# ScioSense AS60xx Embedded Library

Arduino library for AS60xx ultrasonic flow converter sensor family from ScioSense.

<img src="images/AS6031.png" width="400">

The AS60xx sensor family from [ScioSense](https://www.sciosense.com/) offers ultrasonic flow converters for the next generation of ultrasonic water, gas, and heat meters. The sensors come in the size QFN48 package with digital SPI interface. This enables new use cases in single-chip solution provided ready flow information, system design compatible with mechanical meters, high flexibility in choice for external μC handling communication and further data management, precision down to low flow rates and leakage detection.

## Links
* Latest datasheet and application notes are on [ScioSense site](https://www.sciosense.com/ultrasonic-flow-converters/)
* Buy the AS6031 on [Mouser](https://www2.mouser.com/ProductDetail/ScioSense/AS6031-BQFM?qs=DPoM0jnrROWSi1b8OH79RQ%3D%3D) or [Digikey](https://www.digikey.com/en/products/detail/sciosense/as6031-bqfm/17282629)
* Buy the AS6031F1 on [Mouser](https://www.mouser.com/ProductDetail/ScioSense/AS6031F1-BQFM?qs=Rp5uXu7WBW%2FW%2FA74%2Fu76VQ%3D%3D) or [Digikey](https://www.digikey.com/en/products/detail/sciosense/AS6031F1-BQFM/17282627)
* Buy the AS6040 on [Mouser](https://www2.mouser.com/ProductDetail/ScioSense/AS6040-BQFM?qs=DPoM0jnrROWLsLNoAXnDuQ%3D%3D) or [Digikey](https://www.digikey.com/en/products/detail/sciosense/AS6040-BQFM/17282632)
* Buy the AS6031 ST evaluation kit on [Mouser](https://www2.mouser.com/ProductDetail/ScioSense/AS6031_ST_NS-V1.0?qs=DRkmTr78QAQPNfU21SQXMg%3D%3D)
* Buy the AS6040 ST evaluation kit on [Mouser](https:///www2.mouser.com/ProductDetail/ScioSense/AS6040_ST_NS-V1.0?qs=DRkmTr78QATH6T6ez%2F%252BIaw%3D%3D)
* [Further information about the AS6031](https://www.sciosense.com/as6031f1-ultrasonic-flow-converter/) 
* [Further information about the AS6040](https://www.sciosense.com/as6040-ultrasonic-flow-converter/) 
 
## Prerequisites
It is assumed that
 - The Arduino IDE has been installed.
   If not, refer to "Install the Arduino Desktop IDE" on the
   [Arduino site](https://www.arduino.cc/en/Guide/HomePage).
- The library directory is at its default location. Normally this is `C:\Users\[your_username]\Documents\Arduino\libraries`.

## Installation

### Installation via Arduino Library Manager (coming soon)
- In the Arduino IDE, navigate to the Arduino Library Manager on the left side (or, alternatively, select Sketch > 
Include Library > Manage Libraries...)
- Search for `ScioSense_AS60XX`
- Select the library from the search results and press `Install`

### Manual installation
- Download the code from this repository via "Download ZIP".
- In Arduino IDE, select Sketch > Include Library > Add .ZIP library... and browse to the just downloaded ZIP file.
- When the IDE is ready this README.md should be located at `C:\Users\[your_username]\Documents\Arduino\libraries\ScioSense_AS60XX\README.md`.

## Wiring

### General
Please make sure that you use the correct supply voltage: The AS60xx sensors run at VDD = 3.3V, but the ST Nucleo Shields are prepared to work with a supply voltage of 5V. The connections for the ultrasound transducer and temperature sensors can be found at the [UFC ST Nucleo Shields - Expansion Boards User Guide](https://www.sciosense.com/wp-content/uploads/2023/12/UFC-ST-Nucleo-Shields-Expansion-Boards-User-Guide.pdf). The 02_Ultrasound_and_Temperature example is prepared to measure two PT1000 sensors.

### Example with ESP32
This example shows how to wire an ESP32 with a AS60xx ST Nucleo Shields to communicate through SPI.

|  AS60xx_ST  | ESP32 |
|:-----------:|:-----:|
|     VCC     |  5V   |
|     GND     |  GND  |
|      -      |  -    |
|      -      |  -    |
|     SSN     |  5    |
|     MOSI    |  23   |
|     SCK     |  18   |
|     MISO    |  19   |
|     INTN    |  2    |

<img src="images/AS60XX_ESP32.png" width="1000">

## Build an example
To build an example sketch
 - (Re)start Arduino.
 - Open File > Examples > Examples from Custom Libraries > ScioSense_AS60XX > 01_Basic_Ultrasound (or any other of the provided 
examples you wish to run)
 - Make sure Tools > Board lists the correct board.
 - Select Sketch > Verify/Compile.

## Contributing
Contributions in the form of issue opening or creating pull requests are very welcome!

### ScioSense is a Joint Venture of ams AG 
