#include "wav_decoder.h"

// —————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
bool WavDecoder::init() {
    m_valid = true;
    return true;
}
// —————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
void WavDecoder::clear() {
    return;
}
// —————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
void WavDecoder::reset() {
    m_valid = false;
}
// —————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
bool WavDecoder::isValid() {
    return m_valid;
}
// —————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
int32_t WavDecoder::findSyncWord(uint8_t* buf, int32_t nBytes) {
    return 0;
}
// —————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
uint8_t WavDecoder::getChannels() {
    return m_channels;
}
// —————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
uint32_t WavDecoder::getSampleRate() {
    return m_sampleRate;
}
// —————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
uint32_t WavDecoder::getOutputSamples() {
    return m_validSamples;
}
// —————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
uint8_t WavDecoder::getBitsPerSample() {
    return m_bps;
}
// —————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
uint32_t WavDecoder::getBitRate() {
    return 0;
}
// —————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
uint32_t WavDecoder::getAudioDataStart() {
    return 0;
}
// —————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
uint32_t WavDecoder::getAudioFileDuration() {
    return 0;
}
// —————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
const char* WavDecoder::getStreamTitle() {
    return "";
}
// —————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
const char* WavDecoder::whoIsIt() {
    return "WAV";
}
// —————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
int32_t WavDecoder::decode(uint8_t* inbuf, int32_t* bytesLeft, int32_t* outbuf) {

    uint16_t       frame = *bytesLeft;
    const uint8_t* p = inbuf;

    // ------------ 8-BIT PCM unsigned ------------
    if (m_bps == 8) {
        if (frame > 4096) frame = 4096;
        if (getChannels() == 1) {
            // MONO
            for (int i = 0; i < frame / 2; i++) {
                uint8_t p0 = p[0];
                uint8_t p1 = p[1];
                outbuf[i] = (static_cast<int16_t>(p0) - 128) << 24;
                outbuf[i] |= 0x0000FFFF & ((static_cast<int16_t>(p1) - 128) << 8);
                p += 2;
            }
            m_validSamples = frame;
            *bytesLeft -= frame;
        } else if (getChannels() == 2) {
            // STEREO (interleaved L/R)
            for (int i = 0; i < frame / 2; i++) {
                uint8_t l = p[0];
                uint8_t r = p[1];
                outbuf[i] = ((static_cast<int16_t>(l) - 128) << 24);
                outbuf[i] |= 0x0000FFFF & ((static_cast<int16_t>(r) - 128) << 8);
                p += 2;
            }
            m_validSamples = (frame / 2);
            *bytesLeft -= frame;
        }
        return 0;
    }
    // ------------ 16-BIT PCM ------------
    if (m_bps == 16) {
        if (frame > 4096) frame = 4096;
        for (int i = 0; i < frame / 4; i++) {
            outbuf[i] = (p[3] << 24) | (p[2] << 16) | (p[1] << 8) | (p[0]);
            p += 4;
        }

        m_validSamples = frame / (2 * getChannels());
    //    log_w("decode1 m_validSamples %i", m_validSamples);
        *bytesLeft -= frame;
        return 0;
    }
    // ------------ 24-BIT PCM ------------
    if (m_bps == 24) {
        if (frame > 3072) frame = 3072;
        for (int i = 0; i < frame / 3; i++) {
            outbuf[i] = (p[2] << 24) | (p[1] << 16) | (p[0] << 8) | (0x00);
            p += 3;
        }

        m_validSamples = (frame / 3) / getChannels();
    //    log_w("decode1 m_validSamples %i", m_validSamples);
        *bytesLeft -= frame;
        return 0;
    }
    // ------------ 32-BIT PCM ------------
    if (m_bps == 32) {
        if (frame > 3072) frame = 3072;
        for (int i = 0; i < frame / 4; i++) {
            outbuf[i] = (p[3] << 24) | (p[2] << 16) | (p[1] << 8) | (p[0]);
            p += 4;
        }

        m_validSamples = (frame / 4) / getChannels();
    //    log_w("decode1 m_validSamples %i", m_validSamples);
        *bytesLeft -= frame;
        return 0;
    }
    return -1;
}
// —————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
void WavDecoder::setRawBlockParams(uint8_t channels, uint32_t sampleRate, uint8_t BPS, uint32_t tsis, uint32_t AuDaLength) {
    m_channels = channels;
    m_sampleRate = sampleRate;
    m_bps = BPS;
    return;
}
// —————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
std::vector<uint32_t> WavDecoder::getMetadataBlockPicture() {
    std::vector<uint32_t> res = {};
    return res;
}
// —————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
const char* WavDecoder::arg1() {
    return "";
}
// —————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
const char* WavDecoder::arg2() {
    return "";
}
// —————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
int32_t WavDecoder::val1() {
    return 0;
}
// —————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
int32_t WavDecoder::val2() {
    return 0;
}
// —————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
