#pragma once
#pragma GCC diagnostic ignored "-Wunused-variable"
#include "defines.h"
#include "settings.h"
#include "structs.h"

// ——————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
static const uint8_t tabFlipbits[256] = {0, 128, 64, 192, 32, 160, 96,  224, 16, 144, 80, 208, 48, 176, 112, 240, 8,  136, 72, 200, 40, 168, 104, 232, 24, 152, 88, 216, 56, 184, 120, 248,
                                         4, 132, 68, 196, 36, 164, 100, 228, 20, 148, 84, 212, 52, 180, 116, 244, 12, 140, 76, 204, 44, 172, 108, 236, 28, 156, 92, 220, 60, 188, 124, 252,
                                         2, 130, 66, 194, 34, 162, 98,  226, 18, 146, 82, 210, 50, 178, 114, 242, 10, 138, 74, 202, 42, 170, 106, 234, 26, 154, 90, 218, 58, 186, 122, 250,
                                         6, 134, 70, 198, 38, 166, 102, 230, 22, 150, 86, 214, 54, 182, 118, 246, 14, 142, 78, 206, 46, 174, 110, 238, 30, 158, 94, 222, 62, 190, 126, 254,
                                         1, 129, 65, 193, 33, 161, 97,  225, 17, 145, 81, 209, 49, 177, 113, 241, 9,  137, 73, 201, 41, 169, 105, 233, 25, 153, 89, 217, 57, 185, 121, 249,
                                         5, 133, 69, 197, 37, 165, 101, 229, 21, 149, 85, 213, 53, 181, 117, 245, 13, 141, 77, 205, 45, 173, 109, 237, 29, 157, 93, 221, 61, 189, 125, 253,
                                         3, 131, 67, 195, 35, 163, 99,  227, 19, 147, 83, 211, 51, 179, 115, 243, 11, 139, 75, 203, 43, 171, 107, 235, 27, 155, 91, 219, 59, 187, 123, 251,
                                         7, 135, 71, 199, 39, 167, 103, 231, 23, 151, 87, 215, 55, 183, 119, 247, 15, 143, 79, 207, 47, 175, 111, 239, 31, 159, 95, 223, 63, 191, 127, 255};
// ——————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
/* CRC lookup table for G8 polynome in DRM standard */
static const uint8_t crc_table_G8[256] = {
    0x0,  0x1d, 0x3a, 0x27, 0x74, 0x69, 0x4e, 0x53, 0xe8, 0xf5, 0xd2, 0xcf, 0x9c, 0x81, 0xa6, 0xbb, 0xcd, 0xd0, 0xf7, 0xea, 0xb9, 0xa4, 0x83, 0x9e, 0x25, 0x38, 0x1f, 0x2,  0x51, 0x4c, 0x6b, 0x76,
    0x87, 0x9a, 0xbd, 0xa0, 0xf3, 0xee, 0xc9, 0xd4, 0x6f, 0x72, 0x55, 0x48, 0x1b, 0x6,  0x21, 0x3c, 0x4a, 0x57, 0x70, 0x6d, 0x3e, 0x23, 0x4,  0x19, 0xa2, 0xbf, 0x98, 0x85, 0xd6, 0xcb, 0xec, 0xf1,
    0x13, 0xe,  0x29, 0x34, 0x67, 0x7a, 0x5d, 0x40, 0xfb, 0xe6, 0xc1, 0xdc, 0x8f, 0x92, 0xb5, 0xa8, 0xde, 0xc3, 0xe4, 0xf9, 0xaa, 0xb7, 0x90, 0x8d, 0x36, 0x2b, 0xc,  0x11, 0x42, 0x5f, 0x78, 0x65,
    0x94, 0x89, 0xae, 0xb3, 0xe0, 0xfd, 0xda, 0xc7, 0x7c, 0x61, 0x46, 0x5b, 0x8,  0x15, 0x32, 0x2f, 0x59, 0x44, 0x63, 0x7e, 0x2d, 0x30, 0x17, 0xa,  0xb1, 0xac, 0x8b, 0x96, 0xc5, 0xd8, 0xff, 0xe2,
    0x26, 0x3b, 0x1c, 0x1,  0x52, 0x4f, 0x68, 0x75, 0xce, 0xd3, 0xf4, 0xe9, 0xba, 0xa7, 0x80, 0x9d, 0xeb, 0xf6, 0xd1, 0xcc, 0x9f, 0x82, 0xa5, 0xb8, 0x3,  0x1e, 0x39, 0x24, 0x77, 0x6a, 0x4d, 0x50,
    0xa1, 0xbc, 0x9b, 0x86, 0xd5, 0xc8, 0xef, 0xf2, 0x49, 0x54, 0x73, 0x6e, 0x3d, 0x20, 0x7,  0x1a, 0x6c, 0x71, 0x56, 0x4b, 0x18, 0x5,  0x22, 0x3f, 0x84, 0x99, 0xbe, 0xa3, 0xf0, 0xed, 0xca, 0xd7,
    0x35, 0x28, 0xf,  0x12, 0x41, 0x5c, 0x7b, 0x66, 0xdd, 0xc0, 0xe7, 0xfa, 0xa9, 0xb4, 0x93, 0x8e, 0xf8, 0xe5, 0xc2, 0xdf, 0x8c, 0x91, 0xb6, 0xab, 0x10, 0xd,  0x2a, 0x37, 0x64, 0x79, 0x5e, 0x43,
    0xb2, 0xaf, 0x88, 0x95, 0xc6, 0xdb, 0xfc, 0xe1, 0x5a, 0x47, 0x60, 0x7d, 0x2e, 0x33, 0x14, 0x9,  0x7f, 0x62, 0x45, 0x58, 0xb,  0x16, 0x31, 0x2c, 0x97, 0x8a, 0xad, 0xb0, 0xe3, 0xfe, 0xd9, 0xc4,
};
// ——————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
static const uint8_t mes[] = {0x67, 0x20, 0x61, 0x20, 0x20, 0x20, 0x6f, 0x20, 0x72, 0x20, 0x65, 0x20, 0x6e, 0x20, 0x20, 0x20, 0x74,
                              0x20, 0x68, 0x20, 0x67, 0x20, 0x69, 0x20, 0x72, 0x20, 0x79, 0x20, 0x70, 0x20, 0x6f, 0x20, 0x63};
// ——————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
static const uint8_t Parity[256] = { // parity
    0, 1, 1, 0, 1, 0, 0, 1, 1, 0, 0, 1, 0, 1, 1, 0, 1, 0, 0, 1, 0, 1, 1, 0, 0, 1, 1, 0, 1, 0, 0, 1, 1, 0, 0, 1, 0, 1, 1, 0, 0, 1, 1, 0, 1, 0, 0, 1, 0, 1, 1, 0, 1, 0, 0, 1, 1, 0, 0, 1, 0, 1, 1, 0,
    1, 0, 0, 1, 0, 1, 1, 0, 0, 1, 1, 0, 1, 0, 0, 1, 0, 1, 1, 0, 1, 0, 0, 1, 1, 0, 0, 1, 0, 1, 1, 0, 0, 1, 1, 0, 1, 0, 0, 1, 1, 0, 0, 1, 0, 1, 1, 0, 1, 0, 0, 1, 0, 1, 1, 0, 0, 1, 1, 0, 1, 0, 0, 1,
    1, 0, 0, 1, 0, 1, 1, 0, 0, 1, 1, 0, 1, 0, 0, 1, 0, 1, 1, 0, 1, 0, 0, 1, 1, 0, 0, 1, 0, 1, 1, 0, 0, 1, 1, 0, 1, 0, 0, 1, 1, 0, 0, 1, 0, 1, 1, 0, 1, 0, 0, 1, 0, 1, 1, 0, 0, 1, 1, 0, 1, 0, 0, 1,
    0, 1, 1, 0, 1, 0, 0, 1, 1, 0, 0, 1, 0, 1, 1, 0, 1, 0, 0, 1, 0, 1, 1, 0, 0, 1, 1, 0, 1, 0, 0, 1, 1, 0, 0, 1, 0, 1, 1, 0, 0, 1, 1, 0, 1, 0, 0, 1, 0, 1, 1, 0, 1, 0, 0, 1, 1, 0, 0, 1, 0, 1, 1, 0};
/*
 *  This is a simple random number generator with good quality for audio purposes.
 *  It consists of two polycounters with opposite rotation direction and different
 *  periods. The periods are coprime, so the total period is the product of both.
 *
 *     -------------------------------------------------------------------------------------------------
 * +-> |31:30:29:28:27:26:25:24:23:22:21:20:19:18:17:16:15:14:13:12:11:10: 9: 8: 7: 6: 5: 4: 3: 2: 1: 0|
 * |   -------------------------------------------------------------------------------------------------
 * |                                                                          |  |  |  |     |        |
 * |                                                                          +--+--+--+-XOR-+--------+
 * |                                                                                      |
 * +--------------------------------------------------------------------------------------+
 *
 *     -------------------------------------------------------------------------------------------------
 *     |31:30:29:28:27:26:25:24:23:22:21:20:19:18:17:16:15:14:13:12:11:10: 9: 8: 7: 6: 5: 4: 3: 2: 1: 0| <-+
 *     -------------------------------------------------------------------------------------------------   |
 *       |  |           |  |                                                                               |
 *       +--+----XOR----+--+                                                                               |
 *                |                                                                                        |
 *                +----------------------------------------------------------------------------------------+
 *
 *
 *  The first has an period of 3*5*17*257*65537, the second of 7*47*73*178481,
 *  which gives a period of 18.410.713.077.675.721.215. The result is the
 *  XORed values of both generators.
 */
// ——————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
static const char* err_msg[] = {"No error",
                                "Gain control not yet implemented",
                                "Pulse coding not allowed in short blocks",
                                "Invalid huffman codebook",
                                "Scalefactor out of range",
                                "Unable to find ADTS syncword",
                                "Channel coupling not yet implemented",
                                "Channel configuration not allowed in error resilient frame",
                                "Bit error in error resilient scalefactor decoding",
                                "Error decoding huffman scalefactor (bitstream error)",
                                "Error decoding huffman codeword (bitstream error)",
                                "Non existent huffman codebook number found",
                                "Invalid number of channels",
                                "Maximum number of bitstream elements exceeded",
                                "Input data buffer too small",
                                "Array index out of range",
                                "Maximum number of scalefactor bands exceeded",
                                "Quantised value out of range",
                                "LTP lag out of range",
                                "Invalid SBR parameter decoded",
                                "SBR called without being initialised",
                                "Unexpected channel configuration change",
                                "Error in program_config_element",
                                "First SBR frame is not the same as first AAC frame",
                                "Unexpected fill element with SBR data",
                                "Not all elements were provided with SBR data",
                                "LTP decoding not available",
                                "Output data buffer too small",
                                "CRC error in DRM data",
                                "PNS not allowed in DRM data stream",
                                "No standard extension payload allowed in DRM",
                                "PCE shall be the first element in a frame",
                                "Bitstream value not allowed by specification",
                                "MAIN prediction not initialised"};
// ——————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
#ifdef FIXED_POINT
    #define TABLE_BITS 6
    /* just take the maximum number of bits for interpolation */
    #define INTERP_BITS (REAL_BITS - TABLE_BITS)
static const real_t pow2_tab[] = {
    REAL_CONST(1.000000000000000), REAL_CONST(1.010889286051701), REAL_CONST(1.021897148654117), REAL_CONST(1.033024879021228), REAL_CONST(1.044273782427414), REAL_CONST(1.055645178360557),
    REAL_CONST(1.067140400676824), REAL_CONST(1.078760797757120), REAL_CONST(1.090507732665258), REAL_CONST(1.102382583307841), REAL_CONST(1.114386742595892), REAL_CONST(1.126521618608242),
    REAL_CONST(1.138788634756692), REAL_CONST(1.151189229952983), REAL_CONST(1.163724858777578), REAL_CONST(1.176396991650281), REAL_CONST(1.189207115002721), REAL_CONST(1.202156731452703),
    REAL_CONST(1.215247359980469), REAL_CONST(1.228480536106870), REAL_CONST(1.241857812073484), REAL_CONST(1.255380757024691), REAL_CONST(1.269050957191733), REAL_CONST(1.282870016078778),
    REAL_CONST(1.296839554651010), REAL_CONST(1.310961211524764), REAL_CONST(1.325236643159741), REAL_CONST(1.339667524053303), REAL_CONST(1.354255546936893), REAL_CONST(1.369002422974591),
    REAL_CONST(1.383909881963832), REAL_CONST(1.398979672538311), REAL_CONST(1.414213562373095), REAL_CONST(1.429613338391970), REAL_CONST(1.445180806977047), REAL_CONST(1.460917794180647),
    REAL_CONST(1.476826145939499), REAL_CONST(1.492907728291265), REAL_CONST(1.509164427593423), REAL_CONST(1.525598150744538), REAL_CONST(1.542210825407941), REAL_CONST(1.559004400237837),
    REAL_CONST(1.575980845107887), REAL_CONST(1.593142151342267), REAL_CONST(1.610490331949254), REAL_CONST(1.628027421857348), REAL_CONST(1.645755478153965), REAL_CONST(1.663676580326736),
    REAL_CONST(1.681792830507429), REAL_CONST(1.700106353718524), REAL_CONST(1.718619298122478), REAL_CONST(1.737333835273706), REAL_CONST(1.756252160373300), REAL_CONST(1.775376492526521),
    REAL_CONST(1.794709075003107), REAL_CONST(1.814252175500399), REAL_CONST(1.834008086409342), REAL_CONST(1.853979125083386), REAL_CONST(1.874167634110300), REAL_CONST(1.894575981586966),
    REAL_CONST(1.915206561397147), REAL_CONST(1.936061793492294), REAL_CONST(1.957144124175400), REAL_CONST(1.978456026387951), REAL_CONST(2.000000000000000)};
static const real_t log2_tab[] = {
    REAL_CONST(0.000000000000000), REAL_CONST(0.022367813028455), REAL_CONST(0.044394119358453), REAL_CONST(0.066089190457772), REAL_CONST(0.087462841250339), REAL_CONST(0.108524456778169),
    REAL_CONST(0.129283016944966), REAL_CONST(0.149747119504682), REAL_CONST(0.169925001442312), REAL_CONST(0.189824558880017), REAL_CONST(0.209453365628950), REAL_CONST(0.228818690495881),
    REAL_CONST(0.247927513443585), REAL_CONST(0.266786540694901), REAL_CONST(0.285402218862248), REAL_CONST(0.303780748177103), REAL_CONST(0.321928094887362), REAL_CONST(0.339850002884625),
    REAL_CONST(0.357552004618084), REAL_CONST(0.375039431346925), REAL_CONST(0.392317422778760), REAL_CONST(0.409390936137702), REAL_CONST(0.426264754702098), REAL_CONST(0.442943495848728),
    REAL_CONST(0.459431618637297), REAL_CONST(0.475733430966398), REAL_CONST(0.491853096329675), REAL_CONST(0.507794640198696), REAL_CONST(0.523561956057013), REAL_CONST(0.539158811108031),
    REAL_CONST(0.554588851677637), REAL_CONST(0.569855608330948), REAL_CONST(0.584962500721156), REAL_CONST(0.599912842187128), REAL_CONST(0.614709844115208), REAL_CONST(0.629356620079610),
    REAL_CONST(0.643856189774725), REAL_CONST(0.658211482751795), REAL_CONST(0.672425341971496), REAL_CONST(0.686500527183218), REAL_CONST(0.700439718141092), REAL_CONST(0.714245517666123),
    REAL_CONST(0.727920454563199), REAL_CONST(0.741466986401147), REAL_CONST(0.754887502163469), REAL_CONST(0.768184324776926), REAL_CONST(0.781359713524660), REAL_CONST(0.794415866350106),
    REAL_CONST(0.807354922057604), REAL_CONST(0.820178962415188), REAL_CONST(0.832890014164742), REAL_CONST(0.845490050944375), REAL_CONST(0.857980995127572), REAL_CONST(0.870364719583405),
    REAL_CONST(0.882643049361841), REAL_CONST(0.894817763307943), REAL_CONST(0.906890595608519), REAL_CONST(0.918863237274595), REAL_CONST(0.930737337562886), REAL_CONST(0.942514505339240),
    REAL_CONST(0.954196310386875), REAL_CONST(0.965784284662087), REAL_CONST(0.977279923499917), REAL_CONST(0.988684686772166), REAL_CONST(1.000000000000000)};
#endif
// ——————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
#ifdef FIXED_POINT
static const complex_t cfft_tab_512[] = {{FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000)},   {FRAC_CONST(0.999924719333649), FRAC_CONST(0.012271538376808)},
                                         {FRAC_CONST(0.999698817729950), FRAC_CONST(0.024541229009628)},   {FRAC_CONST(0.999322354793549), FRAC_CONST(0.036807224154472)},
                                         {FRAC_CONST(0.998795449733734), FRAC_CONST(0.049067676067352)},   {FRAC_CONST(0.998118102550507), FRAC_CONST(0.061320740729570)},
                                         {FRAC_CONST(0.997290432453156), FRAC_CONST(0.073564566671848)},   {FRAC_CONST(0.996312618255615), FRAC_CONST(0.085797317326069)},
                                         {FRAC_CONST(0.995184719562531), FRAC_CONST(0.098017141222954)},   {FRAC_CONST(0.993906974792480), FRAC_CONST(0.110222205519676)},
                                         {FRAC_CONST(0.992479562759399), FRAC_CONST(0.122410677373409)},   {FRAC_CONST(0.990902662277222), FRAC_CONST(0.134580716490746)},
                                         {FRAC_CONST(0.989176511764526), FRAC_CONST(0.146730467677116)},   {FRAC_CONST(0.987301409244537), FRAC_CONST(0.158858150243759)},
                                         {FRAC_CONST(0.985277652740479), FRAC_CONST(0.170961901545525)},   {FRAC_CONST(0.983105480670929), FRAC_CONST(0.183039888739586)},
                                         {FRAC_CONST(0.980785250663757), FRAC_CONST(0.195090323686600)},   {FRAC_CONST(0.978317379951477), FRAC_CONST(0.207111388444901)},
                                         {FRAC_CONST(0.975702106952667), FRAC_CONST(0.219101235270500)},   {FRAC_CONST(0.972939968109131), FRAC_CONST(0.231058120727539)},
                                         {FRAC_CONST(0.970031261444092), FRAC_CONST(0.242980197072029)},   {FRAC_CONST(0.966976463794708), FRAC_CONST(0.254865676164627)},
                                         {FRAC_CONST(0.963776051998138), FRAC_CONST(0.266712784767151)},   {FRAC_CONST(0.960430502891541), FRAC_CONST(0.278519690036774)},
                                         {FRAC_CONST(0.956940352916718), FRAC_CONST(0.290284663438797)},   {FRAC_CONST(0.953306019306183), FRAC_CONST(0.302005946636200)},
                                         {FRAC_CONST(0.949528157711029), FRAC_CONST(0.313681751489639)},   {FRAC_CONST(0.945607304573059), FRAC_CONST(0.325310319662094)},
                                         {FRAC_CONST(0.941544055938721), FRAC_CONST(0.336889863014221)},   {FRAC_CONST(0.937339007854462), FRAC_CONST(0.348418682813644)},
                                         {FRAC_CONST(0.932992815971375), FRAC_CONST(0.359895050525665)},   {FRAC_CONST(0.928506076335907), FRAC_CONST(0.371317207813263)},
                                         {FRAC_CONST(0.923879504203796), FRAC_CONST(0.382683455944061)},   {FRAC_CONST(0.919113874435425), FRAC_CONST(0.393992066383362)},
                                         {FRAC_CONST(0.914209723472595), FRAC_CONST(0.405241340398788)},   {FRAC_CONST(0.909167945384979), FRAC_CONST(0.416429579257965)},
                                         {FRAC_CONST(0.903989315032959), FRAC_CONST(0.427555084228516)},   {FRAC_CONST(0.898674488067627), FRAC_CONST(0.438616245985031)},
                                         {FRAC_CONST(0.893224298954010), FRAC_CONST(0.449611335992813)},   {FRAC_CONST(0.887639641761780), FRAC_CONST(0.460538715124130)},
                                         {FRAC_CONST(0.881921231746674), FRAC_CONST(0.471396744251251)},   {FRAC_CONST(0.876070082187653), FRAC_CONST(0.482183754444122)},
                                         {FRAC_CONST(0.870086967945099), FRAC_CONST(0.492898225784302)},   {FRAC_CONST(0.863972842693329), FRAC_CONST(0.503538370132446)},
                                         {FRAC_CONST(0.857728600502014), FRAC_CONST(0.514102756977081)},   {FRAC_CONST(0.851355195045471), FRAC_CONST(0.524589717388153)},
                                         {FRAC_CONST(0.844853579998016), FRAC_CONST(0.534997642040253)},   {FRAC_CONST(0.838224709033966), FRAC_CONST(0.545324981212616)},
                                         {FRAC_CONST(0.831469595432281), FRAC_CONST(0.555570244789124)},   {FRAC_CONST(0.824589252471924), FRAC_CONST(0.565731823444366)},
                                         {FRAC_CONST(0.817584812641144), FRAC_CONST(0.575808227062225)},   {FRAC_CONST(0.810457170009613), FRAC_CONST(0.585797905921936)},
                                         {FRAC_CONST(0.803207516670227), FRAC_CONST(0.595699310302734)},   {FRAC_CONST(0.795836925506592), FRAC_CONST(0.605511009693146)},
                                         {FRAC_CONST(0.788346409797668), FRAC_CONST(0.615231633186340)},   {FRAC_CONST(0.780737221240997), FRAC_CONST(0.624859511852264)},
                                         {FRAC_CONST(0.773010432720184), FRAC_CONST(0.634393334388733)},   {FRAC_CONST(0.765167236328125), FRAC_CONST(0.643831551074982)},
                                         {FRAC_CONST(0.757208824157715), FRAC_CONST(0.653172850608826)},   {FRAC_CONST(0.749136388301849), FRAC_CONST(0.662415802478790)},
                                         {FRAC_CONST(0.740951120853424), FRAC_CONST(0.671558976173401)},   {FRAC_CONST(0.732654273509979), FRAC_CONST(0.680601000785828)},
                                         {FRAC_CONST(0.724247097969055), FRAC_CONST(0.689540565013886)},   {FRAC_CONST(0.715730786323547), FRAC_CONST(0.698376297950745)},
                                         {FRAC_CONST(0.707106769084930), FRAC_CONST(0.707106769084930)},   {FRAC_CONST(0.698376238346100), FRAC_CONST(0.715730845928192)},
                                         {FRAC_CONST(0.689540505409241), FRAC_CONST(0.724247097969055)},   {FRAC_CONST(0.680601000785828), FRAC_CONST(0.732654273509979)},
                                         {FRAC_CONST(0.671558916568756), FRAC_CONST(0.740951180458069)},   {FRAC_CONST(0.662415742874146), FRAC_CONST(0.749136388301849)},
                                         {FRAC_CONST(0.653172791004181), FRAC_CONST(0.757208883762360)},   {FRAC_CONST(0.643831551074982), FRAC_CONST(0.765167295932770)},
                                         {FRAC_CONST(0.634393274784088), FRAC_CONST(0.773010432720184)},   {FRAC_CONST(0.624859452247620), FRAC_CONST(0.780737280845642)},
                                         {FRAC_CONST(0.615231573581696), FRAC_CONST(0.788346409797668)},   {FRAC_CONST(0.605511009693146), FRAC_CONST(0.795836925506592)},
                                         {FRAC_CONST(0.595699310302734), FRAC_CONST(0.803207516670227)},   {FRAC_CONST(0.585797846317291), FRAC_CONST(0.810457170009613)},
                                         {FRAC_CONST(0.575808167457581), FRAC_CONST(0.817584812641144)},   {FRAC_CONST(0.565731823444366), FRAC_CONST(0.824589312076569)},
                                         {FRAC_CONST(0.555570185184479), FRAC_CONST(0.831469655036926)},   {FRAC_CONST(0.545324981212616), FRAC_CONST(0.838224709033966)},
                                         {FRAC_CONST(0.534997642040253), FRAC_CONST(0.844853579998016)},   {FRAC_CONST(0.524589657783508), FRAC_CONST(0.851355195045471)},
                                         {FRAC_CONST(0.514102697372437), FRAC_CONST(0.857728660106659)},   {FRAC_CONST(0.503538429737091), FRAC_CONST(0.863972842693329)},
                                         {FRAC_CONST(0.492898195981979), FRAC_CONST(0.870086967945099)},   {FRAC_CONST(0.482183724641800), FRAC_CONST(0.876070141792297)},
                                         {FRAC_CONST(0.471396654844284), FRAC_CONST(0.881921291351318)},   {FRAC_CONST(0.460538715124130), FRAC_CONST(0.887639641761780)},
                                         {FRAC_CONST(0.449611306190491), FRAC_CONST(0.893224298954010)},   {FRAC_CONST(0.438616186380386), FRAC_CONST(0.898674488067627)},
                                         {FRAC_CONST(0.427555114030838), FRAC_CONST(0.903989315032959)},   {FRAC_CONST(0.416429549455643), FRAC_CONST(0.909168004989624)},
                                         {FRAC_CONST(0.405241280794144), FRAC_CONST(0.914209783077240)},   {FRAC_CONST(0.393991947174072), FRAC_CONST(0.919113874435425)},
                                         {FRAC_CONST(0.382683426141739), FRAC_CONST(0.923879504203796)},   {FRAC_CONST(0.371317148208618), FRAC_CONST(0.928506076335907)},
                                         {FRAC_CONST(0.359894961118698), FRAC_CONST(0.932992815971375)},   {FRAC_CONST(0.348418682813644), FRAC_CONST(0.937339007854462)},
                                         {FRAC_CONST(0.336889833211899), FRAC_CONST(0.941544055938721)},   {FRAC_CONST(0.325310230255127), FRAC_CONST(0.945607364177704)},
                                         {FRAC_CONST(0.313681662082672), FRAC_CONST(0.949528217315674)},   {FRAC_CONST(0.302005946636200), FRAC_CONST(0.953306019306183)},
                                         {FRAC_CONST(0.290284633636475), FRAC_CONST(0.956940352916718)},   {FRAC_CONST(0.278519600629807), FRAC_CONST(0.960430562496185)},
                                         {FRAC_CONST(0.266712754964828), FRAC_CONST(0.963776051998138)},   {FRAC_CONST(0.254865646362305), FRAC_CONST(0.966976463794708)},
                                         {FRAC_CONST(0.242980122566223), FRAC_CONST(0.970031261444092)},   {FRAC_CONST(0.231058135628700), FRAC_CONST(0.972939968109131)},
                                         {FRAC_CONST(0.219101220369339), FRAC_CONST(0.975702106952667)},   {FRAC_CONST(0.207111328840256), FRAC_CONST(0.978317379951477)},
                                         {FRAC_CONST(0.195090234279633), FRAC_CONST(0.980785310268402)},   {FRAC_CONST(0.183039888739586), FRAC_CONST(0.983105480670929)},
                                         {FRAC_CONST(0.170961856842041), FRAC_CONST(0.985277652740479)},   {FRAC_CONST(0.158858075737953), FRAC_CONST(0.987301409244537)},
                                         {FRAC_CONST(0.146730497479439), FRAC_CONST(0.989176511764526)},   {FRAC_CONST(0.134580686688423), FRAC_CONST(0.990902662277222)},
                                         {FRAC_CONST(0.122410625219345), FRAC_CONST(0.992479562759399)},   {FRAC_CONST(0.110222116112709), FRAC_CONST(0.993906974792480)},
                                         {FRAC_CONST(0.098017133772373), FRAC_CONST(0.995184719562531)},   {FRAC_CONST(0.085797272622585), FRAC_CONST(0.996312618255615)},
                                         {FRAC_CONST(0.073564492166042), FRAC_CONST(0.997290432453156)},   {FRAC_CONST(0.061320748180151), FRAC_CONST(0.998118102550507)},
                                         {FRAC_CONST(0.049067649990320), FRAC_CONST(0.998795449733734)},   {FRAC_CONST(0.036807164549828), FRAC_CONST(0.999322414398193)},
                                         {FRAC_CONST(0.024541135877371), FRAC_CONST(0.999698817729950)},   {FRAC_CONST(0.012271529063582), FRAC_CONST(0.999924719333649)},
                                         {FRAC_CONST(-0.000000043711388), FRAC_CONST(1.000000000000000)},  {FRAC_CONST(-0.012271616607904), FRAC_CONST(0.999924719333649)},
                                         {FRAC_CONST(-0.024541223421693), FRAC_CONST(0.999698817729950)},  {FRAC_CONST(-0.036807250231504), FRAC_CONST(0.999322354793549)},
                                         {FRAC_CONST(-0.049067739397287), FRAC_CONST(0.998795449733734)},  {FRAC_CONST(-0.061320833861828), FRAC_CONST(0.998118102550507)},
                                         {FRAC_CONST(-0.073564574122429), FRAC_CONST(0.997290432453156)},  {FRAC_CONST(-0.085797362029552), FRAC_CONST(0.996312618255615)},
                                         {FRAC_CONST(-0.098017223179340), FRAC_CONST(0.995184719562531)},  {FRAC_CONST(-0.110222205519676), FRAC_CONST(0.993906974792480)},
                                         {FRAC_CONST(-0.122410707175732), FRAC_CONST(0.992479503154755)},  {FRAC_CONST(-0.134580776095390), FRAC_CONST(0.990902602672577)},
                                         {FRAC_CONST(-0.146730571985245), FRAC_CONST(0.989176511764526)},  {FRAC_CONST(-0.158858165144920), FRAC_CONST(0.987301409244537)},
                                         {FRAC_CONST(-0.170961946249008), FRAC_CONST(0.985277652740479)},  {FRAC_CONST(-0.183039978146553), FRAC_CONST(0.983105480670929)},
                                         {FRAC_CONST(-0.195090323686600), FRAC_CONST(0.980785250663757)},  {FRAC_CONST(-0.207111418247223), FRAC_CONST(0.978317379951477)},
                                         {FRAC_CONST(-0.219101309776306), FRAC_CONST(0.975702106952667)},  {FRAC_CONST(-0.231058210134506), FRAC_CONST(0.972939908504486)},
                                         {FRAC_CONST(-0.242980197072029), FRAC_CONST(0.970031261444092)},  {FRAC_CONST(-0.254865705966949), FRAC_CONST(0.966976463794708)},
                                         {FRAC_CONST(-0.266712844371796), FRAC_CONST(0.963776051998138)},  {FRAC_CONST(-0.278519690036774), FRAC_CONST(0.960430502891541)},
                                         {FRAC_CONST(-0.290284723043442), FRAC_CONST(0.956940293312073)},  {FRAC_CONST(-0.302006036043167), FRAC_CONST(0.953306019306183)},
                                         {FRAC_CONST(-0.313681721687317), FRAC_CONST(0.949528157711029)},  {FRAC_CONST(-0.325310319662094), FRAC_CONST(0.945607304573059)},
                                         {FRAC_CONST(-0.336889922618866), FRAC_CONST(0.941544055938721)},  {FRAC_CONST(-0.348418772220612), FRAC_CONST(0.937338948249817)},
                                         {FRAC_CONST(-0.359895050525665), FRAC_CONST(0.932992815971375)},  {FRAC_CONST(-0.371317237615585), FRAC_CONST(0.928506076335907)},
                                         {FRAC_CONST(-0.382683515548706), FRAC_CONST(0.923879504203796)},  {FRAC_CONST(-0.393992036581039), FRAC_CONST(0.919113874435425)},
                                         {FRAC_CONST(-0.405241340398788), FRAC_CONST(0.914209723472595)},  {FRAC_CONST(-0.416429519653320), FRAC_CONST(0.909168004989624)},
                                         {FRAC_CONST(-0.427555084228516), FRAC_CONST(0.903989315032959)},  {FRAC_CONST(-0.438616245985031), FRAC_CONST(0.898674428462982)},
                                         {FRAC_CONST(-0.449611365795136), FRAC_CONST(0.893224298954010)},  {FRAC_CONST(-0.460538804531097), FRAC_CONST(0.887639582157135)},
                                         {FRAC_CONST(-0.471396833658218), FRAC_CONST(0.881921231746674)},  {FRAC_CONST(-0.482183903455734), FRAC_CONST(0.876070022583008)},
                                         {FRAC_CONST(-0.492898166179657), FRAC_CONST(0.870087027549744)},  {FRAC_CONST(-0.503538370132446), FRAC_CONST(0.863972842693329)},
                                         {FRAC_CONST(-0.514102756977081), FRAC_CONST(0.857728600502014)},  {FRAC_CONST(-0.524589717388153), FRAC_CONST(0.851355135440826)},
                                         {FRAC_CONST(-0.534997701644897), FRAC_CONST(0.844853520393372)},  {FRAC_CONST(-0.545325100421906), FRAC_CONST(0.838224649429321)},
                                         {FRAC_CONST(-0.555570363998413), FRAC_CONST(0.831469535827637)},  {FRAC_CONST(-0.565731763839722), FRAC_CONST(0.824589312076569)},
                                         {FRAC_CONST(-0.575808167457581), FRAC_CONST(0.817584812641144)},  {FRAC_CONST(-0.585797905921936), FRAC_CONST(0.810457170009613)},
                                         {FRAC_CONST(-0.595699369907379), FRAC_CONST(0.803207516670227)},  {FRAC_CONST(-0.605511128902435), FRAC_CONST(0.795836865901947)},
                                         {FRAC_CONST(-0.615231692790985), FRAC_CONST(0.788346350193024)},  {FRAC_CONST(-0.624859631061554), FRAC_CONST(0.780737102031708)},
                                         {FRAC_CONST(-0.634393274784088), FRAC_CONST(0.773010492324829)},  {FRAC_CONST(-0.643831551074982), FRAC_CONST(0.765167236328125)},
                                         {FRAC_CONST(-0.653172850608826), FRAC_CONST(0.757208824157715)},  {FRAC_CONST(-0.662415802478790), FRAC_CONST(0.749136328697205)},
                                         {FRAC_CONST(-0.671559035778046), FRAC_CONST(0.740951061248779)},  {FRAC_CONST(-0.680601119995117), FRAC_CONST(0.732654154300690)},
                                         {FRAC_CONST(-0.689540684223175), FRAC_CONST(0.724246978759766)},  {FRAC_CONST(-0.698376238346100), FRAC_CONST(0.715730845928192)},
                                         {FRAC_CONST(-0.707106769084930), FRAC_CONST(0.707106769084930)},  {FRAC_CONST(-0.715730845928192), FRAC_CONST(0.698376238346100)},
                                         {FRAC_CONST(-0.724247157573700), FRAC_CONST(0.689540505409241)},  {FRAC_CONST(-0.732654333114624), FRAC_CONST(0.680600941181183)},
                                         {FRAC_CONST(-0.740951240062714), FRAC_CONST(0.671558856964111)},  {FRAC_CONST(-0.749136507511139), FRAC_CONST(0.662415623664856)},
                                         {FRAC_CONST(-0.757208824157715), FRAC_CONST(0.653172850608826)},  {FRAC_CONST(-0.765167295932770), FRAC_CONST(0.643831551074982)},
                                         {FRAC_CONST(-0.773010492324829), FRAC_CONST(0.634393274784088)},  {FRAC_CONST(-0.780737280845642), FRAC_CONST(0.624859452247620)},
                                         {FRAC_CONST(-0.788346469402313), FRAC_CONST(0.615231513977051)},  {FRAC_CONST(-0.795836985111237), FRAC_CONST(0.605510950088501)},
                                         {FRAC_CONST(-0.803207635879517), FRAC_CONST(0.595699131488800)},  {FRAC_CONST(-0.810457170009613), FRAC_CONST(0.585797846317291)},
                                         {FRAC_CONST(-0.817584812641144), FRAC_CONST(0.575808167457581)},  {FRAC_CONST(-0.824589312076569), FRAC_CONST(0.565731763839722)},
                                         {FRAC_CONST(-0.831469655036926), FRAC_CONST(0.555570185184479)},  {FRAC_CONST(-0.838224768638611), FRAC_CONST(0.545324862003326)},
                                         {FRAC_CONST(-0.844853639602661), FRAC_CONST(0.534997463226318)},  {FRAC_CONST(-0.851355314254761), FRAC_CONST(0.524589538574219)},
                                         {FRAC_CONST(-0.857728600502014), FRAC_CONST(0.514102756977081)},  {FRAC_CONST(-0.863972842693329), FRAC_CONST(0.503538370132446)},
                                         {FRAC_CONST(-0.870087027549744), FRAC_CONST(0.492898136377335)},  {FRAC_CONST(-0.876070141792297), FRAC_CONST(0.482183694839478)},
                                         {FRAC_CONST(-0.881921350955963), FRAC_CONST(0.471396625041962)},  {FRAC_CONST(-0.887639701366425), FRAC_CONST(0.460538566112518)},
                                         {FRAC_CONST(-0.893224298954010), FRAC_CONST(0.449611365795136)},  {FRAC_CONST(-0.898674488067627), FRAC_CONST(0.438616245985031)},
                                         {FRAC_CONST(-0.903989315032959), FRAC_CONST(0.427555054426193)},  {FRAC_CONST(-0.909168004989624), FRAC_CONST(0.416429489850998)},
                                         {FRAC_CONST(-0.914209783077240), FRAC_CONST(0.405241221189499)},  {FRAC_CONST(-0.919113874435425), FRAC_CONST(0.393991917371750)},
                                         {FRAC_CONST(-0.923879623413086), FRAC_CONST(0.382683277130127)},  {FRAC_CONST(-0.928506076335907), FRAC_CONST(0.371317237615585)},
                                         {FRAC_CONST(-0.932992815971375), FRAC_CONST(0.359895050525665)},  {FRAC_CONST(-0.937339007854462), FRAC_CONST(0.348418653011322)},
                                         {FRAC_CONST(-0.941544115543365), FRAC_CONST(0.336889803409576)},  {FRAC_CONST(-0.945607364177704), FRAC_CONST(0.325310200452805)},
                                         {FRAC_CONST(-0.949528217315674), FRAC_CONST(0.313681602478027)},  {FRAC_CONST(-0.953306078910828), FRAC_CONST(0.302005797624588)},
                                         {FRAC_CONST(-0.956940352916718), FRAC_CONST(0.290284723043442)},  {FRAC_CONST(-0.960430502891541), FRAC_CONST(0.278519690036774)},
                                         {FRAC_CONST(-0.963776051998138), FRAC_CONST(0.266712725162506)},  {FRAC_CONST(-0.966976463794708), FRAC_CONST(0.254865586757660)},
                                         {FRAC_CONST(-0.970031261444092), FRAC_CONST(0.242980077862740)},  {FRAC_CONST(-0.972939968109131), FRAC_CONST(0.231057971715927)},
                                         {FRAC_CONST(-0.975702166557312), FRAC_CONST(0.219101071357727)},  {FRAC_CONST(-0.978317379951477), FRAC_CONST(0.207111403346062)},
                                         {FRAC_CONST(-0.980785310268402), FRAC_CONST(0.195090308785439)},  {FRAC_CONST(-0.983105480670929), FRAC_CONST(0.183039844036102)},
                                         {FRAC_CONST(-0.985277652740479), FRAC_CONST(0.170961812138557)},  {FRAC_CONST(-0.987301409244537), FRAC_CONST(0.158858031034470)},
                                         {FRAC_CONST(-0.989176511764526), FRAC_CONST(0.146730333566666)},  {FRAC_CONST(-0.990902662277222), FRAC_CONST(0.134580522775650)},
                                         {FRAC_CONST(-0.992479503154755), FRAC_CONST(0.122410699725151)},  {FRAC_CONST(-0.993906974792480), FRAC_CONST(0.110222198069096)},
                                         {FRAC_CONST(-0.995184719562531), FRAC_CONST(0.098017096519470)},  {FRAC_CONST(-0.996312618255615), FRAC_CONST(0.085797227919102)},
                                         {FRAC_CONST(-0.997290492057800), FRAC_CONST(0.073564447462559)},  {FRAC_CONST(-0.998118102550507), FRAC_CONST(0.061320584267378)},
                                         {FRAC_CONST(-0.998795449733734), FRAC_CONST(0.049067486077547)},  {FRAC_CONST(-0.999322354793549), FRAC_CONST(0.036807239055634)},
                                         {FRAC_CONST(-0.999698817729950), FRAC_CONST(0.024541210383177)},  {FRAC_CONST(-0.999924719333649), FRAC_CONST(0.012271485291421)},
                                         {FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000)},   {FRAC_CONST(0.999698817729950), FRAC_CONST(0.024541229009628)},
                                         {FRAC_CONST(0.998795449733734), FRAC_CONST(0.049067676067352)},   {FRAC_CONST(0.997290432453156), FRAC_CONST(0.073564566671848)},
                                         {FRAC_CONST(0.995184719562531), FRAC_CONST(0.098017141222954)},   {FRAC_CONST(0.992479562759399), FRAC_CONST(0.122410677373409)},
                                         {FRAC_CONST(0.989176511764526), FRAC_CONST(0.146730467677116)},   {FRAC_CONST(0.985277652740479), FRAC_CONST(0.170961901545525)},
                                         {FRAC_CONST(0.980785250663757), FRAC_CONST(0.195090323686600)},   {FRAC_CONST(0.975702106952667), FRAC_CONST(0.219101235270500)},
                                         {FRAC_CONST(0.970031261444092), FRAC_CONST(0.242980197072029)},   {FRAC_CONST(0.963776051998138), FRAC_CONST(0.266712784767151)},
                                         {FRAC_CONST(0.956940352916718), FRAC_CONST(0.290284663438797)},   {FRAC_CONST(0.949528157711029), FRAC_CONST(0.313681751489639)},
                                         {FRAC_CONST(0.941544055938721), FRAC_CONST(0.336889863014221)},   {FRAC_CONST(0.932992815971375), FRAC_CONST(0.359895050525665)},
                                         {FRAC_CONST(0.923879504203796), FRAC_CONST(0.382683455944061)},   {FRAC_CONST(0.914209723472595), FRAC_CONST(0.405241340398788)},
                                         {FRAC_CONST(0.903989315032959), FRAC_CONST(0.427555084228516)},   {FRAC_CONST(0.893224298954010), FRAC_CONST(0.449611335992813)},
                                         {FRAC_CONST(0.881921231746674), FRAC_CONST(0.471396744251251)},   {FRAC_CONST(0.870086967945099), FRAC_CONST(0.492898225784302)},
                                         {FRAC_CONST(0.857728600502014), FRAC_CONST(0.514102756977081)},   {FRAC_CONST(0.844853579998016), FRAC_CONST(0.534997642040253)},
                                         {FRAC_CONST(0.831469595432281), FRAC_CONST(0.555570244789124)},   {FRAC_CONST(0.817584812641144), FRAC_CONST(0.575808227062225)},
                                         {FRAC_CONST(0.803207516670227), FRAC_CONST(0.595699310302734)},   {FRAC_CONST(0.788346409797668), FRAC_CONST(0.615231633186340)},
                                         {FRAC_CONST(0.773010432720184), FRAC_CONST(0.634393334388733)},   {FRAC_CONST(0.757208824157715), FRAC_CONST(0.653172850608826)},
                                         {FRAC_CONST(0.740951120853424), FRAC_CONST(0.671558976173401)},   {FRAC_CONST(0.724247097969055), FRAC_CONST(0.689540565013886)},
                                         {FRAC_CONST(0.707106769084930), FRAC_CONST(0.707106769084930)},   {FRAC_CONST(0.689540505409241), FRAC_CONST(0.724247097969055)},
                                         {FRAC_CONST(0.671558916568756), FRAC_CONST(0.740951180458069)},   {FRAC_CONST(0.653172791004181), FRAC_CONST(0.757208883762360)},
                                         {FRAC_CONST(0.634393274784088), FRAC_CONST(0.773010432720184)},   {FRAC_CONST(0.615231573581696), FRAC_CONST(0.788346409797668)},
                                         {FRAC_CONST(0.595699310302734), FRAC_CONST(0.803207516670227)},   {FRAC_CONST(0.575808167457581), FRAC_CONST(0.817584812641144)},
                                         {FRAC_CONST(0.555570185184479), FRAC_CONST(0.831469655036926)},   {FRAC_CONST(0.534997642040253), FRAC_CONST(0.844853579998016)},
                                         {FRAC_CONST(0.514102697372437), FRAC_CONST(0.857728660106659)},   {FRAC_CONST(0.492898195981979), FRAC_CONST(0.870086967945099)},
                                         {FRAC_CONST(0.471396654844284), FRAC_CONST(0.881921291351318)},   {FRAC_CONST(0.449611306190491), FRAC_CONST(0.893224298954010)},
                                         {FRAC_CONST(0.427555114030838), FRAC_CONST(0.903989315032959)},   {FRAC_CONST(0.405241280794144), FRAC_CONST(0.914209783077240)},
                                         {FRAC_CONST(0.382683426141739), FRAC_CONST(0.923879504203796)},   {FRAC_CONST(0.359894961118698), FRAC_CONST(0.932992815971375)},
                                         {FRAC_CONST(0.336889833211899), FRAC_CONST(0.941544055938721)},   {FRAC_CONST(0.313681662082672), FRAC_CONST(0.949528217315674)},
                                         {FRAC_CONST(0.290284633636475), FRAC_CONST(0.956940352916718)},   {FRAC_CONST(0.266712754964828), FRAC_CONST(0.963776051998138)},
                                         {FRAC_CONST(0.242980122566223), FRAC_CONST(0.970031261444092)},   {FRAC_CONST(0.219101220369339), FRAC_CONST(0.975702106952667)},
                                         {FRAC_CONST(0.195090234279633), FRAC_CONST(0.980785310268402)},   {FRAC_CONST(0.170961856842041), FRAC_CONST(0.985277652740479)},
                                         {FRAC_CONST(0.146730497479439), FRAC_CONST(0.989176511764526)},   {FRAC_CONST(0.122410625219345), FRAC_CONST(0.992479562759399)},
                                         {FRAC_CONST(0.098017133772373), FRAC_CONST(0.995184719562531)},   {FRAC_CONST(0.073564492166042), FRAC_CONST(0.997290432453156)},
                                         {FRAC_CONST(0.049067649990320), FRAC_CONST(0.998795449733734)},   {FRAC_CONST(0.024541135877371), FRAC_CONST(0.999698817729950)},
                                         {FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000)},   {FRAC_CONST(0.998795449733734), FRAC_CONST(0.049067676067352)},
                                         {FRAC_CONST(0.995184719562531), FRAC_CONST(0.098017141222954)},   {FRAC_CONST(0.989176511764526), FRAC_CONST(0.146730467677116)},
                                         {FRAC_CONST(0.980785250663757), FRAC_CONST(0.195090323686600)},   {FRAC_CONST(0.970031261444092), FRAC_CONST(0.242980197072029)},
                                         {FRAC_CONST(0.956940352916718), FRAC_CONST(0.290284663438797)},   {FRAC_CONST(0.941544055938721), FRAC_CONST(0.336889863014221)},
                                         {FRAC_CONST(0.923879504203796), FRAC_CONST(0.382683455944061)},   {FRAC_CONST(0.903989315032959), FRAC_CONST(0.427555084228516)},
                                         {FRAC_CONST(0.881921231746674), FRAC_CONST(0.471396744251251)},   {FRAC_CONST(0.857728600502014), FRAC_CONST(0.514102756977081)},
                                         {FRAC_CONST(0.831469595432281), FRAC_CONST(0.555570244789124)},   {FRAC_CONST(0.803207516670227), FRAC_CONST(0.595699310302734)},
                                         {FRAC_CONST(0.773010432720184), FRAC_CONST(0.634393334388733)},   {FRAC_CONST(0.740951120853424), FRAC_CONST(0.671558976173401)},
                                         {FRAC_CONST(0.707106769084930), FRAC_CONST(0.707106769084930)},   {FRAC_CONST(0.671558916568756), FRAC_CONST(0.740951180458069)},
                                         {FRAC_CONST(0.634393274784088), FRAC_CONST(0.773010432720184)},   {FRAC_CONST(0.595699310302734), FRAC_CONST(0.803207516670227)},
                                         {FRAC_CONST(0.555570185184479), FRAC_CONST(0.831469655036926)},   {FRAC_CONST(0.514102697372437), FRAC_CONST(0.857728660106659)},
                                         {FRAC_CONST(0.471396654844284), FRAC_CONST(0.881921291351318)},   {FRAC_CONST(0.427555114030838), FRAC_CONST(0.903989315032959)},
                                         {FRAC_CONST(0.382683426141739), FRAC_CONST(0.923879504203796)},   {FRAC_CONST(0.336889833211899), FRAC_CONST(0.941544055938721)},
                                         {FRAC_CONST(0.290284633636475), FRAC_CONST(0.956940352916718)},   {FRAC_CONST(0.242980122566223), FRAC_CONST(0.970031261444092)},
                                         {FRAC_CONST(0.195090234279633), FRAC_CONST(0.980785310268402)},   {FRAC_CONST(0.146730497479439), FRAC_CONST(0.989176511764526)},
                                         {FRAC_CONST(0.098017133772373), FRAC_CONST(0.995184719562531)},   {FRAC_CONST(0.049067649990320), FRAC_CONST(0.998795449733734)},
                                         {FRAC_CONST(-0.000000043711388), FRAC_CONST(1.000000000000000)},  {FRAC_CONST(-0.049067739397287), FRAC_CONST(0.998795449733734)},
                                         {FRAC_CONST(-0.098017223179340), FRAC_CONST(0.995184719562531)},  {FRAC_CONST(-0.146730571985245), FRAC_CONST(0.989176511764526)},
                                         {FRAC_CONST(-0.195090323686600), FRAC_CONST(0.980785250663757)},  {FRAC_CONST(-0.242980197072029), FRAC_CONST(0.970031261444092)},
                                         {FRAC_CONST(-0.290284723043442), FRAC_CONST(0.956940293312073)},  {FRAC_CONST(-0.336889922618866), FRAC_CONST(0.941544055938721)},
                                         {FRAC_CONST(-0.382683515548706), FRAC_CONST(0.923879504203796)},  {FRAC_CONST(-0.427555084228516), FRAC_CONST(0.903989315032959)},
                                         {FRAC_CONST(-0.471396833658218), FRAC_CONST(0.881921231746674)},  {FRAC_CONST(-0.514102756977081), FRAC_CONST(0.857728600502014)},
                                         {FRAC_CONST(-0.555570363998413), FRAC_CONST(0.831469535827637)},  {FRAC_CONST(-0.595699369907379), FRAC_CONST(0.803207516670227)},
                                         {FRAC_CONST(-0.634393274784088), FRAC_CONST(0.773010492324829)},  {FRAC_CONST(-0.671559035778046), FRAC_CONST(0.740951061248779)},
                                         {FRAC_CONST(-0.707106769084930), FRAC_CONST(0.707106769084930)},  {FRAC_CONST(-0.740951240062714), FRAC_CONST(0.671558856964111)},
                                         {FRAC_CONST(-0.773010492324829), FRAC_CONST(0.634393274784088)},  {FRAC_CONST(-0.803207635879517), FRAC_CONST(0.595699131488800)},
                                         {FRAC_CONST(-0.831469655036926), FRAC_CONST(0.555570185184479)},  {FRAC_CONST(-0.857728600502014), FRAC_CONST(0.514102756977081)},
                                         {FRAC_CONST(-0.881921350955963), FRAC_CONST(0.471396625041962)},  {FRAC_CONST(-0.903989315032959), FRAC_CONST(0.427555054426193)},
                                         {FRAC_CONST(-0.923879623413086), FRAC_CONST(0.382683277130127)},  {FRAC_CONST(-0.941544115543365), FRAC_CONST(0.336889803409576)},
                                         {FRAC_CONST(-0.956940352916718), FRAC_CONST(0.290284723043442)},  {FRAC_CONST(-0.970031261444092), FRAC_CONST(0.242980077862740)},
                                         {FRAC_CONST(-0.980785310268402), FRAC_CONST(0.195090308785439)},  {FRAC_CONST(-0.989176511764526), FRAC_CONST(0.146730333566666)},
                                         {FRAC_CONST(-0.995184719562531), FRAC_CONST(0.098017096519470)},  {FRAC_CONST(-0.998795449733734), FRAC_CONST(0.049067486077547)},
                                         {FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000)},   {FRAC_CONST(0.997290432453156), FRAC_CONST(0.073564566671848)},
                                         {FRAC_CONST(0.989176511764526), FRAC_CONST(0.146730467677116)},   {FRAC_CONST(0.975702106952667), FRAC_CONST(0.219101235270500)},
                                         {FRAC_CONST(0.956940352916718), FRAC_CONST(0.290284663438797)},   {FRAC_CONST(0.932992815971375), FRAC_CONST(0.359895050525665)},
                                         {FRAC_CONST(0.903989315032959), FRAC_CONST(0.427555084228516)},   {FRAC_CONST(0.870086967945099), FRAC_CONST(0.492898225784302)},
                                         {FRAC_CONST(0.831469595432281), FRAC_CONST(0.555570244789124)},   {FRAC_CONST(0.788346469402313), FRAC_CONST(0.615231573581696)},
                                         {FRAC_CONST(0.740951120853424), FRAC_CONST(0.671558976173401)},   {FRAC_CONST(0.689540505409241), FRAC_CONST(0.724247097969055)},
                                         {FRAC_CONST(0.634393274784088), FRAC_CONST(0.773010432720184)},   {FRAC_CONST(0.575808227062225), FRAC_CONST(0.817584812641144)},
                                         {FRAC_CONST(0.514102697372437), FRAC_CONST(0.857728660106659)},   {FRAC_CONST(0.449611306190491), FRAC_CONST(0.893224298954010)},
                                         {FRAC_CONST(0.382683426141739), FRAC_CONST(0.923879504203796)},   {FRAC_CONST(0.313681751489639), FRAC_CONST(0.949528157711029)},
                                         {FRAC_CONST(0.242980241775513), FRAC_CONST(0.970031261444092)},   {FRAC_CONST(0.170961856842041), FRAC_CONST(0.985277652740479)},
                                         {FRAC_CONST(0.098017133772373), FRAC_CONST(0.995184719562531)},   {FRAC_CONST(0.024541255086660), FRAC_CONST(0.999698817729950)},
                                         {FRAC_CONST(-0.049067739397287), FRAC_CONST(0.998795449733734)},  {FRAC_CONST(-0.122410707175732), FRAC_CONST(0.992479503154755)},
                                         {FRAC_CONST(-0.195090323686600), FRAC_CONST(0.980785250663757)},  {FRAC_CONST(-0.266712725162506), FRAC_CONST(0.963776051998138)},
                                         {FRAC_CONST(-0.336889803409576), FRAC_CONST(0.941544055938721)},  {FRAC_CONST(-0.405241340398788), FRAC_CONST(0.914209723472595)},
                                         {FRAC_CONST(-0.471396833658218), FRAC_CONST(0.881921231746674)},  {FRAC_CONST(-0.534997701644897), FRAC_CONST(0.844853520393372)},
                                         {FRAC_CONST(-0.595699369907379), FRAC_CONST(0.803207516670227)},  {FRAC_CONST(-0.653172850608826), FRAC_CONST(0.757208824157715)},
                                         {FRAC_CONST(-0.707106769084930), FRAC_CONST(0.707106769084930)},  {FRAC_CONST(-0.757208824157715), FRAC_CONST(0.653172850608826)},
                                         {FRAC_CONST(-0.803207516670227), FRAC_CONST(0.595699369907379)},  {FRAC_CONST(-0.844853520393372), FRAC_CONST(0.534997701644897)},
                                         {FRAC_CONST(-0.881921231746674), FRAC_CONST(0.471396833658218)},  {FRAC_CONST(-0.914209783077240), FRAC_CONST(0.405241221189499)},
                                         {FRAC_CONST(-0.941544115543365), FRAC_CONST(0.336889803409576)},  {FRAC_CONST(-0.963776051998138), FRAC_CONST(0.266712725162506)},
                                         {FRAC_CONST(-0.980785310268402), FRAC_CONST(0.195090308785439)},  {FRAC_CONST(-0.992479503154755), FRAC_CONST(0.122410699725151)},
                                         {FRAC_CONST(-0.998795449733734), FRAC_CONST(0.049067724496126)},  {FRAC_CONST(-0.999698817729950), FRAC_CONST(-0.024541147053242)},
                                         {FRAC_CONST(-0.995184719562531), FRAC_CONST(-0.098017267882824)}, {FRAC_CONST(-0.985277652740479), FRAC_CONST(-0.170961990952492)},
                                         {FRAC_CONST(-0.970031261444092), FRAC_CONST(-0.242980241775513)}, {FRAC_CONST(-0.949528157711029), FRAC_CONST(-0.313681781291962)},
                                         {FRAC_CONST(-0.923879504203796), FRAC_CONST(-0.382683426141739)}, {FRAC_CONST(-0.893224298954010), FRAC_CONST(-0.449611306190491)},
                                         {FRAC_CONST(-0.857728660106659), FRAC_CONST(-0.514102697372437)}, {FRAC_CONST(-0.817584872245789), FRAC_CONST(-0.575808107852936)},
                                         {FRAC_CONST(-0.773010551929474), FRAC_CONST(-0.634393215179443)}, {FRAC_CONST(-0.724247038364410), FRAC_CONST(-0.689540624618530)},
                                         {FRAC_CONST(-0.671558916568756), FRAC_CONST(-0.740951180458069)}, {FRAC_CONST(-0.615231573581696), FRAC_CONST(-0.788346469402313)},
                                         {FRAC_CONST(-0.555570006370544), FRAC_CONST(-0.831469774246216)}, {FRAC_CONST(-0.492898195981979), FRAC_CONST(-0.870086967945099)},
                                         {FRAC_CONST(-0.427554935216904), FRAC_CONST(-0.903989374637604)}, {FRAC_CONST(-0.359895110130310), FRAC_CONST(-0.932992756366730)},
                                         {FRAC_CONST(-0.290284544229507), FRAC_CONST(-0.956940352916718)}, {FRAC_CONST(-0.219101369380951), FRAC_CONST(-0.975702106952667)},
                                         {FRAC_CONST(-0.146730408072472), FRAC_CONST(-0.989176511764526)}, {FRAC_CONST(-0.073564760386944), FRAC_CONST(-0.997290432453156)},
                                         {FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000)},   {FRAC_CONST(0.995184719562531), FRAC_CONST(0.098017141222954)},
                                         {FRAC_CONST(0.980785250663757), FRAC_CONST(0.195090323686600)},   {FRAC_CONST(0.956940352916718), FRAC_CONST(0.290284663438797)},
                                         {FRAC_CONST(0.923879504203796), FRAC_CONST(0.382683455944061)},   {FRAC_CONST(0.881921231746674), FRAC_CONST(0.471396744251251)},
                                         {FRAC_CONST(0.831469595432281), FRAC_CONST(0.555570244789124)},   {FRAC_CONST(0.773010432720184), FRAC_CONST(0.634393334388733)},
                                         {FRAC_CONST(0.707106769084930), FRAC_CONST(0.707106769084930)},   {FRAC_CONST(0.634393274784088), FRAC_CONST(0.773010432720184)},
                                         {FRAC_CONST(0.555570185184479), FRAC_CONST(0.831469655036926)},   {FRAC_CONST(0.471396654844284), FRAC_CONST(0.881921291351318)},
                                         {FRAC_CONST(0.382683426141739), FRAC_CONST(0.923879504203796)},   {FRAC_CONST(0.290284633636475), FRAC_CONST(0.956940352916718)},
                                         {FRAC_CONST(0.195090234279633), FRAC_CONST(0.980785310268402)},   {FRAC_CONST(0.098017133772373), FRAC_CONST(0.995184719562531)},
                                         {FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000)},   {FRAC_CONST(0.980785250663757), FRAC_CONST(0.195090323686600)},
                                         {FRAC_CONST(0.923879504203796), FRAC_CONST(0.382683455944061)},   {FRAC_CONST(0.831469595432281), FRAC_CONST(0.555570244789124)},
                                         {FRAC_CONST(0.707106769084930), FRAC_CONST(0.707106769084930)},   {FRAC_CONST(0.555570185184479), FRAC_CONST(0.831469655036926)},
                                         {FRAC_CONST(0.382683426141739), FRAC_CONST(0.923879504203796)},   {FRAC_CONST(0.195090234279633), FRAC_CONST(0.980785310268402)},
                                         {FRAC_CONST(-0.000000043711388), FRAC_CONST(1.000000000000000)},  {FRAC_CONST(-0.195090323686600), FRAC_CONST(0.980785250663757)},
                                         {FRAC_CONST(-0.382683515548706), FRAC_CONST(0.923879504203796)},  {FRAC_CONST(-0.555570363998413), FRAC_CONST(0.831469535827637)},
                                         {FRAC_CONST(-0.707106769084930), FRAC_CONST(0.707106769084930)},  {FRAC_CONST(-0.831469655036926), FRAC_CONST(0.555570185184479)},
                                         {FRAC_CONST(-0.923879623413086), FRAC_CONST(0.382683277130127)},  {FRAC_CONST(-0.980785310268402), FRAC_CONST(0.195090308785439)},
                                         {FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000)},   {FRAC_CONST(0.956940352916718), FRAC_CONST(0.290284663438797)},
                                         {FRAC_CONST(0.831469595432281), FRAC_CONST(0.555570244789124)},   {FRAC_CONST(0.634393274784088), FRAC_CONST(0.773010432720184)},
                                         {FRAC_CONST(0.382683426141739), FRAC_CONST(0.923879504203796)},   {FRAC_CONST(0.098017133772373), FRAC_CONST(0.995184719562531)},
                                         {FRAC_CONST(-0.195090323686600), FRAC_CONST(0.980785250663757)},  {FRAC_CONST(-0.471396833658218), FRAC_CONST(0.881921231746674)},
                                         {FRAC_CONST(-0.707106769084930), FRAC_CONST(0.707106769084930)},  {FRAC_CONST(-0.881921231746674), FRAC_CONST(0.471396833658218)},
                                         {FRAC_CONST(-0.980785310268402), FRAC_CONST(0.195090308785439)},  {FRAC_CONST(-0.995184719562531), FRAC_CONST(-0.098017267882824)},
                                         {FRAC_CONST(-0.923879504203796), FRAC_CONST(-0.382683426141739)}, {FRAC_CONST(-0.773010551929474), FRAC_CONST(-0.634393215179443)},
                                         {FRAC_CONST(-0.555570006370544), FRAC_CONST(-0.831469774246216)}, {FRAC_CONST(-0.290284544229507), FRAC_CONST(-0.956940352916718)},
                                         {FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000)},   {FRAC_CONST(0.923879504203796), FRAC_CONST(0.382683455944061)},
                                         {FRAC_CONST(0.707106769084930), FRAC_CONST(0.707106769084930)},   {FRAC_CONST(0.382683426141739), FRAC_CONST(0.923879504203796)},
                                         {FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000)},   {FRAC_CONST(0.707106769084930), FRAC_CONST(0.707106769084930)},
                                         {FRAC_CONST(-0.000000043711388), FRAC_CONST(1.000000000000000)},  {FRAC_CONST(-0.707106769084930), FRAC_CONST(0.707106769084930)},
                                         {FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000)},   {FRAC_CONST(0.382683426141739), FRAC_CONST(0.923879504203796)},
                                         {FRAC_CONST(-0.707106769084930), FRAC_CONST(0.707106769084930)},  {FRAC_CONST(-0.923879504203796), FRAC_CONST(-0.382683426141739)},
                                         {FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000)},   {FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000)},
                                         {FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000)},   {FRAC_CONST(0.000000011924881), FRAC_CONST(-1.000000000000000)}};
#endif // FIXED_POINT
// ——————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
#ifdef FIXED_POINT
    #ifdef ALLOW_SMALL_FRAMELENGTH
static const complex_t cfft_tab_480[] = {{FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000)},   {FRAC_CONST(0.999914348125458), FRAC_CONST(0.013089596293867)},
                                         {FRAC_CONST(0.999657332897186), FRAC_CONST(0.026176949962974)},   {FRAC_CONST(0.999229013919830), FRAC_CONST(0.039259817451239)},
                                         {FRAC_CONST(0.998629510402679), FRAC_CONST(0.052335958927870)},   {FRAC_CONST(0.997858941555023), FRAC_CONST(0.065403133630753)},
                                         {FRAC_CONST(0.996917307376862), FRAC_CONST(0.078459098935127)},   {FRAC_CONST(0.995804905891418), FRAC_CONST(0.091501623392105)},
                                         {FRAC_CONST(0.994521915912628), FRAC_CONST(0.104528464376926)},   {FRAC_CONST(0.993068456649780), FRAC_CONST(0.117537401616573)},
                                         {FRAC_CONST(0.991444885730743), FRAC_CONST(0.130526199936867)},   {FRAC_CONST(0.989651381969452), FRAC_CONST(0.143492624163628)},
                                         {FRAC_CONST(0.987688362598419), FRAC_CONST(0.156434476375580)},   {FRAC_CONST(0.985556066036224), FRAC_CONST(0.169349506497383)},
                                         {FRAC_CONST(0.983254909515381), FRAC_CONST(0.182235524058342)},   {FRAC_CONST(0.980785250663757), FRAC_CONST(0.195090323686600)},
                                         {FRAC_CONST(0.978147625923157), FRAC_CONST(0.207911700010300)},   {FRAC_CONST(0.975342333316803), FRAC_CONST(0.220697447657585)},
                                         {FRAC_CONST(0.972369909286499), FRAC_CONST(0.233445376157761)},   {FRAC_CONST(0.969230890274048), FRAC_CONST(0.246153295040131)},
                                         {FRAC_CONST(0.965925812721252), FRAC_CONST(0.258819043636322)},   {FRAC_CONST(0.962455213069916), FRAC_CONST(0.271440446376801)},
                                         {FRAC_CONST(0.958819746971130), FRAC_CONST(0.284015357494354)},   {FRAC_CONST(0.955019950866699), FRAC_CONST(0.296541601419449)},
                                         {FRAC_CONST(0.951056540012360), FRAC_CONST(0.309017002582550)},   {FRAC_CONST(0.946930110454559), FRAC_CONST(0.321439445018768)},
                                         {FRAC_CONST(0.942641496658325), FRAC_CONST(0.333806872367859)},   {FRAC_CONST(0.938191354274750), FRAC_CONST(0.346117079257965)},
                                         {FRAC_CONST(0.933580398559570), FRAC_CONST(0.358367949724197)},   {FRAC_CONST(0.928809583187103), FRAC_CONST(0.370557427406311)},
                                         {FRAC_CONST(0.923879504203796), FRAC_CONST(0.382683455944061)},   {FRAC_CONST(0.918791174888611), FRAC_CONST(0.394743889570236)},
                                         {FRAC_CONST(0.913545429706573), FRAC_CONST(0.406736642122269)},   {FRAC_CONST(0.908143162727356), FRAC_CONST(0.418659746646881)},
                                         {FRAC_CONST(0.902585268020630), FRAC_CONST(0.430511116981506)},   {FRAC_CONST(0.896872758865356), FRAC_CONST(0.442288726568222)},
                                         {FRAC_CONST(0.891006529331207), FRAC_CONST(0.453990519046783)},   {FRAC_CONST(0.884987652301788), FRAC_CONST(0.465614527463913)},
                                         {FRAC_CONST(0.878817081451416), FRAC_CONST(0.477158784866333)},   {FRAC_CONST(0.872496008872986), FRAC_CONST(0.488621264696121)},
                                         {FRAC_CONST(0.866025388240814), FRAC_CONST(0.500000000000000)},   {FRAC_CONST(0.859406411647797), FRAC_CONST(0.511293113231659)},
                                         {FRAC_CONST(0.852640151977539), FRAC_CONST(0.522498548030853)},   {FRAC_CONST(0.845727801322937), FRAC_CONST(0.533614516258240)},
                                         {FRAC_CONST(0.838670551776886), FRAC_CONST(0.544639050960541)},   {FRAC_CONST(0.831469595432281), FRAC_CONST(0.555570244789124)},
                                         {FRAC_CONST(0.824126183986664), FRAC_CONST(0.566406250000000)},   {FRAC_CONST(0.816641509532928), FRAC_CONST(0.577145218849182)},
                                         {FRAC_CONST(0.809017002582550), FRAC_CONST(0.587785243988037)},   {FRAC_CONST(0.801253795623779), FRAC_CONST(0.598324596881866)},
                                         {FRAC_CONST(0.793353319168091), FRAC_CONST(0.608761429786682)},   {FRAC_CONST(0.785316884517670), FRAC_CONST(0.619093954563141)},
                                         {FRAC_CONST(0.777145922183990), FRAC_CONST(0.629320383071899)},   {FRAC_CONST(0.768841803073883), FRAC_CONST(0.639438986778259)},
                                         {FRAC_CONST(0.760405957698822), FRAC_CONST(0.649448096752167)},   {FRAC_CONST(0.751839756965637), FRAC_CONST(0.659345865249634)},
                                         {FRAC_CONST(0.743144810199738), FRAC_CONST(0.669130623340607)},   {FRAC_CONST(0.734322488307953), FRAC_CONST(0.678800761699677)},
                                         {FRAC_CONST(0.725374400615692), FRAC_CONST(0.688354551792145)},   {FRAC_CONST(0.716301918029785), FRAC_CONST(0.697790503501892)},
                                         {FRAC_CONST(0.707106769084930), FRAC_CONST(0.707106769084930)},   {FRAC_CONST(0.697790443897247), FRAC_CONST(0.716301977634430)},
                                         {FRAC_CONST(0.688354551792145), FRAC_CONST(0.725374400615692)},   {FRAC_CONST(0.678800702095032), FRAC_CONST(0.734322547912598)},
                                         {FRAC_CONST(0.669130563735962), FRAC_CONST(0.743144869804382)},   {FRAC_CONST(0.659345805644989), FRAC_CONST(0.751839816570282)},
                                         {FRAC_CONST(0.649448037147522), FRAC_CONST(0.760405957698822)},   {FRAC_CONST(0.639438986778259), FRAC_CONST(0.768841862678528)},
                                         {FRAC_CONST(0.629320383071899), FRAC_CONST(0.777145981788635)},   {FRAC_CONST(0.619093954563141), FRAC_CONST(0.785316944122314)},
                                         {FRAC_CONST(0.608761370182037), FRAC_CONST(0.793353378772736)},   {FRAC_CONST(0.598324596881866), FRAC_CONST(0.801253855228424)},
                                         {FRAC_CONST(0.587785243988037), FRAC_CONST(0.809017002582550)},   {FRAC_CONST(0.577145159244537), FRAC_CONST(0.816641569137573)},
                                         {FRAC_CONST(0.566406250000000), FRAC_CONST(0.824126183986664)},   {FRAC_CONST(0.555570185184479), FRAC_CONST(0.831469655036926)},
                                         {FRAC_CONST(0.544638991355896), FRAC_CONST(0.838670611381531)},   {FRAC_CONST(0.533614516258240), FRAC_CONST(0.845727801322937)},
                                         {FRAC_CONST(0.522498488426209), FRAC_CONST(0.852640211582184)},   {FRAC_CONST(0.511293113231659), FRAC_CONST(0.859406411647797)},
                                         {FRAC_CONST(0.499999970197678), FRAC_CONST(0.866025447845459)},   {FRAC_CONST(0.488621175289154), FRAC_CONST(0.872496068477631)},
                                         {FRAC_CONST(0.477158755064011), FRAC_CONST(0.878817141056061)},   {FRAC_CONST(0.465614467859268), FRAC_CONST(0.884987652301788)},
                                         {FRAC_CONST(0.453990519046783), FRAC_CONST(0.891006529331207)},   {FRAC_CONST(0.442288666963577), FRAC_CONST(0.896872758865356)},
                                         {FRAC_CONST(0.430511027574539), FRAC_CONST(0.902585327625275)},   {FRAC_CONST(0.418659746646881), FRAC_CONST(0.908143162727356)},
                                         {FRAC_CONST(0.406736612319946), FRAC_CONST(0.913545489311218)},   {FRAC_CONST(0.394743800163269), FRAC_CONST(0.918791234493256)},
                                         {FRAC_CONST(0.382683426141739), FRAC_CONST(0.923879504203796)},   {FRAC_CONST(0.370557397603989), FRAC_CONST(0.928809583187103)},
                                         {FRAC_CONST(0.358367860317230), FRAC_CONST(0.933580458164215)},   {FRAC_CONST(0.346117049455643), FRAC_CONST(0.938191354274750)},
                                         {FRAC_CONST(0.333806812763214), FRAC_CONST(0.942641496658325)},   {FRAC_CONST(0.321439474821091), FRAC_CONST(0.946930110454559)},
                                         {FRAC_CONST(0.309016972780228), FRAC_CONST(0.951056540012360)},   {FRAC_CONST(0.296541512012482), FRAC_CONST(0.955019950866699)},
                                         {FRAC_CONST(0.284015327692032), FRAC_CONST(0.958819746971130)},   {FRAC_CONST(0.271440386772156), FRAC_CONST(0.962455272674561)},
                                         {FRAC_CONST(0.258819073438644), FRAC_CONST(0.965925812721252)},   {FRAC_CONST(0.246153265237808), FRAC_CONST(0.969230890274048)},
                                         {FRAC_CONST(0.233445301651955), FRAC_CONST(0.972369909286499)},   {FRAC_CONST(0.220697447657585), FRAC_CONST(0.975342333316803)},
                                         {FRAC_CONST(0.207911655306816), FRAC_CONST(0.978147625923157)},   {FRAC_CONST(0.195090234279633), FRAC_CONST(0.980785310268402)},
                                         {FRAC_CONST(0.182235524058342), FRAC_CONST(0.983254909515381)},   {FRAC_CONST(0.169349446892738), FRAC_CONST(0.985556066036224)},
                                         {FRAC_CONST(0.156434372067451), FRAC_CONST(0.987688362598419)},   {FRAC_CONST(0.143492594361305), FRAC_CONST(0.989651381969452)},
                                         {FRAC_CONST(0.130526125431061), FRAC_CONST(0.991444885730743)},   {FRAC_CONST(0.117537401616573), FRAC_CONST(0.993068456649780)},
                                         {FRAC_CONST(0.104528419673443), FRAC_CONST(0.994521915912628)},   {FRAC_CONST(0.091501533985138), FRAC_CONST(0.995804905891418)},
                                         {FRAC_CONST(0.078459084033966), FRAC_CONST(0.996917307376862)},   {FRAC_CONST(0.065403074026108), FRAC_CONST(0.997858941555023)},
                                         {FRAC_CONST(0.052335973829031), FRAC_CONST(0.998629510402679)},   {FRAC_CONST(0.039259787648916), FRAC_CONST(0.999229013919830)},
                                         {FRAC_CONST(0.026176875457168), FRAC_CONST(0.999657332897186)},   {FRAC_CONST(0.013089597225189), FRAC_CONST(0.999914348125458)},
                                         {FRAC_CONST(-0.000000043711388), FRAC_CONST(1.000000000000000)},  {FRAC_CONST(-0.013089684769511), FRAC_CONST(0.999914348125458)},
                                         {FRAC_CONST(-0.026176963001490), FRAC_CONST(0.999657332897186)},  {FRAC_CONST(-0.039259877055883), FRAC_CONST(0.999229013919830)},
                                         {FRAC_CONST(-0.052336059510708), FRAC_CONST(0.998629510402679)},  {FRAC_CONST(-0.065403163433075), FRAC_CONST(0.997858941555023)},
                                         {FRAC_CONST(-0.078459173440933), FRAC_CONST(0.996917307376862)},  {FRAC_CONST(-0.091501623392105), FRAC_CONST(0.995804905891418)},
                                         {FRAC_CONST(-0.104528509080410), FRAC_CONST(0.994521915912628)},  {FRAC_CONST(-0.117537491023541), FRAC_CONST(0.993068456649780)},
                                         {FRAC_CONST(-0.130526214838028), FRAC_CONST(0.991444885730743)},  {FRAC_CONST(-0.143492683768272), FRAC_CONST(0.989651381969452)},
                                         {FRAC_CONST(-0.156434446573257), FRAC_CONST(0.987688362598419)},  {FRAC_CONST(-0.169349536299706), FRAC_CONST(0.985556066036224)},
                                         {FRAC_CONST(-0.182235598564148), FRAC_CONST(0.983254909515381)},  {FRAC_CONST(-0.195090323686600), FRAC_CONST(0.980785250663757)},
                                         {FRAC_CONST(-0.207911744713783), FRAC_CONST(0.978147566318512)},  {FRAC_CONST(-0.220697522163391), FRAC_CONST(0.975342273712158)},
                                         {FRAC_CONST(-0.233445391058922), FRAC_CONST(0.972369909286499)},  {FRAC_CONST(-0.246153354644775), FRAC_CONST(0.969230890274048)},
                                         {FRAC_CONST(-0.258819162845612), FRAC_CONST(0.965925812721252)},  {FRAC_CONST(-0.271440476179123), FRAC_CONST(0.962455213069916)},
                                         {FRAC_CONST(-0.284015417098999), FRAC_CONST(0.958819687366486)},  {FRAC_CONST(-0.296541571617126), FRAC_CONST(0.955019950866699)},
                                         {FRAC_CONST(-0.309017032384872), FRAC_CONST(0.951056480407715)},  {FRAC_CONST(-0.321439564228058), FRAC_CONST(0.946930110454559)},
                                         {FRAC_CONST(-0.333806872367859), FRAC_CONST(0.942641496658325)},  {FRAC_CONST(-0.346117109060287), FRAC_CONST(0.938191294670105)},
                                         {FRAC_CONST(-0.358367949724197), FRAC_CONST(0.933580458164215)},  {FRAC_CONST(-0.370557487010956), FRAC_CONST(0.928809523582459)},
                                         {FRAC_CONST(-0.382683515548706), FRAC_CONST(0.923879504203796)},  {FRAC_CONST(-0.394743859767914), FRAC_CONST(0.918791234493256)},
                                         {FRAC_CONST(-0.406736701726913), FRAC_CONST(0.913545429706573)},  {FRAC_CONST(-0.418659836053848), FRAC_CONST(0.908143103122711)},
                                         {FRAC_CONST(-0.430511116981506), FRAC_CONST(0.902585268020630)},  {FRAC_CONST(-0.442288637161255), FRAC_CONST(0.896872758865356)},
                                         {FRAC_CONST(-0.453990608453751), FRAC_CONST(0.891006469726563)},  {FRAC_CONST(-0.465614557266235), FRAC_CONST(0.884987592697144)},
                                         {FRAC_CONST(-0.477158725261688), FRAC_CONST(0.878817141056061)},  {FRAC_CONST(-0.488621354103088), FRAC_CONST(0.872495949268341)},
                                         {FRAC_CONST(-0.500000059604645), FRAC_CONST(0.866025388240814)},  {FRAC_CONST(-0.511293053627014), FRAC_CONST(0.859406411647797)},
                                         {FRAC_CONST(-0.522498667240143), FRAC_CONST(0.852640092372894)},  {FRAC_CONST(-0.533614575862885), FRAC_CONST(0.845727801322937)},
                                         {FRAC_CONST(-0.544639050960541), FRAC_CONST(0.838670551776886)},  {FRAC_CONST(-0.555570363998413), FRAC_CONST(0.831469535827637)},
                                         {FRAC_CONST(-0.566406309604645), FRAC_CONST(0.824126124382019)},  {FRAC_CONST(-0.577145218849182), FRAC_CONST(0.816641569137573)},
                                         {FRAC_CONST(-0.587785184383392), FRAC_CONST(0.809017002582550)},  {FRAC_CONST(-0.598324656486511), FRAC_CONST(0.801253736019135)},
                                         {FRAC_CONST(-0.608761429786682), FRAC_CONST(0.793353319168091)},  {FRAC_CONST(-0.619093894958496), FRAC_CONST(0.785316944122314)},
                                         {FRAC_CONST(-0.629320502281189), FRAC_CONST(0.777145862579346)},  {FRAC_CONST(-0.639439046382904), FRAC_CONST(0.768841803073883)},
                                         {FRAC_CONST(-0.649448037147522), FRAC_CONST(0.760405957698822)},  {FRAC_CONST(-0.659345924854279), FRAC_CONST(0.751839697360992)},
                                         {FRAC_CONST(-0.669130682945251), FRAC_CONST(0.743144810199738)},  {FRAC_CONST(-0.678800761699677), FRAC_CONST(0.734322488307953)},
                                         {FRAC_CONST(-0.688354671001434), FRAC_CONST(0.725374281406403)},  {FRAC_CONST(-0.697790503501892), FRAC_CONST(0.716301858425140)},
                                         {FRAC_CONST(-0.707106769084930), FRAC_CONST(0.707106769084930)},  {FRAC_CONST(-0.716302037239075), FRAC_CONST(0.697790324687958)},
                                         {FRAC_CONST(-0.725374460220337), FRAC_CONST(0.688354492187500)},  {FRAC_CONST(-0.734322547912598), FRAC_CONST(0.678800702095032)},
                                         {FRAC_CONST(-0.743144929409027), FRAC_CONST(0.669130444526672)},  {FRAC_CONST(-0.751839876174927), FRAC_CONST(0.659345746040344)},
                                         {FRAC_CONST(-0.760406017303467), FRAC_CONST(0.649448037147522)},  {FRAC_CONST(-0.768841803073883), FRAC_CONST(0.639439046382904)},
                                         {FRAC_CONST(-0.777146041393280), FRAC_CONST(0.629320263862610)},  {FRAC_CONST(-0.785316944122314), FRAC_CONST(0.619093894958496)},
                                         {FRAC_CONST(-0.793353319168091), FRAC_CONST(0.608761429786682)},  {FRAC_CONST(-0.801253914833069), FRAC_CONST(0.598324477672577)},
                                         {FRAC_CONST(-0.809017062187195), FRAC_CONST(0.587785184383392)},  {FRAC_CONST(-0.816641569137573), FRAC_CONST(0.577145218849182)},
                                         {FRAC_CONST(-0.824126303195953), FRAC_CONST(0.566406130790710)},  {FRAC_CONST(-0.831469655036926), FRAC_CONST(0.555570185184479)},
                                         {FRAC_CONST(-0.838670551776886), FRAC_CONST(0.544639050960541)},  {FRAC_CONST(-0.845727920532227), FRAC_CONST(0.533614337444305)},
                                         {FRAC_CONST(-0.852640211582184), FRAC_CONST(0.522498488426209)},  {FRAC_CONST(-0.859406411647797), FRAC_CONST(0.511293053627014)},
                                         {FRAC_CONST(-0.866025388240814), FRAC_CONST(0.500000059604645)},  {FRAC_CONST(-0.872496068477631), FRAC_CONST(0.488621145486832)},
                                         {FRAC_CONST(-0.878817141056061), FRAC_CONST(0.477158725261688)},  {FRAC_CONST(-0.884987652301788), FRAC_CONST(0.465614557266235)},
                                         {FRAC_CONST(-0.891006588935852), FRAC_CONST(0.453990370035172)},  {FRAC_CONST(-0.896872758865356), FRAC_CONST(0.442288637161255)},
                                         {FRAC_CONST(-0.902585268020630), FRAC_CONST(0.430511116981506)},  {FRAC_CONST(-0.908143222332001), FRAC_CONST(0.418659597635269)},
                                         {FRAC_CONST(-0.913545489311218), FRAC_CONST(0.406736582517624)},  {FRAC_CONST(-0.918791234493256), FRAC_CONST(0.394743859767914)},
                                         {FRAC_CONST(-0.923879623413086), FRAC_CONST(0.382683277130127)},  {FRAC_CONST(-0.928809583187103), FRAC_CONST(0.370557337999344)},
                                         {FRAC_CONST(-0.933580458164215), FRAC_CONST(0.358367919921875)},  {FRAC_CONST(-0.938191413879395), FRAC_CONST(0.346116900444031)},
                                         {FRAC_CONST(-0.942641556262970), FRAC_CONST(0.333806753158569)},  {FRAC_CONST(-0.946930170059204), FRAC_CONST(0.321439445018768)},
                                         {FRAC_CONST(-0.951056599617004), FRAC_CONST(0.309016793966293)},  {FRAC_CONST(-0.955020010471344), FRAC_CONST(0.296541452407837)},
                                         {FRAC_CONST(-0.958819746971130), FRAC_CONST(0.284015297889709)},  {FRAC_CONST(-0.962455213069916), FRAC_CONST(0.271440476179123)},
                                         {FRAC_CONST(-0.965925872325897), FRAC_CONST(0.258818924427032)},  {FRAC_CONST(-0.969230949878693), FRAC_CONST(0.246153235435486)},
                                         {FRAC_CONST(-0.972369909286499), FRAC_CONST(0.233445376157761)},  {FRAC_CONST(-0.975342333316803), FRAC_CONST(0.220697283744812)},
                                         {FRAC_CONST(-0.978147625923157), FRAC_CONST(0.207911610603333)},  {FRAC_CONST(-0.980785310268402), FRAC_CONST(0.195090308785439)},
                                         {FRAC_CONST(-0.983254909515381), FRAC_CONST(0.182235360145569)},  {FRAC_CONST(-0.985556066036224), FRAC_CONST(0.169349402189255)},
                                         {FRAC_CONST(-0.987688362598419), FRAC_CONST(0.156434446573257)},  {FRAC_CONST(-0.989651441574097), FRAC_CONST(0.143492430448532)},
                                         {FRAC_CONST(-0.991444885730743), FRAC_CONST(0.130526080727577)},  {FRAC_CONST(-0.993068456649780), FRAC_CONST(0.117537356913090)},
                                         {FRAC_CONST(-0.994521915912628), FRAC_CONST(0.104528494179249)},  {FRAC_CONST(-0.995804965496063), FRAC_CONST(0.091501489281654)},
                                         {FRAC_CONST(-0.996917366981506), FRAC_CONST(0.078459039330482)},  {FRAC_CONST(-0.997858941555023), FRAC_CONST(0.065403148531914)},
                                         {FRAC_CONST(-0.998629570007324), FRAC_CONST(0.052335809916258)},  {FRAC_CONST(-0.999229013919830), FRAC_CONST(0.039259742945433)},
                                         {FRAC_CONST(-0.999657332897186), FRAC_CONST(0.026176951825619)},  {FRAC_CONST(-0.999914348125458), FRAC_CONST(0.013089434243739)},
                                         {FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000)},   {FRAC_CONST(0.999657332897186), FRAC_CONST(0.026176949962974)},
                                         {FRAC_CONST(0.998629510402679), FRAC_CONST(0.052335958927870)},   {FRAC_CONST(0.996917307376862), FRAC_CONST(0.078459098935127)},
                                         {FRAC_CONST(0.994521915912628), FRAC_CONST(0.104528464376926)},   {FRAC_CONST(0.991444885730743), FRAC_CONST(0.130526199936867)},
                                         {FRAC_CONST(0.987688362598419), FRAC_CONST(0.156434476375580)},   {FRAC_CONST(0.983254909515381), FRAC_CONST(0.182235524058342)},
                                         {FRAC_CONST(0.978147625923157), FRAC_CONST(0.207911700010300)},   {FRAC_CONST(0.972369909286499), FRAC_CONST(0.233445376157761)},
                                         {FRAC_CONST(0.965925812721252), FRAC_CONST(0.258819043636322)},   {FRAC_CONST(0.958819746971130), FRAC_CONST(0.284015357494354)},
                                         {FRAC_CONST(0.951056540012360), FRAC_CONST(0.309017002582550)},   {FRAC_CONST(0.942641496658325), FRAC_CONST(0.333806872367859)},
                                         {FRAC_CONST(0.933580398559570), FRAC_CONST(0.358367949724197)},   {FRAC_CONST(0.923879504203796), FRAC_CONST(0.382683455944061)},
                                         {FRAC_CONST(0.913545429706573), FRAC_CONST(0.406736642122269)},   {FRAC_CONST(0.902585268020630), FRAC_CONST(0.430511116981506)},
                                         {FRAC_CONST(0.891006529331207), FRAC_CONST(0.453990519046783)},   {FRAC_CONST(0.878817081451416), FRAC_CONST(0.477158784866333)},
                                         {FRAC_CONST(0.866025388240814), FRAC_CONST(0.500000000000000)},   {FRAC_CONST(0.852640151977539), FRAC_CONST(0.522498548030853)},
                                         {FRAC_CONST(0.838670551776886), FRAC_CONST(0.544639050960541)},   {FRAC_CONST(0.824126183986664), FRAC_CONST(0.566406250000000)},
                                         {FRAC_CONST(0.809017002582550), FRAC_CONST(0.587785243988037)},   {FRAC_CONST(0.793353319168091), FRAC_CONST(0.608761429786682)},
                                         {FRAC_CONST(0.777145922183990), FRAC_CONST(0.629320383071899)},   {FRAC_CONST(0.760405957698822), FRAC_CONST(0.649448096752167)},
                                         {FRAC_CONST(0.743144810199738), FRAC_CONST(0.669130623340607)},   {FRAC_CONST(0.725374400615692), FRAC_CONST(0.688354551792145)},
                                         {FRAC_CONST(0.707106769084930), FRAC_CONST(0.707106769084930)},   {FRAC_CONST(0.688354551792145), FRAC_CONST(0.725374400615692)},
                                         {FRAC_CONST(0.669130563735962), FRAC_CONST(0.743144869804382)},   {FRAC_CONST(0.649448037147522), FRAC_CONST(0.760405957698822)},
                                         {FRAC_CONST(0.629320383071899), FRAC_CONST(0.777145981788635)},   {FRAC_CONST(0.608761370182037), FRAC_CONST(0.793353378772736)},
                                         {FRAC_CONST(0.587785243988037), FRAC_CONST(0.809017002582550)},   {FRAC_CONST(0.566406250000000), FRAC_CONST(0.824126183986664)},
                                         {FRAC_CONST(0.544638991355896), FRAC_CONST(0.838670611381531)},   {FRAC_CONST(0.522498488426209), FRAC_CONST(0.852640211582184)},
                                         {FRAC_CONST(0.499999970197678), FRAC_CONST(0.866025447845459)},   {FRAC_CONST(0.477158755064011), FRAC_CONST(0.878817141056061)},
                                         {FRAC_CONST(0.453990519046783), FRAC_CONST(0.891006529331207)},   {FRAC_CONST(0.430511027574539), FRAC_CONST(0.902585327625275)},
                                         {FRAC_CONST(0.406736612319946), FRAC_CONST(0.913545489311218)},   {FRAC_CONST(0.382683426141739), FRAC_CONST(0.923879504203796)},
                                         {FRAC_CONST(0.358367860317230), FRAC_CONST(0.933580458164215)},   {FRAC_CONST(0.333806812763214), FRAC_CONST(0.942641496658325)},
                                         {FRAC_CONST(0.309016972780228), FRAC_CONST(0.951056540012360)},   {FRAC_CONST(0.284015327692032), FRAC_CONST(0.958819746971130)},
                                         {FRAC_CONST(0.258819073438644), FRAC_CONST(0.965925812721252)},   {FRAC_CONST(0.233445301651955), FRAC_CONST(0.972369909286499)},
                                         {FRAC_CONST(0.207911655306816), FRAC_CONST(0.978147625923157)},   {FRAC_CONST(0.182235524058342), FRAC_CONST(0.983254909515381)},
                                         {FRAC_CONST(0.156434372067451), FRAC_CONST(0.987688362598419)},   {FRAC_CONST(0.130526125431061), FRAC_CONST(0.991444885730743)},
                                         {FRAC_CONST(0.104528419673443), FRAC_CONST(0.994521915912628)},   {FRAC_CONST(0.078459084033966), FRAC_CONST(0.996917307376862)},
                                         {FRAC_CONST(0.052335973829031), FRAC_CONST(0.998629510402679)},   {FRAC_CONST(0.026176875457168), FRAC_CONST(0.999657332897186)},
                                         {FRAC_CONST(-0.000000043711388), FRAC_CONST(1.000000000000000)},  {FRAC_CONST(-0.026176963001490), FRAC_CONST(0.999657332897186)},
                                         {FRAC_CONST(-0.052336059510708), FRAC_CONST(0.998629510402679)},  {FRAC_CONST(-0.078459173440933), FRAC_CONST(0.996917307376862)},
                                         {FRAC_CONST(-0.104528509080410), FRAC_CONST(0.994521915912628)},  {FRAC_CONST(-0.130526214838028), FRAC_CONST(0.991444885730743)},
                                         {FRAC_CONST(-0.156434446573257), FRAC_CONST(0.987688362598419)},  {FRAC_CONST(-0.182235598564148), FRAC_CONST(0.983254909515381)},
                                         {FRAC_CONST(-0.207911744713783), FRAC_CONST(0.978147566318512)},  {FRAC_CONST(-0.233445391058922), FRAC_CONST(0.972369909286499)},
                                         {FRAC_CONST(-0.258819162845612), FRAC_CONST(0.965925812721252)},  {FRAC_CONST(-0.284015417098999), FRAC_CONST(0.958819687366486)},
                                         {FRAC_CONST(-0.309017032384872), FRAC_CONST(0.951056480407715)},  {FRAC_CONST(-0.333806872367859), FRAC_CONST(0.942641496658325)},
                                         {FRAC_CONST(-0.358367949724197), FRAC_CONST(0.933580458164215)},  {FRAC_CONST(-0.382683515548706), FRAC_CONST(0.923879504203796)},
                                         {FRAC_CONST(-0.406736701726913), FRAC_CONST(0.913545429706573)},  {FRAC_CONST(-0.430511116981506), FRAC_CONST(0.902585268020630)},
                                         {FRAC_CONST(-0.453990608453751), FRAC_CONST(0.891006469726563)},  {FRAC_CONST(-0.477158725261688), FRAC_CONST(0.878817141056061)},
                                         {FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000)},   {FRAC_CONST(0.998629510402679), FRAC_CONST(0.052335958927870)},
                                         {FRAC_CONST(0.994521915912628), FRAC_CONST(0.104528464376926)},   {FRAC_CONST(0.987688362598419), FRAC_CONST(0.156434476375580)},
                                         {FRAC_CONST(0.978147625923157), FRAC_CONST(0.207911700010300)},   {FRAC_CONST(0.965925812721252), FRAC_CONST(0.258819043636322)},
                                         {FRAC_CONST(0.951056540012360), FRAC_CONST(0.309017002582550)},   {FRAC_CONST(0.933580398559570), FRAC_CONST(0.358367949724197)},
                                         {FRAC_CONST(0.913545429706573), FRAC_CONST(0.406736642122269)},   {FRAC_CONST(0.891006529331207), FRAC_CONST(0.453990519046783)},
                                         {FRAC_CONST(0.866025388240814), FRAC_CONST(0.500000000000000)},   {FRAC_CONST(0.838670551776886), FRAC_CONST(0.544639050960541)},
                                         {FRAC_CONST(0.809017002582550), FRAC_CONST(0.587785243988037)},   {FRAC_CONST(0.777145922183990), FRAC_CONST(0.629320383071899)},
                                         {FRAC_CONST(0.743144810199738), FRAC_CONST(0.669130623340607)},   {FRAC_CONST(0.707106769084930), FRAC_CONST(0.707106769084930)},
                                         {FRAC_CONST(0.669130563735962), FRAC_CONST(0.743144869804382)},   {FRAC_CONST(0.629320383071899), FRAC_CONST(0.777145981788635)},
                                         {FRAC_CONST(0.587785243988037), FRAC_CONST(0.809017002582550)},   {FRAC_CONST(0.544638991355896), FRAC_CONST(0.838670611381531)},
                                         {FRAC_CONST(0.499999970197678), FRAC_CONST(0.866025447845459)},   {FRAC_CONST(0.453990519046783), FRAC_CONST(0.891006529331207)},
                                         {FRAC_CONST(0.406736612319946), FRAC_CONST(0.913545489311218)},   {FRAC_CONST(0.358367860317230), FRAC_CONST(0.933580458164215)},
                                         {FRAC_CONST(0.309016972780228), FRAC_CONST(0.951056540012360)},   {FRAC_CONST(0.258819073438644), FRAC_CONST(0.965925812721252)},
                                         {FRAC_CONST(0.207911655306816), FRAC_CONST(0.978147625923157)},   {FRAC_CONST(0.156434372067451), FRAC_CONST(0.987688362598419)},
                                         {FRAC_CONST(0.104528419673443), FRAC_CONST(0.994521915912628)},   {FRAC_CONST(0.052335973829031), FRAC_CONST(0.998629510402679)},
                                         {FRAC_CONST(-0.000000043711388), FRAC_CONST(1.000000000000000)},  {FRAC_CONST(-0.052336059510708), FRAC_CONST(0.998629510402679)},
                                         {FRAC_CONST(-0.104528509080410), FRAC_CONST(0.994521915912628)},  {FRAC_CONST(-0.156434446573257), FRAC_CONST(0.987688362598419)},
                                         {FRAC_CONST(-0.207911744713783), FRAC_CONST(0.978147566318512)},  {FRAC_CONST(-0.258819162845612), FRAC_CONST(0.965925812721252)},
                                         {FRAC_CONST(-0.309017032384872), FRAC_CONST(0.951056480407715)},  {FRAC_CONST(-0.358367949724197), FRAC_CONST(0.933580458164215)},
                                         {FRAC_CONST(-0.406736701726913), FRAC_CONST(0.913545429706573)},  {FRAC_CONST(-0.453990608453751), FRAC_CONST(0.891006469726563)},
                                         {FRAC_CONST(-0.500000059604645), FRAC_CONST(0.866025388240814)},  {FRAC_CONST(-0.544639050960541), FRAC_CONST(0.838670551776886)},
                                         {FRAC_CONST(-0.587785184383392), FRAC_CONST(0.809017002582550)},  {FRAC_CONST(-0.629320502281189), FRAC_CONST(0.777145862579346)},
                                         {FRAC_CONST(-0.669130682945251), FRAC_CONST(0.743144810199738)},  {FRAC_CONST(-0.707106769084930), FRAC_CONST(0.707106769084930)},
                                         {FRAC_CONST(-0.743144929409027), FRAC_CONST(0.669130444526672)},  {FRAC_CONST(-0.777146041393280), FRAC_CONST(0.629320263862610)},
                                         {FRAC_CONST(-0.809017062187195), FRAC_CONST(0.587785184383392)},  {FRAC_CONST(-0.838670551776886), FRAC_CONST(0.544639050960541)},
                                         {FRAC_CONST(-0.866025388240814), FRAC_CONST(0.500000059604645)},  {FRAC_CONST(-0.891006588935852), FRAC_CONST(0.453990370035172)},
                                         {FRAC_CONST(-0.913545489311218), FRAC_CONST(0.406736582517624)},  {FRAC_CONST(-0.933580458164215), FRAC_CONST(0.358367919921875)},
                                         {FRAC_CONST(-0.951056599617004), FRAC_CONST(0.309016793966293)},  {FRAC_CONST(-0.965925872325897), FRAC_CONST(0.258818924427032)},
                                         {FRAC_CONST(-0.978147625923157), FRAC_CONST(0.207911610603333)},  {FRAC_CONST(-0.987688362598419), FRAC_CONST(0.156434446573257)},
                                         {FRAC_CONST(-0.994521915912628), FRAC_CONST(0.104528494179249)},  {FRAC_CONST(-0.998629570007324), FRAC_CONST(0.052335809916258)},
                                         {FRAC_CONST(-1.000000000000000), FRAC_CONST(-0.000000087422777)}, {FRAC_CONST(-0.998629510402679), FRAC_CONST(-0.052335985004902)},
                                         {FRAC_CONST(-0.994521856307983), FRAC_CONST(-0.104528672993183)}, {FRAC_CONST(-0.987688302993774), FRAC_CONST(-0.156434610486031)},
                                         {FRAC_CONST(-0.978147566318512), FRAC_CONST(-0.207911789417267)}, {FRAC_CONST(-0.965925812721252), FRAC_CONST(-0.258819073438644)},
                                         {FRAC_CONST(-0.951056540012360), FRAC_CONST(-0.309016972780228)}, {FRAC_CONST(-0.933580398559570), FRAC_CONST(-0.358368098735809)},
                                         {FRAC_CONST(-0.913545429706573), FRAC_CONST(-0.406736731529236)}, {FRAC_CONST(-0.891006529331207), FRAC_CONST(-0.453990548849106)},
                                         {FRAC_CONST(-0.866025269031525), FRAC_CONST(-0.500000178813934)}, {FRAC_CONST(-0.838670492172241), FRAC_CONST(-0.544639170169830)},
                                         {FRAC_CONST(-0.809016942977905), FRAC_CONST(-0.587785363197327)}, {FRAC_CONST(-0.777145922183990), FRAC_CONST(-0.629320442676544)},
                                         {FRAC_CONST(-0.743144810199738), FRAC_CONST(-0.669130623340607)}, {FRAC_CONST(-0.707106649875641), FRAC_CONST(-0.707106888294220)},
                                         {FRAC_CONST(-0.669130504131317), FRAC_CONST(-0.743144869804382)}, {FRAC_CONST(-0.629320323467255), FRAC_CONST(-0.777145981788635)},
                                         {FRAC_CONST(-0.587785065174103), FRAC_CONST(-0.809017121791840)}, {FRAC_CONST(-0.544639110565186), FRAC_CONST(-0.838670551776886)},
                                         {FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000)},   {FRAC_CONST(0.996917307376862), FRAC_CONST(0.078459098935127)},
                                         {FRAC_CONST(0.987688362598419), FRAC_CONST(0.156434476375580)},   {FRAC_CONST(0.972369909286499), FRAC_CONST(0.233445376157761)},
                                         {FRAC_CONST(0.951056540012360), FRAC_CONST(0.309017002582550)},   {FRAC_CONST(0.923879504203796), FRAC_CONST(0.382683455944061)},
                                         {FRAC_CONST(0.891006529331207), FRAC_CONST(0.453990519046783)},   {FRAC_CONST(0.852640151977539), FRAC_CONST(0.522498548030853)},
                                         {FRAC_CONST(0.809017002582550), FRAC_CONST(0.587785243988037)},   {FRAC_CONST(0.760405957698822), FRAC_CONST(0.649448096752167)},
                                         {FRAC_CONST(0.707106769084930), FRAC_CONST(0.707106769084930)},   {FRAC_CONST(0.649448037147522), FRAC_CONST(0.760405957698822)},
                                         {FRAC_CONST(0.587785243988037), FRAC_CONST(0.809017002582550)},   {FRAC_CONST(0.522498488426209), FRAC_CONST(0.852640211582184)},
                                         {FRAC_CONST(0.453990519046783), FRAC_CONST(0.891006529331207)},   {FRAC_CONST(0.382683426141739), FRAC_CONST(0.923879504203796)},
                                         {FRAC_CONST(0.309016972780228), FRAC_CONST(0.951056540012360)},   {FRAC_CONST(0.233445301651955), FRAC_CONST(0.972369909286499)},
                                         {FRAC_CONST(0.156434372067451), FRAC_CONST(0.987688362598419)},   {FRAC_CONST(0.078459084033966), FRAC_CONST(0.996917307376862)},
                                         {FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000)},   {FRAC_CONST(0.987688362598419), FRAC_CONST(0.156434476375580)},
                                         {FRAC_CONST(0.951056540012360), FRAC_CONST(0.309017002582550)},   {FRAC_CONST(0.891006529331207), FRAC_CONST(0.453990519046783)},
                                         {FRAC_CONST(0.809017002582550), FRAC_CONST(0.587785243988037)},   {FRAC_CONST(0.707106769084930), FRAC_CONST(0.707106769084930)},
                                         {FRAC_CONST(0.587785243988037), FRAC_CONST(0.809017002582550)},   {FRAC_CONST(0.453990519046783), FRAC_CONST(0.891006529331207)},
                                         {FRAC_CONST(0.309016972780228), FRAC_CONST(0.951056540012360)},   {FRAC_CONST(0.156434372067451), FRAC_CONST(0.987688362598419)},
                                         {FRAC_CONST(-0.000000043711388), FRAC_CONST(1.000000000000000)},  {FRAC_CONST(-0.156434446573257), FRAC_CONST(0.987688362598419)},
                                         {FRAC_CONST(-0.309017032384872), FRAC_CONST(0.951056480407715)},  {FRAC_CONST(-0.453990608453751), FRAC_CONST(0.891006469726563)},
                                         {FRAC_CONST(-0.587785184383392), FRAC_CONST(0.809017002582550)},  {FRAC_CONST(-0.707106769084930), FRAC_CONST(0.707106769084930)},
                                         {FRAC_CONST(-0.809017062187195), FRAC_CONST(0.587785184383392)},  {FRAC_CONST(-0.891006588935852), FRAC_CONST(0.453990370035172)},
                                         {FRAC_CONST(-0.951056599617004), FRAC_CONST(0.309016793966293)},  {FRAC_CONST(-0.987688362598419), FRAC_CONST(0.156434446573257)},
                                         {FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000)},   {FRAC_CONST(0.972369909286499), FRAC_CONST(0.233445376157761)},
                                         {FRAC_CONST(0.891006529331207), FRAC_CONST(0.453990519046783)},   {FRAC_CONST(0.760405957698822), FRAC_CONST(0.649448096752167)},
                                         {FRAC_CONST(0.587785243988037), FRAC_CONST(0.809017002582550)},   {FRAC_CONST(0.382683426141739), FRAC_CONST(0.923879504203796)},
                                         {FRAC_CONST(0.156434372067451), FRAC_CONST(0.987688362598419)},   {FRAC_CONST(-0.078459173440933), FRAC_CONST(0.996917307376862)},
                                         {FRAC_CONST(-0.309017032384872), FRAC_CONST(0.951056480407715)},  {FRAC_CONST(-0.522498667240143), FRAC_CONST(0.852640092372894)},
                                         {FRAC_CONST(-0.707106769084930), FRAC_CONST(0.707106769084930)},  {FRAC_CONST(-0.852640211582184), FRAC_CONST(0.522498488426209)},
                                         {FRAC_CONST(-0.951056599617004), FRAC_CONST(0.309016793966293)},  {FRAC_CONST(-0.996917366981506), FRAC_CONST(0.078459039330482)},
                                         {FRAC_CONST(-0.987688302993774), FRAC_CONST(-0.156434610486031)}, {FRAC_CONST(-0.923879504203796), FRAC_CONST(-0.382683426141739)},
                                         {FRAC_CONST(-0.809016942977905), FRAC_CONST(-0.587785363197327)}, {FRAC_CONST(-0.649447917938232), FRAC_CONST(-0.760406076908112)},
                                         {FRAC_CONST(-0.453990221023560), FRAC_CONST(-0.891006648540497)}, {FRAC_CONST(-0.233445450663567), FRAC_CONST(-0.972369909286499)},
                                         {FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000)},   {FRAC_CONST(0.951056540012360), FRAC_CONST(0.309017002582550)},
                                         {FRAC_CONST(0.809017002582550), FRAC_CONST(0.587785243988037)},   {FRAC_CONST(0.587785243988037), FRAC_CONST(0.809017002582550)},
                                         {FRAC_CONST(0.309016972780228), FRAC_CONST(0.951056540012360)},   {FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000)},
                                         {FRAC_CONST(0.809017002582550), FRAC_CONST(0.587785243988037)},   {FRAC_CONST(0.309016972780228), FRAC_CONST(0.951056540012360)},
                                         {FRAC_CONST(-0.309017032384872), FRAC_CONST(0.951056480407715)},  {FRAC_CONST(-0.809017062187195), FRAC_CONST(0.587785184383392)},
                                         {FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000)},   {FRAC_CONST(0.587785243988037), FRAC_CONST(0.809017002582550)},
                                         {FRAC_CONST(-0.309017032384872), FRAC_CONST(0.951056480407715)},  {FRAC_CONST(-0.951056599617004), FRAC_CONST(0.309016793966293)},
                                         {FRAC_CONST(-0.809016942977905), FRAC_CONST(-0.587785363197327)}, {FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000)},
                                         {FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000)},   {FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000)},
                                         {FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000)},   {FRAC_CONST(0.309017121791840), FRAC_CONST(-0.951056480407715)}};
    #endif // ALLOW_SMALL_FRAMELENGTH
#endif     // FIXED_POINT
// ——————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
#ifdef FIXED_POINT
static const complex_t cfft_tab_64[] = {{FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000)},   {FRAC_CONST(0.995184719562531), FRAC_CONST(0.098017141222954)},
                                        {FRAC_CONST(0.980785250663757), FRAC_CONST(0.195090323686600)},   {FRAC_CONST(0.956940352916718), FRAC_CONST(0.290284663438797)},
                                        {FRAC_CONST(0.923879504203796), FRAC_CONST(0.382683455944061)},   {FRAC_CONST(0.881921231746674), FRAC_CONST(0.471396744251251)},
                                        {FRAC_CONST(0.831469595432281), FRAC_CONST(0.555570244789124)},   {FRAC_CONST(0.773010432720184), FRAC_CONST(0.634393334388733)},
                                        {FRAC_CONST(0.707106769084930), FRAC_CONST(0.707106769084930)},   {FRAC_CONST(0.634393274784088), FRAC_CONST(0.773010432720184)},
                                        {FRAC_CONST(0.555570185184479), FRAC_CONST(0.831469655036926)},   {FRAC_CONST(0.471396654844284), FRAC_CONST(0.881921291351318)},
                                        {FRAC_CONST(0.382683426141739), FRAC_CONST(0.923879504203796)},   {FRAC_CONST(0.290284633636475), FRAC_CONST(0.956940352916718)},
                                        {FRAC_CONST(0.195090234279633), FRAC_CONST(0.980785310268402)},   {FRAC_CONST(0.098017133772373), FRAC_CONST(0.995184719562531)},
                                        {FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000)},   {FRAC_CONST(0.980785250663757), FRAC_CONST(0.195090323686600)},
                                        {FRAC_CONST(0.923879504203796), FRAC_CONST(0.382683455944061)},   {FRAC_CONST(0.831469595432281), FRAC_CONST(0.555570244789124)},
                                        {FRAC_CONST(0.707106769084930), FRAC_CONST(0.707106769084930)},   {FRAC_CONST(0.555570185184479), FRAC_CONST(0.831469655036926)},
                                        {FRAC_CONST(0.382683426141739), FRAC_CONST(0.923879504203796)},   {FRAC_CONST(0.195090234279633), FRAC_CONST(0.980785310268402)},
                                        {FRAC_CONST(-0.000000043711388), FRAC_CONST(1.000000000000000)},  {FRAC_CONST(-0.195090323686600), FRAC_CONST(0.980785250663757)},
                                        {FRAC_CONST(-0.382683515548706), FRAC_CONST(0.923879504203796)},  {FRAC_CONST(-0.555570363998413), FRAC_CONST(0.831469535827637)},
                                        {FRAC_CONST(-0.707106769084930), FRAC_CONST(0.707106769084930)},  {FRAC_CONST(-0.831469655036926), FRAC_CONST(0.555570185184479)},
                                        {FRAC_CONST(-0.923879623413086), FRAC_CONST(0.382683277130127)},  {FRAC_CONST(-0.980785310268402), FRAC_CONST(0.195090308785439)},
                                        {FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000)},   {FRAC_CONST(0.956940352916718), FRAC_CONST(0.290284663438797)},
                                        {FRAC_CONST(0.831469595432281), FRAC_CONST(0.555570244789124)},   {FRAC_CONST(0.634393274784088), FRAC_CONST(0.773010432720184)},
                                        {FRAC_CONST(0.382683426141739), FRAC_CONST(0.923879504203796)},   {FRAC_CONST(0.098017133772373), FRAC_CONST(0.995184719562531)},
                                        {FRAC_CONST(-0.195090323686600), FRAC_CONST(0.980785250663757)},  {FRAC_CONST(-0.471396833658218), FRAC_CONST(0.881921231746674)},
                                        {FRAC_CONST(-0.707106769084930), FRAC_CONST(0.707106769084930)},  {FRAC_CONST(-0.881921231746674), FRAC_CONST(0.471396833658218)},
                                        {FRAC_CONST(-0.980785310268402), FRAC_CONST(0.195090308785439)},  {FRAC_CONST(-0.995184719562531), FRAC_CONST(-0.098017267882824)},
                                        {FRAC_CONST(-0.923879504203796), FRAC_CONST(-0.382683426141739)}, {FRAC_CONST(-0.773010551929474), FRAC_CONST(-0.634393215179443)},
                                        {FRAC_CONST(-0.555570006370544), FRAC_CONST(-0.831469774246216)}, {FRAC_CONST(-0.290284544229507), FRAC_CONST(-0.956940352916718)},
                                        {FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000)},   {FRAC_CONST(0.923879504203796), FRAC_CONST(0.382683455944061)},
                                        {FRAC_CONST(0.707106769084930), FRAC_CONST(0.707106769084930)},   {FRAC_CONST(0.382683426141739), FRAC_CONST(0.923879504203796)},
                                        {FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000)},   {FRAC_CONST(0.707106769084930), FRAC_CONST(0.707106769084930)},
                                        {FRAC_CONST(-0.000000043711388), FRAC_CONST(1.000000000000000)},  {FRAC_CONST(-0.707106769084930), FRAC_CONST(0.707106769084930)},
                                        {FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000)},   {FRAC_CONST(0.382683426141739), FRAC_CONST(0.923879504203796)},
                                        {FRAC_CONST(-0.707106769084930), FRAC_CONST(0.707106769084930)},  {FRAC_CONST(-0.923879504203796), FRAC_CONST(-0.382683426141739)},
                                        {FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000)},   {FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000)},
                                        {FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000)},   {FRAC_CONST(0.000000011924881), FRAC_CONST(-1.000000000000000)}};
#endif // FIXED POINT
// ——————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
#ifdef FIXED_POINT
    #ifdef ALLOW_SMALL_FRAMELENGTH
static const complex_t cfft_tab_60[] = {{FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000)},   {FRAC_CONST(0.994521915912628), FRAC_CONST(0.104528464376926)},
                                        {FRAC_CONST(0.978147625923157), FRAC_CONST(0.207911700010300)},   {FRAC_CONST(0.951056540012360), FRAC_CONST(0.309017002582550)},
                                        {FRAC_CONST(0.913545429706573), FRAC_CONST(0.406736642122269)},   {FRAC_CONST(0.866025388240814), FRAC_CONST(0.500000000000000)},
                                        {FRAC_CONST(0.809017002582550), FRAC_CONST(0.587785243988037)},   {FRAC_CONST(0.743144810199738), FRAC_CONST(0.669130623340607)},
                                        {FRAC_CONST(0.669130563735962), FRAC_CONST(0.743144869804382)},   {FRAC_CONST(0.587785243988037), FRAC_CONST(0.809017002582550)},
                                        {FRAC_CONST(0.499999970197678), FRAC_CONST(0.866025447845459)},   {FRAC_CONST(0.406736612319946), FRAC_CONST(0.913545489311218)},
                                        {FRAC_CONST(0.309016972780228), FRAC_CONST(0.951056540012360)},   {FRAC_CONST(0.207911655306816), FRAC_CONST(0.978147625923157)},
                                        {FRAC_CONST(0.104528419673443), FRAC_CONST(0.994521915912628)},   {FRAC_CONST(-0.000000043711388), FRAC_CONST(1.000000000000000)},
                                        {FRAC_CONST(-0.104528509080410), FRAC_CONST(0.994521915912628)},  {FRAC_CONST(-0.207911744713783), FRAC_CONST(0.978147566318512)},
                                        {FRAC_CONST(-0.309017032384872), FRAC_CONST(0.951056480407715)},  {FRAC_CONST(-0.406736701726913), FRAC_CONST(0.913545429706573)},
                                        {FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000)},   {FRAC_CONST(0.978147625923157), FRAC_CONST(0.207911700010300)},
                                        {FRAC_CONST(0.913545429706573), FRAC_CONST(0.406736642122269)},   {FRAC_CONST(0.809017002582550), FRAC_CONST(0.587785243988037)},
                                        {FRAC_CONST(0.669130563735962), FRAC_CONST(0.743144869804382)},   {FRAC_CONST(0.499999970197678), FRAC_CONST(0.866025447845459)},
                                        {FRAC_CONST(0.309016972780228), FRAC_CONST(0.951056540012360)},   {FRAC_CONST(0.104528419673443), FRAC_CONST(0.994521915912628)},
                                        {FRAC_CONST(-0.104528509080410), FRAC_CONST(0.994521915912628)},  {FRAC_CONST(-0.309017032384872), FRAC_CONST(0.951056480407715)},
                                        {FRAC_CONST(-0.500000059604645), FRAC_CONST(0.866025388240814)},  {FRAC_CONST(-0.669130682945251), FRAC_CONST(0.743144810199738)},
                                        {FRAC_CONST(-0.809017062187195), FRAC_CONST(0.587785184383392)},  {FRAC_CONST(-0.913545489311218), FRAC_CONST(0.406736582517624)},
                                        {FRAC_CONST(-0.978147625923157), FRAC_CONST(0.207911610603333)},  {FRAC_CONST(-1.000000000000000), FRAC_CONST(-0.000000087422777)},
                                        {FRAC_CONST(-0.978147566318512), FRAC_CONST(-0.207911789417267)}, {FRAC_CONST(-0.913545429706573), FRAC_CONST(-0.406736731529236)},
                                        {FRAC_CONST(-0.809016942977905), FRAC_CONST(-0.587785363197327)}, {FRAC_CONST(-0.669130504131317), FRAC_CONST(-0.743144869804382)},
                                        {FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000)},   {FRAC_CONST(0.951056540012360), FRAC_CONST(0.309017002582550)},
                                        {FRAC_CONST(0.809017002582550), FRAC_CONST(0.587785243988037)},   {FRAC_CONST(0.587785243988037), FRAC_CONST(0.809017002582550)},
                                        {FRAC_CONST(0.309016972780228), FRAC_CONST(0.951056540012360)},   {FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000)},
                                        {FRAC_CONST(0.809017002582550), FRAC_CONST(0.587785243988037)},   {FRAC_CONST(0.309016972780228), FRAC_CONST(0.951056540012360)},
                                        {FRAC_CONST(-0.309017032384872), FRAC_CONST(0.951056480407715)},  {FRAC_CONST(-0.809017062187195), FRAC_CONST(0.587785184383392)},
                                        {FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000)},   {FRAC_CONST(0.587785243988037), FRAC_CONST(0.809017002582550)},
                                        {FRAC_CONST(-0.309017032384872), FRAC_CONST(0.951056480407715)},  {FRAC_CONST(-0.951056599617004), FRAC_CONST(0.309016793966293)},
                                        {FRAC_CONST(-0.809016942977905), FRAC_CONST(-0.587785363197327)}, {FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000)},
                                        {FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000)},   {FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000)},
                                        {FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000)},   {FRAC_CONST(0.309017121791840), FRAC_CONST(-0.951056480407715)}};
    #endif // ALLOW_SMALL_FRAMELENGTH
#endif     // FIXED POINT
// ——————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
#ifdef FIXED_POINT
    #ifdef LD_DEC
static const complex_t cfft_tab_256[] = {{FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000)},   {FRAC_CONST(0.999698817729950), FRAC_CONST(0.024541229009628)},
                                         {FRAC_CONST(0.998795449733734), FRAC_CONST(0.049067676067352)},   {FRAC_CONST(0.997290432453156), FRAC_CONST(0.073564566671848)},
                                         {FRAC_CONST(0.995184719562531), FRAC_CONST(0.098017141222954)},   {FRAC_CONST(0.992479562759399), FRAC_CONST(0.122410677373409)},
                                         {FRAC_CONST(0.989176511764526), FRAC_CONST(0.146730467677116)},   {FRAC_CONST(0.985277652740479), FRAC_CONST(0.170961901545525)},
                                         {FRAC_CONST(0.980785250663757), FRAC_CONST(0.195090323686600)},   {FRAC_CONST(0.975702106952667), FRAC_CONST(0.219101235270500)},
                                         {FRAC_CONST(0.970031261444092), FRAC_CONST(0.242980197072029)},   {FRAC_CONST(0.963776051998138), FRAC_CONST(0.266712784767151)},
                                         {FRAC_CONST(0.956940352916718), FRAC_CONST(0.290284663438797)},   {FRAC_CONST(0.949528157711029), FRAC_CONST(0.313681751489639)},
                                         {FRAC_CONST(0.941544055938721), FRAC_CONST(0.336889863014221)},   {FRAC_CONST(0.932992815971375), FRAC_CONST(0.359895050525665)},
                                         {FRAC_CONST(0.923879504203796), FRAC_CONST(0.382683455944061)},   {FRAC_CONST(0.914209723472595), FRAC_CONST(0.405241340398788)},
                                         {FRAC_CONST(0.903989315032959), FRAC_CONST(0.427555084228516)},   {FRAC_CONST(0.893224298954010), FRAC_CONST(0.449611335992813)},
                                         {FRAC_CONST(0.881921231746674), FRAC_CONST(0.471396744251251)},   {FRAC_CONST(0.870086967945099), FRAC_CONST(0.492898225784302)},
                                         {FRAC_CONST(0.857728600502014), FRAC_CONST(0.514102756977081)},   {FRAC_CONST(0.844853579998016), FRAC_CONST(0.534997642040253)},
                                         {FRAC_CONST(0.831469595432281), FRAC_CONST(0.555570244789124)},   {FRAC_CONST(0.817584812641144), FRAC_CONST(0.575808227062225)},
                                         {FRAC_CONST(0.803207516670227), FRAC_CONST(0.595699310302734)},   {FRAC_CONST(0.788346409797668), FRAC_CONST(0.615231633186340)},
                                         {FRAC_CONST(0.773010432720184), FRAC_CONST(0.634393334388733)},   {FRAC_CONST(0.757208824157715), FRAC_CONST(0.653172850608826)},
                                         {FRAC_CONST(0.740951120853424), FRAC_CONST(0.671558976173401)},   {FRAC_CONST(0.724247097969055), FRAC_CONST(0.689540565013886)},
                                         {FRAC_CONST(0.707106769084930), FRAC_CONST(0.707106769084930)},   {FRAC_CONST(0.689540505409241), FRAC_CONST(0.724247097969055)},
                                         {FRAC_CONST(0.671558916568756), FRAC_CONST(0.740951180458069)},   {FRAC_CONST(0.653172791004181), FRAC_CONST(0.757208883762360)},
                                         {FRAC_CONST(0.634393274784088), FRAC_CONST(0.773010432720184)},   {FRAC_CONST(0.615231573581696), FRAC_CONST(0.788346409797668)},
                                         {FRAC_CONST(0.595699310302734), FRAC_CONST(0.803207516670227)},   {FRAC_CONST(0.575808167457581), FRAC_CONST(0.817584812641144)},
                                         {FRAC_CONST(0.555570185184479), FRAC_CONST(0.831469655036926)},   {FRAC_CONST(0.534997642040253), FRAC_CONST(0.844853579998016)},
                                         {FRAC_CONST(0.514102697372437), FRAC_CONST(0.857728660106659)},   {FRAC_CONST(0.492898195981979), FRAC_CONST(0.870086967945099)},
                                         {FRAC_CONST(0.471396654844284), FRAC_CONST(0.881921291351318)},   {FRAC_CONST(0.449611306190491), FRAC_CONST(0.893224298954010)},
                                         {FRAC_CONST(0.427555114030838), FRAC_CONST(0.903989315032959)},   {FRAC_CONST(0.405241280794144), FRAC_CONST(0.914209783077240)},
                                         {FRAC_CONST(0.382683426141739), FRAC_CONST(0.923879504203796)},   {FRAC_CONST(0.359894961118698), FRAC_CONST(0.932992815971375)},
                                         {FRAC_CONST(0.336889833211899), FRAC_CONST(0.941544055938721)},   {FRAC_CONST(0.313681662082672), FRAC_CONST(0.949528217315674)},
                                         {FRAC_CONST(0.290284633636475), FRAC_CONST(0.956940352916718)},   {FRAC_CONST(0.266712754964828), FRAC_CONST(0.963776051998138)},
                                         {FRAC_CONST(0.242980122566223), FRAC_CONST(0.970031261444092)},   {FRAC_CONST(0.219101220369339), FRAC_CONST(0.975702106952667)},
                                         {FRAC_CONST(0.195090234279633), FRAC_CONST(0.980785310268402)},   {FRAC_CONST(0.170961856842041), FRAC_CONST(0.985277652740479)},
                                         {FRAC_CONST(0.146730497479439), FRAC_CONST(0.989176511764526)},   {FRAC_CONST(0.122410625219345), FRAC_CONST(0.992479562759399)},
                                         {FRAC_CONST(0.098017133772373), FRAC_CONST(0.995184719562531)},   {FRAC_CONST(0.073564492166042), FRAC_CONST(0.997290432453156)},
                                         {FRAC_CONST(0.049067649990320), FRAC_CONST(0.998795449733734)},   {FRAC_CONST(0.024541135877371), FRAC_CONST(0.999698817729950)},
                                         {FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000)},   {FRAC_CONST(0.998795449733734), FRAC_CONST(0.049067676067352)},
                                         {FRAC_CONST(0.995184719562531), FRAC_CONST(0.098017141222954)},   {FRAC_CONST(0.989176511764526), FRAC_CONST(0.146730467677116)},
                                         {FRAC_CONST(0.980785250663757), FRAC_CONST(0.195090323686600)},   {FRAC_CONST(0.970031261444092), FRAC_CONST(0.242980197072029)},
                                         {FRAC_CONST(0.956940352916718), FRAC_CONST(0.290284663438797)},   {FRAC_CONST(0.941544055938721), FRAC_CONST(0.336889863014221)},
                                         {FRAC_CONST(0.923879504203796), FRAC_CONST(0.382683455944061)},   {FRAC_CONST(0.903989315032959), FRAC_CONST(0.427555084228516)},
                                         {FRAC_CONST(0.881921231746674), FRAC_CONST(0.471396744251251)},   {FRAC_CONST(0.857728600502014), FRAC_CONST(0.514102756977081)},
                                         {FRAC_CONST(0.831469595432281), FRAC_CONST(0.555570244789124)},   {FRAC_CONST(0.803207516670227), FRAC_CONST(0.595699310302734)},
                                         {FRAC_CONST(0.773010432720184), FRAC_CONST(0.634393334388733)},   {FRAC_CONST(0.740951120853424), FRAC_CONST(0.671558976173401)},
                                         {FRAC_CONST(0.707106769084930), FRAC_CONST(0.707106769084930)},   {FRAC_CONST(0.671558916568756), FRAC_CONST(0.740951180458069)},
                                         {FRAC_CONST(0.634393274784088), FRAC_CONST(0.773010432720184)},   {FRAC_CONST(0.595699310302734), FRAC_CONST(0.803207516670227)},
                                         {FRAC_CONST(0.555570185184479), FRAC_CONST(0.831469655036926)},   {FRAC_CONST(0.514102697372437), FRAC_CONST(0.857728660106659)},
                                         {FRAC_CONST(0.471396654844284), FRAC_CONST(0.881921291351318)},   {FRAC_CONST(0.427555114030838), FRAC_CONST(0.903989315032959)},
                                         {FRAC_CONST(0.382683426141739), FRAC_CONST(0.923879504203796)},   {FRAC_CONST(0.336889833211899), FRAC_CONST(0.941544055938721)},
                                         {FRAC_CONST(0.290284633636475), FRAC_CONST(0.956940352916718)},   {FRAC_CONST(0.242980122566223), FRAC_CONST(0.970031261444092)},
                                         {FRAC_CONST(0.195090234279633), FRAC_CONST(0.980785310268402)},   {FRAC_CONST(0.146730497479439), FRAC_CONST(0.989176511764526)},
                                         {FRAC_CONST(0.098017133772373), FRAC_CONST(0.995184719562531)},   {FRAC_CONST(0.049067649990320), FRAC_CONST(0.998795449733734)},
                                         {FRAC_CONST(-0.000000043711388), FRAC_CONST(1.000000000000000)},  {FRAC_CONST(-0.049067739397287), FRAC_CONST(0.998795449733734)},
                                         {FRAC_CONST(-0.098017223179340), FRAC_CONST(0.995184719562531)},  {FRAC_CONST(-0.146730571985245), FRAC_CONST(0.989176511764526)},
                                         {FRAC_CONST(-0.195090323686600), FRAC_CONST(0.980785250663757)},  {FRAC_CONST(-0.242980197072029), FRAC_CONST(0.970031261444092)},
                                         {FRAC_CONST(-0.290284723043442), FRAC_CONST(0.956940293312073)},  {FRAC_CONST(-0.336889922618866), FRAC_CONST(0.941544055938721)},
                                         {FRAC_CONST(-0.382683515548706), FRAC_CONST(0.923879504203796)},  {FRAC_CONST(-0.427555084228516), FRAC_CONST(0.903989315032959)},
                                         {FRAC_CONST(-0.471396833658218), FRAC_CONST(0.881921231746674)},  {FRAC_CONST(-0.514102756977081), FRAC_CONST(0.857728600502014)},
                                         {FRAC_CONST(-0.555570363998413), FRAC_CONST(0.831469535827637)},  {FRAC_CONST(-0.595699369907379), FRAC_CONST(0.803207516670227)},
                                         {FRAC_CONST(-0.634393274784088), FRAC_CONST(0.773010492324829)},  {FRAC_CONST(-0.671559035778046), FRAC_CONST(0.740951061248779)},
                                         {FRAC_CONST(-0.707106769084930), FRAC_CONST(0.707106769084930)},  {FRAC_CONST(-0.740951240062714), FRAC_CONST(0.671558856964111)},
                                         {FRAC_CONST(-0.773010492324829), FRAC_CONST(0.634393274784088)},  {FRAC_CONST(-0.803207635879517), FRAC_CONST(0.595699131488800)},
                                         {FRAC_CONST(-0.831469655036926), FRAC_CONST(0.555570185184479)},  {FRAC_CONST(-0.857728600502014), FRAC_CONST(0.514102756977081)},
                                         {FRAC_CONST(-0.881921350955963), FRAC_CONST(0.471396625041962)},  {FRAC_CONST(-0.903989315032959), FRAC_CONST(0.427555054426193)},
                                         {FRAC_CONST(-0.923879623413086), FRAC_CONST(0.382683277130127)},  {FRAC_CONST(-0.941544115543365), FRAC_CONST(0.336889803409576)},
                                         {FRAC_CONST(-0.956940352916718), FRAC_CONST(0.290284723043442)},  {FRAC_CONST(-0.970031261444092), FRAC_CONST(0.242980077862740)},
                                         {FRAC_CONST(-0.980785310268402), FRAC_CONST(0.195090308785439)},  {FRAC_CONST(-0.989176511764526), FRAC_CONST(0.146730333566666)},
                                         {FRAC_CONST(-0.995184719562531), FRAC_CONST(0.098017096519470)},  {FRAC_CONST(-0.998795449733734), FRAC_CONST(0.049067486077547)},
                                         {FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000)},   {FRAC_CONST(0.997290432453156), FRAC_CONST(0.073564566671848)},
                                         {FRAC_CONST(0.989176511764526), FRAC_CONST(0.146730467677116)},   {FRAC_CONST(0.975702106952667), FRAC_CONST(0.219101235270500)},
                                         {FRAC_CONST(0.956940352916718), FRAC_CONST(0.290284663438797)},   {FRAC_CONST(0.932992815971375), FRAC_CONST(0.359895050525665)},
                                         {FRAC_CONST(0.903989315032959), FRAC_CONST(0.427555084228516)},   {FRAC_CONST(0.870086967945099), FRAC_CONST(0.492898225784302)},
                                         {FRAC_CONST(0.831469595432281), FRAC_CONST(0.555570244789124)},   {FRAC_CONST(0.788346469402313), FRAC_CONST(0.615231573581696)},
                                         {FRAC_CONST(0.740951120853424), FRAC_CONST(0.671558976173401)},   {FRAC_CONST(0.689540505409241), FRAC_CONST(0.724247097969055)},
                                         {FRAC_CONST(0.634393274784088), FRAC_CONST(0.773010432720184)},   {FRAC_CONST(0.575808227062225), FRAC_CONST(0.817584812641144)},
                                         {FRAC_CONST(0.514102697372437), FRAC_CONST(0.857728660106659)},   {FRAC_CONST(0.449611306190491), FRAC_CONST(0.893224298954010)},
                                         {FRAC_CONST(0.382683426141739), FRAC_CONST(0.923879504203796)},   {FRAC_CONST(0.313681751489639), FRAC_CONST(0.949528157711029)},
                                         {FRAC_CONST(0.242980241775513), FRAC_CONST(0.970031261444092)},   {FRAC_CONST(0.170961856842041), FRAC_CONST(0.985277652740479)},
                                         {FRAC_CONST(0.098017133772373), FRAC_CONST(0.995184719562531)},   {FRAC_CONST(0.024541255086660), FRAC_CONST(0.999698817729950)},
                                         {FRAC_CONST(-0.049067739397287), FRAC_CONST(0.998795449733734)},  {FRAC_CONST(-0.122410707175732), FRAC_CONST(0.992479503154755)},
                                         {FRAC_CONST(-0.195090323686600), FRAC_CONST(0.980785250663757)},  {FRAC_CONST(-0.266712725162506), FRAC_CONST(0.963776051998138)},
                                         {FRAC_CONST(-0.336889803409576), FRAC_CONST(0.941544055938721)},  {FRAC_CONST(-0.405241340398788), FRAC_CONST(0.914209723472595)},
                                         {FRAC_CONST(-0.471396833658218), FRAC_CONST(0.881921231746674)},  {FRAC_CONST(-0.534997701644897), FRAC_CONST(0.844853520393372)},
                                         {FRAC_CONST(-0.595699369907379), FRAC_CONST(0.803207516670227)},  {FRAC_CONST(-0.653172850608826), FRAC_CONST(0.757208824157715)},
                                         {FRAC_CONST(-0.707106769084930), FRAC_CONST(0.707106769084930)},  {FRAC_CONST(-0.757208824157715), FRAC_CONST(0.653172850608826)},
                                         {FRAC_CONST(-0.803207516670227), FRAC_CONST(0.595699369907379)},  {FRAC_CONST(-0.844853520393372), FRAC_CONST(0.534997701644897)},
                                         {FRAC_CONST(-0.881921231746674), FRAC_CONST(0.471396833658218)},  {FRAC_CONST(-0.914209783077240), FRAC_CONST(0.405241221189499)},
                                         {FRAC_CONST(-0.941544115543365), FRAC_CONST(0.336889803409576)},  {FRAC_CONST(-0.963776051998138), FRAC_CONST(0.266712725162506)},
                                         {FRAC_CONST(-0.980785310268402), FRAC_CONST(0.195090308785439)},  {FRAC_CONST(-0.992479503154755), FRAC_CONST(0.122410699725151)},
                                         {FRAC_CONST(-0.998795449733734), FRAC_CONST(0.049067724496126)},  {FRAC_CONST(-0.999698817729950), FRAC_CONST(-0.024541147053242)},
                                         {FRAC_CONST(-0.995184719562531), FRAC_CONST(-0.098017267882824)}, {FRAC_CONST(-0.985277652740479), FRAC_CONST(-0.170961990952492)},
                                         {FRAC_CONST(-0.970031261444092), FRAC_CONST(-0.242980241775513)}, {FRAC_CONST(-0.949528157711029), FRAC_CONST(-0.313681781291962)},
                                         {FRAC_CONST(-0.923879504203796), FRAC_CONST(-0.382683426141739)}, {FRAC_CONST(-0.893224298954010), FRAC_CONST(-0.449611306190491)},
                                         {FRAC_CONST(-0.857728660106659), FRAC_CONST(-0.514102697372437)}, {FRAC_CONST(-0.817584872245789), FRAC_CONST(-0.575808107852936)},
                                         {FRAC_CONST(-0.773010551929474), FRAC_CONST(-0.634393215179443)}, {FRAC_CONST(-0.724247038364410), FRAC_CONST(-0.689540624618530)},
                                         {FRAC_CONST(-0.671558916568756), FRAC_CONST(-0.740951180458069)}, {FRAC_CONST(-0.615231573581696), FRAC_CONST(-0.788346469402313)},
                                         {FRAC_CONST(-0.555570006370544), FRAC_CONST(-0.831469774246216)}, {FRAC_CONST(-0.492898195981979), FRAC_CONST(-0.870086967945099)},
                                         {FRAC_CONST(-0.427554935216904), FRAC_CONST(-0.903989374637604)}, {FRAC_CONST(-0.359895110130310), FRAC_CONST(-0.932992756366730)},
                                         {FRAC_CONST(-0.290284544229507), FRAC_CONST(-0.956940352916718)}, {FRAC_CONST(-0.219101369380951), FRAC_CONST(-0.975702106952667)},
                                         {FRAC_CONST(-0.146730408072472), FRAC_CONST(-0.989176511764526)}, {FRAC_CONST(-0.073564760386944), FRAC_CONST(-0.997290432453156)},
                                         {FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000)},   {FRAC_CONST(0.995184719562531), FRAC_CONST(0.098017141222954)},
                                         {FRAC_CONST(0.980785250663757), FRAC_CONST(0.195090323686600)},   {FRAC_CONST(0.956940352916718), FRAC_CONST(0.290284663438797)},
                                         {FRAC_CONST(0.923879504203796), FRAC_CONST(0.382683455944061)},   {FRAC_CONST(0.881921231746674), FRAC_CONST(0.471396744251251)},
                                         {FRAC_CONST(0.831469595432281), FRAC_CONST(0.555570244789124)},   {FRAC_CONST(0.773010432720184), FRAC_CONST(0.634393334388733)},
                                         {FRAC_CONST(0.707106769084930), FRAC_CONST(0.707106769084930)},   {FRAC_CONST(0.634393274784088), FRAC_CONST(0.773010432720184)},
                                         {FRAC_CONST(0.555570185184479), FRAC_CONST(0.831469655036926)},   {FRAC_CONST(0.471396654844284), FRAC_CONST(0.881921291351318)},
                                         {FRAC_CONST(0.382683426141739), FRAC_CONST(0.923879504203796)},   {FRAC_CONST(0.290284633636475), FRAC_CONST(0.956940352916718)},
                                         {FRAC_CONST(0.195090234279633), FRAC_CONST(0.980785310268402)},   {FRAC_CONST(0.098017133772373), FRAC_CONST(0.995184719562531)},
                                         {FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000)},   {FRAC_CONST(0.980785250663757), FRAC_CONST(0.195090323686600)},
                                         {FRAC_CONST(0.923879504203796), FRAC_CONST(0.382683455944061)},   {FRAC_CONST(0.831469595432281), FRAC_CONST(0.555570244789124)},
                                         {FRAC_CONST(0.707106769084930), FRAC_CONST(0.707106769084930)},   {FRAC_CONST(0.555570185184479), FRAC_CONST(0.831469655036926)},
                                         {FRAC_CONST(0.382683426141739), FRAC_CONST(0.923879504203796)},   {FRAC_CONST(0.195090234279633), FRAC_CONST(0.980785310268402)},
                                         {FRAC_CONST(-0.000000043711388), FRAC_CONST(1.000000000000000)},  {FRAC_CONST(-0.195090323686600), FRAC_CONST(0.980785250663757)},
                                         {FRAC_CONST(-0.382683515548706), FRAC_CONST(0.923879504203796)},  {FRAC_CONST(-0.555570363998413), FRAC_CONST(0.831469535827637)},
                                         {FRAC_CONST(-0.707106769084930), FRAC_CONST(0.707106769084930)},  {FRAC_CONST(-0.831469655036926), FRAC_CONST(0.555570185184479)},
                                         {FRAC_CONST(-0.923879623413086), FRAC_CONST(0.382683277130127)},  {FRAC_CONST(-0.980785310268402), FRAC_CONST(0.195090308785439)},
                                         {FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000)},   {FRAC_CONST(0.956940352916718), FRAC_CONST(0.290284663438797)},
                                         {FRAC_CONST(0.831469595432281), FRAC_CONST(0.555570244789124)},   {FRAC_CONST(0.634393274784088), FRAC_CONST(0.773010432720184)},
                                         {FRAC_CONST(0.382683426141739), FRAC_CONST(0.923879504203796)},   {FRAC_CONST(0.098017133772373), FRAC_CONST(0.995184719562531)},
                                         {FRAC_CONST(-0.195090323686600), FRAC_CONST(0.980785250663757)},  {FRAC_CONST(-0.471396833658218), FRAC_CONST(0.881921231746674)},
                                         {FRAC_CONST(-0.707106769084930), FRAC_CONST(0.707106769084930)},  {FRAC_CONST(-0.881921231746674), FRAC_CONST(0.471396833658218)},
                                         {FRAC_CONST(-0.980785310268402), FRAC_CONST(0.195090308785439)},  {FRAC_CONST(-0.995184719562531), FRAC_CONST(-0.098017267882824)},
                                         {FRAC_CONST(-0.923879504203796), FRAC_CONST(-0.382683426141739)}, {FRAC_CONST(-0.773010551929474), FRAC_CONST(-0.634393215179443)},
                                         {FRAC_CONST(-0.555570006370544), FRAC_CONST(-0.831469774246216)}, {FRAC_CONST(-0.290284544229507), FRAC_CONST(-0.956940352916718)},
                                         {FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000)},   {FRAC_CONST(0.923879504203796), FRAC_CONST(0.382683455944061)},
                                         {FRAC_CONST(0.707106769084930), FRAC_CONST(0.707106769084930)},   {FRAC_CONST(0.382683426141739), FRAC_CONST(0.923879504203796)},
                                         {FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000)},   {FRAC_CONST(0.707106769084930), FRAC_CONST(0.707106769084930)},
                                         {FRAC_CONST(-0.000000043711388), FRAC_CONST(1.000000000000000)},  {FRAC_CONST(-0.707106769084930), FRAC_CONST(0.707106769084930)},
                                         {FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000)},   {FRAC_CONST(0.382683426141739), FRAC_CONST(0.923879504203796)},
                                         {FRAC_CONST(-0.707106769084930), FRAC_CONST(0.707106769084930)},  {FRAC_CONST(-0.923879504203796), FRAC_CONST(-0.382683426141739)},
                                         {FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000)},   {FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000)},
                                         {FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000)},   {FRAC_CONST(0.000000011924881), FRAC_CONST(-1.000000000000000)}};
    #endif // LD_DEC
#endif     // FIXED POINT
// ——————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
#ifdef FIXED_POINT
    #ifdef LD_DEC
        #ifdef ALLOW_SMALL_FRAMELENGTH
static const complex_t cfft_tab_240[] = {{FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000)},   {FRAC_CONST(0.999657332897186), FRAC_CONST(0.026176949962974)},
                                         {FRAC_CONST(0.998629510402679), FRAC_CONST(0.052335958927870)},   {FRAC_CONST(0.996917307376862), FRAC_CONST(0.078459098935127)},
                                         {FRAC_CONST(0.994521915912628), FRAC_CONST(0.104528464376926)},   {FRAC_CONST(0.991444885730743), FRAC_CONST(0.130526199936867)},
                                         {FRAC_CONST(0.987688362598419), FRAC_CONST(0.156434476375580)},   {FRAC_CONST(0.983254909515381), FRAC_CONST(0.182235524058342)},
                                         {FRAC_CONST(0.978147625923157), FRAC_CONST(0.207911700010300)},   {FRAC_CONST(0.972369909286499), FRAC_CONST(0.233445376157761)},
                                         {FRAC_CONST(0.965925812721252), FRAC_CONST(0.258819043636322)},   {FRAC_CONST(0.958819746971130), FRAC_CONST(0.284015357494354)},
                                         {FRAC_CONST(0.951056540012360), FRAC_CONST(0.309017002582550)},   {FRAC_CONST(0.942641496658325), FRAC_CONST(0.333806872367859)},
                                         {FRAC_CONST(0.933580398559570), FRAC_CONST(0.358367949724197)},   {FRAC_CONST(0.923879504203796), FRAC_CONST(0.382683455944061)},
                                         {FRAC_CONST(0.913545429706573), FRAC_CONST(0.406736642122269)},   {FRAC_CONST(0.902585268020630), FRAC_CONST(0.430511116981506)},
                                         {FRAC_CONST(0.891006529331207), FRAC_CONST(0.453990519046783)},   {FRAC_CONST(0.878817081451416), FRAC_CONST(0.477158784866333)},
                                         {FRAC_CONST(0.866025388240814), FRAC_CONST(0.500000000000000)},   {FRAC_CONST(0.852640151977539), FRAC_CONST(0.522498548030853)},
                                         {FRAC_CONST(0.838670551776886), FRAC_CONST(0.544639050960541)},   {FRAC_CONST(0.824126183986664), FRAC_CONST(0.566406250000000)},
                                         {FRAC_CONST(0.809017002582550), FRAC_CONST(0.587785243988037)},   {FRAC_CONST(0.793353319168091), FRAC_CONST(0.608761429786682)},
                                         {FRAC_CONST(0.777145922183990), FRAC_CONST(0.629320383071899)},   {FRAC_CONST(0.760405957698822), FRAC_CONST(0.649448096752167)},
                                         {FRAC_CONST(0.743144810199738), FRAC_CONST(0.669130623340607)},   {FRAC_CONST(0.725374400615692), FRAC_CONST(0.688354551792145)},
                                         {FRAC_CONST(0.707106769084930), FRAC_CONST(0.707106769084930)},   {FRAC_CONST(0.688354551792145), FRAC_CONST(0.725374400615692)},
                                         {FRAC_CONST(0.669130563735962), FRAC_CONST(0.743144869804382)},   {FRAC_CONST(0.649448037147522), FRAC_CONST(0.760405957698822)},
                                         {FRAC_CONST(0.629320383071899), FRAC_CONST(0.777145981788635)},   {FRAC_CONST(0.608761370182037), FRAC_CONST(0.793353378772736)},
                                         {FRAC_CONST(0.587785243988037), FRAC_CONST(0.809017002582550)},   {FRAC_CONST(0.566406250000000), FRAC_CONST(0.824126183986664)},
                                         {FRAC_CONST(0.544638991355896), FRAC_CONST(0.838670611381531)},   {FRAC_CONST(0.522498488426209), FRAC_CONST(0.852640211582184)},
                                         {FRAC_CONST(0.499999970197678), FRAC_CONST(0.866025447845459)},   {FRAC_CONST(0.477158755064011), FRAC_CONST(0.878817141056061)},
                                         {FRAC_CONST(0.453990519046783), FRAC_CONST(0.891006529331207)},   {FRAC_CONST(0.430511027574539), FRAC_CONST(0.902585327625275)},
                                         {FRAC_CONST(0.406736612319946), FRAC_CONST(0.913545489311218)},   {FRAC_CONST(0.382683426141739), FRAC_CONST(0.923879504203796)},
                                         {FRAC_CONST(0.358367860317230), FRAC_CONST(0.933580458164215)},   {FRAC_CONST(0.333806812763214), FRAC_CONST(0.942641496658325)},
                                         {FRAC_CONST(0.309016972780228), FRAC_CONST(0.951056540012360)},   {FRAC_CONST(0.284015327692032), FRAC_CONST(0.958819746971130)},
                                         {FRAC_CONST(0.258819073438644), FRAC_CONST(0.965925812721252)},   {FRAC_CONST(0.233445301651955), FRAC_CONST(0.972369909286499)},
                                         {FRAC_CONST(0.207911655306816), FRAC_CONST(0.978147625923157)},   {FRAC_CONST(0.182235524058342), FRAC_CONST(0.983254909515381)},
                                         {FRAC_CONST(0.156434372067451), FRAC_CONST(0.987688362598419)},   {FRAC_CONST(0.130526125431061), FRAC_CONST(0.991444885730743)},
                                         {FRAC_CONST(0.104528419673443), FRAC_CONST(0.994521915912628)},   {FRAC_CONST(0.078459084033966), FRAC_CONST(0.996917307376862)},
                                         {FRAC_CONST(0.052335973829031), FRAC_CONST(0.998629510402679)},   {FRAC_CONST(0.026176875457168), FRAC_CONST(0.999657332897186)},
                                         {FRAC_CONST(-0.000000043711388), FRAC_CONST(1.000000000000000)},  {FRAC_CONST(-0.026176963001490), FRAC_CONST(0.999657332897186)},
                                         {FRAC_CONST(-0.052336059510708), FRAC_CONST(0.998629510402679)},  {FRAC_CONST(-0.078459173440933), FRAC_CONST(0.996917307376862)},
                                         {FRAC_CONST(-0.104528509080410), FRAC_CONST(0.994521915912628)},  {FRAC_CONST(-0.130526214838028), FRAC_CONST(0.991444885730743)},
                                         {FRAC_CONST(-0.156434446573257), FRAC_CONST(0.987688362598419)},  {FRAC_CONST(-0.182235598564148), FRAC_CONST(0.983254909515381)},
                                         {FRAC_CONST(-0.207911744713783), FRAC_CONST(0.978147566318512)},  {FRAC_CONST(-0.233445391058922), FRAC_CONST(0.972369909286499)},
                                         {FRAC_CONST(-0.258819162845612), FRAC_CONST(0.965925812721252)},  {FRAC_CONST(-0.284015417098999), FRAC_CONST(0.958819687366486)},
                                         {FRAC_CONST(-0.309017032384872), FRAC_CONST(0.951056480407715)},  {FRAC_CONST(-0.333806872367859), FRAC_CONST(0.942641496658325)},
                                         {FRAC_CONST(-0.358367949724197), FRAC_CONST(0.933580458164215)},  {FRAC_CONST(-0.382683515548706), FRAC_CONST(0.923879504203796)},
                                         {FRAC_CONST(-0.406736701726913), FRAC_CONST(0.913545429706573)},  {FRAC_CONST(-0.430511116981506), FRAC_CONST(0.902585268020630)},
                                         {FRAC_CONST(-0.453990608453751), FRAC_CONST(0.891006469726563)},  {FRAC_CONST(-0.477158725261688), FRAC_CONST(0.878817141056061)},
                                         {FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000)},   {FRAC_CONST(0.998629510402679), FRAC_CONST(0.052335958927870)},
                                         {FRAC_CONST(0.994521915912628), FRAC_CONST(0.104528464376926)},   {FRAC_CONST(0.987688362598419), FRAC_CONST(0.156434476375580)},
                                         {FRAC_CONST(0.978147625923157), FRAC_CONST(0.207911700010300)},   {FRAC_CONST(0.965925812721252), FRAC_CONST(0.258819043636322)},
                                         {FRAC_CONST(0.951056540012360), FRAC_CONST(0.309017002582550)},   {FRAC_CONST(0.933580398559570), FRAC_CONST(0.358367949724197)},
                                         {FRAC_CONST(0.913545429706573), FRAC_CONST(0.406736642122269)},   {FRAC_CONST(0.891006529331207), FRAC_CONST(0.453990519046783)},
                                         {FRAC_CONST(0.866025388240814), FRAC_CONST(0.500000000000000)},   {FRAC_CONST(0.838670551776886), FRAC_CONST(0.544639050960541)},
                                         {FRAC_CONST(0.809017002582550), FRAC_CONST(0.587785243988037)},   {FRAC_CONST(0.777145922183990), FRAC_CONST(0.629320383071899)},
                                         {FRAC_CONST(0.743144810199738), FRAC_CONST(0.669130623340607)},   {FRAC_CONST(0.707106769084930), FRAC_CONST(0.707106769084930)},
                                         {FRAC_CONST(0.669130563735962), FRAC_CONST(0.743144869804382)},   {FRAC_CONST(0.629320383071899), FRAC_CONST(0.777145981788635)},
                                         {FRAC_CONST(0.587785243988037), FRAC_CONST(0.809017002582550)},   {FRAC_CONST(0.544638991355896), FRAC_CONST(0.838670611381531)},
                                         {FRAC_CONST(0.499999970197678), FRAC_CONST(0.866025447845459)},   {FRAC_CONST(0.453990519046783), FRAC_CONST(0.891006529331207)},
                                         {FRAC_CONST(0.406736612319946), FRAC_CONST(0.913545489311218)},   {FRAC_CONST(0.358367860317230), FRAC_CONST(0.933580458164215)},
                                         {FRAC_CONST(0.309016972780228), FRAC_CONST(0.951056540012360)},   {FRAC_CONST(0.258819073438644), FRAC_CONST(0.965925812721252)},
                                         {FRAC_CONST(0.207911655306816), FRAC_CONST(0.978147625923157)},   {FRAC_CONST(0.156434372067451), FRAC_CONST(0.987688362598419)},
                                         {FRAC_CONST(0.104528419673443), FRAC_CONST(0.994521915912628)},   {FRAC_CONST(0.052335973829031), FRAC_CONST(0.998629510402679)},
                                         {FRAC_CONST(-0.000000043711388), FRAC_CONST(1.000000000000000)},  {FRAC_CONST(-0.052336059510708), FRAC_CONST(0.998629510402679)},
                                         {FRAC_CONST(-0.104528509080410), FRAC_CONST(0.994521915912628)},  {FRAC_CONST(-0.156434446573257), FRAC_CONST(0.987688362598419)},
                                         {FRAC_CONST(-0.207911744713783), FRAC_CONST(0.978147566318512)},  {FRAC_CONST(-0.258819162845612), FRAC_CONST(0.965925812721252)},
                                         {FRAC_CONST(-0.309017032384872), FRAC_CONST(0.951056480407715)},  {FRAC_CONST(-0.358367949724197), FRAC_CONST(0.933580458164215)},
                                         {FRAC_CONST(-0.406736701726913), FRAC_CONST(0.913545429706573)},  {FRAC_CONST(-0.453990608453751), FRAC_CONST(0.891006469726563)},
                                         {FRAC_CONST(-0.500000059604645), FRAC_CONST(0.866025388240814)},  {FRAC_CONST(-0.544639050960541), FRAC_CONST(0.838670551776886)},
                                         {FRAC_CONST(-0.587785184383392), FRAC_CONST(0.809017002582550)},  {FRAC_CONST(-0.629320502281189), FRAC_CONST(0.777145862579346)},
                                         {FRAC_CONST(-0.669130682945251), FRAC_CONST(0.743144810199738)},  {FRAC_CONST(-0.707106769084930), FRAC_CONST(0.707106769084930)},
                                         {FRAC_CONST(-0.743144929409027), FRAC_CONST(0.669130444526672)},  {FRAC_CONST(-0.777146041393280), FRAC_CONST(0.629320263862610)},
                                         {FRAC_CONST(-0.809017062187195), FRAC_CONST(0.587785184383392)},  {FRAC_CONST(-0.838670551776886), FRAC_CONST(0.544639050960541)},
                                         {FRAC_CONST(-0.866025388240814), FRAC_CONST(0.500000059604645)},  {FRAC_CONST(-0.891006588935852), FRAC_CONST(0.453990370035172)},
                                         {FRAC_CONST(-0.913545489311218), FRAC_CONST(0.406736582517624)},  {FRAC_CONST(-0.933580458164215), FRAC_CONST(0.358367919921875)},
                                         {FRAC_CONST(-0.951056599617004), FRAC_CONST(0.309016793966293)},  {FRAC_CONST(-0.965925872325897), FRAC_CONST(0.258818924427032)},
                                         {FRAC_CONST(-0.978147625923157), FRAC_CONST(0.207911610603333)},  {FRAC_CONST(-0.987688362598419), FRAC_CONST(0.156434446573257)},
                                         {FRAC_CONST(-0.994521915912628), FRAC_CONST(0.104528494179249)},  {FRAC_CONST(-0.998629570007324), FRAC_CONST(0.052335809916258)},
                                         {FRAC_CONST(-1.000000000000000), FRAC_CONST(-0.000000087422777)}, {FRAC_CONST(-0.998629510402679), FRAC_CONST(-0.052335985004902)},
                                         {FRAC_CONST(-0.994521856307983), FRAC_CONST(-0.104528672993183)}, {FRAC_CONST(-0.987688302993774), FRAC_CONST(-0.156434610486031)},
                                         {FRAC_CONST(-0.978147566318512), FRAC_CONST(-0.207911789417267)}, {FRAC_CONST(-0.965925812721252), FRAC_CONST(-0.258819073438644)},
                                         {FRAC_CONST(-0.951056540012360), FRAC_CONST(-0.309016972780228)}, {FRAC_CONST(-0.933580398559570), FRAC_CONST(-0.358368098735809)},
                                         {FRAC_CONST(-0.913545429706573), FRAC_CONST(-0.406736731529236)}, {FRAC_CONST(-0.891006529331207), FRAC_CONST(-0.453990548849106)},
                                         {FRAC_CONST(-0.866025269031525), FRAC_CONST(-0.500000178813934)}, {FRAC_CONST(-0.838670492172241), FRAC_CONST(-0.544639170169830)},
                                         {FRAC_CONST(-0.809016942977905), FRAC_CONST(-0.587785363197327)}, {FRAC_CONST(-0.777145922183990), FRAC_CONST(-0.629320442676544)},
                                         {FRAC_CONST(-0.743144810199738), FRAC_CONST(-0.669130623340607)}, {FRAC_CONST(-0.707106649875641), FRAC_CONST(-0.707106888294220)},
                                         {FRAC_CONST(-0.669130504131317), FRAC_CONST(-0.743144869804382)}, {FRAC_CONST(-0.629320323467255), FRAC_CONST(-0.777145981788635)},
                                         {FRAC_CONST(-0.587785065174103), FRAC_CONST(-0.809017121791840)}, {FRAC_CONST(-0.544639110565186), FRAC_CONST(-0.838670551776886)},
                                         {FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000)},   {FRAC_CONST(0.996917307376862), FRAC_CONST(0.078459098935127)},
                                         {FRAC_CONST(0.987688362598419), FRAC_CONST(0.156434476375580)},   {FRAC_CONST(0.972369909286499), FRAC_CONST(0.233445376157761)},
                                         {FRAC_CONST(0.951056540012360), FRAC_CONST(0.309017002582550)},   {FRAC_CONST(0.923879504203796), FRAC_CONST(0.382683455944061)},
                                         {FRAC_CONST(0.891006529331207), FRAC_CONST(0.453990519046783)},   {FRAC_CONST(0.852640151977539), FRAC_CONST(0.522498548030853)},
                                         {FRAC_CONST(0.809017002582550), FRAC_CONST(0.587785243988037)},   {FRAC_CONST(0.760405957698822), FRAC_CONST(0.649448096752167)},
                                         {FRAC_CONST(0.707106769084930), FRAC_CONST(0.707106769084930)},   {FRAC_CONST(0.649448037147522), FRAC_CONST(0.760405957698822)},
                                         {FRAC_CONST(0.587785243988037), FRAC_CONST(0.809017002582550)},   {FRAC_CONST(0.522498488426209), FRAC_CONST(0.852640211582184)},
                                         {FRAC_CONST(0.453990519046783), FRAC_CONST(0.891006529331207)},   {FRAC_CONST(0.382683426141739), FRAC_CONST(0.923879504203796)},
                                         {FRAC_CONST(0.309016972780228), FRAC_CONST(0.951056540012360)},   {FRAC_CONST(0.233445301651955), FRAC_CONST(0.972369909286499)},
                                         {FRAC_CONST(0.156434372067451), FRAC_CONST(0.987688362598419)},   {FRAC_CONST(0.078459084033966), FRAC_CONST(0.996917307376862)},
                                         {FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000)},   {FRAC_CONST(0.987688362598419), FRAC_CONST(0.156434476375580)},
                                         {FRAC_CONST(0.951056540012360), FRAC_CONST(0.309017002582550)},   {FRAC_CONST(0.891006529331207), FRAC_CONST(0.453990519046783)},
                                         {FRAC_CONST(0.809017002582550), FRAC_CONST(0.587785243988037)},   {FRAC_CONST(0.707106769084930), FRAC_CONST(0.707106769084930)},
                                         {FRAC_CONST(0.587785243988037), FRAC_CONST(0.809017002582550)},   {FRAC_CONST(0.453990519046783), FRAC_CONST(0.891006529331207)},
                                         {FRAC_CONST(0.309016972780228), FRAC_CONST(0.951056540012360)},   {FRAC_CONST(0.156434372067451), FRAC_CONST(0.987688362598419)},
                                         {FRAC_CONST(-0.000000043711388), FRAC_CONST(1.000000000000000)},  {FRAC_CONST(-0.156434446573257), FRAC_CONST(0.987688362598419)},
                                         {FRAC_CONST(-0.309017032384872), FRAC_CONST(0.951056480407715)},  {FRAC_CONST(-0.453990608453751), FRAC_CONST(0.891006469726563)},
                                         {FRAC_CONST(-0.587785184383392), FRAC_CONST(0.809017002582550)},  {FRAC_CONST(-0.707106769084930), FRAC_CONST(0.707106769084930)},
                                         {FRAC_CONST(-0.809017062187195), FRAC_CONST(0.587785184383392)},  {FRAC_CONST(-0.891006588935852), FRAC_CONST(0.453990370035172)},
                                         {FRAC_CONST(-0.951056599617004), FRAC_CONST(0.309016793966293)},  {FRAC_CONST(-0.987688362598419), FRAC_CONST(0.156434446573257)},
                                         {FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000)},   {FRAC_CONST(0.972369909286499), FRAC_CONST(0.233445376157761)},
                                         {FRAC_CONST(0.891006529331207), FRAC_CONST(0.453990519046783)},   {FRAC_CONST(0.760405957698822), FRAC_CONST(0.649448096752167)},
                                         {FRAC_CONST(0.587785243988037), FRAC_CONST(0.809017002582550)},   {FRAC_CONST(0.382683426141739), FRAC_CONST(0.923879504203796)},
                                         {FRAC_CONST(0.156434372067451), FRAC_CONST(0.987688362598419)},   {FRAC_CONST(-0.078459173440933), FRAC_CONST(0.996917307376862)},
                                         {FRAC_CONST(-0.309017032384872), FRAC_CONST(0.951056480407715)},  {FRAC_CONST(-0.522498667240143), FRAC_CONST(0.852640092372894)},
                                         {FRAC_CONST(-0.707106769084930), FRAC_CONST(0.707106769084930)},  {FRAC_CONST(-0.852640211582184), FRAC_CONST(0.522498488426209)},
                                         {FRAC_CONST(-0.951056599617004), FRAC_CONST(0.309016793966293)},  {FRAC_CONST(-0.996917366981506), FRAC_CONST(0.078459039330482)},
                                         {FRAC_CONST(-0.987688302993774), FRAC_CONST(-0.156434610486031)}, {FRAC_CONST(-0.923879504203796), FRAC_CONST(-0.382683426141739)},
                                         {FRAC_CONST(-0.809016942977905), FRAC_CONST(-0.587785363197327)}, {FRAC_CONST(-0.649447917938232), FRAC_CONST(-0.760406076908112)},
                                         {FRAC_CONST(-0.453990221023560), FRAC_CONST(-0.891006648540497)}, {FRAC_CONST(-0.233445450663567), FRAC_CONST(-0.972369909286499)},
                                         {FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000)},   {FRAC_CONST(0.951056540012360), FRAC_CONST(0.309017002582550)},
                                         {FRAC_CONST(0.809017002582550), FRAC_CONST(0.587785243988037)},   {FRAC_CONST(0.587785243988037), FRAC_CONST(0.809017002582550)},
                                         {FRAC_CONST(0.309016972780228), FRAC_CONST(0.951056540012360)},   {FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000)},
                                         {FRAC_CONST(0.809017002582550), FRAC_CONST(0.587785243988037)},   {FRAC_CONST(0.309016972780228), FRAC_CONST(0.951056540012360)},
                                         {FRAC_CONST(-0.309017032384872), FRAC_CONST(0.951056480407715)},  {FRAC_CONST(-0.809017062187195), FRAC_CONST(0.587785184383392)},
                                         {FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000)},   {FRAC_CONST(0.587785243988037), FRAC_CONST(0.809017002582550)},
                                         {FRAC_CONST(-0.309017032384872), FRAC_CONST(0.951056480407715)},  {FRAC_CONST(-0.951056599617004), FRAC_CONST(0.309016793966293)},
                                         {FRAC_CONST(-0.809016942977905), FRAC_CONST(-0.587785363197327)}, {FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000)},
                                         {FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000)},   {FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000)},
                                         {FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000)},   {FRAC_CONST(0.309017121791840), FRAC_CONST(-0.951056480407715)}};
        #endif // ALLOW_SMALL_FRAMELENGTH
    #endif     // LD_DEC
#endif         // FIXED POINT
// ——————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
#ifdef FIXED_POINT
static const complex_t cfft_tab_128[] = {{FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000)},   {FRAC_CONST(0.998795449733734), FRAC_CONST(0.049067676067352)},
                                         {FRAC_CONST(0.995184719562531), FRAC_CONST(0.098017141222954)},   {FRAC_CONST(0.989176511764526), FRAC_CONST(0.146730467677116)},
                                         {FRAC_CONST(0.980785250663757), FRAC_CONST(0.195090323686600)},   {FRAC_CONST(0.970031261444092), FRAC_CONST(0.242980197072029)},
                                         {FRAC_CONST(0.956940352916718), FRAC_CONST(0.290284663438797)},   {FRAC_CONST(0.941544055938721), FRAC_CONST(0.336889863014221)},
                                         {FRAC_CONST(0.923879504203796), FRAC_CONST(0.382683455944061)},   {FRAC_CONST(0.903989315032959), FRAC_CONST(0.427555084228516)},
                                         {FRAC_CONST(0.881921231746674), FRAC_CONST(0.471396744251251)},   {FRAC_CONST(0.857728600502014), FRAC_CONST(0.514102756977081)},
                                         {FRAC_CONST(0.831469595432281), FRAC_CONST(0.555570244789124)},   {FRAC_CONST(0.803207516670227), FRAC_CONST(0.595699310302734)},
                                         {FRAC_CONST(0.773010432720184), FRAC_CONST(0.634393334388733)},   {FRAC_CONST(0.740951120853424), FRAC_CONST(0.671558976173401)},
                                         {FRAC_CONST(0.707106769084930), FRAC_CONST(0.707106769084930)},   {FRAC_CONST(0.671558916568756), FRAC_CONST(0.740951180458069)},
                                         {FRAC_CONST(0.634393274784088), FRAC_CONST(0.773010432720184)},   {FRAC_CONST(0.595699310302734), FRAC_CONST(0.803207516670227)},
                                         {FRAC_CONST(0.555570185184479), FRAC_CONST(0.831469655036926)},   {FRAC_CONST(0.514102697372437), FRAC_CONST(0.857728660106659)},
                                         {FRAC_CONST(0.471396654844284), FRAC_CONST(0.881921291351318)},   {FRAC_CONST(0.427555114030838), FRAC_CONST(0.903989315032959)},
                                         {FRAC_CONST(0.382683426141739), FRAC_CONST(0.923879504203796)},   {FRAC_CONST(0.336889833211899), FRAC_CONST(0.941544055938721)},
                                         {FRAC_CONST(0.290284633636475), FRAC_CONST(0.956940352916718)},   {FRAC_CONST(0.242980122566223), FRAC_CONST(0.970031261444092)},
                                         {FRAC_CONST(0.195090234279633), FRAC_CONST(0.980785310268402)},   {FRAC_CONST(0.146730497479439), FRAC_CONST(0.989176511764526)},
                                         {FRAC_CONST(0.098017133772373), FRAC_CONST(0.995184719562531)},   {FRAC_CONST(0.049067649990320), FRAC_CONST(0.998795449733734)},
                                         {FRAC_CONST(-0.000000043711388), FRAC_CONST(1.000000000000000)},  {FRAC_CONST(-0.049067739397287), FRAC_CONST(0.998795449733734)},
                                         {FRAC_CONST(-0.098017223179340), FRAC_CONST(0.995184719562531)},  {FRAC_CONST(-0.146730571985245), FRAC_CONST(0.989176511764526)},
                                         {FRAC_CONST(-0.195090323686600), FRAC_CONST(0.980785250663757)},  {FRAC_CONST(-0.242980197072029), FRAC_CONST(0.970031261444092)},
                                         {FRAC_CONST(-0.290284723043442), FRAC_CONST(0.956940293312073)},  {FRAC_CONST(-0.336889922618866), FRAC_CONST(0.941544055938721)},
                                         {FRAC_CONST(-0.382683515548706), FRAC_CONST(0.923879504203796)},  {FRAC_CONST(-0.427555084228516), FRAC_CONST(0.903989315032959)},
                                         {FRAC_CONST(-0.471396833658218), FRAC_CONST(0.881921231746674)},  {FRAC_CONST(-0.514102756977081), FRAC_CONST(0.857728600502014)},
                                         {FRAC_CONST(-0.555570363998413), FRAC_CONST(0.831469535827637)},  {FRAC_CONST(-0.595699369907379), FRAC_CONST(0.803207516670227)},
                                         {FRAC_CONST(-0.634393274784088), FRAC_CONST(0.773010492324829)},  {FRAC_CONST(-0.671559035778046), FRAC_CONST(0.740951061248779)},
                                         {FRAC_CONST(-0.707106769084930), FRAC_CONST(0.707106769084930)},  {FRAC_CONST(-0.740951240062714), FRAC_CONST(0.671558856964111)},
                                         {FRAC_CONST(-0.773010492324829), FRAC_CONST(0.634393274784088)},  {FRAC_CONST(-0.803207635879517), FRAC_CONST(0.595699131488800)},
                                         {FRAC_CONST(-0.831469655036926), FRAC_CONST(0.555570185184479)},  {FRAC_CONST(-0.857728600502014), FRAC_CONST(0.514102756977081)},
                                         {FRAC_CONST(-0.881921350955963), FRAC_CONST(0.471396625041962)},  {FRAC_CONST(-0.903989315032959), FRAC_CONST(0.427555054426193)},
                                         {FRAC_CONST(-0.923879623413086), FRAC_CONST(0.382683277130127)},  {FRAC_CONST(-0.941544115543365), FRAC_CONST(0.336889803409576)},
                                         {FRAC_CONST(-0.956940352916718), FRAC_CONST(0.290284723043442)},  {FRAC_CONST(-0.970031261444092), FRAC_CONST(0.242980077862740)},
                                         {FRAC_CONST(-0.980785310268402), FRAC_CONST(0.195090308785439)},  {FRAC_CONST(-0.989176511764526), FRAC_CONST(0.146730333566666)},
                                         {FRAC_CONST(-0.995184719562531), FRAC_CONST(0.098017096519470)},  {FRAC_CONST(-0.998795449733734), FRAC_CONST(0.049067486077547)},
                                         {FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000)},   {FRAC_CONST(0.995184719562531), FRAC_CONST(0.098017141222954)},
                                         {FRAC_CONST(0.980785250663757), FRAC_CONST(0.195090323686600)},   {FRAC_CONST(0.956940352916718), FRAC_CONST(0.290284663438797)},
                                         {FRAC_CONST(0.923879504203796), FRAC_CONST(0.382683455944061)},   {FRAC_CONST(0.881921231746674), FRAC_CONST(0.471396744251251)},
                                         {FRAC_CONST(0.831469595432281), FRAC_CONST(0.555570244789124)},   {FRAC_CONST(0.773010432720184), FRAC_CONST(0.634393334388733)},
                                         {FRAC_CONST(0.707106769084930), FRAC_CONST(0.707106769084930)},   {FRAC_CONST(0.634393274784088), FRAC_CONST(0.773010432720184)},
                                         {FRAC_CONST(0.555570185184479), FRAC_CONST(0.831469655036926)},   {FRAC_CONST(0.471396654844284), FRAC_CONST(0.881921291351318)},
                                         {FRAC_CONST(0.382683426141739), FRAC_CONST(0.923879504203796)},   {FRAC_CONST(0.290284633636475), FRAC_CONST(0.956940352916718)},
                                         {FRAC_CONST(0.195090234279633), FRAC_CONST(0.980785310268402)},   {FRAC_CONST(0.098017133772373), FRAC_CONST(0.995184719562531)},
                                         {FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000)},   {FRAC_CONST(0.980785250663757), FRAC_CONST(0.195090323686600)},
                                         {FRAC_CONST(0.923879504203796), FRAC_CONST(0.382683455944061)},   {FRAC_CONST(0.831469595432281), FRAC_CONST(0.555570244789124)},
                                         {FRAC_CONST(0.707106769084930), FRAC_CONST(0.707106769084930)},   {FRAC_CONST(0.555570185184479), FRAC_CONST(0.831469655036926)},
                                         {FRAC_CONST(0.382683426141739), FRAC_CONST(0.923879504203796)},   {FRAC_CONST(0.195090234279633), FRAC_CONST(0.980785310268402)},
                                         {FRAC_CONST(-0.000000043711388), FRAC_CONST(1.000000000000000)},  {FRAC_CONST(-0.195090323686600), FRAC_CONST(0.980785250663757)},
                                         {FRAC_CONST(-0.382683515548706), FRAC_CONST(0.923879504203796)},  {FRAC_CONST(-0.555570363998413), FRAC_CONST(0.831469535827637)},
                                         {FRAC_CONST(-0.707106769084930), FRAC_CONST(0.707106769084930)},  {FRAC_CONST(-0.831469655036926), FRAC_CONST(0.555570185184479)},
                                         {FRAC_CONST(-0.923879623413086), FRAC_CONST(0.382683277130127)},  {FRAC_CONST(-0.980785310268402), FRAC_CONST(0.195090308785439)},
                                         {FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000)},   {FRAC_CONST(0.956940352916718), FRAC_CONST(0.290284663438797)},
                                         {FRAC_CONST(0.831469595432281), FRAC_CONST(0.555570244789124)},   {FRAC_CONST(0.634393274784088), FRAC_CONST(0.773010432720184)},
                                         {FRAC_CONST(0.382683426141739), FRAC_CONST(0.923879504203796)},   {FRAC_CONST(0.098017133772373), FRAC_CONST(0.995184719562531)},
                                         {FRAC_CONST(-0.195090323686600), FRAC_CONST(0.980785250663757)},  {FRAC_CONST(-0.471396833658218), FRAC_CONST(0.881921231746674)},
                                         {FRAC_CONST(-0.707106769084930), FRAC_CONST(0.707106769084930)},  {FRAC_CONST(-0.881921231746674), FRAC_CONST(0.471396833658218)},
                                         {FRAC_CONST(-0.980785310268402), FRAC_CONST(0.195090308785439)},  {FRAC_CONST(-0.995184719562531), FRAC_CONST(-0.098017267882824)},
                                         {FRAC_CONST(-0.923879504203796), FRAC_CONST(-0.382683426141739)}, {FRAC_CONST(-0.773010551929474), FRAC_CONST(-0.634393215179443)},
                                         {FRAC_CONST(-0.555570006370544), FRAC_CONST(-0.831469774246216)}, {FRAC_CONST(-0.290284544229507), FRAC_CONST(-0.956940352916718)},
                                         {FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000)},   {FRAC_CONST(0.923879504203796), FRAC_CONST(0.382683455944061)},
                                         {FRAC_CONST(0.707106769084930), FRAC_CONST(0.707106769084930)},   {FRAC_CONST(0.382683426141739), FRAC_CONST(0.923879504203796)},
                                         {FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000)},   {FRAC_CONST(0.707106769084930), FRAC_CONST(0.707106769084930)},
                                         {FRAC_CONST(-0.000000043711388), FRAC_CONST(1.000000000000000)},  {FRAC_CONST(-0.707106769084930), FRAC_CONST(0.707106769084930)},
                                         {FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000)},   {FRAC_CONST(0.382683426141739), FRAC_CONST(0.923879504203796)},
                                         {FRAC_CONST(-0.707106769084930), FRAC_CONST(0.707106769084930)},  {FRAC_CONST(-0.923879504203796), FRAC_CONST(-0.382683426141739)},
                                         {FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000)},   {FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000)},
                                         {FRAC_CONST(1.000000000000000), FRAC_CONST(0.000000000000000)},   {FRAC_CONST(0.000000011924881), FRAC_CONST(-1.000000000000000)}};
#endif // FIXED_POINT
// ——————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
#ifdef FIXED_POINT
static const real_t drc_pow2_table[] = {COEF_CONST(0.5146511183), COEF_CONST(0.5297315472), COEF_CONST(0.5452538663), COEF_CONST(0.5612310242), COEF_CONST(0.5776763484), COEF_CONST(0.5946035575),
                                        COEF_CONST(0.6120267717), COEF_CONST(0.6299605249), COEF_CONST(0.6484197773), COEF_CONST(0.6674199271), COEF_CONST(0.6869768237), COEF_CONST(0.7071067812),
                                        COEF_CONST(0.7278265914), COEF_CONST(0.7491535384), COEF_CONST(0.7711054127), COEF_CONST(0.7937005260), COEF_CONST(0.8169577266), COEF_CONST(0.8408964153),
                                        COEF_CONST(0.8655365610), COEF_CONST(0.8908987181), COEF_CONST(0.9170040432), COEF_CONST(0.9438743127), COEF_CONST(0.9715319412), COEF_CONST(1.0000000000),
                                        COEF_CONST(1.0293022366), COEF_CONST(1.0594630944), COEF_CONST(1.0905077327), COEF_CONST(1.1224620483), COEF_CONST(1.1553526969), COEF_CONST(1.1892071150),
                                        COEF_CONST(1.2240535433), COEF_CONST(1.2599210499), COEF_CONST(1.2968395547), COEF_CONST(1.3348398542), COEF_CONST(1.3739536475), COEF_CONST(1.4142135624),
                                        COEF_CONST(1.4556531828), COEF_CONST(1.4983070769), COEF_CONST(1.5422108254), COEF_CONST(1.5874010520), COEF_CONST(1.6339154532), COEF_CONST(1.6817928305),
                                        COEF_CONST(1.7310731220), COEF_CONST(1.7817974363), COEF_CONST(1.8340080864), COEF_CONST(1.8877486254), COEF_CONST(1.9430638823)};
#endif
// ——————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
#ifdef DRM
/* binary search huffman tables */
static const int8_t f_huffman_sa[][2] = {
    {/*0*/ -15, 1},           /* index 0: 1 bits:  x */
    {2, 3},                   /* index 1: 2 bits:  1x */
    {/*7*/ -8, 4},            /* index 2: 3 bits:  10x */
    {5, 6},                   /* index 3: 3 bits:  11x */
    {/*1*/ -14, /*-1*/ -16},  /* index 4: 4 bits:  101x */
    {/*-2*/ -17, 7},          /* index 5: 4 bits:  110x */
    {8, 9},                   /* index 6: 4 bits:  111x */
    {/*2*/ -13, /*-3*/ -18},  /* index 7: 5 bits:  1101x */
    {/*3*/ -12, 10},          /* index 8: 5 bits:  1110x */
    {11, 12},                 /* index 9: 5 bits:  1111x */
    {/*4*/ -11, /*5*/ -10},   /* index 10: 6 bits: 11101x */
    {/*-4*/ -19, /*-5*/ -20}, /* index 11: 6 bits: 11110x */
    {/*6*/ -9, 13},           /* index 12: 6 bits: 11111x */
    {/*-7*/ -22, /*-6*/ -21}  /* index 13: 7 bits: 111111x */
};
#endif
// ——————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
#ifdef DRM
static const int8_t t_huffman_sa[][2] = {
    {/*0*/ -15, 1},          /* index 0: 1 bits: x */
    {2, 3},                  /* index 1: 2 bits: 1x */
    {/*-1*/ -16, /*1*/ -14}, /* index 2: 3 bits: 10x */
    {4, 5},                  /* index 3: 3 bits: 11x */
    {/*-2*/ -17, /*2*/ -13}, /* index 4: 4 bits: 110x */
    {6, 7},                  /* index 5: 4 bits: 111x */
    {/*-3*/ -18, /*3*/ -12}, /* index 6: 5 bits: 1110x */
    {8, 9},                  /* index 7: 5 bits: 1111x */
    {/*-4*/ -19, /*4*/ -11}, /* index 8: 6 bits: 11110x */
    {10, 11},                /* index 9: 6 bits: 11111x */
    {/*-5*/ -20, /*5*/ -10}, /* index 10: 7 bits: 111110x */
    {/*-6*/ -21, 12},        /* index 11: 7 bits: 111111x */
    {/*-7*/ -22, 13},        /* index 12: 8 bits: 1111111x */
    {/*6*/ -9, /*7*/ -8}     /* index 13: 9 bits: 11111111x */
};
#endif
// ——————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
#ifdef DRM
static const int8_t f_huffman_pan[][2] = {
    {/*0*/ -15, 1},             /* index 0: 1 bits: x */
    {/*-1*/ -16, 2},            /* index 1: 2 bits: 1x */
    {/*1*/ -14, 3},             /* index 2: 3 bits: 11x */
    {4, 5},                     /* index 3: 4 bits: 111x */
    {/*-2*/ -17, /*2*/ -13},    /* index 4: 5 bits: 1110x */
    {6, 7},                     /* index 5: 5 bits: 1111x */
    {/*-3*/ -18, /*3*/ -12},    /* index 6: 6 bits: 11110x */
    {8, 9},                     /* index 7: 6 bits: 11111x */
    {/*-4*/ -19, /*4*/ -11},    /* index 8: 7 bits: 111110x */
    {10, 11},                   /* index 9: 7 bits: 111111x */
    {/*-5*/ -20, /*5*/ -10},    /* index 10: 8 bits: 1111110x */
    {12, 13},                   /* index 11: 8 bits: 1111111x */
    {/*-6*/ -21, /*6*/ -9},     /* index 12: 9 bits: 11111110x */
    {/*-7*/ -22, 14},           /* index 13: 9 bits: 11111111x */
    {/*7*/ -8, 15},             /* index 14: 10 bits: 111111111x */
    {16, 17},                   /* index 15: 11 bits: 1111111111x */
    {/*-8*/ -23, /*8*/ -7},     /* index 16: 12 bits: 11111111110x */
    {18, 19},                   /* index 17: 12 bits: 11111111111x */
    {/*-10*/ -25, 20},          /* index 18: 13 bits: 111111111110x */
    {21, 22},                   /* index 19: 13 bits: 111111111111x */
    {/*-9*/ -24, /*9*/ -6},     /* index 20: 14 bits: 1111111111101x */
    {/*10*/ -5, 23},            /* index 21: 14 bits: 1111111111110x */
    {24, 25},                   /* index 22: 14 bits: 1111111111111x */
    {/*-13*/ -28, /*-11*/ -26}, /* index 23: 15 bits: 11111111111101x */
    {/*11*/ -4, /*13*/ -2},     /* index 24: 15 bits: 11111111111110x */
    {26, 27},                   /* index 25: 15 bits: 11111111111111x */
    {/*-14*/ -29, /*-12*/ -27}, /* index 26: 16 bits: 111111111111110x */
    {/*12*/ -3, /*14*/ -1}      /* index 27: 16 bits: 111111111111111x */
};
#endif
// ——————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
#ifdef DRM
static const int8_t t_huffman_pan[][2] = {
    {/*0*/ -15, 1},             /* index 0: 1 bits: x */
    {/*-1*/ -16, 2},            /* index 1: 2 bits: 1x */
    {/*1*/ -14, 3},             /* index 2: 3 bits: 11x */
    {/*-2*/ -17, 4},            /* index 3: 4 bits: 111x */
    {/*2*/ -13, 5},             /* index 4: 5 bits: 1111x */
    {/*-3*/ -18, 6},            /* index 5: 6 bits: 11111x */
    {/*3*/ -12, 7},             /* index 6: 7 bits: 111111x */
    {/*-4*/ -19, 8},            /* index 7: 8 bits: 1111111x */
    {/*4*/ -11, 9},             /* index 8: 9 bits: 11111111x */
    {10, 11},                   /* index 9: 10 bits: 111111111x */
    {/*-5*/ -20, /*5*/ -10},    /* index 10: 11 bits: 1111111110x */
    {12, 13},                   /* index 11: 11 bits: 1111111111x */
    {/*-6*/ -21, /*6*/ -9},     /* index 12: 12 bits: 11111111110x */
    {14, 15},                   /* index 13: 12 bits: 11111111111x */
    {/*-7*/ -22, /*7*/ -8},     /* index 14: 13 bits: 111111111110x */
    {16, 17},                   /* index 15: 13 bits: 111111111111x */
    {/*-8*/ -23, /*8*/ -7},     /* index 16: 14 bits: 1111111111110x */
    {18, 19},                   /* index 17: 14 bits: 1111111111111x */
    {/*-10*/ -25, /*10*/ -5},   /* index 18: 15 bits: 11111111111110x */
    {20, 21},                   /* index 19: 15 bits: 11111111111111x */
    {/*-9*/ -24, /*9*/ -6},     /* index 20: 16 bits: 111111111111110x */
    {22, 23},                   /* index 21: 16 bits: 111111111111111x */
    {24, 25},                   /* index 22: 17 bits: 1111111111111110x */
    {26, 27},                   /* index 23: 17 bits: 1111111111111111x */
    {/*-14*/ -29, /*-13*/ -28}, /* index 24: 18 bits: 11111111111111100x */
    {/*-12*/ -27, /*-11*/ -26}, /* index 25: 18 bits: 11111111111111101x */
    {/*11*/ -4, /*12*/ -3},     /* index 26: 18 bits: 11111111111111110x */
    {/*13*/ -2, /*14*/ -1}      /* index 27: 18 bits: 11111111111111111x */
};
#endif
// ——————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
#ifdef DRM
/* There are 3 classes in the standard but the last 2 are identical */
static const real_t sa_quant[8][2] = {
    {FRAC_CONST(0.0000), FRAC_CONST(0.0000)}, {FRAC_CONST(0.0501), FRAC_CONST(0.1778)}, {FRAC_CONST(0.0706), FRAC_CONST(0.2818)}, {FRAC_CONST(0.0995), FRAC_CONST(0.4467)},
    {FRAC_CONST(0.1399), FRAC_CONST(0.5623)}, {FRAC_CONST(0.1957), FRAC_CONST(0.7079)}, {FRAC_CONST(0.2713), FRAC_CONST(0.8913)}, {FRAC_CONST(0.3699), FRAC_CONST(1.0000)},
};
#endif
// ——————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
#ifdef DRM
    /* We don't need the actual quantizer values */
    #if 0
static const real_t pan_quant[8][5] =
{
    { COEF_CONST(0.0000), COEF_CONST(0.0000), COEF_CONST(0.0000), COEF_CONST(0.0000), COEF_CONST(0.0000) },
    { COEF_CONST(0.1661), COEF_CONST(0.1661), COEF_CONST(0.3322), COEF_CONST(0.3322), COEF_CONST(0.3322) },
    { COEF_CONST(0.3322), COEF_CONST(0.3322), COEF_CONST(0.6644), COEF_CONST(0.8305), COEF_CONST(0.8305) },
    { COEF_CONST(0.4983), COEF_CONST(0.6644), COEF_CONST(0.9966), COEF_CONST(1.4949), COEF_CONST(1.6610) },
    { COEF_CONST(0.6644), COEF_CONST(0.9966), COEF_CONST(1.4949), COEF_CONST(2.1593), COEF_CONST(2.4914) },
    { COEF_CONST(0.8305), COEF_CONST(1.3288), COEF_CONST(2.1593), COEF_CONST(2.9897), COEF_CONST(3.4880) },
    { COEF_CONST(0.9966), COEF_CONST(1.8271), COEF_CONST(2.8236), COEF_CONST(3.8202), COEF_CONST(4.6507) },
    { COEF_CONST(1.3288), COEF_CONST(2.3253), COEF_CONST(3.4880), COEF_CONST(4.6507), COEF_CONST(5.8134) },
};
    #endif
#endif
// ——————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
#ifdef DRM
/* 2^(pan_quant[x][y] */
static const real_t pan_pow_2_pos[8][5] = {{REAL_CONST(1.0000000), REAL_CONST(1.0000000), REAL_CONST(1.0000000), REAL_CONST(1.0000000), REAL_CONST(1.0000000)},
                                           {REAL_CONST(1.1220021), REAL_CONST(1.1220021), REAL_CONST(1.2589312), REAL_CONST(1.2589312), REAL_CONST(1.2589312)},
                                           {REAL_CONST(1.2589312), REAL_CONST(1.2589312), REAL_CONST(1.5849090), REAL_CONST(1.7783016), REAL_CONST(1.7783016)},
                                           {REAL_CONST(1.4125481), REAL_CONST(1.5849090), REAL_CONST(1.9952921), REAL_CONST(2.8184461), REAL_CONST(3.1623565)},
                                           {REAL_CONST(1.5849090), REAL_CONST(1.9952922), REAL_CONST(2.8184461), REAL_CONST(4.4669806), REAL_CONST(5.6232337)},
                                           {REAL_CONST(1.7783016), REAL_CONST(2.5119365), REAL_CONST(4.4669806), REAL_CONST(7.9430881), REAL_CONST(11.219994)},
                                           {REAL_CONST(1.9952921), REAL_CONST(3.5482312), REAL_CONST(7.0792671), REAL_CONST(14.125206), REAL_CONST(25.118876)},
                                           {REAL_CONST(2.5119365), REAL_CONST(5.0116998), REAL_CONST(11.219994), REAL_CONST(25.118876), REAL_CONST(56.235140)}};
#endif
// ——————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
#ifdef DRM
/* 2^(-pan_quant[x][y] */
static const real_t pan_pow_2_neg[8][5] = {{REAL_CONST(1), REAL_CONST(1), REAL_CONST(1), REAL_CONST(1), REAL_CONST(1)},
                                           {REAL_CONST(0.8912487), REAL_CONST(0.8912487), REAL_CONST(0.7943242), REAL_CONST(0.7943242), REAL_CONST(0.7943242)},
                                           {REAL_CONST(0.7943242), REAL_CONST(0.7943242), REAL_CONST(0.6309511), REAL_CONST(0.5623344), REAL_CONST(0.5623344)},
                                           {REAL_CONST(0.7079405), REAL_CONST(0.6309511), REAL_CONST(0.5011797), REAL_CONST(0.3548054), REAL_CONST(0.3162199)},
                                           {REAL_CONST(0.6309511), REAL_CONST(0.5011797), REAL_CONST(0.3548054), REAL_CONST(0.2238649), REAL_CONST(0.1778336)},
                                           {REAL_CONST(0.5623343), REAL_CONST(0.3980992), REAL_CONST(0.2238649), REAL_CONST(0.1258956), REAL_CONST(0.0891266)},
                                           {REAL_CONST(0.5011797), REAL_CONST(0.2818306), REAL_CONST(0.1412576), REAL_CONST(0.0707954), REAL_CONST(0.0398107)},
                                           {REAL_CONST(0.3980992), REAL_CONST(0.1995331), REAL_CONST(0.0891267), REAL_CONST(0.0398107), REAL_CONST(0.0177825)}};
#endif
// ——————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
#ifdef DRM
/* 2^(pan_quant[x][y]/30) */
static const real_t pan_pow_2_30_pos[8][5] = {{COEF_CONST(1), COEF_CONST(1), COEF_CONST(1), COEF_CONST(1), COEF_CONST(1)},
                                              {COEF_CONST(1.003845098), COEF_CONST(1.003845098), COEF_CONST(1.007704982), COEF_CONST(1.007704982), COEF_CONST(1.007704982)},
                                              {COEF_CONST(1.007704982), COEF_CONST(1.007704982), COEF_CONST(1.01546933), COEF_CONST(1.019373909), COEF_CONST(1.019373909)},
                                              {COEF_CONST(1.011579706), COEF_CONST(1.01546933), COEF_CONST(1.023293502), COEF_CONST(1.035142941), COEF_CONST(1.039123167)},
                                              {COEF_CONST(1.01546933), COEF_CONST(1.023293502), COEF_CONST(1.035142941), COEF_CONST(1.051155908), COEF_CONST(1.059252598)},
                                              {COEF_CONST(1.019373909), COEF_CONST(1.03117796), COEF_CONST(1.051155908), COEF_CONST(1.071518432), COEF_CONST(1.0839263)},
                                              {COEF_CONST(1.023293502), COEF_CONST(1.043118698), COEF_CONST(1.067414119), COEF_CONST(1.092277933), COEF_CONST(1.113439626)},
                                              {COEF_CONST(1.03117796), COEF_CONST(1.055195268), COEF_CONST(1.0839263), COEF_CONST(1.113439626), COEF_CONST(1.143756546)}};
#endif
// ——————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
#ifdef DRM
/* 2^(-pan_quant[x][y]/30) */
static const real_t pan_pow_2_30_neg[8][5] = {{COEF_CONST(1), COEF_CONST(1), COEF_CONST(1), COEF_CONST(1), COEF_CONST(1)},
                                              {COEF_CONST(0.99616963), COEF_CONST(0.99616963), COEF_CONST(0.992353931), COEF_CONST(0.992353931), COEF_CONST(0.99235393)},
                                              {COEF_CONST(0.992353931), COEF_CONST(0.992353931), COEF_CONST(0.984766325), COEF_CONST(0.980994305), COEF_CONST(0.980994305)},
                                              {COEF_CONST(0.988552848), COEF_CONST(0.984766325), COEF_CONST(0.977236734), COEF_CONST(0.966050157), COEF_CONST(0.962349827)},
                                              {COEF_CONST(0.984766325), COEF_CONST(0.977236734), COEF_CONST(0.966050157), COEF_CONST(0.951333663), COEF_CONST(0.944061881)},
                                              {COEF_CONST(0.980994305), COEF_CONST(0.969764715), COEF_CONST(0.951333663), COEF_CONST(0.933255062), COEF_CONST(0.922571949)},
                                              {COEF_CONST(0.977236734), COEF_CONST(0.958663671), COEF_CONST(0.936843519), COEF_CONST(0.915517901), COEF_CONST(0.898117847)},
                                              {COEF_CONST(0.969764715), COEF_CONST(0.947691892), COEF_CONST(0.922571949), COEF_CONST(0.898117847), COEF_CONST(0.874311936)}};
#endif
// ——————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
#ifdef DRM
static const real_t g_decayslope[MAX_SA_BAND] = {FRAC_CONST(1),   FRAC_CONST(1),    FRAC_CONST(1),   FRAC_CONST(0.95), FRAC_CONST(0.9), FRAC_CONST(0.85), FRAC_CONST(0.8), FRAC_CONST(0.75),
                                                 FRAC_CONST(0.7), FRAC_CONST(0.65), FRAC_CONST(0.6), FRAC_CONST(0.55), FRAC_CONST(0.5), FRAC_CONST(0.45), FRAC_CONST(0.4), FRAC_CONST(0.35),
                                                 FRAC_CONST(0.3), FRAC_CONST(0.25), FRAC_CONST(0.2), FRAC_CONST(0.15), FRAC_CONST(0.1), FRAC_CONST(0.05), FRAC_CONST(0),   FRAC_CONST(0),
                                                 FRAC_CONST(0),   FRAC_CONST(0),    FRAC_CONST(0),   FRAC_CONST(0),    FRAC_CONST(0),   FRAC_CONST(0),    FRAC_CONST(0),   FRAC_CONST(0),
                                                 FRAC_CONST(0),   FRAC_CONST(0),    FRAC_CONST(0),   FRAC_CONST(0),    FRAC_CONST(0),   FRAC_CONST(0),    FRAC_CONST(0),   FRAC_CONST(0),
                                                 FRAC_CONST(0),   FRAC_CONST(0),    FRAC_CONST(0),   FRAC_CONST(0),    FRAC_CONST(0)};
#endif
// ——————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
#ifdef DRM
static const real_t sa_sqrt_1_minus[8][2] = {{FRAC_CONST(1), FRAC_CONST(1)},
                                             {FRAC_CONST(0.998744206), FRAC_CONST(0.984066644)},
                                             {FRAC_CONST(0.997504707), FRAC_CONST(0.959473168)},
                                             {FRAC_CONST(0.995037562), FRAC_CONST(0.894683804)},
                                             {FRAC_CONST(0.990165638), FRAC_CONST(0.826933317)},
                                             {FRAC_CONST(0.980663811), FRAC_CONST(0.706312672)},
                                             {FRAC_CONST(0.962494836), FRAC_CONST(0.45341406)},
                                             {FRAC_CONST(0.929071574), FRAC_CONST(0)}};
#endif
// ——————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
#ifdef DRM
static const uint8_t sa_freq_scale[9] = {0, 1, 2, 3, 5, 7, 10, 13, 23};
static const uint8_t pan_freq_scale[21] = {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 18, 22, 26, 32, 64};
static const uint8_t pan_quant_class[20] = {0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 4, 4, 4};
/* Inverse mapping lookup */
static const uint8_t pan_inv_freq[64] = {0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15, 15, 15, 16, 16, 16, 16, 17, 17, 17, 17, 18, 18, 18, 18, 18, 18,
                                         19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19};
static const uint8_t sa_inv_freq[MAX_SA_BAND] = {0, 1, 2, 3, 3, 4, 4, 5, 5, 5, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7};
static const real_t  filter_coeff[] = {FRAC_CONST(0.65143905754106), FRAC_CONST(0.56471812200776), FRAC_CONST(0.48954165955695)};
static const uint8_t delay_length[3] = {3, 4, 5};
static const real_t  delay_fraction[] = {FRAC_CONST(0.43), FRAC_CONST(0.75), FRAC_CONST(0.347)};
static const real_t  peak_decay = FRAC_CONST(0.76592833836465);
static const real_t  smooth_coeff = FRAC_CONST(0.25);
#endif
// ——————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
#if defined(DRM) || defined(PS_DEC)
/* Please note that these are the same tables as in plain PS */
static const complex_t Q_Fract_allpass_Qmf[][3] = {
    {{FRAC_CONST(0.7804303765), FRAC_CONST(0.6252426505)}, {FRAC_CONST(0.3826834261), FRAC_CONST(0.9238795042)}, {FRAC_CONST(0.8550928831), FRAC_CONST(0.5184748173)}},
    {{FRAC_CONST(-0.4399392009), FRAC_CONST(0.8980275393)}, {FRAC_CONST(-0.9238795042), FRAC_CONST(-0.3826834261)}, {FRAC_CONST(-0.0643581524), FRAC_CONST(0.9979268909)}},
    {{FRAC_CONST(-0.9723699093), FRAC_CONST(-0.2334454209)}, {FRAC_CONST(0.9238795042), FRAC_CONST(-0.3826834261)}, {FRAC_CONST(-0.9146071672), FRAC_CONST(0.4043435752)}},
    {{FRAC_CONST(0.0157073960), FRAC_CONST(-0.9998766184)}, {FRAC_CONST(-0.3826834261), FRAC_CONST(0.9238795042)}, {FRAC_CONST(-0.7814115286), FRAC_CONST(-0.6240159869)}},
    {{FRAC_CONST(0.9792228341), FRAC_CONST(-0.2027871907)}, {FRAC_CONST(-0.3826834261), FRAC_CONST(-0.9238795042)}, {FRAC_CONST(0.1920081824), FRAC_CONST(-0.9813933372)}},
    {{FRAC_CONST(0.4115142524), FRAC_CONST(0.9114032984)}, {FRAC_CONST(0.9238795042), FRAC_CONST(0.3826834261)}, {FRAC_CONST(0.9589683414), FRAC_CONST(-0.2835132182)}},
    {{FRAC_CONST(-0.7996847630), FRAC_CONST(0.6004201174)}, {FRAC_CONST(-0.9238795042), FRAC_CONST(0.3826834261)}, {FRAC_CONST(0.6947838664), FRAC_CONST(0.7192186117)}},
    {{FRAC_CONST(-0.7604058385), FRAC_CONST(-0.6494481564)}, {FRAC_CONST(0.3826834261), FRAC_CONST(-0.9238795042)}, {FRAC_CONST(-0.3164770305), FRAC_CONST(0.9486001730)}},
    {{FRAC_CONST(0.4679299891), FRAC_CONST(-0.8837655187)}, {FRAC_CONST(0.3826834261), FRAC_CONST(0.9238795042)}, {FRAC_CONST(-0.9874414206), FRAC_CONST(0.1579856575)}},
    {{FRAC_CONST(0.9645573497), FRAC_CONST(0.2638732493)}, {FRAC_CONST(-0.9238795042), FRAC_CONST(-0.3826834261)}, {FRAC_CONST(-0.5966450572), FRAC_CONST(-0.8025052547)}},
    {{FRAC_CONST(-0.0471066870), FRAC_CONST(0.9988898635)}, {FRAC_CONST(0.9238795042), FRAC_CONST(-0.3826834261)}, {FRAC_CONST(0.4357025325), FRAC_CONST(-0.9000906944)}},
    {{FRAC_CONST(-0.9851093888), FRAC_CONST(0.1719288528)}, {FRAC_CONST(-0.3826834261), FRAC_CONST(0.9238795042)}, {FRAC_CONST(0.9995546937), FRAC_CONST(-0.0298405960)}},
    {{FRAC_CONST(-0.3826831877), FRAC_CONST(-0.9238796234)}, {FRAC_CONST(-0.3826834261), FRAC_CONST(-0.9238795042)}, {FRAC_CONST(0.4886211455), FRAC_CONST(0.8724960685)}},
    {{FRAC_CONST(0.8181498647), FRAC_CONST(-0.5750049949)}, {FRAC_CONST(0.9238795042), FRAC_CONST(0.3826834261)}, {FRAC_CONST(-0.5477093458), FRAC_CONST(0.8366686702)}},
    {{FRAC_CONST(0.7396308780), FRAC_CONST(0.6730127335)}, {FRAC_CONST(-0.9238795042), FRAC_CONST(0.3826834261)}, {FRAC_CONST(-0.9951074123), FRAC_CONST(-0.0987988561)}},
    {{FRAC_CONST(-0.4954589605), FRAC_CONST(0.8686313629)}, {FRAC_CONST(0.3826834261), FRAC_CONST(-0.9238795042)}, {FRAC_CONST(-0.3725017905), FRAC_CONST(-0.9280315042)}},
    {{FRAC_CONST(-0.9557929039), FRAC_CONST(-0.2940406799)}, {FRAC_CONST(0.3826834261), FRAC_CONST(0.9238795042)}, {FRAC_CONST(0.6506417990), FRAC_CONST(-0.7593847513)}},
    {{FRAC_CONST(0.0784594864), FRAC_CONST(-0.9969173074)}, {FRAC_CONST(-0.9238795042), FRAC_CONST(-0.3826834261)}, {FRAC_CONST(0.9741733670), FRAC_CONST(0.2258014232)}},
    {{FRAC_CONST(0.9900237322), FRAC_CONST(-0.1409008205)}, {FRAC_CONST(0.9238795042), FRAC_CONST(-0.3826834261)}, {FRAC_CONST(0.2502108514), FRAC_CONST(0.9681913853)}},
    {{FRAC_CONST(0.3534744382), FRAC_CONST(0.9354441762)}, {FRAC_CONST(-0.3826834261), FRAC_CONST(0.9238795042)}, {FRAC_CONST(-0.7427945137), FRAC_CONST(0.6695194840)}},
    {{FRAC_CONST(-0.8358076215), FRAC_CONST(0.5490224361)}, {FRAC_CONST(-0.3826834261), FRAC_CONST(-0.9238795042)}, {FRAC_CONST(-0.9370992780), FRAC_CONST(-0.3490629196)}},
    {{FRAC_CONST(-0.7181259394), FRAC_CONST(-0.6959131360)}, {FRAC_CONST(0.9238795042), FRAC_CONST(0.3826834261)}, {FRAC_CONST(-0.1237744763), FRAC_CONST(-0.9923103452)}},
    {{FRAC_CONST(0.5224990249), FRAC_CONST(-0.8526399136)}, {FRAC_CONST(-0.9238795042), FRAC_CONST(0.3826834261)}, {FRAC_CONST(0.8226406574), FRAC_CONST(-0.5685616732)}},
    {{FRAC_CONST(0.9460852146), FRAC_CONST(0.3239179254)}, {FRAC_CONST(0.3826834261), FRAC_CONST(-0.9238795042)}, {FRAC_CONST(0.8844994903), FRAC_CONST(0.4665412009)}},
    {{FRAC_CONST(-0.1097348556), FRAC_CONST(0.9939609170)}, {FRAC_CONST(0.3826834261), FRAC_CONST(0.9238795042)}, {FRAC_CONST(-0.0047125919), FRAC_CONST(0.9999889135)}},
    {{FRAC_CONST(-0.9939610362), FRAC_CONST(0.1097337380)}, {FRAC_CONST(-0.9238795042), FRAC_CONST(-0.3826834261)}, {FRAC_CONST(-0.8888573647), FRAC_CONST(0.4581840038)}},
    {{FRAC_CONST(-0.3239168525), FRAC_CONST(-0.9460855722)}, {FRAC_CONST(0.9238795042), FRAC_CONST(-0.3826834261)}, {FRAC_CONST(-0.8172453642), FRAC_CONST(-0.5762898922)}},
    {{FRAC_CONST(0.8526405096), FRAC_CONST(-0.5224980116)}, {FRAC_CONST(-0.3826834261), FRAC_CONST(0.9238795042)}, {FRAC_CONST(0.1331215799), FRAC_CONST(-0.9910997152)}},
    {{FRAC_CONST(0.6959123611), FRAC_CONST(0.7181267142)}, {FRAC_CONST(-0.3826834261), FRAC_CONST(-0.9238795042)}, {FRAC_CONST(0.9403476119), FRAC_CONST(-0.3402152061)}},
    {{FRAC_CONST(-0.5490233898), FRAC_CONST(0.8358070254)}, {FRAC_CONST(0.9238795042), FRAC_CONST(0.3826834261)}, {FRAC_CONST(0.7364512086), FRAC_CONST(0.6764906645)}},
    {{FRAC_CONST(-0.9354437590), FRAC_CONST(-0.3534754813)}, {FRAC_CONST(-0.9238795042), FRAC_CONST(0.3826834261)}, {FRAC_CONST(-0.2593250275), FRAC_CONST(0.9657900929)}},
    {{FRAC_CONST(0.1409019381), FRAC_CONST(-0.9900235534)}, {FRAC_CONST(0.3826834261), FRAC_CONST(-0.9238795042)}, {FRAC_CONST(-0.9762582779), FRAC_CONST(0.2166097313)}},
    {{FRAC_CONST(0.9969173670), FRAC_CONST(-0.0784583688)}, {FRAC_CONST(0.3826834261), FRAC_CONST(0.9238795042)}, {FRAC_CONST(-0.6434556246), FRAC_CONST(-0.7654833794)}},
    {{FRAC_CONST(0.2940396070), FRAC_CONST(0.9557932615)}, {FRAC_CONST(-0.9238795042), FRAC_CONST(-0.3826834261)}, {FRAC_CONST(0.3812320232), FRAC_CONST(-0.9244794250)}},
    {{FRAC_CONST(-0.8686318994), FRAC_CONST(0.4954580069)}, {FRAC_CONST(0.9238795042), FRAC_CONST(-0.3826834261)}, {FRAC_CONST(0.9959943891), FRAC_CONST(-0.0894154981)}},
    {{FRAC_CONST(-0.6730118990), FRAC_CONST(-0.7396316528)}, {FRAC_CONST(-0.3826834261), FRAC_CONST(0.9238795042)}, {FRAC_CONST(0.5397993922), FRAC_CONST(0.8417937160)}},
    {{FRAC_CONST(0.5750059485), FRAC_CONST(-0.8181492686)}, {FRAC_CONST(-0.3826834261), FRAC_CONST(-0.9238795042)}, {FRAC_CONST(-0.4968227744), FRAC_CONST(0.8678520322)}},
    {{FRAC_CONST(0.9238792062), FRAC_CONST(0.3826842010)}, {FRAC_CONST(0.9238795042), FRAC_CONST(0.3826834261)}, {FRAC_CONST(-0.9992290139), FRAC_CONST(-0.0392601527)}},
    {{FRAC_CONST(-0.1719299555), FRAC_CONST(0.9851091504)}, {FRAC_CONST(-0.9238795042), FRAC_CONST(0.3826834261)}, {FRAC_CONST(-0.4271997511), FRAC_CONST(-0.9041572809)}},
    {{FRAC_CONST(-0.9988899231), FRAC_CONST(0.0471055657)}, {FRAC_CONST(0.3826834261), FRAC_CONST(-0.9238795042)}, {FRAC_CONST(0.6041822433), FRAC_CONST(-0.7968461514)}},
    {{FRAC_CONST(-0.2638721764), FRAC_CONST(-0.9645576477)}, {FRAC_CONST(0.3826834261), FRAC_CONST(0.9238795042)}, {FRAC_CONST(0.9859085083), FRAC_CONST(0.1672853529)}},
    {{FRAC_CONST(0.8837660551), FRAC_CONST(-0.4679289758)}, {FRAC_CONST(-0.9238795042), FRAC_CONST(-0.3826834261)}, {FRAC_CONST(0.3075223565), FRAC_CONST(0.9515408874)}},
    {{FRAC_CONST(0.6494473219), FRAC_CONST(0.7604066133)}, {FRAC_CONST(0.9238795042), FRAC_CONST(-0.3826834261)}, {FRAC_CONST(-0.7015317082), FRAC_CONST(0.7126382589)}},
    {{FRAC_CONST(-0.6004210114), FRAC_CONST(0.7996840477)}, {FRAC_CONST(-0.3826834261), FRAC_CONST(0.9238795042)}, {FRAC_CONST(-0.9562535882), FRAC_CONST(-0.2925389707)}},
    {{FRAC_CONST(-0.9114028811), FRAC_CONST(-0.4115152657)}, {FRAC_CONST(-0.3826834261), FRAC_CONST(-0.9238795042)}, {FRAC_CONST(-0.1827499419), FRAC_CONST(-0.9831594229)}},
    {{FRAC_CONST(0.2027882934), FRAC_CONST(-0.9792225957)}, {FRAC_CONST(0.9238795042), FRAC_CONST(0.3826834261)}, {FRAC_CONST(0.7872582674), FRAC_CONST(-0.6166234016)}},
    {{FRAC_CONST(0.9998766780), FRAC_CONST(-0.0157062728)}, {FRAC_CONST(-0.9238795042), FRAC_CONST(0.3826834261)}, {FRAC_CONST(0.9107555747), FRAC_CONST(0.4129458666)}},
    {{FRAC_CONST(0.2334443331), FRAC_CONST(0.9723701477)}, {FRAC_CONST(0.3826834261), FRAC_CONST(-0.9238795042)}, {FRAC_CONST(0.0549497530), FRAC_CONST(0.9984891415)}},
    {{FRAC_CONST(-0.8980280757), FRAC_CONST(0.4399381876)}, {FRAC_CONST(0.3826834261), FRAC_CONST(0.9238795042)}, {FRAC_CONST(-0.8599416018), FRAC_CONST(0.5103924870)}},
    {{FRAC_CONST(-0.6252418160), FRAC_CONST(-0.7804310918)}, {FRAC_CONST(-0.9238795042), FRAC_CONST(-0.3826834261)}, {FRAC_CONST(-0.8501682281), FRAC_CONST(-0.5265110731)}},
    {{FRAC_CONST(0.6252435446), FRAC_CONST(-0.7804297209)}, {FRAC_CONST(0.9238795042), FRAC_CONST(-0.3826834261)}, {FRAC_CONST(0.0737608299), FRAC_CONST(-0.9972759485)}},
    {{FRAC_CONST(0.8980270624), FRAC_CONST(0.4399402142)}, {FRAC_CONST(-0.3826834261), FRAC_CONST(0.9238795042)}, {FRAC_CONST(0.9183775187), FRAC_CONST(-0.3957053721)}},
    {{FRAC_CONST(-0.2334465086), FRAC_CONST(0.9723696709)}, {FRAC_CONST(-0.3826834261), FRAC_CONST(-0.9238795042)}, {FRAC_CONST(0.7754954696), FRAC_CONST(0.6313531399)}},
    {{FRAC_CONST(-0.9998766184), FRAC_CONST(-0.0157085191)}, {FRAC_CONST(0.9238795042), FRAC_CONST(0.3826834261)}, {FRAC_CONST(-0.2012493610), FRAC_CONST(0.9795400500)}},
    {{FRAC_CONST(-0.2027861029), FRAC_CONST(-0.9792230725)}, {FRAC_CONST(-0.9238795042), FRAC_CONST(0.3826834261)}, {FRAC_CONST(-0.9615978599), FRAC_CONST(0.2744622827)}},
    {{FRAC_CONST(0.9114037752), FRAC_CONST(-0.4115132093)}, {FRAC_CONST(0.3826834261), FRAC_CONST(-0.9238795042)}, {FRAC_CONST(-0.6879743338), FRAC_CONST(-0.7257350087)}},
    {{FRAC_CONST(0.6004192233), FRAC_CONST(0.7996854186)}, {FRAC_CONST(0.3826834261), FRAC_CONST(0.9238795042)}, {FRAC_CONST(0.3254036009), FRAC_CONST(-0.9455752373)}},
    {{FRAC_CONST(-0.6494490504), FRAC_CONST(0.7604051232)}, {FRAC_CONST(-0.9238795042), FRAC_CONST(-0.3826834261)}, {FRAC_CONST(0.9888865948), FRAC_CONST(-0.1486719251)}},
    {{FRAC_CONST(-0.8837650418), FRAC_CONST(-0.4679309726)}, {FRAC_CONST(0.9238795042), FRAC_CONST(-0.3826834261)}, {FRAC_CONST(0.5890548825), FRAC_CONST(0.8080930114)}},
    {{FRAC_CONST(0.2638743520), FRAC_CONST(-0.9645570517)}, {FRAC_CONST(-0.3826834261), FRAC_CONST(0.9238795042)}, {FRAC_CONST(-0.4441666007), FRAC_CONST(0.8959442377)}},
    {{FRAC_CONST(0.9988898039), FRAC_CONST(0.0471078083)}, {FRAC_CONST(-0.3826834261), FRAC_CONST(-0.9238795042)}, {FRAC_CONST(-0.9997915030), FRAC_CONST(0.0204183888)}},
    {{FRAC_CONST(0.1719277352), FRAC_CONST(0.9851095676)}, {FRAC_CONST(0.9238795042), FRAC_CONST(0.3826834261)}, {FRAC_CONST(-0.4803760946), FRAC_CONST(-0.8770626187)}},
    {{FRAC_CONST(-0.9238800406), FRAC_CONST(0.3826821446)}, {FRAC_CONST(-0.9238795042), FRAC_CONST(0.3826834261)}, {FRAC_CONST(0.5555707216), FRAC_CONST(-0.8314692974)}},
    {{FRAC_CONST(-0.5750041008), FRAC_CONST(-0.8181505203)}, {FRAC_CONST(0.3826834261), FRAC_CONST(-0.9238795042)}, {FRAC_CONST(0.9941320419), FRAC_CONST(0.1081734300)}}};
#endif
// ——————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
static const complex_t Phi_Fract_Qmf[] = {
    {FRAC_CONST(0.8181497455), FRAC_CONST(0.5750052333)},   {FRAC_CONST(-0.2638730407), FRAC_CONST(0.9645574093)},  {FRAC_CONST(-0.9969173074), FRAC_CONST(0.0784590989)},
    {FRAC_CONST(-0.4115143716), FRAC_CONST(-0.9114032984)}, {FRAC_CONST(0.7181262970), FRAC_CONST(-0.6959127784)},  {FRAC_CONST(0.8980275989), FRAC_CONST(0.4399391711)},
    {FRAC_CONST(-0.1097343117), FRAC_CONST(0.9939609766)},  {FRAC_CONST(-0.9723699093), FRAC_CONST(0.2334453613)},  {FRAC_CONST(-0.5490227938), FRAC_CONST(-0.8358073831)},
    {FRAC_CONST(0.6004202366), FRAC_CONST(-0.7996846437)},  {FRAC_CONST(0.9557930231), FRAC_CONST(0.2940403223)},   {FRAC_CONST(0.0471064523), FRAC_CONST(0.9988898635)},
    {FRAC_CONST(-0.9238795042), FRAC_CONST(0.3826834261)},  {FRAC_CONST(-0.6730124950), FRAC_CONST(-0.7396311164)}, {FRAC_CONST(0.4679298103), FRAC_CONST(-0.8837656379)},
    {FRAC_CONST(0.9900236726), FRAC_CONST(0.1409012377)},   {FRAC_CONST(0.2027872950), FRAC_CONST(0.9792228341)},   {FRAC_CONST(-0.8526401520), FRAC_CONST(0.5224985480)},
    {FRAC_CONST(-0.7804304361), FRAC_CONST(-0.6252426505)}, {FRAC_CONST(0.3239174187), FRAC_CONST(-0.9460853338)},  {FRAC_CONST(0.9998766184), FRAC_CONST(-0.0157073177)},
    {FRAC_CONST(0.3534748554), FRAC_CONST(0.9354440570)},   {FRAC_CONST(-0.7604059577), FRAC_CONST(0.6494480371)},  {FRAC_CONST(-0.8686315417), FRAC_CONST(-0.4954586625)},
    {FRAC_CONST(0.1719291061), FRAC_CONST(-0.9851093292)},  {FRAC_CONST(0.9851093292), FRAC_CONST(-0.1719291061)},  {FRAC_CONST(0.4954586625), FRAC_CONST(0.8686315417)},
    {FRAC_CONST(-0.6494480371), FRAC_CONST(0.7604059577)},  {FRAC_CONST(-0.9354440570), FRAC_CONST(-0.3534748554)}, {FRAC_CONST(0.0157073177), FRAC_CONST(-0.9998766184)},
    {FRAC_CONST(0.9460853338), FRAC_CONST(-0.3239174187)},  {FRAC_CONST(0.6252426505), FRAC_CONST(0.7804304361)},   {FRAC_CONST(-0.5224985480), FRAC_CONST(0.8526401520)},
    {FRAC_CONST(-0.9792228341), FRAC_CONST(-0.2027872950)}, {FRAC_CONST(-0.1409012377), FRAC_CONST(-0.9900236726)}, {FRAC_CONST(0.8837656379), FRAC_CONST(-0.4679298103)},
    {FRAC_CONST(0.7396311164), FRAC_CONST(0.6730124950)},   {FRAC_CONST(-0.3826834261), FRAC_CONST(0.9238795042)},  {FRAC_CONST(-0.9988898635), FRAC_CONST(-0.0471064523)},
    {FRAC_CONST(-0.2940403223), FRAC_CONST(-0.9557930231)}, {FRAC_CONST(0.7996846437), FRAC_CONST(-0.6004202366)},  {FRAC_CONST(0.8358073831), FRAC_CONST(0.5490227938)},
    {FRAC_CONST(-0.2334453613), FRAC_CONST(0.9723699093)},  {FRAC_CONST(-0.9939609766), FRAC_CONST(0.1097343117)},  {FRAC_CONST(-0.4399391711), FRAC_CONST(-0.8980275989)},
    {FRAC_CONST(0.6959127784), FRAC_CONST(-0.7181262970)},  {FRAC_CONST(0.9114032984), FRAC_CONST(0.4115143716)},   {FRAC_CONST(-0.0784590989), FRAC_CONST(0.9969173074)},
    {FRAC_CONST(-0.9645574093), FRAC_CONST(0.2638730407)},  {FRAC_CONST(-0.5750052333), FRAC_CONST(-0.8181497455)}, {FRAC_CONST(0.5750052333), FRAC_CONST(-0.8181497455)},
    {FRAC_CONST(0.9645574093), FRAC_CONST(0.2638730407)},   {FRAC_CONST(0.0784590989), FRAC_CONST(0.9969173074)},   {FRAC_CONST(-0.9114032984), FRAC_CONST(0.4115143716)},
    {FRAC_CONST(-0.6959127784), FRAC_CONST(-0.7181262970)}, {FRAC_CONST(0.4399391711), FRAC_CONST(-0.8980275989)},  {FRAC_CONST(0.9939609766), FRAC_CONST(0.1097343117)},
    {FRAC_CONST(0.2334453613), FRAC_CONST(0.9723699093)},   {FRAC_CONST(-0.8358073831), FRAC_CONST(0.5490227938)},  {FRAC_CONST(-0.7996846437), FRAC_CONST(-0.6004202366)},
    {FRAC_CONST(0.2940403223), FRAC_CONST(-0.9557930231)},  {FRAC_CONST(0.9988898635), FRAC_CONST(-0.0471064523)},  {FRAC_CONST(0.3826834261), FRAC_CONST(0.9238795042)},
    {FRAC_CONST(-0.7396311164), FRAC_CONST(0.6730124950)}};
// ——————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
// ——————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————

static const hcb hcb1_1[] = {{/* 00000 */ 0, 0}, {/*       */ 0, 0},  {/*       */ 0, 0},  {/*       */ 0, 0},  {/*       */ 0, 0},  {/*       */ 0, 0},  {/*       */ 0, 0},  {/*       */ 0, 0},
                             {/*       */ 0, 0}, {/*       */ 0, 0},  {/*       */ 0, 0},  {/*       */ 0, 0},  {/*       */ 0, 0},  {/*       */ 0, 0},  {/*       */ 0, 0},  {/*       */ 0, 0},
                             {/* 10000 */ 1, 0}, {/* 10001 */ 2, 0},  {/* 10010 */ 3, 0},  {/* 10011 */ 4, 0},  {/* 10100 */ 5, 0},  {/* 10101 */ 6, 0},  {/* 10110 */ 7, 0},  {/* 10111 */ 8, 0},
                             {/* 11000 */ 9, 2}, {/* 11001 */ 13, 2}, {/* 11010 */ 17, 2}, {/* 11011 */ 21, 2}, {/* 11100 */ 25, 2}, {/* 11101 */ 29, 2}, {/* 11110 */ 33, 4}, {/* 11111 */ 49, 6}};
// ——————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
/* defines whether a huffman codebook is unsigned or not */
/* Table 4.6.2 */
static const uint8_t unsigned_cb[] = {
    0, 0, 0, 1, 1, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
};
static const int hcb_2_quad_table_size[] = {0, 114, 86, 0, 185, 0, 0, 0, 0, 0, 0, 0};
static const int hcb_2_pair_table_size[] = {0, 0, 0, 0, 0, 0, 126, 0, 83, 0, 210, 373};
static const int hcb_bin_table_size[] = {0, 0, 0, 161, 0, 161, 0, 127, 0, 337, 0, 0};
// ——————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
/* 2nd step table
 * Gives size of codeword and actual data (x,y,v,w) */
static const hcb_2_quad hcb1_2[] = {
    {1, 0, 0, 0, 0},    {5, 1, 0, 0, 0},     {5, -1, 0, 0, 0},    {5, 0, 0, 0, -1},    {5, 0, 1, 0, 0},    {5, 0, 0, 0, 1},     {5, 0, 0, -1, 0},     {5, 0, 0, 1, 0},    {5, 0, -1, 0, 0},
    {7, 1, -1, 0, 0},   {7, -1, 1, 0, 0},    {7, 0, 0, -1, 1},    {7, 0, 1, -1, 0},    {7, 0, -1, 1, 0},   {7, 0, 0, 1, -1},    {7, 1, 1, 0, 0},      {7, 0, 0, -1, -1},  {7, -1, -1, 0, 0},
    {7, 0, -1, -1, 0},  {7, 1, 0, -1, 0},    {7, 0, 1, 0, -1},    {7, -1, 0, 1, 0},    {7, 0, 0, 1, 1},    {7, 1, 0, 1, 0},     {7, 0, -1, 0, 1},     {7, 0, 1, 1, 0},    {7, 0, 1, 0, 1},
    {7, -1, 0, -1, 0},  {7, 1, 0, 0, 1},     {7, -1, 0, 0, -1},   {7, 1, 0, 0, -1},    {7, -1, 0, 0, 1},   {7, 0, -1, 0, -1},   {9, 1, 1, -1, 0},     {9, -1, 1, -1, 0},  {9, 1, -1, 1, 0},
    {9, 0, 1, 1, -1},   {9, 0, 1, -1, 1},    {9, 0, -1, 1, 1},    {9, 0, -1, 1, -1},   {9, 1, -1, -1, 0},  {9, 1, 0, -1, 1},    {9, 0, 1, -1, -1},    {9, -1, 1, 1, 0},   {9, -1, 0, 1, -1},
    {9, -1, -1, 1, 0},  {9, 0, -1, -1, 1},   {9, 1, -1, 0, 1},    {9, 1, -1, 0, -1},   {9, -1, 1, 0, -1},  {9, -1, 1, 0, -1},   {9, -1, 1, 0, -1},    {9, -1, 1, 0, -1},  {9, -1, -1, -1, 0},
    {9, -1, -1, -1, 0}, {9, -1, -1, -1, 0},  {9, -1, -1, -1, 0},  {9, 0, -1, -1, -1},  {9, 0, -1, -1, -1}, {9, 0, -1, -1, -1},  {9, 0, -1, -1, -1},   {9, 0, 1, 1, 1},    {9, 0, 1, 1, 1},
    {9, 0, 1, 1, 1},    {9, 0, 1, 1, 1},     {9, 1, 0, 1, -1},    {9, 1, 0, 1, -1},    {9, 1, 0, 1, -1},   {9, 1, 0, 1, -1},    {9, 1, 1, 0, 1},      {9, 1, 1, 0, 1},    {9, 1, 1, 0, 1},
    {9, 1, 1, 0, 1},    {9, -1, 1, 0, 1},    {9, -1, 1, 0, 1},    {9, -1, 1, 0, 1},    {9, -1, 1, 0, 1},   {9, 1, 1, 1, 0},     {9, 1, 1, 1, 0},      {9, 1, 1, 1, 0},    {9, 1, 1, 1, 0},
    {10, -1, -1, 0, 1}, {10, -1, -1, 0, 1},  {10, -1, 0, -1, -1}, {10, -1, 0, -1, -1}, {10, 1, 1, 0, -1},  {10, 1, 1, 0, -1},   {10, 1, 0, -1, -1},   {10, 1, 0, -1, -1}, {10, -1, 0, -1, 1},
    {10, -1, 0, -1, 1}, {10, -1, -1, 0, -1}, {10, -1, -1, 0, -1}, {10, -1, 0, 1, 1},   {10, -1, 0, 1, 1},  {10, 1, 0, 1, 1},    {10, 1, 0, 1, 1},     {11, 1, -1, 1, -1}, {11, -1, 1, -1, 1},
    {11, -1, 1, 1, -1}, {11, 1, -1, -1, 1},  {11, 1, 1, 1, 1},    {11, -1, -1, 1, 1},  {11, 1, 1, -1, -1}, {11, -1, -1, 1, -1}, {11, -1, -1, -1, -1}, {11, 1, 1, -1, 1},  {11, 1, -1, 1, 1},
    {11, -1, 1, 1, 1},  {11, -1, 1, -1, -1}, {11, -1, -1, -1, 1}, {11, 1, -1, -1, -1}, {11, 1, 1, 1, -1}};
// ——————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
static const hcb hcb2_1[] = {{/* 00000 */ 0, 0},  {/*       */ 0, 0},  {/*       */ 0, 0},  {/*       */ 0, 0},  {/* 00100 */ 1, 0},  {/*       */ 1, 0},  {/* 00110 */ 2, 0},  {/* 00111 */ 3, 0},
                             {/* 01000 */ 4, 0},  {/* 01001 */ 5, 0},  {/* 01010 */ 6, 0},  {/* 01011 */ 7, 0},  {/* 01100 */ 8, 0},  {/* 01101 */ 9, 1},  {/* 01110 */ 11, 1}, {/* 01111 */ 13, 1},
                             {/* 10000 */ 15, 1}, {/* 10001 */ 17, 1}, {/* 10010 */ 19, 1}, {/* 10011 */ 21, 1}, {/* 10100 */ 23, 1}, {/* 10101 */ 25, 1}, {/* 10110 */ 27, 1}, {/* 10111 */ 29, 1},
                             {/* 11000 */ 31, 1}, {/* 11001 */ 33, 2}, {/* 11010 */ 37, 2}, {/* 11011 */ 41, 2}, {/* 11100 */ 45, 3}, {/* 11101 */ 53, 3}, {/* 11110 */ 61, 3}, {/* 11111 */ 69, 4}};
// ——————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
/* 2nd step table
 *  Gives size of codeword and actual data (x,y,v,w) */
static const hcb_2_quad hcb2_2[] = {{3, 0, 0, 0, 0},     {4, 1, 0, 0, 0},    {5, -1, 0, 0, 0},   {5, 0, 0, 0, 1},   {5, 0, 0, -1, 0},   {5, 0, 0, 0, -1},  {5, 0, -1, 0, 0},   {5, 0, 0, 1, 0},
                                    {5, 0, 1, 0, 0},     {6, 0, -1, 1, 0},   {6, -1, 1, 0, 0},   {6, 0, 1, -1, 0},  {6, 0, 0, 1, -1},   {6, 0, 1, 0, -1},  {6, 0, 0, -1, 1},   {6, -1, 0, 0, -1},
                                    {6, 1, -1, 0, 0},    {6, 1, 0, -1, 0},   {6, -1, -1, 0, 0},  {6, 0, 0, -1, -1}, {6, 1, 0, 1, 0},    {6, 1, 0, 0, 1},   {6, 0, -1, 0, 1},   {6, -1, 0, 1, 0},
                                    {6, 0, 1, 0, 1},     {6, 0, -1, -1, 0},  {6, -1, 0, 0, 1},   {6, 0, -1, 0, -1}, {6, -1, 0, -1, 0},  {6, 1, 1, 0, 0},   {6, 0, 1, 1, 0},    {6, 0, 0, 1, 1},
                                    {6, 1, 0, 0, -1},    {7, 0, 1, -1, 1},   {7, 1, 0, -1, 1},   {7, -1, 1, -1, 0}, {7, 0, -1, 1, -1},  {7, 1, -1, 1, 0},  {7, 1, 1, 0, -1},   {7, 1, 0, 1, 1},
                                    {7, -1, 1, 1, 0},    {7, 0, -1, -1, 1},  {7, 1, 1, 1, 0},    {7, -1, 0, 1, -1}, {7, -1, -1, -1, 0}, {7, -1, 0, -1, 1}, {7, -1, 0, -1, 1},  {7, 1, -1, -1, 0},
                                    {7, 1, -1, -1, 0},   {7, 1, 1, -1, 0},   {7, 1, 1, -1, 0},   {8, 1, -1, 0, 1},  {8, -1, 1, 0, -1},  {8, -1, -1, 1, 0}, {8, -1, 0, 1, 1},   {8, -1, -1, 0, 1},
                                    {8, -1, -1, 0, -1},  {8, 0, -1, -1, -1}, {8, 1, 0, 1, -1},   {8, 1, 0, -1, -1}, {8, 0, 1, -1, -1},  {8, 0, 1, 1, 1},   {8, -1, 1, 0, 1},   {8, -1, 0, -1, -1},
                                    {8, 0, 1, 1, -1},    {8, 1, -1, 0, -1},  {8, 0, -1, 1, 1},   {8, 1, 1, 0, 1},   {8, 1, -1, 1, -1},  {8, -1, 1, -1, 1}, {8, -1, 1, -1, 1},  {9, 1, -1, -1, 1},
                                    {9, -1, -1, -1, -1}, {9, -1, 1, 1, -1},  {9, -1, 1, 1, 1},   {9, 1, 1, 1, 1},   {9, -1, -1, 1, -1}, {9, 1, -1, 1, 1},  {9, -1, 1, -1, -1}, {9, -1, -1, 1, 1},
                                    {9, 1, 1, -1, -1},   {9, 1, -1, -1, -1}, {9, -1, -1, -1, 1}, {9, 1, 1, -1, 1},  {9, 1, 1, 1, -1}};
// ——————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
static const hcb_bin_quad hcb3[] = {
    {/*  0 */ 0, {1, 2, 0, 0}},   {/*  1 */ 1, {0, 0, 0, 0}}, /* 0 */
    {/*  2 */ 0, {1, 2, 0, 0}},   {/*  3 */ 0, {2, 3, 0, 0}},   {/*  4 */ 0, {3, 4, 0, 0}},   {/*  5 */ 0, {4, 5, 0, 0}},   {/*  6 */ 0, {5, 6, 0, 0}},   {/*  7 */ 0, {6, 7, 0, 0}},
    {/*  8 */ 0, {7, 8, 0, 0}},   {/*  9 */ 1, {1, 0, 0, 0}}, /* 1000 */
    {/* 10 */ 1, {0, 0, 0, 1}},                               /* 1001 */
    {/* 11 */ 1, {0, 1, 0, 0}},                               /* 1010 */
    {/* 12 */ 1, {0, 0, 1, 0}},                               /* 1011 */
    {/* 13 */ 0, {4, 5, 0, 0}},   {/* 14 */ 0, {5, 6, 0, 0}},   {/* 15 */ 0, {6, 7, 0, 0}},   {/* 16 */ 0, {7, 8, 0, 0}},   {/* 17 */ 1, {1, 1, 0, 0}},   {/* 18 */ 1, {0, 0, 1, 1}},
    {/* 19 */ 0, {6, 7, 0, 0}},   {/* 20 */ 0, {7, 8, 0, 0}},   {/* 21 */ 0, {8, 9, 0, 0}},   {/* 22 */ 0, {9, 10, 0, 0}},  {/* 23 */ 0, {10, 11, 0, 0}}, {/* 24 */ 0, {11, 12, 0, 0}},
    {/* 25 */ 1, {0, 1, 1, 0}}, /* 110100 */
    {/* 26 */ 1, {0, 1, 0, 1}}, /* 110101 */
    {/* 27 */ 1, {1, 0, 1, 0}}, /* 110110 */
    {/* 28 */ 1, {0, 1, 1, 1}}, /* 110111 */
    {/* 29 */ 1, {1, 0, 0, 1}}, /* 111000 */
    {/* 30 */ 1, {1, 1, 1, 0}}, /* 111001 */
    {/* 31 */ 0, {6, 7, 0, 0}},   {/* 32 */ 0, {7, 8, 0, 0}},   {/* 33 */ 0, {8, 9, 0, 0}},   {/* 34 */ 0, {9, 10, 0, 0}},  {/* 35 */ 0, {10, 11, 0, 0}}, {/* 36 */ 0, {11, 12, 0, 0}},
    {/* 37 */ 1, {1, 1, 1, 1}}, /* 1110100 */
    {/* 38 */ 1, {1, 0, 1, 1}}, /* 1110101 */
    {/* 39 */ 1, {1, 1, 0, 1}}, /* 1110110 */
    {/* 40 */ 0, {9, 10, 0, 0}},  {/* 41 */ 0, {10, 11, 0, 0}}, {/* 42 */ 0, {11, 12, 0, 0}}, {/* 43 */ 0, {12, 13, 0, 0}}, {/* 44 */ 0, {13, 14, 0, 0}}, {/* 45 */ 0, {14, 15, 0, 0}},
    {/* 46 */ 0, {15, 16, 0, 0}}, {/* 47 */ 0, {16, 17, 0, 0}}, {/* 48 */ 0, {17, 18, 0, 0}}, {/* 49 */ 1, {2, 0, 0, 0}}, /* 11101110 */
    {/* 50 */ 1, {0, 0, 0, 2}},                                                                                           /* 11101111 */
    {/* 51 */ 1, {0, 0, 1, 2}},                                                                                           /* 11110000 */
    {/* 52 */ 1, {2, 1, 0, 0}},                                                                                           /* 11110001 */
    {/* 53 */ 1, {1, 2, 1, 0}},                                                                                           /* 11110010 */
    {/* 54 */ 0, {13, 14, 0, 0}}, {/* 55 */ 0, {14, 15, 0, 0}}, {/* 56 */ 0, {15, 16, 0, 0}}, {/* 57 */ 0, {16, 17, 0, 0}}, {/* 58 */ 0, {17, 18, 0, 0}}, {/* 59 */ 0, {18, 19, 0, 0}},
    {/* 60 */ 0, {19, 20, 0, 0}}, {/* 61 */ 0, {20, 21, 0, 0}}, {/* 62 */ 0, {21, 22, 0, 0}}, {/* 63 */ 0, {22, 23, 0, 0}}, {/* 64 */ 0, {23, 24, 0, 0}}, {/* 65 */ 0, {24, 25, 0, 0}},
    {/* 66 */ 0, {25, 26, 0, 0}}, {/* 67 */ 1, {0, 0, 2, 1}},   {/* 68 */ 1, {0, 1, 2, 1}},   {/* 69 */ 1, {1, 2, 0, 0}},   {/* 70 */ 1, {0, 1, 1, 2}},   {/* 71 */ 1, {2, 1, 1, 0}},
    {/* 72 */ 1, {0, 0, 2, 0}},   {/* 73 */ 1, {0, 2, 1, 0}},   {/* 74 */ 1, {0, 1, 2, 0}},   {/* 75 */ 1, {0, 2, 0, 0}},   {/* 76 */ 1, {0, 1, 0, 2}},   {/* 77 */ 1, {2, 0, 1, 0}},
    {/* 78 */ 1, {1, 2, 1, 1}},   {/* 79 */ 1, {0, 2, 1, 1}},   {/* 80 */ 1, {1, 1, 2, 0}},   {/* 81 */ 1, {1, 1, 2, 1}},   {/* 82 */ 0, {11, 12, 0, 0}}, {/* 83 */ 0, {12, 13, 0, 0}},
    {/* 84 */ 0, {13, 14, 0, 0}}, {/* 85 */ 0, {14, 15, 0, 0}}, {/* 86 */ 0, {15, 16, 0, 0}}, {/* 87 */ 0, {16, 17, 0, 0}}, {/* 88 */ 0, {17, 18, 0, 0}}, {/* 89 */ 0, {18, 19, 0, 0}},
    {/* 90 */ 0, {19, 20, 0, 0}}, {/* 91 */ 0, {20, 21, 0, 0}}, {/* 92 */ 0, {21, 22, 0, 0}}, {/* 93 */ 1, {1, 2, 0, 1}}, /* 1111101010 */
    {/* 94 */ 1, {1, 0, 2, 0}},                                                                                           /* 1111101011 */
    {/* 95 */ 1, {1, 0, 2, 1}},                                                                                           /* 1111101100 */
    {/* 96 */ 1, {0, 2, 0, 1}},                                                                                           /* 1111101101 */
    {/* 97 */ 1, {2, 1, 1, 1}},                                                                                           /* 1111101110 */
    {/* 98 */ 1, {1, 1, 1, 2}},                                                                                           /* 1111101111 */
    {/* 99 */ 1, {2, 1, 0, 1}},                                                                                           /* 1111110000 */
    {/* 00 */ 1, {1, 0, 1, 2}},                                                                                           /* 1111110001 */
    {/* 01 */ 1, {0, 0, 2, 2}},                                                                                           /* 1111110010 */
    {/* 02 */ 1, {0, 1, 2, 2}},                                                                                           /* 1111110011 */
    {/* 03 */ 1, {2, 2, 1, 0}},                                                                                           /* 1111110100 */
    {/* 04 */ 1, {1, 2, 2, 0}},                                                                                           /* 1111110101 */
    {/* 05 */ 1, {1, 0, 0, 2}},                                                                                           /* 1111110110 */
    {/* 06 */ 1, {2, 0, 0, 1}},                                                                                           /* 1111110111 */
    {/* 07 */ 1, {0, 2, 2, 1}},                                                                                           /* 1111111000 */
    {/* 08 */ 0, {7, 8, 0, 0}},   {/* 09 */ 0, {8, 9, 0, 0}},   {/* 10 */ 0, {9, 10, 0, 0}},  {/* 11 */ 0, {10, 11, 0, 0}}, {/* 12 */ 0, {11, 12, 0, 0}}, {/* 13 */ 0, {12, 13, 0, 0}},
    {/* 14 */ 0, {13, 14, 0, 0}}, {/* 15 */ 1, {2, 2, 0, 0}}, /* 11111110010 */
    {/* 16 */ 1, {1, 2, 2, 1}},                               /* 11111110011 */
    {/* 17 */ 1, {1, 1, 0, 2}},                               /* 11111110100 */
    {/* 18 */ 1, {2, 0, 1, 1}},                               /* 11111110101 */
    {/* 19 */ 1, {1, 1, 2, 2}},                               /* 11111110110 */
    {/* 20 */ 1, {2, 2, 1, 1}},                               /* 11111110111 */
    {/* 21 */ 1, {0, 2, 2, 0}},                               /* 11111111000 */
    {/* 22 */ 1, {0, 2, 1, 2}},                               /* 11111111001 */
    {/* 23 */ 0, {6, 7, 0, 0}},   {/* 24 */ 0, {7, 8, 0, 0}},   {/* 25 */ 0, {8, 9, 0, 0}},   {/* 26 */ 0, {9, 10, 0, 0}},  {/* 27 */ 0, {10, 11, 0, 0}}, {/* 28 */ 0, {11, 12, 0, 0}},
    {/* 29 */ 1, {1, 0, 2, 2}},                                                                                           /* 111111110100 */
    {/* 30 */ 1, {2, 2, 0, 1}},                                                                                           /* 111111110101 */
    {/* 31 */ 1, {2, 1, 2, 0}},                                                                                           /* 111111110110 */
    {/* 32 */ 1, {2, 2, 2, 0}},                                                                                           /* 111111110111 */
    {/* 33 */ 1, {0, 2, 2, 2}},                                                                                           /* 111111111000 */
    {/* 34 */ 1, {2, 2, 2, 1}},                                                                                           /* 111111111001 */
    {/* 35 */ 1, {2, 1, 2, 1}},                                                                                           /* 111111111010 */
    {/* 36 */ 1, {1, 2, 1, 2}},                                                                                           /* 111111111011 */
    {/* 37 */ 1, {1, 2, 2, 2}},                                                                                           /* 111111111100 */
    {/* 38 */ 0, {3, 4, 0, 0}},   {/* 39 */ 0, {4, 5, 0, 0}},   {/* 40 */ 0, {5, 6, 0, 0}},   {/* 41 */ 1, {0, 2, 0, 2}}, /* 1111111111010 */
    {/* 42 */ 1, {2, 0, 2, 0}},                                                                                           /* 1111111111011 */
    {/* 43 */ 1, {1, 2, 0, 2}},                                                                                           /* 1111111111100 */
    {/* 44 */ 0, {3, 4, 0, 0}},   {/* 45 */ 0, {4, 5, 0, 0}},   {/* 46 */ 0, {5, 6, 0, 0}},   {/* 47 */ 1, {2, 0, 2, 1}}, /* 11111111111010 */
    {/* 48 */ 1, {2, 1, 1, 2}},                                                                                           /* 11111111111011 */
    {/* 49 */ 1, {2, 1, 0, 2}},                                                                                           /* 11111111111100 */
    {/* 50 */ 0, {3, 4, 0, 0}},   {/* 51 */ 0, {4, 5, 0, 0}},   {/* 52 */ 0, {5, 6, 0, 0}},   {/* 53 */ 1, {2, 2, 2, 2}}, /* 111111111111010 */
    {/* 54 */ 1, {2, 2, 1, 2}},                                                                                           /* 111111111111011 */
    {/* 55 */ 1, {2, 1, 2, 2}},                                                                                           /* 111111111111100 */
    {/* 56 */ 1, {2, 0, 1, 2}},                                                                                           /* 111111111111101 */
    {/* 57 */ 1, {2, 0, 0, 2}},                                                                                           /* 111111111111110 */
    {/* 58 */ 0, {1, 2, 0, 0}},   {/* 59 */ 1, {2, 2, 0, 2}},                                                             /* 1111111111111110 */
    {/* 60 */ 1, {2, 0, 2, 2}}                                                                                            /* 1111111111111111 */
};
// ——————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
static const hcb hcb4_1[] = {{/* 00000 */ 0, 0},  {/*       */ 0, 0},  {/* 00010 */ 1, 0},  {/*       */ 1, 0},  {/* 00100 */ 2, 0},  {/*       */ 2, 0},  {/* 00110 */ 3, 0},  {/*       */ 3, 0},
                             {/* 01000 */ 4, 0},  {/*       */ 4, 0},  {/* 01010 */ 5, 0},  {/*       */ 5, 0},  {/* 01100 */ 6, 0},  {/*       */ 6, 0},  {/* 01110 */ 7, 0},  {/*       */ 7, 0},
                             {/* 10000 */ 8, 0},  {/*       */ 8, 0},  {/* 10010 */ 9, 0},  {/*       */ 9, 0},  {/* 10100 */ 10, 0}, {/* 10101 */ 11, 0}, {/* 10110 */ 12, 0}, {/* 10111 */ 13, 0},
                             {/* 11000 */ 14, 0}, {/* 11001 */ 15, 0}, {/* 11010 */ 16, 2}, {/* 11011 */ 20, 2}, {/* 11100 */ 24, 3}, {/* 11101 */ 32, 3}, {/* 11110 */ 40, 4}, {/* 11111 */ 56, 7}};
// ——————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
/* 2nd step table
 * Gives size of codeword and actual data (x,y,v,w) */
static const hcb_2_quad hcb4_2[] = {
    {4, 1, 1, 1, 1},  {4, 0, 1, 1, 1},  {4, 1, 1, 0, 1},  {4, 1, 1, 1, 0},  {4, 1, 0, 1, 1},  {4, 1, 0, 0, 0},  {4, 1, 1, 0, 0},  {4, 0, 0, 0, 0},  {4, 0, 0, 1, 1},  {4, 1, 0, 1, 0},
    {5, 1, 0, 0, 1},  {5, 0, 1, 1, 0},  {5, 0, 0, 0, 1},  {5, 0, 1, 0, 1},  {5, 0, 0, 1, 0},  {5, 0, 1, 0, 0},  {7, 2, 1, 1, 1},  {7, 1, 1, 2, 1},  {7, 1, 2, 1, 1},  {7, 1, 1, 1, 2},
    {7, 2, 1, 1, 0},  {7, 2, 1, 0, 1},  {7, 1, 2, 1, 0},  {7, 2, 0, 1, 1},  {7, 0, 1, 2, 1},  {7, 0, 1, 2, 1},  {8, 0, 1, 1, 2},  {8, 1, 1, 2, 0},  {8, 0, 2, 1, 1},  {8, 1, 0, 1, 2},
    {8, 1, 2, 0, 1},  {8, 1, 1, 0, 2},  {8, 1, 0, 2, 1},  {8, 2, 1, 0, 0},  {8, 2, 0, 1, 0},  {8, 1, 2, 0, 0},  {8, 2, 0, 0, 1},  {8, 0, 1, 0, 2},  {8, 0, 2, 1, 0},  {8, 0, 0, 1, 2},
    {8, 0, 1, 2, 0},  {8, 0, 1, 2, 0},  {8, 0, 2, 0, 1},  {8, 0, 2, 0, 1},  {8, 1, 0, 0, 2},  {8, 1, 0, 0, 2},  {8, 0, 0, 2, 1},  {8, 0, 0, 2, 1},  {8, 1, 0, 2, 0},  {8, 1, 0, 2, 0},
    {8, 2, 0, 0, 0},  {8, 2, 0, 0, 0},  {8, 0, 0, 0, 2},  {8, 0, 0, 0, 2},  {9, 0, 2, 0, 0},  {9, 0, 0, 2, 0},  {9, 1, 2, 2, 1},  {9, 1, 2, 2, 1},  {9, 1, 2, 2, 1},  {9, 1, 2, 2, 1},
    {9, 1, 2, 2, 1},  {9, 1, 2, 2, 1},  {9, 1, 2, 2, 1},  {9, 1, 2, 2, 1},  {9, 2, 2, 1, 1},  {9, 2, 2, 1, 1},  {9, 2, 2, 1, 1},  {9, 2, 2, 1, 1},  {9, 2, 2, 1, 1},  {9, 2, 2, 1, 1},
    {9, 2, 2, 1, 1},  {9, 2, 2, 1, 1},  {9, 2, 1, 2, 1},  {9, 2, 1, 2, 1},  {9, 2, 1, 2, 1},  {9, 2, 1, 2, 1},  {9, 2, 1, 2, 1},  {9, 2, 1, 2, 1},  {9, 2, 1, 2, 1},  {9, 2, 1, 2, 1},
    {9, 1, 1, 2, 2},  {9, 1, 1, 2, 2},  {9, 1, 1, 2, 2},  {9, 1, 1, 2, 2},  {9, 1, 1, 2, 2},  {9, 1, 1, 2, 2},  {9, 1, 1, 2, 2},  {9, 1, 1, 2, 2},  {9, 1, 2, 1, 2},  {9, 1, 2, 1, 2},
    {9, 1, 2, 1, 2},  {9, 1, 2, 1, 2},  {9, 1, 2, 1, 2},  {9, 1, 2, 1, 2},  {9, 1, 2, 1, 2},  {9, 1, 2, 1, 2},  {9, 2, 1, 1, 2},  {9, 2, 1, 1, 2},  {9, 2, 1, 1, 2},  {9, 2, 1, 1, 2},
    {9, 2, 1, 1, 2},  {9, 2, 1, 1, 2},  {9, 2, 1, 1, 2},  {9, 2, 1, 1, 2},  {10, 1, 2, 2, 0}, {10, 1, 2, 2, 0}, {10, 1, 2, 2, 0}, {10, 1, 2, 2, 0}, {10, 2, 2, 1, 0}, {10, 2, 2, 1, 0},
    {10, 2, 2, 1, 0}, {10, 2, 2, 1, 0}, {10, 2, 1, 2, 0}, {10, 2, 1, 2, 0}, {10, 2, 1, 2, 0}, {10, 2, 1, 2, 0}, {10, 0, 2, 2, 1}, {10, 0, 2, 2, 1}, {10, 0, 2, 2, 1}, {10, 0, 2, 2, 1},
    {10, 0, 1, 2, 2}, {10, 0, 1, 2, 2}, {10, 0, 1, 2, 2}, {10, 0, 1, 2, 2}, {10, 2, 2, 0, 1}, {10, 2, 2, 0, 1}, {10, 2, 2, 0, 1}, {10, 2, 2, 0, 1}, {10, 0, 2, 1, 2}, {10, 0, 2, 1, 2},
    {10, 0, 2, 1, 2}, {10, 0, 2, 1, 2}, {10, 2, 0, 2, 1}, {10, 2, 0, 2, 1}, {10, 2, 0, 2, 1}, {10, 2, 0, 2, 1}, {10, 1, 0, 2, 2}, {10, 1, 0, 2, 2}, {10, 1, 0, 2, 2}, {10, 1, 0, 2, 2},
    {10, 2, 2, 2, 1}, {10, 2, 2, 2, 1}, {10, 2, 2, 2, 1}, {10, 2, 2, 2, 1}, {10, 1, 2, 0, 2}, {10, 1, 2, 0, 2}, {10, 1, 2, 0, 2}, {10, 1, 2, 0, 2}, {10, 2, 0, 1, 2}, {10, 2, 0, 1, 2},
    {10, 2, 0, 1, 2}, {10, 2, 0, 1, 2}, {10, 2, 1, 0, 2}, {10, 2, 1, 0, 2}, {10, 2, 1, 0, 2}, {10, 2, 1, 0, 2}, {10, 1, 2, 2, 2}, {10, 1, 2, 2, 2}, {10, 1, 2, 2, 2}, {10, 1, 2, 2, 2},
    {11, 2, 1, 2, 2}, {11, 2, 1, 2, 2}, {11, 2, 2, 1, 2}, {11, 2, 2, 1, 2}, {11, 0, 2, 2, 0}, {11, 0, 2, 2, 0}, {11, 2, 2, 0, 0}, {11, 2, 2, 0, 0}, {11, 0, 0, 2, 2}, {11, 0, 0, 2, 2},
    {11, 2, 0, 2, 0}, {11, 2, 0, 2, 0}, {11, 0, 2, 0, 2}, {11, 0, 2, 0, 2}, {11, 2, 0, 0, 2}, {11, 2, 0, 0, 2}, {11, 2, 2, 2, 2}, {11, 2, 2, 2, 2}, {11, 0, 2, 2, 2}, {11, 0, 2, 2, 2},
    {11, 2, 2, 2, 0}, {11, 2, 2, 2, 0}, {12, 2, 2, 0, 2}, {12, 2, 0, 2, 2},
};
// ——————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
static const hcb_bin_pair hcb5[] = {
    {/*  0 */ 0, {1, 2}},   {/*  1 */ 1, {0, 0}}, /* 0 */
    {/*  2 */ 0, {1, 2}},   {/*  3 */ 0, {2, 3}},   {/*  4 */ 0, {3, 4}},   {/*  5 */ 0, {4, 5}},   {/*  6 */ 0, {5, 6}},   {/*  7 */ 0, {6, 7}},   {/*  8 */ 0, {7, 8}},
    {/*  9 */ 1, {-1, 0}}, /* 1000 */
    {/* 10 */ 1, {1, 0}},  /* 1001 */
    {/* 11 */ 1, {0, 1}},  /* 1010 */
    {/* 12 */ 1, {0, -1}}, /* 1011 */
    {/* 13 */ 0, {4, 5}},   {/* 14 */ 0, {5, 6}},   {/* 15 */ 0, {6, 7}},   {/* 16 */ 0, {7, 8}},   {/* 17 */ 1, {1, -1}},  {/* 18 */ 1, {-1, 1}},  {/* 19 */ 1, {-1, -1}},
    {/* 20 */ 1, {1, 1}},   {/* 21 */ 0, {4, 5}},   {/* 22 */ 0, {5, 6}},   {/* 23 */ 0, {6, 7}},   {/* 24 */ 0, {7, 8}},   {/* 25 */ 0, {8, 9}},   {/* 26 */ 0, {9, 10}},
    {/* 27 */ 0, {10, 11}}, {/* 28 */ 0, {11, 12}}, {/* 29 */ 0, {12, 13}}, {/* 30 */ 0, {13, 14}}, {/* 31 */ 0, {14, 15}}, {/* 32 */ 0, {15, 16}}, {/* 33 */ 1, {-2, 0}},
    {/* 34 */ 1, {0, 2}},   {/* 35 */ 1, {2, 0}},   {/* 36 */ 1, {0, -2}},  {/* 37 */ 0, {12, 13}}, {/* 38 */ 0, {13, 14}}, {/* 39 */ 0, {14, 15}}, {/* 40 */ 0, {15, 16}},
    {/* 41 */ 0, {16, 17}}, {/* 42 */ 0, {17, 18}}, {/* 43 */ 0, {18, 19}}, {/* 44 */ 0, {19, 20}}, {/* 45 */ 0, {20, 21}}, {/* 46 */ 0, {21, 22}}, {/* 47 */ 0, {22, 23}},
    {/* 48 */ 0, {23, 24}}, {/* 49 */ 1, {-2, -1}}, {/* 50 */ 1, {2, 1}},   {/* 51 */ 1, {-1, -2}}, {/* 52 */ 1, {1, 2}},   {/* 53 */ 1, {-2, 1}},  {/* 54 */ 1, {2, -1}},
    {/* 55 */ 1, {-1, 2}},  {/* 56 */ 1, {1, -2}},  {/* 57 */ 1, {-3, 0}},  {/* 58 */ 1, {3, 0}},   {/* 59 */ 1, {0, -3}},  {/* 60 */ 1, {0, 3}},   {/* 61 */ 0, {12, 13}},
    {/* 62 */ 0, {13, 14}}, {/* 63 */ 0, {14, 15}}, {/* 64 */ 0, {15, 16}}, {/* 65 */ 0, {16, 17}}, {/* 66 */ 0, {17, 18}}, {/* 67 */ 0, {18, 19}}, {/* 68 */ 0, {19, 20}},
    {/* 69 */ 0, {20, 21}}, {/* 70 */ 0, {21, 22}}, {/* 71 */ 0, {22, 23}}, {/* 72 */ 0, {23, 24}}, {/* 73 */ 1, {-3, -1}}, {/* 74 */ 1, {1, 3}},   {/* 75 */ 1, {3, 1}},
    {/* 76 */ 1, {-1, -3}}, {/* 77 */ 1, {-3, 1}},  {/* 78 */ 1, {3, -1}},  {/* 79 */ 1, {1, -3}},  {/* 80 */ 1, {-1, 3}},  {/* 81 */ 1, {-2, 2}},  {/* 82 */ 1, {2, 2}},
    {/* 83 */ 1, {-2, -2}}, {/* 84 */ 1, {2, -2}},  {/* 85 */ 0, {12, 13}}, {/* 86 */ 0, {13, 14}}, {/* 87 */ 0, {14, 15}}, {/* 88 */ 0, {15, 16}}, {/* 89 */ 0, {16, 17}},
    {/* 90 */ 0, {17, 18}}, {/* 91 */ 0, {18, 19}}, {/* 92 */ 0, {19, 20}}, {/* 93 */ 0, {20, 21}}, {/* 94 */ 0, {21, 22}}, {/* 95 */ 0, {22, 23}}, {/* 96 */ 0, {23, 24}},
    {/* 97 */ 1, {-3, -2}}, {/* 98 */ 1, {3, -2}},  {/* 99 */ 1, {-2, 3}},  {/* 00 */ 1, {2, -3}},  {/* 01 */ 1, {3, 2}},   {/* 02 */ 1, {2, 3}},   {/* 03 */ 1, {-3, 2}},
    {/* 04 */ 1, {-2, -3}}, {/* 05 */ 1, {0, -4}},  {/* 06 */ 1, {-4, 0}},  {/* 07 */ 1, {4, 1}},   {/* 08 */ 1, {4, 0}},   {/* 09 */ 0, {12, 13}}, {/* 10 */ 0, {13, 14}},
    {/* 11 */ 0, {14, 15}}, {/* 12 */ 0, {15, 16}}, {/* 13 */ 0, {16, 17}}, {/* 14 */ 0, {17, 18}}, {/* 15 */ 0, {18, 19}}, {/* 16 */ 0, {19, 20}}, {/* 17 */ 0, {20, 21}},
    {/* 18 */ 0, {21, 22}}, {/* 19 */ 0, {22, 23}}, {/* 20 */ 0, {23, 24}}, {/* 21 */ 1, {-4, -1}}, {/* 22 */ 1, {0, 4}},   {/* 23 */ 1, {4, -1}},  {/* 24 */ 1, {-1, -4}},
    {/* 25 */ 1, {1, 4}},   {/* 26 */ 1, {-1, 4}},  {/* 27 */ 1, {-4, 1}},  {/* 28 */ 1, {1, -4}},  {/* 29 */ 1, {3, -3}},  {/* 30 */ 1, {-3, -3}}, {/* 31 */ 1, {-3, 3}},
    {/* 32 */ 1, {-2, 4}},  {/* 33 */ 1, {-4, -2}}, {/* 34 */ 1, {4, 2}},   {/* 35 */ 1, {2, -4}},  {/* 36 */ 1, {2, 4}},   {/* 37 */ 1, {3, 3}},   {/* 38 */ 1, {-4, 2}},
    {/* 39 */ 0, {6, 7}},   {/* 40 */ 0, {7, 8}},   {/* 41 */ 0, {8, 9}},   {/* 42 */ 0, {9, 10}},  {/* 43 */ 0, {10, 11}}, {/* 44 */ 0, {11, 12}}, {/* 45 */ 1, {-2, -4}},
    {/* 46 */ 1, {4, -2}},  {/* 47 */ 1, {3, -4}},  {/* 48 */ 1, {-4, -3}}, {/* 49 */ 1, {-4, 3}},  {/* 50 */ 1, {3, 4}},   {/* 51 */ 1, {-3, 4}},  {/* 52 */ 1, {4, 3}},
    {/* 53 */ 1, {4, -3}},  {/* 54 */ 1, {-3, -4}}, {/* 55 */ 0, {2, 3}},   {/* 56 */ 0, {3, 4}},   {/* 57 */ 1, {4, -4}},  {/* 58 */ 1, {-4, 4}},  {/* 59 */ 1, {4, 4}},
    {/* 60 */ 1, {-4, -4}}};

// ——————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
static const hcb hcb6_1[] = {{/* 00000 */ 0, 0},  {/*       */ 0, 0},  {/* 00010 */ 1, 0},  {/*       */ 1, 0},  {/* 00100 */ 2, 0},  {/*       */ 2, 0},  {/* 00110 */ 3, 0},  {/*       */ 3, 0},
                             {/* 01000 */ 4, 0},  {/*       */ 4, 0},  {/* 01010 */ 5, 0},  {/*       */ 5, 0},  {/* 01100 */ 6, 0},  {/*       */ 6, 0},  {/* 01110 */ 7, 0},  {/*       */ 7, 0},
                             {/* 10000 */ 8, 0},  {/*       */ 8, 0},  {/* 10010 */ 9, 1},  {/* 10011 */ 11, 1}, {/* 10100 */ 13, 1}, {/* 10101 */ 15, 1}, {/* 10110 */ 17, 1}, {/* 10111 */ 19, 1},
                             {/* 11000 */ 21, 1}, {/* 11001 */ 23, 1}, {/* 11010 */ 25, 2}, {/* 11011 */ 29, 2}, {/* 11100 */ 33, 2}, {/* 11101 */ 37, 3}, {/* 11110 */ 45, 4}, {/* 11111 */ 61, 6}};
// ——————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
/* 2nd step table
 * Gives size of codeword and actual data (x,y,v,w) */
static const hcb_2_pair hcb6_2[] = {
    {4, 0, 0},   {4, 1, 0},   {4, 0, -1},  {4, 0, 1},   {4, -1, 0},  {4, 1, 1},   {4, -1, 1},  {4, 1, -1},   {4, -1, -1},  {6, 2, -1},  {6, 2, 1},   {6, -2, 1},   {6, -2, -1}, {6, -2, 0},
    {6, -1, 2},  {6, 2, 0},   {6, 1, -2},  {6, 1, 2},   {6, 0, -2},  {6, -1, -2}, {6, 0, 2},   {6, 2, -2},   {6, -2, 2},   {6, -2, -2}, {6, 2, 2},   {7, -3, 1},   {7, 3, 1},   {7, 3, -1},
    {7, -1, 3},  {7, -3, -1}, {7, 1, 3},   {7, 1, -3},  {7, -1, -3}, {7, 3, 0},   {7, -3, 0},  {7, 0, -3},   {7, 0, 3},    {7, 3, 2},   {7, 3, 2},   {8, -3, -2},  {8, -2, 3},  {8, 2, 3},
    {8, 3, -2},  {8, 2, -3},  {8, -2, -3}, {8, -3, 2},  {8, -3, 2},  {8, 3, 3},   {8, 3, 3},   {9, 3, -3},   {9, -3, -3},  {9, -3, 3},  {9, 1, -4},  {9, -1, -4},  {9, 4, 1},   {9, -4, 1},
    {9, -4, -1}, {9, 1, 4},   {9, 4, -1},  {9, -1, 4},  {9, 0, -4},  {9, -4, 2},  {9, -4, 2},  {9, -4, 2},   {9, -4, 2},   {9, -4, -2}, {9, -4, -2}, {9, -4, -2},  {9, -4, -2}, {9, 2, 4},
    {9, 2, 4},   {9, 2, 4},   {9, 2, 4},   {9, -2, -4}, {9, -2, -4}, {9, -2, -4}, {9, -2, -4}, {9, -4, 0},   {9, -4, 0},   {9, -4, 0},  {9, -4, 0},  {9, 4, 2},    {9, 4, 2},   {9, 4, 2},
    {9, 4, 2},   {9, 4, -2},  {9, 4, -2},  {9, 4, -2},  {9, 4, -2},  {9, -2, 4},  {9, -2, 4},  {9, -2, 4},   {9, -2, 4},   {9, 4, 0},   {9, 4, 0},   {9, 4, 0},    {9, 4, 0},   {9, 2, -4},
    {9, 2, -4},  {9, 2, -4},  {9, 2, -4},  {9, 0, 4},   {9, 0, 4},   {9, 0, 4},   {9, 0, 4},   {10, -3, -4}, {10, -3, -4}, {10, -3, 4}, {10, -3, 4}, {10, 3, -4},  {10, 3, -4}, {10, 4, -3},
    {10, 4, -3}, {10, 3, 4},  {10, 3, 4},  {10, 4, 3},  {10, 4, 3},  {10, -4, 3}, {10, -4, 3}, {10, -4, -3}, {10, -4, -3}, {11, 4, 4},  {11, -4, 4}, {11, -4, -4}, {11, 4, -4}};
// ——————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
static const hcb_bin_pair hcb7[] = {
    {/*  0 */ 0, {1, 2}},   {/*  1 */ 1, {0, 0}},   {/*  2 */ 0, {1, 2}},   {/*  3 */ 0, {2, 3}},   {/*  4 */ 0, {3, 4}},   {/*  5 */ 1, {1, 0}},   {/*  6 */ 1, {0, 1}},   {/*  7 */ 0, {2, 3}},
    {/*  8 */ 0, {3, 4}},   {/*  9 */ 1, {1, 1}},   {/* 10 */ 0, {3, 4}},   {/* 11 */ 0, {4, 5}},   {/* 12 */ 0, {5, 6}},   {/* 13 */ 0, {6, 7}},   {/* 14 */ 0, {7, 8}},   {/* 15 */ 0, {8, 9}},
    {/* 16 */ 0, {9, 10}},  {/* 17 */ 0, {10, 11}}, {/* 18 */ 0, {11, 12}}, {/* 19 */ 1, {2, 1}},   {/* 20 */ 1, {1, 2}},   {/* 21 */ 1, {2, 0}},   {/* 22 */ 1, {0, 2}},   {/* 23 */ 0, {8, 9}},
    {/* 24 */ 0, {9, 10}},  {/* 25 */ 0, {10, 11}}, {/* 26 */ 0, {11, 12}}, {/* 27 */ 0, {12, 13}}, {/* 28 */ 0, {13, 14}}, {/* 29 */ 0, {14, 15}}, {/* 30 */ 0, {15, 16}}, {/* 31 */ 1, {3, 1}},
    {/* 32 */ 1, {1, 3}},   {/* 33 */ 1, {2, 2}},   {/* 34 */ 1, {3, 0}},   {/* 35 */ 1, {0, 3}},   {/* 36 */ 0, {11, 12}}, {/* 37 */ 0, {12, 13}}, {/* 38 */ 0, {13, 14}}, {/* 39 */ 0, {14, 15}},
    {/* 40 */ 0, {15, 16}}, {/* 41 */ 0, {16, 17}}, {/* 42 */ 0, {17, 18}}, {/* 43 */ 0, {18, 19}}, {/* 44 */ 0, {19, 20}}, {/* 45 */ 0, {20, 21}}, {/* 46 */ 0, {21, 22}}, {/* 47 */ 1, {2, 3}},
    {/* 48 */ 1, {3, 2}},   {/* 49 */ 1, {1, 4}},   {/* 50 */ 1, {4, 1}},   {/* 51 */ 1, {1, 5}},   {/* 52 */ 1, {5, 1}},   {/* 53 */ 1, {3, 3}},   {/* 54 */ 1, {2, 4}},   {/* 55 */ 1, {0, 4}},
    {/* 56 */ 1, {4, 0}},   {/* 57 */ 0, {12, 13}}, {/* 58 */ 0, {13, 14}}, {/* 59 */ 0, {14, 15}}, {/* 60 */ 0, {15, 16}}, {/* 61 */ 0, {16, 17}}, {/* 62 */ 0, {17, 18}}, {/* 63 */ 0, {18, 19}},
    {/* 64 */ 0, {19, 20}}, {/* 65 */ 0, {20, 21}}, {/* 66 */ 0, {21, 22}}, {/* 67 */ 0, {22, 23}}, {/* 68 */ 0, {23, 24}}, {/* 69 */ 1, {4, 2}},   {/* 70 */ 1, {2, 5}},   {/* 71 */ 1, {5, 2}},
    {/* 72 */ 1, {0, 5}},   {/* 73 */ 1, {6, 1}},   {/* 74 */ 1, {5, 0}},   {/* 75 */ 1, {1, 6}},   {/* 76 */ 1, {4, 3}},   {/* 77 */ 1, {3, 5}},   {/* 78 */ 1, {3, 4}},   {/* 79 */ 1, {5, 3}},
    {/* 80 */ 1, {2, 6}},   {/* 81 */ 1, {6, 2}},   {/* 82 */ 1, {1, 7}},   {/* 83 */ 0, {10, 11}}, {/* 84 */ 0, {11, 12}}, {/* 85 */ 0, {12, 13}}, {/* 86 */ 0, {13, 14}}, {/* 87 */ 0, {14, 15}},
    {/* 88 */ 0, {15, 16}}, {/* 89 */ 0, {16, 17}}, {/* 90 */ 0, {17, 18}}, {/* 91 */ 0, {18, 19}}, {/* 92 */ 0, {19, 20}}, {/* 93 */ 1, {3, 6}},   {/* 94 */ 1, {0, 6}},   {/* 95 */ 1, {6, 0}},
    {/* 96 */ 1, {4, 4}},   {/* 97 */ 1, {7, 1}},   {/* 98 */ 1, {4, 5}},   {/* 99 */ 1, {7, 2}},   {/* 00 */ 1, {5, 4}},   {/* 01 */ 1, {6, 3}},   {/* 02 */ 1, {2, 7}},   {/* 03 */ 1, {7, 3}},
    {/* 04 */ 1, {6, 4}},   {/* 05 */ 1, {5, 5}},   {/* 06 */ 1, {4, 6}},   {/* 07 */ 1, {3, 7}},   {/* 08 */ 0, {5, 6}},   {/* 09 */ 0, {6, 7}},   {/* 10 */ 0, {7, 8}},   {/* 11 */ 0, {8, 9}},
    {/* 12 */ 0, {9, 10}},  {/* 13 */ 1, {7, 0}},   {/* 14 */ 1, {0, 7}},   {/* 15 */ 1, {6, 5}},   {/* 16 */ 1, {5, 6}},   {/* 17 */ 1, {7, 4}},   {/* 18 */ 1, {4, 7}},   {/* 19 */ 1, {5, 7}},
    {/* 20 */ 1, {7, 5}},   {/* 21 */ 0, {2, 3}},   {/* 22 */ 0, {3, 4}},   {/* 23 */ 1, {7, 6}},   {/* 24 */ 1, {6, 6}},   {/* 25 */ 1, {6, 7}},   {/* 26 */ 1, {7, 7}}};
// ——————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
static const hcb hcb8_1[] = {{/* 00000 */ 0, 0},  {/*       */ 0, 0},  {/*       */ 0, 0},  {/*       */ 0, 0},  {/* 00100 */ 1, 0},  {/*       */ 1, 0},  {/* 00110 */ 2, 0},  {/*       */ 2, 0},
                             {/* 01000 */ 3, 0},  {/*       */ 3, 0},  {/* 01010 */ 4, 0},  {/*       */ 4, 0},  {/* 01100 */ 5, 0},  {/*       */ 5, 0},  {/* 01110 */ 6, 0},  {/* 01111 */ 7, 0},
                             {/* 10000 */ 8, 0},  {/* 10001 */ 9, 0},  {/* 10010 */ 10, 0}, {/* 10011 */ 11, 0}, {/* 10100 */ 12, 0}, {/* 10101 */ 13, 1}, {/* 10110 */ 15, 1}, {/* 10111 */ 17, 1},
                             {/* 11000 */ 19, 1}, {/* 11001 */ 21, 1}, {/* 11010 */ 23, 2}, {/* 11011 */ 27, 2}, {/* 11100 */ 31, 2}, {/* 11101 */ 35, 3}, {/* 11110 */ 43, 3}, {/* 11111 */ 51, 5}};
// ——————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
/* 2nd step table
 * Gives size of codeword and actual data (x,y,v,w)*/
static const hcb_2_pair hcb8_2[] = {{3, 1, 1}, {4, 2, 1}, {4, 1, 0}, {4, 1, 2}, {4, 0, 1}, {4, 2, 2}, {5, 0, 0}, {5, 2, 0}, {5, 0, 2}, {5, 3, 1},  {5, 1, 3},  {5, 3, 2},  {5, 2, 3}, {6, 3, 3},
                                    {6, 4, 1}, {6, 1, 4}, {6, 4, 2}, {6, 2, 4}, {6, 3, 0}, {6, 0, 3}, {6, 4, 3}, {6, 3, 4}, {6, 5, 2}, {7, 5, 1},  {7, 2, 5},  {7, 1, 5},  {7, 5, 3}, {7, 3, 5},
                                    {7, 4, 4}, {7, 5, 4}, {7, 0, 4}, {7, 4, 5}, {7, 4, 0}, {7, 2, 6}, {7, 6, 2}, {7, 6, 1}, {7, 6, 1}, {7, 1, 6},  {7, 1, 6},  {8, 3, 6},  {8, 6, 3}, {8, 5, 5},
                                    {8, 5, 0}, {8, 6, 4}, {8, 0, 5}, {8, 4, 6}, {8, 7, 1}, {8, 7, 2}, {8, 2, 7}, {8, 6, 5}, {8, 7, 3}, {8, 1, 7},  {8, 1, 7},  {8, 1, 7},  {8, 1, 7}, {8, 5, 6},
                                    {8, 5, 6}, {8, 5, 6}, {8, 5, 6}, {8, 3, 7}, {8, 3, 7}, {8, 3, 7}, {8, 3, 7}, {9, 6, 6}, {9, 6, 6}, {9, 7, 4},  {9, 7, 4},  {9, 6, 0},  {9, 6, 0}, {9, 4, 7},
                                    {9, 4, 7}, {9, 0, 6}, {9, 0, 6}, {9, 7, 5}, {9, 7, 5}, {9, 7, 6}, {9, 7, 6}, {9, 6, 7}, {9, 6, 7}, {10, 5, 7}, {10, 7, 0}, {10, 0, 7}, {10, 7, 7}};
// ——————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
/* Binary search huffman table HCB_9 */
static const hcb_bin_pair hcb9[] = {
    {/*  0 */ 0, {1, 2}},   {/*  1 */ 1, {0, 0}},   {/*  2 */ 0, {1, 2}},   {/*  3 */ 0, {2, 3}},   {/*  4 */ 0, {3, 4}},   {/*  5 */ 1, {1, 0}},   {/*  6 */ 1, {0, 1}},   {/*  7 */ 0, {2, 3}},
    {/*  8 */ 0, {3, 4}},   {/*  9 */ 1, {1, 1}},   {/* 10 */ 0, {3, 4}},   {/* 11 */ 0, {4, 5}},   {/* 12 */ 0, {5, 6}},   {/* 13 */ 0, {6, 7}},   {/* 14 */ 0, {7, 8}},   {/* 15 */ 0, {8, 9}},
    {/* 16 */ 0, {9, 10}},  {/* 17 */ 0, {10, 11}}, {/* 18 */ 0, {11, 12}}, {/* 19 */ 1, {2, 1}},   {/* 20 */ 1, {1, 2}},   {/* 21 */ 1, {2, 0}},   {/* 22 */ 1, {0, 2}},   {/* 23 */ 0, {8, 9}},
    {/* 24 */ 0, {9, 10}},  {/* 25 */ 0, {10, 11}}, {/* 26 */ 0, {11, 12}}, {/* 27 */ 0, {12, 13}}, {/* 28 */ 0, {13, 14}}, {/* 29 */ 0, {14, 15}}, {/* 30 */ 0, {15, 16}}, {/* 31 */ 1, {3, 1}},
    {/* 32 */ 1, {2, 2}},   {/* 33 */ 1, {1, 3}},   {/* 34 */ 0, {13, 14}}, {/* 35 */ 0, {14, 15}}, {/* 36 */ 0, {15, 16}}, {/* 37 */ 0, {16, 17}}, {/* 38 */ 0, {17, 18}}, {/* 39 */ 0, {18, 19}},
    {/* 40 */ 0, {19, 20}}, {/* 41 */ 0, {20, 21}}, {/* 42 */ 0, {21, 22}}, {/* 43 */ 0, {22, 23}}, {/* 44 */ 0, {23, 24}}, {/* 45 */ 0, {24, 25}}, {/* 46 */ 0, {25, 26}}, {/* 47 */ 1, {3, 0}},
    {/* 48 */ 1, {0, 3}},   {/* 49 */ 1, {2, 3}},   {/* 50 */ 1, {3, 2}},   {/* 51 */ 1, {1, 4}},   {/* 52 */ 1, {4, 1}},   {/* 53 */ 1, {2, 4}},   {/* 54 */ 1, {1, 5}},   {/* 55 */ 0, {18, 19}},
    {/* 56 */ 0, {19, 20}}, {/* 57 */ 0, {20, 21}}, {/* 58 */ 0, {21, 22}}, {/* 59 */ 0, {22, 23}}, {/* 60 */ 0, {23, 24}}, {/* 61 */ 0, {24, 25}}, {/* 62 */ 0, {25, 26}}, {/* 63 */ 0, {26, 27}},
    {/* 64 */ 0, {27, 28}}, {/* 65 */ 0, {28, 29}}, {/* 66 */ 0, {29, 30}}, {/* 67 */ 0, {30, 31}}, {/* 68 */ 0, {31, 32}}, {/* 69 */ 0, {32, 33}}, {/* 70 */ 0, {33, 34}}, {/* 71 */ 0, {34, 35}},
    {/* 72 */ 0, {35, 36}}, {/* 73 */ 1, {4, 2}},   {/* 74 */ 1, {3, 3}},   {/* 75 */ 1, {0, 4}},   {/* 76 */ 1, {4, 0}},   {/* 77 */ 1, {5, 1}},   {/* 78 */ 1, {2, 5}},   {/* 79 */ 1, {1, 6}},
    {/* 80 */ 1, {3, 4}},   {/* 81 */ 1, {5, 2}},   {/* 82 */ 1, {6, 1}},   {/* 83 */ 1, {4, 3}},   {/* 84 */ 0, {25, 26}}, {/* 85 */ 0, {26, 27}}, {/* 86 */ 0, {27, 28}}, {/* 87 */ 0, {28, 29}},
    {/* 88 */ 0, {29, 30}}, {/* 89 */ 0, {30, 31}}, {/* 90 */ 0, {31, 32}}, {/* 91 */ 0, {32, 33}}, {/* 92 */ 0, {33, 34}}, {/* 93 */ 0, {34, 35}}, {/* 94 */ 0, {35, 36}}, {/* 95 */ 0, {36, 37}},
    {/* 96 */ 0, {37, 38}}, {/* 97 */ 0, {38, 39}}, {/* 98 */ 0, {39, 40}}, {/* 99 */ 0, {40, 41}}, {/* 00 */ 0, {41, 42}}, {/* 01 */ 0, {42, 43}}, {/* 02 */ 0, {43, 44}}, {/* 03 */ 0, {44, 45}},
    {/* 04 */ 0, {45, 46}}, {/* 05 */ 0, {46, 47}}, {/* 06 */ 0, {47, 48}}, {/* 07 */ 0, {48, 49}}, {/* 08 */ 0, {49, 50}}, {/* 09 */ 1, {0, 5}},   {/* 10 */ 1, {2, 6}},   {/* 11 */ 1, {5, 0}},
    {/* 12 */ 1, {1, 7}},   {/* 13 */ 1, {3, 5}},   {/* 14 */ 1, {1, 8}},   {/* 15 */ 1, {8, 1}},   {/* 16 */ 1, {4, 4}},   {/* 17 */ 1, {5, 3}},   {/* 18 */ 1, {6, 2}},   {/* 19 */ 1, {7, 1}},
    {/* 20 */ 1, {0, 6}},   {/* 21 */ 1, {8, 2}},   {/* 22 */ 1, {2, 8}},   {/* 23 */ 1, {3, 6}},   {/* 24 */ 1, {2, 7}},   {/* 25 */ 1, {4, 5}},   {/* 26 */ 1, {9, 1}},   {/* 27 */ 1, {1, 9}},
    {/* 28 */ 1, {7, 2}},   {/* 29 */ 0, {30, 31}}, {/* 30 */ 0, {31, 32}}, {/* 31 */ 0, {32, 33}}, {/* 32 */ 0, {33, 34}}, {/* 33 */ 0, {34, 35}}, {/* 34 */ 0, {35, 36}}, {/* 35 */ 0, {36, 37}},
    {/* 36 */ 0, {37, 38}}, {/* 37 */ 0, {38, 39}}, {/* 38 */ 0, {39, 40}}, {/* 39 */ 0, {40, 41}}, {/* 40 */ 0, {41, 42}}, {/* 41 */ 0, {42, 43}}, {/* 42 */ 0, {43, 44}}, {/* 43 */ 0, {44, 45}},
    {/* 44 */ 0, {45, 46}}, {/* 45 */ 0, {46, 47}}, {/* 46 */ 0, {47, 48}}, {/* 47 */ 0, {48, 49}}, {/* 48 */ 0, {49, 50}}, {/* 49 */ 0, {50, 51}}, {/* 50 */ 0, {51, 52}}, {/* 51 */ 0, {52, 53}},
    {/* 52 */ 0, {53, 54}}, {/* 53 */ 0, {54, 55}}, {/* 54 */ 0, {55, 56}}, {/* 55 */ 0, {56, 57}}, {/* 56 */ 0, {57, 58}}, {/* 57 */ 0, {58, 59}}, {/* 58 */ 0, {59, 60}}, {/* 59 */ 1, {6, 0}},
    {/* 60 */ 1, {5, 4}},   {/* 61 */ 1, {6, 3}},   {/* 62 */ 1, {8, 3}},   {/* 63 */ 1, {0, 7}},   {/* 64 */ 1, {9, 2}},   {/* 65 */ 1, {3, 8}},   {/* 66 */ 1, {4, 6}},   {/* 67 */ 1, {3, 7}},
    {/* 68 */ 1, {0, 8}},   {/* 69 */ 1, {10, 1}},  {/* 70 */ 1, {6, 4}},   {/* 71 */ 1, {2, 9}},   {/* 72 */ 1, {5, 5}},   {/* 73 */ 1, {8, 0}},   {/* 74 */ 1, {7, 0}},   {/* 75 */ 1, {7, 3}},
    {/* 76 */ 1, {10, 2}},  {/* 77 */ 1, {9, 3}},   {/* 78 */ 1, {8, 4}},   {/* 79 */ 1, {1, 10}},  {/* 80 */ 1, {7, 4}},   {/* 81 */ 1, {6, 5}},   {/* 82 */ 1, {5, 6}},   {/* 83 */ 1, {4, 8}},
    {/* 84 */ 1, {4, 7}},   {/* 85 */ 1, {3, 9}},   {/* 86 */ 1, {11, 1}},  {/* 87 */ 1, {5, 8}},   {/* 88 */ 1, {9, 0}},   {/* 89 */ 1, {8, 5}},   {/* 90 */ 0, {29, 30}}, {/* 91 */ 0, {30, 31}},
    {/* 92 */ 0, {31, 32}}, {/* 93 */ 0, {32, 33}}, {/* 94 */ 0, {33, 34}}, {/* 95 */ 0, {34, 35}}, {/* 96 */ 0, {35, 36}}, {/* 97 */ 0, {36, 37}}, {/* 98 */ 0, {37, 38}}, {/* 99 */ 0, {38, 39}},
    {/* 00 */ 0, {39, 40}}, {/* 01 */ 0, {40, 41}}, {/* 02 */ 0, {41, 42}}, {/* 03 */ 0, {42, 43}}, {/* 04 */ 0, {43, 44}}, {/* 05 */ 0, {44, 45}}, {/* 06 */ 0, {45, 46}}, {/* 07 */ 0, {46, 47}},
    {/* 08 */ 0, {47, 48}}, {/* 09 */ 0, {48, 49}}, {/* 10 */ 0, {49, 50}}, {/* 11 */ 0, {50, 51}}, {/* 12 */ 0, {51, 52}}, {/* 13 */ 0, {52, 53}}, {/* 14 */ 0, {53, 54}}, {/* 15 */ 0, {54, 55}},
    {/* 16 */ 0, {55, 56}}, {/* 17 */ 0, {56, 57}}, {/* 18 */ 0, {57, 58}}, {/* 19 */ 1, {10, 3}},  {/* 20 */ 1, {2, 10}},  {/* 21 */ 1, {0, 9}},   {/* 22 */ 1, {11, 2}},  {/* 23 */ 1, {9, 4}},
    {/* 24 */ 1, {6, 6}},   {/* 25 */ 1, {12, 1}},  {/* 26 */ 1, {4, 9}},   {/* 27 */ 1, {8, 6}},   {/* 28 */ 1, {1, 11}},  {/* 29 */ 1, {9, 5}},   {/* 30 */ 1, {10, 4}},  {/* 31 */ 1, {5, 7}},
    {/* 32 */ 1, {7, 5}},   {/* 33 */ 1, {2, 11}},  {/* 34 */ 1, {1, 12}},  {/* 35 */ 1, {12, 2}},  {/* 36 */ 1, {11, 3}},  {/* 37 */ 1, {3, 10}},  {/* 38 */ 1, {5, 9}},   {/* 39 */ 1, {6, 7}},
    {/* 40 */ 1, {8, 7}},   {/* 41 */ 1, {11, 4}},  {/* 42 */ 1, {0, 10}},  {/* 43 */ 1, {7, 6}},   {/* 44 */ 1, {12, 3}},  {/* 45 */ 1, {10, 0}},  {/* 46 */ 1, {10, 5}},  {/* 47 */ 1, {4, 10}},
    {/* 48 */ 1, {6, 8}},   {/* 49 */ 1, {2, 12}},  {/* 50 */ 1, {9, 6}},   {/* 51 */ 1, {9, 7}},   {/* 52 */ 1, {4, 11}},  {/* 53 */ 1, {11, 0}},  {/* 54 */ 1, {6, 9}},   {/* 55 */ 1, {3, 11}},
    {/* 56 */ 1, {5, 10}},  {/* 57 */ 0, {20, 21}}, {/* 58 */ 0, {21, 22}}, {/* 59 */ 0, {22, 23}}, {/* 60 */ 0, {23, 24}}, {/* 61 */ 0, {24, 25}}, {/* 62 */ 0, {25, 26}}, {/* 63 */ 0, {26, 27}},
    {/* 64 */ 0, {27, 28}}, {/* 65 */ 0, {28, 29}}, {/* 66 */ 0, {29, 30}}, {/* 67 */ 0, {30, 31}}, {/* 68 */ 0, {31, 32}}, {/* 69 */ 0, {32, 33}}, {/* 70 */ 0, {33, 34}}, {/* 71 */ 0, {34, 35}},
    {/* 72 */ 0, {35, 36}}, {/* 73 */ 0, {36, 37}}, {/* 74 */ 0, {37, 38}}, {/* 75 */ 0, {38, 39}}, {/* 76 */ 0, {39, 40}}, {/* 77 */ 1, {8, 8}},   {/* 78 */ 1, {7, 8}},   {/* 79 */ 1, {12, 5}},
    {/* 80 */ 1, {3, 12}},  {/* 81 */ 1, {11, 5}},  {/* 82 */ 1, {7, 7}},   {/* 83 */ 1, {12, 4}},  {/* 84 */ 1, {11, 6}},  {/* 85 */ 1, {10, 6}},  {/* 86 */ 1, {4, 12}},  {/* 87 */ 1, {7, 9}},
    {/* 88 */ 1, {5, 11}},  {/* 89 */ 1, {0, 11}},  {/* 90 */ 1, {12, 6}},  {/* 91 */ 1, {6, 10}},  {/* 92 */ 1, {12, 0}},  {/* 93 */ 1, {10, 7}},  {/* 94 */ 1, {5, 12}},  {/* 95 */ 1, {7, 10}},
    {/* 96 */ 1, {9, 8}},   {/* 97 */ 1, {0, 12}},  {/* 98 */ 1, {11, 7}},  {/* 99 */ 1, {8, 9}},   {/* 00 */ 1, {9, 9}},   {/* 01 */ 1, {10, 8}},  {/* 02 */ 1, {7, 11}},  {/* 03 */ 1, {12, 7}},
    {/* 04 */ 1, {6, 11}},  {/* 05 */ 1, {8, 11}},  {/* 06 */ 1, {11, 8}},  {/* 07 */ 1, {7, 12}},  {/* 08 */ 1, {6, 12}},  {/* 09 */ 0, {8, 9}},   {/* 10 */ 0, {9, 10}},  {/* 11 */ 0, {10, 11}},
    {/* 12 */ 0, {11, 12}}, {/* 13 */ 0, {12, 13}}, {/* 14 */ 0, {13, 14}}, {/* 15 */ 0, {14, 15}}, {/* 16 */ 0, {15, 16}}, {/* 17 */ 1, {8, 10}},  {/* 18 */ 1, {10, 9}},  {/* 19 */ 1, {8, 12}},
    {/* 20 */ 1, {9, 10}},  {/* 21 */ 1, {9, 11}},  {/* 22 */ 1, {9, 12}},  {/* 23 */ 1, {10, 11}}, {/* 24 */ 1, {12, 9}},  {/* 25 */ 1, {10, 10}}, {/* 26 */ 1, {11, 9}},  {/* 27 */ 1, {12, 8}},
    {/* 28 */ 1, {11, 10}}, {/* 29 */ 1, {12, 10}}, {/* 30 */ 1, {12, 11}}, {/* 31 */ 0, {2, 3}},   {/* 32 */ 0, {3, 4}},   {/* 33 */ 1, {10, 12}}, {/* 34 */ 1, {11, 11}}, {/* 35 */ 1, {11, 12}},
    {/* 36 */ 1, {12, 12}}};
// ——————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
static const hcb hcb10_1[] = {
    {/* 000000 */ 0, 0},  {/*        */ 0, 0},  {/*        */ 0, 0},  {/*        */ 0, 0},  {/* 000100 */ 1, 0},  {/*        */ 1, 0},   {/*        */ 1, 0},   {/*        */ 1, 0},
    {/* 001000 */ 2, 0},  {/*        */ 2, 0},  {/*        */ 2, 0},  {/*        */ 2, 0},  {/* 001100 */ 3, 0},  {/*        */ 3, 0},   {/* 001110 */ 4, 0},   {/*        */ 4, 0},
    {/* 010000 */ 5, 0},  {/*        */ 5, 0},  {/* 010010 */ 6, 0},  {/*        */ 6, 0},  {/* 010100 */ 7, 0},  {/*        */ 7, 0},   {/* 010110 */ 8, 0},   {/*        */ 8, 0},
    {/* 011000 */ 9, 0},  {/*        */ 9, 0},  {/* 011010 */ 10, 0}, {/*        */ 10, 0}, {/* 011100 */ 11, 0}, {/* 011101 */ 12, 0},  {/* 011110 */ 13, 0},  {/* 011111 */ 14, 0},
    {/* 100000 */ 15, 0}, {/* 100001 */ 16, 0}, {/* 100010 */ 17, 0}, {/* 100011 */ 18, 0}, {/* 100100 */ 19, 0}, {/* 100101 */ 20, 0},  {/* 100110 */ 21, 0},  {/* 100111 */ 22, 0},
    {/* 101000 */ 23, 0}, {/* 101001 */ 24, 0}, {/* 101010 */ 25, 1}, {/* 101011 */ 27, 1}, {/* 101100 */ 29, 1}, {/* 101101 */ 31, 1},  {/* 101110 */ 33, 1},  {/* 101111 */ 35, 1},
    {/* 110000 */ 37, 1}, {/* 110001 */ 39, 1}, {/* 110010 */ 41, 2}, {/* 110011 */ 45, 2}, {/* 110100 */ 49, 2}, {/* 110101 */ 53, 2},  {/* 110110 */ 57, 2},  {/* 110111 */ 61, 2},
    {/* 111000 */ 65, 3}, {/* 111001 */ 73, 3}, {/* 111010 */ 81, 3}, {/* 111011 */ 89, 3}, {/* 111100 */ 97, 4}, {/* 111101 */ 113, 4}, {/* 111110 */ 129, 4}, {/* 111111 */ 145, 6}};
// ——————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
/* 2nd step table
 * Gives size of codeword and actual data (x,y,v,w) */
static const hcb_2_pair hcb10_2[] = {
    {4, 1, 1},    {4, 1, 2},    {4, 2, 1},    {5, 2, 2},   {5, 1, 0},   {5, 0, 1},    {5, 1, 3},    {5, 3, 2},   {5, 3, 1},    {5, 2, 3},    {5, 3, 3},    {6, 2, 0},    {6, 0, 2},   {6, 2, 4},
    {6, 4, 2},    {6, 1, 4},    {6, 4, 1},    {6, 0, 0},   {6, 4, 3},   {6, 3, 4},    {6, 3, 0},    {6, 0, 3},   {6, 4, 4},    {6, 2, 5},    {6, 5, 2},    {7, 1, 5},    {7, 5, 1},   {7, 5, 3},
    {7, 3, 5},    {7, 5, 4},    {7, 4, 5},    {7, 6, 2},   {7, 2, 6},   {7, 6, 3},    {7, 4, 0},    {7, 6, 1},   {7, 0, 4},    {7, 1, 6},    {7, 3, 6},    {7, 5, 5},    {7, 6, 4},   {7, 4, 6},
    {7, 4, 6},    {8, 6, 5},    {8, 7, 2},    {8, 3, 7},   {8, 2, 7},   {8, 5, 6},    {8, 8, 2},    {8, 7, 3},   {8, 5, 0},    {8, 7, 1},    {8, 0, 5},    {8, 8, 1},    {8, 1, 7},   {8, 8, 3},
    {8, 7, 4},    {8, 4, 7},    {8, 2, 8},    {8, 6, 6},   {8, 7, 5},   {8, 1, 8},    {8, 3, 8},    {8, 8, 4},   {8, 4, 8},    {8, 5, 7},    {8, 5, 7},    {8, 8, 5},    {8, 8, 5},   {8, 5, 8},
    {8, 5, 8},    {9, 7, 6},    {9, 6, 7},    {9, 9, 2},   {9, 6, 0},   {9, 6, 8},    {9, 9, 3},    {9, 3, 9},   {9, 9, 1},    {9, 2, 9},    {9, 0, 6},    {9, 8, 6},    {9, 9, 4},   {9, 4, 9},
    {9, 10, 2},   {9, 1, 9},    {9, 7, 7},    {9, 8, 7},   {9, 9, 5},   {9, 7, 8},    {9, 10, 3},   {9, 5, 9},   {9, 10, 4},   {9, 2, 10},   {9, 10, 1},   {9, 3, 10},   {9, 9, 6},   {9, 6, 9},
    {9, 6, 9},    {9, 8, 0},    {9, 8, 0},    {9, 4, 10},  {9, 4, 10},  {9, 7, 0},    {9, 7, 0},    {9, 11, 2},  {9, 11, 2},   {10, 7, 9},   {10, 11, 3},  {10, 10, 6},  {10, 1, 10}, {10, 11, 1},
    {10, 9, 7},   {10, 0, 7},   {10, 8, 8},   {10, 10, 5}, {10, 3, 11}, {10, 5, 10},  {10, 8, 9},   {10, 11, 5}, {10, 0, 8},   {10, 11, 4},  {10, 2, 11},  {10, 7, 10},  {10, 6, 10}, {10, 10, 7},
    {10, 4, 11},  {10, 1, 11},  {10, 12, 2},  {10, 9, 8},  {10, 12, 3}, {10, 11, 6},  {10, 5, 11},  {10, 12, 4}, {10, 11, 7},  {10, 12, 5},  {10, 3, 12},  {10, 6, 11},  {10, 9, 0},  {10, 10, 8},
    {10, 10, 0},  {10, 12, 1},  {10, 0, 9},   {10, 4, 12}, {10, 9, 9},  {10, 12, 6},  {10, 12, 6},  {10, 12, 6}, {10, 12, 6},  {10, 2, 12},  {10, 2, 12},  {10, 2, 12},  {10, 2, 12}, {10, 8, 10},
    {10, 8, 10},  {10, 8, 10},  {10, 8, 10},  {11, 9, 10}, {11, 9, 10}, {11, 1, 12},  {11, 1, 12},  {11, 11, 8}, {11, 11, 8},  {11, 12, 7},  {11, 12, 7},  {11, 7, 11},  {11, 7, 11}, {11, 5, 12},
    {11, 5, 12},  {11, 6, 12},  {11, 6, 12},  {11, 10, 9}, {11, 10, 9}, {11, 8, 11},  {11, 8, 11},  {11, 12, 8}, {11, 12, 8},  {11, 0, 10},  {11, 0, 10},  {11, 7, 12},  {11, 7, 12}, {11, 11, 0},
    {11, 11, 0},  {11, 10, 10}, {11, 10, 10}, {11, 11, 9}, {11, 11, 9}, {11, 11, 10}, {11, 11, 10}, {11, 0, 11}, {11, 0, 11},  {11, 11, 11}, {11, 11, 11}, {11, 9, 11},  {11, 9, 11}, {11, 10, 11},
    {11, 10, 11}, {11, 12, 0},  {11, 12, 0},  {11, 8, 12}, {11, 8, 12}, {12, 12, 9},  {12, 10, 12}, {12, 9, 12}, {12, 11, 12}, {12, 12, 11}, {12, 0, 12},  {12, 12, 10}, {12, 12, 12}};
// ——————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
static const hcb hcb11_1[] = {{/* 00000 */ 0, 0},   {/*       */ 0, 0},   {/* 00010 */ 1, 0},   {/*       */ 1, 0},  {/* 00100 */ 2, 0},   {/* 00101 */ 3, 0},   {/* 00110 */ 4, 0},
                              {/* 00111 */ 5, 0},   {/* 01000 */ 6, 0},   {/* 01001 */ 7, 0},   {/* 01010 */ 8, 1},  {/* 01011 */ 10, 1},  {/* 01100 */ 12, 1},  {/* 01101 */ 14, 2},
                              {/* 01110 */ 18, 2},  {/* 01111 */ 22, 2},  {/* 10000 */ 26, 2},  {/* 10001 */ 30, 3}, {/* 10010 */ 38, 3},  {/* 10011 */ 46, 3},  {/* 10100 */ 54, 3},
                              {/* 10101 */ 62, 3},  {/* 10110 */ 70, 3},  {/* 10111 */ 78, 3},  {/* 11000 */ 86, 4}, {/* 11001 */ 102, 4}, {/* 11010 */ 118, 4}, {/* 11011 */ 134, 4},
                              {/* 11100 */ 150, 5}, {/* 11101 */ 182, 5}, {/* 11110 */ 214, 5}, {/* 11111 */ 246, 7}};
// ——————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
/* 2nd step table, Gives size of codeword and actual data (x,y,v,w) */
static const hcb_2_pair hcb11_2[] = {
    {4, 0, 0},    {4, 1, 1},    {5, 16, 16},  {5, 1, 0},    {5, 0, 1},    {5, 2, 1},    {5, 1, 2},    {5, 2, 2},    {6, 1, 3},    {6, 3, 1},    {6, 3, 2},    {6, 2, 0},    {6, 2, 3},    {6, 0, 2},
    {6, 3, 3},    {6, 3, 3},    {7, 4, 1},    {7, 1, 4},    {7, 4, 2},    {7, 2, 4},    {7, 4, 3},    {7, 3, 4},    {7, 3, 0},    {7, 0, 3},    {7, 5, 1},    {7, 5, 2},    {7, 2, 5},    {7, 4, 4},
    {7, 1, 5},    {7, 5, 3},    {7, 3, 5},    {7, 3, 5},    {7, 5, 4},    {7, 5, 4},    {8, 4, 5},    {8, 6, 2},    {8, 2, 6},    {8, 6, 1},    {8, 6, 3},    {8, 3, 6},    {8, 1, 6},    {8, 4, 16},
    {8, 3, 16},   {8, 16, 5},   {8, 16, 3},   {8, 16, 4},   {8, 6, 4},    {8, 16, 6},   {8, 4, 0},    {8, 4, 6},    {8, 0, 4},    {8, 2, 16},   {8, 5, 5},    {8, 5, 16},   {8, 16, 7},   {8, 16, 2},
    {8, 16, 8},   {8, 2, 7},    {8, 7, 2},    {8, 3, 7},    {8, 6, 5},    {8, 5, 6},    {8, 6, 16},   {8, 16, 10},  {8, 7, 3},    {8, 7, 1},    {8, 16, 9},   {8, 7, 16},   {8, 1, 16},   {8, 1, 7},
    {8, 4, 7},    {8, 16, 11},  {8, 7, 4},    {8, 16, 12},  {8, 8, 16},   {8, 16, 1},   {8, 6, 6},    {8, 9, 16},   {8, 2, 8},    {8, 5, 7},    {8, 10, 16},  {8, 16, 13},  {8, 8, 3},    {8, 8, 2},
    {8, 3, 8},    {8, 5, 0},    {8, 16, 14},  {8, 16, 14},  {8, 11, 16},  {8, 11, 16},  {8, 7, 5},    {8, 7, 5},    {8, 4, 8},    {8, 4, 8},    {8, 6, 7},    {8, 6, 7},    {8, 7, 6},    {8, 7, 6},
    {8, 0, 5},    {8, 0, 5},    {9, 8, 4},    {9, 16, 15},  {9, 12, 16},  {9, 1, 8},    {9, 8, 1},    {9, 14, 16},  {9, 5, 8},    {9, 13, 16},  {9, 3, 9},    {9, 8, 5},    {9, 7, 7},    {9, 2, 9},
    {9, 8, 6},    {9, 9, 2},    {9, 9, 3},    {9, 15, 16},  {9, 4, 9},    {9, 6, 8},    {9, 6, 0},    {9, 9, 4},    {9, 5, 9},    {9, 8, 7},    {9, 7, 8},    {9, 1, 9},    {9, 10, 3},   {9, 0, 6},
    {9, 10, 2},   {9, 9, 1},    {9, 9, 5},    {9, 4, 10},   {9, 2, 10},   {9, 9, 6},    {9, 3, 10},   {9, 6, 9},    {9, 10, 4},   {9, 8, 8},    {9, 10, 5},   {9, 9, 7},    {9, 11, 3},   {9, 1, 10},
    {9, 7, 0},    {9, 10, 6},   {9, 7, 9},    {9, 3, 11},   {9, 5, 10},   {9, 10, 1},   {9, 4, 11},   {9, 11, 2},   {9, 13, 2},   {9, 6, 10},   {9, 13, 3},   {9, 13, 3},   {9, 2, 11},   {9, 2, 11},
    {9, 16, 0},   {9, 16, 0},   {9, 5, 11},   {9, 5, 11},   {9, 11, 5},   {9, 11, 5},   {10, 11, 4},  {10, 9, 8},   {10, 7, 10},  {10, 8, 9},   {10, 0, 16},  {10, 4, 13},  {10, 0, 7},   {10, 3, 13},
    {10, 11, 6},  {10, 13, 1},  {10, 13, 4},  {10, 12, 3},  {10, 2, 13},  {10, 13, 5},  {10, 8, 10},  {10, 6, 11},  {10, 10, 8},  {10, 10, 7},  {10, 14, 2},  {10, 12, 4},  {10, 1, 11},  {10, 4, 12},
    {10, 11, 1},  {10, 3, 12},  {10, 1, 13},  {10, 12, 2},  {10, 7, 11},  {10, 3, 14},  {10, 5, 12},  {10, 5, 13},  {10, 14, 4},  {10, 4, 14},  {10, 11, 7},  {10, 14, 3},  {10, 12, 5},  {10, 13, 6},
    {10, 12, 6},  {10, 8, 0},   {10, 11, 8},  {10, 2, 12},  {10, 9, 9},   {10, 14, 5},  {10, 6, 13},  {10, 10, 10}, {10, 15, 2},  {10, 8, 11},  {10, 9, 10},  {10, 14, 6},  {10, 10, 9},  {10, 5, 14},
    {10, 11, 9},  {10, 14, 1},  {10, 2, 14},  {10, 6, 12},  {10, 1, 12},  {10, 13, 8},  {10, 0, 8},   {10, 13, 7},  {10, 7, 12},  {10, 12, 7},  {10, 7, 13},  {10, 15, 3},  {10, 12, 1},  {10, 6, 14},
    {10, 2, 15},  {10, 15, 5},  {10, 15, 4},  {10, 1, 14},  {10, 9, 11},  {10, 4, 15},  {10, 14, 7},  {10, 8, 13},  {10, 13, 9},  {10, 8, 12},  {10, 5, 15},  {10, 3, 15},  {10, 10, 11}, {10, 11, 10},
    {10, 12, 8},  {10, 15, 6},  {10, 15, 7},  {10, 8, 14},  {10, 15, 1},  {10, 7, 14},  {10, 9, 0},   {10, 0, 9},   {10, 9, 13},  {10, 9, 13},  {10, 9, 13},  {10, 9, 13},  {10, 9, 12},  {10, 9, 12},
    {10, 9, 12},  {10, 9, 12},  {10, 12, 9},  {10, 12, 9},  {10, 12, 9},  {10, 12, 9},  {10, 14, 8},  {10, 14, 8},  {10, 14, 8},  {10, 14, 8},  {10, 10, 13}, {10, 10, 13}, {10, 10, 13}, {10, 10, 13},
    {10, 14, 9},  {10, 14, 9},  {10, 14, 9},  {10, 14, 9},  {10, 12, 10}, {10, 12, 10}, {10, 12, 10}, {10, 12, 10}, {10, 6, 15},  {10, 6, 15},  {10, 6, 15},  {10, 6, 15},  {10, 7, 15},  {10, 7, 15},
    {10, 7, 15},  {10, 7, 15},  {11, 9, 14},  {11, 9, 14},  {11, 15, 8},  {11, 15, 8},  {11, 11, 11}, {11, 11, 11}, {11, 11, 14}, {11, 11, 14}, {11, 1, 15},  {11, 1, 15},  {11, 10, 12}, {11, 10, 12},
    {11, 10, 14}, {11, 10, 14}, {11, 13, 11}, {11, 13, 11}, {11, 13, 10}, {11, 13, 10}, {11, 11, 13}, {11, 11, 13}, {11, 11, 12}, {11, 11, 12}, {11, 8, 15},  {11, 8, 15},  {11, 14, 11}, {11, 14, 11},
    {11, 13, 12}, {11, 13, 12}, {11, 12, 13}, {11, 12, 13}, {11, 15, 9},  {11, 15, 9},  {11, 14, 10}, {11, 14, 10}, {11, 10, 0},  {11, 10, 0},  {11, 12, 11}, {11, 12, 11}, {11, 9, 15},  {11, 9, 15},
    {11, 0, 10},  {11, 0, 10},  {11, 12, 12}, {11, 12, 12}, {11, 11, 0},  {11, 11, 0},  {11, 12, 14}, {11, 12, 14}, {11, 10, 15}, {11, 10, 15}, {11, 13, 13}, {11, 13, 13}, {11, 0, 13},  {11, 0, 13},
    {11, 14, 12}, {11, 14, 12}, {11, 15, 10}, {11, 15, 10}, {11, 15, 11}, {11, 15, 11}, {11, 11, 15}, {11, 11, 15}, {11, 14, 13}, {11, 14, 13}, {11, 13, 0},  {11, 13, 0},  {11, 0, 11},  {11, 0, 11},
    {11, 13, 14}, {11, 13, 14}, {11, 15, 12}, {11, 15, 12}, {11, 15, 13}, {11, 15, 13}, {11, 12, 15}, {11, 12, 15}, {11, 14, 0},  {11, 14, 0},  {11, 14, 14}, {11, 14, 14}, {11, 13, 15}, {11, 13, 15},
    {11, 12, 0},  {11, 12, 0},  {11, 14, 15}, {11, 14, 15}, {12, 0, 14},  {12, 0, 12},  {12, 15, 14}, {12, 15, 0},  {12, 0, 15},  {12, 15, 15}};
// ——————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
/* Binary search huffman table HCB_SF */
static const uint8_t hcb_sf[][2] = {
    {/*  0 */ 1, 2},   {/*  1 */ 60, 0},  {/*  2 */ 1, 2},   {/*  3 */ 2, 3},   {/*  4 */ 3, 4},   {/*  5 */ 59, 0},  {/*  6 */ 3, 4},   {/*  7 */ 4, 5},   {/*  8 */ 5, 6},   {/*  9 */ 61, 0},
    {/* 10 */ 58, 0},  {/* 11 */ 62, 0},  {/* 12 */ 3, 4},   {/* 13 */ 4, 5},   {/* 14 */ 5, 6},   {/* 15 */ 57, 0},  {/* 16 */ 63, 0},  {/* 17 */ 4, 5},   {/* 18 */ 5, 6},   {/* 19 */ 6, 7},
    {/* 20 */ 7, 8},   {/* 21 */ 56, 0},  {/* 22 */ 64, 0},  {/* 23 */ 55, 0},  {/* 24 */ 65, 0},  {/* 25 */ 4, 5},   {/* 26 */ 5, 6},   {/* 27 */ 6, 7},   {/* 28 */ 7, 8},   {/* 29 */ 66, 0},
    {/* 30 */ 54, 0},  {/* 31 */ 67, 0},  {/* 32 */ 5, 6},   {/* 33 */ 6, 7},   {/* 34 */ 7, 8},   {/* 35 */ 8, 9},   {/* 36 */ 9, 10},  {/* 37 */ 53, 0},  {/* 38 */ 68, 0},  {/* 39 */ 52, 0},
    {/* 40 */ 69, 0},  {/* 41 */ 51, 0},  {/* 42 */ 5, 6},   {/* 43 */ 6, 7},   {/* 44 */ 7, 8},   {/* 45 */ 8, 9},   {/* 46 */ 9, 10},  {/* 47 */ 70, 0},  {/* 48 */ 50, 0},  {/* 49 */ 49, 0},
    {/* 50 */ 71, 0},  {/* 51 */ 6, 7},   {/* 52 */ 7, 8},   {/* 53 */ 8, 9},   {/* 54 */ 9, 10},  {/* 55 */ 10, 11}, {/* 56 */ 11, 12}, {/* 57 */ 72, 0},  {/* 58 */ 48, 0},  {/* 59 */ 73, 0},
    {/* 60 */ 47, 0},  {/* 61 */ 74, 0},  {/* 62 */ 46, 0},  {/* 63 */ 6, 7},   {/* 64 */ 7, 8},   {/* 65 */ 8, 9},   {/* 66 */ 9, 10},  {/* 67 */ 10, 11}, {/* 68 */ 11, 12}, {/* 69 */ 76, 0},
    {/* 70 */ 75, 0},  {/* 71 */ 77, 0},  {/* 72 */ 78, 0},  {/* 73 */ 45, 0},  {/* 74 */ 43, 0},  {/* 75 */ 6, 7},   {/* 76 */ 7, 8},   {/* 77 */ 8, 9},   {/* 78 */ 9, 10},  {/* 79 */ 10, 11},
    {/* 80 */ 11, 12}, {/* 81 */ 44, 0},  {/* 82 */ 79, 0},  {/* 83 */ 42, 0},  {/* 84 */ 41, 0},  {/* 85 */ 80, 0},  {/* 86 */ 40, 0},  {/* 87 */ 6, 7},   {/* 88 */ 7, 8},   {/* 89 */ 8, 9},
    {/* 90 */ 9, 10},  {/* 91 */ 10, 11}, {/* 92 */ 11, 12}, {/* 93 */ 81, 0},  {/* 94 */ 39, 0},  {/* 95 */ 82, 0},  {/* 96 */ 38, 0},  {/* 97 */ 83, 0},  {/* 98 */ 7, 8},   {/* 99 */ 8, 9},
    {/* 00 */ 9, 10},  {/* 01 */ 10, 11}, {/* 02 */ 11, 12}, {/* 03 */ 12, 13}, {/* 04 */ 13, 14}, {/* 05 */ 37, 0},  {/* 06 */ 35, 0},  {/* 07 */ 85, 0},  {/* 08 */ 33, 0},  {/* 09 */ 36, 0},
    {/* 10 */ 34, 0},  {/* 11 */ 84, 0},  {/* 12 */ 32, 0},  {/* 13 */ 6, 7},   {/* 14 */ 7, 8},   {/* 15 */ 8, 9},   {/* 16 */ 9, 10},  {/* 17 */ 10, 11}, {/* 18 */ 11, 12}, {/* 19 */ 87, 0},
    {/* 20 */ 89, 0},  {/* 21 */ 30, 0},  {/* 22 */ 31, 0},  {/* 23 */ 8, 9},   {/* 24 */ 9, 10},  {/* 25 */ 10, 11}, {/* 26 */ 11, 12}, {/* 27 */ 12, 13}, {/* 28 */ 13, 14}, {/* 29 */ 14, 15},
    {/* 30 */ 15, 16}, {/* 31 */ 86, 0},  {/* 32 */ 29, 0},  {/* 33 */ 26, 0},  {/* 34 */ 27, 0},  {/* 35 */ 28, 0},  {/* 36 */ 24, 0},  {/* 37 */ 88, 0},  {/* 38 */ 9, 10},  {/* 39 */ 10, 11},
    {/* 40 */ 11, 12}, {/* 41 */ 12, 13}, {/* 42 */ 13, 14}, {/* 43 */ 14, 15}, {/* 44 */ 15, 16}, {/* 45 */ 16, 17}, {/* 46 */ 17, 18}, {/* 47 */ 25, 0},  {/* 48 */ 22, 0},  {/* 49 */ 23, 0},
    {/* 50 */ 15, 16}, {/* 51 */ 16, 17}, {/* 52 */ 17, 18}, {/* 53 */ 18, 19}, {/* 54 */ 19, 20}, {/* 55 */ 20, 21}, {/* 56 */ 21, 22}, {/* 57 */ 22, 23}, {/* 58 */ 23, 24}, {/* 59 */ 24, 25},
    {/* 60 */ 25, 26}, {/* 61 */ 26, 27}, {/* 62 */ 27, 28}, {/* 63 */ 28, 29}, {/* 64 */ 29, 30}, {/* 65 */ 90, 0},  {/* 66 */ 21, 0},  {/* 67 */ 19, 0},  {/* 68 */ 3, 0},   {/* 69 */ 1, 0},
    {/* 70 */ 2, 0},   {/* 71 */ 0, 0},   {/* 72 */ 23, 24}, {/* 73 */ 24, 25}, {/* 74 */ 25, 26}, {/* 75 */ 26, 27}, {/* 76 */ 27, 28}, {/* 77 */ 28, 29}, {/* 78 */ 29, 30}, {/* 79 */ 30, 31},
    {/* 80 */ 31, 32}, {/* 81 */ 32, 33}, {/* 82 */ 33, 34}, {/* 83 */ 34, 35}, {/* 84 */ 35, 36}, {/* 85 */ 36, 37}, {/* 86 */ 37, 38}, {/* 87 */ 38, 39}, {/* 88 */ 39, 40}, {/* 89 */ 40, 41},
    {/* 90 */ 41, 42}, {/* 91 */ 42, 43}, {/* 92 */ 43, 44}, {/* 93 */ 44, 45}, {/* 94 */ 45, 46}, {/* 95 */ 98, 0},  {/* 96 */ 99, 0},  {/* 97 */ 100, 0}, {/* 98 */ 101, 0}, {/* 99 */ 102, 0},
    {/* 00 */ 117, 0}, {/* 01 */ 97, 0},  {/* 02 */ 91, 0},  {/* 03 */ 92, 0},  {/* 04 */ 93, 0},  {/* 05 */ 94, 0},  {/* 06 */ 95, 0},  {/* 07 */ 96, 0},  {/* 08 */ 104, 0}, {/* 09 */ 111, 0},
    {/* 10 */ 112, 0}, {/* 11 */ 113, 0}, {/* 12 */ 114, 0}, {/* 13 */ 115, 0}, {/* 14 */ 116, 0}, {/* 15 */ 110, 0}, {/* 16 */ 105, 0}, {/* 17 */ 106, 0}, {/* 18 */ 107, 0}, {/* 19 */ 108, 0},
    {/* 20 */ 109, 0}, {/* 21 */ 118, 0}, {/* 22 */ 6, 0},   {/* 23 */ 8, 0},   {/* 24 */ 9, 0},   {/* 25 */ 10, 0},  {/* 26 */ 5, 0},   {/* 27 */ 103, 0}, {/* 28 */ 120, 0}, {/* 29 */ 119, 0},
    {/* 30 */ 4, 0},   {/* 31 */ 7, 0},   {/* 32 */ 15, 0},  {/* 33 */ 16, 0},  {/* 34 */ 18, 0},  {/* 35 */ 20, 0},  {/* 36 */ 17, 0},  {/* 37 */ 11, 0},  {/* 38 */ 12, 0},  {/* 39 */ 14, 0},
    {/* 40 */ 13, 0}};
// ——————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
static const hcb*          hcb_table[] = {0, hcb1_1, hcb2_1, 0, hcb4_1, 0, hcb6_1, 0, hcb8_1, 0, hcb10_1, hcb11_1};
static const hcb_2_quad*   hcb_2_quad_table[] = {0, hcb1_2, hcb2_2, 0, hcb4_2, 0, 0, 0, 0, 0, 0, 0};
static const hcb_2_pair*   hcb_2_pair_table[] = {0, 0, 0, 0, 0, 0, hcb6_2, 0, hcb8_2, 0, hcb10_2, hcb11_2};
static const hcb_bin_pair* hcb_bin_table[] = {0, 0, 0, 0, 0, hcb5, 0, hcb7, 0, hcb9, 0, 0};
static const uint8_t       hcbN[] = {0, 5, 5, 0, 5, 0, 5, 0, 5, 0, 6, 5};
// ——————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
// ——————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
const uint8_t PreSortCB_STD[NUM_CB] = {11, 9, 7, 5, 3, 1};
const uint8_t PreSortCB_ER[NUM_CB_ER] = {11, 31, 30, 29, 28, 27, 26, 25, 24, 23, 22, 21, 20, 19, 18, 17, 16, 9, 7, 5, 3, 1};
/* 8.5.3.3.2 Derivation of segment width */
const uint8_t maxCwLen[MAX_CB] = {0, 11, 9, 20, 16, 13, 11, 14, 12, 17, 14, 49, 0, 0, 0, 0, 14, 17, 21, 21, 25, 25, 29, 29, 29, 29, 33, 33, 33, 37, 37, 41};

/* bit-twiddling helpers */
const uint8_t  S[] = {1, 2, 4, 8, 16};
const uint32_t B[] = {0x55555555, 0x33333333, 0x0F0F0F0F, 0x00FF00FF, 0x0000FFFF};
// ——————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
#ifdef SBR_DEC
    #ifndef SBR_LOW_POWER
// w_array_real[i] = cos(2*M_PI*i/32)
static const real_t w_array_real[] = {FRAC_CONST(1.000000000000000),  FRAC_CONST(0.980785279337272),  FRAC_CONST(0.923879528329380),  FRAC_CONST(0.831469603195765),
                                      FRAC_CONST(0.707106765732237),  FRAC_CONST(0.555570210304169),  FRAC_CONST(0.382683402077046),  FRAC_CONST(0.195090284503576),
                                      FRAC_CONST(0.000000000000000),  FRAC_CONST(-0.195090370246552), FRAC_CONST(-0.382683482845162), FRAC_CONST(-0.555570282993553),
                                      FRAC_CONST(-0.707106827549476), FRAC_CONST(-0.831469651765257), FRAC_CONST(-0.923879561784627), FRAC_CONST(-0.980785296392607)};
// w_array_imag[i] = sin(-2*M_PI*i/32)
static const real_t w_array_imag[] = {FRAC_CONST(0.000000000000000),  FRAC_CONST(-0.195090327375064), FRAC_CONST(-0.382683442461104), FRAC_CONST(-0.555570246648862),
                                      FRAC_CONST(-0.707106796640858), FRAC_CONST(-0.831469627480512), FRAC_CONST(-0.923879545057005), FRAC_CONST(-0.980785287864940),
                                      FRAC_CONST(-1.000000000000000), FRAC_CONST(-0.980785270809601), FRAC_CONST(-0.923879511601754), FRAC_CONST(-0.831469578911016),
                                      FRAC_CONST(-0.707106734823616), FRAC_CONST(-0.555570173959476), FRAC_CONST(-0.382683361692986), FRAC_CONST(-0.195090241632088)};
    // FFT decimation in frequency
    // 4*16*2+16=128+16=144 multiplications
    // 6*16*2+10*8+4*16*2=192+80+128=400 additions
    #endif // SBR_LOW_POWER
#endif     // SBR_DEC
// ——————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
#ifdef FIXED_POINT
/* 256 (N/4) complex twiddle factors */
static const complex_t mdct_tab_2048[] = {
    {FRAC_CONST(0.999999926465718), FRAC_CONST(0.000383495187571)}, {FRAC_CONST(0.999994043728986), FRAC_CONST(0.003451449920136)}, {FRAC_CONST(0.999978748667469), FRAC_CONST(0.006519372166339)},
    {FRAC_CONST(0.999954041425130), FRAC_CONST(0.009587233049729)}, {FRAC_CONST(0.999919922234523), FRAC_CONST(0.012655003694430)}, {FRAC_CONST(0.999876391416790), FRAC_CONST(0.015722655225417)},
    {FRAC_CONST(0.999823449381662), FRAC_CONST(0.018790158768785)}, {FRAC_CONST(0.999761096627447), FRAC_CONST(0.021857485452022)}, {FRAC_CONST(0.999689333741034), FRAC_CONST(0.024924606404281)},
    {FRAC_CONST(0.999608161397882), FRAC_CONST(0.027991492756653)}, {FRAC_CONST(0.999517580362017), FRAC_CONST(0.031058115642435)}, {FRAC_CONST(0.999417591486022), FRAC_CONST(0.034124446197403)},
    {FRAC_CONST(0.999308195711029), FRAC_CONST(0.037190455560088)}, {FRAC_CONST(0.999189394066715), FRAC_CONST(0.040256114872041)}, {FRAC_CONST(0.999061187671285), FRAC_CONST(0.043321395278110)},
    {FRAC_CONST(0.998923577731466), FRAC_CONST(0.046386267926707)}, {FRAC_CONST(0.998776565542496), FRAC_CONST(0.049450703970085)}, {FRAC_CONST(0.998620152488109), FRAC_CONST(0.052514674564603)},
    {FRAC_CONST(0.998454340040525), FRAC_CONST(0.055578150871005)}, {FRAC_CONST(0.998279129760433), FRAC_CONST(0.058641104054683)}, {FRAC_CONST(0.998094523296980), FRAC_CONST(0.061703505285957)},
    {FRAC_CONST(0.997900522387752), FRAC_CONST(0.064765325740340)}, {FRAC_CONST(0.997697128858759), FRAC_CONST(0.067826536598811)}, {FRAC_CONST(0.997484344624418), FRAC_CONST(0.070887109048088)},
    {FRAC_CONST(0.997262171687536), FRAC_CONST(0.073947014280897)}, {FRAC_CONST(0.997030612139289), FRAC_CONST(0.077006223496246)}, {FRAC_CONST(0.996789668159205), FRAC_CONST(0.080064707899691)},
    {FRAC_CONST(0.996539342015138), FRAC_CONST(0.083122438703613)}, {FRAC_CONST(0.996279636063255), FRAC_CONST(0.086179387127485)}, {FRAC_CONST(0.996010552748006), FRAC_CONST(0.089235524398144)},
    {FRAC_CONST(0.995732094602106), FRAC_CONST(0.092290821750062)}, {FRAC_CONST(0.995444264246510), FRAC_CONST(0.095345250425618)}, {FRAC_CONST(0.995147064390386), FRAC_CONST(0.098398781675364)},
    {FRAC_CONST(0.994840497831093), FRAC_CONST(0.101451386758302)}, {FRAC_CONST(0.994524567454152), FRAC_CONST(0.104503036942151)}, {FRAC_CONST(0.994199276233219), FRAC_CONST(0.107553703503616)},
    {FRAC_CONST(0.993864627230060), FRAC_CONST(0.110603357728662)}, {FRAC_CONST(0.993520623594518), FRAC_CONST(0.113651970912782)}, {FRAC_CONST(0.993167268564487), FRAC_CONST(0.116699514361268)},
    {FRAC_CONST(0.992804565465879), FRAC_CONST(0.119745959389480)}, {FRAC_CONST(0.992432517712594), FRAC_CONST(0.122791277323117)}, {FRAC_CONST(0.992051128806486), FRAC_CONST(0.125835439498487)},
    {FRAC_CONST(0.991660402337333), FRAC_CONST(0.128878417262777)}, {FRAC_CONST(0.991260341982802), FRAC_CONST(0.131920181974320)}, {FRAC_CONST(0.990850951508414), FRAC_CONST(0.134960705002869)},
    {FRAC_CONST(0.990432234767506), FRAC_CONST(0.137999957729863)}, {FRAC_CONST(0.990004195701201), FRAC_CONST(0.141037911548698)}, {FRAC_CONST(0.989566838338365), FRAC_CONST(0.144074537864995)},
    {FRAC_CONST(0.989120166795573), FRAC_CONST(0.147109808096872)}, {FRAC_CONST(0.988664185277066), FRAC_CONST(0.150143693675208)}, {FRAC_CONST(0.988198898074718), FRAC_CONST(0.153176166043918)},
    {FRAC_CONST(0.987724309567987), FRAC_CONST(0.156207196660216)}, {FRAC_CONST(0.987240424223882), FRAC_CONST(0.159236756994888)}, {FRAC_CONST(0.986747246596917), FRAC_CONST(0.162264818532558)},
    {FRAC_CONST(0.986244781329065), FRAC_CONST(0.165291352771958)}, {FRAC_CONST(0.985733033149723), FRAC_CONST(0.168316331226195)}, {FRAC_CONST(0.985212006875659), FRAC_CONST(0.171339725423019)},
    {FRAC_CONST(0.984681707410971), FRAC_CONST(0.174361506905094)}, {FRAC_CONST(0.984142139747039), FRAC_CONST(0.177381647230260)}, {FRAC_CONST(0.983593308962479), FRAC_CONST(0.180400117971807)},
    {FRAC_CONST(0.983035220223096), FRAC_CONST(0.183416890718739)}, {FRAC_CONST(0.982467878781833), FRAC_CONST(0.186431937076042)}, {FRAC_CONST(0.981891289978725), FRAC_CONST(0.189445228664950)},
    {FRAC_CONST(0.981305459240845), FRAC_CONST(0.192456737123217)}, {FRAC_CONST(0.980710392082254), FRAC_CONST(0.195466434105377)}, {FRAC_CONST(0.980106094103952), FRAC_CONST(0.198474291283016)},
    {FRAC_CONST(0.979492570993821), FRAC_CONST(0.201480280345038)}, {FRAC_CONST(0.978869828526574), FRAC_CONST(0.204484372997927)}, {FRAC_CONST(0.978237872563701), FRAC_CONST(0.207486540966021)},
    {FRAC_CONST(0.977596709053412), FRAC_CONST(0.210486755991770)}, {FRAC_CONST(0.976946344030582), FRAC_CONST(0.213484989836008)}, {FRAC_CONST(0.976286783616694), FRAC_CONST(0.216481214278217)},
    {FRAC_CONST(0.975618034019782), FRAC_CONST(0.219475401116790)}, {FRAC_CONST(0.974940101534372), FRAC_CONST(0.222467522169302)}, {FRAC_CONST(0.974252992541423), FRAC_CONST(0.225457549272769)},
    {FRAC_CONST(0.973556713508266), FRAC_CONST(0.228445454283916)}, {FRAC_CONST(0.972851270988544), FRAC_CONST(0.231431209079446)}, {FRAC_CONST(0.972136671622152), FRAC_CONST(0.234414785556295)},
    {FRAC_CONST(0.971412922135171), FRAC_CONST(0.237396155631907)}, {FRAC_CONST(0.970680029339806), FRAC_CONST(0.240375291244489)}, {FRAC_CONST(0.969938000134324), FRAC_CONST(0.243352164353285)},
    {FRAC_CONST(0.969186841502986), FRAC_CONST(0.246326746938829)}, {FRAC_CONST(0.968426560515983), FRAC_CONST(0.249299011003218)}, {FRAC_CONST(0.967657164329370), FRAC_CONST(0.252268928570371)},
    {FRAC_CONST(0.966878660184996), FRAC_CONST(0.255236471686292)}, {FRAC_CONST(0.966091055410439), FRAC_CONST(0.258201612419335)}, {FRAC_CONST(0.965294357418935), FRAC_CONST(0.261164322860466)},
    {FRAC_CONST(0.964488573709308), FRAC_CONST(0.264124575123528)}, {FRAC_CONST(0.963673711865903), FRAC_CONST(0.267082341345496)}, {FRAC_CONST(0.962849779558509), FRAC_CONST(0.270037593686751)},
    {FRAC_CONST(0.962016784542291), FRAC_CONST(0.272990304331330)}, {FRAC_CONST(0.961174734657714), FRAC_CONST(0.275940445487197)}, {FRAC_CONST(0.960323637830474), FRAC_CONST(0.278887989386500)},
    {FRAC_CONST(0.959463502071418), FRAC_CONST(0.281832908285833)}, {FRAC_CONST(0.958594335476470), FRAC_CONST(0.284775174466498)}, {FRAC_CONST(0.957716146226559), FRAC_CONST(0.287714760234765)},
    {FRAC_CONST(0.956828942587535), FRAC_CONST(0.290651637922133)}, {FRAC_CONST(0.955932732910098), FRAC_CONST(0.293585779885591)}, {FRAC_CONST(0.955027525629714), FRAC_CONST(0.296517158507877)},
    {FRAC_CONST(0.954113329266539), FRAC_CONST(0.299445746197740)}, {FRAC_CONST(0.953190152425337), FRAC_CONST(0.302371515390196)}, {FRAC_CONST(0.952258003795400), FRAC_CONST(0.305294438546792)},
    {FRAC_CONST(0.951316892150466), FRAC_CONST(0.308214488155861)}, {FRAC_CONST(0.950366826348636), FRAC_CONST(0.311131636732785)}, {FRAC_CONST(0.949407815332292), FRAC_CONST(0.314045856820251)},
    {FRAC_CONST(0.948439868128010), FRAC_CONST(0.316957120988508)}, {FRAC_CONST(0.947462993846478), FRAC_CONST(0.319865401835631)}, {FRAC_CONST(0.946477201682409), FRAC_CONST(0.322770671987771)},
    {FRAC_CONST(0.945482500914454), FRAC_CONST(0.325672904099420)}, {FRAC_CONST(0.944478900905116), FRAC_CONST(0.328572070853664)}, {FRAC_CONST(0.943466411100659), FRAC_CONST(0.331468144962441)},
    {FRAC_CONST(0.942445041031025), FRAC_CONST(0.334361099166799)}, {FRAC_CONST(0.941414800309736), FRAC_CONST(0.337250906237151)}, {FRAC_CONST(0.940375698633812), FRAC_CONST(0.340137538973532)},
    {FRAC_CONST(0.939327745783671), FRAC_CONST(0.343020970205856)}, {FRAC_CONST(0.938270951623047), FRAC_CONST(0.345901172794169)}, {FRAC_CONST(0.937205326098888), FRAC_CONST(0.348778119628908)},
    {FRAC_CONST(0.936130879241267), FRAC_CONST(0.351651783631155)}, {FRAC_CONST(0.935047621163287), FRAC_CONST(0.354522137752887)}, {FRAC_CONST(0.933955562060987), FRAC_CONST(0.357389154977241)},
    {FRAC_CONST(0.932854712213241), FRAC_CONST(0.360252808318757)}, {FRAC_CONST(0.931745081981669), FRAC_CONST(0.363113070823639)}, {FRAC_CONST(0.930626681810532), FRAC_CONST(0.365969915570009)},
    {FRAC_CONST(0.929499522226639), FRAC_CONST(0.368823315668154)}, {FRAC_CONST(0.928363613839244), FRAC_CONST(0.371673244260787)}, {FRAC_CONST(0.927218967339952), FRAC_CONST(0.374519674523293)},
    {FRAC_CONST(0.926065593502609), FRAC_CONST(0.377362579663988)}, {FRAC_CONST(0.924903503183211), FRAC_CONST(0.380201932924366)}, {FRAC_CONST(0.923732707319793), FRAC_CONST(0.383037707579352)},
    {FRAC_CONST(0.922553216932333), FRAC_CONST(0.385869876937555)}, {FRAC_CONST(0.921365043122642), FRAC_CONST(0.388698414341519)}, {FRAC_CONST(0.920168197074266), FRAC_CONST(0.391523293167972)},
    {FRAC_CONST(0.918962690052376), FRAC_CONST(0.394344486828080)}, {FRAC_CONST(0.917748533403661), FRAC_CONST(0.397161968767692)}, {FRAC_CONST(0.916525738556228), FRAC_CONST(0.399975712467595)},
    {FRAC_CONST(0.915294317019487), FRAC_CONST(0.402785691443764)}, {FRAC_CONST(0.914054280384047), FRAC_CONST(0.405591879247604)}, {FRAC_CONST(0.912805640321604), FRAC_CONST(0.408394249466208)},
    {FRAC_CONST(0.911548408584834), FRAC_CONST(0.411192775722600)}, {FRAC_CONST(0.910282597007282), FRAC_CONST(0.413987431675985)}, {FRAC_CONST(0.909008217503247), FRAC_CONST(0.416778191021998)},
    {FRAC_CONST(0.907725282067676), FRAC_CONST(0.419565027492947)}, {FRAC_CONST(0.906433802776045), FRAC_CONST(0.422347914858067)}, {FRAC_CONST(0.905133791784250), FRAC_CONST(0.425126826923762)},
    {FRAC_CONST(0.903825261328488), FRAC_CONST(0.427901737533854)}, {FRAC_CONST(0.902508223725146), FRAC_CONST(0.430672620569827)}, {FRAC_CONST(0.901182691370685), FRAC_CONST(0.433439449951074)},
    {FRAC_CONST(0.899848676741519), FRAC_CONST(0.436202199635144)}, {FRAC_CONST(0.898506192393902), FRAC_CONST(0.438960843617984)}, {FRAC_CONST(0.897155250963809), FRAC_CONST(0.441715355934187)},
    {FRAC_CONST(0.895795865166814), FRAC_CONST(0.444465710657234)}, {FRAC_CONST(0.894428047797974), FRAC_CONST(0.447211881899738)}, {FRAC_CONST(0.893051811731707), FRAC_CONST(0.449953843813691)},
    {FRAC_CONST(0.891667169921672), FRAC_CONST(0.452691570590701)}, {FRAC_CONST(0.890274135400645), FRAC_CONST(0.455425036462242)}, {FRAC_CONST(0.888872721280396), FRAC_CONST(0.458154215699893)},
    {FRAC_CONST(0.887462940751569), FRAC_CONST(0.460879082615579)}, {FRAC_CONST(0.886044807083556), FRAC_CONST(0.463599611561814)}, {FRAC_CONST(0.884618333624370), FRAC_CONST(0.466315776931944)},
    {FRAC_CONST(0.883183533800523), FRAC_CONST(0.469027553160387)}, {FRAC_CONST(0.881740421116898), FRAC_CONST(0.471734914722871)}, {FRAC_CONST(0.880289009156621), FRAC_CONST(0.474437836136679)},
    {FRAC_CONST(0.878829311580933), FRAC_CONST(0.477136291960885)}, {FRAC_CONST(0.877361342129065), FRAC_CONST(0.479830256796594)}, {FRAC_CONST(0.875885114618104), FRAC_CONST(0.482519705287184)},
    {FRAC_CONST(0.874400642942865), FRAC_CONST(0.485204612118542)}, {FRAC_CONST(0.872907941075761), FRAC_CONST(0.487884952019301)}, {FRAC_CONST(0.871407023066671), FRAC_CONST(0.490560699761082)},
    {FRAC_CONST(0.869897903042806), FRAC_CONST(0.493231830158728)}, {FRAC_CONST(0.868380595208580), FRAC_CONST(0.495898318070542)}, {FRAC_CONST(0.866855113845470), FRAC_CONST(0.498560138398525)},
    {FRAC_CONST(0.865321473311890), FRAC_CONST(0.501217266088610)}, {FRAC_CONST(0.863779688043047), FRAC_CONST(0.503869676130899)}, {FRAC_CONST(0.862229772550811), FRAC_CONST(0.506517343559899)},
    {FRAC_CONST(0.860671741423578), FRAC_CONST(0.509160243454755)}, {FRAC_CONST(0.859105609326130), FRAC_CONST(0.511798350939487)}, {FRAC_CONST(0.857531390999499), FRAC_CONST(0.514431641183223)},
    {FRAC_CONST(0.855949101260827), FRAC_CONST(0.517060089400432)}, {FRAC_CONST(0.854358755003227), FRAC_CONST(0.519683670851158)}, {FRAC_CONST(0.852760367195645), FRAC_CONST(0.522302360841255)},
    {FRAC_CONST(0.851153952882715), FRAC_CONST(0.524916134722613)}, {FRAC_CONST(0.849539527184621), FRAC_CONST(0.527524967893398)}, {FRAC_CONST(0.847917105296951), FRAC_CONST(0.530128835798279)},
    {FRAC_CONST(0.846286702490560), FRAC_CONST(0.532727713928659)}, {FRAC_CONST(0.844648334111418), FRAC_CONST(0.535321577822907)}, {FRAC_CONST(0.843002015580473), FRAC_CONST(0.537910403066589)},
    {FRAC_CONST(0.841347762393502), FRAC_CONST(0.540494165292695)}, {FRAC_CONST(0.839685590120966), FRAC_CONST(0.543072840181872)}, {FRAC_CONST(0.838015514407864), FRAC_CONST(0.545646403462649)},
    {FRAC_CONST(0.836337550973584), FRAC_CONST(0.548214830911668)}, {FRAC_CONST(0.834651715611756), FRAC_CONST(0.550778098353912)}, {FRAC_CONST(0.832958024190107), FRAC_CONST(0.553336181662932)},
    {FRAC_CONST(0.831256492650303), FRAC_CONST(0.555889056761074)}, {FRAC_CONST(0.829547137007809), FRAC_CONST(0.558436699619704)}, {FRAC_CONST(0.827829973351730), FRAC_CONST(0.560979086259438)},
    {FRAC_CONST(0.826105017844665), FRAC_CONST(0.563516192750365)}, {FRAC_CONST(0.824372286722551), FRAC_CONST(0.566047995212271)}, {FRAC_CONST(0.822631796294515), FRAC_CONST(0.568574469814869)},
    {FRAC_CONST(0.820883562942715), FRAC_CONST(0.571095592778017)}, {FRAC_CONST(0.819127603122188), FRAC_CONST(0.573611340371945)}, {FRAC_CONST(0.817363933360698), FRAC_CONST(0.576121688917478)},
    {FRAC_CONST(0.815592570258577), FRAC_CONST(0.578626614786261)}, {FRAC_CONST(0.813813530488567), FRAC_CONST(0.581126094400978)}, {FRAC_CONST(0.812026830795670), FRAC_CONST(0.583620104235573)},
    {FRAC_CONST(0.810232487996982), FRAC_CONST(0.586108620815476)}, {FRAC_CONST(0.808430518981543), FRAC_CONST(0.588591620717823)}, {FRAC_CONST(0.806620940710170), FRAC_CONST(0.591069080571671)},
    {FRAC_CONST(0.804803770215303), FRAC_CONST(0.593540977058226)}, {FRAC_CONST(0.802979024600843), FRAC_CONST(0.596007286911057)}, {FRAC_CONST(0.801146721041991), FRAC_CONST(0.598467986916314)},
    {FRAC_CONST(0.799306876785086), FRAC_CONST(0.600923053912954)}, {FRAC_CONST(0.797459509147442), FRAC_CONST(0.603372464792950)}, {FRAC_CONST(0.795604635517188), FRAC_CONST(0.605816196501515)},
    {FRAC_CONST(0.793742273353100), FRAC_CONST(0.608254226037314)}, {FRAC_CONST(0.791872440184440), FRAC_CONST(0.610686530452686)}, {FRAC_CONST(0.789995153610791), FRAC_CONST(0.613113086853855)},
    {FRAC_CONST(0.788110431301888), FRAC_CONST(0.615533872401147)}, {FRAC_CONST(0.786218290997456), FRAC_CONST(0.617948864309208)}, {FRAC_CONST(0.784318750507039), FRAC_CONST(0.620358039847214)},
    {FRAC_CONST(0.782411827709837), FRAC_CONST(0.622761376339086)}, {FRAC_CONST(0.780497540554532), FRAC_CONST(0.625158851163708)}, {FRAC_CONST(0.778575907059125), FRAC_CONST(0.627550441755132)},
    {FRAC_CONST(0.776646945310762), FRAC_CONST(0.629936125602796)}, {FRAC_CONST(0.774710673465566), FRAC_CONST(0.632315880251738)}, {FRAC_CONST(0.772767109748464), FRAC_CONST(0.634689683302798)},
    {FRAC_CONST(0.770816272453019), FRAC_CONST(0.637057512412839)}, {FRAC_CONST(0.768858179941253), FRAC_CONST(0.639419345294951)}, {FRAC_CONST(0.766892850643481), FRAC_CONST(0.641775159718664)},
    {FRAC_CONST(0.764920303058128), FRAC_CONST(0.644124933510155)}, {FRAC_CONST(0.762940555751566), FRAC_CONST(0.646468644552458)}, {FRAC_CONST(0.760953627357928), FRAC_CONST(0.648806270785673)},
    {FRAC_CONST(0.758959536578942), FRAC_CONST(0.651137790207170)}, {FRAC_CONST(0.756958302183750), FRAC_CONST(0.653463180871802)}, {FRAC_CONST(0.754949943008733), FRAC_CONST(0.655782420892106)},
    {FRAC_CONST(0.752934477957330), FRAC_CONST(0.658095488438511)}, {FRAC_CONST(0.750911925999868), FRAC_CONST(0.660402361739545)}, {FRAC_CONST(0.748882306173375), FRAC_CONST(0.662703019082037)},
    {FRAC_CONST(0.746845637581407), FRAC_CONST(0.664997438811325)}, {FRAC_CONST(0.744801939393863), FRAC_CONST(0.667285599331456)}, {FRAC_CONST(0.742751230846809), FRAC_CONST(0.669567479105392)},
    {FRAC_CONST(0.740693531242296), FRAC_CONST(0.671843056655212)}, {FRAC_CONST(0.738628859948175), FRAC_CONST(0.674112310562312)}, {FRAC_CONST(0.736557236397919), FRAC_CONST(0.676375219467612)},
    {FRAC_CONST(0.734478680090438), FRAC_CONST(0.678631762071749)}, {FRAC_CONST(0.732393210589896), FRAC_CONST(0.680881917135287)}, {FRAC_CONST(0.730300847525525), FRAC_CONST(0.683125663478909)},
    {FRAC_CONST(0.728201610591445), FRAC_CONST(0.685362979983619)}, {FRAC_CONST(0.726095519546471), FRAC_CONST(0.687593845590942)}, {FRAC_CONST(0.723982594213936), FRAC_CONST(0.689818239303122)},
    {FRAC_CONST(0.721862854481496), FRAC_CONST(0.692036140183319)}, {FRAC_CONST(0.719736320300951), FRAC_CONST(0.694247527355803)}, {FRAC_CONST(0.717603011688049), FRAC_CONST(0.696452380006158)},
    {FRAC_CONST(0.715462948722304), FRAC_CONST(0.698650677381469)}, {FRAC_CONST(0.713316151546803), FRAC_CONST(0.700842398790526)}, {FRAC_CONST(0.711162640368018), FRAC_CONST(0.703027523604011)},
    {FRAC_CONST(0.709002435455618), FRAC_CONST(0.705206031254698)}, {FRAC_CONST(0.706835557142274), FRAC_CONST(0.707377901237642)}, {FRAC_CONST(0.704662025823469), FRAC_CONST(0.709543113110377)},
    {FRAC_CONST(0.702481861957308), FRAC_CONST(0.711701646493103)}, {FRAC_CONST(0.700295086064324), FRAC_CONST(0.713853481068882)}, {FRAC_CONST(0.698101718727284), FRAC_CONST(0.715998596583829)},
    {FRAC_CONST(0.695901780590997), FRAC_CONST(0.718136972847297)}, {FRAC_CONST(0.693695292362118), FRAC_CONST(0.720268589732077)}, {FRAC_CONST(0.691482274808956), FRAC_CONST(0.722393427174578)},
    {FRAC_CONST(0.689262748761273), FRAC_CONST(0.724511465175020)}, {FRAC_CONST(0.687036735110096), FRAC_CONST(0.726622683797623)}, {FRAC_CONST(0.684804254807511), FRAC_CONST(0.728727063170794)},
    {FRAC_CONST(0.682565328866473), FRAC_CONST(0.730824583487312)}, {FRAC_CONST(0.680319978360607), FRAC_CONST(0.732915225004518)}, {FRAC_CONST(0.678068224424007), FRAC_CONST(0.734998968044497)},
    {FRAC_CONST(0.675810088251037), FRAC_CONST(0.737075792994266)}, {FRAC_CONST(0.673545591096136), FRAC_CONST(0.739145680305957)}, {FRAC_CONST(0.671274754273613), FRAC_CONST(0.741208610497004)},
    {FRAC_CONST(0.668997599157450), FRAC_CONST(0.743264564150321)}, {FRAC_CONST(0.666714147181098), FRAC_CONST(0.745313521914490)}, {FRAC_CONST(0.664424419837275), FRAC_CONST(0.747355464503940)},
    {FRAC_CONST(0.662128438677769), FRAC_CONST(0.749390372699130)}, {FRAC_CONST(0.659826225313227), FRAC_CONST(0.751418227346727)}, {FRAC_CONST(0.657517801412960), FRAC_CONST(0.753439009359794)},
    {FRAC_CONST(0.655203188704732), FRAC_CONST(0.755452699717958)}, {FRAC_CONST(0.652882408974559), FRAC_CONST(0.757459279467601)}, {FRAC_CONST(0.650555484066504), FRAC_CONST(0.759458729722028)},
    {FRAC_CONST(0.648222435882470), FRAC_CONST(0.761451031661654)}, {FRAC_CONST(0.645883286381996), FRAC_CONST(0.763436166534172)}, {FRAC_CONST(0.643538057582048), FRAC_CONST(0.765414115654738)},
    {FRAC_CONST(0.641186771556811), FRAC_CONST(0.767384860406142)}, {FRAC_CONST(0.638829450437486), FRAC_CONST(0.769348382238982)}, {FRAC_CONST(0.636466116412077), FRAC_CONST(0.771304662671845)},
    {FRAC_CONST(0.634096791725184), FRAC_CONST(0.773253683291473)}, {FRAC_CONST(0.631721498677792), FRAC_CONST(0.775195425752941)}, {FRAC_CONST(0.629340259627066), FRAC_CONST(0.777129871779832)},
    {FRAC_CONST(0.626953096986133), FRAC_CONST(0.779057003164401)}, {FRAC_CONST(0.624560033223877), FRAC_CONST(0.780976801767754)}, {FRAC_CONST(0.622161090864727), FRAC_CONST(0.782889249520015)},
    {FRAC_CONST(0.619756292488441), FRAC_CONST(0.784794328420499)}, {FRAC_CONST(0.617345660729897), FRAC_CONST(0.786692020537877)}, {FRAC_CONST(0.614929218278880), FRAC_CONST(0.788582308010347)},
    {FRAC_CONST(0.612506987879866), FRAC_CONST(0.790465173045805)}, {FRAC_CONST(0.610078992331810), FRAC_CONST(0.792340597922007)}, {FRAC_CONST(0.607645254487931), FRAC_CONST(0.794208564986741)},
    {FRAC_CONST(0.605205797255497), FRAC_CONST(0.796069056657988)}, {FRAC_CONST(0.602760643595607), FRAC_CONST(0.797922055424093)}, {FRAC_CONST(0.600309816522980), FRAC_CONST(0.799767543843926)},
    {FRAC_CONST(0.597853339105734), FRAC_CONST(0.801605504547046)}, {FRAC_CONST(0.595391234465169), FRAC_CONST(0.803435920233868)}, {FRAC_CONST(0.592923525775551), FRAC_CONST(0.805258773675822)},
    {FRAC_CONST(0.590450236263896), FRAC_CONST(0.807074047715518)}, {FRAC_CONST(0.587971389209745), FRAC_CONST(0.808881725266904)}, {FRAC_CONST(0.585487007944951), FRAC_CONST(0.810681789315431)},
    {FRAC_CONST(0.582997115853458), FRAC_CONST(0.812474222918210)}, {FRAC_CONST(0.580501736371077), FRAC_CONST(0.814259009204175)}, {FRAC_CONST(0.578000892985270), FRAC_CONST(0.816036131374237)},
    {FRAC_CONST(0.575494609234928), FRAC_CONST(0.817805572701444)}, {FRAC_CONST(0.572982908710149), FRAC_CONST(0.819567316531142)}, {FRAC_CONST(0.570465815052013), FRAC_CONST(0.821321346281127)},
    {FRAC_CONST(0.567943351952366), FRAC_CONST(0.823067645441802)}, {FRAC_CONST(0.565415543153590), FRAC_CONST(0.824806197576334)}, {FRAC_CONST(0.562882412448385), FRAC_CONST(0.826536986320810)},
    {FRAC_CONST(0.560343983679541), FRAC_CONST(0.828259995384386)}, {FRAC_CONST(0.557800280739717), FRAC_CONST(0.829975208549444)}, {FRAC_CONST(0.555251327571214), FRAC_CONST(0.831682609671745)},
    {FRAC_CONST(0.552697148165750), FRAC_CONST(0.833382182680580)}, {FRAC_CONST(0.550137766564234), FRAC_CONST(0.835073911578919)}, {FRAC_CONST(0.547573206856540), FRAC_CONST(0.836757780443567)},
    {FRAC_CONST(0.545003493181281), FRAC_CONST(0.838433773425308)}, {FRAC_CONST(0.542428649725581), FRAC_CONST(0.840101874749058)}, {FRAC_CONST(0.539848700724848), FRAC_CONST(0.841762068714012)},
    {FRAC_CONST(0.537263670462543), FRAC_CONST(0.843414339693793)}, {FRAC_CONST(0.534673583269956), FRAC_CONST(0.845058672136595)}, {FRAC_CONST(0.532078463525974), FRAC_CONST(0.846695050565337)},
    {FRAC_CONST(0.529478335656852), FRAC_CONST(0.848323459577802)}, {FRAC_CONST(0.526873224135985), FRAC_CONST(0.849943883846782)}, {FRAC_CONST(0.524263153483673), FRAC_CONST(0.851556308120229)},
    {FRAC_CONST(0.521648148266897), FRAC_CONST(0.853160717221390)}, {FRAC_CONST(0.519028233099081), FRAC_CONST(0.854757096048957)}, {FRAC_CONST(0.516403432639864), FRAC_CONST(0.856345429577204)},
    {FRAC_CONST(0.513773771594868), FRAC_CONST(0.857925702856130)}, {FRAC_CONST(0.511139274715464), FRAC_CONST(0.859497901011602)}, {FRAC_CONST(0.508499966798541), FRAC_CONST(0.861062009245491)},
    {FRAC_CONST(0.505855872686269), FRAC_CONST(0.862618012835817)}, {FRAC_CONST(0.503207017265869), FRAC_CONST(0.864165897136879)}, {FRAC_CONST(0.500553425469378), FRAC_CONST(0.865705647579402)},
    {FRAC_CONST(0.497895122273411), FRAC_CONST(0.867237249670668)}, {FRAC_CONST(0.495232132698931), FRAC_CONST(0.868760688994655)}, {FRAC_CONST(0.492564481811011), FRAC_CONST(0.870275951212172)},
    {FRAC_CONST(0.489892194718595), FRAC_CONST(0.871783022060993)}, {FRAC_CONST(0.487215296574269), FRAC_CONST(0.873281887355994)}, {FRAC_CONST(0.484533812574016), FRAC_CONST(0.874772532989284)},
    {FRAC_CONST(0.481847767956986), FRAC_CONST(0.876254944930338)}, {FRAC_CONST(0.479157188005253), FRAC_CONST(0.877729109226132)}, {FRAC_CONST(0.476462098043581), FRAC_CONST(0.879195012001267)},
    {FRAC_CONST(0.473762523439183), FRAC_CONST(0.880652639458111)}, {FRAC_CONST(0.471058489601483), FRAC_CONST(0.882101977876918)}, {FRAC_CONST(0.468350021981877), FRAC_CONST(0.883543013615962)},
    {FRAC_CONST(0.465637146073494), FRAC_CONST(0.884975733111667)}, {FRAC_CONST(0.462919887410955), FRAC_CONST(0.886400122878730)}, {FRAC_CONST(0.460198271570134), FRAC_CONST(0.887816169510255)},
    {FRAC_CONST(0.457472324167916), FRAC_CONST(0.889223859677868)}, {FRAC_CONST(0.454742070861955), FRAC_CONST(0.890623180131856)}, {FRAC_CONST(0.452007537350437), FRAC_CONST(0.892014117701280)},
    {FRAC_CONST(0.449268749371830), FRAC_CONST(0.893396659294108)}, {FRAC_CONST(0.446525732704651), FRAC_CONST(0.894770791897330)}, {FRAC_CONST(0.443778513167218), FRAC_CONST(0.896136502577087)},
    {FRAC_CONST(0.441027116617407), FRAC_CONST(0.897493778478790)}, {FRAC_CONST(0.438271568952410), FRAC_CONST(0.898842606827242)}, {FRAC_CONST(0.435511896108492), FRAC_CONST(0.900182974926757)},
    {FRAC_CONST(0.432748124060744), FRAC_CONST(0.901514870161279)}, {FRAC_CONST(0.429980278822841), FRAC_CONST(0.902838279994503)}, {FRAC_CONST(0.427208386446796), FRAC_CONST(0.904153191969992)},
    {FRAC_CONST(0.424432473022717), FRAC_CONST(0.905459593711293)}, {FRAC_CONST(0.421652564678558), FRAC_CONST(0.906757472922057)}, {FRAC_CONST(0.418868687579875), FRAC_CONST(0.908046817386148)},
    {FRAC_CONST(0.416080867929579), FRAC_CONST(0.909327614967767)}, {FRAC_CONST(0.413289131967691), FRAC_CONST(0.910599853611559)}, {FRAC_CONST(0.410493505971093), FRAC_CONST(0.911863521342729)},
    {FRAC_CONST(0.407694016253280), FRAC_CONST(0.913118606267154)}, {FRAC_CONST(0.404890689164118), FRAC_CONST(0.914365096571498)}, {FRAC_CONST(0.402083551089587), FRAC_CONST(0.915602980523320)},
    {FRAC_CONST(0.399272628451541), FRAC_CONST(0.916832246471184)}, {FRAC_CONST(0.396457947707454), FRAC_CONST(0.918052882844770)}, {FRAC_CONST(0.393639535350173), FRAC_CONST(0.919264878154985)},
    {FRAC_CONST(0.390817417907669), FRAC_CONST(0.920468220994067)}, {FRAC_CONST(0.387991621942785), FRAC_CONST(0.921662900035695)}, {FRAC_CONST(0.385162174052990), FRAC_CONST(0.922848904035094)},
    {FRAC_CONST(0.382329100870125), FRAC_CONST(0.924026221829144)}, {FRAC_CONST(0.379492429060153), FRAC_CONST(0.925194842336480)}, {FRAC_CONST(0.376652185322910), FRAC_CONST(0.926354754557603)},
    {FRAC_CONST(0.373808396391851), FRAC_CONST(0.927505947574975)}, {FRAC_CONST(0.370961089033802), FRAC_CONST(0.928648410553131)}, {FRAC_CONST(0.368110290048703), FRAC_CONST(0.929782132738772)},
    {FRAC_CONST(0.365256026269360), FRAC_CONST(0.930907103460875)}, {FRAC_CONST(0.362398324561191), FRAC_CONST(0.932023312130786)}, {FRAC_CONST(0.359537211821973), FRAC_CONST(0.933130748242325)},
    {FRAC_CONST(0.356672714981588), FRAC_CONST(0.934229401371881)}, {FRAC_CONST(0.353804861001772), FRAC_CONST(0.935319261178512)}, {FRAC_CONST(0.350933676875858), FRAC_CONST(0.936400317404042)},
    {FRAC_CONST(0.348059189628526), FRAC_CONST(0.937472559873159)}, {FRAC_CONST(0.345181426315543), FRAC_CONST(0.938535978493509)}, {FRAC_CONST(0.342300414023514), FRAC_CONST(0.939590563255789)},
    {FRAC_CONST(0.339416179869623), FRAC_CONST(0.940636304233848)}, {FRAC_CONST(0.336528751001382), FRAC_CONST(0.941673191584771)}, {FRAC_CONST(0.333638154596371), FRAC_CONST(0.942701215548982)},
    {FRAC_CONST(0.330744417861983), FRAC_CONST(0.943720366450326)}, {FRAC_CONST(0.327847568035171), FRAC_CONST(0.944730634696168)}, {FRAC_CONST(0.324947632382188), FRAC_CONST(0.945732010777477)},
    {FRAC_CONST(0.322044638198335), FRAC_CONST(0.946724485268921)}, {FRAC_CONST(0.319138612807696), FRAC_CONST(0.947708048828952)}, {FRAC_CONST(0.316229583562890), FRAC_CONST(0.948682692199895)},
    {FRAC_CONST(0.313317577844809), FRAC_CONST(0.949648406208035)}, {FRAC_CONST(0.310402623062359), FRAC_CONST(0.950605181763705)}, {FRAC_CONST(0.307484746652204), FRAC_CONST(0.951553009861369)},
    {FRAC_CONST(0.304563976078509), FRAC_CONST(0.952491881579706)}, {FRAC_CONST(0.301640338832679), FRAC_CONST(0.953421788081700)}, {FRAC_CONST(0.298713862433100), FRAC_CONST(0.954342720614716)},
    {FRAC_CONST(0.295784574424884), FRAC_CONST(0.955254670510587)}, {FRAC_CONST(0.292852502379605), FRAC_CONST(0.956157629185692)}, {FRAC_CONST(0.289917673895041), FRAC_CONST(0.957051588141041)},
    {FRAC_CONST(0.286980116594916), FRAC_CONST(0.957936538962351)}, {FRAC_CONST(0.284039858128637), FRAC_CONST(0.958812473320129)}, {FRAC_CONST(0.281096926171038), FRAC_CONST(0.959679382969747)},
    {FRAC_CONST(0.278151348422115), FRAC_CONST(0.960537259751520)}, {FRAC_CONST(0.275203152606767), FRAC_CONST(0.961386095590786)}, {FRAC_CONST(0.272252366474537), FRAC_CONST(0.962225882497979)},
    {FRAC_CONST(0.269299017799346), FRAC_CONST(0.963056612568704)}, {FRAC_CONST(0.266343134379238), FRAC_CONST(0.963878277983814)}, {FRAC_CONST(0.263384744036113), FRAC_CONST(0.964690871009481)},
    {FRAC_CONST(0.260423874615468), FRAC_CONST(0.965494383997270)}, {FRAC_CONST(0.257460553986133), FRAC_CONST(0.966288809384210)}, {FRAC_CONST(0.254494810040011), FRAC_CONST(0.967074139692867)},
    {FRAC_CONST(0.251526670691813), FRAC_CONST(0.967850367531414)}, {FRAC_CONST(0.248556163878797), FRAC_CONST(0.968617485593698)}, {FRAC_CONST(0.245583317560504), FRAC_CONST(0.969375486659311)},
    {FRAC_CONST(0.242608159718497), FRAC_CONST(0.970124363593660)}, {FRAC_CONST(0.239630718356094), FRAC_CONST(0.970864109348029)}, {FRAC_CONST(0.236651021498106), FRAC_CONST(0.971594716959650)},
    {FRAC_CONST(0.233669097190577), FRAC_CONST(0.972316179551765)}, {FRAC_CONST(0.230684973500512), FRAC_CONST(0.973028490333694)}, {FRAC_CONST(0.227698678515621), FRAC_CONST(0.973731642600896)},
    {FRAC_CONST(0.224710240344050), FRAC_CONST(0.974425629735035)}, {FRAC_CONST(0.221719687114115), FRAC_CONST(0.975110445204039)}, {FRAC_CONST(0.218727046974045), FRAC_CONST(0.975786082562164)},
    {FRAC_CONST(0.215732348091706), FRAC_CONST(0.976452535450054)}, {FRAC_CONST(0.212735618654346), FRAC_CONST(0.977109797594801)}, {FRAC_CONST(0.209736886868323), FRAC_CONST(0.977757862810003)},
    {FRAC_CONST(0.206736180958844), FRAC_CONST(0.978396724995823)}, {FRAC_CONST(0.203733529169694), FRAC_CONST(0.979026378139048)}, {FRAC_CONST(0.200728959762976), FRAC_CONST(0.979646816313141)},
    {FRAC_CONST(0.197722501018842), FRAC_CONST(0.980258033678304)}, {FRAC_CONST(0.194714181235226), FRAC_CONST(0.980860024481524)}, {FRAC_CONST(0.191704028727580), FRAC_CONST(0.981452783056636)},
    {FRAC_CONST(0.188692071828605), FRAC_CONST(0.982036303824369)}, {FRAC_CONST(0.185678338887988), FRAC_CONST(0.982610581292405)}, {FRAC_CONST(0.182662858272129), FRAC_CONST(0.983175610055424)},
    {FRAC_CONST(0.179645658363882), FRAC_CONST(0.983731384795162)}, {FRAC_CONST(0.176626767562281), FRAC_CONST(0.984277900280454)}, {FRAC_CONST(0.173606214282275), FRAC_CONST(0.984815151367289)},
    {FRAC_CONST(0.170584026954464), FRAC_CONST(0.985343132998855)}, {FRAC_CONST(0.167560234024824), FRAC_CONST(0.985861840205587)}, {FRAC_CONST(0.164534863954446), FRAC_CONST(0.986371268105216)},
    {FRAC_CONST(0.161507945219266), FRAC_CONST(0.986871411902812)}, {FRAC_CONST(0.158479506309796), FRAC_CONST(0.987362266890832)}, {FRAC_CONST(0.155449575730856), FRAC_CONST(0.987843828449162)},
    {FRAC_CONST(0.152418182001307), FRAC_CONST(0.988316092045160)}, {FRAC_CONST(0.149385353653780), FRAC_CONST(0.988779053233702)}, {FRAC_CONST(0.146351119234411), FRAC_CONST(0.989232707657220)},
    {FRAC_CONST(0.143315507302572), FRAC_CONST(0.989677051045747)}, {FRAC_CONST(0.140278546430595), FRAC_CONST(0.990112079216954)}, {FRAC_CONST(0.137240265203516), FRAC_CONST(0.990537788076189)},
    {FRAC_CONST(0.134200692218792), FRAC_CONST(0.990954173616519)}, {FRAC_CONST(0.131159856086043), FRAC_CONST(0.991361231918763)}, {FRAC_CONST(0.128117785426777), FRAC_CONST(0.991758959151536)},
    {FRAC_CONST(0.125074508874121), FRAC_CONST(0.992147351571276)}, {FRAC_CONST(0.122030055072553), FRAC_CONST(0.992526405522286)}, {FRAC_CONST(0.118984452677633), FRAC_CONST(0.992896117436766)},
    {FRAC_CONST(0.115937730355728), FRAC_CONST(0.993256483834846)}, {FRAC_CONST(0.112889916783750), FRAC_CONST(0.993607501324622)}, {FRAC_CONST(0.109841040648883), FRAC_CONST(0.993949166602181)},
    {FRAC_CONST(0.106791130648307), FRAC_CONST(0.994281476451642)}, {FRAC_CONST(0.103740215488939), FRAC_CONST(0.994604427745176)}, {FRAC_CONST(0.100688323887154), FRAC_CONST(0.994918017443043)},
    {FRAC_CONST(0.097635484568517), FRAC_CONST(0.995222242593618)}, {FRAC_CONST(0.094581726267515), FRAC_CONST(0.995517100333418)}, {FRAC_CONST(0.091527077727285), FRAC_CONST(0.995802587887129)},
    {FRAC_CONST(0.088471567699341), FRAC_CONST(0.996078702567634)}, {FRAC_CONST(0.085415224943307), FRAC_CONST(0.996345441776036)}, {FRAC_CONST(0.082358078226647), FRAC_CONST(0.996602803001684)},
    {FRAC_CONST(0.079300156324388), FRAC_CONST(0.996850783822197)}, {FRAC_CONST(0.076241488018856), FRAC_CONST(0.997089381903483)}, {FRAC_CONST(0.073182102099403), FRAC_CONST(0.997318594999769)},
    {FRAC_CONST(0.070122027362134), FRAC_CONST(0.997538420953611)}, {FRAC_CONST(0.067061292609637), FRAC_CONST(0.997748857695926)}, {FRAC_CONST(0.063999926650714), FRAC_CONST(0.997949903246001)},
    {FRAC_CONST(0.060937958300107), FRAC_CONST(0.998141555711521)}, {FRAC_CONST(0.057875416378229), FRAC_CONST(0.998323813288578)}, {FRAC_CONST(0.054812329710890), FRAC_CONST(0.998496674261695)},
    {FRAC_CONST(0.051748727129028), FRAC_CONST(0.998660137003838)}, {FRAC_CONST(0.048684637468439), FRAC_CONST(0.998814199976435)}, {FRAC_CONST(0.045620089569500), FRAC_CONST(0.998958861729386)},
    {FRAC_CONST(0.042555112276904), FRAC_CONST(0.999094120901079)}, {FRAC_CONST(0.039489734439384), FRAC_CONST(0.999219976218404)}, {FRAC_CONST(0.036423984909444), FRAC_CONST(0.999336426496761)},
    {FRAC_CONST(0.033357892543086), FRAC_CONST(0.999443470640078)}, {FRAC_CONST(0.030291486199539), FRAC_CONST(0.999541107640813)}, {FRAC_CONST(0.027224794740988), FRAC_CONST(0.999629336579970)},
    {FRAC_CONST(0.024157847032300), FRAC_CONST(0.999708156627105)}, {FRAC_CONST(0.021090671940755), FRAC_CONST(0.999777567040333)}, {FRAC_CONST(0.018023298335774), FRAC_CONST(0.999837567166337)},
    {FRAC_CONST(0.014955755088644), FRAC_CONST(0.999888156440373)}, {FRAC_CONST(0.011888071072252), FRAC_CONST(0.999929334386276)}, {FRAC_CONST(0.008820275160808), FRAC_CONST(0.999961100616463)},
    {FRAC_CONST(0.005752396229574), FRAC_CONST(0.999983454831938)}, {FRAC_CONST(0.002684463154596), FRAC_CONST(0.999996396822294)}};
/* 64 (N/4) complex twiddle factors */
static const complex_t mdct_tab_256[] = {
    {FRAC_CONST(0.999995293809576), FRAC_CONST(0.003067956762966)}, {FRAC_CONST(0.999618822495179), FRAC_CONST(0.027608145778966)}, {FRAC_CONST(0.998640218180265), FRAC_CONST(0.052131704680283)},
    {FRAC_CONST(0.997060070339483), FRAC_CONST(0.076623861392031)}, {FRAC_CONST(0.994879330794806), FRAC_CONST(0.101069862754828)}, {FRAC_CONST(0.992099313142192), FRAC_CONST(0.125454983411546)},
    {FRAC_CONST(0.988721691960324), FRAC_CONST(0.149764534677322)}, {FRAC_CONST(0.984748501801904), FRAC_CONST(0.173983873387464)}, {FRAC_CONST(0.980182135968117), FRAC_CONST(0.198098410717954)},
    {FRAC_CONST(0.975025345066994), FRAC_CONST(0.222093620973204)}, {FRAC_CONST(0.969281235356549), FRAC_CONST(0.245955050335795)}, {FRAC_CONST(0.962953266873684), FRAC_CONST(0.269668325572915)},
    {FRAC_CONST(0.956045251349996), FRAC_CONST(0.293219162694259)}, {FRAC_CONST(0.948561349915730), FRAC_CONST(0.316593375556166)}, {FRAC_CONST(0.940506070593268), FRAC_CONST(0.339776884406827)},
    {FRAC_CONST(0.931884265581668), FRAC_CONST(0.362755724367397)}, {FRAC_CONST(0.922701128333879), FRAC_CONST(0.385516053843919)}, {FRAC_CONST(0.912962190428398), FRAC_CONST(0.408044162864979)},
    {FRAC_CONST(0.902673318237259), FRAC_CONST(0.430326481340083)}, {FRAC_CONST(0.891840709392343), FRAC_CONST(0.452349587233771)}, {FRAC_CONST(0.880470889052161), FRAC_CONST(0.474100214650550)},
    {FRAC_CONST(0.868570705971341), FRAC_CONST(0.495565261825773)}, {FRAC_CONST(0.856147328375194), FRAC_CONST(0.516731799017650)}, {FRAC_CONST(0.843208239641845), FRAC_CONST(0.537587076295645)},
    {FRAC_CONST(0.829761233794523), FRAC_CONST(0.558118531220556)}, {FRAC_CONST(0.815814410806734), FRAC_CONST(0.578313796411656)}, {FRAC_CONST(0.801376171723140), FRAC_CONST(0.598160706996342)},
    {FRAC_CONST(0.786455213599086), FRAC_CONST(0.617647307937804)}, {FRAC_CONST(0.771060524261814), FRAC_CONST(0.636761861236284)}, {FRAC_CONST(0.755201376896537), FRAC_CONST(0.655492852999615)},
    {FRAC_CONST(0.738887324460615), FRAC_CONST(0.673829000378756)}, {FRAC_CONST(0.722128193929215), FRAC_CONST(0.691759258364158)}, {FRAC_CONST(0.704934080375905), FRAC_CONST(0.709272826438866)},
    {FRAC_CONST(0.687315340891759), FRAC_CONST(0.726359155084346)}, {FRAC_CONST(0.669282588346636), FRAC_CONST(0.743007952135122)}, {FRAC_CONST(0.650846684996381), FRAC_CONST(0.759209188978388)},
    {FRAC_CONST(0.632018735939809), FRAC_CONST(0.774953106594874)}, {FRAC_CONST(0.612810082429410), FRAC_CONST(0.790230221437310)}, {FRAC_CONST(0.593232295039800), FRAC_CONST(0.805031331142964)},
    {FRAC_CONST(0.573297166698042), FRAC_CONST(0.819347520076797)}, {FRAC_CONST(0.553016705580028), FRAC_CONST(0.833170164701913)}, {FRAC_CONST(0.532403127877198), FRAC_CONST(0.846490938774052)},
    {FRAC_CONST(0.511468850437971), FRAC_CONST(0.859301818357008)}, {FRAC_CONST(0.490226483288291), FRAC_CONST(0.871595086655951)}, {FRAC_CONST(0.468688822035828), FRAC_CONST(0.883363338665732)},
    {FRAC_CONST(0.446868840162374), FRAC_CONST(0.894599485631383)}, {FRAC_CONST(0.424779681209109), FRAC_CONST(0.905296759318119)}, {FRAC_CONST(0.402434650859419), FRAC_CONST(0.915448716088268)},
    {FRAC_CONST(0.379847208924051), FRAC_CONST(0.925049240782678)}, {FRAC_CONST(0.357030961233430), FRAC_CONST(0.934092550404259)}, {FRAC_CONST(0.333999651442009), FRAC_CONST(0.942573197601447)},
    {FRAC_CONST(0.310767152749611), FRAC_CONST(0.950486073949482)}, {FRAC_CONST(0.287347459544730), FRAC_CONST(0.957826413027533)}, {FRAC_CONST(0.263754678974832), FRAC_CONST(0.964589793289813)},
    {FRAC_CONST(0.240003022448742), FRAC_CONST(0.970772140728950)}, {FRAC_CONST(0.216106797076220), FRAC_CONST(0.976369731330021)}, {FRAC_CONST(0.192080397049892), FRAC_CONST(0.981379193313755)},
    {FRAC_CONST(0.167938294974731), FRAC_CONST(0.985797509167567)}, {FRAC_CONST(0.143695033150295), FRAC_CONST(0.989622017463201)}, {FRAC_CONST(0.119365214810991), FRAC_CONST(0.992850414459865)},
    {FRAC_CONST(0.094963495329639), FRAC_CONST(0.995480755491927)}, {FRAC_CONST(0.070504573389614), FRAC_CONST(0.997511456140303)}, {FRAC_CONST(0.046003182130915), FRAC_CONST(0.998941293186857)},
    {FRAC_CONST(0.021474080275470), FRAC_CONST(0.999769405351215)}};
    #ifdef LD_DEC
/* 256 (N/4) complex twiddle factors */
static const complex_t mdct_tab_1024[] = {
    {FRAC_CONST(0.999999705862882), FRAC_CONST(0.000766990318743)}, {FRAC_CONST(0.999976174986898), FRAC_CONST(0.006902858724730)}, {FRAC_CONST(0.999914995573113), FRAC_CONST(0.013038467241987)},
    {FRAC_CONST(0.999816169924900), FRAC_CONST(0.019173584868323)}, {FRAC_CONST(0.999679701762988), FRAC_CONST(0.025307980620025)}, {FRAC_CONST(0.999505596225325), FRAC_CONST(0.031441423540560)},
    {FRAC_CONST(0.999293859866888), FRAC_CONST(0.037573682709270)}, {FRAC_CONST(0.999044500659429), FRAC_CONST(0.043704527250063)}, {FRAC_CONST(0.998757527991183), FRAC_CONST(0.049833726340107)},
    {FRAC_CONST(0.998432952666508), FRAC_CONST(0.055961049218521)}, {FRAC_CONST(0.998070786905482), FRAC_CONST(0.062086265195060)}, {FRAC_CONST(0.997671044343441), FRAC_CONST(0.068209143658806)},
    {FRAC_CONST(0.997233740030466), FRAC_CONST(0.074329454086846)}, {FRAC_CONST(0.996758890430818), FRAC_CONST(0.080446966052950)}, {FRAC_CONST(0.996246513422316), FRAC_CONST(0.086561449236251)},
    {FRAC_CONST(0.995696628295664), FRAC_CONST(0.092672673429913)}, {FRAC_CONST(0.995109255753726), FRAC_CONST(0.098780408549800)}, {FRAC_CONST(0.994484417910748), FRAC_CONST(0.104884424643135)},
    {FRAC_CONST(0.993822138291520), FRAC_CONST(0.110984491897163)}, {FRAC_CONST(0.993122441830496), FRAC_CONST(0.117080380647801)}, {FRAC_CONST(0.992385354870852), FRAC_CONST(0.123171861388280)},
    {FRAC_CONST(0.991610905163495), FRAC_CONST(0.129258704777796)}, {FRAC_CONST(0.990799121866020), FRAC_CONST(0.135340681650134)}, {FRAC_CONST(0.989950035541609), FRAC_CONST(0.141417563022303)},
    {FRAC_CONST(0.989063678157882), FRAC_CONST(0.147489120103154)}, {FRAC_CONST(0.988140083085693), FRAC_CONST(0.153555124301993)}, {FRAC_CONST(0.987179285097874), FRAC_CONST(0.159615347237193)},
    {FRAC_CONST(0.986181320367928), FRAC_CONST(0.165669560744784)}, {FRAC_CONST(0.985146226468662), FRAC_CONST(0.171717536887050)}, {FRAC_CONST(0.984074042370776), FRAC_CONST(0.177759047961107)},
    {FRAC_CONST(0.982964808441396), FRAC_CONST(0.183793866507478)}, {FRAC_CONST(0.981818566442553), FRAC_CONST(0.189821765318656)}, {FRAC_CONST(0.980635359529608), FRAC_CONST(0.195842517447658)},
    {FRAC_CONST(0.979415232249635), FRAC_CONST(0.201855896216568)}, {FRAC_CONST(0.978158230539735), FRAC_CONST(0.207861675225075)}, {FRAC_CONST(0.976864401725313), FRAC_CONST(0.213859628358994)},
    {FRAC_CONST(0.975533794518291), FRAC_CONST(0.219849529798779)}, {FRAC_CONST(0.974166459015280), FRAC_CONST(0.225831154028026)}, {FRAC_CONST(0.972762446695689), FRAC_CONST(0.231804275841965)},
    {FRAC_CONST(0.971321810419786), FRAC_CONST(0.237768670355934)}, {FRAC_CONST(0.969844604426715), FRAC_CONST(0.243724113013852)}, {FRAC_CONST(0.968330884332445), FRAC_CONST(0.249670379596669)},
    {FRAC_CONST(0.966780707127683), FRAC_CONST(0.255607246230807)}, {FRAC_CONST(0.965194131175725), FRAC_CONST(0.261534489396596)}, {FRAC_CONST(0.963571216210257), FRAC_CONST(0.267451885936678)},
    {FRAC_CONST(0.961912023333112), FRAC_CONST(0.273359213064419)}, {FRAC_CONST(0.960216615011963), FRAC_CONST(0.279256248372291)}, {FRAC_CONST(0.958485055077976), FRAC_CONST(0.285142769840249)},
    {FRAC_CONST(0.956717408723403), FRAC_CONST(0.291018555844085)}, {FRAC_CONST(0.954913742499131), FRAC_CONST(0.296883385163778)}, {FRAC_CONST(0.953074124312172), FRAC_CONST(0.302737036991819)},
    {FRAC_CONST(0.951198623423113), FRAC_CONST(0.308579290941525)}, {FRAC_CONST(0.949287310443502), FRAC_CONST(0.314409927055337)}, {FRAC_CONST(0.947340257333192), FRAC_CONST(0.320228725813100)},
    {FRAC_CONST(0.945357537397632), FRAC_CONST(0.326035468140330)}, {FRAC_CONST(0.943339225285108), FRAC_CONST(0.331829935416461)}, {FRAC_CONST(0.941285396983929), FRAC_CONST(0.337611909483075)},
    {FRAC_CONST(0.939196129819570), FRAC_CONST(0.343381172652115)}, {FRAC_CONST(0.937071502451759), FRAC_CONST(0.349137507714085)}, {FRAC_CONST(0.934911594871516), FRAC_CONST(0.354880697946223)},
    {FRAC_CONST(0.932716488398140), FRAC_CONST(0.360610527120662)}, {FRAC_CONST(0.930486265676150), FRAC_CONST(0.366326779512574)}, {FRAC_CONST(0.928221010672169), FRAC_CONST(0.372029239908285)},
    {FRAC_CONST(0.925920808671770), FRAC_CONST(0.377717693613386)}, {FRAC_CONST(0.923585746276257), FRAC_CONST(0.383391926460809)}, {FRAC_CONST(0.921215911399409), FRAC_CONST(0.389051724818894)},
    {FRAC_CONST(0.918811393264170), FRAC_CONST(0.394696875599434)}, {FRAC_CONST(0.916372282399289), FRAC_CONST(0.400327166265690)}, {FRAC_CONST(0.913898670635912), FRAC_CONST(0.405942384840403)},
    {FRAC_CONST(0.911390651104122), FRAC_CONST(0.411542319913765)}, {FRAC_CONST(0.908848318229439), FRAC_CONST(0.417126760651388)}, {FRAC_CONST(0.906271767729258), FRAC_CONST(0.422695496802233)},
    {FRAC_CONST(0.903661096609248), FRAC_CONST(0.428248318706532)}, {FRAC_CONST(0.901016403159702), FRAC_CONST(0.433785017303679)}, {FRAC_CONST(0.898337786951834), FRAC_CONST(0.439305384140100)},
    {FRAC_CONST(0.895625348834030), FRAC_CONST(0.444809211377105)}, {FRAC_CONST(0.892879190928052), FRAC_CONST(0.450296291798709)}, {FRAC_CONST(0.890099416625192), FRAC_CONST(0.455766418819435)},
    {FRAC_CONST(0.887286130582383), FRAC_CONST(0.461219386492092)}, {FRAC_CONST(0.884439438718254), FRAC_CONST(0.466654989515531)}, {FRAC_CONST(0.881559448209144), FRAC_CONST(0.472073023242369)},
    {FRAC_CONST(0.878646267485068), FRAC_CONST(0.477473283686698)}, {FRAC_CONST(0.875700006225635), FRAC_CONST(0.482855567531766)}, {FRAC_CONST(0.872720775355914), FRAC_CONST(0.488219672137627)},
    {FRAC_CONST(0.869708687042266), FRAC_CONST(0.493565395548775)}, {FRAC_CONST(0.866663854688111), FRAC_CONST(0.498892536501745)}, {FRAC_CONST(0.863586392929668), FRAC_CONST(0.504200894432690)},
    {FRAC_CONST(0.860476417631632), FRAC_CONST(0.509490269484936)}, {FRAC_CONST(0.857334045882816), FRAC_CONST(0.514760462516501)}, {FRAC_CONST(0.854159395991739), FRAC_CONST(0.520011275107596)},
    {FRAC_CONST(0.850952587482176), FRAC_CONST(0.525242509568095)}, {FRAC_CONST(0.847713741088654), FRAC_CONST(0.530453968944976)}, {FRAC_CONST(0.844442978751911), FRAC_CONST(0.535645457029741)},
    {FRAC_CONST(0.841140423614298), FRAC_CONST(0.540816778365797)}, {FRAC_CONST(0.837806200015151), FRAC_CONST(0.545967738255818)}, {FRAC_CONST(0.834440433486103), FRAC_CONST(0.551098142769075)},
    {FRAC_CONST(0.831043250746362), FRAC_CONST(0.556207798748740)}, {FRAC_CONST(0.827614779697938), FRAC_CONST(0.561296513819151)}, {FRAC_CONST(0.824155149420829), FRAC_CONST(0.566364096393064)},
    {FRAC_CONST(0.820664490168157), FRAC_CONST(0.571410355678857)}, {FRAC_CONST(0.817142933361273), FRAC_CONST(0.576435101687722)}, {FRAC_CONST(0.813590611584799), FRAC_CONST(0.581438145240810)},
    {FRAC_CONST(0.810007658581641), FRAC_CONST(0.586419297976361)}, {FRAC_CONST(0.806394209247956), FRAC_CONST(0.591378372356788)}, {FRAC_CONST(0.802750399628069), FRAC_CONST(0.596315181675744)},
    {FRAC_CONST(0.799076366909352), FRAC_CONST(0.601229540065149)}, {FRAC_CONST(0.795372249417061), FRAC_CONST(0.606121262502186)}, {FRAC_CONST(0.791638186609126), FRAC_CONST(0.610990164816272)},
    {FRAC_CONST(0.787874319070900), FRAC_CONST(0.615836063695985)}, {FRAC_CONST(0.784080788509870), FRAC_CONST(0.620658776695972)}, {FRAC_CONST(0.780257737750317), FRAC_CONST(0.625458122243814)},
    {FRAC_CONST(0.776405310727940), FRAC_CONST(0.630233919646864)}, {FRAC_CONST(0.772523652484441), FRAC_CONST(0.634985989099049)}, {FRAC_CONST(0.768612909162058), FRAC_CONST(0.639714151687640)},
    {FRAC_CONST(0.764673227998067), FRAC_CONST(0.644418229399988)}, {FRAC_CONST(0.760704757319237), FRAC_CONST(0.649098045130226)}, {FRAC_CONST(0.756707646536246), FRAC_CONST(0.653753422685936)},
    {FRAC_CONST(0.752682046138055), FRAC_CONST(0.658384186794785)}, {FRAC_CONST(0.748628107686245), FRAC_CONST(0.662990163111121)}, {FRAC_CONST(0.744545983809307), FRAC_CONST(0.667571178222540)},
    {FRAC_CONST(0.740435828196898), FRAC_CONST(0.672127059656412)}, {FRAC_CONST(0.736297795594053), FRAC_CONST(0.676657635886375)}, {FRAC_CONST(0.732132041795361), FRAC_CONST(0.681162736338795)},
    {FRAC_CONST(0.727938723639099), FRAC_CONST(0.685642191399187)}, {FRAC_CONST(0.723717999001324), FRAC_CONST(0.690095832418600)}, {FRAC_CONST(0.719470026789933), FRAC_CONST(0.694523491719966)},
    {FRAC_CONST(0.715194966938680), FRAC_CONST(0.698925002604414)}, {FRAC_CONST(0.710892980401152), FRAC_CONST(0.703300199357549)}, {FRAC_CONST(0.706564229144710), FRAC_CONST(0.707648917255684)},
    {FRAC_CONST(0.702208876144392), FRAC_CONST(0.711970992572050)}, {FRAC_CONST(0.697827085376777), FRAC_CONST(0.716266262582953)}, {FRAC_CONST(0.693419021813812), FRAC_CONST(0.720534565573905)},
    {FRAC_CONST(0.688984851416597), FRAC_CONST(0.724775740845711)}, {FRAC_CONST(0.684524741129142), FRAC_CONST(0.728989628720519)}, {FRAC_CONST(0.680038858872079), FRAC_CONST(0.733176070547833)},
    {FRAC_CONST(0.675527373536339), FRAC_CONST(0.737334908710483)}, {FRAC_CONST(0.670990454976794), FRAC_CONST(0.741465986630563)}, {FRAC_CONST(0.666428274005865), FRAC_CONST(0.745569148775325)},
    {FRAC_CONST(0.661841002387087), FRAC_CONST(0.749644240663033)}, {FRAC_CONST(0.657228812828643), FRAC_CONST(0.753691108868781)}, {FRAC_CONST(0.652591878976863), FRAC_CONST(0.757709601030268)},
    {FRAC_CONST(0.647930375409685), FRAC_CONST(0.761699565853535)}, {FRAC_CONST(0.643244477630086), FRAC_CONST(0.765660853118662)}, {FRAC_CONST(0.638534362059467), FRAC_CONST(0.769593313685423)},
    {FRAC_CONST(0.633800206031017), FRAC_CONST(0.773496799498899)}, {FRAC_CONST(0.629042187783036), FRAC_CONST(0.777371163595056)}, {FRAC_CONST(0.624260486452221), FRAC_CONST(0.781216260106276)},
    {FRAC_CONST(0.619455282066924), FRAC_CONST(0.785031944266848)}, {FRAC_CONST(0.614626755540375), FRAC_CONST(0.788818072418420)}, {FRAC_CONST(0.609775088663868), FRAC_CONST(0.792574502015408)},
    {FRAC_CONST(0.604900464099920), FRAC_CONST(0.796301091630359)}, {FRAC_CONST(0.600003065375389), FRAC_CONST(0.799997700959282)}, {FRAC_CONST(0.595083076874570), FRAC_CONST(0.803664190826924)},
    {FRAC_CONST(0.590140683832249), FRAC_CONST(0.807300423192014)}, {FRAC_CONST(0.585176072326730), FRAC_CONST(0.810906261152460)}, {FRAC_CONST(0.580189429272832), FRAC_CONST(0.814481568950499)},
    {FRAC_CONST(0.575180942414845), FRAC_CONST(0.818026211977813)}, {FRAC_CONST(0.570150800319470), FRAC_CONST(0.821540056780598)}, {FRAC_CONST(0.565099192368714), FRAC_CONST(0.825022971064580)},
    {FRAC_CONST(0.560026308752760), FRAC_CONST(0.828474823700007)}, {FRAC_CONST(0.554932340462810), FRAC_CONST(0.831895484726578)}, {FRAC_CONST(0.549817479283891), FRAC_CONST(0.835284825358337)},
    {FRAC_CONST(0.544681917787635), FRAC_CONST(0.838642717988527)}, {FRAC_CONST(0.539525849325029), FRAC_CONST(0.841969036194388)}, {FRAC_CONST(0.534349468019138), FRAC_CONST(0.845263654741918)},
    {FRAC_CONST(0.529152968757791), FRAC_CONST(0.848526449590593)}, {FRAC_CONST(0.523936547186249), FRAC_CONST(0.851757297898029)}, {FRAC_CONST(0.518700399699835), FRAC_CONST(0.854956078024615)},
    {FRAC_CONST(0.513444723436544), FRAC_CONST(0.858122669538086)}, {FRAC_CONST(0.508169716269615), FRAC_CONST(0.861256953218062)}, {FRAC_CONST(0.502875576800087), FRAC_CONST(0.864358811060534)},
    {FRAC_CONST(0.497562504349319), FRAC_CONST(0.867428126282307)}, {FRAC_CONST(0.492230698951486), FRAC_CONST(0.870464783325398)}, {FRAC_CONST(0.486880361346047), FRAC_CONST(0.873468667861385)},
    {FRAC_CONST(0.481511692970190), FRAC_CONST(0.876439666795714)}, {FRAC_CONST(0.476124895951244), FRAC_CONST(0.879377668271953)}, {FRAC_CONST(0.470720173099072), FRAC_CONST(0.882282561676009)},
    {FRAC_CONST(0.465297727898435), FRAC_CONST(0.885154237640285)}, {FRAC_CONST(0.459857764501330), FRAC_CONST(0.887992588047806)}, {FRAC_CONST(0.454400487719304), FRAC_CONST(0.890797506036281)},
    {FRAC_CONST(0.448926103015743), FRAC_CONST(0.893568886002136)}, {FRAC_CONST(0.443434816498138), FRAC_CONST(0.896306623604480)}, {FRAC_CONST(0.437926834910323), FRAC_CONST(0.899010615769039)},
    {FRAC_CONST(0.432402365624690), FRAC_CONST(0.901680760692038)}, {FRAC_CONST(0.426861616634386), FRAC_CONST(0.904316957844028)}, {FRAC_CONST(0.421304796545480), FRAC_CONST(0.906919107973678)},
    {FRAC_CONST(0.415732114569105), FRAC_CONST(0.909487113111505)}, {FRAC_CONST(0.410143780513590), FRAC_CONST(0.912020876573568)}, {FRAC_CONST(0.404540004776553), FRAC_CONST(0.914520302965104)},
    {FRAC_CONST(0.398920998336983), FRAC_CONST(0.916985298184123)}, {FRAC_CONST(0.393286972747297), FRAC_CONST(0.919415769424947)}, {FRAC_CONST(0.387638140125373), FRAC_CONST(0.921811625181708)},
    {FRAC_CONST(0.381974713146567), FRAC_CONST(0.924172775251791)}, {FRAC_CONST(0.376296905035705), FRAC_CONST(0.926499130739231)}, {FRAC_CONST(0.370604929559052), FRAC_CONST(0.928790604058057)},
    {FRAC_CONST(0.364899001016267), FRAC_CONST(0.931047108935595)}, {FRAC_CONST(0.359179334232337), FRAC_CONST(0.933268560415712)}, {FRAC_CONST(0.353446144549481), FRAC_CONST(0.935454874862015)},
    {FRAC_CONST(0.347699647819051), FRAC_CONST(0.937605969961000)}, {FRAC_CONST(0.341940060393402), FRAC_CONST(0.939721764725153)}, {FRAC_CONST(0.336167599117745), FRAC_CONST(0.941802179495998)},
    {FRAC_CONST(0.330382481321983), FRAC_CONST(0.943847135947093)}, {FRAC_CONST(0.324584924812532), FRAC_CONST(0.945856557086984)}, {FRAC_CONST(0.318775147864118), FRAC_CONST(0.947830367262101)},
    {FRAC_CONST(0.312953369211560), FRAC_CONST(0.949768492159607)}, {FRAC_CONST(0.307119808041533), FRAC_CONST(0.951670858810194)}, {FRAC_CONST(0.301274683984318), FRAC_CONST(0.953537395590833)},
    {FRAC_CONST(0.295418217105532), FRAC_CONST(0.955368032227470)}, {FRAC_CONST(0.289550627897843), FRAC_CONST(0.957162699797670)}, {FRAC_CONST(0.283672137272669), FRAC_CONST(0.958921330733213)},
    {FRAC_CONST(0.277782966551858), FRAC_CONST(0.960643858822638)}, {FRAC_CONST(0.271883337459360), FRAC_CONST(0.962330219213737)}, {FRAC_CONST(0.265973472112876), FRAC_CONST(0.963980348415994)},
    {FRAC_CONST(0.260053593015495), FRAC_CONST(0.965594184302977)}, {FRAC_CONST(0.254123923047321), FRAC_CONST(0.967171666114677)}, {FRAC_CONST(0.248184685457075), FRAC_CONST(0.968712734459795)},
    {FRAC_CONST(0.242236103853696), FRAC_CONST(0.970217331317979)}, {FRAC_CONST(0.236278402197920), FRAC_CONST(0.971685400042009)}, {FRAC_CONST(0.230311804793846), FRAC_CONST(0.973116885359925)},
    {FRAC_CONST(0.224336536280494), FRAC_CONST(0.974511733377116)}, {FRAC_CONST(0.218352821623346), FRAC_CONST(0.975869891578341)}, {FRAC_CONST(0.212360886105879), FRAC_CONST(0.977191308829712)},
    {FRAC_CONST(0.206360955321076), FRAC_CONST(0.978475935380617)}, {FRAC_CONST(0.200353255162940), FRAC_CONST(0.979723722865591)}, {FRAC_CONST(0.194338011817989), FRAC_CONST(0.980934624306142)},
    {FRAC_CONST(0.188315451756732), FRAC_CONST(0.982108594112514)}, {FRAC_CONST(0.182285801725153), FRAC_CONST(0.983245588085407)}, {FRAC_CONST(0.176249288736168), FRAC_CONST(0.984345563417642)},
    {FRAC_CONST(0.170206140061078), FRAC_CONST(0.985408478695768)}, {FRAC_CONST(0.164156583221016), FRAC_CONST(0.986434293901627)}, {FRAC_CONST(0.158100845978377), FRAC_CONST(0.987422970413855)},
    {FRAC_CONST(0.152039156328246), FRAC_CONST(0.988374471009341)}, {FRAC_CONST(0.145971742489812), FRAC_CONST(0.989288759864625)}, {FRAC_CONST(0.139898832897777), FRAC_CONST(0.990165802557248)},
    {FRAC_CONST(0.133820656193755), FRAC_CONST(0.991005566067049)}, {FRAC_CONST(0.127737441217662), FRAC_CONST(0.991808018777406)}, {FRAC_CONST(0.121649416999106), FRAC_CONST(0.992573130476429)},
    {FRAC_CONST(0.115556812748755), FRAC_CONST(0.993300872358093)}, {FRAC_CONST(0.109459857849718), FRAC_CONST(0.993991217023329)}, {FRAC_CONST(0.103358781848900), FRAC_CONST(0.994644138481051)},
    {FRAC_CONST(0.097253814448363), FRAC_CONST(0.995259612149133)}, {FRAC_CONST(0.091145185496681), FRAC_CONST(0.995837614855342)}, {FRAC_CONST(0.085033124980280), FRAC_CONST(0.996378124838200)},
    {FRAC_CONST(0.078917863014785), FRAC_CONST(0.996881121747814)}, {FRAC_CONST(0.072799629836352), FRAC_CONST(0.997346586646633)}, {FRAC_CONST(0.066678655793002), FRAC_CONST(0.997774502010168)},
    {FRAC_CONST(0.060555171335948), FRAC_CONST(0.998164851727646)}, {FRAC_CONST(0.054429407010919), FRAC_CONST(0.998517621102622)}, {FRAC_CONST(0.048301593449480), FRAC_CONST(0.998832796853528)},
    {FRAC_CONST(0.042171961360348), FRAC_CONST(0.999110367114175)}, {FRAC_CONST(0.036040741520706), FRAC_CONST(0.999350321434199)}, {FRAC_CONST(0.029908164767517), FRAC_CONST(0.999552650779457)},
    {FRAC_CONST(0.023774461988828), FRAC_CONST(0.999717347532362)}, {FRAC_CONST(0.017639864115082), FRAC_CONST(0.999844405492175)}, {FRAC_CONST(0.011504602110423), FRAC_CONST(0.999933819875236)},
    {FRAC_CONST(0.005368906963996), FRAC_CONST(0.999985587315143)}};
    #endif // LD_DEC
    #ifdef ALLOW_SMALL_FRAMELENGTH
/* 480 (N/4) complex twiddle factors */
static const complex_t mdct_tab_1920[] = {
    {FRAC_CONST(0.999999916334328), FRAC_CONST(0.000409061532028)}, {FRAC_CONST(0.999993223088129), FRAC_CONST(0.003681545574400)}, {FRAC_CONST(0.999975820717897), FRAC_CONST(0.006953990190376)},
    {FRAC_CONST(0.999947709409999), FRAC_CONST(0.010226360334704)}, {FRAC_CONST(0.999908889465485), FRAC_CONST(0.013498620962929)}, {FRAC_CONST(0.999859361300084), FRAC_CONST(0.016770737031768)},
    {FRAC_CONST(0.999799125444203), FRAC_CONST(0.020042673499487)}, {FRAC_CONST(0.999728182542920), FRAC_CONST(0.023314395326274)}, {FRAC_CONST(0.999646533355977), FRAC_CONST(0.026585867474619)},
    {FRAC_CONST(0.999554178757770), FRAC_CONST(0.029857054909681)}, {FRAC_CONST(0.999451119737344), FRAC_CONST(0.033127922599673)}, {FRAC_CONST(0.999337357398377), FRAC_CONST(0.036398435516228)},
    {FRAC_CONST(0.999212892959173), FRAC_CONST(0.039668558634781)}, {FRAC_CONST(0.999077727752645), FRAC_CONST(0.042938256934941)}, {FRAC_CONST(0.998931863226306), FRAC_CONST(0.046207495400865)},
    {FRAC_CONST(0.998775300942246), FRAC_CONST(0.049476239021636)}, {FRAC_CONST(0.998608042577122), FRAC_CONST(0.052744452791636)}, {FRAC_CONST(0.998430089922136), FRAC_CONST(0.056012101710921)},
    {FRAC_CONST(0.998241444883019), FRAC_CONST(0.059279150785597)}, {FRAC_CONST(0.998042109480008), FRAC_CONST(0.062545565028192)}, {FRAC_CONST(0.997832085847824), FRAC_CONST(0.065811309458034)},
    {FRAC_CONST(0.997611376235651), FRAC_CONST(0.069076349101624)}, {FRAC_CONST(0.997379983007114), FRAC_CONST(0.072340648993011)}, {FRAC_CONST(0.997137908640245), FRAC_CONST(0.075604174174166)},
    {FRAC_CONST(0.996885155727469), FRAC_CONST(0.078866889695354)}, {FRAC_CONST(0.996621726975566), FRAC_CONST(0.082128760615515)}, {FRAC_CONST(0.996347625205645), FRAC_CONST(0.085389752002632)},
    {FRAC_CONST(0.996062853353117), FRAC_CONST(0.088649828934106)}, {FRAC_CONST(0.995767414467660), FRAC_CONST(0.091908956497133)}, {FRAC_CONST(0.995461311713186), FRAC_CONST(0.095167099789075)},
    {FRAC_CONST(0.995144548367810), FRAC_CONST(0.098424223917834)}, {FRAC_CONST(0.994817127823813), FRAC_CONST(0.101680294002229)}, {FRAC_CONST(0.994479053587606), FRAC_CONST(0.104935275172364)},
    {FRAC_CONST(0.994130329279692), FRAC_CONST(0.108189132570007)}, {FRAC_CONST(0.993770958634630), FRAC_CONST(0.111441831348957)}, {FRAC_CONST(0.993400945500988), FRAC_CONST(0.114693336675426)},
    {FRAC_CONST(0.993020293841312), FRAC_CONST(0.117943613728403)}, {FRAC_CONST(0.992629007732074), FRAC_CONST(0.121192627700032)}, {FRAC_CONST(0.992227091363634), FRAC_CONST(0.124440343795983)},
    {FRAC_CONST(0.991814549040194), FRAC_CONST(0.127686727235827)}, {FRAC_CONST(0.991391385179751), FRAC_CONST(0.130931743253405)}, {FRAC_CONST(0.990957604314048), FRAC_CONST(0.134175357097202)},
    {FRAC_CONST(0.990513211088533), FRAC_CONST(0.137417534030720)}, {FRAC_CONST(0.990058210262297), FRAC_CONST(0.140658239332849)}, {FRAC_CONST(0.989592606708036), FRAC_CONST(0.143897438298239)},
    {FRAC_CONST(0.989116405411988), FRAC_CONST(0.147135096237670)}, {FRAC_CONST(0.988629611473887), FRAC_CONST(0.150371178478428)}, {FRAC_CONST(0.988132230106905), FRAC_CONST(0.153605650364672)},
    {FRAC_CONST(0.987624266637598), FRAC_CONST(0.156838477257806)}, {FRAC_CONST(0.987105726505845), FRAC_CONST(0.160069624536852)}, {FRAC_CONST(0.986576615264794), FRAC_CONST(0.163299057598817)},
    {FRAC_CONST(0.986036938580803), FRAC_CONST(0.166526741859069)}, {FRAC_CONST(0.985486702233375), FRAC_CONST(0.169752642751702)}, {FRAC_CONST(0.984925912115099), FRAC_CONST(0.172976725729910)},
    {FRAC_CONST(0.984354574231587), FRAC_CONST(0.176198956266353)}, {FRAC_CONST(0.983772694701407), FRAC_CONST(0.179419299853531)}, {FRAC_CONST(0.983180279756024), FRAC_CONST(0.182637722004152)},
    {FRAC_CONST(0.982577335739725), FRAC_CONST(0.185854188251500)}, {FRAC_CONST(0.981963869109555), FRAC_CONST(0.189068664149806)}, {FRAC_CONST(0.981339886435250), FRAC_CONST(0.192281115274616)},
    {FRAC_CONST(0.980705394399163), FRAC_CONST(0.195491507223158)}, {FRAC_CONST(0.980060399796194), FRAC_CONST(0.198699805614714)}, {FRAC_CONST(0.979404909533716), FRAC_CONST(0.201905976090986)},
    {FRAC_CONST(0.978738930631504), FRAC_CONST(0.205109984316464)}, {FRAC_CONST(0.978062470221657), FRAC_CONST(0.208311795978794)}, {FRAC_CONST(0.977375535548522), FRAC_CONST(0.211511376789145)},
    {FRAC_CONST(0.976678133968618), FRAC_CONST(0.214708692482577)}, {FRAC_CONST(0.975970272950556), FRAC_CONST(0.217903708818409)}, {FRAC_CONST(0.975251960074958), FRAC_CONST(0.221096391580581)},
    {FRAC_CONST(0.974523203034377), FRAC_CONST(0.224286706578026)}, {FRAC_CONST(0.973784009633218), FRAC_CONST(0.227474619645035)}, {FRAC_CONST(0.973034387787646), FRAC_CONST(0.230660096641619)},
    {FRAC_CONST(0.972274345525510), FRAC_CONST(0.233843103453878)}, {FRAC_CONST(0.971503890986252), FRAC_CONST(0.237023605994367)}, {FRAC_CONST(0.970723032420820), FRAC_CONST(0.240201570202459)},
    {FRAC_CONST(0.969931778191584), FRAC_CONST(0.243376962044711)}, {FRAC_CONST(0.969130136772239), FRAC_CONST(0.246549747515226)}, {FRAC_CONST(0.968318116747721), FRAC_CONST(0.249719892636022)},
    {FRAC_CONST(0.967495726814114), FRAC_CONST(0.252887363457390)}, {FRAC_CONST(0.966662975778551), FRAC_CONST(0.256052126058264)}, {FRAC_CONST(0.965819872559127), FRAC_CONST(0.259214146546579)},
    {FRAC_CONST(0.964966426184802), FRAC_CONST(0.262373391059634)}, {FRAC_CONST(0.964102645795299), FRAC_CONST(0.265529825764461)}, {FRAC_CONST(0.963228540641012), FRAC_CONST(0.268683416858178)},
    {FRAC_CONST(0.962344120082907), FRAC_CONST(0.271834130568359)}, {FRAC_CONST(0.961449393592416), FRAC_CONST(0.274981933153391)}, {FRAC_CONST(0.960544370751341), FRAC_CONST(0.278126790902837)},
    {FRAC_CONST(0.959629061251750), FRAC_CONST(0.281268670137799)}, {FRAC_CONST(0.958703474895872), FRAC_CONST(0.284407537211272)}, {FRAC_CONST(0.957767621595993), FRAC_CONST(0.287543358508512)},
    {FRAC_CONST(0.956821511374351), FRAC_CONST(0.290676100447394)}, {FRAC_CONST(0.955865154363025), FRAC_CONST(0.293805729478766)}, {FRAC_CONST(0.954898560803832), FRAC_CONST(0.296932212086818)},
    {FRAC_CONST(0.953921741048211), FRAC_CONST(0.300055514789431)}, {FRAC_CONST(0.952934705557117), FRAC_CONST(0.303175604138543)}, {FRAC_CONST(0.951937464900908), FRAC_CONST(0.306292446720504)},
    {FRAC_CONST(0.950930029759229), FRAC_CONST(0.309406009156434)}, {FRAC_CONST(0.949912410920903), FRAC_CONST(0.312516258102580)}, {FRAC_CONST(0.948884619283808), FRAC_CONST(0.315623160250676)},
    {FRAC_CONST(0.947846665854767), FRAC_CONST(0.318726682328294)}, {FRAC_CONST(0.946798561749429), FRAC_CONST(0.321826791099207)}, {FRAC_CONST(0.945740318192145), FRAC_CONST(0.324923453363742)},
    {FRAC_CONST(0.944671946515855), FRAC_CONST(0.328016635959131)}, {FRAC_CONST(0.943593458161960), FRAC_CONST(0.331106305759876)}, {FRAC_CONST(0.942504864680205), FRAC_CONST(0.334192429678095)},
    {FRAC_CONST(0.941406177728551), FRAC_CONST(0.337274974663880)}, {FRAC_CONST(0.940297409073052), FRAC_CONST(0.340353907705650)}, {FRAC_CONST(0.939178570587730), FRAC_CONST(0.343429195830507)},
    {FRAC_CONST(0.938049674254446), FRAC_CONST(0.346500806104585)}, {FRAC_CONST(0.936910732162774), FRAC_CONST(0.349568705633406)}, {FRAC_CONST(0.935761756509868), FRAC_CONST(0.352632861562230)},
    {FRAC_CONST(0.934602759600334), FRAC_CONST(0.355693241076410)}, {FRAC_CONST(0.933433753846097), FRAC_CONST(0.358749811401739)}, {FRAC_CONST(0.932254751766271), FRAC_CONST(0.361802539804806)},
    {FRAC_CONST(0.931065765987021), FRAC_CONST(0.364851393593340)}, {FRAC_CONST(0.929866809241428), FRAC_CONST(0.367896340116568)}, {FRAC_CONST(0.928657894369357), FRAC_CONST(0.370937346765559)},
    {FRAC_CONST(0.927439034317314), FRAC_CONST(0.373974380973575)}, {FRAC_CONST(0.926210242138311), FRAC_CONST(0.377007410216418)}, {FRAC_CONST(0.924971530991726), FRAC_CONST(0.380036402012783)},
    {FRAC_CONST(0.923722914143160), FRAC_CONST(0.383061323924602)}, {FRAC_CONST(0.922464404964295), FRAC_CONST(0.386082143557389)}, {FRAC_CONST(0.921196016932755), FRAC_CONST(0.389098828560595)},
    {FRAC_CONST(0.919917763631956), FRAC_CONST(0.392111346627946)}, {FRAC_CONST(0.918629658750963), FRAC_CONST(0.395119665497795)}, {FRAC_CONST(0.917331716084346), FRAC_CONST(0.398123752953462)},
    {FRAC_CONST(0.916023949532027), FRAC_CONST(0.401123576823585)}, {FRAC_CONST(0.914706373099136), FRAC_CONST(0.404119104982459)}, {FRAC_CONST(0.913379000895858), FRAC_CONST(0.407110305350386)},
    {FRAC_CONST(0.912041847137282), FRAC_CONST(0.410097145894012)}, {FRAC_CONST(0.910694926143251), FRAC_CONST(0.413079594626675)}, {FRAC_CONST(0.909338252338207), FRAC_CONST(0.416057619608744)},
    {FRAC_CONST(0.907971840251037), FRAC_CONST(0.419031188947965)}, {FRAC_CONST(0.906595704514915), FRAC_CONST(0.422000270799800)}, {FRAC_CONST(0.905209859867151), FRAC_CONST(0.424964833367766)},
    {FRAC_CONST(0.903814321149027), FRAC_CONST(0.427924844903780)}, {FRAC_CONST(0.902409103305641), FRAC_CONST(0.430880273708497)}, {FRAC_CONST(0.900994221385748), FRAC_CONST(0.433831088131649)},
    {FRAC_CONST(0.899569690541596), FRAC_CONST(0.436777256572384)}, {FRAC_CONST(0.898135526028766), FRAC_CONST(0.439718747479604)}, {FRAC_CONST(0.896691743206008), FRAC_CONST(0.442655529352306)},
    {FRAC_CONST(0.895238357535076), FRAC_CONST(0.445587570739915)}, {FRAC_CONST(0.893775384580563), FRAC_CONST(0.448514840242624)}, {FRAC_CONST(0.892302840009734), FRAC_CONST(0.451437306511726)},
    {FRAC_CONST(0.890820739592359), FRAC_CONST(0.454354938249958)}, {FRAC_CONST(0.889329099200541), FRAC_CONST(0.457267704211826)}, {FRAC_CONST(0.887827934808551), FRAC_CONST(0.460175573203949)},
    {FRAC_CONST(0.886317262492655), FRAC_CONST(0.463078514085383)}, {FRAC_CONST(0.884797098430938), FRAC_CONST(0.465976495767966)}, {FRAC_CONST(0.883267458903136), FRAC_CONST(0.468869487216642)},
    {FRAC_CONST(0.881728360290461), FRAC_CONST(0.471757457449795)}, {FRAC_CONST(0.880179819075421), FRAC_CONST(0.474640375539586)}, {FRAC_CONST(0.878621851841649), FRAC_CONST(0.477518210612278)},
    {FRAC_CONST(0.877054475273722), FRAC_CONST(0.480390931848569)}, {FRAC_CONST(0.875477706156984), FRAC_CONST(0.483258508483922)}, {FRAC_CONST(0.873891561377366), FRAC_CONST(0.486120909808896)},
    {FRAC_CONST(0.872296057921204), FRAC_CONST(0.488978105169472)}, {FRAC_CONST(0.870691212875058), FRAC_CONST(0.491830063967383)}, {FRAC_CONST(0.869077043425529), FRAC_CONST(0.494676755660442)},
    {FRAC_CONST(0.867453566859076), FRAC_CONST(0.497518149762867)}, {FRAC_CONST(0.865820800561827), FRAC_CONST(0.500354215845611)}, {FRAC_CONST(0.864178762019399), FRAC_CONST(0.503184923536685)},
    {FRAC_CONST(0.862527468816704), FRAC_CONST(0.506010242521482)}, {FRAC_CONST(0.860866938637767), FRAC_CONST(0.508830142543107)}, {FRAC_CONST(0.859197189265532), FRAC_CONST(0.511644593402696)},
    {FRAC_CONST(0.857518238581672), FRAC_CONST(0.514453564959741)}, {FRAC_CONST(0.855830104566401), FRAC_CONST(0.517257027132414)}, {FRAC_CONST(0.854132805298278), FRAC_CONST(0.520054949897887)},
    {FRAC_CONST(0.852426358954015), FRAC_CONST(0.522847303292655)}, {FRAC_CONST(0.850710783808280), FRAC_CONST(0.525634057412856)}, {FRAC_CONST(0.848986098233506), FRAC_CONST(0.528415182414593)},
    {FRAC_CONST(0.847252320699689), FRAC_CONST(0.531190648514252)}, {FRAC_CONST(0.845509469774194), FRAC_CONST(0.533960425988819)}, {FRAC_CONST(0.843757564121554), FRAC_CONST(0.536724485176205)},
    {FRAC_CONST(0.841996622503271), FRAC_CONST(0.539482796475555)}, {FRAC_CONST(0.840226663777615), FRAC_CONST(0.542235330347571)}, {FRAC_CONST(0.838447706899422), FRAC_CONST(0.544982057314827)},
    {FRAC_CONST(0.836659770919891), FRAC_CONST(0.547722947962084)}, {FRAC_CONST(0.834862874986380), FRAC_CONST(0.550457972936605)}, {FRAC_CONST(0.833057038342201), FRAC_CONST(0.553187102948470)},
    {FRAC_CONST(0.831242280326413), FRAC_CONST(0.555910308770889)}, {FRAC_CONST(0.829418620373617), FRAC_CONST(0.558627561240515)}, {FRAC_CONST(0.827586078013746), FRAC_CONST(0.561338831257758)},
    {FRAC_CONST(0.825744672871856), FRAC_CONST(0.564044089787093)}, {FRAC_CONST(0.823894424667918), FRAC_CONST(0.566743307857377)}, {FRAC_CONST(0.822035353216601), FRAC_CONST(0.569436456562150)},
    {FRAC_CONST(0.820167478427070), FRAC_CONST(0.572123507059955)}, {FRAC_CONST(0.818290820302761), FRAC_CONST(0.574804430574639)}, {FRAC_CONST(0.816405398941175), FRAC_CONST(0.577479198395666)},
    {FRAC_CONST(0.814511234533661), FRAC_CONST(0.580147781878420)}, {FRAC_CONST(0.812608347365198), FRAC_CONST(0.582810152444517)}, {FRAC_CONST(0.810696757814178), FRAC_CONST(0.585466281582107)},
    {FRAC_CONST(0.808776486352191), FRAC_CONST(0.588116140846181)}, {FRAC_CONST(0.806847553543799), FRAC_CONST(0.590759701858874)}, {FRAC_CONST(0.804909980046325), FRAC_CONST(0.593396936309773)},
    {FRAC_CONST(0.802963786609623), FRAC_CONST(0.596027815956215)}, {FRAC_CONST(0.801008994075862), FRAC_CONST(0.598652312623592)}, {FRAC_CONST(0.799045623379300), FRAC_CONST(0.601270398205654)},
    {FRAC_CONST(0.797073695546059), FRAC_CONST(0.603882044664808)}, {FRAC_CONST(0.795093231693901), FRAC_CONST(0.606487224032418)}, {FRAC_CONST(0.793104253032005), FRAC_CONST(0.609085908409106)},
    {FRAC_CONST(0.791106780860733), FRAC_CONST(0.611678069965050)}, {FRAC_CONST(0.789100836571407), FRAC_CONST(0.614263680940283)}, {FRAC_CONST(0.787086441646080), FRAC_CONST(0.616842713644988)},
    {FRAC_CONST(0.785063617657302), FRAC_CONST(0.619415140459796)}, {FRAC_CONST(0.783032386267894), FRAC_CONST(0.621980933836084)}, {FRAC_CONST(0.780992769230711), FRAC_CONST(0.624540066296266)},
    {FRAC_CONST(0.778944788388414), FRAC_CONST(0.627092510434089)}, {FRAC_CONST(0.776888465673232), FRAC_CONST(0.629638238914927)}, {FRAC_CONST(0.774823823106730), FRAC_CONST(0.632177224476073)},
    {FRAC_CONST(0.772750882799570), FRAC_CONST(0.634709439927031)}, {FRAC_CONST(0.770669666951277), FRAC_CONST(0.637234858149809)}, {FRAC_CONST(0.768580197850002), FRAC_CONST(0.639753452099206)},
    {FRAC_CONST(0.766482497872280), FRAC_CONST(0.642265194803105)}, {FRAC_CONST(0.764376589482793), FRAC_CONST(0.644770059362758)}, {FRAC_CONST(0.762262495234126), FRAC_CONST(0.647268018953079)},
    {FRAC_CONST(0.760140237766532), FRAC_CONST(0.649759046822928)}, {FRAC_CONST(0.758009839807683), FRAC_CONST(0.652243116295397)}, {FRAC_CONST(0.755871324172429), FRAC_CONST(0.654720200768098)},
    {FRAC_CONST(0.753724713762555), FRAC_CONST(0.657190273713446)}, {FRAC_CONST(0.751570031566534), FRAC_CONST(0.659653308678945)}, {FRAC_CONST(0.749407300659280), FRAC_CONST(0.662109279287469)},
    {FRAC_CONST(0.747236544201905), FRAC_CONST(0.664558159237545)}, {FRAC_CONST(0.745057785441466), FRAC_CONST(0.666999922303638)}, {FRAC_CONST(0.742871047710719), FRAC_CONST(0.669434542336425)},
    {FRAC_CONST(0.740676354427868), FRAC_CONST(0.671861993263083)}, {FRAC_CONST(0.738473729096316), FRAC_CONST(0.674282249087562)}, {FRAC_CONST(0.736263195304409), FRAC_CONST(0.676695283890867)},
    {FRAC_CONST(0.734044776725190), FRAC_CONST(0.679101071831334)}, {FRAC_CONST(0.731818497116138), FRAC_CONST(0.681499587144906)}, {FRAC_CONST(0.729584380318920), FRAC_CONST(0.683890804145412)},
    {FRAC_CONST(0.727342450259131), FRAC_CONST(0.686274697224838)}, {FRAC_CONST(0.725092730946042), FRAC_CONST(0.688651240853606)}, {FRAC_CONST(0.722835246472338), FRAC_CONST(0.691020409580841)},
    {FRAC_CONST(0.720570021013866), FRAC_CONST(0.693382178034651)}, {FRAC_CONST(0.718297078829369), FRAC_CONST(0.695736520922392)}, {FRAC_CONST(0.716016444260233), FRAC_CONST(0.698083413030944)},
    {FRAC_CONST(0.713728141730222), FRAC_CONST(0.700422829226978)}, {FRAC_CONST(0.711432195745216), FRAC_CONST(0.702754744457225)}, {FRAC_CONST(0.709128630892954), FRAC_CONST(0.705079133748748)},
    {FRAC_CONST(0.706817471842764), FRAC_CONST(0.707395972209203)}, {FRAC_CONST(0.704498743345302), FRAC_CONST(0.709705235027113)}, {FRAC_CONST(0.702172470232289), FRAC_CONST(0.712006897472128)},
    {FRAC_CONST(0.699838677416240), FRAC_CONST(0.714300934895292)}, {FRAC_CONST(0.697497389890200), FRAC_CONST(0.716587322729308)}, {FRAC_CONST(0.695148632727480), FRAC_CONST(0.718866036488799)},
    {FRAC_CONST(0.692792431081381), FRAC_CONST(0.721137051770570)}, {FRAC_CONST(0.690428810184929), FRAC_CONST(0.723400344253874)}, {FRAC_CONST(0.688057795350606), FRAC_CONST(0.725655889700665)},
    {FRAC_CONST(0.685679411970075), FRAC_CONST(0.727903663955865)}, {FRAC_CONST(0.683293685513912), FRAC_CONST(0.730143642947616)}, {FRAC_CONST(0.680900641531330), FRAC_CONST(0.732375802687543)},
    {FRAC_CONST(0.678500305649909), FRAC_CONST(0.734600119271009)}, {FRAC_CONST(0.676092703575316), FRAC_CONST(0.736816568877370)}, {FRAC_CONST(0.673677861091036), FRAC_CONST(0.739025127770231)},
    {FRAC_CONST(0.671255804058092), FRAC_CONST(0.741225772297702)}, {FRAC_CONST(0.668826558414768), FRAC_CONST(0.743418478892647)}, {FRAC_CONST(0.666390150176334), FRAC_CONST(0.745603224072940)},
    {FRAC_CONST(0.663946605434765), FRAC_CONST(0.747779984441716)}, {FRAC_CONST(0.661495950358462), FRAC_CONST(0.749948736687619)}, {FRAC_CONST(0.659038211191971), FRAC_CONST(0.752109457585056)},
    {FRAC_CONST(0.656573414255705), FRAC_CONST(0.754262123994441)}, {FRAC_CONST(0.654101585945659), FRAC_CONST(0.756406712862448)}, {FRAC_CONST(0.651622752733128), FRAC_CONST(0.758543201222251)},
    {FRAC_CONST(0.649136941164425), FRAC_CONST(0.760671566193777)}, {FRAC_CONST(0.646644177860593), FRAC_CONST(0.762791784983948)}, {FRAC_CONST(0.644144489517126), FRAC_CONST(0.764903834886923)},
    {FRAC_CONST(0.641637902903677), FRAC_CONST(0.767007693284345)}, {FRAC_CONST(0.639124444863776), FRAC_CONST(0.769103337645580)}, {FRAC_CONST(0.636604142314538), FRAC_CONST(0.771190745527961)},
    {FRAC_CONST(0.634077022246379), FRAC_CONST(0.773269894577026)}, {FRAC_CONST(0.631543111722725), FRAC_CONST(0.775340762526760)}, {FRAC_CONST(0.629002437879721), FRAC_CONST(0.777403327199831)},
    {FRAC_CONST(0.626455027925944), FRAC_CONST(0.779457566507828)}, {FRAC_CONST(0.623900909142107), FRAC_CONST(0.781503458451498)}, {FRAC_CONST(0.621340108880771), FRAC_CONST(0.783540981120982)},
    {FRAC_CONST(0.618772654566049), FRAC_CONST(0.785570112696050)}, {FRAC_CONST(0.616198573693314), FRAC_CONST(0.787590831446332)}, {FRAC_CONST(0.613617893828905), FRAC_CONST(0.789603115731555)},
    {FRAC_CONST(0.611030642609828), FRAC_CONST(0.791606944001769)}, {FRAC_CONST(0.608436847743468), FRAC_CONST(0.793602294797585)}, {FRAC_CONST(0.605836537007281), FRAC_CONST(0.795589146750397)},
    {FRAC_CONST(0.603229738248508), FRAC_CONST(0.797567478582619)}, {FRAC_CONST(0.600616479383869), FRAC_CONST(0.799537269107905)}, {FRAC_CONST(0.597996788399267), FRAC_CONST(0.801498497231381)},
    {FRAC_CONST(0.595370693349487), FRAC_CONST(0.803451141949871)}, {FRAC_CONST(0.592738222357898), FRAC_CONST(0.805395182352117)}, {FRAC_CONST(0.590099403616149), FRAC_CONST(0.807330597619008)},
    {FRAC_CONST(0.587454265383869), FRAC_CONST(0.809257367023803)}, {FRAC_CONST(0.584802835988364), FRAC_CONST(0.811175469932349)}, {FRAC_CONST(0.582145143824311), FRAC_CONST(0.813084885803304)},
    {FRAC_CONST(0.579481217353460), FRAC_CONST(0.814985594188359)}, {FRAC_CONST(0.576811085104321), FRAC_CONST(0.816877574732454)}, {FRAC_CONST(0.574134775671867), FRAC_CONST(0.818760807173997)},
    {FRAC_CONST(0.571452317717222), FRAC_CONST(0.820635271345081)}, {FRAC_CONST(0.568763739967354), FRAC_CONST(0.822500947171703)}, {FRAC_CONST(0.566069071214772), FRAC_CONST(0.824357814673971)},
    {FRAC_CONST(0.563368340317214), FRAC_CONST(0.826205853966327)}, {FRAC_CONST(0.560661576197336), FRAC_CONST(0.828045045257756)}, {FRAC_CONST(0.557948807842409), FRAC_CONST(0.829875368851995)},
    {FRAC_CONST(0.555230064304002), FRAC_CONST(0.831696805147750)}, {FRAC_CONST(0.552505374697674), FRAC_CONST(0.833509334638900)}, {FRAC_CONST(0.549774768202663), FRAC_CONST(0.835312937914713)},
    {FRAC_CONST(0.547038274061568), FRAC_CONST(0.837107595660044)}, {FRAC_CONST(0.544295921580046), FRAC_CONST(0.838893288655553)}, {FRAC_CONST(0.541547740126486), FRAC_CONST(0.840669997777901)},
    {FRAC_CONST(0.538793759131706), FRAC_CONST(0.842437703999961)}, {FRAC_CONST(0.536034008088628), FRAC_CONST(0.844196388391019)}, {FRAC_CONST(0.533268516551970), FRAC_CONST(0.845946032116980)},
    {FRAC_CONST(0.530497314137923), FRAC_CONST(0.847686616440563)}, {FRAC_CONST(0.527720430523840), FRAC_CONST(0.849418122721510)}, {FRAC_CONST(0.524937895447912), FRAC_CONST(0.851140532416778)},
    {FRAC_CONST(0.522149738708856), FRAC_CONST(0.852853827080745)}, {FRAC_CONST(0.519355990165590), FRAC_CONST(0.854557988365401)}, {FRAC_CONST(0.516556679736915), FRAC_CONST(0.856252998020546)},
    {FRAC_CONST(0.513751837401199), FRAC_CONST(0.857938837893991)}, {FRAC_CONST(0.510941493196049), FRAC_CONST(0.859615489931744)}, {FRAC_CONST(0.508125677217994), FRAC_CONST(0.861282936178208)},
    {FRAC_CONST(0.505304419622159), FRAC_CONST(0.862941158776375)}, {FRAC_CONST(0.502477750621949), FRAC_CONST(0.864590139968012)}, {FRAC_CONST(0.499645700488717), FRAC_CONST(0.866229862093855)},
    {FRAC_CONST(0.496808299551444), FRAC_CONST(0.867860307593799)}, {FRAC_CONST(0.493965578196415), FRAC_CONST(0.869481459007080)}, {FRAC_CONST(0.491117566866892), FRAC_CONST(0.871093298972471)},
    {FRAC_CONST(0.488264296062789), FRAC_CONST(0.872695810228461)}, {FRAC_CONST(0.485405796340343), FRAC_CONST(0.874288975613440)}, {FRAC_CONST(0.482542098311789), FRAC_CONST(0.875872778065888)},
    {FRAC_CONST(0.479673232645033), FRAC_CONST(0.877447200624553)}, {FRAC_CONST(0.476799230063322), FRAC_CONST(0.879012226428633)}, {FRAC_CONST(0.473920121344914), FRAC_CONST(0.880567838717962)},
    {FRAC_CONST(0.471035937322751), FRAC_CONST(0.882114020833179)}, {FRAC_CONST(0.468146708884125), FRAC_CONST(0.883650756215917)}, {FRAC_CONST(0.465252466970353), FRAC_CONST(0.885178028408975)},
    {FRAC_CONST(0.462353242576441), FRAC_CONST(0.886695821056495)}, {FRAC_CONST(0.459449066750752), FRAC_CONST(0.888204117904136)}, {FRAC_CONST(0.456539970594675), FRAC_CONST(0.889702902799251)},
    {FRAC_CONST(0.453625985262295), FRAC_CONST(0.891192159691058)}, {FRAC_CONST(0.450707141960053), FRAC_CONST(0.892671872630812)}, {FRAC_CONST(0.447783471946415), FRAC_CONST(0.894142025771977)},
    {FRAC_CONST(0.444855006531538), FRAC_CONST(0.895602603370393)}, {FRAC_CONST(0.441921777076935), FRAC_CONST(0.897053589784447)}, {FRAC_CONST(0.438983814995137), FRAC_CONST(0.898494969475242)},
    {FRAC_CONST(0.436041151749356), FRAC_CONST(0.899926727006758)}, {FRAC_CONST(0.433093818853152), FRAC_CONST(0.901348847046022)}, {FRAC_CONST(0.430141847870093), FRAC_CONST(0.902761314363272)},
    {FRAC_CONST(0.427185270413416), FRAC_CONST(0.904164113832116)}, {FRAC_CONST(0.424224118145690), FRAC_CONST(0.905557230429701)}, {FRAC_CONST(0.421258422778478), FRAC_CONST(0.906940649236866)},
    {FRAC_CONST(0.418288216071994), FRAC_CONST(0.908314355438308)}, {FRAC_CONST(0.415313529834766), FRAC_CONST(0.909678334322736)}, {FRAC_CONST(0.412334395923293), FRAC_CONST(0.911032571283032)},
    {FRAC_CONST(0.409350846241706), FRAC_CONST(0.912377051816407)}, {FRAC_CONST(0.406362912741425), FRAC_CONST(0.913711761524555)}, {FRAC_CONST(0.403370627420818), FRAC_CONST(0.915036686113806)},
    {FRAC_CONST(0.400374022324857), FRAC_CONST(0.916351811395282)}, {FRAC_CONST(0.397373129544774), FRAC_CONST(0.917657123285050)}, {FRAC_CONST(0.394367981217720), FRAC_CONST(0.918952607804266)},
    {FRAC_CONST(0.391358609526420), FRAC_CONST(0.920238251079332)}, {FRAC_CONST(0.388345046698826), FRAC_CONST(0.921514039342042)}, {FRAC_CONST(0.385327325007776), FRAC_CONST(0.922779958929729)},
    {FRAC_CONST(0.382305476770645), FRAC_CONST(0.924035996285410)}, {FRAC_CONST(0.379279534348999), FRAC_CONST(0.925282137957935)}, {FRAC_CONST(0.376249530148250), FRAC_CONST(0.926518370602127)},
    {FRAC_CONST(0.373215496617310), FRAC_CONST(0.927744680978929)}, {FRAC_CONST(0.370177466248239), FRAC_CONST(0.928961055955541)}, {FRAC_CONST(0.367135471575903), FRAC_CONST(0.930167482505564)},
    {FRAC_CONST(0.364089545177621), FRAC_CONST(0.931363947709140)}, {FRAC_CONST(0.361039719672816), FRAC_CONST(0.932550438753087)}, {FRAC_CONST(0.357986027722671), FRAC_CONST(0.933726942931039)},
    {FRAC_CONST(0.354928502029772), FRAC_CONST(0.934893447643582)}, {FRAC_CONST(0.351867175337763), FRAC_CONST(0.936049940398387)}, {FRAC_CONST(0.348802080430994), FRAC_CONST(0.937196408810347)},
    {FRAC_CONST(0.345733250134169), FRAC_CONST(0.938332840601705)}, {FRAC_CONST(0.342660717311994), FRAC_CONST(0.939459223602190)}, {FRAC_CONST(0.339584514868829), FRAC_CONST(0.940575545749145)},
    {FRAC_CONST(0.336504675748328), FRAC_CONST(0.941681795087657)}, {FRAC_CONST(0.333421232933097), FRAC_CONST(0.942777959770684)}, {FRAC_CONST(0.330334219444328), FRAC_CONST(0.943864028059183)},
    {FRAC_CONST(0.327243668341457), FRAC_CONST(0.944939988322235)}, {FRAC_CONST(0.324149612721804), FRAC_CONST(0.946005829037171)}, {FRAC_CONST(0.321052085720218), FRAC_CONST(0.947061538789691)},
    {FRAC_CONST(0.317951120508725), FRAC_CONST(0.948107106273994)}, {FRAC_CONST(0.314846750296171), FRAC_CONST(0.949142520292891)}, {FRAC_CONST(0.311739008327867), FRAC_CONST(0.950167769757930)},
    {FRAC_CONST(0.308627927885232), FRAC_CONST(0.951182843689513)}, {FRAC_CONST(0.305513542285440), FRAC_CONST(0.952187731217013)}, {FRAC_CONST(0.302395884881056), FRAC_CONST(0.953182421578893)},
    {FRAC_CONST(0.299274989059689), FRAC_CONST(0.954166904122818)}, {FRAC_CONST(0.296150888243624), FRAC_CONST(0.955141168305771)}, {FRAC_CONST(0.293023615889471), FRAC_CONST(0.956105203694164)},
    {FRAC_CONST(0.289893205487806), FRAC_CONST(0.957058999963955)}, {FRAC_CONST(0.286759690562807), FRAC_CONST(0.958002546900750)}, {FRAC_CONST(0.283623104671904), FRAC_CONST(0.958935834399920)},
    {FRAC_CONST(0.280483481405410), FRAC_CONST(0.959858852466706)}, {FRAC_CONST(0.277340854386169), FRAC_CONST(0.960771591216325)}, {FRAC_CONST(0.274195257269191), FRAC_CONST(0.961674040874080)},
    {FRAC_CONST(0.271046723741295), FRAC_CONST(0.962566191775459)}, {FRAC_CONST(0.267895287520743), FRAC_CONST(0.963448034366243)}, {FRAC_CONST(0.264740982356888), FRAC_CONST(0.964319559202607)},
    {FRAC_CONST(0.261583842029803), FRAC_CONST(0.965180756951218)}, {FRAC_CONST(0.258423900349924), FRAC_CONST(0.966031618389343)}, {FRAC_CONST(0.255261191157689), FRAC_CONST(0.966872134404937)},
    {FRAC_CONST(0.252095748323171), FRAC_CONST(0.967702295996750)}, {FRAC_CONST(0.248927605745720), FRAC_CONST(0.968522094274417)}, {FRAC_CONST(0.245756797353599), FRAC_CONST(0.969331520458559)},
    {FRAC_CONST(0.242583357103617), FRAC_CONST(0.970130565880871)}, {FRAC_CONST(0.239407318980770), FRAC_CONST(0.970919221984218)}, {FRAC_CONST(0.236228716997876), FRAC_CONST(0.971697480322728)},
    {FRAC_CONST(0.233047585195206), FRAC_CONST(0.972465332561878)}, {FRAC_CONST(0.229863957640129), FRAC_CONST(0.973222770478587)}, {FRAC_CONST(0.226677868426735), FRAC_CONST(0.973969785961306)},
    {FRAC_CONST(0.223489351675482), FRAC_CONST(0.974706371010097)}, {FRAC_CONST(0.220298441532823), FRAC_CONST(0.975432517736727)}, {FRAC_CONST(0.217105172170841), FRAC_CONST(0.976148218364747)},
    {FRAC_CONST(0.213909577786886), FRAC_CONST(0.976853465229579)}, {FRAC_CONST(0.210711692603206), FRAC_CONST(0.977548250778596)}, {FRAC_CONST(0.207511550866582), FRAC_CONST(0.978232567571202)},
    {FRAC_CONST(0.204309186847962), FRAC_CONST(0.978906408278914)}, {FRAC_CONST(0.201104634842092), FRAC_CONST(0.979569765685441)}, {FRAC_CONST(0.197897929167148), FRAC_CONST(0.980222632686756)},
    {FRAC_CONST(0.194689104164373), FRAC_CONST(0.980865002291179)}, {FRAC_CONST(0.191478194197704), FRAC_CONST(0.981496867619447)}, {FRAC_CONST(0.188265233653407), FRAC_CONST(0.982118221904791)},
    {FRAC_CONST(0.185050256939710), FRAC_CONST(0.982729058493005)}, {FRAC_CONST(0.181833298486427), FRAC_CONST(0.983329370842520)}, {FRAC_CONST(0.178614392744603), FRAC_CONST(0.983919152524473)},
    {FRAC_CONST(0.175393574186129), FRAC_CONST(0.984498397222776)}, {FRAC_CONST(0.172170877303385), FRAC_CONST(0.985067098734184)}, {FRAC_CONST(0.168946336608867), FRAC_CONST(0.985625250968360)},
    {FRAC_CONST(0.165719986634814), FRAC_CONST(0.986172847947943)}, {FRAC_CONST(0.162491861932842), FRAC_CONST(0.986709883808609)}, {FRAC_CONST(0.159261997073573), FRAC_CONST(0.987236352799134)},
    {FRAC_CONST(0.156030426646266), FRAC_CONST(0.987752249281460)}, {FRAC_CONST(0.152797185258443), FRAC_CONST(0.988257567730749)}, {FRAC_CONST(0.149562307535523), FRAC_CONST(0.988752302735447)},
    {FRAC_CONST(0.146325828120446), FRAC_CONST(0.989236448997339)}, {FRAC_CONST(0.143087781673307), FRAC_CONST(0.989710001331608)}, {FRAC_CONST(0.139848202870981), FRAC_CONST(0.990172954666889)},
    {FRAC_CONST(0.136607126406757), FRAC_CONST(0.990625304045323)}, {FRAC_CONST(0.133364586989957), FRAC_CONST(0.991067044622612)}, {FRAC_CONST(0.130120619345575), FRAC_CONST(0.991498171668069)},
    {FRAC_CONST(0.126875258213898), FRAC_CONST(0.991918680564670)}, {FRAC_CONST(0.123628538350136), FRAC_CONST(0.992328566809103)}, {FRAC_CONST(0.120380494524051), FRAC_CONST(0.992727826011815)},
    {FRAC_CONST(0.117131161519582), FRAC_CONST(0.993116453897061)}, {FRAC_CONST(0.113880574134475), FRAC_CONST(0.993494446302948)}, {FRAC_CONST(0.110628767179910), FRAC_CONST(0.993861799181482)},
    {FRAC_CONST(0.107375775480128), FRAC_CONST(0.994218508598608)}, {FRAC_CONST(0.104121633872055), FRAC_CONST(0.994564570734255)}, {FRAC_CONST(0.100866377204933), FRAC_CONST(0.994899981882376)},
    {FRAC_CONST(0.097610040339947), FRAC_CONST(0.995224738450986)}, {FRAC_CONST(0.094352658149849), FRAC_CONST(0.995538836962204)}, {FRAC_CONST(0.091094265518583), FRAC_CONST(0.995842274052287)},
    {FRAC_CONST(0.087834897340919), FRAC_CONST(0.996135046471667)}, {FRAC_CONST(0.084574588522070), FRAC_CONST(0.996417151084987)}, {FRAC_CONST(0.081313373977324), FRAC_CONST(0.996688584871134)},
    {FRAC_CONST(0.078051288631670), FRAC_CONST(0.996949344923269)}, {FRAC_CONST(0.074788367419420), FRAC_CONST(0.997199428448862)}, {FRAC_CONST(0.071524645283840), FRAC_CONST(0.997438832769720)},
    {FRAC_CONST(0.068260157176771), FRAC_CONST(0.997667555322013)}, {FRAC_CONST(0.064994938058259), FRAC_CONST(0.997885593656308)}, {FRAC_CONST(0.061729022896176), FRAC_CONST(0.998092945437590)},
    {FRAC_CONST(0.058462446665851), FRAC_CONST(0.998289608445286)}, {FRAC_CONST(0.055195244349690), FRAC_CONST(0.998475580573295)}, {FRAC_CONST(0.051927450936806), FRAC_CONST(0.998650859830004)},
    {FRAC_CONST(0.048659101422640), FRAC_CONST(0.998815444338313)}, {FRAC_CONST(0.045390230808591), FRAC_CONST(0.998969332335654)}, {FRAC_CONST(0.042120874101635), FRAC_CONST(0.999112522174011)},
    {FRAC_CONST(0.038851066313958), FRAC_CONST(0.999245012319936)}, {FRAC_CONST(0.035580842462574), FRAC_CONST(0.999366801354564)}, {FRAC_CONST(0.032310237568951), FRAC_CONST(0.999477887973635)},
    {FRAC_CONST(0.029039286658643), FRAC_CONST(0.999578270987499)}, {FRAC_CONST(0.025768024760904), FRAC_CONST(0.999667949321134)}, {FRAC_CONST(0.022496486908322), FRAC_CONST(0.999746922014158)},
    {FRAC_CONST(0.019224708136438), FRAC_CONST(0.999815188220837)}, {FRAC_CONST(0.015952723483375), FRAC_CONST(0.999872747210095)}, {FRAC_CONST(0.012680567989461), FRAC_CONST(0.999919598365521)},
    {FRAC_CONST(0.009408276696850), FRAC_CONST(0.999955741185376)}, {FRAC_CONST(0.006135884649155), FRAC_CONST(0.999981175282601)}, {FRAC_CONST(0.002863426891064), FRAC_CONST(0.999995900384816)}};
        #ifdef LD_DEC
/* 240 (N/4) complex twiddle factors */
static const complex_t mdct_tab_960[] = {
    {FRAC_CONST(0.999999665337326), FRAC_CONST(0.000818122995607)}, {FRAC_CONST(0.999972892444367), FRAC_CONST(0.007363041249780)}, {FRAC_CONST(0.999903284040864), FRAC_CONST(0.013907644095771)},
    {FRAC_CONST(0.999790843108610), FRAC_CONST(0.020451651184577)}, {FRAC_CONST(0.999635574464198), FRAC_CONST(0.026994782192715)}, {FRAC_CONST(0.999437484758823), FRAC_CONST(0.033536756834230)},
    {FRAC_CONST(0.999196582477986), FRAC_CONST(0.040077294872701)}, {FRAC_CONST(0.998912877941140), FRAC_CONST(0.046616116133247)}, {FRAC_CONST(0.998586383301244), FRAC_CONST(0.053152940514528)},
    {FRAC_CONST(0.998217112544241), FRAC_CONST(0.059687488000744)}, {FRAC_CONST(0.997805081488460), FRAC_CONST(0.066219478673630)}, {FRAC_CONST(0.997350307783942), FRAC_CONST(0.072748632724445)},
    {FRAC_CONST(0.996852810911678), FRAC_CONST(0.079274670465961)}, {FRAC_CONST(0.996312612182778), FRAC_CONST(0.085797312344440)}, {FRAC_CONST(0.995729734737558), FRAC_CONST(0.092316278951614)},
    {FRAC_CONST(0.995104203544548), FRAC_CONST(0.098831291036650)}, {FRAC_CONST(0.994436045399422), FRAC_CONST(0.105342069518114)}, {FRAC_CONST(0.993725288923851), FRAC_CONST(0.111848335495926)},
    {FRAC_CONST(0.992971964564277), FRAC_CONST(0.118349810263305)}, {FRAC_CONST(0.992176104590608), FRAC_CONST(0.124846215318711)}, {FRAC_CONST(0.991337743094838), FRAC_CONST(0.131337272377774)},
    {FRAC_CONST(0.990456915989581), FRAC_CONST(0.137822703385212)}, {FRAC_CONST(0.989533661006540), FRAC_CONST(0.144302230526747)}, {FRAC_CONST(0.988568017694885), FRAC_CONST(0.150775576241001)},
    {FRAC_CONST(0.987560027419562), FRAC_CONST(0.157242463231389)}, {FRAC_CONST(0.986509733359519), FRAC_CONST(0.163702614477995)}, {FRAC_CONST(0.985417180505858), FRAC_CONST(0.170155753249442)},
    {FRAC_CONST(0.984282415659907), FRAC_CONST(0.176601603114742)}, {FRAC_CONST(0.983105487431216), FRAC_CONST(0.183039887955141)}, {FRAC_CONST(0.981886446235473), FRAC_CONST(0.189470331975943)},
    {FRAC_CONST(0.980625344292344), FRAC_CONST(0.195892659718330)}, {FRAC_CONST(0.979322235623241), FRAC_CONST(0.202306596071156)}, {FRAC_CONST(0.977977176049000), FRAC_CONST(0.208711866282735)},
    {FRAC_CONST(0.976590223187499), FRAC_CONST(0.215108195972610)}, {FRAC_CONST(0.975161436451181), FRAC_CONST(0.221495311143304)}, {FRAC_CONST(0.973690877044515), FRAC_CONST(0.227872938192063)},
    {FRAC_CONST(0.972178607961371), FRAC_CONST(0.234240803922570)}, {FRAC_CONST(0.970624693982323), FRAC_CONST(0.240598635556650)}, {FRAC_CONST(0.969029201671875), FRAC_CONST(0.246946160745958)},
    {FRAC_CONST(0.967392199375607), FRAC_CONST(0.253283107583640)}, {FRAC_CONST(0.965713757217249), FRAC_CONST(0.259609204615985)}, {FRAC_CONST(0.963993947095677), FRAC_CONST(0.265924180854051)},
    {FRAC_CONST(0.962232842681832), FRAC_CONST(0.272227765785273)}, {FRAC_CONST(0.960430519415566), FRAC_CONST(0.278519689385053)}, {FRAC_CONST(0.958587054502409), FRAC_CONST(0.284799682128326)},
    {FRAC_CONST(0.956702526910263), FRAC_CONST(0.291067475001103)}, {FRAC_CONST(0.954777017366017), FRAC_CONST(0.297322799511998)}, {FRAC_CONST(0.952810608352092), FRAC_CONST(0.303565387703730)},
    {FRAC_CONST(0.950803384102905), FRAC_CONST(0.309794972164597)}, {FRAC_CONST(0.948755430601263), FRAC_CONST(0.316011286039934)}, {FRAC_CONST(0.946666835574676), FRAC_CONST(0.322214063043544)},
    {FRAC_CONST(0.944537688491606), FRAC_CONST(0.328403037469105)}, {FRAC_CONST(0.942368080557626), FRAC_CONST(0.334577944201551)}, {FRAC_CONST(0.940158104711519), FRAC_CONST(0.340738518728429)},
    {FRAC_CONST(0.937907855621296), FRAC_CONST(0.346884497151231)}, {FRAC_CONST(0.935617429680138), FRAC_CONST(0.353015616196696)}, {FRAC_CONST(0.933286925002268), FRAC_CONST(0.359131613228090)},
    {FRAC_CONST(0.930916441418752), FRAC_CONST(0.365232226256457)}, {FRAC_CONST(0.928506080473216), FRAC_CONST(0.371317193951838)}, {FRAC_CONST(0.926055945417500), FRAC_CONST(0.377386255654469)},
    {FRAC_CONST(0.923566141207236), FRAC_CONST(0.383439151385947)}, {FRAC_CONST(0.921036774497350), FRAC_CONST(0.389475621860365)}, {FRAC_CONST(0.918467953637492), FRAC_CONST(0.395495408495417)},
    {FRAC_CONST(0.915859788667400), FRAC_CONST(0.401498253423481)}, {FRAC_CONST(0.913212391312179), FRAC_CONST(0.407483899502658)}, {FRAC_CONST(0.910525874977521), FRAC_CONST(0.413452090327791)},
    {FRAC_CONST(0.907800354744844), FRAC_CONST(0.419402570241451)}, {FRAC_CONST(0.905035947366364), FRAC_CONST(0.425335084344881)}, {FRAC_CONST(0.902232771260093), FRAC_CONST(0.431249378508924)},
    {FRAC_CONST(0.899390946504764), FRAC_CONST(0.437145199384900)}, {FRAC_CONST(0.896510594834693), FRAC_CONST(0.443022294415467)}, {FRAC_CONST(0.893591839634558), FRAC_CONST(0.448880411845433)},
    {FRAC_CONST(0.890634805934118), FRAC_CONST(0.454719300732547)}, {FRAC_CONST(0.887639620402854), FRAC_CONST(0.460538710958240)}, {FRAC_CONST(0.884606411344546), FRAC_CONST(0.466338393238348)},
    {FRAC_CONST(0.881535308691775), FRAC_CONST(0.472118099133784)}, {FRAC_CONST(0.878426444000357), FRAC_CONST(0.477877581061184)}, {FRAC_CONST(0.875279950443708), FRAC_CONST(0.483616592303511)},
    {FRAC_CONST(0.872095962807140), FRAC_CONST(0.489334887020625)}, {FRAC_CONST(0.868874617482085), FRAC_CONST(0.495032220259813)}, {FRAC_CONST(0.865616052460258), FRAC_CONST(0.500708347966279)},
    {FRAC_CONST(0.862320407327736), FRAC_CONST(0.506363026993605)}, {FRAC_CONST(0.858987823258990), FRAC_CONST(0.511996015114162)}, {FRAC_CONST(0.855618443010829), FRAC_CONST(0.517607071029487)},
    {FRAC_CONST(0.852212410916289), FRAC_CONST(0.523195954380619)}, {FRAC_CONST(0.848769872878448), FRAC_CONST(0.528762425758396)}, {FRAC_CONST(0.845290976364179), FRAC_CONST(0.534306246713712)},
    {FRAC_CONST(0.841775870397828), FRAC_CONST(0.539827179767727)}, {FRAC_CONST(0.838224705554838), FRAC_CONST(0.545324988422046)}, {FRAC_CONST(0.834637633955290), FRAC_CONST(0.550799437168844)},
    {FRAC_CONST(0.831014809257393), FRAC_CONST(0.556250291500956)}, {FRAC_CONST(0.827356386650900), FRAC_CONST(0.561677317921925)}, {FRAC_CONST(0.823662522850458), FRAC_CONST(0.567080283956001)},
    {FRAC_CONST(0.819933376088899), FRAC_CONST(0.572458958158102)}, {FRAC_CONST(0.816169106110459), FRAC_CONST(0.577813110123727)}, {FRAC_CONST(0.812369874163934), FRAC_CONST(0.583142510498826)},
    {FRAC_CONST(0.808535842995778), FRAC_CONST(0.588446930989624)}, {FRAC_CONST(0.804667176843123), FRAC_CONST(0.593726144372402)}, {FRAC_CONST(0.800764041426753), FRAC_CONST(0.598979924503229)},
    {FRAC_CONST(0.796826603943998), FRAC_CONST(0.604208046327650)}, {FRAC_CONST(0.792855033061574), FRAC_CONST(0.609410285890327)}, {FRAC_CONST(0.788849498908361), FRAC_CONST(0.614586420344631)},
    {FRAC_CONST(0.784810173068109), FRAC_CONST(0.619736227962191)}, {FRAC_CONST(0.780737228572094), FRAC_CONST(0.624859488142386)}, {FRAC_CONST(0.776630839891703), FRAC_CONST(0.629955981421804)},
    {FRAC_CONST(0.772491182930959), FRAC_CONST(0.635025489483633)}, {FRAC_CONST(0.768318435018988), FRAC_CONST(0.640067795167023)}, {FRAC_CONST(0.764112774902423), FRAC_CONST(0.645082682476378)},
    {FRAC_CONST(0.759874382737746), FRAC_CONST(0.650069936590618)}, {FRAC_CONST(0.755603440083571), FRAC_CONST(0.655029343872374)}, {FRAC_CONST(0.751300129892866), FRAC_CONST(0.659960691877147)},
    {FRAC_CONST(0.746964636505118), FRAC_CONST(0.664863769362399)}, {FRAC_CONST(0.742597145638433), FRAC_CONST(0.669738366296610)}, {FRAC_CONST(0.738197844381584), FRAC_CONST(0.674584273868271)},
    {FRAC_CONST(0.733766921185995), FRAC_CONST(0.679401284494831)}, {FRAC_CONST(0.729304565857668), FRAC_CONST(0.684189191831585)}, {FRAC_CONST(0.724810969549055), FRAC_CONST(0.688947790780520)},
    {FRAC_CONST(0.720286324750863), FRAC_CONST(0.693676877499095)}, {FRAC_CONST(0.715730825283819), FRAC_CONST(0.698376249408973)}, {FRAC_CONST(0.711144666290356), FRAC_CONST(0.703045705204703)},
    {FRAC_CONST(0.706528044226263), FRAC_CONST(0.707685044862340)}, {FRAC_CONST(0.701881156852263), FRAC_CONST(0.712294069648014)}, {FRAC_CONST(0.697204203225545), FRAC_CONST(0.716872582126442)},
    {FRAC_CONST(0.692497383691237), FRAC_CONST(0.721420386169390)}, {FRAC_CONST(0.687760899873822), FRAC_CONST(0.725937286964068)}, {FRAC_CONST(0.682994954668502), FRAC_CONST(0.730423091021479)},
    {FRAC_CONST(0.678199752232508), FRAC_CONST(0.734877606184707)}, {FRAC_CONST(0.673375497976352), FRAC_CONST(0.739300641637149)}, {FRAC_CONST(0.668522398555031), FRAC_CONST(0.743692007910687)},
    {FRAC_CONST(0.663640661859171), FRAC_CONST(0.748051516893805)}, {FRAC_CONST(0.658730497006124), FRAC_CONST(0.752378981839648)}, {FRAC_CONST(0.653792114331011), FRAC_CONST(0.756674217374021)},
    {FRAC_CONST(0.648825725377709), FRAC_CONST(0.760937039503328)}, {FRAC_CONST(0.643831542889792), FRAC_CONST(0.765167265622459)}, {FRAC_CONST(0.638809780801414), FRAC_CONST(0.769364714522605)},
    {FRAC_CONST(0.633760654228152), FRAC_CONST(0.773529206399025)}, {FRAC_CONST(0.628684379457781), FRAC_CONST(0.777660562858748)}, {FRAC_CONST(0.623581173941019), FRAC_CONST(0.781758606928213)},
    {FRAC_CONST(0.618451256282204), FRAC_CONST(0.785823163060853)}, {FRAC_CONST(0.613294846229936), FRAC_CONST(0.789854057144609)}, {FRAC_CONST(0.608112164667659), FRAC_CONST(0.793851116509396)},
    {FRAC_CONST(0.602903433604202), FRAC_CONST(0.797814169934493)}, {FRAC_CONST(0.597668876164268), FRAC_CONST(0.801743047655882)}, {FRAC_CONST(0.592408716578875), FRAC_CONST(0.805637581373517)},
    {FRAC_CONST(0.587123180175754), FRAC_CONST(0.809497604258536)}, {FRAC_CONST(0.581812493369691), FRAC_CONST(0.813322950960406)}, {FRAC_CONST(0.576476883652835), FRAC_CONST(0.817113457614006)},
    {FRAC_CONST(0.571116579584947), FRAC_CONST(0.820868961846646)}, {FRAC_CONST(0.565731810783613), FRAC_CONST(0.824589302785025)}, {FRAC_CONST(0.560322807914407), FRAC_CONST(0.828274321062119)},
    {FRAC_CONST(0.554889802681009), FRAC_CONST(0.831923858824010)}, {FRAC_CONST(0.549433027815281), FRAC_CONST(0.835537759736646)}, {FRAC_CONST(0.543952717067296), FRAC_CONST(0.839115868992540)},
    {FRAC_CONST(0.538449105195327), FRAC_CONST(0.842658033317402)}, {FRAC_CONST(0.532922427955790), FRAC_CONST(0.846164100976699)}, {FRAC_CONST(0.527372922093142), FRAC_CONST(0.849633921782164)},
    {FRAC_CONST(0.521800825329746), FRAC_CONST(0.853067347098221)}, {FRAC_CONST(0.516206376355680), FRAC_CONST(0.856464229848356)}, {FRAC_CONST(0.510589814818519), FRAC_CONST(0.859824424521420)},
    {FRAC_CONST(0.504951381313066), FRAC_CONST(0.863147787177854)}, {FRAC_CONST(0.499291317371047), FRAC_CONST(0.866434175455865)}, {FRAC_CONST(0.493609865450762), FRAC_CONST(0.869683448577516)},
    {FRAC_CONST(0.487907268926702), FRAC_CONST(0.872895467354761)}, {FRAC_CONST(0.482183772079123), FRAC_CONST(0.876070094195407)}, {FRAC_CONST(0.476439620083580), FRAC_CONST(0.879207193109004)},
    {FRAC_CONST(0.470675059000427), FRAC_CONST(0.882306629712678)}, {FRAC_CONST(0.464890335764274), FRAC_CONST(0.885368271236879)}, {FRAC_CONST(0.459085698173413), FRAC_CONST(0.888391986531075)},
    {FRAC_CONST(0.453261394879198), FRAC_CONST(0.891377646069366)}, {FRAC_CONST(0.447417675375397), FRAC_CONST(0.894325121956035)}, {FRAC_CONST(0.441554789987504), FRAC_CONST(0.897234287931024)},
    {FRAC_CONST(0.435672989862017), FRAC_CONST(0.900105019375345)}, {FRAC_CONST(0.429772526955677), FRAC_CONST(0.902937193316419)}, {FRAC_CONST(0.423853654024676), FRAC_CONST(0.905730688433339)},
    {FRAC_CONST(0.417916624613831), FRAC_CONST(0.908485385062073)}, {FRAC_CONST(0.411961693045722), FRAC_CONST(0.911201165200584)}, {FRAC_CONST(0.405989114409798), FRAC_CONST(0.913877912513892)},
    {FRAC_CONST(0.399999144551449), FRAC_CONST(0.916515512339049)}, {FRAC_CONST(0.393992040061048), FRAC_CONST(0.919113851690058)}, {FRAC_CONST(0.387968058262959), FRAC_CONST(0.921672819262709)},
    {FRAC_CONST(0.381927457204511), FRAC_CONST(0.924192305439348)}, {FRAC_CONST(0.375870495644949), FRAC_CONST(0.926672202293573)}, {FRAC_CONST(0.369797433044349), FRAC_CONST(0.929112403594856)},
    {FRAC_CONST(0.363708529552499), FRAC_CONST(0.931512804813095)}, {FRAC_CONST(0.357604045997758), FRAC_CONST(0.933873303123091)}, {FRAC_CONST(0.351484243875885), FRAC_CONST(0.936193797408954)},
    {FRAC_CONST(0.345349385338836), FRAC_CONST(0.938474188268430)}, {FRAC_CONST(0.339199733183530), FRAC_CONST(0.940714378017165)}, {FRAC_CONST(0.333035550840599), FRAC_CONST(0.942914270692887)},
    {FRAC_CONST(0.326857102363098), FRAC_CONST(0.945073772059514)}, {FRAC_CONST(0.320664652415198), FRAC_CONST(0.947192789611197)}, {FRAC_CONST(0.314458466260842), FRAC_CONST(0.949271232576274)},
    {FRAC_CONST(0.308238809752391), FRAC_CONST(0.951309011921168)}, {FRAC_CONST(0.302005949319228), FRAC_CONST(0.953306040354194)}, {FRAC_CONST(0.295760151956351), FRAC_CONST(0.955262232329299)},
    {FRAC_CONST(0.289501685212929), FRAC_CONST(0.957177504049732)}, {FRAC_CONST(0.283230817180850), FRAC_CONST(0.959051773471624)}, {FRAC_CONST(0.276947816483228), FRAC_CONST(0.960884960307514)},
    {FRAC_CONST(0.270652952262902), FRAC_CONST(0.962676986029777)}, {FRAC_CONST(0.264346494170904), FRAC_CONST(0.964427773873996)}, {FRAC_CONST(0.258028712354909), FRAC_CONST(0.966137248842248)},
    {FRAC_CONST(0.251699877447663), FRAC_CONST(0.967805337706313)}, {FRAC_CONST(0.245360260555389), FRAC_CONST(0.969431969010818)}, {FRAC_CONST(0.239010133246176), FRAC_CONST(0.971017073076290)},
    {FRAC_CONST(0.232649767538342), FRAC_CONST(0.972560582002147)}, {FRAC_CONST(0.226279435888785), FRAC_CONST(0.974062429669605)}, {FRAC_CONST(0.219899411181310), FRAC_CONST(0.975522551744506)},
    {FRAC_CONST(0.213509966714943), FRAC_CONST(0.976940885680082)}, {FRAC_CONST(0.207111376192219), FRAC_CONST(0.978317370719628)}, {FRAC_CONST(0.200703913707458), FRAC_CONST(0.979651947899104)},
    {FRAC_CONST(0.194287853735029), FRAC_CONST(0.980944560049668)}, {FRAC_CONST(0.187863471117585), FRAC_CONST(0.982195151800116)}, {FRAC_CONST(0.181431041054297), FRAC_CONST(0.983403669579260)},
    {FRAC_CONST(0.174990839089060), FRAC_CONST(0.984570061618221)}, {FRAC_CONST(0.168543141098691), FRAC_CONST(0.985694277952645)}, {FRAC_CONST(0.162088223281113), FRAC_CONST(0.986776270424848)},
    {FRAC_CONST(0.155626362143520), FRAC_CONST(0.987815992685872)}, {FRAC_CONST(0.149157834490539), FRAC_CONST(0.988813400197476)}, {FRAC_CONST(0.142682917412363), FRAC_CONST(0.989768450234042)},
    {FRAC_CONST(0.136201888272891), FRAC_CONST(0.990681101884405)}, {FRAC_CONST(0.129715024697841), FRAC_CONST(0.991551316053606)}, {FRAC_CONST(0.123222604562857), FRAC_CONST(0.992379055464567)},
    {FRAC_CONST(0.116724905981611), FRAC_CONST(0.993164284659685)}, {FRAC_CONST(0.110222207293883), FRAC_CONST(0.993906970002356)}, {FRAC_CONST(0.103714787053643), FRAC_CONST(0.994607079678411)},
    {FRAC_CONST(0.097202924017115), FRAC_CONST(0.995264583697482)}, {FRAC_CONST(0.090686897130838), FRAC_CONST(0.995879453894286)}, {FRAC_CONST(0.084166985519718), FRAC_CONST(0.996451663929828)},
    {FRAC_CONST(0.077643468475068), FRAC_CONST(0.996981189292537)}, {FRAC_CONST(0.071116625442645), FRAC_CONST(0.997468007299307)}, {FRAC_CONST(0.064586736010684), FRAC_CONST(0.997912097096476)},
    {FRAC_CONST(0.058054079897912), FRAC_CONST(0.998313439660714)}, {FRAC_CONST(0.051518936941578), FRAC_CONST(0.998672017799843)}, {FRAC_CONST(0.044981587085452), FRAC_CONST(0.998987816153567)},
    {FRAC_CONST(0.038442310367847), FRAC_CONST(0.999260821194138)}, {FRAC_CONST(0.031901386909611), FRAC_CONST(0.999491021226926)}, {FRAC_CONST(0.025359096902136), FRAC_CONST(0.999678406390929)},
    {FRAC_CONST(0.018815720595351), FRAC_CONST(0.999822968659191)}, {FRAC_CONST(0.012271538285720), FRAC_CONST(0.999924701839145)}, {FRAC_CONST(0.005726830304231), FRAC_CONST(0.999983601572879)}};
        #endif // LD_DEC
/* 60 (N/4) complex twiddle factors */
static const complex_t mdct_tab_240[] = {
    {FRAC_CONST(0.999994645401696), FRAC_CONST(0.003272486506527)}, {FRAC_CONST(0.999566308502021), FRAC_CONST(0.029448173247963)}, {FRAC_CONST(0.998452918783950), FRAC_CONST(0.055603677682425)},
    {FRAC_CONST(0.996655239309180), FRAC_CONST(0.081721074133668)}, {FRAC_CONST(0.994174502117428), FRAC_CONST(0.107782463042759)}, {FRAC_CONST(0.991012407382049), FRAC_CONST(0.133769983235535)},
    {FRAC_CONST(0.987171122244825), FRAC_CONST(0.159665824163761)}, {FRAC_CONST(0.982653279330712), FRAC_CONST(0.185452238111591)}, {FRAC_CONST(0.977461974943572), FRAC_CONST(0.211111552358965)},
    {FRAC_CONST(0.971600766944121), FRAC_CONST(0.236626181293610)}, {FRAC_CONST(0.965073672311547), FRAC_CONST(0.261978638463337)}, {FRAC_CONST(0.957885164390477), FRAC_CONST(0.287151548560387)},
    {FRAC_CONST(0.950040169825165), FRAC_CONST(0.312127659329594)}, {FRAC_CONST(0.941544065183021), FRAC_CONST(0.336889853392220)}, {FRAC_CONST(0.932402673269775), FRAC_CONST(0.361421159977355)},
    {FRAC_CONST(0.922622259138823), FRAC_CONST(0.385704766552831)}, {FRAC_CONST(0.912209525797468), FRAC_CONST(0.409724030347695)}, {FRAC_CONST(0.901171609613013), FRAC_CONST(0.433462489758331)},
    {FRAC_CONST(0.889516075421856), FRAC_CONST(0.456903875630421)}, {FRAC_CONST(0.877250911344924), FRAC_CONST(0.480032122409011)}, {FRAC_CONST(0.864384523313017), FRAC_CONST(0.502831379149042)},
    {FRAC_CONST(0.850925729305802), FRAC_CONST(0.525286020378792)}, {FRAC_CONST(0.836883753308409), FRAC_CONST(0.547380656808797)}, {FRAC_CONST(0.822268218989775), FRAC_CONST(0.569100145878898)},
    {FRAC_CONST(0.807089143107059), FRAC_CONST(0.590429602136201)}, {FRAC_CONST(0.791356928640660), FRAC_CONST(0.611354407436816)}, {FRAC_CONST(0.775082357664531), FRAC_CONST(0.631860220964409)},
    {FRAC_CONST(0.758276583956687), FRAC_CONST(0.651932989058674)}, {FRAC_CONST(0.740951125354959), FRAC_CONST(0.671558954847018)}, {FRAC_CONST(0.723117855863248), FRAC_CONST(0.690724667672829)},
    {FRAC_CONST(0.704788997513670), FRAC_CONST(0.709416992313883)}, {FRAC_CONST(0.685977111990193), FRAC_CONST(0.727623117984575)}, {FRAC_CONST(0.666695092019479), FRAC_CONST(0.745330567115786)},
    {FRAC_CONST(0.646956152534857), FRAC_CONST(0.762527203906388)}, {FRAC_CONST(0.626773821619469), FRAC_CONST(0.779201242640517)}, {FRAC_CONST(0.606161931234795), FRAC_CONST(0.795341255764910)},
    {FRAC_CONST(0.585134607740916), FRAC_CONST(0.810936181720784)}, {FRAC_CONST(0.563706262215017), FRAC_CONST(0.825975332524873)}, {FRAC_CONST(0.541891580574752), FRAC_CONST(0.840448401094438)},
    {FRAC_CONST(0.519705513513249), FRAC_CONST(0.854345468311227)}, {FRAC_CONST(0.497163266252654), FRAC_CONST(0.867657009819544)}, {FRAC_CONST(0.474280288123229), FRAC_CONST(0.880373902553765)},
    {FRAC_CONST(0.451072261975153), FRAC_CONST(0.892487430990834)}, {FRAC_CONST(0.427555093430282), FRAC_CONST(0.903989293123443)}, {FRAC_CONST(0.403744899981227), FRAC_CONST(0.914871606149819)},
    {FRAC_CONST(0.379657999945233), FRAC_CONST(0.925126911876195)}, {FRAC_CONST(0.355310901280416), FRAC_CONST(0.934748181828292)}, {FRAC_CONST(0.330720290272038), FRAC_CONST(0.943728822068278)},
    {FRAC_CONST(0.305903020096554), FRAC_CONST(0.952062677713924)}, {FRAC_CONST(0.280876099271292), FRAC_CONST(0.959744037156857)}, {FRAC_CONST(0.255656679997665), FRAC_CONST(0.966767635977008)},
    {FRAC_CONST(0.230262046405902), FRAC_CONST(0.973128660550580)}, {FRAC_CONST(0.204709602709380), FRAC_CONST(0.978822751349072)}, {FRAC_CONST(0.179016861276633), FRAC_CONST(0.983846005927077)},
    {FRAC_CONST(0.153201430629259), FRAC_CONST(0.988194981596825)}, {FRAC_CONST(0.127281003373913), FRAC_CONST(0.991866697787626)}, {FRAC_CONST(0.101273344076683), FRAC_CONST(0.994858638088611)},
    {FRAC_CONST(0.075196277088140), FRAC_CONST(0.997168751973348)}, {FRAC_CONST(0.049067674327418), FRAC_CONST(0.998795456205172)}, {FRAC_CONST(0.022905443033697), FRAC_CONST(0.999737635922260)}};
    #endif // ALLOW_SMALL_FRAMELENGTH
    #ifdef SSR_DEC
/* 128 (N/4) complex twiddle factors */
static const complex_t mdct_tab_512[] = {
    {FRAC_CONST(0.999998823451702), FRAC_CONST(0.001533980186285)}, {FRAC_CONST(0.999904701082853), FRAC_CONST(0.013805388528060)}, {FRAC_CONST(0.999659996743959), FRAC_CONST(0.026074717829104)},
    {FRAC_CONST(0.999264747286594), FRAC_CONST(0.038340120373553)}, {FRAC_CONST(0.998719012233873), FRAC_CONST(0.050599749036899)}, {FRAC_CONST(0.998022873771486), FRAC_CONST(0.062851757564161)},
    {FRAC_CONST(0.997176436735326), FRAC_CONST(0.075094300847921)}, {FRAC_CONST(0.996179828595697), FRAC_CONST(0.087325535206192)}, {FRAC_CONST(0.995033199438119), FRAC_CONST(0.099543618660069)},
    {FRAC_CONST(0.993736721940725), FRAC_CONST(0.111746711211127)}, {FRAC_CONST(0.992290591348257), FRAC_CONST(0.123932975118512)}, {FRAC_CONST(0.990695025442665), FRAC_CONST(0.136100575175706)},
    {FRAC_CONST(0.988950264510303), FRAC_CONST(0.148247678986896)}, {FRAC_CONST(0.987056571305751), FRAC_CONST(0.160372457242928)}, {FRAC_CONST(0.985014231012240), FRAC_CONST(0.172473083996796)},
    {FRAC_CONST(0.982823551198705), FRAC_CONST(0.184547736938620)}, {FRAC_CONST(0.980484861773469), FRAC_CONST(0.196594597670080)}, {FRAC_CONST(0.977998514934557), FRAC_CONST(0.208611851978263)},
    {FRAC_CONST(0.975364885116657), FRAC_CONST(0.220597690108874)}, {FRAC_CONST(0.972584368934732), FRAC_CONST(0.232550307038775)}, {FRAC_CONST(0.969657385124292), FRAC_CONST(0.244467902747824)},
    {FRAC_CONST(0.966584374478333), FRAC_CONST(0.256348682489943)}, {FRAC_CONST(0.963365799780954), FRAC_CONST(0.268190857063403)}, {FRAC_CONST(0.960002145737666), FRAC_CONST(0.279992643080273)},
    {FRAC_CONST(0.956493918902395), FRAC_CONST(0.291752263234989)}, {FRAC_CONST(0.952841647601199), FRAC_CONST(0.303467946572011)}, {FRAC_CONST(0.949045881852701), FRAC_CONST(0.315137928752522)},
    {FRAC_CONST(0.945107193285261), FRAC_CONST(0.326760452320132)}, {FRAC_CONST(0.941026175050889), FRAC_CONST(0.338333766965541)}, {FRAC_CONST(0.936803441735922), FRAC_CONST(0.349856129790135)},
    {FRAC_CONST(0.932439629268462), FRAC_CONST(0.361325805568454)}, {FRAC_CONST(0.927935394822618), FRAC_CONST(0.372741067009516)}, {FRAC_CONST(0.923291416719528), FRAC_CONST(0.384100195016935)},
    {FRAC_CONST(0.918508394325212), FRAC_CONST(0.395401478947816)}, {FRAC_CONST(0.913587047945251), FRAC_CONST(0.406643216870369)}, {FRAC_CONST(0.908528118716306), FRAC_CONST(0.417823715820212)},
    {FRAC_CONST(0.903332368494512), FRAC_CONST(0.428941292055329)}, {FRAC_CONST(0.898000579740740), FRAC_CONST(0.439994271309633)}, {FRAC_CONST(0.892533555402765), FRAC_CONST(0.450980989045104)},
    {FRAC_CONST(0.886932118794342), FRAC_CONST(0.461899790702463)}, {FRAC_CONST(0.881197113471222), FRAC_CONST(0.472749031950343)}, {FRAC_CONST(0.875329403104111), FRAC_CONST(0.483527078932919)},
    {FRAC_CONST(0.869329871348607), FRAC_CONST(0.494232308515960)}, {FRAC_CONST(0.863199421712124), FRAC_CONST(0.504863108531268)}, {FRAC_CONST(0.856938977417829), FRAC_CONST(0.515417878019463)},
    {FRAC_CONST(0.850549481265603), FRAC_CONST(0.525895027471085)}, {FRAC_CONST(0.844031895490066), FRAC_CONST(0.536292979065963)}, {FRAC_CONST(0.837387201615662), FRAC_CONST(0.546610166910835)},
    {FRAC_CONST(0.830616400308846), FRAC_CONST(0.556845037275160)}, {FRAC_CONST(0.823720511227391), FRAC_CONST(0.566996048825109)}, {FRAC_CONST(0.816700572866828), FRAC_CONST(0.577061672855679)},
    {FRAC_CONST(0.809557642404051), FRAC_CONST(0.587040393520918)}, {FRAC_CONST(0.802292795538116), FRAC_CONST(0.596930708062197)}, {FRAC_CONST(0.794907126328237), FRAC_CONST(0.606731127034524)},
    {FRAC_CONST(0.787401747029031), FRAC_CONST(0.616440174530854)}, {FRAC_CONST(0.779777787923015), FRAC_CONST(0.626056388404344)}, {FRAC_CONST(0.772036397150385), FRAC_CONST(0.635578320488556)},
    {FRAC_CONST(0.764178740536117), FRAC_CONST(0.645004536815544)}, {FRAC_CONST(0.756206001414395), FRAC_CONST(0.654333617831800)}, {FRAC_CONST(0.748119380450404), FRAC_CONST(0.663564158612040)},
    {FRAC_CONST(0.739920095459516), FRAC_CONST(0.672694769070773)}, {FRAC_CONST(0.731609381223893), FRAC_CONST(0.681724074171650)}, {FRAC_CONST(0.723188489306527), FRAC_CONST(0.690650714134535)},
    {FRAC_CONST(0.714658687862769), FRAC_CONST(0.699473344640284)}, {FRAC_CONST(0.706021261449340), FRAC_CONST(0.708190637033195)}, {FRAC_CONST(0.697277510830887), FRAC_CONST(0.716801278521100)},
    {FRAC_CONST(0.688428752784091), FRAC_CONST(0.725303972373061)}, {FRAC_CONST(0.679476319899365), FRAC_CONST(0.733697438114660)}, {FRAC_CONST(0.670421560380173), FRAC_CONST(0.741980411720831)},
    {FRAC_CONST(0.661265837839992), FRAC_CONST(0.750151645806215)}, {FRAC_CONST(0.652010531096960), FRAC_CONST(0.758209909813015)}, {FRAC_CONST(0.642657033966227), FRAC_CONST(0.766153990196313)},
    {FRAC_CONST(0.633206755050057), FRAC_CONST(0.773982690606823)}, {FRAC_CONST(0.623661117525695), FRAC_CONST(0.781694832071059)}, {FRAC_CONST(0.614021558931038), FRAC_CONST(0.789289253168886)},
    {FRAC_CONST(0.604289530948156), FRAC_CONST(0.796764810208419)}, {FRAC_CONST(0.594466499184665), FRAC_CONST(0.804120377398266)}, {FRAC_CONST(0.584553942953015), FRAC_CONST(0.811354847017064)},
    {FRAC_CONST(0.574553355047716), FRAC_CONST(0.818467129580299)}, {FRAC_CONST(0.564466241520520), FRAC_CONST(0.825456154004377)}, {FRAC_CONST(0.554294121453620), FRAC_CONST(0.832320867767930)},
    {FRAC_CONST(0.544038526730884), FRAC_CONST(0.839060237070313)}, {FRAC_CONST(0.533701001807153), FRAC_CONST(0.845673246987299)}, {FRAC_CONST(0.523283103475656), FRAC_CONST(0.852158901623920)},
    {FRAC_CONST(0.512786400633563), FRAC_CONST(0.858516224264443)}, {FRAC_CONST(0.502212474045711), FRAC_CONST(0.864744257519462)}, {FRAC_CONST(0.491562916106550), FRAC_CONST(0.870842063470079)},
    {FRAC_CONST(0.480839330600334), FRAC_CONST(0.876808723809146)}, {FRAC_CONST(0.470043332459596), FRAC_CONST(0.882643339979563)}, {FRAC_CONST(0.459176547521944), FRAC_CONST(0.888345033309596)},
    {FRAC_CONST(0.448240612285220), FRAC_CONST(0.893912945145203)}, {FRAC_CONST(0.437237173661044), FRAC_CONST(0.899346236979341)}, {FRAC_CONST(0.426167888726800), FRAC_CONST(0.904644090578246)},
    {FRAC_CONST(0.415034424476082), FRAC_CONST(0.909805708104652)}, {FRAC_CONST(0.403838457567654), FRAC_CONST(0.914830312237946)}, {FRAC_CONST(0.392581674072952), FRAC_CONST(0.919717146291227)},
    {FRAC_CONST(0.381265769222162), FRAC_CONST(0.924465474325263)}, {FRAC_CONST(0.369892447148934), FRAC_CONST(0.929074581259316)}, {FRAC_CONST(0.358463420633737), FRAC_CONST(0.933543772978836)},
    {FRAC_CONST(0.346980410845924), FRAC_CONST(0.937872376439990)}, {FRAC_CONST(0.335445147084532), FRAC_CONST(0.942059739771017)}, {FRAC_CONST(0.323859366517853), FRAC_CONST(0.946105232370403)},
    {FRAC_CONST(0.312224813921825), FRAC_CONST(0.950008245001843)}, {FRAC_CONST(0.300543241417273), FRAC_CONST(0.953768189885990)}, {FRAC_CONST(0.288816408206049), FRAC_CONST(0.957384500788976)},
    {FRAC_CONST(0.277046080306100), FRAC_CONST(0.960856633107680)}, {FRAC_CONST(0.265234030285512), FRAC_CONST(0.964184063951746)}, {FRAC_CONST(0.253382036995570), FRAC_CONST(0.967366292222329)},
    {FRAC_CONST(0.241491885302869), FRAC_CONST(0.970402838687556)}, {FRAC_CONST(0.229565365820519), FRAC_CONST(0.973293246054698)}, {FRAC_CONST(0.217604274638484), FRAC_CONST(0.976037079039039)},
    {FRAC_CONST(0.205610413053099), FRAC_CONST(0.978633924429423)}, {FRAC_CONST(0.193585587295804), FRAC_CONST(0.981083391150487)}, {FRAC_CONST(0.181531608261125), FRAC_CONST(0.983385110321551)},
    {FRAC_CONST(0.169450291233968), FRAC_CONST(0.985538735312176)}, {FRAC_CONST(0.157343455616238), FRAC_CONST(0.987543941794359)}, {FRAC_CONST(0.145212924652848), FRAC_CONST(0.989400427791380)},
    {FRAC_CONST(0.133060525157139), FRAC_CONST(0.991107913723277)}, {FRAC_CONST(0.120888087235777), FRAC_CONST(0.992666142448948)}, {FRAC_CONST(0.108697444013139), FRAC_CONST(0.994074879304879)},
    {FRAC_CONST(0.096490431355253), FRAC_CONST(0.995333912140482)}, {FRAC_CONST(0.084268887593324), FRAC_CONST(0.996443051350043)}, {FRAC_CONST(0.072034653246889), FRAC_CONST(0.997402129901275)},
    {FRAC_CONST(0.059789570746640), FRAC_CONST(0.998211003360478)}, {FRAC_CONST(0.047535484156959), FRAC_CONST(0.998869549914284)}, {FRAC_CONST(0.035274238898214), FRAC_CONST(0.999377670388003)},
    {FRAC_CONST(0.023007681468839), FRAC_CONST(0.999735288260562)}, {FRAC_CONST(0.010737659167265), FRAC_CONST(0.999942349676024)}};
/* 16 (N/4) complex twiddle factors */
static const complex_t mdct_tab_64[] = {
    {FRAC_CONST(0.999924701839145), FRAC_CONST(0.012271538285720)}, {FRAC_CONST(0.993906970002356), FRAC_CONST(0.110222207293883)}, {FRAC_CONST(0.978317370719628), FRAC_CONST(0.207111376192219)},
    {FRAC_CONST(0.953306040354194), FRAC_CONST(0.302005949319228)}, {FRAC_CONST(0.919113851690058), FRAC_CONST(0.393992040061048)}, {FRAC_CONST(0.876070094195407), FRAC_CONST(0.482183772079123)},
    {FRAC_CONST(0.824589302785025), FRAC_CONST(0.565731810783613)}, {FRAC_CONST(0.765167265622459), FRAC_CONST(0.643831542889791)}, {FRAC_CONST(0.698376249408973), FRAC_CONST(0.715730825283819)},
    {FRAC_CONST(0.624859488142386), FRAC_CONST(0.780737228572094)}, {FRAC_CONST(0.545324988422046), FRAC_CONST(0.838224705554838)}, {FRAC_CONST(0.460538710958240), FRAC_CONST(0.887639620402854)},
    {FRAC_CONST(0.371317193951838), FRAC_CONST(0.928506080473215)}, {FRAC_CONST(0.278519689385053), FRAC_CONST(0.960430519415566)}, {FRAC_CONST(0.183039887955141), FRAC_CONST(0.983105487431216)},
    {FRAC_CONST(0.085797312344440), FRAC_CONST(0.996312612182778)}};
    #endif // SSR_DEC
#else      // FIXED_POINT
/* 256 (N/4) complex twiddle factors */
static const complex_t mdct_tab_2048[] = {
    {FRAC_CONST(0.031249997702054), FRAC_CONST(0.000011984224612)}, {FRAC_CONST(0.031249813866531), FRAC_CONST(0.000107857810004)}, {FRAC_CONST(0.031249335895858), FRAC_CONST(0.000203730380198)},
    {FRAC_CONST(0.031248563794535), FRAC_CONST(0.000299601032804)}, {FRAC_CONST(0.031247497569829), FRAC_CONST(0.000395468865451)}, {FRAC_CONST(0.031246137231775), FRAC_CONST(0.000491332975794)},
    {FRAC_CONST(0.031244482793177), FRAC_CONST(0.000587192461525)}, {FRAC_CONST(0.031242534269608), FRAC_CONST(0.000683046420376)}, {FRAC_CONST(0.031240291679407), FRAC_CONST(0.000778893950134)},
    {FRAC_CONST(0.031237755043684), FRAC_CONST(0.000874734148645)}, {FRAC_CONST(0.031234924386313), FRAC_CONST(0.000970566113826)}, {FRAC_CONST(0.031231799733938), FRAC_CONST(0.001066388943669)},
    {FRAC_CONST(0.031228381115970), FRAC_CONST(0.001162201736253)}, {FRAC_CONST(0.031224668564585), FRAC_CONST(0.001258003589751)}, {FRAC_CONST(0.031220662114728), FRAC_CONST(0.001353793602441)},
    {FRAC_CONST(0.031216361804108), FRAC_CONST(0.001449570872710)}, {FRAC_CONST(0.031211767673203), FRAC_CONST(0.001545334499065)}, {FRAC_CONST(0.031206879765253), FRAC_CONST(0.001641083580144)},
    {FRAC_CONST(0.031201698126266), FRAC_CONST(0.001736817214719)}, {FRAC_CONST(0.031196222805014), FRAC_CONST(0.001832534501709)}, {FRAC_CONST(0.031190453853031), FRAC_CONST(0.001928234540186)},
    {FRAC_CONST(0.031184391324617), FRAC_CONST(0.002023916429386)}, {FRAC_CONST(0.031178035276836), FRAC_CONST(0.002119579268713)}, {FRAC_CONST(0.031171385769513), FRAC_CONST(0.002215222157753)},
    {FRAC_CONST(0.031164442865236), FRAC_CONST(0.002310844196278)}, {FRAC_CONST(0.031157206629353), FRAC_CONST(0.002406444484258)}, {FRAC_CONST(0.031149677129975), FRAC_CONST(0.002502022121865)},
    {FRAC_CONST(0.031141854437973), FRAC_CONST(0.002597576209488)}, {FRAC_CONST(0.031133738626977), FRAC_CONST(0.002693105847734)}, {FRAC_CONST(0.031125329773375), FRAC_CONST(0.002788610137442)},
    {FRAC_CONST(0.031116627956316), FRAC_CONST(0.002884088179689)}, {FRAC_CONST(0.031107633257703), FRAC_CONST(0.002979539075801)}, {FRAC_CONST(0.031098345762200), FRAC_CONST(0.003074961927355)},
    {FRAC_CONST(0.031088765557222), FRAC_CONST(0.003170355836197)}, {FRAC_CONST(0.031078892732942), FRAC_CONST(0.003265719904442)}, {FRAC_CONST(0.031068727382288), FRAC_CONST(0.003361053234488)},
    {FRAC_CONST(0.031058269600939), FRAC_CONST(0.003456354929021)}, {FRAC_CONST(0.031047519487329), FRAC_CONST(0.003551624091024)}, {FRAC_CONST(0.031036477142640), FRAC_CONST(0.003646859823790)},
    {FRAC_CONST(0.031025142670809), FRAC_CONST(0.003742061230921)}, {FRAC_CONST(0.031013516178519), FRAC_CONST(0.003837227416347)}, {FRAC_CONST(0.031001597775203), FRAC_CONST(0.003932357484328)},
    {FRAC_CONST(0.030989387573042), FRAC_CONST(0.004027450539462)}, {FRAC_CONST(0.030976885686963), FRAC_CONST(0.004122505686697)}, {FRAC_CONST(0.030964092234638), FRAC_CONST(0.004217522031340)},
    {FRAC_CONST(0.030951007336485), FRAC_CONST(0.004312498679058)}, {FRAC_CONST(0.030937631115663), FRAC_CONST(0.004407434735897)}, {FRAC_CONST(0.030923963698074), FRAC_CONST(0.004502329308281)},
    {FRAC_CONST(0.030910005212362), FRAC_CONST(0.004597181503027)}, {FRAC_CONST(0.030895755789908), FRAC_CONST(0.004691990427350)}, {FRAC_CONST(0.030881215564835), FRAC_CONST(0.004786755188872)},
    {FRAC_CONST(0.030866384674000), FRAC_CONST(0.004881474895632)}, {FRAC_CONST(0.030851263256996), FRAC_CONST(0.004976148656090)}, {FRAC_CONST(0.030835851456154), FRAC_CONST(0.005070775579142)},
    {FRAC_CONST(0.030820149416533), FRAC_CONST(0.005165354774124)}, {FRAC_CONST(0.030804157285929), FRAC_CONST(0.005259885350819)}, {FRAC_CONST(0.030787875214864), FRAC_CONST(0.005354366419469)},
    {FRAC_CONST(0.030771303356593), FRAC_CONST(0.005448797090784)}, {FRAC_CONST(0.030754441867095), FRAC_CONST(0.005543176475946)}, {FRAC_CONST(0.030737290905077), FRAC_CONST(0.005637503686619)},
    {FRAC_CONST(0.030719850631972), FRAC_CONST(0.005731777834961)}, {FRAC_CONST(0.030702121211932), FRAC_CONST(0.005825998033626)}, {FRAC_CONST(0.030684102811835), FRAC_CONST(0.005920163395780)},
    {FRAC_CONST(0.030665795601276), FRAC_CONST(0.006014273035101)}, {FRAC_CONST(0.030647199752570), FRAC_CONST(0.006108326065793)}, {FRAC_CONST(0.030628315440748), FRAC_CONST(0.006202321602594)},
    {FRAC_CONST(0.030609142843557), FRAC_CONST(0.006296258760782)}, {FRAC_CONST(0.030589682141455), FRAC_CONST(0.006390136656185)}, {FRAC_CONST(0.030569933517616), FRAC_CONST(0.006483954405188)},
    {FRAC_CONST(0.030549897157919), FRAC_CONST(0.006577711124743)}, {FRAC_CONST(0.030529573250956), FRAC_CONST(0.006671405932375)}, {FRAC_CONST(0.030508961988022), FRAC_CONST(0.006765037946194)},
    {FRAC_CONST(0.030488063563118), FRAC_CONST(0.006858606284900)}, {FRAC_CONST(0.030466878172949), FRAC_CONST(0.006952110067791)}, {FRAC_CONST(0.030445406016919), FRAC_CONST(0.007045548414774)},
    {FRAC_CONST(0.030423647297133), FRAC_CONST(0.007138920446372)}, {FRAC_CONST(0.030401602218392), FRAC_CONST(0.007232225283733)}, {FRAC_CONST(0.030379270988192), FRAC_CONST(0.007325462048634)},
    {FRAC_CONST(0.030356653816724), FRAC_CONST(0.007418629863497)}, {FRAC_CONST(0.030333750916869), FRAC_CONST(0.007511727851390)}, {FRAC_CONST(0.030310562504198), FRAC_CONST(0.007604755136040)},
    {FRAC_CONST(0.030287088796968), FRAC_CONST(0.007697710841838)}, {FRAC_CONST(0.030263330016124), FRAC_CONST(0.007790594093851)}, {FRAC_CONST(0.030239286385293), FRAC_CONST(0.007883404017824)},
    {FRAC_CONST(0.030214958130781), FRAC_CONST(0.007976139740197)}, {FRAC_CONST(0.030190345481576), FRAC_CONST(0.008068800388104)}, {FRAC_CONST(0.030165448669342), FRAC_CONST(0.008161385089390)},
    {FRAC_CONST(0.030140267928416), FRAC_CONST(0.008253892972610)}, {FRAC_CONST(0.030114803495809), FRAC_CONST(0.008346323167047)}, {FRAC_CONST(0.030089055611203), FRAC_CONST(0.008438674802711)},
    {FRAC_CONST(0.030063024516947), FRAC_CONST(0.008530947010354)}, {FRAC_CONST(0.030036710458054), FRAC_CONST(0.008623138921475)}, {FRAC_CONST(0.030010113682202), FRAC_CONST(0.008715249668328)},
    {FRAC_CONST(0.029983234439732), FRAC_CONST(0.008807278383932)}, {FRAC_CONST(0.029956072983640), FRAC_CONST(0.008899224202078)}, {FRAC_CONST(0.029928629569580), FRAC_CONST(0.008991086257336)},
    {FRAC_CONST(0.029900904455860), FRAC_CONST(0.009082863685067)}, {FRAC_CONST(0.029872897903441), FRAC_CONST(0.009174555621425)}, {FRAC_CONST(0.029844610175929), FRAC_CONST(0.009266161203371)},
    {FRAC_CONST(0.029816041539579), FRAC_CONST(0.009357679568679)}, {FRAC_CONST(0.029787192263292), FRAC_CONST(0.009449109855944)}, {FRAC_CONST(0.029758062618606), FRAC_CONST(0.009540451204587)},
    {FRAC_CONST(0.029728652879702), FRAC_CONST(0.009631702754871)}, {FRAC_CONST(0.029698963323395), FRAC_CONST(0.009722863647900)}, {FRAC_CONST(0.029668994229134), FRAC_CONST(0.009813933025633)},
    {FRAC_CONST(0.029638745879000), FRAC_CONST(0.009904910030891)}, {FRAC_CONST(0.029608218557702), FRAC_CONST(0.009995793807363)}, {FRAC_CONST(0.029577412552575), FRAC_CONST(0.010086583499618)},
    {FRAC_CONST(0.029546328153577), FRAC_CONST(0.010177278253107)}, {FRAC_CONST(0.029514965653285), FRAC_CONST(0.010267877214177)}, {FRAC_CONST(0.029483325346896), FRAC_CONST(0.010358379530076)},
    {FRAC_CONST(0.029451407532220), FRAC_CONST(0.010448784348962)}, {FRAC_CONST(0.029419212509679), FRAC_CONST(0.010539090819911)}, {FRAC_CONST(0.029386740582307), FRAC_CONST(0.010629298092923)},
    {FRAC_CONST(0.029353992055740), FRAC_CONST(0.010719405318933)}, {FRAC_CONST(0.029320967238220), FRAC_CONST(0.010809411649818)}, {FRAC_CONST(0.029287666440590), FRAC_CONST(0.010899316238403)},
    {FRAC_CONST(0.029254089976290), FRAC_CONST(0.010989118238474)}, {FRAC_CONST(0.029220238161353), FRAC_CONST(0.011078816804778)}, {FRAC_CONST(0.029186111314406), FRAC_CONST(0.011168411093039)},
    {FRAC_CONST(0.029151709756664), FRAC_CONST(0.011257900259961)}, {FRAC_CONST(0.029117033811927), FRAC_CONST(0.011347283463239)}, {FRAC_CONST(0.029082083806579), FRAC_CONST(0.011436559861563)},
    {FRAC_CONST(0.029046860069582), FRAC_CONST(0.011525728614630)}, {FRAC_CONST(0.029011362932476), FRAC_CONST(0.011614788883150)}, {FRAC_CONST(0.028975592729373), FRAC_CONST(0.011703739828853)},
    {FRAC_CONST(0.028939549796957), FRAC_CONST(0.011792580614500)}, {FRAC_CONST(0.028903234474475), FRAC_CONST(0.011881310403886)}, {FRAC_CONST(0.028866647103744), FRAC_CONST(0.011969928361855)},
    {FRAC_CONST(0.028829788029135), FRAC_CONST(0.012058433654299)}, {FRAC_CONST(0.028792657597583), FRAC_CONST(0.012146825448172)}, {FRAC_CONST(0.028755256158571), FRAC_CONST(0.012235102911499)},
    {FRAC_CONST(0.028717584064137), FRAC_CONST(0.012323265213377)}, {FRAC_CONST(0.028679641668864), FRAC_CONST(0.012411311523990)}, {FRAC_CONST(0.028641429329882), FRAC_CONST(0.012499241014612)},
    {FRAC_CONST(0.028602947406859), FRAC_CONST(0.012587052857618)}, {FRAC_CONST(0.028564196262001), FRAC_CONST(0.012674746226488)}, {FRAC_CONST(0.028525176260050), FRAC_CONST(0.012762320295819)},
    {FRAC_CONST(0.028485887768276), FRAC_CONST(0.012849774241331)}, {FRAC_CONST(0.028446331156478), FRAC_CONST(0.012937107239875)}, {FRAC_CONST(0.028406506796976), FRAC_CONST(0.013024318469437)},
    {FRAC_CONST(0.028366415064615), FRAC_CONST(0.013111407109155)}, {FRAC_CONST(0.028326056336751), FRAC_CONST(0.013198372339315)}, {FRAC_CONST(0.028285430993258), FRAC_CONST(0.013285213341368)},
    {FRAC_CONST(0.028244539416515), FRAC_CONST(0.013371929297933)}, {FRAC_CONST(0.028203381991411), FRAC_CONST(0.013458519392807)}, {FRAC_CONST(0.028161959105334), FRAC_CONST(0.013544982810971)},
    {FRAC_CONST(0.028120271148172), FRAC_CONST(0.013631318738598)}, {FRAC_CONST(0.028078318512309), FRAC_CONST(0.013717526363062)}, {FRAC_CONST(0.028036101592619), FRAC_CONST(0.013803604872943)},
    {FRAC_CONST(0.027993620786463), FRAC_CONST(0.013889553458039)}, {FRAC_CONST(0.027950876493687), FRAC_CONST(0.013975371309367)}, {FRAC_CONST(0.027907869116616), FRAC_CONST(0.014061057619178)},
    {FRAC_CONST(0.027864599060052), FRAC_CONST(0.014146611580959)}, {FRAC_CONST(0.027821066731270), FRAC_CONST(0.014232032389445)}, {FRAC_CONST(0.027777272540012), FRAC_CONST(0.014317319240622)},
    {FRAC_CONST(0.027733216898487), FRAC_CONST(0.014402471331737)}, {FRAC_CONST(0.027688900221361), FRAC_CONST(0.014487487861307)}, {FRAC_CONST(0.027644322925762), FRAC_CONST(0.014572368029123)},
    {FRAC_CONST(0.027599485431266), FRAC_CONST(0.014657111036262)}, {FRAC_CONST(0.027554388159903), FRAC_CONST(0.014741716085090)}, {FRAC_CONST(0.027509031536144), FRAC_CONST(0.014826182379271)},
    {FRAC_CONST(0.027463415986904), FRAC_CONST(0.014910509123778)}, {FRAC_CONST(0.027417541941533), FRAC_CONST(0.014994695524894)}, {FRAC_CONST(0.027371409831816), FRAC_CONST(0.015078740790225)},
    {FRAC_CONST(0.027325020091965), FRAC_CONST(0.015162644128704)}, {FRAC_CONST(0.027278373158618), FRAC_CONST(0.015246404750603)}, {FRAC_CONST(0.027231469470833), FRAC_CONST(0.015330021867534)},
    {FRAC_CONST(0.027184309470088), FRAC_CONST(0.015413494692460)}, {FRAC_CONST(0.027136893600268), FRAC_CONST(0.015496822439704)}, {FRAC_CONST(0.027089222307671), FRAC_CONST(0.015580004324954)},
    {FRAC_CONST(0.027041296040997), FRAC_CONST(0.015663039565269)}, {FRAC_CONST(0.026993115251345), FRAC_CONST(0.015745927379091)}, {FRAC_CONST(0.026944680392213), FRAC_CONST(0.015828666986247)},
    {FRAC_CONST(0.026895991919487), FRAC_CONST(0.015911257607961)}, {FRAC_CONST(0.026847050291442), FRAC_CONST(0.015993698466859)}, {FRAC_CONST(0.026797855968734), FRAC_CONST(0.016075988786976)},
    {FRAC_CONST(0.026748409414401), FRAC_CONST(0.016158127793763)}, {FRAC_CONST(0.026698711093851), FRAC_CONST(0.016240114714099)}, {FRAC_CONST(0.026648761474864), FRAC_CONST(0.016321948776289)},
    {FRAC_CONST(0.026598561027585), FRAC_CONST(0.016403629210082)}, {FRAC_CONST(0.026548110224519), FRAC_CONST(0.016485155246669)}, {FRAC_CONST(0.026497409540530), FRAC_CONST(0.016566526118696)},
    {FRAC_CONST(0.026446459452830), FRAC_CONST(0.016647741060271)}, {FRAC_CONST(0.026395260440982), FRAC_CONST(0.016728799306966)}, {FRAC_CONST(0.026343812986890), FRAC_CONST(0.016809700095831)},
    {FRAC_CONST(0.026292117574797), FRAC_CONST(0.016890442665397)}, {FRAC_CONST(0.026240174691280), FRAC_CONST(0.016971026255683)}, {FRAC_CONST(0.026187984825246), FRAC_CONST(0.017051450108208)},
    {FRAC_CONST(0.026135548467924), FRAC_CONST(0.017131713465990)}, {FRAC_CONST(0.026082866112867), FRAC_CONST(0.017211815573560)}, {FRAC_CONST(0.026029938255941), FRAC_CONST(0.017291755676967)},
    {FRAC_CONST(0.025976765395322), FRAC_CONST(0.017371533023784)}, {FRAC_CONST(0.025923348031494), FRAC_CONST(0.017451146863116)}, {FRAC_CONST(0.025869686667242), FRAC_CONST(0.017530596445607)},
    {FRAC_CONST(0.025815781807646), FRAC_CONST(0.017609881023449)}, {FRAC_CONST(0.025761633960080), FRAC_CONST(0.017688999850383)}, {FRAC_CONST(0.025707243634204), FRAC_CONST(0.017767952181715)},
    {FRAC_CONST(0.025652611341960), FRAC_CONST(0.017846737274313)}, {FRAC_CONST(0.025597737597568), FRAC_CONST(0.017925354386623)}, {FRAC_CONST(0.025542622917522), FRAC_CONST(0.018003802778671)},
    {FRAC_CONST(0.025487267820581), FRAC_CONST(0.018082081712071)}, {FRAC_CONST(0.025431672827768), FRAC_CONST(0.018160190450031)}, {FRAC_CONST(0.025375838462365), FRAC_CONST(0.018238128257362)},
    {FRAC_CONST(0.025319765249906), FRAC_CONST(0.018315894400484)}, {FRAC_CONST(0.025263453718173), FRAC_CONST(0.018393488147432)}, {FRAC_CONST(0.025206904397193), FRAC_CONST(0.018470908767865)},
    {FRAC_CONST(0.025150117819228), FRAC_CONST(0.018548155533070)}, {FRAC_CONST(0.025093094518776), FRAC_CONST(0.018625227715971)}, {FRAC_CONST(0.025035835032562), FRAC_CONST(0.018702124591135)},
    {FRAC_CONST(0.024978339899534), FRAC_CONST(0.018778845434780)}, {FRAC_CONST(0.024920609660858), FRAC_CONST(0.018855389524780)}, {FRAC_CONST(0.024862644859912), FRAC_CONST(0.018931756140672)},
    {FRAC_CONST(0.024804446042284), FRAC_CONST(0.019007944563666)}, {FRAC_CONST(0.024746013755764), FRAC_CONST(0.019083954076646)}, {FRAC_CONST(0.024687348550337), FRAC_CONST(0.019159783964183)},
    {FRAC_CONST(0.024628450978184), FRAC_CONST(0.019235433512536)}, {FRAC_CONST(0.024569321593670), FRAC_CONST(0.019310902009663)}, {FRAC_CONST(0.024509960953345), FRAC_CONST(0.019386188745225)},
    {FRAC_CONST(0.024450369615932), FRAC_CONST(0.019461293010596)}, {FRAC_CONST(0.024390548142329), FRAC_CONST(0.019536214098866)}, {FRAC_CONST(0.024330497095598), FRAC_CONST(0.019610951304848)},
    {FRAC_CONST(0.024270217040961), FRAC_CONST(0.019685503925087)}, {FRAC_CONST(0.024209708545799), FRAC_CONST(0.019759871257867)}, {FRAC_CONST(0.024148972179639), FRAC_CONST(0.019834052603212)},
    {FRAC_CONST(0.024088008514157), FRAC_CONST(0.019908047262901)}, {FRAC_CONST(0.024026818123164), FRAC_CONST(0.019981854540467)}, {FRAC_CONST(0.023965401582609), FRAC_CONST(0.020055473741208)},
    {FRAC_CONST(0.023903759470567), FRAC_CONST(0.020128904172192)}, {FRAC_CONST(0.023841892367236), FRAC_CONST(0.020202145142264)}, {FRAC_CONST(0.023779800854935), FRAC_CONST(0.020275195962052)},
    {FRAC_CONST(0.023717485518092), FRAC_CONST(0.020348055943974)}, {FRAC_CONST(0.023654946943242), FRAC_CONST(0.020420724402244)}, {FRAC_CONST(0.023592185719023), FRAC_CONST(0.020493200652878)},
    {FRAC_CONST(0.023529202436167), FRAC_CONST(0.020565484013703)}, {FRAC_CONST(0.023465997687496), FRAC_CONST(0.020637573804361)}, {FRAC_CONST(0.023402572067918), FRAC_CONST(0.020709469346314)},
    {FRAC_CONST(0.023338926174419), FRAC_CONST(0.020781169962854)}, {FRAC_CONST(0.023275060606058), FRAC_CONST(0.020852674979108)}, {FRAC_CONST(0.023210975963963), FRAC_CONST(0.020923983722044)},
    {FRAC_CONST(0.023146672851322), FRAC_CONST(0.020995095520475)}, {FRAC_CONST(0.023082151873380), FRAC_CONST(0.021066009705072)}, {FRAC_CONST(0.023017413637435), FRAC_CONST(0.021136725608363)},
    {FRAC_CONST(0.022952458752826), FRAC_CONST(0.021207242564742)}, {FRAC_CONST(0.022887287830934), FRAC_CONST(0.021277559910478)}, {FRAC_CONST(0.022821901485173), FRAC_CONST(0.021347676983716)},
    {FRAC_CONST(0.022756300330983), FRAC_CONST(0.021417593124488)}, {FRAC_CONST(0.022690484985827), FRAC_CONST(0.021487307674717)}, {FRAC_CONST(0.022624456069185), FRAC_CONST(0.021556819978223)},
    {FRAC_CONST(0.022558214202547), FRAC_CONST(0.021626129380729)}, {FRAC_CONST(0.022491760009405), FRAC_CONST(0.021695235229869)}, {FRAC_CONST(0.022425094115252), FRAC_CONST(0.021764136875192)},
    {FRAC_CONST(0.022358217147572), FRAC_CONST(0.021832833668171)}, {FRAC_CONST(0.022291129735838), FRAC_CONST(0.021901324962204)}, {FRAC_CONST(0.022223832511501), FRAC_CONST(0.021969610112625)},
    {FRAC_CONST(0.022156326107988), FRAC_CONST(0.022037688476709)}, {FRAC_CONST(0.022088611160696), FRAC_CONST(0.022105559413676)}, {FRAC_CONST(0.022020688306983), FRAC_CONST(0.022173222284699)},
    {FRAC_CONST(0.021952558186166), FRAC_CONST(0.022240676452909)}, {FRAC_CONST(0.021884221439510), FRAC_CONST(0.022307921283403)}, {FRAC_CONST(0.021815678710228), FRAC_CONST(0.022374956143245)},
    {FRAC_CONST(0.021746930643469), FRAC_CONST(0.022441780401478)}, {FRAC_CONST(0.021677977886316), FRAC_CONST(0.022508393429127)}, {FRAC_CONST(0.021608821087780), FRAC_CONST(0.022574794599206)},
    {FRAC_CONST(0.021539460898790), FRAC_CONST(0.022640983286719)}, {FRAC_CONST(0.021469897972190), FRAC_CONST(0.022706958868676)}, {FRAC_CONST(0.021400132962735), FRAC_CONST(0.022772720724087)},
    {FRAC_CONST(0.021330166527077), FRAC_CONST(0.022838268233979)}, {FRAC_CONST(0.021259999323769), FRAC_CONST(0.022903600781391)}, {FRAC_CONST(0.021189632013250), FRAC_CONST(0.022968717751391)},
    {FRAC_CONST(0.021119065257845), FRAC_CONST(0.023033618531071)}, {FRAC_CONST(0.021048299721754), FRAC_CONST(0.023098302509561)}, {FRAC_CONST(0.020977336071050), FRAC_CONST(0.023162769078031)},
    {FRAC_CONST(0.020906174973670), FRAC_CONST(0.023227017629698)}, {FRAC_CONST(0.020834817099409), FRAC_CONST(0.023291047559828)}, {FRAC_CONST(0.020763263119915), FRAC_CONST(0.023354858265748)},
    {FRAC_CONST(0.020691513708680), FRAC_CONST(0.023418449146848)}, {FRAC_CONST(0.020619569541038), FRAC_CONST(0.023481819604585)}, {FRAC_CONST(0.020547431294155), FRAC_CONST(0.023544969042494)},
    {FRAC_CONST(0.020475099647023), FRAC_CONST(0.023607896866186)}, {FRAC_CONST(0.020402575280455), FRAC_CONST(0.023670602483363)}, {FRAC_CONST(0.020329858877078), FRAC_CONST(0.023733085303813)},
    {FRAC_CONST(0.020256951121327), FRAC_CONST(0.023795344739427)}, {FRAC_CONST(0.020183852699437), FRAC_CONST(0.023857380204193)}, {FRAC_CONST(0.020110564299439), FRAC_CONST(0.023919191114211)},
    {FRAC_CONST(0.020037086611150), FRAC_CONST(0.023980776887692)}, {FRAC_CONST(0.019963420326171), FRAC_CONST(0.024042136944968)}, {FRAC_CONST(0.019889566137877), FRAC_CONST(0.024103270708495)},
    {FRAC_CONST(0.019815524741412), FRAC_CONST(0.024164177602859)}, {FRAC_CONST(0.019741296833681), FRAC_CONST(0.024224857054779)}, {FRAC_CONST(0.019666883113346), FRAC_CONST(0.024285308493120)},
    {FRAC_CONST(0.019592284280817), FRAC_CONST(0.024345531348888)}, {FRAC_CONST(0.019517501038246), FRAC_CONST(0.024405525055242)}, {FRAC_CONST(0.019442534089523), FRAC_CONST(0.024465289047500)},
    {FRAC_CONST(0.019367384140264), FRAC_CONST(0.024524822763141)}, {FRAC_CONST(0.019292051897809), FRAC_CONST(0.024584125641809)}, {FRAC_CONST(0.019216538071215), FRAC_CONST(0.024643197125323)},
    {FRAC_CONST(0.019140843371246), FRAC_CONST(0.024702036657681)}, {FRAC_CONST(0.019064968510369), FRAC_CONST(0.024760643685063)}, {FRAC_CONST(0.018988914202748), FRAC_CONST(0.024819017655836)},
    {FRAC_CONST(0.018912681164234), FRAC_CONST(0.024877158020562)}, {FRAC_CONST(0.018836270112363), FRAC_CONST(0.024935064232003)}, {FRAC_CONST(0.018759681766343), FRAC_CONST(0.024992735745123)},
    {FRAC_CONST(0.018682916847054), FRAC_CONST(0.025050172017095)}, {FRAC_CONST(0.018605976077037), FRAC_CONST(0.025107372507308)}, {FRAC_CONST(0.018528860180486), FRAC_CONST(0.025164336677369)},
    {FRAC_CONST(0.018451569883247), FRAC_CONST(0.025221063991110)}, {FRAC_CONST(0.018374105912805), FRAC_CONST(0.025277553914591)}, {FRAC_CONST(0.018296468998280), FRAC_CONST(0.025333805916107)},
    {FRAC_CONST(0.018218659870421), FRAC_CONST(0.025389819466194)}, {FRAC_CONST(0.018140679261596), FRAC_CONST(0.025445594037630)}, {FRAC_CONST(0.018062527905790), FRAC_CONST(0.025501129105445)},
    {FRAC_CONST(0.017984206538592), FRAC_CONST(0.025556424146920)}, {FRAC_CONST(0.017905715897192), FRAC_CONST(0.025611478641598)}, {FRAC_CONST(0.017827056720375), FRAC_CONST(0.025666292071285)},
    {FRAC_CONST(0.017748229748511), FRAC_CONST(0.025720863920056)}, {FRAC_CONST(0.017669235723550), FRAC_CONST(0.025775193674260)}, {FRAC_CONST(0.017590075389012), FRAC_CONST(0.025829280822525)},
    {FRAC_CONST(0.017510749489986), FRAC_CONST(0.025883124855762)}, {FRAC_CONST(0.017431258773116), FRAC_CONST(0.025936725267170)}, {FRAC_CONST(0.017351603986600), FRAC_CONST(0.025990081552242)},
    {FRAC_CONST(0.017271785880180), FRAC_CONST(0.026043193208768)}, {FRAC_CONST(0.017191805205132), FRAC_CONST(0.026096059736841)}, {FRAC_CONST(0.017111662714267), FRAC_CONST(0.026148680638861)},
    {FRAC_CONST(0.017031359161915), FRAC_CONST(0.026201055419541)}, {FRAC_CONST(0.016950895303924), FRAC_CONST(0.026253183585908)}, {FRAC_CONST(0.016870271897651), FRAC_CONST(0.026305064647313)},
    {FRAC_CONST(0.016789489701954), FRAC_CONST(0.026356698115431)}, {FRAC_CONST(0.016708549477186), FRAC_CONST(0.026408083504269)}, {FRAC_CONST(0.016627451985187), FRAC_CONST(0.026459220330167)},
    {FRAC_CONST(0.016546197989277), FRAC_CONST(0.026510108111806)}, {FRAC_CONST(0.016464788254250), FRAC_CONST(0.026560746370212)}, {FRAC_CONST(0.016383223546365), FRAC_CONST(0.026611134628757)},
    {FRAC_CONST(0.016301504633341), FRAC_CONST(0.026661272413168)}, {FRAC_CONST(0.016219632284346), FRAC_CONST(0.026711159251530)}, {FRAC_CONST(0.016137607269996), FRAC_CONST(0.026760794674288)},
    {FRAC_CONST(0.016055430362340), FRAC_CONST(0.026810178214254)}, {FRAC_CONST(0.015973102334858), FRAC_CONST(0.026859309406613)}, {FRAC_CONST(0.015890623962454), FRAC_CONST(0.026908187788922)},
    {FRAC_CONST(0.015807996021446), FRAC_CONST(0.026956812901119)}, {FRAC_CONST(0.015725219289558), FRAC_CONST(0.027005184285527)}, {FRAC_CONST(0.015642294545918), FRAC_CONST(0.027053301486856)},
    {FRAC_CONST(0.015559222571044), FRAC_CONST(0.027101164052208)}, {FRAC_CONST(0.015476004146842), FRAC_CONST(0.027148771531083)}, {FRAC_CONST(0.015392640056594), FRAC_CONST(0.027196123475380)},
    {FRAC_CONST(0.015309131084956), FRAC_CONST(0.027243219439406)}, {FRAC_CONST(0.015225478017946), FRAC_CONST(0.027290058979875)}, {FRAC_CONST(0.015141681642938), FRAC_CONST(0.027336641655915)},
    {FRAC_CONST(0.015057742748656), FRAC_CONST(0.027382967029073)}, {FRAC_CONST(0.014973662125164), FRAC_CONST(0.027429034663317)}, {FRAC_CONST(0.014889440563862), FRAC_CONST(0.027474844125040)},
    {FRAC_CONST(0.014805078857474), FRAC_CONST(0.027520394983066)}, {FRAC_CONST(0.014720577800046), FRAC_CONST(0.027565686808654)}, {FRAC_CONST(0.014635938186934), FRAC_CONST(0.027610719175499)},
    {FRAC_CONST(0.014551160814797), FRAC_CONST(0.027655491659740)}, {FRAC_CONST(0.014466246481592), FRAC_CONST(0.027700003839960)}, {FRAC_CONST(0.014381195986567), FRAC_CONST(0.027744255297195)},
    {FRAC_CONST(0.014296010130247), FRAC_CONST(0.027788245614933)}, {FRAC_CONST(0.014210689714436), FRAC_CONST(0.027831974379120)}, {FRAC_CONST(0.014125235542201), FRAC_CONST(0.027875441178165)},
    {FRAC_CONST(0.014039648417870), FRAC_CONST(0.027918645602941)}, {FRAC_CONST(0.013953929147020), FRAC_CONST(0.027961587246792)}, {FRAC_CONST(0.013868078536476), FRAC_CONST(0.028004265705534)},
    {FRAC_CONST(0.013782097394294), FRAC_CONST(0.028046680577462)}, {FRAC_CONST(0.013695986529763), FRAC_CONST(0.028088831463351)}, {FRAC_CONST(0.013609746753390), FRAC_CONST(0.028130717966461)},
    {FRAC_CONST(0.013523378876898), FRAC_CONST(0.028172339692540)}, {FRAC_CONST(0.013436883713214), FRAC_CONST(0.028213696249828)}, {FRAC_CONST(0.013350262076462), FRAC_CONST(0.028254787249062)},
    {FRAC_CONST(0.013263514781960), FRAC_CONST(0.028295612303478)}, {FRAC_CONST(0.013176642646205), FRAC_CONST(0.028336171028814)}, {FRAC_CONST(0.013089646486871), FRAC_CONST(0.028376463043317)},
    {FRAC_CONST(0.013002527122799), FRAC_CONST(0.028416487967743)}, {FRAC_CONST(0.012915285373990), FRAC_CONST(0.028456245425361)}, {FRAC_CONST(0.012827922061597), FRAC_CONST(0.028495735041960)},
    {FRAC_CONST(0.012740438007915), FRAC_CONST(0.028534956445849)}, {FRAC_CONST(0.012652834036379), FRAC_CONST(0.028573909267859)}, {FRAC_CONST(0.012565110971550), FRAC_CONST(0.028612593141354)},
    {FRAC_CONST(0.012477269639111), FRAC_CONST(0.028651007702224)}, {FRAC_CONST(0.012389310865858), FRAC_CONST(0.028689152588899)}, {FRAC_CONST(0.012301235479693), FRAC_CONST(0.028727027442343)},
    {FRAC_CONST(0.012213044309615), FRAC_CONST(0.028764631906065)}, {FRAC_CONST(0.012124738185712), FRAC_CONST(0.028801965626115)}, {FRAC_CONST(0.012036317939156), FRAC_CONST(0.028839028251097)},
    {FRAC_CONST(0.011947784402191), FRAC_CONST(0.028875819432161)}, {FRAC_CONST(0.011859138408130), FRAC_CONST(0.028912338823015)}, {FRAC_CONST(0.011770380791341), FRAC_CONST(0.028948586079925)},
    {FRAC_CONST(0.011681512387245), FRAC_CONST(0.028984560861718)}, {FRAC_CONST(0.011592534032306), FRAC_CONST(0.029020262829785)}, {FRAC_CONST(0.011503446564022), FRAC_CONST(0.029055691648087)},
    {FRAC_CONST(0.011414250820918), FRAC_CONST(0.029090846983152)}, {FRAC_CONST(0.011324947642537), FRAC_CONST(0.029125728504087)}, {FRAC_CONST(0.011235537869437), FRAC_CONST(0.029160335882573)},
    {FRAC_CONST(0.011146022343175), FRAC_CONST(0.029194668792871)}, {FRAC_CONST(0.011056401906305), FRAC_CONST(0.029228726911828)}, {FRAC_CONST(0.010966677402371), FRAC_CONST(0.029262509918876)},
    {FRAC_CONST(0.010876849675891), FRAC_CONST(0.029296017496036)}, {FRAC_CONST(0.010786919572361), FRAC_CONST(0.029329249327922)}, {FRAC_CONST(0.010696887938235), FRAC_CONST(0.029362205101743)},
    {FRAC_CONST(0.010606755620926), FRAC_CONST(0.029394884507308)}, {FRAC_CONST(0.010516523468793), FRAC_CONST(0.029427287237024)}, {FRAC_CONST(0.010426192331137), FRAC_CONST(0.029459412985906)},
    {FRAC_CONST(0.010335763058187), FRAC_CONST(0.029491261451573)}, {FRAC_CONST(0.010245236501099), FRAC_CONST(0.029522832334255)}, {FRAC_CONST(0.010154613511943), FRAC_CONST(0.029554125336796)},
    {FRAC_CONST(0.010063894943698), FRAC_CONST(0.029585140164654)}, {FRAC_CONST(0.009973081650240), FRAC_CONST(0.029615876525905)}, {FRAC_CONST(0.009882174486340), FRAC_CONST(0.029646334131247)},
    {FRAC_CONST(0.009791174307650), FRAC_CONST(0.029676512694001)}, {FRAC_CONST(0.009700081970699), FRAC_CONST(0.029706411930116)}, {FRAC_CONST(0.009608898332881), FRAC_CONST(0.029736031558168)},
    {FRAC_CONST(0.009517624252453), FRAC_CONST(0.029765371299366)}, {FRAC_CONST(0.009426260588521), FRAC_CONST(0.029794430877553)}, {FRAC_CONST(0.009334808201034), FRAC_CONST(0.029823210019210)},
    {FRAC_CONST(0.009243267950778), FRAC_CONST(0.029851708453456)}, {FRAC_CONST(0.009151640699363), FRAC_CONST(0.029879925912053)}, {FRAC_CONST(0.009059927309220), FRAC_CONST(0.029907862129408)},
    {FRAC_CONST(0.008968128643591), FRAC_CONST(0.029935516842573)}, {FRAC_CONST(0.008876245566520), FRAC_CONST(0.029962889791254)}, {FRAC_CONST(0.008784278942845), FRAC_CONST(0.029989980717805)},
    {FRAC_CONST(0.008692229638191), FRAC_CONST(0.030016789367235)}, {FRAC_CONST(0.008600098518961), FRAC_CONST(0.030043315487212)}, {FRAC_CONST(0.008507886452329), FRAC_CONST(0.030069558828062)},
    {FRAC_CONST(0.008415594306230), FRAC_CONST(0.030095519142772)}, {FRAC_CONST(0.008323222949351), FRAC_CONST(0.030121196186994)}, {FRAC_CONST(0.008230773251129), FRAC_CONST(0.030146589719046)},
    {FRAC_CONST(0.008138246081733), FRAC_CONST(0.030171699499915)}, {FRAC_CONST(0.008045642312067), FRAC_CONST(0.030196525293257)}, {FRAC_CONST(0.007952962813750), FRAC_CONST(0.030221066865402)},
    {FRAC_CONST(0.007860208459119), FRAC_CONST(0.030245323985357)}, {FRAC_CONST(0.007767380121212), FRAC_CONST(0.030269296424803)}, {FRAC_CONST(0.007674478673766), FRAC_CONST(0.030292983958103)},
    {FRAC_CONST(0.007581504991203), FRAC_CONST(0.030316386362302)}, {FRAC_CONST(0.007488459948628), FRAC_CONST(0.030339503417126)}, {FRAC_CONST(0.007395344421816), FRAC_CONST(0.030362334904989)},
    {FRAC_CONST(0.007302159287206), FRAC_CONST(0.030384880610993)}, {FRAC_CONST(0.007208905421891), FRAC_CONST(0.030407140322928)}, {FRAC_CONST(0.007115583703613), FRAC_CONST(0.030429113831278)},
    {FRAC_CONST(0.007022195010752), FRAC_CONST(0.030450800929220)}, {FRAC_CONST(0.006928740222316), FRAC_CONST(0.030472201412626)}, {FRAC_CONST(0.006835220217939), FRAC_CONST(0.030493315080068)},
    {FRAC_CONST(0.006741635877866), FRAC_CONST(0.030514141732814)}, {FRAC_CONST(0.006647988082948), FRAC_CONST(0.030534681174838)}, {FRAC_CONST(0.006554277714635), FRAC_CONST(0.030554933212813)},
    {FRAC_CONST(0.006460505654964), FRAC_CONST(0.030574897656119)}, {FRAC_CONST(0.006366672786553), FRAC_CONST(0.030594574316845)}, {FRAC_CONST(0.006272779992593), FRAC_CONST(0.030613963009786)},
    {FRAC_CONST(0.006178828156839), FRAC_CONST(0.030633063552447)}, {FRAC_CONST(0.006084818163601), FRAC_CONST(0.030651875765048)}, {FRAC_CONST(0.005990750897737), FRAC_CONST(0.030670399470520)},
    {FRAC_CONST(0.005896627244644), FRAC_CONST(0.030688634494512)}, {FRAC_CONST(0.005802448090250), FRAC_CONST(0.030706580665388)}, {FRAC_CONST(0.005708214321004), FRAC_CONST(0.030724237814232)},
    {FRAC_CONST(0.005613926823871), FRAC_CONST(0.030741605774849)}, {FRAC_CONST(0.005519586486321), FRAC_CONST(0.030758684383764)}, {FRAC_CONST(0.005425194196321), FRAC_CONST(0.030775473480228)},
    {FRAC_CONST(0.005330750842327), FRAC_CONST(0.030791972906214)}, {FRAC_CONST(0.005236257313276), FRAC_CONST(0.030808182506425)}, {FRAC_CONST(0.005141714498576), FRAC_CONST(0.030824102128288)},
    {FRAC_CONST(0.005047123288102), FRAC_CONST(0.030839731621963)}, {FRAC_CONST(0.004952484572181), FRAC_CONST(0.030855070840339)}, {FRAC_CONST(0.004857799241589), FRAC_CONST(0.030870119639036)},
    {FRAC_CONST(0.004763068187541), FRAC_CONST(0.030884877876411)}, {FRAC_CONST(0.004668292301681), FRAC_CONST(0.030899345413553)}, {FRAC_CONST(0.004573472476075), FRAC_CONST(0.030913522114288)},
    {FRAC_CONST(0.004478609603205), FRAC_CONST(0.030927407845180)}, {FRAC_CONST(0.004383704575956), FRAC_CONST(0.030941002475530)}, {FRAC_CONST(0.004288758287610), FRAC_CONST(0.030954305877381)},
    {FRAC_CONST(0.004193771631837), FRAC_CONST(0.030967317925516)}, {FRAC_CONST(0.004098745502689), FRAC_CONST(0.030980038497461)}, {FRAC_CONST(0.004003680794587), FRAC_CONST(0.030992467473486)},
    {FRAC_CONST(0.003908578402316), FRAC_CONST(0.031004604736602)}, {FRAC_CONST(0.003813439221017), FRAC_CONST(0.031016450172571)}, {FRAC_CONST(0.003718264146176), FRAC_CONST(0.031028003669899)},
    {FRAC_CONST(0.003623054073616), FRAC_CONST(0.031039265119839)}, {FRAC_CONST(0.003527809899492), FRAC_CONST(0.031050234416394)}, {FRAC_CONST(0.003432532520278), FRAC_CONST(0.031060911456318)},
    {FRAC_CONST(0.003337222832760), FRAC_CONST(0.031071296139114)}, {FRAC_CONST(0.003241881734029), FRAC_CONST(0.031081388367037)}, {FRAC_CONST(0.003146510121474), FRAC_CONST(0.031091188045095)},
    {FRAC_CONST(0.003051108892766), FRAC_CONST(0.031100695081051)}, {FRAC_CONST(0.002955678945860), FRAC_CONST(0.031109909385419)}, {FRAC_CONST(0.002860221178978), FRAC_CONST(0.031118830871473)},
    {FRAC_CONST(0.002764736490604), FRAC_CONST(0.031127459455239)}, {FRAC_CONST(0.002669225779478), FRAC_CONST(0.031135795055501)}, {FRAC_CONST(0.002573689944583), FRAC_CONST(0.031143837593803)},
    {FRAC_CONST(0.002478129885137), FRAC_CONST(0.031151586994444)}, {FRAC_CONST(0.002382546500589), FRAC_CONST(0.031159043184484)}, {FRAC_CONST(0.002286940690606), FRAC_CONST(0.031166206093743)},
    {FRAC_CONST(0.002191313355067), FRAC_CONST(0.031173075654800)}, {FRAC_CONST(0.002095665394051), FRAC_CONST(0.031179651802998)}, {FRAC_CONST(0.001999997707835), FRAC_CONST(0.031185934476438)},
    {FRAC_CONST(0.001904311196878), FRAC_CONST(0.031191923615985)}, {FRAC_CONST(0.001808606761820), FRAC_CONST(0.031197619165268)}, {FRAC_CONST(0.001712885303465), FRAC_CONST(0.031203021070678)},
    {FRAC_CONST(0.001617147722782), FRAC_CONST(0.031208129281370)}, {FRAC_CONST(0.001521394920889), FRAC_CONST(0.031212943749264)}, {FRAC_CONST(0.001425627799047), FRAC_CONST(0.031217464429043)},
    {FRAC_CONST(0.001329847258653), FRAC_CONST(0.031221691278159)}, {FRAC_CONST(0.001234054201231), FRAC_CONST(0.031225624256825)}, {FRAC_CONST(0.001138249528420), FRAC_CONST(0.031229263328024)},
    {FRAC_CONST(0.001042434141971), FRAC_CONST(0.031232608457502)}, {FRAC_CONST(0.000946608943736), FRAC_CONST(0.031235659613775)}, {FRAC_CONST(0.000850774835656), FRAC_CONST(0.031238416768124)},
    {FRAC_CONST(0.000754932719759), FRAC_CONST(0.031240879894597)}, {FRAC_CONST(0.000659083498149), FRAC_CONST(0.031243048970010)}, {FRAC_CONST(0.000563228072993), FRAC_CONST(0.031244923973948)},
    {FRAC_CONST(0.000467367346520), FRAC_CONST(0.031246504888762)}, {FRAC_CONST(0.000371502221008), FRAC_CONST(0.031247791699571)}, {FRAC_CONST(0.000275633598775), FRAC_CONST(0.031248784394264)},
    {FRAC_CONST(0.000179762382174), FRAC_CONST(0.031249482963498)}, {FRAC_CONST(0.000083889473581), FRAC_CONST(0.031249887400697)}};
/* 64 (N/4) complex twiddle factors */
static const complex_t mdct_tab_256[] = {
    {FRAC_CONST(0.088387931675923), FRAC_CONST(0.000271171628935)}, {FRAC_CONST(0.088354655998507), FRAC_CONST(0.002440238387037)}, {FRAC_CONST(0.088268158780110), FRAC_CONST(0.004607835236780)},
    {FRAC_CONST(0.088128492123423), FRAC_CONST(0.006772656498875)}, {FRAC_CONST(0.087935740158418), FRAC_CONST(0.008933398165942)}, {FRAC_CONST(0.087690018991670), FRAC_CONST(0.011088758687994)},
    {FRAC_CONST(0.087391476636423), FRAC_CONST(0.013237439756448)}, {FRAC_CONST(0.087040292923427), FRAC_CONST(0.015378147086172)}, {FRAC_CONST(0.086636679392621), FRAC_CONST(0.017509591195118)},
    {FRAC_CONST(0.086180879165703), FRAC_CONST(0.019630488181053)}, {FRAC_CONST(0.085673166799686), FRAC_CONST(0.021739560494940)}, {FRAC_CONST(0.085113848121515), FRAC_CONST(0.023835537710479)},
    {FRAC_CONST(0.084503260043847), FRAC_CONST(0.025917157289369)}, {FRAC_CONST(0.083841770362110), FRAC_CONST(0.027983165341813)}, {FRAC_CONST(0.083129777532952), FRAC_CONST(0.030032317381813)},
    {FRAC_CONST(0.082367710434230), FRAC_CONST(0.032063379076803)}, {FRAC_CONST(0.081556028106671), FRAC_CONST(0.034075126991164)}, {FRAC_CONST(0.080695219477356), FRAC_CONST(0.036066349323177)},
    {FRAC_CONST(0.079785803065216), FRAC_CONST(0.038035846634965)}, {FRAC_CONST(0.078828326668693), FRAC_CONST(0.039982432574992)}, {FRAC_CONST(0.077823367035766), FRAC_CONST(0.041904934592675)},
    {FRAC_CONST(0.076771529516540), FRAC_CONST(0.043802194644686)}, {FRAC_CONST(0.075673447698606), FRAC_CONST(0.045673069892513)}, {FRAC_CONST(0.074529783025390), FRAC_CONST(0.047516433390863)},
    {FRAC_CONST(0.073341224397728), FRAC_CONST(0.049331174766491)}, {FRAC_CONST(0.072108487758894), FRAC_CONST(0.051116200887052)}, {FRAC_CONST(0.070832315663343), FRAC_CONST(0.052870436519557)},
    {FRAC_CONST(0.069513476829429), FRAC_CONST(0.054592824978055)}, {FRAC_CONST(0.068152765676348), FRAC_CONST(0.056282328760143)}, {FRAC_CONST(0.066751001845620), FRAC_CONST(0.057937930171918)},
    {FRAC_CONST(0.065309029707361), FRAC_CONST(0.059558631940996)}, {FRAC_CONST(0.063827717851668), FRAC_CONST(0.061143457817234)}, {FRAC_CONST(0.062307958565413), FRAC_CONST(0.062691453160784)},
    {FRAC_CONST(0.060750667294763), FRAC_CONST(0.064201685517134)}, {FRAC_CONST(0.059156782093749), FRAC_CONST(0.065673245178784)}, {FRAC_CONST(0.057527263059216), FRAC_CONST(0.067105245733220)},
    {FRAC_CONST(0.055863091752499), FRAC_CONST(0.068496824596852)}, {FRAC_CONST(0.054165270608165), FRAC_CONST(0.069847143534609)}, {FRAC_CONST(0.052434822330188), FRAC_CONST(0.071155389164853)},
    {FRAC_CONST(0.050672789275903), FRAC_CONST(0.072420773449336)}, {FRAC_CONST(0.048880232828135), FRAC_CONST(0.073642534167879)}, {FRAC_CONST(0.047058232755862), FRAC_CONST(0.074819935377512)},
    {FRAC_CONST(0.045207886563797), FRAC_CONST(0.075952267855771)}, {FRAC_CONST(0.043330308831298), FRAC_CONST(0.077038849527912)}, {FRAC_CONST(0.041426630540984), FRAC_CONST(0.078079025877766)},
    {FRAC_CONST(0.039497998397473), FRAC_CONST(0.079072170341994)}, {FRAC_CONST(0.037545574136653), FRAC_CONST(0.080017684687506)}, {FRAC_CONST(0.035570533825892), FRAC_CONST(0.080914999371817)},
    {FRAC_CONST(0.033574067155622), FRAC_CONST(0.081763573886112)}, {FRAC_CONST(0.031557376722714), FRAC_CONST(0.082562897080836)}, {FRAC_CONST(0.029521677306074), FRAC_CONST(0.083312487473584)},
    {FRAC_CONST(0.027468195134911), FRAC_CONST(0.084011893539132)}, {FRAC_CONST(0.025398167150101), FRAC_CONST(0.084660693981419)}, {FRAC_CONST(0.023312840259098), FRAC_CONST(0.085258497987320)},
    {FRAC_CONST(0.021213470584847), FRAC_CONST(0.085804945462053)}, {FRAC_CONST(0.019101322709138), FRAC_CONST(0.086299707246093)}, {FRAC_CONST(0.016977668910873), FRAC_CONST(0.086742485313442)},
    {FRAC_CONST(0.014843788399692), FRAC_CONST(0.087133012951149)}, {FRAC_CONST(0.012700966545425), FRAC_CONST(0.087471054919968)}, {FRAC_CONST(0.010550494103830), FRAC_CONST(0.087756407596056)},
    {FRAC_CONST(0.008393666439096), FRAC_CONST(0.087988899093631)}, {FRAC_CONST(0.006231782743558), FRAC_CONST(0.088168389368510)}, {FRAC_CONST(0.004066145255116), FRAC_CONST(0.088294770302461)},
    {FRAC_CONST(0.001898058472816), FRAC_CONST(0.088367965768336)}};
    #ifdef LD_DEC
/* 128 (N/4) complex twiddle factors */
static const complex_t mdct_tab_1024[] = {
    {FRAC_CONST(0.044194160825012), FRAC_CONST(0.000033896503468)}, {FRAC_CONST(0.044193120897389), FRAC_CONST(0.000305066138364)}, {FRAC_CONST(0.044190417123742), FRAC_CONST(0.000576224287693)},
    {FRAC_CONST(0.044186049605866), FRAC_CONST(0.000847360742503)}, {FRAC_CONST(0.044180018508197), FRAC_CONST(0.001118465294660)}, {FRAC_CONST(0.044172324057802), FRAC_CONST(0.001389527737231)},
    {FRAC_CONST(0.044162966544372), FRAC_CONST(0.001660537864867)}, {FRAC_CONST(0.044151946320213), FRAC_CONST(0.001931485474192)}, {FRAC_CONST(0.044139263800230), FRAC_CONST(0.002202360364180)},
    {FRAC_CONST(0.044124919461912), FRAC_CONST(0.002473152336546)}, {FRAC_CONST(0.044108913845316), FRAC_CONST(0.002743851196123)}, {FRAC_CONST(0.044091247553044), FRAC_CONST(0.003014446751254)},
    {FRAC_CONST(0.044071921250223), FRAC_CONST(0.003284928814169)}, {FRAC_CONST(0.044050935664476), FRAC_CONST(0.003555287201370)}, {FRAC_CONST(0.044028291585898), FRAC_CONST(0.003825511734018)},
    {FRAC_CONST(0.044003989867028), FRAC_CONST(0.004095592238311)}, {FRAC_CONST(0.043978031422810), FRAC_CONST(0.004365518545871)}, {FRAC_CONST(0.043950417230565), FRAC_CONST(0.004635280494126)},
    {FRAC_CONST(0.043921148329953), FRAC_CONST(0.004904867926689)}, {FRAC_CONST(0.043890225822930), FRAC_CONST(0.005174270693748)}, {FRAC_CONST(0.043857650873712), FRAC_CONST(0.005443478652439)},
    {FRAC_CONST(0.043823424708727), FRAC_CONST(0.005712481667236)}, {FRAC_CONST(0.043787548616571), FRAC_CONST(0.005981269610326)}, {FRAC_CONST(0.043750023947958), FRAC_CONST(0.006249832361997)},
    {FRAC_CONST(0.043710852115672), FRAC_CONST(0.006518159811011)}, {FRAC_CONST(0.043670034594508), FRAC_CONST(0.006786241854993)}, {FRAC_CONST(0.043627572921225), FRAC_CONST(0.007054068400804)},
    {FRAC_CONST(0.043583468694479), FRAC_CONST(0.007321629364927)}, {FRAC_CONST(0.043537723574771), FRAC_CONST(0.007588914673843)}, {FRAC_CONST(0.043490339284377), FRAC_CONST(0.007855914264410)},
    {FRAC_CONST(0.043441317607290), FRAC_CONST(0.008122618084246)}, {FRAC_CONST(0.043390660389149), FRAC_CONST(0.008389016092101)}, {FRAC_CONST(0.043338369537168), FRAC_CONST(0.008655098258243)},
    {FRAC_CONST(0.043284447020070), FRAC_CONST(0.008920854564826)}, {FRAC_CONST(0.043228894868005), FRAC_CONST(0.009186275006278)}, {FRAC_CONST(0.043171715172482), FRAC_CONST(0.009451349589667)},
    {FRAC_CONST(0.043112910086283), FRAC_CONST(0.009716068335087)}, {FRAC_CONST(0.043052481823387), FRAC_CONST(0.009980421276025)}, {FRAC_CONST(0.042990432658884), FRAC_CONST(0.010244398459743)},
    {FRAC_CONST(0.042926764928889), FRAC_CONST(0.010507989947649)}, {FRAC_CONST(0.042861481030457), FRAC_CONST(0.010771185815673)}, {FRAC_CONST(0.042794583421490), FRAC_CONST(0.011033976154639)},
    {FRAC_CONST(0.042726074620644), FRAC_CONST(0.011296351070639)}, {FRAC_CONST(0.042655957207238), FRAC_CONST(0.011558300685406)}, {FRAC_CONST(0.042584233821153), FRAC_CONST(0.011819815136685)},
    {FRAC_CONST(0.042510907162732), FRAC_CONST(0.012080884578604)}, {FRAC_CONST(0.042435979992684), FRAC_CONST(0.012341499182048)}, {FRAC_CONST(0.042359455131975), FRAC_CONST(0.012601649135022)},
    {FRAC_CONST(0.042281335461721), FRAC_CONST(0.012861324643029)}, {FRAC_CONST(0.042201623923085), FRAC_CONST(0.013120515929433)}, {FRAC_CONST(0.042120323517160), FRAC_CONST(0.013379213235827)},
    {FRAC_CONST(0.042037437304862), FRAC_CONST(0.013637406822406)}, {FRAC_CONST(0.041952968406809), FRAC_CONST(0.013895086968325)}, {FRAC_CONST(0.041866920003207), FRAC_CONST(0.014152243972073)},
    {FRAC_CONST(0.041779295333730), FRAC_CONST(0.014408868151835)}, {FRAC_CONST(0.041690097697398), FRAC_CONST(0.014664949845855)}, {FRAC_CONST(0.041599330452450), FRAC_CONST(0.014920479412801)},
    {FRAC_CONST(0.041506997016224), FRAC_CONST(0.015175447232131)}, {FRAC_CONST(0.041413100865019), FRAC_CONST(0.015429843704450)}, {FRAC_CONST(0.041317645533974), FRAC_CONST(0.015683659251874)},
    {FRAC_CONST(0.041220634616927), FRAC_CONST(0.015936884318392)}, {FRAC_CONST(0.041122071766285), FRAC_CONST(0.016189509370223)}, {FRAC_CONST(0.041021960692883), FRAC_CONST(0.016441524896177)},
    {FRAC_CONST(0.040920305165846), FRAC_CONST(0.016692921408010)}, {FRAC_CONST(0.040817109012449), FRAC_CONST(0.016943689440788)}, {FRAC_CONST(0.040712376117967), FRAC_CONST(0.017193819553235)},
    {FRAC_CONST(0.040606110425535), FRAC_CONST(0.017443302328094)}, {FRAC_CONST(0.040498315935996), FRAC_CONST(0.017692128372479)}, {FRAC_CONST(0.040388996707752), FRAC_CONST(0.017940288318230)},
    {FRAC_CONST(0.040278156856609), FRAC_CONST(0.018187772822267)}, {FRAC_CONST(0.040165800555627), FRAC_CONST(0.018434572566936)}, {FRAC_CONST(0.040051932034955), FRAC_CONST(0.018680678260367)},
    {FRAC_CONST(0.039936555581679), FRAC_CONST(0.018926080636820)}, {FRAC_CONST(0.039819675539659), FRAC_CONST(0.019170770457035)}, {FRAC_CONST(0.039701296309360), FRAC_CONST(0.019414738508577)},
    {FRAC_CONST(0.039581422347694), FRAC_CONST(0.019657975606187)}, {FRAC_CONST(0.039460058167849), FRAC_CONST(0.019900472592126)}, {FRAC_CONST(0.039337208339116), FRAC_CONST(0.020142220336521)},
    {FRAC_CONST(0.039212877486723), FRAC_CONST(0.020383209737704)}, {FRAC_CONST(0.039087070291656), FRAC_CONST(0.020623431722561)}, {FRAC_CONST(0.038959791490485), FRAC_CONST(0.020862877246870)},
    {FRAC_CONST(0.038831045875184), FRAC_CONST(0.021101537295642)}, {FRAC_CONST(0.038700838292953), FRAC_CONST(0.021339402883462)}, {FRAC_CONST(0.038569173646034), FRAC_CONST(0.021576465054824)},
    {FRAC_CONST(0.038436056891527), FRAC_CONST(0.021812714884472)}, {FRAC_CONST(0.038301493041202), FRAC_CONST(0.022048143477734)}, {FRAC_CONST(0.038165487161312), FRAC_CONST(0.022282741970855)},
    {FRAC_CONST(0.038028044372402), FRAC_CONST(0.022516501531335)}, {FRAC_CONST(0.037889169849115), FRAC_CONST(0.022749413358259)}, {FRAC_CONST(0.037748868819998), FRAC_CONST(0.022981468682628)},
    {FRAC_CONST(0.037607146567305), FRAC_CONST(0.023212658767690)}, {FRAC_CONST(0.037464008426800), FRAC_CONST(0.023442974909269)}, {FRAC_CONST(0.037319459787553), FRAC_CONST(0.023672408436094)},
    {FRAC_CONST(0.037173506091737), FRAC_CONST(0.023900950710120)}, {FRAC_CONST(0.037026152834428), FRAC_CONST(0.024128593126861)}, {FRAC_CONST(0.036877405563392), FRAC_CONST(0.024355327115708)},
    {FRAC_CONST(0.036727269878879), FRAC_CONST(0.024581144140255)}, {FRAC_CONST(0.036575751433414), FRAC_CONST(0.024806035698618)}, {FRAC_CONST(0.036422855931580), FRAC_CONST(0.025029993323758)},
    {FRAC_CONST(0.036268589129807), FRAC_CONST(0.025253008583796)}, {FRAC_CONST(0.036112956836151), FRAC_CONST(0.025475073082334)}, {FRAC_CONST(0.035955964910083), FRAC_CONST(0.025696178458769)},
    {FRAC_CONST(0.035797619262257), FRAC_CONST(0.025916316388609)}, {FRAC_CONST(0.035637925854300), FRAC_CONST(0.026135478583784)}, {FRAC_CONST(0.035476890698576), FRAC_CONST(0.026353656792963)},
    {FRAC_CONST(0.035314519857970), FRAC_CONST(0.026570842801858)}, {FRAC_CONST(0.035150819445650), FRAC_CONST(0.026787028433540)}, {FRAC_CONST(0.034985795624846), FRAC_CONST(0.027002205548742)},
    {FRAC_CONST(0.034819454608610), FRAC_CONST(0.027216366046166)}, {FRAC_CONST(0.034651802659589), FRAC_CONST(0.027429501862792)}, {FRAC_CONST(0.034482846089783), FRAC_CONST(0.027641604974175)},
    {FRAC_CONST(0.034312591260311), FRAC_CONST(0.027852667394755)}, {FRAC_CONST(0.034141044581172), FRAC_CONST(0.028062681178149)}, {FRAC_CONST(0.033968212511001), FRAC_CONST(0.028271638417458)},
    {FRAC_CONST(0.033794101556828), FRAC_CONST(0.028479531245560)}, {FRAC_CONST(0.033618718273831), FRAC_CONST(0.028686351835407)}, {FRAC_CONST(0.033442069265093), FRAC_CONST(0.028892092400321)},
    {FRAC_CONST(0.033264161181349), FRAC_CONST(0.029096745194286)}, {FRAC_CONST(0.033085000720737), FRAC_CONST(0.029300302512241)}, {FRAC_CONST(0.032904594628548), FRAC_CONST(0.029502756690366)},
    {FRAC_CONST(0.032722949696969), FRAC_CONST(0.029704100106376)}, {FRAC_CONST(0.032540072764829), FRAC_CONST(0.029904325179807)}, {FRAC_CONST(0.032355970717341), FRAC_CONST(0.030103424372297)},
    {FRAC_CONST(0.032170650485843), FRAC_CONST(0.030301390187873)}, {FRAC_CONST(0.031984119047537), FRAC_CONST(0.030498215173235)}, {FRAC_CONST(0.031796383425227), FRAC_CONST(0.030693891918034)},
    {FRAC_CONST(0.031607450687052), FRAC_CONST(0.030888413055150)}, {FRAC_CONST(0.031417327946223), FRAC_CONST(0.031081771260973)}, {FRAC_CONST(0.031226022360754), FRAC_CONST(0.031273959255676)},
    {FRAC_CONST(0.031033541133193), FRAC_CONST(0.031464969803488)}, {FRAC_CONST(0.030839891510348), FRAC_CONST(0.031654795712972)}, {FRAC_CONST(0.030645080783018), FRAC_CONST(0.031843429837288)},
    {FRAC_CONST(0.030449116285718), FRAC_CONST(0.032030865074469)}, {FRAC_CONST(0.030252005396399), FRAC_CONST(0.032217094367684)}, {FRAC_CONST(0.030053755536176), FRAC_CONST(0.032402110705505)},
    {FRAC_CONST(0.029854374169043), FRAC_CONST(0.032585907122172)}, {FRAC_CONST(0.029653868801596), FRAC_CONST(0.032768476697853)}, {FRAC_CONST(0.029452246982750), FRAC_CONST(0.032949812558907)},
    {FRAC_CONST(0.029249516303451), FRAC_CONST(0.033129907878142)}, {FRAC_CONST(0.029045684396395), FRAC_CONST(0.033308755875070)}, {FRAC_CONST(0.028840758935738), FRAC_CONST(0.033486349816166)},
    {FRAC_CONST(0.028634747636808), FRAC_CONST(0.033662683015118)}, {FRAC_CONST(0.028427658255815), FRAC_CONST(0.033837748833080)}, {FRAC_CONST(0.028219498589555), FRAC_CONST(0.034011540678924)},
    {FRAC_CONST(0.028010276475123), FRAC_CONST(0.034184052009485)}, {FRAC_CONST(0.027799999789613), FRAC_CONST(0.034355276329809)}, {FRAC_CONST(0.027588676449824), FRAC_CONST(0.034525207193396)},
    {FRAC_CONST(0.027376314411959), FRAC_CONST(0.034693838202447)}, {FRAC_CONST(0.027162921671330), FRAC_CONST(0.034861163008098)}, {FRAC_CONST(0.026948506262053), FRAC_CONST(0.035027175310665)},
    {FRAC_CONST(0.026733076256746), FRAC_CONST(0.035191868859880)}, {FRAC_CONST(0.026516639766228), FRAC_CONST(0.035355237455122)}, {FRAC_CONST(0.026299204939210), FRAC_CONST(0.035517274945657)},
    {FRAC_CONST(0.026080779961991), FRAC_CONST(0.035677975230865)}, {FRAC_CONST(0.025861373058146), FRAC_CONST(0.035837332260471)}, {FRAC_CONST(0.025640992488223), FRAC_CONST(0.035995340034772)},
    {FRAC_CONST(0.025419646549425), FRAC_CONST(0.036151992604866)}, {FRAC_CONST(0.025197343575302), FRAC_CONST(0.036307284072871)}, {FRAC_CONST(0.024974091935435), FRAC_CONST(0.036461208592152)},
    {FRAC_CONST(0.024749900035122), FRAC_CONST(0.036613760367538)}, {FRAC_CONST(0.024524776315061), FRAC_CONST(0.036764933655540)}, {FRAC_CONST(0.024298729251033), FRAC_CONST(0.036914722764569)},
    {FRAC_CONST(0.024071767353583), FRAC_CONST(0.037063122055150)}, {FRAC_CONST(0.023843899167697), FRAC_CONST(0.037210125940135)}, {FRAC_CONST(0.023615133272485), FRAC_CONST(0.037355728884908)},
    {FRAC_CONST(0.023385478280852), FRAC_CONST(0.037499925407603)}, {FRAC_CONST(0.023154942839179), FRAC_CONST(0.037642710079302)}, {FRAC_CONST(0.022923535626995), FRAC_CONST(0.037784077524241)},
    {FRAC_CONST(0.022691265356652), FRAC_CONST(0.037924022420018)}, {FRAC_CONST(0.022458140772993), FRAC_CONST(0.038062539497785)}, {FRAC_CONST(0.022224170653027), FRAC_CONST(0.038199623542453)},
    {FRAC_CONST(0.021989363805598), FRAC_CONST(0.038335269392885)}, {FRAC_CONST(0.021753729071049), FRAC_CONST(0.038469471942092)}, {FRAC_CONST(0.021517275320897), FRAC_CONST(0.038602226137423)},
    {FRAC_CONST(0.021280011457490), FRAC_CONST(0.038733526980758)}, {FRAC_CONST(0.021041946413679), FRAC_CONST(0.038863369528695)}, {FRAC_CONST(0.020803089152479), FRAC_CONST(0.038991748892734)},
    {FRAC_CONST(0.020563448666730), FRAC_CONST(0.039118660239466)}, {FRAC_CONST(0.020323033978761), FRAC_CONST(0.039244098790750)}, {FRAC_CONST(0.020081854140050), FRAC_CONST(0.039368059823895)},
    {FRAC_CONST(0.019839918230880), FRAC_CONST(0.039490538671839)}, {FRAC_CONST(0.019597235360003), FRAC_CONST(0.039611530723322)}, {FRAC_CONST(0.019353814664291), FRAC_CONST(0.039731031423061)},
    {FRAC_CONST(0.019109665308395), FRAC_CONST(0.039849036271924)}, {FRAC_CONST(0.018864796484402), FRAC_CONST(0.039965540827094)}, {FRAC_CONST(0.018619217411483), FRAC_CONST(0.040080540702240)},
    {FRAC_CONST(0.018372937335552), FRAC_CONST(0.040194031567683)}, {FRAC_CONST(0.018125965528915), FRAC_CONST(0.040306009150554)}, {FRAC_CONST(0.017878311289921), FRAC_CONST(0.040416469234963)},
    {FRAC_CONST(0.017629983942612), FRAC_CONST(0.040525407662148)}, {FRAC_CONST(0.017380992836371), FRAC_CONST(0.040632820330639)}, {FRAC_CONST(0.017131347345575), FRAC_CONST(0.040738703196411)},
    {FRAC_CONST(0.016881056869233), FRAC_CONST(0.040843052273033)}, {FRAC_CONST(0.016630130830641), FRAC_CONST(0.040945863631822)}, {FRAC_CONST(0.016378578677023), FRAC_CONST(0.041047133401988)},
    {FRAC_CONST(0.016126409879175), FRAC_CONST(0.041146857770781)}, {FRAC_CONST(0.015873633931110), FRAC_CONST(0.041245032983635)}, {FRAC_CONST(0.015620260349699), FRAC_CONST(0.041341655344309)},
    {FRAC_CONST(0.015366298674314), FRAC_CONST(0.041436721215026)}, {FRAC_CONST(0.015111758466470), FRAC_CONST(0.041530227016609)}, {FRAC_CONST(0.014856649309460), FRAC_CONST(0.041622169228618)},
    {FRAC_CONST(0.014600980808001), FRAC_CONST(0.041712544389481)}, {FRAC_CONST(0.014344762587867), FRAC_CONST(0.041801349096623)}, {FRAC_CONST(0.014088004295529), FRAC_CONST(0.041888580006598)},
    {FRAC_CONST(0.013830715597792), FRAC_CONST(0.041974233835211)}, {FRAC_CONST(0.013572906181430), FRAC_CONST(0.042058307357645)}, {FRAC_CONST(0.013314585752822), FRAC_CONST(0.042140797408577)},
    {FRAC_CONST(0.013055764037585), FRAC_CONST(0.042221700882306)}, {FRAC_CONST(0.012796450780212), FRAC_CONST(0.042301014732860)}, {FRAC_CONST(0.012536655743699), FRAC_CONST(0.042378735974118)},
    {FRAC_CONST(0.012276388709183), FRAC_CONST(0.042454861679919)}, {FRAC_CONST(0.012015659475571), FRAC_CONST(0.042529388984173)}, {FRAC_CONST(0.011754477859172), FRAC_CONST(0.042602315080970)},
    {FRAC_CONST(0.011492853693324), FRAC_CONST(0.042673637224683)}, {FRAC_CONST(0.011230796828031), FRAC_CONST(0.042743352730074)}, {FRAC_CONST(0.010968317129584), FRAC_CONST(0.042811458972393)},
    {FRAC_CONST(0.010705424480197), FRAC_CONST(0.042877953387479)}, {FRAC_CONST(0.010442128777629), FRAC_CONST(0.042942833471854)}, {FRAC_CONST(0.010178439934815), FRAC_CONST(0.043006096782821)},
    {FRAC_CONST(0.009914367879490), FRAC_CONST(0.043067740938551)}, {FRAC_CONST(0.009649922553818), FRAC_CONST(0.043127763618177)}, {FRAC_CONST(0.009385113914016), FRAC_CONST(0.043186162561878)},
    {FRAC_CONST(0.009119951929979), FRAC_CONST(0.043242935570968)}, {FRAC_CONST(0.008854446584907), FRAC_CONST(0.043298080507974)}, {FRAC_CONST(0.008588607874926), FRAC_CONST(0.043351595296722)},
    {FRAC_CONST(0.008322445808712), FRAC_CONST(0.043403477922409)}, {FRAC_CONST(0.008055970407118), FRAC_CONST(0.043453726431684)}, {FRAC_CONST(0.007789191702791), FRAC_CONST(0.043502338932719)},
    {FRAC_CONST(0.007522119739798), FRAC_CONST(0.043549313595281)}, {FRAC_CONST(0.007254764573250), FRAC_CONST(0.043594648650800)}, {FRAC_CONST(0.006987136268915), FRAC_CONST(0.043638342392438)},
    {FRAC_CONST(0.006719244902849), FRAC_CONST(0.043680393175148)}, {FRAC_CONST(0.006451100561010), FRAC_CONST(0.043720799415744)}, {FRAC_CONST(0.006182713338881), FRAC_CONST(0.043759559592953)},
    {FRAC_CONST(0.005914093341090), FRAC_CONST(0.043796672247476)}, {FRAC_CONST(0.005645250681027), FRAC_CONST(0.043832135982044)}, {FRAC_CONST(0.005376195480466), FRAC_CONST(0.043865949461465)},
    {FRAC_CONST(0.005106937869184), FRAC_CONST(0.043898111412683)}, {FRAC_CONST(0.004837487984578), FRAC_CONST(0.043928620624817)}, {FRAC_CONST(0.004567855971284), FRAC_CONST(0.043957475949213)},
    {FRAC_CONST(0.004298051980793), FRAC_CONST(0.043984676299484)}, {FRAC_CONST(0.004028086171076), FRAC_CONST(0.044010220651553)}, {FRAC_CONST(0.003757968706190), FRAC_CONST(0.044034108043689)},
    {FRAC_CONST(0.003487709755907), FRAC_CONST(0.044056337576546)}, {FRAC_CONST(0.003217319495322), FRAC_CONST(0.044076908413193)}, {FRAC_CONST(0.002946808104477), FRAC_CONST(0.044095819779151)},
    {FRAC_CONST(0.002676185767973), FRAC_CONST(0.044113070962418)}, {FRAC_CONST(0.002405462674586), FRAC_CONST(0.044128661313495)}, {FRAC_CONST(0.002134649016890), FRAC_CONST(0.044142590245416)},
    {FRAC_CONST(0.001863754990865), FRAC_CONST(0.044154857233763)}, {FRAC_CONST(0.001592790795518), FRAC_CONST(0.044165461816692)}, {FRAC_CONST(0.001321766632497), FRAC_CONST(0.044174403594946)},
    {FRAC_CONST(0.001050692705710), FRAC_CONST(0.044181682231873)}, {FRAC_CONST(0.000779579220936), FRAC_CONST(0.044187297453434)}, {FRAC_CONST(0.000508436385446), FRAC_CONST(0.044191249048222)},
    {FRAC_CONST(0.000237274407613), FRAC_CONST(0.044193536867459)}};
    #endif // LD_DEC
    #ifdef ALLOW_SMALL_FRAMELENGTH
/* 480 (N/4) complex twiddle factors */
static const complex_t mdct_tab_1920[] = {
    {FRAC_CONST(0.032274858518097), FRAC_CONST(0.000013202404176)}, {FRAC_CONST(0.032274642494505), FRAC_CONST(0.000118821372483)}, {FRAC_CONST(0.032274080835421), FRAC_CONST(0.000224439068308)},
    {FRAC_CONST(0.032273173546860), FRAC_CONST(0.000330054360572)}, {FRAC_CONST(0.032271920638538), FRAC_CONST(0.000435666118218)}, {FRAC_CONST(0.032270322123873), FRAC_CONST(0.000541273210231)},
    {FRAC_CONST(0.032268378019984), FRAC_CONST(0.000646874505642)}, {FRAC_CONST(0.032266088347691), FRAC_CONST(0.000752468873546)}, {FRAC_CONST(0.032263453131514), FRAC_CONST(0.000858055183114)},
    {FRAC_CONST(0.032260472399674), FRAC_CONST(0.000963632303600)}, {FRAC_CONST(0.032257146184092), FRAC_CONST(0.001069199104358)}, {FRAC_CONST(0.032253474520390), FRAC_CONST(0.001174754454853)},
    {FRAC_CONST(0.032249457447888), FRAC_CONST(0.001280297224671)}, {FRAC_CONST(0.032245095009606), FRAC_CONST(0.001385826283535)}, {FRAC_CONST(0.032240387252262), FRAC_CONST(0.001491340501313)},
    {FRAC_CONST(0.032235334226272), FRAC_CONST(0.001596838748031)}, {FRAC_CONST(0.032229935985750), FRAC_CONST(0.001702319893890)}, {FRAC_CONST(0.032224192588507), FRAC_CONST(0.001807782809271)},
    {FRAC_CONST(0.032218104096050), FRAC_CONST(0.001913226364749)}, {FRAC_CONST(0.032211670573582), FRAC_CONST(0.002018649431111)}, {FRAC_CONST(0.032204892090000), FRAC_CONST(0.002124050879359)},
    {FRAC_CONST(0.032197768717898), FRAC_CONST(0.002229429580728)}, {FRAC_CONST(0.032190300533560), FRAC_CONST(0.002334784406698)}, {FRAC_CONST(0.032182487616965), FRAC_CONST(0.002440114229003)},
    {FRAC_CONST(0.032174330051782), FRAC_CONST(0.002545417919644)}, {FRAC_CONST(0.032165827925374), FRAC_CONST(0.002650694350905)}, {FRAC_CONST(0.032156981328790), FRAC_CONST(0.002755942395358)},
    {FRAC_CONST(0.032147790356771), FRAC_CONST(0.002861160925883)}, {FRAC_CONST(0.032138255107744), FRAC_CONST(0.002966348815672)}, {FRAC_CONST(0.032128375683825), FRAC_CONST(0.003071504938250)},
    {FRAC_CONST(0.032118152190814), FRAC_CONST(0.003176628167476)}, {FRAC_CONST(0.032107584738196), FRAC_CONST(0.003281717377568)}, {FRAC_CONST(0.032096673439141), FRAC_CONST(0.003386771443102)},
    {FRAC_CONST(0.032085418410500), FRAC_CONST(0.003491789239036)}, {FRAC_CONST(0.032073819772804), FRAC_CONST(0.003596769640711)}, {FRAC_CONST(0.032061877650267), FRAC_CONST(0.003701711523874)},
    {FRAC_CONST(0.032049592170778), FRAC_CONST(0.003806613764680)}, {FRAC_CONST(0.032036963465906), FRAC_CONST(0.003911475239711)}, {FRAC_CONST(0.032023991670893), FRAC_CONST(0.004016294825985)},
    {FRAC_CONST(0.032010676924657), FRAC_CONST(0.004121071400967)}, {FRAC_CONST(0.031997019369789), FRAC_CONST(0.004225803842586)}, {FRAC_CONST(0.031983019152549), FRAC_CONST(0.004330491029241)},
    {FRAC_CONST(0.031968676422869), FRAC_CONST(0.004435131839816)}, {FRAC_CONST(0.031953991334348), FRAC_CONST(0.004539725153692)}, {FRAC_CONST(0.031938964044252), FRAC_CONST(0.004644269850758)},
    {FRAC_CONST(0.031923594713510), FRAC_CONST(0.004748764811426)}, {FRAC_CONST(0.031907883506716), FRAC_CONST(0.004853208916638)}, {FRAC_CONST(0.031891830592124), FRAC_CONST(0.004957601047881)},
    {FRAC_CONST(0.031875436141648), FRAC_CONST(0.005061940087200)}, {FRAC_CONST(0.031858700330859), FRAC_CONST(0.005166224917208)}, {FRAC_CONST(0.031841623338985), FRAC_CONST(0.005270454421097)},
    {FRAC_CONST(0.031824205348907), FRAC_CONST(0.005374627482653)}, {FRAC_CONST(0.031806446547156), FRAC_CONST(0.005478742986267)}, {FRAC_CONST(0.031788347123916), FRAC_CONST(0.005582799816945)},
    {FRAC_CONST(0.031769907273017), FRAC_CONST(0.005686796860323)}, {FRAC_CONST(0.031751127191935), FRAC_CONST(0.005790733002674)}, {FRAC_CONST(0.031732007081789), FRAC_CONST(0.005894607130928)},
    {FRAC_CONST(0.031712547147340), FRAC_CONST(0.005998418132675)}, {FRAC_CONST(0.031692747596989), FRAC_CONST(0.006102164896182)}, {FRAC_CONST(0.031672608642773), FRAC_CONST(0.006205846310406)},
    {FRAC_CONST(0.031652130500364), FRAC_CONST(0.006309461265002)}, {FRAC_CONST(0.031631313389067), FRAC_CONST(0.006413008650337)}, {FRAC_CONST(0.031610157531816), FRAC_CONST(0.006516487357501)},
    {FRAC_CONST(0.031588663155172), FRAC_CONST(0.006619896278321)}, {FRAC_CONST(0.031566830489325), FRAC_CONST(0.006723234305370)}, {FRAC_CONST(0.031544659768083), FRAC_CONST(0.006826500331981)},
    {FRAC_CONST(0.031522151228878), FRAC_CONST(0.006929693252258)}, {FRAC_CONST(0.031499305112758), FRAC_CONST(0.007032811961088)}, {FRAC_CONST(0.031476121664387), FRAC_CONST(0.007135855354151)},
    {FRAC_CONST(0.031452601132040), FRAC_CONST(0.007238822327937)}, {FRAC_CONST(0.031428743767604), FRAC_CONST(0.007341711779751)}, {FRAC_CONST(0.031404549826572), FRAC_CONST(0.007444522607730)},
    {FRAC_CONST(0.031380019568042), FRAC_CONST(0.007547253710853)}, {FRAC_CONST(0.031355153254712), FRAC_CONST(0.007649903988952)}, {FRAC_CONST(0.031329951152882), FRAC_CONST(0.007752472342725)},
    {FRAC_CONST(0.031304413532445), FRAC_CONST(0.007854957673748)}, {FRAC_CONST(0.031278540666888), FRAC_CONST(0.007957358884484)}, {FRAC_CONST(0.031252332833290), FRAC_CONST(0.008059674878300)},
    {FRAC_CONST(0.031225790312316), FRAC_CONST(0.008161904559473)}, {FRAC_CONST(0.031198913388214), FRAC_CONST(0.008264046833205)}, {FRAC_CONST(0.031171702348814), FRAC_CONST(0.008366100605636)},
    {FRAC_CONST(0.031144157485525), FRAC_CONST(0.008468064783849)}, {FRAC_CONST(0.031116279093331), FRAC_CONST(0.008569938275893)}, {FRAC_CONST(0.031088067470786), FRAC_CONST(0.008671719990782)},
    {FRAC_CONST(0.031059522920014), FRAC_CONST(0.008773408838517)}, {FRAC_CONST(0.031030645746705), FRAC_CONST(0.008875003730092)}, {FRAC_CONST(0.031001436260110), FRAC_CONST(0.008976503577507)},
    {FRAC_CONST(0.030971894773039), FRAC_CONST(0.009077907293780)}, {FRAC_CONST(0.030942021601857), FRAC_CONST(0.009179213792959)}, {FRAC_CONST(0.030911817066483), FRAC_CONST(0.009280421990133)},
    {FRAC_CONST(0.030881281490382), FRAC_CONST(0.009381530801444)}, {FRAC_CONST(0.030850415200566), FRAC_CONST(0.009482539144097)}, {FRAC_CONST(0.030819218527589), FRAC_CONST(0.009583445936373)},
    {FRAC_CONST(0.030787691805541), FRAC_CONST(0.009684250097643)}, {FRAC_CONST(0.030755835372048), FRAC_CONST(0.009784950548375)}, {FRAC_CONST(0.030723649568268), FRAC_CONST(0.009885546210147)},
    {FRAC_CONST(0.030691134738883), FRAC_CONST(0.009986036005661)}, {FRAC_CONST(0.030658291232103), FRAC_CONST(0.010086418858753)}, {FRAC_CONST(0.030625119399655), FRAC_CONST(0.010186693694402)},
    {FRAC_CONST(0.030591619596781), FRAC_CONST(0.010286859438745)}, {FRAC_CONST(0.030557792182239), FRAC_CONST(0.010386915019088)}, {FRAC_CONST(0.030523637518292), FRAC_CONST(0.010486859363916)},
    {FRAC_CONST(0.030489155970710), FRAC_CONST(0.010586691402906)}, {FRAC_CONST(0.030454347908763), FRAC_CONST(0.010686410066936)}, {FRAC_CONST(0.030419213705216), FRAC_CONST(0.010786014288099)},
    {FRAC_CONST(0.030383753736329), FRAC_CONST(0.010885502999714)}, {FRAC_CONST(0.030347968381849), FRAC_CONST(0.010984875136338)}, {FRAC_CONST(0.030311858025010), FRAC_CONST(0.011084129633775)},
    {FRAC_CONST(0.030275423052523), FRAC_CONST(0.011183265429088)}, {FRAC_CONST(0.030238663854579), FRAC_CONST(0.011282281460612)}, {FRAC_CONST(0.030201580824838), FRAC_CONST(0.011381176667967)},
    {FRAC_CONST(0.030164174360430), FRAC_CONST(0.011479949992062)}, {FRAC_CONST(0.030126444861948), FRAC_CONST(0.011578600375117)}, {FRAC_CONST(0.030088392733446), FRAC_CONST(0.011677126760663)},
    {FRAC_CONST(0.030050018382430), FRAC_CONST(0.011775528093563)}, {FRAC_CONST(0.030011322219859), FRAC_CONST(0.011873803320018)}, {FRAC_CONST(0.029972304660138), FRAC_CONST(0.011971951387578)},
    {FRAC_CONST(0.029932966121114), FRAC_CONST(0.012069971245157)}, {FRAC_CONST(0.029893307024070), FRAC_CONST(0.012167861843041)}, {FRAC_CONST(0.029853327793724), FRAC_CONST(0.012265622132901)},
    {FRAC_CONST(0.029813028858222), FRAC_CONST(0.012363251067801)}, {FRAC_CONST(0.029772410649132), FRAC_CONST(0.012460747602215)}, {FRAC_CONST(0.029731473601443), FRAC_CONST(0.012558110692033)},
    {FRAC_CONST(0.029690218153558), FRAC_CONST(0.012655339294575)}, {FRAC_CONST(0.029648644747289), FRAC_CONST(0.012752432368600)}, {FRAC_CONST(0.029606753827855), FRAC_CONST(0.012849388874320)},
    {FRAC_CONST(0.029564545843872), FRAC_CONST(0.012946207773407)}, {FRAC_CONST(0.029522021247356), FRAC_CONST(0.013042888029011)}, {FRAC_CONST(0.029479180493710), FRAC_CONST(0.013139428605762)},
    {FRAC_CONST(0.029436024041725), FRAC_CONST(0.013235828469789)}, {FRAC_CONST(0.029392552353570), FRAC_CONST(0.013332086588727)}, {FRAC_CONST(0.029348765894794), FRAC_CONST(0.013428201931728)},
    {FRAC_CONST(0.029304665134313), FRAC_CONST(0.013524173469475)}, {FRAC_CONST(0.029260250544412), FRAC_CONST(0.013620000174189)}, {FRAC_CONST(0.029215522600735), FRAC_CONST(0.013715681019643)},
    {FRAC_CONST(0.029170481782283), FRAC_CONST(0.013811214981173)}, {FRAC_CONST(0.029125128571406), FRAC_CONST(0.013906601035686)}, {FRAC_CONST(0.029079463453801), FRAC_CONST(0.014001838161674)},
    {FRAC_CONST(0.029033486918505), FRAC_CONST(0.014096925339225)}, {FRAC_CONST(0.028987199457889), FRAC_CONST(0.014191861550031)}, {FRAC_CONST(0.028940601567655), FRAC_CONST(0.014286645777401)},
    {FRAC_CONST(0.028893693746829), FRAC_CONST(0.014381277006273)}, {FRAC_CONST(0.028846476497755), FRAC_CONST(0.014475754223221)}, {FRAC_CONST(0.028798950326094), FRAC_CONST(0.014570076416472)},
    {FRAC_CONST(0.028751115740811), FRAC_CONST(0.014664242575910)}, {FRAC_CONST(0.028702973254178), FRAC_CONST(0.014758251693091)}, {FRAC_CONST(0.028654523381760), FRAC_CONST(0.014852102761253)},
    {FRAC_CONST(0.028605766642418), FRAC_CONST(0.014945794775326)}, {FRAC_CONST(0.028556703558297), FRAC_CONST(0.015039326731945)}, {FRAC_CONST(0.028507334654823), FRAC_CONST(0.015132697629457)},
    {FRAC_CONST(0.028457660460698), FRAC_CONST(0.015225906467935)}, {FRAC_CONST(0.028407681507891), FRAC_CONST(0.015318952249187)}, {FRAC_CONST(0.028357398331639), FRAC_CONST(0.015411833976768)},
    {FRAC_CONST(0.028306811470432), FRAC_CONST(0.015504550655988)}, {FRAC_CONST(0.028255921466016), FRAC_CONST(0.015597101293927)}, {FRAC_CONST(0.028204728863381), FRAC_CONST(0.015689484899442)},
    {FRAC_CONST(0.028153234210760), FRAC_CONST(0.015781700483179)}, {FRAC_CONST(0.028101438059619), FRAC_CONST(0.015873747057582)}, {FRAC_CONST(0.028049340964652), FRAC_CONST(0.015965623636907)},
    {FRAC_CONST(0.027996943483779), FRAC_CONST(0.016057329237229)}, {FRAC_CONST(0.027944246178133), FRAC_CONST(0.016148862876456)}, {FRAC_CONST(0.027891249612061), FRAC_CONST(0.016240223574335)},
    {FRAC_CONST(0.027837954353113), FRAC_CONST(0.016331410352467)}, {FRAC_CONST(0.027784360972039), FRAC_CONST(0.016422422234315)}, {FRAC_CONST(0.027730470042780), FRAC_CONST(0.016513258245214)},
    {FRAC_CONST(0.027676282142466), FRAC_CONST(0.016603917412384)}, {FRAC_CONST(0.027621797851405), FRAC_CONST(0.016694398764938)}, {FRAC_CONST(0.027567017753080), FRAC_CONST(0.016784701333894)},
    {FRAC_CONST(0.027511942434143), FRAC_CONST(0.016874824152183)}, {FRAC_CONST(0.027456572484404), FRAC_CONST(0.016964766254662)}, {FRAC_CONST(0.027400908496833), FRAC_CONST(0.017054526678124)},
    {FRAC_CONST(0.027344951067546), FRAC_CONST(0.017144104461307)}, {FRAC_CONST(0.027288700795801), FRAC_CONST(0.017233498644904)}, {FRAC_CONST(0.027232158283994), FRAC_CONST(0.017322708271577)},
    {FRAC_CONST(0.027175324137651), FRAC_CONST(0.017411732385960)}, {FRAC_CONST(0.027118198965418), FRAC_CONST(0.017500570034678)}, {FRAC_CONST(0.027060783379060), FRAC_CONST(0.017589220266351)},
    {FRAC_CONST(0.027003077993454), FRAC_CONST(0.017677682131607)}, {FRAC_CONST(0.026945083426576), FRAC_CONST(0.017765954683088)}, {FRAC_CONST(0.026886800299502), FRAC_CONST(0.017854036975468)},
    {FRAC_CONST(0.026828229236397), FRAC_CONST(0.017941928065456)}, {FRAC_CONST(0.026769370864511), FRAC_CONST(0.018029627011808)}, {FRAC_CONST(0.026710225814170), FRAC_CONST(0.018117132875340)},
    {FRAC_CONST(0.026650794718768), FRAC_CONST(0.018204444718934)}, {FRAC_CONST(0.026591078214767), FRAC_CONST(0.018291561607551)}, {FRAC_CONST(0.026531076941680), FRAC_CONST(0.018378482608238)},
    {FRAC_CONST(0.026470791542075), FRAC_CONST(0.018465206790142)}, {FRAC_CONST(0.026410222661558), FRAC_CONST(0.018551733224515)}, {FRAC_CONST(0.026349370948775), FRAC_CONST(0.018638060984730)},
    {FRAC_CONST(0.026288237055398), FRAC_CONST(0.018724189146286)}, {FRAC_CONST(0.026226821636121), FRAC_CONST(0.018810116786819)}, {FRAC_CONST(0.026165125348656), FRAC_CONST(0.018895842986112)},
    {FRAC_CONST(0.026103148853718), FRAC_CONST(0.018981366826109)}, {FRAC_CONST(0.026040892815028), FRAC_CONST(0.019066687390916)}, {FRAC_CONST(0.025978357899296), FRAC_CONST(0.019151803766819)},
    {FRAC_CONST(0.025915544776223), FRAC_CONST(0.019236715042290)}, {FRAC_CONST(0.025852454118485), FRAC_CONST(0.019321420307998)}, {FRAC_CONST(0.025789086601733), FRAC_CONST(0.019405918656817)},
    {FRAC_CONST(0.025725442904582), FRAC_CONST(0.019490209183837)}, {FRAC_CONST(0.025661523708606), FRAC_CONST(0.019574290986376)}, {FRAC_CONST(0.025597329698327), FRAC_CONST(0.019658163163984)},
    {FRAC_CONST(0.025532861561211), FRAC_CONST(0.019741824818458)}, {FRAC_CONST(0.025468119987662), FRAC_CONST(0.019825275053848)}, {FRAC_CONST(0.025403105671008), FRAC_CONST(0.019908512976470)},
    {FRAC_CONST(0.025337819307501), FRAC_CONST(0.019991537694913)}, {FRAC_CONST(0.025272261596305), FRAC_CONST(0.020074348320047)}, {FRAC_CONST(0.025206433239491), FRAC_CONST(0.020156943965039)},
    {FRAC_CONST(0.025140334942028), FRAC_CONST(0.020239323745355)}, {FRAC_CONST(0.025073967411776), FRAC_CONST(0.020321486778774)}, {FRAC_CONST(0.025007331359476), FRAC_CONST(0.020403432185395)},
    {FRAC_CONST(0.024940427498748), FRAC_CONST(0.020485159087650)}, {FRAC_CONST(0.024873256546079), FRAC_CONST(0.020566666610309)}, {FRAC_CONST(0.024805819220816), FRAC_CONST(0.020647953880491)},
    {FRAC_CONST(0.024738116245157), FRAC_CONST(0.020729020027676)}, {FRAC_CONST(0.024670148344147), FRAC_CONST(0.020809864183709)}, {FRAC_CONST(0.024601916245669), FRAC_CONST(0.020890485482816)},
    {FRAC_CONST(0.024533420680433), FRAC_CONST(0.020970883061607)}, {FRAC_CONST(0.024464662381971), FRAC_CONST(0.021051056059087)}, {FRAC_CONST(0.024395642086630), FRAC_CONST(0.021131003616670)},
    {FRAC_CONST(0.024326360533561), FRAC_CONST(0.021210724878181)}, {FRAC_CONST(0.024256818464715), FRAC_CONST(0.021290218989868)}, {FRAC_CONST(0.024187016624830), FRAC_CONST(0.021369485100415)},
    {FRAC_CONST(0.024116955761430), FRAC_CONST(0.021448522360944)}, {FRAC_CONST(0.024046636624808), FRAC_CONST(0.021527329925030)}, {FRAC_CONST(0.023976059968027), FRAC_CONST(0.021605906948708)},
    {FRAC_CONST(0.023905226546906), FRAC_CONST(0.021684252590480)}, {FRAC_CONST(0.023834137120014), FRAC_CONST(0.021762366011328)}, {FRAC_CONST(0.023762792448662), FRAC_CONST(0.021840246374720)},
    {FRAC_CONST(0.023691193296893), FRAC_CONST(0.021917892846620)}, {FRAC_CONST(0.023619340431478), FRAC_CONST(0.021995304595495)}, {FRAC_CONST(0.023547234621902), FRAC_CONST(0.022072480792330)},
    {FRAC_CONST(0.023474876640361), FRAC_CONST(0.022149420610628)}, {FRAC_CONST(0.023402267261751), FRAC_CONST(0.022226123226426)}, {FRAC_CONST(0.023329407263659), FRAC_CONST(0.022302587818300)},
    {FRAC_CONST(0.023256297426359), FRAC_CONST(0.022378813567377)}, {FRAC_CONST(0.023182938532797), FRAC_CONST(0.022454799657339)}, {FRAC_CONST(0.023109331368588), FRAC_CONST(0.022530545274437)},
    {FRAC_CONST(0.023035476722006), FRAC_CONST(0.022606049607496)}, {FRAC_CONST(0.022961375383975), FRAC_CONST(0.022681311847926)}, {FRAC_CONST(0.022887028148061), FRAC_CONST(0.022756331189727)},
    {FRAC_CONST(0.022812435810462), FRAC_CONST(0.022831106829504)}, {FRAC_CONST(0.022737599170003), FRAC_CONST(0.022905637966469)}, {FRAC_CONST(0.022662519028125), FRAC_CONST(0.022979923802453)},
    {FRAC_CONST(0.022587196188874), FRAC_CONST(0.023053963541915)}, {FRAC_CONST(0.022511631458899), FRAC_CONST(0.023127756391950)}, {FRAC_CONST(0.022435825647437), FRAC_CONST(0.023201301562294)},
    {FRAC_CONST(0.022359779566306), FRAC_CONST(0.023274598265338)}, {FRAC_CONST(0.022283494029900), FRAC_CONST(0.023347645716133)}, {FRAC_CONST(0.022206969855176), FRAC_CONST(0.023420443132400)},
    {FRAC_CONST(0.022130207861645), FRAC_CONST(0.023492989734537)}, {FRAC_CONST(0.022053208871367), FRAC_CONST(0.023565284745628)}, {FRAC_CONST(0.021975973708940), FRAC_CONST(0.023637327391451)},
    {FRAC_CONST(0.021898503201489), FRAC_CONST(0.023709116900488)}, {FRAC_CONST(0.021820798178663), FRAC_CONST(0.023780652503931)}, {FRAC_CONST(0.021742859472618), FRAC_CONST(0.023851933435691)},
    {FRAC_CONST(0.021664687918017), FRAC_CONST(0.023922958932406)}, {FRAC_CONST(0.021586284352013), FRAC_CONST(0.023993728233451)}, {FRAC_CONST(0.021507649614247), FRAC_CONST(0.024064240580942)},
    {FRAC_CONST(0.021428784546832), FRAC_CONST(0.024134495219750)}, {FRAC_CONST(0.021349689994350), FRAC_CONST(0.024204491397504)}, {FRAC_CONST(0.021270366803840), FRAC_CONST(0.024274228364600)},
    {FRAC_CONST(0.021190815824791), FRAC_CONST(0.024343705374213)}, {FRAC_CONST(0.021111037909128), FRAC_CONST(0.024412921682298)}, {FRAC_CONST(0.021031033911210), FRAC_CONST(0.024481876547605)},
    {FRAC_CONST(0.020950804687815), FRAC_CONST(0.024550569231683)}, {FRAC_CONST(0.020870351098134), FRAC_CONST(0.024618998998889)}, {FRAC_CONST(0.020789674003759), FRAC_CONST(0.024687165116394)},
    {FRAC_CONST(0.020708774268678), FRAC_CONST(0.024755066854194)}, {FRAC_CONST(0.020627652759262), FRAC_CONST(0.024822703485116)}, {FRAC_CONST(0.020546310344257), FRAC_CONST(0.024890074284826)},
    {FRAC_CONST(0.020464747894775), FRAC_CONST(0.024957178531837)}, {FRAC_CONST(0.020382966284284), FRAC_CONST(0.025024015507516)}, {FRAC_CONST(0.020300966388600), FRAC_CONST(0.025090584496093)},
    {FRAC_CONST(0.020218749085876), FRAC_CONST(0.025156884784668)}, {FRAC_CONST(0.020136315256592), FRAC_CONST(0.025222915663218)}, {FRAC_CONST(0.020053665783549), FRAC_CONST(0.025288676424605)},
    {FRAC_CONST(0.019970801551857), FRAC_CONST(0.025354166364584)}, {FRAC_CONST(0.019887723448925), FRAC_CONST(0.025419384781811)}, {FRAC_CONST(0.019804432364452), FRAC_CONST(0.025484330977848)},
    {FRAC_CONST(0.019720929190419), FRAC_CONST(0.025549004257175)}, {FRAC_CONST(0.019637214821078), FRAC_CONST(0.025613403927192)}, {FRAC_CONST(0.019553290152943), FRAC_CONST(0.025677529298230)},
    {FRAC_CONST(0.019469156084779), FRAC_CONST(0.025741379683559)}, {FRAC_CONST(0.019384813517595), FRAC_CONST(0.025804954399392)}, {FRAC_CONST(0.019300263354632), FRAC_CONST(0.025868252764895)},
    {FRAC_CONST(0.019215506501354), FRAC_CONST(0.025931274102193)}, {FRAC_CONST(0.019130543865439), FRAC_CONST(0.025994017736379)}, {FRAC_CONST(0.019045376356769), FRAC_CONST(0.026056482995518)},
    {FRAC_CONST(0.018960004887419), FRAC_CONST(0.026118669210657)}, {FRAC_CONST(0.018874430371648), FRAC_CONST(0.026180575715833)}, {FRAC_CONST(0.018788653725892), FRAC_CONST(0.026242201848076)},
    {FRAC_CONST(0.018702675868750), FRAC_CONST(0.026303546947421)}, {FRAC_CONST(0.018616497720974), FRAC_CONST(0.026364610356909)}, {FRAC_CONST(0.018530120205464), FRAC_CONST(0.026425391422602)},
    {FRAC_CONST(0.018443544247254), FRAC_CONST(0.026485889493583)}, {FRAC_CONST(0.018356770773502), FRAC_CONST(0.026546103921965)}, {FRAC_CONST(0.018269800713483), FRAC_CONST(0.026606034062902)},
    {FRAC_CONST(0.018182634998576), FRAC_CONST(0.026665679274589)}, {FRAC_CONST(0.018095274562256), FRAC_CONST(0.026725038918274)}, {FRAC_CONST(0.018007720340083), FRAC_CONST(0.026784112358263)},
    {FRAC_CONST(0.017919973269692), FRAC_CONST(0.026842898961926)}, {FRAC_CONST(0.017832034290785), FRAC_CONST(0.026901398099707)}, {FRAC_CONST(0.017743904345116), FRAC_CONST(0.026959609145127)},
    {FRAC_CONST(0.017655584376488), FRAC_CONST(0.027017531474792)}, {FRAC_CONST(0.017567075330734), FRAC_CONST(0.027075164468401)}, {FRAC_CONST(0.017478378155718), FRAC_CONST(0.027132507508750)},
    {FRAC_CONST(0.017389493801313), FRAC_CONST(0.027189559981742)}, {FRAC_CONST(0.017300423219401), FRAC_CONST(0.027246321276391)}, {FRAC_CONST(0.017211167363854), FRAC_CONST(0.027302790784828)},
    {FRAC_CONST(0.017121727190533), FRAC_CONST(0.027358967902310)}, {FRAC_CONST(0.017032103657269), FRAC_CONST(0.027414852027226)}, {FRAC_CONST(0.016942297723858), FRAC_CONST(0.027470442561102)},
    {FRAC_CONST(0.016852310352050), FRAC_CONST(0.027525738908608)}, {FRAC_CONST(0.016762142505537), FRAC_CONST(0.027580740477564)}, {FRAC_CONST(0.016671795149944), FRAC_CONST(0.027635446678948)},
    {FRAC_CONST(0.016581269252819), FRAC_CONST(0.027689856926900)}, {FRAC_CONST(0.016490565783622), FRAC_CONST(0.027743970638730)}, {FRAC_CONST(0.016399685713714), FRAC_CONST(0.027797787234924)},
    {FRAC_CONST(0.016308630016347), FRAC_CONST(0.027851306139149)}, {FRAC_CONST(0.016217399666655), FRAC_CONST(0.027904526778260)}, {FRAC_CONST(0.016125995641641), FRAC_CONST(0.027957448582309)},
    {FRAC_CONST(0.016034418920170), FRAC_CONST(0.028010070984544)}, {FRAC_CONST(0.015942670482954), FRAC_CONST(0.028062393421421)}, {FRAC_CONST(0.015850751312545), FRAC_CONST(0.028114415332610)},
    {FRAC_CONST(0.015758662393324), FRAC_CONST(0.028166136160998)}, {FRAC_CONST(0.015666404711489), FRAC_CONST(0.028217555352697)}, {FRAC_CONST(0.015573979255046), FRAC_CONST(0.028268672357047)},
    {FRAC_CONST(0.015481387013797), FRAC_CONST(0.028319486626627)}, {FRAC_CONST(0.015388628979331), FRAC_CONST(0.028369997617257)}, {FRAC_CONST(0.015295706145012), FRAC_CONST(0.028420204788004)},
    {FRAC_CONST(0.015202619505968), FRAC_CONST(0.028470107601191)}, {FRAC_CONST(0.015109370059084), FRAC_CONST(0.028519705522399)}, {FRAC_CONST(0.015015958802984), FRAC_CONST(0.028568998020472)},
    {FRAC_CONST(0.014922386738030), FRAC_CONST(0.028617984567529)}, {FRAC_CONST(0.014828654866302), FRAC_CONST(0.028666664638963)}, {FRAC_CONST(0.014734764191593), FRAC_CONST(0.028715037713449)},
    {FRAC_CONST(0.014640715719398), FRAC_CONST(0.028763103272951)}, {FRAC_CONST(0.014546510456900), FRAC_CONST(0.028810860802724)}, {FRAC_CONST(0.014452149412962), FRAC_CONST(0.028858309791325)},
    {FRAC_CONST(0.014357633598114), FRAC_CONST(0.028905449730613)}, {FRAC_CONST(0.014262964024545), FRAC_CONST(0.028952280115756)}, {FRAC_CONST(0.014168141706090), FRAC_CONST(0.028998800445240)},
    {FRAC_CONST(0.014073167658220), FRAC_CONST(0.029045010220868)}, {FRAC_CONST(0.013978042898030), FRAC_CONST(0.029090908947771)}, {FRAC_CONST(0.013882768444231), FRAC_CONST(0.029136496134411)},
    {FRAC_CONST(0.013787345317136), FRAC_CONST(0.029181771292585)}, {FRAC_CONST(0.013691774538648), FRAC_CONST(0.029226733937433)}, {FRAC_CONST(0.013596057132255), FRAC_CONST(0.029271383587441)},
    {FRAC_CONST(0.013500194123014), FRAC_CONST(0.029315719764447)}, {FRAC_CONST(0.013404186537539), FRAC_CONST(0.029359741993647)}, {FRAC_CONST(0.013308035403995), FRAC_CONST(0.029403449803598)},
    {FRAC_CONST(0.013211741752084), FRAC_CONST(0.029446842726223)}, {FRAC_CONST(0.013115306613032), FRAC_CONST(0.029489920296820)}, {FRAC_CONST(0.013018731019584), FRAC_CONST(0.029532682054063)},
    {FRAC_CONST(0.012922016005985), FRAC_CONST(0.029575127540008)}, {FRAC_CONST(0.012825162607977), FRAC_CONST(0.029617256300097)}, {FRAC_CONST(0.012728171862781), FRAC_CONST(0.029659067883165)},
    {FRAC_CONST(0.012631044809089), FRAC_CONST(0.029700561841444)}, {FRAC_CONST(0.012533782487056), FRAC_CONST(0.029741737730567)}, {FRAC_CONST(0.012436385938281), FRAC_CONST(0.029782595109573)},
    {FRAC_CONST(0.012338856205805), FRAC_CONST(0.029823133540913)}, {FRAC_CONST(0.012241194334091), FRAC_CONST(0.029863352590452)}, {FRAC_CONST(0.012143401369021), FRAC_CONST(0.029903251827477)},
    {FRAC_CONST(0.012045478357878), FRAC_CONST(0.029942830824699)}, {FRAC_CONST(0.011947426349339), FRAC_CONST(0.029982089158259)}, {FRAC_CONST(0.011849246393462), FRAC_CONST(0.030021026407731)},
    {FRAC_CONST(0.011750939541676), FRAC_CONST(0.030059642156129)}, {FRAC_CONST(0.011652506846768), FRAC_CONST(0.030097935989909)}, {FRAC_CONST(0.011553949362874), FRAC_CONST(0.030135907498976)},
    {FRAC_CONST(0.011455268145464), FRAC_CONST(0.030173556276684)}, {FRAC_CONST(0.011356464251335), FRAC_CONST(0.030210881919845)}, {FRAC_CONST(0.011257538738598), FRAC_CONST(0.030247884028732)},
    {FRAC_CONST(0.011158492666665), FRAC_CONST(0.030284562207083)}, {FRAC_CONST(0.011059327096240), FRAC_CONST(0.030320916062102)}, {FRAC_CONST(0.010960043089307), FRAC_CONST(0.030356945204470)},
    {FRAC_CONST(0.010860641709118), FRAC_CONST(0.030392649248343)}, {FRAC_CONST(0.010761124020182), FRAC_CONST(0.030428027811361)}, {FRAC_CONST(0.010661491088253), FRAC_CONST(0.030463080514646)},
    {FRAC_CONST(0.010561743980319), FRAC_CONST(0.030497806982812)}, {FRAC_CONST(0.010461883764593), FRAC_CONST(0.030532206843968)}, {FRAC_CONST(0.010361911510496), FRAC_CONST(0.030566279729717)},
    {FRAC_CONST(0.010261828288652), FRAC_CONST(0.030600025275167)}, {FRAC_CONST(0.010161635170872), FRAC_CONST(0.030633443118931)}, {FRAC_CONST(0.010061333230142), FRAC_CONST(0.030666532903129)},
    {FRAC_CONST(0.009960923540617), FRAC_CONST(0.030699294273397)}, {FRAC_CONST(0.009860407177603), FRAC_CONST(0.030731726878888)}, {FRAC_CONST(0.009759785217550), FRAC_CONST(0.030763830372273)},
    {FRAC_CONST(0.009659058738038), FRAC_CONST(0.030795604409750)}, {FRAC_CONST(0.009558228817767), FRAC_CONST(0.030827048651045)}, {FRAC_CONST(0.009457296536545), FRAC_CONST(0.030858162759415)},
    {FRAC_CONST(0.009356262975275), FRAC_CONST(0.030888946401653)}, {FRAC_CONST(0.009255129215945), FRAC_CONST(0.030919399248091)}, {FRAC_CONST(0.009153896341616), FRAC_CONST(0.030949520972603)},
    {FRAC_CONST(0.009052565436412), FRAC_CONST(0.030979311252611)}, {FRAC_CONST(0.008951137585505), FRAC_CONST(0.031008769769084)}, {FRAC_CONST(0.008849613875105), FRAC_CONST(0.031037896206544)},
    {FRAC_CONST(0.008747995392451), FRAC_CONST(0.031066690253072)}, {FRAC_CONST(0.008646283225794), FRAC_CONST(0.031095151600306)}, {FRAC_CONST(0.008544478464390), FRAC_CONST(0.031123279943448)},
    {FRAC_CONST(0.008442582198486), FRAC_CONST(0.031151074981266)}, {FRAC_CONST(0.008340595519310), FRAC_CONST(0.031178536416098)}, {FRAC_CONST(0.008238519519057), FRAC_CONST(0.031205663953853)},
    {FRAC_CONST(0.008136355290878), FRAC_CONST(0.031232457304017)}, {FRAC_CONST(0.008034103928871), FRAC_CONST(0.031258916179656)}, {FRAC_CONST(0.007931766528065), FRAC_CONST(0.031285040297416)},
    {FRAC_CONST(0.007829344184412), FRAC_CONST(0.031310829377528)}, {FRAC_CONST(0.007726837994772), FRAC_CONST(0.031336283143813)}, {FRAC_CONST(0.007624249056906), FRAC_CONST(0.031361401323680)},
    {FRAC_CONST(0.007521578469457), FRAC_CONST(0.031386183648135)}, {FRAC_CONST(0.007418827331946), FRAC_CONST(0.031410629851778)}, {FRAC_CONST(0.007315996744755), FRAC_CONST(0.031434739672811)},
    {FRAC_CONST(0.007213087809115), FRAC_CONST(0.031458512853036)}, {FRAC_CONST(0.007110101627101), FRAC_CONST(0.031481949137863)}, {FRAC_CONST(0.007007039301610), FRAC_CONST(0.031505048276306)},
    {FRAC_CONST(0.006903901936357), FRAC_CONST(0.031527810020993)}, {FRAC_CONST(0.006800690635862), FRAC_CONST(0.031550234128164)}, {FRAC_CONST(0.006697406505433), FRAC_CONST(0.031572320357675)},
    {FRAC_CONST(0.006594050651161), FRAC_CONST(0.031594068473000)}, {FRAC_CONST(0.006490624179905), FRAC_CONST(0.031615478241233)}, {FRAC_CONST(0.006387128199278), FRAC_CONST(0.031636549433095)},
    {FRAC_CONST(0.006283563817639), FRAC_CONST(0.031657281822929)}, {FRAC_CONST(0.006179932144080), FRAC_CONST(0.031677675188707)}, {FRAC_CONST(0.006076234288412), FRAC_CONST(0.031697729312034)},
    {FRAC_CONST(0.005972471361157), FRAC_CONST(0.031717443978146)}, {FRAC_CONST(0.005868644473532), FRAC_CONST(0.031736818975914)}, {FRAC_CONST(0.005764754737440), FRAC_CONST(0.031755854097848)},
    {FRAC_CONST(0.005660803265456), FRAC_CONST(0.031774549140098)}, {FRAC_CONST(0.005556791170816), FRAC_CONST(0.031792903902453)}, {FRAC_CONST(0.005452719567407), FRAC_CONST(0.031810918188350)},
    {FRAC_CONST(0.005348589569753), FRAC_CONST(0.031828591804869)}, {FRAC_CONST(0.005244402293001), FRAC_CONST(0.031845924562742)}, {FRAC_CONST(0.005140158852914), FRAC_CONST(0.031862916276347)},
    {FRAC_CONST(0.005035860365855), FRAC_CONST(0.031879566763717)}, {FRAC_CONST(0.004931507948778), FRAC_CONST(0.031895875846539)}, {FRAC_CONST(0.004827102719212), FRAC_CONST(0.031911843350155)},
    {FRAC_CONST(0.004722645795254), FRAC_CONST(0.031927469103567)}, {FRAC_CONST(0.004618138295554), FRAC_CONST(0.031942752939435)}, {FRAC_CONST(0.004513581339303), FRAC_CONST(0.031957694694082)},
    {FRAC_CONST(0.004408976046222), FRAC_CONST(0.031972294207493)}, {FRAC_CONST(0.004304323536549), FRAC_CONST(0.031986551323320)}, {FRAC_CONST(0.004199624931030), FRAC_CONST(0.032000465888879)},
    {FRAC_CONST(0.004094881350902), FRAC_CONST(0.032014037755158)}, {FRAC_CONST(0.003990093917884), FRAC_CONST(0.032027266776813)}, {FRAC_CONST(0.003885263754166), FRAC_CONST(0.032040152812170)},
    {FRAC_CONST(0.003780391982394), FRAC_CONST(0.032052695723232)}, {FRAC_CONST(0.003675479725661), FRAC_CONST(0.032064895375674)}, {FRAC_CONST(0.003570528107494), FRAC_CONST(0.032076751638847)},
    {FRAC_CONST(0.003465538251839), FRAC_CONST(0.032088264385780)}, {FRAC_CONST(0.003360511283053), FRAC_CONST(0.032099433493181)}, {FRAC_CONST(0.003255448325892), FRAC_CONST(0.032110258841438)},
    {FRAC_CONST(0.003150350505494), FRAC_CONST(0.032120740314619)}, {FRAC_CONST(0.003045218947373), FRAC_CONST(0.032130877800478)}, {FRAC_CONST(0.002940054777404), FRAC_CONST(0.032140671190449)},
    {FRAC_CONST(0.002834859121810), FRAC_CONST(0.032150120379653)}, {FRAC_CONST(0.002729633107153), FRAC_CONST(0.032159225266897)}, {FRAC_CONST(0.002624377860318), FRAC_CONST(0.032167985754674)},
    {FRAC_CONST(0.002519094508504), FRAC_CONST(0.032176401749168)}, {FRAC_CONST(0.002413784179212), FRAC_CONST(0.032184473160250)}, {FRAC_CONST(0.002308448000231), FRAC_CONST(0.032192199901481)},
    {FRAC_CONST(0.002203087099626), FRAC_CONST(0.032199581890114)}, {FRAC_CONST(0.002097702605728), FRAC_CONST(0.032206619047093)}, {FRAC_CONST(0.001992295647121), FRAC_CONST(0.032213311297057)},
    {FRAC_CONST(0.001886867352628), FRAC_CONST(0.032219658568338)}, {FRAC_CONST(0.001781418851302), FRAC_CONST(0.032225660792960)}, {FRAC_CONST(0.001675951272410), FRAC_CONST(0.032231317906644)},
    {FRAC_CONST(0.001570465745428), FRAC_CONST(0.032236629848809)}, {FRAC_CONST(0.001464963400018), FRAC_CONST(0.032241596562566)}, {FRAC_CONST(0.001359445366028), FRAC_CONST(0.032246217994727)},
    {FRAC_CONST(0.001253912773470), FRAC_CONST(0.032250494095799)}, {FRAC_CONST(0.001148366752513), FRAC_CONST(0.032254424819990)}, {FRAC_CONST(0.001042808433471), FRAC_CONST(0.032258010125204)},
    {FRAC_CONST(0.000937238946789), FRAC_CONST(0.032261249973045)}, {FRAC_CONST(0.000831659423030), FRAC_CONST(0.032264144328817)}, {FRAC_CONST(0.000726070992868), FRAC_CONST(0.032266693161525)},
    {FRAC_CONST(0.000620474787068), FRAC_CONST(0.032268896443871)}, {FRAC_CONST(0.000514871936481), FRAC_CONST(0.032270754152261)}, {FRAC_CONST(0.000409263572030), FRAC_CONST(0.032272266266801)},
    {FRAC_CONST(0.000303650824695), FRAC_CONST(0.032273432771295)}, {FRAC_CONST(0.000198034825504), FRAC_CONST(0.032274253653254)}, {FRAC_CONST(0.000092416705518), FRAC_CONST(0.032274728903884)}};
        #ifdef LD_DEC
/* 240 (N/4) complex twiddle factors */
static const complex_t mdct_tab_960[] = {
    {FRAC_CONST(0.045643531183573), FRAC_CONST(0.000037342034959)}, {FRAC_CONST(0.045642309173789), FRAC_CONST(0.000336075315362)}, {FRAC_CONST(0.045639131999390), FRAC_CONST(0.000634794199417)},
    {FRAC_CONST(0.045633999796474), FRAC_CONST(0.000933485891002)}, {FRAC_CONST(0.045626912784890), FRAC_CONST(0.001232137595157)}, {FRAC_CONST(0.045617871268219), FRAC_CONST(0.001530736518639)},
    {FRAC_CONST(0.045606875633772), FRAC_CONST(0.001829269870464)}, {FRAC_CONST(0.045593926352564), FRAC_CONST(0.002127724862455)}, {FRAC_CONST(0.045579023979299), FRAC_CONST(0.002426088709795)},
    {FRAC_CONST(0.045562169152346), FRAC_CONST(0.002724348631569)}, {FRAC_CONST(0.045543362593709), FRAC_CONST(0.003022491851315)}, {FRAC_CONST(0.045522605108999), FRAC_CONST(0.003320505597570)},
    {FRAC_CONST(0.045499897587396), FRAC_CONST(0.003618377104416)}, {FRAC_CONST(0.045475241001617), FRAC_CONST(0.003916093612031)}, {FRAC_CONST(0.045448636407866), FRAC_CONST(0.004213642367228)},
    {FRAC_CONST(0.045420084945797), FRAC_CONST(0.004511010624011)}, {FRAC_CONST(0.045389587838458), FRAC_CONST(0.004808185644112)}, {FRAC_CONST(0.045357146392244), FRAC_CONST(0.005105154697544)},
    {FRAC_CONST(0.045322761996840), FRAC_CONST(0.005401905063139)}, {FRAC_CONST(0.045286436125157), FRAC_CONST(0.005698424029100)}, {FRAC_CONST(0.045248170333275), FRAC_CONST(0.005994698893542)},
    {FRAC_CONST(0.045207966260374), FRAC_CONST(0.006290716965035)}, {FRAC_CONST(0.045165825628663), FRAC_CONST(0.006586465563151)}, {FRAC_CONST(0.045121750243305), FRAC_CONST(0.006881932019003)},
    {FRAC_CONST(0.045075741992343), FRAC_CONST(0.007177103675792)}, {FRAC_CONST(0.045027802846618), FRAC_CONST(0.007471967889347)}, {FRAC_CONST(0.044977934859683), FRAC_CONST(0.007766512028667)},
    {FRAC_CONST(0.044926140167717), FRAC_CONST(0.008060723476460)}, {FRAC_CONST(0.044872420989432), FRAC_CONST(0.008354589629687)}, {FRAC_CONST(0.044816779625979), FRAC_CONST(0.008648097900101)},
    {FRAC_CONST(0.044759218460849), FRAC_CONST(0.008941235714784)}, {FRAC_CONST(0.044699739959770), FRAC_CONST(0.009233990516688)}, {FRAC_CONST(0.044638346670603), FRAC_CONST(0.009526349765171)},
    {FRAC_CONST(0.044575041223233), FRAC_CONST(0.009818300936537)}, {FRAC_CONST(0.044509826329454), FRAC_CONST(0.010109831524568)}, {FRAC_CONST(0.044442704782856), FRAC_CONST(0.010400929041064)},
    {FRAC_CONST(0.044373679458701), FRAC_CONST(0.010691581016378)}, {FRAC_CONST(0.044302753313806), FRAC_CONST(0.010981774999945)}, {FRAC_CONST(0.044229929386409), FRAC_CONST(0.011271498560822)},
    {FRAC_CONST(0.044155210796046), FRAC_CONST(0.011560739288214)}, {FRAC_CONST(0.044078600743413), FRAC_CONST(0.011849484792012)}, {FRAC_CONST(0.044000102510229), FRAC_CONST(0.012137722703321)},
    {FRAC_CONST(0.043919719459097), FRAC_CONST(0.012425440674986)}, {FRAC_CONST(0.043837455033359), FRAC_CONST(0.012712626382127)}, {FRAC_CONST(0.043753312756950), FRAC_CONST(0.012999267522665)},
    {FRAC_CONST(0.043667296234245), FRAC_CONST(0.013285351817848)}, {FRAC_CONST(0.043579409149906), FRAC_CONST(0.013570867012776)}, {FRAC_CONST(0.043489655268722), FRAC_CONST(0.013855800876928)},
    {FRAC_CONST(0.043398038435451), FRAC_CONST(0.014140141204686)}, {FRAC_CONST(0.043304562574653), FRAC_CONST(0.014423875815857)}, {FRAC_CONST(0.043209231690524), FRAC_CONST(0.014706992556195)},
    {FRAC_CONST(0.043112049866720), FRAC_CONST(0.014989479297920)}, {FRAC_CONST(0.043013021266188), FRAC_CONST(0.015271323940241)}, {FRAC_CONST(0.042912150130984), FRAC_CONST(0.015552514409871)},
    {FRAC_CONST(0.042809440782090), FRAC_CONST(0.015833038661547)}, {FRAC_CONST(0.042704897619235), FRAC_CONST(0.016112884678543)}, {FRAC_CONST(0.042598525120698), FRAC_CONST(0.016392040473187)},
    {FRAC_CONST(0.042490327843124), FRAC_CONST(0.016670494087374)}, {FRAC_CONST(0.042380310421324), FRAC_CONST(0.016948233593079)}, {FRAC_CONST(0.042268477568078), FRAC_CONST(0.017225247092864)},
    {FRAC_CONST(0.042154834073934), FRAC_CONST(0.017501522720393)}, {FRAC_CONST(0.042039384807000), FRAC_CONST(0.017777048640940)}, {FRAC_CONST(0.041922134712739), FRAC_CONST(0.018051813051888)},
    {FRAC_CONST(0.041803088813754), FRAC_CONST(0.018325804183247)}, {FRAC_CONST(0.041682252209576), FRAC_CONST(0.018599010298148)}, {FRAC_CONST(0.041559630076443), FRAC_CONST(0.018871419693350)},
    {FRAC_CONST(0.041435227667079), FRAC_CONST(0.019143020699741)}, {FRAC_CONST(0.041309050310468), FRAC_CONST(0.019413801682838)}, {FRAC_CONST(0.041181103411629), FRAC_CONST(0.019683751043285)},
    {FRAC_CONST(0.041051392451382), FRAC_CONST(0.019952857217350)}, {FRAC_CONST(0.040919922986111), FRAC_CONST(0.020221108677421)}, {FRAC_CONST(0.040786700647532), FRAC_CONST(0.020488493932496)},
    {FRAC_CONST(0.040651731142446), FRAC_CONST(0.020755001528683)}, {FRAC_CONST(0.040515020252497), FRAC_CONST(0.021020620049682)}, {FRAC_CONST(0.040376573833925), FRAC_CONST(0.021285338117280)},
    {FRAC_CONST(0.040236397817314), FRAC_CONST(0.021549144391836)}, {FRAC_CONST(0.040094498207337), FRAC_CONST(0.021812027572768)}, {FRAC_CONST(0.039950881082502), FRAC_CONST(0.022073976399034)},
    {FRAC_CONST(0.039805552594888), FRAC_CONST(0.022334979649620)}, {FRAC_CONST(0.039658518969884), FRAC_CONST(0.022595026144014)}, {FRAC_CONST(0.039509786505922), FRAC_CONST(0.022854104742690)},
    {FRAC_CONST(0.039359361574204), FRAC_CONST(0.023112204347583)}, {FRAC_CONST(0.039207250618434), FRAC_CONST(0.023369313902565)}, {FRAC_CONST(0.039053460154540), FRAC_CONST(0.023625422393919)},
    {FRAC_CONST(0.038897996770393), FRAC_CONST(0.023880518850809)}, {FRAC_CONST(0.038740867125527), FRAC_CONST(0.024134592345752)}, {FRAC_CONST(0.038582077950852), FRAC_CONST(0.024387631995085)},
    {FRAC_CONST(0.038421636048370), FRAC_CONST(0.024639626959432)}, {FRAC_CONST(0.038259548290876), FRAC_CONST(0.024890566444167)}, {FRAC_CONST(0.038095821621671), FRAC_CONST(0.025140439699877)},
    {FRAC_CONST(0.037930463054261), FRAC_CONST(0.025389236022825)}, {FRAC_CONST(0.037763479672055), FRAC_CONST(0.025636944755403)}, {FRAC_CONST(0.037594878628068), FRAC_CONST(0.025883555286595)},
    {FRAC_CONST(0.037424667144605), FRAC_CONST(0.026129057052425)}, {FRAC_CONST(0.037252852512960), FRAC_CONST(0.026373439536415)}, {FRAC_CONST(0.037079442093102), FRAC_CONST(0.026616692270033)},
    {FRAC_CONST(0.036904443313354), FRAC_CONST(0.026858804833142)}, {FRAC_CONST(0.036727863670081), FRAC_CONST(0.027099766854444)}, {FRAC_CONST(0.036549710727369), FRAC_CONST(0.027339568011930)},
    {FRAC_CONST(0.036369992116697), FRAC_CONST(0.027578198033315)}, {FRAC_CONST(0.036188715536611), FRAC_CONST(0.027815646696484)}, {FRAC_CONST(0.036005888752396), FRAC_CONST(0.028051903829926)},
    {FRAC_CONST(0.035821519595745), FRAC_CONST(0.028286959313171)}, {FRAC_CONST(0.035635615964417), FRAC_CONST(0.028520803077226)}, {FRAC_CONST(0.035448185821906), FRAC_CONST(0.028753425105002)},
    {FRAC_CONST(0.035259237197095), FRAC_CONST(0.028984815431745)}, {FRAC_CONST(0.035068778183914), FRAC_CONST(0.029214964145465)}, {FRAC_CONST(0.034876816940994), FRAC_CONST(0.029443861387355)},
    {FRAC_CONST(0.034683361691315), FRAC_CONST(0.029671497352220)}, {FRAC_CONST(0.034488420721856), FRAC_CONST(0.029897862288892)}, {FRAC_CONST(0.034292002383240), FRAC_CONST(0.030122946500652)},
    {FRAC_CONST(0.034094115089375), FRAC_CONST(0.030346740345641)}, {FRAC_CONST(0.033894767317093), FRAC_CONST(0.030569234237276)}, {FRAC_CONST(0.033693967605790), FRAC_CONST(0.030790418644658)},
    {FRAC_CONST(0.033491724557057), FRAC_CONST(0.031010284092984)}, {FRAC_CONST(0.033288046834313), FRAC_CONST(0.031228821163949)}, {FRAC_CONST(0.033082943162434), FRAC_CONST(0.031446020496153)},
    {FRAC_CONST(0.032876422327378), FRAC_CONST(0.031661872785500)}, {FRAC_CONST(0.032668493175811), FRAC_CONST(0.031876368785596)}, {FRAC_CONST(0.032459164614726), FRAC_CONST(0.032089499308145)},
    {FRAC_CONST(0.032248445611061), FRAC_CONST(0.032301255223347)}, {FRAC_CONST(0.032036345191317), FRAC_CONST(0.032511627460281)}, {FRAC_CONST(0.031822872441171), FRAC_CONST(0.032720607007302)},
    {FRAC_CONST(0.031608036505083), FRAC_CONST(0.032928184912422)}, {FRAC_CONST(0.031391846585912), FRAC_CONST(0.033134352283693)}, {FRAC_CONST(0.031174311944513), FRAC_CONST(0.033339100289593)},
    {FRAC_CONST(0.030955441899347), FRAC_CONST(0.033542420159397)}, {FRAC_CONST(0.030735245826077), FRAC_CONST(0.033744303183559)}, {FRAC_CONST(0.030513733157171), FRAC_CONST(0.033944740714083)},
    {FRAC_CONST(0.030290913381494), FRAC_CONST(0.034143724164891)}, {FRAC_CONST(0.030066796043904), FRAC_CONST(0.034341245012195)}, {FRAC_CONST(0.029841390744841), FRAC_CONST(0.034537294794860)},
    {FRAC_CONST(0.029614707139919), FRAC_CONST(0.034731865114764)}, {FRAC_CONST(0.029386754939508), FRAC_CONST(0.034924947637164)}, {FRAC_CONST(0.029157543908322), FRAC_CONST(0.035116534091046)},
    {FRAC_CONST(0.028927083864999), FRAC_CONST(0.035306616269485)}, {FRAC_CONST(0.028695384681680), FRAC_CONST(0.035495186029992)}, {FRAC_CONST(0.028462456283587), FRAC_CONST(0.035682235294866)},
    {FRAC_CONST(0.028228308648598), FRAC_CONST(0.035867756051541)}, {FRAC_CONST(0.027992951806817), FRAC_CONST(0.036051740352923)}, {FRAC_CONST(0.027756395840148), FRAC_CONST(0.036234180317738)},
    {FRAC_CONST(0.027518650881862), FRAC_CONST(0.036415068130865)}, {FRAC_CONST(0.027279727116161), FRAC_CONST(0.036594396043672)}, {FRAC_CONST(0.027039634777745), FRAC_CONST(0.036772156374348)},
    {FRAC_CONST(0.026798384151369), FRAC_CONST(0.036948341508233)}, {FRAC_CONST(0.026555985571409), FRAC_CONST(0.037122943898140)}, {FRAC_CONST(0.026312449421412), FRAC_CONST(0.037295956064686)},
    {FRAC_CONST(0.026067786133656), FRAC_CONST(0.037467370596605)}, {FRAC_CONST(0.025822006188702), FRAC_CONST(0.037637180151068)}, {FRAC_CONST(0.025575120114946), FRAC_CONST(0.037805377454000)},
    {FRAC_CONST(0.025327138488165), FRAC_CONST(0.037971955300388)}, {FRAC_CONST(0.025078071931066), FRAC_CONST(0.038136906554591)}, {FRAC_CONST(0.024827931112832), FRAC_CONST(0.038300224150647)},
    {FRAC_CONST(0.024576726748663), FRAC_CONST(0.038461901092573)}, {FRAC_CONST(0.024324469599317), FRAC_CONST(0.038621930454668)}, {FRAC_CONST(0.024071170470652), FRAC_CONST(0.038780305381806)},
    {FRAC_CONST(0.023816840213160), FRAC_CONST(0.038937019089732)}, {FRAC_CONST(0.023561489721501), FRAC_CONST(0.039092064865353)}, {FRAC_CONST(0.023305129934041), FRAC_CONST(0.039245436067023)},
    {FRAC_CONST(0.023047771832380), FRAC_CONST(0.039397126124832)}, {FRAC_CONST(0.022789426440883), FRAC_CONST(0.039547128540881)}, {FRAC_CONST(0.022530104826206), FRAC_CONST(0.039695436889566)},
    {FRAC_CONST(0.022269818096825), FRAC_CONST(0.039842044817851)}, {FRAC_CONST(0.022008577402555), FRAC_CONST(0.039986946045542)}, {FRAC_CONST(0.021746393934081), FRAC_CONST(0.040130134365550)},
    {FRAC_CONST(0.021483278922467), FRAC_CONST(0.040271603644166)}, {FRAC_CONST(0.021219243638687), FRAC_CONST(0.040411347821316)}, {FRAC_CONST(0.020954299393132), FRAC_CONST(0.040549360910825)},
    {FRAC_CONST(0.020688457535133), FRAC_CONST(0.040685637000671)}, {FRAC_CONST(0.020421729452469), FRAC_CONST(0.040820170253240)}, {FRAC_CONST(0.020154126570884), FRAC_CONST(0.040952954905576)},
    {FRAC_CONST(0.019885660353596), FRAC_CONST(0.041083985269625)}, {FRAC_CONST(0.019616342300802), FRAC_CONST(0.041213255732484)}, {FRAC_CONST(0.019346183949192), FRAC_CONST(0.041340760756635)},
    {FRAC_CONST(0.019075196871451), FRAC_CONST(0.041466494880189)}, {FRAC_CONST(0.018803392675763), FRAC_CONST(0.041590452717113)}, {FRAC_CONST(0.018530783005316), FRAC_CONST(0.041712628957466)},
    {FRAC_CONST(0.018257379537800), FRAC_CONST(0.041833018367625)}, {FRAC_CONST(0.017983193984910), FRAC_CONST(0.041951615790509)}, {FRAC_CONST(0.017708238091842), FRAC_CONST(0.042068416145797)},
    {FRAC_CONST(0.017432523636792), FRAC_CONST(0.042183414430153)}, {FRAC_CONST(0.017156062430449), FRAC_CONST(0.042296605717432)}, {FRAC_CONST(0.016878866315491), FRAC_CONST(0.042407985158896)},
    {FRAC_CONST(0.016600947166078), FRAC_CONST(0.042517547983420)}, {FRAC_CONST(0.016322316887341), FRAC_CONST(0.042625289497698)}, {FRAC_CONST(0.016042987414872), FRAC_CONST(0.042731205086442)},
    {FRAC_CONST(0.015762970714219), FRAC_CONST(0.042835290212581)}, {FRAC_CONST(0.015482278780363), FRAC_CONST(0.042937540417454)}, {FRAC_CONST(0.015200923637213), FRAC_CONST(0.043037951321002)},
    {FRAC_CONST(0.014918917337087), FRAC_CONST(0.043136518621958)}, {FRAC_CONST(0.014636271960196), FRAC_CONST(0.043233238098025)}, {FRAC_CONST(0.014352999614128), FRAC_CONST(0.043328105606063)},
    {FRAC_CONST(0.014069112433327), FRAC_CONST(0.043421117082265)}, {FRAC_CONST(0.013784622578575), FRAC_CONST(0.043512268542327)}, {FRAC_CONST(0.013499542236471), FRAC_CONST(0.043601556081625)},
    {FRAC_CONST(0.013213883618907), FRAC_CONST(0.043688975875378)}, {FRAC_CONST(0.012927658962548), FRAC_CONST(0.043774524178812)}, {FRAC_CONST(0.012640880528305), FRAC_CONST(0.043858197327323)},
    {FRAC_CONST(0.012353560600813), FRAC_CONST(0.043939991736633)}, {FRAC_CONST(0.012065711487901), FRAC_CONST(0.044019903902940)}, {FRAC_CONST(0.011777345520066), FRAC_CONST(0.044097930403073)},
    {FRAC_CONST(0.011488475049948), FRAC_CONST(0.044174067894638)}, {FRAC_CONST(0.011199112451794), FRAC_CONST(0.044248313116156)}, {FRAC_CONST(0.010909270120937), FRAC_CONST(0.044320662887211)},
    {FRAC_CONST(0.010618960473257), FRAC_CONST(0.044391114108577)}, {FRAC_CONST(0.010328195944653), FRAC_CONST(0.044459663762361)}, {FRAC_CONST(0.010036988990509), FRAC_CONST(0.044526308912122)},
    {FRAC_CONST(0.009745352085163), FRAC_CONST(0.044591046703005)}, {FRAC_CONST(0.009453297721368), FRAC_CONST(0.044653874361857)}, {FRAC_CONST(0.009160838409762), FRAC_CONST(0.044714789197351)},
    {FRAC_CONST(0.008867986678328), FRAC_CONST(0.044773788600099)}, {FRAC_CONST(0.008574755071860), FRAC_CONST(0.044830870042761)}, {FRAC_CONST(0.008281156151424), FRAC_CONST(0.044886031080160)},
    {FRAC_CONST(0.007987202493820), FRAC_CONST(0.044939269349379)}, {FRAC_CONST(0.007692906691044), FRAC_CONST(0.044990582569869)}, {FRAC_CONST(0.007398281349750), FRAC_CONST(0.045039968543542)},
    {FRAC_CONST(0.007103339090706), FRAC_CONST(0.045087425154868)}, {FRAC_CONST(0.006808092548258), FRAC_CONST(0.045132950370962)}, {FRAC_CONST(0.006512554369783), FRAC_CONST(0.045176542241676)},
    {FRAC_CONST(0.006216737215155), FRAC_CONST(0.045218198899680)}, {FRAC_CONST(0.005920653756196), FRAC_CONST(0.045257918560541)}, {FRAC_CONST(0.005624316676135), FRAC_CONST(0.045295699522801)},
    {FRAC_CONST(0.005327738669067), FRAC_CONST(0.045331540168049)}, {FRAC_CONST(0.005030932439406), FRAC_CONST(0.045365438960992)}, {FRAC_CONST(0.004733910701344), FRAC_CONST(0.045397394449517)},
    {FRAC_CONST(0.004436686178303), FRAC_CONST(0.045427405264758)}, {FRAC_CONST(0.004139271602393), FRAC_CONST(0.045455470121152)}, {FRAC_CONST(0.003841679713863), FRAC_CONST(0.045481587816494)},
    {FRAC_CONST(0.003543923260561), FRAC_CONST(0.045505757231988)}, {FRAC_CONST(0.003246014997382), FRAC_CONST(0.045527977332297)}, {FRAC_CONST(0.002947967685724), FRAC_CONST(0.045548247165585)},
    {FRAC_CONST(0.002649794092941), FRAC_CONST(0.045566565863562)}, {FRAC_CONST(0.002351506991799), FRAC_CONST(0.045582932641515)}, {FRAC_CONST(0.002053119159924), FRAC_CONST(0.045597346798344)},
    {FRAC_CONST(0.001754643379257), FRAC_CONST(0.045609807716597)}, {FRAC_CONST(0.001456092435508), FRAC_CONST(0.045620314862489)}, {FRAC_CONST(0.001157479117605), FRAC_CONST(0.045628867785927)},
    {FRAC_CONST(0.000858816217149), FRAC_CONST(0.045635466120535)}, {FRAC_CONST(0.000560116527865), FRAC_CONST(0.045640109583661)}, {FRAC_CONST(0.000261392845053), FRAC_CONST(0.045642797976394)}};
        #endif // LD_DEC
/* 60 (N/4) complex twiddle factors */
static const complex_t mdct_tab_240[] = {
    {FRAC_CONST(0.091286604111815), FRAC_CONST(0.000298735779793)}, {FRAC_CONST(0.091247502481454), FRAC_CONST(0.002688238127538)}, {FRAC_CONST(0.091145864370807), FRAC_CONST(0.005075898091152)},
    {FRAC_CONST(0.090981759437558), FRAC_CONST(0.007460079287760)}, {FRAC_CONST(0.090755300151030), FRAC_CONST(0.009839147718664)}, {FRAC_CONST(0.090466641715108), FRAC_CONST(0.012211472889198)},
    {FRAC_CONST(0.090115981961863), FRAC_CONST(0.014575428926191)}, {FRAC_CONST(0.089703561215976), FRAC_CONST(0.016929395692256)}, {FRAC_CONST(0.089229662130024), FRAC_CONST(0.019271759896156)},
    {FRAC_CONST(0.088694609490769), FRAC_CONST(0.021600916198470)}, {FRAC_CONST(0.088098769996564), FRAC_CONST(0.023915268311810)}, {FRAC_CONST(0.087442552006035), FRAC_CONST(0.026213230094844)},
    {FRAC_CONST(0.086726405258214), FRAC_CONST(0.028493226639351)}, {FRAC_CONST(0.085950820564309), FRAC_CONST(0.030753695349588)}, {FRAC_CONST(0.085116329471329), FRAC_CONST(0.032993087013213)},
    {FRAC_CONST(0.084223503897785), FRAC_CONST(0.035209866863042)}, {FRAC_CONST(0.083272955741727), FRAC_CONST(0.037402515628894)}, {FRAC_CONST(0.082265336461381), FRAC_CONST(0.039569530578832)},
    {FRAC_CONST(0.081201336628670), FRAC_CONST(0.041709426549053)}, {FRAC_CONST(0.080081685455930), FRAC_CONST(0.043820736961749)}, {FRAC_CONST(0.078907150296148), FRAC_CONST(0.045902014830227)},
    {FRAC_CONST(0.077678536117054), FRAC_CONST(0.047951833750597)}, {FRAC_CONST(0.076396684949434), FRAC_CONST(0.049968788879362)}, {FRAC_CONST(0.075062475310050), FRAC_CONST(0.051951497896226)},
    {FRAC_CONST(0.073676821599542), FRAC_CONST(0.053898601951466)}, {FRAC_CONST(0.072240673475749), FRAC_CONST(0.055808766597225)}, {FRAC_CONST(0.070755015202858), FRAC_CONST(0.057680682702068)},
    {FRAC_CONST(0.069220864976840), FRAC_CONST(0.059513067348201)}, {FRAC_CONST(0.067639274227625), FRAC_CONST(0.061304664710718)}, {FRAC_CONST(0.066011326898512), FRAC_CONST(0.063054246918278)},
    {FRAC_CONST(0.064338138703282), FRAC_CONST(0.064760614894630)}, {FRAC_CONST(0.062620856361546), FRAC_CONST(0.066422599180399)}, {FRAC_CONST(0.060860656812842), FRAC_CONST(0.068039060734572)},
    {FRAC_CONST(0.059058746410016), FRAC_CONST(0.069608891715145)}, {FRAC_CONST(0.057216360092450), FRAC_CONST(0.071131016238378)}, {FRAC_CONST(0.055334760539699), FRAC_CONST(0.072604391116154)},
    {FRAC_CONST(0.053415237306106), FRAC_CONST(0.074028006570930)}, {FRAC_CONST(0.051459105937014), FRAC_CONST(0.075400886927784)}, {FRAC_CONST(0.049467707067153), FRAC_CONST(0.076722091283096)},
    {FRAC_CONST(0.047442405501835), FRAC_CONST(0.077990714149396)}, {FRAC_CONST(0.045384589281588), FRAC_CONST(0.079205886075941)}, {FRAC_CONST(0.043295668730857), FRAC_CONST(0.080366774244592)},
    {FRAC_CONST(0.041177075491445), FRAC_CONST(0.081472583040586)}, {FRAC_CONST(0.039030261541332), FRAC_CONST(0.082522554597810)}, {FRAC_CONST(0.036856698199564), FRAC_CONST(0.083515969318206)},
    {FRAC_CONST(0.034657875117883), FRAC_CONST(0.084452146364948)}, {FRAC_CONST(0.032435299259796), FRAC_CONST(0.085330444129049)}, {FRAC_CONST(0.030190493867775), FRAC_CONST(0.086150260669096)},
    {FRAC_CONST(0.027924997419306), FRAC_CONST(0.086911034123781)}, {FRAC_CONST(0.025640362572491), FRAC_CONST(0.087612243096981)}, {FRAC_CONST(0.023338155101933), FRAC_CONST(0.088253407015092)},
    {FRAC_CONST(0.021019952825636), FRAC_CONST(0.088834086456390)}, {FRAC_CONST(0.018687344523641), FRAC_CONST(0.089353883452193)}, {FRAC_CONST(0.016341928849164), FRAC_CONST(0.089812441759604)},
    {FRAC_CONST(0.013985313232951), FRAC_CONST(0.090209447105664)}, {FRAC_CONST(0.011619112781631), FRAC_CONST(0.090544627402740)}, {FRAC_CONST(0.009244949170797), FRAC_CONST(0.090817752935000)},
    {FRAC_CONST(0.006864449533597), FRAC_CONST(0.091028636515846)}, {FRAC_CONST(0.004479245345574), FRAC_CONST(0.091177133616206)}, {FRAC_CONST(0.002090971306534), FRAC_CONST(0.091263142463585)}};
    #endif     // ALLOW_SMALL_FRAMELENGTH
    #ifdef SSR_DEC
/* 128 (N/4) complex twiddle factors */
static const complex_t mdct_tab_512[] = {
    {FRAC_CONST(0.062499926465731), FRAC_CONST(0.000095873761643)}, {FRAC_CONST(0.062494043817678), FRAC_CONST(0.000862836783004)}, {FRAC_CONST(0.062478749796497), FRAC_CONST(0.001629669864319)},
    {FRAC_CONST(0.062454046705412), FRAC_CONST(0.002396257523347)}, {FRAC_CONST(0.062419938264617), FRAC_CONST(0.003162484314806)}, {FRAC_CONST(0.062376429610718), FRAC_CONST(0.003928234847760)},
    {FRAC_CONST(0.062323527295958), FRAC_CONST(0.004693393802995)}, {FRAC_CONST(0.062261239287231), FRAC_CONST(0.005457845950387)}, {FRAC_CONST(0.062189574964882), FRAC_CONST(0.006221476166254)},
    {FRAC_CONST(0.062108545121295), FRAC_CONST(0.006984169450695)}, {FRAC_CONST(0.062018161959266), FRAC_CONST(0.007745810944907)}, {FRAC_CONST(0.061918439090167), FRAC_CONST(0.008506285948482)},
    {FRAC_CONST(0.061809391531894), FRAC_CONST(0.009265479936681)}, {FRAC_CONST(0.061691035706609), FRAC_CONST(0.010023278577683)}, {FRAC_CONST(0.061563389438265), FRAC_CONST(0.010779567749800)},
    {FRAC_CONST(0.061426471949919), FRAC_CONST(0.011534233558664)}, {FRAC_CONST(0.061280303860842), FRAC_CONST(0.012287162354380)}, {FRAC_CONST(0.061124907183410), FRAC_CONST(0.013038240748641)},
    {FRAC_CONST(0.060960305319791), FRAC_CONST(0.013787355631805)}, {FRAC_CONST(0.060786523058421), FRAC_CONST(0.014534394189923)}, {FRAC_CONST(0.060603586570268), FRAC_CONST(0.015279243921739)},
    {FRAC_CONST(0.060411523404896), FRAC_CONST(0.016021792655621)}, {FRAC_CONST(0.060210362486310), FRAC_CONST(0.016761928566463)}, {FRAC_CONST(0.060000134108604), FRAC_CONST(0.017499540192517)},
    {FRAC_CONST(0.059780869931400), FRAC_CONST(0.018234516452187)}, {FRAC_CONST(0.059552602975075), FRAC_CONST(0.018966746660751)}, {FRAC_CONST(0.059315367615794), FRAC_CONST(0.019696120547033)},
    {FRAC_CONST(0.059069199580329), FRAC_CONST(0.020422528270008)}, {FRAC_CONST(0.058814135940681), FRAC_CONST(0.021145860435346)}, {FRAC_CONST(0.058550215108495), FRAC_CONST(0.021866008111883)},
    {FRAC_CONST(0.058277476829279), FRAC_CONST(0.022582862848028)}, {FRAC_CONST(0.057995962176414), FRAC_CONST(0.023296316688095)}, {FRAC_CONST(0.057705713544970), FRAC_CONST(0.024006262188558)},
    {FRAC_CONST(0.057406774645326), FRAC_CONST(0.024712592434239)}, {FRAC_CONST(0.057099190496578), FRAC_CONST(0.025415201054398)}, {FRAC_CONST(0.056783007419769), FRAC_CONST(0.026113982238763)},
    {FRAC_CONST(0.056458273030907), FRAC_CONST(0.026808830753458)}, {FRAC_CONST(0.056125036233796), FRAC_CONST(0.027499641956852)}, {FRAC_CONST(0.055783347212673), FRAC_CONST(0.028186311815319)},
    {FRAC_CONST(0.055433257424646), FRAC_CONST(0.028868736918904)}, {FRAC_CONST(0.055074819591951), FRAC_CONST(0.029546814496896)}, {FRAC_CONST(0.054708087694007), FRAC_CONST(0.030220442433307)},
    {FRAC_CONST(0.054333116959288), FRAC_CONST(0.030889519282247)}, {FRAC_CONST(0.053949963857008), FRAC_CONST(0.031553944283204)}, {FRAC_CONST(0.053558686088614), FRAC_CONST(0.032213617376216)},
    {FRAC_CONST(0.053159342579100), FRAC_CONST(0.032868439216943)}, {FRAC_CONST(0.052751993468129), FRAC_CONST(0.033518311191623)}, {FRAC_CONST(0.052336700100979), FRAC_CONST(0.034163135431927)},
    {FRAC_CONST(0.051913525019303), FRAC_CONST(0.034802814829698)}, {FRAC_CONST(0.051482531951712), FRAC_CONST(0.035437253051569)}, {FRAC_CONST(0.051043785804177), FRAC_CONST(0.036066354553480)},
    {FRAC_CONST(0.050597352650253), FRAC_CONST(0.036690024595057)}, {FRAC_CONST(0.050143299721132), FRAC_CONST(0.037308169253887)}, {FRAC_CONST(0.049681695395515), FRAC_CONST(0.037920695439658)},
    {FRAC_CONST(0.049212609189314), FRAC_CONST(0.038527510908178)}, {FRAC_CONST(0.048736111745188), FRAC_CONST(0.039128524275271)}, {FRAC_CONST(0.048252274821899), FRAC_CONST(0.039723645030535)},
    {FRAC_CONST(0.047761171283507), FRAC_CONST(0.040312783550971)}, {FRAC_CONST(0.047262875088400), FRAC_CONST(0.040895851114488)}, {FRAC_CONST(0.046757461278150), FRAC_CONST(0.041472759913252)},
    {FRAC_CONST(0.046245005966220), FRAC_CONST(0.042043423066923)}, {FRAC_CONST(0.045725586326493), FRAC_CONST(0.042607754635728)}, {FRAC_CONST(0.045199280581658), FRAC_CONST(0.043165669633408)},
    {FRAC_CONST(0.044666167991423), FRAC_CONST(0.043717084040018)}, {FRAC_CONST(0.044126328840584), FRAC_CONST(0.044261914814575)}, {FRAC_CONST(0.043579844426930), FRAC_CONST(0.044800079907569)},
    {FRAC_CONST(0.043026797049006), FRAC_CONST(0.045331498273316)}, {FRAC_CONST(0.042467269993710), FRAC_CONST(0.045856089882166)}, {FRAC_CONST(0.041901347523761), FRAC_CONST(0.046373775732552)},
    {FRAC_CONST(0.041329114865000), FRAC_CONST(0.046884477862888)}, {FRAC_CONST(0.040750658193560), FRAC_CONST(0.047388119363313)}, {FRAC_CONST(0.040166064622889), FRAC_CONST(0.047884624387270)},
    {FRAC_CONST(0.039575422190629), FRAC_CONST(0.048373918162926)}, {FRAC_CONST(0.038978819845356), FRAC_CONST(0.048855927004441)}, {FRAC_CONST(0.038376347433190), FRAC_CONST(0.049330578323055)},
    {FRAC_CONST(0.037768095684260), FRAC_CONST(0.049797800638026)}, {FRAC_CONST(0.037154156199042), FRAC_CONST(0.050257523587392)}, {FRAC_CONST(0.036534621434563), FRAC_CONST(0.050709677938566)},
    {FRAC_CONST(0.035909584690482), FRAC_CONST(0.051154195598769)}, {FRAC_CONST(0.035279140095032), FRAC_CONST(0.051591009625274)}, {FRAC_CONST(0.034643382590851), FRAC_CONST(0.052020054235496)},
    {FRAC_CONST(0.034002407920680), FRAC_CONST(0.052441264816895)}, {FRAC_CONST(0.033356312612947), FRAC_CONST(0.052854577936706)}, {FRAC_CONST(0.032705193967229), FRAC_CONST(0.053259931351495)},
    {FRAC_CONST(0.032049150039598), FRAC_CONST(0.053657264016528)}, {FRAC_CONST(0.031388279627857), FRAC_CONST(0.054046516094966)}, {FRAC_CONST(0.030722682256659), FRAC_CONST(0.054427628966880)},
    {FRAC_CONST(0.030052458162521), FRAC_CONST(0.054800545238072)}, {FRAC_CONST(0.029377708278725), FRAC_CONST(0.055165208748723)}, {FRAC_CONST(0.028698534220122), FRAC_CONST(0.055521564581850)},
    {FRAC_CONST(0.028015038267826), FRAC_CONST(0.055869559071575)}, {FRAC_CONST(0.027327323353815), FRAC_CONST(0.056209139811209)}, {FRAC_CONST(0.026635493045425), FRAC_CONST(0.056540255661140)},
    {FRAC_CONST(0.025939651529755), FRAC_CONST(0.056862856756541)}, {FRAC_CONST(0.025239903597978), FRAC_CONST(0.057176894514872)}, {FRAC_CONST(0.024536354629559), FRAC_CONST(0.057482321643202)},
    {FRAC_CONST(0.023829110576385), FRAC_CONST(0.057779092145329)}, {FRAC_CONST(0.023118277946808), FRAC_CONST(0.058067161328707)}, {FRAC_CONST(0.022403963789609), FRAC_CONST(0.058346485811177)},
    {FRAC_CONST(0.021686275677870), FRAC_CONST(0.058617023527499)}, {FRAC_CONST(0.020965321692783), FRAC_CONST(0.058878733735689)}, {FRAC_CONST(0.020241210407366), FRAC_CONST(0.059131577023150)},
    {FRAC_CONST(0.019514050870114), FRAC_CONST(0.059375515312615)}, {FRAC_CONST(0.018783952588580), FRAC_CONST(0.059610511867874)}, {FRAC_CONST(0.018051025512878), FRAC_CONST(0.059836531299311)},
    {FRAC_CONST(0.017315380019131), FRAC_CONST(0.060053539569230)}, {FRAC_CONST(0.016577126892844), FRAC_CONST(0.060261503996984)}, {FRAC_CONST(0.015836377312223), FRAC_CONST(0.060460393263896)},
    {FRAC_CONST(0.015093242831429), FRAC_CONST(0.060650177417972)}, {FRAC_CONST(0.014347835363782), FRAC_CONST(0.060830827878419)}, {FRAC_CONST(0.013600267164905), FRAC_CONST(0.061002317439940)},
    {FRAC_CONST(0.012850650815819), FRAC_CONST(0.061164620276839)}, {FRAC_CONST(0.012099099205988), FRAC_CONST(0.061317711946905)}, {FRAC_CONST(0.011345725516320), FRAC_CONST(0.061461569395097)},
    {FRAC_CONST(0.010590643202123), FRAC_CONST(0.061596170957011)}, {FRAC_CONST(0.009833965976015), FRAC_CONST(0.061721496362147)}, {FRAC_CONST(0.009075807790803), FRAC_CONST(0.061837526736961)},
    {FRAC_CONST(0.008316282822321), FRAC_CONST(0.061944244607705)}, {FRAC_CONST(0.007555505452236), FRAC_CONST(0.062041633903059)}, {FRAC_CONST(0.006793590250821), FRAC_CONST(0.062129679956555)},
    {FRAC_CONST(0.006030651959703), FRAC_CONST(0.062208369508780)}, {FRAC_CONST(0.005266805474583), FRAC_CONST(0.062277690709378)}, {FRAC_CONST(0.004502165827931), FRAC_CONST(0.062337633118830)},
    {FRAC_CONST(0.003736848171665), FRAC_CONST(0.062388187710030)}, {FRAC_CONST(0.002970967759810), FRAC_CONST(0.062429346869643)}, {FRAC_CONST(0.002204639931138), FRAC_CONST(0.062461104399250)},
    {FRAC_CONST(0.001437980091802), FRAC_CONST(0.062483455516285)}, {FRAC_CONST(0.000671103697954), FRAC_CONST(0.062496396854751)}};
/* 16 (N/4) complex twiddle factors */
static const complex_t mdct_tab_64[] = {
    {FRAC_CONST(0.176763384336599), FRAC_CONST(0.002169321984356)}, {FRAC_CONST(0.175699589589310), FRAC_CONST(0.019484717553714)}, {FRAC_CONST(0.172943711747111), FRAC_CONST(0.036612464641599)},
    {FRAC_CONST(0.168522291420137), FRAC_CONST(0.053387613680577)}, {FRAC_CONST(0.162477909303132), FRAC_CONST(0.069648610815172)}, {FRAC_CONST(0.154868776100077), FRAC_CONST(0.085238853753814)},
    {FRAC_CONST(0.145768171923295), FRAC_CONST(0.100008199934509)}, {FRAC_CONST(0.135263740565902), FRAC_CONST(0.113814412479792)}, {FRAC_CONST(0.123456645444178), FRAC_CONST(0.126524530015608)},
    {FRAC_CONST(0.110460595338559), FRAC_CONST(0.138016147162030)}, {FRAC_CONST(0.096400749315926), FRAC_CONST(0.148178593363981)}, {FRAC_CONST(0.081412511379371), FRAC_CONST(0.156913998709178)},
    {FRAC_CONST(0.065640226453626), FRAC_CONST(0.164138236468888)}, {FRAC_CONST(0.049235790264535), FRAC_CONST(0.169781733284316)}, {FRAC_CONST(0.032357186500177), FRAC_CONST(0.173790139196080)},
    {FRAC_CONST(0.015166965341583), FRAC_CONST(0.176124851064031)}};
    #endif // SSR_DEC
#endif     // FIXED_POINT
// ——————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
static const real_t kbd_long_1024[] = {
    FRAC_CONST(0.00029256153896361), FRAC_CONST(0.00042998567353047), FRAC_CONST(0.00054674074589540), FRAC_CONST(0.00065482304299792), FRAC_CONST(0.00075870195068747),
    FRAC_CONST(0.00086059331713336), FRAC_CONST(0.00096177541439010), FRAC_CONST(0.0010630609410878),  FRAC_CONST(0.0011650036308132),  FRAC_CONST(0.0012680012194148),
    FRAC_CONST(0.0013723517232956),  FRAC_CONST(0.0014782864109136),  FRAC_CONST(0.0015859901976719),  FRAC_CONST(0.0016956148252373),  FRAC_CONST(0.0018072876903517),
    FRAC_CONST(0.0019211179405514),  FRAC_CONST(0.0020372007924215),  FRAC_CONST(0.0021556206591754),  FRAC_CONST(0.0022764534599614),  FRAC_CONST(0.0023997683540995),
    FRAC_CONST(0.0025256290631156),  FRAC_CONST(0.0026540948920831),  FRAC_CONST(0.0027852215281403),  FRAC_CONST(0.0029190616715331),  FRAC_CONST(0.0030556655443223),
    FRAC_CONST(0.0031950812943391),  FRAC_CONST(0.0033373553240392),  FRAC_CONST(0.0034825325586930),  FRAC_CONST(0.0036306566699199),  FRAC_CONST(0.0037817702604646),
    FRAC_CONST(0.0039359150179719),  FRAC_CONST(0.0040931318437260),  FRAC_CONST(0.0042534609610026),  FRAC_CONST(0.0044169420066964),  FRAC_CONST(0.0045836141091341),
    FRAC_CONST(0.0047535159544086),  FRAC_CONST(0.0049266858431214),  FRAC_CONST(0.0051031617390698),  FRAC_CONST(0.0052829813111335),  FRAC_CONST(0.0054661819693975),
    FRAC_CONST(0.0056528008963682),  FRAC_CONST(0.0058428750739943),  FRAC_CONST(0.0060364413070882),  FRAC_CONST(0.0062335362436492),  FRAC_CONST(0.0064341963925079),
    FRAC_CONST(0.0066384581386503),  FRAC_CONST(0.0068463577565218),  FRAC_CONST(0.0070579314215715),  FRAC_CONST(0.0072732152202559),  FRAC_CONST(0.0074922451586909),
    FRAC_CONST(0.0077150571701162),  FRAC_CONST(0.0079416871213115),  FRAC_CONST(0.0081721708180857),  FRAC_CONST(0.0084065440099458),  FRAC_CONST(0.0086448423940363),
    FRAC_CONST(0.0088871016184291),  FRAC_CONST(0.0091333572848345),  FRAC_CONST(0.0093836449507939),  FRAC_CONST(0.0096380001314086),  FRAC_CONST(0.0098964583006517),
    FRAC_CONST(0.010159054892306),   FRAC_CONST(0.010425825300561),   FRAC_CONST(0.010696804880310),   FRAC_CONST(0.010972028947167),   FRAC_CONST(0.011251532777236),
    FRAC_CONST(0.011535351606646),   FRAC_CONST(0.011823520630897),   FRAC_CONST(0.012116075003993),   FRAC_CONST(0.012413049837429),   FRAC_CONST(0.012714480198999),
    FRAC_CONST(0.013020401111478),   FRAC_CONST(0.013330847551161),   FRAC_CONST(0.013645854446288),   FRAC_CONST(0.013965456675352),   FRAC_CONST(0.014289689065314),
    FRAC_CONST(0.014618586389712),   FRAC_CONST(0.014952183366697),   FRAC_CONST(0.015290514656976),   FRAC_CONST(0.015633614861688),   FRAC_CONST(0.015981518520214),
    FRAC_CONST(0.016334260107915),   FRAC_CONST(0.016691874033817),   FRAC_CONST(0.017054394638241),   FRAC_CONST(0.017421856190380),   FRAC_CONST(0.017794292885832),
    FRAC_CONST(0.018171738844085),   FRAC_CONST(0.018554228105962),   FRAC_CONST(0.018941794631032),   FRAC_CONST(0.019334472294980),   FRAC_CONST(0.019732294886947),
    FRAC_CONST(0.020135296106839),   FRAC_CONST(0.020543509562604),   FRAC_CONST(0.020956968767488),   FRAC_CONST(0.021375707137257),   FRAC_CONST(0.021799757987407),
    FRAC_CONST(0.022229154530343),   FRAC_CONST(0.022663929872540),   FRAC_CONST(0.023104117011689),   FRAC_CONST(0.023549748833816),   FRAC_CONST(0.024000858110398),
    FRAC_CONST(0.024457477495451),   FRAC_CONST(0.024919639522613),   FRAC_CONST(0.025387376602207),   FRAC_CONST(0.025860721018295),   FRAC_CONST(0.026339704925726),
    FRAC_CONST(0.026824360347160),   FRAC_CONST(0.027314719170100),   FRAC_CONST(0.027810813143900),   FRAC_CONST(0.028312673876775),   FRAC_CONST(0.028820332832801),
    FRAC_CONST(0.029333821328905),   FRAC_CONST(0.029853170531859),   FRAC_CONST(0.030378411455255),   FRAC_CONST(0.030909574956490),   FRAC_CONST(0.031446691733739),
    FRAC_CONST(0.031989792322926),   FRAC_CONST(0.032538907094693),   FRAC_CONST(0.033094066251369),   FRAC_CONST(0.033655299823935),   FRAC_CONST(0.034222637668991),
    FRAC_CONST(0.034796109465717),   FRAC_CONST(0.035375744712844),   FRAC_CONST(0.035961572725616),   FRAC_CONST(0.036553622632758),   FRAC_CONST(0.037151923373446),
    FRAC_CONST(0.037756503694277),   FRAC_CONST(0.038367392146243),   FRAC_CONST(0.038984617081711),   FRAC_CONST(0.039608206651398),   FRAC_CONST(0.040238188801359),
    FRAC_CONST(0.040874591269976),   FRAC_CONST(0.041517441584950),   FRAC_CONST(0.042166767060301),   FRAC_CONST(0.042822594793376),   FRAC_CONST(0.043484951661852),
    FRAC_CONST(0.044153864320760),   FRAC_CONST(0.044829359199509),   FRAC_CONST(0.045511462498913),   FRAC_CONST(0.046200200188234),   FRAC_CONST(0.046895598002228),
    FRAC_CONST(0.047597681438201),   FRAC_CONST(0.048306475753074),   FRAC_CONST(0.049022005960455),   FRAC_CONST(0.049744296827725),   FRAC_CONST(0.050473372873129),
    FRAC_CONST(0.051209258362879),   FRAC_CONST(0.051951977308273),   FRAC_CONST(0.052701553462813),   FRAC_CONST(0.053458010319350),   FRAC_CONST(0.054221371107223),
    FRAC_CONST(0.054991658789428),   FRAC_CONST(0.055768896059787),   FRAC_CONST(0.056553105340134),   FRAC_CONST(0.057344308777513),   FRAC_CONST(0.058142528241393),
    FRAC_CONST(0.058947785320893),   FRAC_CONST(0.059760101322019),   FRAC_CONST(0.060579497264926),   FRAC_CONST(0.061405993881180),   FRAC_CONST(0.062239611611049),
    FRAC_CONST(0.063080370600799),   FRAC_CONST(0.063928290700012),   FRAC_CONST(0.064783391458919),   FRAC_CONST(0.065645692125747),   FRAC_CONST(0.066515211644086),
    FRAC_CONST(0.067391968650269),   FRAC_CONST(0.068275981470777),   FRAC_CONST(0.069167268119652),   FRAC_CONST(0.070065846295935),   FRAC_CONST(0.070971733381121),
    FRAC_CONST(0.071884946436630),   FRAC_CONST(0.072805502201299),   FRAC_CONST(0.073733417088896),   FRAC_CONST(0.074668707185649),   FRAC_CONST(0.075611388247794),
    FRAC_CONST(0.076561475699152),   FRAC_CONST(0.077518984628715),   FRAC_CONST(0.078483929788261),   FRAC_CONST(0.079456325589986),   FRAC_CONST(0.080436186104162),
    FRAC_CONST(0.081423525056808),   FRAC_CONST(0.082418355827392),   FRAC_CONST(0.083420691446553),   FRAC_CONST(0.084430544593841),   FRAC_CONST(0.085447927595483),
    FRAC_CONST(0.086472852422178),   FRAC_CONST(0.087505330686900),   FRAC_CONST(0.088545373642744),   FRAC_CONST(0.089592992180780),   FRAC_CONST(0.090648196827937),
    FRAC_CONST(0.091710997744919),   FRAC_CONST(0.092781404724131),   FRAC_CONST(0.093859427187640),   FRAC_CONST(0.094945074185163),   FRAC_CONST(0.096038354392069),
    FRAC_CONST(0.097139276107423),   FRAC_CONST(0.098247847252041),   FRAC_CONST(0.099364075366580),   FRAC_CONST(0.10048796760965),    FRAC_CONST(0.10161953075597),
    FRAC_CONST(0.10275877119451),    FRAC_CONST(0.10390569492671),    FRAC_CONST(0.10506030756469),    FRAC_CONST(0.10622261432949),    FRAC_CONST(0.10739262004941),
    FRAC_CONST(0.10857032915821),    FRAC_CONST(0.10975574569357),    FRAC_CONST(0.11094887329534),    FRAC_CONST(0.11214971520402),    FRAC_CONST(0.11335827425914),
    FRAC_CONST(0.11457455289772),    FRAC_CONST(0.11579855315274),    FRAC_CONST(0.11703027665170),    FRAC_CONST(0.11826972461510),    FRAC_CONST(0.11951689785504),
    FRAC_CONST(0.12077179677383),    FRAC_CONST(0.12203442136263),    FRAC_CONST(0.12330477120008),    FRAC_CONST(0.12458284545102),    FRAC_CONST(0.12586864286523),
    FRAC_CONST(0.12716216177615),    FRAC_CONST(0.12846340009971),    FRAC_CONST(0.12977235533312),    FRAC_CONST(0.13108902455375),    FRAC_CONST(0.13241340441801),
    FRAC_CONST(0.13374549116025),    FRAC_CONST(0.13508528059173),    FRAC_CONST(0.13643276809961),    FRAC_CONST(0.13778794864595),    FRAC_CONST(0.13915081676677),
    FRAC_CONST(0.14052136657114),    FRAC_CONST(0.14189959174027),    FRAC_CONST(0.14328548552671),    FRAC_CONST(0.14467904075349),    FRAC_CONST(0.14608024981336),
    FRAC_CONST(0.14748910466804),    FRAC_CONST(0.14890559684750),    FRAC_CONST(0.15032971744929),    FRAC_CONST(0.15176145713790),    FRAC_CONST(0.15320080614414),
    FRAC_CONST(0.15464775426459),    FRAC_CONST(0.15610229086100),    FRAC_CONST(0.15756440485987),    FRAC_CONST(0.15903408475193),    FRAC_CONST(0.16051131859170),
    FRAC_CONST(0.16199609399712),    FRAC_CONST(0.16348839814917),    FRAC_CONST(0.16498821779156),    FRAC_CONST(0.16649553923042),    FRAC_CONST(0.16801034833404),
    FRAC_CONST(0.16953263053270),    FRAC_CONST(0.17106237081842),    FRAC_CONST(0.17259955374484),    FRAC_CONST(0.17414416342714),    FRAC_CONST(0.17569618354193),
    FRAC_CONST(0.17725559732720),    FRAC_CONST(0.17882238758238),    FRAC_CONST(0.18039653666830),    FRAC_CONST(0.18197802650733),    FRAC_CONST(0.18356683858343),
    FRAC_CONST(0.18516295394233),    FRAC_CONST(0.18676635319174),    FRAC_CONST(0.18837701650148),    FRAC_CONST(0.18999492360384),    FRAC_CONST(0.19162005379380),
    FRAC_CONST(0.19325238592940),    FRAC_CONST(0.19489189843209),    FRAC_CONST(0.19653856928714),    FRAC_CONST(0.19819237604409),    FRAC_CONST(0.19985329581721),
    FRAC_CONST(0.20152130528605),    FRAC_CONST(0.20319638069594),    FRAC_CONST(0.20487849785865),    FRAC_CONST(0.20656763215298),    FRAC_CONST(0.20826375852540),
    FRAC_CONST(0.20996685149083),    FRAC_CONST(0.21167688513330),    FRAC_CONST(0.21339383310678),    FRAC_CONST(0.21511766863598),    FRAC_CONST(0.21684836451719),
    FRAC_CONST(0.21858589311922),    FRAC_CONST(0.22033022638425),    FRAC_CONST(0.22208133582887),    FRAC_CONST(0.22383919254503),    FRAC_CONST(0.22560376720111),
    FRAC_CONST(0.22737503004300),    FRAC_CONST(0.22915295089517),    FRAC_CONST(0.23093749916189),    FRAC_CONST(0.23272864382838),    FRAC_CONST(0.23452635346201),
    FRAC_CONST(0.23633059621364),    FRAC_CONST(0.23814133981883),    FRAC_CONST(0.23995855159925),    FRAC_CONST(0.24178219846403),    FRAC_CONST(0.24361224691114),
    FRAC_CONST(0.24544866302890),    FRAC_CONST(0.24729141249740),    FRAC_CONST(0.24914046059007),    FRAC_CONST(0.25099577217522),    FRAC_CONST(0.25285731171763),
    FRAC_CONST(0.25472504328019),    FRAC_CONST(0.25659893052556),    FRAC_CONST(0.25847893671788),    FRAC_CONST(0.26036502472451),    FRAC_CONST(0.26225715701781),
    FRAC_CONST(0.26415529567692),    FRAC_CONST(0.26605940238966),    FRAC_CONST(0.26796943845439),    FRAC_CONST(0.26988536478190),    FRAC_CONST(0.27180714189742),
    FRAC_CONST(0.27373472994256),    FRAC_CONST(0.27566808867736),    FRAC_CONST(0.27760717748238),    FRAC_CONST(0.27955195536071),    FRAC_CONST(0.28150238094021),
    FRAC_CONST(0.28345841247557),    FRAC_CONST(0.28542000785059),    FRAC_CONST(0.28738712458038),    FRAC_CONST(0.28935971981364),    FRAC_CONST(0.29133775033492),
    FRAC_CONST(0.29332117256704),    FRAC_CONST(0.29530994257338),    FRAC_CONST(0.29730401606034),    FRAC_CONST(0.29930334837974),    FRAC_CONST(0.30130789453132),
    FRAC_CONST(0.30331760916521),    FRAC_CONST(0.30533244658452),    FRAC_CONST(0.30735236074785),    FRAC_CONST(0.30937730527195),    FRAC_CONST(0.31140723343430),
    FRAC_CONST(0.31344209817583),    FRAC_CONST(0.31548185210356),    FRAC_CONST(0.31752644749341),    FRAC_CONST(0.31957583629288),    FRAC_CONST(0.32162997012390),
    FRAC_CONST(0.32368880028565),    FRAC_CONST(0.32575227775738),    FRAC_CONST(0.32782035320134),    FRAC_CONST(0.32989297696566),    FRAC_CONST(0.33197009908736),
    FRAC_CONST(0.33405166929523),    FRAC_CONST(0.33613763701295),    FRAC_CONST(0.33822795136203),    FRAC_CONST(0.34032256116495),    FRAC_CONST(0.34242141494820),
    FRAC_CONST(0.34452446094547),    FRAC_CONST(0.34663164710072),    FRAC_CONST(0.34874292107143),    FRAC_CONST(0.35085823023181),    FRAC_CONST(0.35297752167598),
    FRAC_CONST(0.35510074222129),    FRAC_CONST(0.35722783841160),    FRAC_CONST(0.35935875652060),    FRAC_CONST(0.36149344255514),    FRAC_CONST(0.36363184225864),
    FRAC_CONST(0.36577390111444),    FRAC_CONST(0.36791956434930),    FRAC_CONST(0.37006877693676),    FRAC_CONST(0.37222148360070),    FRAC_CONST(0.37437762881878),
    FRAC_CONST(0.37653715682603),    FRAC_CONST(0.37870001161834),    FRAC_CONST(0.38086613695607),    FRAC_CONST(0.38303547636766),    FRAC_CONST(0.38520797315322),
    FRAC_CONST(0.38738357038821),    FRAC_CONST(0.38956221092708),    FRAC_CONST(0.39174383740701),    FRAC_CONST(0.39392839225157),    FRAC_CONST(0.39611581767449),
    FRAC_CONST(0.39830605568342),    FRAC_CONST(0.40049904808370),    FRAC_CONST(0.40269473648218),    FRAC_CONST(0.40489306229101),    FRAC_CONST(0.40709396673153),
    FRAC_CONST(0.40929739083810),    FRAC_CONST(0.41150327546197),    FRAC_CONST(0.41371156127524),    FRAC_CONST(0.41592218877472),    FRAC_CONST(0.41813509828594),
    FRAC_CONST(0.42035022996702),    FRAC_CONST(0.42256752381274),    FRAC_CONST(0.42478691965848),    FRAC_CONST(0.42700835718423),    FRAC_CONST(0.42923177591866),
    FRAC_CONST(0.43145711524314),    FRAC_CONST(0.43368431439580),    FRAC_CONST(0.43591331247564),    FRAC_CONST(0.43814404844658),    FRAC_CONST(0.44037646114161),
    FRAC_CONST(0.44261048926688),    FRAC_CONST(0.44484607140589),    FRAC_CONST(0.44708314602359),    FRAC_CONST(0.44932165147057),    FRAC_CONST(0.45156152598727),
    FRAC_CONST(0.45380270770813),    FRAC_CONST(0.45604513466581),    FRAC_CONST(0.45828874479543),    FRAC_CONST(0.46053347593880),    FRAC_CONST(0.46277926584861),
    FRAC_CONST(0.46502605219277),    FRAC_CONST(0.46727377255861),    FRAC_CONST(0.46952236445718),    FRAC_CONST(0.47177176532752),    FRAC_CONST(0.47402191254100),
    FRAC_CONST(0.47627274340557),    FRAC_CONST(0.47852419517009),    FRAC_CONST(0.48077620502869),    FRAC_CONST(0.48302871012505),    FRAC_CONST(0.48528164755674),
    FRAC_CONST(0.48753495437962),    FRAC_CONST(0.48978856761212),    FRAC_CONST(0.49204242423966),    FRAC_CONST(0.49429646121898),    FRAC_CONST(0.49655061548250),
    FRAC_CONST(0.49880482394273),    FRAC_CONST(0.50105902349665),    FRAC_CONST(0.50331315103004),    FRAC_CONST(0.50556714342194),    FRAC_CONST(0.50782093754901),
    FRAC_CONST(0.51007447028990),    FRAC_CONST(0.51232767852971),    FRAC_CONST(0.51458049916433),    FRAC_CONST(0.51683286910489),    FRAC_CONST(0.51908472528213),
    FRAC_CONST(0.52133600465083),    FRAC_CONST(0.52358664419420),    FRAC_CONST(0.52583658092832),    FRAC_CONST(0.52808575190648),    FRAC_CONST(0.53033409422367),
    FRAC_CONST(0.53258154502092),    FRAC_CONST(0.53482804148974),    FRAC_CONST(0.53707352087652),    FRAC_CONST(0.53931792048690),    FRAC_CONST(0.54156117769021),
    FRAC_CONST(0.54380322992385),    FRAC_CONST(0.54604401469766),    FRAC_CONST(0.54828346959835),    FRAC_CONST(0.55052153229384),    FRAC_CONST(0.55275814053768),
    FRAC_CONST(0.55499323217338),    FRAC_CONST(0.55722674513883),    FRAC_CONST(0.55945861747062),    FRAC_CONST(0.56168878730842),    FRAC_CONST(0.56391719289930),
    FRAC_CONST(0.56614377260214),    FRAC_CONST(0.56836846489188),    FRAC_CONST(0.57059120836390),    FRAC_CONST(0.57281194173835),    FRAC_CONST(0.57503060386439),
    FRAC_CONST(0.57724713372458),    FRAC_CONST(0.57946147043912),    FRAC_CONST(0.58167355327012),    FRAC_CONST(0.58388332162591),    FRAC_CONST(0.58609071506528),
    FRAC_CONST(0.58829567330173),    FRAC_CONST(0.59049813620770),    FRAC_CONST(0.59269804381879),    FRAC_CONST(0.59489533633802),    FRAC_CONST(0.59708995413996),
    FRAC_CONST(0.59928183777495),    FRAC_CONST(0.60147092797329),    FRAC_CONST(0.60365716564937),    FRAC_CONST(0.60584049190582),    FRAC_CONST(0.60802084803764),
    FRAC_CONST(0.61019817553632),    FRAC_CONST(0.61237241609393),    FRAC_CONST(0.61454351160718),    FRAC_CONST(0.61671140418155),    FRAC_CONST(0.61887603613527),
    FRAC_CONST(0.62103735000336),    FRAC_CONST(0.62319528854167),    FRAC_CONST(0.62534979473088),    FRAC_CONST(0.62750081178042),    FRAC_CONST(0.62964828313250),
    FRAC_CONST(0.63179215246597),    FRAC_CONST(0.63393236370030),    FRAC_CONST(0.63606886099946),    FRAC_CONST(0.63820158877577),    FRAC_CONST(0.64033049169379),
    FRAC_CONST(0.64245551467413),    FRAC_CONST(0.64457660289729),    FRAC_CONST(0.64669370180740),    FRAC_CONST(0.64880675711607),    FRAC_CONST(0.65091571480603),
    FRAC_CONST(0.65302052113494),    FRAC_CONST(0.65512112263906),    FRAC_CONST(0.65721746613689),    FRAC_CONST(0.65930949873289),    FRAC_CONST(0.66139716782102),
    FRAC_CONST(0.66348042108842),    FRAC_CONST(0.66555920651892),    FRAC_CONST(0.66763347239664),    FRAC_CONST(0.66970316730947),    FRAC_CONST(0.67176824015260),
    FRAC_CONST(0.67382864013196),    FRAC_CONST(0.67588431676768),    FRAC_CONST(0.67793521989751),    FRAC_CONST(0.67998129968017),    FRAC_CONST(0.68202250659876),
    FRAC_CONST(0.68405879146403),    FRAC_CONST(0.68609010541774),    FRAC_CONST(0.68811639993588),    FRAC_CONST(0.69013762683195),    FRAC_CONST(0.69215373826012),
    FRAC_CONST(0.69416468671849),    FRAC_CONST(0.69617042505214),    FRAC_CONST(0.69817090645634),    FRAC_CONST(0.70016608447958),    FRAC_CONST(0.70215591302664),
    FRAC_CONST(0.70414034636163),    FRAC_CONST(0.70611933911096),    FRAC_CONST(0.70809284626630),    FRAC_CONST(0.71006082318751),    FRAC_CONST(0.71202322560554),
    FRAC_CONST(0.71398000962530),    FRAC_CONST(0.71593113172842),    FRAC_CONST(0.71787654877613),    FRAC_CONST(0.71981621801195),    FRAC_CONST(0.72175009706445),
    FRAC_CONST(0.72367814394990),    FRAC_CONST(0.72560031707496),    FRAC_CONST(0.72751657523927),    FRAC_CONST(0.72942687763803),    FRAC_CONST(0.73133118386457),
    FRAC_CONST(0.73322945391280),    FRAC_CONST(0.73512164817975),    FRAC_CONST(0.73700772746796),    FRAC_CONST(0.73888765298787),    FRAC_CONST(0.74076138636020),
    FRAC_CONST(0.74262888961827),    FRAC_CONST(0.74449012521027),    FRAC_CONST(0.74634505600152),    FRAC_CONST(0.74819364527663),    FRAC_CONST(0.75003585674175),
    FRAC_CONST(0.75187165452661),    FRAC_CONST(0.75370100318668),    FRAC_CONST(0.75552386770515),    FRAC_CONST(0.75734021349500),    FRAC_CONST(0.75915000640095),
    FRAC_CONST(0.76095321270137),    FRAC_CONST(0.76274979911019),    FRAC_CONST(0.76453973277875),    FRAC_CONST(0.76632298129757),    FRAC_CONST(0.76809951269819),
    FRAC_CONST(0.76986929545481),    FRAC_CONST(0.77163229848604),    FRAC_CONST(0.77338849115651),    FRAC_CONST(0.77513784327849),    FRAC_CONST(0.77688032511340),
    FRAC_CONST(0.77861590737340),    FRAC_CONST(0.78034456122283),    FRAC_CONST(0.78206625827961),    FRAC_CONST(0.78378097061667),    FRAC_CONST(0.78548867076330),
    FRAC_CONST(0.78718933170643),    FRAC_CONST(0.78888292689189),    FRAC_CONST(0.79056943022564),    FRAC_CONST(0.79224881607494),    FRAC_CONST(0.79392105926949),
    FRAC_CONST(0.79558613510249),    FRAC_CONST(0.79724401933170),    FRAC_CONST(0.79889468818046),    FRAC_CONST(0.80053811833858),    FRAC_CONST(0.80217428696334),
    FRAC_CONST(0.80380317168028),    FRAC_CONST(0.80542475058405),    FRAC_CONST(0.80703900223920),    FRAC_CONST(0.80864590568089),    FRAC_CONST(0.81024544041560),
    FRAC_CONST(0.81183758642175),    FRAC_CONST(0.81342232415032),    FRAC_CONST(0.81499963452540),    FRAC_CONST(0.81656949894467),    FRAC_CONST(0.81813189927991),
    FRAC_CONST(0.81968681787738),    FRAC_CONST(0.82123423755821),    FRAC_CONST(0.82277414161874),    FRAC_CONST(0.82430651383076),    FRAC_CONST(0.82583133844180),
    FRAC_CONST(0.82734860017528),    FRAC_CONST(0.82885828423070),    FRAC_CONST(0.83036037628369),    FRAC_CONST(0.83185486248609),    FRAC_CONST(0.83334172946597),
    FRAC_CONST(0.83482096432759),    FRAC_CONST(0.83629255465130),    FRAC_CONST(0.83775648849344),    FRAC_CONST(0.83921275438615),    FRAC_CONST(0.84066134133716),
    FRAC_CONST(0.84210223882952),    FRAC_CONST(0.84353543682130),    FRAC_CONST(0.84496092574524),    FRAC_CONST(0.84637869650833),    FRAC_CONST(0.84778874049138),
    FRAC_CONST(0.84919104954855),    FRAC_CONST(0.85058561600677),    FRAC_CONST(0.85197243266520),    FRAC_CONST(0.85335149279457),    FRAC_CONST(0.85472279013653),
    FRAC_CONST(0.85608631890295),    FRAC_CONST(0.85744207377513),    FRAC_CONST(0.85879004990298),    FRAC_CONST(0.86013024290422),    FRAC_CONST(0.86146264886346),
    FRAC_CONST(0.86278726433124),    FRAC_CONST(0.86410408632306),    FRAC_CONST(0.86541311231838),    FRAC_CONST(0.86671434025950),    FRAC_CONST(0.86800776855046),
    FRAC_CONST(0.86929339605590),    FRAC_CONST(0.87057122209981),    FRAC_CONST(0.87184124646433),    FRAC_CONST(0.87310346938840),    FRAC_CONST(0.87435789156650),
    FRAC_CONST(0.87560451414719),    FRAC_CONST(0.87684333873173),    FRAC_CONST(0.87807436737261),    FRAC_CONST(0.87929760257204),    FRAC_CONST(0.88051304728038),
    FRAC_CONST(0.88172070489456),    FRAC_CONST(0.88292057925645),    FRAC_CONST(0.88411267465117),    FRAC_CONST(0.88529699580537),    FRAC_CONST(0.88647354788545),
    FRAC_CONST(0.88764233649580),    FRAC_CONST(0.88880336767692),    FRAC_CONST(0.88995664790351),    FRAC_CONST(0.89110218408260),    FRAC_CONST(0.89223998355154),
    FRAC_CONST(0.89337005407600),    FRAC_CONST(0.89449240384793),    FRAC_CONST(0.89560704148345),    FRAC_CONST(0.89671397602074),    FRAC_CONST(0.89781321691786),
    FRAC_CONST(0.89890477405053),    FRAC_CONST(0.89998865770993),    FRAC_CONST(0.90106487860034),    FRAC_CONST(0.90213344783689),    FRAC_CONST(0.90319437694315),
    FRAC_CONST(0.90424767784873),    FRAC_CONST(0.90529336288690),    FRAC_CONST(0.90633144479201),    FRAC_CONST(0.90736193669708),    FRAC_CONST(0.90838485213119),
    FRAC_CONST(0.90940020501694),    FRAC_CONST(0.91040800966776),    FRAC_CONST(0.91140828078533),    FRAC_CONST(0.91240103345685),    FRAC_CONST(0.91338628315231),
    FRAC_CONST(0.91436404572173),    FRAC_CONST(0.91533433739238),    FRAC_CONST(0.91629717476594),    FRAC_CONST(0.91725257481564),    FRAC_CONST(0.91820055488334),
    FRAC_CONST(0.91914113267664),    FRAC_CONST(0.92007432626589),    FRAC_CONST(0.92100015408120),    FRAC_CONST(0.92191863490944),    FRAC_CONST(0.92282978789113),
    FRAC_CONST(0.92373363251740),    FRAC_CONST(0.92463018862687),    FRAC_CONST(0.92551947640245),    FRAC_CONST(0.92640151636824),    FRAC_CONST(0.92727632938624),
    FRAC_CONST(0.92814393665320),    FRAC_CONST(0.92900435969727),    FRAC_CONST(0.92985762037477),    FRAC_CONST(0.93070374086684),    FRAC_CONST(0.93154274367610),
    FRAC_CONST(0.93237465162328),    FRAC_CONST(0.93319948784382),    FRAC_CONST(0.93401727578443),    FRAC_CONST(0.93482803919967),    FRAC_CONST(0.93563180214841),
    FRAC_CONST(0.93642858899043),    FRAC_CONST(0.93721842438279),    FRAC_CONST(0.93800133327637),    FRAC_CONST(0.93877734091223),    FRAC_CONST(0.93954647281807),
    FRAC_CONST(0.94030875480458),    FRAC_CONST(0.94106421296182),    FRAC_CONST(0.94181287365556),    FRAC_CONST(0.94255476352362),    FRAC_CONST(0.94328990947213),
    FRAC_CONST(0.94401833867184),    FRAC_CONST(0.94474007855439),    FRAC_CONST(0.94545515680855),    FRAC_CONST(0.94616360137644),    FRAC_CONST(0.94686544044975),
    FRAC_CONST(0.94756070246592),    FRAC_CONST(0.94824941610434),    FRAC_CONST(0.94893161028248),    FRAC_CONST(0.94960731415209),    FRAC_CONST(0.95027655709525),
    FRAC_CONST(0.95093936872056),    FRAC_CONST(0.95159577885924),    FRAC_CONST(0.95224581756115),    FRAC_CONST(0.95288951509097),    FRAC_CONST(0.95352690192417),
    FRAC_CONST(0.95415800874314),    FRAC_CONST(0.95478286643320),    FRAC_CONST(0.95540150607863),    FRAC_CONST(0.95601395895871),    FRAC_CONST(0.95662025654373),
    FRAC_CONST(0.95722043049100),    FRAC_CONST(0.95781451264084),    FRAC_CONST(0.95840253501260),    FRAC_CONST(0.95898452980058),    FRAC_CONST(0.95956052937008),
    FRAC_CONST(0.96013056625336),    FRAC_CONST(0.96069467314557),    FRAC_CONST(0.96125288290073),    FRAC_CONST(0.96180522852773),    FRAC_CONST(0.96235174318622),
    FRAC_CONST(0.96289246018262),    FRAC_CONST(0.96342741296604),    FRAC_CONST(0.96395663512424),    FRAC_CONST(0.96448016037959),    FRAC_CONST(0.96499802258499),
    FRAC_CONST(0.96551025571985),    FRAC_CONST(0.96601689388602),    FRAC_CONST(0.96651797130376),    FRAC_CONST(0.96701352230768),    FRAC_CONST(0.96750358134269),
    FRAC_CONST(0.96798818295998),    FRAC_CONST(0.96846736181297),    FRAC_CONST(0.96894115265327),    FRAC_CONST(0.96940959032667),    FRAC_CONST(0.96987270976912),
    FRAC_CONST(0.97033054600270),    FRAC_CONST(0.97078313413161),    FRAC_CONST(0.97123050933818),    FRAC_CONST(0.97167270687887),    FRAC_CONST(0.97210976208030),
    FRAC_CONST(0.97254171033525),    FRAC_CONST(0.97296858709871),    FRAC_CONST(0.97339042788392),    FRAC_CONST(0.97380726825843),    FRAC_CONST(0.97421914384017),
    FRAC_CONST(0.97462609029350),    FRAC_CONST(0.97502814332534),    FRAC_CONST(0.97542533868127),    FRAC_CONST(0.97581771214160),    FRAC_CONST(0.97620529951759),
    FRAC_CONST(0.97658813664749),    FRAC_CONST(0.97696625939282),    FRAC_CONST(0.97733970363445),    FRAC_CONST(0.97770850526884),    FRAC_CONST(0.97807270020427),
    FRAC_CONST(0.97843232435704),    FRAC_CONST(0.97878741364771),    FRAC_CONST(0.97913800399743),    FRAC_CONST(0.97948413132414),    FRAC_CONST(0.97982583153895),
    FRAC_CONST(0.98016314054243),    FRAC_CONST(0.98049609422096),    FRAC_CONST(0.98082472844313),    FRAC_CONST(0.98114907905608),    FRAC_CONST(0.98146918188197),
    FRAC_CONST(0.98178507271438),    FRAC_CONST(0.98209678731477),    FRAC_CONST(0.98240436140902),    FRAC_CONST(0.98270783068385),    FRAC_CONST(0.98300723078342),
    FRAC_CONST(0.98330259730589),    FRAC_CONST(0.98359396579995),    FRAC_CONST(0.98388137176152),    FRAC_CONST(0.98416485063031),    FRAC_CONST(0.98444443778651),
    FRAC_CONST(0.98472016854752),    FRAC_CONST(0.98499207816463),    FRAC_CONST(0.98526020181980),    FRAC_CONST(0.98552457462240),    FRAC_CONST(0.98578523160609),
    FRAC_CONST(0.98604220772560),    FRAC_CONST(0.98629553785362),    FRAC_CONST(0.98654525677772),    FRAC_CONST(0.98679139919726),    FRAC_CONST(0.98703399972035),
    FRAC_CONST(0.98727309286089),    FRAC_CONST(0.98750871303556),    FRAC_CONST(0.98774089456089),    FRAC_CONST(0.98796967165036),    FRAC_CONST(0.98819507841154),
    FRAC_CONST(0.98841714884323),    FRAC_CONST(0.98863591683269),    FRAC_CONST(0.98885141615285),    FRAC_CONST(0.98906368045957),    FRAC_CONST(0.98927274328896),
    FRAC_CONST(0.98947863805473),    FRAC_CONST(0.98968139804554),    FRAC_CONST(0.98988105642241),    FRAC_CONST(0.99007764621618),    FRAC_CONST(0.99027120032501),
    FRAC_CONST(0.99046175151186),    FRAC_CONST(0.99064933240208),    FRAC_CONST(0.99083397548099),    FRAC_CONST(0.99101571309153),    FRAC_CONST(0.99119457743191),
    FRAC_CONST(0.99137060055337),    FRAC_CONST(0.99154381435784),    FRAC_CONST(0.99171425059582),    FRAC_CONST(0.99188194086414),    FRAC_CONST(0.99204691660388),
    FRAC_CONST(0.99220920909823),    FRAC_CONST(0.99236884947045),    FRAC_CONST(0.99252586868186),    FRAC_CONST(0.99268029752989),    FRAC_CONST(0.99283216664606),
    FRAC_CONST(0.99298150649419),    FRAC_CONST(0.99312834736847),    FRAC_CONST(0.99327271939167),    FRAC_CONST(0.99341465251338),    FRAC_CONST(0.99355417650825),
    FRAC_CONST(0.99369132097430),    FRAC_CONST(0.99382611533130),    FRAC_CONST(0.99395858881910),    FRAC_CONST(0.99408877049612),    FRAC_CONST(0.99421668923778),
    FRAC_CONST(0.99434237373503),    FRAC_CONST(0.99446585249289),    FRAC_CONST(0.99458715382906),    FRAC_CONST(0.99470630587254),    FRAC_CONST(0.99482333656229),
    FRAC_CONST(0.99493827364600),    FRAC_CONST(0.99505114467878),    FRAC_CONST(0.99516197702200),    FRAC_CONST(0.99527079784214),    FRAC_CONST(0.99537763410962),
    FRAC_CONST(0.99548251259777),    FRAC_CONST(0.99558545988178),    FRAC_CONST(0.99568650233767),    FRAC_CONST(0.99578566614138),    FRAC_CONST(0.99588297726783),
    FRAC_CONST(0.99597846149005),    FRAC_CONST(0.99607214437834),    FRAC_CONST(0.99616405129947),    FRAC_CONST(0.99625420741595),    FRAC_CONST(0.99634263768527),
    FRAC_CONST(0.99642936685928),    FRAC_CONST(0.99651441948352),    FRAC_CONST(0.99659781989663),    FRAC_CONST(0.99667959222978),    FRAC_CONST(0.99675976040620),
    FRAC_CONST(0.99683834814063),    FRAC_CONST(0.99691537893895),    FRAC_CONST(0.99699087609774),    FRAC_CONST(0.99706486270391),    FRAC_CONST(0.99713736163442),
    FRAC_CONST(0.99720839555593),    FRAC_CONST(0.99727798692461),    FRAC_CONST(0.99734615798589),    FRAC_CONST(0.99741293077431),    FRAC_CONST(0.99747832711337),
    FRAC_CONST(0.99754236861541),    FRAC_CONST(0.99760507668158),    FRAC_CONST(0.99766647250181),    FRAC_CONST(0.99772657705478),    FRAC_CONST(0.99778541110799),
    FRAC_CONST(0.99784299521785),    FRAC_CONST(0.99789934972976),    FRAC_CONST(0.99795449477828),    FRAC_CONST(0.99800845028730),    FRAC_CONST(0.99806123597027),
    FRAC_CONST(0.99811287133042),    FRAC_CONST(0.99816337566108),    FRAC_CONST(0.99821276804596),    FRAC_CONST(0.99826106735952),    FRAC_CONST(0.99830829226732),
    FRAC_CONST(0.99835446122649),    FRAC_CONST(0.99839959248609),    FRAC_CONST(0.99844370408765),    FRAC_CONST(0.99848681386566),    FRAC_CONST(0.99852893944805),
    FRAC_CONST(0.99857009825685),    FRAC_CONST(0.99861030750869),    FRAC_CONST(0.99864958421549),    FRAC_CONST(0.99868794518504),    FRAC_CONST(0.99872540702178),
    FRAC_CONST(0.99876198612738),    FRAC_CONST(0.99879769870160),    FRAC_CONST(0.99883256074295),    FRAC_CONST(0.99886658804953),    FRAC_CONST(0.99889979621983),
    FRAC_CONST(0.99893220065356),    FRAC_CONST(0.99896381655254),    FRAC_CONST(0.99899465892154),    FRAC_CONST(0.99902474256924),    FRAC_CONST(0.99905408210916),
    FRAC_CONST(0.99908269196056),    FRAC_CONST(0.99911058634952),    FRAC_CONST(0.99913777930986),    FRAC_CONST(0.99916428468421),    FRAC_CONST(0.99919011612505),
    FRAC_CONST(0.99921528709576),    FRAC_CONST(0.99923981087174),    FRAC_CONST(0.99926370054150),    FRAC_CONST(0.99928696900779),    FRAC_CONST(0.99930962898876),
    FRAC_CONST(0.99933169301910),    FRAC_CONST(0.99935317345126),    FRAC_CONST(0.99937408245662),    FRAC_CONST(0.99939443202674),    FRAC_CONST(0.99941423397457),
    FRAC_CONST(0.99943349993572),    FRAC_CONST(0.99945224136972),    FRAC_CONST(0.99947046956130),    FRAC_CONST(0.99948819562171),    FRAC_CONST(0.99950543049000),
    FRAC_CONST(0.99952218493439),    FRAC_CONST(0.99953846955355),    FRAC_CONST(0.99955429477803),    FRAC_CONST(0.99956967087154),    FRAC_CONST(0.99958460793242),
    FRAC_CONST(0.99959911589494),    FRAC_CONST(0.99961320453077),    FRAC_CONST(0.99962688345035),    FRAC_CONST(0.99964016210433),    FRAC_CONST(0.99965304978499),
    FRAC_CONST(0.99966555562769),    FRAC_CONST(0.99967768861231),    FRAC_CONST(0.99968945756473),    FRAC_CONST(0.99970087115825),    FRAC_CONST(0.99971193791510),
    FRAC_CONST(0.99972266620792),    FRAC_CONST(0.99973306426121),    FRAC_CONST(0.99974314015288),    FRAC_CONST(0.99975290181568),    FRAC_CONST(0.99976235703876),
    FRAC_CONST(0.99977151346914),    FRAC_CONST(0.99978037861326),    FRAC_CONST(0.99978895983845),    FRAC_CONST(0.99979726437448),    FRAC_CONST(0.99980529931507),
    FRAC_CONST(0.99981307161943),    FRAC_CONST(0.99982058811377),    FRAC_CONST(0.99982785549283),    FRAC_CONST(0.99983488032144),    FRAC_CONST(0.99984166903600),
    FRAC_CONST(0.99984822794606),    FRAC_CONST(0.99985456323584),    FRAC_CONST(0.99986068096572),    FRAC_CONST(0.99986658707386),    FRAC_CONST(0.99987228737764),
    FRAC_CONST(0.99987778757524),    FRAC_CONST(0.99988309324717),    FRAC_CONST(0.99988820985777),    FRAC_CONST(0.99989314275675),    FRAC_CONST(0.99989789718072),
    FRAC_CONST(0.99990247825468),    FRAC_CONST(0.99990689099357),    FRAC_CONST(0.99991114030376),    FRAC_CONST(0.99991523098456),    FRAC_CONST(0.99991916772971),
    FRAC_CONST(0.99992295512891),    FRAC_CONST(0.99992659766930),    FRAC_CONST(0.99993009973692),    FRAC_CONST(0.99993346561824),    FRAC_CONST(0.99993669950161),
    FRAC_CONST(0.99993980547870),    FRAC_CONST(0.99994278754604),    FRAC_CONST(0.99994564960642),    FRAC_CONST(0.99994839547033),    FRAC_CONST(0.99995102885747),
    FRAC_CONST(0.99995355339809),    FRAC_CONST(0.99995597263451),    FRAC_CONST(0.99995829002249),    FRAC_CONST(0.99996050893264),    FRAC_CONST(0.99996263265183),
    FRAC_CONST(0.99996466438460),    FRAC_CONST(0.99996660725452),    FRAC_CONST(0.99996846430558),    FRAC_CONST(0.99997023850356),    FRAC_CONST(0.99997193273736),
    FRAC_CONST(0.99997354982037),    FRAC_CONST(0.99997509249183),    FRAC_CONST(0.99997656341810),    FRAC_CONST(0.99997796519400),    FRAC_CONST(0.99997930034415),
    FRAC_CONST(0.99998057132421),    FRAC_CONST(0.99998178052220),    FRAC_CONST(0.99998293025975),    FRAC_CONST(0.99998402279338),    FRAC_CONST(0.99998506031574),
    FRAC_CONST(0.99998604495686),    FRAC_CONST(0.99998697878536),    FRAC_CONST(0.99998786380966),    FRAC_CONST(0.99998870197921),    FRAC_CONST(0.99998949518567),
    FRAC_CONST(0.99999024526408),    FRAC_CONST(0.99999095399401),    FRAC_CONST(0.99999162310077),    FRAC_CONST(0.99999225425649),    FRAC_CONST(0.99999284908128),
    FRAC_CONST(0.99999340914435),    FRAC_CONST(0.99999393596510),    FRAC_CONST(0.99999443101421),    FRAC_CONST(0.99999489571473),    FRAC_CONST(0.99999533144314),
    FRAC_CONST(0.99999573953040),    FRAC_CONST(0.99999612126300),    FRAC_CONST(0.99999647788395),    FRAC_CONST(0.99999681059383),    FRAC_CONST(0.99999712055178),
    FRAC_CONST(0.99999740887647),    FRAC_CONST(0.99999767664709),    FRAC_CONST(0.99999792490431),    FRAC_CONST(0.99999815465123),    FRAC_CONST(0.99999836685427),
    FRAC_CONST(0.99999856244415),    FRAC_CONST(0.99999874231676),    FRAC_CONST(0.99999890733405),    FRAC_CONST(0.99999905832493),    FRAC_CONST(0.99999919608613),
    FRAC_CONST(0.99999932138304),    FRAC_CONST(0.99999943495056),    FRAC_CONST(0.99999953749392),    FRAC_CONST(0.99999962968950),    FRAC_CONST(0.99999971218563),
    FRAC_CONST(0.99999978560337),    FRAC_CONST(0.99999985053727),    FRAC_CONST(0.99999990755616),    FRAC_CONST(0.99999995720387)};
#ifdef ALLOW_SMALL_FRAMELENGTH
static const real_t kbd_long_960[] = {
    FRAC_CONST(0.0003021562530949), FRAC_CONST(0.0004452267024786), FRAC_CONST(0.0005674947527496), FRAC_CONST(0.0006812465553466), FRAC_CONST(0.0007910496776387), FRAC_CONST(0.0008991655033895),
    FRAC_CONST(0.0010068978259384), FRAC_CONST(0.0011150758515751), FRAC_CONST(0.0012242653193642), FRAC_CONST(0.0013348735658205), FRAC_CONST(0.0014472068670273), FRAC_CONST(0.0015615039850448),
    FRAC_CONST(0.0016779568885263), FRAC_CONST(0.0017967241232412), FRAC_CONST(0.0019179397560955), FRAC_CONST(0.0020417195415393), FRAC_CONST(0.0021681652836642), FRAC_CONST(0.0022973679910599),
    FRAC_CONST(0.0024294102029937), FRAC_CONST(0.0025643677339078), FRAC_CONST(0.0027023110014772), FRAC_CONST(0.0028433060512612), FRAC_CONST(0.0029874153568025), FRAC_CONST(0.0031346984511728),
    FRAC_CONST(0.0032852124303662), FRAC_CONST(0.0034390123581190), FRAC_CONST(0.0035961515940931), FRAC_CONST(0.0037566820618961), FRAC_CONST(0.0039206544694386), FRAC_CONST(0.0040881184912194),
    FRAC_CONST(0.0042591229199617), FRAC_CONST(0.0044337157933972), FRAC_CONST(0.0046119445007641), FRAC_CONST(0.0047938558726415), FRAC_CONST(0.0049794962570131), FRAC_CONST(0.0051689115838900),
    FRAC_CONST(0.0053621474203763), FRAC_CONST(0.0055592490177131), FRAC_CONST(0.0057602613515573), FRAC_CONST(0.0059652291565289), FRAC_CONST(0.0061741969558843), FRAC_CONST(0.0063872090870253),
    FRAC_CONST(0.0066043097234387), FRAC_CONST(0.0068255428935640), FRAC_CONST(0.0070509524970088), FRAC_CONST(0.0072805823184660), FRAC_CONST(0.0075144760396340), FRAC_CONST(0.0077526772493942),
    FRAC_CONST(0.0079952294524673), FRAC_CONST(0.0082421760767325), FRAC_CONST(0.0084935604793733), FRAC_CONST(0.0087494259519870), FRAC_CONST(0.0090098157247792), FRAC_CONST(0.0092747729699467),
    FRAC_CONST(0.0095443408043399), FRAC_CONST(0.0098185622914832), FRAC_CONST(0.0100974804430226), FRAC_CONST(0.0103811382196612), FRAC_CONST(0.0106695785316351), FRAC_CONST(0.0109628442387771),
    FRAC_CONST(0.0112609781502091), FRAC_CONST(0.0115640230236993), FRAC_CONST(0.0118720215647169), FRAC_CONST(0.0121850164252137), FRAC_CONST(0.0125030502021561), FRAC_CONST(0.0128261654358321),
    FRAC_CONST(0.0131544046079532), FRAC_CONST(0.0134878101395681), FRAC_CONST(0.0138264243888068), FRAC_CONST(0.0141702896484671), FRAC_CONST(0.0145194481434592), FRAC_CONST(0.0148739420281182),
    FRAC_CONST(0.0152338133833959), FRAC_CONST(0.0155991042139432), FRAC_CONST(0.0159698564450882), FRAC_CONST(0.0163461119197227), FRAC_CONST(0.0167279123950996), FRAC_CONST(0.0171152995395520),
    FRAC_CONST(0.0175083149291368), FRAC_CONST(0.0179070000442104), FRAC_CONST(0.0183113962659409), FRAC_CONST(0.0187215448727609), FRAC_CONST(0.0191374870367659), FRAC_CONST(0.0195592638200623),
    FRAC_CONST(0.0199869161710679), FRAC_CONST(0.0204204849207691), FRAC_CONST(0.0208600107789370), FRAC_CONST(0.0213055343303066), FRAC_CONST(0.0217570960307201), FRAC_CONST(0.0222147362032386),
    FRAC_CONST(0.0226784950342228), FRAC_CONST(0.0231484125693867), FRAC_CONST(0.0236245287098244), FRAC_CONST(0.0241068832080138), FRAC_CONST(0.0245955156637973), FRAC_CONST(0.0250904655203431),
    FRAC_CONST(0.0255917720600868), FRAC_CONST(0.0260994744006559), FRAC_CONST(0.0266136114907790), FRAC_CONST(0.0271342221061795), FRAC_CONST(0.0276613448454576), FRAC_CONST(0.0281950181259587),
    FRAC_CONST(0.0287352801796329), FRAC_CONST(0.0292821690488833), FRAC_CONST(0.0298357225824074), FRAC_CONST(0.0303959784310299), FRAC_CONST(0.0309629740435296), FRAC_CONST(0.0315367466624615),
    FRAC_CONST(0.0321173333199732), FRAC_CONST(0.0327047708336193), FRAC_CONST(0.0332990958021720), FRAC_CONST(0.0339003446014307), FRAC_CONST(0.0345085533800302), FRAC_CONST(0.0351237580552491),
    FRAC_CONST(0.0357459943088193), FRAC_CONST(0.0363752975827358), FRAC_CONST(0.0370117030750704), FRAC_CONST(0.0376552457357870), FRAC_CONST(0.0383059602625614), FRAC_CONST(0.0389638810966056),
    FRAC_CONST(0.0396290424184964), FRAC_CONST(0.0403014781440112), FRAC_CONST(0.0409812219199691), FRAC_CONST(0.0416683071200799), FRAC_CONST(0.0423627668408009), FRAC_CONST(0.0430646338972016),
    FRAC_CONST(0.0437739408188385), FRAC_CONST(0.0444907198456388), FRAC_CONST(0.0452150029237951), FRAC_CONST(0.0459468217016708), FRAC_CONST(0.0466862075257170), FRAC_CONST(0.0474331914364021),
    FRAC_CONST(0.0481878041641539), FRAC_CONST(0.0489500761253148), FRAC_CONST(0.0497200374181119), FRAC_CONST(0.0504977178186404), FRAC_CONST(0.0512831467768636), FRAC_CONST(0.0520763534126273),
    FRAC_CONST(0.0528773665116913), FRAC_CONST(0.0536862145217772), FRAC_CONST(0.0545029255486345), FRAC_CONST(0.0553275273521232), FRAC_CONST(0.0561600473423164), FRAC_CONST(0.0570005125756209),
    FRAC_CONST(0.0578489497509179), FRAC_CONST(0.0587053852057233), FRAC_CONST(0.0595698449123695), FRAC_CONST(0.0604423544742077), FRAC_CONST(0.0613229391218317), FRAC_CONST(0.0622116237093247),
    FRAC_CONST(0.0631084327105284), FRAC_CONST(0.0640133902153352), FRAC_CONST(0.0649265199260043), FRAC_CONST(0.0658478451535027), FRAC_CONST(0.0667773888138695), FRAC_CONST(0.0677151734246072),
    FRAC_CONST(0.0686612211010977), FRAC_CONST(0.0696155535530446), FRAC_CONST(0.0705781920809429), FRAC_CONST(0.0715491575725758), FRAC_CONST(0.0725284704995383), FRAC_CONST(0.0735161509137906),
    FRAC_CONST(0.0745122184442388), FRAC_CONST(0.0755166922933461), FRAC_CONST(0.0765295912337720), FRAC_CONST(0.0775509336050437), FRAC_CONST(0.0785807373102561), FRAC_CONST(0.0796190198128044),
    FRAC_CONST(0.0806657981331473), FRAC_CONST(0.0817210888456026), FRAC_CONST(0.0827849080751753), FRAC_CONST(0.0838572714944183), FRAC_CONST(0.0849381943203265), FRAC_CONST(0.0860276913112652),
    FRAC_CONST(0.0871257767639319), FRAC_CONST(0.0882324645103534), FRAC_CONST(0.0893477679149177), FRAC_CONST(0.0904716998714418), FRAC_CONST(0.0916042728002747), FRAC_CONST(0.0927454986454381),
    FRAC_CONST(0.0938953888718020), FRAC_CONST(0.0950539544622996), FRAC_CONST(0.0962212059151784), FRAC_CONST(0.0973971532412897), FRAC_CONST(0.0985818059614169), FRAC_CONST(0.0997751731036425),
    FRAC_CONST(0.1009772632007537), FRAC_CONST(0.1021880842876888), FRAC_CONST(0.1034076438990227), FRAC_CONST(0.1046359490664932), FRAC_CONST(0.1058730063165681), FRAC_CONST(0.1071188216680533),
    FRAC_CONST(0.1083734006297428), FRAC_CONST(0.1096367481981100), FRAC_CONST(0.1109088688550422), FRAC_CONST(0.1121897665656167), FRAC_CONST(0.1134794447759207), FRAC_CONST(0.1147779064109143),
    FRAC_CONST(0.1160851538723372), FRAC_CONST(0.1174011890366591), FRAC_CONST(0.1187260132530751), FRAC_CONST(0.1200596273415457), FRAC_CONST(0.1214020315908810), FRAC_CONST(0.1227532257568719),
    FRAC_CONST(0.1241132090604651), FRAC_CONST(0.1254819801859856), FRAC_CONST(0.1268595372794049), FRAC_CONST(0.1282458779466558), FRAC_CONST(0.1296409992519942), FRAC_CONST(0.1310448977164081),
    FRAC_CONST(0.1324575693160745), FRAC_CONST(0.1338790094808633), FRAC_CONST(0.1353092130928902), FRAC_CONST(0.1367481744851168), FRAC_CONST(0.1381958874400010), FRAC_CONST(0.1396523451881945),
    FRAC_CONST(0.1411175404072910), FRAC_CONST(0.1425914652206223), FRAC_CONST(0.1440741111961058), FRAC_CONST(0.1455654693451402), FRAC_CONST(0.1470655301215526), FRAC_CONST(0.1485742834205956),
    FRAC_CONST(0.1500917185779945), FRAC_CONST(0.1516178243690463), FRAC_CONST(0.1531525890077689), FRAC_CONST(0.1546960001461024), FRAC_CONST(0.1562480448731608), FRAC_CONST(0.1578087097145364),
    FRAC_CONST(0.1593779806316558), FRAC_CONST(0.1609558430211876), FRAC_CONST(0.1625422817145027), FRAC_CONST(0.1641372809771871), FRAC_CONST(0.1657408245086070), FRAC_CONST(0.1673528954415270),
    FRAC_CONST(0.1689734763417811), FRAC_CONST(0.1706025492079969), FRAC_CONST(0.1722400954713725), FRAC_CONST(0.1738860959955082), FRAC_CONST(0.1755405310762898), FRAC_CONST(0.1772033804418275),
    FRAC_CONST(0.1788746232524467), FRAC_CONST(0.1805542381007349), FRAC_CONST(0.1822422030116404), FRAC_CONST(0.1839384954426268), FRAC_CONST(0.1856430922838810), FRAC_CONST(0.1873559698585756),
    FRAC_CONST(0.1890771039231862), FRAC_CONST(0.1908064696678625), FRAC_CONST(0.1925440417168546), FRAC_CONST(0.1942897941289937), FRAC_CONST(0.1960437003982277), FRAC_CONST(0.1978057334542116),
    FRAC_CONST(0.1995758656629525), FRAC_CONST(0.2013540688275098), FRAC_CONST(0.2031403141887507), FRAC_CONST(0.2049345724261595), FRAC_CONST(0.2067368136587033), FRAC_CONST(0.2085470074457521),
    FRAC_CONST(0.2103651227880538), FRAC_CONST(0.2121911281287646), FRAC_CONST(0.2140249913545346), FRAC_CONST(0.2158666797966480), FRAC_CONST(0.2177161602322188), FRAC_CONST(0.2195733988854414),
    FRAC_CONST(0.2214383614288963), FRAC_CONST(0.2233110129849106), FRAC_CONST(0.2251913181269740), FRAC_CONST(0.2270792408812093), FRAC_CONST(0.2289747447278976), FRAC_CONST(0.2308777926030592),
    FRAC_CONST(0.2327883469000885), FRAC_CONST(0.2347063694714437), FRAC_CONST(0.2366318216303919), FRAC_CONST(0.2385646641528076), FRAC_CONST(0.2405048572790267), FRAC_CONST(0.2424523607157545),
    FRAC_CONST(0.2444071336380283), FRAC_CONST(0.2463691346912334), FRAC_CONST(0.2483383219931741), FRAC_CONST(0.2503146531361985), FRAC_CONST(0.2522980851893767), FRAC_CONST(0.2542885747007335),
    FRAC_CONST(0.2562860776995335), FRAC_CONST(0.2582905496986215), FRAC_CONST(0.2603019456968142), FRAC_CONST(0.2623202201813464), FRAC_CONST(0.2643453271303700), FRAC_CONST(0.2663772200155053),
    FRAC_CONST(0.2684158518044454), FRAC_CONST(0.2704611749636135), FRAC_CONST(0.2725131414608710), FRAC_CONST(0.2745717027682799), FRAC_CONST(0.2766368098649151), FRAC_CONST(0.2787084132397296),
    FRAC_CONST(0.2807864628944707), FRAC_CONST(0.2828709083466482), FRAC_CONST(0.2849616986325523), FRAC_CONST(0.2870587823103237), FRAC_CONST(0.2891621074630737), FRAC_CONST(0.2912716217020546),
    FRAC_CONST(0.2933872721698803), FRAC_CONST(0.2955090055437973), FRAC_CONST(0.2976367680390041), FRAC_CONST(0.2997705054120213), FRAC_CONST(0.3019101629641097), FRAC_CONST(0.3040556855447379),
    FRAC_CONST(0.3062070175550981), FRAC_CONST(0.3083641029516701), FRAC_CONST(0.3105268852498334), FRAC_CONST(0.3126953075275265), FRAC_CONST(0.3148693124289546), FRAC_CONST(0.3170488421683428),
    FRAC_CONST(0.3192338385337370), FRAC_CONST(0.3214242428908514), FRAC_CONST(0.3236199961869606), FRAC_CONST(0.3258210389548392), FRAC_CONST(0.3280273113167459), FRAC_CONST(0.3302387529884521),
    FRAC_CONST(0.3324553032833160), FRAC_CONST(0.3346769011164010), FRAC_CONST(0.3369034850086373), FRAC_CONST(0.3391349930910280), FRAC_CONST(0.3413713631088974), FRAC_CONST(0.3436125324261830),
    FRAC_CONST(0.3458584380297697), FRAC_CONST(0.3481090165338656), FRAC_CONST(0.3503642041844199), FRAC_CONST(0.3526239368635820), FRAC_CONST(0.3548881500942010), FRAC_CONST(0.3571567790443668),
    FRAC_CONST(0.3594297585319891), FRAC_CONST(0.3617070230294185), FRAC_CONST(0.3639885066681048), FRAC_CONST(0.3662741432432950), FRAC_CONST(0.3685638662187693), FRAC_CONST(0.3708576087316147),
    FRAC_CONST(0.3731553035970366), FRAC_CONST(0.3754568833132069), FRAC_CONST(0.3777622800661488), FRAC_CONST(0.3800714257346570), FRAC_CONST(0.3823842518952546), FRAC_CONST(0.3847006898271841),
    FRAC_CONST(0.3870206705174334), FRAC_CONST(0.3893441246657958), FRAC_CONST(0.3916709826899639), FRAC_CONST(0.3940011747306560), FRAC_CONST(0.3963346306567764), FRAC_CONST(0.3986712800706062),
    FRAC_CONST(0.4010110523130271), FRAC_CONST(0.4033538764687756), FRAC_CONST(0.4056996813717284), FRAC_CONST(0.4080483956102172), FRAC_CONST(0.4103999475323736), FRAC_CONST(0.4127542652515031),
    FRAC_CONST(0.4151112766514873), FRAC_CONST(0.4174709093922143), FRAC_CONST(0.4198330909150365), FRAC_CONST(0.4221977484482556), FRAC_CONST(0.4245648090126334), FRAC_CONST(0.4269341994269293),
    FRAC_CONST(0.4293058463134616), FRAC_CONST(0.4316796761036958), FRAC_CONST(0.4340556150438547), FRAC_CONST(0.4364335892005536), FRAC_CONST(0.4388135244664580), FRAC_CONST(0.4411953465659639),
    FRAC_CONST(0.4435789810609000), FRAC_CONST(0.4459643533562509), FRAC_CONST(0.4483513887059016), FRAC_CONST(0.4507400122184019), FRAC_CONST(0.4531301488627497), FRAC_CONST(0.4555217234741947),
    FRAC_CONST(0.4579146607600593), FRAC_CONST(0.4603088853055777), FRAC_CONST(0.4627043215797521), FRAC_CONST(0.4651008939412254), FRAC_CONST(0.4674985266441709), FRAC_CONST(0.4698971438441951),
    FRAC_CONST(0.4722966696042580), FRAC_CONST(0.4746970279006055), FRAC_CONST(0.4770981426287164), FRAC_CONST(0.4794999376092619), FRAC_CONST(0.4819023365940778), FRAC_CONST(0.4843052632721476),
    FRAC_CONST(0.4867086412755978), FRAC_CONST(0.4891123941857028), FRAC_CONST(0.4915164455388997), FRAC_CONST(0.4939207188328126), FRAC_CONST(0.4963251375322855), FRAC_CONST(0.4987296250754225),
    FRAC_CONST(0.5011341048796359), FRAC_CONST(0.5035385003477012), FRAC_CONST(0.5059427348738168), FRAC_CONST(0.5083467318496706), FRAC_CONST(0.5107504146705106), FRAC_CONST(0.5131537067412193),
    FRAC_CONST(0.5155565314823923), FRAC_CONST(0.5179588123364193), FRAC_CONST(0.5203604727735667), FRAC_CONST(0.5227614362980630), FRAC_CONST(0.5251616264541841), FRAC_CONST(0.5275609668323384),
    FRAC_CONST(0.5299593810751532), FRAC_CONST(0.5323567928835578), FRAC_CONST(0.5347531260228663), FRAC_CONST(0.5371483043288580), FRAC_CONST(0.5395422517138538), FRAC_CONST(0.5419348921727899),
    FRAC_CONST(0.5443261497892862), FRAC_CONST(0.5467159487417104), FRAC_CONST(0.5491042133092364), FRAC_CONST(0.5514908678778958), FRAC_CONST(0.5538758369466227), FRAC_CONST(0.5562590451332913),
    FRAC_CONST(0.5586404171807443), FRAC_CONST(0.5610198779628133), FRAC_CONST(0.5633973524903286), FRAC_CONST(0.5657727659171199), FRAC_CONST(0.5681460435460047), FRAC_CONST(0.5705171108347663),
    FRAC_CONST(0.5728858934021188), FRAC_CONST(0.5752523170336598), FRAC_CONST(0.5776163076878088), FRAC_CONST(0.5799777915017323), FRAC_CONST(0.5823366947972535), FRAC_CONST(0.5846929440867458),
    FRAC_CONST(0.5870464660790119), FRAC_CONST(0.5893971876851449), FRAC_CONST(0.5917450360243719), FRAC_CONST(0.5940899384298793), FRAC_CONST(0.5964318224546208), FRAC_CONST(0.5987706158771039),
    FRAC_CONST(0.6011062467071583), FRAC_CONST(0.6034386431916822), FRAC_CONST(0.6057677338203681), FRAC_CONST(0.6080934473314057), FRAC_CONST(0.6104157127171639), FRAC_CONST(0.6127344592298474),
    FRAC_CONST(0.6150496163871310), FRAC_CONST(0.6173611139777690), FRAC_CONST(0.6196688820671789), FRAC_CONST(0.6219728510029997), FRAC_CONST(0.6242729514206247), FRAC_CONST(0.6265691142487051),
    FRAC_CONST(0.6288612707146283), FRAC_CONST(0.6311493523499663), FRAC_CONST(0.6334332909958958), FRAC_CONST(0.6357130188085891), FRAC_CONST(0.6379884682645743), FRAC_CONST(0.6402595721660647),
    FRAC_CONST(0.6425262636462578), FRAC_CONST(0.6447884761746012), FRAC_CONST(0.6470461435620266), FRAC_CONST(0.6492991999661505), FRAC_CONST(0.6515475798964411), FRAC_CONST(0.6537912182193508),
    FRAC_CONST(0.6560300501634142), FRAC_CONST(0.6582640113243098), FRAC_CONST(0.6604930376698862), FRAC_CONST(0.6627170655451516), FRAC_CONST(0.6649360316772256), FRAC_CONST(0.6671498731802533),
    FRAC_CONST(0.6693585275602818), FRAC_CONST(0.6715619327200959), FRAC_CONST(0.6737600269640164), FRAC_CONST(0.6759527490026566), FRAC_CONST(0.6781400379576392), FRAC_CONST(0.6803218333662715),
    FRAC_CONST(0.6824980751861787), FRAC_CONST(0.6846687037998949), FRAC_CONST(0.6868336600194123), FRAC_CONST(0.6889928850906855), FRAC_CONST(0.6911463206980928), FRAC_CONST(0.6932939089688525),
    FRAC_CONST(0.6954355924773949), FRAC_CONST(0.6975713142496884), FRAC_CONST(0.6997010177675195), FRAC_CONST(0.7018246469727265), FRAC_CONST(0.7039421462713862), FRAC_CONST(0.7060534605379528),
    FRAC_CONST(0.7081585351193496), FRAC_CONST(0.7102573158390105), FRAC_CONST(0.7123497490008750), FRAC_CONST(0.7144357813933307), FRAC_CONST(0.7165153602931092), FRAC_CONST(0.7185884334691287),
    FRAC_CONST(0.7206549491862871), FRAC_CONST(0.7227148562092042), FRAC_CONST(0.7247681038059106), FRAC_CONST(0.7268146417514855), FRAC_CONST(0.7288544203316418), FRAC_CONST(0.7308873903462577),
    FRAC_CONST(0.7329135031128549), FRAC_CONST(0.7349327104700221), FRAC_CONST(0.7369449647807855), FRAC_CONST(0.7389502189359237), FRAC_CONST(0.7409484263572271), FRAC_CONST(0.7429395410007016),
    FRAC_CONST(0.7449235173597176), FRAC_CONST(0.7469003104681008), FRAC_CONST(0.7488698759031670), FRAC_CONST(0.7508321697887005), FRAC_CONST(0.7527871487978728), FRAC_CONST(0.7547347701561059),
    FRAC_CONST(0.7566749916438754), FRAC_CONST(0.7586077715994560), FRAC_CONST(0.7605330689216074), FRAC_CONST(0.7624508430722016), FRAC_CONST(0.7643610540787891), FRAC_CONST(0.7662636625371070),
    FRAC_CONST(0.7681586296135255), FRAC_CONST(0.7700459170474343), FRAC_CONST(0.7719254871535672), FRAC_CONST(0.7737973028242671), FRAC_CONST(0.7756613275316875), FRAC_CONST(0.7775175253299340),
    FRAC_CONST(0.7793658608571425), FRAC_CONST(0.7812062993374951), FRAC_CONST(0.7830388065831744), FRAC_CONST(0.7848633489962533), FRAC_CONST(0.7866798935705233), FRAC_CONST(0.7884884078932579),
    FRAC_CONST(0.7902888601469138), FRAC_CONST(0.7920812191107668), FRAC_CONST(0.7938654541624850), FRAC_CONST(0.7956415352796368), FRAC_CONST(0.7974094330411343), FRAC_CONST(0.7991691186286133),
    FRAC_CONST(0.8009205638277465), FRAC_CONST(0.8026637410294932), FRAC_CONST(0.8043986232312831), FRAC_CONST(0.8061251840381346), FRAC_CONST(0.8078433976637077), FRAC_CONST(0.8095532389312917),
    FRAC_CONST(0.8112546832747255), FRAC_CONST(0.8129477067392539), FRAC_CONST(0.8146322859823164), FRAC_CONST(0.8163083982742698), FRAC_CONST(0.8179760214990457), FRAC_CONST(0.8196351341547393),
    FRAC_CONST(0.8212857153541345), FRAC_CONST(0.8229277448251595), FRAC_CONST(0.8245612029112778), FRAC_CONST(0.8261860705718113), FRAC_CONST(0.8278023293821971), FRAC_CONST(0.8294099615341773),
    FRAC_CONST(0.8310089498359212), FRAC_CONST(0.8325992777120815), FRAC_CONST(0.8341809292037831), FRAC_CONST(0.8357538889685445), FRAC_CONST(0.8373181422801330), FRAC_CONST(0.8388736750283521),
    FRAC_CONST(0.8404204737187619), FRAC_CONST(0.8419585254723335), FRAC_CONST(0.8434878180250348), FRAC_CONST(0.8450083397273509), FRAC_CONST(0.8465200795437368), FRAC_CONST(0.8480230270520029),
    FRAC_CONST(0.8495171724426350), FRAC_CONST(0.8510025065180464), FRAC_CONST(0.8524790206917633), FRAC_CONST(0.8539467069875448), FRAC_CONST(0.8554055580384357), FRAC_CONST(0.8568555670857525),
    FRAC_CONST(0.8582967279780043), FRAC_CONST(0.8597290351697464), FRAC_CONST(0.8611524837203691), FRAC_CONST(0.8625670692928198), FRAC_CONST(0.8639727881522599), FRAC_CONST(0.8653696371646555),
    FRAC_CONST(0.8667576137953045), FRAC_CONST(0.8681367161072958), FRAC_CONST(0.8695069427599065), FRAC_CONST(0.8708682930069319), FRAC_CONST(0.8722207666949527), FRAC_CONST(0.8735643642615368),
    FRAC_CONST(0.8748990867333771), FRAC_CONST(0.8762249357243662), FRAC_CONST(0.8775419134336067), FRAC_CONST(0.8788500226433579), FRAC_CONST(0.8801492667169208), FRAC_CONST(0.8814396495964587),
    FRAC_CONST(0.8827211758007560), FRAC_CONST(0.8839938504229149), FRAC_CONST(0.8852576791279895), FRAC_CONST(0.8865126681505587), FRAC_CONST(0.8877588242922386), FRAC_CONST(0.8889961549191320),
    FRAC_CONST(0.8902246679592184), FRAC_CONST(0.8914443718996848), FRAC_CONST(0.8926552757841945), FRAC_CONST(0.8938573892100969), FRAC_CONST(0.8950507223255798), FRAC_CONST(0.8962352858267605),
    FRAC_CONST(0.8974110909547198), FRAC_CONST(0.8985781494924783), FRAC_CONST(0.8997364737619142), FRAC_CONST(0.9008860766206249), FRAC_CONST(0.9020269714587307), FRAC_CONST(0.9031591721956235),
    FRAC_CONST(0.9042826932766591), FRAC_CONST(0.9053975496697941), FRAC_CONST(0.9065037568621681), FRAC_CONST(0.9076013308566311), FRAC_CONST(0.9086902881682180), FRAC_CONST(0.9097706458205682),
    FRAC_CONST(0.9108424213422940), FRAC_CONST(0.9119056327632955), FRAC_CONST(0.9129602986110235), FRAC_CONST(0.9140064379066919), FRAC_CONST(0.9150440701614393), FRAC_CONST(0.9160732153724396),
    FRAC_CONST(0.9170938940189634), FRAC_CONST(0.9181061270583908), FRAC_CONST(0.9191099359221748), FRAC_CONST(0.9201053425117579), FRAC_CONST(0.9210923691944400), FRAC_CONST(0.9220710387992010),
    FRAC_CONST(0.9230413746124764), FRAC_CONST(0.9240034003738882), FRAC_CONST(0.9249571402719298), FRAC_CONST(0.9259026189396085), FRAC_CONST(0.9268398614500427), FRAC_CONST(0.9277688933120170),
    FRAC_CONST(0.9286897404654957), FRAC_CONST(0.9296024292770939), FRAC_CONST(0.9305069865355076), FRAC_CONST(0.9314034394469048), FRAC_CONST(0.9322918156302762), FRAC_CONST(0.9331721431127471),
    FRAC_CONST(0.9340444503248519), FRAC_CONST(0.9349087660957711), FRAC_CONST(0.9357651196485313), FRAC_CONST(0.9366135405951697), FRAC_CONST(0.9374540589318637), FRAC_CONST(0.9382867050340261),
    FRAC_CONST(0.9391115096513655), FRAC_CONST(0.9399285039029165), FRAC_CONST(0.9407377192720349), FRAC_CONST(0.9415391876013639), FRAC_CONST(0.9423329410877687), FRAC_CONST(0.9431190122772415),
    FRAC_CONST(0.9438974340597782), FRAC_CONST(0.9446682396642262), FRAC_CONST(0.9454314626531054), FRAC_CONST(0.9461871369174033), FRAC_CONST(0.9469352966713429), FRAC_CONST(0.9476759764471278),
    FRAC_CONST(0.9484092110896616), FRAC_CONST(0.9491350357512457), FRAC_CONST(0.9498534858862532), FRAC_CONST(0.9505645972457831), FRAC_CONST(0.9512684058722927), FRAC_CONST(0.9519649480942105),
    FRAC_CONST(0.9526542605205314), FRAC_CONST(0.9533363800353921), FRAC_CONST(0.9540113437926313), FRAC_CONST(0.9546791892103320), FRAC_CONST(0.9553399539653500), FRAC_CONST(0.9559936759878265),
    FRAC_CONST(0.9566403934556893), FRAC_CONST(0.9572801447891388), FRAC_CONST(0.9579129686451244), FRAC_CONST(0.9585389039118085), FRAC_CONST(0.9591579897030224), FRAC_CONST(0.9597702653527108),
    FRAC_CONST(0.9603757704093711), FRAC_CONST(0.9609745446304828), FRAC_CONST(0.9615666279769324), FRAC_CONST(0.9621520606074324), FRAC_CONST(0.9627308828729358), FRAC_CONST(0.9633031353110477),
    FRAC_CONST(0.9638688586404335), FRAC_CONST(0.9644280937552258), FRAC_CONST(0.9649808817194311), FRAC_CONST(0.9655272637613366), FRAC_CONST(0.9660672812679171), FRAC_CONST(0.9666009757792454),
    FRAC_CONST(0.9671283889829055), FRAC_CONST(0.9676495627084089), FRAC_CONST(0.9681645389216160), FRAC_CONST(0.9686733597191652), FRAC_CONST(0.9691760673229058), FRAC_CONST(0.9696727040743406),
    FRAC_CONST(0.9701633124290767), FRAC_CONST(0.9706479349512860), FRAC_CONST(0.9711266143081750), FRAC_CONST(0.9715993932644684), FRAC_CONST(0.9720663146769026), FRAC_CONST(0.9725274214887337),
    FRAC_CONST(0.9729827567242596), FRAC_CONST(0.9734323634833574), FRAC_CONST(0.9738762849360358), FRAC_CONST(0.9743145643170059), FRAC_CONST(0.9747472449202687), FRAC_CONST(0.9751743700937215),
    FRAC_CONST(0.9755959832337850), FRAC_CONST(0.9760121277800496), FRAC_CONST(0.9764228472099433), FRAC_CONST(0.9768281850334235), FRAC_CONST(0.9772281847876897), FRAC_CONST(0.9776228900319223),
    FRAC_CONST(0.9780123443420448), FRAC_CONST(0.9783965913055132), FRAC_CONST(0.9787756745161313), FRAC_CONST(0.9791496375688939), FRAC_CONST(0.9795185240548578), FRAC_CONST(0.9798823775560431),
    FRAC_CONST(0.9802412416403639), FRAC_CONST(0.9805951598565897), FRAC_CONST(0.9809441757293399), FRAC_CONST(0.9812883327541090), FRAC_CONST(0.9816276743923267), FRAC_CONST(0.9819622440664515),
    FRAC_CONST(0.9822920851550995), FRAC_CONST(0.9826172409882086), FRAC_CONST(0.9829377548422400), FRAC_CONST(0.9832536699354163), FRAC_CONST(0.9835650294229984), FRAC_CONST(0.9838718763926001),
    FRAC_CONST(0.9841742538595437), FRAC_CONST(0.9844722047622547), FRAC_CONST(0.9847657719576983), FRAC_CONST(0.9850549982168574), FRAC_CONST(0.9853399262202529), FRAC_CONST(0.9856205985535073),
    FRAC_CONST(0.9858970577029519), FRAC_CONST(0.9861693460512790), FRAC_CONST(0.9864375058732389), FRAC_CONST(0.9867015793313820), FRAC_CONST(0.9869616084718489), FRAC_CONST(0.9872176352202061),
    FRAC_CONST(0.9874697013773301), FRAC_CONST(0.9877178486153397), FRAC_CONST(0.9879621184735767), FRAC_CONST(0.9882025523546365), FRAC_CONST(0.9884391915204485), FRAC_CONST(0.9886720770884069),
    FRAC_CONST(0.9889012500275530), FRAC_CONST(0.9891267511548089), FRAC_CONST(0.9893486211312621), FRAC_CONST(0.9895669004585049), FRAC_CONST(0.9897816294750255), FRAC_CONST(0.9899928483526520),
    FRAC_CONST(0.9902005970930525), FRAC_CONST(0.9904049155242876), FRAC_CONST(0.9906058432974180), FRAC_CONST(0.9908034198831690), FRAC_CONST(0.9909976845686489), FRAC_CONST(0.9911886764541239),
    FRAC_CONST(0.9913764344498495), FRAC_CONST(0.9915609972729590), FRAC_CONST(0.9917424034444086), FRAC_CONST(0.9919206912859797), FRAC_CONST(0.9920958989173397), FRAC_CONST(0.9922680642531603),
    FRAC_CONST(0.9924372250002933), FRAC_CONST(0.9926034186550070), FRAC_CONST(0.9927666825002789), FRAC_CONST(0.9929270536031491), FRAC_CONST(0.9930845688121325), FRAC_CONST(0.9932392647546895),
    FRAC_CONST(0.9933911778347579), FRAC_CONST(0.9935403442303433), FRAC_CONST(0.9936867998911693), FRAC_CONST(0.9938305805363887), FRAC_CONST(0.9939717216523539), FRAC_CONST(0.9941102584904481),
    FRAC_CONST(0.9942462260649764), FRAC_CONST(0.9943796591511174), FRAC_CONST(0.9945105922829353), FRAC_CONST(0.9946390597514524), FRAC_CONST(0.9947650956027824), FRAC_CONST(0.9948887336363228),
    FRAC_CONST(0.9950100074030103), FRAC_CONST(0.9951289502036336), FRAC_CONST(0.9952455950872091), FRAC_CONST(0.9953599748494155), FRAC_CONST(0.9954721220310890), FRAC_CONST(0.9955820689167787),
    FRAC_CONST(0.9956898475333619), FRAC_CONST(0.9957954896487196), FRAC_CONST(0.9958990267704713), FRAC_CONST(0.9960004901447701), FRAC_CONST(0.9960999107551559), FRAC_CONST(0.9961973193214694),
    FRAC_CONST(0.9962927462988245), FRAC_CONST(0.9963862218766388), FRAC_CONST(0.9964777759777242), FRAC_CONST(0.9965674382574342), FRAC_CONST(0.9966552381028704), FRAC_CONST(0.9967412046321465),
    FRAC_CONST(0.9968253666937095), FRAC_CONST(0.9969077528657186), FRAC_CONST(0.9969883914554805), FRAC_CONST(0.9970673104989413), FRAC_CONST(0.9971445377602348), FRAC_CONST(0.9972201007312871),
    FRAC_CONST(0.9972940266314749), FRAC_CONST(0.9973663424073412), FRAC_CONST(0.9974370747323638), FRAC_CONST(0.9975062500067785), FRAC_CONST(0.9975738943574574), FRAC_CONST(0.9976400336378379),
    FRAC_CONST(0.9977046934279079), FRAC_CONST(0.9977678990342401), FRAC_CONST(0.9978296754900812), FRAC_CONST(0.9978900475554902), FRAC_CONST(0.9979490397175296), FRAC_CONST(0.9980066761905056),
    FRAC_CONST(0.9980629809162593), FRAC_CONST(0.9981179775645063), FRAC_CONST(0.9981716895332257), FRAC_CONST(0.9982241399490979), FRAC_CONST(0.9982753516679893), FRAC_CONST(0.9983253472754841),
    FRAC_CONST(0.9983741490874634), FRAC_CONST(0.9984217791507299), FRAC_CONST(0.9984682592436778), FRAC_CONST(0.9985136108770075), FRAC_CONST(0.9985578552944850), FRAC_CONST(0.9986010134737439),
    FRAC_CONST(0.9986431061271304), FRAC_CONST(0.9986841537025921), FRAC_CONST(0.9987241763846056), FRAC_CONST(0.9987631940951476), FRAC_CONST(0.9988012264947044), FRAC_CONST(0.9988382929833222),
    FRAC_CONST(0.9988744127016956), FRAC_CONST(0.9989096045322947), FRAC_CONST(0.9989438871005292), FRAC_CONST(0.9989772787759494), FRAC_CONST(0.9990097976734847), FRAC_CONST(0.9990414616547146),
    FRAC_CONST(0.9990722883291779), FRAC_CONST(0.9991022950557125), FRAC_CONST(0.9991314989438310), FRAC_CONST(0.9991599168551279), FRAC_CONST(0.9991875654047181), FRAC_CONST(0.9992144609627068),
    FRAC_CONST(0.9992406196556911), FRAC_CONST(0.9992660573682882), FRAC_CONST(0.9992907897446957), FRAC_CONST(0.9993148321902777), FRAC_CONST(0.9993381998731797), FRAC_CONST(0.9993609077259696),
    FRAC_CONST(0.9993829704473038), FRAC_CONST(0.9994044025036201), FRAC_CONST(0.9994252181308537), FRAC_CONST(0.9994454313361775), FRAC_CONST(0.9994650558997651), FRAC_CONST(0.9994841053765757),
    FRAC_CONST(0.9995025930981609), FRAC_CONST(0.9995205321744921), FRAC_CONST(0.9995379354958073), FRAC_CONST(0.9995548157344778), FRAC_CONST(0.9995711853468930), FRAC_CONST(0.9995870565753632),
    FRAC_CONST(0.9996024414500382), FRAC_CONST(0.9996173517908444), FRAC_CONST(0.9996317992094352), FRAC_CONST(0.9996457951111574), FRAC_CONST(0.9996593506970310), FRAC_CONST(0.9996724769657434),
    FRAC_CONST(0.9996851847156547), FRAC_CONST(0.9996974845468164), FRAC_CONST(0.9997093868630000), FRAC_CONST(0.9997209018737374), FRAC_CONST(0.9997320395963699), FRAC_CONST(0.9997428098581069),
    FRAC_CONST(0.9997532222980933), FRAC_CONST(0.9997632863694836), FRAC_CONST(0.9997730113415246), FRAC_CONST(0.9997824063016426), FRAC_CONST(0.9997914801575380), FRAC_CONST(0.9998002416392840),
    FRAC_CONST(0.9998086993014300), FRAC_CONST(0.9998168615251084), FRAC_CONST(0.9998247365201450), FRAC_CONST(0.9998323323271717), FRAC_CONST(0.9998396568197407), FRAC_CONST(0.9998467177064404),
    FRAC_CONST(0.9998535225330116), FRAC_CONST(0.9998600786844637), FRAC_CONST(0.9998663933871905), FRAC_CONST(0.9998724737110845), FRAC_CONST(0.9998783265716498), FRAC_CONST(0.9998839587321121),
    FRAC_CONST(0.9998893768055266), FRAC_CONST(0.9998945872568815), FRAC_CONST(0.9998995964051983), FRAC_CONST(0.9999044104256269), FRAC_CONST(0.9999090353515359), FRAC_CONST(0.9999134770765971),
    FRAC_CONST(0.9999177413568642), FRAC_CONST(0.9999218338128448), FRAC_CONST(0.9999257599315647), FRAC_CONST(0.9999295250686255), FRAC_CONST(0.9999331344502529), FRAC_CONST(0.9999365931753376),
    FRAC_CONST(0.9999399062174669), FRAC_CONST(0.9999430784269460), FRAC_CONST(0.9999461145328103), FRAC_CONST(0.9999490191448277), FRAC_CONST(0.9999517967554878), FRAC_CONST(0.9999544517419835),
    FRAC_CONST(0.9999569883681778), FRAC_CONST(0.9999594107865607), FRAC_CONST(0.9999617230401926), FRAC_CONST(0.9999639290646355), FRAC_CONST(0.9999660326898712), FRAC_CONST(0.9999680376422052),
    FRAC_CONST(0.9999699475461585), FRAC_CONST(0.9999717659263435), FRAC_CONST(0.9999734962093266), FRAC_CONST(0.9999751417254756), FRAC_CONST(0.9999767057107922), FRAC_CONST(0.9999781913087290),
    FRAC_CONST(0.9999796015719915), FRAC_CONST(0.9999809394643231), FRAC_CONST(0.9999822078622751), FRAC_CONST(0.9999834095569596), FRAC_CONST(0.9999845472557860), FRAC_CONST(0.9999856235841805),
    FRAC_CONST(0.9999866410872889), FRAC_CONST(0.9999876022316609), FRAC_CONST(0.9999885094069193), FRAC_CONST(0.9999893649274085), FRAC_CONST(0.9999901710338274), FRAC_CONST(0.9999909298948430),
    FRAC_CONST(0.9999916436086862), FRAC_CONST(0.9999923142047299), FRAC_CONST(0.9999929436450469), FRAC_CONST(0.9999935338259505), FRAC_CONST(0.9999940865795161), FRAC_CONST(0.9999946036750835),
    FRAC_CONST(0.9999950868207405), FRAC_CONST(0.9999955376647868), FRAC_CONST(0.9999959577971798), FRAC_CONST(0.9999963487509599), FRAC_CONST(0.9999967120036571), FRAC_CONST(0.9999970489786785),
    FRAC_CONST(0.9999973610466748), FRAC_CONST(0.9999976495268890), FRAC_CONST(0.9999979156884846), FRAC_CONST(0.9999981607518545), FRAC_CONST(0.9999983858899099), FRAC_CONST(0.9999985922293493),
    FRAC_CONST(0.9999987808519092), FRAC_CONST(0.9999989527955938), FRAC_CONST(0.9999991090558848), FRAC_CONST(0.9999992505869332), FRAC_CONST(0.9999993783027293), FRAC_CONST(0.9999994930782556),
    FRAC_CONST(0.9999995957506171), FRAC_CONST(0.9999996871201549), FRAC_CONST(0.9999997679515386), FRAC_CONST(0.9999998389748399), FRAC_CONST(0.9999999008865869), FRAC_CONST(0.9999999543507984)};
#endif
static const real_t kbd_short_128[] = {
    FRAC_CONST(4.3795702929468881e-005), FRAC_CONST(0.00011867384265436617), FRAC_CONST(0.0002307165763996192), FRAC_CONST(0.00038947282760568383), FRAC_CONST(0.00060581272288302553),
    FRAC_CONST(0.00089199695169487453),  FRAC_CONST(0.0012617254423430522),  FRAC_CONST(0.0017301724373162003), FRAC_CONST(0.0023140071937421476),  FRAC_CONST(0.0030313989666022221),
    FRAC_CONST(0.0039020049735530842),   FRAC_CONST(0.0049469401815512024),  FRAC_CONST(0.0061887279335368318), FRAC_CONST(0.0076512306364647726),  FRAC_CONST(0.0093595599562652423),
    FRAC_CONST(0.011339966208377799),    FRAC_CONST(0.013619706891715299),   FRAC_CONST(0.016226894586323766),  FRAC_CONST(0.019190324717288168),   FRAC_CONST(0.022539283975960878),
    FRAC_CONST(0.026303340480472455),    FRAC_CONST(0.030512117046644357),   FRAC_CONST(0.03519504922365594),   FRAC_CONST(0.040381130021856941),   FRAC_CONST(0.046098643518702249),
    FRAC_CONST(0.052374889768730587),    FRAC_CONST(0.059235903660769147),   FRAC_CONST(0.066706170556282418),  FRAC_CONST(0.074808341703430481),   FRAC_CONST(0.083562952548726227),
    FRAC_CONST(0.092988147159339674),    FRAC_CONST(0.1030994120216919),     FRAC_CONST(0.11390932249409955),   FRAC_CONST(0.12542730516149531),    FRAC_CONST(0.13765941926783826),
    FRAC_CONST(0.15060816028651081),     FRAC_CONST(0.16427228853114245),    FRAC_CONST(0.17864668550988483),   FRAC_CONST(0.19372224048676889),    FRAC_CONST(0.20948576943658073),
    FRAC_CONST(0.22591996826744942),     FRAC_CONST(0.24300340184133981),    FRAC_CONST(0.26071052995068139),   FRAC_CONST(0.27901177101369551),    FRAC_CONST(0.29787360383626599),
    FRAC_CONST(0.3172587073594233),      FRAC_CONST(0.33712613787396362),    FRAC_CONST(0.35743154274286698),   FRAC_CONST(0.37812740923363009),    FRAC_CONST(0.39916334663203618),
    FRAC_CONST(0.42048639939189658),     FRAC_CONST(0.4420413886774246),     FRAC_CONST(0.4637712792815169),    FRAC_CONST(0.4856175685594023),     FRAC_CONST(0.50752069370766872),
    FRAC_CONST(0.52942045344797806),     FRAC_CONST(0.55125643994680196),    FRAC_CONST(0.57296847662071559),   FRAC_CONST(0.59449705734411495),    FRAC_CONST(0.61578378249506627),
    FRAC_CONST(0.63677178724712891),     FRAC_CONST(0.65740615754163356),    FRAC_CONST(0.67763432925662526),   FRAC_CONST(0.69740646622548552),    FRAC_CONST(0.71667581294953808),
    FRAC_CONST(0.73539901809352737),     FRAC_CONST(0.75353642514900732),    FRAC_CONST(0.77105232699609816),   FRAC_CONST(0.78791518148597028),    FRAC_CONST(0.80409778560147072),
    FRAC_CONST(0.81957740622770781),     FRAC_CONST(0.83433586607383625),    FRAC_CONST(0.84835958382689225),   FRAC_CONST(0.86163956818294229),    FRAC_CONST(0.87417136598406997),
    FRAC_CONST(0.88595496528524853),     FRAC_CONST(0.89699465477567619),    FRAC_CONST(0.90729884157670959),   FRAC_CONST(0.91687983002436779),    FRAC_CONST(0.92575356460899649),
    FRAC_CONST(0.93393934077779084),     FRAC_CONST(0.94145948779657318),    FRAC_CONST(0.94833902830402828),   FRAC_CONST(0.95460531956280026),    FRAC_CONST(0.96028768170574896),
    FRAC_CONST(0.96541701848104766),     FRAC_CONST(0.97002543610646474),    FRAC_CONST(0.97414586584250062),   FRAC_CONST(0.97781169577969584),    FRAC_CONST(0.98105641710392333),
    FRAC_CONST(0.98391328975491177),     FRAC_CONST(0.98641503193166202),    FRAC_CONST(0.98859353733226141),   FRAC_CONST(0.99047962335771556),    FRAC_CONST(0.9921028127769449),
    FRAC_CONST(0.99349115056397752),     FRAC_CONST(0.99467105680259038),    FRAC_CONST(0.9956672157341897),    FRAC_CONST(0.99650250022834352),    FRAC_CONST(0.99719793020823266),
    FRAC_CONST(0.99777266288955657),     FRAC_CONST(0.99824401211201486),    FRAC_CONST(0.99862749357391212),   FRAC_CONST(0.99893689243401962),    FRAC_CONST(0.99918434952623147),
    FRAC_CONST(0.99938046234161726),     FRAC_CONST(0.99953439696357238),    FRAC_CONST(0.99965400728430465),   FRAC_CONST(0.99974595807027455),    FRAC_CONST(0.99981584876278362),
    FRAC_CONST(0.99986833527824281),     FRAC_CONST(0.99990724749057802),    FRAC_CONST(0.99993570051598468),   FRAC_CONST(0.99995619835942084),    FRAC_CONST(0.99997072890647543),
    FRAC_CONST(0.9999808496399144),      FRAC_CONST(0.99998776381655818),    FRAC_CONST(0.99999238714961569),   FRAC_CONST(0.99999540529959718),    FRAC_CONST(0.99999732268176988),
    FRAC_CONST(0.99999850325054862),     FRAC_CONST(0.99999920402413744),    FRAC_CONST(0.9999996021706401),    FRAC_CONST(0.99999981649545566),    FRAC_CONST(0.99999992415545547),
    FRAC_CONST(0.99999997338493041),     FRAC_CONST(0.99999999295825959),    FRAC_CONST(0.99999999904096815)};
#ifdef ALLOW_SMALL_FRAMELENGTH
static const real_t kbd_short_120[] = {
    FRAC_CONST(0.0000452320086910), FRAC_CONST(0.0001274564692111), FRAC_CONST(0.0002529398385345), FRAC_CONST(0.0004335140496648), FRAC_CONST(0.0006827100966952), FRAC_CONST(0.0010158708222246),
    FRAC_CONST(0.0014502162869659), FRAC_CONST(0.0020048865156264), FRAC_CONST(0.0027009618393178), FRAC_CONST(0.0035614590925043), FRAC_CONST(0.0046113018122711), FRAC_CONST(0.0058772627936484),
    FRAC_CONST(0.0073878776584103), FRAC_CONST(0.0091733284512589), FRAC_CONST(0.0112652966728373), FRAC_CONST(0.0136967855861945), FRAC_CONST(0.0165019120857793), FRAC_CONST(0.0197156688892217),
    FRAC_CONST(0.0233736582950619), FRAC_CONST(0.0275117992367496), FRAC_CONST(0.0321660098468534), FRAC_CONST(0.0373718682174417), FRAC_CONST(0.0431642544948834), FRAC_CONST(0.0495769778717676),
    FRAC_CONST(0.0566423924273392), FRAC_CONST(0.0643910061132260), FRAC_CONST(0.0728510874761729), FRAC_CONST(0.0820482749475221), FRAC_CONST(0.0920051937045235), FRAC_CONST(0.1027410852163450),
    FRAC_CONST(0.1142714546239370), FRAC_CONST(0.1266077410648368), FRAC_CONST(0.1397570159398145), FRAC_CONST(0.1537217139274270), FRAC_CONST(0.1684994012857075), FRAC_CONST(0.1840825856392944),
    FRAC_CONST(0.2004585710384133), FRAC_CONST(0.2176093615976121), FRAC_CONST(0.2355116164824983), FRAC_CONST(0.2541366584185075), FRAC_CONST(0.2734505372545160), FRAC_CONST(0.2934141494343369),
    FRAC_CONST(0.3139834135200387), FRAC_CONST(0.3351095011824163), FRAC_CONST(0.3567391223361566), FRAC_CONST(0.3788148623608774), FRAC_CONST(0.4012755686250732), FRAC_CONST(0.4240567828288110),
    FRAC_CONST(0.4470912150133537), FRAC_CONST(0.4703092544619664), FRAC_CONST(0.4936395121456694), FRAC_CONST(0.5170093888596962), FRAC_CONST(0.5403456627591340), FRAC_CONST(0.5635750896430154),
    FRAC_CONST(0.5866250090612892), FRAC_CONST(0.6094239491338723), FRAC_CONST(0.6319022228794100), FRAC_CONST(0.6539925088563087), FRAC_CONST(0.6756304090216887), FRAC_CONST(0.6967549769155277),
    FRAC_CONST(0.7173092095766250), FRAC_CONST(0.7372404969921184), FRAC_CONST(0.7565010233699827), FRAC_CONST(0.7750481150999984), FRAC_CONST(0.7928445309277697), FRAC_CONST(0.8098586906021583),
    FRAC_CONST(0.8260648390616000), FRAC_CONST(0.8414431440907889), FRAC_CONST(0.8559797262966709), FRAC_CONST(0.8696666212110165), FRAC_CONST(0.8825016743142358), FRAC_CONST(0.8944883707784486),
    FRAC_CONST(0.9056356027326216), FRAC_CONST(0.9159573778427816), FRAC_CONST(0.9254724739583072), FRAC_CONST(0.9342040454819434), FRAC_CONST(0.9421791879559176), FRAC_CONST(0.9494284680976784),
    FRAC_CONST(0.9559854271440150), FRAC_CONST(0.9618860658493898), FRAC_CONST(0.9671683198119525), FRAC_CONST(0.9718715339497299), FRAC_CONST(0.9760359449042233), FRAC_CONST(0.9797021798981759),
    FRAC_CONST(0.9829107801140203), FRAC_CONST(0.9857017559923277), FRAC_CONST(0.9881141809867999), FRAC_CONST(0.9901858292742826), FRAC_CONST(0.9919528617340944), FRAC_CONST(0.9934495632180476),
    FRAC_CONST(0.9947081327749199), FRAC_CONST(0.9957585271195989), FRAC_CONST(0.9966283562984427), FRAC_CONST(0.9973428292485683), FRAC_CONST(0.9979247458259197), FRAC_CONST(0.9983945309245774),
    FRAC_CONST(0.9987703055583410), FRAC_CONST(0.9990679892449266), FRAC_CONST(0.9993014277313617), FRAC_CONST(0.9994825400228521), FRAC_CONST(0.9996214788122335), FRAC_CONST(0.9997267987294857),
    FRAC_CONST(0.9998056273097539), FRAC_CONST(0.9998638341781910), FRAC_CONST(0.9999061946325793), FRAC_CONST(0.9999365445321382), FRAC_CONST(0.9999579241373735), FRAC_CONST(0.9999727092594598),
    FRAC_CONST(0.9999827287418790), FRAC_CONST(0.9999893678912771), FRAC_CONST(0.9999936579844555), FRAC_CONST(0.9999963523959187), FRAC_CONST(0.9999979902130101), FRAC_CONST(0.9999989484358076),
    FRAC_CONST(0.9999994840031031), FRAC_CONST(0.9999997669534347), FRAC_CONST(0.9999999060327799), FRAC_CONST(0.9999999680107184), FRAC_CONST(0.9999999918774242), FRAC_CONST(0.9999999989770326)};
#endif
// ——————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
static const real_t sine_long_1024[] = {
    FRAC_CONST(0.00076699031874270449), FRAC_CONST(0.002300969151425805),  FRAC_CONST(0.0038349425697062275), FRAC_CONST(0.0053689069639963425), FRAC_CONST(0.0069028587247297558),
    FRAC_CONST(0.0084367942423697988),  FRAC_CONST(0.0099707099074180308), FRAC_CONST(0.011504602110422714),  FRAC_CONST(0.013038467241987334),  FRAC_CONST(0.014572301692779064),
    FRAC_CONST(0.016106101853537287),   FRAC_CONST(0.017639864115082053),  FRAC_CONST(0.019173584868322623),  FRAC_CONST(0.020707260504265895),  FRAC_CONST(0.022240887414024961),
    FRAC_CONST(0.023774461988827555),   FRAC_CONST(0.025307980620024571),  FRAC_CONST(0.026841439699098531),  FRAC_CONST(0.028374835617672099),  FRAC_CONST(0.029908164767516555),
    FRAC_CONST(0.031441423540560301),   FRAC_CONST(0.032974608328897335),  FRAC_CONST(0.03450771552479575),   FRAC_CONST(0.036040741520706229),  FRAC_CONST(0.037573682709270494),
    FRAC_CONST(0.039106535483329888),   FRAC_CONST(0.040639296235933736),  FRAC_CONST(0.042171961360347947),  FRAC_CONST(0.043704527250063421),  FRAC_CONST(0.04523699029880459),
    FRAC_CONST(0.046769346900537863),   FRAC_CONST(0.048301593449480144),  FRAC_CONST(0.049833726340107277),  FRAC_CONST(0.051365741967162593),  FRAC_CONST(0.052897636725665324),
    FRAC_CONST(0.054429407010919133),   FRAC_CONST(0.055961049218520569),  FRAC_CONST(0.057492559744367566),  FRAC_CONST(0.059023934984667931),  FRAC_CONST(0.060555171335947788),
    FRAC_CONST(0.062086265195060088),   FRAC_CONST(0.063617212959193106),  FRAC_CONST(0.065148011025878833),  FRAC_CONST(0.066678655793001557),  FRAC_CONST(0.068209143658806329),
    FRAC_CONST(0.069739471021907307),   FRAC_CONST(0.071269634281296401),  FRAC_CONST(0.072799629836351673),  FRAC_CONST(0.074329454086845756),  FRAC_CONST(0.075859103432954447),
    FRAC_CONST(0.077388574275265049),   FRAC_CONST(0.078917863014784942),  FRAC_CONST(0.080446966052950014),  FRAC_CONST(0.081975879791633066),  FRAC_CONST(0.083504600633152432),
    FRAC_CONST(0.085033124980280275),   FRAC_CONST(0.08656144923625117),   FRAC_CONST(0.088089569804770507),  FRAC_CONST(0.089617483090022959),  FRAC_CONST(0.091145185496681005),
    FRAC_CONST(0.09267267342991331),    FRAC_CONST(0.094199943295393204),  FRAC_CONST(0.095726991499307162),  FRAC_CONST(0.097253814448363271),  FRAC_CONST(0.098780408549799623),
    FRAC_CONST(0.10030677021139286),    FRAC_CONST(0.10183289584146653),   FRAC_CONST(0.10335878184889961),   FRAC_CONST(0.10488442464313497),   FRAC_CONST(0.10640982063418768),
    FRAC_CONST(0.10793496623265365),    FRAC_CONST(0.10945985784971798),   FRAC_CONST(0.11098449189716339),   FRAC_CONST(0.11250886478737869),   FRAC_CONST(0.1140329729333672),
    FRAC_CONST(0.11555681274875526),    FRAC_CONST(0.11708038064780059),   FRAC_CONST(0.11860367304540072),   FRAC_CONST(0.1201266863571015),    FRAC_CONST(0.12164941699910553),
    FRAC_CONST(0.12317186138828048),    FRAC_CONST(0.12469401594216764),   FRAC_CONST(0.12621587707899035),   FRAC_CONST(0.12773744121766231),   FRAC_CONST(0.12925870477779614),
    FRAC_CONST(0.13077966417971171),    FRAC_CONST(0.13230031584444465),   FRAC_CONST(0.13382065619375472),   FRAC_CONST(0.13534068165013421),   FRAC_CONST(0.13686038863681638),
    FRAC_CONST(0.13837977357778389),    FRAC_CONST(0.13989883289777721),   FRAC_CONST(0.14141756302230302),   FRAC_CONST(0.14293596037764267),   FRAC_CONST(0.14445402139086047),
    FRAC_CONST(0.14597174248981221),    FRAC_CONST(0.14748912010315357),   FRAC_CONST(0.14900615066034845),   FRAC_CONST(0.1505228305916774),    FRAC_CONST(0.15203915632824605),
    FRAC_CONST(0.15355512430199345),    FRAC_CONST(0.15507073094570051),   FRAC_CONST(0.15658597269299843),   FRAC_CONST(0.15810084597837698),   FRAC_CONST(0.15961534723719306),
    FRAC_CONST(0.16112947290567881),    FRAC_CONST(0.16264321942095031),   FRAC_CONST(0.16415658322101581),   FRAC_CONST(0.16566956074478412),   FRAC_CONST(0.16718214843207294),
    FRAC_CONST(0.16869434272361733),    FRAC_CONST(0.17020614006107807),   FRAC_CONST(0.17171753688704997),   FRAC_CONST(0.17322852964507032),   FRAC_CONST(0.1747391147796272),
    FRAC_CONST(0.17624928873616788),    FRAC_CONST(0.17775904796110717),   FRAC_CONST(0.17926838890183575),   FRAC_CONST(0.18077730800672859),   FRAC_CONST(0.1822858017251533),
    FRAC_CONST(0.18379386650747845),    FRAC_CONST(0.1853014988050819),    FRAC_CONST(0.18680869507035927),   FRAC_CONST(0.18831545175673212),   FRAC_CONST(0.18982176531865641),
    FRAC_CONST(0.1913276322116309),     FRAC_CONST(0.19283304889220523),   FRAC_CONST(0.1943380118179886),    FRAC_CONST(0.19584251744765785),   FRAC_CONST(0.19734656224096592),
    FRAC_CONST(0.19885014265875009),    FRAC_CONST(0.20035325516294045),   FRAC_CONST(0.20185589621656805),   FRAC_CONST(0.20335806228377332),   FRAC_CONST(0.20485974982981442),
    FRAC_CONST(0.20636095532107551),    FRAC_CONST(0.20786167522507507),   FRAC_CONST(0.20936190601047416),   FRAC_CONST(0.21086164414708486),   FRAC_CONST(0.21236088610587842),
    FRAC_CONST(0.21385962835899375),    FRAC_CONST(0.21535786737974555),   FRAC_CONST(0.21685559964263262),   FRAC_CONST(0.21835282162334632),   FRAC_CONST(0.2198495297987787),
    FRAC_CONST(0.22134572064703081),    FRAC_CONST(0.22284139064742112),   FRAC_CONST(0.2243365362804936),    FRAC_CONST(0.22583115402802617),   FRAC_CONST(0.22732524037303886),
    FRAC_CONST(0.22881879179980222),    FRAC_CONST(0.23031180479384544),   FRAC_CONST(0.23180427584196478),   FRAC_CONST(0.23329620143223159),   FRAC_CONST(0.23478757805400097),
    FRAC_CONST(0.23627840219791957),    FRAC_CONST(0.23776867035593419),   FRAC_CONST(0.23925837902129998),   FRAC_CONST(0.24074752468858843),   FRAC_CONST(0.24223610385369601),
    FRAC_CONST(0.24372411301385216),    FRAC_CONST(0.24521154866762754),   FRAC_CONST(0.24669840731494241),   FRAC_CONST(0.24818468545707478),   FRAC_CONST(0.24967037959666857),
    FRAC_CONST(0.25115548623774192),    FRAC_CONST(0.25264000188569552),   FRAC_CONST(0.25412392304732062),   FRAC_CONST(0.25560724623080738),   FRAC_CONST(0.25708996794575312),
    FRAC_CONST(0.25857208470317034),    FRAC_CONST(0.26005359301549519),   FRAC_CONST(0.26153448939659552),   FRAC_CONST(0.263014770361779),     FRAC_CONST(0.26449443242780163),
    FRAC_CONST(0.26597347211287559),    FRAC_CONST(0.26745188593667762),   FRAC_CONST(0.26892967042035726),   FRAC_CONST(0.27040682208654482),   FRAC_CONST(0.27188333745935972),
    FRAC_CONST(0.27335921306441868),    FRAC_CONST(0.27483444542884394),   FRAC_CONST(0.27630903108127108),   FRAC_CONST(0.27778296655185769),   FRAC_CONST(0.27925624837229118),
    FRAC_CONST(0.28072887307579719),    FRAC_CONST(0.28220083719714756),   FRAC_CONST(0.28367213727266843),   FRAC_CONST(0.28514276984024867),   FRAC_CONST(0.28661273143934779),
    FRAC_CONST(0.28808201861100413),    FRAC_CONST(0.28955062789784303),   FRAC_CONST(0.29101855584408509),   FRAC_CONST(0.29248579899555388),   FRAC_CONST(0.29395235389968466),
    FRAC_CONST(0.29541821710553201),    FRAC_CONST(0.29688338516377827),   FRAC_CONST(0.2983478546267414),    FRAC_CONST(0.29981162204838335),   FRAC_CONST(0.30127468398431795),
    FRAC_CONST(0.30273703699181914),    FRAC_CONST(0.30419867762982911),   FRAC_CONST(0.30565960245896612),   FRAC_CONST(0.3071198080415331),    FRAC_CONST(0.30857929094152509),
    FRAC_CONST(0.31003804772463789),    FRAC_CONST(0.31149607495827591),   FRAC_CONST(0.3129533692115602),    FRAC_CONST(0.31440992705533666),   FRAC_CONST(0.31586574506218396),
    FRAC_CONST(0.31732081980642174),    FRAC_CONST(0.31877514786411848),   FRAC_CONST(0.32022872581309986),   FRAC_CONST(0.32168155023295658),   FRAC_CONST(0.32313361770505233),
    FRAC_CONST(0.32458492481253215),    FRAC_CONST(0.32603546814033024),   FRAC_CONST(0.327485244275178),     FRAC_CONST(0.3289342498056122),    FRAC_CONST(0.33038248132198278),
    FRAC_CONST(0.33182993541646111),    FRAC_CONST(0.33327660868304793),   FRAC_CONST(0.33472249771758122),   FRAC_CONST(0.33616759911774452),   FRAC_CONST(0.33761190948307462),
    FRAC_CONST(0.33905542541496964),    FRAC_CONST(0.34049814351669716),   FRAC_CONST(0.34194006039340219),   FRAC_CONST(0.34338117265211504),   FRAC_CONST(0.34482147690175929),
    FRAC_CONST(0.34626096975316001),    FRAC_CONST(0.34769964781905138),   FRAC_CONST(0.34913750771408497),   FRAC_CONST(0.35057454605483751),   FRAC_CONST(0.35201075945981908),
    FRAC_CONST(0.35344614454948081),    FRAC_CONST(0.35488069794622279),   FRAC_CONST(0.35631441627440241),   FRAC_CONST(0.3577472961603419),    FRAC_CONST(0.3591793342323365),
    FRAC_CONST(0.36061052712066227),    FRAC_CONST(0.36204087145758418),   FRAC_CONST(0.36347036387736376),   FRAC_CONST(0.36489900101626732),   FRAC_CONST(0.36632677951257359),
    FRAC_CONST(0.36775369600658198),    FRAC_CONST(0.36917974714062002),   FRAC_CONST(0.37060492955905167),   FRAC_CONST(0.37202923990828501),   FRAC_CONST(0.3734526748367803),
    FRAC_CONST(0.37487523099505754),    FRAC_CONST(0.37629690503570479),   FRAC_CONST(0.37771769361338564),   FRAC_CONST(0.37913759338484732),   FRAC_CONST(0.38055660100892852),
    FRAC_CONST(0.38197471314656722),    FRAC_CONST(0.38339192646080866),   FRAC_CONST(0.38480823761681288),   FRAC_CONST(0.38622364328186298),   FRAC_CONST(0.38763814012537273),
    FRAC_CONST(0.38905172481889438),    FRAC_CONST(0.39046439403612659),   FRAC_CONST(0.39187614445292235),   FRAC_CONST(0.3932869727472964),    FRAC_CONST(0.39469687559943356),
    FRAC_CONST(0.39610584969169627),    FRAC_CONST(0.39751389170863233),   FRAC_CONST(0.39892099833698291),   FRAC_CONST(0.40032716626569009),   FRAC_CONST(0.40173239218590501),
    FRAC_CONST(0.4031366727909953),     FRAC_CONST(0.404540004776553),     FRAC_CONST(0.40594238484040251),   FRAC_CONST(0.40734380968260797),   FRAC_CONST(0.40874427600548136),
    FRAC_CONST(0.41014378051359024),    FRAC_CONST(0.41154231991376522),   FRAC_CONST(0.41293989091510808),   FRAC_CONST(0.4143364902289991),    FRAC_CONST(0.41573211456910536),
    FRAC_CONST(0.41712676065138787),    FRAC_CONST(0.4185204251941097),    FRAC_CONST(0.41991310491784362),   FRAC_CONST(0.42130479654547964),   FRAC_CONST(0.42269549680223295),
    FRAC_CONST(0.42408520241565156),    FRAC_CONST(0.4254739101156238),    FRAC_CONST(0.42686161663438643),   FRAC_CONST(0.42824831870653196),   FRAC_CONST(0.42963401306901638),
    FRAC_CONST(0.43101869646116703),    FRAC_CONST(0.43240236562469014),   FRAC_CONST(0.43378501730367852),   FRAC_CONST(0.43516664824461926),   FRAC_CONST(0.4365472551964012),
    FRAC_CONST(0.43792683491032286),    FRAC_CONST(0.43930538414009995),   FRAC_CONST(0.4406828996418729),    FRAC_CONST(0.4420593781742147),    FRAC_CONST(0.44343481649813848),
    FRAC_CONST(0.44480921137710488),    FRAC_CONST(0.44618255957703007),   FRAC_CONST(0.44755485786629301),   FRAC_CONST(0.44892610301574326),   FRAC_CONST(0.45029629179870861),
    FRAC_CONST(0.45166542099100249),    FRAC_CONST(0.45303348737093158),   FRAC_CONST(0.45440048771930358),   FRAC_CONST(0.45576641881943464),   FRAC_CONST(0.45713127745715698),
    FRAC_CONST(0.45849506042082627),    FRAC_CONST(0.45985776450132954),   FRAC_CONST(0.46121938649209238),   FRAC_CONST(0.46257992318908681),   FRAC_CONST(0.46393937139083852),
    FRAC_CONST(0.4652977278984346),     FRAC_CONST(0.46665498951553092),   FRAC_CONST(0.46801115304835983),   FRAC_CONST(0.46936621530573752),   FRAC_CONST(0.4707201730990716),
    FRAC_CONST(0.47207302324236866),    FRAC_CONST(0.47342476255224153),   FRAC_CONST(0.47477538784791712),   FRAC_CONST(0.47612489595124358),   FRAC_CONST(0.47747328368669806),
    FRAC_CONST(0.47882054788139389),    FRAC_CONST(0.48016668536508839),   FRAC_CONST(0.48151169297018986),   FRAC_CONST(0.48285556753176567),   FRAC_CONST(0.48419830588754903),
    FRAC_CONST(0.48553990487794696),    FRAC_CONST(0.48688036134604734),   FRAC_CONST(0.48821967213762679),   FRAC_CONST(0.48955783410115744),   FRAC_CONST(0.49089484408781509),
    FRAC_CONST(0.49223069895148602),    FRAC_CONST(0.49356539554877477),   FRAC_CONST(0.49489893073901126),   FRAC_CONST(0.49623130138425825),   FRAC_CONST(0.49756250434931915),
    FRAC_CONST(0.49889253650174459),    FRAC_CONST(0.50022139471184068),   FRAC_CONST(0.50154907585267539),   FRAC_CONST(0.50287557680008699),   FRAC_CONST(0.50420089443269034),
    FRAC_CONST(0.50552502563188539),    FRAC_CONST(0.50684796728186321),   FRAC_CONST(0.5081697162696146),    FRAC_CONST(0.50949026948493636),   FRAC_CONST(0.51080962382043904),
    FRAC_CONST(0.51212777617155469),    FRAC_CONST(0.51344472343654346),   FRAC_CONST(0.5147604625165012),    FRAC_CONST(0.51607499031536663),   FRAC_CONST(0.51738830373992906),
    FRAC_CONST(0.51870039969983495),    FRAC_CONST(0.52001127510759604),   FRAC_CONST(0.52132092687859566),   FRAC_CONST(0.52262935193109661),   FRAC_CONST(0.5239365471862486),
    FRAC_CONST(0.52524250956809471),    FRAC_CONST(0.52654723600357944),   FRAC_CONST(0.52785072342255523),   FRAC_CONST(0.52915296875779061),   FRAC_CONST(0.53045396894497632),
    FRAC_CONST(0.53175372092273332),    FRAC_CONST(0.53305222163261945),   FRAC_CONST(0.53434946801913752),   FRAC_CONST(0.53564545702974109),   FRAC_CONST(0.53694018561484291),
    FRAC_CONST(0.5382336507278217),     FRAC_CONST(0.53952584932502889),   FRAC_CONST(0.54081677836579667),   FRAC_CONST(0.54210643481244392),   FRAC_CONST(0.5433948156302848),
    FRAC_CONST(0.54468191778763453),    FRAC_CONST(0.54596773825581757),   FRAC_CONST(0.54725227400917409),   FRAC_CONST(0.54853552202506739),   FRAC_CONST(0.54981747928389091),
    FRAC_CONST(0.55109814276907543),    FRAC_CONST(0.55237750946709607),   FRAC_CONST(0.55365557636747931),   FRAC_CONST(0.55493234046281037),   FRAC_CONST(0.55620779874873993),
    FRAC_CONST(0.55748194822399155),    FRAC_CONST(0.55875478589036831),   FRAC_CONST(0.56002630875276038),   FRAC_CONST(0.56129651381915147),   FRAC_CONST(0.56256539810062656),
    FRAC_CONST(0.56383295861137817),    FRAC_CONST(0.56509919236871398),   FRAC_CONST(0.56636409639306384),   FRAC_CONST(0.56762766770798623),   FRAC_CONST(0.56888990334017586),
    FRAC_CONST(0.5701508003194703),     FRAC_CONST(0.57141035567885723),   FRAC_CONST(0.57266856645448116),   FRAC_CONST(0.57392542968565075),   FRAC_CONST(0.57518094241484508),
    FRAC_CONST(0.57643510168772183),    FRAC_CONST(0.5776879045531228),    FRAC_CONST(0.57893934806308178),   FRAC_CONST(0.58018942927283168),   FRAC_CONST(0.58143814524081017),
    FRAC_CONST(0.58268549302866846),    FRAC_CONST(0.58393146970127618),   FRAC_CONST(0.58517607232673041),   FRAC_CONST(0.5864192979763605),    FRAC_CONST(0.58766114372473666),
    FRAC_CONST(0.58890160664967572),    FRAC_CONST(0.59014068383224882),   FRAC_CONST(0.59137837235678758),   FRAC_CONST(0.59261466931089113),   FRAC_CONST(0.59384957178543363),
    FRAC_CONST(0.59508307687456996),    FRAC_CONST(0.59631518167574371),   FRAC_CONST(0.59754588328969316),   FRAC_CONST(0.59877517882045872),   FRAC_CONST(0.60000306537538894),
    FRAC_CONST(0.6012295400651485),     FRAC_CONST(0.60245460000372375),   FRAC_CONST(0.60367824230843037),   FRAC_CONST(0.60490046409991982),   FRAC_CONST(0.60612126250218612),
    FRAC_CONST(0.60734063464257293),    FRAC_CONST(0.60855857765177945),   FRAC_CONST(0.60977508866386843),   FRAC_CONST(0.61099016481627166),   FRAC_CONST(0.61220380324979795),
    FRAC_CONST(0.61341600110863859),    FRAC_CONST(0.61462675554037505),   FRAC_CONST(0.61583606369598509),   FRAC_CONST(0.61704392272984976),   FRAC_CONST(0.61825032979976025),
    FRAC_CONST(0.61945528206692402),    FRAC_CONST(0.62065877669597214),   FRAC_CONST(0.62186081085496536),   FRAC_CONST(0.62306138171540126),   FRAC_CONST(0.62426048645222065),
    FRAC_CONST(0.62545812224381436),    FRAC_CONST(0.62665428627202935),   FRAC_CONST(0.62784897572217646),   FRAC_CONST(0.629042187783036),     FRAC_CONST(0.63023391964686437),
    FRAC_CONST(0.63142416850940186),    FRAC_CONST(0.63261293156987741),   FRAC_CONST(0.63380020603101728),   FRAC_CONST(0.63498598909904946),   FRAC_CONST(0.63617027798371217),
    FRAC_CONST(0.63735306989825913),    FRAC_CONST(0.63853436205946679),   FRAC_CONST(0.63971415168764045),   FRAC_CONST(0.64089243600662138),   FRAC_CONST(0.64206921224379254),
    FRAC_CONST(0.64324447763008585),    FRAC_CONST(0.64441822939998838),   FRAC_CONST(0.64559046479154869),   FRAC_CONST(0.64676118104638392),   FRAC_CONST(0.64793037540968534),
    FRAC_CONST(0.64909804513022595),    FRAC_CONST(0.65026418746036585),   FRAC_CONST(0.65142879965605982),   FRAC_CONST(0.65259187897686244),   FRAC_CONST(0.65375342268593606),
    FRAC_CONST(0.65491342805005603),    FRAC_CONST(0.6560718923396176),    FRAC_CONST(0.65722881282864254),   FRAC_CONST(0.65838418679478505),   FRAC_CONST(0.65953801151933866),
    FRAC_CONST(0.6606902842872423),     FRAC_CONST(0.66184100238708687),   FRAC_CONST(0.66299016311112147),   FRAC_CONST(0.66413776375526001),   FRAC_CONST(0.66528380161908718),
    FRAC_CONST(0.66642827400586524),    FRAC_CONST(0.66757117822254031),   FRAC_CONST(0.66871251157974798),   FRAC_CONST(0.66985227139182102),   FRAC_CONST(0.67099045497679422),
    FRAC_CONST(0.67212705965641173),    FRAC_CONST(0.67326208275613297),   FRAC_CONST(0.67439552160513905),   FRAC_CONST(0.67552737353633852),   FRAC_CONST(0.67665763588637495),
    FRAC_CONST(0.6777863059956315),     FRAC_CONST(0.67891338120823841),   FRAC_CONST(0.68003885887207893),   FRAC_CONST(0.68116273633879543),   FRAC_CONST(0.68228501096379557),
    FRAC_CONST(0.68340568010625868),    FRAC_CONST(0.6845247411291423),    FRAC_CONST(0.68564219139918747),   FRAC_CONST(0.68675802828692589),   FRAC_CONST(0.68787224916668555),
    FRAC_CONST(0.68898485141659704),    FRAC_CONST(0.69009583241859995),   FRAC_CONST(0.69120518955844845),   FRAC_CONST(0.69231292022571822),   FRAC_CONST(0.69341902181381176),
    FRAC_CONST(0.69452349171996552),    FRAC_CONST(0.69562632734525487),   FRAC_CONST(0.6967275260946012),    FRAC_CONST(0.69782708537677729),   FRAC_CONST(0.69892500260441415),
    FRAC_CONST(0.70002127519400625),    FRAC_CONST(0.70111590056591866),   FRAC_CONST(0.70220887614439187),   FRAC_CONST(0.70330019935754873),   FRAC_CONST(0.70438986763740041),
    FRAC_CONST(0.7054778784198521),     FRAC_CONST(0.70656422914470951),   FRAC_CONST(0.70764891725568435),   FRAC_CONST(0.70873194020040065),   FRAC_CONST(0.70981329543040084),
    FRAC_CONST(0.71089298040115168),    FRAC_CONST(0.71197099257204999),   FRAC_CONST(0.71304732940642923),   FRAC_CONST(0.71412198837156471),   FRAC_CONST(0.71519496693868001),
    FRAC_CONST(0.71626626258295312),    FRAC_CONST(0.71733587278352173),   FRAC_CONST(0.71840379502348972),   FRAC_CONST(0.71947002678993299),   FRAC_CONST(0.72053456557390527),
    FRAC_CONST(0.72159740887044366),    FRAC_CONST(0.72265855417857561),   FRAC_CONST(0.72371799900132339),   FRAC_CONST(0.72477574084571128),   FRAC_CONST(0.72583177722277037),
    FRAC_CONST(0.72688610564754497),    FRAC_CONST(0.72793872363909862),   FRAC_CONST(0.72898962872051931),   FRAC_CONST(0.73003881841892615),   FRAC_CONST(0.73108629026547423),
    FRAC_CONST(0.73213204179536129),    FRAC_CONST(0.73317607054783274),   FRAC_CONST(0.73421837406618817),   FRAC_CONST(0.73525894989778673),   FRAC_CONST(0.73629779559405306),
    FRAC_CONST(0.73733490871048279),    FRAC_CONST(0.73837028680664851),   FRAC_CONST(0.73940392744620576),   FRAC_CONST(0.74043582819689802),   FRAC_CONST(0.74146598663056329),
    FRAC_CONST(0.74249440032313918),    FRAC_CONST(0.74352106685466912),   FRAC_CONST(0.74454598380930725),   FRAC_CONST(0.74556914877532543),   FRAC_CONST(0.74659055934511731),
    FRAC_CONST(0.74761021311520515),    FRAC_CONST(0.74862810768624533),   FRAC_CONST(0.74964424066303348),   FRAC_CONST(0.75065860965451059),   FRAC_CONST(0.75167121227376843),
    FRAC_CONST(0.75268204613805523),    FRAC_CONST(0.75369110886878121),   FRAC_CONST(0.75469839809152439),   FRAC_CONST(0.75570391143603588),   FRAC_CONST(0.75670764653624567),
    FRAC_CONST(0.75770960103026808),    FRAC_CONST(0.75870977256040739),   FRAC_CONST(0.75970815877316344),   FRAC_CONST(0.76070475731923692),   FRAC_CONST(0.76169956585353527),
    FRAC_CONST(0.76269258203517787),    FRAC_CONST(0.76368380352750187),   FRAC_CONST(0.76467322799806714),   FRAC_CONST(0.76566085311866239),   FRAC_CONST(0.76664667656531038),
    FRAC_CONST(0.76763069601827327),    FRAC_CONST(0.76861290916205827),   FRAC_CONST(0.76959331368542294),   FRAC_CONST(0.7705719072813807),    FRAC_CONST(0.7715486876472063),
    FRAC_CONST(0.77252365248444133),    FRAC_CONST(0.77349679949889905),   FRAC_CONST(0.77446812640067086),   FRAC_CONST(0.77543763090413043),   FRAC_CONST(0.77640531072794039),
    FRAC_CONST(0.7773711635950562),     FRAC_CONST(0.77833518723273309),   FRAC_CONST(0.7792973793725303),    FRAC_CONST(0.78025773775031659),   FRAC_CONST(0.78121626010627609),
    FRAC_CONST(0.7821729441849129),     FRAC_CONST(0.78312778773505731),   FRAC_CONST(0.78408078850986995),   FRAC_CONST(0.78503194426684808),   FRAC_CONST(0.78598125276783015),
    FRAC_CONST(0.7869287117790017),     FRAC_CONST(0.78787431907090011),   FRAC_CONST(0.78881807241842017),   FRAC_CONST(0.78975996960081907),   FRAC_CONST(0.79070000840172161),
    FRAC_CONST(0.79163818660912577),    FRAC_CONST(0.79257450201540758),   FRAC_CONST(0.79350895241732666),   FRAC_CONST(0.79444153561603059),   FRAC_CONST(0.79537224941706119),
    FRAC_CONST(0.79630109163035911),    FRAC_CONST(0.7972280600702687),    FRAC_CONST(0.79815315255554375),   FRAC_CONST(0.79907636690935235),   FRAC_CONST(0.79999770095928191),
    FRAC_CONST(0.8009171525373443),     FRAC_CONST(0.80183471947998131),   FRAC_CONST(0.80275039962806916),   FRAC_CONST(0.80366419082692409),   FRAC_CONST(0.804576090926307),
    FRAC_CONST(0.80548609778042912),    FRAC_CONST(0.80639420924795624),   FRAC_CONST(0.80730042319201445),   FRAC_CONST(0.80820473748019472),   FRAC_CONST(0.80910714998455813),
    FRAC_CONST(0.81000765858164114),    FRAC_CONST(0.81090626115245967),   FRAC_CONST(0.81180295558251536),   FRAC_CONST(0.81269773976179949),   FRAC_CONST(0.81359061158479851),
    FRAC_CONST(0.81448156895049861),    FRAC_CONST(0.81537060976239129),   FRAC_CONST(0.81625773192847739),   FRAC_CONST(0.81714293336127297),   FRAC_CONST(0.81802621197781344),
    FRAC_CONST(0.81890756569965895),    FRAC_CONST(0.81978699245289899),   FRAC_CONST(0.82066449016815746),   FRAC_CONST(0.82154005678059761),   FRAC_CONST(0.82241369022992639),
    FRAC_CONST(0.82328538846040011),    FRAC_CONST(0.82415514942082857),   FRAC_CONST(0.82502297106458022),   FRAC_CONST(0.82588885134958678),   FRAC_CONST(0.82675278823834852),
    FRAC_CONST(0.8276147796979384),     FRAC_CONST(0.82847482370000713),   FRAC_CONST(0.82933291822078825),   FRAC_CONST(0.83018906124110237),   FRAC_CONST(0.83104325074636232),
    FRAC_CONST(0.83189548472657759),    FRAC_CONST(0.83274576117635946),   FRAC_CONST(0.83359407809492514),   FRAC_CONST(0.83444043348610319),   FRAC_CONST(0.83528482535833737),
    FRAC_CONST(0.83612725172469216),    FRAC_CONST(0.83696771060285702),   FRAC_CONST(0.83780620001515094),   FRAC_CONST(0.8386427179885273),    FRAC_CONST(0.83947726255457855),
    FRAC_CONST(0.84030983174954077),    FRAC_CONST(0.84114042361429808),   FRAC_CONST(0.84196903619438768),   FRAC_CONST(0.84279566754000412),   FRAC_CONST(0.84362031570600404),
    FRAC_CONST(0.84444297875191066),    FRAC_CONST(0.84526365474191822),   FRAC_CONST(0.84608234174489694),   FRAC_CONST(0.84689903783439735),   FRAC_CONST(0.84771374108865427),
    FRAC_CONST(0.84852644959059265),    FRAC_CONST(0.84933716142783067),   FRAC_CONST(0.85014587469268521),   FRAC_CONST(0.85095258748217573),   FRAC_CONST(0.85175729789802912),
    FRAC_CONST(0.85256000404668397),    FRAC_CONST(0.85336070403929543),   FRAC_CONST(0.85415939599173873),   FRAC_CONST(0.85495607802461482),   FRAC_CONST(0.85575074826325392),
    FRAC_CONST(0.85654340483771996),    FRAC_CONST(0.85733404588281559),   FRAC_CONST(0.85812266953808602),   FRAC_CONST(0.8589092739478239),    FRAC_CONST(0.85969385726107261),
    FRAC_CONST(0.86047641763163207),    FRAC_CONST(0.86125695321806206),   FRAC_CONST(0.86203546218368721),   FRAC_CONST(0.86281194269660033),   FRAC_CONST(0.86358639292966799),
    FRAC_CONST(0.86435881106053403),    FRAC_CONST(0.86512919527162369),   FRAC_CONST(0.86589754375014882),   FRAC_CONST(0.86666385468811102),   FRAC_CONST(0.86742812628230692),
    FRAC_CONST(0.86819035673433131),    FRAC_CONST(0.86895054425058238),   FRAC_CONST(0.86970868704226556),   FRAC_CONST(0.87046478332539767),   FRAC_CONST(0.8712188313208109),
    FRAC_CONST(0.8719708292541577),     FRAC_CONST(0.8727207753559143),    FRAC_CONST(0.87346866786138488),   FRAC_CONST(0.8742145050107063),    FRAC_CONST(0.87495828504885154),
    FRAC_CONST(0.8757000062256346),     FRAC_CONST(0.87643966679571361),   FRAC_CONST(0.87717726501859594),   FRAC_CONST(0.87791279915864173),   FRAC_CONST(0.87864626748506813),
    FRAC_CONST(0.87937766827195318),    FRAC_CONST(0.88010699979824036),   FRAC_CONST(0.88083426034774204),   FRAC_CONST(0.88155944820914378),   FRAC_CONST(0.8822825616760086),
    FRAC_CONST(0.88300359904678072),    FRAC_CONST(0.88372255862478966),   FRAC_CONST(0.8844394387182537),    FRAC_CONST(0.88515423764028511),   FRAC_CONST(0.88586695370889279),
    FRAC_CONST(0.88657758524698704),    FRAC_CONST(0.88728613058238315),   FRAC_CONST(0.88799258804780556),   FRAC_CONST(0.88869695598089171),   FRAC_CONST(0.88939923272419552),
    FRAC_CONST(0.89009941662519221),    FRAC_CONST(0.89079750603628149),   FRAC_CONST(0.89149349931479138),   FRAC_CONST(0.89218739482298248),   FRAC_CONST(0.89287919092805168),
    FRAC_CONST(0.89356888600213602),    FRAC_CONST(0.89425647842231604),   FRAC_CONST(0.89494196657062075),   FRAC_CONST(0.89562534883403),      FRAC_CONST(0.89630662360447966),
    FRAC_CONST(0.89698578927886397),    FRAC_CONST(0.89766284425904075),   FRAC_CONST(0.89833778695183419),   FRAC_CONST(0.89901061576903907),   FRAC_CONST(0.89968132912742393),
    FRAC_CONST(0.9003499254487356),     FRAC_CONST(0.90101640315970233),   FRAC_CONST(0.90168076069203773),   FRAC_CONST(0.9023429964824442),    FRAC_CONST(0.90300310897261704),
    FRAC_CONST(0.90366109660924798),    FRAC_CONST(0.90431695784402832),   FRAC_CONST(0.90497069113365325),   FRAC_CONST(0.90562229493982516),   FRAC_CONST(0.90627176772925766),
    FRAC_CONST(0.90691910797367803),    FRAC_CONST(0.90756431414983252),   FRAC_CONST(0.9082073847394887),    FRAC_CONST(0.90884831822943912),   FRAC_CONST(0.90948711311150543),
    FRAC_CONST(0.91012376788254157),    FRAC_CONST(0.91075828104443757),   FRAC_CONST(0.91139065110412232),   FRAC_CONST(0.91202087657356823),   FRAC_CONST(0.9126489559697939),
    FRAC_CONST(0.91327488781486776),    FRAC_CONST(0.91389867063591168),   FRAC_CONST(0.91452030296510445),   FRAC_CONST(0.91513978333968526),   FRAC_CONST(0.91575711030195672),
    FRAC_CONST(0.91637228239928914),    FRAC_CONST(0.91698529818412289),   FRAC_CONST(0.91759615621397295),   FRAC_CONST(0.9182048550514309),    FRAC_CONST(0.91881139326416994),
    FRAC_CONST(0.91941576942494696),    FRAC_CONST(0.92001798211160657),   FRAC_CONST(0.92061802990708386),   FRAC_CONST(0.92121591139940873),   FRAC_CONST(0.92181162518170812),
    FRAC_CONST(0.92240516985220988),    FRAC_CONST(0.92299654401424625),   FRAC_CONST(0.92358574627625656),   FRAC_CONST(0.9241727752517912),    FRAC_CONST(0.92475762955951391),
    FRAC_CONST(0.9253403078232062),     FRAC_CONST(0.92592080867176996),   FRAC_CONST(0.92649913073923051),   FRAC_CONST(0.9270752726647401),    FRAC_CONST(0.92764923309258118),
    FRAC_CONST(0.92822101067216944),    FRAC_CONST(0.92879060405805702),   FRAC_CONST(0.9293580119099355),    FRAC_CONST(0.92992323289263956),   FRAC_CONST(0.93048626567614978),
    FRAC_CONST(0.93104710893559517),    FRAC_CONST(0.93160576135125783),   FRAC_CONST(0.93216222160857432),   FRAC_CONST(0.93271648839814025),   FRAC_CONST(0.93326856041571205),
    FRAC_CONST(0.93381843636221096),    FRAC_CONST(0.9343661149437259),    FRAC_CONST(0.93491159487151609),   FRAC_CONST(0.93545487486201462),   FRAC_CONST(0.9359959536368313),
    FRAC_CONST(0.9365348299227555),     FRAC_CONST(0.93707150245175919),   FRAC_CONST(0.93760596996099999),   FRAC_CONST(0.93813823119282436),   FRAC_CONST(0.93866828489477017),
    FRAC_CONST(0.9391961298195699),     FRAC_CONST(0.93972176472515334),   FRAC_CONST(0.94024518837465088),   FRAC_CONST(0.94076639953639607),   FRAC_CONST(0.94128539698392866),
    FRAC_CONST(0.94180217949599765),    FRAC_CONST(0.94231674585656378),   FRAC_CONST(0.94282909485480271),   FRAC_CONST(0.94333922528510772),   FRAC_CONST(0.94384713594709269),
    FRAC_CONST(0.94435282564559475),    FRAC_CONST(0.94485629319067721),   FRAC_CONST(0.94535753739763229),   FRAC_CONST(0.94585655708698391),   FRAC_CONST(0.94635335108449059),
    FRAC_CONST(0.946847918221148),      FRAC_CONST(0.94734025733319194),   FRAC_CONST(0.94783036726210101),   FRAC_CONST(0.94831824685459909),   FRAC_CONST(0.94880389496265838),
    FRAC_CONST(0.94928731044350201),    FRAC_CONST(0.94976849215960668),   FRAC_CONST(0.95024743897870523),   FRAC_CONST(0.95072414977378961),   FRAC_CONST(0.95119862342311323),
    FRAC_CONST(0.95167085881019386),    FRAC_CONST(0.95214085482381583),   FRAC_CONST(0.95260861035803324),   FRAC_CONST(0.9530741243121722),    FRAC_CONST(0.95353739559083328),
    FRAC_CONST(0.95399842310389449),    FRAC_CONST(0.95445720576651349),   FRAC_CONST(0.95491374249913052),   FRAC_CONST(0.95536803222747024),   FRAC_CONST(0.95582007388254542),
    FRAC_CONST(0.95626986640065814),    FRAC_CONST(0.95671740872340305),   FRAC_CONST(0.9571626997976701),    FRAC_CONST(0.95760573857564624),   FRAC_CONST(0.9580465240148186),
    FRAC_CONST(0.9584850550779761),     FRAC_CONST(0.95892133073321306),   FRAC_CONST(0.95935534995393079),   FRAC_CONST(0.9597871117188399),    FRAC_CONST(0.96021661501196343),
    FRAC_CONST(0.96064385882263847),    FRAC_CONST(0.96106884214551935),   FRAC_CONST(0.961491563980579),     FRAC_CONST(0.9619120233331121),    FRAC_CONST(0.9623302192137374),
    FRAC_CONST(0.96274615063839941),    FRAC_CONST(0.96315981662837136),   FRAC_CONST(0.96357121621025721),   FRAC_CONST(0.96398034841599411),   FRAC_CONST(0.96438721228285429),
    FRAC_CONST(0.9647918068534479),     FRAC_CONST(0.96519413117572472),   FRAC_CONST(0.96559418430297683),   FRAC_CONST(0.96599196529384057),   FRAC_CONST(0.96638747321229879),
    FRAC_CONST(0.96678070712768327),    FRAC_CONST(0.96717166611467664),   FRAC_CONST(0.96756034925331436),   FRAC_CONST(0.9679467556289878),    FRAC_CONST(0.9683308843324453),
    FRAC_CONST(0.96871273445979478),    FRAC_CONST(0.9690923051125061),    FRAC_CONST(0.96946959539741295),   FRAC_CONST(0.96984460442671483),   FRAC_CONST(0.97021733131797916),
    FRAC_CONST(0.97058777519414363),    FRAC_CONST(0.97095593518351797),   FRAC_CONST(0.97132181041978616),   FRAC_CONST(0.97168540004200854),   FRAC_CONST(0.9720467031946235),
    FRAC_CONST(0.97240571902744977),    FRAC_CONST(0.97276244669568857),   FRAC_CONST(0.97311688535992513),   FRAC_CONST(0.97346903418613095),   FRAC_CONST(0.9738188923456661),
    FRAC_CONST(0.97416645901528032),    FRAC_CONST(0.97451173337711572),   FRAC_CONST(0.97485471461870843),   FRAC_CONST(0.97519540193299037),   FRAC_CONST(0.97553379451829136),
    FRAC_CONST(0.97586989157834103),    FRAC_CONST(0.97620369232227056),   FRAC_CONST(0.97653519596461447),   FRAC_CONST(0.97686440172531264),   FRAC_CONST(0.97719130882971228),
    FRAC_CONST(0.97751591650856928),    FRAC_CONST(0.97783822399805043),   FRAC_CONST(0.97815823053973505),   FRAC_CONST(0.97847593538061683),   FRAC_CONST(0.97879133777310567),
    FRAC_CONST(0.97910443697502925),    FRAC_CONST(0.97941523224963478),   FRAC_CONST(0.97972372286559117),   FRAC_CONST(0.98002990809698998),   FRAC_CONST(0.98033378722334796),
    FRAC_CONST(0.98063535952960812),    FRAC_CONST(0.98093462430614164),   FRAC_CONST(0.98123158084874973),   FRAC_CONST(0.98152622845866466),   FRAC_CONST(0.9818185664425525),
    FRAC_CONST(0.98210859411251361),    FRAC_CONST(0.98239631078608469),   FRAC_CONST(0.98268171578624086),   FRAC_CONST(0.98296480844139644),   FRAC_CONST(0.98324558808540707),
    FRAC_CONST(0.98352405405757126),    FRAC_CONST(0.98380020570263149),   FRAC_CONST(0.98407404237077645),   FRAC_CONST(0.9843455634176419),    FRAC_CONST(0.9846147682043126),
    FRAC_CONST(0.9848816560973237),     FRAC_CONST(0.98514622646866223),   FRAC_CONST(0.98540847869576842),   FRAC_CONST(0.98566841216153755),   FRAC_CONST(0.98592602625432113),
    FRAC_CONST(0.98618132036792827),    FRAC_CONST(0.98643429390162707),   FRAC_CONST(0.98668494626014669),   FRAC_CONST(0.98693327685367771),   FRAC_CONST(0.98717928509787434),
    FRAC_CONST(0.98742297041385541),    FRAC_CONST(0.98766433222820571),   FRAC_CONST(0.98790336997297779),   FRAC_CONST(0.98814008308569257),   FRAC_CONST(0.98837447100934128),
    FRAC_CONST(0.98860653319238645),    FRAC_CONST(0.98883626908876354),   FRAC_CONST(0.98906367815788154),   FRAC_CONST(0.98928875986462517),   FRAC_CONST(0.98951151367935519),
    FRAC_CONST(0.98973193907791057),    FRAC_CONST(0.98995003554160899),   FRAC_CONST(0.9901658025572484),    FRAC_CONST(0.99037923961710816),   FRAC_CONST(0.99059034621895015),
    FRAC_CONST(0.99079912186602037),    FRAC_CONST(0.99100556606704937),   FRAC_CONST(0.99120967833625406),   FRAC_CONST(0.99141145819333854),   FRAC_CONST(0.99161090516349537),
    FRAC_CONST(0.99180801877740643),    FRAC_CONST(0.99200279857124452),   FRAC_CONST(0.99219524408667392),   FRAC_CONST(0.99238535487085167),   FRAC_CONST(0.99257313047642881),
    FRAC_CONST(0.99275857046155114),    FRAC_CONST(0.99294167438986047),   FRAC_CONST(0.99312244183049558),   FRAC_CONST(0.99330087235809328),   FRAC_CONST(0.99347696555278919),
    FRAC_CONST(0.99365072100021912),    FRAC_CONST(0.99382213829151966),   FRAC_CONST(0.99399121702332938),   FRAC_CONST(0.99415795679778973),   FRAC_CONST(0.99432235722254581),
    FRAC_CONST(0.9944844179107476),     FRAC_CONST(0.99464413848105071),   FRAC_CONST(0.99480151855761711),   FRAC_CONST(0.99495655777011638),   FRAC_CONST(0.99510925575372611),
    FRAC_CONST(0.99525961214913339),    FRAC_CONST(0.9954076266025349),    FRAC_CONST(0.99555329876563847),   FRAC_CONST(0.99569662829566352),   FRAC_CONST(0.99583761485534161),
    FRAC_CONST(0.99597625811291779),    FRAC_CONST(0.99611255774215113),   FRAC_CONST(0.99624651342231552),   FRAC_CONST(0.99637812483820021),   FRAC_CONST(0.99650739168011082),
    FRAC_CONST(0.9966343136438699),     FRAC_CONST(0.996758890430818),     FRAC_CONST(0.99688112174781385),   FRAC_CONST(0.99700100730723529),   FRAC_CONST(0.99711854682697998),
    FRAC_CONST(0.99723374003046616),    FRAC_CONST(0.99734658664663323),   FRAC_CONST(0.99745708640994191),   FRAC_CONST(0.99756523906037575),   FRAC_CONST(0.997671044343441),
    FRAC_CONST(0.99777450201016782),    FRAC_CONST(0.99787561181711015),   FRAC_CONST(0.99797437352634699),   FRAC_CONST(0.99807078690548234),   FRAC_CONST(0.99816485172764624),
    FRAC_CONST(0.99825656777149518),    FRAC_CONST(0.99834593482121237),   FRAC_CONST(0.99843295266650844),   FRAC_CONST(0.99851762110262221),   FRAC_CONST(0.99859993993032037),
    FRAC_CONST(0.99867990895589909),    FRAC_CONST(0.99875752799118334),   FRAC_CONST(0.99883279685352799),   FRAC_CONST(0.99890571536581829),   FRAC_CONST(0.99897628335646982),
    FRAC_CONST(0.99904450065942929),    FRAC_CONST(0.99911036711417489),   FRAC_CONST(0.99917388256571638),   FRAC_CONST(0.99923504686459585),   FRAC_CONST(0.99929385986688779),
    FRAC_CONST(0.99935032143419944),    FRAC_CONST(0.9994044314336713),    FRAC_CONST(0.99945618973797734),   FRAC_CONST(0.99950559622532531),   FRAC_CONST(0.99955265077945699),
    FRAC_CONST(0.99959735328964838),    FRAC_CONST(0.9996397036507102),    FRAC_CONST(0.99967970176298793),   FRAC_CONST(0.99971734753236219),   FRAC_CONST(0.99975264087024884),
    FRAC_CONST(0.99978558169359921),    FRAC_CONST(0.99981616992490041),   FRAC_CONST(0.99984440549217524),   FRAC_CONST(0.99987028832898295),   FRAC_CONST(0.99989381837441849),
    FRAC_CONST(0.99991499557311347),    FRAC_CONST(0.999933819875236),     FRAC_CONST(0.99995029123649048),   FRAC_CONST(0.99996440961811828),   FRAC_CONST(0.99997617498689761),
    FRAC_CONST(0.9999855873151432),     FRAC_CONST(0.99999264658070719),   FRAC_CONST(0.99999735276697821),   FRAC_CONST(0.99999970586288223)};

#ifdef ALLOW_SMALL_FRAMELENGTH
static const real_t sine_long_960[] = {
    FRAC_CONST(0.00081812299560725323), FRAC_CONST(0.0024543667964602917), FRAC_CONST(0.0040906040262347889), FRAC_CONST(0.0057268303042312674), FRAC_CONST(0.0073630412497795667),
    FRAC_CONST(0.0089992324822505774),  FRAC_CONST(0.010635399621067975),  FRAC_CONST(0.012271538285719924),  FRAC_CONST(0.013907644095770845),  FRAC_CONST(0.015543712670873098),
    FRAC_CONST(0.017179739630778748),   FRAC_CONST(0.018815720595351273),  FRAC_CONST(0.020451651184577292),  FRAC_CONST(0.022087527018578291),  FRAC_CONST(0.023723343717622358),
    FRAC_CONST(0.025359096902135895),   FRAC_CONST(0.02699478219271537),   FRAC_CONST(0.028630395210139003),  FRAC_CONST(0.030265931575378519),  FRAC_CONST(0.031901386909610863),
    FRAC_CONST(0.033536756834229922),   FRAC_CONST(0.035172036970858266),  FRAC_CONST(0.036807222941358832),  FRAC_CONST(0.038442310367846677),  FRAC_CONST(0.040077294872700696),
    FRAC_CONST(0.041712172078575326),   FRAC_CONST(0.043346937608412288),  FRAC_CONST(0.044981587085452281),  FRAC_CONST(0.046616116133246711),  FRAC_CONST(0.048250520375669431),
    FRAC_CONST(0.049884795436928406),   FRAC_CONST(0.051518936941577477),  FRAC_CONST(0.053152940514528055),  FRAC_CONST(0.05478680178106083),   FRAC_CONST(0.056420516366837495),
    FRAC_CONST(0.05805407989791244),    FRAC_CONST(0.059687488000744485),  FRAC_CONST(0.061320736302208578),  FRAC_CONST(0.062953820429607482),  FRAC_CONST(0.064586736010683557),
    FRAC_CONST(0.066219478673630344),   FRAC_CONST(0.06785204404710439),   FRAC_CONST(0.069484427760236861),  FRAC_CONST(0.071116625442645326),  FRAC_CONST(0.072748632724445372),
    FRAC_CONST(0.07438044523626236),    FRAC_CONST(0.076012058609243122),  FRAC_CONST(0.077643468475067631),  FRAC_CONST(0.079274670465960706),  FRAC_CONST(0.080905660214703745),
    FRAC_CONST(0.082536433354646319),   FRAC_CONST(0.084166985519717977),  FRAC_CONST(0.085797312344439894),  FRAC_CONST(0.08742740946393647),   FRAC_CONST(0.089057272513947183),
    FRAC_CONST(0.090686897130838162),   FRAC_CONST(0.092316278951613845),  FRAC_CONST(0.093945413613928788),  FRAC_CONST(0.095574296756099186),  FRAC_CONST(0.097202924017114667),
    FRAC_CONST(0.098831291036649963),   FRAC_CONST(0.10045939345507648),   FRAC_CONST(0.10208722691347409),   FRAC_CONST(0.10371478705364276),   FRAC_CONST(0.10534206951811415),
    FRAC_CONST(0.10696906995016341),    FRAC_CONST(0.10859578399382072),   FRAC_CONST(0.11022220729388306),   FRAC_CONST(0.11184833549592579),   FRAC_CONST(0.11347416424631435),
    FRAC_CONST(0.11509968919221586),    FRAC_CONST(0.11672490598161089),   FRAC_CONST(0.11834981026330495),   FRAC_CONST(0.11997439768694031),   FRAC_CONST(0.12159866390300751),
    FRAC_CONST(0.12322260456285709),    FRAC_CONST(0.12484621531871121),   FRAC_CONST(0.12646949182367517),   FRAC_CONST(0.12809242973174936),   FRAC_CONST(0.12971502469784052),
    FRAC_CONST(0.13133727237777362),    FRAC_CONST(0.13295916842830346),   FRAC_CONST(0.13458070850712617),   FRAC_CONST(0.13620188827289101),   FRAC_CONST(0.1378227033852118),
    FRAC_CONST(0.13944314950467873),    FRAC_CONST(0.14106322229286994),   FRAC_CONST(0.14268291741236291),   FRAC_CONST(0.14430223052674654),   FRAC_CONST(0.1459211573006321),
    FRAC_CONST(0.14753969339966552),    FRAC_CONST(0.14915783449053857),   FRAC_CONST(0.15077557624100058),   FRAC_CONST(0.15239291431987001),   FRAC_CONST(0.1540098443970461),
    FRAC_CONST(0.15562636214352044),    FRAC_CONST(0.15724246323138855),   FRAC_CONST(0.15885814333386142),   FRAC_CONST(0.16047339812527725),   FRAC_CONST(0.16208822328111283),
    FRAC_CONST(0.16370261447799525),    FRAC_CONST(0.16531656739371339),   FRAC_CONST(0.16693007770722967),   FRAC_CONST(0.16854314109869134),   FRAC_CONST(0.17015575324944232),
    FRAC_CONST(0.17176790984203447),    FRAC_CONST(0.17337960656023954),   FRAC_CONST(0.1749908390890603),    FRAC_CONST(0.17660160311474243),   FRAC_CONST(0.17821189432478593),
    FRAC_CONST(0.17982170840795647),    FRAC_CONST(0.18143104105429744),   FRAC_CONST(0.18303988795514095),   FRAC_CONST(0.1846482448031197),    FRAC_CONST(0.18625610729217834),
    FRAC_CONST(0.1878634711175852),     FRAC_CONST(0.18947033197594348),   FRAC_CONST(0.19107668556520319),   FRAC_CONST(0.19268252758467228),   FRAC_CONST(0.19428785373502844),
    FRAC_CONST(0.19589265971833042),    FRAC_CONST(0.19749694123802966),   FRAC_CONST(0.19910069399898173),   FRAC_CONST(0.20070391370745785),   FRAC_CONST(0.20230659607115639),
    FRAC_CONST(0.20390873679921437),    FRAC_CONST(0.20551033160221882),   FRAC_CONST(0.20711137619221856),   FRAC_CONST(0.2087118662827353),    FRAC_CONST(0.21031179758877552),
    FRAC_CONST(0.21191116582684155),    FRAC_CONST(0.21350996671494335),   FRAC_CONST(0.21510819597260972),   FRAC_CONST(0.21670584932089998),   FRAC_CONST(0.2183029224824154),
    FRAC_CONST(0.21989941118131037),    FRAC_CONST(0.22149531114330431),   FRAC_CONST(0.22309061809569264),   FRAC_CONST(0.22468532776735861),   FRAC_CONST(0.22627943588878449),
    FRAC_CONST(0.22787293819206314),    FRAC_CONST(0.22946583041090929),   FRAC_CONST(0.23105810828067114),   FRAC_CONST(0.23264976753834157),   FRAC_CONST(0.23424080392256985),
    FRAC_CONST(0.2358312131736727),     FRAC_CONST(0.23742099103364595),   FRAC_CONST(0.23901013324617584),   FRAC_CONST(0.24059863555665045),   FRAC_CONST(0.24218649371217096),
    FRAC_CONST(0.24377370346156332),    FRAC_CONST(0.24536026055538934),   FRAC_CONST(0.24694616074595824),   FRAC_CONST(0.24853139978733788),   FRAC_CONST(0.25011597343536629),
    FRAC_CONST(0.25169987744766298),    FRAC_CONST(0.25328310758364025),   FRAC_CONST(0.25486565960451457),   FRAC_CONST(0.25644752927331788),   FRAC_CONST(0.25802871235490898),
    FRAC_CONST(0.25960920461598508),    FRAC_CONST(0.26118900182509258),   FRAC_CONST(0.26276809975263904),   FRAC_CONST(0.264346494170904),     FRAC_CONST(0.26592418085405067),
    FRAC_CONST(0.26750115557813692),    FRAC_CONST(0.2690774141211269),    FRAC_CONST(0.27065295226290209),   FRAC_CONST(0.2722277657852728),    FRAC_CONST(0.27380185047198918),
    FRAC_CONST(0.27537520210875299),    FRAC_CONST(0.2769478164832283),    FRAC_CONST(0.27851968938505312),   FRAC_CONST(0.28009081660585067),   FRAC_CONST(0.28166119393924061),
    FRAC_CONST(0.28323081718085019),    FRAC_CONST(0.28479968212832563),   FRAC_CONST(0.28636778458134327),   FRAC_CONST(0.28793512034162105),   FRAC_CONST(0.2895016852129294),
    FRAC_CONST(0.29106747500110264),    FRAC_CONST(0.29263248551405047),   FRAC_CONST(0.2941967125617686),    FRAC_CONST(0.29576015195635058),   FRAC_CONST(0.29732279951199847),
    FRAC_CONST(0.29888465104503475),    FRAC_CONST(0.30044570237391266),   FRAC_CONST(0.30200594931922808),   FRAC_CONST(0.30356538770373032),   FRAC_CONST(0.30512401335233358),
    FRAC_CONST(0.30668182209212791),    FRAC_CONST(0.3082388097523906),    FRAC_CONST(0.30979497216459695),   FRAC_CONST(0.31135030516243201),   FRAC_CONST(0.3129048045818012),
    FRAC_CONST(0.31445846626084178),    FRAC_CONST(0.31601128603993378),   FRAC_CONST(0.31756325976171151),   FRAC_CONST(0.31911438327107416),   FRAC_CONST(0.32066465241519732),
    FRAC_CONST(0.32221406304354389),    FRAC_CONST(0.3237626110078754),    FRAC_CONST(0.32531029216226293),   FRAC_CONST(0.32685710236309828),   FRAC_CONST(0.32840303746910487),
    FRAC_CONST(0.32994809334134939),    FRAC_CONST(0.3314922658432522),    FRAC_CONST(0.33303555084059877),   FRAC_CONST(0.33457794420155085),   FRAC_CONST(0.33611944179665709),
    FRAC_CONST(0.33766003949886464),    FRAC_CONST(0.33919973318352969),   FRAC_CONST(0.34073851872842903),   FRAC_CONST(0.34227639201377064),   FRAC_CONST(0.34381334892220483),
    FRAC_CONST(0.34534938533883547),    FRAC_CONST(0.34688449715123082),   FRAC_CONST(0.34841868024943456),   FRAC_CONST(0.34995193052597684),   FRAC_CONST(0.35148424387588523),
    FRAC_CONST(0.3530156161966958),     FRAC_CONST(0.35454604338846402),   FRAC_CONST(0.35607552135377557),   FRAC_CONST(0.35760404599775775),   FRAC_CONST(0.35913161322809023),
    FRAC_CONST(0.36065821895501554),    FRAC_CONST(0.36218385909135092),   FRAC_CONST(0.36370852955249849),   FRAC_CONST(0.36523222625645668),   FRAC_CONST(0.36675494512383078),
    FRAC_CONST(0.36827668207784414),    FRAC_CONST(0.36979743304434909),   FRAC_CONST(0.37131719395183754),   FRAC_CONST(0.37283596073145214),   FRAC_CONST(0.37435372931699717),
    FRAC_CONST(0.37587049564494951),    FRAC_CONST(0.37738625565446909),   FRAC_CONST(0.37890100528741022),   FRAC_CONST(0.38041474048833229),   FRAC_CONST(0.38192745720451066),
    FRAC_CONST(0.38343915138594736),    FRAC_CONST(0.38494981898538222),   FRAC_CONST(0.38645945595830333),   FRAC_CONST(0.38796805826295838),   FRAC_CONST(0.38947562186036483),
    FRAC_CONST(0.39098214271432141),    FRAC_CONST(0.39248761679141814),   FRAC_CONST(0.3939920400610481),    FRAC_CONST(0.39549540849541737),   FRAC_CONST(0.39699771806955625),
    FRAC_CONST(0.39849896476132979),    FRAC_CONST(0.39999914455144892),   FRAC_CONST(0.40149825342348083),   FRAC_CONST(0.4029962873638599),    FRAC_CONST(0.40449324236189854),
    FRAC_CONST(0.40598911440979762),    FRAC_CONST(0.40748389950265762),   FRAC_CONST(0.40897759363848879),   FRAC_CONST(0.41047019281822261),   FRAC_CONST(0.41196169304572178),
    FRAC_CONST(0.4134520903277914),     FRAC_CONST(0.41494138067418929),   FRAC_CONST(0.41642956009763715),   FRAC_CONST(0.41791662461383078),   FRAC_CONST(0.41940257024145089),
    FRAC_CONST(0.42088739300217382),    FRAC_CONST(0.42237108892068231),   FRAC_CONST(0.42385365402467584),   FRAC_CONST(0.42533508434488143),   FRAC_CONST(0.42681537591506419),
    FRAC_CONST(0.42829452477203828),    FRAC_CONST(0.42977252695567697),   FRAC_CONST(0.43124937850892364),   FRAC_CONST(0.4327250754778022),    FRAC_CONST(0.43419961391142781),
    FRAC_CONST(0.43567298986201736),    FRAC_CONST(0.43714519938489987),   FRAC_CONST(0.43861623853852766),   FRAC_CONST(0.44008610338448595),   FRAC_CONST(0.44155478998750436),
    FRAC_CONST(0.44302229441546676),    FRAC_CONST(0.4444886127394222),    FRAC_CONST(0.44595374103359531),   FRAC_CONST(0.44741767537539667),   FRAC_CONST(0.44888041184543348),
    FRAC_CONST(0.45034194652752002),    FRAC_CONST(0.45180227550868812),   FRAC_CONST(0.45326139487919759),   FRAC_CONST(0.45471930073254679),   FRAC_CONST(0.45617598916548296),
    FRAC_CONST(0.45763145627801283),    FRAC_CONST(0.45908569817341294),   FRAC_CONST(0.46053871095824001),   FRAC_CONST(0.46199049074234161),   FRAC_CONST(0.46344103363886635),
    FRAC_CONST(0.46489033576427435),    FRAC_CONST(0.46633839323834758),   FRAC_CONST(0.46778520218420055),   FRAC_CONST(0.46923075872829029),   FRAC_CONST(0.47067505900042683),
    FRAC_CONST(0.47211809913378361),    FRAC_CONST(0.47355987526490806),   FRAC_CONST(0.47500038353373153),   FRAC_CONST(0.47643962008357982),   FRAC_CONST(0.47787758106118372),
    FRAC_CONST(0.47931426261668875),    FRAC_CONST(0.48074966090366611),   FRAC_CONST(0.48218377207912272),   FRAC_CONST(0.48361659230351117),   FRAC_CONST(0.48504811774074069),
    FRAC_CONST(0.48647834455818684),    FRAC_CONST(0.48790726892670194),   FRAC_CONST(0.48933488702062544),   FRAC_CONST(0.49076119501779414),   FRAC_CONST(0.49218618909955225),
    FRAC_CONST(0.4936098654507618),     FRAC_CONST(0.49503222025981269),   FRAC_CONST(0.49645324971863303),   FRAC_CONST(0.49787295002269943),   FRAC_CONST(0.49929131737104687),
    FRAC_CONST(0.50070834796627917),    FRAC_CONST(0.50212403801457872),   FRAC_CONST(0.50353838372571758),   FRAC_CONST(0.50495138131306638),   FRAC_CONST(0.50636302699360547),
    FRAC_CONST(0.50777331698793449),    FRAC_CONST(0.50918224752028263),   FRAC_CONST(0.51058981481851906),   FRAC_CONST(0.51199601511416237),   FRAC_CONST(0.51340084464239111),
    FRAC_CONST(0.51480429964205421),    FRAC_CONST(0.51620637635567967),   FRAC_CONST(0.51760707102948678),   FRAC_CONST(0.51900637991339404),   FRAC_CONST(0.5204042992610306),
    FRAC_CONST(0.52180082532974559),    FRAC_CONST(0.5231959543806185),    FRAC_CONST(0.52458968267846895),   FRAC_CONST(0.52598200649186677),   FRAC_CONST(0.52737292209314235),
    FRAC_CONST(0.52876242575839572),    FRAC_CONST(0.53015051376750777),   FRAC_CONST(0.53153718240414882),   FRAC_CONST(0.53292242795578992),   FRAC_CONST(0.53430624671371152),
    FRAC_CONST(0.53568863497301467),    FRAC_CONST(0.5370695890326298),    FRAC_CONST(0.5384491051953274),    FRAC_CONST(0.53982717976772743),   FRAC_CONST(0.54120380906030963),
    FRAC_CONST(0.54257898938742311),    FRAC_CONST(0.54395271706729609),   FRAC_CONST(0.54532498842204646),   FRAC_CONST(0.54669579977769045),   FRAC_CONST(0.54806514746415402),
    FRAC_CONST(0.54943302781528081),    FRAC_CONST(0.55079943716884383),   FRAC_CONST(0.55216437186655387),   FRAC_CONST(0.55352782825406999),   FRAC_CONST(0.55488980268100907),
    FRAC_CONST(0.55625029150095584),    FRAC_CONST(0.55760929107147217),   FRAC_CONST(0.55896679775410718),   FRAC_CONST(0.56032280791440714),   FRAC_CONST(0.56167731792192455),
    FRAC_CONST(0.56303032415022869),    FRAC_CONST(0.56438182297691453),   FRAC_CONST(0.56573181078361312),   FRAC_CONST(0.56708028395600085),   FRAC_CONST(0.56842723888380908),
    FRAC_CONST(0.56977267196083425),    FRAC_CONST(0.57111657958494688),   FRAC_CONST(0.5724589581581021),    FRAC_CONST(0.57379980408634845),   FRAC_CONST(0.57513911377983773),
    FRAC_CONST(0.57647688365283478),    FRAC_CONST(0.57781311012372738),   FRAC_CONST(0.57914778961503466),   FRAC_CONST(0.58048091855341843),   FRAC_CONST(0.5818124933696911),
    FRAC_CONST(0.58314251049882604),    FRAC_CONST(0.58447096637996743),   FRAC_CONST(0.58579785745643886),   FRAC_CONST(0.5871231801757536),    FRAC_CONST(0.58844693098962408),
    FRAC_CONST(0.58976910635397084),    FRAC_CONST(0.59108970272893235),   FRAC_CONST(0.59240871657887517),   FRAC_CONST(0.59372614437240179),   FRAC_CONST(0.59504198258236196),
    FRAC_CONST(0.5963562276858605),     FRAC_CONST(0.59766887616426767),   FRAC_CONST(0.5989799245032289),    FRAC_CONST(0.60028936919267273),   FRAC_CONST(0.60159720672682204),
    FRAC_CONST(0.60290343360420195),    FRAC_CONST(0.60420804632765002),   FRAC_CONST(0.60551104140432543),   FRAC_CONST(0.60681241534571839),   FRAC_CONST(0.60811216466765883),
    FRAC_CONST(0.60941028589032709),    FRAC_CONST(0.61070677553826169),   FRAC_CONST(0.61200163014036979),   FRAC_CONST(0.61329484622993602),   FRAC_CONST(0.6145864203446314),
    FRAC_CONST(0.61587634902652377),    FRAC_CONST(0.61716462882208556),   FRAC_CONST(0.61845125628220421),   FRAC_CONST(0.61973622796219074),   FRAC_CONST(0.6210195404217892),
    FRAC_CONST(0.62230119022518593),    FRAC_CONST(0.62358117394101897),   FRAC_CONST(0.62485948814238634),   FRAC_CONST(0.62613612940685637),   FRAC_CONST(0.62741109431647646),
    FRAC_CONST(0.62868437945778133),    FRAC_CONST(0.62995598142180387),   FRAC_CONST(0.6312258968040827),    FRAC_CONST(0.63249412220467238),   FRAC_CONST(0.63376065422815175),
    FRAC_CONST(0.63502548948363347),    FRAC_CONST(0.63628862458477287),   FRAC_CONST(0.63755005614977711),   FRAC_CONST(0.63880978080141437),   FRAC_CONST(0.6400677951670225),
    FRAC_CONST(0.6413240958785188),     FRAC_CONST(0.64257867957240766),   FRAC_CONST(0.6438315428897915),    FRAC_CONST(0.64508268247637779),   FRAC_CONST(0.64633209498248945),
    FRAC_CONST(0.64757977706307335),    FRAC_CONST(0.64882572537770888),   FRAC_CONST(0.65006993659061751),   FRAC_CONST(0.65131240737067142),   FRAC_CONST(0.65255313439140239),
    FRAC_CONST(0.65379211433101081),    FRAC_CONST(0.65502934387237444),   FRAC_CONST(0.6562648197030575),    FRAC_CONST(0.65749853851531959),   FRAC_CONST(0.65873049700612374),
    FRAC_CONST(0.65996069187714679),    FRAC_CONST(0.66118911983478657),   FRAC_CONST(0.66241577759017178),   FRAC_CONST(0.66364066185917048),   FRAC_CONST(0.66486376936239888),
    FRAC_CONST(0.66608509682523009),    FRAC_CONST(0.66730464097780284),   FRAC_CONST(0.66852239855503071),   FRAC_CONST(0.66973836629660977),   FRAC_CONST(0.67095254094702894),
    FRAC_CONST(0.67216491925557675),    FRAC_CONST(0.67337549797635199),   FRAC_CONST(0.67458427386827102),   FRAC_CONST(0.67579124369507693),   FRAC_CONST(0.67699640422534846),
    FRAC_CONST(0.67819975223250772),    FRAC_CONST(0.6794012844948305),    FRAC_CONST(0.68060099779545302),   FRAC_CONST(0.68179888892238183),   FRAC_CONST(0.6829949546685018),
    FRAC_CONST(0.68418919183158522),    FRAC_CONST(0.68538159721429948),   FRAC_CONST(0.6865721676242168),    FRAC_CONST(0.68776089987382172),   FRAC_CONST(0.68894779078052026),
    FRAC_CONST(0.69013283716664853),    FRAC_CONST(0.69131603585948032),   FRAC_CONST(0.69249738369123692),   FRAC_CONST(0.69367687749909468),   FRAC_CONST(0.69485451412519361),
    FRAC_CONST(0.69603029041664599),    FRAC_CONST(0.6972042032255451),    FRAC_CONST(0.6983762494089728),    FRAC_CONST(0.69954642582900894),   FRAC_CONST(0.70071472935273893),
    FRAC_CONST(0.70188115685226271),    FRAC_CONST(0.703045705204703),     FRAC_CONST(0.70420837129221303),   FRAC_CONST(0.70536915200198613),   FRAC_CONST(0.70652804422626281),
    FRAC_CONST(0.70768504486233985),    FRAC_CONST(0.70884015081257845),   FRAC_CONST(0.70999335898441229),   FRAC_CONST(0.711144666290356),     FRAC_CONST(0.71229406964801356),
    FRAC_CONST(0.71344156598008623),    FRAC_CONST(0.71458715221438096),   FRAC_CONST(0.71573082528381871),   FRAC_CONST(0.71687258212644234),   FRAC_CONST(0.7180124196854254),
    FRAC_CONST(0.71915033490907943),    FRAC_CONST(0.72028632475086318),   FRAC_CONST(0.72142038616938997),   FRAC_CONST(0.72255251612843596),   FRAC_CONST(0.72368271159694852),
    FRAC_CONST(0.72481096954905444),    FRAC_CONST(0.72593728696406756),   FRAC_CONST(0.72706166082649704),   FRAC_CONST(0.72818408812605595),   FRAC_CONST(0.72930456585766834),
    FRAC_CONST(0.73042309102147851),    FRAC_CONST(0.73153966062285747),   FRAC_CONST(0.73265427167241282),   FRAC_CONST(0.73376692118599507),   FRAC_CONST(0.73487760618470677),
    FRAC_CONST(0.73598632369490979),    FRAC_CONST(0.73709307074823405),   FRAC_CONST(0.73819784438158409),   FRAC_CONST(0.73930064163714881),   FRAC_CONST(0.74040145956240788),
    FRAC_CONST(0.74150029521014049),    FRAC_CONST(0.74259714563843304),   FRAC_CONST(0.74369200791068657),   FRAC_CONST(0.74478487909562552),   FRAC_CONST(0.74587575626730485),
    FRAC_CONST(0.74696463650511791),    FRAC_CONST(0.74805151689380456),   FRAC_CONST(0.74913639452345926),   FRAC_CONST(0.75021926648953785),   FRAC_CONST(0.75130012989286621),
    FRAC_CONST(0.7523789818396478),     FRAC_CONST(0.75345581944147111),   FRAC_CONST(0.75453063981531809),   FRAC_CONST(0.75560344008357094),   FRAC_CONST(0.75667421737402052),
    FRAC_CONST(0.7577429688198738),     FRAC_CONST(0.75880969155976163),   FRAC_CONST(0.75987438273774599),   FRAC_CONST(0.76093703950332836),   FRAC_CONST(0.76199765901145666),
    FRAC_CONST(0.76305623842253345),    FRAC_CONST(0.76411277490242291),   FRAC_CONST(0.76516726562245885),   FRAC_CONST(0.76621970775945258),   FRAC_CONST(0.76727009849569949),
    FRAC_CONST(0.76831843501898767),    FRAC_CONST(0.76936471452260458),   FRAC_CONST(0.77040893420534517),   FRAC_CONST(0.77145109127151923),   FRAC_CONST(0.77249118293095853),
    FRAC_CONST(0.77352920639902467),    FRAC_CONST(0.77456515889661659),   FRAC_CONST(0.77559903765017746),   FRAC_CONST(0.7766308398917029),    FRAC_CONST(0.77766056285874774),
    FRAC_CONST(0.77868820379443371),    FRAC_CONST(0.77971375994745684),   FRAC_CONST(0.78073722857209438),   FRAC_CONST(0.7817586069282132),    FRAC_CONST(0.78277789228127592),
    FRAC_CONST(0.78379508190234881),    FRAC_CONST(0.78481017306810918),   FRAC_CONST(0.78582316306085265),   FRAC_CONST(0.78683404916849986),   FRAC_CONST(0.78784282868460476),
    FRAC_CONST(0.78884949890836087),    FRAC_CONST(0.78985405714460888),   FRAC_CONST(0.7908565007038445),    FRAC_CONST(0.79185682690222425),   FRAC_CONST(0.79285503306157412),
    FRAC_CONST(0.79385111650939566),    FRAC_CONST(0.79484507457887377),   FRAC_CONST(0.79583690460888357),   FRAC_CONST(0.79682660394399751),   FRAC_CONST(0.79781416993449272),
    FRAC_CONST(0.79879959993635785),    FRAC_CONST(0.7997828913113002),    FRAC_CONST(0.80076404142675273),   FRAC_CONST(0.80174304765588156),   FRAC_CONST(0.80271990737759213),
    FRAC_CONST(0.80369461797653707),    FRAC_CONST(0.80466717684312306),   FRAC_CONST(0.80563758137351682),   FRAC_CONST(0.80660582896965372),   FRAC_CONST(0.80757191703924336),
    FRAC_CONST(0.80853584299577752),    FRAC_CONST(0.80949760425853612),   FRAC_CONST(0.81045719825259477),   FRAC_CONST(0.81141462240883167),   FRAC_CONST(0.81236987416393436),
    FRAC_CONST(0.81332295096040608),    FRAC_CONST(0.81427385024657373),   FRAC_CONST(0.81522256947659355),   FRAC_CONST(0.81616910611045879),   FRAC_CONST(0.817113457614006),
    FRAC_CONST(0.81805562145892186),    FRAC_CONST(0.81899559512275044),   FRAC_CONST(0.81993337608889916),   FRAC_CONST(0.82086896184664637),   FRAC_CONST(0.8218023498911472),
    FRAC_CONST(0.82273353772344116),    FRAC_CONST(0.82366252285045805),   FRAC_CONST(0.82458930278502529),   FRAC_CONST(0.82551387504587381),   FRAC_CONST(0.82643623715764558),
    FRAC_CONST(0.82735638665089983),    FRAC_CONST(0.82827432106211907),   FRAC_CONST(0.82919003793371693),   FRAC_CONST(0.83010353481404364),   FRAC_CONST(0.83101480925739324),
    FRAC_CONST(0.83192385882400965),    FRAC_CONST(0.83283068108009373),   FRAC_CONST(0.8337352735978093),    FRAC_CONST(0.83463763395529011),   FRAC_CONST(0.83553775973664579),
    FRAC_CONST(0.83643564853196872),    FRAC_CONST(0.83733129793734051),   FRAC_CONST(0.83822470555483797),   FRAC_CONST(0.83911586899254031),   FRAC_CONST(0.84000478586453453),
    FRAC_CONST(0.84089145379092289),    FRAC_CONST(0.84177587039782842),   FRAC_CONST(0.84265803331740163),   FRAC_CONST(0.84353794018782702),   FRAC_CONST(0.844415588653329),
    FRAC_CONST(0.8452909763641786),     FRAC_CONST(0.84616410097669936),   FRAC_CONST(0.84703496015327406),   FRAC_CONST(0.84790355156235053),   FRAC_CONST(0.84876987287844818),
    FRAC_CONST(0.8496339217821639),     FRAC_CONST(0.85049569596017938),   FRAC_CONST(0.85135519310526508),   FRAC_CONST(0.85221241091628896),   FRAC_CONST(0.85306734709822085),
    FRAC_CONST(0.85391999936213903),    FRAC_CONST(0.85477036542523732),   FRAC_CONST(0.85561844301082923),   FRAC_CONST(0.85646422984835635),   FRAC_CONST(0.85730772367339259),
    FRAC_CONST(0.85814892222765116),    FRAC_CONST(0.85898782325899026),   FRAC_CONST(0.85982442452141961),   FRAC_CONST(0.86065872377510555),   FRAC_CONST(0.86149071878637817),
    FRAC_CONST(0.8623204073277364),     FRAC_CONST(0.86314778717785412),   FRAC_CONST(0.8639728561215867),    FRAC_CONST(0.86479561194997623),   FRAC_CONST(0.86561605246025763),
    FRAC_CONST(0.86643417545586487),    FRAC_CONST(0.8672499787464365),    FRAC_CONST(0.86806346014782154),   FRAC_CONST(0.8688746174820855),    FRAC_CONST(0.86968344857751589),
    FRAC_CONST(0.87048995126862883),    FRAC_CONST(0.87129412339617363),   FRAC_CONST(0.87209596280713941),   FRAC_CONST(0.8728954673547612),    FRAC_CONST(0.87369263489852422),
    FRAC_CONST(0.87448746330417149),    FRAC_CONST(0.87527995044370765),   FRAC_CONST(0.8760700941954066),    FRAC_CONST(0.87685789244381551),   FRAC_CONST(0.87764334307976144),
    FRAC_CONST(0.87842644400035663),    FRAC_CONST(0.8792071931090043),    FRAC_CONST(0.87998558831540408),   FRAC_CONST(0.88076162753555787),   FRAC_CONST(0.88153530869177488),
    FRAC_CONST(0.88230662971267804),    FRAC_CONST(0.88307558853320878),   FRAC_CONST(0.88384218309463292),   FRAC_CONST(0.8846064113445461),    FRAC_CONST(0.88536827123687933),
    FRAC_CONST(0.88612776073190425),    FRAC_CONST(0.88688487779623937),   FRAC_CONST(0.88763962040285393),   FRAC_CONST(0.8883919865310751),    FRAC_CONST(0.88914197416659235),
    FRAC_CONST(0.88988958130146301),    FRAC_CONST(0.8906348059341177),    FRAC_CONST(0.89137764606936609),   FRAC_CONST(0.89211809971840139),   FRAC_CONST(0.89285616489880615),
    FRAC_CONST(0.89359183963455813),    FRAC_CONST(0.89432512195603453),   FRAC_CONST(0.89505600990001799),   FRAC_CONST(0.89578450150970124),   FRAC_CONST(0.8965105948346932),
    FRAC_CONST(0.89723428793102367),    FRAC_CONST(0.89795557886114807),   FRAC_CONST(0.89867446569395382),   FRAC_CONST(0.89939094650476448),   FRAC_CONST(0.90010501937534515),
    FRAC_CONST(0.900816682393908),      FRAC_CONST(0.90152593365511691),   FRAC_CONST(0.90223277126009283),   FRAC_CONST(0.90293719331641886),   FRAC_CONST(0.90363919793814496),
    FRAC_CONST(0.90433878324579353),    FRAC_CONST(0.90503594736636439),   FRAC_CONST(0.90573068843333915),   FRAC_CONST(0.90642300458668679),   FRAC_CONST(0.90711289397286898),
    FRAC_CONST(0.90780035474484411),    FRAC_CONST(0.90848538506207266),   FRAC_CONST(0.90916798309052227),   FRAC_CONST(0.90984814700267291),   FRAC_CONST(0.9105258749775208),
    FRAC_CONST(0.91120116520058425),    FRAC_CONST(0.91187401586390815),   FRAC_CONST(0.91254442516606893),   FRAC_CONST(0.9132123913121788),    FRAC_CONST(0.91387791251389161),
    FRAC_CONST(0.91454098698940678),    FRAC_CONST(0.91520161296347435),   FRAC_CONST(0.91585978866739981),   FRAC_CONST(0.91651551233904871),   FRAC_CONST(0.91716878222285148),
    FRAC_CONST(0.91781959656980805),    FRAC_CONST(0.91846795363749245),   FRAC_CONST(0.91911385169005766),   FRAC_CONST(0.9197572889982405),    FRAC_CONST(0.9203982638393654),
    FRAC_CONST(0.92103677449734989),    FRAC_CONST(0.92167281926270861),   FRAC_CONST(0.92230639643255874),   FRAC_CONST(0.92293750431062316),   FRAC_CONST(0.92356614120723612),
    FRAC_CONST(0.92419230543934783),    FRAC_CONST(0.92481599533052783),   FRAC_CONST(0.92543720921097061),   FRAC_CONST(0.92605594541749991),   FRAC_CONST(0.92667220229357261),
    FRAC_CONST(0.92728597818928349),    FRAC_CONST(0.9278972714613698),    FRAC_CONST(0.92850608047321548),   FRAC_CONST(0.9291124035948557),    FRAC_CONST(0.92971623920298097),
    FRAC_CONST(0.93031758568094147),    FRAC_CONST(0.93091644141875196),   FRAC_CONST(0.93151280481309506),   FRAC_CONST(0.93210667426732674),   FRAC_CONST(0.93269804819147983),
    FRAC_CONST(0.93328692500226818),    FRAC_CONST(0.93387330312309147),   FRAC_CONST(0.93445718098403896),   FRAC_CONST(0.93503855702189376),   FRAC_CONST(0.9356174296801375),
    FRAC_CONST(0.93619379740895381),    FRAC_CONST(0.93676765866523259),   FRAC_CONST(0.93733901191257496),   FRAC_CONST(0.93790785562129597),   FRAC_CONST(0.93847418826842988),
    FRAC_CONST(0.93903800833773399),    FRAC_CONST(0.93959931431969212),   FRAC_CONST(0.94015810471151917),   FRAC_CONST(0.94071437801716529),   FRAC_CONST(0.94126813274731924),
    FRAC_CONST(0.94181936741941319),    FRAC_CONST(0.94236808055762578),   FRAC_CONST(0.94291427069288691),   FRAC_CONST(0.94345793636288133),   FRAC_CONST(0.94399907611205225),
    FRAC_CONST(0.9445376884916058),     FRAC_CONST(0.94507377205951448),   FRAC_CONST(0.94560732538052128),   FRAC_CONST(0.94613834702614352),   FRAC_CONST(0.94666683557467624),
    FRAC_CONST(0.94719278961119657),    FRAC_CONST(0.94771620772756759),   FRAC_CONST(0.94823708852244104),   FRAC_CONST(0.94875543060126255),   FRAC_CONST(0.94927123257627433),
    FRAC_CONST(0.94978449306651924),    FRAC_CONST(0.95029521069784428),   FRAC_CONST(0.9508033841029051),    FRAC_CONST(0.95130901192116835),   FRAC_CONST(0.9518120927989161),
    FRAC_CONST(0.95231262538924943),    FRAC_CONST(0.95281060835209208),   FRAC_CONST(0.95330604035419386),   FRAC_CONST(0.95379892006913403),   FRAC_CONST(0.95428924617732525),
    FRAC_CONST(0.95477701736601728),    FRAC_CONST(0.95526223232929941),   FRAC_CONST(0.95574488976810545),   FRAC_CONST(0.95622498839021619),   FRAC_CONST(0.95670252691026292),
    FRAC_CONST(0.95717750404973156),    FRAC_CONST(0.95764991853696524),   FRAC_CONST(0.95811976910716812),   FRAC_CONST(0.95858705450240911),   FRAC_CONST(0.95905177347162429),
    FRAC_CONST(0.95951392477062125),    FRAC_CONST(0.95997350716208196),   FRAC_CONST(0.96043051941556579),   FRAC_CONST(0.96088496030751369),   FRAC_CONST(0.96133682862125036),
    FRAC_CONST(0.96178612314698864),    FRAC_CONST(0.96223284268183173),   FRAC_CONST(0.9626769860297768),    FRAC_CONST(0.96311855200171881),   FRAC_CONST(0.96355753941545252),
    FRAC_CONST(0.96399394709567654),    FRAC_CONST(0.96442777387399625),   FRAC_CONST(0.96485901858892686),   FRAC_CONST(0.96528768008589627),   FRAC_CONST(0.96571375721724895),
    FRAC_CONST(0.96613724884224783),    FRAC_CONST(0.96655815382707866),   FRAC_CONST(0.96697647104485207),   FRAC_CONST(0.96739219937560694),   FRAC_CONST(0.96780533770631338),
    FRAC_CONST(0.96821588493087585),    FRAC_CONST(0.9686238399501359),    FRAC_CONST(0.96902920167187501),   FRAC_CONST(0.96943196901081796),   FRAC_CONST(0.96983214088863534),
    FRAC_CONST(0.9702297162339466),     FRAC_CONST(0.97062469398232287),   FRAC_CONST(0.97101707307629004),   FRAC_CONST(0.97140685246533098),   FRAC_CONST(0.97179403110588902),
    FRAC_CONST(0.97217860796137046),    FRAC_CONST(0.97256058200214734),   FRAC_CONST(0.97293995220556007),   FRAC_CONST(0.97331671755592064),   FRAC_CONST(0.97369087704451474),
    FRAC_CONST(0.97406242966960455),    FRAC_CONST(0.97443137443643235),   FRAC_CONST(0.97479771035722163),   FRAC_CONST(0.97516143645118103),   FRAC_CONST(0.97552255174450631),
    FRAC_CONST(0.97588105527038305),    FRAC_CONST(0.97623694606898959),   FRAC_CONST(0.97659022318749911),   FRAC_CONST(0.97694088568008242),   FRAC_CONST(0.97728893260791039),
    FRAC_CONST(0.97763436303915685),    FRAC_CONST(0.97797717604900047),   FRAC_CONST(0.97831737071962765),   FRAC_CONST(0.97865494614023485),   FRAC_CONST(0.97898990140703124),
    FRAC_CONST(0.97932223562324061),    FRAC_CONST(0.97965194789910426),   FRAC_CONST(0.9799790373518833),    FRAC_CONST(0.98030350310586067),   FRAC_CONST(0.98062534429234405),
    FRAC_CONST(0.98094456004966768),    FRAC_CONST(0.98126114952319499),   FRAC_CONST(0.98157511186532054),   FRAC_CONST(0.98188644623547261),   FRAC_CONST(0.98219515180011563),
    FRAC_CONST(0.98250122773275184),    FRAC_CONST(0.98280467321392362),   FRAC_CONST(0.98310548743121629),   FRAC_CONST(0.98340366957925973),   FRAC_CONST(0.98369921885973044),
    FRAC_CONST(0.98399213448135414),    FRAC_CONST(0.98428241565990748),   FRAC_CONST(0.98457006161822058),   FRAC_CONST(0.98485507158617835),   FRAC_CONST(0.98513744480072363),
    FRAC_CONST(0.98541718050585803),    FRAC_CONST(0.98569427795264519),   FRAC_CONST(0.98596873639921168),   FRAC_CONST(0.98624055511074971),   FRAC_CONST(0.98650973335951875),
    FRAC_CONST(0.98677627042484772),    FRAC_CONST(0.98704016559313645),   FRAC_CONST(0.98730141815785832),   FRAC_CONST(0.98756002741956173),   FRAC_CONST(0.9878159926858715),
    FRAC_CONST(0.98806931327149194),    FRAC_CONST(0.98831998849820735),   FRAC_CONST(0.98856801769488489),   FRAC_CONST(0.98881340019747566),   FRAC_CONST(0.98905613534901682),
    FRAC_CONST(0.98929622249963345),    FRAC_CONST(0.98953366100653983),   FRAC_CONST(0.98976845023404181),   FRAC_CONST(0.99000058955353776),   FRAC_CONST(0.99023007834352106),
    FRAC_CONST(0.99045691598958097),    FRAC_CONST(0.99068110188440506),   FRAC_CONST(0.99090263542778001),   FRAC_CONST(0.99112151602659404),   FRAC_CONST(0.99133774309483769),
    FRAC_CONST(0.99155131605360625),    FRAC_CONST(0.99176223433110056),   FRAC_CONST(0.99197049736262888),   FRAC_CONST(0.99217610459060845),   FRAC_CONST(0.99237905546456673),
    FRAC_CONST(0.99257934944114334),    FRAC_CONST(0.99277698598409092),   FRAC_CONST(0.99297196456427694),   FRAC_CONST(0.99316428465968509),   FRAC_CONST(0.99335394575541669),
    FRAC_CONST(0.99354094734369169),    FRAC_CONST(0.99372528892385081),   FRAC_CONST(0.99390697000235606),   FRAC_CONST(0.99408599009279242),   FRAC_CONST(0.99426234871586938),
    FRAC_CONST(0.99443604539942176),    FRAC_CONST(0.99460707967841133),   FRAC_CONST(0.99477545109492771),   FRAC_CONST(0.99494115919819004),   FRAC_CONST(0.99510420354454787),
    FRAC_CONST(0.99526458369748239),    FRAC_CONST(0.99542229922760772),   FRAC_CONST(0.99557734971267187),   FRAC_CONST(0.9957297347375581),    FRAC_CONST(0.99587945389428578),
    FRAC_CONST(0.99602650678201154),    FRAC_CONST(0.99617089300703077),   FRAC_CONST(0.996312612182778),     FRAC_CONST(0.99645166392982831),   FRAC_CONST(0.99658804787589839),
    FRAC_CONST(0.99672176365584741),    FRAC_CONST(0.99685281091167788),   FRAC_CONST(0.99698118929253687),   FRAC_CONST(0.99710689845471678),   FRAC_CONST(0.99722993806165661),
    FRAC_CONST(0.99735030778394196),    FRAC_CONST(0.99746800729930707),   FRAC_CONST(0.99758303629263489),   FRAC_CONST(0.99769539445595812),   FRAC_CONST(0.99780508148846014),
    FRAC_CONST(0.99791209709647588),    FRAC_CONST(0.99801644099349218),   FRAC_CONST(0.99811811290014918),   FRAC_CONST(0.9982171125442405),    FRAC_CONST(0.9983134396607144),
    FRAC_CONST(0.99840709399167404),    FRAC_CONST(0.99849807528637868),   FRAC_CONST(0.99858638330124405),   FRAC_CONST(0.99867201779984294),   FRAC_CONST(0.99875497855290607),
    FRAC_CONST(0.99883526533832245),    FRAC_CONST(0.99891287794114036),   FRAC_CONST(0.99898781615356746),   FRAC_CONST(0.99906007977497147),   FRAC_CONST(0.99912966861188113),
    FRAC_CONST(0.99919658247798593),    FRAC_CONST(0.99926082119413751),   FRAC_CONST(0.99932238458834954),   FRAC_CONST(0.999381272495798),     FRAC_CONST(0.99943748475882255),
    FRAC_CONST(0.9994910212269259),     FRAC_CONST(0.99954188175677483),   FRAC_CONST(0.99959006621220048),   FRAC_CONST(0.99963557446419837),   FRAC_CONST(0.99967840639092931),
    FRAC_CONST(0.99971856187771946),    FRAC_CONST(0.99975604081706027),   FRAC_CONST(0.99979084310860955),   FRAC_CONST(0.99982296865919107),   FRAC_CONST(0.99985241738279484),
    FRAC_CONST(0.99987918920057806),    FRAC_CONST(0.99990328404086426),   FRAC_CONST(0.9999247018391445),    FRAC_CONST(0.99994344253807688),   FRAC_CONST(0.99995950608748674),
    FRAC_CONST(0.99997289244436727),    FRAC_CONST(0.99998360157287902),   FRAC_CONST(0.9999916334443506),    FRAC_CONST(0.99999698803727821),   FRAC_CONST(0.99999966533732598)};
#endif

static const real_t sine_short_128[] = {
    FRAC_CONST(0.0061358846491544753), FRAC_CONST(0.01840672990580482),  FRAC_CONST(0.030674803176636626), FRAC_CONST(0.04293825693494082), FRAC_CONST(0.055195244349689934),
    FRAC_CONST(0.067443919563664051),  FRAC_CONST(0.079682437971430126), FRAC_CONST(0.091908956497132724), FRAC_CONST(0.10412163387205459), FRAC_CONST(0.11631863091190475),
    FRAC_CONST(0.12849811079379317),   FRAC_CONST(0.14065823933284921),  FRAC_CONST(0.15279718525844344),  FRAC_CONST(0.16491312048996989), FRAC_CONST(0.17700422041214875),
    FRAC_CONST(0.18906866414980619),   FRAC_CONST(0.2011046348420919),   FRAC_CONST(0.21311031991609136),  FRAC_CONST(0.22508391135979283), FRAC_CONST(0.2370236059943672),
    FRAC_CONST(0.24892760574572015),   FRAC_CONST(0.26079411791527551),  FRAC_CONST(0.27262135544994898),  FRAC_CONST(0.28440753721127188), FRAC_CONST(0.29615088824362379),
    FRAC_CONST(0.30784964004153487),   FRAC_CONST(0.31950203081601569),  FRAC_CONST(0.33110630575987643),  FRAC_CONST(0.34266071731199438), FRAC_CONST(0.35416352542049034),
    FRAC_CONST(0.36561299780477385),   FRAC_CONST(0.37700741021641826),  FRAC_CONST(0.38834504669882625),  FRAC_CONST(0.39962419984564679), FRAC_CONST(0.41084317105790391),
    FRAC_CONST(0.42200027079979968),   FRAC_CONST(0.43309381885315196),  FRAC_CONST(0.4441221445704292),   FRAC_CONST(0.45508358712634384), FRAC_CONST(0.46597649576796618),
    FRAC_CONST(0.47679923006332209),   FRAC_CONST(0.487550160148436),    FRAC_CONST(0.49822766697278187),  FRAC_CONST(0.50883014254310699), FRAC_CONST(0.51935599016558964),
    FRAC_CONST(0.52980362468629461),   FRAC_CONST(0.54017147272989285),  FRAC_CONST(0.55045797293660481),  FRAC_CONST(0.56066157619733603), FRAC_CONST(0.57078074588696726),
    FRAC_CONST(0.58081395809576453),   FRAC_CONST(0.59075970185887416),  FRAC_CONST(0.60061647938386897),  FRAC_CONST(0.61038280627630948), FRAC_CONST(0.6200572117632891),
    FRAC_CONST(0.62963823891492698),   FRAC_CONST(0.63912444486377573),  FRAC_CONST(0.64851440102211244),  FRAC_CONST(0.65780669329707864), FRAC_CONST(0.66699992230363747),
    FRAC_CONST(0.67609270357531592),   FRAC_CONST(0.68508366777270036),  FRAC_CONST(0.693971460889654),    FRAC_CONST(0.7027547444572253),  FRAC_CONST(0.71143219574521643),
    FRAC_CONST(0.72000250796138165),   FRAC_CONST(0.7284643904482252),   FRAC_CONST(0.73681656887736979),  FRAC_CONST(0.74505778544146595), FRAC_CONST(0.75318679904361241),
    FRAC_CONST(0.76120238548426178),   FRAC_CONST(0.76910333764557959),  FRAC_CONST(0.77688846567323244),  FRAC_CONST(0.78455659715557524), FRAC_CONST(0.79210657730021239),
    FRAC_CONST(0.79953726910790501),   FRAC_CONST(0.80684755354379922),  FRAC_CONST(0.8140363297059483),   FRAC_CONST(0.82110251499110465), FRAC_CONST(0.8280450452577558),
    FRAC_CONST(0.83486287498638001),   FRAC_CONST(0.84155497743689833),  FRAC_CONST(0.84812034480329712),  FRAC_CONST(0.85455798836540053), FRAC_CONST(0.86086693863776731),
    FRAC_CONST(0.86704624551569265),   FRAC_CONST(0.87309497841829009),  FRAC_CONST(0.87901222642863341),  FRAC_CONST(0.88479709843093779), FRAC_CONST(0.89044872324475788),
    FRAC_CONST(0.89596624975618511),   FRAC_CONST(0.90134884704602203),  FRAC_CONST(0.90659570451491533),  FRAC_CONST(0.91170603200542988), FRAC_CONST(0.9166790599210427),
    FRAC_CONST(0.9215140393420419),    FRAC_CONST(0.92621024213831127),  FRAC_CONST(0.93076696107898371),  FRAC_CONST(0.9351835099389475),  FRAC_CONST(0.93945922360218992),
    FRAC_CONST(0.94359345816196039),   FRAC_CONST(0.94758559101774109),  FRAC_CONST(0.95143502096900834),  FRAC_CONST(0.95514116830577067), FRAC_CONST(0.9587034748958716),
    FRAC_CONST(0.96212140426904158),   FRAC_CONST(0.9653944416976894),   FRAC_CONST(0.96852209427441727),  FRAC_CONST(0.97150389098625178), FRAC_CONST(0.97433938278557586),
    FRAC_CONST(0.97702814265775439),   FRAC_CONST(0.97956976568544052),  FRAC_CONST(0.98196386910955524),  FRAC_CONST(0.98421009238692903), FRAC_CONST(0.98630809724459867),
    FRAC_CONST(0.98825756773074946),   FRAC_CONST(0.99005821026229712),  FRAC_CONST(0.99170975366909953),  FRAC_CONST(0.9932119492347945),  FRAC_CONST(0.99456457073425542),
    FRAC_CONST(0.99576741446765982),   FRAC_CONST(0.99682029929116567),  FRAC_CONST(0.99772306664419164),  FRAC_CONST(0.99847558057329477), FRAC_CONST(0.99907772775264536),
    FRAC_CONST(0.99952941750109314),   FRAC_CONST(0.9998305817958234),   FRAC_CONST(0.99998117528260111)};

#ifdef ALLOW_SMALL_FRAMELENGTH
static const real_t sine_short_120[] = {
    FRAC_CONST(0.0065449379673518581), FRAC_CONST(0.019633692460628301), FRAC_CONST(0.032719082821776137), FRAC_CONST(0.045798866936520771), FRAC_CONST(0.058870803651189033),
    FRAC_CONST(0.071932653156719387),  FRAC_CONST(0.084982177372441667), FRAC_CONST(0.09801714032956059),  FRAC_CONST(0.11103530855427769),  FRAC_CONST(0.12403445145048532),
    FRAC_CONST(0.13701234168196802),   FRAC_CONST(0.14996675555404498),  FRAC_CONST(0.16289547339458874),  FRAC_CONST(0.17579627993435451),  FRAC_CONST(0.18866696468655525),
    FRAC_CONST(0.2015053223256171),    FRAC_CONST(0.21430915306505074),  FRAC_CONST(0.2270762630343732),   FRAC_CONST(0.23980446465501654),  FRAC_CONST(0.25249157701515795),
    FRAC_CONST(0.26513542624340797),   FRAC_CONST(0.27773384588129219),  FRAC_CONST(0.29028467725446233),  FRAC_CONST(0.3027857698425746),   FRAC_CONST(0.31523498164776964),
    FRAC_CONST(0.32763017956169349),   FRAC_CONST(0.33996923973099424),  FRAC_CONST(0.35225004792123354),  FRAC_CONST(0.36447049987914965),  FRAC_CONST(0.37662850169321077),
    FRAC_CONST(0.38872197015239557),   FRAC_CONST(0.40074883310314097),  FRAC_CONST(0.41270702980439467),  FRAC_CONST(0.42459451128071307),  FRAC_CONST(0.43640924067334208),
    FRAC_CONST(0.44814919358922256),   FRAC_CONST(0.45981235844785984),  FRAC_CONST(0.47139673682599764),  FRAC_CONST(0.48290034380003727),  FRAC_CONST(0.49432120828614462),
    FRAC_CONST(0.50565737337798455),   FRAC_CONST(0.51690689668202761),  FRAC_CONST(0.52806785065036799),  FRAC_CONST(0.53913832291100017),  FRAC_CONST(0.55011641659549337),
    FRAC_CONST(0.56100025066400983),   FRAC_CONST(0.57178796022761225),  FRAC_CONST(0.58247769686780215),  FRAC_CONST(0.59306762895323706),  FRAC_CONST(0.60355594195357143),
    FRAC_CONST(0.61394083875036642),   FRAC_CONST(0.62422053994501758),  FRAC_CONST(0.63439328416364549),  FRAC_CONST(0.64445732835889735),  FRAC_CONST(0.65441094810861034),
    FRAC_CONST(0.66425243791128175),   FRAC_CONST(0.67398011147829784),  FRAC_CONST(0.68359230202287125),  FRAC_CONST(0.69308736254563585),  FRAC_CONST(0.70246366611685174),
    FRAC_CONST(0.71171960615517138),   FRAC_CONST(0.72085359670291882),  FRAC_CONST(0.7298640726978356),   FRAC_CONST(0.73874949024124625),  FRAC_CONST(0.74750832686259672),
    FRAC_CONST(0.75613908178032285),   FRAC_CONST(0.76464027615900032),  FRAC_CONST(0.77301045336273699),  FRAC_CONST(0.78124817920475853),  FRAC_CONST(0.78935204219315003),
    FRAC_CONST(0.79732065377270711),   FRAC_CONST(0.80515264856285829),  FRAC_CONST(0.81284668459161513),  FRAC_CONST(0.82040144352551359),  FRAC_CONST(0.82781563089550203),
    FRAC_CONST(0.83508797631874299),   FRAC_CONST(0.84221723371628654),  FRAC_CONST(0.84920218152657889),  FRAC_CONST(0.85604162291477137),  FRAC_CONST(0.86273438597779184),
    FRAC_CONST(0.86927932394514362),   FRAC_CONST(0.87567531537539967),  FRAC_CONST(0.88192126434835494),  FRAC_CONST(0.88801610065280734),  FRAC_CONST(0.89395877996993212),
    FRAC_CONST(0.8997482840522214),    FRAC_CONST(0.90538362089795521),  FRAC_CONST(0.91086382492117568),  FRAC_CONST(0.91618795711713596),  FRAC_CONST(0.92135510522319242),
    FRAC_CONST(0.9263643838751181),    FRAC_CONST(0.93121493475880346),  FRAC_CONST(0.93590592675732565),  FRAC_CONST(0.94043655609335486),  FRAC_CONST(0.94480604646687805),
    FRAC_CONST(0.94901364918821385),   FRAC_CONST(0.95305864330629697),  FRAC_CONST(0.95694033573220882),  FRAC_CONST(0.9606580613579353),   FRAC_CONST(0.96421118317032928),
    FRAC_CONST(0.96759909236025976),   FRAC_CONST(0.9708212084269281),   FRAC_CONST(0.97387697927733363),  FRAC_CONST(0.97676588132087239),  FRAC_CONST(0.97948741955905139),
    FRAC_CONST(0.98204112767030394),   FRAC_CONST(0.98442656808989171),  FRAC_CONST(0.98664333208487898),  FRAC_CONST(0.98869103982416728),  FRAC_CONST(0.99056934044357725),
    FRAC_CONST(0.99227791210596705),   FRAC_CONST(0.99381646205637808),  FRAC_CONST(0.99518472667219682),  FRAC_CONST(0.99638247150832537),  FRAC_CONST(0.99740949133735191),
    FRAC_CONST(0.99826561018471593),   FRAC_CONST(0.99895068135886012),  FRAC_CONST(0.99946458747636568),  FRAC_CONST(0.99980724048206482),  FRAC_CONST(0.99997858166412923)};
#endif

#ifdef LD_DEC
static const real_t sine_mid_512[] = {
    FRAC_CONST(0.0015339801862847655), FRAC_CONST(0.0046019261204485705), FRAC_CONST(0.007669828739531097), FRAC_CONST(0.010737659167264491), FRAC_CONST(0.013805388528060391),
    FRAC_CONST(0.01687298794728171),   FRAC_CONST(0.019940428551514441),  FRAC_CONST(0.023007681468839369), FRAC_CONST(0.026074717829103901), FRAC_CONST(0.029141508764193722),
    FRAC_CONST(0.032208025408304586),  FRAC_CONST(0.035274238898213947),  FRAC_CONST(0.038340120373552694), FRAC_CONST(0.041405640977076739), FRAC_CONST(0.044470771854938668),
    FRAC_CONST(0.047535484156959303),  FRAC_CONST(0.050599749036899282),  FRAC_CONST(0.05366353765273052),  FRAC_CONST(0.056726821166907748), FRAC_CONST(0.059789570746639868),
    FRAC_CONST(0.062851757564161406),  FRAC_CONST(0.065913352797003805),  FRAC_CONST(0.068974327628266746), FRAC_CONST(0.072034653246889332), FRAC_CONST(0.075094300847921305),
    FRAC_CONST(0.078153241632794232),  FRAC_CONST(0.081211446809592441),  FRAC_CONST(0.084268887593324071), FRAC_CONST(0.087325535206192059), FRAC_CONST(0.090381360877864983),
    FRAC_CONST(0.093436335845747787),  FRAC_CONST(0.096490431355252593),  FRAC_CONST(0.099543618660069319), FRAC_CONST(0.10259586902243628),  FRAC_CONST(0.10564715371341062),
    FRAC_CONST(0.10869744401313872),   FRAC_CONST(0.11174671121112659),   FRAC_CONST(0.11479492660651008),  FRAC_CONST(0.11784206150832498),  FRAC_CONST(0.12088808723577708),
    FRAC_CONST(0.12393297511851216),   FRAC_CONST(0.12697669649688587),   FRAC_CONST(0.13001922272223335),  FRAC_CONST(0.13306052515713906),  FRAC_CONST(0.1361005751757062),
    FRAC_CONST(0.1391393441638262),    FRAC_CONST(0.14217680351944803),   FRAC_CONST(0.14521292465284746),  FRAC_CONST(0.14824767898689603),  FRAC_CONST(0.15128103795733022),
    FRAC_CONST(0.1543129730130201),    FRAC_CONST(0.15734345561623825),   FRAC_CONST(0.16037245724292828),  FRAC_CONST(0.16339994938297323),  FRAC_CONST(0.1664259035404641),
    FRAC_CONST(0.16945029123396796),   FRAC_CONST(0.17247308399679595),   FRAC_CONST(0.17549425337727143),  FRAC_CONST(0.17851377093899751),  FRAC_CONST(0.18153160826112497),
    FRAC_CONST(0.18454773693861962),   FRAC_CONST(0.1875621285825296),    FRAC_CONST(0.19057475482025274),  FRAC_CONST(0.19358558729580361),  FRAC_CONST(0.19659459767008022),
    FRAC_CONST(0.19960175762113097),   FRAC_CONST(0.20260703884442113),   FRAC_CONST(0.20561041305309924),  FRAC_CONST(0.20861185197826349),  FRAC_CONST(0.21161132736922755),
    FRAC_CONST(0.21460881099378676),   FRAC_CONST(0.21760427463848364),   FRAC_CONST(0.22059769010887351),  FRAC_CONST(0.22358902922978999),  FRAC_CONST(0.22657826384561),
    FRAC_CONST(0.22956536582051887),   FRAC_CONST(0.23255030703877524),   FRAC_CONST(0.23553305940497549),  FRAC_CONST(0.23851359484431842),  FRAC_CONST(0.24149188530286933),
    FRAC_CONST(0.24446790274782415),   FRAC_CONST(0.24744161916777327),   FRAC_CONST(0.25041300657296522),  FRAC_CONST(0.25338203699557016),  FRAC_CONST(0.25634868248994291),
    FRAC_CONST(0.25931291513288623),   FRAC_CONST(0.26227470702391359),   FRAC_CONST(0.26523403028551179),  FRAC_CONST(0.26819085706340318),  FRAC_CONST(0.27114515952680801),
    FRAC_CONST(0.27409690986870638),   FRAC_CONST(0.2770460803060999),    FRAC_CONST(0.27999264308027322),  FRAC_CONST(0.28293657045705539),  FRAC_CONST(0.28587783472708062),
    FRAC_CONST(0.28881640820604948),   FRAC_CONST(0.29175226323498926),   FRAC_CONST(0.29468537218051433),  FRAC_CONST(0.2976157074350862),   FRAC_CONST(0.30054324141727345),
    FRAC_CONST(0.30346794657201132),   FRAC_CONST(0.30638979537086092),   FRAC_CONST(0.30930876031226873),  FRAC_CONST(0.31222481392182488),  FRAC_CONST(0.31513792875252244),
    FRAC_CONST(0.31804807738501495),   FRAC_CONST(0.32095523242787521),   FRAC_CONST(0.32385936651785285),  FRAC_CONST(0.32676045232013173),  FRAC_CONST(0.32965846252858749),
    FRAC_CONST(0.33255336986604422),   FRAC_CONST(0.3354451470845316),    FRAC_CONST(0.33833376696554113),  FRAC_CONST(0.34121920232028236),  FRAC_CONST(0.34410142598993881),
    FRAC_CONST(0.34698041084592368),   FRAC_CONST(0.34985612979013492),   FRAC_CONST(0.35272855575521073),  FRAC_CONST(0.35559766170478385),  FRAC_CONST(0.35846342063373654),
    FRAC_CONST(0.36132580556845428),   FRAC_CONST(0.36418478956707989),   FRAC_CONST(0.36704034571976718),  FRAC_CONST(0.3698924471489341),   FRAC_CONST(0.37274106700951576),
    FRAC_CONST(0.37558617848921722),   FRAC_CONST(0.37842775480876556),   FRAC_CONST(0.38126576922216238),  FRAC_CONST(0.38410019501693504),  FRAC_CONST(0.38693100551438858),
    FRAC_CONST(0.38975817406985641),   FRAC_CONST(0.39258167407295147),   FRAC_CONST(0.39540147894781635),  FRAC_CONST(0.39821756215337356),  FRAC_CONST(0.40102989718357562),
    FRAC_CONST(0.40383845756765407),   FRAC_CONST(0.40664321687036903),   FRAC_CONST(0.40944414869225759),  FRAC_CONST(0.41224122666988289),  FRAC_CONST(0.41503442447608163),
    FRAC_CONST(0.41782371582021227),   FRAC_CONST(0.42060907444840251),   FRAC_CONST(0.42339047414379605),  FRAC_CONST(0.42616788872679962),  FRAC_CONST(0.42894129205532949),
    FRAC_CONST(0.43171065802505726),   FRAC_CONST(0.43447596056965565),   FRAC_CONST(0.43723717366104409),  FRAC_CONST(0.43999427130963326),  FRAC_CONST(0.44274722756457002),
    FRAC_CONST(0.44549601651398174),   FRAC_CONST(0.44824061228521989),   FRAC_CONST(0.45098098904510386),  FRAC_CONST(0.45371712100016387),  FRAC_CONST(0.45644898239688392),
    FRAC_CONST(0.45917654752194409),   FRAC_CONST(0.46189979070246273),   FRAC_CONST(0.46461868630623782),  FRAC_CONST(0.46733320874198842),  FRAC_CONST(0.47004333245959562),
    FRAC_CONST(0.47274903195034279),   FRAC_CONST(0.47545028174715587),   FRAC_CONST(0.47814705642484301),  FRAC_CONST(0.48083933060033396),  FRAC_CONST(0.48352707893291874),
    FRAC_CONST(0.48621027612448642),   FRAC_CONST(0.48888889691976317),   FRAC_CONST(0.4915629161065499),   FRAC_CONST(0.49423230851595967),  FRAC_CONST(0.49689704902265447),
    FRAC_CONST(0.49955711254508184),   FRAC_CONST(0.50221247404571079),   FRAC_CONST(0.50486310853126759),  FRAC_CONST(0.50750899105297087),  FRAC_CONST(0.51015009670676681),
    FRAC_CONST(0.51278640063356296),   FRAC_CONST(0.51541787801946293),   FRAC_CONST(0.51804450409599934),  FRAC_CONST(0.52066625414036716),  FRAC_CONST(0.52328310347565643),
    FRAC_CONST(0.52589502747108463),   FRAC_CONST(0.52850200154222848),   FRAC_CONST(0.531104001151255),    FRAC_CONST(0.53370100180715296),  FRAC_CONST(0.53629297906596318),
    FRAC_CONST(0.53887990853100842),   FRAC_CONST(0.54146176585312344),   FRAC_CONST(0.54403852673088382),  FRAC_CONST(0.54661016691083486),  FRAC_CONST(0.54917666218771966),
    FRAC_CONST(0.55173798840470734),   FRAC_CONST(0.55429412145362),      FRAC_CONST(0.5568450372751601),   FRAC_CONST(0.55939071185913614),  FRAC_CONST(0.56193112124468947),
    FRAC_CONST(0.5644662415205195),    FRAC_CONST(0.56699604882510868),   FRAC_CONST(0.56952051934694714),  FRAC_CONST(0.57203962932475705),  FRAC_CONST(0.57455335504771576),
    FRAC_CONST(0.57706167285567944),   FRAC_CONST(0.57956455913940563),   FRAC_CONST(0.58206199034077544),  FRAC_CONST(0.58455394295301533),  FRAC_CONST(0.58704039352091797),
    FRAC_CONST(0.58952131864106394),   FRAC_CONST(0.59199669496204099),   FRAC_CONST(0.59446649918466443),  FRAC_CONST(0.5969307080621965),   FRAC_CONST(0.59938929840056454),
    FRAC_CONST(0.60184224705858003),   FRAC_CONST(0.60428953094815596),   FRAC_CONST(0.60673112703452448),  FRAC_CONST(0.60916701233645321),  FRAC_CONST(0.61159716392646191),
    FRAC_CONST(0.61402155893103838),   FRAC_CONST(0.61644017453085365),   FRAC_CONST(0.61885298796097632),  FRAC_CONST(0.62125997651108755),  FRAC_CONST(0.62366111752569453),
    FRAC_CONST(0.62605638840434352),   FRAC_CONST(0.62844576660183271),   FRAC_CONST(0.63082922962842447),  FRAC_CONST(0.63320675505005719),  FRAC_CONST(0.63557832048855611),
    FRAC_CONST(0.63794390362184406),   FRAC_CONST(0.64030348218415167),   FRAC_CONST(0.64265703396622686),  FRAC_CONST(0.64500453681554393),  FRAC_CONST(0.64734596863651206),
    FRAC_CONST(0.64968130739068319),   FRAC_CONST(0.6520105310969595),    FRAC_CONST(0.65433361783180044),  FRAC_CONST(0.65665054572942894),  FRAC_CONST(0.65896129298203732),
    FRAC_CONST(0.66126583783999227),   FRAC_CONST(0.66356415861203977),   FRAC_CONST(0.66585623366550972),  FRAC_CONST(0.66814204142651845),  FRAC_CONST(0.67042156038017309),
    FRAC_CONST(0.67269476907077286),   FRAC_CONST(0.67496164610201193),   FRAC_CONST(0.67722217013718033),  FRAC_CONST(0.67947631989936497),  FRAC_CONST(0.68172407417164971),
    FRAC_CONST(0.6839654117973154),    FRAC_CONST(0.68620031168003859),   FRAC_CONST(0.68842875278409044),  FRAC_CONST(0.6906507141345346),   FRAC_CONST(0.69286617481742463),
    FRAC_CONST(0.69507511398000088),   FRAC_CONST(0.69727751083088652),   FRAC_CONST(0.69947334464028377),  FRAC_CONST(0.70166259474016845),  FRAC_CONST(0.70384524052448494),
    FRAC_CONST(0.70602126144933974),   FRAC_CONST(0.70819063703319529),   FRAC_CONST(0.71035334685706231),  FRAC_CONST(0.71250937056469232),  FRAC_CONST(0.71465868786276898),
    FRAC_CONST(0.71680127852109954),   FRAC_CONST(0.71893712237280438),   FRAC_CONST(0.72106619931450811),  FRAC_CONST(0.72318848930652735),  FRAC_CONST(0.72530397237306066),
    FRAC_CONST(0.72741262860237577),   FRAC_CONST(0.7295144381469969),    FRAC_CONST(0.73160938122389252),  FRAC_CONST(0.73369743811466026),  FRAC_CONST(0.73577858916571348),
    FRAC_CONST(0.73785281478846598),   FRAC_CONST(0.73992009545951609),   FRAC_CONST(0.74198041172083096),  FRAC_CONST(0.74403374417992918),  FRAC_CONST(0.74608007351006378),
    FRAC_CONST(0.74811938045040349),   FRAC_CONST(0.75015164580621496),   FRAC_CONST(0.7521768504490427),   FRAC_CONST(0.75419497531688917),  FRAC_CONST(0.75620600141439454),
    FRAC_CONST(0.75820990981301528),   FRAC_CONST(0.76020668165120242),   FRAC_CONST(0.7621962981345789),   FRAC_CONST(0.76417874053611667),  FRAC_CONST(0.76615399019631281),
    FRAC_CONST(0.76812202852336531),   FRAC_CONST(0.7700828369933479),    FRAC_CONST(0.77203639715038441),  FRAC_CONST(0.77398269060682279),  FRAC_CONST(0.77592169904340758),
    FRAC_CONST(0.77785340420945304),   FRAC_CONST(0.77977778792301444),   FRAC_CONST(0.78169483207105939),  FRAC_CONST(0.7836045186096382),   FRAC_CONST(0.78550682956405393),
    FRAC_CONST(0.78740174702903132),   FRAC_CONST(0.78928925316888565),   FRAC_CONST(0.79116933021769009),  FRAC_CONST(0.79304196047944364),  FRAC_CONST(0.79490712632823701),
    FRAC_CONST(0.79676481020841872),   FRAC_CONST(0.79861499463476082),   FRAC_CONST(0.80045766219262271),  FRAC_CONST(0.80229279553811572),  FRAC_CONST(0.8041203773982657),
    FRAC_CONST(0.80594039057117628),   FRAC_CONST(0.80775281792619036),   FRAC_CONST(0.80955764240405126),  FRAC_CONST(0.81135484701706373),  FRAC_CONST(0.81314441484925359),
    FRAC_CONST(0.81492632905652662),   FRAC_CONST(0.81670057286682785),   FRAC_CONST(0.81846712958029866),  FRAC_CONST(0.82022598256943469),  FRAC_CONST(0.82197711527924155),
    FRAC_CONST(0.82372051122739132),   FRAC_CONST(0.82545615400437744),   FRAC_CONST(0.82718402727366902),  FRAC_CONST(0.82890411477186487),  FRAC_CONST(0.8306164003088462),
    FRAC_CONST(0.83232086776792968),   FRAC_CONST(0.83401750110601813),   FRAC_CONST(0.8357062843537526),   FRAC_CONST(0.83738720161566194),  FRAC_CONST(0.83906023707031263),
    FRAC_CONST(0.84072537497045807),   FRAC_CONST(0.84238259964318596),   FRAC_CONST(0.84403189549006641),  FRAC_CONST(0.84567324698729907),  FRAC_CONST(0.84730663868585832),
    FRAC_CONST(0.84893205521163961),   FRAC_CONST(0.85054948126560337),   FRAC_CONST(0.85215890162391983),  FRAC_CONST(0.8537603011381113),   FRAC_CONST(0.85535366473519603),
    FRAC_CONST(0.85693897741782865),   FRAC_CONST(0.85851622426444274),   FRAC_CONST(0.86008539042939014),  FRAC_CONST(0.8616464611430813),   FRAC_CONST(0.86319942171212416),
    FRAC_CONST(0.86474425751946238),   FRAC_CONST(0.86628095402451299),   FRAC_CONST(0.86780949676330321),  FRAC_CONST(0.86932987134860673),  FRAC_CONST(0.87084206347007886),
    FRAC_CONST(0.87234605889439154),   FRAC_CONST(0.87384184346536675),   FRAC_CONST(0.87532940310411078),  FRAC_CONST(0.87680872380914576),  FRAC_CONST(0.87827979165654146),
    FRAC_CONST(0.87974259280004741),   FRAC_CONST(0.88119711347122198),   FRAC_CONST(0.88264333997956279),  FRAC_CONST(0.88408125871263499),  FRAC_CONST(0.88551085613619995),
    FRAC_CONST(0.88693211879434208),   FRAC_CONST(0.88834503330959624),   FRAC_CONST(0.88974958638307289),  FRAC_CONST(0.89114576479458318),  FRAC_CONST(0.89253355540276469),
    FRAC_CONST(0.89391294514520325),   FRAC_CONST(0.89528392103855758),   FRAC_CONST(0.89664647017868015),  FRAC_CONST(0.89800057974073988),  FRAC_CONST(0.89934623697934146),
    FRAC_CONST(0.90068342922864686),   FRAC_CONST(0.90201214390249307),   FRAC_CONST(0.90333236849451182),  FRAC_CONST(0.90464409057824624),  FRAC_CONST(0.90594729780726846),
    FRAC_CONST(0.90724197791529593),   FRAC_CONST(0.90852811871630612),   FRAC_CONST(0.90980570810465222),  FRAC_CONST(0.91107473405517625),  FRAC_CONST(0.91233518462332275),
    FRAC_CONST(0.91358704794525081),   FRAC_CONST(0.91483031223794609),   FRAC_CONST(0.91606496579933161),  FRAC_CONST(0.91729099700837791),  FRAC_CONST(0.91850839432521225),
    FRAC_CONST(0.91971714629122736),   FRAC_CONST(0.92091724152918952),   FRAC_CONST(0.92210866874334507),  FRAC_CONST(0.92329141671952764),  FRAC_CONST(0.9244654743252626),
    FRAC_CONST(0.92563083050987272),   FRAC_CONST(0.92678747430458175),   FRAC_CONST(0.92793539482261789),  FRAC_CONST(0.92907458125931575),  FRAC_CONST(0.93020502289221907),
    FRAC_CONST(0.93132670908118043),   FRAC_CONST(0.93243962926846236),   FRAC_CONST(0.93354377297883617),  FRAC_CONST(0.93463912981968078),  FRAC_CONST(0.93572568948108037),
    FRAC_CONST(0.93680344173592156),   FRAC_CONST(0.93787237643998989),   FRAC_CONST(0.93893248353206449),  FRAC_CONST(0.93998375303401394),  FRAC_CONST(0.94102617505088926),
    FRAC_CONST(0.94205973977101731),   FRAC_CONST(0.94308443746609349),   FRAC_CONST(0.94410025849127266),  FRAC_CONST(0.94510719328526061),  FRAC_CONST(0.94610523237040334),
    FRAC_CONST(0.94709436635277722),   FRAC_CONST(0.94807458592227623),   FRAC_CONST(0.94904588185270056),  FRAC_CONST(0.950008245001843),    FRAC_CONST(0.95096166631157508),
    FRAC_CONST(0.95190613680793223),   FRAC_CONST(0.95284164760119872),   FRAC_CONST(0.95376818988599033),  FRAC_CONST(0.95468575494133834),  FRAC_CONST(0.95559433413077111),
    FRAC_CONST(0.95649391890239499),   FRAC_CONST(0.95738450078897586),   FRAC_CONST(0.95826607140801767),  FRAC_CONST(0.95913862246184189),  FRAC_CONST(0.96000214573766585),
    FRAC_CONST(0.96085663310767966),   FRAC_CONST(0.96170207652912254),   FRAC_CONST(0.96253846804435916),  FRAC_CONST(0.96336579978095405),  FRAC_CONST(0.96418406395174572),
    FRAC_CONST(0.96499325285492032),   FRAC_CONST(0.96579335887408357),   FRAC_CONST(0.96658437447833312),  FRAC_CONST(0.96736629222232851),  FRAC_CONST(0.96813910474636233),
    FRAC_CONST(0.96890280477642887),   FRAC_CONST(0.96965738512429245),   FRAC_CONST(0.9704028386875555),   FRAC_CONST(0.97113915844972509),  FRAC_CONST(0.9718663374802794),
    FRAC_CONST(0.97258436893473221),   FRAC_CONST(0.97329324605469825),   FRAC_CONST(0.97399296216795583),  FRAC_CONST(0.97468351068851067),  FRAC_CONST(0.97536488511665687),
    FRAC_CONST(0.97603707903903902),   FRAC_CONST(0.97670008612871184),   FRAC_CONST(0.97735390014519996),  FRAC_CONST(0.97799851493455714),  FRAC_CONST(0.9786339244294231),
    FRAC_CONST(0.97926012264908202),   FRAC_CONST(0.97987710369951764),   FRAC_CONST(0.98048486177346938),  FRAC_CONST(0.98108339115048659),  FRAC_CONST(0.98167268619698311),
    FRAC_CONST(0.98225274136628937),   FRAC_CONST(0.98282355119870524),   FRAC_CONST(0.98338511032155118),  FRAC_CONST(0.98393741344921892),  FRAC_CONST(0.98448045538322093),
    FRAC_CONST(0.98501423101223984),   FRAC_CONST(0.98553873531217606),   FRAC_CONST(0.98605396334619544),  FRAC_CONST(0.98655991026477541),  FRAC_CONST(0.98705657130575097),
    FRAC_CONST(0.98754394179435923),   FRAC_CONST(0.98802201714328353),   FRAC_CONST(0.98849079285269659),  FRAC_CONST(0.98895026451030299),  FRAC_CONST(0.98940042779138038),
    FRAC_CONST(0.98984127845882053),   FRAC_CONST(0.99027281236316911),   FRAC_CONST(0.99069502544266463),  FRAC_CONST(0.99110791372327678),  FRAC_CONST(0.9915114733187439),
    FRAC_CONST(0.99190570043060933),   FRAC_CONST(0.99229059134825737),   FRAC_CONST(0.99266614244894802),  FRAC_CONST(0.99303235019785141),  FRAC_CONST(0.99338921114808065),
    FRAC_CONST(0.9937367219407246),    FRAC_CONST(0.99407487930487937),   FRAC_CONST(0.9944036800576791),   FRAC_CONST(0.9947231211043257),   FRAC_CONST(0.99503319943811863),
    FRAC_CONST(0.99533391214048228),   FRAC_CONST(0.99562525638099431),   FRAC_CONST(0.99590722941741172),  FRAC_CONST(0.99617982859569687),  FRAC_CONST(0.99644305135004263),
    FRAC_CONST(0.99669689520289606),   FRAC_CONST(0.99694135776498216),   FRAC_CONST(0.99717643673532619),  FRAC_CONST(0.9974021299012753),   FRAC_CONST(0.99761843513851955),
    FRAC_CONST(0.99782535041111164),   FRAC_CONST(0.99802287377148624),   FRAC_CONST(0.99821100336047819),  FRAC_CONST(0.99838973740734016),  FRAC_CONST(0.99855907422975931),
    FRAC_CONST(0.99871901223387294),   FRAC_CONST(0.99886954991428356),   FRAC_CONST(0.99901068585407338),  FRAC_CONST(0.99914241872481691),  FRAC_CONST(0.99926474728659442),
    FRAC_CONST(0.99937767038800285),   FRAC_CONST(0.99948118696616695),   FRAC_CONST(0.99957529604674922),  FRAC_CONST(0.99965999674395922),  FRAC_CONST(0.99973528826056168),
    FRAC_CONST(0.99980116988788426),   FRAC_CONST(0.99985764100582386),   FRAC_CONST(0.9999047010828529),   FRAC_CONST(0.99994234967602391),  FRAC_CONST(0.99997058643097414),
    FRAC_CONST(0.9999894110819284),    FRAC_CONST(0.99999882345170188)};

    #ifdef ALLOW_SMALL_FRAMELENGTH
static const real_t sine_mid_480[] = {
    FRAC_CONST(0.0016362454436240478), FRAC_CONST(0.00490871880799799),  FRAC_CONST(0.0081811396039371282), FRAC_CONST(0.011453472786443779), FRAC_CONST(0.014725683311458524),
    FRAC_CONST(0.017997736136235509),  FRAC_CONST(0.021269596219717739), FRAC_CONST(0.024541228522912285),  FRAC_CONST(0.027812598009265607), FRAC_CONST(0.03108366964503869),
    FRAC_CONST(0.034354408399682276),  FRAC_CONST(0.037624779246211978), FRAC_CONST(0.04089474716158345),   FRAC_CONST(0.044164277127067358), FRAC_CONST(0.047433334128624507),
    FRAC_CONST(0.050701883157280733),  FRAC_CONST(0.053969889209501881), FRAC_CONST(0.057237317287568618),  FRAC_CONST(0.060504132399951269), FRAC_CONST(0.063770299561684493),
    FRAC_CONST(0.06703578379474201),   FRAC_CONST(0.070300550128411174), FRAC_CONST(0.073564563599667426),  FRAC_CONST(0.076827789253548759), FRAC_CONST(0.080090192143530081),
    FRAC_CONST(0.083351737331897449),  FRAC_CONST(0.086612389890122182), FRAC_CONST(0.089872114899234967),  FRAC_CONST(0.093130877450199795), FRAC_CONST(0.096388642644287828),
    FRAC_CONST(0.09964537559345106),   FRAC_CONST(0.1029010414206961),   FRAC_CONST(0.10615560526045748),   FRAC_CONST(0.10940903225897117),  FRAC_CONST(0.11266128757464781),
    FRAC_CONST(0.11591233637844581),   FRAC_CONST(0.11916214385424433),  FRAC_CONST(0.1224106751992162),    FRAC_CONST(0.12565789562420052),  FRAC_CONST(0.12890377035407541),
    FRAC_CONST(0.13214826462813015),   FRAC_CONST(0.13539134370043773),  FRAC_CONST(0.13863297284022669),   FRAC_CONST(0.14187311733225325),  FRAC_CONST(0.14511174247717309),
    FRAC_CONST(0.14834881359191271),   FRAC_CONST(0.15158429601004111),  FRAC_CONST(0.15481815508214106),   FRAC_CONST(0.1580503561761798),   FRAC_CONST(0.16128086467788047),
    FRAC_CONST(0.16450964599109233),   FRAC_CONST(0.16773666553816149),  FRAC_CONST(0.17096188876030122),   FRAC_CONST(0.17418528111796186),  FRAC_CONST(0.17740680809120093),
    FRAC_CONST(0.18062643518005275),   FRAC_CONST(0.18384412790489776),  FRAC_CONST(0.18705985180683199),   FRAC_CONST(0.19027357244803589),  FRAC_CONST(0.19348525541214331),
    FRAC_CONST(0.19669486630460997),   FRAC_CONST(0.19990237075308173),  FRAC_CONST(0.20310773440776286),   FRAC_CONST(0.20631092294178383),  FRAC_CONST(0.20951190205156878),
    FRAC_CONST(0.21271063745720317),   FRAC_CONST(0.21590709490280058),  FRAC_CONST(0.2191012401568698),    FRAC_CONST(0.22229303901268133),  FRAC_CONST(0.22548245728863364),
    FRAC_CONST(0.22866946082861941),   FRAC_CONST(0.23185401550239115),  FRAC_CONST(0.23503608720592667),   FRAC_CONST(0.23821564186179459),  FRAC_CONST(0.24139264541951888),
    FRAC_CONST(0.24456706385594387),   FRAC_CONST(0.24773886317559846),  FRAC_CONST(0.25090800941106001),   FRAC_CONST(0.25407446862331851),  FRAC_CONST(0.25723820690213967),
    FRAC_CONST(0.26039919036642817),   FRAC_CONST(0.26355738516459076),  FRAC_CONST(0.26671275747489837),   FRAC_CONST(0.2698652735058486),   FRAC_CONST(0.27301489949652735),
    FRAC_CONST(0.27616160171697068),   FRAC_CONST(0.27930534646852595),  FRAC_CONST(0.28244610008421245),   FRAC_CONST(0.2855838289290823),   FRAC_CONST(0.28871849940058025),
    FRAC_CONST(0.29185007792890405),   FRAC_CONST(0.29497853097736348),  FRAC_CONST(0.2981038250427398),    FRAC_CONST(0.30122592665564446),  FRAC_CONST(0.30434480238087736),
    FRAC_CONST(0.30746041881778519),   FRAC_CONST(0.31057274260061901),  FRAC_CONST(0.31368174039889146),   FRAC_CONST(0.31678737891773395),  FRAC_CONST(0.31988962489825296),
    FRAC_CONST(0.32298844511788638),   FRAC_CONST(0.32608380639075912),  FRAC_CONST(0.32917567556803889),   FRAC_CONST(0.33226401953829071),  FRAC_CONST(0.33534880522783189),
    FRAC_CONST(0.33842999960108583),   FRAC_CONST(0.34150756966093632),  FRAC_CONST(0.34458148244908043),   FRAC_CONST(0.34765170504638188),  FRAC_CONST(0.35071820457322322),
    FRAC_CONST(0.35378094818985806),   FRAC_CONST(0.35683990309676283),  FRAC_CONST(0.35989503653498811),   FRAC_CONST(0.36294631578650921),  FRAC_CONST(0.36599370817457672),
    FRAC_CONST(0.36903718106406647),   FRAC_CONST(0.37207670186182878),  FRAC_CONST(0.37511223801703802),   FRAC_CONST(0.37814375702154046),  FRAC_CONST(0.38117122641020335),
    FRAC_CONST(0.38419461376126157),   FRAC_CONST(0.38721388669666562),  FRAC_CONST(0.39022901288242801),   FRAC_CONST(0.39323996002896966),  FRAC_CONST(0.39624669589146555),
    FRAC_CONST(0.39924918827019029),   FRAC_CONST(0.40224740501086254),  FRAC_CONST(0.40524131400498986),   FRAC_CONST(0.40823088319021217),  FRAC_CONST(0.41121608055064529),
    FRAC_CONST(0.41419687411722372),   FRAC_CONST(0.41717323196804335),  FRAC_CONST(0.42014512222870243),   FRAC_CONST(0.42311251307264408),  FRAC_CONST(0.42607537272149631),
    FRAC_CONST(0.4290336694454126),    FRAC_CONST(0.43198737156341183),  FRAC_CONST(0.43493644744371707),   FRAC_CONST(0.43788086550409511),  FRAC_CONST(0.44082059421219388),
    FRAC_CONST(0.44375560208588088),   FRAC_CONST(0.44668585769357955),  FRAC_CONST(0.4496113296546066),    FRAC_CONST(0.45253198663950756),  FRAC_CONST(0.45544779737039259),
    FRAC_CONST(0.45835873062127125),   FRAC_CONST(0.46126475521838717),  FRAC_CONST(0.46416584004055156),   FRAC_CONST(0.46706195401947659),  FRAC_CONST(0.46995306614010829),
    FRAC_CONST(0.47283914544095862),   FRAC_CONST(0.47572016101443682),  FRAC_CONST(0.47859608200718085),   FRAC_CONST(0.4814668776203872),   FRAC_CONST(0.48433251711014125),
    FRAC_CONST(0.4871929697877464),    FRAC_CONST(0.49004820502005247),  FRAC_CONST(0.49289819222978404),   FRAC_CONST(0.49574290089586776),  FRAC_CONST(0.49858230055375902),
    FRAC_CONST(0.50141636079576901),   FRAC_CONST(0.50424505127138919),  FRAC_CONST(0.50706834168761705),   FRAC_CONST(0.50988620180928057),  FRAC_CONST(0.51269860145936175),
    FRAC_CONST(0.51550551051931948),   FRAC_CONST(0.51830689892941317),  FRAC_CONST(0.5211027366890234),    FRAC_CONST(0.52389299385697385),  FRAC_CONST(0.52667764055185196),
    FRAC_CONST(0.52945664695232897),   FRAC_CONST(0.53222998329747884),  FRAC_CONST(0.53499761988709726),   FRAC_CONST(0.53775952708201991),  FRAC_CONST(0.54051567530443978),
    FRAC_CONST(0.54326603503822357),   FRAC_CONST(0.54601057682922816),  FRAC_CONST(0.54874927128561579),   FRAC_CONST(0.55148208907816942),  FRAC_CONST(0.55420900094060566),
    FRAC_CONST(0.55692997766988939),   FRAC_CONST(0.559644990126546),    FRAC_CONST(0.56235400923497314),   FRAC_CONST(0.56505700598375252),  FRAC_CONST(0.56775395142596052),
    FRAC_CONST(0.57044481667947822),   FRAC_CONST(0.57312957292730071),  FRAC_CONST(0.57580819141784534),   FRAC_CONST(0.57848064346525996),  FRAC_CONST(0.58114690044973039),
    FRAC_CONST(0.58380693381778626),   FRAC_CONST(0.58646071508260733),  FRAC_CONST(0.58910821582432815),   FRAC_CONST(0.5917494076903429),   FRAC_CONST(0.5943842623956086),
    FRAC_CONST(0.59701275172294799),   FRAC_CONST(0.59963484752335228),  FRAC_CONST(0.60225052171628191),   FRAC_CONST(0.60485974628996786),  FRAC_CONST(0.60746249330171098),
    FRAC_CONST(0.61005873487818185),   FRAC_CONST(0.61264844321571899),  FRAC_CONST(0.61523159058062682),   FRAC_CONST(0.61780814930947225),  FRAC_CONST(0.62037809180938108),
    FRAC_CONST(0.62294139055833397),   FRAC_CONST(0.6254980181054608),   FRAC_CONST(0.62804794707133416),   FRAC_CONST(0.63059115014826372),  FRAC_CONST(0.63312760010058777),
    FRAC_CONST(0.63565726976496484),   FRAC_CONST(0.63818013205066515),  FRAC_CONST(0.64069615993986073),   FRAC_CONST(0.64320532648791406),  FRAC_CONST(0.64570760482366729),
    FRAC_CONST(0.64820296814972966),   FRAC_CONST(0.65069138974276486),  FRAC_CONST(0.65317284295377676),   FRAC_CONST(0.65564730120839498),  FRAC_CONST(0.65811473800715958),
    FRAC_CONST(0.660575126925805),     FRAC_CONST(0.66302844161554231),  FRAC_CONST(0.6654746558033422),    FRAC_CONST(0.66791374329221598),  FRAC_CONST(0.67034567796149647),
    FRAC_CONST(0.67277043376711676),   FRAC_CONST(0.67518798474189046),  FRAC_CONST(0.67759830499578866),   FRAC_CONST(0.68000136871621808),  FRAC_CONST(0.68239715016829683),
    FRAC_CONST(0.6847856236951303),    FRAC_CONST(0.68716676371808583),  FRAC_CONST(0.68954054473706683),   FRAC_CONST(0.69190694133078579),  FRAC_CONST(0.69426592815703603),
    FRAC_CONST(0.69661747995296419),   FRAC_CONST(0.69896157153533944),  FRAC_CONST(0.70129817780082437),   FRAC_CONST(0.7036272737262429),   FRAC_CONST(0.70594883436884903),
    FRAC_CONST(0.70826283486659336),   FRAC_CONST(0.71056925043838959),  FRAC_CONST(0.71286805638437978),   FRAC_CONST(0.71515922808619936),  FRAC_CONST(0.71744274100723993),
    FRAC_CONST(0.71971857069291278),   FRAC_CONST(0.7219866927709101),   FRAC_CONST(0.72424708295146689),   FRAC_CONST(0.72649971702762028),  FRAC_CONST(0.72874457087546896),
    FRAC_CONST(0.73098162045443171),   FRAC_CONST(0.73321084180750484),  FRAC_CONST(0.73543221106151868),   FRAC_CONST(0.73764570442739286),  FRAC_CONST(0.73985129820039208),
    FRAC_CONST(0.74204896876037885),   FRAC_CONST(0.7442386925720671),   FRAC_CONST(0.74642044618527381),   FRAC_CONST(0.74859420623517081),  FRAC_CONST(0.75075994944253421),
    FRAC_CONST(0.75291765261399446),   FRAC_CONST(0.75506729264228367),  FRAC_CONST(0.75720884650648446),   FRAC_CONST(0.75934229127227548),  FRAC_CONST(0.76146760409217706),
    FRAC_CONST(0.76358476220579641),   FRAC_CONST(0.7656937429400712),   FRAC_CONST(0.76779452370951196),   FRAC_CONST(0.76988708201644451),  FRAC_CONST(0.77197139545125026),
    FRAC_CONST(0.7740474416926072),    FRAC_CONST(0.77611519850772781),  FRAC_CONST(0.77817464375259782),   FRAC_CONST(0.78022575537221317),  FRAC_CONST(0.78226851140081632),
    FRAC_CONST(0.78430288996213138),   FRAC_CONST(0.78632886926959822),  FRAC_CONST(0.78834642762660623),   FRAC_CONST(0.79035554342672631),  FRAC_CONST(0.79235619515394229),
    FRAC_CONST(0.79434836138288134),   FRAC_CONST(0.79633202077904397),  FRAC_CONST(0.79830715209903147),   FRAC_CONST(0.8002737341907743),   FRAC_CONST(0.80223174599375802),
    FRAC_CONST(0.80418116653924954),   FRAC_CONST(0.80612197495052085),  FRAC_CONST(0.80805415044307316),   FRAC_CONST(0.80997767232485907),  FRAC_CONST(0.81189251999650469),
    FRAC_CONST(0.81379867295152986),   FRAC_CONST(0.81569611077656778),  FRAC_CONST(0.81758481315158371),   FRAC_CONST(0.81946475985009259),  FRAC_CONST(0.82133593073937561),
    FRAC_CONST(0.82319830578069586),   FRAC_CONST(0.82505186502951278),  FRAC_CONST(0.82689658863569615),   FRAC_CONST(0.82873245684373809),  FRAC_CONST(0.83055944999296494),
    FRAC_CONST(0.83237754851774781),   FRAC_CONST(0.83418673294771239),  FRAC_CONST(0.83598698390794668),   FRAC_CONST(0.83777828211920935),  FRAC_CONST(0.83956060839813562),
    FRAC_CONST(0.84133394365744296),   FRAC_CONST(0.84309826890613537),  FRAC_CONST(0.84485356524970701),   FRAC_CONST(0.84659981389034411),  FRAC_CONST(0.84833699612712676),
    FRAC_CONST(0.85006509335622882),   FRAC_CONST(0.8517840870711173),   FRAC_CONST(0.85349395886275037),   FRAC_CONST(0.85519469041977514),  FRAC_CONST(0.85688626352872277),
    FRAC_CONST(0.85856866007420429),   FRAC_CONST(0.86024186203910447),  FRAC_CONST(0.86190585150477417),   FRAC_CONST(0.86356061065122347),  FRAC_CONST(0.86520612175731115),
    FRAC_CONST(0.86684236720093533),   FRAC_CONST(0.86846932945922151),  FRAC_CONST(0.87008699110871135),   FRAC_CONST(0.87169533482554817),  FRAC_CONST(0.87329434338566281),
    FRAC_CONST(0.87488399966495822),   FRAC_CONST(0.87646428663949283),  FRAC_CONST(0.87803518738566277),   FRAC_CONST(0.87959668508038291),  FRAC_CONST(0.88114876300126743),
    FRAC_CONST(0.88269140452680916),   FRAC_CONST(0.8842245931365561),   FRAC_CONST(0.88574831241129048),   FRAC_CONST(0.88726254603320276),  FRAC_CONST(0.88876727778606746),
    FRAC_CONST(0.89026249155541637),   FRAC_CONST(0.8917481713287112),   FRAC_CONST(0.89322430119551532),   FRAC_CONST(0.89469086534766362),  FRAC_CONST(0.89614784807943237),
    FRAC_CONST(0.89759523378770689),   FRAC_CONST(0.89903300697214927),  FRAC_CONST(0.9004611522353636),    FRAC_CONST(0.90187965428306172),  FRAC_CONST(0.90328849792422594),
    FRAC_CONST(0.90468766807127299),   FRAC_CONST(0.90607714974021469),  FRAC_CONST(0.90745692805081868),   FRAC_CONST(0.90882698822676755),  FRAC_CONST(0.91018731559581767),
    FRAC_CONST(0.91153789558995579),   FRAC_CONST(0.91287871374555518),  FRAC_CONST(0.91420975570353069),   FRAC_CONST(0.9155310072094921),   FRAC_CONST(0.91684245411389753),
    FRAC_CONST(0.91814408237220391),   FRAC_CONST(0.91943587804501858),  FRAC_CONST(0.92071782729824769),   FRAC_CONST(0.92198991640324446),  FRAC_CONST(0.92325213173695675),
    FRAC_CONST(0.92450445978207241),   FRAC_CONST(0.92574688712716402),  FRAC_CONST(0.92697940046683291),   FRAC_CONST(0.92820198660185149),  FRAC_CONST(0.92941463243930444),
    FRAC_CONST(0.93061732499272909),   FRAC_CONST(0.93181005138225426),  FRAC_CONST(0.93299279883473885),   FRAC_CONST(0.93416555468390772),  FRAC_CONST(0.93532830637048769),
    FRAC_CONST(0.93648104144234268),   FRAC_CONST(0.93762374755460598),  FRAC_CONST(0.93875641246981323),   FRAC_CONST(0.93987902405803303),  FRAC_CONST(0.94099157029699743),
    FRAC_CONST(0.94209403927222979),   FRAC_CONST(0.94318641917717327),  FRAC_CONST(0.9442686983133165),    FRAC_CONST(0.94534086509031956),  FRAC_CONST(0.9464029080261378),
    FRAC_CONST(0.94745481574714419),   FRAC_CONST(0.94849657698825252),  FRAC_CONST(0.94952818059303667),   FRAC_CONST(0.95054961551385087),  FRAC_CONST(0.95156087081194762),
    FRAC_CONST(0.95256193565759528),   FRAC_CONST(0.95355279933019343),  FRAC_CONST(0.9545334512183884),    FRAC_CONST(0.95550388082018611),  FRAC_CONST(0.95646407774306541),
    FRAC_CONST(0.95741403170408834),   FRAC_CONST(0.95835373253001133),  FRAC_CONST(0.95928317015739362),   FRAC_CONST(0.96020233463270466),  FRAC_CONST(0.96111121611243155),
    FRAC_CONST(0.96200980486318388),   FRAC_CONST(0.96289809126179782),  FRAC_CONST(0.96377606579543984),   FRAC_CONST(0.96464371906170809),  FRAC_CONST(0.96550104176873297),
    FRAC_CONST(0.96634802473527726),   FRAC_CONST(0.96718465889083372),  FRAC_CONST(0.96801093527572268),   FRAC_CONST(0.96882684504118799),  FRAC_CONST(0.96963237944949143),
    FRAC_CONST(0.97042752987400682),   FRAC_CONST(0.97121228779931179),  FRAC_CONST(0.97198664482127939),   FRAC_CONST(0.97275059264716823),  FRAC_CONST(0.97350412309571066),
    FRAC_CONST(0.97424722809720088),   FRAC_CONST(0.97497989969358168),  FRAC_CONST(0.97570213003852857),   FRAC_CONST(0.97641391139753486),  FRAC_CONST(0.97711523614799412),
    FRAC_CONST(0.97780609677928154),   FRAC_CONST(0.97848648589283505),  FRAC_CONST(0.97915639620223371),   FRAC_CONST(0.9798158205332762),   FRAC_CONST(0.98046475182405801),
    FRAC_CONST(0.98110318312504607),   FRAC_CONST(0.98173110759915416),  FRAC_CONST(0.98234851852181571),   FRAC_CONST(0.98295540928105563),  FRAC_CONST(0.9835517733775615),
    FRAC_CONST(0.98413760442475307),   FRAC_CONST(0.98471289614885038),  FRAC_CONST(0.98527764238894122),   FRAC_CONST(0.98583183709704714),  FRAC_CONST(0.98637547433818806),
    FRAC_CONST(0.98690854829044583),   FRAC_CONST(0.98743105324502667),  FRAC_CONST(0.98794298360632238),   FRAC_CONST(0.98844433389196995),  FRAC_CONST(0.98893509873291074),
    FRAC_CONST(0.98941527287344755),   FRAC_CONST(0.98988485117130098),  FRAC_CONST(0.99034382859766479),   FRAC_CONST(0.99079220023725967),  FRAC_CONST(0.99122996128838525),
    FRAC_CONST(0.9916571070629725),    FRAC_CONST(0.99207363298663342),  FRAC_CONST(0.99247953459870997),   FRAC_CONST(0.99287480755232194),  FRAC_CONST(0.99325944761441354),
    FRAC_CONST(0.99363345066579889),   FRAC_CONST(0.99399681270120555),  FRAC_CONST(0.99434952982931812),   FRAC_CONST(0.9946915982728195),   FRAC_CONST(0.99502301436843166),
    FRAC_CONST(0.99534377456695422),   FRAC_CONST(0.9956538754333033),   FRAC_CONST(0.99595331364654771),   FRAC_CONST(0.99624208599994479),  FRAC_CONST(0.99652018940097464),
    FRAC_CONST(0.99678762087137318),   FRAC_CONST(0.99704437754716424),  FRAC_CONST(0.99729045667869021),   FRAC_CONST(0.99752585563064111),  FRAC_CONST(0.99775057188208349),
    FRAC_CONST(0.9979646030264866),    FRAC_CONST(0.99816794677174903),  FRAC_CONST(0.9983606009402225),    FRAC_CONST(0.99854256346873571),  FRAC_CONST(0.99871383240861611),
    FRAC_CONST(0.99887440592571108),   FRAC_CONST(0.99902428230040718),  FRAC_CONST(0.99916345992764877),   FRAC_CONST(0.99929193731695531),  FRAC_CONST(0.99940971309243731),
    FRAC_CONST(0.99951678599281069),   FRAC_CONST(0.99961315487141078),  FRAC_CONST(0.99969881869620425),   FRAC_CONST(0.99977377654980037),  FRAC_CONST(0.99983802762946083),
    FRAC_CONST(0.99989157124710804),   FRAC_CONST(0.9999344068293331),   FRAC_CONST(0.99996653391740109),   FRAC_CONST(0.99998795216725689),  FRAC_CONST(0.99999866134952808)};
    #endif

static const real_t ld_mid_512[] = {FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0.0061358846491544753),
                                    FRAC_CONST(0.01840672990580482),
                                    FRAC_CONST(0.030674803176636626),
                                    FRAC_CONST(0.04293825693494082),
                                    FRAC_CONST(0.055195244349689934),
                                    FRAC_CONST(0.067443919563664051),
                                    FRAC_CONST(0.079682437971430126),
                                    FRAC_CONST(0.091908956497132724),
                                    FRAC_CONST(0.10412163387205459),
                                    FRAC_CONST(0.11631863091190475),
                                    FRAC_CONST(0.12849811079379317),
                                    FRAC_CONST(0.14065823933284921),
                                    FRAC_CONST(0.15279718525844344),
                                    FRAC_CONST(0.16491312048996989),
                                    FRAC_CONST(0.17700422041214875),
                                    FRAC_CONST(0.18906866414980619),
                                    FRAC_CONST(0.2011046348420919),
                                    FRAC_CONST(0.21311031991609136),
                                    FRAC_CONST(0.22508391135979283),
                                    FRAC_CONST(0.2370236059943672),
                                    FRAC_CONST(0.24892760574572015),
                                    FRAC_CONST(0.26079411791527551),
                                    FRAC_CONST(0.27262135544994898),
                                    FRAC_CONST(0.28440753721127188),
                                    FRAC_CONST(0.29615088824362379),
                                    FRAC_CONST(0.30784964004153487),
                                    FRAC_CONST(0.31950203081601569),
                                    FRAC_CONST(0.33110630575987643),
                                    FRAC_CONST(0.34266071731199438),
                                    FRAC_CONST(0.35416352542049034),
                                    FRAC_CONST(0.36561299780477385),
                                    FRAC_CONST(0.37700741021641826),
                                    FRAC_CONST(0.38834504669882625),
                                    FRAC_CONST(0.39962419984564679),
                                    FRAC_CONST(0.41084317105790391),
                                    FRAC_CONST(0.42200027079979968),
                                    FRAC_CONST(0.43309381885315196),
                                    FRAC_CONST(0.4441221445704292),
                                    FRAC_CONST(0.45508358712634384),
                                    FRAC_CONST(0.46597649576796618),
                                    FRAC_CONST(0.47679923006332209),
                                    FRAC_CONST(0.487550160148436),
                                    FRAC_CONST(0.49822766697278187),
                                    FRAC_CONST(0.50883014254310699),
                                    FRAC_CONST(0.51935599016558964),
                                    FRAC_CONST(0.52980362468629461),
                                    FRAC_CONST(0.54017147272989285),
                                    FRAC_CONST(0.55045797293660481),
                                    FRAC_CONST(0.56066157619733603),
                                    FRAC_CONST(0.57078074588696726),
                                    FRAC_CONST(0.58081395809576453),
                                    FRAC_CONST(0.59075970185887416),
                                    FRAC_CONST(0.60061647938386897),
                                    FRAC_CONST(0.61038280627630948),
                                    FRAC_CONST(0.6200572117632891),
                                    FRAC_CONST(0.62963823891492698),
                                    FRAC_CONST(0.63912444486377573),
                                    FRAC_CONST(0.64851440102211244),
                                    FRAC_CONST(0.65780669329707864),
                                    FRAC_CONST(0.66699992230363747),
                                    FRAC_CONST(0.67609270357531592),
                                    FRAC_CONST(0.68508366777270036),
                                    FRAC_CONST(0.693971460889654),
                                    FRAC_CONST(0.7027547444572253),
                                    FRAC_CONST(0.71143219574521643),
                                    FRAC_CONST(0.72000250796138165),
                                    FRAC_CONST(0.7284643904482252),
                                    FRAC_CONST(0.73681656887736979),
                                    FRAC_CONST(0.74505778544146595),
                                    FRAC_CONST(0.75318679904361241),
                                    FRAC_CONST(0.76120238548426178),
                                    FRAC_CONST(0.76910333764557959),
                                    FRAC_CONST(0.77688846567323244),
                                    FRAC_CONST(0.78455659715557524),
                                    FRAC_CONST(0.79210657730021239),
                                    FRAC_CONST(0.79953726910790501),
                                    FRAC_CONST(0.80684755354379922),
                                    FRAC_CONST(0.8140363297059483),
                                    FRAC_CONST(0.82110251499110465),
                                    FRAC_CONST(0.8280450452577558),
                                    FRAC_CONST(0.83486287498638001),
                                    FRAC_CONST(0.84155497743689833),
                                    FRAC_CONST(0.84812034480329712),
                                    FRAC_CONST(0.85455798836540053),
                                    FRAC_CONST(0.86086693863776731),
                                    FRAC_CONST(0.86704624551569265),
                                    FRAC_CONST(0.87309497841829009),
                                    FRAC_CONST(0.87901222642863341),
                                    FRAC_CONST(0.88479709843093779),
                                    FRAC_CONST(0.89044872324475788),
                                    FRAC_CONST(0.89596624975618511),
                                    FRAC_CONST(0.90134884704602203),
                                    FRAC_CONST(0.90659570451491533),
                                    FRAC_CONST(0.91170603200542988),
                                    FRAC_CONST(0.9166790599210427),
                                    FRAC_CONST(0.9215140393420419),
                                    FRAC_CONST(0.92621024213831127),
                                    FRAC_CONST(0.93076696107898371),
                                    FRAC_CONST(0.9351835099389475),
                                    FRAC_CONST(0.93945922360218992),
                                    FRAC_CONST(0.94359345816196039),
                                    FRAC_CONST(0.94758559101774109),
                                    FRAC_CONST(0.95143502096900834),
                                    FRAC_CONST(0.95514116830577067),
                                    FRAC_CONST(0.9587034748958716),
                                    FRAC_CONST(0.96212140426904158),
                                    FRAC_CONST(0.9653944416976894),
                                    FRAC_CONST(0.96852209427441727),
                                    FRAC_CONST(0.97150389098625178),
                                    FRAC_CONST(0.97433938278557586),
                                    FRAC_CONST(0.97702814265775439),
                                    FRAC_CONST(0.97956976568544052),
                                    FRAC_CONST(0.98196386910955524),
                                    FRAC_CONST(0.98421009238692903),
                                    FRAC_CONST(0.98630809724459867),
                                    FRAC_CONST(0.98825756773074946),
                                    FRAC_CONST(0.99005821026229712),
                                    FRAC_CONST(0.99170975366909953),
                                    FRAC_CONST(0.9932119492347945),
                                    FRAC_CONST(0.99456457073425542),
                                    FRAC_CONST(0.99576741446765982),
                                    FRAC_CONST(0.99682029929116567),
                                    FRAC_CONST(0.99772306664419164),
                                    FRAC_CONST(0.99847558057329477),
                                    FRAC_CONST(0.99907772775264536),
                                    FRAC_CONST(0.99952941750109314),
                                    FRAC_CONST(0.9998305817958234),
                                    FRAC_CONST(0.99998117528260111),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1)};

    #ifdef ALLOW_SMALL_FRAMELENGTH
static const real_t ld_mid_480[] = {FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0),
                                    FRAC_CONST(0.0065449379673518581),
                                    FRAC_CONST(0.019633692460628301),
                                    FRAC_CONST(0.032719082821776137),
                                    FRAC_CONST(0.045798866936520771),
                                    FRAC_CONST(0.058870803651189033),
                                    FRAC_CONST(0.071932653156719387),
                                    FRAC_CONST(0.084982177372441667),
                                    FRAC_CONST(0.09801714032956059),
                                    FRAC_CONST(0.11103530855427769),
                                    FRAC_CONST(0.12403445145048532),
                                    FRAC_CONST(0.13701234168196802),
                                    FRAC_CONST(0.14996675555404498),
                                    FRAC_CONST(0.16289547339458874),
                                    FRAC_CONST(0.17579627993435451),
                                    FRAC_CONST(0.18866696468655525),
                                    FRAC_CONST(0.2015053223256171),
                                    FRAC_CONST(0.21430915306505074),
                                    FRAC_CONST(0.2270762630343732),
                                    FRAC_CONST(0.23980446465501654),
                                    FRAC_CONST(0.25249157701515795),
                                    FRAC_CONST(0.26513542624340797),
                                    FRAC_CONST(0.27773384588129219),
                                    FRAC_CONST(0.29028467725446233),
                                    FRAC_CONST(0.3027857698425746),
                                    FRAC_CONST(0.31523498164776964),
                                    FRAC_CONST(0.32763017956169349),
                                    FRAC_CONST(0.33996923973099424),
                                    FRAC_CONST(0.35225004792123354),
                                    FRAC_CONST(0.36447049987914965),
                                    FRAC_CONST(0.37662850169321077),
                                    FRAC_CONST(0.38872197015239557),
                                    FRAC_CONST(0.40074883310314097),
                                    FRAC_CONST(0.41270702980439467),
                                    FRAC_CONST(0.42459451128071307),
                                    FRAC_CONST(0.43640924067334208),
                                    FRAC_CONST(0.44814919358922256),
                                    FRAC_CONST(0.45981235844785984),
                                    FRAC_CONST(0.47139673682599764),
                                    FRAC_CONST(0.48290034380003727),
                                    FRAC_CONST(0.49432120828614462),
                                    FRAC_CONST(0.50565737337798455),
                                    FRAC_CONST(0.51690689668202761),
                                    FRAC_CONST(0.52806785065036799),
                                    FRAC_CONST(0.53913832291100017),
                                    FRAC_CONST(0.55011641659549337),
                                    FRAC_CONST(0.56100025066400983),
                                    FRAC_CONST(0.57178796022761225),
                                    FRAC_CONST(0.58247769686780215),
                                    FRAC_CONST(0.59306762895323706),
                                    FRAC_CONST(0.60355594195357143),
                                    FRAC_CONST(0.61394083875036642),
                                    FRAC_CONST(0.62422053994501758),
                                    FRAC_CONST(0.63439328416364549),
                                    FRAC_CONST(0.64445732835889735),
                                    FRAC_CONST(0.65441094810861034),
                                    FRAC_CONST(0.66425243791128175),
                                    FRAC_CONST(0.67398011147829784),
                                    FRAC_CONST(0.68359230202287125),
                                    FRAC_CONST(0.69308736254563585),
                                    FRAC_CONST(0.70246366611685174),
                                    FRAC_CONST(0.71171960615517138),
                                    FRAC_CONST(0.72085359670291882),
                                    FRAC_CONST(0.7298640726978356),
                                    FRAC_CONST(0.73874949024124625),
                                    FRAC_CONST(0.74750832686259672),
                                    FRAC_CONST(0.75613908178032285),
                                    FRAC_CONST(0.76464027615900032),
                                    FRAC_CONST(0.77301045336273699),
                                    FRAC_CONST(0.78124817920475853),
                                    FRAC_CONST(0.78935204219315003),
                                    FRAC_CONST(0.79732065377270711),
                                    FRAC_CONST(0.80515264856285829),
                                    FRAC_CONST(0.81284668459161513),
                                    FRAC_CONST(0.82040144352551359),
                                    FRAC_CONST(0.82781563089550203),
                                    FRAC_CONST(0.83508797631874299),
                                    FRAC_CONST(0.84221723371628654),
                                    FRAC_CONST(0.84920218152657889),
                                    FRAC_CONST(0.85604162291477137),
                                    FRAC_CONST(0.86273438597779184),
                                    FRAC_CONST(0.86927932394514362),
                                    FRAC_CONST(0.87567531537539967),
                                    FRAC_CONST(0.88192126434835494),
                                    FRAC_CONST(0.88801610065280734),
                                    FRAC_CONST(0.89395877996993212),
                                    FRAC_CONST(0.8997482840522214),
                                    FRAC_CONST(0.90538362089795521),
                                    FRAC_CONST(0.91086382492117568),
                                    FRAC_CONST(0.91618795711713596),
                                    FRAC_CONST(0.92135510522319242),
                                    FRAC_CONST(0.9263643838751181),
                                    FRAC_CONST(0.93121493475880346),
                                    FRAC_CONST(0.93590592675732565),
                                    FRAC_CONST(0.94043655609335486),
                                    FRAC_CONST(0.94480604646687805),
                                    FRAC_CONST(0.94901364918821385),
                                    FRAC_CONST(0.95305864330629697),
                                    FRAC_CONST(0.95694033573220882),
                                    FRAC_CONST(0.9606580613579353),
                                    FRAC_CONST(0.96421118317032928),
                                    FRAC_CONST(0.96759909236025976),
                                    FRAC_CONST(0.9708212084269281),
                                    FRAC_CONST(0.97387697927733363),
                                    FRAC_CONST(0.97676588132087239),
                                    FRAC_CONST(0.97948741955905139),
                                    FRAC_CONST(0.98204112767030394),
                                    FRAC_CONST(0.98442656808989171),
                                    FRAC_CONST(0.98664333208487898),
                                    FRAC_CONST(0.98869103982416728),
                                    FRAC_CONST(0.99056934044357725),
                                    FRAC_CONST(0.99227791210596705),
                                    FRAC_CONST(0.99381646205637808),
                                    FRAC_CONST(0.99518472667219682),
                                    FRAC_CONST(0.99638247150832537),
                                    FRAC_CONST(0.99740949133735191),
                                    FRAC_CONST(0.99826561018471593),
                                    FRAC_CONST(0.99895068135886012),
                                    FRAC_CONST(0.99946458747636568),
                                    FRAC_CONST(0.99980724048206482),
                                    FRAC_CONST(0.99997858166412923),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1),
                                    FRAC_CONST(1)};
    #endif
#endif
// ——————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
#ifdef FIXED_POINT
static real_t pow05_table[] = {
    COEF_CONST(1.68179283050743), /* 0.5^(-3/4) */
    COEF_CONST(1.41421356237310), /* 0.5^(-2/4) */
    COEF_CONST(1.18920711500272), /* 0.5^(-1/4) */
    COEF_CONST(1.0),              /* 0.5^( 0/4) */
    COEF_CONST(0.84089641525371), /* 0.5^(+1/4) */
    COEF_CONST(0.70710678118655), /* 0.5^(+2/4) */
    COEF_CONST(0.59460355750136)  /* 0.5^(+3/4) */
};
#endif
// ——————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
#ifdef MAIN_DEC
static const real_t mnt_table[128] = {
    COEF_CONST(0.9531250000), COEF_CONST(0.9453125000), COEF_CONST(0.9375000000), COEF_CONST(0.9296875000), COEF_CONST(0.9257812500), COEF_CONST(0.9179687500), COEF_CONST(0.9101562500),
    COEF_CONST(0.9023437500), COEF_CONST(0.8984375000), COEF_CONST(0.8906250000), COEF_CONST(0.8828125000), COEF_CONST(0.8789062500), COEF_CONST(0.8710937500), COEF_CONST(0.8671875000),
    COEF_CONST(0.8593750000), COEF_CONST(0.8515625000), COEF_CONST(0.8476562500), COEF_CONST(0.8398437500), COEF_CONST(0.8359375000), COEF_CONST(0.8281250000), COEF_CONST(0.8242187500),
    COEF_CONST(0.8203125000), COEF_CONST(0.8125000000), COEF_CONST(0.8085937500), COEF_CONST(0.8007812500), COEF_CONST(0.7968750000), COEF_CONST(0.7929687500), COEF_CONST(0.7851562500),
    COEF_CONST(0.7812500000), COEF_CONST(0.7773437500), COEF_CONST(0.7734375000), COEF_CONST(0.7656250000), COEF_CONST(0.7617187500), COEF_CONST(0.7578125000), COEF_CONST(0.7539062500),
    COEF_CONST(0.7500000000), COEF_CONST(0.7421875000), COEF_CONST(0.7382812500), COEF_CONST(0.7343750000), COEF_CONST(0.7304687500), COEF_CONST(0.7265625000), COEF_CONST(0.7226562500),
    COEF_CONST(0.7187500000), COEF_CONST(0.7148437500), COEF_CONST(0.7109375000), COEF_CONST(0.7070312500), COEF_CONST(0.6992187500), COEF_CONST(0.6953125000), COEF_CONST(0.6914062500),
    COEF_CONST(0.6875000000), COEF_CONST(0.6835937500), COEF_CONST(0.6796875000), COEF_CONST(0.6796875000), COEF_CONST(0.6757812500), COEF_CONST(0.6718750000), COEF_CONST(0.6679687500),
    COEF_CONST(0.6640625000), COEF_CONST(0.6601562500), COEF_CONST(0.6562500000), COEF_CONST(0.6523437500), COEF_CONST(0.6484375000), COEF_CONST(0.6445312500), COEF_CONST(0.6406250000),
    COEF_CONST(0.6406250000), COEF_CONST(0.6367187500), COEF_CONST(0.6328125000), COEF_CONST(0.6289062500), COEF_CONST(0.6250000000), COEF_CONST(0.6210937500), COEF_CONST(0.6210937500),
    COEF_CONST(0.6171875000), COEF_CONST(0.6132812500), COEF_CONST(0.6093750000), COEF_CONST(0.6054687500), COEF_CONST(0.6054687500), COEF_CONST(0.6015625000), COEF_CONST(0.5976562500),
    COEF_CONST(0.5937500000), COEF_CONST(0.5937500000), COEF_CONST(0.5898437500), COEF_CONST(0.5859375000), COEF_CONST(0.5820312500), COEF_CONST(0.5820312500), COEF_CONST(0.5781250000),
    COEF_CONST(0.5742187500), COEF_CONST(0.5742187500), COEF_CONST(0.5703125000), COEF_CONST(0.5664062500), COEF_CONST(0.5664062500), COEF_CONST(0.5625000000), COEF_CONST(0.5585937500),
    COEF_CONST(0.5585937500), COEF_CONST(0.5546875000), COEF_CONST(0.5507812500), COEF_CONST(0.5507812500), COEF_CONST(0.5468750000), COEF_CONST(0.5429687500), COEF_CONST(0.5429687500),
    COEF_CONST(0.5390625000), COEF_CONST(0.5390625000), COEF_CONST(0.5351562500), COEF_CONST(0.5312500000), COEF_CONST(0.5312500000), COEF_CONST(0.5273437500), COEF_CONST(0.5273437500),
    COEF_CONST(0.5234375000), COEF_CONST(0.5195312500), COEF_CONST(0.5195312500), COEF_CONST(0.5156250000), COEF_CONST(0.5156250000), COEF_CONST(0.5117187500), COEF_CONST(0.5117187500),
    COEF_CONST(0.5078125000), COEF_CONST(0.5078125000), COEF_CONST(0.5039062500), COEF_CONST(0.5039062500), COEF_CONST(0.5000000000), COEF_CONST(0.4980468750), COEF_CONST(0.4960937500),
    COEF_CONST(0.4941406250), COEF_CONST(0.4921875000), COEF_CONST(0.4902343750), COEF_CONST(0.4882812500), COEF_CONST(0.4863281250), COEF_CONST(0.4843750000), COEF_CONST(0.4824218750),
    COEF_CONST(0.4804687500), COEF_CONST(0.4785156250)};
static const real_t exp_table[128] = {COEF_CONST(0.50000000000000000000000000000000000000000000000000),
                                      COEF_CONST(0.25000000000000000000000000000000000000000000000000),
                                      COEF_CONST(0.12500000000000000000000000000000000000000000000000),
                                      COEF_CONST(0.06250000000000000000000000000000000000000000000000),
                                      COEF_CONST(0.03125000000000000000000000000000000000000000000000),
                                      COEF_CONST(0.01562500000000000000000000000000000000000000000000),
                                      COEF_CONST(0.00781250000000000000000000000000000000000000000000),
                                      COEF_CONST(0.00390625000000000000000000000000000000000000000000),
                                      COEF_CONST(0.00195312500000000000000000000000000000000000000000),
                                      COEF_CONST(0.00097656250000000000000000000000000000000000000000),
                                      COEF_CONST(0.00048828125000000000000000000000000000000000000000),
                                      COEF_CONST(0.00024414062500000000000000000000000000000000000000),
                                      COEF_CONST(0.00012207031250000000000000000000000000000000000000),
                                      COEF_CONST(0.00006103515625000000000000000000000000000000000000),
                                      COEF_CONST(0.00003051757812500000000000000000000000000000000000),
                                      COEF_CONST(0.00001525878906250000000000000000000000000000000000),
                                      COEF_CONST(0.00000762939453125000000000000000000000000000000000),
                                      COEF_CONST(0.00000381469726562500000000000000000000000000000000),
                                      COEF_CONST(0.00000190734863281250000000000000000000000000000000),
                                      COEF_CONST(0.00000095367431640625000000000000000000000000000000),
                                      COEF_CONST(0.00000047683715820312500000000000000000000000000000),
                                      COEF_CONST(0.00000023841857910156250000000000000000000000000000),
                                      COEF_CONST(0.00000011920928955078125000000000000000000000000000),
                                      COEF_CONST(0.00000005960464477539062500000000000000000000000000),
                                      COEF_CONST(0.00000002980232238769531300000000000000000000000000),
                                      COEF_CONST(0.00000001490116119384765600000000000000000000000000),
                                      COEF_CONST(0.00000000745058059692382810000000000000000000000000),
                                      COEF_CONST(0.00000000372529029846191410000000000000000000000000),
                                      COEF_CONST(0.00000000186264514923095700000000000000000000000000),
                                      COEF_CONST(0.00000000093132257461547852000000000000000000000000),
                                      COEF_CONST(0.00000000046566128730773926000000000000000000000000),
                                      COEF_CONST(0.00000000023283064365386963000000000000000000000000),
                                      COEF_CONST(0.00000000011641532182693481000000000000000000000000),
                                      COEF_CONST(0.00000000005820766091346740700000000000000000000000),
                                      COEF_CONST(0.00000000002910383045673370400000000000000000000000),
                                      COEF_CONST(0.00000000001455191522836685200000000000000000000000),
                                      COEF_CONST(0.00000000000727595761418342590000000000000000000000),
                                      COEF_CONST(0.00000000000363797880709171300000000000000000000000),
                                      COEF_CONST(0.00000000000181898940354585650000000000000000000000),
                                      COEF_CONST(0.00000000000090949470177292824000000000000000000000),
                                      COEF_CONST(0.00000000000045474735088646412000000000000000000000),
                                      COEF_CONST(0.00000000000022737367544323206000000000000000000000),
                                      COEF_CONST(0.00000000000011368683772161603000000000000000000000),
                                      COEF_CONST(0.00000000000005684341886080801500000000000000000000),
                                      COEF_CONST(0.00000000000002842170943040400700000000000000000000),
                                      COEF_CONST(0.00000000000001421085471520200400000000000000000000),
                                      COEF_CONST(0.00000000000000710542735760100190000000000000000000),
                                      COEF_CONST(0.00000000000000355271367880050090000000000000000000),
                                      COEF_CONST(0.00000000000000177635683940025050000000000000000000),
                                      COEF_CONST(0.00000000000000088817841970012523000000000000000000),
                                      COEF_CONST(0.00000000000000044408920985006262000000000000000000),
                                      COEF_CONST(0.00000000000000022204460492503131000000000000000000),
                                      COEF_CONST(0.00000000000000011102230246251565000000000000000000),
                                      COEF_CONST(0.00000000000000005551115123125782700000000000000000),
                                      COEF_CONST(0.00000000000000002775557561562891400000000000000000),
                                      COEF_CONST(0.00000000000000001387778780781445700000000000000000),
                                      COEF_CONST(0.00000000000000000693889390390722840000000000000000),
                                      COEF_CONST(0.00000000000000000346944695195361420000000000000000),
                                      COEF_CONST(0.00000000000000000173472347597680710000000000000000),
                                      COEF_CONST(0.00000000000000000086736173798840355000000000000000),
                                      COEF_CONST(0.00000000000000000043368086899420177000000000000000),
                                      COEF_CONST(0.00000000000000000021684043449710089000000000000000),
                                      COEF_CONST(0.00000000000000000010842021724855044000000000000000),
                                      COEF_CONST(0.00000000000000000005421010862427522200000000000000),
                                      COEF_CONST(0.00000000000000000002710505431213761100000000000000),
                                      COEF_CONST(0.00000000000000000001355252715606880500000000000000),
                                      COEF_CONST(0.00000000000000000000677626357803440270000000000000),
                                      COEF_CONST(0.00000000000000000000338813178901720140000000000000),
                                      COEF_CONST(0.00000000000000000000169406589450860070000000000000),
                                      COEF_CONST(0.00000000000000000000084703294725430034000000000000),
                                      COEF_CONST(0.00000000000000000000042351647362715017000000000000),
                                      COEF_CONST(0.00000000000000000000021175823681357508000000000000),
                                      COEF_CONST(0.00000000000000000000010587911840678754000000000000),
                                      COEF_CONST(0.00000000000000000000005293955920339377100000000000),
                                      COEF_CONST(0.00000000000000000000002646977960169688600000000000),
                                      COEF_CONST(0.00000000000000000000001323488980084844300000000000),
                                      COEF_CONST(0.00000000000000000000000661744490042422140000000000),
                                      COEF_CONST(0.00000000000000000000000330872245021211070000000000),
                                      COEF_CONST(0.00000000000000000000000165436122510605530000000000),
                                      COEF_CONST(0.00000000000000000000000082718061255302767000000000),
                                      COEF_CONST(0.00000000000000000000000041359030627651384000000000),
                                      COEF_CONST(0.00000000000000000000000020679515313825692000000000),
                                      COEF_CONST(0.00000000000000000000000010339757656912846000000000),
                                      COEF_CONST(0.00000000000000000000000005169878828456423000000000),
                                      COEF_CONST(0.00000000000000000000000002584939414228211500000000),
                                      COEF_CONST(0.00000000000000000000000001292469707114105700000000),
                                      COEF_CONST(0.00000000000000000000000000646234853557052870000000),
                                      COEF_CONST(0.00000000000000000000000000323117426778526440000000),
                                      COEF_CONST(0.00000000000000000000000000161558713389263220000000),
                                      COEF_CONST(0.00000000000000000000000000080779356694631609000000),
                                      COEF_CONST(0.00000000000000000000000000040389678347315804000000),
                                      COEF_CONST(0.00000000000000000000000000020194839173657902000000),
                                      COEF_CONST(0.00000000000000000000000000010097419586828951000000),
                                      COEF_CONST(0.00000000000000000000000000005048709793414475600000),
                                      COEF_CONST(0.00000000000000000000000000002524354896707237800000),
                                      COEF_CONST(0.00000000000000000000000000001262177448353618900000),
                                      COEF_CONST(0.00000000000000000000000000000631088724176809440000),
                                      COEF_CONST(0.00000000000000000000000000000315544362088404720000),
                                      COEF_CONST(0.00000000000000000000000000000157772181044202360000),
                                      COEF_CONST(0.00000000000000000000000000000078886090522101181000),
                                      COEF_CONST(0.00000000000000000000000000000039443045261050590000),
                                      COEF_CONST(0.00000000000000000000000000000019721522630525295000),
                                      COEF_CONST(0.00000000000000000000000000000009860761315262647600),
                                      COEF_CONST(0.00000000000000000000000000000004930380657631323800),
                                      COEF_CONST(0.00000000000000000000000000000002465190328815661900),
                                      COEF_CONST(0.00000000000000000000000000000001232595164407830900),
                                      COEF_CONST(0.00000000000000000000000000000000616297582203915470),
                                      COEF_CONST(0.00000000000000000000000000000000308148791101957740),
                                      COEF_CONST(0.00000000000000000000000000000000154074395550978870),
                                      COEF_CONST(0.00000000000000000000000000000000077037197775489434),
                                      COEF_CONST(0.00000000000000000000000000000000038518598887744717),
                                      COEF_CONST(0.00000000000000000000000000000000019259299443872359),
                                      COEF_CONST(0.00000000000000000000000000000000009629649721936179),
                                      COEF_CONST(0.00000000000000000000000000000000004814824860968090),
                                      COEF_CONST(0.00000000000000000000000000000000002407412430484045),
                                      COEF_CONST(0.00000000000000000000000000000000001203706215242022),
                                      COEF_CONST(0.00000000000000000000000000000000000601853107621011),
                                      COEF_CONST(0.00000000000000000000000000000000000300926553810506),
                                      COEF_CONST(0.00000000000000000000000000000000000150463276905253),
                                      COEF_CONST(0.00000000000000000000000000000000000075231638452626),
                                      COEF_CONST(0.00000000000000000000000000000000000037615819226313),
                                      COEF_CONST(0.00000000000000000000000000000000000018807909613157),
                                      COEF_CONST(0.00000000000000000000000000000000000009403954806578),
                                      COEF_CONST(0.00000000000000000000000000000000000004701977403289),
                                      COEF_CONST(0.00000000000000000000000000000000000002350988701645),
                                      COEF_CONST(0.00000000000000000000000000000000000001175494350822),
                                      COEF_CONST(0.0 /* 0000000000000000000000000000000000000587747175411 "floating point underflow" */),
                                      COEF_CONST(0.0)};
#endif /* MAIN_DEC */
// ——————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
#ifndef FIXED_POINT
static const real_t pow2sf_tab[] = {2.9802322387695313E-008,
                                    5.9604644775390625E-008,
                                    1.1920928955078125E-007,
                                    2.384185791015625E-007,
                                    4.76837158203125E-007,
                                    9.5367431640625E-007,
                                    1.9073486328125E-006,
                                    3.814697265625E-006,
                                    7.62939453125E-006,
                                    1.52587890625E-005,
                                    3.0517578125E-005,
                                    6.103515625E-005,
                                    0.0001220703125,
                                    0.000244140625,
                                    0.00048828125,
                                    0.0009765625,
                                    0.001953125,
                                    0.00390625,
                                    0.0078125,
                                    0.015625,
                                    0.03125,
                                    0.0625,
                                    0.125,
                                    0.25,
                                    0.5,
                                    1.0,
                                    2.0,
                                    4.0,
                                    8.0,
                                    16.0,
                                    32.0,
                                    64.0,
                                    128.0,
                                    256.0,
                                    512.0,
                                    1024.0,
                                    2048.0,
                                    4096.0,
                                    8192.0,
                                    16384.0,
                                    32768.0,
                                    65536.0,
                                    131072.0,
                                    262144.0,
                                    524288.0,
                                    1048576.0,
                                    2097152.0,
                                    4194304.0,
                                    8388608.0,
                                    16777216.0,
                                    33554432.0,
                                    67108864.0,
                                    134217728.0,
                                    268435456.0,
                                    536870912.0,
                                    1073741824.0,
                                    2147483648.0,
                                    4294967296.0,
                                    8589934592.0,
                                    17179869184.0,
                                    34359738368.0,
                                    68719476736.0,
                                    137438953472.0,
                                    274877906944.0};
#endif
// ——————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
#ifdef LD_DEC
static const uint8_t num_swb_512_window[] = {0, 0, 0, 36, 36, 37, 31, 31, 0, 0, 0, 0};
static const uint8_t num_swb_480_window[] = {0, 0, 0, 35, 35, 37, 30, 30, 0, 0, 0, 0};
#endif
static const uint8_t  num_swb_960_window[] = {40, 40, 45, 49, 49, 49, 46, 46, 42, 42, 42, 40};
static const uint8_t  num_swb_1024_window[] = {41, 41, 47, 49, 49, 51, 47, 47, 43, 43, 43, 40};
static const uint8_t  num_swb_128_window[] = {12, 12, 12, 14, 14, 14, 15, 15, 15, 15, 15, 15};
static const uint16_t swb_offset_1024_96[] = {0,   4,   8,   12,  16,  20,  24,  28,  32,  36,  40,  44,  48,  52,  56,  64,  72,  80,  88,  96,  108,
                                              120, 132, 144, 156, 172, 188, 212, 240, 276, 320, 384, 448, 512, 576, 640, 704, 768, 832, 896, 960, 1024};
static const uint16_t swb_offset_128_96[] = {0, 4, 8, 12, 16, 20, 24, 32, 40, 48, 64, 92, 128};
static const uint16_t swb_offset_1024_64[] = {0,   4,   8,   12,  16,  20,  24,  28,  32,  36,  40,  44,  48,  52,  56,  64,  72,  80,  88,  100, 112, 124, 140, 156,
                                              172, 192, 216, 240, 268, 304, 344, 384, 424, 464, 504, 544, 584, 624, 664, 704, 744, 784, 824, 864, 904, 944, 984, 1024};
static const uint16_t swb_offset_128_64[] = {0, 4, 8, 12, 16, 20, 24, 32, 40, 48, 64, 92, 128};
static const uint16_t swb_offset_1024_48[] = {0,   4,   8,   12,  16,  20,  24,  28,  32,  36,  40,  48,  56,  64,  72,  80,  88,  96,  108, 120, 132, 144, 160, 176, 196,
                                              216, 240, 264, 292, 320, 352, 384, 416, 448, 480, 512, 544, 576, 608, 640, 672, 704, 736, 768, 800, 832, 864, 896, 928, 1024};
#ifdef LD_DEC
static const uint16_t swb_offset_512_48[] = {0,  4,   8,   12,  16,  20,  24,  28,  32,  36,  40,  44,  48,  52,  56,  60,  68,  76, 84,
                                             92, 100, 112, 124, 136, 148, 164, 184, 208, 236, 268, 300, 332, 364, 396, 428, 460, 512};
static const uint16_t swb_offset_480_48[] = {0,  4,  8,   12,  16,  20,  24,  28,  32,  36,  40,  44,  48,  52,  56,  64,  72,  80,
                                             88, 96, 108, 120, 132, 144, 156, 172, 188, 212, 240, 272, 304, 336, 368, 400, 432, 480};
#endif
static const uint16_t swb_offset_128_48[] = {0, 4, 8, 12, 16, 20, 28, 36, 44, 56, 68, 80, 96, 112, 128};
static const uint16_t swb_offset_1024_32[] = {0,   4,   8,   12,  16,  20,  24,  28,  32,  36,  40,  48,  56,  64,  72,  80,  88,  96,  108, 120, 132, 144, 160, 176, 196, 216,
                                              240, 264, 292, 320, 352, 384, 416, 448, 480, 512, 544, 576, 608, 640, 672, 704, 736, 768, 800, 832, 864, 896, 928, 960, 992, 1024};
#ifdef LD_DEC
static const uint16_t swb_offset_512_32[] = {0,  4,   8,   12,  16,  20,  24,  28,  32,  36,  40,  44,  48,  52,  56,  64,  72,  80,  88,
                                             96, 108, 120, 132, 144, 160, 176, 192, 212, 236, 260, 288, 320, 352, 384, 416, 448, 480, 512};
static const uint16_t swb_offset_480_32[] = {0,  4,  8,   12,  16,  20,  24,  28,  32,  36,  40,  44,  48,  52,  56,  60,  64,  72,  80,
                                             88, 96, 104, 112, 124, 136, 148, 164, 180, 200, 224, 256, 288, 320, 352, 384, 416, 448, 480};
#endif
static const uint16_t swb_offset_1024_24[] = {0,   4,   8,   12,  16,  20,  24,  28,  32,  36,  40,  44,  52,  60,  68,  76,  84,  92,  100, 108, 116, 124, 136, 148,
                                              160, 172, 188, 204, 220, 240, 260, 284, 308, 336, 364, 396, 432, 468, 508, 552, 600, 652, 704, 768, 832, 896, 960, 1024};
#ifdef LD_DEC
static const uint16_t swb_offset_512_24[] = {0, 4, 8, 12, 16, 20, 24, 28, 32, 36, 40, 44, 52, 60, 68, 80, 92, 104, 120, 140, 164, 192, 224, 256, 288, 320, 352, 384, 416, 448, 480, 512};
static const uint16_t swb_offset_480_24[] = {0, 4, 8, 12, 16, 20, 24, 28, 32, 36, 40, 44, 52, 60, 68, 80, 92, 104, 120, 140, 164, 192, 224, 256, 288, 320, 352, 384, 416, 448, 480};
#endif
static const uint16_t  swb_offset_128_24[] = {0, 4, 8, 12, 16, 20, 24, 28, 36, 44, 52, 64, 76, 92, 108, 128};
static const uint16_t  swb_offset_1024_16[] = {0,   8,   16,  24,  32,  40,  48,  56,  64,  72,  80,  88,  100, 112, 124, 136, 148, 160, 172, 184, 196, 212,
                                               228, 244, 260, 280, 300, 320, 344, 368, 396, 424, 456, 492, 532, 572, 616, 664, 716, 772, 832, 896, 960, 1024};
static const uint16_t  swb_offset_128_16[] = {0, 4, 8, 12, 16, 20, 24, 28, 32, 40, 48, 60, 72, 88, 108, 128};
static const uint16_t  swb_offset_1024_8[] = {0,   12,  24,  36,  48,  60,  72,  84,  96,  108, 120, 132, 144, 156, 172, 188, 204, 220, 236, 252, 268,
                                              288, 308, 328, 348, 372, 396, 420, 448, 476, 508, 544, 580, 620, 664, 712, 764, 820, 880, 944, 1024};
static const uint16_t  swb_offset_128_8[] = {0, 4, 8, 12, 16, 20, 24, 28, 36, 44, 52, 60, 72, 88, 108, 128};
static const uint16_t* swb_offset_1024_window[] = {
    swb_offset_1024_96, /* 96000 */
    swb_offset_1024_96, /* 88200 */
    swb_offset_1024_64, /* 64000 */
    swb_offset_1024_48, /* 48000 */
    swb_offset_1024_48, /* 44100 */
    swb_offset_1024_32, /* 32000 */
    swb_offset_1024_24, /* 24000 */
    swb_offset_1024_24, /* 22050 */
    swb_offset_1024_16, /* 16000 */
    swb_offset_1024_16, /* 12000 */
    swb_offset_1024_16, /* 11025 */
    swb_offset_1024_8   /* 8000  */
};
// ——————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————
#ifndef FIXED_POINT
static const real_t iq_table[IQ_TABLE_SIZE] = {0,
                                               1,
                                               2.5198420997897464,
                                               4.3267487109222245,
                                               6.3496042078727974,
                                               8.5498797333834844,
                                               10.902723556992836,
                                               13.390518279406722,
                                               15.999999999999998,
                                               18.720754407467133,
                                               21.544346900318832,
                                               24.463780996262464,
                                               27.47314182127996,
                                               30.567350940369842,
                                               33.741991698453212,
                                               36.993181114957046,
                                               40.317473596635935,
                                               43.711787041189993,
                                               47.173345095760126,
                                               50.699631325716943,
                                               54.288352331898118,
                                               57.937407704003519,
                                               61.6448652744185,
                                               65.408940536585988,
                                               69.227979374755591,
                                               73.100443455321638,
                                               77.024897778591622,
                                               80.999999999999986,
                                               85.024491212518527,
                                               89.097187944889555,
                                               93.216975178615741,
                                               97.382800224133163,
                                               101.59366732596474,
                                               105.84863288986224,
                                               110.14680124343441,
                                               114.4873208566006,
                                               118.86938096020653,
                                               123.29220851090024,
                                               127.75506545836058,
                                               132.25724627755247,
                                               136.79807573413572,
                                               141.37690685569191,
                                               145.99311908523086,
                                               150.6461165966291,
                                               155.33532675434674,
                                               160.06019870205279,
                                               164.82020206673349,
                                               169.61482576651861,
                                               174.44357691188537,
                                               179.30597979112557,
                                               184.20157493201927,
                                               189.12991823257562,
                                               194.09058015449685,
                                               199.08314497371677,
                                               204.1072100829694,
                                               209.16238534187647,
                                               214.24829247050752,
                                               219.36456448277784,
                                               224.51084515641216,
                                               229.6867885365223,
                                               234.89205847013176,
                                               240.12632816923249,
                                               245.38927980018505,
                                               250.68060409747261,
                                               255.99999999999991,
                                               261.34717430828869,
                                               266.72184136106449,
                                               272.12372272986045,
                                               277.55254693037961,
                                               283.0080491494619,
                                               288.48997098659891,
                                               293.99806020902247,
                                               299.53207051947408,
                                               305.0917613358298,
                                               310.67689758182206,
                                               316.28724948815585,
                                               321.92259240337177,
                                               327.58270661385535,
                                               333.26737717243742,
                                               338.97639373507025,
                                               344.70955040510125,
                                               350.46664558470013,
                                               356.24748183302603,
                                               362.05186573075139,
                                               367.87960775058258,
                                               373.73052213344511,
                                               379.60442677002078,
                                               385.50114308734607,
                                               391.42049594019937,
                                               397.36231350702371,
                                               403.32642719014467,
                                               409.31267152006262,
                                               415.32088406360799,
                                               421.35090533576471,
                                               427.40257871497619,
                                               433.4757503617617,
                                               439.5702691404793,
                                               445.68598654408271,
                                               451.82275662172759,
                                               457.98043590909128,
                                               464.15888336127773,
                                               470.35796028818726,
                                               476.5775302922363,
                                               482.81745920832043,
                                               489.07761504591741,
                                               495.35786793323581,
                                               501.65809006331688,
                                               507.97815564200368,
                                               514.31794083769648,
                                               520.67732373281672,
                                               527.05618427690604,
                                               533.45440424129174,
                                               539.87186717525128,
                                               546.30845836361505,
                                               552.76406478574609,
                                               559.23857507584194,
                                               565.73187948450413,
                                               572.24386984152341,
                                               578.77443951983378,
                                               585.32348340058843,
                                               591.89089783931263,
                                               598.47658063309257,
                                               605.08043098876044,
                                               611.70234949203643,
                                               618.3422380775919,
                                               624.99999999999977,
                                               631.67553980553748,
                                               638.36876330481164,
                                               645.07957754617485,
                                               651.80789078990415,
                                               658.55361248311499,
                                               665.31665323538357,
                                               672.09692479505225,
                                               678.8943400261943,
                                               685.70881288621433,
                                               692.540258404062,
                                               699.38859265903977,
                                               706.25373276018058,
                                               713.13559682617972,
                                               720.03410396586037,
                                               726.94917425915435,
                                               733.88072873858209,
                                               740.82868937121543,
                                               747.79297904110535,
                                               754.77352153216191,
                                               761.77024151147043,
                                               768.78306451302956,
                                               775.81191692189896,
                                               782.85672595874246,
                                               789.91741966475445,
                                               796.99392688695798,
                                               804.08617726386274,
                                               811.19410121147098,
                                               818.31762990962227,
                                               825.45669528866563,
                                               832.61123001644864,
                                               839.78116748561604,
                                               846.96644180120552,
                                               854.16698776853514,
                                               861.38274088137143,
                                               868.61363731036977,
                                               875.85961389178203,
                                               883.12060811641959,
                                               890.39655811886757,
                                               897.68740266694181,
                                               904.99308115138172,
                                               912.31353357577188,
                                               919.64870054668756,
                                               926.99852326405619,
                                               934.36294351172899,
                                               941.74190364825859,
                                               949.13534659787422,
                                               956.54321584165211,
                                               963.96545540887348,
                                               971.40200986856541,
                                               978.85282432122176,
                                               986.31784439069588,
                                               993.7970162162635,
                                               1001.29028644485,
                                               1008.797602223418,
                                               1016.3189111915103,
                                               1023.8541614739464,
                                               1031.4033016736653,
                                               1038.9662808647138,
                                               1046.5430485853758,
                                               1054.1335548314366,
                                               1061.7377500495838,
                                               1069.3555851309357,
                                               1076.9870114046978,
                                               1084.6319806319441,
                                               1092.2904449995174,
                                               1099.9623571140482,
                                               1107.6476699960892,
                                               1115.3463370743607,
                                               1123.058312180106,
                                               1130.7835495415541,
                                               1138.5220037784854,
                                               1146.273629896901,
                                               1154.0383832837879,
                                               1161.816219701986,
                                               1169.607095285146,
                                               1177.4109665327808,
                                               1185.2277903054078,
                                               1193.0575238197798,
                                               1200.9001246442001,
                                               1208.7555506939248,
                                               1216.6237602266442,
                                               1224.5047118380478,
                                               1232.3983644574657,
                                               1240.3046773435874,
                                               1248.2236100802568,
                                               1256.1551225723395,
                                               1264.099175041662,
                                               1272.0557280230228,
                                               1280.0247423602691,
                                               1288.0061792024444,
                                               1295.9999999999995,
                                               1304.006166501068,
                                               1312.0246407478062,
                                               1320.0553850727929,
                                               1328.0983620954903,
                                               1336.1535347187651,
                                               1344.2208661254647,
                                               1352.3003197750522,
                                               1360.3918594002962,
                                               1368.4954490040145,
                                               1376.6110528558709,
                                               1384.7386354892244,
                                               1392.8781616980295,
                                               1401.0295965337855,
                                               1409.1929053025353,
                                               1417.3680535619119,
                                               1425.5550071182327,
                                               1433.7537320236374,
                                               1441.9641945732744,
                                               1450.1863613025282,
                                               1458.4201989842913,
                                               1466.6656746262797,
                                               1474.9227554683875,
                                               1483.1914089800841,
                                               1491.4716028578516,
                                               1499.7633050226596,
                                               1508.0664836174794,
                                               1516.3811070048375,
                                               1524.7071437644029,
                                               1533.0445626906128,
                                               1541.3933327903342,
                                               1549.7534232805581,
                                               1558.1248035861302,
                                               1566.507443337515,
                                               1574.9013123685909,
                                               1583.3063807144795,
                                               1591.7226186094069,
                                               1600.1499964845941,
                                               1608.58848496618,
                                               1617.0380548731737,
                                               1625.4986772154357,
                                               1633.9703231916887,
                                               1642.4529641875577,
                                               1650.9465717736346,
                                               1659.4511177035752,
                                               1667.9665739122186,
                                               1676.4929125137353,
                                               1685.030105799801,
                                               1693.5781262377957,
                                               1702.136946469027,
                                               1710.7065393069795,
                                               1719.2868777355877,
                                               1727.8779349075323,
                                               1736.4796841425596,
                                               1745.092098925825,
                                               1753.7151529062583,
                                               1762.3488198949503,
                                               1770.9930738635628,
                                               1779.6478889427597,
                                               1788.3132394206564,
                                               1796.9890997412947,
                                               1805.6754445031333,
                                               1814.3722484575621,
                                               1823.0794865074322,
                                               1831.7971337056094,
                                               1840.5251652535437,
                                               1849.2635564998579,
                                               1858.0122829389563,
                                               1866.7713202096493,
                                               1875.5406440937966,
                                               1884.3202305149687,
                                               1893.110055537124,
                                               1901.9100953633042,
                                               1910.7203263343454,
                                               1919.5407249276057,
                                               1928.3712677557098,
                                               1937.2119315653083,
                                               1946.0626932358525,
                                               1954.923529778386,
                                               1963.79441833435,
                                               1972.6753361744036,
                                               1981.5662606972594,
                                               1990.467169428533,
                                               1999.3780400196069,
                                               2008.2988502465078,
                                               2017.2295780087982,
                                               2026.1702013284819,
                                               2035.1206983489212,
                                               2044.0810473337688,
                                               2053.0512266659125,
                                               2062.0312148464309,
                                               2071.0209904935646,
                                               2080.0205323416958,
                                               2089.0298192403443,
                                               2098.0488301531714,
                                               2107.0775441569995,
                                               2116.115940440839,
                                               2125.1639983049317,
                                               2134.2216971597995,
                                               2143.2890165253098,
                                               2152.3659360297484,
                                               2161.4524354089031,
                                               2170.5484945051617,
                                               2179.6540932666144,
                                               2188.7692117461711,
                                               2197.8938301006888,
                                               2207.0279285901042,
                                               2216.1714875765838,
                                               2225.324487523676,
                                               2234.4869089954782,
                                               2243.6587326558101,
                                               2252.8399392673982,
                                               2262.0305096910702,
                                               2271.2304248849537,
                                               2280.4396659036897,
                                               2289.6582138976523,
                                               2298.8860501121762,
                                               2308.1231558867926,
                                               2317.3695126544767,
                                               2326.6251019409005,
                                               2335.8899053636933,
                                               2345.1639046317132,
                                               2354.4470815443233,
                                               2363.7394179906792,
                                               2373.0408959490205,
                                               2382.3514974859731,
                                               2391.6712047558558,
                                               2400.9999999999991,
                                               2410.3378655460651,
                                               2419.6847838073813,
                                               2429.0407372822747,
                                               2438.4057085534191,
                                               2447.7796802871858,
                                               2457.1626352330004,
                                               2466.5545562227112,
                                               2475.9554261699564,
                                               2485.3652280695474,
                                               2494.7839449968492,
                                               2504.2115601071737,
                                               2513.6480566351788,
                                               2523.0934178942675,
                                               2532.5476272760025,
                                               2542.0106682495189,
                                               2551.482524360948,
                                               2560.9631792328441,
                                               2570.4526165636184,
                                               2579.9508201269791,
                                               2589.4577737713744,
                                               2598.9734614194458,
                                               2608.4978670674823,
                                               2618.0309747848837,
                                               2627.5727687136259,
                                               2637.1232330677353,
                                               2646.6823521327647,
                                               2656.2501102652768,
                                               2665.8264918923328,
                                               2675.4114815109842,
                                               2685.0050636877722,
                                               2694.6072230582295,
                                               2704.2179443263894,
                                               2713.8372122642972,
                                               2723.4650117115279,
                                               2733.1013275747096,
                                               2742.7461448270483,
                                               2752.3994485078601,
                                               2762.0612237221085,
                                               2771.7314556399419,
                                               2781.4101294962406,
                                               2791.0972305901655,
                                               2800.7927442847094,
                                               2810.4966560062589,
                                               2820.2089512441521,
                                               2829.9296155502466,
                                               2839.6586345384894,
                                               2849.3959938844923,
                                               2859.1416793251065,
                                               2868.8956766580086,
                                               2878.6579717412847,
                                               2888.4285504930212,
                                               2898.2073988908974,
                                               2907.9945029717837,
                                               2917.789848831344,
                                               2927.5934226236377,
                                               2937.4052105607311,
                                               2947.2251989123079,
                                               2957.0533740052865,
                                               2966.8897222234368,
                                               2976.734230007005,
                                               2986.5868838523397,
                                               2996.4476703115197,
                                               3006.3165759919889,
                                               3016.1935875561908,
                                               3026.0786917212095,
                                               3035.9718752584108,
                                               3045.8731249930906,
                                               3055.7824278041207,
                                               3065.6997706236039,
                                               3075.625140436528,
                                               3085.5585242804245,
                                               3095.4999092450298,
                                               3105.4492824719491,
                                               3115.4066311543256,
                                               3125.3719425365089,
                                               3135.3452039137287,
                                               3145.3264026317715,
                                               3155.3155260866592,
                                               3165.3125617243295,
                                               3175.3174970403229,
                                               3185.3303195794679,
                                               3195.35101693557,
                                               3205.3795767511078,
                                               3215.4159867169251,
                                               3225.460234571929,
                                               3235.5123081027928,
                                               3245.5721951436558,
                                               3255.63988357583,
                                               3265.7153613275095,
                                               3275.7986163734795,
                                               3285.8896367348289,
                                               3295.9884104786665,
                                               3306.0949257178395,
                                               3316.2091706106517,
                                               3326.331133360588,
                                               3336.4608022160378,
                                               3346.5981654700231,
                                               3356.7432114599264,
                                               3366.8959285672249,
                                               3377.0563052172211,
                                               3387.2243298787821,
                                               3397.3999910640764,
                                               3407.5832773283128,
                                               3417.7741772694862,
                                               3427.9726795281199,
                                               3438.1787727870123,
                                               3448.3924457709873,
                                               3458.6136872466445,
                                               3468.8424860221107,
                                               3479.0788309467976,
                                               3489.3227109111554,
                                               3499.5741148464344,
                                               3509.8330317244445,
                                               3520.0994505573185,
                                               3530.3733603972751,
                                               3540.6547503363886,
                                               3550.9436095063534,
                                               3561.239927078258,
                                               3571.5436922623535,
                                               3581.8548943078308,
                                               3592.1735225025936,
                                               3602.4995661730372,
                                               3612.8330146838275,
                                               3623.1738574376814,
                                               3633.5220838751502,
                                               3643.8776834744031,
                                               3654.2406457510142,
                                               3664.6109602577494,
                                               3674.9886165843564,
                                               3685.3736043573545,
                                               3695.7659132398294,
                                               3706.1655329312248,
                                               3716.5724531671399,
                                               3726.9866637191262,
                                               3737.4081543944876,
                                               3747.8369150360782,
                                               3758.2729355221072,
                                               3768.7162057659411,
                                               3779.1667157159077,
                                               3789.6244553551055,
                                               3800.0894147012082,
                                               3810.5615838062768,
                                               3821.0409527565694,
                                               3831.5275116723533,
                                               3842.0212507077194,
                                               3852.522160050396,
                                               3863.0302299215673,
                                               3873.5454505756893,
                                               3884.0678123003108,
                                               3894.5973054158922,
                                               3905.1339202756285,
                                               3915.6776472652732,
                                               3926.2284768029604,
                                               3936.7863993390338,
                                               3947.3514053558706,
                                               3957.9234853677135,
                                               3968.5026299204969,
                                               3979.0888295916798,
                                               3989.6820749900776,
                                               4000.2823567556948,
                                               4010.8896655595613,
                                               4021.5039921035655,
                                               4032.1253271202945,
                                               4042.7536613728694,
                                               4053.3889856547858,
                                               4064.0312907897551,
                                               4074.6805676315448,
                                               4085.3368070638221,
                                               4095.9999999999982,
                                               4106.6701373830711,
                                               4117.347210185475,
                                               4128.0312094089259,
                                               4138.722126084268,
                                               4149.4199512713267,
                                               4160.1246760587583,
                                               4170.8362915638982,
                                               4181.5547889326181,
                                               4192.2801593391769,
                                               4203.0123939860741,
                                               4213.7514841039101,
                                               4224.4974209512384,
                                               4235.2501958144258,
                                               4246.0098000075095,
                                               4256.7762248720574,
                                               4267.549461777031,
                                               4278.3295021186423,
                                               4289.1163373202198,
                                               4299.9099588320714,
                                               4310.7103581313495,
                                               4321.5175267219138,
                                               4332.3314561342004,
                                               4343.152137925088,
                                               4353.9795636777671,
                                               4364.8137250016052,
                                               4375.6546135320223,
                                               4386.5022209303588,
                                               4397.3565388837469,
                                               4408.2175591049827,
                                               4419.0852733324018,
                                               4429.9596733297531,
                                               4440.8407508860728,
                                               4451.7284978155603,
                                               4462.6229059574571,
                                               4473.5239671759227,
                                               4484.4316733599126,
                                               4495.3460164230582,
                                               4506.2669883035496,
                                               4517.1945809640119,
                                               4528.1287863913894,
                                               4539.069596596828,
                                               4550.0170036155587,
                                               4560.9709995067806,
                                               4571.931576353546,
                                               4582.898726262647,
                                               4593.8724413645004,
                                               4604.8527138130348,
                                               4615.8395357855816,
                                               4626.8328994827571,
                                               4637.8327971283588,
                                               4648.8392209692511,
                                               4659.8521632752563,
                                               4670.8716163390473,
                                               4681.8975724760394,
                                               4692.9300240242837,
                                               4703.9689633443595,
                                               4715.0143828192668,
                                               4726.0662748543255,
                                               4737.1246318770682,
                                               4748.1894463371373,
                                               4759.2607107061804,
                                               4770.3384174777493,
                                               4781.4225591671993,
                                               4792.5131283115852,
                                               4803.6101174695614,
                                               4814.7135192212854,
                                               4825.8233261683154,
                                               4836.9395309335096,
                                               4848.0621261609349,
                                               4859.1911045157631,
                                               4870.3264586841779,
                                               4881.4681813732768,
                                               4892.6162653109768,
                                               4903.7707032459193,
                                               4914.931487947375,
                                               4926.0986122051509,
                                               4937.2720688294967,
                                               4948.4518506510112,
                                               4959.637950520555,
                                               4970.8303613091521,
                                               4982.0290759079044,
                                               4993.2340872278974,
                                               5004.4453882001153,
                                               5015.6629717753467,
                                               5026.8868309241007,
                                               5038.1169586365131,
                                               5049.353347922266,
                                               5060.5959918104927,
                                               5071.8448833496996,
                                               5083.1000156076734,
                                               5094.3613816713996,
                                               5105.6289746469747,
                                               5116.9027876595246,
                                               5128.18281385312,
                                               5139.4690463906918,
                                               5150.7614784539473,
                                               5162.0601032432933,
                                               5173.3649139777472,
                                               5184.6759038948594,
                                               5195.9930662506322,
                                               5207.3163943194386,
                                               5218.6458813939435,
                                               5229.9815207850224,
                                               5241.3233058216847,
                                               5252.6712298509919,
                                               5264.025286237983,
                                               5275.3854683655954,
                                               5286.7517696345885,
                                               5298.1241834634639,
                                               5309.5027032883945,
                                               5320.887322563146,
                                               5332.2780347589978,
                                               5343.6748333646756,
                                               5355.0777118862716,
                                               5366.4866638471722,
                                               5377.901682787985,
                                               5389.3227622664635,
                                               5400.749895857437,
                                               5412.1830771527357,
                                               5423.622299761123,
                                               5435.067557308219,
                                               5446.5188434364318,
                                               5457.9761518048872,
                                               5469.4394760893592,
                                               5480.9088099821975,
                                               5492.3841471922606,
                                               5503.8654814448455,
                                               5515.3528064816201,
                                               5526.846116060552,
                                               5538.3454039558474,
                                               5549.8506639578736,
                                               5561.3618898731029,
                                               5572.8790755240361,
                                               5584.4022147491451,
                                               5595.9313014027975,
                                               5607.4663293552012,
                                               5619.0072924923297,
                                               5630.5541847158656,
                                               5642.1069999431284,
                                               5653.665732107017,
                                               5665.230375155943,
                                               5676.8009230537655,
                                               5688.3773697797333,
                                               5699.9597093284156,
                                               5711.5479357096474,
                                               5723.1420429484588,
                                               5734.7420250850209,
                                               5746.347876174581,
                                               5757.9595902874016,
                                               5769.5771615087006,
                                               5781.2005839385911,
                                               5792.8298516920213,
                                               5804.4649588987149,
                                               5816.1058997031105,
                                               5827.7526682643065,
                                               5839.4052587559972,
                                               5851.0636653664196,
                                               5862.7278822982908,
                                               5874.3979037687541,
                                               5886.0737240093204,
                                               5897.7553372658094,
                                               5909.4427377982956,
                                               5921.1359198810505,
                                               5932.8348778024874,
                                               5944.5396058651031,
                                               5956.2500983854261,
                                               5967.9663496939575,
                                               5979.6883541351208,
                                               5991.4161060672022,
                                               6003.1495998623004,
                                               6014.8888299062692,
                                               6026.6337905986684,
                                               6038.3844763527022,
                                               6050.1408815951781,
                                               6061.9030007664414,
                                               6073.6708283203316,
                                               6085.4443587241267,
                                               6097.2235864584891,
                                               6109.0085060174197,
                                               6120.7991119081998,
                                               6132.595398651345,
                                               6144.3973607805519,
                                               6156.2049928426459,
                                               6168.0182893975361,
                                               6179.8372450181578,
                                               6191.6618542904307,
                                               6203.4921118132024,
                                               6215.3280121982016,
                                               6227.1695500699925,
                                               6239.0167200659189,
                                               6250.8695168360628,
                                               6262.7279350431891,
                                               6274.5919693627056,
                                               6286.4616144826068,
                                               6298.3368651034316,
                                               6310.2177159382172,
                                               6322.1041617124456,
                                               6333.9961971640032,
                                               6345.8938170431311,
                                               6357.7970161123785,
                                               6369.7057891465583,
                                               6381.6201309327007,
                                               6393.5400362700075,
                                               6405.4654999698032,
                                               6417.3965168554978,
                                               6429.3330817625329,
                                               6441.2751895383453,
                                               6453.2228350423138,
                                               6465.176013145724,
                                               6477.134718731716,
                                               6489.0989466952469,
                                               6501.0686919430445,
                                               6513.0439493935628,
                                               6525.0247139769417,
                                               6537.010980634961,
                                               6549.002744321001,
                                               6560.9999999999973,
                                               6573.0027426483985,
                                               6585.0109672541284,
                                               6597.0246688165371,
                                               6609.0438423463656,
                                               6621.0684828657004,
                                               6633.0985854079354,
                                               6645.134145017727,
                                               6657.1751567509573,
                                               6669.2216156746908,
                                               6681.2735168671343,
                                               6693.3308554176001,
                                               6705.3936264264594,
                                               6717.461825005108,
                                               6729.535446275926,
                                               6741.6144853722335,
                                               6753.6989374382601,
                                               6765.7887976290967,
                                               6777.8840611106634,
                                               6789.9847230596661,
                                               6802.0907786635626,
                                               6814.2022231205201,
                                               6826.3190516393797,
                                               6838.4412594396181,
                                               6850.5688417513074,
                                               6862.701793815083,
                                               6874.840110882099,
                                               6886.9837882139991,
                                               6899.1328210828724,
                                               6911.2872047712199,
                                               6923.4469345719199,
                                               6935.6120057881863,
                                               6947.7824137335365,
                                               6959.9581537317536,
                                               6972.1392211168532,
                                               6984.3256112330409,
                                               6996.5173194346862,
                                               7008.7143410862773,
                                               7020.9166715623942,
                                               7033.1243062476678,
                                               7045.3372405367481,
                                               7057.5554698342685,
                                               7069.7789895548103,
                                               7082.0077951228714,
                                               7094.2418819728273,
                                               7106.4812455489018,
                                               7118.7258813051285,
                                               7130.9757847053224,
                                               7143.2309512230404,
                                               7155.4913763415516,
                                               7167.7570555538041,
                                               7180.0279843623894,
                                               7192.3041582795131,
                                               7204.5855728269571,
                                               7216.8722235360519,
                                               7229.1641059476406,
                                               7241.4612156120484,
                                               7253.7635480890503,
                                               7266.0710989478375,
                                               7278.3838637669869,
                                               7290.7018381344296,
                                               7303.0250176474174,
                                               7315.3533979124932,
                                               7327.6869745454596,
                                               7340.0257431713462,
                                               7352.3696994243801,
                                               7364.7188389479543,
                                               7377.0731573945968,
                                               7389.4326504259407,
                                               7401.7973137126937,
                                               7414.1671429346061,
                                               7426.5421337804428,
                                               7438.922281947951,
                                               7451.3075831438346,
                                               7463.6980330837177,
                                               7476.0936274921214,
                                               7488.4943621024304,
                                               7500.9002326568652,
                                               7513.3112349064522,
                                               7525.7273646109943,
                                               7538.1486175390446,
                                               7550.5749894678729,
                                               7563.0064761834419,
                                               7575.4430734803736,
                                               7587.8847771619248,
                                               7600.3315830399597,
                                               7612.7834869349153,
                                               7625.24048467578,
                                               7637.7025721000637,
                                               7650.1697450537677,
                                               7662.6419993913596,
                                               7675.1193309757446,
                                               7687.6017356782404,
                                               7700.0892093785433,
                                               7712.5817479647112,
                                               7725.079347333125,
                                               7737.5820033884729,
                                               7750.0897120437139,
                                               7762.6024692200581,
                                               7775.1202708469355,
                                               7787.6431128619733,
                                               7800.1709912109645,
                                               7812.7039018478481,
                                               7825.2418407346768,
                                               7837.7848038415968,
                                               7850.3327871468155,
                                               7862.8857866365806,
                                               7875.4437983051539,
                                               7888.006818154784,
                                               7900.5748421956796,
                                               7913.1478664459901,
                                               7925.725886931772,
                                               7938.3088996869719,
                                               7950.8969007533951,
                                               7963.4898861806851,
                                               7976.0878520262959,
                                               7988.6907943554688,
                                               8001.2987092412086,
                                               8013.911592764257,
                                               8026.5294410130691,
                                               8039.1522500837891,
                                               8051.7800160802271,
                                               8064.412735113835,
                                               8077.0504033036796,
                                               8089.6930167764222,
                                               8102.3405716662946,
                                               8114.9930641150731,
                                               8127.6504902720571,
                                               8140.3128462940449,
                                               8152.9801283453098,
                                               8165.6523325975786,
                                               8178.3294552300049,
                                               8191.0114924291529,
                                               8203.6984403889655,
                                               8216.3902953107463,
                                               8229.0870534031419,
                                               8241.7887108821069,
                                               8254.4952639708936,
                                               8267.2067089000211,
                                               8279.9230419072574,
                                               8292.6442592375952,
                                               8305.3703571432306,
                                               8318.101331883543,
                                               8330.8371797250657,
                                               8343.577896941475,
                                               8356.3234798135582,
                                               8369.0739246291978,
                                               8381.8292276833508,
                                               8394.5893852780209,
                                               8407.3543937222421,
                                               8420.1242493320569,
                                               8432.8989484304948,
                                               8445.6784873475499,
                                               8458.4628624201578,
                                               8471.2520699921806,
                                               8484.0461064143838,
                                               8496.8449680444082,
                                               8509.6486512467636,
                                               8522.4571523927953,
                                               8535.270467860666,
                                               8548.0885940353437,
                                               8560.9115273085663,
                                               8573.7392640788403,
                                               8586.5718007514006,
                                               8599.4091337382069,
                                               8612.2512594579148,
                                               8625.0981743358552,
                                               8637.9498748040205,
                                               8650.8063573010386,
                                               8663.6676182721567,
                                               8676.533654169225,
                                               8689.4044614506638,
                                               8702.2800365814601,
                                               8715.1603760331418,
                                               8728.0454762837508,
                                               8740.9353338178389,
                                               8753.8299451264356,
                                               8766.7293067070332,
                                               8779.6334150635721,
                                               8792.5422667064158,
                                               8805.4558581523324,
                                               8818.3741859244819,
                                               8831.2972465523908,
                                               8844.2250365719356,
                                               8857.1575525253265,
                                               8870.0947909610859,
                                               8883.0367484340295,
                                               8895.9834215052524,
                                               8908.934806742107,
                                               8921.8909007181846,
                                               8934.8517000132997,
                                               8947.817201213471,
                                               8960.7874009109,
                                               8973.7622957039603,
                                               8986.7418821971733,
                                               8999.7261570011924,
                                               9012.7151167327884,
                                               9025.7087580148236,
                                               9038.7070774762469,
                                               9051.7100717520643,
                                               9064.7177374833282,
                                               9077.7300713171153,
                                               9090.7470699065179,
                                               9103.7687299106146,
                                               9116.7950479944648,
                                               9129.8260208290812,
                                               9142.8616450914233,
                                               9155.9019174643727,
                                               9168.9468346367157,
                                               9181.9963933031358,
                                               9195.0505901641845,
                                               9208.1094219262741,
                                               9221.1728853016557,
                                               9234.240977008405,
                                               9247.3136937704076,
                                               9260.3910323173386,
                                               9273.472989384647,
                                               9286.5595617135423,
                                               9299.6507460509747,
                                               9312.7465391496207,
                                               9325.8469377678684,
                                               9338.9519386698012,
                                               9352.0615386251757,
                                               9365.1757344094131,
                                               9378.2945228035842,
                                               9391.4179005943843,
                                               9404.5458645741273,
                                               9417.6784115407263,
                                               9430.8155382976747,
                                               9443.9572416540359,
                                               9457.1035184244265,
                                               9470.2543654290002,
                                               9483.4097794934296,
                                               9496.5697574488931,
                                               9509.7342961320664,
                                               9522.9033923850911,
                                               9536.0770430555804,
                                               9549.2552449965824,
                                               9562.4379950665825,
                                               9575.6252901294793,
                                               9588.8171270545736,
                                               9602.0135027165488,
                                               9615.2144139954635,
                                               9628.4198577767274,
                                               9641.629830951093,
                                               9654.844330414644,
                                               9668.0633530687719,
                                               9681.286895820167,
                                               9694.5149555808002,
                                               9707.7475292679192,
                                               9720.9846138040157,
                                               9734.2262061168276,
                                               9747.4723031393187,
                                               9760.7229018096641,
                                               9773.9779990712323,
                                               9787.2375918725811,
                                               9800.5016771674327,
                                               9813.7702519146696,
                                               9827.0433130783094,
                                               9840.3208576275028,
                                               9853.602882536512,
                                               9866.8893847846994,
                                               9880.1803613565116,
                                               9893.4758092414686,
                                               9906.7757254341523,
                                               9920.0801069341851,
                                               9933.3889507462245,
                                               9946.7022538799429,
                                               9960.0200133500221,
                                               9973.3422261761298,
                                               9986.6688893829159,
                                               9999.9999999999945,
                                               10013.335555061929,
                                               10026.675551608221,
                                               10040.019986683301,
                                               10053.368857336509,
                                               10066.722160622081,
                                               10080.079893599144,
                                               10093.442053331697,
                                               10106.808636888598,
                                               10120.179641343551,
                                               10133.555063775095,
                                               10146.934901266595,
                                               10160.31915090622,
                                               10173.707809786936,
                                               10187.100875006496,
                                               10200.498343667417,
                                               10213.900212876984,
                                               10227.306479747222,
                                               10240.717141394889,
                                               10254.132194941467,
                                               10267.551637513146,
                                               10280.975466240814,
                                               10294.40367826004,
                                               10307.836270711066,
                                               10321.273240738796,
                                               10334.71458549278,
                                               10348.160302127204,
                                               10361.610387800878,
                                               10375.064839677221,
                                               10388.523654924258,
                                               10401.986830714593,
                                               10415.454364225412,
                                               10428.926252638465,
                                               10442.402493140049,
                                               10455.883082921007,
                                               10469.368019176709,
                                               10482.85729910704,
                                               10496.350919916393,
                                               10509.848878813653,
                                               10523.351173012188,
                                               10536.857799729838,
                                               10550.3687561889,
                                               10563.884039616123,
                                               10577.403647242685,
                                               10590.927576304197,
                                               10604.455824040679,
                                               10617.988387696556,
                                               10631.525264520642,
                                               10645.066451766135,
                                               10658.611946690598,
                                               10672.161746555956,
                                               10685.715848628475,
                                               10699.274250178762,
                                               10712.836948481747,
                                               10726.403940816675,
                                               10739.975224467091,
                                               10753.550796720834,
                                               10767.130654870027,
                                               10780.714796211059,
                                               10794.303218044579,
                                               10807.895917675487,
                                               10821.492892412922,
                                               10835.094139570248,
                                               10848.699656465047,
                                               10862.309440419107,
                                               10875.923488758415,
                                               10889.541798813138,
                                               10903.16436791762,
                                               10916.791193410372,
                                               10930.422272634056,
                                               10944.05760293548,
                                               10957.697181665582,
                                               10971.341006179427,
                                               10984.98907383619,
                                               10998.641381999149,
                                               11012.297928035676,
                                               11025.958709317223,
                                               11039.623723219316,
                                               11053.292967121541,
                                               11066.966438407539,
                                               11080.64413446499,
                                               11094.326052685608,
                                               11108.012190465128,
                                               11121.702545203296,
                                               11135.397114303863,
                                               11149.095895174571,
                                               11162.798885227143,
                                               11176.506081877278,
                                               11190.217482544635,
                                               11203.933084652828,
                                               11217.652885629415,
                                               11231.376882905886,
                                               11245.105073917659,
                                               11258.837456104062,
                                               11272.574026908333,
                                               11286.314783777601,
                                               11300.059724162888,
                                               11313.808845519083,
                                               11327.562145304952,
                                               11341.319620983111,
                                               11355.081270020033,
                                               11368.847089886023,
                                               11382.617078055218,
                                               11396.391232005579,
                                               11410.169549218874,
                                               11423.952027180676,
                                               11437.738663380349,
                                               11451.529455311042,
                                               11465.324400469679,
                                               11479.123496356951,
                                               11492.926740477304,
                                               11506.734130338931,
                                               11520.545663453764,
                                               11534.361337337466,
                                               11548.181149509423,
                                               11562.005097492724,
                                               11575.83317881417,
                                               11589.665391004253,
                                               11603.501731597149,
                                               11617.342198130715,
                                               11631.186788146468,
                                               11645.035499189589,
                                               11658.888328808911,
                                               11672.745274556904,
                                               11686.606333989675,
                                               11700.471504666955,
                                               11714.340784152086,
                                               11728.214170012021,
                                               11742.091659817312,
                                               11755.973251142101,
                                               11769.858941564111,
                                               11783.748728664636,
                                               11797.642610028539,
                                               11811.540583244237,
                                               11825.442645903697,
                                               11839.34879560242,
                                               11853.259029939445,
                                               11867.173346517333,
                                               11881.091742942155,
                                               11895.014216823492,
                                               11908.940765774427,
                                               11922.871387411526,
                                               11936.806079354839,
                                               11950.744839227897,
                                               11964.687664657684,
                                               11978.634553274653,
                                               11992.585502712702,
                                               12006.540510609168,
                                               12020.499574604828,
                                               12034.462692343877,
                                               12048.429861473938,
                                               12062.401079646032,
                                               12076.376344514589,
                                               12090.355653737433,
                                               12104.339004975769,
                                               12118.326395894188,
                                               12132.317824160644,
                                               12146.313287446457,
                                               12160.312783426305,
                                               12174.316309778205,
                                               12188.323864183525,
                                               12202.335444326955,
                                               12216.351047896511,
                                               12230.370672583531,
                                               12244.394316082657,
                                               12258.421976091831,
                                               12272.453650312296,
                                               12286.489336448574,
                                               12300.529032208471,
                                               12314.572735303058,
                                               12328.620443446678,
                                               12342.672154356922,
                                               12356.727865754638,
                                               12370.787575363909,
                                               12384.851280912055,
                                               12398.918980129623,
                                               12412.990670750381,
                                               12427.066350511306,
                                               12441.146017152583,
                                               12455.229668417589,
                                               12469.317302052901,
                                               12483.40891580827,
                                               12497.50450743663,
                                               12511.604074694078,
                                               12525.707615339878,
                                               12539.815127136444,
                                               12553.926607849342,
                                               12568.042055247275,
                                               12582.161467102082,
                                               12596.284841188726,
                                               12610.41217528529,
                                               12624.543467172971,
                                               12638.678714636069,
                                               12652.817915461985,
                                               12666.961067441209,
                                               12681.108168367316,
                                               12695.259216036962,
                                               12709.414208249869,
                                               12723.573142808827,
                                               12737.736017519681,
                                               12751.902830191326,
                                               12766.073578635704,
                                               12780.248260667788,
                                               12794.426874105588,
                                               12808.609416770132,
                                               12822.795886485468,
                                               12836.986281078653,
                                               12851.180598379744,
                                               12865.378836221802,
                                               12879.580992440871,
                                               12893.787064875984,
                                               12907.997051369144,
                                               12922.210949765335,
                                               12936.428757912496,
                                               12950.650473661524,
                                               12964.876094866273,
                                               12979.105619383534,
                                               12993.339045073039,
                                               13007.576369797454,
                                               13021.817591422368,
                                               13036.062707816285,
                                               13050.311716850629,
                                               13064.564616399723,
                                               13078.821404340792,
                                               13093.082078553954,
                                               13107.346636922217,
                                               13121.615077331464,
                                               13135.887397670458,
                                               13150.163595830827,
                                               13164.44366970706,
                                               13178.727617196502,
                                               13193.015436199352,
                                               13207.307124618648,
                                               13221.602680360265,
                                               13235.902101332911,
                                               13250.205385448118,
                                               13264.512530620239,
                                               13278.823534766434,
                                               13293.138395806676,
                                               13307.457111663734,
                                               13321.779680263176,
                                               13336.106099533356,
                                               13350.436367405409,
                                               13364.77048181325,
                                               13379.108440693562,
                                               13393.450241985796,
                                               13407.795883632158,
                                               13422.145363577607,
                                               13436.498679769853,
                                               13450.855830159346,
                                               13465.216812699266,
                                               13479.581625345529,
                                               13493.950266056772,
                                               13508.32273279435,
                                               13522.699023522329,
                                               13537.079136207483,
                                               13551.463068819286,
                                               13565.850819329906,
                                               13580.2423857142,
                                               13594.63776594971,
                                               13609.036958016657,
                                               13623.439959897927,
                                               13637.846769579081,
                                               13652.257385048335,
                                               13666.67180429656,
                                               13681.090025317284,
                                               13695.512046106669,
                                               13709.937864663521,
                                               13724.367478989278,
                                               13738.800887088004,
                                               13753.238086966385,
                                               13767.679076633727,
                                               13782.123854101939,
                                               13796.572417385545,
                                               13811.024764501659,
                                               13825.480893469998,
                                               13839.94080231286,
                                               13854.404489055134,
                                               13868.871951724283,
                                               13883.34318835034,
                                               13897.818196965914,
                                               13912.296975606168,
                                               13926.779522308825,
                                               13941.26583511416,
                                               13955.755912064991,
                                               13970.249751206682,
                                               13984.747350587126,
                                               13999.248708256751,
                                               14013.753822268511,
                                               14028.262690677873,
                                               14042.775311542828,
                                               14057.291682923867,
                                               14071.811802883994,
                                               14086.335669488704,
                                               14100.863280805994,
                                               14115.394634906341,
                                               14129.92972986271,
                                               14144.468563750548,
                                               14159.01113464777,
                                               14173.55744063476,
                                               14188.107479794369,
                                               14202.661250211901,
                                               14217.218749975118,
                                               14231.779977174227,
                                               14246.344929901879,
                                               14260.913606253163,
                                               14275.486004325601,
                                               14290.062122219146,
                                               14304.641958036171,
                                               14319.225509881464,
                                               14333.812775862236,
                                               14348.403754088098,
                                               14362.998442671067,
                                               14377.59683972556,
                                               14392.198943368388,
                                               14406.804751718748,
                                               14421.414262898223,
                                               14436.027475030774,
                                               14450.64438624274,
                                               14465.264994662828,
                                               14479.889298422106,
                                               14494.517295654005,
                                               14509.148984494313,
                                               14523.784363081166,
                                               14538.423429555049,
                                               14553.066182058781,
                                               14567.712618737527,
                                               14582.362737738777,
                                               14597.016537212348,
                                               14611.674015310382,
                                               14626.33517018734,
                                               14640.999999999993,
                                               14655.668502907418,
                                               14670.340677071003,
                                               14685.016520654426,
                                               14699.696031823671,
                                               14714.379208746999,
                                               14729.066049594967,
                                               14743.756552540408,
                                               14758.45071575843,
                                               14773.148537426418,
                                               14787.850015724018,
                                               14802.555148833142,
                                               14817.263934937961,
                                               14831.976372224897,
                                               14846.692458882624,
                                               14861.41219310206,
                                               14876.135573076363,
                                               14890.862597000923,
                                               14905.593263073371,
                                               14920.327569493558,
                                               14935.065514463557,
                                               14949.807096187662,
                                               14964.552312872382,
                                               14979.301162726431,
                                               14994.053643960735,
                                               15008.809754788414,
                                               15023.569493424788,
                                               15038.332858087369,
                                               15053.099846995858,
                                               15067.870458372134,
                                               15082.644690440264,
                                               15097.422541426484,
                                               15112.204009559202,
                                               15126.989093068994,
                                               15141.777790188597,
                                               15156.570099152905,
                                               15171.366018198967,
                                               15186.165545565986,
                                               15200.968679495301,
                                               15215.775418230402,
                                               15230.585760016909,
                                               15245.399703102579,
                                               15260.217245737298,
                                               15275.038386173073,
                                               15289.863122664035,
                                               15304.691453466432,
                                               15319.523376838621,
                                               15334.358891041069,
                                               15349.197994336346,
                                               15364.040684989128,
                                               15378.886961266177,
                                               15393.736821436356,
                                               15408.590263770609,
                                               15423.447286541972,
                                               15438.307888025554,
                                               15453.172066498542,
                                               15468.039820240196,
                                               15482.91114753184,
                                               15497.786046656869,
                                               15512.664515900733,
                                               15527.546553550939,
                                               15542.432157897045,
                                               15557.32132723066,
                                               15572.214059845435,
                                               15587.110354037064,
                                               15602.010208103273,
                                               15616.913620343823,
                                               15631.820589060506,
                                               15646.731112557136,
                                               15661.645189139546,
                                               15676.562817115593,
                                               15691.483994795139,
                                               15706.408720490062,
                                               15721.336992514242,
                                               15736.268809183561,
                                               15751.204168815901,
                                               15766.143069731135,
                                               15781.085510251132,
                                               15796.03148869974,
                                               15810.981003402798,
                                               15825.934052688119,
                                               15840.890634885489,
                                               15855.850748326673,
                                               15870.814391345401,
                                               15885.781562277361,
                                               15900.752259460214,
                                               15915.726481233565,
                                               15930.704225938984,
                                               15945.685491919978,
                                               15960.670277522009,
                                               15975.658581092481,
                                               15990.65040098073,
                                               16005.645735538035,
                                               16020.644583117599,
                                               16035.646942074556,
                                               16050.652810765967,
                                               16065.662187550806,
                                               16080.675070789974,
                                               16095.691458846273,
                                               16110.711350084424,
                                               16125.734742871053,
                                               16140.761635574685,
                                               16155.792026565747,
                                               16170.825914216561,
                                               16185.863296901338,
                                               16200.904172996183,
                                               16215.948540879079,
                                               16230.996398929899,
                                               16246.047745530386,
                                               16261.102579064163,
                                               16276.160897916721,
                                               16291.22270047542,
                                               16306.287985129484,
                                               16321.356750269995,
                                               16336.428994289896,
                                               16351.504715583982,
                                               16366.5839125489,
                                               16381.666583583141,
                                               16396.752727087041,
                                               16411.842341462776,
                                               16426.935425114363,
                                               16442.031976447644,
                                               16457.131993870298,
                                               16472.235475791829,
                                               16487.342420623561,
                                               16502.452826778641,
                                               16517.566692672033,
                                               16532.684016720516,
                                               16547.804797342676,
                                               16562.929032958902,
                                               16578.056721991394,
                                               16593.18786286415,
                                               16608.322454002962,
                                               16623.460493835417,
                                               16638.601980790896,
                                               16653.746913300558,
                                               16668.895289797354,
                                               16684.047108716015,
                                               16699.202368493046,
                                               16714.361067566726,
                                               16729.523204377107,
                                               16744.688777366009,
                                               16759.857784977012,
                                               16775.030225655464,
                                               16790.206097848466,
                                               16805.385400004874,
                                               16820.568130575302,
                                               16835.754288012104,
                                               16850.943870769381,
                                               16866.136877302983,
                                               16881.333306070494,
                                               16896.53315553123,
                                               16911.736424146249,
                                               16926.943110378332,
                                               16942.153212691992,
                                               16957.366729553454,
                                               16972.583659430682,
                                               16987.804000793338,
                                               17003.027752112816,
                                               17018.254911862205,
                                               17033.485478516312,
                                               17048.719450551645,
                                               17063.956826446421,
                                               17079.197604680547,
                                               17094.44178373563,
                                               17109.689362094967,
                                               17124.940338243552,
                                               17140.194710668064,
                                               17155.452477856852,
                                               17170.713638299967,
                                               17185.978190489128,
                                               17201.246132917724,
                                               17216.517464080825,
                                               17231.792182475165,
                                               17247.070286599141,
                                               17262.351774952826,
                                               17277.636646037936,
                                               17292.924898357855,
                                               17308.216530417623,
                                               17323.511540723921,
                                               17338.809927785089,
                                               17354.111690111105,
                                               17369.416826213594,
                                               17384.725334605821,
                                               17400.037213802683,
                                               17415.352462320716,
                                               17430.67107867809,
                                               17445.993061394587,
                                               17461.318408991636,
                                               17476.647119992274,
                                               17491.979192921168,
                                               17507.314626304586,
                                               17522.653418670423,
                                               17537.995568548187,
                                               17553.341074468986,
                                               17568.689934965536,
                                               17584.042148572156,
                                               17599.397713824768,
                                               17614.75662926089,
                                               17630.118893419625,
                                               17645.484504841683,
                                               17660.853462069354,
                                               17676.225763646511,
                                               17691.601408118619,
                                               17706.980394032718,
                                               17722.362719937424,
                                               17737.748384382936,
                                               17753.137385921014,
                                               17768.529723104999,
                                               17783.92539448979,
                                               17799.324398631856,
                                               17814.726734089225,
                                               17830.13239942148,
                                               17845.541393189767,
                                               17860.95371395678,
                                               17876.369360286772,
                                               17891.788330745527,
                                               17907.210623900395,
                                               17922.636238320254,
                                               17938.065172575527,
                                               17953.497425238176,
                                               17968.932994881692,
                                               17984.371880081104,
                                               17999.814079412972,
                                               18015.259591455371,
                                               18030.708414787914,
                                               18046.160547991731,
                                               18061.615989649465,
                                               18077.074738345284,
                                               18092.536792664861,
                                               18108.002151195393,
                                               18123.470812525571,
                                               18138.942775245599,
                                               18154.418037947191,
                                               18169.896599223546,
                                               18185.37845766938,
                                               18200.863611880886,
                                               18216.352060455767,
                                               18231.843801993204,
                                               18247.338835093873,
                                               18262.837158359936,
                                               18278.338770395032,
                                               18293.84366980429,
                                               18309.351855194309,
                                               18324.863325173166,
                                               18340.378078350412,
                                               18355.896113337069,
                                               18371.417428745623,
                                               18386.942023190033,
                                               18402.469895285718,
                                               18418.00104364955,
                                               18433.53546689987,
                                               18449.073163656474,
                                               18464.614132540602,
                                               18480.158372174956,
                                               18495.705881183676,
                                               18511.256658192357,
                                               18526.810701828035,
                                               18542.368010719183,
                                               18557.928583495715,
                                               18573.492418788985,
                                               18589.059515231773,
                                               18604.629871458303,
                                               18620.203486104212,
                                               18635.78035780658,
                                               18651.360485203899,
                                               18666.943866936086,
                                               18682.53050164448,
                                               18698.120387971841,
                                               18713.713524562332,
                                               18729.30991006154,
                                               18744.909543116457,
                                               18760.512422375479,
                                               18776.118546488418,
                                               18791.727914106479,
                                               18807.340523882274,
                                               18822.95637446981,
                                               18838.575464524489,
                                               18854.197792703111,
                                               18869.823357663863,
                                               18885.452158066328,
                                               18901.08419257147,
                                               18916.719459841639,
                                               18932.357958540564,
                                               18947.999687333362,
                                               18963.644644886521,
                                               18979.292829867907,
                                               18994.944240946759,
                                               19010.598876793687,
                                               19026.256736080668,
                                               19041.917817481048,
                                               19057.582119669532,
                                               19073.2496413222,
                                               19088.920381116473,
                                               19104.594337731145,
                                               19120.271509846356,
                                               19135.951896143604,
                                               19151.635495305738,
                                               19167.322306016948,
                                               19183.012326962784,
                                               19198.705556830122,
                                               19214.401994307198,
                                               19230.101638083579,
                                               19245.804486850167,
                                               19261.510539299208,
                                               19277.219794124274,
                                               19292.932250020265,
                                               19308.647905683421,
                                               19324.366759811302,
                                               19340.088811102793,
                                               19355.8140582581,
                                               19371.542499978754,
                                               19387.2741349676,
                                               19403.008961928797,
                                               19418.746979567823,
                                               19434.488186591469,
                                               19450.232581707827,
                                               19465.980163626304,
                                               19481.730931057613,
                                               19497.484882713761,
                                               19513.242017308068,
                                               19529.002333555141,
                                               19544.765830170898,
                                               19560.532505872539,
                                               19576.302359378566,
                                               19592.075389408761,
                                               19607.851594684209,
                                               19623.630973927269,
                                               19639.41352586159,
                                               19655.199249212103,
                                               19670.988142705017,
                                               19686.780205067826,
                                               19702.575435029288,
                                               19718.373831319448,
                                               19734.175392669615,
                                               19749.980117812371,
                                               19765.788005481569,
                                               19781.599054412323,
                                               19797.413263341008,
                                               19813.230631005274,
                                               19829.051156144014,
                                               19844.874837497395,
                                               19860.701673806827,
                                               19876.531663814985,
                                               19892.364806265789,
                                               19908.201099904403,
                                               19924.040543477258,
                                               19939.883135732012,
                                               19955.728875417579,
                                               19971.577761284105,
                                               19987.429792082985,
                                               20003.284966566847,
                                               20019.14328348956,
                                               20035.004741606219,
                                               20050.869339673161,
                                               20066.737076447946,
                                               20082.607950689362,
                                               20098.481961157428,
                                               20114.359106613385,
                                               20130.239385819699,
                                               20146.122797540058,
                                               20162.009340539353,
                                               20177.899013583716,
                                               20193.791815440476,
                                               20209.687744878182,
                                               20225.586800666591,
                                               20241.488981576669,
                                               20257.394286380597,
                                               20273.302713851754,
                                               20289.214262764715,
                                               20305.128931895277,
                                               20321.046720020415,
                                               20336.967625918318,
                                               20352.891648368361,
                                               20368.818786151114,
                                               20384.749038048347,
                                               20400.682402843009,
                                               20416.618879319249,
                                               20432.558466262391,
                                               20448.501162458953,
                                               20464.446966696629,
                                               20480.395877764302,
                                               20496.347894452025,
                                               20512.303015551031,
                                               20528.261239853735,
                                               20544.22256615372,
                                               20560.186993245738,
                                               20576.15451992572,
                                               20592.125144990758,
                                               20608.098867239107,
                                               20624.075685470198,
                                               20640.055598484618,
                                               20656.038605084115,
                                               20672.024704071595,
                                               20688.013894251126,
                                               20704.006174427926,
                                               20720.001543408373,
                                               20735.999999999989,
                                               20752.001543011454,
                                               20768.006171252597,
                                               20784.013883534382,
                                               20800.024678668931,
                                               20816.038555469506,
                                               20832.055512750507,
                                               20848.075549327474,
                                               20864.098664017085,
                                               20880.124855637161,
                                               20896.154123006647,
                                               20912.186464945626,
                                               20928.221880275312,
                                               20944.260367818049,
                                               20960.301926397311,
                                               20976.346554837684,
                                               20992.394251964895,
                                               21008.445016605787,
                                               21024.498847588318,
                                               21040.555743741574,
                                               21056.615703895754,
                                               21072.678726882168,
                                               21088.744811533252,
                                               21104.813956682538,
                                               21120.886161164683,
                                               21136.961423815443,
                                               21153.039743471683,
                                               21169.121118971379,
                                               21185.205549153605,
                                               21201.293032858535,
                                               21217.383568927453,
                                               21233.477156202731,
                                               21249.573793527841,
                                               21265.673479747358,
                                               21281.776213706937,
                                               21297.881994253334,
                                               21313.990820234398,
                                               21330.102690499054,
                                               21346.21760389733,
                                               21362.335559280327,
                                               21378.456555500241,
                                               21394.580591410333,
                                               21410.707665864964,
                                               21426.83777771956,
                                               21442.970925830628,
                                               21459.107109055756,
                                               21475.246326253604,
                                               21491.388576283895,
                                               21507.533858007431,
                                               21523.682170286087,
                                               21539.833511982797,
                                               21555.987881961566,
                                               21572.145279087465,
                                               21588.305702226615,
                                               21604.469150246216,
                                               21620.635622014521,
                                               21636.805116400832,
                                               21652.977632275521,
                                               21669.153168510009,
                                               21685.331723976764,
                                               21701.513297549318,
                                               21717.697888102244,
                                               21733.885494511167,
                                               21750.076115652759,
                                               21766.269750404736,
                                               21782.466397645861,
                                               21798.666056255934,
                                               21814.868725115801,
                                               21831.074403107345,
                                               21847.283089113484,
                                               21863.494782018177,
                                               21879.709480706417,
                                               21895.927184064229,
                                               21912.147890978667,
                                               21928.371600337818,
                                               21944.598311030797,
                                               21960.828021947746,
                                               21977.060731979829,
                                               21993.296440019243,
                                               22009.535144959198,
                                               22025.77684569393,
                                               22042.021541118691,
                                               22058.269230129757,
                                               22074.519911624411,
                                               22090.773584500959,
                                               22107.030247658717,
                                               22123.289899998013,
                                               22139.552540420187,
                                               22155.818167827587,
                                               22172.086781123569,
                                               22188.358379212495,
                                               22204.632960999726,
                                               22220.910525391639,
                                               22237.191071295601,
                                               22253.474597619981,
                                               22269.761103274148,
                                               22286.050587168469,
                                               22302.343048214312,
                                               22318.638485324027,
                                               22334.936897410968,
                                               22351.23828338947,
                                               22367.542642174871,
                                               22383.849972683485,
                                               22400.160273832618,
                                               22416.473544540564,
                                               22432.789783726603,
                                               22449.108990310986,
                                               22465.431163214958,
                                               22481.75630136074,
                                               22498.084403671528,
                                               22514.415469071497,
                                               22530.749496485802,
                                               22547.086484840562,
                                               22563.426433062879,
                                               22579.769340080824,
                                               22596.115204823436,
                                               22612.464026220721,
                                               22628.815803203655,
                                               22645.170534704179,
                                               22661.5282196552,
                                               22677.888856990587,
                                               22694.252445645168,
                                               22710.618984554734,
                                               22726.988472656034,
                                               22743.360908886778,
                                               22759.736292185622,
                                               22776.114621492186,
                                               22792.495895747044,
                                               22808.880113891719,
                                               22825.267274868678,
                                               22841.657377621348,
                                               22858.050421094096,
                                               22874.446404232243,
                                               22890.845325982053,
                                               22907.247185290722,
                                               22923.651981106406,
                                               22940.059712378195,
                                               22956.470378056114,
                                               22972.883977091129,
                                               22989.300508435153,
                                               23005.719971041017,
                                               23022.142363862498,
                                               23038.567685854305,
                                               23054.995935972078,
                                               23071.427113172387,
                                               23087.86121641273,
                                               23104.298244651531,
                                               23120.738196848146,
                                               23137.181071962848,
                                               23153.626868956846,
                                               23170.075586792263,
                                               23186.527224432142,
                                               23202.981780840448,
                                               23219.439254982066,
                                               23235.899645822796,
                                               23252.362952329357,
                                               23268.829173469378,
                                               23285.298308211408,
                                               23301.770355524899,
                                               23318.245314380223,
                                               23334.723183748658,
                                               23351.203962602387,
                                               23367.687649914504,
                                               23384.174244659007,
                                               23400.663745810798,
                                               23417.15615234568,
                                               23433.651463240367,
                                               23450.149677472462,
                                               23466.650794020472,
                                               23483.154811863806,
                                               23499.661729982763,
                                               23516.171547358543,
                                               23532.684262973235,
                                               23549.199875809823,
                                               23565.718384852185,
                                               23582.239789085092,
                                               23598.764087494197,
                                               23615.291279066041,
                                               23631.821362788058,
                                               23648.354337648565,
                                               23664.890202636761,
                                               23681.428956742733,
                                               23697.970598957443,
                                               23714.515128272738,
                                               23731.062543681343,
                                               23747.612844176863,
                                               23764.166028753778,
                                               23780.72209640744,
                                               23797.281046134085,
                                               23813.842876930816,
                                               23830.407587795606,
                                               23846.975177727301,
                                               23863.545645725622,
                                               23880.11899079115,
                                               23896.695211925336,
                                               23913.274308130498,
                                               23929.856278409821,
                                               23946.441121767348,
                                               23963.028837207989,
                                               23979.619423737513,
                                               23996.212880362549,
                                               24012.809206090584,
                                               24029.408399929966,
                                               24046.010460889898,
                                               24062.615387980433,
                                               24079.223180212492,
                                               24095.833836597827,
                                               24112.447356149063,
                                               24129.063737879667,
                                               24145.682980803951,
                                               24162.305083937081,
                                               24178.930046295067,
                                               24195.557866894767,
                                               24212.188544753884,
                                               24228.822078890964,
                                               24245.458468325389,
                                               24262.097712077397,
                                               24278.739809168052,
                                               24295.384758619261,
                                               24312.032559453768,
                                               24328.683210695162,
                                               24345.336711367858,
                                               24361.993060497109,
                                               24378.652257108995,
                                               24395.314300230442,
                                               24411.979188889192,
                                               24428.646922113825,
                                               24445.317498933746,
                                               24461.990918379193,
                                               24478.667179481225,
                                               24495.346281271726,
                                               24512.028222783407,
                                               24528.713003049801,
                                               24545.400621105266,
                                               24562.091075984976,
                                               24578.784366724925,
                                               24595.480492361927,
                                               24612.179451933614,
                                               24628.881244478438,
                                               24645.585869035654,
                                               24662.293324645343,
                                               24679.003610348394,
                                               24695.716725186514,
                                               24712.432668202211,
                                               24729.151438438807,
                                               24745.873034940436,
                                               24762.597456752032,
                                               24779.324702919344,
                                               24796.054772488926,
                                               24812.787664508123,
                                               24829.5233780251,
                                               24846.261912088819,
                                               24863.003265749034,
                                               24879.747438056307,
                                               24896.494428062004,
                                               24913.244234818278,
                                               24929.996857378079,
                                               24946.752294795166,
                                               24963.510546124078,
                                               24980.271610420157,
                                               24997.035486739525,
                                               25013.802174139113,
                                               25030.571671676629,
                                               25047.343978410572,
                                               25064.119093400237,
                                               25080.897015705697,
                                               25097.677744387816,
                                               25114.461278508239,
                                               25131.2476171294,
                                               25148.036759314517,
                                               25164.828704127583,
                                               25181.623450633375,
                                               25198.42099789745,
                                               25215.221344986145,
                                               25232.024490966574,
                                               25248.830434906627,
                                               25265.639175874974,
                                               25282.450712941049,
                                               25299.265045175071,
                                               25316.082171648024,
                                               25332.902091431668,
                                               25349.724803598532,
                                               25366.550307221914,
                                               25383.378601375884,
                                               25400.209685135269,
                                               25417.043557575678,
                                               25433.880217773472,
                                               25450.719664805783,
                                               25467.561897750507,
                                               25484.406915686297,
                                               25501.254717692573,
                                               25518.105302849512,
                                               25534.958670238051,
                                               25551.814818939893,
                                               25568.67374803748,
                                               25585.535456614027,
                                               25602.399943753502,
                                               25619.267208540619,
                                               25636.137250060852,
                                               25653.010067400432,
                                               25669.885659646327,
                                               25686.76402588627,
                                               25703.645165208734,
                                               25720.529076702944,
                                               25737.415759458876,
                                               25754.305212567244,
                                               25771.197435119517,
                                               25788.092426207899,
                                               25804.990184925344,
                                               25821.890710365547,
                                               25838.794001622944,
                                               25855.700057792714,
                                               25872.608877970775,
                                               25889.520461253778,
                                               25906.434806739118,
                                               25923.351913524923,
                                               25940.271780710063,
                                               25957.194407394138,
                                               25974.11979267748,
                                               25991.047935661154,
                                               26007.978835446964,
                                               26024.912491137442,
                                               26041.848901835841,
                                               26058.788066646157,
                                               26075.729984673108,
                                               26092.674655022136,
                                               26109.622076799409,
                                               26126.572249111829,
                                               26143.525171067016,
                                               26160.480841773315,
                                               26177.43926033979,
                                               26194.400425876229,
                                               26211.364337493149,
                                               26228.330994301767,
                                               26245.30039541404,
                                               26262.272539942627,
                                               26279.247427000919,
                                               26296.225055703002,
                                               26313.205425163702,
                                               26330.188534498539,
                                               26347.174382823756,
                                               26364.162969256304,
                                               26381.154292913852,
                                               26398.148352914774,
                                               26415.145148378149,
                                               26432.144678423778,
                                               26449.146942172156,
                                               26466.151938744493,
                                               26483.159667262702,
                                               26500.170126849403,
                                               26517.183316627921,
                                               26534.199235722277,
                                               26551.217883257199,
                                               26568.239258358124,
                                               26585.263360151173,
                                               26602.290187763181,
                                               26619.319740321676,
                                               26636.352016954883,
                                               26653.387016791727,
                                               26670.424738961825,
                                               26687.465182595493,
                                               26704.508346823739,
                                               26721.554230778267,
                                               26738.602833591467,
                                               26755.65415439643,
                                               26772.708192326929,
                                               26789.764946517433,
                                               26806.824416103096,
                                               26823.886600219761,
                                               26840.95149800396,
                                               26858.019108592915,
                                               26875.089431124517,
                                               26892.162464737365,
                                               26909.238208570721,
                                               26926.316661764544,
                                               26943.397823459472,
                                               26960.481692796813,
                                               26977.568268918571,
                                               26994.657550967422,
                                               27011.749538086722,
                                               27028.844229420498,
                                               27045.941624113464,
                                               27063.041721311005,
                                               27080.144520159181,
                                               27097.250019804727,
                                               27114.35821939505,
                                               27131.469118078236,
                                               27148.582715003027,
                                               27165.699009318858,
                                               27182.818000175819,
                                               27199.939686724665,
                                               27217.064068116837,
                                               27234.191143504428,
                                               27251.320912040203,
                                               27268.453372877593,
                                               27285.588525170693,
                                               27302.726368074269,
                                               27319.866900743735,
                                               27337.010122335181,
                                               27354.156032005358,
                                               27371.304628911668,
                                               27388.455912212183,
                                               27405.609881065626,
                                               27422.766534631384,
                                               27439.925872069507,
                                               27457.087892540683,
                                               27474.252595206275,
                                               27491.419979228293,
                                               27508.5900437694,
                                               27525.762787992917,
                                               27542.93821106281,
                                               27560.116312143706,
                                               27577.297090400876,
                                               27594.480545000242,
                                               27611.666675108383,
                                               27628.855479892518,
                                               27646.046958520514,
                                               27663.241110160889,
                                               27680.437933982801,
                                               27697.637429156068,
                                               27714.839594851132,
                                               27732.04443023909,
                                               27749.251934491687,
                                               27766.462106781299,
                                               27783.674946280949,
                                               27800.890452164302,
                                               27818.108623605654,
                                               27835.329459779954,
                                               27852.55295986278,
                                               27869.779123030345,
                                               27887.007948459504,
                                               27904.239435327745,
                                               27921.473582813196,
                                               27938.710390094613,
                                               27955.949856351392,
                                               27973.19198076355,
                                               27990.436762511745,
                                               28007.684200777272,
                                               28024.934294742041,
                                               28042.187043588601,
                                               28059.442446500128,
                                               28076.700502660427,
                                               28093.961211253929,
                                               28111.224571465693,
                                               28128.490582481401,
                                               28145.759243487362,
                                               28163.030553670509,
                                               28180.304512218394,
                                               28197.581118319198,
                                               28214.860371161725,
                                               28232.14226993539,
                                               28249.42681383024,
                                               28266.71400203693,
                                               28284.003833746745,
                                               28301.296308151585,
                                               28318.591424443959,
                                               28335.889181817001,
                                               28353.189579464462,
                                               28370.492616580705,
                                               28387.798292360701,
                                               28405.106606000048,
                                               28422.417556694945,
                                               28439.731143642206,
                                               28457.047366039264,
                                               28474.366223084147,
                                               28491.687713975512,
                                               28509.011837912611,
                                               28526.338594095305,
                                               28543.667981724069,
                                               28560.999999999982,
                                               28578.334648124732,
                                               28595.671925300605,
                                               28613.011830730498,
                                               28630.354363617909,
                                               28647.699523166943,
                                               28665.0473085823,
                                               28682.397719069289,
                                               28699.750753833818,
                                               28717.10641208239,
                                               28734.464693022121,
                                               28751.825595860708,
                                               28769.189119806462,
                                               28786.55526406828,
                                               28803.924027855664,
                                               28821.295410378701,
                                               28838.669410848088,
                                               28856.046028475103,
                                               28873.425262471628,
                                               28890.80711205013,
                                               28908.191576423673,
                                               28925.578654805915,
                                               28942.968346411097,
                                               28960.360650454055,
                                               28977.755566150216,
                                               28995.153092715591,
                                               29012.553229366786,
                                               29029.955975320987,
                                               29047.361329795975,
                                               29064.769292010107,
                                               29082.179861182336,
                                               29099.593036532187,
                                               29117.00881727978,
                                               29134.427202645813,
                                               29151.848191851568,
                                               29169.271784118911,
                                               29186.697978670283,
                                               29204.126774728706,
                                               29221.55817151779,
                                               29238.992168261717,
                                               29256.42876418525,
                                               29273.867958513725,
                                               29291.309750473058,
                                               29308.754139289747,
                                               29326.201124190855,
                                               29343.65070440403,
                                               29361.102879157483,
                                               29378.557647680012,
                                               29396.015009200975,
                                               29413.474962950309,
                                               29430.937508158524,
                                               29448.402644056692,
                                               29465.870369876469,
                                               29483.340684850071,
                                               29500.81358821028,
                                               29518.289079190454,
                                               29535.767157024511,
                                               29553.247820946945,
                                               29570.731070192807,
                                               29588.216903997723,
                                               29605.70532159787,
                                               29623.19632223,
                                               29640.689905131429,
                                               29658.186069540028,
                                               29675.684814694236,
                                               29693.186139833047,
                                               29710.690044196028,
                                               29728.196527023298,
                                               29745.705587555527,
                                               29763.217225033964,
                                               29780.731438700397,
                                               29798.248227797183,
                                               29815.76759156723,
                                               29833.289529254005,
                                               29850.81404010153,
                                               29868.341123354381,
                                               29885.870778257693,
                                               29903.403004057145,
                                               29920.937799998974,
                                               29938.475165329975,
                                               29956.015099297485,
                                               29973.557601149394,
                                               29991.102670134147,
                                               30008.650305500738,
                                               30026.200506498706,
                                               30043.753272378144,
                                               30061.308602389683,
                                               30078.866495784507,
                                               30096.426951814352,
                                               30113.989969731494,
                                               30131.55554878875,
                                               30149.123688239491,
                                               30166.694387337629,
                                               30184.267645337608,
                                               30201.843461494434,
                                               30219.42183506364,
                                               30237.002765301309,
                                               30254.586251464058,
                                               30272.172292809046,
                                               30289.760888593977,
                                               30307.35203807709,
                                               30324.94574051716,
                                               30342.541995173502,
                                               30360.140801305966,
                                               30377.742158174944,
                                               30395.346065041358,
                                               30412.952521166666,
                                               30430.561525812864,
                                               30448.173078242475,
                                               30465.787177718561,
                                               30483.403823504719,
                                               30501.02301486507,
                                               30518.644751064272,
                                               30536.269031367516,
                                               30553.895855040515,
                                               30571.525221349519,
                                               30589.157129561307,
                                               30606.791578943175,
                                               30624.428568762964,
                                               30642.06809828903,
                                               30659.710166790261,
                                               30677.35477353607,
                                               30695.001917796391,
                                               30712.651598841687,
                                               30730.303815942945,
                                               30747.958568371676,
                                               30765.615855399912,
                                               30783.275676300211,
                                               30800.938030345646,
                                               30818.602916809814,
                                               30836.270334966837,
                                               30853.940284091354,
                                               30871.612763458521,
                                               30889.287772344011,
                                               30906.965310024025,
                                               30924.645375775272,
                                               30942.327968874983,
                                               30960.013088600903,
                                               30977.700734231294,
                                               30995.390905044929,
                                               31013.083600321101,
                                               31030.778819339619,
                                               31048.476561380798,
                                               31066.17682572547,
                                               31083.879611654978,
                                               31101.584918451179,
                                               31119.29274539644,
                                               31137.003091773637,
                                               31154.715956866155,
                                               31172.431339957893,
                                               31190.14924033326,
                                               31207.869657277162,
                                               31225.592590075023,
                                               31243.318038012771,
                                               31261.046000376838,
                                               31278.776476454172,
                                               31296.50946553221,
                                               31314.24496689891,
                                               31331.98297984272,
                                               31349.7235036526,
                                               31367.466537618013,
                                               31385.212081028923,
                                               31402.960133175795,
                                               31420.710693349596,
                                               31438.463760841791,
                                               31456.219334944351,
                                               31473.977414949743,
                                               31491.738000150934,
                                               31509.501089841389,
                                               31527.266683315069,
                                               31545.034779866437,
                                               31562.80537879045,
                                               31580.578479382562,
                                               31598.35408093872,
                                               31616.132182755369,
                                               31633.91278412945,
                                               31651.695884358396,
                                               31669.481482740131,
                                               31687.269578573076,
                                               31705.060171156143,
                                               31722.853259788735,
                                               31740.648843770748,
                                               31758.446922402567,
                                               31776.247494985066,
                                               31794.050560819614,
                                               31811.85611920806,
                                               31829.664169452753,
                                               31847.474710856521,
                                               31865.287742722685,
                                               31883.103264355046,
                                               31900.921275057899,
                                               31918.741774136019,
                                               31936.564760894671,
                                               31954.390234639599,
                                               31972.21819467704,
                                               31990.048640313704,
                                               32007.881570856793,
                                               32025.716985613984,
                                               32043.554883893445,
                                               32061.395265003815,
                                               32079.238128254223,
                                               32097.083472954269,
                                               32114.931298414049,
                                               32132.781603944117,
                                               32150.634388855524,
                                               32168.48965245979,
                                               32186.347394068915,
                                               32204.207612995371,
                                               32222.07030855212,
                                               32239.935480052583,
                                               32257.803126810672,
                                               32275.673248140767,
                                               32293.545843357719,
                                               32311.420911776862,
                                               32329.298452713996,
                                               32347.178465485395,
                                               32365.060949407813,
                                               32382.945903798463,
                                               32400.83332797504,
                                               32418.723221255706,
                                               32436.615582959093,
                                               32454.510412404306,
                                               32472.407708910916,
                                               32490.307471798966,
                                               32508.209700388961,
                                               32526.114394001877,
                                               32544.021551959166,
                                               32561.931173582732,
                                               32579.843258194956,
                                               32597.757805118679,
                                               32615.674813677211,
                                               32633.594283194328,
                                               32651.516212994258,
                                               32669.440602401712,
                                               32687.367450741847,
                                               32705.296757340297,
                                               32723.228521523146,
                                               32741.162742616943,
                                               32759.099419948703,
                                               32777.038552845901,
                                               32794.980140636464,
                                               32812.924182648792,
                                               32830.87067821173,
                                               32848.819626654593,
                                               32866.77102730715,
                                               32884.724879499619,
                                               32902.681182562686,
                                               32920.639935827494,
                                               32938.601138625643,
                                               32956.56479028918,
                                               32974.530890150607,
                                               32992.499437542894,
                                               33010.470431799447,
                                               33028.443872254145,
                                               33046.419758241311,
                                               33064.39808909571,
                                               33082.378864152583,
                                               33100.36208274759,
                                               33118.347744216881,
                                               33136.335847897026,
                                               33154.326393125062,
                                               33172.31937923847,
                                               33190.314805575174,
                                               33208.312671473555,
                                               33226.312976272442,
                                               33244.315719311111,
                                               33262.320899929284,
                                               33280.328517467125,
                                               33298.33857126526,
                                               33316.351060664747,
                                               33334.365985007091,
                                               33352.383343634239,
                                               33370.403135888591,
                                               33388.42536111299,
                                               33406.450018650721,
                                               33424.477107845501,
                                               33442.506628041512,
                                               33460.53857858335,
                                               33478.572958816083,
                                               33496.609768085189,
                                               33514.649005736617,
                                               33532.690671116739,
                                               33550.734763572356,
                                               33568.781282450735,
                                               33586.830227099563,
                                               33604.881596866973,
                                               33622.935391101528,
                                               33640.991609152239,
                                               33659.050250368542,
                                               33677.111314100322,
                                               33695.174799697881,
                                               33713.240706511984,
                                               33731.309033893805,
                                               33749.37978119497,
                                               33767.452947767531,
                                               33785.528532963974,
                                               33803.606536137209,
                                               33821.686956640602,
                                               33839.769793827938,
                                               33857.855047053425,
                                               33875.942715671707,
                                               33894.032799037872,
                                               33912.125296507431,
                                               33930.220207436316,
                                               33948.317531180888,
                                               33966.417267097961,
                                               33984.519414544746,
                                               34002.623972878901,
                                               34020.730941458511,
                                               34038.840319642077,
                                               34056.952106788536,
                                               34075.066302257255,
                                               34093.182905408015,
                                               34111.301915601027,
                                               34129.42333219693,
                                               34147.547154556785,
                                               34165.673382042078,
                                               34183.80201401472,
                                               34201.933049837033,
                                               34220.06648887178,
                                               34238.202330482141,
                                               34256.340574031703,
                                               34274.481218884495,
                                               34292.624264404949,
                                               34310.769709957938,
                                               34328.91755490873,
                                               34347.067798623029,
                                               34365.220440466954,
                                               34383.375479807051,
                                               34401.532916010263,
                                               34419.692748443973,
                                               34437.854976475966,
                                               34456.01959947445,
                                               34474.18661680806,
                                               34492.356027845817,
                                               34510.527831957188,
                                               34528.702028512052,
                                               34546.878616880676,
                                               34565.05759643377,
                                               34583.238966542449,
                                               34601.422726578232,
                                               34619.608875913065,
                                               34637.797413919296,
                                               34655.988339969692,
                                               34674.181653437423,
                                               34692.37735369608,
                                               34710.575440119668,
                                               34728.775912082579,
                                               34746.978768959649,
                                               34765.184010126082,
                                               34783.391634957537,
                                               34801.60164283005,
                                               34819.814033120063,
                                               34838.028805204456,
                                               34856.24595846048,
                                               34874.465492265823,
                                               34892.687405998557,
                                               34910.911699037177,
                                               34929.138370760564,
                                               34947.367420548027,
                                               34965.598847779271,
                                               34983.832651834389,
                                               35002.068832093908,
                                               35020.307387938738,
                                               35038.548318750189,
                                               35056.79162390998,
                                               35075.03730280025,
                                               35093.285354803513,
                                               35111.535779302685,
                                               35129.788575681116,
                                               35148.043743322516,
                                               35166.301281611013,
                                               35184.561189931141,
                                               35202.823467667826,
                                               35221.088114206388,
                                               35239.355128932555,
                                               35257.624511232447,
                                               35275.896260492584,
                                               35294.170376099886,
                                               35312.446857441668,
                                               35330.725703905628,
                                               35349.006914879887,
                                               35367.290489752944,
                                               35385.576427913686,
                                               35403.864728751418,
                                               35422.155391655811,
                                               35440.448416016967,
                                               35458.743801225341,
                                               35477.041546671804,
                                               35495.341651747622,
                                               35513.644115844436,
                                               35531.948938354304,
                                               35550.256118669655,
                                               35568.565656183309,
                                               35586.877550288496,
                                               35605.191800378816,
                                               35623.508405848268,
                                               35641.827366091238,
                                               35660.148680502505,
                                               35678.472348477233,
                                               35696.798369410979,
                                               35715.126742699678,
                                               35733.457467739659,
                                               35751.790543927644,
                                               35770.125970660738,
                                               35788.46374733642,
                                               35806.803873352568,
                                               35825.146348107453,
                                               35843.49117099971,
                                               35861.838341428367,
                                               35880.187858792851,
                                               35898.539722492955,
                                               35916.893931928862,
                                               35935.250486501129,
                                               35953.609385610718,
                                               35971.970628658957,
                                               35990.334215047558,
                                               36008.700144178612,
                                               36027.068415454596,
                                               36045.439028278372,
                                               36063.811982053165,
                                               36082.187276182609,
                                               36100.564910070694,
                                               36118.944883121789,
                                               36137.327194740654,
                                               36155.711844332429,
                                               36174.098831302617,
                                               36192.488155057115,
                                               36210.87981500219,
                                               36229.273810544473,
                                               36247.670141091003,
                                               36266.068806049167,
                                               36284.469804826738,
                                               36302.873136831862,
                                               36321.278801473069,
                                               36339.686798159251,
                                               36358.097126299683,
                                               36376.509785304013,
                                               36394.924774582258,
                                               36413.342093544816,
                                               36431.761741602444,
                                               36450.183718166292,
                                               36468.608022647859,
                                               36487.034654459028,
                                               36505.463613012063,
                                               36523.894897719583,
                                               36542.328507994578,
                                               36560.764443250409,
                                               36579.202702900831,
                                               36597.643286359926,
                                               36616.086193042182,
                                               36634.531422362437,
                                               36652.978973735895,
                                               36671.428846578143,
                                               36689.881040305125,
                                               36708.335554333149,
                                               36726.792388078902,
                                               36745.251540959427,
                                               36763.713012392138,
                                               36782.176801794812,
                                               36800.642908585593,
                                               36819.111332182983,
                                               36837.582072005869,
                                               36856.055127473483,
                                               36874.530498005421,
                                               36893.008183021651,
                                               36911.488181942506,
                                               36929.970494188674,
                                               36948.455119181206,
                                               36966.942056341519,
                                               36985.431305091392,
                                               37003.922864852961,
                                               37022.416735048733,
                                               37040.912915101559,
                                               37059.411404434657,
                                               37077.91220247162,
                                               37096.415308636388,
                                               37114.920722353243,
                                               37133.428443046862,
                                               37151.938470142253,
                                               37170.450803064785,
                                               37188.965441240209,
                                               37207.482384094597,
                                               37226.001631054402,
                                               37244.523181546429,
                                               37263.047034997842,
                                               37281.573190836149,
                                               37300.101648489224,
                                               37318.632407385296,
                                               37337.165466952945,
                                               37355.700826621112,
                                               37374.238485819085,
                                               37392.778443976509,
                                               37411.320700523385,
                                               37429.865254890057,
                                               37448.412106507232,
                                               37466.961254805974,
                                               37485.512699217681,
                                               37504.066439174116,
                                               37522.622474107404,
                                               37541.180803449992,
                                               37559.741426634704,
                                               37578.304343094693,
                                               37596.869552263488,
                                               37615.43705357494,
                                               37634.006846463279,
                                               37652.578930363044,
                                               37671.153304709165,
                                               37689.729968936896,
                                               37708.308922481847,
                                               37726.890164779965,
                                               37745.473695267559,
                                               37764.059513381275,
                                               37782.647618558112,
                                               37801.238010235415,
                                               37819.830687850859,
                                               37838.425650842495,
                                               37857.022898648691,
                                               37875.622430708172,
                                               37894.224246460013,
                                               37912.828345343616,
                                               37931.434726798747,
                                               37950.043390265506,
                                               37968.654335184328,
                                               37987.267560995999,
                                               38005.883067141665,
                                               38024.500853062775,
                                               38043.120918201159,
                                               38061.743261998963,
                                               38080.367883898682,
                                               38098.994783343158,
                                               38117.623959775563,
                                               38136.255412639417,
                                               38154.889141378575,
                                               38173.525145437234,
                                               38192.163424259939,
                                               38210.803977291551,
                                               38229.446803977284,
                                               38248.091903762703,
                                               38266.739276093685,
                                               38285.388920416466,
                                               38304.040836177606,
                                               38322.695022824002,
                                               38341.351479802899,
                                               38360.010206561863,
                                               38378.671202548816,
                                               38397.334467211993,
                                               38415.999999999978,
                                               38434.667800361683,
                                               38453.33786774637,
                                               38472.010201603611,
                                               38490.684801383337,
                                               38509.361666535784,
                                               38528.040796511552,
                                               38546.722190761553,
                                               38565.405848737035,
                                               38584.091769889594,
                                               38602.779953671132,
                                               38621.470399533908,
                                               38640.163106930493,
                                               38658.858075313794,
                                               38677.555304137059,
                                               38696.254792853862,
                                               38714.956540918094,
                                               38733.660547783991,
                                               38752.366812906112,
                                               38771.075335739348,
                                               38789.78611573892,
                                               38808.499152360368,
                                               38827.214445059573,
                                               38845.931993292739,
                                               38864.651796516388,
                                               38883.373854187383,
                                               38902.098165762916,
                                               38920.824730700486,
                                               38939.553548457938,
                                               38958.284618493431,
                                               38977.017940265461,
                                               38995.753513232834,
                                               39014.491336854699,
                                               39033.231410590517,
                                               39051.973733900079,
                                               39070.718306243485,
                                               39089.465127081188,
                                               39108.214195873945,
                                               39126.965512082832,
                                               39145.719075169261,
                                               39164.474884594965,
                                               39183.232939821988,
                                               39201.99324031271,
                                               39220.755785529815,
                                               39239.52057493633,
                                               39258.287607995589,
                                               39277.056884171245,
                                               39295.828402927284,
                                               39314.602163728006,
                                               39333.378166038019,
                                               39352.15640932227,
                                               39370.936893046004,
                                               39389.719616674811,
                                               39408.504579674584,
                                               39427.291781511522,
                                               39446.081221652174,
                                               39464.872899563372,
                                               39483.666814712291,
                                               39502.462966566411,
                                               39521.261354593538,
                                               39540.06197826178,
                                               39558.864837039568,
                                               39577.669930395656,
                                               39596.47725779911,
                                               39615.286818719302,
                                               39634.098612625923,
                                               39652.912638988993,
                                               39671.728897278823,
                                               39690.547386966064,
                                               39709.368107521652,
                                               39728.191058416858,
                                               39747.016239123259,
                                               39765.84364911275,
                                               39784.673287857528,
                                               39803.505154830105,
                                               39822.339249503319,
                                               39841.175571350293,
                                               39860.014119844491,
                                               39878.854894459677,
                                               39897.697894669909,
                                               39916.54311994958,
                                               39935.390569773372,
                                               39954.240243616303,
                                               39973.092140953675,
                                               39991.946261261117,
                                               40010.802604014549,
                                               40029.661168690225,
                                               40048.521954764678,
                                               40067.384961714779,
                                               40086.250189017679,
                                               40105.117636150855,
                                               40123.98730259209,
                                               40142.859187819471,
                                               40161.733291311379,
                                               40180.609612546526,
                                               40199.488151003912,
                                               40218.368906162854,
                                               40237.25187750296,
                                               40256.137064504153,
                                               40275.024466646668,
                                               40293.914083411029,
                                               40312.805914278084,
                                               40331.699958728961,
                                               40350.596216245103,
                                               40369.494686308273,
                                               40388.39536840051,
                                               40407.298262004173,
                                               40426.20336660192,
                                               40445.110681676706,
                                               40464.020206711793,
                                               40482.931941190756,
                                               40501.845884597446,
                                               40520.762036416032,
                                               40539.680396130985,
                                               40558.600963227072,
                                               40577.523737189367,
                                               40596.448717503234,
                                               40615.375903654342,
                                               40634.305295128659,
                                               40653.236891412453,
                                               40672.170691992294,
                                               40691.106696355047,
                                               40710.044903987873,
                                               40728.985314378238,
                                               40747.927927013901,
                                               40766.872741382918,
                                               40785.819756973651,
                                               40804.768973274746,
                                               40823.720389775161,
                                               40842.674005964131,
                                               40861.629821331211,
                                               40880.587835366234,
                                               40899.548047559321,
                                               40918.510457400931,
                                               40937.475064381761,
                                               40956.441867992849,
                                               40975.410867725499,
                                               40994.382063071331,
                                               41013.355453522236,
                                               41032.331038570417,
                                               41051.308817708363,
                                               41070.288790428858,
                                               41089.270956224987,
                                               41108.255314590111,
                                               41127.241865017888,
                                               41146.23060700229,
                                               41165.221540037543,
                                               41184.214663618193,
                                               41203.209977239079,
                                               41222.207480395307,
                                               41241.207172582297,
                                               41260.209053295752,
                                               41279.213122031659,
                                               41298.219378286303,
                                               41317.227821556255,
                                               41336.23845133838,
                                               41355.251267129832,
                                               41374.266268428037,
                                               41393.283454730743,
                                               41412.302825535953,
                                               41431.324380341983,
                                               41450.348118647416,
                                               41469.374039951144,
                                               41488.402143752326,
                                               41507.432429550427,
                                               41526.464896845187,
                                               41545.499545136627,
                                               41564.536373925075,
                                               41583.575382711126,
                                               41602.616570995662,
                                               41621.659938279874,
                                               41640.705484065205,
                                               41659.753207853406,
                                               41678.803109146495,
                                               41697.855187446803,
                                               41716.909442256911,
                                               41735.965873079709,
                                               41755.02447941836,
                                               41774.085260776315,
                                               41793.148216657297,
                                               41812.213346565331,
                                               41831.280650004708,
                                               41850.350126480014,
                                               41869.421775496106,
                                               41888.495596558132,
                                               41907.571589171515,
                                               41926.649752841957,
                                               41945.730087075463,
                                               41964.812591378286,
                                               41983.897265256979,
                                               42002.984108218378,
                                               42022.073119769593,
                                               42041.164299418015,
                                               42060.257646671307,
                                               42079.353161037419,
                                               42098.450842024591,
                                               42117.550689141324,
                                               42136.652701896404,
                                               42155.756879798893,
                                               42174.863222358137,
                                               42193.971729083758,
                                               42213.082399485655,
                                               42232.195233074002,
                                               42251.310229359246,
                                               42270.427387852127,
                                               42289.546708063644,
                                               42308.668189505079,
                                               42327.791831687995,
                                               42346.917634124227,
                                               42366.045596325886,
                                               42385.175717805352,
                                               42404.307998075295,
                                               42423.442436648642,
                                               42442.579033038608,
                                               42461.717786758672,
                                               42480.858697322597,
                                               42500.001764244422,
                                               42519.146987038446,
                                               42538.294365219248,
                                               42557.443898301688,
                                               42576.595585800882,
                                               42595.749427232236,
                                               42614.90542211142,
                                               42634.063569954378,
                                               42653.223870277317,
                                               42672.386322596729,
                                               42691.55092642938,
                                               42710.717681292292,
                                               42729.886586702756,
                                               42749.057642178363,
                                               42768.23084723694,
                                               42787.406201396603,
                                               42806.58370417574,
                                               42825.76335509299,
                                               42844.945153667286,
                                               42864.129099417805,
                                               42883.315191864014,
                                               42902.503430525649,
                                               42921.693814922692,
                                               42940.88634457541,
                                               42960.081019004348,
                                               42979.277837730297,
                                               42998.476800274322,
                                               43017.677906157769,
                                               43036.881154902228,
                                               43056.086546029583,
                                               43075.294079061961,
                                               43094.503753521763,
                                               43113.715568931671,
                                               43132.929524814601,
                                               43152.145620693766,
                                               43171.363856092619,
                                               43190.584230534907,
                                               43209.806743544621,
                                               43229.031394646016,
                                               43248.258183363621,
                                               43267.487109222224,
                                               43286.718171746885,
                                               43305.951370462906,
                                               43325.186704895881,
                                               43344.42417457165,
                                               43363.663779016322,
                                               43382.905517756262,
                                               43402.149390318104,
                                               43421.395396228749,
                                               43440.643535015348,
                                               43459.89380620532,
                                               43479.146209326354,
                                               43498.400743906379,
                                               43517.657409473606,
                                               43536.916205556496,
                                               43556.177131683784,
                                               43575.44018738444,
                                               43594.705372187724,
                                               43613.972685623135,
                                               43633.242127220445,
                                               43652.513696509668,
                                               43671.787393021099,
                                               43691.063216285271,
                                               43710.341165833001,
                                               43729.621241195346,
                                               43748.903441903625,
                                               43768.187767489413,
                                               43787.474217484552,
                                               43806.762791421126,
                                               43826.053488831501,
                                               43845.346309248278,
                                               43864.641252204325,
                                               43883.938317232765,
                                               43903.237503866971,
                                               43922.538811640596,
                                               43941.842240087513,
                                               43961.147788741881,
                                               43980.455457138101,
                                               43999.765244810835,
                                               44019.077151295001,
                                               44038.391176125755,
                                               44057.70731883854,
                                               44077.02557896902,
                                               44096.345956053141,
                                               44115.668449627083,
                                               44134.993059227287,
                                               44154.319784390456,
                                               44173.648624653535,
                                               44192.979579553728,
                                               44212.312648628489,
                                               44231.647831415532,
                                               44250.985127452805,
                                               44270.324536278538,
                                               44289.666057431183,
                                               44309.009690449464,
                                               44328.355434872348,
                                               44347.703290239064,
                                               44367.053256089079,
                                               44386.405331962109,
                                               44405.759517398139,
                                               44425.115811937387,
                                               44444.474215120332,
                                               44463.834726487694,
                                               44483.197345580462,
                                               44502.562071939843,
                                               44521.928905107328,
                                               44541.297844624634,
                                               44560.668890033732,
                                               44580.042040876848,
                                               44599.417296696454,
                                               44618.794657035272,
                                               44638.174121436256,
                                               44657.555689442641,
                                               44676.939360597877,
                                               44696.325134445673,
                                               44715.713010530002,
                                               44735.102988395054,
                                               44754.495067585296,
                                               44773.88924764542,
                                               44793.285528120374,
                                               44812.683908555344,
                                               44832.084388495779,
                                               44851.486967487363,
                                               44870.891645076015,
                                               44890.298420807922,
                                               44909.707294229491,
                                               44929.118264887409,
                                               44948.531332328566,
                                               44967.946496100136,
                                               44987.363755749502,
                                               45006.783110824319,
                                               45026.204560872473,
                                               45045.628105442098,
                                               45065.053744081561,
                                               45084.48147633949,
                                               45103.911301764747,
                                               45123.343219906426,
                                               45142.777230313885,
                                               45162.21333253671,
                                               45181.651526124733,
                                               45201.091810628037,
                                               45220.534185596924,
                                               45239.978650581965,
                                               45259.425205133957,
                                               45278.873848803938,
                                               45298.324581143192,
                                               45317.777401703235,
                                               45337.232310035848,
                                               45356.68930569302,
                                               45376.148388226997,
                                               45395.60955719027,
                                               45415.072812135557,
                                               45434.538152615823,
                                               45454.005578184282,
                                               45473.475088394356,
                                               45492.946682799746,
                                               45512.420360954362,
                                               45531.896122412363,
                                               45551.373966728155,
                                               45570.853893456362,
                                               45590.33590215187,
                                               45609.819992369776,
                                               45629.306163665438,
                                               45648.794415594442,
                                               45668.284747712612,
                                               45687.777159576006,
                                               45707.27165074092,
                                               45726.768220763894,
                                               45746.266869201696,
                                               45765.767595611323,
                                               45785.270399550034,
                                               45804.775280575297,
                                               45824.282238244828,
                                               45843.79127211657,
                                               45863.302381748719,
                                               45882.815566699683,
                                               45902.33082652813,
                                               45921.848160792935,
                                               45941.367569053225,
                                               45960.889050868354,
                                               45980.41260579793,
                                               45999.938233401757,
                                               46019.465933239902,
                                               46038.995704872657,
                                               46058.527547860547,
                                               46078.06146176433,
                                               46097.597446144995,
                                               46117.135500563774,
                                               46136.675624582109,
                                               46156.217817761702,
                                               46175.762079664462,
                                               46195.308409852543,
                                               46214.856807888333,
                                               46234.407273334444,
                                               46253.959805753715,
                                               46273.51440470924,
                                               46293.071069764315,
                                               46312.629800482478,
                                               46332.190596427499,
                                               46351.753457163381,
                                               46371.318382254351,
                                               46390.885371264863,
                                               46410.45442375962,
                                               46430.025539303526,
                                               46449.598717461733,
                                               46469.17395779962,
                                               46488.751259882782,
                                               46508.33062327707,
                                               46527.912047548532,
                                               46547.495532263471,
                                               46567.081076988397,
                                               46586.668681290059,
                                               46606.258344735434,
                                               46625.850066891719,
                                               46645.443847326351,
                                               46665.039685606986,
                                               46684.637581301497,
                                               46704.237533978005,
                                               46723.839543204842,
                                               46743.443608550573,
                                               46763.049729583989,
                                               46782.657905874104,
                                               46802.268136990162,
                                               46821.880422501628,
                                               46841.494761978196,
                                               46861.111154989776,
                                               46880.729601106526,
                                               46900.350099898795,
                                               46919.97265093719,
                                               46939.597253792526,
                                               46959.223908035841,
                                               46978.852613238392,
                                               46998.483368971691,
                                               47018.11617480743,
                                               47037.751030317551,
                                               47057.387935074221,
                                               47077.026888649809,
                                               47096.66789061694,
                                               47116.310940548428,
                                               47135.956038017328,
                                               47155.603182596918,
                                               47175.252373860698,
                                               47194.903611382375,
                                               47214.556894735892,
                                               47234.212223495422,
                                               47253.869597235338,
                                               47273.52901553025,
                                               47293.19047795498,
                                               47312.853984084577,
                                               47332.519533494306,
                                               47352.187125759658,
                                               47371.856760456343,
                                               47391.528437160297,
                                               47411.202155447652,
                                               47430.877914894787,
                                               47450.555715078299,
                                               47470.235555574982,
                                               47489.917435961863,
                                               47509.601355816201,
                                               47529.287314715453,
                                               47548.975312237308,
                                               47568.665347959672,
                                               47588.357421460656,
                                               47608.051532318605,
                                               47627.747680112072,
                                               47647.445864419846,
                                               47667.14608482091,
                                               47686.848340894474,
                                               47706.552632219973,
                                               47726.258958377046,
                                               47745.967318945557,
                                               47765.677713505589,
                                               47785.390141637428,
                                               47805.104602921601,
                                               47824.821096938824,
                                               47844.539623270044,
                                               47864.260181496429,
                                               47883.982771199349,
                                               47903.707391960394,
                                               47923.434043361369,
                                               47943.162724984308,
                                               47962.893436411439,
                                               47982.626177225218,
                                               48002.36094700831,
                                               48022.097745343599,
                                               48041.836571814172,
                                               48061.57742600335,
                                               48081.32030749465,
                                               48101.065215871815,
                                               48120.81215071879,
                                               48140.56111161974,
                                               48160.312098159047,
                                               48180.065109921306,
                                               48199.820146491307,
                                               48219.577207454073,
                                               48239.336292394844,
                                               48259.097400899045,
                                               48278.860532552339,
                                               48298.625686940592,
                                               48318.392863649875,
                                               48338.162062266485,
                                               48357.933282376915,
                                               48377.706523567889,
                                               48397.481785426316,
                                               48417.259067539344,
                                               48437.038369494308,
                                               48456.819690878765,
                                               48476.603031280487,
                                               48496.388390287451,
                                               48516.175767487839,
                                               48535.965162470042,
                                               48555.756574822684,
                                               48575.550004134566,
                                               48595.345449994718,
                                               48615.142911992378,
                                               48634.942389716991,
                                               48654.743882758201,
                                               48674.547390705877,
                                               48694.352913150084,
                                               48714.160449681112,
                                               48733.969999889443,
                                               48753.781563365759,
                                               48773.595139700978,
                                               48793.410728486211,
                                               48813.228329312769,
                                               48833.047941772187,
                                               48852.869565456189,
                                               48872.693199956717,
                                               48892.518844865925,
                                               48912.346499776155,
                                               48932.176164279976,
                                               48952.007837970152,
                                               48971.841520439666,
                                               48991.677211281676,
                                               49011.514910089587,
                                               49031.354616456978,
                                               49051.196329977654,
                                               49071.04005024561,
                                               49090.885776855059,
                                               49110.733509400408,
                                               49130.583247476279,
                                               49150.434990677488,
                                               49170.288738599062,
                                               49190.144490836232,
                                               49210.002246984441,
                                               49229.86200663932,
                                               49249.723769396718,
                                               49269.587534852675,
                                               49289.453302603448,
                                               49309.32107224549,
                                               49329.190843375451,
                                               49349.062615590192,
                                               49368.936388486785,
                                               49388.812161662492,
                                               49408.689934714785,
                                               49428.569707241324,
                                               49448.45147883999,
                                               49468.335249108866,
                                               49488.22101764621,
                                               49508.108784050521,
                                               49527.99854792047,
                                               49547.890308854934,
                                               49567.784066453009,
                                               49587.679820313977,
                                               49607.57757003732,
                                               49627.477315222721,
                                               49647.379055470075,
                                               49667.28279037946,
                                               49687.188519551179,
                                               49707.096242585707,
                                               49727.005959083741,
                                               49746.917668646165,
                                               49766.831370874068,
                                               49786.747065368734,
                                               49806.66475173166,
                                               49826.584429564515,
                                               49846.506098469203,
                                               49866.429758047794,
                                               49886.355407902578,
                                               49906.283047636032,
                                               49926.212676850846,
                                               49946.144295149883,
                                               49966.077902136225,
                                               49986.013497413151,
                                               50005.951080584135,
                                               50025.890651252834,
                                               50045.832209023123,
                                               50065.775753499074,
                                               50085.721284284933,
                                               50105.668800985164,
                                               50125.618303204428,
                                               50145.569790547575,
                                               50165.523262619652,
                                               50185.478719025901,
                                               50205.436159371769,
                                               50225.395583262893,
                                               50245.356990305103,
                                               50265.320380104429,
                                               50285.285752267104,
                                               50305.253106399534,
                                               50325.222442108337,
                                               50345.193759000336,
                                               50365.16705668252,
                                               50385.142334762102,
                                               50405.119592846473,
                                               50425.098830543218,
                                               50445.080047460127,
                                               50465.063243205179,
                                               50485.048417386541,
                                               50505.035569612577,
                                               50525.024699491856,
                                               50545.015806633128,
                                               50565.008890645338,
                                               50585.003951137631,
                                               50605.00098771933,
                                               50624.999999999971,
                                               50645.000987589265,
                                               50665.003950097132,
                                               50685.008887133677,
                                               50705.015798309192,
                                               50725.024683234165,
                                               50745.035541519283,
                                               50765.048372775411,
                                               50785.063176613621,
                                               50805.079952645159,
                                               50825.098700481489,
                                               50845.119419734241,
                                               50865.142110015244,
                                               50885.166770936521,
                                               50905.193402110279,
                                               50925.222003148934,
                                               50945.252573665071,
                                               50965.285113271471,
                                               50985.319621581119,
                                               51005.356098207172,
                                               51025.394542762981,
                                               51045.434954862096,
                                               51065.477334118244,
                                               51085.521680145357,
                                               51105.567992557546,
                                               51125.616270969113,
                                               51145.66651499454,
                                               51165.718724248516,
                                               51185.772898345916,
                                               51205.829036901778,
                                               51225.887139531362,
                                               51245.947205850105,
                                               51266.009235473619,
                                               51286.073228017718,
                                               51306.139183098399,
                                               51326.207100331856,
                                               51346.276979334456,
                                               51366.348819722756,
                                               51386.42262111351,
                                               51406.498383123653,
                                               51426.57610537031,
                                               51446.655787470787,
                                               51466.737429042587,
                                               51486.82102970338,
                                               51506.906589071048,
                                               51526.994106763632,
                                               51547.083582399391,
                                               51567.175015596738,
                                               51587.268405974297,
                                               51607.363753150858,
                                               51627.461056745415,
                                               51647.56031637713,
                                               51667.661531665362,
                                               51687.764702229651,
                                               51707.869827689727,
                                               51727.976907665499,
                                               51748.085941777055,
                                               51768.196929644677,
                                               51788.309870888836,
                                               51808.42476513017,
                                               51828.541611989524,
                                               51848.660411087905,
                                               51868.781162046515,
                                               51888.90386448674,
                                               51909.028518030143,
                                               51929.155122298485,
                                               51949.283676913685,
                                               51969.414181497872,
                                               51989.546635673345,
                                               52009.681039062583,
                                               52029.817391288263,
                                               52049.955691973213,
                                               52070.095940740481,
                                               52090.238137213273,
                                               52110.382281014987,
                                               52130.5283717692,
                                               52150.676409099666,
                                               52170.826392630333,
                                               52190.97832198532,
                                               52211.132196788931,
                                               52231.288016665654,
                                               52251.445781240145,
                                               52271.60549013727,
                                               52291.76714298204,
                                               52311.930739399664,
                                               52332.096279015546,
                                               52352.263761455244,
                                               52372.433186344519,
                                               52392.604553309284,
                                               52412.777861975665,
                                               52432.953111969946,
                                               52453.130302918595,
                                               52473.309434448267,
                                               52493.490506185793,
                                               52513.67351775818,
                                               52533.858468792605,
                                               52554.045358916446,
                                               52574.234187757254,
                                               52594.42495494274,
                                               52614.617660100812,
                                               52634.812302859558,
                                               52655.008882847229,
                                               52675.20739969227,
                                               52695.407853023295,
                                               52715.610242469098,
                                               52735.814567658657,
                                               52756.02082822111,
                                               52776.229023785803,
                                       