/*
  Helpers.h - Helper classes
  
  Copyright © 2020 - 2025  Davide Perini
  
  Permission is hereby granted, free of charge, to any person obtaining a copy of 
  this software and associated documentation files (the "Software"), to deal
  in the Software without restriction, including without limitation the rights
  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
  copies of the Software, and to permit persons to whom the Software is 
  furnished to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be included in 
  all copies or substantial portions of the Software.
  
  You should have received a copy of the MIT License along with this program.  
  If not, see <https://opensource.org/licenses/MIT/>.
*/

#ifndef _DPSOFTWARE_HELPERS_UTILS_H
#define _DPSOFTWARE_HELPERS_UTILS_H

#include <ArduinoJson.h>
#include "Configuration.h"


extern bool isConfigFileOk;
extern String lastMQTTConnection;
extern String lastWIFiConnection;
extern String lastBoot;

extern bool screenSaverTriggered;

extern bool lastPageScrollTriggered;
extern int yoffset;

extern String haVersion;
extern String firmwareVersion;
extern String MAC;
extern String deviceName;
extern String microcontrollerIP;
extern bool dhcpInUse;
extern int8_t ethd;
extern String qsid;
extern String qpass;
extern String OTApass;
extern String mqttIP;
extern String mqttPort;
extern String mqttuser;
extern String mqttpass;
extern String mqttWillTopic;
extern String mqttWillPayload;
extern int mqttWillQOS;
extern bool mqttWillRetain;
extern bool mqttCleanSession;
extern bool mqttConnected;
extern bool blockingMqtt;
extern String additionalParam;
extern bool ethConnected;

// Blink LED vars
extern unsigned long previousMillis;     // will store last time LED was updated
extern const unsigned long interval;           // interval at which to blink (milliseconds)
extern bool ledTriggered;
extern int blinkCounter;
extern const int blinkTimes; // 6 equals to 3 blink on and 3 off

extern String timedate;
[[maybe_unused]] extern String date;
[[maybe_unused]] extern String currentime;
extern String ERROR;

extern int wifiReconnectAttemp;
extern int mqttReconnectAttemp;
extern bool fastDisconnectionManagement;
extern bool forceWebServer; // if set to true, forces the use of launchWebServerForOTAConfig - added by Pronoe on 02/03/2022

[[maybe_unused]] const int DELAY_10 = 10;
[[maybe_unused]] const int DELAY_50 = 50;
[[maybe_unused]] const int DELAY_200 = 200;
[[maybe_unused]] const int DELAY_500 = 500;
[[maybe_unused]] const int DELAY_1000 = 1000;
[[maybe_unused]] const int DELAY_1500 = 1500;
[[maybe_unused]] const int DELAY_3000 = 3000;
[[maybe_unused]] const int DELAY_2000 = 2000;
[[maybe_unused]] const int DELAY_4000 = 4000;
[[maybe_unused]] const int DELAY_5000 = 5000;

[[maybe_unused]] const String ON_CMD = "ON";
[[maybe_unused]] const String OFF_CMD = "OFF";
[[maybe_unused]] const String on_CMD = "on";
[[maybe_unused]] const String off_CMD = "off";
[[maybe_unused]] const String VALUE = "value";
[[maybe_unused]] const String EMPTY_STR = "";
#if defined(ESP8266)
#define FILE_READ       "r"
#define FILE_WRITE      "w"
#endif

extern bool temporaryDisableImprove;
extern bool improvePacketReceived;

// 'arduino', 45x31px
const unsigned char ARDUINOLOGO[] PROGMEM = {
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x01, 0xe0, 0x00, 0x01, 0xff, 0x80, 0x0f,
        0xfc, 0x40, 0x07, 0xff, 0xe0, 0x3f, 0xff, 0x00, 0x0f, 0xff, 0xf0, 0x7f, 0xff, 0x80, 0x1f, 0x01,
        0xf8, 0xfc, 0x07, 0xc0, 0x1e, 0x00, 0x7d, 0xf0, 0x03, 0xc0, 0x3c, 0x00, 0x3d, 0xe0, 0x01, 0xe0,
        0x38, 0x00, 0x1f, 0xc0, 0xc0, 0xe0, 0x78, 0x00, 0x1f, 0xc0, 0xc0, 0xf0, 0x78, 0x7e, 0x0f, 0x83,
        0xf0, 0xf0, 0x78, 0x7e, 0x0f, 0x83, 0xf0, 0xf0, 0x78, 0x00, 0x0f, 0x80, 0xc0, 0xf0, 0x38, 0x00,
        0x1f, 0xc0, 0xc0, 0xe0, 0x3c, 0x00, 0x3d, 0xe0, 0x01, 0xe0, 0x3e, 0x00, 0x7d, 0xf0, 0x03, 0xe0,
        0x1f, 0x00, 0xf8, 0xf8, 0x07, 0xc0, 0x0f, 0xe7, 0xf0, 0x7f, 0x3f, 0x80, 0x07, 0xff, 0xe0, 0x3f,
        0xff, 0x00, 0x03, 0xff, 0xc0, 0x1f, 0xfe, 0x00, 0x00, 0xff, 0x00, 0x07, 0xf8, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x7b, 0xec, 0x9e, 0xc9, 0xe0,
        0x1c, 0x4b, 0x2c, 0x8c, 0xeb, 0x20, 0x16, 0x5b, 0x3c, 0x8c, 0xea, 0x30, 0x16, 0x73, 0x3c, 0x8c,
        0xfa, 0x30, 0x1e, 0x5b, 0x2c, 0x8c, 0xdb, 0x30, 0x22, 0x4b, 0x6c, 0x8c, 0xd9, 0x60, 0x23, 0x4f,
        0x83, 0x1e, 0xc8, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};
#define ARDUINOLOGOW  45
#define ARDUINOLOGOH  31

// 'home-assistant_big', 44x44px
static const unsigned char HABIGLOGO[] PROGMEM = {
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x80, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xc0, 0x00, 0x00,
        0x00, 0x00, 0x7f, 0xe0, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x01, 0xff, 0xf8,
        0x00, 0x00, 0x00, 0x03, 0xf0, 0xfd, 0xe0, 0x00, 0x00, 0x07, 0xe0, 0x7f, 0xe0, 0x00, 0x00, 0x0f,
        0xcf, 0x3f, 0xe0, 0x00, 0x00, 0x1f, 0xcf, 0x3f, 0xe0, 0x00, 0x00, 0x3f, 0xe6, 0x7f, 0xe0, 0x00,
        0x00, 0x7f, 0xe0, 0x7f, 0xe0, 0x00, 0x00, 0xff, 0xf0, 0xff, 0xf0, 0x00, 0x01, 0xff, 0xf0, 0xff,
        0xf8, 0x00, 0x03, 0xff, 0xf0, 0xff, 0xfc, 0x00, 0x07, 0xf0, 0xf0, 0xf0, 0xfe, 0x00, 0x0f, 0xe0,
        0x70, 0xe0, 0x7f, 0x00, 0x1f, 0xce, 0x70, 0xe7, 0x3f, 0x80, 0x1f, 0xcf, 0x70, 0xef, 0x3f, 0x80,
        0x01, 0xce, 0x70, 0xe7, 0x38, 0x00, 0x01, 0xe0, 0x30, 0xc0, 0x78, 0x00, 0x01, 0xf0, 0x10, 0x80,
        0xf8, 0x00, 0x01, 0xff, 0x00, 0x0f, 0xf8, 0x00, 0x01, 0xff, 0x80, 0x0f, 0xf8, 0x00, 0x01, 0xff,
        0xc0, 0x1f, 0xf8, 0x00, 0x01, 0xff, 0xe0, 0x3f, 0xf8, 0x00, 0x01, 0xff, 0xf0, 0x7f, 0xf8, 0x00,
        0x01, 0xff, 0xf0, 0xff, 0xf8, 0x00, 0x01, 0xff, 0xf0, 0xff, 0xf8, 0x00, 0x01, 0xff, 0xf0, 0xff,
        0xf8, 0x00, 0x01, 0xff, 0xf0, 0xff, 0xf8, 0x00, 0x01, 0xff, 0xf0, 0xff, 0xf8, 0x00, 0x01, 0xff,
        0xf0, 0xff, 0xf8, 0x00, 0x01, 0xff, 0xf0, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};
#define HABIGLOGOW  44
#define HABIGLOGOH  44

class Helpers {

public:
    static void smartPrint(String msg);

    static void smartPrintln(String msg);

    static void smartPrint(int msg);

    static void smartPrintln(int msg);

    void smartDisplay();

    void smartDisplay(int delayTime);

    static String getValue(String data, char separator, int index);

    static String getValue(String string);

    [[maybe_unused]] static long versionNumberToNumber(const String &latestReleaseStr);

    [[maybe_unused]] static char *string2char(String command);

    [[maybe_unused]] static void setDateTime(String timeConst);

    [[maybe_unused]] static String isOnOff(JsonDocument json);

};

#endif

