Подробное описание функционала библиотеки с использованием стандартной терминологии автоматизации (IEC 61131-3), добавил таблицы истинности и временные диаграммы (ASCII-графику), чтобы было максимально наглядно.

---

# Описание функций библиотеки SavaTrig

Библиотека реализует 5 стандартных логических элементов (триггеров), используемых в промышленной автоматике (ПЛК). Все функции оптимизированы для работы в циклическом методе `loop()` Arduino.

---

## 1. RT (R_TRIG) — Детектор переднего фронта
**Rising Edge Trigger**

Выделяет момент перехода сигнала из **0** в **1** (нажатие).
Генерирует импульс `true` длительностью ровно в один программный цикл, когда входной сигнал меняется с низкого уровня на высокий. Если вход остается высоким, выход возвращается в `false`.

**Синтаксис:**
```cpp
bool RT(bool input);
```

**Временная диаграмма:**
```text
Вход (Input):   ____/͞ ͞ ͞ ͞ ͞ ͞ ͞ ͞ ͞ ͞ ͞ ͞ \_________
Выход (RT):     ____|_____________________
                (Импульс 1 цикл)
```

**Применение:**
*   Подсчет количества нажатий кнопки.
*   Запуск процесса один раз при появлении сигнала.
*   Инициализация действий.

---

## 2. FT (F_TRIG) — Детектор заднего фронта
**Falling Edge Trigger**

Выделяет момент перехода сигнала из **1** в **0** (отпускание).
Генерирует импульс `true` длительностью ровно в один программный цикл, когда входной сигнал меняется с высокого уровня на низкий.

**Синтаксис:**
```cpp
bool FT(bool input);
```

**Временная диаграмма:**
```text
Вход (Input):   ____/͞ ͞ ͞ ͞ ͞ ͞ ͞ ͞ ͞ ͞ ͞ \_________
Выход (FT):     ________________|_________
                           (Импульс 1 цикл)
```

**Применение:**
*   Фиксация окончания события.
*   Измерение длительности импульса (в связке с таймером).
*   Действие "по отпусканию" кнопки.

---

## 3. TT (T_TRIG) — Счетный триггер (Переключатель)
**Toggle Flip-Flop**

Меняет состояние выхода на противоположное при каждом **переднем фронте** на входе. Работает как кнопка с фиксацией или импульсное реле.
*   Пришел импульс -> Выход стал `true`.
*   Пришел следующий импульс -> Выход стал `false`.

**Синтаксис:**
```cpp
bool TT(bool input);
```

**Логика работы:**
```text
Нажатие 1:  Вход 0->1  =>  Выход ВКЛ (ON)
Отпускание: Вход 1->0  =>  Выход ВКЛ (ON) - состояние сохраняется
Нажатие 2:  Вход 0->1  =>  Выход ВЫКЛ (OFF)
```

**Применение:**
*   Управление светом одной кнопкой (вкл/выкл).
*   Переключение режимов работы "Старт/Стоп".

---

## 4. RS (RS_TRIG) — Триггер с приоритетом СБРОСА
**Reset Dominant Latch**

Бистабильный триггер (защелка). Запоминает состояние.
Имеет два входа: `SET` (включить) и `RESET` (выключить).
**Особенность:** Если оба входа активны одновременно (`SET=1` и `RESET=1`), приоритет отдается **RESET** (выход будет **0**).

Это "безопасный" триггер. В аварийной ситуации команда "Стоп" важнее команды "Пуск".

**Синтаксис:**
```cpp
bool RS(bool set, bool reset);
```

**Таблица истинности:**
| SET (Вкл) | RESET (Выкл) | **Выход (OUT)** | Примечание |
| :---: | :---: | :---: | :--- |
| 0 | 0 | Сохраняет | Старое состояние |
| 1 | 0 | **1** | Включение |
| 0 | 1 | **0** | Выключение |
| 1 | 1 | **0** | **Приоритет Сброса!** |

**Применение:**
*   Управление моторами, станками, конвейерами.
*   Системы аварийной остановки.

---

## 5. SR (SR_TRIG) — Триггер с приоритетом УСТАНОВКИ
**Set Dominant Latch**

Бистабильный триггер (защелка).
Имеет два входа: `SET` (включить) и `RESET` (выключить).
**Особенность:** Если оба входа активны одновременно (`SET=1` и `RESET=1`), приоритет отдается **SET** (выход будет **1**).

Используется там, где выполнение задачи критичнее, чем сигналы блокировки.

**Синтаксис:**
```cpp
bool SR(bool set, bool reset);
```

**Таблица истинности:**
| SET (Вкл) | RESET (Выкл) | **Выход (OUT)** | Примечание |
| :---: | :---: | :---: | :--- |
| 0 | 0 | Сохраняет | Старое состояние |
| 1 | 0 | **1** | Включение |
| 0 | 1 | **0** | Выключение |
| 1 | 1 | **1** | **Приоритет Установки!** |

**Применение:**
*   Насосные станции (ручной принудительный пуск при ошибке датчиков).
*   Системы пожаротушения.
*   Аварийная сигнализация (нельзя сбросить, пока идет сигнал тревоги).
