/*  Для работы с кнопками установите библиотеку SavaButton https://github.com/sava-74/SavaButton.git
*
* Теория:
* SR-триггер (Set Dominant) — это ячейка памяти с приоритетом ВКЛЮЧЕНИЯ.
* Используется там, где активность процесса важнее сигналов остановки (например, режим ручного тестирования или тревожная сигнализация).
* Если нажать SET — выход включится.
* Если нажать RESET — выход выключится.
* ГЛАВНОЕ: Если нажать ОБЕ КНОПКИ СРАЗУ — выход ВКЛЮЧИТСЯ. Команда "Установить" перекрывает команду "Сброс".
*  Сценарий: Наполнение бака водой.
* Кнопка 12 (Set): Ручная кнопка "Налить воды".
* Кнопка 15 (Reset): Датчик уровня (говорит "Бак полон, стоп").
* Если мы держим кнопку "Налить воды" рукой, насос должен работать, даже если датчик уровня кричит "Стоп" (мы хотим перелить бак или датчик сломался и мы работаем в ручном режиме).
*
*  Пример использования SR-триггера (SavaTrig)
*  Сценарий: Насос с ручным принудительным запуском
*  
*  Логика SR (Set Dominant):
*  - Приоритет всегда у сигнала УСТАНОВКИ (Set).
*  - Если нажаты обе кнопки одновременно -> Насос БУДЕТ РАБОТАТЬ.
*/

#include <SavaButton.h>
#include <SavaTrig.h>

// Настройка кнопок
SavaButton btnManualFill; // Ручная подача (SET)
SavaButton sensorFull;    // Датчик "Бак полон" (RESET)

SavaTrig pumpLogic; // Экземпляр триггера

void setup() {
  Serial.begin(9600);
  
  btnManualFill(12);
  sensorFull(15);
  
  Serial.println("--- Пример запуска SR (установить приоритет) ---");
  Serial.println("Btn 12: ПРИНУДИТЕЛЬНОЕ ЗАПОЛНЕНИЕ (установка) - ПРИОРИТЕТ!");
  Serial.println("Btn 15: ПОЛНЫЙ ДАТЧИК (сброс)");
}

void loop() {
  // 1. Читаем входы
  bool setSignal = btnManualFill.read(); // Хотим включить
  bool resetSignal = sensorFull.read();  // Хотим выключить

  // 2. Обработка логики SR
  // Здесь Set имеет приоритет. Если мы держим кнопку Force,
  // насос будет работать, даже если SensorFull активен.
  bool pumpState = pumpLogic.SR(setSignal, resetSignal);

  // 3. Вывод информации
  Serial.print("Вход [ Приоритет:");
  Serial.print(setSignal);
  Serial.print(" Датчик:");
  Serial.print(resetSignal);
  Serial.print(" ]  --->  Помпа: ");

  if (pumpState) {
    Serial.print("Вкл  (Работа)");
    // Если нажаты обе, поясняем почему работает
    if (setSignal && resetSignal) {
      Serial.print(" <- Установить приоритет (принудительный)!");
    }
    Serial.println();
  } else {
    Serial.println("Выкл. (Хлостой)");
  }

  delay(100);
}