#include <Arduino.h>
#include "SavaOLED_ESP32.h"

// --- НАСТРОЙКИ ---
#define SCREEN_WIDTH 128
#define SCREEN_HEIGHT 64
#define SDA_PIN 5
#define SCL_PIN 4
// Объект дисплея
SavaOLED_ESP32 oled(SCREEN_WIDTH, SCREEN_HEIGHT);

// Битмап мячика
const uint8_t bol_9x9[] = {//мяч
  0x38, 0xee, 0xc2, 0xcb, 0xe1, 0xf3, 0xfe, 0xfe, 0x38, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00
};

const uint8_t ZX_GAME_108x44[] = { //картинка ZX-spectrum
  0xe0, 0xf0, 0x7c, 0xf0, 0xe4, 0xa0, 0x20, 0x70, 0x20, 0x70, 0x24, 0x70, 0x20, 0x00, 0x00, 0x00,
  0x02, 0x20, 0x60, 0x20, 0x00, 0x00, 0x08, 0x00, 0x20, 0x20, 0x24, 0x00, 0x00, 0x04, 0x00, 0x20,
  0x20, 0x20, 0x00, 0x00, 0x00, 0x00, 0x22, 0x20, 0x20, 0x00, 0x00, 0x00, 0x04, 0x20, 0x20, 0x20,
  0x00, 0x00, 0x00, 0x00, 0x20, 0x20, 0x20, 0x08, 0x00, 0x00, 0x00, 0x24, 0x20, 0x20, 0x00, 0x08,
  0x80, 0x00, 0xaa, 0x20, 0x34, 0xd8, 0x40, 0x20, 0xa0, 0x20, 0x40, 0xc0, 0x00, 0x00, 0x00, 0x00,
  0x38, 0xc6, 0x92, 0x39, 0x7d, 0x01, 0x82, 0xc6, 0x38, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00,
  0x00, 0x08, 0x00, 0x00, 0x80, 0xe0, 0x60, 0xb4, 0xc8, 0xe4, 0xf2, 0xf9, 0xff, 0xff, 0x3e, 0x1e,
  0xff, 0x1f, 0x3e, 0x64, 0xc4, 0x84, 0x0e, 0x04, 0x0e, 0x04, 0x0e, 0x04, 0x00, 0x00, 0x00, 0x00,
  0xc4, 0xe4, 0x84, 0xa0, 0x00, 0x20, 0x40, 0x84, 0x04, 0x04, 0x00, 0x00, 0x80, 0x00, 0x04, 0x04,
  0x04, 0x00, 0x20, 0x00, 0x00, 0x04, 0x84, 0x04, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x00,
  0x00, 0x20, 0x00, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x44, 0x21, 0x92, 0x68,
  0x07, 0x18, 0x12, 0x27, 0x2f, 0x20, 0x10, 0x18, 0x07, 0x00, 0x00, 0x00, 0x80, 0x00, 0x80, 0x41,
  0x01, 0xe1, 0x18, 0x48, 0xe4, 0xf4, 0x04, 0x08, 0x18, 0xe0, 0x00, 0x00, 0x80, 0xe0, 0x9c, 0xe6,
  0xfb, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 0xff, 0xff, 0xc9, 0x89, 0xff, 0x89, 0xc9, 0x69,
  0x39, 0x1f, 0x0f, 0x0f, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x01, 0x01, 0x20,
  0x00, 0x00, 0x00, 0x00, 0x02, 0x04, 0x08, 0x12, 0x00, 0x10, 0x00, 0x10, 0x08, 0x00, 0x08, 0x00,
  0x08, 0x04, 0x00, 0x04, 0x02, 0x00, 0x01, 0x00, 0x01, 0x60, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
  0x02, 0x00, 0x02, 0x04, 0x08, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x08, 0x00, 0x48, 0x80,
  0xa4, 0x42, 0x80, 0x02, 0x00, 0xc1, 0x40, 0x21, 0xa0, 0x20, 0x40, 0xc0, 0x00, 0x00, 0x03, 0x02,
  0x04, 0x05, 0x84, 0x02, 0x03, 0x00, 0x00, 0xfc, 0x07, 0xf8, 0xff, 0xff, 0xcf, 0x07, 0x03, 0x03,
  0x01, 0x01, 0x80, 0x00, 0x7f, 0xff, 0xe7, 0xf7, 0x7f, 0x5f, 0x47, 0xe2, 0x42, 0xe2, 0x47, 0xe2,
  0x47, 0x02, 0x07, 0x02, 0x00, 0x40, 0x40, 0x40, 0x02, 0x02, 0x02, 0x00, 0x40, 0x40, 0x40, 0x02,
  0x02, 0x02, 0x00, 0x40, 0x40, 0x40, 0x02, 0x02, 0x02, 0x00, 0x40, 0x40, 0x40, 0x02, 0x02, 0x02,
  0x00, 0x40, 0x40, 0x40, 0x02, 0x02, 0x02, 0x00, 0x40, 0x40, 0x40, 0x02, 0x02, 0x02, 0x00, 0x40,
  0x40, 0x40, 0x02, 0x02, 0x02, 0x00, 0x40, 0x40, 0x40, 0x02, 0x12, 0x0a, 0x24, 0x51, 0x4c, 0x40,
  0x07, 0x18, 0x12, 0x27, 0x2f, 0x20, 0x10, 0x18, 0x07, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x1f, 0xf0, 0x1f, 0xff, 0xff, 0x3f, 0x0f, 0x0e, 0x06, 0x03, 0x01, 0x00, 0x00,
  0xf0, 0xf0, 0x63, 0x60, 0xc0, 0xc0, 0x80, 0x00, 0x00, 0x08, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x1e, 0x3c, 0x0c, 0x08, 0x40, 0x00,
  0x40, 0x00, 0x40, 0x00, 0x80, 0x00, 0x80, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x80, 0x00,
  0x80, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00,
  0x80, 0x00, 0x40, 0x00, 0x40, 0x20, 0x00, 0x70, 0x8c, 0x24, 0x72, 0xfa, 0x02, 0x04, 0x8c, 0x70,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x08,
  0x80, 0x07, 0x1c, 0x70, 0xcc, 0xbc, 0x7e, 0xff, 0xff, 0xfe, 0xf8, 0xf0, 0x0f, 0x0e, 0x0c, 0x0c,
  0x0e, 0x07, 0x03, 0x03, 0x0e, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x06,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x02, 0x02, 0x02, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00,
  0x00, 0x01, 0x06, 0x0d, 0x0b, 0x07, 0x0f, 0x0f
};

uint32_t lastTime = 0;
uint32_t curentTime = 0;
uint8_t curent = 0;
uint8_t schet = 0;
int effect = 1;
int step = 0;
int phase = 0;

// Структура мяча (координаты и скорость умножены на 10 для плавности int)
struct Ball { int x, y, vx, vy; }; 

Ball balls[15];   // Массив мячей
int ballCount = 1; // Текущее кол-во
int hitCount = 0;  // Счетчик ударов

// Границы экрана для мяча 9x9 (умноженные на 10)
// Ширина 128 - 9 = 119 -> 1190
// Высота 64 - 9 = 55 -> 550
const int MAX_X_10 = 1190;
const int MAX_Y_10 = 550;

void curentStep() ;
void efLine();
void efLine2();
void circles();
void efRect();
void efRectR();
void efSinus();
void resetBalls();
void efBall();
void efFill();

void curentStep(){
  if(millis() - curentTime >= 10){
    curentTime = millis();
    curent++;
    if(curent >= 64)curent = 64;
  }
}

void efLine(){
  curentStep();
  oled.clear();
  for(int i = 0, j = 0; i < curent; i+=2, j+=4){
    oled.line(0,0,j,63);
    oled.line(0,0,127,i); 
  }
  if(curent == 64) {
    curent = 0;
    schet = 1; 
    delay(1000);
  }
}

void efLine2(){
  static uint8_t rounds = 0;
  int lim1 = constrain(step, 0, 64);
  int lim2 = constrain(step - 64, 0, 64);
  int lim3 = constrain(step - 128, 0, 128);
  int lim4 = constrain(step - 256, 0, 64);
  int lim5 = constrain(step - 320, 0, 64);

  bool filling = (rounds % 2 == 0);

  int start = 63;
  int end   = 63 + lim1;
  if (!filling) { start = 63 + lim1; end = 127; } 
  
  for (int x = start; x < end; x += 2) {
    oled.line(63, 31, x, 0, INV_AUTO);
  }

  start = 0; 
  end   = lim2;
  if (!filling) { start = lim2; end = 63; }

  for (int y = start; y < end; y += 2) {
    oled.line(63, 31, 127, y, INV_AUTO);
  }

  if (filling) {
     for (int x = 127; x > 127 - lim3; x -= 2) oled.line(63, 31, x, 63, INV_AUTO);
  } else {
     for (int x = 127 - lim3; x > 0; x -= 2)   oled.line(63, 31, x, 63, INV_AUTO);
  }

  if (filling) {
     for (int y = 63; y > 63 - lim4; y -= 2) oled.line(63, 31, 0, y, INV_AUTO);
  } else {
     for (int y = 63 - lim4; y > 0; y -= 2)  oled.line(63, 31, 0, y, INV_AUTO);
  }

  start = 0;
  end   = lim5;

  if (!filling) { start = lim5; end = 63; }

  for (int x = start; x < end; x += 2) {
    oled.line(63, 31, x, 0, INV_AUTO);
  }

  step += 4; // Скорость заливки
  
  if (step > 384) {
    step = 0;
    rounds++;
    if (rounds >= 3) {
      rounds = 0;
      schet = 2;
    }
  }
}

void circles(){
  oled.circle(64, 32, 5, REPLACE, FILL); 

  for (int i = 0; i < 10; i++) {
    int r = (step + i * 10) % 120;
    if (r > 5) oled.circle(64, 32, r, REPLACE, NO_FILL);
    delay(1);
  }

  step += 1;
  if (step > 200) { step = 0; schet = 3; }
}

void efRect(){
  if (phase == 0) {
    for (int i = 0; i <= step; i += 2) {
      oled.rect(i, i, 128 - 2 * i, 64 - 2 * i, REPLACE, NO_FILL);
    }
  }
  else if (phase == 1) {
    for (int i = 0; i <= step; i += 2) {
      oled.rect(i, i, 128 - 2 * i, 64 - 2 * i, INV_AUTO, FILL);
    }
  }

  step += 1;

  if (step >= 32) { 
    step = 0;
    phase++;
    if (phase > 1) { phase = 0; schet = 4; delay(1000);}
  }
}

void efRectR(){
  int r = step;
  oled.rectR(0, 0, 128, 64, r, REPLACE, NO_FILL);        
  oled.rectR(20, 20, 98, 34, r / 2, REPLACE, FILL);      
  step ++; 
  delay(20);
  if (step > 30) {
    step = 0;
    phase++;
      if (phase > 5) { phase = 0; schet = 5; delay(100);}
      }
}

void efSinus(){
    int prevY = 32;
      for (int x = 0; x < 128; x++) {
        // Формула: Y = Центр + Амплитуда * sin(Частота + Фаза)
        // 3 пика вверх и 3 вниз = 3 периода = 3 * 2PI на ширину экрана
        float angle = (x * 0.15) + (step * 0.2); 
        int y = 32 + (int)(25.0 * sin(angle));
        if (x > 0) oled.line(x - 1, prevY, x, y); 
        prevY = y;
      }
      step++;
      if (step > 400) { step = 0; schet = 6; resetBalls(); }
}

void resetBalls(){
  ballCount = 1;
  hitCount = 0;

  int vx = random(18, 25); 
  int vy = random(16, 20);

  if (random(0, 2)) vx = -vx;
  if (random(0, 2)) vy = -vy;

  balls[0] = {595, 275, vx, vy}; 
}

void efBall(){
  bool hitFrame = false; 

  for (int i = 0; i < ballCount; i++) {
    balls[i].x += balls[i].vx;
    balls[i].y += balls[i].vy;
    if (balls[i].x >= MAX_X_10 || balls[i].x < 0) {
      balls[i].vx = -balls[i].vx; 
      hitFrame = true;            
    }
    if (balls[i].y >= MAX_Y_10 || balls[i].y < 0) {
      balls[i].vy = -balls[i].vy; 
      hitFrame = true;            
    }
    oled.drawBitmap(balls[i].x / 10, balls[i].y / 10, bol_9x9, 9, 9);
  }

  if (hitFrame) {
    hitCount++;
    if (hitCount >= ballCount) {
      hitCount = 0;
      
      if (ballCount < 15) {
         // Базовая скорость немного растет с количеством (от 4 до 7)
         int baseSpeed = 4 + (ballCount / 4); 
         
         int newVx = baseSpeed + random(10, 25); 
         int newVy = baseSpeed + random(12, 20);
         
         if (random(0, 2)) newVx = -newVx;
         if (random(0, 2)) newVy = -newVy;

         balls[ballCount] = {595, 275, newVx, newVy};
         ballCount++;
      } else {
         schet = 7; 
         phase = 0; step = 0; 
         resetBalls();        
      }
    }
  }  
}

void efFill() {
  static uint8_t pilotPattern = 51;
  static int loadY = 0;
  static uint8_t loadTimer = 0;
  static uint8_t pilotTimer = 0;

  // --- Фаза 0: Вспышка ---
  if (phase == 0) {
    oled.fillScreen(0xFF);
    if (step > 10) {
      step = 0; phase++;
      pilotPattern = 51;
    }
  }
  // --- Фаза 1: Пилот-тон ---
  else if (phase == 1) {
    pilotTimer++;
    if (pilotTimer > 4) { 
       pilotPattern = (pilotPattern << 1) | (pilotPattern >> 7);
       pilotTimer = 0;
    }
    
    oled.fillScreen(pilotPattern);
    oled.rect(10, 10, 108, 44, REPLACE, FILL);

    if (step > 200) {
      step = 0; phase++;
      loadY = 0; loadTimer = 0;
    }
  }
  // --- Фаза 2: Шум + Загрузка ---
  else if (phase == 2) {
    oled.fillScreen(random(1, 255));
    oled.rect(10, 10, 108, 44, REPLACE, FILL);
    oled.drawBitmap(10, 10, ZX_GAME_108x44, 108, 44, REPLACE);

    if (loadY < 44) {
      oled.rect(10, 10 + loadY, 108, 44 - loadY, REPLACE, FILL);
      loadTimer++;
      if (loadTimer >= 10) {
        loadY += 2;
        loadTimer = 0;
      }
    } else {
      step = 0; phase++;
    }
  }
  // --- Фаза 3: Финал ---
  else if (phase == 3) {
    oled.drawBitmap(10, 10, ZX_GAME_108x44, 108, 44, REPLACE);
    oled.rect(10, 10, 108, 44, ADD_UP, NO_FILL);

    step++;
    if (step > 340) {
      step = 0; phase = 0;
      schet = 0; // На начало демо
    }
  }
  step++;
}

void setup() {
 Serial.begin(115200);
 //oled.init(); // Инициализация по умолчанию: 400000 (400 кГц), sda = 21, scl = 22
 oled.init(1200000, SDA_PIN, SCL_PIN); // Инициализация
 randomSeed(analogRead(0));
}

void loop() {
  if (millis() - lastTime >= 10) { 
    lastTime = millis();
    oled.clear();
    switch (schet) {
    case 0 : efLine(); break;
    case 1 : efLine2(); break;
    case 2 : circles(); break;
    case 3 : efRect(); break;
    case 4 : efRectR(); break;
    case 5 : efSinus(); break;
    case 6 : efBall(); break;
    case 7 : efFill(); break; 
    }
    oled.display();
  }  
}
