/**
 * @file 11_Effect_BreathingRainbow.ino
 * @brief Пример использования встроенного эффекта "Дышащая Радуга".
 * 
 * Этот скетч демонстрирует эффект, где вся лента целиком плавно
 * меняет свой цвет, проходя через весь спектр радуги. Это достигается
 * с помощью всего одной функции - breathingRainbow().
 * 
 * Эффект:
 * Вся лента плавно переливается: Красный -> Оранжевый -> ... -> Синий -> Фиолетовый -> Красный.
 * 
 * АРХИТЕКТУРА:
 * Как и другие встроенные эффекты, эта функция является неблокирующей.
 * Вы просто вызываете её в loop(), а библиотека сама управляет временем
 * и обновлением ленты, не "замораживая" основной цикл.
 * 
 * =========================================================================
 *                   Функция breathingRainbow(speed)
 * =========================================================================
 * 
 *   void breathingRainbow(uint16_t speed);
 * 
 *   - speed: Управляет скоростью смены цветов.
 *     - 1: Очень медленно.
 *     - 255: Очень быстро.
 *     - 0: Эффект останавливается (пауза).
 * 
 * =========================================================================
 */

#include <SavaLED_ESP32.h>

// --- Конфигурация ---
#define LED_PIN    14
#define NUM_LEDS   100
#define BRIGHTNESS 200

SavaLED_ESP32 strip;

void setup() {
  Serial.begin(115200);
  Serial.println("\nПример 11: Встроенный эффект 'Дышащая Радуга'");

  if (!strip.begin(NUM_LEDS, LED_PIN)) {
    Serial.println("Ошибка инициализации!");
    while (true);
  }
  
  strip.setBrightness(BRIGHTNESS);
}

void loop() {
  // Просто вызываем эту функцию в цикле.
  // Попробуйте изменить значение скорости, чтобы увидеть разницу.
  if (strip.canShow()) {
    // 1. Готовим кадр.
    strip.breathingRainbow(200);
    // 2. Показываем его.
    strip.show();
  }
  // Ваш другой код может выполняться здесь...
}