/**
 * @file 10_Effect_RainbowCycle.ino
 * @brief Пример использования встроенного эффекта "Бегущая Радуга".
 * 
 * Этот скетч показывает, как легко запустить сложную анимацию с помощью
 * всего одной функции - rainbowCycle(). Библиотека сама берет на себя
 * управление временем, отрисовку кадра и отправку данных на ленту.
 * 
 * Эффект:
 * Плавный градиент всех цветов радуги непрерывно движется вдоль ленты,
 * создавая классический и очень популярный эффект.
 * 
 * АРХИТЕКТУРА:
 * Встроенные эффекты инкапсулируют всю логику. Вам нужно просто вызывать
 * соответствующую функцию в каждой итерации loop(). Библиотека сама
 * использует неблокирующие таймеры и проверку canShow() "под капотом",
 * поэтому ваш loop() остается полностью свободным.
 * 
 * =========================================================================
 *                      Функция rainbowCycle(speed)
 * =========================================================================
 * 
 *   void rainbowCycle(uint16_t speed);
 * 
 *   - speed: Управляет скоростью движения радуги.
 *     - 1: Очень медленно.
 *     - 255: Очень быстро.
 *     - 0: Эффект останавливается (пауза).
 * 
 * Просто вызывайте эту функцию в loop(), и библиотека сделает всё остальное.
 * =========================================================================
 */

#include <SavaLED_ESP32.h>

// --- Конфигурация ---
#define LED_PIN    14
#define NUM_LEDS   100
#define BRIGHTNESS 255
#define BRIG_1 55

SavaLED_ESP32 strip;

void setup() {
  Serial.begin(115200);
  Serial.println("\nПример 10: Встроенный эффект 'Бегущая Радуга'");

  if (!strip.begin(NUM_LEDS, LED_PIN)) {
    Serial.println("Ошибка инициализации!");
    while (true);
  }
  
  strip.setBrightness(BRIGHTNESS);
}

void loop() {
  // Всё, что нужно сделать - это вызвать эту функцию в цикле.
  // Попробуйте изменить значение скорости от 1 до 255.

  if (strip.canShow()) {
    strip.rainbowCycle(50, 50, true, 230, BRIG_1);
    // Радуга от начала (пиксель 0) на 50 пикселей вперед
    strip.rainbowCycle(50, 50, false, 230);

    // Встречная радуга от конца (пиксель 99) на 50 пикселей назад
    //strip.rainbowCycle(99, 50, true, 230);
    
    strip.show();
  }


  // Здесь может быть ваш другой код. Он будет выполняться, 
  // не мешая плавной анимации.
}