**SavaLED_ESP32 - Высокопроизводительная библиотека для ESP32**

**Версия: 2.1.0**

**Автор: SavaLab** 

## Описание:
 * **SavaLED_ESP32** — это мощная, эффективная и полностью неблокирующая библиотека для платформы ESP32 (в среде Arduino IDE), предназначенная для управления адресными светодиодами (WS2812, SK6812 и совместимыми).
* **Библиотека разработана с нуля для проектов**, требующих максимальной производительности и отзывчивости. Благодаря использованию аппаратного модуля RMT и асинхронной архитектуры, 
* **SavaLED_ESP32 не останавливает выполнение основного цикла (loop())**, что делает ее идеальным выбором для сложных задач, таких как аудиовизуализаторы, интерактивные инсталляции, 
* **IoT-устройства** с сетевым управлением и любые проекты, где задержки недопустимы.

## Ключевые особенности:
* **Полностью неблокирующая:** Вся логика, включая сложные встроенные эффекты, работает по асинхронному принципу, не "замораживая" loop().
* **Высокая производительность:** Использует аппаратный RMT-модуль ESP32 для генерации идеально стабильного сигнала, достигая максимально возможной частоты обновления ленты.
* **Гибкие встроенные эффекты:** Включает готовые к использованию, настраиваемые эффекты ("Радуга", "Кометы" и др.), которые можно комбинировать и применять к отдельным сегментам ленты.
* **Удобное управление цветом:** Поддерживает как RGB, так и интуитивно понятную модель HSV. Содержит богатую палитру из 24 предопределенных цветовых констант и функции для тонкого управления яркостью.
* **Визуальное качество:** Встроенная, оптимизированная гамма-коррекция обеспечивает более плавные и естественные градиенты и переходы яркости.
* **Профессиональная архитектура:** API спроектирован так, чтобы способствовать написанию чистого, эффективного и масштабируемого кода.

## Установка:
* Скачайте эту библиотеку в виде ZIP-архива.
* В Arduino IDE выберите Скетч -> Подключить библиотеку -> Добавить .ZIP библиотеку....
* Выберите скачанный ZIP-файл. Библиотека будет установлена.
* Примеры будут доступны в меню Файл -> Примеры -> SavaLED_ESP32.
* **Архитектура правильного loop()**
* Чтобы достичь максимальной производительности и плавности, вся работа с лентой должна строиться по единому принципу "Синхронизация кадра".

## код C++:

```bash
void loop() {
  // Выполняем расчеты и отрисовку ТОЛЬКО тогда, 
  // когда лента физически готова принять новый кадр.
  if (strip.canShow()) {
    
    // 1. ПОДГОТОВКА в исключительных случаях если есть проблемы с наложение эфектов:
    // При отчсутствии проблем не использовать. Рисуем фон (например, очищаем ленту).
    // Это гарантирует отсутствие "фантомных" пикселей от прошлого кадра.
    strip.clear(); 
    
    // 2. РИСОВАНИЕ: Вызываем функции эффектов или setPixel/fill.
    // Здесь можно комбинировать несколько вызовов для создания сложной сцены.
    strip.rainbowCycle(0, 50, false, 50, 200);
    strip.setPixel(75, WHITE);
    
    // 3. ОТОБРАЖЕНИЕ: Отправляем готовый кадр на ленту.
    strip.show();
  }
  
  // Здесь может быть любой другой ваш код (работа с датчиками, сетью и т.д.)
}
```
* Этот паттерн — ключ к стабильной и эффективной работе со всеми функциями библиотеки.

## API Справочник :

* **bool begin(uint16_t numLeds, int pin)** Инициализирует библиотеку. Вызывается один раз в setup()

* **void show()** Инициирует асинхронную отправкуданных из буфера на ленту.

* **bool canShow()** Ключевая функция! Проверяет, свободен ли RMT-модуль. Возвращает true, если можно рисовать и отправлять новый кадр

* **void setBrightness(uint8_t brightness)** Устанавливает глобальную яркость для всей ленты (0-255). Применяется как финальный модификатор ко всем цветам в момент вызова show()

* **uint16_t getNumLeds()** Возвращает количество светодиодов в ленте

## Палитры цветов
Таблица предопределенных цветов (RGB)
## 🌈 Основные Цветовые Константы

| Категория | Название | HEX Код | Пример |
| :--- | :--- | :--- | :--- |
| **Основные (яркие)** | RED | `0xFF0000` | 🔴 Красный |
| | LIME | `0x00FF00` | 🟢 Лайм |
| | BLUE | `0x0000FF` | 🔵 Синий |
| **Вторичные (яркие)** | YELLOW | `0xFFFF00` | 🟡 Желтый |
| | CYAN | `0x00FFFF` | 💧 Голубой (Циан) |
| | MAGENTA | `0xFF00FF` | 🟣 Пурпурный (Маджента) |
| **Теплые оттенки** | ORANGE | `0xFF7F00` | 🟠 Оранжевый |
| | GOLD | `0xFFD700` | ✨ Золотой |
| | CRIMSON | `0xDC143C` | 🩸 Малиновый |
| | PINK | `0xFF69B4` | 🌸 Розовый |
| | BROWN | `0xA52A2A` | 🟤 Коричневый |
| | MAROON | `0x800000` | 🍷 Бордовый |
| **Холодные оттенки** | GREEN | `0x008000` | 🌿 Зеленый (Лесной) |
| | OLIVE | `0x808000` | 🫒 Оливковый |
| | TEAL | `0x008080` | 🌊 Бирюзовый |
| | SKYBLUE | `0x87CEEB` | ☁️ Небесно-голубой |
| | NAVY | `0x000080` | 🌃 Темно-синий |
| | INDIGO | `0x4B0082` | 🫐 Индиго |
| | PURPLE | `0x800080` | 🔮 Пурпурный/Лиловый |
| | VIOLET | `0xEE82EE` | 💜 Фиалковый |
| **Оттенки серого** | WHITE | `0xFFFFFF` | ⚪ Белый |
| | SILVER | `0xC0C0C0` | 🪙 Серебряный |
| | GRAY | `0x808080` | 🔘 Серый |
| | BLACK | `0x000000` | ⚫ Черный (Выключено) |

## Таблица HSV (Тон/Hue)
### HUE	Цвет (при S=255, V=255)
* 0	Красный
*	42	Желтый
*	85	Зеленый (Лайм)
*	127	Голубой (Циан)
*	170	Синий
*	212	Пурпурный (Маджента)
*	255	Красный (цикл)

## Функции рисования:
| функция | Описание |
| :--- | :--- |
|void setPixel(uint16_t n, uint8_t r, uint8_t g, uint8_t b)|Устанавливает цвет одного пикселя по RGB компонентам|
|void setPixel(uint16_t n, uint32_t color)|Устанавливает цвет одного пикселя из "упакованного" 32-битного значения (например, RED)|
|void setPixelColor(uint16_t n, uint32_t color, uint8_t brightness)|Устанавливает цвет пикселя, применяя к нему индивидуальную яркость|
|void setPixelHSV(uint16_t n, uint8_t h, uint8_t s, uint8_t v)|Устанавливает цвет пикселя по HSV (Тон, Насыщенность, Яркость)|
|void clear()|Быстро очищает весь буфер (заполняет черным цветом)|
|void fill(uint32_t color)|Заливает всю ленту одним цветом|
|void fillColor(uint32_t color, uint8_t brightness)|Заливает всю ленту цветом с применением указанной яркости|
|void fillHSV(uint8_t h, uint8_t s, uint8_t v)|Заливает всю ленту цветом, заданным в HSV|
|void rainbowStatic(...)|Рисует статичный градиент|
||**Версия 1 (Радуга): rainbowStatic(start, num, reversed, brightness, start_hue)**|
||**Версия 2 (Между тонами): rainbowStatic(start, num, reversed, brightness, start_hue, end_hue)**|

## Встроенные динамические эффекты
* **Важно: Все эти функции должны вызываться внутри if (strip.canShow()), непосредственно перед strip.show().**

| Функция|Описание|
| :--- | :---|
|void rainbowCycle(...)|Создает эффект "бегущей радуги"|
||**Простая версия: rainbowCycle(speed, brightness)**|
||**Расширенная версия: rainbowCycle(start, num, reversed, speed, brightness)**|
|void breathingRainbow(uint16_t speed, uint8_t brightness = 255)|Вся лента плавно переливается всеми цветами спектра|
|void runCometsEffect(...)|Запускает сложный эффект "Кометы"|

```bash
void runCometsEffect(
  uint8_t num_comets, 
  uint8_t tail_length, 
  const uint32_t palette[], 
  int palette_size, 
  uint32_t background_color = BLACK, 
  uint16_t spawn_interval_ms = 1500
);
```
* **Пример использования:**
```bash
const uint32_t my_palette[] = { GOLD, CYAN };

void loop() {
  if (strip.canShow()) {
    // Эта функция сама рисует фон, поэтому strip.clear() не нужен
    strip.runCometsEffect(3, 15, my_palette, 2);
    strip.show();
  }
}
```
## Прочее
|Функция|Описание|
|:---|:---|
|uint32_t Color(uint8_t r, uint8_t g, uint8_t b)|**Вспомогательная функция для создания 32-битного значения цвета**|
|void setGammaCorrection(bool enabled)|**Включает (true) или выключает (false) гамма-коррекцию. По умолчанию включена**|

<details>
  <summary>Показать Таблицу Цветовых Констант</summary>

  <table width="100%">
    <thead>
      <tr>
        <th width="25%">Категория Цветов</th>
        <th width="20%">Название</th>
        <th width="20%">HEX Код</th>
        <th width="35%">Пример</th>
      </tr>
    </thead>
    <tbody>
      <tr><td rowspan="3"><b>RGB Основные (насыщенные)</b></td><td>RED</td><td><code>0xFF0000</code></td><td>🔴 Красный</td></tr>
      <tr><td>LIME</td><td><code>0x00FF00</code></td><td>🟢 Лайм</td></tr>
      <tr><td>BLUE</td><td><code>0x0000FF</code></td><td>🔵 Синий</td></tr>
      <tr><td rowspan="3"><b>RGB Вторичные (комбинированные)</b></td><td>YELLOW</td><td><code>0xFFFF00</code></td><td>🟡 Желтый</td></tr>
      <tr><td>CYAN</td><td><code>0x00FFFF</code></td><td>💧 Голубой (Циан)</td></tr>
      <tr><td>MAGENTA</td><td><code>0xFF00FF</code></td><td>🟣 Пурпурный (Маджента)</td></tr>
      <tr><td rowspan="6"><b>Теплые оттенки</b></td><td>ORANGE</td><td><code>0xFF7F00</code></td><td>🟠 Оранжевый</td></tr>
      <tr><td>GOLD</td><td><code>0xFFD700</code></td><td>✨ Золотой</td></tr>
      <tr><td>CRIMSON</td><td><code>0xDC143C</code></td><td>🩸 Малиновый</td></tr>
      <tr><td>PINK</td><td><code>0xFF69B4</code></td><td>🌸 Розовый</td></tr>
      <tr><td>BROWN</td><td><code>0xA52A2A</code></td><td>🟤 Коричневый</td></tr>
      <tr><td>MAROON</td><td><code>0x800000</code></td><td>🍷 Бордовый</td></tr>
      <tr><td rowspan="8"><b>Холодные оттенки</b></td><td>GREEN</td><td><code>0x008000</code></td><td>🌿 Зеленый (Лесной)</td></tr>
      <tr><td>OLIVE</td><td><code>0x808000</code></td><td>🫒 Оливковый</td></tr>
      <tr><td>TEAL</td><td><code>0x008080</code></td><td>🌊 Бирюзовый</td></tr>
      <tr><td>SKYBLUE</td><td><code>0x87CEEB</code></td><td>☁️ Небесно-голубой</td></tr>
      <tr><td>NAVY</td><td><code>0x000080</code></td><td>🌃 Темно-синий</td></tr>
      <tr><td>INDIGO</td><td><code>0x4B0082</code></td><td>🫐 Индиго</td></tr>
      <tr><td>PURPLE</td><td><code>0x800080</code></td><td>🔮 Пурпурный/Лиловый</td></tr>
      <tr><td>VIOLET</td><td><code>0xEE82EE</code></td><td>💜 Фиалковый</td></tr>
      <tr><td rowspan="4"><b>Оттенки серого</b></td><td>WHITE</td><td><code>0xFFFFFF</code></td><td>⚪ Белый</td></tr>
      <tr><td>SILVER</td><td><code>0xC0C0C0</code></td><td>🪙 Серебряный</td></tr>
      <tr><td>GRAY</td><td><code>0x808080</code></td><td>🔘 Серый</td></tr>
      <tr><td>BLACK</td><td><code>0x000000</code></td><td>⚫ Черный (Выключено)</td></tr>
    </tbody>
  </table>
</details>
