
# SavaButton Library

**Автор:** SavaLab (<sava-74@inbox.ru>)

**Версия:** 1.0.0

**Версия:** 1.0.1

**Версия:** 1.0.2

**Версия:** 2.0.0 (измененён API)

**Версия:** 2.0.1 (добавлен параметр repeat в readSmart)

Легкая, эффективная и многофункциональная библиотека для работы с тактовыми кнопками на платформе Arduino.
Библиотека решает проблему дребезга контактов (Debounce) программным методом и предоставляет удобный интерфейс для обработки событий: клик, удержание, двойной клик и авто-повтор.

---

## Основные возможности

* **Минимальное потребление памяти:** Использует одну статику для времени антидребезга на все кнопки.
* **Универсальность подключения:** Поддержка схем с подтяжкой к питанию (`PLUS`/`INPUT_PULLUP`) и к земле (`MINUS`/`INPUT_PULLDOWN`).
* **Простой режим:** Определение нажатия и отпускания (возвращает `bool`).
* **Событийный режим:** Определение короткого клика (`CLICK`) и долгого нажатия (`LONG`).
* **Умный режим (Smart):** Поддержка **Двойного клика** и **Прогрессивного авто-повтора** (ускорение при удержании).

---

## Миграция с версий 1.x на 2.0.0

**Версия 2.0.0 изменила API для упрощения использования библиотеки.**

### Что изменилось

#### `readLong()` - убран аргумент

**Старый код (v1.x):**

```cpp
uint8_t event = btn.readLong(800);  // Время передавалось каждый раз
```

**Новый код (v2.0.0):**

```cpp
// В setup()
btn.setLong(800);  // Настройка один раз

// В loop()
uint8_t event = btn.readLong();  // БЕЗ аргумента!
```

#### `readSmart()` - убраны все аргументы

**Старый код (v1.x):**

```cpp
uint8_t event = btn.readSmart(SM_DOUBLE, SM_PROG, 600, 250);  // Передавалось каждый раз
```

**Новый код (v2.0.0):**

```cpp
// В setup()
btn.setSmart(SM_DOUBLE, SM_PROG, 600, 250);  // Настройка один раз

// В loop()
uint8_t event = btn.readSmart();  // БЕЗ аргументов!
```

### Преимущества нового подхода

* **Чище код** - не нужно повторять параметры в каждом вызове
* **Меньше ошибок** - настройка в одном месте
* **Гибкость** - можно изменить параметры в runtime через setter'ы
* **Обратная совместимость** - все параметры имеют значения по умолчанию

### Значения по умолчанию

* `setLong()` - 600 мс
* `setSmart()` - SM_CLICK, SM_REPEAT, 600 мс, 250 мс

Если значения по умолчанию вас устраивают - можно вообще не вызывать setter'ы!

---

## Установка и Подключение

1. Скачайте библиотеку.
2. Распакуйте в папку `libraries` вашей Arduino IDE.
3. Подключите в скетче:

    ```cpp
    #include "SavaButton.h"
    ```

---

## Инициализация

Библиотека использует двухэтапную инициализацию, чтобы корректно работать с аппаратной частью контроллера.

### 1. Создание объекта

Создайте экземпляр класса глобально (перед `void setup()`). Конструктор не принимает аргументов.

```cpp
SavaButton myBtn;
```

### 2. Настройка в setup()

Внутри функции `setup()` вызовите объект как функцию, передав номер пина и режим подключения.

```cpp
void setup() {
    // Синтаксис: myBtn(pin, mode);

    myBtn(2);          // Пин 2, режим PLUS (по умолчанию)
    myBtn(3, MINUS);   // Пин 3, режим MINUS

    // Настройка параметров (опционально)
    myBtn.setLong(800);  // Время долгого нажатия для readLong()
}
```

**Режимы подключения (`mode`):**

* **`PLUS`** (по умолчанию) — Использует внутреннюю подтяжку (`INPUT_PULLUP`), подтягивающий к плюсу **+VCC**. Кнопка замыкается на **GND**. Библиотека сама инвертирует сигнал (нажатие = `true`).
* **`MINUS`** — Использует внутреннюю подтяжку (`INPUT_DOWN`), стягивающий к земле **GND**. Кнопка замыкается на **+5V/VCC**. (нажатие = `true`).
* **`INPUT`** — Обычный высокоимпедансный вход.

---

## Настройка времени (Глобально)

### `static void bounceTime(uint8_t ms)`

Устанавливает время подавления дребезга (антидребезг).

* **Важно:** Это значение устанавливается **одно для всех кнопок** в проекте для экономии памяти.

* **ms**: Время в миллисекундах (по умолчанию 40 мс).

```cpp
// Пример: Установить 50 мс для всех кнопок
SavaButton::bounceTime(50);
```

---

## Функции чтения

### 1. Базовое чтение

#### `bool read()`

Возвращает текущее состояние кнопки с учетом антидребезга.

* **Возвращает:** `true` — кнопка нажата и удерживается, `false` — отпущена.
* Подходит для простых действий (например, пока держим — горит диод).

---

### 2. Детектор Клика и Удержания

#### `uint8_t readLong()`

Простой обработчик событий. Различает короткое нажатие и удержание.

* **Возвращает коды событий:**

  * `BTN_NONE` (0) — Нет событий.
  * `BTN_CLICK` (1) — Был короткий клик (срабатывает при отпускании).
  * `BTN_LONG` (2) — Кнопка удерживается дольше установленного времени (срабатывает один раз по таймеру).

**Настройка времени:**

```cpp
myBtn.setLong(1000);  // Установить 1000 мс для долгого нажатия (по умолчанию 600)
```

**Использование:**

```cpp
uint8_t state = myBtn.readLong();  // БЕЗ аргументов!
```

---

### 3. Умный режим (Smart)

#### `uint8_t readSmart(bool repeat = true)`

Продвинутый обработчик, поддерживающий двойные клики и авто-повтор значений (например, для настройки меню).

**Параметр `repeat`** (опционально, по умолчанию `true`):

* `true` — использует настройки из `setSmart()` (стандартное поведение)
* `false` — временно отключает авто-повтор. При коротком нажатии возвращает `BTN_CLICK`, при удержании возвращает `BTN_NONE` (ничего)

**Возвращает коды событий:**

* `BTN_NONE` (0) — Нет событий.
* `BTN_CLICK` (1) — Одиночный клик (или шаг авто-повтора при удержании).
* `BTN_LONG` (2) — Долгое нажатие (возвращается только если `repMode == SM_REP_NONE`).
* `BTN_DOUBLE` (3) — Двойной клик.

**Настройка параметров:**

```cpp
myBtn.setSmart(clickMode, repMode, longMs, doubleMs);
```

**Параметры `setSmart()`:**

1. **`clickMode`** — Тип обработки кликов:
    * `SM_CLICK` — Обычный клик (срабатывает сразу при отпускании). *По умолчанию.*
    * `SM_DOUBLE` — Ожидание двойного клика (вносит небольшую задержку реакции на одиночный клик).
2. **`repMode`** — Тип авто-повтора при удержании:
    * `SM_REP_NONE` — Без повтора (возвращается `BTN_LONG`).
    * `SM_REPEAT` — Простой повтор с постоянной скоростью (возвращается `BTN_CLICK` многократно). *По умолчанию.*
    * `SM_PROG` — Прогрессивный повтор с ускорением (возвращается `BTN_CLICK` многократно).
3. **`longMs`** — Время старта удержания (мс) / Базовая скорость повтора. *По умолчанию: 600.*
4. **`doubleMs`** — Время ожидания второго нажатия для двойного клика. *По умолчанию: 250.*

**Важно:** Если включен авто-повтор (`SM_REPEAT` или `SM_PROG`), то при удержании кнопки многократно возвращается `BTN_CLICK` вместо `BTN_LONG` и `BTN_REPEAT`. Это упрощает код - одно и то же действие обрабатывается одинаково для одиночного клика и повтора.

**Логика прогрессивного повтора (`SM_PROG`):**

* Шаги 0-5: Скорость равна `longMs` (медленно).
* Шаги 6-15: Скорость **200 мс** (быстрее).
* Шаги 16+: Скорость **50 мс** (очень быстро).

**Примеры использования:**

```cpp
// Кнопка OK (с долгим нажатием, без повтора)
btn_ok.setSmart(SM_DOUBLE, SM_REP_NONE);

if (event == BTN_CLICK)  { /* подтверждение */ }
if (event == BTN_DOUBLE) { /* быстрое подтверждение */ }
if (event == BTN_LONG)   { /* отмена/назад */ }

// Кнопка +/- (с авто-повтором, без долгого нажатия)
btn_plus.setSmart(SM_CLICK, SM_PROG);

if (event == BTN_CLICK) {
    value++;  // Работает и для одиночного клика, и для повтора!
}

// Кнопка изменения значения (с двойным кликом для сброса)
btn_value.setSmart(SM_DOUBLE, SM_PROG);

if (event == BTN_CLICK)  { value++; }
if (event == BTN_DOUBLE) { value = 0; }  // Сброс
```

---

## Константы событий

| Константа | Код | Описание |
| :--- | :---: | :--- |
| `BTN_NONE` | 0 | Событий нет |
| `BTN_CLICK` | 1 | Одиночный клик (также используется для авто-повтора) |
| `BTN_LONG` | 2 | Долгое нажатие (только если `SM_REP_NONE`) |
| `BTN_DOUBLE` | 3 | Двойной клик |
| `BTN_REPEAT` | 4 | ~~Устарело~~ (теперь используется `BTN_CLICK`) |

---

## Пример использования

```cpp
#include "SavaButton.h"

SavaButton btn_value;
int value = 0;

void setup() {
  Serial.begin(9600);

  // Инициализация пина 2
  btn_value(2);

  // Настройка: двойной клик для сброса + прогрессивный авто-повтор
  btn_value.setSmart(SM_DOUBLE, SM_PROG);
}

void loop() {
  uint8_t event = btn_value.readSmart();  //аргумент по умолчанию`true` 
                                          // — использует настройки из `setSmart()` (стандартное поведение)

  if (event == BTN_CLICK) {
    value++;  // Работает и для одиночного клика, и для повтора!
    Serial.print("Value: ");
    Serial.println(value);
  }

  if (event == BTN_DOUBLE) {
    value = 0;  // Сброс двойным кликом
    Serial.println("Reset!");
  }
}
```
