***

# SavaButton Library

**Автор:** SavaLab (<sava-74@inbox.ru>)  
**Версия:** 1.0.0

Легкая, эффективная и многофункциональная библиотека для работы с тактовыми кнопками на платформе Arduino. 
Библиотека решает проблему дребезга контактов (Debounce) программным методом и предоставляет удобный интерфейс для обработки событий: клик, удержание, двойной клик и авто-повтор.

---

## Основные возможности

*   **Минимальное потребление памяти:** Использует одну статику для времени антидребезга на все кнопки.
*   **Универсальность подключения:** Поддержка схем с подтяжкой к питанию (`PLUS`/`INPUT_PULLUP`) и к земле (`MINUS`/`INPUT_PULLDOWN`).
*   **Простой режим:** Определение нажатия и отпускания (возвращает `bool`).
*   **Событийный режим:** Определение короткого клика (`CLICK`) и долгого нажатия (`LONG`).
*   **Умный режим (Smart):** Поддержка **Двойного клика** и **Прогрессивного авто-повтора** (ускорение при удержании).

---

## Установка и Подключение

1.  Скачайте библиотеку.
2.  Распакуйте в папку `libraries` вашей Arduino IDE.
3.  Подключите в скетче:
    ```cpp
    #include "SavaButton.h"
    ```

---

## Инициализация

Библиотека использует двухэтапную инициализацию, чтобы корректно работать с аппаратной частью контроллера.

### 1. Создание объекта
Создайте экземпляр класса глобально (перед `void setup()`). Конструктор не принимает аргументов.

```cpp
SavaButton myBtn;
```

### 2. Настройка в setup()
Внутри функции `setup()` вызовите объект как функцию, передав номер пина и режим подключения.

```cpp
void setup() {
    // Синтаксис: myBtn(pin, mode);
    
    myBtn(2);          // Пин 2, режим PLUS (по умолчанию)
    myBtn(3, MINUS);   // Пин 3, режим MINUS
}
```

**Режимы подключения (`mode`):**
*   **`PLUS`** (по умолчанию) — Использует внутреннюю подтяжку (`INPUT_PULLUP`), подтягивающий к плюсу **+VCC**. Кнопка замыкается на **GND**. Библиотека сама инвертирует сигнал (нажатие = `true`).
*   **`MINUS`** — Использует внутреннюю подтяжку (`INPUT_DOWN`), стягивающий к земле **GND**. Кнопка замыкается на **+5V/VCC**. (нажатие = `true`).
*   **`INPUT`** — Обычный высокоимпедансный вход.

---

## Настройка времени (Глобально)

### `static void bounceTime(uint8_t ms)`
Устанавливает время подавления дребезга (антидребезг).
*   **Важно:** Это значение устанавливается **одно для всех кнопок** в проекте для экономии памяти.
*   **ms**: Время в миллисекундах (по умолчанию 40 мс).

```cpp
// Пример: Установить 50 мс для всех кнопок
SavaButton::bounceTime(50);
```

---

## Функции чтения

### 1. Базовое чтение
#### `bool read()`
Возвращает текущее состояние кнопки с учетом антидребезга.
*   **Возвращает:** `true` — кнопка нажата и удерживается, `false` — отпущена.
*   Подходит для простых действий (например, пока держим — горит диод).

---

### 2. Детектор Клика и Удержания
#### `uint8_t readLong(uint16_t longMs)`
Простой обработчик событий. Различает короткое нажатие и удержание.

*   **longMs**: Время в мс, после которого нажатие считается "Долгим" (по умолчанию 800).
*   **Возвращает коды событий:**
    *   `BTN_NONE` (0) — Нет событий.
    *   `BTN_CLICK` (1) — Был короткий клик (срабатывает при отпускании).
    *   `BTN_LONG` (2) — Кнопка удерживается дольше `longMs` (срабатывает один раз по таймеру).

```cpp
// Пример
uint8_t state = myBtn.readLong(1000); // 1 секунда для лонга
```

---

### 3. Умный режим (Smart)
#### `uint8_t readSmart(clickMode, repMode, longMs, doubleMs)`
Продвинутый обработчик, поддерживающий двойные клики и авто-повтор значений (например, для настройки меню).

**Аргументы:**
1.  **`clickMode`** — Тип обработки кликов:
    *   `SM_CLICK` — Обычный клик (срабатывает сразу при отпускании).
    *   `SM_DOUBLE` — Ожидание двойного клика (вносит небольшую задержку реакции на одиночный клик).
2.  **`repMode`** — Тип авто-повтора при удержании:
    *   `SM_REP_NONE` — Без повтора.
    *   `SM_REPEAT` — Простой повтор с постоянной скоростью.
    *   `SM_PROG` — Прогрессивный повтор (ускоряется со временем).
3.  **`longMs`** — Время старта удержания (мс) / Базовая скорость повтора.
4.  **`doubleMs`** — Время ожидания второго нажатия для двойного клика (по умолчанию 250 мс).

**Логика прогрессивного повтора (`SM_PROG`):**
*   Шаги 0-5: Скорость равна `longMs` (медленно).
*   Шаги 6-15: Скорость **200 мс** (быстрее).
*   Шаги 16+: Скорость **50 мс** (очень быстро).

**Возвращает коды событий:**
*   `BTN_NONE` (0)
*   `BTN_CLICK` (1)
*   `BTN_LONG` (2) — Начало удержания.
*   `BTN_DOUBLE` (3) — Зафиксирован двойной клик.
*   `BTN_REPEAT` (4) — Шаг авто-повтора (при удержании).

```cpp
// Пример: Включен двойной клик и прогрессивный повтор
uint8_t state = myBtn.readSmart(SM_DOUBLE, SM_PROG, 600, 250);
```

---

## Константы событий

| Константа | Код | Описание |
| :--- | :---: | :--- |
| `BTN_NONE` | 0 | Событий нет |
| `BTN_CLICK` | 1 | Одиночный клик |
| `BTN_LONG` | 2 | Долгое нажатие (старт) |
| `BTN_DOUBLE`| 3 | Двойной клик |
| `BTN_REPEAT`| 4 | Событие повтора (при удержании) |

---

## Пример использования

```cpp
#include "SavaButton.h"

SavaButton btn(2, PLUS);

void setup() {
  Serial.begin(9600);
  btn(2); // Инициализация пина 2
}

void loop() {
  // Двойной клик + Прогрессивный повтор
  uint8_t event = btn.readSmart(SM_DOUBLE, SM_PROG);

  switch (event) {
    case BTN_CLICK:  Serial.println("Click"); break;
    case BTN_DOUBLE: Serial.println("Double Click"); break;
    case BTN_LONG:   Serial.println("Hold Start"); break;
    case BTN_REPEAT: Serial.println("Auto-Repeat Step"); break;
  }
}
```
