# Contributing to RockBLOCK 9704

🎉 First off, thanks for taking the time to contribute! 🎉

The following is a set of guidelines for contributing to RockBLOCK 9704.
Please follow these guidelines to help maintain consistency.

## How to Contribute

### 🐛 Reporting Bugs

- Use the [Issue Tracker](https://github.com/rock7/rockblock-9704/issues) to report bugs.
- Include **clear steps to reproduce**, **expected behavior**, and **actual behavior**.
- Provide **logs** or **screenshots** if helpful.

### ✨ Suggesting Enhancements

- Open an issue and prefix it with `[Feature Request]`.
- Describe the problem you're trying to solve, not just the solution.

### 🛠️ Code Contributions

1. Fork the repository.
2. Create a feature branch (`git checkout -b feature/awesome-feature`).
3. Write clear, concise commit messages.
4. Ensure code passes all tests and linters.
5. Submit a pull request and describe your changes.

### 📐 Code Style

- Follow the style of the existing codebase.
- Python: Follow [PEP8](https://peps.python.org/pep-0008/).
- C: Use 4-space indentation, Allman style braces and camelCase function/variable names.

