///
/// @file Terminal8x12e.h
/// @brief Font Terminal 8 x 12
///
/// @details Project Pervasive Displays Library Suite
/// @n Based on highView technology
///
/// @author Rei Vilo
/// @date 21 Nov 2024
/// @version 810
///
/// @copyright (c) Rei Vilo, 2010-2024
/// @copyright All rights reserved
/// @copyright For exclusive use with Pervasive Displays screens
///
/// * Basic edition: for hobbyists and for basic usage
/// @n Creative Commons Attribution-ShareAlike 4.0 International (CC BY-SA 4.0)
/// @see https://creativecommons.org/licenses/by-sa/4.0/
///
/// @n Consider the Evaluation or Commercial editions for professionals or organisations and for commercial usage
///
/// * Evaluation edition: for professionals or organisations, evaluation only, no commercial usage
/// @n All rights reserved
///
/// * Commercial edition: for professionals or organisations, commercial usage
/// @n All rights reserved
///
/// * Viewer edition: for professionals or organisations
/// @n All rights reserved
///
/// * Documentation
/// @n All rights reserved
///

//
// Terminal8e.h
// Font library
// ----------------------------------

#ifndef TERMINAL8E_FONT_RELEASE
///
/// @brief Release
///
#define TERMINAL8E_FONT_RELEASE 810

///
/// @brief Font Terminal8x12e
/// @details GLCD FontName : Terminal8x12e
/// @n GLCD FontSize : 8 x 12
///
/// @copyright Font generated manually
///
// #if defined(ENERGIA)
// unsigned char replaced by uint8_t
static const uint8_t Terminal8x12e[224][16] =
    // #elif defined(ARDUINO) || defined(MPIDE) || defined(WIRING)
    // static prog_uchar Terminal8x12e[224][16] PROGMEM =
    // #endif
{
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x7E, 0x03, 0x7E, 0x03, 0x1C, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x0E, 0x00, 0x0E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0E, 0x00, 0x0E, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x88, 0x00, 0xFE, 0x03, 0xFE, 0x03, 0x88, 0x00, 0xFE, 0x03, 0xFE, 0x03, 0x88, 0x00,
    0x00, 0x00, 0x0C, 0x01, 0x1E, 0x03, 0x33, 0x0E, 0x63, 0x0E, 0xC6, 0x03, 0x84, 0x01, 0x00, 0x00,
    0x06, 0x00, 0x8F, 0x01, 0xC9, 0x00, 0x6F, 0x03, 0xB6, 0x07, 0x98, 0x04, 0x8C, 0x07, 0x00, 0x03,
    0x00, 0x00, 0xEC, 0x01, 0xFE, 0x03, 0x12, 0x02, 0x5E, 0x02, 0xCC, 0x01, 0xC0, 0x03, 0x40, 0x02,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0E, 0x00, 0x0E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0xF8, 0x00, 0xFE, 0x03, 0x07, 0x07, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x01, 0x04, 0x07, 0x07, 0xFE, 0x03, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x20, 0x00, 0xA8, 0x00, 0xF8, 0x00, 0x70, 0x00, 0xF8, 0x00, 0xA8, 0x00, 0x20, 0x00,
    0x00, 0x00, 0x20, 0x00, 0x20, 0x00, 0xF8, 0x00, 0xF8, 0x00, 0x20, 0x00, 0x20, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x00, 0x0F, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x03, 0xC0, 0x03, 0xF0, 0x00, 0x3C, 0x00, 0x0F, 0x00, 0x03, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0xFC, 0x01, 0xFE, 0x03, 0xC2, 0x02, 0x1A, 0x02, 0xFE, 0x03, 0xFC, 0x01,
    0x00, 0x00, 0x08, 0x00, 0x08, 0x00, 0x0C, 0x00, 0xFE, 0x03, 0xFE, 0x03, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x0C, 0x03, 0x8E, 0x03, 0xC2, 0x02, 0x62, 0x02, 0x3E, 0x02, 0x1C, 0x02, 0x00, 0x00,
    0x00, 0x00, 0x8C, 0x01, 0x8E, 0x03, 0x22, 0x02, 0x22, 0x02, 0xFE, 0x03, 0xDC, 0x01, 0x00, 0x00,
    0x00, 0x00, 0xC0, 0x00, 0xFE, 0x00, 0xBE, 0x00, 0x80, 0x00, 0xF8, 0x03, 0xF8, 0x03, 0x80, 0x00,
    0x00, 0x00, 0x3E, 0x02, 0x3E, 0x02, 0x22, 0x02, 0x22, 0x03, 0xE2, 0x01, 0xC2, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xF0, 0x01, 0xF8, 0x03, 0x1E, 0x02, 0x16, 0x02, 0xF2, 0x03, 0xE0, 0x01, 0x00, 0x00,
    0x00, 0x00, 0x02, 0x00, 0x82, 0x03, 0xE2, 0x03, 0x7A, 0x00, 0x1E, 0x00, 0x06, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xDC, 0x01, 0xFE, 0x03, 0x32, 0x02, 0x62, 0x02, 0xFE, 0x03, 0xDC, 0x01, 0x00, 0x00,
    0x00, 0x00, 0x3C, 0x00, 0x7E, 0x02, 0x42, 0x03, 0xC2, 0x03, 0xFE, 0x00, 0x7C, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x03, 0x18, 0x03, 0x18, 0x03, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x0B, 0x18, 0x0F, 0x18, 0x07, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x20, 0x00, 0x70, 0x00, 0xD8, 0x00, 0x8C, 0x01, 0x06, 0x03, 0x02, 0x02, 0x00, 0x00,
    0x00, 0x00, 0x50, 0x00, 0x50, 0x00, 0x50, 0x00, 0x50, 0x00, 0x50, 0x00, 0x50, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x02, 0x02, 0x06, 0x03, 0x8C, 0x01, 0xD8, 0x00, 0x70, 0x00, 0x20, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x0C, 0x00, 0x0E, 0x00, 0x62, 0x03, 0x72, 0x03, 0x1E, 0x00, 0x0C, 0x00, 0x00, 0x00,
    0xFC, 0x01, 0xFE, 0x03, 0x02, 0x02, 0x62, 0x02, 0xF2, 0x02, 0x92, 0x02, 0xFE, 0x02, 0xFC, 0x02,
    0x00, 0x00, 0xF8, 0x03, 0xFC, 0x03, 0x46, 0x00, 0x46, 0x00, 0xFC, 0x03, 0xF8, 0x03, 0x00, 0x00,
    0x00, 0x00, 0xFE, 0x03, 0xFE, 0x03, 0x22, 0x02, 0x22, 0x02, 0xFE, 0x03, 0xDC, 0x01, 0x00, 0x00,
    0x00, 0x00, 0xFC, 0x01, 0xFE, 0x03, 0x02, 0x02, 0x02, 0x02, 0x8E, 0x03, 0x8C, 0x01, 0x00, 0x00,
    0x00, 0x00, 0xFE, 0x03, 0xFE, 0x03, 0x02, 0x02, 0x06, 0x03, 0xFC, 0x01, 0xF8, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xFE, 0x03, 0xFE, 0x03, 0x22, 0x02, 0x22, 0x02, 0x22, 0x02, 0x02, 0x02, 0x00, 0x00,
    0x00, 0x00, 0xFE, 0x03, 0xFE, 0x03, 0x22, 0x00, 0x22, 0x00, 0x22, 0x00, 0x02, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xFC, 0x01, 0xFE, 0x03, 0x02, 0x02, 0x42, 0x02, 0xCE, 0x03, 0xCC, 0x03, 0x00, 0x00,
    0x00, 0x00, 0xFE, 0x03, 0xFE, 0x03, 0x20, 0x00, 0x20, 0x00, 0xFE, 0x03, 0xFE, 0x03, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0xFE, 0x03, 0xFE, 0x03, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x80, 0x01, 0x80, 0x03, 0x00, 0x02, 0x00, 0x02, 0xFE, 0x03, 0xFE, 0x01, 0x00, 0x00,
    0x00, 0x00, 0xFE, 0x03, 0xFE, 0x03, 0x20, 0x00, 0xF8, 0x00, 0xDE, 0x03, 0x06, 0x03, 0x00, 0x00,
    0x00, 0x00, 0xFE, 0x03, 0xFE, 0x03, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x00,
    0x00, 0x00, 0xFE, 0x03, 0xFE, 0x03, 0x08, 0x00, 0x70, 0x00, 0x08, 0x00, 0xFE, 0x03, 0xFE, 0x03,
    0x00, 0x00, 0xFE, 0x03, 0xFE, 0x03, 0x18, 0x00, 0x30, 0x00, 0x60, 0x00, 0xFE, 0x03, 0xFE, 0x03,
    0x00, 0x00, 0xFC, 0x01, 0xFE, 0x03, 0x02, 0x02, 0x02, 0x02, 0xFE, 0x03, 0xFC, 0x01, 0x00, 0x00,
    0x00, 0x00, 0xFE, 0x03, 0xFE, 0x03, 0x22, 0x00, 0x22, 0x00, 0x3E, 0x00, 0x1C, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xFC, 0x01, 0xFE, 0x03, 0x02, 0x02, 0x02, 0x06, 0xFE, 0x0F, 0xFC, 0x09, 0x00, 0x00,
    0x00, 0x00, 0xFE, 0x03, 0xFE, 0x03, 0x22, 0x00, 0x62, 0x00, 0xFE, 0x03, 0x9C, 0x03, 0x00, 0x00,
    0x00, 0x00, 0x0C, 0x01, 0x1E, 0x03, 0x32, 0x02, 0x62, 0x02, 0xC6, 0x03, 0x84, 0x01, 0x00, 0x00,
    0x00, 0x00, 0x02, 0x00, 0x02, 0x00, 0xFE, 0x03, 0xFE, 0x03, 0x02, 0x00, 0x02, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xFE, 0x01, 0xFE, 0x03, 0x00, 0x02, 0x00, 0x02, 0xFE, 0x03, 0xFE, 0x01, 0x00, 0x00,
    0x00, 0x00, 0xFE, 0x00, 0xFE, 0x01, 0x00, 0x03, 0x00, 0x03, 0xFE, 0x01, 0xFE, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x7E, 0x00, 0xFE, 0x03, 0x80, 0x03, 0x70, 0x00, 0x80, 0x03, 0xFE, 0x03, 0x7E, 0x00,
    0x00, 0x00, 0x86, 0x03, 0xCE, 0x03, 0x38, 0x00, 0x70, 0x00, 0xCE, 0x03, 0x86, 0x03, 0x00, 0x00,
    0x00, 0x00, 0x1E, 0x00, 0x3E, 0x00, 0xE0, 0x03, 0xE0, 0x03, 0x3E, 0x00, 0x1E, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x82, 0x03, 0xC2, 0x03, 0x62, 0x02, 0x32, 0x02, 0x1E, 0x02, 0x0E, 0x02, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0xFF, 0x0F, 0xFF, 0x0F, 0x01, 0x08, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x06, 0x00, 0x1E, 0x00, 0x78, 0x00, 0xE0, 0x01, 0x80, 0x07, 0x00, 0x06, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x01, 0x08, 0x01, 0x08, 0xFF, 0x0F, 0xFF, 0x0F, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x02, 0x00, 0x03, 0x00, 0x01, 0x00, 0x01, 0x00, 0x03, 0x00, 0x02, 0x00, 0x00, 0x00,
    0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x03, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x80, 0x01, 0xC8, 0x03, 0x48, 0x02, 0x48, 0x02, 0xF8, 0x03, 0xF0, 0x03, 0x00, 0x00,
    0x00, 0x00, 0xFE, 0x03, 0xFE, 0x03, 0x08, 0x02, 0x08, 0x02, 0xF8, 0x03, 0xF0, 0x01, 0x00, 0x00,
    0x00, 0x00, 0xF0, 0x01, 0xF8, 0x03, 0x08, 0x02, 0x08, 0x02, 0x18, 0x03, 0x10, 0x01, 0x00, 0x00,
    0x00, 0x00, 0xF0, 0x01, 0xF8, 0x03, 0x08, 0x02, 0x08, 0x02, 0xFE, 0x03, 0xFE, 0x03, 0x00, 0x00,
    0x00, 0x00, 0xF0, 0x01, 0xF8, 0x03, 0x48, 0x02, 0x48, 0x02, 0x78, 0x02, 0x70, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x20, 0x00, 0xFC, 0x03, 0xFE, 0x03, 0x22, 0x00, 0x22, 0x00, 0x22, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xF0, 0x08, 0xF8, 0x09, 0x08, 0x09, 0x08, 0x09, 0xF8, 0x0F, 0xF8, 0x07, 0x00, 0x00,
    0x00, 0x00, 0xFE, 0x03, 0xFE, 0x03, 0x08, 0x00, 0x08, 0x00, 0xF8, 0x03, 0xF0, 0x03, 0x00, 0x00,
    0x00, 0x00, 0x08, 0x02, 0x08, 0x02, 0xFB, 0x03, 0xFB, 0x03, 0x00, 0x02, 0x00, 0x02, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0xFB, 0x0F, 0xFB, 0x07, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xFE, 0x03, 0xFE, 0x03, 0x40, 0x00, 0xE0, 0x00, 0xB8, 0x03, 0x18, 0x03, 0x00, 0x00,
    0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0xFE, 0x03, 0xFE, 0x03, 0x00, 0x02, 0x00, 0x02, 0x00, 0x00,
    0x00, 0x00, 0xF8, 0x03, 0xF8, 0x03, 0x08, 0x00, 0xF8, 0x01, 0x08, 0x00, 0xF8, 0x03, 0xF0, 0x03,
    0x00, 0x00, 0xF8, 0x03, 0xF8, 0x03, 0x08, 0x00, 0x08, 0x00, 0xF8, 0x03, 0xF0, 0x03, 0x00, 0x00,
    0x00, 0x00, 0xF0, 0x01, 0xF8, 0x03, 0x08, 0x02, 0x08, 0x02, 0xF8, 0x03, 0xF0, 0x01, 0x00, 0x00,
    0x00, 0x00, 0xF8, 0x0F, 0xF8, 0x0F, 0x08, 0x01, 0x08, 0x01, 0xF8, 0x01, 0xF0, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xF0, 0x00, 0xF8, 0x01, 0x08, 0x01, 0x08, 0x01, 0xF8, 0x0F, 0xF8, 0x0F, 0x00, 0x00,
    0x00, 0x00, 0xF8, 0x03, 0xF8, 0x03, 0x20, 0x00, 0x10, 0x00, 0x18, 0x00, 0x18, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x30, 0x02, 0x78, 0x02, 0x48, 0x02, 0x48, 0x02, 0xC8, 0x03, 0x88, 0x01, 0x00, 0x00,
    0x00, 0x00, 0x08, 0x00, 0xFE, 0x01, 0xFE, 0x03, 0x08, 0x02, 0x08, 0x02, 0x08, 0x02, 0x00, 0x00,
    0x00, 0x00, 0xF8, 0x01, 0xF8, 0x03, 0x00, 0x02, 0x00, 0x02, 0xF8, 0x03, 0xF8, 0x03, 0x00, 0x00,
    0x00, 0x00, 0xF8, 0x00, 0xF8, 0x01, 0x00, 0x03, 0x00, 0x03, 0xF8, 0x01, 0xF8, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xF8, 0x00, 0xF8, 0x03, 0x00, 0x03, 0xF0, 0x00, 0x00, 0x03, 0xF8, 0x03, 0xF8, 0x00,
    0x00, 0x00, 0x18, 0x03, 0xB8, 0x03, 0xE0, 0x00, 0xE0, 0x00, 0xB8, 0x03, 0x18, 0x03, 0x00, 0x00,
    0x00, 0x00, 0xF8, 0x08, 0xF8, 0x09, 0x00, 0x0D, 0x00, 0x0F, 0xF8, 0x03, 0xF8, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x08, 0x03, 0x88, 0x03, 0xC8, 0x02, 0x68, 0x02, 0x38, 0x02, 0x18, 0x02, 0x00, 0x00,
    0x00, 0x00, 0x20, 0x00, 0x70, 0x00, 0xDE, 0x03, 0x8F, 0x07, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x0F, 0xFF, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x01, 0x04, 0x8F, 0x07, 0xDE, 0x03, 0x70, 0x00, 0x20, 0x00, 0x00, 0x00,
    0x0C, 0x00, 0x06, 0x00, 0x02, 0x00, 0x06, 0x00, 0x0C, 0x00, 0x08, 0x00, 0x0C, 0x00, 0x06, 0x00,
    0x00, 0x00, 0xFE, 0x03, 0xFE, 0x03, 0xFE, 0x03, 0xFE, 0x03, 0xFE, 0x03, 0xFE, 0x03, 0x00, 0x00,
    0x00, 0x00, 0x50, 0x00, 0xFC, 0x01, 0xFE, 0x03, 0x52, 0x02, 0x02, 0x02, 0x04, 0x01, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x00, 0x07, 0x00, 0x00, 0x00, 0x0B, 0x00, 0x07, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00,
    0x00, 0x00, 0x18, 0x00, 0x18, 0x00, 0xFE, 0x07, 0xFE, 0x07, 0x18, 0x00, 0x18, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x98, 0x01, 0x98, 0x01, 0xFE, 0x07, 0xFE, 0x07, 0x98, 0x01, 0x98, 0x01, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x0E, 0x00, 0x0A, 0x06, 0x8E, 0x01, 0x60, 0x04, 0x18, 0x00, 0x06, 0x04, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x40, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xFC, 0x03, 0x02, 0x04, 0x02, 0x04, 0xFE, 0x07, 0x22, 0x04, 0x02, 0x04, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0E, 0x00, 0x0D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x0E, 0x00, 0x0D, 0x00, 0x00, 0x00, 0x0E, 0x00, 0x0D, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x0B, 0x00, 0x07, 0x00, 0x00, 0x00, 0x0B, 0x00, 0x07, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x60, 0x00, 0xF0, 0x00, 0xF0, 0x00, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x04, 0x00, 0x02, 0x00, 0x02, 0x00, 0x04, 0x00, 0x04, 0x00, 0x02, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x01, 0x00, 0x0F, 0x00, 0x01, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x02, 0x00, 0x0F, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x01, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xD8, 0x0F, 0xD8, 0x0F, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xF0, 0x00, 0xF8, 0x01, 0x0E, 0x07, 0x0E, 0x07, 0x98, 0x01, 0x90, 0x00, 0x00, 0x00,
    0x20, 0x03, 0xFC, 0x03, 0xFE, 0x02, 0x22, 0x02, 0x22, 0x02, 0x26, 0x02, 0x04, 0x02, 0x00, 0x00,
    0x00, 0x00, 0xB4, 0x00, 0xFC, 0x00, 0x48, 0x00, 0x48, 0x00, 0xFC, 0x00, 0xB4, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xAE, 0x00, 0xBE, 0x00, 0xF0, 0x03, 0xF0, 0x03, 0xBE, 0x00, 0xAE, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3E, 0x0F, 0x3E, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x66, 0x04, 0xFF, 0x0C, 0x99, 0x09, 0x99, 0x09, 0xF3, 0x0F, 0x62, 0x06, 0x00, 0x00,
    0x00, 0x00, 0x03, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03, 0x00, 0x00, 0x00,
    0xFC, 0x01, 0x06, 0x03, 0x72, 0x02, 0x8A, 0x02, 0x8A, 0x02, 0x52, 0x02, 0x06, 0x03, 0xFC, 0x01,
    0x00, 0x00, 0x90, 0x00, 0xBA, 0x00, 0xAA, 0x00, 0xAA, 0x00, 0xBE, 0x00, 0xBC, 0x00, 0x00, 0x00,
    0x80, 0x00, 0xC0, 0x01, 0x60, 0x03, 0x20, 0x02, 0x80, 0x00, 0xC0, 0x01, 0x60, 0x03, 0x20, 0x02,
    0x00, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0xE0, 0x00, 0xE0, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x00, 0x00,
    0xFC, 0x01, 0x06, 0x03, 0xFA, 0x02, 0x4A, 0x02, 0x4A, 0x02, 0xB2, 0x02, 0x06, 0x03, 0xFC, 0x01,
    0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
    0x00, 0x00, 0x06, 0x00, 0x0F, 0x00, 0x09, 0x00, 0x09, 0x00, 0x0F, 0x00, 0x06, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x20, 0x02, 0x20, 0x02, 0xF8, 0x02, 0xF8, 0x02, 0x20, 0x02, 0x20, 0x02, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x32, 0x00, 0x3A, 0x00, 0x2E, 0x00, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x22, 0x00, 0x2A, 0x00, 0x3E, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x03, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x08, 0xFC, 0x0F, 0xFC, 0x07, 0x00, 0x01, 0x00, 0x01, 0xFC, 0x00, 0xFC, 0x01, 0x00, 0x01,
    0x00, 0x00, 0x1C, 0x00, 0x3E, 0x00, 0x7F, 0x00, 0x7F, 0x00, 0xFF, 0x0F, 0xFF, 0x0F, 0x01, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x0A, 0x00, 0x0E, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x3E, 0x00, 0x3E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x9C, 0x00, 0xBE, 0x00, 0xA2, 0x00, 0xA2, 0x00, 0xBE, 0x00, 0x9C, 0x00, 0x00, 0x00,
    0x20, 0x02, 0x60, 0x03, 0xC0, 0x01, 0x80, 0x00, 0x20, 0x02, 0x60, 0x03, 0xC0, 0x01, 0x80, 0x00,
    0x02, 0x01, 0x9F, 0x01, 0xDF, 0x00, 0x60, 0x03, 0xB0, 0x03, 0xD8, 0x02, 0xCC, 0x07, 0xC4, 0x07,
    0x02, 0x01, 0x9F, 0x01, 0xDF, 0x00, 0x60, 0x00, 0x70, 0x06, 0x58, 0x07, 0xCC, 0x05, 0x84, 0x04,
    0x11, 0x01, 0x95, 0x01, 0xDF, 0x00, 0x6A, 0x03, 0xB0, 0x03, 0xD8, 0x02, 0xCC, 0x07, 0xC4, 0x07,
    0x00, 0x00, 0x00, 0x06, 0x00, 0x0F, 0xD8, 0x09, 0xD8, 0x08, 0x00, 0x0E, 0x00, 0x06, 0x00, 0x00,
    0x00, 0x00, 0xF8, 0x03, 0xFD, 0x03, 0x47, 0x00, 0x46, 0x00, 0xFC, 0x03, 0xF8, 0x03, 0x00, 0x00,
    0x00, 0x00, 0xF8, 0x03, 0xFC, 0x03, 0x46, 0x00, 0x47, 0x00, 0xFD, 0x03, 0xF8, 0x03, 0x00, 0x00,
    0x00, 0x00, 0xF8, 0x03, 0xFD, 0x03, 0x47, 0x00, 0x47, 0x00, 0xFD, 0x03, 0xF8, 0x03, 0x00, 0x00,
    0x00, 0x00, 0xF2, 0x03, 0xF9, 0x03, 0x4D, 0x00, 0x4E, 0x00, 0xFA, 0x03, 0xF1, 0x03, 0x00, 0x00,
    0x00, 0x00, 0xF8, 0x03, 0xFD, 0x03, 0x46, 0x00, 0x46, 0x00, 0xFD, 0x03, 0xF8, 0x03, 0x00, 0x00,
    0x00, 0x00, 0xF0, 0x03, 0xFA, 0x03, 0x4D, 0x00, 0x4D, 0x00, 0xFA, 0x03, 0xF0, 0x03, 0x00, 0x00,
    0x00, 0x00, 0xF0, 0x03, 0xF8, 0x03, 0x4C, 0x00, 0xFE, 0x03, 0xFE, 0x03, 0x22, 0x02, 0x22, 0x02,
    0x00, 0x00, 0xFC, 0x00, 0xFE, 0x09, 0x02, 0x0B, 0x02, 0x0F, 0xCE, 0x05, 0xCC, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xFC, 0x03, 0xFD, 0x03, 0x25, 0x02, 0x24, 0x02, 0x24, 0x02, 0x04, 0x02, 0x00, 0x00,
    0x00, 0x00, 0xFC, 0x03, 0xFC, 0x03, 0x24, 0x02, 0x25, 0x02, 0x25, 0x02, 0x04, 0x02, 0x00, 0x00,
    0x00, 0x00, 0xFC, 0x03, 0xFD, 0x03, 0x25, 0x02, 0x25, 0x02, 0x25, 0x02, 0x04, 0x02, 0x00, 0x00,
    0x00, 0x00, 0xFC, 0x03, 0xFD, 0x03, 0x24, 0x02, 0x24, 0x02, 0x25, 0x02, 0x04, 0x02, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0xFD, 0x03, 0xFC, 0x03, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x04, 0x02, 0xFC, 0x03, 0xFD, 0x03, 0x05, 0x02, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x05, 0x02, 0xFD, 0x03, 0xFD, 0x03, 0x05, 0x02, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x05, 0x02, 0xFC, 0x03, 0xFC, 0x03, 0x05, 0x02, 0x00, 0x00, 0x00, 0x00,
    0x20, 0x00, 0xFE, 0x03, 0xFE, 0x03, 0x22, 0x02, 0x06, 0x03, 0xFC, 0x01, 0xF8, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xFA, 0x03, 0xF9, 0x03, 0x31, 0x00, 0x62, 0x00, 0xC2, 0x00, 0xF9, 0x03, 0xF8, 0x03,
    0x00, 0x00, 0xF8, 0x01, 0xFD, 0x03, 0x05, 0x02, 0x04, 0x02, 0xFC, 0x03, 0xF8, 0x01, 0x00, 0x00,
    0x00, 0x00, 0xF8, 0x01, 0xFC, 0x03, 0x04, 0x02, 0x05, 0x02, 0xFD, 0x03, 0xF8, 0x01, 0x00, 0x00,
    0x00, 0x00, 0xF8, 0x01, 0xFD, 0x03, 0x05, 0x02, 0x05, 0x02, 0xFD, 0x03, 0xF8, 0x01, 0x00, 0x00,
    0x00, 0x00, 0xF8, 0x01, 0xFD, 0x03, 0x05, 0x02, 0x05, 0x02, 0xFD, 0x03, 0xF8, 0x01, 0x00, 0x00,
    0x00, 0x00, 0xF8, 0x01, 0xFD, 0x03, 0x04, 0x02, 0x04, 0x02, 0xFD, 0x03, 0xF8, 0x01, 0x00, 0x00,
    0x00, 0x00, 0x8C, 0x01, 0xD8, 0x00, 0x70, 0x00, 0x70, 0x00, 0xD8, 0x00, 0x8C, 0x01, 0x00, 0x00,
    0x00, 0x00, 0xFC, 0x03, 0xFE, 0x03, 0xE2, 0x02, 0x3A, 0x02, 0xFE, 0x03, 0xFE, 0x01, 0x00, 0x00,
    0x00, 0x00, 0xFC, 0x01, 0xFD, 0x03, 0x01, 0x02, 0x00, 0x02, 0xFC, 0x03, 0xFC, 0x01, 0x00, 0x00,
    0x00, 0x00, 0xFC, 0x01, 0xFC, 0x03, 0x00, 0x02, 0x01, 0x02, 0xFD, 0x03, 0xFC, 0x01, 0x00, 0x00,
    0x00, 0x00, 0xFC, 0x01, 0xFD, 0x03, 0x01, 0x02, 0x01, 0x02, 0xFD, 0x03, 0xFC, 0x01, 0x00, 0x00,
    0x00, 0x00, 0xFC, 0x01, 0xFD, 0x03, 0x00, 0x02, 0x00, 0x02, 0xFD, 0x03, 0xFC, 0x01, 0x00, 0x00,
    0x00, 0x00, 0x1C, 0x00, 0x3C, 0x00, 0xE0, 0x03, 0xE1, 0x03, 0x3D, 0x00, 0x1C, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xFE, 0x03, 0xFE, 0x03, 0x88, 0x00, 0x88, 0x00, 0xF8, 0x00, 0x70, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xFC, 0x03, 0xFE, 0x03, 0x02, 0x00, 0x1E, 0x02, 0xFC, 0x03, 0xE0, 0x01, 0x00, 0x00,
    0x00, 0x00, 0x80, 0x01, 0xC9, 0x03, 0x4B, 0x02, 0x4A, 0x02, 0xF8, 0x03, 0xF0, 0x03, 0x00, 0x00,
    0x00, 0x00, 0x80, 0x01, 0xC8, 0x03, 0x4A, 0x02, 0x4B, 0x02, 0xF9, 0x03, 0xF0, 0x03, 0x00, 0x00,
    0x00, 0x00, 0x80, 0x01, 0xCA, 0x03, 0x49, 0x02, 0x49, 0x02, 0xFA, 0x03, 0xF0, 0x03, 0x00, 0x00,
    0x00, 0x00, 0x82, 0x01, 0xC9, 0x03, 0x49, 0x02, 0x4A, 0x02, 0xFA, 0x03, 0xF1, 0x03, 0x00, 0x00,
    0x00, 0x00, 0x83, 0x01, 0xCB, 0x03, 0x48, 0x02, 0x48, 0x02, 0xFB, 0x03, 0xF3, 0x03, 0x00, 0x00,
    0x00, 0x00, 0x80, 0x01, 0xD2, 0x03, 0x55, 0x02, 0x55, 0x02, 0xF2, 0x03, 0xE0, 0x03, 0x00, 0x00,
    0x80, 0x01, 0xC8, 0x03, 0x48, 0x02, 0xF0, 0x03, 0xF8, 0x01, 0x48, 0x02, 0x78, 0x02, 0x70, 0x02,
    0x00, 0x00, 0xF0, 0x01, 0xF8, 0x0B, 0x08, 0x0A, 0x08, 0x0E, 0x18, 0x03, 0x10, 0x01, 0x00, 0x00,
    0x00, 0x00, 0xF0, 0x01, 0xF9, 0x03, 0x4B, 0x02, 0x4A, 0x02, 0x78, 0x02, 0x70, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xF0, 0x01, 0xF8, 0x03, 0x4A, 0x02, 0x4B, 0x02, 0x79, 0x02, 0x70, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xF0, 0x01, 0xFA, 0x03, 0x49, 0x02, 0x49, 0x02, 0x7A, 0x02, 0x70, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xF3, 0x01, 0xFB, 0x03, 0x48, 0x02, 0x48, 0x02, 0x7B, 0x02, 0x73, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x08, 0x02, 0x09, 0x02, 0xFB, 0x03, 0xFA, 0x03, 0x00, 0x02, 0x00, 0x02, 0x00, 0x00,
    0x00, 0x00, 0x08, 0x02, 0x08, 0x02, 0xFA, 0x03, 0xFB, 0x03, 0x01, 0x02, 0x00, 0x02, 0x00, 0x00,
    0x00, 0x00, 0x08, 0x02, 0x0A, 0x02, 0xF9, 0x03, 0xF9, 0x03, 0x02, 0x02, 0x00, 0x02, 0x00, 0x00,
    0x00, 0x00, 0x0B, 0x02, 0x0B, 0x02, 0xF8, 0x03, 0xF8, 0x03, 0x03, 0x02, 0x03, 0x02, 0x00, 0x00,
    0x00, 0x00, 0xE8, 0x01, 0xEA, 0x03, 0x16, 0x02, 0x1C, 0x02, 0xFA, 0x03, 0xF2, 0x01, 0x00, 0x00,
    0x00, 0x00, 0xFA, 0x03, 0xF9, 0x03, 0x09, 0x00, 0x0A, 0x00, 0xFA, 0x03, 0xF1, 0x03, 0x00, 0x00,
    0x00, 0x00, 0xF0, 0x01, 0xF9, 0x03, 0x0B, 0x02, 0x0A, 0x02, 0xF8, 0x03, 0xF0, 0x01, 0x00, 0x00,
    0x00, 0x00, 0xF0, 0x01, 0xF8, 0x03, 0x0A, 0x02, 0x0B, 0x02, 0xF9, 0x03, 0xF0, 0x01, 0x00, 0x00,
    0x00, 0x00, 0xF0, 0x01, 0xFA, 0x03, 0x09, 0x02, 0x09, 0x02, 0xFA, 0x03, 0xF0, 0x01, 0x00, 0x00,
    0x00, 0x00, 0xF2, 0x01, 0xF9, 0x03, 0x09, 0x02, 0x0A, 0x02, 0xFA, 0x03, 0xF1, 0x01, 0x00, 0x00,
    0x00, 0x00, 0xF3, 0x01, 0xFB, 0x03, 0x08, 0x02, 0x08, 0x02, 0xFB, 0x03, 0xF3, 0x01, 0x00, 0x00,
    0x00, 0x00, 0x20, 0x00, 0x20, 0x00, 0xAC, 0x01, 0xAC, 0x01, 0x20, 0x00, 0x20, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xF0, 0x03, 0xF8, 0x03, 0xC8, 0x02, 0x68, 0x02, 0xF8, 0x03, 0xF8, 0x01, 0x00, 0x00,
    0x00, 0x00, 0xF8, 0x01, 0xF9, 0x03, 0x03, 0x02, 0x02, 0x02, 0xF8, 0x03, 0xF8, 0x03, 0x00, 0x00,
    0x00, 0x00, 0xF8, 0x01, 0xF8, 0x03, 0x02, 0x02, 0x03, 0x02, 0xF9, 0x03, 0xF8, 0x03, 0x00, 0x00,
    0x00, 0x00, 0xFA, 0x01, 0xFB, 0x03, 0x01, 0x02, 0x01, 0x02, 0xFB, 0x03, 0xFA, 0x03, 0x00, 0x00,
    0x00, 0x00, 0xFB, 0x01, 0xFB, 0x03, 0x00, 0x02, 0x00, 0x02, 0xFB, 0x03, 0xFB, 0x03, 0x00, 0x00,
    0x00, 0x08, 0xF8, 0x08, 0xF8, 0x09, 0x02, 0x0D, 0x03, 0x07, 0xF9, 0x03, 0xF8, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xFF, 0x0F, 0xFF, 0x0F, 0x08, 0x01, 0x08, 0x01, 0xF8, 0x01, 0xF0, 0x00, 0x00, 0x00,
    0x00, 0x08, 0xFB, 0x08, 0xFB, 0x09, 0x00, 0x0D, 0x00, 0x07, 0xFB, 0x03, 0xFB, 0x00, 0x00, 0x00
};

#endif
