# Pervasive Displays Library Suite - Basic edition - Global update

[![Release](https://img.shields.io/github/v/release/rei-vilo/PDLS_EXT3_Basic_Global)](https://github.com/rei-vilo/PDLS_EXT3_Basic_Global/releases) [![Codacy Badge](https://app.codacy.com/project/badge/Grade/77ecc9fa99834e299505f5f2a7c83e53)](https://app.codacy.com/gh/rei-vilo/PDLS_EXT3_Basic_Global/dashboard?utm_source=github.com&amp;utm_medium=referral&amp;utm_content=rei-vilo/PDLS_EXT3_Basic_Global&amp;utm_campaign=Badge_Grade) ![Arduino lint](https://github.com/rei-vilo/PDLS_EXT3_Basic_Global/actions/workflows/main.yml/badge.svg) [![GitHub issues](https://img.shields.io/github/issues/rei-vilo/PDLS_EXT3_Basic_Global)](https://github.com/rei-vilo/PDLS_EXT3_Basic_Global/issues)

[![](https://img.shields.io/badge/-Wiki-blue)](https://docs.pervasivedisplays.com/) [![](https://img.shields.io/badge/-User_Guide-blue)](https://pdls.pervasivedisplays.com/userguide/index.html) [![](https://img.shields.io/badge/-Reference_manual-blue)](https://pdls.pervasivedisplays.com/reference/html/index.html)

The Pervasive Displays Library Suite is specifically designed for the [Pervasive Displays](https://www.pervasivedisplays.com) e-paper screens, extension boards and evaluation kits.

![](https://pdls.pervasivedisplays.com/userguide/img/Logo_PDI_text_320.png)

> ### The library **PDLS_EXT3_Basic_Global** turns legacy. 
>
> As a replacement of monochrome screens (film `C`), use the screens with wide temperature and embedded fast update (film `K`). 
>
> As a replacement of colour black-white-red screens (film `J`), use the colour black-white-red-yellow screens (film `Q`).

The **PDLS_EXT3_Basic_Global** supports the screens

* iTC [monochrome](https://www.pervasivedisplays.com/products/?_sft_product_colour=black-white) (film `C`);
* iTC [colour (black-white-red)](https://www.pervasivedisplays.com/products/?_sft_product_colour=black-white-red) (film `J`); 

the boards

* [EPD Extension Kit Gen 3 (EXT3 or EXT3.1)](https://www.pervasivedisplays.com/product/epd-extension-kit-gen-3-EXT3/); 

the kits

* [EPD Pico Kit (EPDK)](https://www.pervasivedisplays.com/product/epd-pico-kit-epdk/), which includes a Raspberry Pi Pico RP2040, an EXT3.1 extension board and a 2.66" monochrome panel.

## Features

The Pervasive Displays Library Suite provides a high-level interface to drive the e-paper screens.

* Global update
* Graphics routines
* Text routines
* Four extended fonts with double-sized variants

## Documentation

* [Wiki](https://docs.pervasivedisplays.com/) 
* [User guide](https://pdls.pervasivedisplays.com/userguide/index.html) with commented examples
* [Reference manual](https://rei-vilo.github.io/PDLS_EXT3_Basic_Documentation/index.html) 

## Support

* Please refer to [PDLS_EXT3_Basic_Global](https://github.com/rei-vilo/PDLS_EXT3_Basic_Global/issues) for reporting issues and contributing pull requests.

## Installation

Software

* [Arduino IDE](https://www.arduino.cc/en/software) or [Arduino CLI](https://arduino.github.io/arduino-cli/)
* [Installing Additional Arduino Libraries](https://www.arduino.cc/en/guide/libraries)

    + Using the Library Manager
    + Importing a `.zip` Library

Hardware

* [Connecting the Pervasive Displays e-Paper EPD Extension Kit Gen 3](https://embeddedcomputing.weebly.com/connecting-the-e-paper-epd-extension-kit-gen-3.html)

## Configuration

Software

* Arduino SDK
* SPI library

Hardware

* Pervasive Displays EPD Extension Kit Gen 3 (EXT3 or EXT3.1)
* Pervasive Displays iTC monochrome screens (film `C`)
* Pervasive Displays iTC colour (black-white-red) screens (film `J`)

## Licence

**Copyright** &copy; Rei Vilo, 2010-2025

For exclusive use with Pervasive Displays screens

**Licence** [Attribution-ShareAlike 4.0 International (CC BY-SA 4.0)](./LICENCE.md)

![](img/by-sa.svg)

**Portions** &copy; Pervasive Displays, 2010-2025

