///
/// @file hV_Common.h
/// @brief Shared low-level libraries for the Pervasive Displays Library Suite
///
/// @details Project Pervasive Displays Library Suite
/// @n Based on highView technology
///
/// @author Rei Vilo
/// @date 21 Jan 2025
/// @version 812
///
/// @copyright (c) Rei Vilo, 2010-2025
/// @copyright All rights reserved
/// @copyright For exclusive use with Pervasive Displays screens
///
/// * Basic edition: for hobbyists and for basic usage
/// @n Creative Commons Attribution-ShareAlike 4.0 International (CC BY-SA 4.0)
/// @see https://creativecommons.org/licenses/by-sa/4.0/
///
/// @n Consider the Evaluation or Commercial editions for professionals or organisations and for commercial usage
///
/// * Evaluation edition: for professionals or organisations, evaluation only, no commercial usage
/// @n All rights reserved
///
/// * Commercial edition: for professionals or organisations, commercial usage
/// @n All rights reserved
///
/// * Viewer edition: for professionals or organisations
/// @n All rights reserved
///
/// * Documentation
/// @n All rights reserved
///

#ifndef hV_COMMON_RELEASE
///
/// @brief Library release number
///
#define hV_COMMON_RELEASE 812

// SDK
#include "hV_HAL_Peripherals.h"

// Configuration
#include "hV_Configuration.h"
#include "hV_List_Constants.h"
#include "hV_List_Options.h"
#include "hV_List_Boards.h"
#include "hV_List_Screens.h"
// #include "hV_List_Screens_Legacy.h"

#include "hV_Documentation.h"

#include "hV_Utilities_Common.h"
#include "hV_Colours565.h"

// Screen
// #include "hV_Screen_Virtual.h"
// #include "hV_Screen_Buffer.h"

#endif // hV_COMMON_RELEASE
