///
/// @file Terminal6x8e.h
/// @brief Font Terminal 6 x 8
///
/// @details Project Pervasive Displays Library Suite
/// @n Based on highView technology
///
/// @author Rei Vilo
/// @date 21 Jan 2025
/// @version 812
///
/// @copyright (c) Rei Vilo, 2010-2025
/// @copyright All rights reserved
/// @copyright For exclusive use with Pervasive Displays screens
///
/// * Basic edition: for hobbyists and for basic usage
/// @n Creative Commons Attribution-ShareAlike 4.0 International (CC BY-SA 4.0)
/// @see https://creativecommons.org/licenses/by-sa/4.0/
///
/// @n Consider the Evaluation or Commercial editions for professionals or organisations and for commercial usage
///
/// * Evaluation edition: for professionals or organisations, evaluation only, no commercial usage
/// @n All rights reserved
///
/// * Commercial edition: for professionals or organisations, commercial usage
/// @n All rights reserved
///
/// * Viewer edition: for professionals or organisations
/// @n All rights reserved
///
/// * Documentation
/// @n All rights reserved
///

//
// Terminal6e.h
// Font library
// ----------------------------------

#ifndef TERMINAL6E_FONT_RELEASE
///
/// @brief Release
///
#define TERMINAL6E_FONT_RELEASE 812

///
/// @brief Font Terminal6x8e
/// @details GLCD FontName : Terminal6x8e
/// @n GLCD FontSize : 6 x 8
///
/// @copyright Font generated manually
///
// #if defined(ENERGIA)
// unsigned char replaced by uint8_t
static const uint8_t Terminal6x8e[224][6] =
    // #elif defined(ARDUINO) || defined(MPIDE) || defined(WIRING)
    // static prog_uchar Terminal6x8e[224][6] PROGMEM =
    // #endif
{
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x06, 0x5F, 0x06, 0x00,
    0x00, 0x07, 0x03, 0x00, 0x07, 0x03,
    0x00, 0x24, 0x7E, 0x24, 0x7E, 0x24,
    0x00, 0x24, 0x2B, 0x6A, 0x12, 0x00,
    0x00, 0x63, 0x13, 0x08, 0x64, 0x63,
    0x00, 0x36, 0x49, 0x56, 0x20, 0x50,
    0x00, 0x00, 0x07, 0x03, 0x00, 0x00,
    0x00, 0x00, 0x3E, 0x41, 0x00, 0x00,
    0x00, 0x00, 0x41, 0x3E, 0x00, 0x00,
    0x00, 0x08, 0x3E, 0x1C, 0x3E, 0x08,
    0x00, 0x08, 0x08, 0x3E, 0x08, 0x08,
    0x00, 0x00, 0xE0, 0x60, 0x00, 0x00,
    0x00, 0x08, 0x08, 0x08, 0x08, 0x08,
    0x00, 0x00, 0x60, 0x60, 0x00, 0x00,
    0x00, 0x20, 0x10, 0x08, 0x04, 0x02,
    0x00, 0x3E, 0x51, 0x49, 0x45, 0x3E,
    0x00, 0x00, 0x42, 0x7F, 0x40, 0x00,
    0x00, 0x62, 0x51, 0x49, 0x49, 0x46,
    0x00, 0x22, 0x49, 0x49, 0x49, 0x36,
    0x00, 0x18, 0x14, 0x12, 0x7F, 0x10,
    0x00, 0x2F, 0x49, 0x49, 0x49, 0x31,
    0x00, 0x3C, 0x4A, 0x49, 0x49, 0x30,
    0x00, 0x01, 0x71, 0x09, 0x05, 0x03,
    0x00, 0x36, 0x49, 0x49, 0x49, 0x36,
    0x00, 0x06, 0x49, 0x49, 0x29, 0x1E,
    0x00, 0x00, 0x6C, 0x6C, 0x00, 0x00,
    0x00, 0x00, 0xEC, 0x6C, 0x00, 0x00,
    0x00, 0x08, 0x14, 0x22, 0x41, 0x00,
    0x00, 0x24, 0x24, 0x24, 0x24, 0x24,
    0x00, 0x00, 0x41, 0x22, 0x14, 0x08,
    0x00, 0x02, 0x01, 0x59, 0x09, 0x06,
    0x00, 0x3E, 0x41, 0x5D, 0x55, 0x1E,
    0x00, 0x7E, 0x11, 0x11, 0x11, 0x7E,
    0x00, 0x7F, 0x49, 0x49, 0x49, 0x36,
    0x00, 0x3E, 0x41, 0x41, 0x41, 0x22,
    0x00, 0x7F, 0x41, 0x41, 0x41, 0x3E,
    0x00, 0x7F, 0x49, 0x49, 0x49, 0x41,
    0x00, 0x7F, 0x09, 0x09, 0x09, 0x01,
    0x00, 0x3E, 0x41, 0x49, 0x49, 0x7A,
    0x00, 0x7F, 0x08, 0x08, 0x08, 0x7F,
    0x00, 0x00, 0x41, 0x7F, 0x41, 0x00,
    0x00, 0x30, 0x40, 0x40, 0x40, 0x3F,
    0x00, 0x7F, 0x08, 0x14, 0x22, 0x41,
    0x00, 0x7F, 0x40, 0x40, 0x40, 0x40,
    0x00, 0x7F, 0x02, 0x04, 0x02, 0x7F,
    0x00, 0x7F, 0x02, 0x04, 0x08, 0x7F,
    0x00, 0x3E, 0x41, 0x41, 0x41, 0x3E,
    0x00, 0x7F, 0x09, 0x09, 0x09, 0x06,
    0x00, 0x3E, 0x41, 0x51, 0x21, 0x5E,
    0x00, 0x7F, 0x09, 0x09, 0x19, 0x66,
    0x00, 0x26, 0x49, 0x49, 0x49, 0x32,
    0x00, 0x01, 0x01, 0x7F, 0x01, 0x01,
    0x00, 0x3F, 0x40, 0x40, 0x40, 0x3F,
    0x00, 0x1F, 0x20, 0x40, 0x20, 0x1F,
    0x00, 0x3F, 0x40, 0x3C, 0x40, 0x3F,
    0x00, 0x63, 0x14, 0x08, 0x14, 0x63,
    0x00, 0x07, 0x08, 0x70, 0x08, 0x07,
    0x00, 0x71, 0x49, 0x45, 0x43, 0x00,
    0x00, 0x00, 0x7F, 0x41, 0x41, 0x00,
    0x00, 0x02, 0x04, 0x08, 0x10, 0x20,
    0x00, 0x00, 0x41, 0x41, 0x7F, 0x00,
    0x00, 0x04, 0x02, 0x01, 0x02, 0x04,
    0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
    0x00, 0x00, 0x03, 0x07, 0x00, 0x00,
    0x00, 0x20, 0x54, 0x54, 0x54, 0x78,
    0x00, 0x7F, 0x44, 0x44, 0x44, 0x38,
    0x00, 0x38, 0x44, 0x44, 0x44, 0x28,
    0x00, 0x38, 0x44, 0x44, 0x44, 0x7F,
    0x00, 0x38, 0x54, 0x54, 0x54, 0x08,
    0x00, 0x08, 0x7E, 0x09, 0x09, 0x00,
    0x00, 0x18, 0xA4, 0xA4, 0xA4, 0x7C,
    0x00, 0x7F, 0x04, 0x04, 0x78, 0x00,
    0x00, 0x00, 0x00, 0x7D, 0x40, 0x00,
    0x00, 0x40, 0x80, 0x84, 0x7D, 0x00,
    0x00, 0x7F, 0x10, 0x28, 0x44, 0x00,
    0x00, 0x00, 0x00, 0x7F, 0x40, 0x00,
    0x00, 0x7C, 0x04, 0x18, 0x04, 0x78,
    0x00, 0x7C, 0x04, 0x04, 0x78, 0x00,
    0x00, 0x38, 0x44, 0x44, 0x44, 0x38,
    0x00, 0xFC, 0x44, 0x44, 0x44, 0x38,
    0x00, 0x38, 0x44, 0x44, 0x44, 0xFC,
    0x00, 0x44, 0x78, 0x44, 0x04, 0x08,
    0x00, 0x08, 0x54, 0x54, 0x54, 0x20,
    0x00, 0x04, 0x3E, 0x44, 0x24, 0x00,
    0x00, 0x3C, 0x40, 0x20, 0x7C, 0x00,
    0x00, 0x1C, 0x20, 0x40, 0x20, 0x1C,
    0x00, 0x3C, 0x60, 0x30, 0x60, 0x3C,
    0x00, 0x6C, 0x10, 0x10, 0x6C, 0x00,
    0x00, 0x9C, 0xA0, 0x60, 0x3C, 0x00,
    0x00, 0x64, 0x54, 0x54, 0x4C, 0x00,
    0x00, 0x08, 0x3E, 0x41, 0x41, 0x00,
    0x00, 0x00, 0x00, 0x77, 0x00, 0x00,
    0x00, 0x00, 0x41, 0x41, 0x3E, 0x08,
    0x00, 0x02, 0x01, 0x02, 0x01, 0x00,
    0x00, 0x3C, 0x26, 0x23, 0x26, 0x3C,
    0x00, 0x14, 0x3E, 0x55, 0x41, 0x21,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xE0, 0x60, 0x00, 0x00,
    0x00, 0x40, 0x34, 0x0E, 0x05, 0x00,
    0x00, 0xE0, 0x60, 0x00, 0xE0, 0x60,
    0x00, 0x40, 0x00, 0x40, 0x00, 0x40,
    0x00, 0x00, 0x02, 0x3F, 0x02, 0x00,
    0x00, 0x00, 0x12, 0x3F, 0x12, 0x00,
    0x00, 0x00, 0x02, 0x01, 0x02, 0x00,
    0x00, 0x63, 0x13, 0x48, 0x04, 0x43,
    0x00, 0x4C, 0x55, 0x56, 0x55, 0x64,
    0x00, 0x00, 0x08, 0x14, 0x00, 0x00,
    0x00, 0x3E, 0x41, 0x7F, 0x49, 0x41,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x64, 0x55, 0x56, 0x4D, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x06, 0x07, 0x00, 0x00,
    0x00, 0x00, 0x07, 0x03, 0x00, 0x00,
    0x00, 0x07, 0x06, 0x00, 0x07, 0x06,
    0x00, 0x03, 0x07, 0x00, 0x03, 0x07,
    0x00, 0x00, 0x18, 0x18, 0x00, 0x00,
    0x00, 0x08, 0x08, 0x08, 0x00, 0x00,
    0x00, 0x08, 0x08, 0x08, 0x08, 0x08,
    0x00, 0x10, 0x08, 0x10, 0x08, 0x00,
    0x01, 0x07, 0x01, 0x07, 0x01, 0x07,
    0x00, 0x08, 0x55, 0x56, 0x55, 0x20,
    0x00, 0x00, 0x14, 0x08, 0x00, 0x00,
    0x00, 0x38, 0x44, 0x38, 0x54, 0x48,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x64, 0x55, 0x56, 0x4D, 0x00,
    0x00, 0x04, 0x09, 0x70, 0x09, 0x04,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x60, 0xFA, 0x60, 0x00,
    0x00, 0x18, 0x24, 0x66, 0x24, 0x00,
    0x00, 0x48, 0x3E, 0x49, 0x41, 0x22,
    0x00, 0x5D, 0x22, 0x22, 0x22, 0x5D,
    0x00, 0x29, 0x2A, 0x7C, 0x2A, 0x29,
    0x00, 0x00, 0x00, 0x77, 0x00, 0x00,
    0x00, 0x26, 0x4D, 0x55, 0x59, 0x32,
    0x00, 0x00, 0x02, 0x00, 0x02, 0x00,
    0x3E, 0x41, 0x5D, 0x55, 0x41, 0x3E,
    0x00, 0x08, 0x55, 0x55, 0x55, 0x5E,
    0x00, 0x08, 0x14, 0x00, 0x08, 0x14,
    0x00, 0x04, 0x04, 0x04, 0x04, 0x1C,
    0x00, 0x00, 0x30, 0x7D, 0x30, 0x00,
    0x3E, 0x41, 0x5D, 0x4B, 0x55, 0x3E,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x00, 0x4E, 0x51, 0x51, 0x4E, 0x00,
    0x00, 0x00, 0x24, 0x2E, 0x24, 0x00,
    0x00, 0x09, 0x0D, 0x0A, 0x00, 0x00,
    0x00, 0x09, 0x0F, 0x05, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x01, 0x01, 0x00,
    0x00, 0xFC, 0x20, 0x20, 0x1C, 0x00,
    0x00, 0x06, 0x09, 0x7F, 0x01, 0x7F,
    0x00, 0x00, 0x08, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x80, 0xC0, 0x40, 0x00,
    0x00, 0x02, 0x0F, 0x00, 0x00, 0x00,
    0x00, 0x06, 0x09, 0x09, 0x06, 0x00,
    0x00, 0x14, 0x08, 0x00, 0x14, 0x08,
    0x00, 0x17, 0x08, 0x34, 0x2A, 0x78,
    0x00, 0x17, 0x08, 0x4C, 0x6A, 0x50,
    0x05, 0x17, 0x0A, 0x34, 0x2A, 0x79,
    0x00, 0x30, 0x48, 0x4D, 0x40, 0x20,
    0x00, 0x70, 0x29, 0x25, 0x28, 0x70,
    0x00, 0x70, 0x28, 0x25, 0x29, 0x70,
    0x00, 0x70, 0x29, 0x25, 0x29, 0x70,
    0x00, 0x70, 0x2A, 0x25, 0x2A, 0x71,
    0x00, 0x70, 0x29, 0x24, 0x29, 0x70,
    0x00, 0x70, 0x2A, 0x2D, 0x2A, 0x70,
    0x00, 0x7E, 0x11, 0x7F, 0x49, 0x41,
    0x00, 0x1E, 0xA1, 0xE1, 0x61, 0x12,
    0x00, 0x7C, 0x55, 0x55, 0x54, 0x44,
    0x00, 0x7C, 0x54, 0x55, 0x55, 0x44,
    0x00, 0x7C, 0x55, 0x55, 0x55, 0x44,
    0x00, 0x7C, 0x55, 0x54, 0x55, 0x44,
    0x00, 0x00, 0x45, 0x7D, 0x44, 0x00,
    0x00, 0x00, 0x44, 0x7D, 0x45, 0x00,
    0x00, 0x00, 0x45, 0x7D, 0x45, 0x00,
    0x00, 0x00, 0x45, 0x7C, 0x45, 0x00,
    0x00, 0x08, 0x7F, 0x49, 0x41, 0x3E,
    0x00, 0x7A, 0x11, 0x22, 0x79, 0x00,
    0x00, 0x3D, 0x43, 0x42, 0x3C, 0x00,
    0x00, 0x3C, 0x42, 0x43, 0x3D, 0x00,
    0x00, 0x3C, 0x43, 0x43, 0x3D, 0x00,
    0x00, 0x3E, 0x45, 0x42, 0x3D, 0x00,
    0x00, 0x3C, 0x42, 0x43, 0x3D, 0x00,
    0x00, 0x00, 0x28, 0x10, 0x28, 0x00,
    0x00, 0x7E, 0x61, 0x5D, 0x43, 0x3F,
    0x00, 0x3C, 0x40, 0x41, 0x3D, 0x00,
    0x00, 0x3D, 0x41, 0x40, 0x3C, 0x00,
    0x00, 0x3C, 0x41, 0x41, 0x3D, 0x00,
    0x00, 0x3C, 0x41, 0x40, 0x3D, 0x00,
    0x00, 0x04, 0x08, 0x71, 0x09, 0x04,
    0x00, 0xFE, 0xAA, 0x28, 0x10, 0x00,
    0x00, 0xFE, 0x4A, 0x4A, 0x34, 0x00,
    0x00, 0x20, 0x55, 0x55, 0x54, 0x78,
    0x00, 0x20, 0x54, 0x54, 0x55, 0x79,
    0x00, 0x20, 0x55, 0x55, 0x55, 0x78,
    0x00, 0x20, 0x56, 0x55, 0x56, 0x7D,
    0x00, 0x20, 0x55, 0x54, 0x55, 0x78,
    0x00, 0x20, 0x57, 0x55, 0x57, 0x7C,
    0x00, 0xFC, 0x20, 0x20, 0x1C, 0x00,
    0x00, 0x38, 0xC4, 0xC4, 0x44, 0x28,
    0x00, 0x39, 0x55, 0x54, 0x08, 0x00,
    0x00, 0x38, 0x54, 0x55, 0x09, 0x00,
    0x00, 0x38, 0x55, 0x55, 0x09, 0x00,
    0x00, 0x38, 0x55, 0x54, 0x09, 0x00,
    0x00, 0x00, 0x01, 0x7D, 0x40, 0x00,
    0x00, 0x00, 0x00, 0x7D, 0x41, 0x00,
    0x00, 0x00, 0x01, 0x7D, 0x41, 0x00,
    0x00, 0x00, 0x01, 0x7C, 0x41, 0x00,
    0x00, 0x39, 0x47, 0x45, 0x46, 0x3D,
    0x00, 0x7A, 0x09, 0x0A, 0x71, 0x00,
    0x00, 0x39, 0x45, 0x44, 0x38, 0x00,
    0x00, 0x38, 0x44, 0x45, 0x39, 0x00,
    0x00, 0x38, 0x45, 0x45, 0x39, 0x00,
    0x00, 0x3A, 0x45, 0x46, 0x39, 0x00,
    0x00, 0x38, 0x45, 0x44, 0x39, 0x00,
    0x00, 0x08, 0x08, 0x2A, 0x08, 0x08,
    0x00, 0x58, 0x24, 0x54, 0x48, 0x34,
    0x00, 0x3D, 0x41, 0x20, 0x7C, 0x00,
    0x00, 0x3C, 0x40, 0x21, 0x7D, 0x00,
    0x00, 0x3C, 0x41, 0x21, 0x7D, 0x00,
    0x00, 0x3C, 0x41, 0x20, 0x7D, 0x00,
    0x00, 0x9C, 0xA0, 0x61, 0x3D, 0x00,
    0x00, 0xFF, 0xA5, 0x24, 0x18, 0x00,
    0x00, 0x9C, 0xA1, 0x60, 0x3D, 0x00
};

#endif

