///
/// @file Terminal12x16e.h
/// @brief Font Terminal 12 x 16
///
/// @details Project Pervasive Displays Library Suite
/// @n Based on highView technology
///
/// @author Rei Vilo
/// @date 21 Mar 2024
/// @version 801
///
/// @copyright (c) Rei Vilo, 2010-2024
/// @copyright All rights reserved
/// @copyright For exclusive use with Pervasive Displays screens
///
/// * Basic edition: for hobbyists and for basic usage
/// @n Creative Commons Attribution-ShareAlike 4.0 International (CC BY-SA 4.0)
/// @see https://creativecommons.org/licenses/by-sa/4.0/
///
/// @n Consider the Evaluation or Commercial editions for professionals or organisations and for commercial usage
///
/// * Evaluation edition: for professionals or organisations, evaluation only, no commercial usage
/// @n All rights reserved
///
/// * Commercial edition: for professionals or organisations, commercial usage
/// @n All rights reserved
///
/// * Viewer edition: for professionals or organisations
/// @n All rights reserved
///
/// * Documentation
/// @n All rights reserved
///

//
// Terminal12e.h
// Font library
// ----------------------------------

#ifndef TERMINAL12E_FONT_RELEASE
///
/// @brief Release
///
#define TERMINAL12E_FONT_RELEASE 801

///
/// @brief Font Terminal12x16e
/// @details GLCD FontName : Terminal12x16e
/// @n GLCD FontSize : 12 x 26
///
/// @copyright Font generated manually
///
// #if defined(ENERGIA)
// unsigned char replaced by uint8_t
static const uint8_t Terminal12x16e[224][24] =
    // #elif defined(ARDUINO) || defined(MPIDE) || defined(WIRING)
    // static prog_uchar Terminal12x16e[224][24] PROGMEM =
    // #endif
{
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7C, 0x00, 0xFF, 0x33, 0xFF, 0x33, 0x7C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3C, 0x00, 0x3C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3C, 0x00, 0x3C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x02, 0x10, 0x1E, 0x90, 0x1F, 0xF0, 0x03, 0x7E, 0x02, 0x1E, 0x1E, 0x90, 0x1F, 0xF0, 0x03, 0x7E, 0x02, 0x1E, 0x00, 0x10, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x78, 0x04, 0xFC, 0x0C, 0xCC, 0x0C, 0xFF, 0x3F, 0xFF, 0x3F, 0xCC, 0x0C, 0xCC, 0x0F, 0x88, 0x07, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x30, 0x38, 0x38, 0x38, 0x1C, 0x38, 0x0E, 0x00, 0x07, 0x80, 0x03, 0xC0, 0x01, 0xE0, 0x38, 0x70, 0x38, 0x38, 0x38, 0x18, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xB8, 0x3F, 0xFC, 0x31, 0xC6, 0x21, 0xE2, 0x37, 0x3E, 0x1E, 0x1C, 0x1C, 0x00, 0x36, 0x00, 0x22, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x27, 0x00, 0x3F, 0x00, 0x1F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x03, 0xFC, 0x0F, 0xFE, 0x1F, 0x07, 0x38, 0x01, 0x20, 0x01, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x20, 0x01, 0x20, 0x07, 0x38, 0xFE, 0x1F, 0xFC, 0x0F, 0xF0, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x98, 0x0C, 0xB8, 0x0E, 0xE0, 0x03, 0xF8, 0x0F, 0xF8, 0x0F, 0xE0, 0x03, 0xB8, 0x0E, 0x98, 0x0C, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0xF0, 0x0F, 0xF0, 0x0F, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xB8, 0x00, 0xF8, 0x00, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x00, 0x38, 0x00, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x18, 0x00, 0x1C, 0x00, 0x0E, 0x00, 0x07, 0x80, 0x03, 0xC0, 0x01, 0xE0, 0x00, 0x70, 0x00, 0x38, 0x00, 0x1C, 0x00, 0x0E, 0x00,
    0x00, 0x00, 0xF8, 0x07, 0xFE, 0x1F, 0x06, 0x1E, 0x03, 0x33, 0x83, 0x31, 0xC3, 0x30, 0x63, 0x30, 0x33, 0x30, 0x1E, 0x18, 0xFE, 0x1F, 0xF8, 0x07,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x30, 0x0C, 0x30, 0x0E, 0x30, 0xFF, 0x3F, 0xFF, 0x3F, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x00,
    0x00, 0x00, 0x1C, 0x30, 0x1E, 0x38, 0x07, 0x3C, 0x03, 0x3E, 0x03, 0x37, 0x83, 0x33, 0xC3, 0x31, 0xE3, 0x30, 0x77, 0x30, 0x3E, 0x30, 0x1C, 0x30,
    0x00, 0x00, 0x0C, 0x0C, 0x0E, 0x1C, 0x07, 0x38, 0xC3, 0x30, 0xC3, 0x30, 0xC3, 0x30, 0xC3, 0x30, 0xC3, 0x30, 0xE7, 0x39, 0x7E, 0x1F, 0x3C, 0x0E,
    0x00, 0x00, 0xC0, 0x03, 0xE0, 0x03, 0x70, 0x03, 0x38, 0x03, 0x1C, 0x03, 0x0E, 0x03, 0x07, 0x03, 0xFF, 0x3F, 0xFF, 0x3F, 0x00, 0x03, 0x00, 0x03,
    0x00, 0x00, 0x3F, 0x0C, 0x7F, 0x1C, 0x63, 0x38, 0x63, 0x30, 0x63, 0x30, 0x63, 0x30, 0x63, 0x30, 0x63, 0x30, 0xE3, 0x38, 0xC3, 0x1F, 0x83, 0x0F,
    0x00, 0x00, 0xC0, 0x0F, 0xF0, 0x1F, 0xF8, 0x39, 0xDC, 0x30, 0xCE, 0x30, 0xC7, 0x30, 0xC3, 0x30, 0xC3, 0x30, 0xC3, 0x39, 0x80, 0x1F, 0x00, 0x0F,
    0x00, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x30, 0x03, 0x3C, 0x03, 0x0F, 0xC3, 0x03, 0xF3, 0x00, 0x3F, 0x00, 0x0F, 0x00, 0x03, 0x00,
    0x00, 0x00, 0x00, 0x0F, 0xBC, 0x1F, 0xFE, 0x39, 0xE7, 0x30, 0xC3, 0x30, 0xC3, 0x30, 0xC3, 0x30, 0xE7, 0x30, 0xFE, 0x39, 0xBC, 0x1F, 0x00, 0x0F,
    0x00, 0x00, 0x3C, 0x00, 0x7E, 0x00, 0xE7, 0x30, 0xC3, 0x30, 0xC3, 0x30, 0xC3, 0x38, 0xC3, 0x1C, 0xC3, 0x0E, 0xE7, 0x07, 0xFE, 0x03, 0xFC, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x1C, 0x70, 0x1C, 0x70, 0x1C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x9C, 0x70, 0xFC, 0x70, 0x7C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0xC0, 0x00, 0xE0, 0x01, 0xF0, 0x03, 0x38, 0x07, 0x1C, 0x0E, 0x0E, 0x1C, 0x07, 0x38, 0x03, 0x30, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x60, 0x06, 0x60, 0x06, 0x60, 0x06, 0x60, 0x06, 0x60, 0x06, 0x60, 0x06, 0x60, 0x06, 0x60, 0x06, 0x60, 0x06, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x03, 0x30, 0x07, 0x38, 0x0E, 0x1C, 0x1C, 0x0E, 0x38, 0x07, 0xF0, 0x03, 0xE0, 0x01, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x1C, 0x00, 0x1E, 0x00, 0x07, 0x00, 0x03, 0x00, 0x83, 0x37, 0xC3, 0x37, 0xE3, 0x00, 0x77, 0x00, 0x3E, 0x00, 0x1C, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xF8, 0x0F, 0xFE, 0x1F, 0x07, 0x18, 0xF3, 0x33, 0xFB, 0x37, 0x1B, 0x36, 0xFB, 0x37, 0xFB, 0x37, 0x07, 0x36, 0xFE, 0x03, 0xF8, 0x01,
    0x00, 0x00, 0x00, 0x38, 0x00, 0x3F, 0xE0, 0x07, 0xFC, 0x06, 0x1F, 0x06, 0x1F, 0x06, 0xFC, 0x06, 0xE0, 0x07, 0x00, 0x3F, 0x00, 0x38, 0x00, 0x00,
    0x00, 0x00, 0xFF, 0x3F, 0xFF, 0x3F, 0xC3, 0x30, 0xC3, 0x30, 0xC3, 0x30, 0xC3, 0x30, 0xE7, 0x30, 0xFE, 0x39, 0xBC, 0x1F, 0x00, 0x0F, 0x00, 0x00,
    0x00, 0x00, 0xF0, 0x03, 0xFC, 0x0F, 0x0E, 0x1C, 0x07, 0x38, 0x03, 0x30, 0x03, 0x30, 0x03, 0x30, 0x07, 0x38, 0x0E, 0x1C, 0x0C, 0x0C, 0x00, 0x00,
    0x00, 0x00, 0xFF, 0x3F, 0xFF, 0x3F, 0x03, 0x30, 0x03, 0x30, 0x03, 0x30, 0x03, 0x30, 0x07, 0x38, 0x0E, 0x1C, 0xFC, 0x0F, 0xF0, 0x03, 0x00, 0x00,
    0x00, 0x00, 0xFF, 0x3F, 0xFF, 0x3F, 0xC3, 0x30, 0xC3, 0x30, 0xC3, 0x30, 0xC3, 0x30, 0xC3, 0x30, 0xC3, 0x30, 0x03, 0x30, 0x03, 0x30, 0x00, 0x00,
    0x00, 0x00, 0xFF, 0x3F, 0xFF, 0x3F, 0xC3, 0x00, 0xC3, 0x00, 0xC3, 0x00, 0xC3, 0x00, 0xC3, 0x00, 0xC3, 0x00, 0x03, 0x00, 0x03, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xF0, 0x03, 0xFC, 0x0F, 0x0E, 0x1C, 0x07, 0x38, 0x03, 0x30, 0xC3, 0x30, 0xC3, 0x30, 0xC3, 0x30, 0xC7, 0x3F, 0xC6, 0x3F, 0x00, 0x00,
    0x00, 0x00, 0xFF, 0x3F, 0xFF, 0x3F, 0xC0, 0x00, 0xC0, 0x00, 0xC0, 0x00, 0xC0, 0x00, 0xC0, 0x00, 0xC0, 0x00, 0xFF, 0x3F, 0xFF, 0x3F, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x30, 0x03, 0x30, 0xFF, 0x3F, 0xFF, 0x3F, 0x03, 0x30, 0x03, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x0E, 0x00, 0x1E, 0x00, 0x38, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x38, 0xFF, 0x1F, 0xFF, 0x07, 0x00, 0x00,
    0x00, 0x00, 0xFF, 0x3F, 0xFF, 0x3F, 0xC0, 0x00, 0xE0, 0x01, 0xF0, 0x03, 0x38, 0x07, 0x1C, 0x0E, 0x0E, 0x1C, 0x07, 0x38, 0x03, 0x30, 0x00, 0x00,
    0x00, 0x00, 0xFF, 0x3F, 0xFF, 0x3F, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x00,
    0x00, 0x00, 0xFF, 0x3F, 0xFF, 0x3F, 0x1E, 0x00, 0x78, 0x00, 0xE0, 0x01, 0xE0, 0x01, 0x78, 0x00, 0x1E, 0x00, 0xFF, 0x3F, 0xFF, 0x3F, 0x00, 0x00,
    0x00, 0x00, 0xFF, 0x3F, 0xFF, 0x3F, 0x0E, 0x00, 0x38, 0x00, 0xF0, 0x00, 0xC0, 0x03, 0x00, 0x07, 0x00, 0x1C, 0xFF, 0x3F, 0xFF, 0x3F, 0x00, 0x00,
    0x00, 0x00, 0xF0, 0x03, 0xFC, 0x0F, 0x0E, 0x1C, 0x07, 0x38, 0x03, 0x30, 0x03, 0x30, 0x07, 0x38, 0x0E, 0x1C, 0xFC, 0x0F, 0xF0, 0x03, 0x00, 0x00,
    0x00, 0x00, 0xFF, 0x3F, 0xFF, 0x3F, 0x83, 0x01, 0x83, 0x01, 0x83, 0x01, 0x83, 0x01, 0x83, 0x01, 0xC7, 0x01, 0xFE, 0x00, 0x7C, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xF0, 0x03, 0xFC, 0x0F, 0x0E, 0x1C, 0x07, 0x38, 0x03, 0x30, 0x03, 0x36, 0x07, 0x3E, 0x0E, 0x1C, 0xFC, 0x3F, 0xF0, 0x33, 0x00, 0x00,
    0x00, 0x00, 0xFF, 0x3F, 0xFF, 0x3F, 0x83, 0x01, 0x83, 0x01, 0x83, 0x03, 0x83, 0x07, 0x83, 0x0F, 0xC7, 0x1D, 0xFE, 0x38, 0x7C, 0x30, 0x00, 0x00,
    0x00, 0x00, 0x3C, 0x0C, 0x7E, 0x1C, 0xE7, 0x38, 0xC3, 0x30, 0xC3, 0x30, 0xC3, 0x30, 0xC3, 0x30, 0xC7, 0x39, 0x8E, 0x1F, 0x0C, 0x0F, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0xFF, 0x3F, 0xFF, 0x3F, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xFF, 0x07, 0xFF, 0x1F, 0x00, 0x38, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x38, 0xFF, 0x1F, 0xFF, 0x07, 0x00, 0x00,
    0x00, 0x00, 0x07, 0x00, 0x3F, 0x00, 0xF8, 0x01, 0xC0, 0x0F, 0x00, 0x3E, 0x00, 0x3E, 0xC0, 0x0F, 0xF8, 0x01, 0x3F, 0x00, 0x07, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xFF, 0x3F, 0xFF, 0x3F, 0x00, 0x1C, 0x00, 0x06, 0x80, 0x03, 0x80, 0x03, 0x00, 0x06, 0x00, 0x1C, 0xFF, 0x3F, 0xFF, 0x3F, 0x00, 0x00,
    0x00, 0x00, 0x03, 0x30, 0x0F, 0x3C, 0x1C, 0x0E, 0x30, 0x03, 0xE0, 0x01, 0xE0, 0x01, 0x30, 0x03, 0x1C, 0x0E, 0x0F, 0x3C, 0x03, 0x30, 0x00, 0x00,
    0x00, 0x00, 0x03, 0x00, 0x0F, 0x00, 0x3C, 0x00, 0xF0, 0x00, 0xC0, 0x3F, 0xC0, 0x3F, 0xF0, 0x00, 0x3C, 0x00, 0x0F, 0x00, 0x03, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x03, 0x30, 0x03, 0x3C, 0x03, 0x3E, 0x03, 0x33, 0xC3, 0x31, 0xE3, 0x30, 0x33, 0x30, 0x1F, 0x30, 0x0F, 0x30, 0x03, 0x30, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x3F, 0xFF, 0x3F, 0x03, 0x30, 0x03, 0x30, 0x03, 0x30, 0x03, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x0E, 0x00, 0x1C, 0x00, 0x38, 0x00, 0x70, 0x00, 0xE0, 0x00, 0xC0, 0x01, 0x80, 0x03, 0x00, 0x07, 0x00, 0x0E, 0x00, 0x1C, 0x00, 0x18,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x30, 0x03, 0x30, 0x03, 0x30, 0x03, 0x30, 0xFF, 0x3F, 0xFF, 0x3F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x60, 0x00, 0x70, 0x00, 0x38, 0x00, 0x1C, 0x00, 0x0E, 0x00, 0x07, 0x00, 0x0E, 0x00, 0x1C, 0x00, 0x38, 0x00, 0x70, 0x00, 0x60, 0x00,
    0x00, 0x00, 0x00, 0xC0, 0x00, 0xC0, 0x00, 0xC0, 0x00, 0xC0, 0x00, 0xC0, 0x00, 0xC0, 0x00, 0xC0, 0x00, 0xC0, 0x00, 0xC0, 0x00, 0xC0, 0x00, 0xC0,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3E, 0x00, 0x7E, 0x00, 0x4E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x1C, 0x40, 0x3E, 0x60, 0x33, 0x60, 0x33, 0x60, 0x33, 0x60, 0x33, 0x60, 0x33, 0x60, 0x33, 0xE0, 0x3F, 0xC0, 0x3F, 0x00, 0x00,
    0x00, 0x00, 0xFF, 0x3F, 0xFF, 0x3F, 0xC0, 0x30, 0x60, 0x30, 0x60, 0x30, 0x60, 0x30, 0x60, 0x30, 0xE0, 0x38, 0xC0, 0x1F, 0x80, 0x0F, 0x00, 0x00,
    0x00, 0x00, 0x80, 0x0F, 0xC0, 0x1F, 0xE0, 0x38, 0x60, 0x30, 0x60, 0x30, 0x60, 0x30, 0x60, 0x30, 0x60, 0x30, 0xC0, 0x18, 0x80, 0x08, 0x00, 0x00,
    0x00, 0x00, 0x80, 0x0F, 0xC0, 0x1F, 0xE0, 0x38, 0x60, 0x30, 0x60, 0x30, 0x60, 0x30, 0xE0, 0x30, 0xC0, 0x30, 0xFF, 0x3F, 0xFF, 0x3F, 0x00, 0x00,
    0x00, 0x00, 0x80, 0x0F, 0xC0, 0x1F, 0xE0, 0x3B, 0x60, 0x33, 0x60, 0x33, 0x60, 0x33, 0x60, 0x33, 0x60, 0x33, 0xC0, 0x13, 0x80, 0x01, 0x00, 0x00,
    0x00, 0x00, 0xC0, 0x00, 0xC0, 0x00, 0xFC, 0x3F, 0xFE, 0x3F, 0xC7, 0x00, 0xC3, 0x00, 0xC3, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x80, 0x03, 0xC0, 0xC7, 0xE0, 0xCE, 0x60, 0xCC, 0x60, 0xCC, 0x60, 0xCC, 0x60, 0xCC, 0x60, 0xE6, 0xE0, 0x7F, 0xE0, 0x3F, 0x00, 0x00,
    0x00, 0x00, 0xFF, 0x3F, 0xFF, 0x3F, 0xC0, 0x00, 0x60, 0x00, 0x60, 0x00, 0x60, 0x00, 0xE0, 0x00, 0xC0, 0x3F, 0x80, 0x3F, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x60, 0x30, 0xEC, 0x3F, 0xEC, 0x3F, 0x00, 0x30, 0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x00, 0xE0, 0x00, 0xC0, 0x60, 0xC0, 0xEC, 0xFF, 0xEC, 0x7F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0xFF, 0x3F, 0xFF, 0x3F, 0x00, 0x03, 0x80, 0x07, 0xC0, 0x0F, 0xE0, 0x1C, 0x60, 0x38, 0x00, 0x30, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x03, 0x30, 0xFF, 0x3F, 0xFF, 0x3F, 0x00, 0x30, 0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xE0, 0x3F, 0xC0, 0x3F, 0xE0, 0x00, 0xE0, 0x00, 0xC0, 0x3F, 0xC0, 0x3F, 0xE0, 0x00, 0xE0, 0x00, 0xC0, 0x3F, 0x80, 0x3F, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0xE0, 0x3F, 0xE0, 0x3F, 0x60, 0x00, 0x60, 0x00, 0x60, 0x00, 0x60, 0x00, 0xE0, 0x00, 0xC0, 0x3F, 0x80, 0x3F, 0x00, 0x00,
    0x00, 0x00, 0x80, 0x0F, 0xC0, 0x1F, 0xE0, 0x38, 0x60, 0x30, 0x60, 0x30, 0x60, 0x30, 0x60, 0x30, 0xE0, 0x38, 0xC0, 0x1F, 0x80, 0x0F, 0x00, 0x00,
    0x00, 0x00, 0xE0, 0xFF, 0xE0, 0xFF, 0x60, 0x0C, 0x60, 0x18, 0x60, 0x18, 0x60, 0x18, 0x60, 0x18, 0xE0, 0x1C, 0xC0, 0x0F, 0x80, 0x07, 0x00, 0x00,
    0x00, 0x00, 0x80, 0x07, 0xC0, 0x0F, 0xE0, 0x1C, 0x60, 0x18, 0x60, 0x18, 0x60, 0x18, 0x60, 0x18, 0x60, 0x0C, 0xE0, 0xFF, 0xE0, 0xFF, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0xE0, 0x3F, 0xE0, 0x3F, 0xC0, 0x00, 0x60, 0x00, 0x60, 0x00, 0x60, 0x00, 0x60, 0x00, 0xE0, 0x00, 0xC0, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xC0, 0x11, 0xE0, 0x33, 0x60, 0x33, 0x60, 0x33, 0x60, 0x33, 0x60, 0x33, 0x60, 0x3F, 0x40, 0x1E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x60, 0x00, 0x60, 0x00, 0xFE, 0x1F, 0xFE, 0x3F, 0x60, 0x30, 0x60, 0x30, 0x60, 0x30, 0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xE0, 0x0F, 0xE0, 0x1F, 0x00, 0x38, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x18, 0xE0, 0x3F, 0xE0, 0x3F, 0x00, 0x00,
    0x00, 0x00, 0x60, 0x00, 0xE0, 0x01, 0x80, 0x07, 0x00, 0x1E, 0x00, 0x38, 0x00, 0x38, 0x00, 0x1E, 0x80, 0x07, 0xE0, 0x01, 0x60, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xE0, 0x07, 0xE0, 0x1F, 0x00, 0x38, 0x00, 0x1C, 0xE0, 0x0F, 0xE0, 0x0F, 0x00, 0x1C, 0x00, 0x38, 0xE0, 0x1F, 0xE0, 0x07, 0x00, 0x00,
    0x00, 0x00, 0x60, 0x30, 0xE0, 0x38, 0xC0, 0x1D, 0x80, 0x0F, 0x00, 0x07, 0x80, 0x0F, 0xC0, 0x1D, 0xE0, 0x38, 0x60, 0x30, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x60, 0x00, 0xE0, 0x81, 0x80, 0xE7, 0x00, 0x7E, 0x00, 0x1E, 0x80, 0x07, 0xE0, 0x01, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x60, 0x30, 0x60, 0x38, 0x60, 0x3C, 0x60, 0x36, 0x60, 0x33, 0xE0, 0x31, 0xE0, 0x30, 0x60, 0x30, 0x20, 0x30, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0xC0, 0x01, 0xFC, 0x1F, 0x7E, 0x3F, 0x07, 0x70, 0x03, 0x60, 0x03, 0x60, 0x03, 0x60, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xBF, 0x3F, 0xBF, 0x3F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x03, 0x60, 0x03, 0x60, 0x03, 0x60, 0x07, 0x70, 0x7E, 0x3F, 0xFC, 0x1F, 0xC0, 0x01, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x10, 0x00, 0x18, 0x00, 0x0C, 0x00, 0x04, 0x00, 0x0C, 0x00, 0x18, 0x00, 0x10, 0x00, 0x18, 0x00, 0x0C, 0x00, 0x04, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x0F, 0x80, 0x0F, 0xC0, 0x0C, 0x60, 0x0C, 0x30, 0x0C, 0x30, 0x0C, 0x60, 0x0C, 0xC0, 0x0C, 0x80, 0x0F, 0x00, 0x0F, 0x00, 0x00,
    0x00, 0x00, 0x20, 0x01, 0xF0, 0x03, 0xFC, 0x0F, 0x2E, 0x1D, 0x27, 0x39, 0x23, 0x31, 0x23, 0x30, 0x07, 0x3C, 0x06, 0x1C, 0x00, 0x08, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4E, 0x00, 0x7E, 0x00, 0x3E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x10, 0x40, 0x30, 0x60, 0x3E, 0xE0, 0x1F, 0xFC, 0x03, 0x7E, 0x00, 0x66, 0x00, 0x26, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4E, 0x00, 0x7E, 0x00, 0x3E, 0x00, 0x00, 0x00, 0x4E, 0x00, 0x7E, 0x00, 0x3E, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x38, 0x00, 0x38, 0x00, 0x38, 0x00, 0x00, 0x00, 0x38, 0x00, 0x38, 0x00, 0x38, 0x00, 0x00, 0x00, 0x38, 0x00, 0x38, 0x00, 0x38,
    0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0xFE, 0x3F, 0xFE, 0x3F, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x30, 0x06, 0x30, 0x06, 0x30, 0x06, 0xFE, 0x3F, 0xFE, 0x3F, 0x30, 0x06, 0x30, 0x06, 0x30, 0x06, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x18, 0x00, 0x0C, 0x00, 0x0C, 0x00, 0x18, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x30, 0x38, 0x38, 0x38, 0x1C, 0x38, 0x0E, 0x00, 0x07, 0x80, 0x03, 0xC0, 0x39, 0xE0, 0x38, 0x70, 0x00, 0x38, 0x38, 0x18, 0x38,
    0x00, 0x00, 0x70, 0x0C, 0xF8, 0x1C, 0xDC, 0x39, 0x8D, 0x31, 0x8F, 0x31, 0x8E, 0x31, 0x8F, 0x31, 0x9D, 0x3B, 0x38, 0x1F, 0x30, 0x0E, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0xC0, 0x01, 0x60, 0x03, 0x20, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xF0, 0x03, 0xFC, 0x0F, 0x0E, 0x1C, 0x07, 0x38, 0x03, 0x30, 0xFF, 0x3F, 0xFF, 0x3F, 0xC3, 0x30, 0xC3, 0x30, 0x03, 0x30, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x18, 0x30, 0x18, 0x38, 0x19, 0x3C, 0x1B, 0x36, 0x1E, 0x33, 0x9E, 0x31, 0xDB, 0x30, 0x79, 0x30, 0x38, 0x30, 0x18, 0x30, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7C, 0x00, 0x7E, 0x00, 0x72, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4E, 0x00, 0x7E, 0x00, 0x3E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7C, 0x00, 0x7E, 0x00, 0x72, 0x00, 0x00, 0x00, 0x7C, 0x00, 0x7E, 0x00, 0x72, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4E, 0x00, 0x7E, 0x00, 0x3E, 0x00, 0x00, 0x00, 0x4E, 0x00, 0x7E, 0x00, 0x3E, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x01, 0xE0, 0x03, 0xE0, 0x03, 0xE0, 0x03, 0xC0, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x00, 0xC0, 0x00, 0xC0, 0x00, 0xC0, 0x00, 0xC0, 0x00, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xC0, 0x00, 0xC0, 0x00, 0xC0, 0x00, 0xC0, 0x00, 0xC0, 0x00, 0xC0, 0x00, 0xC0, 0x00, 0xC0, 0x00, 0xC0, 0x00, 0xC0, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0xC0, 0x00, 0x40, 0x00, 0xC0, 0x00, 0x80, 0x00, 0xC0, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x02, 0x00, 0x02, 0x00, 0x3E, 0x00, 0x02, 0x00, 0x02, 0x00, 0x3E, 0x00, 0x04, 0x00, 0x08, 0x00, 0x04, 0x00, 0x3E, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xC0, 0x11, 0xE0, 0x33, 0x60, 0x33, 0x64, 0x33, 0x68, 0x33, 0x64, 0x33, 0x60, 0x3F, 0x40, 0x1E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x02, 0x60, 0x03, 0xC0, 0x01, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x80, 0x0F, 0xC0, 0x1F, 0xE0, 0x38, 0x60, 0x30, 0xE0, 0x38, 0xC0, 0x1F, 0x60, 0x33, 0x60, 0x33, 0x60, 0x33, 0xC0, 0x13, 0x80, 0x01,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x60, 0x30, 0x60, 0x38, 0x60, 0x3C, 0x64, 0x36, 0x68, 0x33, 0xE4, 0x31, 0xE0, 0x30, 0x60, 0x30, 0x20, 0x30, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x08, 0x00, 0x18, 0x00, 0x33, 0x00, 0x63, 0x00, 0xC0, 0x3F, 0xC0, 0x3F, 0x63, 0x00, 0x33, 0x00, 0x18, 0x00, 0x08, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3E, 0xCC, 0xFF, 0xCC, 0xFF, 0x00, 0x3E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0xE0, 0x03, 0xF0, 0x07, 0x38, 0x0E, 0xFE, 0x3F, 0xFE, 0x3F, 0x18, 0x0C, 0x38, 0x0E, 0x30, 0x06, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x80, 0x08, 0xC0, 0x1C, 0xF8, 0x1F, 0xFC, 0x0F, 0xCE, 0x0C, 0xC6, 0x0C, 0xC6, 0x1C, 0x4C, 0x18, 0x08, 0x08, 0x00, 0x00,
    0x00, 0x00, 0xF6, 0x1B, 0xFE, 0x1F, 0x18, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x18, 0x06, 0xFE, 0x1F, 0xF6, 0x1B, 0x00, 0x00,
    0x00, 0x00, 0x03, 0x00, 0x0F, 0x0A, 0x3C, 0x0A, 0xF0, 0x0A, 0xC0, 0x3F, 0xC0, 0x3F, 0xF0, 0x0A, 0x3C, 0x0A, 0x0F, 0x0A, 0x03, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3F, 0x3F, 0x3F, 0x3F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0xDC, 0x08, 0xFE, 0x19, 0x22, 0x11, 0x22, 0x11, 0x22, 0x11, 0x22, 0x11, 0xE6, 0x1F, 0xC4, 0x0E, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x00, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x00, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xF0, 0x07, 0xF8, 0x0F, 0x1C, 0x1C, 0xCC, 0x19, 0xEC, 0x1B, 0x2C, 0x1A, 0x6C, 0x1B, 0x4C, 0x19, 0x1C, 0x1C, 0xF8, 0x0F, 0xF0, 0x07,
    0x00, 0x00, 0x70, 0x00, 0xFA, 0x06, 0xDB, 0x06, 0xDB, 0x06, 0xDB, 0x06, 0xDB, 0x06, 0xDB, 0x06, 0xDB, 0x06, 0xFF, 0x06, 0xFE, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x80, 0x00, 0xC0, 0x01, 0x60, 0x03, 0x20, 0x02, 0x00, 0x00, 0x80, 0x00, 0xC0, 0x01, 0x60, 0x03, 0x20, 0x02, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0xC0, 0x00, 0xC0, 0x00, 0xC0, 0x00, 0xC0, 0x00, 0xC0, 0x00, 0xC0, 0x00, 0xC0, 0x07, 0xC0, 0x07, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xF0, 0x07, 0xF8, 0x0F, 0x1C, 0x1C, 0xEC, 0x1B, 0xEC, 0x1B, 0xAC, 0x18, 0xEC, 0x1B, 0x4C, 0x1B, 0x1C, 0x1C, 0xF8, 0x0F, 0xF0, 0x07,
    0x00, 0x00, 0x0C, 0x00, 0x0C, 0x00, 0x0C, 0x00, 0x0C, 0x00, 0x0C, 0x00, 0x0C, 0x00, 0x0C, 0x00, 0x0C, 0x00, 0x0C, 0x00, 0x0C, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1E, 0x00, 0x3F, 0x00, 0x33, 0x00, 0x33, 0x00, 0x3F, 0x00, 0x1E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x18, 0xC0, 0x18, 0xF0, 0x1B, 0xF0, 0x1B, 0xC0, 0x18, 0xC0, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x19, 0x00, 0x1D, 0x00, 0x15, 0x00, 0x17, 0x00, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x11, 0x00, 0x15, 0x00, 0x15, 0x00, 0x1F, 0x00, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x18, 0x00, 0x0C, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xF0, 0xFF, 0xF0, 0xFF, 0x00, 0x06, 0x00, 0x0C, 0x00, 0x0C, 0x00, 0x0C, 0x00, 0x0E, 0xF0, 0x07, 0xF0, 0x03, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x38, 0x00, 0x7C, 0x00, 0xC6, 0x00, 0x82, 0x00, 0xFE, 0x3F, 0xFE, 0x3F, 0x02, 0x00, 0xFE, 0x3F, 0xFE, 0x3F, 0x02, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x80, 0x07, 0x80, 0x07, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x20, 0x00, 0x30, 0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x1F, 0x00, 0x1F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x0E, 0x00, 0x11, 0x00, 0x11, 0x00, 0x0E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x20, 0x02, 0x60, 0x03, 0xC0, 0x01, 0x80, 0x00, 0x00, 0x00, 0x20, 0x02, 0x60, 0x03, 0xC0, 0x01, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x48, 0x00, 0x7C, 0x04, 0x7C, 0x06, 0x40, 0x03, 0x80, 0x01, 0xC0, 0x06, 0x60, 0x07, 0x30, 0x04, 0x10, 0x1F, 0x00, 0x1F, 0x00, 0x00,
    0x00, 0x00, 0x48, 0x00, 0x7C, 0x04, 0x7C, 0x06, 0x40, 0x03, 0x80, 0x01, 0xC0, 0x00, 0x60, 0x19, 0x30, 0x1D, 0x10, 0x17, 0x00, 0x12, 0x00, 0x00,
    0x00, 0x00, 0x44, 0x00, 0x54, 0x04, 0x7C, 0x06, 0x28, 0x03, 0x80, 0x01, 0xC0, 0x06, 0x60, 0x07, 0x30, 0x04, 0x10, 0x1F, 0x00, 0x1F, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x0E, 0x00, 0x1F, 0x80, 0x3B, 0xC0, 0x31, 0xFB, 0x30, 0x7B, 0x30, 0x00, 0x30, 0x00, 0x38, 0x00, 0x1E, 0x00, 0x0E, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x38, 0x00, 0x3E, 0x80, 0x0F, 0xE1, 0x0D, 0x73, 0x0C, 0x76, 0x0C, 0xE4, 0x0D, 0x80, 0x0F, 0x00, 0x3E, 0x00, 0x38, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x38, 0x00, 0x3E, 0x80, 0x0F, 0xE4, 0x0D, 0x76, 0x0C, 0x73, 0x0C, 0xE1, 0x0D, 0x80, 0x0F, 0x00, 0x3E, 0x00, 0x38, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x38, 0x00, 0x3E, 0x84, 0x0F, 0xE6, 0x0D, 0x73, 0x0C, 0x73, 0x0C, 0xE6, 0x0D, 0x84, 0x0F, 0x00, 0x3E, 0x00, 0x38, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x38, 0x00, 0x3E, 0x82, 0x0F, 0xE3, 0x0D, 0x79, 0x0C, 0x7B, 0x0C, 0xE2, 0x0D, 0x83, 0x0F, 0x01, 0x3E, 0x00, 0x38, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x38, 0x00, 0x3E, 0x83, 0x0F, 0xE3, 0x0D, 0x78, 0x0C, 0x78, 0x0C, 0xE3, 0x0D, 0x83, 0x0F, 0x00, 0x3E, 0x00, 0x38, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x38, 0x00, 0x3E, 0x80, 0x0F, 0xE2, 0x0D, 0x75, 0x0C, 0x75, 0x0C, 0xE2, 0x0D, 0x80, 0x0F, 0x00, 0x3E, 0x00, 0x38, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x38, 0x00, 0x3F, 0xE0, 0x07, 0xFC, 0x06, 0x1F, 0x06, 0xFF, 0x3F, 0xFF, 0x3F, 0xC3, 0x30, 0xC3, 0x30, 0x03, 0x30, 0x00, 0x00,
    0x00, 0x00, 0xF0, 0x03, 0xFC, 0x0F, 0x0E, 0x1C, 0x07, 0x38, 0x03, 0xB0, 0x03, 0xF0, 0x03, 0xF0, 0x07, 0x38, 0x0E, 0x1C, 0x0C, 0x0C, 0x00, 0x00,
    0x00, 0x00, 0xF8, 0x3F, 0xF8, 0x3F, 0x99, 0x31, 0x9B, 0x31, 0x9E, 0x31, 0x9C, 0x31, 0x98, 0x31, 0x98, 0x31, 0x18, 0x30, 0x18, 0x30, 0x00, 0x00,
    0x00, 0x00, 0xF8, 0x3F, 0xF8, 0x3F, 0x98, 0x31, 0x98, 0x31, 0x9C, 0x31, 0x9E, 0x31, 0x9B, 0x31, 0x99, 0x31, 0x18, 0x30, 0x18, 0x30, 0x00, 0x00,
    0x00, 0x00, 0xF8, 0x3F, 0xF8, 0x3F, 0x9C, 0x31, 0x9E, 0x31, 0x9B, 0x31, 0x9B, 0x31, 0x9E, 0x31, 0x9C, 0x31, 0x18, 0x30, 0x18, 0x30, 0x00, 0x00,
    0x00, 0x00, 0xF8, 0x3F, 0xF8, 0x3F, 0x9B, 0x31, 0x9B, 0x31, 0x98, 0x31, 0x98, 0x31, 0x9B, 0x31, 0x9B, 0x31, 0x18, 0x30, 0x18, 0x30, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0x30, 0x1B, 0x30, 0xFE, 0x3F, 0xFC, 0x3F, 0x18, 0x30, 0x18, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x30, 0x18, 0x30, 0xFC, 0x3F, 0xFE, 0x3F, 0x1B, 0x30, 0x19, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1C, 0x30, 0x1E, 0x30, 0xFB, 0x3F, 0xFB, 0x3F, 0x1E, 0x30, 0x1C, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1B, 0x30, 0x1B, 0x30, 0xF8, 0x3F, 0xF8, 0x3F, 0x1B, 0x30, 0x1B, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xC0, 0x00, 0xFF, 0x3F, 0xFF, 0x3F, 0xC3, 0x30, 0x03, 0x30, 0x03, 0x30, 0x07, 0x38, 0x0E, 0x1C, 0xFC, 0x0F, 0xF0, 0x03, 0x00, 0x00,
    0x00, 0x00, 0xF8, 0x3F, 0xF8, 0x3F, 0x72, 0x00, 0xE3, 0x00, 0xC1, 0x01, 0x83, 0x03, 0x02, 0x07, 0x03, 0x0E, 0xF9, 0x3F, 0xF8, 0x3F, 0x00, 0x00,
    0x00, 0x00, 0xE0, 0x0F, 0xF0, 0x1F, 0x39, 0x38, 0x1B, 0x30, 0x1E, 0x30, 0x1C, 0x30, 0x18, 0x30, 0x38, 0x38, 0xF0, 0x1F, 0xE0, 0x0F, 0x00, 0x00,
    0x00, 0x00, 0xE0, 0x0F, 0xF0, 0x1F, 0x38, 0x38, 0x18, 0x30, 0x1C, 0x30, 0x1E, 0x30, 0x1B, 0x30, 0x39, 0x38, 0xF0, 0x1F, 0xE0, 0x0F, 0x00, 0x00,
    0x00, 0x00, 0xE0, 0x0F, 0xF0, 0x1F, 0x3C, 0x38, 0x1E, 0x30, 0x1B, 0x30, 0x1B, 0x30, 0x1E, 0x30, 0x3C, 0x38, 0xF0, 0x1F, 0xE0, 0x0F, 0x00, 0x00,
    0x00, 0x00, 0xE0, 0x0F, 0xF0, 0x1F, 0x3A, 0x38, 0x1B, 0x30, 0x19, 0x30, 0x1B, 0x30, 0x1A, 0x30, 0x3B, 0x38, 0xF1, 0x1F, 0xE0, 0x0F, 0x00, 0x00,
    0x00, 0x00, 0xE0, 0x0F, 0xF0, 0x1F, 0x3B, 0x38, 0x1B, 0x30, 0x18, 0x30, 0x18, 0x30, 0x1B, 0x30, 0x3B, 0x38, 0xF0, 0x1F, 0xE0, 0x0F, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x40, 0x10, 0xC0, 0x18, 0x80, 0x0D, 0x00, 0x07, 0x00, 0x07, 0x80, 0x0D, 0xC0, 0x18, 0x40, 0x10, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xF0, 0x2F, 0xF8, 0x3F, 0x1C, 0x18, 0x0C, 0x3E, 0x8C, 0x37, 0xEC, 0x31, 0x7C, 0x30, 0x18, 0x38, 0xFC, 0x1F, 0xF4, 0x0F, 0x00, 0x00,
    0x00, 0x00, 0xF8, 0x07, 0xF8, 0x1F, 0x01, 0x38, 0x03, 0x30, 0x06, 0x30, 0x04, 0x30, 0x00, 0x30, 0x00, 0x38, 0xF8, 0x1F, 0xF8, 0x07, 0x00, 0x00,
    0x00, 0x00, 0xF8, 0x07, 0xF8, 0x1F, 0x00, 0x38, 0x00, 0x30, 0x04, 0x30, 0x06, 0x30, 0x03, 0x30, 0x01, 0x38, 0xF8, 0x1F, 0xF8, 0x07, 0x00, 0x00,
    0x00, 0x00, 0xF8, 0x07, 0xF8, 0x1F, 0x04, 0x38, 0x06, 0x30, 0x03, 0x30, 0x03, 0x30, 0x06, 0x30, 0x04, 0x38, 0xF8, 0x1F, 0xF8, 0x07, 0x00, 0x00,
    0x00, 0x00, 0xF8, 0x07, 0xF8, 0x1F, 0x03, 0x38, 0x03, 0x30, 0x00, 0x30, 0x00, 0x30, 0x03, 0x30, 0x03, 0x38, 0xF8, 0x1F, 0xF8, 0x07, 0x00, 0x00,
    0x00, 0x00, 0x08, 0x00, 0x18, 0x00, 0x30, 0x00, 0x60, 0x00, 0xC4, 0x3F, 0xC6, 0x3F, 0x63, 0x00, 0x31, 0x00, 0x18, 0x00, 0x08, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x0C, 0x30, 0xFC, 0x3F, 0xFC, 0x3F, 0x6C, 0x36, 0x60, 0x06, 0x60, 0x06, 0xE0, 0x07, 0xC0, 0x03, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0xC0, 0xFF, 0xE0, 0xFF, 0x30, 0x21, 0x10, 0x21, 0x10, 0x21, 0x30, 0x33, 0xE0, 0x3F, 0xC0, 0x1E, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x1C, 0x40, 0x3E, 0x60, 0x33, 0x62, 0x33, 0x66, 0x33, 0x6C, 0x33, 0x68, 0x33, 0x60, 0x33, 0xE0, 0x3F, 0xC0, 0x3F, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x1C, 0x40, 0x3E, 0x60, 0x33, 0x68, 0x33, 0x6C, 0x33, 0x66, 0x33, 0x62, 0x33, 0x60, 0x33, 0xE0, 0x3F, 0xC0, 0x3F, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x1C, 0x40, 0x3E, 0x68, 0x33, 0x6C, 0x33, 0x66, 0x33, 0x66, 0x33, 0x6C, 0x33, 0x68, 0x33, 0xE0, 0x3F, 0xC0, 0x3F, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x1C, 0x40, 0x3E, 0x68, 0x33, 0x6C, 0x33, 0x64, 0x33, 0x6C, 0x33, 0x68, 0x33, 0x6C, 0x33, 0xE4, 0x3F, 0xC0, 0x3F, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x1C, 0x40, 0x3E, 0x6C, 0x33, 0x6C, 0x33, 0x60, 0x33, 0x60, 0x33, 0x6C, 0x33, 0x6C, 0x33, 0xE0, 0x3F, 0xC0, 0x3F, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x1C, 0x40, 0x3E, 0x60, 0x33, 0x60, 0x33, 0x6E, 0x33, 0x6A, 0x33, 0x6E, 0x33, 0x60, 0x33, 0xE0, 0x3F, 0xC0, 0x3F, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x1C, 0x40, 0x3E, 0x60, 0x33, 0x60, 0x33, 0xE0, 0x3F, 0xC0, 0x1F, 0x60, 0x33, 0x60, 0x33, 0xE0, 0x31, 0xC0, 0x10, 0x00, 0x00,
    0x00, 0x00, 0x80, 0x0F, 0xC0, 0x1F, 0xE0, 0x38, 0x60, 0x30, 0x60, 0xB0, 0x60, 0xF0, 0x60, 0xF0, 0x60, 0x30, 0xC0, 0x18, 0x80, 0x08, 0x00, 0x00,
    0x00, 0x00, 0x80, 0x0F, 0xC0, 0x1F, 0xE0, 0x3B, 0x62, 0x33, 0x66, 0x33, 0x6C, 0x33, 0x68, 0x33, 0x60, 0x33, 0xC0, 0x13, 0x80, 0x01, 0x00, 0x00,
    0x00, 0x00, 0x80, 0x0F, 0xC0, 0x1F, 0xE0, 0x3B, 0x68, 0x33, 0x6C, 0x33, 0x66, 0x33, 0x62, 0x33, 0x60, 0x33, 0xC0, 0x13, 0x80, 0x01, 0x00, 0x00,
    0x00, 0x00, 0x80, 0x0F, 0xC0, 0x1F, 0xE8, 0x3B, 0x6C, 0x33, 0x66, 0x33, 0x66, 0x33, 0x6C, 0x33, 0x68, 0x33, 0xC0, 0x13, 0x80, 0x01, 0x00, 0x00,
    0x00, 0x00, 0x80, 0x0F, 0xC0, 0x1F, 0xE6, 0x3B, 0x66, 0x33, 0x60, 0x33, 0x60, 0x33, 0x66, 0x33, 0x66, 0x33, 0xC0, 0x13, 0x80, 0x01, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x62, 0x30, 0xE6, 0x3F, 0xEC, 0x3F, 0x08, 0x30, 0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x68, 0x30, 0xEC, 0x3F, 0xE6, 0x3F, 0x02, 0x30, 0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x30, 0x6C, 0x30, 0xE6, 0x3F, 0xE6, 0x3F, 0x0C, 0x30, 0x08, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x30, 0x66, 0x30, 0xE0, 0x3F, 0xE0, 0x3F, 0x06, 0x30, 0x06, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x80, 0x0F, 0xC0, 0x1F, 0xE0, 0x38, 0x6A, 0x30, 0x6E, 0x30, 0x64, 0x30, 0x6E, 0x30, 0xFA, 0x38, 0xD0, 0x1F, 0x80, 0x0F, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0xE0, 0x3F, 0xE8, 0x3F, 0x6C, 0x00, 0x64, 0x00, 0x6C, 0x00, 0x68, 0x00, 0xEC, 0x00, 0xC4, 0x3F, 0x80, 0x3F, 0x00, 0x00,
    0x00, 0x00, 0x80, 0x0F, 0xC0, 0x1F, 0xE0, 0x38, 0x62, 0x30, 0x66, 0x30, 0x6C, 0x30, 0x68, 0x30, 0xE0, 0x38, 0xC0, 0x1F, 0x80, 0x0F, 0x00, 0x00,
    0x00, 0x00, 0x80, 0x0F, 0xC0, 0x1F, 0xE0, 0x38, 0x68, 0x30, 0x6C, 0x30, 0x66, 0x30, 0x62, 0x30, 0xE0, 0x38, 0xC0, 0x1F, 0x80, 0x0F, 0x00, 0x00,
    0x00, 0x00, 0x80, 0x0F, 0xC0, 0x1F, 0xE8, 0x38, 0x6C, 0x30, 0x66, 0x30, 0x66, 0x30, 0x6C, 0x30, 0xE8, 0x38, 0xC0, 0x1F, 0x80, 0x0F, 0x00, 0x00,
    0x00, 0x00, 0x80, 0x0F, 0xC0, 0x1F, 0xE8, 0x38, 0x6C, 0x30, 0x64, 0x30, 0x6C, 0x30, 0x68, 0x30, 0xEC, 0x38, 0xC4, 0x1F, 0x80, 0x0F, 0x00, 0x00,
    0x00, 0x00, 0x80, 0x0F, 0xC0, 0x1F, 0xE6, 0x38, 0x66, 0x30, 0x60, 0x30, 0x60, 0x30, 0x66, 0x30, 0xE6, 0x38, 0xC0, 0x1F, 0x80, 0x0F, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0xB0, 0x0D, 0xB0, 0x0D, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x80, 0x2F, 0xC0, 0x1F, 0xE0, 0x38, 0x60, 0x34, 0x60, 0x32, 0x60, 0x31, 0xE0, 0x38, 0xC0, 0x1F, 0xA0, 0x0F, 0x00, 0x00,
    0x00, 0x00, 0xE0, 0x0F, 0xE0, 0x1F, 0x00, 0x38, 0x02, 0x30, 0x06, 0x30, 0x0C, 0x30, 0x08, 0x30, 0x00, 0x18, 0xE0, 0x3F, 0xE0, 0x3F, 0x00, 0x00,
    0x00, 0x00, 0xE0, 0x0F, 0xE0, 0x1F, 0x00, 0x38, 0x08, 0x30, 0x0C, 0x30, 0x06, 0x30, 0x02, 0x30, 0x00, 0x18, 0xE0, 0x3F, 0xE0, 0x3F, 0x00, 0x00,
    0x00, 0x00, 0xE0, 0x0F, 0xE0, 0x1F, 0x08, 0x38, 0x0C, 0x30, 0x06, 0x30, 0x06, 0x30, 0x0C, 0x30, 0x08, 0x18, 0xE0, 0x3F, 0xE0, 0x3F, 0x00, 0x00,
    0x00, 0x00, 0xE0, 0x0F, 0xE0, 0x1F, 0x0C, 0x38, 0x0C, 0x30, 0x00, 0x30, 0x00, 0x30, 0x0C, 0x30, 0x0C, 0x18, 0xE0, 0x3F, 0xE0, 0x3F, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x60, 0x00, 0xE0, 0x81, 0x80, 0xE7, 0x10, 0x7E, 0x18, 0x1E, 0x8C, 0x07, 0xE4, 0x01, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x03, 0x30, 0xFF, 0x3F, 0xFF, 0x3F, 0x1B, 0x36, 0x18, 0x06, 0x18, 0x06, 0xF8, 0x07, 0xF0, 0x03, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x60, 0x00, 0xEC, 0x81, 0x8C, 0xE7, 0x00, 0x7E, 0x00, 0x1E, 0x8C, 0x07, 0xEC, 0x01, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00
};

#endif
