# Pervasive Displays Library Suite - Basic edition - Common library

[![Release](https://img.shields.io/github/v/release/rei-vilo/PDLS_Common)](https://github.com/rei-vilo/PDLS_Common/releases) [![Codacy Badge](https://app.codacy.com/project/badge/Grade/6ced75939ad648c3bcba058b58c65871)](https://app.codacy.com/gh/rei-vilo/PDLS_Common/dashboard?utm_source=gh&utm_medium=referral&utm_content=&utm_campaign=Badge_grade) ![Arduino lint](https://github.com/rei-vilo/PDLS_Common/actions/workflows/main.yml/badge.svg) [![GitHub issues](https://img.shields.io/github/issues/rei-vilo/PDLS_Common)](https://github.com/rei-vilo/PDLS_Common/issues)

[![](https://img.shields.io/badge/-Wiki-blue)](https://docs.pervasivedisplays.com/) [![](https://img.shields.io/badge/-User_Guide-blue)](https://pdls.pervasivedisplays.com/userguide/index.html) [![](https://img.shields.io/badge/-Reference_Manual-blue)](https://pdls.pervasivedisplays.com/reference/html/index.html)

The Pervasive Displays Library Suite is specifically designed for the [Pervasive Displays](https://www.pervasivedisplays.com) e-paper screens, extension boards and evaluation kits.

![](https://pdls.pervasivedisplays.com/userguide/img/Logo_PDI_text_320.png)

Release 9 inaugurates a new structure based on drivers developed by Pervasive Displays.

## Features

The **PDLS_Common** library provides a light hardware abstraction layer with C-like syntax for C and C++ SDKs. It is required by the drivers and the PDLS library.

* Intermediate layer as foundation for all the extensions
* Low level utilities

## Documentation

* [Pervasive Displays Technical Wiki](https://docs.pervasivedisplays.com/) 
* [User guide](https://pdls.pervasivedisplays.com/userguide/index.html) with commented examples
* [Reference manual](https://pdls.pervasivedisplays.com/reference/html/index.html) 

## Support

* Please refer to the [PDLS_Common](https://github.com/rei-vilo/PDLS_Common/issues) repository for reporting issues and contributing pull requests.

## Installation

Software

* [Arduino IDE](https://www.arduino.cc/en/software) or [Arduino CLI](https://arduino.github.io/arduino-cli/)
* [Installing Additional Arduino Libraries](https://www.arduino.cc/en/guide/libraries)

    + Using the Library Manager
    + Importing a `.zip` Library

Hardware

* [Connecting the Pervasive Displays e-Paper EPD Extension Kit Gen 3](https://embeddedcomputing.weebly.com/connecting-the-e-paper-epd-extension-kit-gen-3.html)

## Configuration

Software

* Arduino SDK
* SPI library
* Wire library

Hardware

* Pervasive Displays EPD Extension Kit Gen 3 (EXT3 or EXT3.1)
* ![](https://img.shields.io/badge/-New-orange) Pervasive Displays EPD Extension Kit Gen 4 (EXT4)
* See the requirements for the PDLS Basic edition

## Licence

**Copyright** &copy; Rei Vilo, 2010-2025

*For exclusive use with Pervasive Displays screens*

**Licence** [Attribution-ShareAlike 4.0 International (CC BY-SA 4.0)](./LICENCE.md)

![](img/by-sa.svg)

