///
/// @file Terminal16x24e.h
/// @brief Font Terminal 16 x 24
///
/// @details Project Pervasive Displays Library Suite
/// @n Based on highView technology
///
/// @author Rei Vilo
/// @date 21 Jan 2025
/// @version 902
///
/// @copyright (c) Rei Vilo, 2010-2025
/// @copyright All rights reserved
/// @copyright For exclusive use with Pervasive Displays screens
///
/// * Basic edition: for hobbyists and for basic usage
/// @n Creative Commons Attribution-ShareAlike 4.0 International (CC BY-SA 4.0)
/// @see https://creativecommons.org/licenses/by-sa/4.0/
///
/// @n Consider the Evaluation or Commercial editions for professionals or organisations and for commercial usage
///
/// * Evaluation edition: for professionals or organisations, evaluation only, no commercial usage
/// @n All rights reserved
///
/// * Commercial edition: for professionals or organisations, commercial usage
/// @n All rights reserved
///
/// * Viewer edition: for professionals or organisations
/// @n All rights reserved
///
/// * Documentation
/// @n All rights reserved
///

//
// Terminal16e.h
// Font library
// ----------------------------------
//
// Project Pervasive Displays Library Suite
// Based on highView technology
//  Created by Rei Vilo on 26 May 2012
//  Copyright Rei Vilo
//  Licence All rights reserved
//

#ifndef TERMINAL16E_FONT_RELEASE
///
/// @brief Library release number
///
#define TERMINAL16E_FONT_RELEASE 902

///
/// @brief Font Terminal16x24
/// @details GLCD FontName : Terminal11x16
/// @n GLCD FontSize : 16 x 24
///
/// @copyright Font generated manually
///
// #if defined(ENERGIA)
// unsigned char replaced by uint8_t
static const uint8_t Terminal16x24e[224][48] =
    // #elif defined(ARDUINO) || defined(MPIDE) || defined(WIRING)
    // static prog_uchar Terminal16x24e[224][48] PROGMEM =
    // #endif
{
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x3F, 0x07, 0xFC, 0x3F, 0x07, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char !
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00, 0xFC, 0x00, 0x00, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00, 0xFC, 0x00, 0x00, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char "
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x00, 0x00, 0x63, 0x00, 0x00, 0xE3, 0x07, 0x00, 0xFF, 0x07, 0xF0, 0x7F, 0x00, 0xF0, 0x63, 0x00, 0x00, 0xE3, 0x07, 0x00, 0xFF, 0x07, 0xF0, 0x7F, 0x00, 0xF0, 0x63, 0x00, 0x00, 0x63, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00 }, // Code for char #
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xE0, 0x01, 0x03, 0xF0, 0x03, 0x06, 0x30, 0x07, 0x06, 0x18, 0x06, 0x3F, 0x18, 0xFF, 0x3F, 0xFE, 0x3F, 0x06, 0x1E, 0x1C, 0x06, 0x18, 0x18, 0x03, 0x18, 0xF0, 0x03, 0x00, 0xE0, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char $
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x04, 0xF8, 0x01, 0x06, 0x8C, 0x81, 0x03, 0x8C, 0xC1, 0x01, 0x8C, 0x71, 0x00, 0xFC, 0x1C, 0x00, 0x78, 0xCE, 0x03, 0x80, 0xE3, 0x07, 0xC0, 0x31, 0x06, 0x70, 0x30, 0x06, 0x38, 0x30, 0x06, 0x0C, 0xF0, 0x03, 0x04, 0xE0, 0x01, 0x00, 0x00, 0x00 }, // Code for char %
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x01, 0xF0, 0xF8, 0x03, 0xF8, 0x1F, 0x07, 0x1C, 0x0F, 0x06, 0x0C, 0x1E, 0x06, 0x0C, 0x3B, 0x06, 0x9C, 0x73, 0x07, 0xF8, 0xE1, 0x03, 0xF0, 0xC0, 0x03, 0x00, 0xF8, 0x07, 0x00, 0x38, 0x06, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00 }, // Code for char &
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00, 0xFC, 0x00, 0x00, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char '
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x01, 0x80, 0xFF, 0x07, 0xC0, 0x03, 0x1F, 0x70, 0x00, 0x38, 0x38, 0x00, 0x70, 0x1C, 0x00, 0xE0, 0x08, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char (
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x40, 0x1C, 0x00, 0xE0, 0x38, 0x00, 0x70, 0x70, 0x00, 0x38, 0xE0, 0x03, 0x0F, 0x80, 0xFF, 0x07, 0x00, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char )
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x03, 0x00, 0x30, 0x03, 0x00, 0x20, 0x01, 0x00, 0xC0, 0x00, 0x00, 0xFC, 0x0F, 0x00, 0xFC, 0x0F, 0x00, 0xC0, 0x00, 0x00, 0x20, 0x01, 0x00, 0x30, 0x03, 0x00, 0x20, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char *
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x18, 0x00, 0x00, 0x18, 0x00, 0x00, 0x18, 0x00, 0x00, 0x18, 0x00, 0xC0, 0xFF, 0x03, 0xC0, 0xFF, 0x03, 0x00, 0x18, 0x00, 0x00, 0x18, 0x00, 0x00, 0x18, 0x00, 0x00, 0x18, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00 }, // Code for char +
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x00, 0x00, 0x60, 0x00, 0x80, 0x73, 0x00, 0x80, 0x3F, 0x00, 0x80, 0x1F, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char ,
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00, 0x30, 0x00, 0x00, 0x30, 0x00, 0x00, 0x30, 0x00, 0x00, 0x30, 0x00, 0x00, 0x30, 0x00, 0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char -
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x80, 0x07, 0x00, 0x80, 0x07, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char .
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x3C, 0x00, 0x00, 0x1F, 0x00, 0xE0, 0x03, 0x00, 0xF8, 0x00, 0x00, 0x1F, 0x00, 0xC0, 0x07, 0x00, 0xF8, 0x00, 0x00, 0x3C, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char /
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7F, 0x00, 0xC0, 0xFF, 0x01, 0xE0, 0xE0, 0x03, 0x70, 0x30, 0x07, 0x30, 0x18, 0x06, 0x30, 0x1C, 0x06, 0x30, 0x0C, 0x06, 0x70, 0x06, 0x07, 0xE0, 0x83, 0x03, 0xC0, 0xFF, 0x01, 0x00, 0x7F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char 0
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x06, 0xE0, 0x00, 0x06, 0x60, 0x00, 0x06, 0x30, 0x00, 0x06, 0xF0, 0xFF, 0x07, 0xF0, 0xFF, 0x07, 0x00, 0x00, 0x06, 0x00, 0x00, 0x06, 0x00, 0x00, 0x06, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char 1
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x06, 0xE0, 0x00, 0x07, 0x70, 0x80, 0x07, 0x30, 0xC0, 0x06, 0x30, 0x60, 0x06, 0x30, 0x30, 0x06, 0x70, 0x1C, 0x06, 0xE0, 0x0F, 0x06, 0xC0, 0x07, 0x06, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char 2
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x00, 0x06, 0x30, 0x00, 0x06, 0x30, 0x0C, 0x06, 0x30, 0x0C, 0x06, 0x30, 0x0C, 0x06, 0x70, 0x0E, 0x06, 0xE0, 0x1B, 0x03, 0xC0, 0xF9, 0x03, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char 3
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xE0, 0x00, 0x00, 0xF0, 0x00, 0x00, 0xDC, 0x00, 0x00, 0xCF, 0x00, 0x80, 0xC3, 0x00, 0xE0, 0xC0, 0x00, 0x70, 0xC0, 0x00, 0xF0, 0xFF, 0x07, 0xF0, 0xFF, 0x07, 0x00, 0xC0, 0x00, 0x00, 0xC0, 0x00, 0x00, 0xC0, 0x00, 0x00, 0x00, 0x00 }, // Code for char 4
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x0F, 0x06, 0xF0, 0x0F, 0x06, 0x30, 0x0C, 0x06, 0x30, 0x0C, 0x06, 0x30, 0x0C, 0x06, 0x30, 0x0C, 0x06, 0x30, 0x1C, 0x03, 0x30, 0xF8, 0x01, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char 5
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFE, 0x00, 0x80, 0xFF, 0x03, 0xC0, 0x18, 0x03, 0x60, 0x0C, 0x06, 0x70, 0x0C, 0x06, 0x30, 0x0C, 0x06, 0x30, 0x0C, 0x06, 0x30, 0x1C, 0x03, 0x30, 0xF8, 0x03, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char 6
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00, 0x30, 0x00, 0x00, 0x30, 0x00, 0x06, 0x30, 0x80, 0x07, 0x30, 0xE0, 0x03, 0x30, 0x78, 0x00, 0x30, 0x1E, 0x00, 0xB0, 0x07, 0x00, 0xF0, 0x01, 0x00, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char 7
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0xE1, 0x01, 0xE0, 0xF3, 0x03, 0x70, 0x3E, 0x07, 0x30, 0x1E, 0x06, 0x30, 0x0C, 0x06, 0x30, 0x0C, 0x06, 0x30, 0x1E, 0x06, 0x70, 0x3E, 0x07, 0xE0, 0xF3, 0x03, 0xC0, 0xE1, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char 8
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x07, 0x00, 0xE0, 0x0F, 0x06, 0x60, 0x1C, 0x06, 0x30, 0x18, 0x06, 0x30, 0x18, 0x06, 0x30, 0x18, 0x07, 0x30, 0x18, 0x03, 0x60, 0xCC, 0x01, 0xE0, 0xFF, 0x00, 0x80, 0x3F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char 9
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x80, 0x87, 0x07, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char :
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x00, 0x00, 0x60, 0x00, 0x83, 0x73, 0x80, 0x87, 0x3F, 0x00, 0x83, 0x1F, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char ;
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x38, 0x00, 0x00, 0x7C, 0x00, 0x00, 0x6C, 0x00, 0x00, 0xC6, 0x00, 0x00, 0x83, 0x01, 0x80, 0x01, 0x03, 0xC0, 0x01, 0x07, 0x80, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char <
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x00, 0x00, 0x66, 0x00, 0x00, 0x66, 0x00, 0x00, 0x66, 0x00, 0x00, 0x66, 0x00, 0x00, 0x66, 0x00, 0x00, 0x66, 0x00, 0x00, 0x66, 0x00, 0x00, 0x66, 0x00, 0x00, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char =
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x02, 0xC0, 0x01, 0x07, 0x80, 0x01, 0x03, 0x00, 0x83, 0x01, 0x00, 0xC6, 0x00, 0x00, 0x6C, 0x00, 0x00, 0x7C, 0x00, 0x00, 0x38, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char >
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x0C, 0x00, 0x07, 0x0C, 0x3C, 0x07, 0x18, 0x3C, 0x07, 0x38, 0x0E, 0x00, 0xF0, 0x0F, 0x00, 0xE0, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char ?
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x07, 0x80, 0xFF, 0x3F, 0xE0, 0x03, 0x78, 0x70, 0x00, 0x40, 0x18, 0xF8, 0xC3, 0x0C, 0xFE, 0x87, 0x04, 0x07, 0x86, 0x04, 0xE3, 0x83, 0x04, 0xFF, 0x87, 0x0C, 0x0F, 0x46, 0x38, 0x00, 0x07, 0xF0, 0xFF, 0x03, 0xC0, 0xFF, 0x00, 0x00, 0x00, 0x00 }, // Code for char @
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0xE0, 0x07, 0x00, 0xFE, 0x00, 0xC0, 0xCF, 0x00, 0xF0, 0xC1, 0x00, 0x10, 0xC0, 0x00, 0xF0, 0xC0, 0x00, 0xE0, 0xC7, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xF8, 0x01, 0x00, 0xC0, 0x07, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00 }, // Code for char A
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0xFF, 0x07, 0xF0, 0xFF, 0x07, 0x30, 0x0C, 0x06, 0x30, 0x0C, 0x06, 0x30, 0x0C, 0x06, 0x30, 0x0C, 0x06, 0x70, 0x0E, 0x06, 0xE0, 0x1B, 0x03, 0xC0, 0xF9, 0x03, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char B
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7F, 0x00, 0xC0, 0xFF, 0x01, 0xE0, 0xC1, 0x03, 0x60, 0x00, 0x03, 0x30, 0x00, 0x06, 0x30, 0x00, 0x06, 0x30, 0x00, 0x06, 0x30, 0x00, 0x06, 0x30, 0x00, 0x06, 0x60, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char C
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0xFF, 0x07, 0xF0, 0xFF, 0x07, 0x30, 0x00, 0x06, 0x30, 0x00, 0x06, 0x30, 0x00, 0x06, 0x30, 0x00, 0x06, 0x30, 0x00, 0x07, 0x60, 0x00, 0x03, 0xE0, 0xC0, 0x03, 0xC0, 0xFF, 0x01, 0x00, 0x7F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char D
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0xFF, 0x07, 0xF0, 0xFF, 0x07, 0x30, 0x0C, 0x06, 0x30, 0x0C, 0x06, 0x30, 0x0C, 0x06, 0x30, 0x0C, 0x06, 0x30, 0x0C, 0x06, 0x30, 0x0C, 0x06, 0x30, 0x0C, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char E
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0xFF, 0x07, 0xF0, 0xFF, 0x07, 0x30, 0x0C, 0x00, 0x30, 0x0C, 0x00, 0x30, 0x0C, 0x00, 0x30, 0x0C, 0x00, 0x30, 0x0C, 0x00, 0x30, 0x0C, 0x00, 0x30, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char F
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7E, 0x00, 0x80, 0xFF, 0x01, 0xC0, 0xC1, 0x03, 0x60, 0x00, 0x03, 0x70, 0x00, 0x06, 0x30, 0x00, 0x06, 0x30, 0x0C, 0x06, 0x30, 0x0C, 0x06, 0x30, 0x0C, 0x06, 0x30, 0xFC, 0x07, 0x60, 0xFC, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char G
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0xFF, 0x07, 0xF0, 0xFF, 0x07, 0x00, 0x0C, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x0C, 0x00, 0xF0, 0xFF, 0x07, 0xF0, 0xFF, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char H
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x06, 0x30, 0x00, 0x06, 0x30, 0x00, 0x06, 0x30, 0x00, 0x06, 0xF0, 0xFF, 0x07, 0xF0, 0xFF, 0x07, 0x30, 0x00, 0x06, 0x30, 0x00, 0x06, 0x30, 0x00, 0x06, 0x30, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char I
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x03, 0x30, 0x00, 0x06, 0x30, 0x00, 0x06, 0x30, 0x00, 0x06, 0x30, 0x00, 0x06, 0x30, 0x00, 0x07, 0xF0, 0xFF, 0x03, 0xF0, 0xFF, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char J
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0xFF, 0x07, 0xF0, 0xFF, 0x07, 0x00, 0x08, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x77, 0x00, 0x80, 0xE3, 0x00, 0xC0, 0xC1, 0x01, 0x60, 0x80, 0x03, 0x30, 0x00, 0x06, 0x10, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char K
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0xFF, 0x07, 0xF0, 0xFF, 0x07, 0x00, 0x00, 0x06, 0x00, 0x00, 0x06, 0x00, 0x00, 0x06, 0x00, 0x00, 0x06, 0x00, 0x00, 0x06, 0x00, 0x00, 0x06, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char L
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0xFF, 0x07, 0xF0, 0xFF, 0x07, 0xF0, 0x00, 0x00, 0x80, 0x07, 0x00, 0x00, 0x1E, 0x00, 0x00, 0x30, 0x00, 0x00, 0x1E, 0x00, 0x80, 0x07, 0x00, 0xF0, 0x00, 0x00, 0xF0, 0xFF, 0x07, 0xF0, 0xFF, 0x07, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00 }, // Code for char M
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0xFF, 0x07, 0xF0, 0xFF, 0x07, 0x70, 0x00, 0x00, 0xE0, 0x01, 0x00, 0x80, 0x07, 0x00, 0x00, 0x3C, 0x00, 0x00, 0xF0, 0x00, 0x00, 0xC0, 0x03, 0x00, 0x00, 0x07, 0xF0, 0xFF, 0x07, 0xF0, 0xFF, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char N
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7F, 0x00, 0xC0, 0xFF, 0x01, 0xE0, 0x80, 0x03, 0x60, 0x00, 0x07, 0x30, 0x00, 0x06, 0x30, 0x00, 0x06, 0x30, 0x00, 0x06, 0x30, 0x00, 0x06, 0x70, 0x00, 0x03, 0xE0, 0x80, 0x03, 0xC0, 0xFF, 0x01, 0x00, 0x7F, 0x00, 0x00, 0x00, 0x00 }, // Code for char O
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0xFF, 0x07, 0xF0, 0xFF, 0x07, 0x30, 0x30, 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x00, 0x60, 0x18, 0x00, 0xE0, 0x0F, 0x00, 0x80, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char P
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7F, 0x00, 0xC0, 0xFF, 0x01, 0xE0, 0x80, 0x03, 0x60, 0x00, 0x07, 0x30, 0x00, 0x06, 0x30, 0x00, 0x1E, 0x30, 0x00, 0x3E, 0x30, 0x00, 0x76, 0x70, 0x00, 0x63, 0xE0, 0x80, 0x63, 0xC0, 0xFF, 0x61, 0x00, 0x7F, 0x30, 0x00, 0x00, 0x00 }, // Code for char Q
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0xFF, 0x07, 0xF0, 0xFF, 0x07, 0x30, 0x18, 0x00, 0x30, 0x18, 0x00, 0x30, 0x18, 0x00, 0x30, 0x78, 0x00, 0x70, 0xEC, 0x01, 0xE0, 0xCF, 0x07, 0xC0, 0x03, 0x07, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char R
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x03, 0x03, 0xE0, 0x07, 0x06, 0x60, 0x06, 0x06, 0x30, 0x0C, 0x06, 0x30, 0x0C, 0x06, 0x30, 0x18, 0x06, 0x30, 0x18, 0x06, 0x30, 0x38, 0x03, 0x60, 0xF0, 0x03, 0x00, 0xE0, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char S
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00, 0x30, 0x00, 0x00, 0x30, 0x00, 0x00, 0x30, 0x00, 0x00, 0x30, 0x00, 0x00, 0xF0, 0xFF, 0x07, 0xF0, 0xFF, 0x07, 0x30, 0x00, 0x00, 0x30, 0x00, 0x00, 0x30, 0x00, 0x00, 0x30, 0x00, 0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char T
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0xFF, 0x01, 0xF0, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x06, 0x00, 0x00, 0x06, 0x00, 0x00, 0x06, 0x00, 0x00, 0x06, 0x00, 0x00, 0x06, 0x00, 0x00, 0x03, 0xF0, 0xFF, 0x03, 0xF0, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char U
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00, 0xF0, 0x01, 0x00, 0xC0, 0x0F, 0x00, 0x00, 0x7E, 0x00, 0x00, 0xF8, 0x03, 0x00, 0xC0, 0x07, 0x00, 0x00, 0x06, 0x00, 0xC0, 0x07, 0x00, 0xF0, 0x01, 0x00, 0x7E, 0x00, 0xC0, 0x0F, 0x00, 0xF0, 0x01, 0x00, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char V
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x3F, 0x00, 0xF0, 0xFF, 0x07, 0x00, 0xC0, 0x07, 0x00, 0x80, 0x07, 0x00, 0xF8, 0x01, 0x00, 0x06, 0x00, 0x00, 0xFC, 0x01, 0x00, 0xC0, 0x07, 0x00, 0x80, 0x07, 0xF0, 0xFF, 0x07, 0xF0, 0x3F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char W
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x10, 0x00, 0x06, 0x30, 0x80, 0x07, 0xF0, 0xC0, 0x03, 0xC0, 0xE3, 0x00, 0x80, 0x7F, 0x00, 0x00, 0x1E, 0x00, 0x00, 0x3F, 0x00, 0x80, 0xF3, 0x00, 0xC0, 0xE1, 0x03, 0xF0, 0x80, 0x07, 0x30, 0x00, 0x06, 0x10, 0x00, 0x04, 0x00, 0x00, 0x00 }, // Code for char X
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00, 0xE0, 0x00, 0x00, 0xC0, 0x03, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x1E, 0x00, 0x00, 0xF8, 0x07, 0x00, 0xF8, 0x07, 0x00, 0x1C, 0x00, 0x00, 0x0F, 0x00, 0xC0, 0x03, 0x00, 0xE0, 0x00, 0x00, 0x70, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char Y
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x06, 0x30, 0x80, 0x07, 0x30, 0xC0, 0x07, 0x30, 0xF0, 0x06, 0x30, 0x38, 0x06, 0x30, 0x0E, 0x06, 0xB0, 0x07, 0x06, 0xF0, 0x01, 0x06, 0xF0, 0x00, 0x06, 0x30, 0x00, 0x06, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char Z
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0xFF, 0xFF, 0xFC, 0xFF, 0xFF, 0x0C, 0x00, 0xC0, 0x0C, 0x00, 0xC0, 0x0C, 0x00, 0xC0, 0x0C, 0x00, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char [
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x3C, 0x00, 0x00, 0xF8, 0x00, 0x00, 0xC0, 0x07, 0x00, 0x00, 0x1F, 0x00, 0x00, 0xF8, 0x00, 0x00, 0xE0, 0x03, 0x00, 0x00, 0x1F, 0x00, 0x00, 0x3C, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char BackSlash
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x00, 0xC0, 0x0C, 0x00, 0xC0, 0x0C, 0x00, 0xC0, 0x0C, 0x00, 0xC0, 0xFC, 0xFF, 0xFF, 0xFC, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char ]
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x07, 0x00, 0xC0, 0x01, 0x00, 0x70, 0x00, 0x00, 0x30, 0x00, 0x00, 0x70, 0x00, 0x00, 0xC0, 0x01, 0x00, 0x00, 0x07, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char ^
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x00, 0x00, 0xC0, 0x00, 0x00, 0xC0, 0x00, 0x00, 0xC0, 0x00, 0x00, 0xC0, 0x00, 0x00, 0xC0, 0x00, 0x00, 0xC0, 0x00, 0x00, 0xC0, 0x00, 0x00, 0xC0, 0x00, 0x00, 0xC0, 0x00, 0x00, 0xC0, 0x00, 0x00, 0xC0, 0x00, 0x00, 0xC0, 0x00, 0x00, 0x00 }, // Code for char _
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x18, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char `
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x03, 0x00, 0xE3, 0x03, 0x80, 0x71, 0x06, 0x80, 0x31, 0x06, 0x80, 0x31, 0x06, 0x80, 0x31, 0x06, 0x80, 0x31, 0x07, 0x80, 0x33, 0x03, 0x00, 0xFF, 0x07, 0x00, 0xFE, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char a
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0xFF, 0x03, 0xFC, 0xFF, 0x07, 0x00, 0x07, 0x06, 0x00, 0x03, 0x06, 0x80, 0x01, 0x06, 0x80, 0x01, 0x06, 0x80, 0x01, 0x07, 0x80, 0x83, 0x03, 0x00, 0xFF, 0x01, 0x00, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char b
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00, 0xFE, 0x03, 0x00, 0x87, 0x03, 0x80, 0x03, 0x07, 0x80, 0x01, 0x06, 0x80, 0x01, 0x06, 0x80, 0x01, 0x06, 0x80, 0x01, 0x06, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char c
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00, 0xFE, 0x03, 0x00, 0x07, 0x07, 0x80, 0x03, 0x06, 0x80, 0x01, 0x06, 0x80, 0x01, 0x06, 0x80, 0x01, 0x03, 0x80, 0x81, 0x01, 0xFC, 0xFF, 0x07, 0xFC, 0xFF, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char d
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00, 0xFE, 0x03, 0x00, 0x33, 0x03, 0x80, 0x31, 0x06, 0x80, 0x31, 0x06, 0x80, 0x31, 0x06, 0x80, 0x31, 0x06, 0x00, 0x33, 0x06, 0x00, 0x3F, 0x03, 0x00, 0x3C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char e
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0xF0, 0xFF, 0x07, 0xF8, 0xFF, 0x07, 0x1C, 0x03, 0x00, 0x0C, 0x03, 0x00, 0x0C, 0x03, 0x00, 0x0C, 0x03, 0x00, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char f
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x39, 0x00, 0xDE, 0x7F, 0x00, 0x7F, 0xE6, 0x80, 0x73, 0xC6, 0x80, 0x61, 0xC6, 0x80, 0x61, 0xC6, 0x80, 0x61, 0xC6, 0x80, 0x73, 0xC6, 0x80, 0x3F, 0x66, 0x80, 0x1F, 0x7C, 0x80, 0x01, 0x3C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char g
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0xFF, 0x07, 0xFC, 0xFF, 0x07, 0x00, 0x07, 0x00, 0x00, 0x03, 0x00, 0x80, 0x01, 0x00, 0x80, 0x01, 0x00, 0x80, 0x03, 0x00, 0x00, 0xFF, 0x07, 0x00, 0xFE, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char h
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x01, 0x06, 0x80, 0x01, 0x06, 0x80, 0x01, 0x06, 0x9C, 0x01, 0x06, 0x9C, 0xFF, 0x07, 0x9C, 0xFF, 0x07, 0x00, 0x00, 0x06, 0x00, 0x00, 0x06, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char i
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x01, 0x60, 0x80, 0x01, 0xC0, 0x80, 0x01, 0xC0, 0x80, 0x01, 0xC0, 0x80, 0x01, 0xC0, 0x9C, 0x01, 0xE0, 0x9C, 0xFF, 0x7F, 0x9C, 0xFF, 0x1F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char j
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0xFF, 0x07, 0xFC, 0xFF, 0x07, 0x00, 0x10, 0x00, 0x00, 0x38, 0x00, 0x00, 0x6C, 0x00, 0x00, 0xC6, 0x00, 0x00, 0x87, 0x01, 0x80, 0x03, 0x03, 0x80, 0x01, 0x06, 0x80, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char k
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x00, 0x06, 0x0C, 0x00, 0x06, 0x0C, 0x00, 0x06, 0x0C, 0x00, 0x06, 0xFC, 0xFF, 0x07, 0xFC, 0xFF, 0x07, 0x00, 0x00, 0x06, 0x00, 0x00, 0x06, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char l
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xFF, 0x07, 0x80, 0xFF, 0x07, 0x00, 0x07, 0x00, 0x80, 0x01, 0x00, 0x80, 0x01, 0x00, 0x80, 0xFF, 0x07, 0x00, 0xFF, 0x07, 0x00, 0x07, 0x00, 0x80, 0x01, 0x00, 0x80, 0x01, 0x00, 0x80, 0xFF, 0x07, 0x00, 0xFF, 0x07, 0x00, 0x00, 0x00 }, // Code for char m
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xFF, 0x07, 0x80, 0xFF, 0x07, 0x00, 0x07, 0x00, 0x00, 0x03, 0x00, 0x80, 0x01, 0x00, 0x80, 0x01, 0x00, 0x80, 0x03, 0x00, 0x00, 0xFF, 0x07, 0x00, 0xFE, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char n
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00, 0xFE, 0x03, 0x00, 0x87, 0x03, 0x80, 0x03, 0x07, 0x80, 0x01, 0x06, 0x80, 0x01, 0x06, 0x80, 0x01, 0x06, 0x80, 0x03, 0x07, 0x00, 0x87, 0x03, 0x00, 0xFF, 0x01, 0x00, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char o
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xFF, 0xFF, 0x80, 0xFF, 0xFF, 0x00, 0x07, 0x06, 0x00, 0x03, 0x06, 0x80, 0x01, 0x06, 0x80, 0x01, 0x06, 0x80, 0x01, 0x07, 0x80, 0x83, 0x03, 0x00, 0xFF, 0x01, 0x00, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char p
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00, 0xFE, 0x03, 0x00, 0x07, 0x07, 0x80, 0x03, 0x06, 0x80, 0x01, 0x06, 0x80, 0x01, 0x06, 0x80, 0x01, 0x03, 0x80, 0x81, 0x03, 0x80, 0xFF, 0xFF, 0x80, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char q
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xFF, 0x07, 0x80, 0xFF, 0x07, 0x00, 0x06, 0x00, 0x00, 0x03, 0x00, 0x80, 0x01, 0x00, 0x80, 0x01, 0x00, 0x80, 0x01, 0x00, 0x80, 0x03, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x0E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char r
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0E, 0x03, 0x00, 0x1F, 0x06, 0x80, 0x19, 0x06, 0x80, 0x31, 0x06, 0x80, 0x31, 0x06, 0x80, 0x31, 0x06, 0x80, 0x61, 0x06, 0x00, 0xE3, 0x03, 0x00, 0xC0, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char s
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x01, 0x00, 0x80, 0x01, 0x00, 0x80, 0x01, 0x00, 0xF0, 0xFF, 0x00, 0xF8, 0xFF, 0x03, 0x80, 0x81, 0x07, 0x80, 0x01, 0x06, 0x80, 0x01, 0x06, 0x80, 0x01, 0x06, 0x80, 0x01, 0x06, 0x80, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char t
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xFF, 0x01, 0x80, 0xFF, 0x03, 0x00, 0x00, 0x07, 0x00, 0x00, 0x06, 0x00, 0x00, 0x06, 0x00, 0x00, 0x03, 0x00, 0x80, 0x03, 0x80, 0xFF, 0x07, 0x80, 0xFF, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char u
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x03, 0x00, 0x80, 0x0F, 0x00, 0x00, 0x7E, 0x00, 0x00, 0xF0, 0x01, 0x00, 0x80, 0x07, 0x00, 0x00, 0x04, 0x00, 0x80, 0x07, 0x00, 0xF0, 0x01, 0x00, 0x3E, 0x00, 0x80, 0x0F, 0x00, 0x80, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char v
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x7F, 0x00, 0x80, 0xFF, 0x07, 0x00, 0x00, 0x06, 0x00, 0xC0, 0x07, 0x00, 0xF8, 0x00, 0x00, 0x0C, 0x00, 0x00, 0xF8, 0x00, 0x00, 0xC0, 0x07, 0x00, 0x00, 0x06, 0x80, 0xFF, 0x07, 0x80, 0x3F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char w
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x04, 0x80, 0x01, 0x06, 0x80, 0x87, 0x07, 0x00, 0xCF, 0x03, 0x00, 0xFC, 0x00, 0x00, 0x38, 0x00, 0x00, 0xFC, 0x00, 0x00, 0xCE, 0x03, 0x80, 0x87, 0x07, 0x80, 0x01, 0x06, 0x80, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char x
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x80, 0x03, 0xC0, 0x80, 0x0F, 0xC0, 0x00, 0x7E, 0xE0, 0x00, 0xF0, 0x71, 0x00, 0xC0, 0x3F, 0x00, 0x00, 0x1E, 0x00, 0xC0, 0x07, 0x00, 0xF0, 0x00, 0x00, 0x3E, 0x00, 0x80, 0x0F, 0x00, 0x80, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char y
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x01, 0x06, 0x80, 0x01, 0x07, 0x80, 0xC1, 0x07, 0x80, 0xE1, 0x06, 0x80, 0x31, 0x06, 0x80, 0x1D, 0x06, 0x80, 0x0F, 0x06, 0x80, 0x03, 0x06, 0x80, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char z
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x18, 0x00, 0x00, 0x3C, 0x00, 0xF0, 0xFF, 0x3F, 0xF8, 0xE7, 0x7F, 0x1C, 0x00, 0xE0, 0x0C, 0x00, 0xC0, 0x0C, 0x00, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char {
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char |
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x00, 0xC0, 0x0C, 0x00, 0xC0, 0x1C, 0x00, 0xE0, 0xF8, 0xE7, 0x7F, 0xF0, 0xFF, 0x3F, 0x00, 0x3C, 0x00, 0x00, 0x18, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char }
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00, 0x38, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x18, 0x00, 0x00, 0x30, 0x00, 0x00, 0x60, 0x00, 0x00, 0x60, 0x00, 0x00, 0x60, 0x00, 0x00, 0x38, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00 }, // Code for char ~
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0xFF, 0x03, 0x10, 0x00, 0x02, 0x10, 0x00, 0x02, 0x10, 0x00, 0x02, 0xF0, 0xFF, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char 
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x00, 0x00, 0x7F, 0x00, 0xC0, 0xFF, 0x01, 0xE0, 0xCB, 0x03, 0x60, 0x0A, 0x03, 0x30, 0x0A, 0x06, 0x30, 0x0A, 0x06, 0x30, 0x0A, 0x06, 0x70, 0x02, 0x06, 0x70, 0x00, 0x07, 0x20, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x30, 0x00, 0x06, 0x48, 0x80, 0x03, 0x48, 0xC0, 0x01, 0x30, 0x70, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x8E, 0x01, 0x80, 0x43, 0x02, 0xC0, 0x41, 0x02, 0x70, 0x80, 0x01, 0x38, 0x00, 0x00, 0x0C, 0x80, 0x01, 0x04, 0x40, 0x02, 0x00, 0x40, 0x02, 0x00, 0x80, 0x01 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7F, 0x00, 0xC0, 0xFF, 0x01, 0xE0, 0x80, 0x03, 0x60, 0x00, 0x07, 0x30, 0x00, 0x06, 0x30, 0x00, 0x06, 0xF0, 0xFF, 0x07, 0xF0, 0xFF, 0x07, 0x30, 0x0C, 0x06, 0x30, 0x0C, 0x06, 0x30, 0x0C, 0x06, 0x30, 0x0C, 0x06, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x10, 0x00, 0x00, 0xF0, 0x03, 0x00, 0x10, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x03, 0x00, 0x20, 0x00, 0x00, 0x40, 0x00, 0x00, 0x20, 0x00, 0x00, 0xF0, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFE, 0x01, 0x00, 0xFF, 0x03, 0x80, 0x01, 0x06, 0x80, 0x01, 0x06, 0x00, 0x03, 0x03, 0x00, 0xFE, 0x01, 0x00, 0xFF, 0x03, 0x80, 0x33, 0x07, 0x80, 0x31, 0x06, 0x80, 0x31, 0x06, 0x00, 0x3F, 0x06, 0x00, 0x3E, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00, 0xE0, 0x00, 0x00, 0xC0, 0x03, 0x00, 0x03, 0x0F, 0x00, 0x03, 0x1E, 0x00, 0x00, 0xF8, 0x07, 0x00, 0xF8, 0x07, 0x00, 0x1C, 0x00, 0x03, 0x0F, 0x00, 0xC3, 0x03, 0x00, 0xE0, 0x00, 0x00, 0x70, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xF3, 0xFF, 0x80, 0xF3, 0xFF, 0x80, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3F, 0x00, 0x80, 0xFF, 0x00, 0xC0, 0xC1, 0x00, 0xE0, 0x80, 0x39, 0x60, 0xF0, 0x3F, 0xE0, 0xFF, 0x01, 0xFE, 0x87, 0x01, 0x6E, 0x80, 0x01, 0xC0, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x06, 0x00, 0x0C, 0x06, 0xC0, 0xFF, 0x07, 0xE0, 0xFF, 0x07, 0x70, 0x0C, 0x06, 0x30, 0x0C, 0x06, 0x30, 0x0C, 0x06, 0x30, 0x0C, 0x06, 0x30, 0x0C, 0x06, 0x60, 0x00, 0x06, 0x20, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x01, 0x70, 0xBE, 0x03, 0xE0, 0xFF, 0x01, 0xC0, 0xE1, 0x00, 0xC0, 0xC0, 0x00, 0xC0, 0xC0, 0x00, 0xC0, 0xC0, 0x00, 0xC0, 0xE1, 0x00, 0xE0, 0xFF, 0x01, 0x70, 0x9F, 0x03, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x30, 0x98, 0x01, 0x60, 0x98, 0x01, 0xC0, 0x99, 0x01, 0x80, 0x9B, 0x01, 0x00, 0xFE, 0x07, 0x00, 0xFE, 0x07, 0x80, 0x9B, 0x01, 0xC0, 0x99, 0x01, 0x60, 0x98, 0x01, 0x30, 0x98, 0x01, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xC1, 0xFF, 0xFF, 0xC1, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1E, 0x18, 0x70, 0x3F, 0x30, 0xF8, 0x73, 0x30, 0xDC, 0x61, 0x30, 0x8C, 0xC1, 0x30, 0x0C, 0x83, 0x31, 0x0C, 0x87, 0x19, 0x0C, 0xCE, 0x1F, 0x0C, 0xFC, 0x0E, 0x00, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7F, 0x00, 0xC0, 0xFF, 0x01, 0xE0, 0x80, 0x03, 0x20, 0x00, 0x02, 0x30, 0x3E, 0x06, 0x10, 0xFF, 0x04, 0x90, 0xC1, 0x04, 0x90, 0x80, 0x04, 0xB0, 0x80, 0x06, 0x20, 0x00, 0x02, 0xE0, 0x80, 0x03, 0xC0, 0xFF, 0x01, 0x00, 0x7F, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x27, 0x00, 0xB0, 0x2F, 0x00, 0x90, 0x28, 0x00, 0x90, 0x28, 0x00, 0x90, 0x24, 0x00, 0xF0, 0x2F, 0x00, 0xE0, 0x2F, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x7C, 0x00, 0x00, 0xEE, 0x00, 0x00, 0xC7, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x7C, 0x00, 0x00, 0xEE, 0x00, 0x00, 0xC7, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x18, 0x00, 0x00, 0x18, 0x00, 0x00, 0x18, 0x00, 0x00, 0x18, 0x00, 0x00, 0x18, 0x00, 0x00, 0x18, 0x00, 0x00, 0x18, 0x00, 0x00, 0xF8, 0x00, 0x00, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00, 0x30, 0x00, 0x00, 0x30, 0x00, 0x00, 0x30, 0x00, 0x00, 0x30, 0x00, 0x00, 0x30, 0x00, 0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xE0, 0x03, 0x00, 0x18, 0x0C, 0x00, 0x08, 0x08, 0x00, 0xF4, 0x17, 0x00, 0x94, 0x10, 0x00, 0x74, 0x13, 0x00, 0x08, 0x0C, 0x00, 0x18, 0x0C, 0x00, 0xE0, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0xF8, 0x01, 0x00, 0x9C, 0x03, 0x00, 0x0C, 0x03, 0x00, 0x0C, 0x03, 0x00, 0x9C, 0x03, 0x00, 0xF8, 0x01, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0xE0, 0x7F, 0x06, 0xE0, 0x7F, 0x06, 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x0C, 0x00, 0x0C, 0x0E, 0x00, 0x0C, 0x0F, 0x00, 0x8C, 0x0F, 0x00, 0xFC, 0x0C, 0x00, 0x78, 0x0C, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x0C, 0x00, 0xCC, 0x0C, 0x00, 0xCC, 0x0C, 0x00, 0xCC, 0x0C, 0x00, 0xCC, 0x0C, 0x00, 0xFC, 0x07, 0x00, 0xB8, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x18, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xFF, 0xFF, 0x80, 0xFF, 0xFF, 0x00, 0x00, 0x07, 0x00, 0x00, 0x06, 0x00, 0x00, 0x06, 0x00, 0x00, 0x07, 0x00, 0x80, 0x03, 0x80, 0xFF, 0x03, 0x80, 0xFF, 0x07, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xE0, 0x01, 0x00, 0xF8, 0x07, 0x10, 0xF8, 0x07, 0x18, 0xFC, 0x0F, 0x30, 0xFC, 0x0F, 0x30, 0xFC, 0x0F, 0x30, 0x0C, 0x00, 0x30, 0x0C, 0x00, 0x18, 0xFC, 0xFF, 0x1F, 0xFC, 0xFF, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x3C, 0x00, 0x00, 0x3C, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00, 0x38, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x0C, 0x00, 0x18, 0x0C, 0x00, 0x18, 0x0C, 0x00, 0xFC, 0x0F, 0x00, 0xFC, 0x0F, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x23, 0x00, 0xE0, 0x27, 0x00, 0x30, 0x2C, 0x00, 0x10, 0x28, 0x00, 0x10, 0x28, 0x00, 0x30, 0x2C, 0x00, 0xE0, 0x27, 0x00, 0xC0, 0x23, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC7, 0x01, 0x00, 0xEE, 0x00, 0x00, 0x7C, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC7, 0x01, 0x00, 0xEE, 0x00, 0x00, 0x7C, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x04, 0x08, 0x00, 0x06, 0xFC, 0x81, 0x03, 0xFC, 0xC1, 0x01, 0x00, 0x70, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x0E, 0x03, 0x80, 0xE3, 0x03, 0xC0, 0x71, 0x02, 0x70, 0xF0, 0x07, 0x38, 0xF0, 0x07, 0x0C, 0x00, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x04, 0x08, 0x00, 0x06, 0xFC, 0x81, 0x03, 0xFC, 0xC1, 0x01, 0x00, 0x70, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x0E, 0x00, 0x80, 0x23, 0x04, 0xC0, 0x11, 0x06, 0x70, 0x10, 0x07, 0x38, 0xF0, 0x05, 0x0C, 0xE0, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x94, 0x00, 0x06, 0x94, 0x80, 0x03, 0x94, 0xC0, 0x01, 0xFC, 0x70, 0x00, 0x6C, 0x38, 0x00, 0x00, 0x0E, 0x03, 0x00, 0xE7, 0x03, 0xC0, 0x71, 0x02, 0x70, 0xF0, 0x07, 0x38, 0xF0, 0x07, 0x0C, 0x00, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1F, 0x00, 0x80, 0x3F, 0x00, 0xC0, 0x71, 0x80, 0xF3, 0x60, 0x80, 0xF3, 0xC0, 0x80, 0x03, 0xC0, 0x00, 0x00, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x01, 0xE0, 0x07, 0x03, 0xFE, 0x00, 0xC7, 0xCF, 0x00, 0xF6, 0xC1, 0x00, 0x14, 0xC0, 0x00, 0xF0, 0xC0, 0x00, 0xE0, 0xC7, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xF8, 0x01, 0x00, 0xC0, 0x07, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0xE0, 0x07, 0x00, 0xFE, 0x00, 0xC0, 0xCF, 0x00, 0xF4, 0xC1, 0x00, 0x16, 0xC0, 0x00, 0xF7, 0xC0, 0x00, 0xE3, 0xC7, 0x00, 0x01, 0xFF, 0x00, 0x00, 0xF8, 0x01, 0x00, 0xC0, 0x07, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0xE0, 0x07, 0x04, 0xFE, 0x00, 0xC6, 0xCF, 0x00, 0xF3, 0xC1, 0x00, 0x13, 0xC0, 0x00, 0xF3, 0xC0, 0x00, 0xE6, 0xC7, 0x00, 0x04, 0xFF, 0x00, 0x00, 0xF8, 0x01, 0x00, 0xC0, 0x07, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x02, 0xE0, 0x07, 0x07, 0xFE, 0x00, 0xC1, 0xCF, 0x00, 0xF1, 0xC1, 0x00, 0x12, 0xC0, 0x00, 0xF4, 0xC0, 0x00, 0xE4, 0xC7, 0x00, 0x07, 0xFF, 0x00, 0x02, 0xF8, 0x01, 0x00, 0xC0, 0x07, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0xE0, 0x07, 0x03, 0xFE, 0x00, 0xC3, 0xCF, 0x00, 0xF0, 0xC1, 0x00, 0x10, 0xC0, 0x00, 0xF0, 0xC0, 0x00, 0xE3, 0xC7, 0x00, 0x03, 0xFF, 0x00, 0x00, 0xF8, 0x01, 0x00, 0xC0, 0x07, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0xE0, 0x07, 0x00, 0xFE, 0x00, 0xC0, 0xCF, 0x00, 0xF2, 0xC1, 0x00, 0x15, 0xC0, 0x00, 0xF5, 0xC0, 0x00, 0xE2, 0xC7, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xF8, 0x01, 0x00, 0xC0, 0x07, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x80, 0x07, 0x00, 0xE0, 0x03, 0x00, 0xFC, 0x00, 0x00, 0xCF, 0x00, 0xE0, 0xC3, 0x00, 0x70, 0xC0, 0x00, 0xF0, 0xFF, 0x07, 0xF0, 0xFF, 0x07, 0x30, 0x0C, 0x06, 0x30, 0x0C, 0x06, 0x30, 0x0C, 0x06, 0x30, 0x0C, 0x06, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7F, 0x00, 0x80, 0xFF, 0x01, 0xC0, 0xC1, 0x03, 0x60, 0x00, 0x03, 0x70, 0x00, 0x37, 0x30, 0x00, 0x3E, 0x30, 0x00, 0x1E, 0x30, 0x00, 0x06, 0x30, 0x00, 0x06, 0x30, 0x00, 0x06, 0x60, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF1, 0xFF, 0x07, 0xF3, 0xFF, 0x07, 0x37, 0x0C, 0x06, 0x36, 0x0C, 0x06, 0x34, 0x0C, 0x06, 0x30, 0x0C, 0x06, 0x30, 0x0C, 0x06, 0x30, 0x0C, 0x06, 0x30, 0x0C, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0xFF, 0x07, 0xF0, 0xFF, 0x07, 0x30, 0x0C, 0x06, 0x34, 0x0C, 0x06, 0x36, 0x0C, 0x06, 0x37, 0x0C, 0x06, 0x33, 0x0C, 0x06, 0x31, 0x0C, 0x06, 0x30, 0x0C, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0xFF, 0x07, 0xF4, 0xFF, 0x07, 0x36, 0x0C, 0x06, 0x33, 0x0C, 0x06, 0x33, 0x0C, 0x06, 0x33, 0x0C, 0x06, 0x36, 0x0C, 0x06, 0x34, 0x0C, 0x06, 0x30, 0x0C, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0xFF, 0x07, 0xF3, 0xFF, 0x07, 0x33, 0x0C, 0x06, 0x30, 0x0C, 0x06, 0x30, 0x0C, 0x06, 0x30, 0x0C, 0x06, 0x33, 0x0C, 0x06, 0x33, 0x0C, 0x06, 0x30, 0x0C, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x31, 0x00, 0x06, 0x33, 0x00, 0x06, 0x37, 0x00, 0x06, 0x36, 0x00, 0x06, 0xF4, 0xFF, 0x07, 0xF0, 0xFF, 0x07, 0x30, 0x00, 0x06, 0x30, 0x00, 0x06, 0x30, 0x00, 0x06, 0x30, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x06, 0x30, 0x00, 0x06, 0x30, 0x00, 0x06, 0x34, 0x00, 0x06, 0xF6, 0xFF, 0x07, 0xF7, 0xFF, 0x07, 0x33, 0x00, 0x06, 0x31, 0x00, 0x06, 0x30, 0x00, 0x06, 0x30, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x06, 0x34, 0x00, 0x06, 0x36, 0x00, 0x06, 0x33, 0x00, 0x06, 0xF3, 0xFF, 0x07, 0xF3, 0xFF, 0x07, 0x36, 0x00, 0x06, 0x34, 0x00, 0x06, 0x30, 0x00, 0x06, 0x30, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x06, 0x33, 0x00, 0x06, 0x33, 0x00, 0x06, 0x30, 0x00, 0x06, 0xF0, 0xFF, 0x07, 0xF0, 0xFF, 0x07, 0x33, 0x00, 0x06, 0x33, 0x00, 0x06, 0x30, 0x00, 0x06, 0x30, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x0C, 0x00, 0xF0, 0xFF, 0x07, 0xF0, 0xFF, 0x07, 0x30, 0x0C, 0x06, 0x30, 0x0C, 0x06, 0x30, 0x0C, 0x06, 0x30, 0x00, 0x06, 0x30, 0x00, 0x07, 0x60, 0x00, 0x03, 0xE0, 0xC0, 0x03, 0xC0, 0xFF, 0x01, 0x00, 0x7F, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0xFF, 0x07, 0xF2, 0xFF, 0x07, 0x77, 0x00, 0x00, 0xE1, 0x01, 0x00, 0x81, 0x07, 0x00, 0x02, 0x3C, 0x00, 0x04, 0xF0, 0x00, 0x04, 0xC0, 0x03, 0x07, 0x00, 0x07, 0xF2, 0xFF, 0x07, 0xF0, 0xFF, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7F, 0x00, 0xC1, 0xFF, 0x01, 0xE3, 0x80, 0x03, 0x67, 0x00, 0x07, 0x36, 0x00, 0x06, 0x34, 0x00, 0x06, 0x30, 0x00, 0x06, 0x30, 0x00, 0x06, 0x70, 0x00, 0x03, 0xE0, 0x80, 0x03, 0xC0, 0xFF, 0x01, 0x00, 0x7F, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7F, 0x00, 0xC0, 0xFF, 0x01, 0xE0, 0x80, 0x03, 0x60, 0x00, 0x07, 0x34, 0x00, 0x06, 0x36, 0x00, 0x06, 0x37, 0x00, 0x06, 0x33, 0x00, 0x06, 0x71, 0x00, 0x03, 0xE0, 0x80, 0x03, 0xC0, 0xFF, 0x01, 0x00, 0x7F, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7F, 0x00, 0xC0, 0xFF, 0x01, 0xE4, 0x80, 0x03, 0x66, 0x00, 0x07, 0x33, 0x00, 0x06, 0x33, 0x00, 0x06, 0x33, 0x00, 0x06, 0x36, 0x00, 0x06, 0x74, 0x00, 0x03, 0xE0, 0x80, 0x03, 0xC0, 0xFF, 0x01, 0x00, 0x7F, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7F, 0x00, 0xC2, 0xFF, 0x01, 0xE7, 0x80, 0x03, 0x61, 0x00, 0x07, 0x31, 0x00, 0x06, 0x32, 0x00, 0x06, 0x34, 0x00, 0x06, 0x34, 0x00, 0x06, 0x77, 0x00, 0x03, 0xE2, 0x80, 0x03, 0xC0, 0xFF, 0x01, 0x00, 0x7F, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7F, 0x00, 0xC0, 0xFF, 0x01, 0xE3, 0x80, 0x03, 0x63, 0x00, 0x07, 0x30, 0x00, 0x06, 0x30, 0x00, 0x06, 0x30, 0x00, 0x06, 0x33, 0x00, 0x06, 0x73, 0x00, 0x03, 0xE0, 0x80, 0x03, 0xC0, 0xFF, 0x01, 0x00, 0x7F, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x83, 0x01, 0x80, 0xC7, 0x01, 0x00, 0xEF, 0x00, 0x00, 0x7E, 0x00, 0x00, 0x3C, 0x00, 0x00, 0x7C, 0x00, 0x00, 0xFE, 0x00, 0x00, 0xE7, 0x01, 0x80, 0xC3, 0x01, 0x00, 0x81, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7F, 0x00, 0xC0, 0xFF, 0x01, 0xE0, 0x80, 0x33, 0x60, 0x00, 0x3F, 0x30, 0xC0, 0x07, 0x30, 0xFC, 0x06, 0xB0, 0x1F, 0x06, 0xF0, 0x01, 0x06, 0x7E, 0x00, 0x03, 0xE6, 0x80, 0x03, 0xC0, 0xFF, 0x01, 0x00, 0x7F, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0xFF, 0x01, 0xF1, 0xFF, 0x03, 0x03, 0x00, 0x03, 0x07, 0x00, 0x06, 0x06, 0x00, 0x06, 0x04, 0x00, 0x06, 0x00, 0x00, 0x06, 0x00, 0x00, 0x06, 0x00, 0x00, 0x03, 0xF0, 0xFF, 0x03, 0xF0, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0xFF, 0x01, 0xF0, 0xFF, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x06, 0x04, 0x00, 0x06, 0x06, 0x00, 0x06, 0x07, 0x00, 0x06, 0x03, 0x00, 0x06, 0x01, 0x00, 0x03, 0xF0, 0xFF, 0x03, 0xF0, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0xFF, 0x01, 0xF0, 0xFF, 0x03, 0x04, 0x00, 0x03, 0x06, 0x00, 0x06, 0x03, 0x00, 0x06, 0x03, 0x00, 0x06, 0x03, 0x00, 0x06, 0x06, 0x00, 0x06, 0x04, 0x00, 0x03, 0xF0, 0xFF, 0x03, 0xF0, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0xFF, 0x01, 0xF0, 0xFF, 0x03, 0x03, 0x00, 0x03, 0x03, 0x00, 0x06, 0x00, 0x00, 0x06, 0x00, 0x00, 0x06, 0x00, 0x00, 0x06, 0x03, 0x00, 0x06, 0x03, 0x00, 0x03, 0xF0, 0xFF, 0x03, 0xF0, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00, 0xE0, 0x00, 0x00, 0xC0, 0x03, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x1E, 0x00, 0x04, 0xF8, 0x07, 0x06, 0xF8, 0x07, 0x07, 0x1C, 0x00, 0x03, 0x0F, 0x00, 0xC1, 0x03, 0x00, 0xE0, 0x00, 0x00, 0x70, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0xFF, 0x07, 0xF0, 0xFF, 0x07, 0xC0, 0xC0, 0x00, 0xC0, 0xC0, 0x00, 0xC0, 0xC0, 0x00, 0xC0, 0xC0, 0x00, 0xC0, 0xE0, 0x00, 0x80, 0x61, 0x00, 0x80, 0x3F, 0x00, 0x00, 0x1E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0xFF, 0x07, 0xF8, 0xFF, 0x07, 0x1C, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x0C, 0x0E, 0x06, 0x8C, 0x1F, 0x06, 0x8C, 0x39, 0x06, 0xF8, 0x70, 0x06, 0x70, 0xE0, 0x03, 0x00, 0xC0, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x03, 0x04, 0xE3, 0x03, 0x8C, 0x71, 0x06, 0x9C, 0x31, 0x06, 0x98, 0x31, 0x06, 0x90, 0x31, 0x06, 0x80, 0x31, 0x07, 0x80, 0x33, 0x03, 0x00, 0xFF, 0x07, 0x00, 0xFE, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x03, 0x00, 0xE3, 0x03, 0x80, 0x71, 0x06, 0x90, 0x31, 0x06, 0x98, 0x31, 0x06, 0x9C, 0x31, 0x06, 0x8C, 0x31, 0x07, 0x84, 0x33, 0x03, 0x00, 0xFF, 0x07, 0x00, 0xFE, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x03, 0x10, 0xE3, 0x03, 0x98, 0x71, 0x06, 0x8C, 0x31, 0x06, 0x84, 0x31, 0x06, 0x8C, 0x31, 0x06, 0x98, 0x31, 0x07, 0x90, 0x33, 0x03, 0x00, 0xFF, 0x07, 0x00, 0xFE, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xC0, 0x03, 0x1C, 0xE3, 0x03, 0x84, 0x71, 0x06, 0x84, 0x31, 0x06, 0x88, 0x31, 0x06, 0x90, 0x31, 0x06, 0x90, 0x31, 0x07, 0x9C, 0x33, 0x03, 0x08, 0xFF, 0x07, 0x00, 0xFE, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x03, 0x1C, 0xE3, 0x03, 0x9C, 0x71, 0x06, 0x9C, 0x31, 0x06, 0x80, 0x31, 0x06, 0x80, 0x31, 0x06, 0x9C, 0x31, 0x07, 0x9C, 0x33, 0x03, 0x1C, 0xFF, 0x07, 0x00, 0xFE, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x03, 0x00, 0xE3, 0x03, 0x98, 0x71, 0x06, 0xA4, 0x31, 0x06, 0xA4, 0x31, 0x06, 0x98, 0x31, 0x06, 0x80, 0x31, 0x07, 0x80, 0x33, 0x03, 0x00, 0xFF, 0x07, 0x00, 0xFE, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xE0, 0x03, 0x00, 0xF3, 0x07, 0x80, 0x31, 0x06, 0x80, 0x31, 0x06, 0x80, 0x31, 0x03, 0x80, 0xFF, 0x01, 0x00, 0xFF, 0x03, 0x80, 0x33, 0x07, 0x80, 0x31, 0x06, 0x80, 0x31, 0x06, 0x00, 0x3F, 0x06, 0x00, 0x3E, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00, 0xFE, 0x03, 0x00, 0x87, 0x03, 0x80, 0x03, 0x37, 0x80, 0x01, 0x3E, 0x80, 0x01, 0x1E, 0x80, 0x01, 0x06, 0x80, 0x01, 0x06, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00, 0xFE, 0x03, 0x04, 0x33, 0x03, 0x8C, 0x31, 0x06, 0x9C, 0x31, 0x06, 0x98, 0x31, 0x06, 0x90, 0x31, 0x06, 0x00, 0x33, 0x06, 0x00, 0x3F, 0x03, 0x00, 0x3C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00, 0xFE, 0x03, 0x00, 0x33, 0x03, 0x80, 0x31, 0x06, 0x90, 0x31, 0x06, 0x98, 0x31, 0x06, 0x9C, 0x31, 0x06, 0x0C, 0x33, 0x06, 0x04, 0x3F, 0x03, 0x00, 0x3C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00, 0xFE, 0x03, 0x10, 0x33, 0x03, 0x98, 0x31, 0x06, 0x8C, 0x31, 0x06, 0x84, 0x31, 0x06, 0x8C, 0x31, 0x06, 0x18, 0x33, 0x06, 0x10, 0x3F, 0x03, 0x00, 0x3C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00, 0xFE, 0x03, 0x1C, 0x33, 0x03, 0x9C, 0x31, 0x06, 0x9C, 0x31, 0x06, 0x80, 0x31, 0x06, 0x80, 0x31, 0x06, 0x1C, 0x33, 0x06, 0x1C, 0x3F, 0x03, 0x1C, 0x3C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x01, 0x06, 0x84, 0x01, 0x06, 0x8C, 0x01, 0x06, 0x9C, 0x01, 0x06, 0x98, 0xFF, 0x07, 0x90, 0xFF, 0x07, 0x00, 0x00, 0x06, 0x00, 0x00, 0x06, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x01, 0x06, 0x80, 0x01, 0x06, 0x80, 0x01, 0x06, 0x90, 0x01, 0x06, 0x98, 0xFF, 0x07, 0x9C, 0xFF, 0x07, 0x0C, 0x00, 0x06, 0x04, 0x00, 0x06, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x01, 0x06, 0x90, 0x01, 0x06, 0x98, 0x01, 0x06, 0x8C, 0x01, 0x06, 0x84, 0xFF, 0x07, 0x8C, 0xFF, 0x07, 0x18, 0x00, 0x06, 0x10, 0x00, 0x06, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x01, 0x06, 0x9C, 0x01, 0x06, 0x9C, 0x01, 0x06, 0x9C, 0x01, 0x06, 0x80, 0xFF, 0x07, 0x80, 0xFF, 0x07, 0x1C, 0x00, 0x06, 0x1C, 0x00, 0x06, 0x1C, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF8, 0x00, 0x00, 0xFE, 0x03, 0x30, 0x87, 0x03, 0xB4, 0x03, 0x07, 0x9C, 0x01, 0x06, 0x9C, 0x01, 0x06, 0xF8, 0x01, 0x06, 0xF8, 0x01, 0x07, 0xCC, 0x87, 0x03, 0x0C, 0xFF, 0x01, 0x00, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0xFF, 0x07, 0x9C, 0xFF, 0x07, 0x04, 0x07, 0x00, 0x04, 0x03, 0x00, 0x88, 0x01, 0x00, 0x90, 0x01, 0x00, 0x90, 0x03, 0x00, 0x1C, 0xFF, 0x07, 0x08, 0xFE, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00, 0xFE, 0x03, 0x04, 0x87, 0x03, 0x8C, 0x03, 0x07, 0x9C, 0x01, 0x06, 0x98, 0x01, 0x06, 0x90, 0x01, 0x06, 0x80, 0x03, 0x07, 0x00, 0x87, 0x03, 0x00, 0xFF, 0x01, 0x00, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00, 0xFE, 0x03, 0x00, 0x87, 0x03, 0x80, 0x03, 0x07, 0x90, 0x01, 0x06, 0x98, 0x01, 0x06, 0x9C, 0x01, 0x06, 0x8C, 0x03, 0x07, 0x04, 0x87, 0x03, 0x00, 0xFF, 0x01, 0x00, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00, 0xFE, 0x03, 0x10, 0x87, 0x03, 0x98, 0x03, 0x07, 0x8C, 0x01, 0x06, 0x84, 0x01, 0x06, 0x8C, 0x01, 0x06, 0x98, 0x03, 0x07, 0x10, 0x87, 0x03, 0x00, 0xFF, 0x01, 0x00, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x08, 0xFE, 0x03, 0x1C, 0x87, 0x03, 0x84, 0x03, 0x07, 0x84, 0x01, 0x06, 0x88, 0x01, 0x06, 0x90, 0x01, 0x06, 0x90, 0x03, 0x07, 0x1C, 0x87, 0x03, 0x08, 0xFF, 0x01, 0x00, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00, 0xFE, 0x03, 0x1C, 0x87, 0x03, 0x9C, 0x03, 0x07, 0x9C, 0x01, 0x06, 0x80, 0x01, 0x06, 0x80, 0x01, 0x06, 0x9C, 0x03, 0x07, 0x1C, 0x87, 0x03, 0x1C, 0xFF, 0x01, 0x00, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x18, 0x00, 0x00, 0x18, 0x00, 0x00, 0x18, 0x00, 0xC0, 0x99, 0x03, 0xC0, 0x99, 0x03, 0xC0, 0x99, 0x03, 0x00, 0x18, 0x00, 0x00, 0x18, 0x00, 0x00, 0x18, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00, 0xFE, 0x01, 0x00, 0x87, 0x33, 0x80, 0x03, 0x3F, 0x80, 0xC1, 0x07, 0x80, 0xF9, 0x06, 0x80, 0x1F, 0x06, 0xE0, 0x03, 0x07, 0x60, 0x87, 0x03, 0x00, 0xFE, 0x01, 0x00, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xFF, 0x01, 0x84, 0xFF, 0x03, 0x0C, 0x00, 0x07, 0x1C, 0x00, 0x06, 0x18, 0x00, 0x06, 0x10, 0x00, 0x03, 0x00, 0x80, 0x03, 0x80, 0xFF, 0x07, 0x80, 0xFF, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xFF, 0x01, 0x80, 0xFF, 0x03, 0x00, 0x00, 0x07, 0x10, 0x00, 0x06, 0x18, 0x00, 0x06, 0x1C, 0x00, 0x03, 0x0C, 0x80, 0x03, 0x84, 0xFF, 0x07, 0x80, 0xFF, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xFF, 0x01, 0x90, 0xFF, 0x03, 0x18, 0x00, 0x07, 0x0C, 0x00, 0x06, 0x04, 0x00, 0x06, 0x0C, 0x00, 0x03, 0x18, 0x80, 0x03, 0x90, 0xFF, 0x07, 0x80, 0xFF, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xFF, 0x01, 0x9C, 0xFF, 0x03, 0x1C, 0x00, 0x07, 0x1C, 0x00, 0x06, 0x00, 0x00, 0x06, 0x00, 0x00, 0x03, 0x1C, 0x80, 0x03, 0x9C, 0xFF, 0x07, 0x9C, 0xFF, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x80, 0x03, 0xC0, 0x80, 0x0F, 0xC0, 0x00, 0x7E, 0xE0, 0x00, 0xF0, 0x71, 0x10, 0xC0, 0x3F, 0x18, 0x00, 0x1E, 0x1C, 0xC0, 0x07, 0x0C, 0xF0, 0x00, 0x04, 0x3E, 0x00, 0x80, 0x0F, 0x00, 0x80, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0xFF, 0xFF, 0xFC, 0xFF, 0xFF, 0x00, 0x07, 0x06, 0x00, 0x03, 0x06, 0x80, 0x01, 0x06, 0x80, 0x01, 0x06, 0x80, 0x01, 0x07, 0x80, 0x83, 0x03, 0x00, 0xFF, 0x01, 0x00, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, // Code for char �
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x80, 0x03, 0xC0, 0x80, 0x0F, 0xC0, 0x1C, 0x7E, 0xE0, 0x1C, 0xF0, 0x71, 0x1C, 0xC0, 0x3F, 0x00, 0x00, 0x1E, 0x00, 0xC0, 0x07, 0x1C, 0xF0, 0x00, 0x1C, 0x3E, 0x00, 0x9C, 0x0F, 0x00, 0x80, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 } // Code for char �
};

#endif
