/*==============================================================================
Generated on: 2024-10-23 18:06:29.353169
Generated by: betaflight_target_converter.py
Source: https://github.com/betaflight/unified-targets
Board name: YUPIF7
Manufacturer ID: YUPF

//copy this line to madflight.ino to use this flight controller (or copy/paste the whole file)
#include <madflight_board_betaflight_YUPF-YUPIF7.h>
==============================================================================*/

#define HW_BOARD_NAME "BETAFLIGHT-YUPF-YUPIF7"
#define HW_MCU "STM32F7X2"

//Defines from betaflight. Note: madflight will pick the last sensor defined here, this might not be the sensor that is actually on the board. Comment the offending sensors out.
#define IMU_USE  IMU_USE_SPI_ICM20689
#define BARO_USE  BARO_USE_MS5611
#define BARO_USE  BARO_USE_BMP280
#define BB_USE  BB_USE_FLASH
#define BB_FLASH_TYPE  "M25P16"
#define OSD_USE  OSD_USE_MAX7456

//Sensor specific setup
#define IMU_ALIGN  IMU_ALIGN_CW90
#define BARO_I2C_ADR  0
#define MAG_I2C_ADR  0

//LED:
#define HW_PIN_LED       PB4
#define HW_LED_ON        1 //0:low is on, 1:high is on

//IMU SPI: (SPI1)
#define HW_PIN_SPI_MISO  PA6
#define HW_PIN_SPI_MOSI  PA7
#define HW_PIN_SPI_SCLK  PA5
#define HW_PIN_IMU_CS    PA4
#define HW_PIN_IMU_EXTI  PNONE

//BARO/MAG I2C: (I2C1)
#define HW_PIN_I2C_SDA   PB8
#define HW_PIN_I2C_SCL   PB9

//Outputs:
#define HW_OUT_COUNT     6
#define HW_PIN_OUT_LIST  {PA0,PA1,PA2,PA3,PB0,PB1}

//RC Receiver: (SERIAL1)
#define HW_PIN_RCIN_RX   PA10
#define HW_PIN_RCIN_TX   PA9
#define HW_PIN_RCIN_INVERTER  -1

//GPS: (SERIAL3)
#define HW_PIN_GPS_RX    PB11
#define HW_PIN_GPS_TX    PB10
#define HW_PIN_GPS_INVERTER  -1

//Battery ADC voltage and current inputs:
#define HW_PIN_BAT_V     PC1
#define HW_PIN_BAT_I     PC2

//-------------------------------------

//Serial
#define HW_SERIAL_COUNT 5
#define HW_PIN_SERIAL { {1,PA9,PA10,-1}, {3,PB10,PB11,-1}, {5,PC12,PD2,-1}, {6,PC6,PC7,-1}, {11,PB1,PB0,-1} } // {INDEX,TX,RX,INVERTER}

//SPI
#define HW_SPI_COUNT 2
#define HW_PIN_SPI { {1,PA5,PA6,PA7}, {3,PC10,PC11,PB5} } // {INDEX,SCK,MISO,MOSI}

//I2C
#define HW_I2C_COUNT 1
#define HW_PIN_I2C { {1,PB8,PB9} } // {INDEX,SCL,SDA}

//other pins
#define HW_PIN_BEEPER PB14
#define HW_PIN_PPM PC8
#define HW_PIN_LED_STRIP PB1
//#define HW_PIN_LED PB4
#define HW_PIN_CAMERA_CONTROL PB7
#define HW_PIN_ADC_BATT PC1
#define HW_PIN_ADC_RSSI PC0
#define HW_PIN_ADC_CURR PC2
#define HW_PIN_FLASH_CS PA15
#define HW_PIN_OSD_CS PA14
#define HW_PIN_GYRO_EXTI PNONE
#define HW_PIN_GYRO_CS PA4
#define HW_PIN_USB_DETECT PA8

//set statements
#define HW_SET_MAG_BUSTYPE I2C
#define HW_SET_MAG_I2C_DEVICE 1
#define HW_SET_BARO_BUSTYPE I2C
#define HW_SET_BARO_I2C_DEVICE 1
#define HW_SET_DSHOT_BURST ON
#define HW_SET_CURRENT_METER ADC
#define HW_SET_BATTERY_METER ADC
#define HW_SET_IBATA_SCALE 235
#define HW_SET_BEEPER_FREQUENCY 3150
#define HW_SET_MAX7456_SPI_BUS 1
#define HW_SET_FLASH_SPI_BUS 3
#define HW_SET_BLACKBOX_DEVICE SPIFLASH
#define HW_SET_GYRO_1_BUSTYPE SPI
#define HW_SET_GYRO_1_SPIBUS 1
#define HW_SET_GYRO_1_SENSOR_ALIGN CW90
#define HW_SET_GYRO_1_ALIGN_YAW 900


/*
#==============================================================================
# BetaFlight Source file
#==============================================================================
# Betaflight / STM32F7X2 (S7X2) 4.2.0 Dec  6 2019 / 01:11:14 (b18478f43e) MSP API: 1.43

#define USE_GYRO
#define USE_GYRO_SPI_ICM20689
#define USE_ACC
#define USE_ACC_SPI_ICM20689
#define USE_BARO
#define USE_BARO_MS5611
#define USE_BARO_BMP280
#define USE_FLASH
#define USE_FLASH_M25P16
#define USE_MAX7456

board_name YUPIF7
manufacturer_id YUPF

# resources
resource BEEPER 1 B14
resource MOTOR 1 A00
resource MOTOR 2 A01
resource MOTOR 3 A02
resource MOTOR 4 A03
resource MOTOR 5 B00
resource MOTOR 6 B01
resource PPM 1 C08
resource LED_STRIP 1 B01
resource SERIAL_TX 1 A09
resource SERIAL_TX 3 B10
resource SERIAL_TX 5 C12
resource SERIAL_TX 6 C06
resource SERIAL_TX 11 B01
resource SERIAL_RX 1 A10
resource SERIAL_RX 3 B11
resource SERIAL_RX 5 D02
resource SERIAL_RX 6 C07
resource SERIAL_RX 11 B00
resource I2C_SCL 1 B08
resource I2C_SDA 1 B09
resource LED 1 B04
resource SPI_SCK 1 A05
resource SPI_SCK 3 C10
resource SPI_MISO 1 A06
resource SPI_MISO 3 C11
resource SPI_MOSI 1 A07
resource SPI_MOSI 3 B05
resource CAMERA_CONTROL 1 B07
resource ADC_BATT 1 C01
resource ADC_RSSI 1 C00
resource ADC_CURR 1 C02
resource FLASH_CS 1 A15
resource OSD_CS 1 A14
# Disabling GYRO_EXTI since gyro and OSD are on same SPI bus
# resource GYRO_EXTI 1 C04
resource GYRO_EXTI 1 NONE
resource GYRO_CS 1 A04
resource USB_DETECT 1 A08

# timer
timer C08 AF3
# pin C08: TIM8 CH3 (AF3)
timer A00 AF1
# pin A00: TIM2 CH1 (AF1)
timer A01 AF2
# pin A01: TIM5 CH2 (AF2)
timer A02 AF2
# pin A02: TIM5 CH3 (AF2)
timer A03 AF2
# pin A03: TIM5 CH4 (AF2)
timer B00 AF2
# pin B00: TIM3 CH3 (AF2)
timer B01 AF2
# pin B01: TIM3 CH4 (AF2)
timer B07 AF2
# pin B07: TIM4 CH2 (AF2)
timer B14 AF9
# pin B14: TIM12 CH1 (AF9)

# dma
dma ADC 1 0
# ADC 1: DMA2 Stream 0 Channel 0
dma pin C08 1
# pin C08: DMA2 Stream 4 Channel 7
dma pin A00 0
# pin A00: DMA1 Stream 5 Channel 3
dma pin A01 0
# pin A01: DMA1 Stream 4 Channel 6
dma pin A02 0
# pin A02: DMA1 Stream 0 Channel 6
dma pin A03 1
# pin A03: DMA1 Stream 3 Channel 6
dma pin B00 0
# pin B00: DMA1 Stream 7 Channel 5
dma pin B01 0
# pin B01: DMA1 Stream 2 Channel 5
dma pin B07 0
# pin B07: DMA1 Stream 3 Channel 2

# feature
feature OSD

# master
set mag_bustype = I2C
set mag_i2c_device = 1
set baro_bustype = I2C
set baro_i2c_device = 1
set dshot_burst = ON
set current_meter = ADC
set battery_meter = ADC
set ibata_scale = 235
set beeper_frequency = 3150
set max7456_spi_bus = 1
set flash_spi_bus = 3
set blackbox_device = SPIFLASH
set gyro_1_bustype = SPI
set gyro_1_spibus = 1
set gyro_1_sensor_align = CW90
set gyro_1_align_yaw = 900

*/
