/*==============================================================================
Generated on: 2024-10-23 18:06:29.333170
Generated by: betaflight_target_converter.py
Source: https://github.com/betaflight/unified-targets
Board name: TMOTORH743
Manufacturer ID: TMTR

//copy this line to madflight.ino to use this flight controller (or copy/paste the whole file)
#include <madflight_board_betaflight_TMTR-TMOTORH743.h>
==============================================================================*/

#define HW_BOARD_NAME "BETAFLIGHT-TMTR-TMOTORH743"
#define HW_MCU "STM32H743"

//Defines from betaflight. Note: madflight will pick the last sensor defined here, this might not be the sensor that is actually on the board. Comment the offending sensors out.
#define IMU_USE  IMU_USE_SPI_MPU6000
#define IMU_USE  IMU_USE_SPI_ICM42688P
#define BB_USE  BB_USE_FLASH
#define BB_FLASH_TYPE  "M25P16"
#define BB_USE  BB_USE_FLASH
#define BB_FLASH_TYPE  "W25N01G"
#define BARO_USE  BARO_USE_BMP280
#define OSD_USE  OSD_USE_MAX7456

//Sensor specific setup
#define IMU_ALIGN  IMU_ALIGN_CW90FLIP
#define BARO_I2C_ADR  0
#define MAG_I2C_ADR  0

//LED:
#define HW_PIN_LED       PE5
#define HW_LED_ON        1 //0:low is on, 1:high is on

//IMU SPI: (SPI2)
#define HW_PIN_SPI_MISO  PB14
#define HW_PIN_SPI_MOSI  PB15
#define HW_PIN_SPI_SCLK  PB13
#define HW_PIN_IMU_CS    PA4
#define HW_PIN_IMU_EXTI  PC4

//BARO/MAG I2C: (I2C2)
#define HW_PIN_I2C_SDA   PB10
#define HW_PIN_I2C_SCL   PB11

//Outputs:
#define HW_OUT_COUNT     8
#define HW_PIN_OUT_LIST  {PA0,PA1,PA2,PA3,PB0,PB1,PC8,PC9}

//RC Receiver: (SERIAL1)
#define HW_PIN_RCIN_RX   PA10
#define HW_PIN_RCIN_TX   PA9
#define HW_PIN_RCIN_INVERTER  -1

//GPS: (SERIAL2)
#define HW_PIN_GPS_RX    PD6
#define HW_PIN_GPS_TX    PD5
#define HW_PIN_GPS_INVERTER  -1

//Battery ADC voltage and current inputs:
#define HW_PIN_BAT_V     PC1
#define HW_PIN_BAT_I     PC3

//-------------------------------------

//Serial
#define HW_SERIAL_COUNT 8
#define HW_PIN_SERIAL { {1,PA9,PA10,-1}, {2,PD5,PD6,-1}, {3,PD8,PD9,-1}, {4,PD1,PD0,-1}, {5,PC12,PD2,-1}, {6,PC6,PC7,-1}, {7,PE8,PE7,-1}, {8,PE1,PE0,-1} } // {INDEX,TX,RX,INVERTER}

//SPI
#define HW_SPI_COUNT 5
#define HW_PIN_SPI { {1,PA5,PA6,PA7}, {2,PB13,PB14,PB15}, {3,PC10,PC11,PB2}, {4,PE12,PE13,PE14}, {6,PB3,PB4,PB5} } // {INDEX,SCK,MISO,MOSI}

//I2C
#define HW_I2C_COUNT 2
#define HW_PIN_I2C { {1,PB6,PB7}, {2,PB10,PB11} } // {INDEX,SCL,SDA}

//other pins
#define HW_PIN_BEEPER PE3
#define HW_PIN_LED_STRIP PA8
//#define HW_PIN_LED PE5
#define HW_PIN_LED_2 PE4
#define HW_PIN_ADC_BATT PC1
#define HW_PIN_ADC_RSSI PC5
#define HW_PIN_ADC_CURR PC3
#define HW_PIN_ADC_EXT PC0
#define HW_PIN_PINIO PC14
#define HW_PIN_PINIO_2 PD11
#define HW_PIN_PINIO_3 PE2
#define HW_PIN_FLASH_CS PA15
#define HW_PIN_OSD_CS PB12
#define HW_PIN_GYRO_EXTI PC4
#define HW_PIN_GYRO_EXTI_2 PE15
#define HW_PIN_GYRO_CS PA4
#define HW_PIN_GYRO_CS_2 PE11
#define HW_PIN_USB_DETECT PE6

//set statements
#define HW_SET_GYRO_TO_USE FIRST
#define HW_SET_MAG_BUSTYPE I2C
#define HW_SET_MAG_I2C_DEVICE 1
#define HW_SET_BARO_BUSTYPE I2C
#define HW_SET_BARO_I2C_DEVICE 2
#define HW_SET_BLACKBOX_DEVICE SPIFLASH
#define HW_SET_MAX7456_SPI_BUS 3
#define HW_SET_BEEPER_INVERSION ON
#define HW_SET_BEEPER_OD OFF
#define HW_SET_CURRENT_METER ADC
#define HW_SET_BATTERY_METER ADC
#define HW_SET_VBAT_SCALE 110
#define HW_SET_IBATA_SCALE 200
#define HW_SET_PINIO_CONFIG 1,1,1,1
#define HW_SET_PINIO_BOX 40,41,42,255
#define HW_SET_FLASH_SPI_BUS 3
#define HW_SET_GYRO_1_BUSTYPE SPI
#define HW_SET_GYRO_1_SPIBUS 2
#define HW_SET_GYRO_1_SENSOR_ALIGN CW90FLIP
#define HW_SET_GYRO_2_BUSTYPE SPI
#define HW_SET_GYRO_2_SPIBUS 1
#define HW_SET_GYRO_2_SENSOR_ALIGN CW0FLIP


/*
#==============================================================================
# BetaFlight Source file
#==============================================================================
# Betaflight / STM32H743 (SH74) 4.3.2 Nov 28 2022 / 07:31:53 (60c9521) MSP API: 1.44

#define USE_ACC
#define USE_ACC_SPI_MPU6000
#define USE_GYRO
#define USE_GYRO_SPI_MPU6000
#define USE_GYRO_SPI_ICM42688P
#define USE_ACC_SPI_ICM42688P
#define USE_FLASH
#define USE_FLASH_M25P16
#define USE_FLASH_W25N01G
#define USE_BARO
#define USE_BARO_BMP280
#define USE_MAX7456

board_name TMOTORH743
manufacturer_id TMTR

# resources
resource BEEPER 1 E03
resource MOTOR 1 A00
resource MOTOR 2 A01
resource MOTOR 3 A02
resource MOTOR 4 A03
resource MOTOR 5 B00
resource MOTOR 6 B01
resource MOTOR 7 C08
resource MOTOR 8 C09
resource LED_STRIP 1 A08
resource SERIAL_TX 1 A09
resource SERIAL_TX 2 D05
resource SERIAL_TX 3 D08
resource SERIAL_TX 4 D01
resource SERIAL_TX 5 C12
resource SERIAL_TX 6 C06
resource SERIAL_TX 7 E08
resource SERIAL_TX 8 E01
resource SERIAL_RX 1 A10
resource SERIAL_RX 2 D06
resource SERIAL_RX 3 D09
resource SERIAL_RX 4 D00
resource SERIAL_RX 5 D02
resource SERIAL_RX 6 C07
resource SERIAL_RX 7 E07
resource SERIAL_RX 8 E00
resource I2C_SCL 1 B06
resource I2C_SCL 2 B10
resource I2C_SDA 1 B07
resource I2C_SDA 2 B11
resource LED 1 E05
resource LED 2 E04
resource SPI_SCK 1 A05
resource SPI_SCK 2 B13
resource SPI_SCK 3 C10
resource SPI_SCK 4 E12
resource SPI_SCK 6 B03
resource SPI_MISO 1 A06
resource SPI_MISO 2 B14
resource SPI_MISO 3 C11
resource SPI_MISO 4 E13
resource SPI_MISO 6 B04
resource SPI_MOSI 1 A07
resource SPI_MOSI 2 B15
resource SPI_MOSI 3 B02
resource SPI_MOSI 4 E14
resource SPI_MOSI 6 B05
resource ADC_BATT 1 C01
resource ADC_RSSI 1 C05
resource ADC_CURR 1 C03
resource ADC_EXT 1 C00
resource PINIO 1 C14
resource PINIO 2 D11
resource PINIO 3 E02
resource FLASH_CS 1 A15
resource OSD_CS 1 B12
resource GYRO_EXTI 1 C04
resource GYRO_EXTI 2 E15
resource GYRO_CS 1 A04
resource GYRO_CS 2 E11
resource USB_DETECT 1 E06

# timer
timer A03 AF1
# pin A03: TIM2 CH4 (AF1)
timer B00 AF2
# pin B00: TIM3 CH3 (AF2)
timer B01 AF2
# pin B01: TIM3 CH4 (AF2)
timer B04 AF2
# pin B04: TIM3 CH1 (AF2)
timer B05 AF2
# pin B05: TIM3 CH2 (AF2)
timer B06 AF2
# pin B06: TIM4 CH1 (AF2)
timer B07 AF2
# pin B07: TIM4 CH2 (AF2)
timer C08 AF3
# pin C08: TIM8 CH3 (AF3)
timer C09 AF3
# pin C09: TIM8 CH4 (AF3)
timer A08 AF1
# pin A08: TIM1 CH1 (AF1)
timer B03 AF1
# pin B03: TIM2 CH2 (AF1)
timer A00 AF1
# pin A00: TIM2 CH1 (AF1)
timer A01 AF1
# pin A01: TIM2 CH2 (AF1)
timer A02 AF1
# pin A02: TIM2 CH3 (AF1)

# dma
dma ADC 1 8
# ADC 1: DMA2 Stream 0 Request 9
dma ADC 3 9
# ADC 3: DMA2 Stream 1 Request 115
dma TIMUP 1 0
# TIMUP 1: DMA1 Stream 0 Request 15
dma TIMUP 2 0
# TIMUP 2: DMA1 Stream 0 Request 22
dma TIMUP 3 0
# TIMUP 3: DMA1 Stream 0 Request 27
dma TIMUP 8 0
# TIMUP 8: DMA1 Stream 0 Request 51
dma pin A03 3
# pin A03: DMA1 Stream 3 Request 21
dma pin B00 4
# pin B00: DMA1 Stream 4 Request 25
dma pin B01 5
# pin B01: DMA1 Stream 5 Request 26
dma pin B04 0
# pin B04: DMA1 Stream 0 Request 23
dma pin B05 0
# pin B05: DMA1 Stream 0 Request 24
dma pin B06 0
# pin B06: DMA1 Stream 0 Request 29
dma pin B07 0
# pin B07: DMA1 Stream 0 Request 30
dma pin C08 6
# pin C08: DMA1 Stream 6 Request 49
dma pin C09 7
# pin C09: DMA1 Stream 7 Request 50
dma pin A08 14
# pin A08: DMA2 Stream 6 Request 11
dma pin B03 0
# pin B03: DMA1 Stream 0 Request 19
dma pin A00 0
# pin A00: DMA1 Stream 0 Request 18
dma pin A01 1
# pin A01: DMA1 Stream 1 Request 19
dma pin A02 2
# pin A02: DMA1 Stream 2 Request 20

# feature
feature RX_SERIAL
feature TELEMETRY
feature OSD


# master
set gyro_to_use = FIRST
set mag_bustype = I2C
set mag_i2c_device = 1
set baro_bustype = I2C
set baro_i2c_device = 2
set blackbox_device = SPIFLASH
set max7456_spi_bus = 3
set beeper_inversion = ON
set beeper_od = OFF
set current_meter = ADC
set battery_meter = ADC
set vbat_scale = 110
set ibata_scale = 200
set pinio_config = 1,1,1,1
set pinio_box = 40,41,42,255
set flash_spi_bus = 3
set gyro_1_bustype = SPI
set gyro_1_spibus = 2
set gyro_1_sensor_align = CW90FLIP
set gyro_2_bustype = SPI
set gyro_2_spibus = 1
set gyro_2_sensor_align = CW0FLIP

*/
