/*==============================================================================
Generated on: 2024-10-23 18:06:29.323170
Generated by: betaflight_target_converter.py
Source: https://github.com/betaflight/unified-targets
Board name: COLIBRI
Manufacturer ID: TEBS

//copy this line to madflight.ino to use this flight controller (or copy/paste the whole file)
#include <madflight_board_betaflight_TEBS-COLIBRI.h>
==============================================================================*/

#define HW_BOARD_NAME "BETAFLIGHT-TEBS-COLIBRI"
#define HW_MCU "STM32F405"

//Defines from betaflight. Note: madflight will pick the last sensor defined here, this might not be the sensor that is actually on the board. Comment the offending sensors out.
#define IMU_USE  IMU_USE_SPI_MPU6000
#define BARO_USE  BARO_USE_MS5611
#define BB_USE  BB_USE_FLASH
#define BB_FLASH_TYPE  "M25P16"

//Sensor specific setup
#define IMU_ALIGN  IMU_ALIGN_CW270FLIP
#define BARO_I2C_ADR  0
#define MAG_I2C_ADR  0

//LED:
#define HW_PIN_LED       PC14
#define HW_LED_ON        1 //0:low is on, 1:high is on

//IMU SPI: (SPI1)
#define HW_PIN_SPI_MISO  PA6
#define HW_PIN_SPI_MOSI  PA7
#define HW_PIN_SPI_SCLK  PA5
#define HW_PIN_IMU_CS    PC4
#define HW_PIN_IMU_EXTI  PC0

//BARO/MAG I2C: (I2C3)
#define HW_PIN_I2C_SDA   PA8
#define HW_PIN_I2C_SCL   PC9

//Outputs:
#define HW_OUT_COUNT     8
#define HW_PIN_OUT_LIST  {PB0,PB4,PB1,PB15,PB5,PB14,PB8,PB9}

//RC Receiver: (SERIAL1)
#define HW_PIN_RCIN_RX   PB7
#define HW_PIN_RCIN_TX   PB6
#define HW_PIN_RCIN_INVERTER  -1

//GPS: (SERIAL2)
#define HW_PIN_GPS_RX    PA3
#define HW_PIN_GPS_TX    PA2
#define HW_PIN_GPS_INVERTER  PB2

//Battery ADC voltage and current inputs:
#define HW_PIN_BAT_V     -1
#define HW_PIN_BAT_I     -1

//-------------------------------------

//Serial
#define HW_SERIAL_COUNT 3
#define HW_PIN_SERIAL { {1,PB6,PB7,-1}, {2,PA2,PA3,PB2}, {3,PB10,PB11,-1} } // {INDEX,TX,RX,INVERTER}

//SPI
#define HW_SPI_COUNT 2
#define HW_PIN_SPI { {1,PA5,PA6,PA7}, {2,PB13,PC2,PC3} } // {INDEX,SCK,MISO,MOSI}

//I2C
#define HW_I2C_COUNT 1
#define HW_PIN_I2C { {3,PA8,PC9} } // {INDEX,SCL,SDA}

//other pins
#define HW_PIN_BEEPER PC5
#define HW_PIN_PPM PA10
#define HW_PIN_PWM PA10
#define HW_PIN_PWM_2 PC6
#define HW_PIN_PWM_3 PC7
#define HW_PIN_PWM_4 PC8
#define HW_PIN_PWM_5 PA15
#define HW_PIN_PWM_6 PB3
#define HW_PIN_PWM_7 PA0
#define HW_PIN_PWM_8 PA1
#define HW_PIN_LED_STRIP PB7
//#define HW_PIN_LED PC14
#define HW_PIN_LED_2 PC13
#define HW_PIN_ESCSERIAL PA10
#define HW_PIN_COMPASS_EXTI PC1
#define HW_PIN_FLASH_CS PB12
#define HW_PIN_GYRO_EXTI PC0
#define HW_PIN_GYRO_CS PC4
#define HW_PIN_USB_DETECT PA9

//set statements
#define HW_SET_MAG_BUSTYPE I2C
#define HW_SET_MAG_I2C_DEVICE 3
#define HW_SET_BARO_BUSTYPE I2C
#define HW_SET_BARO_I2C_DEVICE 3
#define HW_SET_BLACKBOX_DEVICE SPIFLASH
#define HW_SET_SYSTEM_HSE_MHZ 16
#define HW_SET_DASHBOARD_I2C_BUS 3
#define HW_SET_FLASH_SPI_BUS 2
#define HW_SET_GYRO_1_BUSTYPE SPI
#define HW_SET_GYRO_1_SPIBUS 1
#define HW_SET_GYRO_1_SENSOR_ALIGN CW270FLIP
#define HW_SET_GYRO_1_ALIGN_PITCH 1800
#define HW_SET_GYRO_1_ALIGN_YAW 2700


/*
#==============================================================================
# BetaFlight Source file
#==============================================================================
# Betaflight / STM32F405 (S405) 4.2.0 Feb 11 2020 / 19:14:12 (norevision) MSP API: 1.43
#mcu STM32F405

#define USE_ACC
#define USE_ACC_SPI_MPU6000
#define USE_GYRO
#define USE_GYRO_SPI_MPU6000
#define USE_BARO
#define USE_BARO_MS5611
#define USE_FLASH
#define USE_FLASH_M25P16

board_name COLIBRI
manufacturer_id TEBS

# resources
resource BEEPER 1 C05
resource MOTOR 1 B00
resource MOTOR 2 B04
resource MOTOR 3 B01
resource MOTOR 4 B15
resource MOTOR 5 B05
resource MOTOR 6 B14
resource MOTOR 7 B08
resource MOTOR 8 B09
resource PPM 1 A10
resource PWM 1 A10
resource PWM 2 C06
resource PWM 3 C07
resource PWM 4 C08
resource PWM 5 A15
resource PWM 6 B03
resource PWM 7 A00
resource PWM 8 A01
resource LED_STRIP 1 B07
resource SERIAL_TX 1 B06
resource SERIAL_TX 2 A02
resource SERIAL_TX 3 B10
resource SERIAL_RX 1 B07
resource SERIAL_RX 2 A03
resource SERIAL_RX 3 B11
resource INVERTER 2 B02
resource I2C_SCL 3 A08
resource I2C_SDA 3 C09
resource LED 1 C14
resource LED 2 C13
resource SPI_SCK 1 A05
resource SPI_SCK 2 B13
resource SPI_MISO 1 A06
resource SPI_MISO 2 C02
resource SPI_MOSI 1 A07
resource SPI_MOSI 2 C03
resource ESCSERIAL 1 A10
resource COMPASS_EXTI 1 C01
resource FLASH_CS 1 B12
resource GYRO_EXTI 1 C00
resource GYRO_CS 1 C04
resource USB_DETECT 1 A09

# timer
timer A10 AF1
# pin A10: TIM1 CH3 (AF1)
timer C06 AF3
# pin C06: TIM8 CH1 (AF3)
timer C07 AF3
# pin C07: TIM8 CH2 (AF3)
timer C08 AF3
# pin C08: TIM8 CH3 (AF3)
timer A15 AF1
# pin A15: TIM2 CH1 (AF1)
timer B03 AF1
# pin B03: TIM2 CH2 (AF1)
timer A00 AF2
# pin A00: TIM5 CH1 (AF2)
timer A01 AF2
# pin A01: TIM5 CH2 (AF2)
timer B00 AF2
# pin B00: TIM3 CH3 (AF2)
timer B04 AF2
# pin B04: TIM3 CH1 (AF2)
timer B01 AF2
# pin B01: TIM3 CH4 (AF2)
timer B15 AF9
# pin B15: TIM12 CH2 (AF9)
timer B05 AF2
# pin B05: TIM3 CH2 (AF2)
timer B14 AF9
# pin B14: TIM12 CH1 (AF9)
timer B08 AF3
# pin B08: TIM10 CH1 (AF3)
timer B09 AF3
# pin B09: TIM11 CH1 (AF3)
timer B07 AF2
# pin B07: TIM4 CH2 (AF2)

# dma
dma ADC 1 1
# ADC 1: DMA2 Stream 4 Channel 0
dma pin A10 0
# pin A10: DMA2 Stream 6 Channel 0
dma pin C06 0
# pin C06: DMA2 Stream 2 Channel 0
dma pin C07 0
# pin C07: DMA2 Stream 2 Channel 0
dma pin C08 0
# pin C08: DMA2 Stream 2 Channel 0
dma pin A15 0
# pin A15: DMA1 Stream 5 Channel 3
dma pin B03 0
# pin B03: DMA1 Stream 6 Channel 3
dma pin A00 0
# pin A00: DMA1 Stream 2 Channel 6
dma pin A01 0
# pin A01: DMA1 Stream 4 Channel 6
dma pin B00 0
# pin B00: DMA1 Stream 7 Channel 5
dma pin B04 0
# pin B04: DMA1 Stream 4 Channel 5
dma pin B01 0
# pin B01: DMA1 Stream 2 Channel 5
dma pin B05 0
# pin B05: DMA1 Stream 5 Channel 5
dma pin B07 0
# pin B07: DMA1 Stream 3 Channel 2

# master
set mag_bustype = I2C
set mag_i2c_device = 3
set baro_bustype = I2C
set baro_i2c_device = 3
set blackbox_device = SPIFLASH
set system_hse_mhz = 16
set dashboard_i2c_bus = 3
set flash_spi_bus = 2
set gyro_1_bustype = SPI
set gyro_1_spibus = 1
set gyro_1_sensor_align = CW270FLIP
set gyro_1_align_pitch = 1800
set gyro_1_align_yaw = 2700

*/
