/*==============================================================================
Generated on: 2024-10-23 18:06:29.236656
Generated by: betaflight_target_converter.py
Source: https://github.com/betaflight/unified-targets
Board name: NBD_INFINITY200RS
Manufacturer ID: NEBD

//copy this line to madflight.ino to use this flight controller (or copy/paste the whole file)
#include <madflight_board_betaflight_NEBD-NBD_INFINITY200RS.h>
==============================================================================*/

#define HW_BOARD_NAME "BETAFLIGHT-NEBD-NBD_INFINITY200RS"
#define HW_MCU "STM32F745"

//Defines from betaflight. Note: madflight will pick the last sensor defined here, this might not be the sensor that is actually on the board. Comment the offending sensors out.
#define IMU_USE  IMU_USE_SPI_MPU6000
#define BB_USE  BB_USE_FLASH
#define BB_FLASH_TYPE  "W25N01G"
#define OSD_USE  OSD_USE_MAX7456

//Sensor specific setup
#define IMU_ALIGN  IMU_ALIGN_CW90
#define BARO_I2C_ADR  0
#define MAG_I2C_ADR  0

//LED:
#define HW_PIN_LED       PC0
#define HW_LED_ON        1 //0:low is on, 1:high is on

//IMU SPI: (SPI4)
#define HW_PIN_SPI_MISO  PE13
#define HW_PIN_SPI_MOSI  PE14
#define HW_PIN_SPI_SCLK  PE12
#define HW_PIN_IMU_CS    PE11
#define HW_PIN_IMU_EXTI  PB1

//BARO/MAG I2C: (I2C1)
#define HW_PIN_I2C_SDA   PB8
#define HW_PIN_I2C_SCL   PB9

//Outputs:
#define HW_OUT_COUNT     4
#define HW_PIN_OUT_LIST  {PC8,PC6,PC9,PC7}

//RC Receiver: (SERIAL1)
#define HW_PIN_RCIN_RX   PB7
#define HW_PIN_RCIN_TX   PB6
#define HW_PIN_RCIN_INVERTER  -1

//GPS: (SERIAL2)
#define HW_PIN_GPS_RX    PA3
#define HW_PIN_GPS_TX    PA2
#define HW_PIN_GPS_INVERTER  -1

//Battery ADC voltage and current inputs:
#define HW_PIN_BAT_V     PC1
#define HW_PIN_BAT_I     PC2

//-------------------------------------

//Serial
#define HW_SERIAL_COUNT 6
#define HW_PIN_SERIAL { {1,PB6,PB7,-1}, {2,PA2,PA3,-1}, {3,PB10,-1,-1}, {5,-1,PD2,-1}, {7,PE8,PE7,-1}, {8,PE1,PE0,-1} } // {INDEX,TX,RX,INVERTER}

//SPI
#define HW_SPI_COUNT 4
#define HW_PIN_SPI { {1,PA5,PA6,PA7}, {2,PB13,PB14,PB15}, {3,PB3,PB4,PD6}, {4,PE12,PE13,PE14} } // {INDEX,SCK,MISO,MOSI}

//I2C
#define HW_I2C_COUNT 1
#define HW_PIN_I2C { {1,PB8,PB9} } // {INDEX,SCL,SDA}

//other pins
#define HW_PIN_LED_STRIP PA9
//#define HW_PIN_LED PC0
#define HW_PIN_ADC_BATT PC1
#define HW_PIN_ADC_CURR PC2
#define HW_PIN_FLASH_CS PB0
#define HW_PIN_OSD_CS PA15
#define HW_PIN_GYRO_EXTI PB1
#define HW_PIN_GYRO_EXTI_2 PE9
#define HW_PIN_GYRO_CS PE11
#define HW_PIN_GYRO_CS_2 PB12

//set statements
#define HW_SET_BLACKBOX_DEVICE SPIFLASH
#define HW_SET_DSHOT_BURST ON
#define HW_SET_CURRENT_METER ADC
#define HW_SET_BATTERY_METER ADC
#define HW_SET_IBATA_SCALE 230
#define HW_SET_IBATA_OFFSET 10
#define HW_SET_SMALL_ANGLE 180
#define HW_SET_MAX7456_SPI_BUS 3
#define HW_SET_FLASH_SPI_BUS 1
#define HW_SET_GYRO_1_BUSTYPE SPI
#define HW_SET_GYRO_1_SPIBUS 4
#define HW_SET_GYRO_1_SENSOR_ALIGN CW90
#define HW_SET_GYRO_1_ALIGN_YAW 900
#define HW_SET_GYRO_2_SPIBUS 2


/*
#==============================================================================
# BetaFlight Source file
#==============================================================================
# Betaflight / STM32F745 (S745) 4.4.0 Apr 30 2023 / 08:22:46 (norevision) MSP API: 1.45

#define USE_GYRO
#define USE_GYRO_SPI_MPU6000
#define USE_ACC
#define USE_ACC_SPI_MPU6000
#define USE_ACCGYRO_BMI270
#define USE_FLASH
#define USE_FLASH_W25N01G
#define USE_MAX7456

board_name NBD_INFINITY200RS
manufacturer_id NEBD

# resources
resource MOTOR 1 C08
resource MOTOR 2 C06
resource MOTOR 3 C09
resource MOTOR 4 C07
resource LED_STRIP 1 A09
resource SERIAL_TX 1 B06
resource SERIAL_TX 2 A02
resource SERIAL_TX 3 B10
resource SERIAL_TX 7 E08
resource SERIAL_TX 8 E01
resource SERIAL_RX 1 B07
resource SERIAL_RX 2 A03
resource SERIAL_RX 5 D02
resource SERIAL_RX 7 E07
resource SERIAL_RX 8 E00
resource I2C_SCL 1 B08
resource I2C_SDA 1 B09
resource LED 1 C00
resource SPI_SCK 1 A05
resource SPI_SCK 2 B13
resource SPI_SCK 3 B03
resource SPI_SCK 4 E12
resource SPI_MISO 1 A06
resource SPI_MISO 2 B14
resource SPI_MISO 3 B04
resource SPI_MISO 4 E13
resource SPI_MOSI 1 A07
resource SPI_MOSI 2 B15
resource SPI_MOSI 3 D06
resource SPI_MOSI 4 E14
resource ADC_BATT 1 C01
resource ADC_CURR 1 C02
resource FLASH_CS 1 B00
resource OSD_CS 1 A15
resource GYRO_EXTI 1 B01
resource GYRO_EXTI 2 E09
resource GYRO_CS 1 E11
resource GYRO_CS 2 B12

# timer
timer C08 AF2
# pin C08: TIM3 CH3 (AF2)
timer C06 AF2
# pin C06: TIM3 CH1 (AF2)
timer C09 AF2
# pin C09: TIM3 CH4 (AF2)
timer C07 AF2
# pin C07: TIM3 CH2 (AF2)
timer A01 AF1
# pin A01: TIM2 CH2 (AF1)
timer A09 AF1
# pin A09: TIM1 CH2 (AF1)

# dma
dma ADC 1 0
# ADC 1: DMA2 Stream 0 Channel 0
dma pin C08 0
# pin C08: DMA1 Stream 7 Channel 5
dma pin C06 0
# pin C06: DMA1 Stream 4 Channel 5
dma pin C09 0
# pin C09: DMA1 Stream 2 Channel 5
dma pin C07 0
# pin C07: DMA1 Stream 5 Channel 5
dma pin A01 0
# pin A01: DMA1 Stream 6 Channel 3
dma pin A09 0
# pin A09: DMA2 Stream 6 Channel 0

# feature
feature LED_STRIP
feature OSD
feature ESC_SENSOR

# serial
serial 0 1 115200 57600 0 115200
serial 1 2048 115200 57600 0 115200
serial 4 1024 115200 57600 0 115200

# led
led 0 6,11::CTO:0
led 1 7,11::CTO:0
led 2 8,11::CTO:0
led 3 9,11::CTO:0

# master
set blackbox_device = SPIFLASH
set dshot_burst = ON
set current_meter = ADC
set battery_meter = ADC
set ibata_scale = 230
set ibata_offset = 10
set small_angle = 180
set max7456_spi_bus = 3
set flash_spi_bus = 1
set gyro_1_bustype = SPI
set gyro_1_spibus = 4
set gyro_1_sensor_align = CW90
set gyro_1_align_yaw = 900
set gyro_2_spibus = 2

*/
