/*==============================================================================
Generated on: 2024-10-23 18:06:29.076413
Generated by: betaflight_target_converter.py
Source: https://github.com/betaflight/unified-targets
Board name: FOXEERF405V2
Manufacturer ID: FOXE

//copy this line to madflight.ino to use this flight controller (or copy/paste the whole file)
#include <madflight_board_betaflight_FOXE-FOXEERF405V2.h>
==============================================================================*/

#define HW_BOARD_NAME "BETAFLIGHT-FOXE-FOXEERF405V2"
#define HW_MCU "STM32F405"

//Defines from betaflight. Note: madflight will pick the last sensor defined here, this might not be the sensor that is actually on the board. Comment the offending sensors out.
#define IMU_USE  IMU_USE_SPI_MPU6000
#define IMU_USE  IMU_USE_SPI_MPU6500
#define IMU_USE  IMU_USE_SPI_ICM42688P
#define BARO_USE  BARO_USE_DPS310
#define BB_USE  BB_USE_FLASH
#define BB_FLASH_TYPE  "M25P16"
#define OSD_USE  OSD_USE_MAX7456

//Sensor specific setup
#define IMU_ALIGN  IMU_ALIGN_CW270
#define BARO_I2C_ADR  0
#define MAG_I2C_ADR  0

//LED:
#define HW_PIN_LED       PA13
#define HW_LED_ON        1 //0:low is on, 1:high is on

//IMU SPI: (SPI1)
#define HW_PIN_SPI_MISO  PA6
#define HW_PIN_SPI_MOSI  PA7
#define HW_PIN_SPI_SCLK  PA5
#define HW_PIN_IMU_CS    PA4
#define HW_PIN_IMU_EXTI  PC4

//BARO/MAG I2C: (I2C1)
#define HW_PIN_I2C_SDA   PB8
#define HW_PIN_I2C_SCL   PB9

//Outputs:
#define HW_OUT_COUNT     8
#define HW_PIN_OUT_LIST  {PA8,PC9,PC8,PB15,PB6,PA15,PB11,PB10}

//RC Receiver: (SERIAL1)
#define HW_PIN_RCIN_RX   PA10
#define HW_PIN_RCIN_TX   PA9
#define HW_PIN_RCIN_INVERTER  -1

//GPS: (SERIAL2)
#define HW_PIN_GPS_RX    PA3
#define HW_PIN_GPS_TX    PA2
#define HW_PIN_GPS_INVERTER  -1

//Battery ADC voltage and current inputs:
#define HW_PIN_BAT_V     PC0
#define HW_PIN_BAT_I     PC1

//-------------------------------------

//Serial
#define HW_SERIAL_COUNT 6
#define HW_PIN_SERIAL { {1,PA9,PA10,-1}, {2,PA2,PA3,-1}, {3,PC10,PC11,-1}, {4,PA0,PA1,-1}, {5,PC12,PD2,-1}, {6,PC6,PC7,-1} } // {INDEX,TX,RX,INVERTER}

//SPI
#define HW_SPI_COUNT 3
#define HW_PIN_SPI { {1,PA5,PA6,PA7}, {2,PB13,PC2,PC3}, {3,PB3,PB4,PB5} } // {INDEX,SCK,MISO,MOSI}

//I2C
#define HW_I2C_COUNT 1
#define HW_PIN_I2C { {1,PB8,PB9} } // {INDEX,SCL,SDA}

//other pins
#define HW_PIN_BEEPER PC15
#define HW_PIN_SERVO PB1
#define HW_PIN_LED_STRIP PB7
//#define HW_PIN_LED PA13
#define HW_PIN_LED_2 PA14
#define HW_PIN_CAMERA_CONTROL PB0
#define HW_PIN_ADC_BATT PC0
#define HW_PIN_ADC_CURR PC1
#define HW_PIN_ADC_RSSI PC5
#define HW_PIN_PINIO PB14
#define HW_PIN_FLASH_CS PB12
#define HW_PIN_OSD_CS PC14
#define HW_PIN_GYRO_EXTI PC4
#define HW_PIN_GYRO_CS PA4

//set statements
#define HW_SET_MAG_BUSTYPE I2C
#define HW_SET_MAG_I2C_DEVICE 1
#define HW_SET_MAG_HARDWARE AUTO
#define HW_SET_BARO_BUSTYPE I2C
#define HW_SET_BARO_I2C_DEVICE 1
#define HW_SET_SYSTEM_HSE_MHZ 8
#define HW_SET_MAX7456_SPI_BUS 3
#define HW_SET_MAX7456_PREINIT_OPU OFF
#define HW_SET_DASHBOARD_I2C_BUS 1
#define HW_SET_DASHBOARD_I2C_ADDR 60
#define HW_SET_USB_MSC_PIN_PULLUP ON
#define HW_SET_FLASH_SPI_BUS 2
#define HW_SET_CURRENT_METER ADC
#define HW_SET_BATTERY_METER ADC
#define HW_SET_IBATA_SCALE 70
#define HW_SET_GYRO_1_BUSTYPE SPI
#define HW_SET_GYRO_1_SPIBUS 1
#define HW_SET_GYRO_1_I2CBUS 0
#define HW_SET_GYRO_1_I2C_ADDRESS 0
#define HW_SET_GYRO_1_SENSOR_ALIGN CW270
#define HW_SET_I2C1_PULLUP OFF
#define HW_SET_PINIO_BOX 40,41,255,255
#define HW_SET_BOX_USER_1_NAME CAM_SWITCH


/*
#==============================================================================
# BetaFlight Source file
#==============================================================================
# Betaflight / STM32F405 (S405) 4.1.0 Oct 16 2019 / 11:57:16 (c37a7c91a) MSP API: 1.42
#mcu STM32F405

#define USE_ACC
#define USE_ACC_SPI_MPU6000
#define USE_ACC_SPI_MPU6500
#define USE_ACC_SPI_ICM42688P
#define USE_GYRO
#define USE_GYRO_SPI_MPU6000
#define USE_GYRO_SPI_MPU6500
#define USE_GYRO_SPI_ICM42688P
#define USE_BARO
#define USE_BARO_DPS310
#define USE_FLASH
#define USE_FLASH_M25P16
#define USE_MAX7456

board_name FOXEERF405V2
manufacturer_id FOXE

# resources
resource BEEPER 1 C15
resource MOTOR 1 A08
resource MOTOR 2 C09
resource MOTOR 3 C08
resource MOTOR 4 B15
resource MOTOR 5 B06
resource MOTOR 6 A15
resource MOTOR 7 B11
resource MOTOR 8 B10
resource SERVO 1 B01
resource LED_STRIP 1 B07
resource SERIAL_TX 1 A09
resource SERIAL_TX 2 A02
resource SERIAL_TX 3 C10
resource SERIAL_TX 4 A00
resource SERIAL_TX 5 C12
resource SERIAL_TX 6 C06
resource SERIAL_RX 1 A10
resource SERIAL_RX 2 A03
resource SERIAL_RX 3 C11
resource SERIAL_RX 4 A01
resource SERIAL_RX 5 D02
resource SERIAL_RX 6 C07
resource LED 1 A13
resource LED 2 A14
resource I2C_SCL 1 B08
resource I2C_SDA 1 B09
resource SPI_SCK 1 A05
resource SPI_SCK 2 B13
resource SPI_SCK 3 B03
resource SPI_MISO 1 A06
resource SPI_MISO 2 C02
resource SPI_MISO 3 B04
resource SPI_MOSI 1 A07
resource SPI_MOSI 2 C03
resource SPI_MOSI 3 B05
resource CAMERA_CONTROL 1 B00
resource ADC_BATT 1 C00
resource ADC_CURR 1 C01
resource ADC_RSSI 1 C05
resource PINIO 1 B14
resource FLASH_CS 1 B12
resource OSD_CS 1 C14
resource GYRO_EXTI 1 C04
resource GYRO_CS 1 A04

# timer
timer A08 AF1
# pin A08: TIM1 CH1 (AF1)
timer B07 AF2
# pin B07: TIM4 CH2 (AF2)
timer C09 AF3
# pin C09: TIM8 CH4(AF3)
timer C08 AF3
# pin C08: TIM8 CH3 (AF3)
timer B15 AF1
# pin B15: TIM1 CH3N (AF1)
timer B10 AF1
# pin B10: TIM2 CH3 (AF1)
timer B11 AF1
# pin B11: TIM2 CH4 (AF1)
timer A15 AF1
# pin A15: TIM2 CH1 (AF1)
timer B06 AF2
# pin B06: TIM4 CH1 (AF2)
timer B01 AF2
# pin B01: TIM3 CH4 (AF2)
timer B00 AF2
# pin B00: TIM3 CH3 (AF2)

# dma
dma ADC 1 1
# ADC 1: DMA2 Stream 4 Channel 0
dma pin A08 1
# pin A08: DMA2 Stream 1 Channel 6
dma pin C09 0
# pin B07: DMA1 Stream 3 Channel 2
dma pin B07 0
# pin C09: DMA2 Stream 7 Channel 7
dma pin C08 0
# pin C08: DMA2 Stream 2 Channel 0
dma pin B15 1
# pin B15: DMA2 Stream 6 Channel 6
dma pin B10 0
# pin B10: DMA1 Stream 1 Channel 3
dma pin B11 0
# pin B11: DMA1 Stream 7 Channel 3
dma pin A15 0
# pin A15: DMA1 Stream 5 Channel 3
dma pin B06 0
# pin B06: DMA1 Stream 0 Channel 2
dma pin B01 0
# pin B01: DMA1 Stream 2 Channel 5
dma pin B00 0
# pin B00: DMA1 Stream 7 Channel 5

# feature
feature RX_SERIAL
feature TELEMETRY
feature OSD

# aux
aux 2 40 2 1600 2100 1

# master
set mag_bustype = I2C
set mag_i2c_device = 1
set mag_hardware = AUTO
set baro_bustype = I2C
set baro_i2c_device = 1
set system_hse_mhz = 8
set max7456_spi_bus = 3
set max7456_preinit_opu = OFF
set dashboard_i2c_bus = 1
set dashboard_i2c_addr = 60
set usb_msc_pin_pullup = ON
set flash_spi_bus = 2
set current_meter = ADC
set battery_meter = ADC
set ibata_scale = 70
set gyro_1_bustype = SPI
set gyro_1_spibus = 1
set gyro_1_i2cBus = 0
set gyro_1_i2c_address = 0
set gyro_1_sensor_align = CW270
set i2c1_pullup = OFF
set pinio_box = 40,41,255,255
set box_user_1_name = CAM_SWITCH


*/
