/*==============================================================================
Generated on: 2024-10-23 18:06:29.072408
Generated by: betaflight_target_converter.py
Source: https://github.com/betaflight/unified-targets
Board name: FENIX_F405
Manufacturer ID: FOSS

//copy this line to madflight.ino to use this flight controller (or copy/paste the whole file)
#include <madflight_board_betaflight_FOSS-FENIX_F405.h>
==============================================================================*/

#define HW_BOARD_NAME "BETAFLIGHT-FOSS-FENIX_F405"
#define HW_MCU "STM32F405"

//Defines from betaflight. Note: madflight will pick the last sensor defined here, this might not be the sensor that is actually on the board. Comment the offending sensors out.
#define IMU_USE  IMU_USE_SPI_MPU6000
#define BB_USE  BB_USE_FLASH
#define BB_FLASH_TYPE  "W25M512"
#define OSD_USE  OSD_USE_MAX7456

//Sensor specific setup
#define IMU_ALIGN  IMU_ALIGN_CW0FLIP
#define BARO_I2C_ADR  0
#define MAG_I2C_ADR  0

//LED:
#define HW_PIN_LED       PA8
#define HW_LED_ON        1 //0:low is on, 1:high is on

//IMU SPI: (SPI3)
#define HW_PIN_SPI_MISO  PC11
#define HW_PIN_SPI_MOSI  PC12
#define HW_PIN_SPI_SCLK  PC10
#define HW_PIN_IMU_CS    PB3
#define HW_PIN_IMU_EXTI  PB6

//BARO/MAG I2C: (I2C1)
#define HW_PIN_I2C_SDA   -1
#define HW_PIN_I2C_SCL   -1

//Outputs:
#define HW_OUT_COUNT     4
#define HW_PIN_OUT_LIST  {PB1,PB0,PA3,PA2}

//RC Receiver: (SERIAL1)
#define HW_PIN_RCIN_RX   PA10
#define HW_PIN_RCIN_TX   PA9
#define HW_PIN_RCIN_INVERTER  -1

//GPS: (SERIAL3)
#define HW_PIN_GPS_RX    PB11
#define HW_PIN_GPS_TX    PB10
#define HW_PIN_GPS_INVERTER  -1

//Battery ADC voltage and current inputs:
#define HW_PIN_BAT_V     PC4
#define HW_PIN_BAT_I     PA1

//-------------------------------------

//Serial
#define HW_SERIAL_COUNT 3
#define HW_PIN_SERIAL { {1,PA9,PA10,-1}, {3,PB10,PB11,-1}, {6,PC6,PC7,-1} } // {INDEX,TX,RX,INVERTER}

//SPI
#define HW_SPI_COUNT 3
#define HW_PIN_SPI { {1,PA5,PA6,PA7}, {2,PB13,PB14,PB15}, {3,PC10,PC11,PC12} } // {INDEX,SCK,MISO,MOSI}

//I2C
#define HW_I2C_COUNT 0
#define HW_PIN_I2C {  } // {INDEX,SCL,SDA}

//other pins
#define HW_PIN_LED_STRIP PC8
//#define HW_PIN_LED PA8
#define HW_PIN_ADC_BATT PC4
#define HW_PIN_ADC_CURR PA1
#define HW_PIN_FLASH_CS PB12
#define HW_PIN_OSD_CS PA4
#define HW_PIN_GYRO_EXTI PB6
#define HW_PIN_GYRO_CS PB3

//set statements
#define HW_SET_SERIALRX_PROVIDER CRSF
#define HW_SET_DSHOT_BITBANG OFF
#define HW_SET_MOTOR_PWM_PROTOCOL DSHOT300
#define HW_SET_BLACKBOX_DEVICE SPIFLASH
#define HW_SET_CURRENT_METER ADC
#define HW_SET_BATTERY_METER ADC
#define HW_SET_IBATA_SCALE 270
#define HW_SET_SYSTEM_HSE_MHZ 8
#define HW_SET_MAX7456_SPI_BUS 1
#define HW_SET_FLASH_SPI_BUS 2
#define HW_SET_GYRO_1_BUSTYPE SPI
#define HW_SET_GYRO_1_SPIBUS 3
#define HW_SET_GYRO_1_SENSOR_ALIGN CW0FLIP
#define HW_SET_GYRO_1_ALIGN_PITCH 1800


/*
#==============================================================================
# BetaFlight Source file
#==============================================================================
# Betaflight / STM32F405 (S405) 4.3.0 Dec 27 2020 / 20:40:55 (32373e3e0) MSP API: 1.44

#define USE_GYRO
#define USE_GYRO_SPI_MPU6000
#define USE_ACC
#define USE_ACC_SPI_MPU6000
#define USE_FLASH
#define USE_FLASH_W25M512
#define USE_MAX7456

board_name FENIX_F405
manufacturer_id FOSS

# resources
resource MOTOR 1 B01
resource MOTOR 2 B00
resource MOTOR 3 A03
resource MOTOR 4 A02
resource LED_STRIP 1 C08
resource SERIAL_TX 1 A09
resource SERIAL_TX 3 B10
resource SERIAL_TX 6 C06
resource SERIAL_RX 1 A10
resource SERIAL_RX 3 B11
resource SERIAL_RX 6 C07
resource LED 1 A08
resource SPI_SCK 1 A05
resource SPI_SCK 2 B13
resource SPI_SCK 3 C10
resource SPI_MISO 1 A06
resource SPI_MISO 2 B14
resource SPI_MISO 3 C11
resource SPI_MOSI 1 A07
resource SPI_MOSI 2 B15
resource SPI_MOSI 3 C12
resource ADC_BATT 1 C04
resource ADC_CURR 1 A01
resource FLASH_CS 1 B12
resource OSD_CS 1 A04
resource GYRO_EXTI 1 B06
resource GYRO_CS 1 B03

# timer
timer B01 AF1
# pin B01: TIM1 CH3N (AF1)
timer B00 AF2
# pin B00: TIM3 CH3 (AF2)
timer A03 AF1
# pin A03: TIM2 CH4 (AF1)
timer A02 AF1
# pin A02: TIM2 CH3 (AF1)
timer C08 AF3
# pin C08: TIM8 CH3 (AF3)

# dma
dma ADC 1 0
# ADC 1: DMA2 Stream 4 Channel 0
dma pin B01 0
# pin B01: DMA2 Stream 6 Channel 0
dma pin B00 0
# pin B00: DMA1 Stream 7 Channel 5
dma pin A03 1
# pin A03: DMA1 Stream 6 Channel 3
dma pin A02 0
# pin A02: DMA1 Stream 1 Channel 3
dma pin C08 1
# pin C08: DMA2 Stream 4 Channel 7

# feature
feature RX_SERIAL
feature OSD
feature LED_STRIP

# serial
serial 5 64 115200 57600 0 115200

# master
set serialrx_provider = CRSF
set dshot_bitbang = OFF
set motor_pwm_protocol = DSHOT300
set blackbox_device = SPIFLASH
set current_meter = ADC
set battery_meter = ADC
set ibata_scale = 270
set system_hse_mhz = 8
set max7456_spi_bus = 1
set flash_spi_bus = 2
set gyro_1_bustype = SPI
set gyro_1_spibus = 3
set gyro_1_sensor_align = CW0FLIP
set gyro_1_align_pitch = 1800

*/
