/*==============================================================================
Generated on: 2024-10-23 18:06:29.013406
Generated by: betaflight_target_converter.py
Source: https://github.com/betaflight/unified-targets
Board name: ELINF722
Manufacturer ID: DRCL

//copy this line to madflight.ino to use this flight controller (or copy/paste the whole file)
#include <madflight_board_betaflight_DRCL-ELINF722.h>
==============================================================================*/

#define HW_BOARD_NAME "BETAFLIGHT-DRCL-ELINF722"
#define HW_MCU "STM32F7X2"

//Defines from betaflight. Note: madflight will pick the last sensor defined here, this might not be the sensor that is actually on the board. Comment the offending sensors out.
#define IMU_USE  IMU_USE_SPI_MPU6500
#define OSD_USE  OSD_USE_MAX7456

//Sensor specific setup
#define IMU_ALIGN  IMU_ALIGN_CW0
#define BARO_I2C_ADR  0
#define MAG_I2C_ADR  0

//LED:
#define HW_PIN_LED       PB5
#define HW_LED_ON        1 //0:low is on, 1:high is on

//IMU SPI: (SPI1)
#define HW_PIN_SPI_MISO  PA6
#define HW_PIN_SPI_MOSI  PA7
#define HW_PIN_SPI_SCLK  PA5
#define HW_PIN_IMU_CS    PA4
#define HW_PIN_IMU_EXTI  PC4

//BARO/MAG I2C: (I2C1)
#define HW_PIN_I2C_SDA   PB8
#define HW_PIN_I2C_SCL   PB9

//Outputs:
#define HW_OUT_COUNT     4
#define HW_PIN_OUT_LIST  {PB0,PB1,PA3,PA2}

//RC Receiver: (SERIAL1)
#define HW_PIN_RCIN_RX   PA10
#define HW_PIN_RCIN_TX   PA9
#define HW_PIN_RCIN_INVERTER  -1

//GPS: (SERIAL3)
#define HW_PIN_GPS_RX    PB11
#define HW_PIN_GPS_TX    PB10
#define HW_PIN_GPS_INVERTER  -1

//Battery ADC voltage and current inputs:
#define HW_PIN_BAT_V     PC2
#define HW_PIN_BAT_I     PC1

//-------------------------------------

//Serial
#define HW_SERIAL_COUNT 6
#define HW_PIN_SERIAL { {1,PA9,PA10,-1}, {3,PB10,PB11,-1}, {4,PA0,PA1,-1}, {6,PC6,PC7,-1}, {11,PC9,-1,-1}, {12,-1,PA8,-1} } // {INDEX,TX,RX,INVERTER}

//SPI
#define HW_SPI_COUNT 3
#define HW_PIN_SPI { {1,PA5,PA6,PA7}, {2,PB13,PB14,PB15}, {3,PC10,PC11,PC12} } // {INDEX,SCK,MISO,MOSI}

//I2C
#define HW_I2C_COUNT 1
#define HW_PIN_I2C { {1,PB8,PB9} } // {INDEX,SCL,SDA}

//other pins
#define HW_PIN_BEEPER PB4
#define HW_PIN_PPM PB6
#define HW_PIN_LED_STRIP PB6
//#define HW_PIN_LED PB5
#define HW_PIN_CAMERA_CONTROL PB7
#define HW_PIN_ADC_BATT PC2
#define HW_PIN_ADC_CURR PC1
#define HW_PIN_PINIO PC13
#define HW_PIN_PINIO_2 PC14
#define HW_PIN_FLASH_CS PB3
#define HW_PIN_OSD_CS PC8
#define HW_PIN_GYRO_EXTI PC4
#define HW_PIN_GYRO_CS PA4
#define HW_PIN_USB_DETECT PC15

//set statements
#define HW_SET_MAG_HARDWARE NONE
#define HW_SET_BARO_BUSTYPE I2C
#define HW_SET_BARO_I2C_DEVICE 1
#define HW_SET_SERIALRX_PROVIDER SBUS
#define HW_SET_SERIALRX_HALFDUPLEX ON
#define HW_SET_DSHOT_BURST ON
#define HW_SET_MOTOR_PWM_PROTOCOL DSHOT600
#define HW_SET_CURRENT_METER ADC
#define HW_SET_BATTERY_METER ADC
#define HW_SET_PID_PROCESS_DENOM 1
#define HW_SET_OSD_WARN_CORE_TEMP OFF
#define HW_SET_OSD_WARN_RC_SMOOTHING OFF
#define HW_SET_OSD_WARN_FAIL_SAFE OFF
#define HW_SET_OSD_WARN_LAUNCH_CONTROL OFF
#define HW_SET_OSD_WARN_NO_GPS_RESCUE OFF
#define HW_SET_OSD_WARN_GPS_RESCUE_DISABLED OFF
#define HW_SET_OSD_VBAT_POS 2401
#define HW_SET_OSD_RSSI_POS 2106
#define HW_SET_OSD_VTX_CHANNEL_POS 2424
#define HW_SET_OSD_CROSSHAIRS_POS 2253
#define HW_SET_OSD_AH_SBAR_POS 2254
#define HW_SET_OSD_AH_POS 2126
#define HW_SET_OSD_COMPASS_BAR_POS 106
#define HW_SET_OSD_WARNINGS_POS 2377
#define HW_SET_VCD_VIDEO_SYSTEM NTSC
#define HW_SET_MAX7456_SPI_BUS 2
#define HW_SET_PINIO_BOX 40,41,255,255
#define HW_SET_FLASH_SPI_BUS 3
#define HW_SET_GYRO_1_BUSTYPE SPI
#define HW_SET_GYRO_1_SPIBUS 1
#define HW_SET_GYRO_1_SENSOR_ALIGN CW0
#define HW_SET_GYRO_2_SPIBUS 1


/*
#==============================================================================
# BetaFlight Source file
#==============================================================================
# Betaflight / STM32F7X2 (S7X2) 4.0.0 Mar 26 2019 / 19:51:34 (173e958da) MSP API: 1.41

#define USE_ACC
#define USE_ACC_SPI_MPU6500
#define USE_GYRO
#define USE_GYRO_SPI_MPU6500
#define USE_MAX7456

board_name ELINF722
manufacturer_id DRCL

# name

# resources
resource BEEPER 1 B04
resource MOTOR 1 B00
resource MOTOR 2 B01
resource MOTOR 3 A03
resource MOTOR 4 A02
resource PPM 1 B06
resource LED_STRIP 1 B06
resource SERIAL_TX 1 A09
resource SERIAL_TX 3 B10
resource SERIAL_TX 4 A00
resource SERIAL_TX 6 C06
resource SERIAL_TX 11 C09
resource SERIAL_RX 1 A10
resource SERIAL_RX 3 B11
resource SERIAL_RX 4 A01
resource SERIAL_RX 6 C07
resource SERIAL_RX 12 A08
resource I2C_SCL 1 B08
resource I2C_SDA 1 B09
resource LED 1 B05
resource SPI_SCK 1 A05
resource SPI_SCK 2 B13
resource SPI_SCK 3 C10
resource SPI_MISO 1 A06
resource SPI_MISO 2 B14
resource SPI_MISO 3 C11
resource SPI_MOSI 1 A07
resource SPI_MOSI 2 B15
resource SPI_MOSI 3 C12
resource CAMERA_CONTROL 1 B07
resource ADC_BATT 1 C02
resource ADC_CURR 1 C01
resource PINIO 1 C13
resource PINIO 2 C14
resource FLASH_CS 1 B03
resource OSD_CS 1 C08
resource GYRO_EXTI 1 C04
resource GYRO_CS 1 A04
resource USB_DETECT 1 C15

# timer
timer B00 AF2
# pin B00: TIM3 CH3 (AF2)
timer B01 AF2
# pin B01: TIM3 CH4 (AF2)
timer A03 AF1
# pin A03: TIM2 CH4 (AF1)
timer A02 AF1
# pin A02: TIM2 CH3 (AF1)
timer A08 AF1
# pin A08: TIM1 CH1 (AF1)
timer C09 AF3
# pin C09: TIM8 CH4 (AF3)
timer B06 AF2
# pin B06: TIM4 CH1 (AF2)
timer B07 AF2
# pin B07: TIM4 CH2 (AF2)

# dma
dma ADC 1 1
# ADC 1: DMA2 Stream 4 Channel 0
dma pin B00 0
# pin B00: DMA1 Stream 7 Channel 5
dma pin B01 0
# pin B01: DMA1 Stream 2 Channel 5
dma pin A03 1
# pin A03: DMA1 Stream 6 Channel 3
dma pin A02 0
# pin A02: DMA1 Stream 1 Channel 3
dma pin A08 0
# pin A08: DMA2 Stream 6 Channel 0
dma pin C09 0
# pin C09: DMA2 Stream 7 Channel 7
dma pin B06 0
# pin B06: DMA1 Stream 0 Channel 2
dma pin B07 0
# pin B07: DMA1 Stream 3 Channel 2

# mixer

# servo

# servo mix


# feature
feature RX_SERIAL
feature SOFTSERIAL
feature TELEMETRY
feature OSD

# beeper

# beacon

# map

# serial
serial 0 64 115200 57600 0 115200

# led

# color

# mode_color

# aux

# adjrange

# rxrange

# vtx

# rxfail

# display_name

# master
set mag_hardware = NONE
set baro_bustype = I2C
set baro_i2c_device = 1
set serialrx_provider = SBUS
set serialrx_halfduplex = ON
set dshot_burst = ON
set motor_pwm_protocol = DSHOT600
set current_meter = ADC
set battery_meter = ADC
set pid_process_denom = 1
set osd_warn_core_temp = OFF
set osd_warn_rc_smoothing = OFF
set osd_warn_fail_safe = OFF
set osd_warn_launch_control = OFF
set osd_warn_no_gps_rescue = OFF
set osd_warn_gps_rescue_disabled = OFF
set osd_vbat_pos = 2401
set osd_rssi_pos = 2106
set osd_vtx_channel_pos = 2424
set osd_crosshairs_pos = 2253
set osd_ah_sbar_pos = 2254
set osd_ah_pos = 2126
set osd_compass_bar_pos = 106
set osd_warnings_pos = 2377
set vcd_video_system = NTSC
set max7456_spi_bus = 2
set pinio_box = 40,41,255,255
set flash_spi_bus = 3
set gyro_1_bustype = SPI
set gyro_1_spibus = 1
set gyro_1_sensor_align = CW0
set gyro_2_spibus = 1

*/
