/*==============================================================================
Generated on: 2024-10-23 18:06:28.983894
Generated by: betaflight_target_converter.py
Source: https://github.com/betaflight/unified-targets
Board name: SIRMIXALOT
Manufacturer ID: CUST

//copy this line to madflight.ino to use this flight controller (or copy/paste the whole file)
#include <madflight_board_betaflight_CUST-SIRMIXALOT.h>
==============================================================================*/

#define HW_BOARD_NAME "BETAFLIGHT-CUST-SIRMIXALOT"
#define HW_MCU "STM32F7X2"

//Defines from betaflight. Note: madflight will pick the last sensor defined here, this might not be the sensor that is actually on the board. Comment the offending sensors out.

//Sensor specific setup
#define IMU_ALIGN  IMU_ALIGN_CW180
#define BARO_I2C_ADR  0
#define MAG_I2C_ADR  0

//LED:
#define HW_PIN_LED       PB12
#define HW_LED_ON        1 //0:low is on, 1:high is on

//IMU SPI: (SPI1)
#define HW_PIN_SPI_MISO  PA6
#define HW_PIN_SPI_MOSI  PA7
#define HW_PIN_SPI_SCLK  PA5
#define HW_PIN_IMU_CS    PA4
#define HW_PIN_IMU_EXTI  PC4

//BARO/MAG I2C: (I2C1)
#define HW_PIN_I2C_SDA   PA8
#define HW_PIN_I2C_SCL   PC9

//Outputs:
#define HW_OUT_COUNT     4
#define HW_PIN_OUT_LIST  {PB6,PB7,PB8,PA15}

//RC Receiver: (SERIAL1)
#define HW_PIN_RCIN_RX   PA10
#define HW_PIN_RCIN_TX   PA9
#define HW_PIN_RCIN_INVERTER  -1

//GPS: (SERIAL2)
#define HW_PIN_GPS_RX    PA3
#define HW_PIN_GPS_TX    PA2
#define HW_PIN_GPS_INVERTER  -1

//Battery ADC voltage and current inputs:
#define HW_PIN_BAT_V     PC2
#define HW_PIN_BAT_I     PC1

//-------------------------------------

//Serial
#define HW_SERIAL_COUNT 7
#define HW_PIN_SERIAL { {1,PA9,PA10,-1}, {2,PA2,PA3,-1}, {3,PB10,-1,-1}, {4,-1,PA1,-1}, {5,PC12,PD2,-1}, {6,PC6,PC7,-1}, {11,PA0,PB11,-1} } // {INDEX,TX,RX,INVERTER}

//SPI
#define HW_SPI_COUNT 3
#define HW_PIN_SPI { {1,PA5,PA6,PA7}, {2,PB13,PB14,PB15}, {3,PB3,PB4,PB5} } // {INDEX,SCK,MISO,MOSI}

//I2C
#define HW_I2C_COUNT 1
#define HW_PIN_I2C { {1,PA8,PC9} } // {INDEX,SCL,SDA}

//other pins
#define HW_PIN_BEEPER PC11
#define HW_PIN_LED_STRIP PB1
//#define HW_PIN_LED PB12
#define HW_PIN_LED_2 PC8
#define HW_PIN_CAMERA_CONTROL PC10
#define HW_PIN_ADC_BATT PC2
#define HW_PIN_ADC_RSSI PC3
#define HW_PIN_ADC_CURR PC1
#define HW_PIN_BARO_CS PB9
#define HW_PIN_FLASH_CS PC0
#define HW_PIN_OSD_CS PC14
#define HW_PIN_GYRO_EXTI PC4
#define HW_PIN_GYRO_CS PA4
#define HW_PIN_USB_DETECT PB2

//set statements
#define HW_SET_MAG_HARDWARE AUTO
#define HW_SET_BARO_SPI_DEVICE 3
#define HW_SET_SERIALRX_PROVIDER FPORT
#define HW_SET_SERIALRX_INVERTED ON
#define HW_SET_SERIALRX_HALFDUPLEX ON
#define HW_SET_BLACKBOX_DEVICE SPIFLASH
#define HW_SET_DSHOT_BURST ON
#define HW_SET_DSHOT_BIDIR OFF
#define HW_SET_MOTOR_PWM_PROTOCOL DSHOT600
#define HW_SET_CURRENT_METER ADC
#define HW_SET_BATTERY_METER ADC
#define HW_SET_VBAT_SCALE 80
#define HW_SET_IBATA_SCALE 210
#define HW_SET_BEEPER_INVERSION ON
#define HW_SET_BEEPER_OD OFF
#define HW_SET_PID_PROCESS_DENOM 1
#define HW_SET_LEDSTRIP_VISUAL_BEEPER ON
#define HW_SET_OSD_VBAT_POS 2403
#define HW_SET_OSD_RSSI_POS 2436
#define HW_SET_OSD_RSSI_DBM_POS 66
#define HW_SET_OSD_TIM_1_POS 2071
#define HW_SET_OSD_TIM_2_POS 2103
#define HW_SET_OSD_FLYMODE_POS 2424
#define HW_SET_OSD_VTX_CHANNEL_POS 480
#define HW_SET_OSD_CRAFT_NAME_POS 2058
#define HW_SET_OSD_GPS_SPEED_POS 2359
#define HW_SET_OSD_GPS_SATS_POS 2392
#define HW_SET_OSD_HOME_DIR_POS 2095
#define HW_SET_OSD_ALTITUDE_POS 2135
#define HW_SET_OSD_WARNINGS_POS 14698
#define HW_SET_OSD_DISARMED_POS 2250
#define HW_SET_VTX_BAND 1
#define HW_SET_VTX_CHANNEL 3
#define HW_SET_VTX_POWER 1
#define HW_SET_VTX_FREQ 5825
#define HW_SET_MAX7456_SPI_BUS 3
#define HW_SET_LED_INVERSION 3
#define HW_SET_FLASH_SPI_BUS 2
#define HW_SET_GYRO_1_BUSTYPE SPI
#define HW_SET_GYRO_1_SPIBUS 1
#define HW_SET_GYRO_1_SENSOR_ALIGN CW180
#define HW_SET_GYRO_1_ALIGN_YAW 1800


/*
#==============================================================================
# BetaFlight Source file
#==============================================================================
# Betaflight / STM32F7X2 (S7X2) 4.1.0 Sep 25 2019 / 14:09:57 (08e8afa09) MSP API: 1.42
# manufacturer_id: CUST   board_name: SIRMIXALOT   custom defaults: NO

board_name SIRMIXALOT
manufacturer_id CUST

# resources
resource BEEPER 1 C11
resource MOTOR 1 B06
resource MOTOR 2 B07
resource MOTOR 3 B08
resource MOTOR 4 A15
resource LED_STRIP 1 B01
resource SERIAL_TX 1 A09
resource SERIAL_TX 2 A02
resource SERIAL_TX 3 B10
resource SERIAL_TX 5 C12
resource SERIAL_TX 6 C06
resource SERIAL_TX 11 A00
resource SERIAL_RX 1 A10
resource SERIAL_RX 2 A03
resource SERIAL_RX 4 A01
resource SERIAL_RX 5 D02
resource SERIAL_RX 6 C07
resource SERIAL_RX 11 B11
resource I2C_SCL 1 A08
resource I2C_SDA 1 C09
resource LED 1 B12
resource LED 2 C08
resource SPI_SCK 1 A05
resource SPI_SCK 2 B13
resource SPI_SCK 3 B03
resource SPI_MISO 1 A06
resource SPI_MISO 2 B14
resource SPI_MISO 3 B04
resource SPI_MOSI 1 A07
resource SPI_MOSI 2 B15
resource SPI_MOSI 3 B05
resource CAMERA_CONTROL 1 C10
resource ADC_BATT 1 C02
resource ADC_RSSI 1 C03
resource ADC_CURR 1 C01
resource BARO_CS 1 B09
resource FLASH_CS 1 C00
resource OSD_CS 1 C14
resource GYRO_EXTI 1 C04
resource GYRO_CS 1 A04
resource USB_DETECT 1 B02

# timer
timer B06 AF2
# pin B06: TIM4 CH1 (AF2)
timer B07 AF2
# pin B07: TIM4 CH2 (AF2)
timer B08 AF2
# pin B08: TIM4 CH3 (AF2)
timer B01 AF2
# pin B01: TIM3 CH4 (AF2)
timer A15 AF1
# pin A15: TIM2 CH1 (AF1)

# dma
dma ADC 1 1
# ADC 1: DMA2 Stream 4 Channel 0
dma pin B06 0
# pin B06: DMA1 Stream 0 Channel 2
dma pin B07 0
# pin B07: DMA1 Stream 3 Channel 2
dma pin B08 0
# pin B08: DMA1 Stream 7 Channel 2
dma pin B01 0
# pin B01: DMA1 Stream 2 Channel 5
dma pin A15 0
# pin A15: DMA1 Stream 5 Channel 3

# feature
feature RX_SERIAL
feature SOFTSERIAL
feature TELEMETRY
feature LED_STRIP
feature OSD

# beeper
beeper -ON_USB

# serial
serial 2 2048 115200 57600 0 115200
serial 3 1024 115200 57600 0 115200
serial 4 64 115200 57600 0 115200
serial 30 16384 115200 57600 0 115200

# led
led 0 7,7::A:2

# color
color 10 240,128,255

# mode_color
mode_color 6 1 2

# aux
aux 0 0 0 1700 2100 0 0
aux 1 27 8 1300 2100 0 0
aux 2 13 4 1300 2100 0 0
aux 3 15 5 1300 2100 0 0
aux 4 26 0 900 2100 0 0
aux 5 33 2 1300 1700 0 0
aux 6 34 3 1300 1700 0 0
aux 7 36 6 1700 2100 0 0

# master
set mag_hardware = AUTO
set baro_spi_device = 3
set serialrx_provider = FPORT
set serialrx_inverted = ON
set serialrx_halfduplex = ON
set blackbox_device = SPIFLASH
set dshot_burst = ON
set dshot_bidir = OFF
set motor_pwm_protocol = DSHOT600
set current_meter = ADC
set battery_meter = ADC
set vbat_scale = 80
set ibata_scale = 210
set beeper_inversion = ON
set beeper_od = OFF
set pid_process_denom = 1
set ledstrip_visual_beeper = ON
set osd_vbat_pos = 2403
set osd_rssi_pos = 2436
set osd_rssi_dbm_pos = 66
set osd_tim_1_pos = 2071
set osd_tim_2_pos = 2103
set osd_flymode_pos = 2424
set osd_vtx_channel_pos = 480
set osd_craft_name_pos = 2058
set osd_gps_speed_pos = 2359
set osd_gps_sats_pos = 2392
set osd_home_dir_pos = 2095
set osd_altitude_pos = 2135
set osd_warnings_pos = 14698
set osd_disarmed_pos = 2250
set vtx_band = 1
set vtx_channel = 3
set vtx_power = 1
set vtx_freq = 5825
set max7456_spi_bus = 3
set led_inversion = 3
set flash_spi_bus = 2
set gyro_1_bustype = SPI
set gyro_1_spibus = 1
set gyro_1_sensor_align = CW180
set gyro_1_align_yaw = 1800

*/
