/*==============================================================================
Generated on: 2024-10-23 18:06:28.974888
Generated by: betaflight_target_converter.py
Source: https://github.com/betaflight/unified-targets
Board name: NERO
Manufacturer ID: BKMN

//copy this line to madflight.ino to use this flight controller (or copy/paste the whole file)
#include <madflight_board_betaflight_BKMN-NERO.h>
==============================================================================*/

#define HW_BOARD_NAME "BETAFLIGHT-BKMN-NERO"
#define HW_MCU "STM32F7X2"

//Defines from betaflight. Note: madflight will pick the last sensor defined here, this might not be the sensor that is actually on the board. Comment the offending sensors out.
#define IMU_USE  IMU_USE_SPI_ICM20602
#define BB_USE  BB_USE_SDCARD

//Sensor specific setup
#define IMU_ALIGN  IMU_ALIGN_CW0
#define BARO_I2C_ADR  0
#define MAG_I2C_ADR  0

//LED:
#define HW_PIN_LED       PB6
#define HW_LED_ON        1 //0:low is on, 1:high is on

//IMU SPI: (SPI1)
#define HW_PIN_SPI_MISO  PA6
#define HW_PIN_SPI_MOSI  PA7
#define HW_PIN_SPI_SCLK  PA5
#define HW_PIN_IMU_CS    PC4
#define HW_PIN_IMU_EXTI  PB2

//BARO/MAG I2C: (I2C1)
#define HW_PIN_I2C_SDA   PB8
#define HW_PIN_I2C_SCL   PB9

//Outputs:
#define HW_OUT_COUNT     7
#define HW_PIN_OUT_LIST  {PA0,PA1,PA2,PA3,PB1,PC8,PC9}

//RC Receiver: (SERIAL1)
#define HW_PIN_RCIN_RX   PA10
#define HW_PIN_RCIN_TX   PA9
#define HW_PIN_RCIN_INVERTER  -1

//GPS: (SERIAL3)
#define HW_PIN_GPS_RX    PB11
#define HW_PIN_GPS_TX    PB10
#define HW_PIN_GPS_INVERTER  -1

//Battery ADC voltage and current inputs:
#define HW_PIN_BAT_V     PC3
#define HW_PIN_BAT_I     PC2

//-------------------------------------

//Serial
#define HW_SERIAL_COUNT 3
#define HW_PIN_SERIAL { {1,PA9,PA10,-1}, {3,PB10,PB11,-1}, {6,PC6,PC7,-1} } // {INDEX,TX,RX,INVERTER}

//SPI
#define HW_SPI_COUNT 3
#define HW_PIN_SPI { {1,PA5,PA6,PA7}, {2,PB13,PB14,PB15}, {3,PC10,PC11,PC12} } // {INDEX,SCK,MISO,MOSI}

//I2C
#define HW_I2C_COUNT 1
#define HW_PIN_I2C { {1,PB8,PB9} } // {INDEX,SCL,SDA}

//other pins
#define HW_PIN_BEEPER PC1
#define HW_PIN_LED_STRIP PB0
//#define HW_PIN_LED PB6
#define HW_PIN_LED_2 PB5
#define HW_PIN_LED_3 PB4
#define HW_PIN_ADC_BATT PC3
#define HW_PIN_ADC_CURR PC2
#define HW_PIN_ADC_RSSI PA4
#define HW_PIN_GYRO_CS PC4
#define HW_PIN_GYRO_EXTI PB2
#define HW_PIN_SDCARD_CS PA15
#define HW_PIN_SDCARD_DETECT PD2

//set statements
#define HW_SET_DSHOT_BURST ON
#define HW_SET_GYRO_1_BUSTYPE SPI
#define HW_SET_GYRO_1_SPIBUS 1
#define HW_SET_GYRO_1_SENSOR_ALIGN CW0
#define HW_SET_BLACKBOX_DEVICE SDCARD
#define HW_SET_SDCARD_MODE SPI
#define HW_SET_SDCARD_SPI_BUS 3
#define HW_SET_SDCARD_DETECT_INVERTED ON
#define HW_SET_BEEPER_INVERSION ON
#define HW_SET_BEEPER_OD OFF
#define HW_SET_CURRENT_METER ADC
#define HW_SET_BATTERY_METER ADC
#define HW_SET_MAG_HARDWARE NONE
#define HW_SET_BARO_HARDWARE NONE


/*
#==============================================================================
# BetaFlight Source file
#==============================================================================
# Betaflight / STM32F7X2 (S7X2) 4.4.3 Mar 18 2024 / 20:58:20 (738127e7e) MSP API: 1.45

#define USE_ACC
#define USE_ACC_SPI_ICM20602
#define USE_GYRO
#define USE_GYRO_SPI_ICM20602
#define USE_SDCARD

board_name NERO
manufacturer_id BKMN

# resources
resource BEEPER 1 C01
resource LED_STRIP 1 B00 # pin M5
resource LED 1 B06
resource LED 2 B05
resource LED 3 B04

# Motors
resource MOTOR 1 A00
resource MOTOR 2 A01
resource MOTOR 3 A02
resource MOTOR 4 A03
# resource MOTOR 5 B00
resource MOTOR 6 B01
resource MOTOR 7 C08
resource MOTOR 8 C09

# UARTS
resource SERIAL_TX 1 A09
resource SERIAL_RX 1 A10
resource SERIAL_TX 3 B10
resource SERIAL_RX 3 B11
resource SERIAL_TX 6 C06
resource SERIAL_RX 6 C07

# I2C1
resource I2C_SCL 1 B08
resource I2C_SDA 1 B09

# ADC
resource ADC_BATT 1 C03
resource ADC_CURR 1 C02 # --> pin AD
resource ADC_RSSI 1 A04 # --> pin DA

# GYRO & ACC --> SPI1
resource SPI_SCK 1 A05
resource SPI_MISO 1 A06
resource SPI_MOSI 1 A07
resource GYRO_CS 1 C04
resource GYRO_EXTI 1 B02

# ACC_SPI --> SPI2 (CS pin B12)
resource SPI_SCK 2 B13
resource SPI_MISO 2 B14
resource SPI_MOSI 2 B15

# SDCARD --> SPI3
resource SPI_SCK 3 C10
resource SPI_MISO 3 C11
resource SPI_MOSI 3 C12
resource SDCARD_CS 1 A15
resource SDCARD_DETECT 1 D02

# timer
timer A00 AF2
# pin A00: TIM5 CH1 (AF2)
timer A01 AF2
# pin A01: TIM5 CH2 (AF2)
timer A02 AF2
# pin A02: TIM5 CH3 (AF2)
timer A03 AF2
# pin A03: TIM5 CH4 (AF2)
timer B00 AF2
# pin B00: TIM3 CH3 (AF2)
timer B01 AF2
# pin B01: TIM3 CH4 (AF2)
timer C08 AF3
# pin C08: TIM8 CH3 (AF3)
timer C09 AF3
# pin C09: TIM8 CH4 (AF3)

# dma
dma ADC 1 1
# ADC 1: DMA2 Stream 4 Channel 0
dma pin A00 0
# pin A00: DMA1 Stream 2 Channel 6
dma pin A01 0
# pin A01: DMA1 Stream 4 Channel 6
dma pin A02 0
# pin A02: DMA1 Stream 0 Channel 6
dma pin A03 0
# pin A03: DMA1 Stream 1 Channel 6
dma pin B00 0
# pin B00: DMA1 Stream 7 Channel 5
dma pin B01 0
# pin B01: DMA1 Stream 2 Channel 5
dma pin C08 0
# pin C08: DMA2 Stream 2 Channel 0
dma pin C09 0
# pin C09: DMA2 Stream 7 Channel 7

# master
set dshot_burst = ON
set gyro_1_bustype = SPI
set gyro_1_spibus = 1
set gyro_1_sensor_align = CW0
set blackbox_device = SDCARD
set sdcard_mode = SPI
set sdcard_spi_bus = 3
set sdcard_detect_inverted = ON
set beeper_inversion = ON
set beeper_od = OFF
set current_meter = ADC
set battery_meter = ADC
set mag_hardware = NONE
set baro_hardware = NONE

*/
