/*==============================================================================
Generated on: 2024-10-23 18:06:28.971879
Generated by: betaflight_target_converter.py
Source: https://github.com/betaflight/unified-targets
Board name: BETAFPVG473
Manufacturer ID: BEFH

//copy this line to madflight.ino to use this flight controller (or copy/paste the whole file)
#include <madflight_board_betaflight_BEFH-BETAFPVG473.h>
==============================================================================*/

#define HW_BOARD_NAME "BETAFLIGHT-BEFH-BETAFPVG473"
#define HW_MCU "STM32G47X"

//Defines from betaflight. Note: madflight will pick the last sensor defined here, this might not be the sensor that is actually on the board. Comment the offending sensors out.
#define IMU_USE  IMU_USE_SPI_ICM42688P
#define BARO_USE  BARO_USE_BMP280
#define BARO_USE  BARO_USE_DPS310
#define BB_USE  BB_USE_FLASH
#define BB_FLASH_TYPE  "M25P16"
#define OSD_USE  OSD_USE_MAX7456

//Sensor specific setup
#define IMU_ALIGN  IMU_ALIGN_CW180
#define BARO_I2C_ADR  0
#define MAG_I2C_ADR  0

//LED:
#define HW_PIN_LED       PC15
#define HW_LED_ON        1 //0:low is on, 1:high is on

//IMU SPI: (SPI1)
#define HW_PIN_SPI_MISO  PA6
#define HW_PIN_SPI_MOSI  PA7
#define HW_PIN_SPI_SCLK  PA5
#define HW_PIN_IMU_CS    PA4
#define HW_PIN_IMU_EXTI  PC4

//BARO/MAG I2C: (I2C1)
#define HW_PIN_I2C_SDA   PA15
#define HW_PIN_I2C_SCL   PB7

//Outputs:
#define HW_OUT_COUNT     4
#define HW_PIN_OUT_LIST  {PB0,PB1,PB6,PC13}

//RC Receiver: (SERIAL1)
#define HW_PIN_RCIN_RX   PA10
#define HW_PIN_RCIN_TX   PA9
#define HW_PIN_RCIN_INVERTER  -1

//GPS: (SERIAL2)
#define HW_PIN_GPS_RX    PA3
#define HW_PIN_GPS_TX    PA2
#define HW_PIN_GPS_INVERTER  -1

//Battery ADC voltage and current inputs:
#define HW_PIN_BAT_V     PA0
#define HW_PIN_BAT_I     PA1

//-------------------------------------

//Serial
#define HW_SERIAL_COUNT 4
#define HW_PIN_SERIAL { {1,PA9,PA10,-1}, {2,PA2,PA3,-1}, {3,PB10,PB11,-1}, {4,PC10,PC11,-1} } // {INDEX,TX,RX,INVERTER}

//SPI
#define HW_SPI_COUNT 3
#define HW_PIN_SPI { {1,PA5,PA6,PA7}, {2,PB13,PB14,PB15}, {3,PB3,PB4,PB5} } // {INDEX,SCK,MISO,MOSI}

//I2C
#define HW_I2C_COUNT 1
#define HW_PIN_I2C { {1,PA15,PB7} } // {INDEX,SCL,SDA}

//other pins
#define HW_PIN_BEEPER PA8
#define HW_PIN_LED_STRIP PB2
//#define HW_PIN_LED PC15
#define HW_PIN_LED_2 PC14
#define HW_PIN_ADC_BATT PA0
#define HW_PIN_ADC_CURR PA1
#define HW_PIN_FLASH_CS PB9
#define HW_PIN_OSD_CS PB12
#define HW_PIN_GYRO_EXTI PC4
#define HW_PIN_GYRO_CS PA4

//set statements
#define HW_SET_BARO_BUSTYPE I2C
#define HW_SET_BARO_I2C_DEVICE 1
#define HW_SET_SERIALRX_PROVIDER CRSF
#define HW_SET_BLACKBOX_DEVICE SPIFLASH
#define HW_SET_IBATA_SCALE 750
#define HW_SET_DSHOT_IDLE_VALUE 450
#define HW_SET_DSHOT_BURST OFF
#define HW_SET_DSHOT_BITBANG AUTO
#define HW_SET_CURRENT_METER ADC
#define HW_SET_BATTERY_METER ADC
#define HW_SET_BEEPER_INVERSION ON
#define HW_SET_BEEPER_OD OFF
#define HW_SET_MAX7456_SPI_BUS 2
#define HW_SET_FLASH_SPI_BUS 3
#define HW_SET_GYRO_1_BUSTYPE SPI
#define HW_SET_GYRO_1_SPIBUS 1
#define HW_SET_GYRO_1_SENSOR_ALIGN CW180
#define HW_SET_GYRO_1_ALIGN_YAW 1800


/*
#==============================================================================
# BetaFlight Source file
#==============================================================================
# Betaflight / STM32G47X (SG47) 4.3.0 Jun 14 2022 / 00:51:21 (229ac66) MSP API: 1.44

board_name BETAFPVG473
manufacturer_id BEFH

#define USE_GYRO
#define USE_ACC
#define USE_GYRO_SPI_ICM42688P
#define USE_ACC_SPI_ICM42688P
#define USE_ACCGYRO_BMI270
#define USE_BARO
#define USE_BARO_BMP280
#define USE_BARO_DPS310
#define USE_FLASH
#define USE_FLASH_M25P16
#define USE_MAX7456

# resource
resource BEEPER 1 A08
resource MOTOR 1 B00
resource MOTOR 2 B01
resource MOTOR 3 B06
resource MOTOR 4 C13
resource LED_STRIP 1 B02
resource SERIAL_TX 1 A09
resource SERIAL_TX 2 A02
resource SERIAL_TX 3 B10
resource SERIAL_TX 4 C10
resource SERIAL_RX 1 A10
resource SERIAL_RX 2 A03
resource SERIAL_RX 3 B11
resource SERIAL_RX 4 C11
resource I2C_SCL 1 A15
resource I2C_SDA 1 B07
resource LED 1 C15
resource LED 2 C14
resource SPI_SCK 1 A05
resource SPI_SCK 2 B13
resource SPI_SCK 3 B03
resource SPI_MISO 1 A06
resource SPI_MISO 2 B14
resource SPI_MISO 3 B04
resource SPI_MOSI 1 A07
resource SPI_MOSI 2 B15
resource SPI_MOSI 3 B05
resource ADC_BATT 1 A00
resource ADC_CURR 1 A01
resource FLASH_CS 1 B09
resource OSD_CS 1 B12
resource GYRO_EXTI 1 C04
resource GYRO_CS 1 A04

# timer
timer B02 AF2
# pin B02: TIM5 CH1 (AF2)
timer B00 AF2
# pin B00: TIM3 CH3 (AF2)
timer B01 AF2
# pin B01: TIM3 CH4 (AF2)
timer B06 AF5
# pin B06: TIM8 CH1 (AF5)
timer C13 AF6
# pin C13: TIM8 CH4N (AF6)

# dma
dma SPI_MOSI 1 14
# SPI_MOSI 1: DMA2 Channel 7 Request 11
dma SPI_MOSI 2 10
# SPI_MOSI 2: DMA2 Channel 3 Request 13
dma SPI_MOSI 3 9
# SPI_MOSI 3: DMA2 Channel 2 Request 15
dma SPI_MISO 1 13
# SPI_MISO 1: DMA2 Channel 6 Request 10
dma SPI_MISO 2 11
# SPI_MISO 2: DMA2 Channel 4 Request 12
dma SPI_MISO 3 8
# SPI_MISO 3: DMA2 Channel 1 Request 14
dma SPI_TX 1 14
# SPI_TX 1: DMA2 Channel 7 Request 11
dma SPI_TX 2 10
# SPI_TX 2: DMA2 Channel 3 Request 13
dma SPI_TX 3 9
# SPI_TX 3: DMA2 Channel 2 Request 15
dma SPI_RX 1 13
# SPI_RX 1: DMA2 Channel 6 Request 10
dma SPI_RX 2 11
# SPI_RX 2: DMA2 Channel 4 Request 12
dma SPI_RX 3 8
# SPI_RX 3: DMA2 Channel 1 Request 14
dma ADC 1 6
# ADC 1: DMA1 Channel 7 Request 5
dma pin B02 1
# pin B02: DMA1 Channel 2 Request 72
dma pin B00 2
# pin B00: DMA1 Channel 3 Request 63
dma pin B01 3
# pin B01: DMA1 Channel 4 Request 64
dma pin B06 4
# pin B06: DMA1 Channel 5 Request 49
dma pin C13 5
# pin C13: DMA1 Channel 6 Request 52

# feature
feature RX_SERIAL
feature TELEMETRY
feature OSD
feature AIRMODE

# serial
serial 1 2048 115200 57600 0 115200
serial 2 64 115200 57600 0 115200

# master
set baro_bustype = I2C
set baro_i2c_device = 1
set serialrx_provider = CRSF
set blackbox_device = SPIFLASH
set ibata_scale = 750
set dshot_idle_value = 450
set dshot_burst = OFF
set dshot_bitbang = AUTO
set current_meter = ADC
set battery_meter = ADC
set beeper_inversion = ON
set beeper_od = OFF
set max7456_spi_bus = 2
set flash_spi_bus = 3
set gyro_1_bustype = SPI
set gyro_1_spibus = 1
set gyro_1_sensor_align = CW180
set gyro_1_align_yaw = 1800

*/
