/*==============================================================================
Generated on: 2024-10-23 18:06:28.961889
Generated by: betaflight_target_converter.py
Source: https://github.com/betaflight/unified-targets
Board name: MERCURYG4
Manufacturer ID: ANYL

//copy this line to madflight.ino to use this flight controller (or copy/paste the whole file)
#include <madflight_board_betaflight_ANYL-MERCURYG4.h>
==============================================================================*/

#define HW_BOARD_NAME "BETAFLIGHT-ANYL-MERCURYG4"
#define HW_MCU "STM32G47X"

//Defines from betaflight. Note: madflight will pick the last sensor defined here, this might not be the sensor that is actually on the board. Comment the offending sensors out.
#define IMU_USE  IMU_USE_SPI_ICM42688P
#define BARO_USE  BARO_USE_DPS310
#define BB_USE  BB_USE_FLASH
#define BB_FLASH_TYPE  "M25P16"
#define USE_GPS

//Sensor specific setup
#define IMU_ALIGN  IMU_ALIGN_CW90
#define BARO_I2C_ADR  119
#define MAG_I2C_ADR  0

//LED:
#define HW_PIN_LED       -1
#define HW_LED_ON        1 //0:low is on, 1:high is on

//IMU SPI: (SPI1)
#define HW_PIN_SPI_MISO  PA6
#define HW_PIN_SPI_MOSI  PA7
#define HW_PIN_SPI_SCLK  PA5
#define HW_PIN_IMU_CS    PB12
#define HW_PIN_IMU_EXTI  PC13

//BARO/MAG I2C: (I2C2)
#define HW_PIN_I2C_SDA   PA9
#define HW_PIN_I2C_SCL   PA8

//Outputs:
#define HW_OUT_COUNT     4
#define HW_PIN_OUT_LIST  {PC6,PA4,PB0,PB1}

//RC Receiver: (SERIAL1)
#define HW_PIN_RCIN_RX   PB7
#define HW_PIN_RCIN_TX   PB6
#define HW_PIN_RCIN_INVERTER  -1

//GPS: (SERIAL2)
#define HW_PIN_GPS_RX    PB4
#define HW_PIN_GPS_TX    PB3
#define HW_PIN_GPS_INVERTER  -1

//Battery ADC voltage and current inputs:
#define HW_PIN_BAT_V     PA1
#define HW_PIN_BAT_I     PB2

//-------------------------------------

//Serial
#define HW_SERIAL_COUNT 5
#define HW_PIN_SERIAL { {1,PB6,PB7,-1}, {2,PB3,PB4,-1}, {3,PB10,PB11,-1}, {4,PC10,PC11,-1}, {9,PA2,PA3,-1} } // {INDEX,TX,RX,INVERTER}

//SPI
#define HW_SPI_COUNT 2
#define HW_PIN_SPI { {1,PA5,PA6,PA7}, {2,PB13,PB14,PB15} } // {INDEX,SCK,MISO,MOSI}

//I2C
#define HW_I2C_COUNT 2
#define HW_PIN_I2C { {1,PA15,PB9}, {2,PA9,PA8} } // {INDEX,SCL,SDA}

//other pins
#define HW_PIN_GYRO_EXTI PC13
#define HW_PIN_GYRO_CS PB12
#define HW_PIN_FLASH_CS PA0
#define HW_PIN_ADC_BATT PA1
#define HW_PIN_ADC_CURR PB2
#define HW_PIN_BEEPER PA10

//set statements
#define HW_SET_GYRO_1_BUSTYPE SPI
#define HW_SET_GYRO_1_SPIBUS 1
#define HW_SET_GYRO_1_SENSOR_ALIGN CW90
#define HW_SET_BARO_HARDWARE DPS310
#define HW_SET_BARO_BUSTYPE I2C
#define HW_SET_BARO_I2C_DEVICE 2
#define HW_SET_BARO_I2C_ADDRESS 119
#define HW_SET_I2C2_CLOCKSPEED_KHZ 400
#define HW_SET_I2C2_PULLUP ON
#define HW_SET_MCO_ON_PA8 OFF
#define HW_SET_BLACKBOX_DEVICE SPIFLASH
#define HW_SET_FLASH_SPI_BUS 2
#define HW_SET_ADC_DEVICE 2
#define HW_SET_CURRENT_METER ADC
#define HW_SET_BATTERY_METER ADC
#define HW_SET_VBAT_SCALE 118
#define HW_SET_VBAT_DIVIDER 5
#define HW_SET_VBAT_MULTIPLIER 2
#define HW_SET_SERIALRX_PROVIDER CRSF
#define HW_SET_RSSI_CHANNEL 15
#define HW_SET_SYSTEM_HSE_MHZ 16
#define HW_SET_PID_PROCESS_DENOM 2


/*
#==============================================================================
# BetaFlight Source file
#==============================================================================
# Betaflight / STM32G47X (SG47) 4.4.0 Feb 25 2023 / 03:35:00 (8d4f005) MSP API: 1.44

#define USE_GYRO
#define USE_GYRO_SPI_ICM42688P
#define USE_ACC
#define USE_ACC_SPI_ICM42688P
#define USE_BARO
#define USE_BARO_DPS310
#define USE_FLASH
#define USE_FLASH_M25P16
#define USE_GPS
//TODO#define SYSTEM_HSE_MHZ 16

board_name MERCURYG4
manufacturer_id ANYL


# IMU
resource GYRO_EXTI 1 C13
resource GYRO_CS 1 B12
set gyro_1_bustype = SPI
set gyro_1_spibus = 1
set gyro_1_sensor_align = CW90


# Barometer
set baro_hardware = DPS310
set baro_bustype = I2C
set baro_i2c_device = 2
set baro_i2c_address = 119  # 0x77
set i2c2_clockspeed_khz = 400
set i2c2_pullup = ON  # No hardware PUs are present.
set mco_on_pa8 = OFF


# Flash
resource FLASH_CS 1 A00
set blackbox_device = SPIFLASH
set flash_spi_bus = 2


# SPI
# SPI 1: IMU
resource SPI_SCK 1 A05
resource SPI_MISO 1 A06
resource SPI_MOSI 1 A07

# SPI 2: Blackbox flash 
resource SPI_SCK 2 B13
resource SPI_MISO 2 B14
resource SPI_MOSI 2 B15


# I2C
resource I2C_SCL 1 A15
resource I2C_SDA 1 B09

# I2c 2: Barometer
resource I2C_SCL 2 A09
resource I2C_SDA 2 A08


# UART
resource SERIAL_TX 1 B06
resource SERIAL_RX 1 B07

# UART 2: ELRS receiver
resource SERIAL_TX 2 B03
resource SERIAL_RX 2 B04

resource SERIAL_TX 3 B10
resource SERIAL_RX 3 B11

# UART 4: OSD
resource SERIAL_TX 4 C10
resource SERIAL_RX 4 C11

# LPUART 1:
resource SERIAL_TX 9 A02
resource SERIAL_RX 9 A03


# ADC
resource ADC_BATT 1 A01 # ADC2 In 2
resource ADC_CURR 1 B02 # ADC2 In 12
set adc_device = 2

set current_meter = ADC
set battery_meter = ADC
set vbat_scale = 118
set vbat_divider = 5
set vbat_multiplier = 2


# Motors and timer pins for burst DMA DSHOT
timer C06 AF2    # Tim3 ch1
timer A04 AF2    # Tim3 ch2
timer B00 AF2    # Tim3 ch3
timer B01 AF2    # Tim3 ch4

resource MOTOR 1 C06
resource MOTOR 2 A04
resource MOTOR 3 B00
resource MOTOR 4 B01

timer A10 AF10  # Beeper: Tim2 ch4
resource BEEPER 1 A10


# Control Rx
set serialrx_provider = CRSF
# For RSSI on the OSD, use AUX11/ch15 for Link Quality Indictaor, or AUX12/ch16 for RSSI dBm
set rssi_channel = 15


# DMA
# Assign DMA channels explicitly. Leaving the default assignments triggers
# system failures indicated by the attitude indication responding strangely
# on the `Setup` page.

# We don't use ADC 1 directly, but it is mandatory to assign it, since
# the MCU's temperature sensor, and VDDA measurement are on ADC1.
dma ADC 1 6
dma ADC 2 7
dma SPI_MOSI 1 8
dma SPI_MISO 1 9
dma SPI_MOSI 2 10
dma SPI_MISO 2 11


# Features
feature TELEMETRY
feature OSD
feature RX_SERIAL  # For the built-en ELRS receiver, via CRSF.


# Configure UART4 for digital (MSP Displayport) OSD.
serial 3 1 115200 57600 0 115200
# Configure UART2 for the built-in ELRS receiver, via CRSF.
serial 1 64 115200 57600 0 115200


# Master
set system_hse_mhz = 16
# 4kHz PID loop frequency.
set pid_process_denom = 2

*/
