/*==============================================================================
Generated on: 2024-10-23 18:06:28.951881
Generated by: betaflight_target_converter.py
Source: https://github.com/betaflight/unified-targets
Board name: NOX
Manufacturer ID: AIRB

//copy this line to madflight.ino to use this flight controller (or copy/paste the whole file)
#include <madflight_board_betaflight_AIRB-NOX.h>
==============================================================================*/

#define HW_BOARD_NAME "BETAFLIGHT-AIRB-NOX"
#define HW_MCU "STM32F411"

//Defines from betaflight. Note: madflight will pick the last sensor defined here, this might not be the sensor that is actually on the board. Comment the offending sensors out.
#define IMU_USE  IMU_USE_SPI_MPU6000
#define IMU_USE  IMU_USE_SPI_MPU6500
#define BARO_USE  BARO_USE_SPI_BMP280
#define BB_USE  BB_USE_FLASH
#define BB_FLASH_TYPE  "M25P16"
#define OSD_USE  OSD_USE_MAX7456

//Sensor specific setup
#define IMU_ALIGN  IMU_ALIGN_CW0
#define BARO_I2C_ADR  0
#define MAG_I2C_ADR  0

//LED:
#define HW_PIN_LED       PA4
#define HW_LED_ON        1 //0:low is on, 1:high is on

//IMU SPI: (SPI2)
#define HW_PIN_SPI_MISO  PB14
#define HW_PIN_SPI_MOSI  PB15
#define HW_PIN_SPI_SCLK  PB13
#define HW_PIN_IMU_CS    PB12
#define HW_PIN_IMU_EXTI  PNONE

//BARO/MAG I2C: (I2C1)
#define HW_PIN_I2C_SDA   -1
#define HW_PIN_I2C_SCL   -1

//Outputs:
#define HW_OUT_COUNT     4
#define HW_PIN_OUT_LIST  {PA1,PA7,PB8,PB1}

//RC Receiver: (SERIAL1)
#define HW_PIN_RCIN_RX   PB7
#define HW_PIN_RCIN_TX   PB6
#define HW_PIN_RCIN_INVERTER  -1

//GPS: (SERIAL2)
#define HW_PIN_GPS_RX    PA3
#define HW_PIN_GPS_TX    PA2
#define HW_PIN_GPS_INVERTER  PC14

//Battery ADC voltage and current inputs:
#define HW_PIN_BAT_V     PA5
#define HW_PIN_BAT_I     -1

//-------------------------------------

//Serial
#define HW_SERIAL_COUNT 2
#define HW_PIN_SERIAL { {1,PB6,PB7,-1}, {2,PA2,PA3,PC14} } // {INDEX,TX,RX,INVERTER}

//SPI
#define HW_SPI_COUNT 2
#define HW_PIN_SPI { {1,PB3,PB4,PB5}, {2,PB13,PB14,PB15} } // {INDEX,SCK,MISO,MOSI}

//I2C
#define HW_I2C_COUNT 0
#define HW_PIN_I2C {  } // {INDEX,SCL,SDA}

//other pins
#define HW_PIN_BEEPER PC13
#define HW_PIN_PPM PB10
#define HW_PIN_LED_STRIP PA0
//#define HW_PIN_LED PA4
#define HW_PIN_ESCSERIAL PB10
#define HW_PIN_ADC_BATT PA5
#define HW_PIN_BARO_CS PA9
#define HW_PIN_FLASH_CS PA15
#define HW_PIN_OSD_CS PA10
#define HW_PIN_GYRO_EXTI PNONE
#define HW_PIN_GYRO_CS PB12

//set statements
#define HW_SET_BARO_SPI_DEVICE 2
#define HW_SET_SERIALRX_PROVIDER SBUS
#define HW_SET_BLACKBOX_DEVICE SPIFLASH
#define HW_SET_MIN_THROTTLE 1070
#define HW_SET_USE_UNSYNCED_PWM OFF
#define HW_SET_MOTOR_PWM_PROTOCOL ONESHOT125
#define HW_SET_MOTOR_PWM_RATE 480
#define HW_SET_CURRENT_METER ESC
#define HW_SET_BATTERY_METER ESC
#define HW_SET_BEEPER_INVERSION ON
#define HW_SET_BEEPER_OD OFF
#define HW_SET_SYSTEM_HSE_MHZ 8
#define HW_SET_MAX7456_SPI_BUS 2
#define HW_SET_FLASH_SPI_BUS 1
#define HW_SET_GYRO_1_BUSTYPE SPI
#define HW_SET_GYRO_1_SPIBUS 2


/*
#==============================================================================
# BetaFlight Source file
#==============================================================================
# Betaflight / STM32F411 (S411) 4.1.0 Oct 16 2019 / 11:57:34 (c37a7c91a) MSP API: 1.42

#define USE_GYRO
#define USE_GYRO_SPI_MPU6000
#define USE_GYRO_SPI_MPU6500
#define USE_ACC
#define USE_ACC_SPI_MPU6000
#define USE_ACC_SPI_MPU6500
#define USE_BARO
#define USE_BARO_SPI_BMP280
#define USE_FLASH
#define USE_FLASH_M25P16
#define USE_MAX7456

board_name NOX
manufacturer_id AIRB

# resources
resource BEEPER 1 C13
resource MOTOR 1 A01
resource MOTOR 2 A07
resource MOTOR 3 B08
resource MOTOR 4 B01
resource PPM 1 B10
resource LED_STRIP 1 A00
resource SERIAL_TX 1 B06
resource SERIAL_TX 2 A02
resource SERIAL_RX 1 B07
resource SERIAL_RX 2 A03
resource INVERTER 2 C14
resource LED 1 A04
resource SPI_SCK 1 B03
resource SPI_SCK 2 B13
resource SPI_MISO 1 B04
resource SPI_MISO 2 B14
resource SPI_MOSI 1 B05
resource SPI_MOSI 2 B15
resource ESCSERIAL 1 B10
resource ADC_BATT 1 A05
resource BARO_CS 1 A09
resource FLASH_CS 1 A15
resource OSD_CS 1 A10
# Disabling GYRO_EXTI since gyro and OSD are on same SPI bus
# resource GYRO_EXTI 1 A08
resource GYRO_EXTI 1 NONE
resource GYRO_CS 1 B12

# timer
timer B10 AF1
# pin B10: TIM2 CH3 (AF1)
timer A01 AF2
# pin A01: TIM5 CH2 (AF2)
timer A07 AF1
# pin A07: TIM1 CH1N (AF1)
timer B08 AF2
# pin B08: TIM4 CH3 (AF2)
timer B01 AF2
# pin B01: TIM3 CH4 (AF2)
timer A00 AF1
# pin A00: TIM2 CH1 (AF1)
timer A02 AF3
# pin A02: TIM9 CH1 (AF3)
timer A03 AF3
# pin A03: TIM9 CH2 (AF3)

# dma
dma ADC 1 1
# ADC 1: DMA2 Stream 4 Channel 0
dma pin B10 0
# pin B10: DMA1 Stream 1 Channel 3
dma pin A01 0
# pin A01: DMA1 Stream 4 Channel 6
dma pin A07 0
# pin A07: DMA2 Stream 6 Channel 0
dma pin B08 0
# pin B08: DMA1 Stream 7 Channel 2
dma pin B01 0
# pin B01: DMA1 Stream 2 Channel 5
dma pin A00 0
# pin A00: DMA1 Stream 5 Channel 3

# feature
feature RX_SERIAL
feature OSD
feature SOFTSERIAL
feature ESC_SENSOR

# serial
serial 0 2048 115200 57600 0 115200
serial 1 64 115200 57600 0 115200

# master
set baro_spi_device = 2
set serialrx_provider = SBUS
set blackbox_device = SPIFLASH
set min_throttle = 1070
set use_unsynced_pwm = OFF
set motor_pwm_protocol = ONESHOT125
set motor_pwm_rate = 480
set current_meter = ESC
set battery_meter = ESC
set beeper_inversion = ON
set beeper_od = OFF
set system_hse_mhz = 8
set max7456_spi_bus = 2
set flash_spi_bus = 1
set gyro_1_bustype = SPI
set gyro_1_spibus = 2

*/
