// Talkie library
// Copyright 2011 Peter Knight
// This code is released under GPLv2 license.
//
// Armin Joachimsmeyer 11/2018 converted to .c and .h files and made them unique.
//
// The following phrases are derived from those built into the
// Acorn Computers Speech Synthesizer add-on from 1983.
//
// A male voice with an RP English accent, voiced by Kenneth Kendall.
//

#pragma once 

// moved to Vocab_Special
//static  const uint8_t spa_PAUSE1[]    = {0x08,0x14,0xC1,0xDD,0x45,0x64,0x03,0x00,0xFC,0x4A,0x56,0x26,0x3A,0x06,0x0A};
//static  const uint8_t spa_PAUSE2[]    = {0x08,0x14,0xC1,0xDD,0x45,0x64,0x03,0x00,0x00,0x00,0xC0,0xFF,0x4A,0x46,0x51,0x39,0x79,0x15,0x0A};

static  const uint8_t spa_TONE1[]     = {0x8D,0xF2,0xDE,0xDD,0xDD,0x93,0x74,0xAA,0x53,0x9D,0xEA,0x54,0xA7,0x3A,0xD5,0xA9,0x4E,0x75,0xAA,0x53,0x9D,0xEA,0x54,0xA7,0x3A,0xD5,0xA9,0x4E,0x75,0xAA,0x53,0x9D,0xEA,0x54,0xA7,0x3A,0xD5,0xA9,0x4E,0x75,0xAA,0x53,0x9D,0xEA,0x54,0xA7,0x3A,0xD5,0xA9,0x4E,0x75,0xAA,0x53,0x9D,0xFA,0x4A,0x26,0x51,0x39,0x79,0x15,0x0A};
static  const uint8_t spa_TONE2[]     = {0x4D,0xF1,0xDE,0xDD,0xDD,0x93,0x74,0xA5,0x2B,0x5D,0xE9,0x4A,0x57,0xBA,0xD2,0x95,0xAE,0x74,0xA5,0x2B,0x5D,0xE9,0x4A,0x57,0xBA,0xD2,0x95,0xAE,0x74,0xA5,0x2B,0x5D,0xE9,0x4A,0x57,0xBA,0xD2,0x95,0xAE,0x74,0xA5,0x2B,0x5D,0xE9,0x4A,0x57,0xBA,0xD2,0x95,0xAE,0x74,0xA5,0x2B,0x5D,0xF9,0x11,0x5A};
static  const uint8_t spa__D[]        = {0x64,0x14,0xCA,0xDD,0x45,0x64,0x83,0xEB,0xB7,0x71,0x17,0x53,0x37,0xA9,0x6F,0x5E,0xDC,0xCD,0x6D,0xFF,0x11,0x51,0x5A};
static  const uint8_t spa__ED[]       = {0x69,0x2C,0x8E,0xCA,0x33,0x16,0xB9,0xA9,0x58,0xAA,0xC8,0x6A,0x28,0x96,0x2C,0x45,0xC3,0xB3,0x31,0x99,0x84,0x72,0x77,0x11,0xD9,0xE0,0xA6,0x6D,0xDC,0xC5,0xD4,0x4D,0x1A,0x9A,0x17,0x77,0x73,0xDB,0xFF,0x71,0x39,0x49,0x5A};
static  const uint8_t spa__ING[]      = {0x2B,0x99,0xCE,0xD1,0x7D,0x22,0x8F,0x7A,0x78,0x25,0xCF,0xA9,0x3C,0xBA,0x15,0x1A,0xA5,0xAA,0x52,0x1A,0x66,0x12,0xE8,0xAE,0xD0,0x7A,0x52,0x63,0x56,0x5C,0x4E,0x9E,0x45,0x0D,0x51,0x59,0xA9,0x46,0x66,0x3B,0xB8,0xBE,0x38,0x97,0x10,0xB3,0xE3,0x07,0x04,0x38,0xA3,0xFA,0x65,0x5A};
static  const uint8_t spa__S[]        = {0x04,0xF8,0xD4,0x5D,0x00,0x8F,0xB9,0x0B,0xE0,0x4B,0x33,0x06,0x7C,0xE6,0xC5,0x80,0xCF,0xD5,0x09,0xF0,0x0D,0x0A,0x02,0xBE,0x12,0x43,0xC0,0x55,0x6C,0xFF,0x39,0x51,0x51,0x15,0x5A};
static  const uint8_t spa__TEEN[]     = {0xA0,0x80,0x25,0x5C,0x14,0x70,0x5C,0x71,0x89,0x87,0x21,0xCA,0x19,0xDB,0x2D,0xE9,0x8E,0xA8,0x77,0xA2,0x8C,0x64,0x06,0x01,0xDF,0xAA,0x3C,0xEB,0xD6,0xAE,0xA4,0x20,0x3B,0xB3,0x4B,0x3F,0x12,0x48,0x5E,0xC5,0x29,0xC3,0x4C,0x48,0x76,0x5D,0xBB,0x0C,0x23,0xA2,0xC4,0x75,0xE4,0x32,0x64,0xAE,0x36,0xAE,0x49,0xC3,0x10,0x84,0xC5,0xB9,0x39,0x71,0x43,0x10,0x96,0xAB,0x96,0x44,0x0D,0x59,0x72,0x96,0x59,0x6A,0x31,0x74,0x19,0xE6,0x66,0xB6,0xFF,0x09,0x15,0x5A};
static  const uint8_t spa__TH[]       = {0x08,0x18,0x22,0x94,0x02,0x02,0xE8,0xDC,0x85,0x00,0x5D,0xB8,0x31,0x20,0x87,0x30,0x04,0x04,0x99,0xFE,0x4D,0x15,0x5A};
static  const uint8_t spa__T[]        = {0x04,0x68,0x24,0xC4,0x01,0x07,0x44,0x1A,0xA0,0x42,0xE3,0xD1,0x0C,0x67,0x68,0x36,0xB5,0x5B,0x3F,0xBC,0x91,0x47,0xCD,0x49,0xD3,0x70,0x4A,0x91,0x35,0x3B,0x2F,0xFF,0x2D,0x5A};
static  const uint8_t spa__Z[]        = {0xA1,0xEB,0x38,0x38,0x3C,0x67,0x9B,0xF6,0x6B,0x12,0x97,0x6C,0x62,0x5B,0x06,0x2C,0x40,0x46,0x80,0x2F,0x58,0x11,0xF0,0x95,0x08,0x02,0xBE,0x31,0x47,0xC0,0x17,0x52,0xFF,0x06};
static  const uint8_t spa_ZERO[]      = {0xA2,0x2B,0x20,0x2D,0xAA,0x1A,0xAA,0xB6,0x81,0xD4,0x88,0x72,0xAC,0x80,0x8F,0xC4,0x34,0x90,0xAA,0x8F,0x44,0xD5,0x43,0x4D,0xCB,0x16,0x33,0x8C,0xB6,0x44,0x23,0x9A,0xDC,0x21,0xA7,0x6B,0xAD,0x60,0x28,0x83,0x9C,0x9E,0x75,0x82,0x69,0x12,0x74,0xB2,0xD1,0xF1,0x87,0x74,0xAA,0x89,0x46,0x27,0x18,0x36,0x39,0x5C,0x17,0x9D,0x60,0xA8,0x92,0x34,0x5B,0xB4,0xA2,0xA6,0xCA,0xD2,0x7D,0xD1,0x88,0x73,0xB6,0xF2,0xA8,0x96,0x23,0xCD,0x83,0x4D,0x23,0x5D,0xB7,0x2C,0x0F,0x74,0xF3,0xC8,0xDC,0x8A,0x5C,0xA9,0xA4,0x3B,0x55,0xAB,0x73,0xE5,0xE2,0x3A,0xD7,0x6D,0x2C,0x49,0x8B,0x3D,0x6F,0x95,0xB1,0x78,0x4D,0xD7,0x78,0x94,0xA6,0x64,0xC3,0x33,0xE2,0x52,0x9A,0x92,0x8D,0x08,0xF3,0x4B,0x61,0x4A,0x31,0xDC,0xB8,0x26,0xBB,0x25,0x05,0x77,0x95,0x7A,0xF4,0x06,0x06};
static  const uint8_t spa_HUNDRED[]   = {0xA2,0x6D,0x76,0xD2,0x5D,0x1B,0xE9,0x62,0xFB,0xD7,0x3F,0x7E,0xB7,0x69,0x05,0x9E,0x7A,0x04,0x95,0xBB,0xAC,0x64,0xE2,0x11,0x35,0x9C,0x7C,0xE2,0x49,0x4A,0x1C,0xA5,0xC5,0x52,0xB9,0x0E,0x89,0xD5,0x56,0xA1,0x63,0x4B,0x16,0xA1,0x2D,0x21,0xCD,0x84,0x23,0x85,0xB6,0xD7,0x11,0x75,0x93,0xDD,0xDA,0x52,0x38,0xC9,0xAA,0x75,0xEB,0xB3,0xA3,0xF2,0xC8,0xC6,0xA5,0x2F,0x8E,0xCA,0x33,0x16,0x85,0xB1,0x58,0xAA,0xC8,0x6A,0x28,0xA6,0x2C,0x45,0xC3,0xB3,0x31,0x99,0x84,0x72,0x77,0x11,0xD9,0x60,0xA6,0x6D,0xDC,0xC5,0xD4,0xCD,0xFF,0x06,0x06,0x06};
static  const uint8_t spa_THOUSAND[]  = {0x08,0x68,0x2A,0x14,0x03,0x04,0xE8,0x32,0x9C,0x00,0xD5,0x46,0x2C,0x3F,0xE5,0x08,0xD1,0xAA,0x7C,0xFC,0xDC,0xAB,0x5C,0xAA,0xC8,0xF1,0x4B,0xAC,0x6E,0xD5,0xC9,0xC7,0xAB,0x7E,0x2A,0x4D,0x67,0x1D,0xBF,0x86,0xCD,0x54,0x9D,0x75,0x82,0xEA,0x2F,0xD2,0x68,0xE5,0x8A,0x4A,0x1C,0x37,0xA1,0x97,0x2D,0x8A,0xCE,0xC3,0x35,0x5E,0xB6,0x24,0x29,0xA9,0xF0,0x5C,0x15,0xDA,0xCB,0x28,0xD5,0xBC,0x5D,0xE8,0x9F,0xA0,0x50,0x55,0xE5,0x71,0x68,0xDD,0xE2,0x15,0x2C,0x92,0xA5,0xB4,0x25,0x84,0x2A,0xD7,0xE5,0xD2,0x17,0x1B,0x6E,0x1C,0x9B,0xD2,0x98,0xA4,0x59,0x53,0xB6,0x0E,0x53,0x36,0xE2,0x41,0x9E,0x39,0x4C,0x59,0x99,0x39,0x5B,0x6E,0x33,0x16,0x21,0x5A,0x16,0x5A,0xCC,0x98,0xB8,0x59,0x9B,0xA7,0x46,0xA0,0x50,0xEE,0x2E,0x22,0x1B,0xDC,0xB4,0x8D,0xBB,0x98,0xBA,0x49,0x43,0xF3,0xE2,0x6E,0x6E,0xFB,0xFF,0x46};
static  const uint8_t spa_ONE[]       = {0xA6,0x90,0x76,0xCC,0x43,0x6B,0xB9,0x42,0xD8,0x35,0x77,0xA9,0x19,0x72,0xE5,0x46,0xD2,0x62,0x56,0xCB,0xAC,0x9F,0x68,0xE1,0x4E,0x23,0x09,0x71,0x23,0x55,0x3A,0x9E,0xB8,0xC4,0x4B,0x77,0x6D,0x74,0xE3,0x93,0x54,0x7B,0xE5,0x6E,0x2D,0x4F,0xD6,0xEC,0x56,0x84,0xB5,0x3A,0x45,0x0D,0x5D,0xA1,0xD6,0xA8,0xF4,0xC5,0x58,0x84,0x78,0xEC,0x34,0x64,0x6D,0x16,0xEA,0x8D,0xC2,0x90,0x95,0x66,0xB1,0x25,0x0E,0x43,0x92,0x1A,0x43,0x9E,0x26,0x0C,0x49,0x49,0xB4,0x78,0xEA,0x34,0x16,0x1B,0xA6,0xEA,0xB1,0xC9,0x24,0x82,0xBB,0x88,0xC8,0x06,0x00,0xF8,0x26};
static  const uint8_t spa_TWO[]       = {0x0E,0x58,0x56,0xCB,0x00,0xD7,0xAB,0x19,0xE0,0x38,0xCB,0xE6,0x0C,0x65,0x8A,0x61,0xAD,0x86,0x9D,0xA5,0x79,0xA4,0x2D,0x1E,0x6E,0x61,0x69,0x9A,0xF6,0x79,0x04,0x85,0xA4,0x6B,0xC8,0xEF,0x16,0x17,0x94,0xA1,0xC1,0xBB,0x5B,0x5E,0x61,0x86,0x05,0x7E,0x0A,0xA5,0x0A,0x25,0xA6,0x75,0x3A,0x34,0x8E,0x5F,0xA8,0xEB,0x4B,0xD7,0x49,0xBB,0xE6,0x12,0x8F,0xDD,0xE0,0xC5,0x78,0xB2,0xBC,0x36,0x83,0x15,0xEB,0x2E,0xF2,0x48,0x0D,0x46,0x9E,0x89,0xE9,0x2B,0x31,0xC8,0x32,0x2C,0x9E,0xAB,0xFF,0x5A,0x26};
static  const uint8_t spa_TWEN_[]     = {0x01,0x98,0xC1,0xC2,0x00,0xCD,0x4E,0x28,0xA0,0xCC,0x8A,0xE2,0xC7,0xA2,0x6E,0x16,0x8D,0x8E,0x57,0xBC,0x4B,0xBA,0xAF,0x3E,0x7E,0x0F,0x45,0xE1,0xDA,0xF9,0x04,0xD3,0x35,0x85,0x7A,0xAB,0x13,0x75,0xE5,0xD4,0x16,0x89,0x46,0xDC,0x94,0xD0,0x51,0xD9,0x4D,0x69,0x56,0x1C,0xC5,0xA9,0x8C,0xD4,0x42,0xB9,0xBB,0x88,0x6C,0x80,0xFF,0x66};
static  const uint8_t spa_THREE[]     = {0x08,0xA8,0xC2,0x8C,0x02,0x04,0x68,0x2A,0xDC,0xF9,0x51,0x5B,0x96,0x79,0x8D,0x10,0xE5,0xCA,0x2E,0x9A,0x76,0x72,0xD0,0xC2,0x5C,0x25,0x21,0x23,0xCD,0x0C,0x4F,0xD4,0x22,0x7A,0x46,0x34,0x3E,0xF1,0x48,0x86,0xD2,0xB1,0xEA,0x24,0x33,0x16,0x62,0xE7,0xAA,0x55,0xAC,0xD4,0x04,0xD5,0x8D,0x47,0xB3,0x53,0x33,0xE4,0x2C,0x69,0xED,0x4E,0x81,0x30,0x53,0xA7,0xF5,0xBB,0x14,0x43,0xF4,0x92,0x36,0xEC,0x92,0x04,0xD5,0x4B,0xD2,0xB8,0xAB,0x23,0xF4,0x34,0xCE,0x63,0x19,0x57,0x73,0x84,0xAE,0x26,0x69,0x9C,0x8D,0xC0,0xAB,0x6B,0x87,0xB1,0x7B,0x94,0x99,0x8A,0xF2,0x5A,0x66};
static  const uint8_t spa_THIR_[]     = {0x08,0xC8,0x22,0x19,0x01,0x4D,0x05,0x0B,0xA0,0x73,0x17,0x03,0x74,0xE1,0x96,0x9C,0x69,0x92,0x4B,0xCC,0xF1,0x08,0xA3,0x77,0x1E,0xAF,0xB2,0xC7,0x2F,0xD6,0xB4,0x2C,0x2F,0x1F,0xBF,0x9B,0xE0,0x0C,0x79,0x7C,0x82,0x6E,0x92,0x3D,0x64,0xF5,0x09,0x7B,0x70,0x09,0xD3,0x39,0x27,0xAA,0x8E,0x23,0xBD,0xAA,0xA6,0xB4,0x39,0x56,0xD3,0xAC,0x85,0x40,0xA1,0xDC,0x5D,0x44,0x36,0xFC,0x16};
static  const uint8_t spa_FOUR[]      = {0x08,0xA8,0xCA,0x94,0x00,0x5D,0x84,0x31,0x20,0xA9,0x0A,0x05,0x54,0x1D,0x16,0xBC,0xAA,0xDC,0xC3,0xC4,0xCE,0x0A,0x92,0xDA,0x94,0xA0,0x4D,0xC7,0x4F,0x7C,0xDA,0x0B,0x73,0x9F,0x20,0xAA,0x2D,0x73,0xCE,0x75,0x92,0x28,0xB7,0x23,0xD9,0xF7,0xCA,0x82,0xB9,0x16,0xD3,0x5C,0xA3,0x88,0x7A,0x2A,0x83,0x72,0x8D,0x2E,0xEA,0xED,0x08,0xCC,0xD3,0x86,0x68,0xB6,0xCD,0x29,0x77,0x19,0xA3,0xDE,0xD6,0xA0,0xDE,0x65,0x0C,0x66,0x5B,0x82,0x73,0x97,0x31,0xD8,0x2D,0x0B,0xEA,0x53,0xC6,0x10,0xB6,0x24,0xB8,0x77,0x99,0x42,0x98,0x4C,0xE5,0xDC,0x6E,0x0A,0xA3,0x4C,0xC3,0x17,0xFE,0x5A,0x16};
static  const uint8_t spa_FOUR_[]     = {0x08,0xA8,0xCA,0x94,0x00,0x5D,0x84,0x31,0x20,0xA9,0x0A,0x05,0x54,0x1D,0x16,0xBC,0xAA,0xDC,0xC3,0xC4,0xCE,0x0A,0x92,0xDA,0x94,0xA0,0x4D,0xC7,0x4F,0x7C,0xDA,0x0B,0x73,0x9F,0x20,0xAA,0x2D,0x73,0xCE,0xB5,0x92,0x60,0xAE,0xC5,0x34,0xD7,0xC8,0xA2,0x9E,0xCA,0xA0,0x5C,0x2D,0x8B,0x66,0xDB,0x9C,0x72,0xA7,0x22,0x98,0x6D,0x09,0xCE,0x6D,0x8A,0x30,0xCA,0x34,0x7C,0xE1,0xFF,0x56};
static  const uint8_t spa_FIVE[]      = {0x08,0xE8,0xD2,0x15,0x03,0x02,0xA8,0x3A,0x5D,0x01,0x55,0x96,0x0E,0x3F,0xA5,0x70,0xE7,0x98,0xBD,0x82,0xDC,0xDB,0x5D,0xAD,0xD6,0x0A,0x4A,0xF8,0x70,0xF5,0x86,0x27,0x2E,0xFE,0xD3,0xC5,0x6B,0x9D,0xB4,0xE9,0xAB,0x94,0x68,0x78,0xAA,0xEA,0x2F,0xC3,0xA3,0xF1,0xE9,0x6A,0xD8,0x88,0xF0,0xD9,0xA7,0x6F,0x61,0xA2,0xDC,0x66,0xAF,0xBE,0x85,0xB6,0x34,0x9B,0xB5,0xFA,0xEE,0x5D,0xD2,0x73,0xCE,0xEA,0xBB,0x33,0x8A,0xAC,0x3A,0x63,0xE8,0x56,0x29,0xAB,0xAB,0x94,0xBE,0x67,0x45,0xCB,0x9E,0x5D,0xFA,0xE6,0x04,0xB3,0x72,0x76,0xEA,0x8A,0x26,0x6F,0xCF,0x29,0xA9,0x4D,0xCA,0x34,0x3D,0x6A,0xC7,0xC1,0x0F,0xFF,0x5A,0x56};
static  const uint8_t spa_FIF_[]      = {0x08,0x28,0xD4,0x14,0x03,0x06,0x68,0x2A,0x74,0x79,0xCD,0x30,0x75,0xFB,0xE4,0x13,0x4C,0x1D,0xC8,0x13,0xAB,0x4E,0xD0,0x9D,0x62,0x94,0x4F,0x29,0x51,0x53,0x4A,0x9E,0x3E,0x59,0x00,0x4D,0x98,0x28,0x60,0x99,0x54,0x0D,0x20,0x50,0x28,0x77,0x17,0x91,0x0D,0xF0,0x36};
static  const uint8_t spa_SIX[]       = {0x04,0xF8,0x82,0x8D,0x03,0x0A,0xF8,0xCA,0xDC,0x01,0x5F,0x79,0x28,0xE0,0xEB,0x30,0x05,0x7C,0xED,0xBE,0xBC,0xAD,0x8A,0x34,0x62,0xD5,0x0D,0x4E,0xB4,0xDC,0x12,0x87,0x77,0x1A,0xD5,0x28,0x09,0x1E,0xBE,0x24,0x36,0xA8,0x15,0xCA,0xDD,0x45,0x64,0x03,0x80,0x01,0xF2,0x54,0x31,0xC0,0x57,0x15,0x02,0xF8,0xCA,0x8C,0x01,0xDF,0x58,0x12,0xE0,0x1B,0x0B,0x04,0x7C,0x2F,0x86,0x80,0xEF,0xD4,0xFE,0x5A,0x36};
static  const uint8_t spa_SIX_[]      = {0x04,0xF8,0x82,0x8D,0x03,0x0A,0xF8,0xCA,0xDC,0x01,0x5F,0x79,0x28,0xE0,0x6B,0xF7,0xE5,0x6D,0x55,0xA4,0x11,0xAB,0x4E,0xB4,0xDC,0x12,0x87,0x77,0x0A,0xCD,0x28,0x09,0x1E,0xBE,0x04,0xB5,0x42,0xB9,0xBB,0x88,0x6C,0x00,0x06,0xE4,0xA9,0x22,0x80,0xAF,0xCC,0x08,0xF0,0x8D,0x25,0x06,0xFE,0x76};
static  const uint8_t spa_SEVEN[]     = {0x08,0xF8,0x5C,0x9D,0x01,0x5F,0x78,0x08,0xE0,0x8B,0x74,0x05,0x7C,0x15,0xAE,0x81,0x61,0x57,0x6B,0x9A,0xDC,0x75,0x8E,0xD7,0x6D,0x48,0x89,0x2F,0x3E,0x41,0x0B,0xED,0x29,0x3A,0xFB,0x44,0xD5,0xA7,0x87,0xDA,0xA2,0x96,0xC4,0x50,0x11,0xCA,0xB5,0x54,0xAD,0x65,0x6A,0x88,0xB8,0x6A,0x6D,0x0E,0x63,0xC6,0xD6,0xB8,0x8D,0xB9,0x46,0x38,0xD9,0xEC,0x34,0xE5,0xAC,0x45,0xBE,0x75,0xC2,0x94,0x84,0x78,0xBB,0x37,0xB6,0x93,0x9E,0xC8,0x24,0x82,0xBB,0x88,0xC8,0x06,0x00,0x80,0xFF,0x5A,0x76};
static  const uint8_t spa_SEVEN_[]    = {0x08,0xF8,0x5C,0x9D,0x01,0x5F,0x78,0x08,0xE0,0x8B,0x74,0x05,0x7C,0x15,0xAE,0x81,0x61,0x57,0x6B,0x9A,0xDC,0x75,0x4E,0xD0,0x42,0x7B,0x8A,0xCE,0xBE,0x41,0x4B,0x62,0xA8,0x08,0xE5,0x5A,0xAA,0xD6,0x32,0x35,0x44,0x5C,0xB5,0x36,0x87,0x31,0x63,0x6B,0xDC,0xDB,0x34,0xE6,0x1A,0xE1,0x64,0xB3,0xC3,0x94,0xB3,0x16,0xF9,0xD6,0x71,0x53,0x12,0xE2,0xED,0xDE,0xF8,0xFF,0x0E};
static  const uint8_t spa_EIGHT[]     = {0x23,0x1E,0xC5,0x58,0x33,0xA7,0x9E,0xA0,0x6A,0xF1,0xAD,0x9E,0xB2,0xE2,0xEE,0x49,0xAB,0x3A,0xCA,0x2A,0x66,0x72,0x94,0xE9,0xDA,0xBB,0x0A,0xC3,0x30,0x8C,0xB5,0x1D,0x5B,0x4C,0x42,0xB9,0xBB,0x88,0x6C,0x00,0x00,0x01,0x5C,0x91,0x26,0x01,0x04,0x14,0x9F,0xFA,0x5A,0x0E};
static  const uint8_t spa_EIGH_[]     = {0x23,0x1E,0xC5,0x58,0x33,0xA7,0x9E,0xA0,0x6A,0xF1,0xAD,0x9E,0xB2,0xE2,0xEE,0x49,0xAB,0x3A,0xCA,0x2A,0x66,0x72,0x94,0xE9,0xDA,0xBB,0x0A,0xC3,0x30,0x8C,0xB5,0x1D,0x5B,0x4C,0x42,0xB9,0xBB,0x88,0x6C,0x00,0x80,0xFF,0x4E};
static  const uint8_t spa_NINE[]      = {0xA1,0x4A,0x4C,0xF4,0x31,0xDD,0x85,0x32,0x71,0xB6,0xC7,0x74,0x97,0x8A,0xCC,0x54,0x1F,0xCB,0x5D,0xC9,0x33,0x35,0x7D,0xCC,0xE4,0x2D,0x6B,0x20,0xF9,0x58,0xEB,0x9F,0xA4,0xCB,0x56,0x13,0x6F,0x74,0xE2,0xAE,0x37,0x5C,0x3D,0xD1,0x89,0x9B,0xBD,0x74,0xF1,0x44,0x27,0x69,0xE6,0xDA,0xD5,0x13,0x9D,0xB4,0xAB,0x9B,0x10,0x4F,0x74,0xF2,0x29,0x67,0xC2,0x3C,0xE5,0x29,0xA7,0xE9,0xAA,0x90,0x54,0xA7,0x9A,0xBE,0x3D,0x52,0x5A,0x9D,0x66,0xC5,0x51,0x49,0x6B,0x74,0xDA,0x95,0x46,0x30,0xA2,0xD1,0xE8,0x66,0x2E,0xE4,0xCA,0xCA,0x6D,0x58,0x21,0x89,0x3A,0x23,0x87,0x21,0x73,0xB5,0x71,0x4D,0x6A,0x86,0x20,0x2C,0xCE,0xCD,0x89,0x1A,0x82,0xB0,0x5C,0xB5,0x24,0x6A,0x08,0x22,0x2A,0x2D,0x3D,0xAB,0x3E,0x4A,0xAD,0x34,0xF3,0xF5,0x5A,0x4E};
static  const uint8_t spa_NINE_[]     = {0xA1,0x4A,0x4C,0xF4,0x31,0xDD,0x85,0x32,0x71,0xB6,0xC7,0x74,0x57,0xF2,0x4C,0x4D,0x1F,0x33,0x79,0xCB,0x1A,0x48,0x3E,0xD6,0xFA,0x27,0xE9,0xB2,0xD5,0xC4,0x1B,0x9D,0xB8,0xD9,0x4B,0x17,0x4F,0x74,0xD2,0xAE,0x6E,0x42,0x3C,0xD1,0x29,0xA7,0xE9,0xAA,0x90,0x54,0xA7,0x9A,0xBE,0x3D,0x52,0x5A,0x9D,0x66,0xC5,0x51,0x49,0x6B,0x74,0xDA,0x95,0x46,0x30,0xA2,0xD1,0xE8,0x66,0x2E,0xE4,0xCA,0xCA,0x6D,0x58,0x21,0x89,0x3A,0x23,0x87,0x21,0x73,0xB5,0x71,0x4D,0x6A,0x86,0x20,0x2C,0xCE,0xCD,0xC9,0xFF,0x41};
static  const uint8_t spa_A[]         = {0x27,0x5A,0x3E,0x95,0xDB,0xDB,0x9C,0x68,0xDA,0x26,0x6D,0xAF,0x75,0xA2,0xA5,0x8B,0xBD,0xBD,0xF6,0x89,0x86,0x4F,0xCA,0xF2,0xDA,0x27,0xEA,0xC1,0xB8,0x2A,0xEB,0x9C,0xB8,0x07,0xE5,0xAA,0xAA,0x72,0xD2,0x1E,0x45,0xAA,0xBA,0xCA,0x2A,0x47,0x13,0xF1,0xEA,0x29,0xAB,0x9B,0xD9,0x59,0xA6,0x96,0x8C,0x7E,0x14,0x23,0x99,0x9A,0x3D,0xC6,0x1E,0x98,0x73,0xAB,0x52,0x1B,0x47,0x12,0xF2,0xAE,0xD9,0x75,0x2C,0x63,0x4F,0xC4,0x59,0x53,0xE5,0xFF,0x39,0x25,0x79,0x61,0x41};
static  const uint8_t spa_ACORN[]     = {0x23,0x9B,0x35,0x85,0xD3,0x96,0x9C,0x64,0xD6,0x12,0x0A,0x5F,0x7C,0xA2,0x95,0xD6,0x30,0x6C,0xF1,0x89,0x56,0x18,0x86,0xCC,0x45,0x2B,0x5A,0xA1,0x11,0x2B,0x1B,0xB7,0x68,0x34,0x06,0xCF,0x9E,0x94,0xB2,0x91,0x19,0x32,0xAB,0x96,0x2A,0x84,0x72,0x77,0x11,0xD9,0x00,0x0A,0x08,0x51,0xC9,0x02,0x25,0x8F,0x6D,0x54,0x4D,0x66,0xB6,0x22,0x86,0x09,0x33,0xDA,0xD5,0xDA,0xE8,0x2A,0xD3,0xB0,0x4F,0xEB,0x92,0xA9,0xCA,0xA0,0xBC,0x6D,0x48,0xA6,0x2A,0x83,0xF2,0x95,0x29,0xD9,0xEC,0x34,0xEC,0x9B,0xE6,0x90,0xAA,0x5D,0x78,0x73,0x98,0x63,0xC9,0x74,0xD6,0x57,0x6E,0x8E,0xCB,0x42,0x6C,0x66,0xB9,0x29,0x0D,0x4B,0xE6,0x8E,0x1B,0xC6,0x94,0x2C,0x84,0xA2,0x73,0x98,0xB2,0x71,0x0B,0xF0,0xCC,0x6E,0x4E,0x3A,0xD4,0xD8,0xB3,0xAA,0xB9,0x68,0x33,0x23,0xD5,0xF2,0x25,0x51,0x15,0x31,0x41};
static  const uint8_t spa_AFTER[]     = {0xA5,0xC9,0x76,0xCB,0x1C,0x13,0xAF,0x3A,0xAB,0x1D,0x0B,0xEE,0xBC,0xEA,0xAC,0x6F,0x2C,0x38,0xF3,0xA9,0xB3,0xB9,0xF6,0x90,0xCC,0xA7,0xCA,0xFA,0x3A,0x82,0x33,0x9F,0x2A,0x9B,0xED,0x08,0xCE,0xBC,0xEA,0xEC,0x3B,0xD3,0xB1,0x57,0x69,0xB2,0xCD,0x6C,0xA3,0xD6,0x04,0x68,0xCE,0x44,0x02,0x14,0x40,0xA0,0x08,0xEE,0x22,0x22,0x1B,0x14,0xB0,0x8D,0x7B,0xAB,0x06,0x33,0xB3,0xD2,0x4C,0xA7,0xAA,0xD6,0x3C,0xCD,0x56,0x9D,0xBA,0x3A,0x8D,0x34,0x5D,0x35,0xDA,0xE2,0xB5,0xD2,0xEC,0x55,0x68,0x73,0xF2,0x74,0xF5,0x55,0xFF,0x39,0x49,0x41,0x71,0x41};
static  const uint8_t spa_AGAIN[]     = {0xA9,0x28,0x2E,0x64,0x68,0x26,0xAF,0xB2,0x26,0xF3,0xA4,0xAE,0x73,0x8A,0x1A,0xDC,0x4A,0x62,0xF6,0xC9,0xBA,0x6B,0x2A,0x93,0xC5,0xA9,0x28,0xC2,0x71,0x39,0x26,0xFB,0x2C,0x15,0xDE,0xA8,0x98,0x9B,0x93,0x91,0x4C,0x19,0x90,0x59,0x71,0x56,0x34,0x5C,0x40,0x55,0x55,0x3E,0x61,0x0B,0xC2,0x13,0x1B,0xE5,0x44,0x3D,0x89,0x56,0x74,0xDC,0x13,0x77,0xAF,0x3C,0x31,0x55,0x4E,0x32,0x7C,0x50,0x45,0x2D,0x5E,0xD9,0xF0,0x4E,0x59,0xB5,0x78,0x95,0x23,0x26,0x59,0x65,0xED,0x55,0xF7,0x24,0x94,0x55,0x65,0x47,0x3B,0xA4,0x92,0x5D,0x55,0x99,0x5D,0x1A,0xBA,0x26,0xCD,0xD9,0x4A,0x61,0x2C,0x9C,0x2A,0x33,0x9D,0x84,0x31,0x29,0x4B,0xE7,0xF0,0xEA,0xC6,0x64,0x34,0x9C,0x23,0x4D,0x18,0x8B,0xE4,0xD6,0x50,0x2F,0x61,0x48,0x5A,0xD3,0xC2,0x5D,0xFD,0x15,0x39,0x55,0x79,0x59,0x41};
static  const uint8_t spa_AMOUNT[]    = {0xA3,0x6E,0x6E,0xDC,0x95,0x1A,0x9E,0xB2,0xBA,0xC9,0x30,0x5A,0x74,0x8B,0x55,0xA4,0xE2,0x29,0x94,0x93,0x4B,0x91,0x9C,0x14,0x43,0xB7,0x6B,0x79,0x36,0x52,0x0A,0xD5,0xAD,0xE7,0x25,0x4D,0x46,0x5A,0x21,0xD7,0x9D,0x28,0x87,0x75,0x75,0x59,0x78,0x82,0xE2,0xAE,0x42,0xB5,0xE1,0x09,0xAA,0xBB,0x72,0xB3,0x86,0x27,0xAA,0xEE,0x3A,0xCD,0x6A,0x9D,0xBC,0xB4,0x2E,0xB7,0xAC,0x72,0xCA,0x1A,0x3A,0xD2,0x74,0xCA,0x6A,0x4A,0x2E,0x0F,0xD1,0x59,0xAD,0x2D,0x49,0x5B,0x28,0xBC,0xA4,0xB6,0x47,0xA8,0x14,0x57,0xE7,0x5B,0xD6,0x0B,0xE5,0xEE,0x22,0xB2,0x01,0x40,0x01,0x4B,0x67,0x08,0xE0,0x67,0x4F,0x04,0xB4,0x94,0xFA,0x39,0x41};
static  const uint8_t spa_AN[]        = {0xAB,0x6E,0xA5,0xD4,0xCC,0x27,0x9F,0x72,0xBA,0x75,0x75,0x69,0x75,0xCA,0xE9,0x36,0xD4,0xB9,0xD5,0xA9,0x86,0x5F,0x37,0xE7,0xC5,0xA7,0x1A,0x7E,0xC3,0x9D,0x1A,0x9F,0x6A,0xB8,0x75,0x0F,0x5E,0x74,0xEA,0x61,0xD7,0x3D,0x64,0xD5,0x69,0x86,0x19,0xB7,0xD0,0x55,0xAB,0xE9,0xA6,0x3D,0xC4,0x5A,0x95,0xBA,0xB1,0xC0,0x51,0x9B,0xDA,0xAA,0xAA,0x94,0x96,0x23,0x6E,0xAB,0xB2,0x54,0x59,0x4E,0x27,0xA9,0xAA,0xC6,0x4C,0xCD,0x1D,0xFD,0x11,0x39,0x41};
static  const uint8_t spa_AND[]       = {0x2B,0x98,0x61,0x52,0x43,0x1B,0x9F,0x60,0xF8,0x0D,0x73,0x6B,0x74,0x82,0xE1,0xCF,0xD5,0x3D,0xD6,0x09,0x86,0x3B,0x37,0xF7,0x5A,0x27,0x9C,0x76,0xCC,0xDD,0x6B,0x9D,0x68,0xB8,0xB5,0x70,0x8F,0x75,0xB2,0x1E,0xC6,0xC3,0xBD,0xD6,0xAA,0x6A,0x8B,0x08,0xCF,0x28,0xA3,0x6B,0xA9,0x2D,0x3C,0x6A,0xB5,0xBE,0xF9,0xD6,0xB4,0xA8,0x55,0x86,0x1A,0xC3,0x42,0xB2,0x56,0x1C,0x5D,0x1F,0xA5,0x45,0x87,0xC5,0x32,0x83,0x97,0xDE,0x65,0x9E,0xC8,0x0E,0x6A,0x0C,0xD2,0xAB,0x35,0x62,0xA9,0xD1,0xCB,0xCC,0x36,0x4B,0x4C,0x06,0xA1,0xDC,0x5D,0x44,0x36,0xB8,0x69,0x1B,0x77,0x31,0x75,0x93,0x86,0xE6,0xC5,0xDD,0xDC,0xF6,0xFF,0x25,0x51,0x09,0x15,0x79,0x39,0x41};
static  const uint8_t spa_ANOTHER[]   = {0xA5,0x2E,0x29,0x3C,0xD4,0x27,0xAD,0xBA,0xA6,0xF4,0x94,0xA8,0x75,0xCB,0x55,0xD4,0xE8,0xE1,0x12,0x75,0x5A,0x59,0x0C,0x66,0x73,0x3B,0x29,0x65,0xB3,0x68,0xC7,0x65,0x77,0x34,0x5D,0x96,0x86,0x4A,0xAB,0x55,0x36,0x3B,0x11,0xAA,0xAD,0x6E,0x79,0xCA,0xA6,0x26,0xC3,0xB5,0xD5,0x2D,0x53,0x9B,0x75,0x59,0xB2,0x4C,0x72,0x5D,0x52,0xAE,0xA1,0x96,0xB8,0xB4,0x55,0xB6,0xA6,0x4A,0x93,0x51,0x67,0x97,0x5E,0x54,0x57,0x57,0x95,0x83,0x87,0xCB,0x54,0x5D,0x55,0x8E,0x5E,0x2A,0x13,0x77,0x55,0x39,0x79,0x9A,0x54,0x9D,0x52,0xD7,0x10,0x59,0xA2,0x73,0xFE,0x25,0x51,0x75,0x65,0x39,0x41};
static  const uint8_t spa_ANSWER[]    = {0x23,0xC8,0xF6,0xDA,0x43,0x3C,0x1E,0x3F,0x9B,0xCD,0x10,0xC9,0x78,0xFC,0x6C,0xB6,0x5C,0x35,0xE3,0x09,0xB2,0xDB,0x72,0xB1,0x94,0x27,0xC8,0xFE,0xCA,0xD4,0x53,0x9E,0xA8,0xC4,0xF7,0xA4,0x48,0x34,0xA2,0xA2,0x56,0x13,0xB4,0x69,0x8B,0x0B,0x4F,0x69,0xF0,0xB5,0x39,0x51,0x71,0x54,0x1A,0x0D,0x9B,0x04,0x01,0x1D,0xB8,0x11,0xE0,0x4B,0x51,0x09,0x58,0x40,0x03,0xA5,0x6A,0xA2,0x24,0x31,0x66,0xB7,0xBA,0xBA,0x30,0xE7,0xB8,0xBD,0xFA,0x1A,0x3D,0x4C,0x6A,0xF1,0x1A,0x9A,0xCB,0x48,0xE3,0xD5,0x6B,0xAC,0xBE,0x22,0x95,0x57,0xB7,0xB1,0x64,0x4F,0xE3,0x9C,0x93,0xA6,0x92,0x9A,0xCD,0x22,0xD6,0xFF,0x4D,0x39,0x41};
static  const uint8_t spa_ANY[]       = {0xA3,0xEA,0xC1,0x59,0x33,0x17,0x9F,0x6A,0xF9,0x52,0x0E,0x5B,0x7D,0x8A,0xE5,0xC6,0x28,0x6C,0xF3,0x29,0xA6,0x1B,0xE5,0xF4,0xCD,0xA7,0xDC,0x66,0x94,0x23,0x56,0x8D,0xB2,0x4B,0x85,0x31,0x8B,0x32,0xAB,0x55,0x6D,0xDB,0x44,0xE6,0x0B,0x57,0x75,0xEC,0x30,0x44,0xAE,0x5A,0xD5,0xB6,0x83,0xD0,0xD5,0x70,0x55,0xCB,0x35,0x70,0xE5,0xC2,0x55,0x4D,0x3F,0xC0,0x55,0x33,0x47,0x35,0x7C,0x80,0x55,0x95,0x0A,0x6D,0x4F,0x82,0x15,0x13,0xE4,0xFF,0x51,0x19,0x21,0x41,0x19,0x49,0x41,0x35,0x41};
static  const uint8_t spa_AVAILABLE[] = {0x23,0x6F,0xB6,0x2C,0x8D,0x57,0x9D,0x62,0xE8,0x89,0x08,0xDA,0x7C,0xB2,0xAE,0xC6,0xDD,0xF9,0xD5,0xC8,0x9B,0x2C,0x0D,0xA3,0x57,0xA9,0xAA,0x3C,0xD5,0x95,0x5A,0x85,0xBA,0x53,0x13,0x73,0xF6,0x16,0xEA,0xCE,0xCD,0xC4,0x44,0x5D,0xCB,0xAA,0x36,0x49,0xE5,0x36,0x2B,0xEA,0xC6,0x38,0x53,0x56,0x9D,0x68,0xB8,0x64,0x2F,0x69,0x75,0xA2,0xE1,0x93,0xA2,0x6C,0xF1,0x89,0x46,0x08,0x8A,0xF2,0x59,0x27,0x9A,0xAE,0xC0,0x32,0x5A,0xAD,0x78,0x18,0x25,0x8F,0x5C,0xDC,0xD2,0xC2,0x4B,0x94,0x6B,0x53,0xCF,0x56,0x9E,0x83,0x27,0xEA,0xB4,0x2A,0x45,0x4A,0x4D,0x36,0x39,0x19,0x95,0x81,0xA6,0xB9,0x46,0x63,0x36,0x25,0xEE,0xE6,0xE6,0xB1,0x4B,0x1B,0xC3,0xBA,0xA8,0x2E,0x4E,0x7D,0xC8,0x15,0xAA,0xF1,0x2A,0x0D,0x21,0x75,0xA8,0x59,0x6B,0x3F,0xF9,0xD9,0x4C,0x3E,0x65,0x06,0x65,0xEB,0xFF,0x21};
static  const uint8_t spa_B[]         = {0xA9,0xB2,0x56,0x3D,0xBD,0x2B,0x95,0xB8,0x28,0xC1,0x9D,0xAD,0xD5,0xBC,0x69,0x1C,0xA2,0xAF,0x51,0xF3,0x97,0x0D,0xB0,0xBE,0xC6,0x3B,0x5C,0xD1,0xF2,0x06,0x32,0x1B,0x7B,0x67,0x2B,0x5F,0xD1,0x80,0x66,0x62,0x8F,0x6A,0x3B,0x26,0x9E,0x89,0xDD,0x9A,0x1D,0x85,0x70,0xA7,0x4E,0x1A,0x56,0x60,0x94,0xEB,0x3A,0x69,0x9C,0x8E,0xC8,0xBF,0xE2,0xB8,0xB1,0x6B,0xB0,0x9D,0x72,0xEC,0xC6,0x6E,0xC1,0x67,0xD3,0x8E,0x1B,0x47,0x04,0xE9,0xA9,0x28,0xFF,0x11,0x41,0x21};
static  const uint8_t spa_BAD[]       = {0x08,0x00,0x71,0xC2,0x98,0xD1,0xA7,0xA9,0x5A,0xAA,0x13,0x14,0x15,0x1C,0x69,0xAD,0x4F,0x30,0xEC,0x88,0xAB,0x2F,0x3A,0xC1,0xB0,0x23,0x6E,0x51,0xEB,0x04,0xC3,0x9E,0x84,0x44,0xA3,0x13,0xF5,0xD0,0x16,0x16,0xB1,0x4E,0xDC,0x63,0x7B,0xA8,0xC7,0x3A,0x59,0x8F,0xED,0xA9,0x51,0xEB,0x54,0xAD,0x66,0x84,0x45,0xE5,0x55,0xB7,0x9C,0x91,0xE6,0xB5,0x57,0xDB,0x62,0x78,0x99,0xD7,0x6E,0x7D,0xCD,0xE6,0xEE,0x59,0xA5,0xF5,0x25,0xBA,0x85,0x57,0x99,0xD2,0x97,0xA0,0x11,0xD6,0x75,0xC2,0x98,0xBC,0x66,0xD6,0x46,0xD6,0x23,0x19,0x85,0x72,0x77,0x11,0xD9,0xE0,0xFA,0x6D,0xDC,0xC5,0xD4,0x4D,0xEA,0x9B,0x17,0x77,0x73,0xDB,0xFF,0x39,0x51,0x51,0x75,0x15,0x51,0x21};
static  const uint8_t spa_BETWEEN[]   = {0xAC,0x55,0xAC,0x3C,0x22,0x63,0xB7,0xBA,0x5A,0x67,0x33,0xED,0xB4,0xF2,0x6A,0x99,0x33,0x6A,0x51,0xC8,0x9B,0x65,0xB1,0xC8,0x44,0xA4,0x10,0xCA,0xDD,0x45,0x64,0x03,0x04,0x60,0x7A,0xB3,0x00,0xCC,0xD0,0x6E,0x80,0x52,0x36,0x8A,0x9B,0x47,0xBB,0x32,0xC7,0x5A,0x6E,0x36,0x29,0x6E,0xB6,0xFA,0x38,0x4D,0x1B,0x65,0xF8,0x9A,0xE3,0x8D,0xA4,0x10,0xD5,0x8B,0x57,0x36,0x13,0x61,0xF4,0xC4,0x1E,0x45,0x77,0x60,0x33,0xED,0xA8,0xB5,0x55,0x61,0xEC,0x94,0xEA,0xD1,0x4F,0x47,0x18,0x33,0x71,0xDA,0x30,0x0C,0x51,0xCE,0xC4,0x6E,0x63,0x37,0x24,0x91,0x95,0xB8,0x8C,0x85,0xBB,0x25,0x87,0xDA,0x3A,0xFE,0x09,0x15,0x79,0x21};
static  const uint8_t spa_BOTH[]      = {0x85,0xD5,0xA6,0x32,0xC5,0x16,0x8D,0xA2,0x58,0xCD,0xD4,0xB8,0xBB,0x8B,0x53,0x56,0x6B,0x5E,0xA6,0x8F,0x6F,0xB9,0xAA,0x6C,0x2C,0xCA,0xFC,0xCE,0xAA,0x8A,0x51,0x6F,0xD5,0x3B,0xB3,0x6A,0x55,0x50,0xAD,0x2D,0x39,0xA9,0xD5,0x51,0x7A,0x64,0x46,0x2A,0x01,0x34,0x65,0x22,0x01,0x09,0x48,0x80,0x03,0x0C,0x28,0xDC,0x94,0x01,0x41,0x95,0xFE,0x39,0x79,0x15,0x15,0x55,0x21};
static  const uint8_t spa_BUTTON[]    = {0xA9,0x69,0xCE,0xC2,0x45,0x14,0x9F,0x28,0xFB,0xB5,0x14,0xDD,0x78,0xA2,0x5C,0x26,0x52,0x6D,0xD1,0x8A,0x4A,0xEE,0x2C,0xB7,0x45,0x23,0x2A,0x39,0x23,0x35,0x1A,0x92,0x58,0x28,0x77,0x17,0x91,0x0D,0x00,0xA8,0x28,0x2E,0xAA,0xD0,0x9D,0xA4,0xAA,0xE8,0x8E,0x26,0x75,0x56,0x9A,0x68,0x34,0x83,0xD3,0x55,0x1A,0xB2,0x95,0x54,0x71,0xCF,0x61,0xCE,0x4A,0x22,0x38,0xBD,0x98,0xA5,0x70,0xD7,0x10,0x4F,0x22,0x96,0xA2,0x4C,0x83,0x3D,0xEB,0xFF,0x61};
static  const uint8_t spa_C[]         = {0x0C,0xF8,0x8A,0x45,0x02,0x1A,0x50,0xC0,0xE7,0x11,0x16,0x30,0xC0,0xE3,0x69,0xCD,0x5D,0x8A,0xC9,0xB3,0x6D,0x2F,0x6F,0x39,0x03,0xE9,0xA9,0xBD,0xFC,0xE5,0x14,0x6C,0xB6,0xF1,0x0E,0x57,0xB2,0x9D,0x82,0xCC,0xD6,0x9E,0xD9,0x28,0x77,0x10,0x94,0x9E,0xDA,0xAD,0xD9,0x49,0x91,0x76,0xE2,0x94,0x7E,0x25,0x46,0xDE,0x89,0x53,0x86,0x15,0x08,0xE5,0xBA,0x4E,0x1D,0xD3,0x38,0x1D,0x92,0x7F,0xC5,0x89,0x63,0x1C,0xDD,0x38,0x3C,0x48,0x4F,0x45,0x71,0x43,0x33,0xA8,0xDB,0x63,0xFB,0xFF,0x51,0x15,0x15,0x51,0x65,0x65,0x41,0x61};
static  const uint8_t spa_CASSETTE[]  = {0x06,0x68,0x86,0x65,0x84,0x55,0x8B,0x74,0xB9,0xAD,0x13,0xB5,0xEC,0x1A,0x16,0x8D,0x4F,0xD6,0xC3,0x68,0x98,0xB4,0x3A,0x79,0x77,0xA5,0x69,0xB6,0xBA,0x14,0xD5,0xAB,0xB9,0x75,0x29,0x04,0x2C,0xA4,0x86,0x80,0x83,0x23,0x10,0x70,0x99,0x3B,0x03,0x3E,0xCB,0x64,0xC0,0x67,0x91,0x02,0xB8,0x2A,0x42,0x01,0x4B,0x95,0x2D,0xB7,0x59,0x97,0xD2,0x58,0x7C,0xA2,0xEE,0x52,0xC2,0x7D,0xF1,0xC9,0xBA,0x2F,0x09,0xB7,0xD5,0xA7,0xEA,0x3E,0x25,0xDC,0x57,0xA7,0xA6,0x19,0x93,0x8A,0x98,0x89,0x1A,0xA1,0xDC,0x5D,0x44,0x36,0x80,0x00,0xAE,0x48,0x93,0x00,0x02,0xAA,0x6F,0xF8,0x25,0x51,0x15,0x61,0x41,0x25,0x41,0x09,0x61};
static  const uint8_t spa_CHARACTER[] = {0x0A,0x68,0x46,0x44,0x01,0x4D,0x91,0xB6,0x60,0x44,0xC1,0x10,0x8F,0xB3,0xDC,0xEE,0xCD,0xCA,0x42,0xCE,0x71,0x5A,0x2E,0x2B,0xCD,0x58,0xC7,0x6B,0x7E,0xA3,0xD5,0x63,0x9D,0xA0,0x85,0xCE,0xB4,0x48,0x74,0xA2,0x96,0xA2,0xCD,0x2D,0xD5,0xC8,0x6A,0xD1,0xC2,0x8A,0xCC,0x23,0x6B,0x45,0x12,0x23,0x33,0xAD,0xBC,0x57,0x35,0xB5,0xCC,0x35,0x8A,0x9E,0x94,0xA2,0xAA,0x31,0x03,0x82,0x62,0x43,0xA0,0x50,0xEE,0x2E,0x22,0x1B,0x00,0x40,0x00,0xDB,0xA4,0x96,0xA2,0x98,0xE0,0xD2,0xAC,0xD4,0xFA,0xEA,0xC3,0x42,0xA2,0x55,0x5A,0x72,0x33,0x4D,0xEF,0xDA,0x6E,0x2D,0x35,0xC2,0x24,0x2B,0xDB,0xF5,0xFF,0x51,0x15,0x51,0x19,0x05,0x59,0x79,0x61};
static  const uint8_t spa_COMPLETE[]  = {0x06,0x28,0x29,0x68,0x44,0x29,0xAA,0xA6,0xD6,0xEC,0x15,0xE7,0x9C,0xE6,0x64,0xAB,0x5A,0x9E,0xBD,0x96,0x41,0xB6,0x0D,0x79,0xB2,0xDC,0x48,0xDD,0xCD,0x94,0x49,0x53,0x15,0x7B,0x12,0x54,0x09,0xE5,0xEE,0x22,0xB2,0x01,0x14,0x50,0x7C,0x78,0x00,0x9A,0x61,0x4B,0xC1,0xE2,0x93,0xE8,0x21,0xA7,0x07,0xCB,0x1C,0xDC,0xC1,0xAB,0xEA,0x2C,0x77,0x06,0x03,0xDB,0x5E,0x3C,0xA2,0xA5,0x05,0xFC,0xBA,0x76,0x8B,0x57,0x31,0xE0,0xEE,0xDA,0x24,0x16,0xCA,0xDD,0x45,0x64,0x03,0x00,0x28,0xE0,0x8A,0x34,0x0D,0x20,0xA0,0xFA,0x86,0xFF,0x25,0x51,0x15,0x55,0x05,0x59,0x79,0x61};
static  const uint8_t spa_COMPUTER[]  = {0x06,0x28,0x29,0x68,0x44,0x29,0xAA,0xA6,0xD6,0xEC,0x15,0xE7,0x9C,0xE6,0x64,0xAB,0x5A,0x9E,0xBD,0x96,0x41,0xB6,0x0D,0x79,0xB2,0xDC,0x48,0xDD,0xCD,0x94,0x49,0x53,0x15,0x7B,0x12,0x54,0x09,0xE5,0xEE,0x22,0xB2,0x81,0x01,0xD5,0x86,0x97,0xA0,0x47,0x22,0xCF,0xAA,0xDC,0xFC,0x26,0x8D,0xB2,0x7D,0xF5,0xF2,0x33,0x6D,0xCD,0xB0,0xD7,0x3B,0xE8,0x11,0x2A,0x84,0x72,0x77,0x11,0xD9,0xA0,0x80,0x6D,0x35,0x1D,0xB0,0x89,0xFB,0x48,0x8A,0x35,0x75,0xED,0xDA,0xAB,0xAA,0xDE,0x2D,0x24,0x57,0xAF,0xB6,0xF9,0xB6,0x14,0x5D,0x5D,0xA6,0x52,0xD3,0x5C,0x73,0xB6,0xDB,0xB3,0x4F,0x4F,0x89,0x31,0xFF,0x15,0x61,0x51,0x25,0x25,0x79,0x61};
static  const uint8_t spa_CORRECT[]   = {0x0A,0x28,0x71,0xD9,0x00,0xB9,0x39,0x97,0xA8,0xD4,0x66,0xF3,0x68,0x32,0xA2,0x94,0xCD,0x35,0x62,0xF2,0x4A,0x4A,0xD1,0x22,0xB7,0xC5,0x2D,0xCD,0x87,0x93,0xD3,0x5A,0xA7,0x34,0x2E,0x0A,0x75,0xEB,0x12,0xD2,0x30,0x31,0x2C,0xBC,0x73,0x48,0xC2,0xC0,0x0C,0x8B,0x4E,0x25,0x4A,0x13,0x4B,0xD2,0x5A,0x8F,0xA0,0x14,0x4E,0x2E,0x5F,0x7C,0xA2,0x56,0x2C,0x34,0x6C,0xF1,0x89,0x5B,0x90,0xF0,0xC8,0x29,0x27,0xEB,0x49,0x2D,0x3D,0xEA,0xB4,0xA2,0x25,0xD6,0xCE,0x9A,0x8C,0x0A,0xA1,0xDC,0x5D,0x44,0x36,0x00,0x00,0x00,0x28,0xE0,0x8A,0x34,0x0D,0x20,0xA0,0x9A,0x86,0xFF,0x11};
static  const uint8_t spa_D[]         = {0x0C,0xB8,0xD0,0x64,0x64,0x0F,0x15,0x8B,0x5A,0xE8,0x15,0x6C,0xE1,0xA0,0x39,0x8B,0x8E,0xFB,0x4C,0x00,0x57,0x2F,0x3A,0xEE,0x75,0x09,0x5C,0x33,0xEB,0xF8,0xC7,0x3A,0x70,0xEF,0xEC,0x13,0x6D,0xEB,0x20,0xB3,0xB5,0x46,0x32,0x2D,0x43,0xF6,0xC4,0x1E,0xC5,0x8A,0x0A,0x3A,0x13,0xBB,0x55,0xDB,0x3B,0x70,0x4F,0xE5,0xD6,0xEC,0x68,0xC0,0xBD,0x95,0x7B,0x97,0x87,0x38,0xFD,0x41,0x15,0x41,0x11};
static  const uint8_t spa_DATA[]      = {0x65,0x3C,0x3A,0x32,0x23,0x64,0xAF,0x78,0x10,0xA7,0xAC,0x6C,0x78,0xA2,0xA1,0x8D,0x3A,0x6B,0xF1,0x89,0x66,0x4C,0xF2,0xB0,0xC6,0x27,0x9A,0xA1,0x49,0xC3,0x5A,0x9D,0x68,0xC6,0x00,0xAB,0x5C,0x34,0xA2,0x59,0x03,0xD4,0x6B,0x56,0x89,0x47,0x64,0x8C,0xAA,0x5A,0x24,0x16,0xCA,0xDD,0x45,0x64,0x83,0x03,0x36,0x4B,0x33,0xC0,0xC6,0xA1,0xA5,0x28,0x4A,0xBD,0xA5,0xA3,0xAC,0xAA,0x79,0xB3,0xD0,0x9C,0xB2,0xA6,0x16,0xD2,0x53,0xF4,0x71,0x5B,0x4A,0x1E,0x75,0xF3,0x5B,0x61,0xAD,0xB9,0x3D,0xC5,0x2E,0xFD,0x51,0x15,0x41,0x11};
static  const uint8_t spa_DATE[]      = {0xAC,0xDD,0xD0,0x3D,0x2D,0x6D,0x8F,0x74,0xB1,0x24,0xB5,0x48,0x7C,0xA2,0x2E,0x8D,0x2B,0xB3,0xF6,0x09,0x87,0x36,0xAE,0xAE,0xC5,0x27,0xA8,0x5A,0x7C,0xAB,0xA7,0xAC,0xB8,0x7B,0xD2,0xAA,0x8E,0xB2,0x8A,0x99,0x1C,0x65,0xBA,0xF6,0xAE,0xC2,0x30,0x0C,0x63,0x6D,0xC7,0x16,0x93,0x50,0xEE,0x2E,0x22,0x1B,0x00,0x40,0x00,0x57,0xA4,0x49,0x00,0x01,0xC5,0xA7,0xFE,0x79,0x11};
static  const uint8_t spa_DO[]        = {0x0C,0x98,0x92,0x79,0x04,0x53,0x32,0x57,0x47,0xA7,0x19,0x8C,0xA0,0x90,0x74,0x0D,0xF9,0xDD,0xE2,0x82,0x32,0x34,0x78,0x77,0xCB,0x2B,0xCC,0xB0,0xC0,0x4F,0xA1,0x54,0xA1,0xC4,0xB4,0x4E,0x87,0xC6,0xF1,0x0B,0x75,0x7D,0xE9,0x3A,0x69,0xD7,0x5C,0xE2,0xB1,0x1B,0xBC,0x18,0x4F,0x96,0xD7,0x66,0xB0,0x62,0xDD,0x45,0x1E,0xFD,0x25,0x41,0x19,0x19,0x79,0x11};
static  const uint8_t spa_DOLLAR[]    = {0xA4,0xD2,0x34,0xA3,0x2B,0x1D,0x8D,0xA0,0x11,0xF7,0xB0,0x4A,0x7D,0x82,0xA2,0x5B,0xCD,0xBC,0xD3,0x09,0x72,0x98,0x70,0xD5,0x8E,0x27,0xC8,0xE1,0xD2,0xD5,0x32,0x9D,0x30,0x87,0x2D,0x57,0xCB,0x74,0xA2,0x14,0x2F,0x5D,0x3C,0xD3,0x8A,0xB3,0xAB,0x76,0x8A,0x4C,0x2D,0xCD,0x26,0x32,0xA0,0x96,0xD6,0x7C,0xB4,0x39,0x76,0x18,0x77,0xCB,0x36,0xE5,0x9C,0xA1,0x3C,0x95,0xD3,0x94,0x5B,0x99,0x69,0x55,0x8E,0x8B,0x5D,0xFE,0x15,0x39,0x79,0x11};
static  const uint8_t spa_DONT[]      = {0x61,0x3C,0xD5,0x4B,0x23,0xEC,0xAE,0xA2,0x0B,0x67,0xF3,0xE8,0x74,0x8A,0x61,0x52,0x2C,0x74,0xF7,0x29,0xBB,0x2E,0xB3,0x94,0x3D,0xA7,0xEC,0x3A,0xCD,0x4B,0xF6,0x9C,0xB2,0x9B,0x54,0x4B,0xD9,0x7D,0xCA,0xAE,0x43,0x3D,0xB9,0xF7,0xA9,0x9A,0x76,0x4B,0x13,0xDF,0xAD,0xCA,0x56,0x3D,0xC8,0x3C,0xA7,0x2A,0x09,0x91,0x55,0x4B,0x1A,0xEA,0xAC,0xB0,0x4B,0xC2,0x0D,0x6A,0x44,0x70,0x17,0x11,0xD9,0x20,0x80,0x2D,0xD2,0x24,0x80,0x80,0xE2,0x53,0xFF,0x39,0x75,0x79,0x11};
static  const uint8_t spa_DOWN[]      = {0x08,0x48,0x60,0x82,0xD4,0x8E,0xBA,0x57,0xB4,0xED,0xE6,0x74,0x92,0x6A,0x1E,0x8D,0x4F,0xD4,0x54,0x6A,0x8A,0xB7,0x3A,0x51,0x13,0x2B,0xA5,0xB1,0xE8,0x44,0x55,0x9F,0x95,0x58,0xAB,0x13,0x55,0xFB,0x9E,0xEA,0xAD,0x4E,0x5C,0xED,0x47,0xA9,0x37,0x3C,0x69,0x35,0x1F,0x69,0xD1,0xF0,0xE4,0xD5,0x5D,0xA4,0xF9,0xAA,0x53,0x96,0xB0,0x51,0x66,0x8B,0x4E,0x5D,0xDC,0x7A,0x86,0xAE,0x1C,0x43,0x29,0x6D,0x29,0x76,0x2B,0x8D,0x29,0xA4,0x78,0xE4,0xAC,0x30,0xC5,0xEC,0xE2,0x51,0x93,0xDC,0x14,0x93,0xAB,0xD8,0x34,0x72,0x53,0x32,0x96,0xA2,0x99,0xD9,0x8D,0x49,0xC8,0xB8,0x86,0x67,0x33,0x44,0x21,0x53,0x16,0x5A,0xCC,0xE0,0x65,0x54,0x69,0xBA,0x36,0x7D,0xE4,0xDA,0xA5,0xA3,0xF8,0xFF,0x51};
static  const uint8_t spa_E[]         = {0x21,0x3A,0x4A,0x41,0x77,0x63,0xCF,0x68,0x27,0x3B,0x1D,0xC5,0x6A,0x4A,0x38,0x55,0x7B,0x16,0xB3,0x2E,0xED,0xAA,0x42,0x78,0x15,0xB5,0xB6,0xA5,0x9F,0x19,0xD9,0x2F,0xE3,0xD4,0x3E,0x0F,0x69,0x98,0x01,0xD9,0x2F,0xE3,0xE4,0xE1,0xFF,0x09,0x61,0x41,0x51};
static  const uint8_t spa_EACH[]      = {0xA5,0x58,0x36,0x91,0xB6,0x1B,0xED,0x62,0x15,0xD3,0x05,0xF0,0xD6,0xC2,0x55,0xCE,0xE0,0x20,0x5B,0x0B,0x77,0xB9,0xCA,0x11,0x05,0x7C,0xBA,0x62,0xA9,0x7A,0x40,0xEE,0xAE,0x8A,0xA8,0x13,0xC1,0x5D,0x44,0x64,0x03,0x28,0x60,0x67,0x17,0x07,0xEC,0xD6,0x19,0x80,0x5D,0x3A,0x03,0xB0,0xFA,0xA6,0x05,0x14,0xB0,0xEA,0xB8,0x00,0xE6,0x6C,0x27,0xC0,0x4C,0x26,0xFF,0x39,0x51,0x35,0x51,0x19,0x51};
static  const uint8_t spa_ELEVEN[]    = {0x25,0xED,0x5A,0x29,0x36,0xAB,0x8C,0xAC,0x1B,0xC3,0xD8,0x5A,0xB8,0xE2,0x41,0x5C,0xEC,0x32,0xD3,0x48,0x07,0x56,0xB5,0xB2,0x34,0x2D,0xA9,0xC0,0xC3,0x3A,0x56,0xB5,0xA4,0x80,0x08,0xED,0x6C,0xD5,0xE2,0x0E,0xDC,0xB9,0xA3,0xE5,0x09,0x06,0x77,0xEE,0xB4,0x45,0x27,0x1A,0xA2,0x34,0xD2,0x16,0x9D,0xA8,0xCB,0xB4,0x72,0x7F,0x74,0x92,0xAE,0xC7,0xDD,0x78,0x51,0xCB,0x4B,0x2C,0x0F,0x96,0xDA,0xA1,0x69,0xAA,0x2C,0x84,0x63,0xBB,0xB9,0xF1,0x52,0x57,0x4E,0x9C,0xC6,0x5C,0x23,0x9C,0x6C,0x76,0x98,0x72,0xD6,0x22,0xDF,0x3A,0x66,0x4A,0x42,0xBC,0xDD,0x1B,0xDB,0x09,0x8D,0x22,0xB8,0x8B,0x88,0x6C,0x00,0x80,0xFF,0x11,0x51,0x71,0x41,0x71,0x39,0x51};
static  const uint8_t spa_ENGAGED[]   = {0xA3,0x18,0x41,0xD9,0xAB,0xE6,0x9C,0x7C,0x86,0x64,0x89,0x98,0x7D,0xD2,0x29,0x82,0xB4,0xA3,0x56,0x49,0x93,0x92,0x28,0x4A,0x77,0x35,0x4B,0x59,0x56,0xD8,0x45,0xAD,0x25,0x66,0x28,0x13,0xC1,0x5D,0x44,0x64,0x23,0x20,0x28,0xEA,0x96,0x0F,0x2D,0xE0,0x55,0xB3,0x56,0x3C,0xA4,0x63,0x4E,0xCD,0xBA,0xD1,0x89,0x7B,0x30,0xAA,0x8C,0x3A,0x27,0xE9,0x91,0xB5,0xA2,0xAA,0x9E,0xB4,0x45,0xF2,0x8C,0xAE,0x7B,0x8A,0x9E,0xC8,0x32,0xBB,0xEA,0xA9,0x7A,0x65,0xC9,0xE8,0xAA,0xAB,0x9D,0x39,0x49,0x3A,0x17,0x8F,0x61,0x24,0x43,0x9D,0x7C,0x5C,0xA6,0xEE,0x49,0x6A,0x7A,0x52,0x1A,0x47,0x61,0x8C,0xEA,0x39,0x64,0x10,0xC1,0xDD,0x45,0x64,0x03,0x02,0x40,0xEC,0x0A,0xCF,0xAC,0xEE,0x12,0x2A,0x45,0x00,0x7B,0x99,0x4A,0x40,0x01,0xA7,0x94,0x09,0x60,0x47,0x13,0x04,0x8A,0xE0,0x2E,0x22,0xB2,0xC1,0x4D,0xD7,0xB8,0x8B,0xA9,0x9B,0x34,0x0C,0x23,0xEE,0xE6,0xB6,0xFF,0x25,0x51,0x15,0x39,0x51};
static  const uint8_t spa_ENTER[]     = {0x23,0x98,0x29,0x45,0xD2,0x9A,0x9C,0x60,0xF9,0x16,0x49,0x6D,0x7C,0x83,0x13,0x6C,0x9D,0xAC,0x65,0x8D,0x57,0xD8,0xA4,0x72,0x79,0xD4,0x6E,0x51,0x91,0x22,0xA7,0x9E,0xA4,0xC4,0x99,0xAB,0x3E,0x55,0x3C,0x97,0x44,0xC1,0xF1,0x12,0x76,0x50,0x23,0x94,0xBB,0x8B,0xC8,0x06,0x03,0x7C,0x11,0xA1,0x80,0x4D,0x23,0x5A,0x96,0x9D,0x79,0x7A,0x57,0x19,0x7D,0xF5,0xEE,0x6E,0xBE,0x78,0x8C,0xD5,0xA5,0x85,0xD9,0xEA,0x36,0x95,0x98,0xE6,0x1A,0xB3,0xCA,0x5C,0x62,0x98,0x5B,0xCE,0xCC,0xF3,0xFF,0x25,0x79,0x25,0x25,0x51};
static  const uint8_t spa_ERROR[]     = {0x2B,0x98,0xB1,0xC5,0x9C,0x1B,0x1F,0x7F,0xBA,0x96,0x48,0xAE,0x75,0x82,0x1E,0xCA,0xCA,0xA4,0xD1,0x09,0x6B,0xB3,0x12,0xF3,0xC6,0x23,0x2E,0x5B,0x82,0x4B,0x33,0x8F,0xB4,0x2C,0x29,0x2A,0x6F,0xD5,0xB3,0x51,0xD7,0x66,0x23,0x2E,0x8B,0x4E,0x5F,0x4B,0x57,0xA8,0x2C,0x3E,0x43,0x8D,0x55,0xA9,0xB2,0x7A,0x0C,0x25,0x57,0x85,0xCA,0xE3,0x39,0x94,0xB1,0xD4,0x68,0x93,0x9A,0xFC,0x51,0x05,0x41,0x61,0x65,0x51};
static  const uint8_t spa_ESCAPE[]    = {0x21,0x68,0x5E,0xB9,0x22,0x26,0xAF,0x74,0xB8,0xA4,0x08,0x5F,0x75,0xD2,0xA5,0x9B,0x34,0x6C,0xD5,0xCA,0xAA,0x36,0x29,0xAF,0x49,0x25,0xBF,0x24,0x54,0x2A,0x52,0x09,0xE0,0x12,0x73,0x0B,0x58,0x40,0x01,0xDF,0xB8,0x09,0xE0,0xF1,0x0A,0x04,0x0A,0xE5,0xEE,0x22,0xB2,0x41,0x01,0x53,0xB3,0x35,0xB3,0x79,0xD2,0x89,0x8A,0x73,0xDC,0x16,0x29,0xCA,0x3B,0xCE,0x09,0x7B,0x52,0x29,0xCF,0x3A,0x27,0x1D,0x51,0x39,0xB3,0xEA,0xAC,0x6A,0x14,0x61,0xCF,0xAA,0xDB,0x86,0x11,0x99,0x3C,0xB3,0x0E,0x99,0x84,0x72,0x77,0x11,0xD9,0x00,0x00,0x80,0x80,0x60,0x9D,0x09,0x90,0xB2,0x08,0x02,0x82,0x35,0xFD,0x31};
static  const uint8_t spa_F[]         = {0x23,0x1E,0x29,0x44,0x32,0xE6,0x9C,0x70,0xA6,0x16,0x09,0x9F,0x7D,0xC2,0xE5,0x53,0xB4,0xBD,0xF6,0x89,0xA6,0x77,0x89,0xF6,0x25,0x27,0x1D,0x39,0x35,0x9C,0x9B,0x8C,0xA2,0xA4,0x34,0xB7,0xA8,0x8A,0x80,0x14,0xCC,0x09,0x30,0x6C,0x05,0x05,0x38,0xC0,0x80,0xE1,0x2B,0x08,0x30,0x4C,0x3A,0x01,0x9A,0x49,0xC7,0x00,0x06,0xFE,0x75,0x51,0x31};
static  const uint8_t spa_FEW[]       = {0x08,0xA8,0x54,0x95,0x02,0x0C,0x68,0xD2,0xC8,0x00,0x33,0x2B,0xB5,0xBC,0x6B,0x45,0xDB,0xAA,0x3C,0xF2,0xE9,0x12,0x68,0x72,0xD1,0x2E,0x56,0x31,0xB4,0x83,0xB5,0xBD,0x5C,0x45,0xC3,0xCE,0xB9,0xB2,0x6A,0x94,0x15,0xBB,0x4C,0xD3,0xE6,0x56,0x55,0xD0,0xA1,0xC9,0xBF,0x5B,0x55,0x50,0x7B,0x04,0xEE,0xEE,0x55,0xA9,0x12,0xDE,0x70,0xA3,0x9D,0xA1,0x8A,0xF4,0xC2,0x8D,0x76,0xDA,0xEA,0xFF,0x51,0x19,0x49,0x31};
static  const uint8_t spa_FILE[]      = {0x08,0xE8,0xD2,0x95,0x00,0x4D,0xA7,0x09,0xA0,0xC8,0xF0,0xE6,0xE5,0x54,0x9E,0x4A,0x8F,0x4E,0x50,0xFC,0x95,0xB9,0x36,0xB8,0xE1,0x89,0xAA,0xB9,0x52,0xF3,0x86,0x27,0x6E,0xFA,0xDA,0xCD,0x5A,0x9E,0xB4,0xEA,0x6B,0x77,0x6B,0x79,0x8A,0xA6,0xB7,0x32,0xA4,0xD3,0xA9,0xBA,0xDD,0xC8,0x94,0x55,0xA7,0xEB,0xA1,0x3D,0x83,0x17,0x9F,0xBE,0x87,0x90,0x08,0x5B,0x3C,0x86,0xEE,0x4C,0xB2,0x6C,0x71,0x99,0x8A,0x97,0x48,0xAF,0xD9,0x61,0xCE,0x4E,0x2B,0xB4,0xE6,0x84,0x25,0x79,0xCF,0x22,0x5F,0xED,0x67,0x33,0x85,0xEE,0x66,0xD2,0x8D,0xDD,0x18,0x62,0x64,0x52,0xAC,0xB2,0xE3,0xFF,0x15,0x65,0x25,0x49,0x31};
static  const uint8_t spa_FIRST[]     = {0x04,0xC8,0x2C,0x94,0x01,0x53,0x54,0x08,0x60,0xB0,0x54,0x01,0x54,0x99,0x3A,0x9C,0xEC,0x53,0xC3,0xB4,0xF6,0xF1,0xAB,0x29,0x0B,0x93,0xD5,0xC7,0x6F,0xAE,0x2D,0x95,0x57,0x9D,0xA8,0xDA,0xD2,0x70,0x5B,0x74,0x92,0x6E,0x5A,0xC3,0x64,0xF3,0x29,0xBA,0x4D,0x4D,0x93,0xCD,0xAB,0xEF,0x36,0x35,0x4C,0x5E,0xA7,0x21,0x5B,0xF7,0xF6,0x9C,0x95,0xC6,0x12,0x4D,0xC3,0x7B,0xB4,0x02,0x82,0xD5,0x12,0xC0,0x42,0xA1,0x0A,0xF8,0xC2,0x9C,0x01,0x5F,0x78,0x0A,0xE0,0x73,0x37,0x01,0x7C,0xE6,0x2E,0x80,0x1F,0xD8,0x10,0x28,0x94,0xBB,0x8B,0xC8,0x06,0x06,0x4C,0xE1,0x25,0x80,0x4D,0x39,0x11,0x30,0x44,0xE8,0xFF,0x11,0x39,0x55,0x79,0x31};
static  const uint8_t spa_FOUND[]     = {0x04,0x18,0x2E,0x5D,0x01,0xC3,0xA4,0x2A,0x60,0xEA,0x08,0x0F,0x8C,0x38,0xC5,0xB2,0x30,0x5E,0xB4,0xF2,0x9C,0x2A,0xD2,0x68,0xD5,0x29,0x4A,0xDC,0xC8,0xE0,0x8E,0xA7,0x2A,0x61,0x33,0x92,0x3B,0x9F,0xBA,0xBA,0x8D,0x4C,0xEE,0x74,0xEA,0xEA,0x27,0x32,0x79,0xF5,0x69,0x6B,0x18,0xCF,0xA0,0x55,0xAB,0x2D,0xB1,0xBD,0x94,0x56,0xAD,0xA6,0xA4,0xF2,0x14,0x5E,0xB5,0xEA,0x12,0xD2,0x0B,0x25,0xD3,0xAA,0x8A,0x8B,0x08,0x34,0xCD,0xA3,0xAA,0x2A,0xA4,0x41,0x9D,0xB5,0xAA,0x52,0xA7,0xA5,0x48,0x5A,0xAA,0x22,0x44,0x9E,0x32,0x0E,0x6B,0x82,0x94,0x1C,0x2A,0xC7,0xA1,0xDD,0xC6,0x5D,0x4C,0xDD,0x94,0xBE,0x79,0x71,0x37,0xB7,0xFD,0x59,0x79,0x25,0x31};
static  const uint8_t spa_FROM[]      = {0x08,0xE8,0xDA,0x84,0x02,0x0A,0x68,0x26,0x54,0x03,0xAE,0x88,0x83,0x2A,0xC4,0x73,0x97,0x2A,0x2D,0x8D,0x90,0xC8,0xBD,0xEA,0x1C,0xAD,0x22,0xA8,0xF7,0x69,0xB2,0xAF,0x8A,0xA4,0x3E,0xA7,0xCD,0xBE,0x2A,0x12,0xF7,0x9C,0x2E,0x9B,0x6D,0x0B,0xEA,0x72,0xFA,0x6C,0x6E,0x34,0xB8,0xF5,0xEA,0xB3,0xBE,0xB5,0xE0,0xD6,0xA3,0xCF,0x7A,0x5A,0x43,0x3D,0xB7,0x2E,0xAB,0xB6,0x14,0x52,0x5D,0xDA,0x24,0x5A,0x43,0x58,0x4B,0x6E,0x43,0x13,0x9D,0x85,0x91,0xB6,0xF1,0xCD,0xFF,0x71};
static  const uint8_t spa_G[]         = {0xA1,0xDE,0xDD,0x89,0x30,0xD2,0x58,0x60,0x64,0x2B,0x1A,0xB1,0x45,0x97,0x95,0xCC,0xA8,0xC8,0xD9,0xAB,0x77,0xB8,0xFD,0x13,0x4C,0x2B,0xE8,0x39,0xB5,0x6F,0xB4,0x92,0x6D,0x14,0x38,0xB7,0xF2,0xCE,0x46,0xB5,0xBD,0x22,0xE5,0x34,0x6E,0xDD,0xCE,0x8E,0x90,0x53,0x27,0x0D,0x3B,0x08,0xE2,0x4E,0x9D,0x34,0xAC,0x24,0x88,0xD7,0x75,0xF3,0x90,0x86,0x55,0x04,0x71,0xA7,0x49,0x19,0x66,0x16,0xE0,0xED,0xC5,0x61,0x18,0x01,0xB8,0x7B,0x62,0x87,0x61,0x64,0x22,0xCF,0x8E,0xFC,0x11,0x79,0x79,0x71};
static  const uint8_t spa_GOOD[]      = {0xA9,0x2C,0xA9,0xC5,0xD4,0x6C,0x8F,0xA2,0x61,0xD7,0x68,0xE9,0xBC,0xCA,0x22,0xCC,0xDB,0x64,0xCD,0xA9,0x92,0x2A,0x37,0xB3,0xCD,0xB7,0x3A,0x55,0x52,0x19,0xAE,0xFA,0x7A,0x57,0xA3,0xCE,0xC2,0xA3,0x42,0x57,0xD7,0x06,0x35,0x22,0xB8,0x8B,0x88,0x6C,0x70,0xC3,0x36,0xEE,0x62,0xEA,0xC6,0x75,0xCD,0x8B,0xBB,0xB9,0x6D,0xDF,0xFD,0x09};
static  const uint8_t spa_H[]         = {0xC3,0x1B,0xD1,0x29,0xA2,0x6A,0xAF,0x68,0xC6,0x46,0xF3,0x6C,0x74,0xC2,0x91,0x12,0xCD,0x7B,0xD1,0x89,0x66,0x2C,0xD4,0xAC,0x45,0x27,0x5E,0xB9,0x91,0xB3,0x16,0xAD,0x6C,0xD5,0x41,0x8C,0x58,0x94,0xAA,0xD9,0x02,0xB8,0x7A,0x11,0xA9,0x84,0x72,0x77,0x11,0xD9,0x00,0xA0,0x80,0x69,0xCC,0x15,0xB0,0xB3,0x8B,0x03,0x76,0xEB,0x0C,0xC0,0x2E,0x9D,0x01,0x58,0x7D,0xD3,0x02,0x0A,0x58,0x75,0x5C,0x00,0x73,0xB6,0x13,0x60,0x26,0x93,0xFF,0x51,0x35,0x41,0x09};
static  const uint8_t spa_HAVE[]      = {0xAC,0x19,0xA1,0xBD,0x3C,0x2B,0x8F,0x68,0x44,0x8F,0x54,0x33,0x7D,0x9C,0xEA,0xDD,0x53,0x3D,0xF2,0x71,0x87,0x6B,0x8B,0xB0,0xDA,0x27,0x18,0x6E,0xDD,0xC3,0x6A,0x9D,0x68,0x9A,0x09,0x4F,0x6B,0x74,0xE2,0x69,0x27,0x23,0xA5,0xD1,0x29,0x86,0x9F,0x8C,0xD4,0xC5,0xA7,0x6A,0xA9,0x22,0xC2,0x27,0x8D,0xAE,0xC6,0xB2,0x48,0x2F,0xD5,0xFA,0x1A,0xC2,0xD3,0x7C,0x54,0x1B,0x4A,0x2C,0xF6,0xB4,0xCA,0x69,0x48,0xA1,0xD8,0xD7,0x6A,0xB9,0xC1,0x55,0xD7,0xA9,0xAC,0x64,0x46,0x6F,0x3C,0xCB,0xAD,0x95,0x9A,0x8A,0x31,0x73,0xB6,0xC4,0x6A,0x6C,0x32,0xD4,0x58,0x54,0xFF,0x49};
static  const uint8_t spa_I[]         = {0x2B,0x2B,0xA5,0x3A,0xCD,0x9B,0x9C,0xB4,0x9A,0x8B,0x08,0x5B,0xB4,0x92,0xE2,0xDF,0x3D,0xBD,0xE6,0x89,0x4B,0x7C,0xB7,0x88,0x98,0x27,0x2D,0xFE,0xC3,0x22,0x6A,0x9E,0xB4,0xF8,0x0F,0xF7,0x68,0x78,0xB2,0x6A,0x3E,0x23,0x6C,0xE5,0xA9,0x9B,0xBA,0x8C,0xD4,0xD6,0xA7,0x6E,0xFA,0x32,0x4A,0x57,0x9F,0xB1,0xF9,0x89,0x48,0x5B,0x73,0xA6,0x16,0xCB,0x33,0x6C,0xF1,0x5A,0x7B,0x0E,0x8F,0xB0,0xDA,0x63,0x6D,0x51,0x3C,0xB2,0x16,0xB7,0xAD,0x79,0xD5,0xEC,0x9A,0x53,0xB6,0x9E,0x44,0x62,0xBB,0x4E,0xDA,0xBA,0x63,0xCD,0x99,0xCA,0x69,0xED,0x8E,0x2C,0x27,0xE5,0xFC,0x19,0x41,0x71,0x51,0x19,0x19,0x49};
static  const uint8_t spa_ILLEGAL[]   = {0x25,0x19,0x4C,0xA9,0x6F,0x42,0xF7,0x2C,0x67,0x21,0x5F,0x20,0x38,0xC3,0x1E,0x96,0xE4,0x70,0x65,0x4B,0x5F,0xDD,0xA2,0x43,0x85,0xAD,0xA2,0xF5,0x08,0xB6,0x36,0xD0,0xD6,0x26,0x2B,0x9A,0xD6,0x40,0xBB,0xAA,0xAC,0x64,0x79,0x03,0xDD,0xAE,0x3D,0xB2,0x99,0x08,0x6A,0xBA,0x72,0xA9,0x56,0x37,0xE0,0xE9,0x46,0xA6,0x5A,0xDD,0x81,0xAA,0x67,0x21,0x50,0x04,0x77,0x11,0x91,0x0D,0xAE,0x28,0xA9,0xC1,0xD4,0x6C,0x97,0x36,0xC7,0x46,0xF7,0x48,0x34,0xFA,0xAA,0xC3,0x4A,0x7D,0xF1,0x18,0xB2,0x8F,0x0C,0xCE,0x35,0x65,0x8A,0xB1,0xDC,0x39,0x5B,0x87,0x39,0x94,0x72,0xE3,0x5E,0x1C,0xA6,0x10,0xDB,0x83,0xB2,0xAB,0x1B,0xA3,0x1B,0x6B,0xB4,0xB5,0x7E,0xF8,0x5A,0x39,0x49};
static  const uint8_t spa_IN_[]       = {0xCD,0x9E,0xC3,0x89,0x23,0x17,0x9F,0x68,0xC5,0x42,0xCA,0x5C,0x74,0xC2,0xE5,0x12,0xB9,0x62,0xE1,0x09,0x97,0x76,0x92,0x8A,0x46,0x2D,0x28,0x92,0xEC,0x38,0xD3,0x35,0xBF,0x39,0xF4,0xE1,0x74,0xD7,0xFC,0xE6,0xD0,0x46,0x52,0x79,0xF3,0x9B,0x45,0x1F,0x49,0x2D,0x28,0x12,0xCA,0xDD,0x45,0x64,0xC3,0xFF,0x15,0x55,0x05,0x39,0x49};
static  const uint8_t spa_INPUT[]     = {0x23,0x58,0x3A,0x90,0xAB,0x56,0x6F,0x6F,0x79,0x4B,0x19,0x5A,0xE7,0xA2,0xE1,0x15,0x21,0xB1,0x1A,0xEE,0x5A,0x5C,0x24,0x45,0x5B,0x68,0x0B,0x49,0x91,0x14,0x6B,0xA5,0xC5,0xA5,0x49,0x72,0x2D,0x95,0x17,0x92,0x0B,0xE5,0xEE,0x22,0xB2,0x01,0x04,0x10,0xB5,0xA6,0x02,0x72,0x34,0x4D,0x55,0x9C,0xC1,0xAA,0x35,0x39,0xD5,0xA1,0xBB,0x98,0xF7,0xE8,0xD4,0xC6,0xA4,0x85,0x39,0x73,0xC8,0x20,0x94,0xBB,0x8B,0xC8,0x06,0x00,0x05,0x5C,0x91,0xA6,0x01,0x04,0x54,0xDF,0xF0,0x65,0x49};
static  const uint8_t spa_IS[]        = {0xC9,0x5F,0x3E,0x90,0xB2,0x17,0xDF,0xE0,0x04,0xDB,0x04,0x72,0xF5,0xA2,0x13,0x6E,0x1D,0xC8,0xD5,0x8B,0x4E,0xB4,0x5C,0x23,0x65,0x2F,0x3A,0xE9,0x76,0x85,0x1C,0xB5,0xE8,0x94,0x33,0x24,0x89,0xD6,0xA2,0xD5,0xCD,0xD4,0x24,0x54,0x8B,0xC6,0xD8,0x0D,0x4B,0xF8,0xD6,0x29,0x63,0xE2,0x6E,0x9D,0x1D,0x3B,0x8F,0x66,0x3C,0xD0,0xCD,0xA3,0x12,0xDA,0x89,0x01,0x13,0xB0,0x23,0xE0,0x61,0x76,0x04,0x7C,0x4A,0xFA,0x29};
static  const uint8_t spa_J[]         = {0xA1,0xDE,0xDD,0x89,0x30,0xD2,0x68,0x60,0x64,0x2B,0x1A,0xB1,0x45,0x97,0x13,0x75,0x61,0x18,0xBE,0x29,0x4F,0xD4,0x95,0x53,0x45,0x67,0x3A,0xD1,0xF0,0xC1,0x61,0xD1,0xEA,0xC4,0x43,0x17,0x67,0x64,0xEB,0x93,0x74,0xE3,0xDC,0x91,0xAD,0x4F,0xDA,0x83,0x4A,0x78,0x35,0x39,0x79,0x0F,0x2A,0xE5,0x59,0x67,0x55,0xDD,0xA9,0x54,0xD6,0x92,0xD5,0x0E,0x13,0x14,0x13,0x8D,0xC7,0x58,0x95,0xE8,0x4C,0x57,0x2E,0x63,0x35,0x6C,0x33,0x5D,0x25,0x8D,0xCD,0x90,0xD5,0x74,0xE8,0x3C,0x86,0xB1,0x08,0x8E,0xEB,0x35,0xFD,0x69};
static  const uint8_t spa_K[]         = {0x06,0xA8,0x86,0x99,0x01,0x2D,0x10,0x0D,0x7F,0x04,0xC5,0x0C,0xB7,0x72,0xBC,0xE6,0xD9,0xDB,0x2A,0xEE,0x71,0x47,0x48,0x0E,0xB7,0x25,0x37,0x38,0x71,0xF7,0x26,0x15,0x39,0xE7,0xA4,0x3D,0xA9,0x94,0x65,0xDD,0x53,0xB4,0xC0,0xDE,0x51,0xD5,0x4E,0xDD,0xBD,0x72,0x55,0xCC,0x39,0x6D,0x77,0xCA,0xD5,0x39,0xA7,0xB5,0xCD,0xB1,0x74,0xF7,0xD4,0xD6,0xF7,0x28,0x1C,0x5D,0x75,0xDA,0x38,0x92,0x90,0x77,0xCD,0xAE,0x63,0x19,0x7B,0x22,0xCE,0x9A,0x2A,0xFF,0x4D,0x51,0x69};
static  const uint8_t spa_KEY[]       = {0x09,0xE8,0x9C,0xCD,0x01,0x93,0x4B,0x38,0x60,0x6A,0xD5,0x61,0x4F,0x27,0xE8,0x35,0xB6,0x87,0xB3,0xBC,0x81,0xD5,0xD6,0x59,0xEE,0xB2,0x0A,0xD1,0x9B,0x64,0xFB,0x2B,0x3C,0x56,0xC1,0x7A,0x63,0xCF,0x68,0xE4,0xDB,0x2B,0x48,0x6F,0xEC,0x99,0x97,0x7A,0x07,0x01,0x9D,0xB1,0x5D,0x6B,0xD7,0x2D,0x4D,0x18,0xD3,0x72,0xFE,0x19};
static  const uint8_t spa_L[]         = {0x23,0x1A,0x59,0x35,0xD5,0xEB,0xAC,0xA4,0x05,0xC9,0xF0,0xAA,0x73,0x92,0x16,0xD5,0xC3,0xBA,0xCA,0xC9,0x5A,0xF1,0x72,0x8E,0x2A,0xA7,0xA8,0x25,0xDA,0xD9,0xE7,0x9C,0xBA,0xC6,0xEC,0x14,0x5E,0xB3,0xBA,0xE2,0xB3,0x5D,0x69,0x73,0xE9,0xB3,0xB3,0x09,0x91,0xDD,0xA5,0x4F,0x2E,0x3A,0xD9,0xF2,0xA4,0x21,0x79,0x5B,0xA7,0xE8,0xEC,0x86,0x50,0xA2,0x59,0xBA,0xB5,0x1B,0x42,0x8E,0x32,0xAA,0xD6,0x61,0x8C,0xC5,0x5B,0x70,0x1A,0xAB,0x31,0x05,0x6B,0xA1,0x6A,0xFC,0x51,0x71,0x25,0x41,0x19};
static  const uint8_t spa_LARGE[]     = {0xA1,0xEA,0x60,0xD8,0x3D,0x6F,0x95,0xBA,0x83,0x96,0xF4,0xBC,0xD5,0xAA,0x0D,0x4A,0xC2,0xEC,0x61,0x2B,0x26,0x68,0x71,0xF7,0x07,0x2B,0x9B,0xB0,0x34,0x55,0x36,0x9D,0x38,0x9B,0x51,0x37,0x7F,0x78,0xE2,0x62,0xC7,0xDC,0x6C,0xE3,0x89,0xB2,0xF9,0x34,0xD5,0x16,0x27,0xCE,0xE6,0xD2,0xC5,0x5A,0x9C,0x24,0xE7,0x4B,0x17,0x6B,0xB1,0xD2,0x5C,0xAE,0xDC,0xB4,0xE1,0xCA,0x73,0xDD,0x72,0x95,0x46,0xA7,0xCC,0xA9,0xCA,0x8D,0x1B,0xAE,0x3A,0xB5,0x4A,0x57,0x6D,0x38,0xBA,0xD4,0xAB,0xC2,0x64,0xD1,0x1A,0x73,0xAE,0x4C,0xE5,0x85,0x6B,0xCA,0xB9,0x22,0x54,0x16,0xB6,0x29,0xC7,0x8C,0x10,0x7B,0x14,0xA6,0x94,0xA4,0xD4,0xA7,0xA1,0x9A,0x93,0x71,0x31,0x8B,0x54,0x64,0x12,0xCA,0xDD,0x45,0x64,0x03,0x02,0x9A,0x23,0x11,0xC0,0x68,0xEB,0x0A,0x58,0x75,0x4C,0x02,0x04,0x18,0x6B,0xFC,0xFF,0x15,0x65,0x41,0x19};
static  const uint8_t spa_LAST[]      = {0xA1,0x4D,0xA0,0x6D,0xCC,0x17,0x96,0xA6,0x80,0xB1,0x8C,0x58,0x58,0x9B,0x55,0x75,0x56,0x96,0xA6,0x9B,0x56,0xD5,0xE4,0x44,0x19,0xAE,0x3A,0x75,0x55,0x9D,0x95,0xB4,0xF9,0xD6,0xA7,0x2E,0xAE,0xB3,0x1D,0x37,0x9F,0xA6,0x98,0xA9,0x0A,0xEA,0xBD,0x9B,0xD5,0x54,0x3D,0x99,0x41,0xBD,0x47,0x93,0x5D,0x79,0x51,0x56,0x76,0xF5,0xA1,0xE5,0xE1,0xA2,0xD8,0x00,0x17,0x8B,0x69,0x40,0x00,0x8F,0x91,0x52,0x00,0x81,0x22,0xB8,0x8B,0x88,0x6C,0x60,0xC0,0x91,0x14,0x0C,0x58,0x5C,0xED,0xFF,0x51,0x39,0x49,0x19};
static  const uint8_t spa_LINE[]      = {0xA1,0xAC,0x20,0xB9,0x2D,0x57,0x97,0x62,0x81,0xE0,0x0C,0x7B,0x58,0xF2,0x01,0x42,0x3A,0xED,0x45,0x4B,0x27,0x48,0xB7,0x8A,0x95,0x23,0x99,0x20,0x2D,0x4A,0x57,0x9D,0xA8,0x8B,0xD5,0x94,0xB8,0x79,0xA2,0x6A,0xCE,0x43,0x7D,0xE6,0x89,0x4B,0xF8,0x08,0x8B,0x5A,0x27,0x2D,0x75,0xC3,0xBD,0x2A,0x9F,0xAC,0xDA,0x4F,0xB7,0xA8,0x75,0xF2,0x29,0x67,0xC2,0x3C,0xE5,0x29,0xA7,0xE9,0xAA,0x90,0x54,0xA7,0x9A,0xBE,0x3D,0x52,0x5A,0x9D,0x66,0xC5,0x51,0x49,0x6B,0x74,0xFA,0x95,0x46,0x30,0xA2,0xD1,0x18,0x66,0x2E,0xE4,0xCA,0xCA,0x6D,0x58,0x21,0x89,0x3A,0x23,0x87,0xA1,0x70,0xB5,0x71,0x4D,0xEA,0x07,0x33,0x24,0x61,0xB9,0x6A,0x49,0xFE,0x59};
static  const uint8_t spa_M[]         = {0x2B,0x1B,0x41,0x55,0x3B,0x9A,0x9C,0x64,0x85,0x34,0x4E,0x6B,0x73,0xA2,0xAD,0x52,0xB4,0xBD,0xD1,0x89,0xA6,0x4E,0xF6,0xF1,0x46,0x27,0x9E,0x32,0x38,0xD6,0x5A,0x9D,0x74,0x86,0x11,0x2F,0x6A,0x74,0xB2,0x61,0xDB,0x23,0xB1,0xF3,0x28,0x7B,0x96,0x18,0x10,0xBB,0xB9,0x73,0x43,0xD2,0x92,0x81,0xBE,0x56,0x0D,0xD1,0x58,0x18,0x56,0x17,0x35,0x78,0xEF,0x26,0xDA,0x4D,0xCC,0x10,0xAD,0xA6,0x52,0x77,0x31,0x43,0x50,0x9A,0x49,0xD1,0x36,0x74,0x39,0x86,0x2B,0x59,0xAD,0xFF,0x4D,0x39,0x41,0x59};
static  const uint8_t spa_MANY[]      = {0xAE,0x4D,0x9A,0xEC,0x2C,0x62,0xC7,0xAA,0x54,0x49,0x93,0x6D,0x78,0xE2,0x55,0xF5,0x10,0xA4,0x6E,0xAD,0x4E,0x3D,0x5D,0xB3,0xBA,0xAD,0x3A,0xF5,0xF0,0x2D,0x6A,0xBE,0xEA,0xD4,0xD3,0xA7,0x98,0xF9,0xAA,0xD4,0x54,0x43,0xD2,0xDA,0xB1,0x52,0x9D,0x25,0xEB,0x69,0x85,0x59,0xF5,0xF0,0x4E,0xA6,0xB1,0xE8,0x34,0xD3,0x16,0x71,0xE5,0xC2,0x53,0x2F,0xDB,0x44,0x99,0x2B,0x47,0xDD,0xA3,0x92,0x47,0x8F,0xAE,0xF5,0xFF,0x65,0x55,0x39,0x49,0x59};
static  const uint8_t spa_MINUS[]     = {0xAE,0x48,0xCA,0xB4,0x51,0xB6,0xE4,0xA2,0x65,0xD9,0x84,0x25,0xE2,0x96,0x99,0xAE,0xA4,0xEA,0x4B,0x53,0xF1,0x79,0xE2,0xA6,0xB7,0x43,0xAD,0xE5,0x89,0xBA,0xDC,0x0E,0x8D,0x94,0x27,0x1A,0x6A,0x32,0xDC,0x5A,0x9E,0x68,0xD9,0x16,0x0F,0x4F,0x78,0xE2,0xE5,0x97,0xC5,0x22,0xE1,0xCA,0x96,0x1B,0x16,0xA9,0x98,0xAD,0x6C,0x52,0xA9,0xC5,0xA3,0x94,0xA6,0x28,0xD5,0x92,0x48,0xDC,0xDA,0x16,0x22,0xD8,0xAA,0x76,0x1B,0x9B,0x75,0x37,0x8D,0x39,0x69,0x4C,0x26,0x3C,0x6D,0x1A,0x87,0x31,0x45,0x13,0xF3,0xAD,0x25,0x80,0x0D,0xD4,0x05,0xF0,0x39,0x8B,0x00,0xBE,0x10,0x36,0xC0,0xE7,0xEC,0x1A,0xE0,0x00,0x07,0x08,0xF0,0xAD,0xD0,0xFF,0x51,0x25,0x79,0x59};
static  const uint8_t spa_MORE[]      = {0xA6,0x2A,0x06,0xA3,0xD1,0x9D,0xE5,0xAA,0x97,0x2D,0xCA,0xEC,0xCA,0x8C,0xF2,0xAC,0x28,0x93,0x4F,0x53,0xEE,0xB9,0xA2,0x4C,0xBE,0x44,0x35,0xE7,0x8A,0x0B,0xDA,0x15,0xF1,0x5C,0x2B,0x29,0x70,0xD7,0xD5,0x7C,0xAF,0x2C,0x91,0x5B,0x17,0xF3,0xB3,0xF2,0x82,0x67,0x5D,0xC4,0xCF,0xAA,0x0A,0x99,0x35,0x51,0xBF,0xA3,0xC9,0xB4,0xD7,0x83,0xF2,0xB6,0x2E,0x89,0x59,0x75,0xEA,0x5B,0xC6,0xA8,0x77,0xC4,0x79,0x4F,0x1A,0x83,0xDB,0x16,0xE3,0xCD,0x65,0x0C,0x7E,0x4B,0x4C,0x36,0x97,0x31,0x9A,0x6D,0x75,0xEE,0x5D,0xC6,0x50,0x3B,0x54,0x75,0xD3,0xFF,0x15,0x65,0x55,0x59};
static  const uint8_t spa_MUST[]      = {0xA1,0xCD,0x9E,0xCA,0xC1,0x93,0xB5,0x26,0x3B,0x89,0x04,0x69,0xD3,0xEA,0xEC,0x24,0x0A,0xB4,0xED,0xA8,0xB3,0xD7,0x48,0x90,0x36,0xA3,0xCE,0x5E,0xA3,0x80,0xD2,0x9C,0xBA,0x84,0xC9,0x0A,0xCC,0x74,0xEA,0x6A,0x26,0x23,0x25,0xD3,0xA9,0x9B,0x9E,0x8A,0x94,0x4E,0xA7,0x6A,0x66,0x2A,0x93,0x5B,0xAD,0xAA,0x04,0xAF,0xE0,0xA8,0xDD,0xEA,0x49,0x32,0xDC,0xCC,0x93,0x02,0x2E,0xE6,0x10,0xC0,0x13,0xE4,0x0A,0x78,0x96,0x5C,0x03,0x02,0x78,0x82,0x1C,0x81,0x22,0xB8,0x8B,0x88,0x6C,0x10,0xC0,0x15,0x69,0x12,0x40,0x40,0xF1,0xA9,0xFF,0x39};
static  const uint8_t spa_N[]         = {0x27,0x9E,0x71,0x99,0x3D,0x16,0x9D,0x68,0xBA,0x22,0xCB,0xAC,0x75,0xA2,0xE9,0x92,0x22,0x73,0xD6,0x89,0xA6,0x2F,0xF2,0xC8,0x59,0x27,0x59,0x61,0x55,0x4D,0x6A,0x9D,0x7C,0xBB,0x52,0x0D,0xAD,0x35,0xAA,0xAE,0x9D,0x5A,0x3C,0x76,0xAB,0xBB,0x72,0x1A,0x0E,0x3B,0xA5,0xED,0x2A,0x68,0x30,0x9D,0x96,0xBE,0x69,0xE7,0xC1,0x54,0x53,0x87,0x3A,0xD4,0xA1,0x0C,0x4D,0xBB,0x14,0xBA,0xDB,0x34,0x14,0x1F,0x62,0x16,0xB1,0x42,0x57,0x8C,0x49,0x8A,0xC5,0xFC,0x51,0x59,0x41,0x39};
static  const uint8_t spa_NAME[]      = {0x24,0x56,0x3C,0xA2,0x3D,0x12,0xAB,0x82,0x99,0xD8,0x96,0x48,0x62,0x32,0x6E,0x7C,0x9B,0xD3,0x8D,0x49,0x95,0xD2,0x6B,0x49,0x3B,0x21,0xF1,0x52,0xFA,0xA5,0xEC,0x9C,0x68,0x89,0xC0,0xD6,0xAA,0x74,0xA2,0xA5,0x8A,0xD3,0xAA,0xD6,0x09,0xA7,0x29,0x4A,0xCB,0x5A,0x27,0x9A,0x2A,0xB9,0xA2,0x6A,0x9F,0x68,0x9A,0xA4,0xCC,0xAA,0x7D,0xD2,0xE5,0x0A,0xCD,0xBB,0xF6,0xC9,0x67,0x4C,0xD4,0x98,0x3A,0xAB,0x1A,0x5E,0xD0,0x7B,0xEA,0x8C,0x76,0x3A,0x03,0xED,0x9E,0xDD,0xDA,0xE1,0x14,0xAD,0x6A,0x96,0xEB,0xAA,0x10,0xA9,0xF4,0x26,0x66,0x48,0x5A,0x32,0xD0,0xD7,0x9A,0x21,0x69,0xAA,0x62,0x4F,0x62,0x87,0xFF,0x51,0x35,0x49,0x15,0x41,0x71,0x51,0x39};
static  const uint8_t spa_NEGATIVE[]  = {0x26,0x2E,0x4C,0x24,0xCC,0x13,0xC5,0x32,0x14,0x49,0xD0,0x9C,0xA4,0x9B,0x92,0x25,0xC9,0x33,0x9C,0x6E,0x46,0x32,0x94,0x91,0x7B,0x2C,0x3E,0xD1,0x74,0x21,0x6E,0xD1,0xF8,0x84,0xCB,0x26,0x9B,0x7B,0xE3,0x13,0x4C,0x93,0xE8,0x9D,0xAB,0x46,0x30,0x4A,0x41,0x44,0xCE,0x22,0x49,0xD7,0x06,0x16,0xB5,0x7A,0x64,0xDD,0x15,0x87,0x8A,0xE2,0x95,0x75,0xA3,0xD0,0x13,0xB5,0x56,0xDA,0x94,0x70,0x75,0xD4,0x26,0x9D,0x50,0xEE,0x2E,0x22,0x1B,0x0C,0xB0,0xA8,0x85,0x03,0x16,0x0B,0x0D,0xED,0x16,0x4E,0x5A,0x16,0xBB,0xB4,0xC3,0x2A,0xA5,0x57,0x9D,0x32,0x74,0x27,0x1C,0x59,0x73,0xC2,0xD2,0x8D,0x70,0x65,0xCE,0x76,0x4B,0x33,0x22,0xE5,0x39,0xCB,0x2D,0xD5,0x93,0xA5,0xD5,0x2C,0x33,0x67,0x23,0x5A,0x5A,0x35,0xC5,0x5C,0x55,0x88,0xA9,0x35,0x36,0xF3,0x70,0xA9,0xA9,0xAA,0x98,0x00,0x4D,0x9B,0xFC,0x75,0x51,0x39};
static  const uint8_t spa_NEW[]       = {0xAE,0x88,0x82,0xB6,0x2D,0xD5,0xA4,0x3A,0x49,0xF5,0xA1,0x8C,0xDB,0xEB,0x52,0x27,0x25,0xF6,0x62,0x75,0x47,0xDD,0xB5,0xA2,0x6D,0x55,0x1E,0xF9,0x74,0x09,0x34,0xB9,0xA8,0xC5,0x53,0x19,0xE8,0x75,0xE5,0x11,0x0C,0x67,0x60,0x5B,0x0F,0x8F,0xDF,0x64,0xB0,0x87,0xAF,0xDE,0xC1,0x88,0x0A,0x1F,0x55,0xD6,0x57,0x23,0x8D,0x6C,0x54,0x35,0x56,0xA6,0xC2,0x89,0x73,0x31,0xDF,0xE4,0x5A,0xE1,0x4E,0xCD,0xF2,0x91,0x1B,0xB4,0x3A,0x13,0xF3,0x26,0x66,0x64,0x61,0x2D,0xD4,0x93,0xE8,0xF1,0xFF,0x79,0x39};
static  const uint8_t spa_NO[]        = {0xAC,0xEF,0xCC,0xD9,0x25,0x6C,0xBB,0xB6,0x50,0xD1,0xC7,0x74,0x17,0x9A,0x42,0xD9,0x1E,0xD3,0x5D,0xAA,0x2B,0x51,0x7D,0x2C,0x77,0x29,0xAF,0xC4,0xF4,0x31,0x93,0xB7,0xAC,0x81,0xE4,0x63,0xAD,0x7F,0xD2,0x2E,0x5B,0x4D,0xBC,0xD1,0x89,0x9B,0x6E,0x33,0xF5,0x4D,0x27,0x6B,0x26,0x3D,0xD8,0x56,0x9F,0xA2,0xEA,0x0E,0x53,0xDB,0x74,0xAA,0xA6,0x32,0x42,0xE5,0xD3,0xEE,0xC7,0xD8,0x44,0xA7,0x19,0x7E,0x0E,0x53,0x32,0xE3,0x6C,0xF6,0x28,0x8C,0xC1,0xB7,0x19,0xE5,0x9C,0x38,0xDA,0xF1,0xFF,0x15,0x79,0x39};
static  const uint8_t spa_NOT[]       = {0xA1,0xCD,0x9A,0xA3,0x71,0xEC,0xA6,0x36,0x1B,0xCA,0xA4,0x56,0x9A,0xDA,0x6A,0xB1,0x4D,0x4B,0x73,0x6E,0x4F,0xDD,0x9C,0x7B,0x91,0xA5,0x3D,0x75,0x75,0xD3,0xE6,0x9C,0xFA,0x34,0xC5,0xEC,0xB8,0x4B,0xE6,0xD3,0x14,0xB3,0x6B,0xAE,0x69,0x4E,0x5D,0xCC,0x4E,0x98,0x64,0x3E,0x75,0x71,0x33,0xE6,0x9C,0xA9,0x95,0x39,0x44,0xB9,0x48,0x23,0x53,0x64,0xB7,0xE9,0xE2,0x19,0x51,0x2B,0x82,0xBB,0x88,0xC8,0x06,0x60,0xC0,0x15,0x69,0x1C,0x40,0x40,0xF1,0xA9,0xFF,0x75,0x79,0x39};
static  const uint8_t spa_NOW[]       = {0xAE,0x2A,0x92,0x7A,0x28,0x9D,0x86,0xA2,0x48,0xF4,0xA7,0x72,0x56,0xF2,0x2A,0xC8,0x5E,0xD2,0x5E,0xC9,0x2A,0x53,0x7E,0xB5,0xEA,0x27,0xEE,0xBA,0x3C,0xC4,0x3A,0x9E,0xA8,0xEB,0xC9,0x52,0xCD,0x78,0xA2,0xA6,0xB7,0x52,0xAD,0xE5,0x89,0x9A,0xBA,0x0E,0xB5,0x8C,0x27,0xE9,0x6A,0x27,0xCD,0x52,0x9E,0xAC,0xA9,0xED,0x32,0xCD,0x78,0xEA,0xAE,0xB6,0xD3,0x35,0xD7,0x69,0x9B,0xDE,0xCE,0x94,0xCE,0x6B,0xAC,0xEE,0x2A,0x93,0x36,0x8D,0xB1,0xB8,0xCD,0x08,0xDA,0x54,0xA7,0x32,0xA6,0x54,0x1E,0xA2,0xB7,0xC2,0x14,0x73,0x8B,0x85,0xDD,0x32,0x53,0xC8,0x2D,0x2E,0xFE,0xEA,0xFF,0x25,0x51,0x21,0x59,0x55,0x39};
static  const uint8_t spa_NUMBER[]    = {0xA6,0x0A,0x42,0x72,0xB9,0xDC,0x84,0x32,0x0A,0x89,0xA3,0x72,0x13,0xF2,0xC0,0x35,0x0E,0xDB,0x4D,0x49,0x13,0x57,0x3D,0xAA,0xA4,0x27,0xAE,0xAE,0xC3,0x25,0x12,0x9F,0xA8,0xBA,0x2D,0x37,0x4F,0x74,0x82,0x62,0xAF,0xC3,0x3C,0xD5,0xF1,0x8B,0xBD,0x0E,0xB5,0x44,0xCB,0xAF,0x72,0xAD,0x91,0xDC,0xAC,0xA0,0xCA,0xB1,0x46,0x4A,0x33,0x82,0x6C,0x46,0x03,0xA4,0x4B,0x8A,0xB2,0x0C,0x2B,0x90,0x2D,0x2A,0x33,0xD2,0xB2,0xC4,0x3E,0x8B,0xCA,0xCA,0xD2,0x10,0x5F,0xD5,0xAA,0xE2,0xDB,0x8C,0x65,0x53,0xAB,0x73,0x09,0x57,0xAE,0xDB,0x6D,0x28,0xB1,0xDC,0xC5,0x1F,0xB7,0x29,0x87,0xF0,0xD0,0xBE,0x94,0xE7,0xB0,0x64,0x1F,0x16,0x5A,0x53,0xEC,0xFA,0x79};
static  const uint8_t spa_O[]         = {0x2B,0xC9,0x21,0xCD,0x2C,0x1F,0xEE,0xE4,0xA4,0xC5,0x54,0x9A,0xE9,0xA6,0x9B,0xAE,0x2C,0xBB,0x4A,0x55,0xDB,0xB4,0xB3,0x95,0xA7,0xD4,0x2E,0xEA,0xAB,0x67,0xDE,0xF2,0x68,0xC7,0x4D,0x74,0x63,0x29,0x82,0x5E,0x4F,0xD4,0x9D,0xB9,0x08,0x95,0xB1,0xE7,0x2E,0xB6,0xD1,0x57,0xA6,0x52,0x69,0xD4,0xB5,0x16,0xAA,0xCA,0xB7,0x54,0xE1,0x1C,0xFD,0x69,0x61,0x79,0x19,0x61,0x72,0x79};
static  const uint8_t spa_OCLOCK[]    = {0x2B,0xAB,0xA6,0xC3,0x9D,0x37,0xAF,0x3C,0x87,0x0C,0x17,0x79,0xD5,0x8A,0x38,0x9D,0xDD,0x7A,0x16,0x2A,0x84,0x72,0x77,0x11,0xD9,0x00,0x00,0x06,0x28,0xA5,0x3B,0x00,0x5D,0x6B,0xA4,0x60,0x59,0x0D,0x09,0x55,0x32,0xBC,0xA4,0x35,0x4B,0xAD,0xD1,0x70,0x73,0xF6,0x16,0xD7,0x29,0x2B,0xCC,0xAD,0xCA,0x4D,0x67,0xAD,0x2C,0xF5,0xAE,0x50,0x9D,0x38,0x86,0xD4,0x3B,0x4B,0x65,0x65,0x98,0xD2,0x4B,0x75,0xF3,0xDA,0x64,0x12,0xCA,0xDD,0x45,0x64,0x03,0x00,0x00,0x28,0x20,0x15,0x23,0x02,0xE4,0xE4,0x8C,0x80,0x2C,0x07,0xFE,0x31,0x79};
static  const uint8_t spa_OF[]        = {0x2B,0x2E,0x6E,0x3A,0x95,0xBA,0x9C,0x28,0xFB,0xCB,0x10,0x5B,0x75,0xA3,0x13,0x67,0xFF,0xE5,0xAC,0xAB,0x57,0x92,0xE2,0x76,0x8A,0x36,0x1E,0x69,0x4A,0x5B,0x26,0xBE,0x78,0xD4,0x29,0x4D,0xBB,0xE8,0xE2,0xD4,0xC6,0x51,0x29,0x5A,0xB7,0xD2,0x10,0x72,0x8E,0x71,0xD7,0x72,0x63,0x52,0xE9,0xAE,0xDA,0xDA,0x8F,0x6E,0x2A,0x3A,0xDD,0x94,0x6D,0xEB,0xE9,0xFF,0x31,0x31,0x79};
static  const uint8_t spa_OFF[]       = {0xCD,0xCB,0x7E,0x52,0x55,0x1A,0xAD,0x28,0xFB,0x2B,0x33,0xCD,0x74,0x83,0x13,0x66,0xF7,0xA5,0x6A,0xAD,0x56,0x5C,0xF4,0x4E,0x38,0x75,0x6E,0x79,0x0A,0x5B,0xA6,0xF2,0x28,0xB5,0xA1,0x8E,0x9B,0xC5,0xEC,0xD0,0x27,0x97,0x19,0x6A,0x8D,0x14,0x50,0x6C,0x87,0x00,0x9A,0x6D,0x67,0xC0,0x34,0xE9,0x04,0x98,0xA6,0x82,0x00,0xCD,0x55,0x10,0xA0,0x9B,0x70,0x04,0x54,0x53,0xFE,0x11,0x19,0x79};
static  const uint8_t spa_OLD[]       = {0xA9,0x68,0x21,0xBC,0x44,0x1A,0xAF,0xB2,0x98,0x88,0x34,0x7D,0xBC,0xCB,0x55,0xA5,0x54,0xA6,0x1A,0xB7,0x56,0x9D,0x5D,0xBA,0xB1,0x3E,0x1E,0x75,0x8C,0x11,0x42,0xFD,0x78,0xD6,0xA3,0x89,0xAA,0xC3,0x94,0x37,0xF7,0xA6,0x34,0xD1,0x58,0x1B,0x4B,0xDF,0xDA,0xA4,0xBA,0x58,0xEC,0x04,0x4F,0x9F,0xEB,0x5C,0x87,0x2A,0x59,0x2E,0xC7,0x74,0x1F,0xDA,0x5C,0x28,0xCC,0x5C,0x0B,0x19,0x85,0x72,0x77,0x11,0xD9,0xE0,0xFA,0x6D,0xDC,0xC5,0xD4,0x4D,0xEA,0x9B,0x17,0x77,0x73,0xDB,0xFF,0x39,0x79};
static  const uint8_t spa_ON[]        = {0x25,0x2A,0xF6,0xC6,0xD4,0xE3,0x9C,0xB0,0x89,0xDD,0x14,0x4B,0x7C,0x82,0x2A,0x6E,0x8D,0xA3,0xD6,0x09,0x8A,0xFC,0x51,0xCE,0xD8,0x37,0x3A,0x71,0x76,0x37,0xAA,0xDE,0xF8,0x64,0x39,0xDE,0xA8,0x7A,0xE3,0xD5,0xA4,0x71,0x29,0xEE,0xB5,0x4B,0x5F,0xDC,0x26,0x9B,0x2D,0x29,0x43,0xB6,0x15,0xC2,0x91,0x38,0x0C,0x91,0xA7,0x47,0x58,0xE3,0x30,0x06,0xE9,0x51,0x9A,0x8D,0xDD,0x14,0x94,0x7B,0x69,0xA6,0x76,0x63,0x94,0x1A,0x23,0x9E,0xDA,0x8D,0x51,0x9A,0xBB,0x56,0x9A,0xFF,0x4D,0x19,0x39,0x79};
static  const uint8_t spa_ONLY[]      = {0x29,0x2B,0xC1,0xDD,0xA4,0x66,0x9F,0xA8,0xEB,0xB2,0x34,0xD9,0x7C,0xA2,0xA6,0xDA,0x5C,0xA5,0xD5,0x09,0x9B,0x2C,0x73,0xD5,0x4D,0x2B,0xC8,0xAA,0xD5,0x2D,0x5E,0x0E,0x3F,0xA9,0x88,0x50,0xDB,0x34,0x82,0xA2,0xC2,0x1A,0x35,0x5D,0x0B,0x0A,0x17,0x5B,0x75,0xF7,0x25,0x2A,0x92,0x62,0x34,0xDC,0xA7,0x28,0x49,0xEA,0xD4,0x4A,0x92,0xB2,0x28,0xB9,0xCD,0x3B,0x51,0xC9,0x33,0x97,0x48,0xAD,0x96,0xB9,0x68,0x75,0xB6,0x6A,0x19,0x5B,0x79,0xF4,0xCD,0x99,0xBA,0xD7,0xE2,0x36,0x34,0xA3,0x96,0xD5,0xB3,0xDD,0x58,0xB4,0x7A,0xE7,0x46,0xB2,0xD3,0xFF,0x25,0x79};
static  const uint8_t spa_OR[]        = {0x25,0xCA,0xEC,0xCA,0x8C,0xF2,0xB4,0x28,0x93,0x4F,0x53,0xEE,0x39,0xA2,0x4C,0xBE,0x44,0x35,0x67,0x8B,0x0B,0xDA,0x15,0xF1,0x5C,0x23,0x29,0x70,0xD7,0xD5,0x7C,0xCF,0xA4,0x65,0x89,0xDC,0xBA,0x98,0x9F,0x96,0x17,0x3C,0xEB,0x22,0x7E,0x5A,0x93,0x69,0xAF,0x07,0xE5,0x2D,0x5D,0x12,0xB3,0xEA,0xD4,0x37,0x8D,0x51,0xEF,0x88,0xF3,0x9E,0x30,0x06,0xB7,0x2D,0xC6,0x9B,0xFF,0x05};
static  const uint8_t spa_P[]         = {0x0E,0x18,0x5D,0x29,0x79,0x95,0x93,0x6E,0x8D,0x98,0xE1,0x4E,0xC3,0x54,0x35,0x76,0x97,0xBB,0x8C,0x81,0xF7,0xD4,0x19,0xF1,0x75,0x01,0x5C,0x3B,0x7B,0x64,0x3B,0x05,0x50,0x4E,0xED,0xD6,0xEC,0x68,0xC0,0xBD,0x95,0x7B,0x97,0x87,0x38,0xFD,0x25,0x51,0x15,0x51,0x59,0x41,0x25,0x41,0x05};
static  const uint8_t spa_PARAMETER[] = {0x04,0xD0,0xA2,0x3D,0xA5,0xC5,0xA7,0x9B,0x6B,0xCD,0x91,0xE6,0x21,0x85,0xE3,0x71,0x7B,0xDA,0xB2,0x1C,0xB8,0x38,0x3C,0x6E,0xCA,0xD2,0xC5,0x32,0xF5,0xB6,0x31,0x6B,0x69,0x39,0x6C,0x61,0xE9,0x65,0x45,0xA5,0x5B,0x71,0x45,0xA3,0x13,0xD4,0x9C,0x11,0x9A,0x8D,0x4E,0xD0,0xEC,0x46,0xBA,0xD5,0x5A,0x49,0x89,0x9E,0x42,0x39,0xB9,0xE4,0xC9,0x49,0x31,0x74,0xBB,0x92,0x67,0x23,0xA5,0x50,0xDD,0x4A,0x9E,0x8C,0xB4,0x42,0xAE,0x3B,0x65,0x2D,0x5E,0xC6,0x3E,0xA5,0xB5,0xD5,0x69,0x28,0xC7,0x62,0xD2,0x0A,0xE5,0xEE,0x22,0xB2,0x41,0x01,0x9B,0x65,0x1A,0xA0,0xE0,0xF0,0xD6,0x24,0xEF,0x96,0xDA,0xB5,0xCE,0xD0,0x82,0x7B,0xAA,0xAE,0x1E,0x53,0x4D,0x15,0xA1,0xF2,0xB8,0x8D,0x25,0x57,0x84,0xEA,0xE2,0x32,0x96,0x9C,0x11,0xEC,0x93,0xFF,0x51,0x61,0x39,0x51,0x05};
static  const uint8_t spa_PENCE[]     = {0x02,0x28,0x46,0xAA,0xB9,0x23,0x1B,0xBB,0x69,0x98,0xE5,0x17,0x2B,0x59,0x96,0x71,0x4F,0xB0,0xC2,0x88,0xA5,0x34,0x3E,0xC9,0x76,0x23,0x96,0xDA,0xE8,0x64,0xC7,0x8E,0x7B,0x48,0xA3,0x55,0x4E,0x53,0x12,0x26,0x89,0x5B,0xDD,0x94,0x4B,0xA9,0xC4,0x29,0x6D,0x51,0x6A,0xC5,0x19,0x27,0xF5,0x45,0xB1,0xAF,0x78,0x5C,0xD5,0x27,0x21,0xB9,0x16,0x95,0x09,0x90,0x61,0x1A,0x01,0x3E,0x43,0x16,0xC0,0x67,0x22,0x0A,0xF8,0x4C,0x4D,0x01,0x9F,0xAA,0x09,0xE0,0x53,0x55,0x02,0x7C,0xA9,0xFC,0x51,0x65,0x41,0x51,0x19,0x05};
static  const uint8_t spa_PLEASE[]    = {0x06,0xC8,0xD6,0x4C,0x01,0x45,0x8B,0x05,0xFB,0x18,0x56,0xAA,0x70,0xD2,0x82,0xC3,0x95,0x2D,0x7D,0xF5,0x0C,0x96,0xB7,0xB5,0x81,0xB6,0x36,0x59,0xC1,0xB4,0x06,0xDA,0x55,0x65,0x25,0xCB,0x1B,0xE8,0x76,0xED,0x91,0xCD,0x44,0x50,0xD3,0x95,0x47,0x31,0x87,0x82,0x76,0xCD,0x6A,0xED,0xEA,0x06,0x3C,0xDD,0x28,0x75,0xAB,0x3B,0x50,0xF5,0xAC,0xD4,0xCF,0xA1,0xC0,0x5D,0xB3,0x52,0x3F,0xBB,0x01,0x77,0xD5,0x2E,0xFD,0x6C,0x06,0xDC,0x35,0x3B,0xF5,0x33,0x0B,0x68,0xF7,0xEC,0xD4,0x8F,0x20,0x60,0xD9,0xB3,0x53,0xDF,0xA4,0x50,0x7A,0x57,0x0E,0x5D,0xC7,0xC1,0xE1,0x39,0xDB,0xB4,0x5F,0x93,0xB8,0x64,0x13,0xDB,0x32,0x60,0x01,0x32,0x02,0x7C,0xC1,0x8A,0x80,0xAF,0x44,0x10,0xF0,0x8D,0x39,0x02,0xBE,0x90,0xFA,0x65,0x55,0x19,0x05};
static  const uint8_t spa_PLUS[]      = {0x02,0xF0,0xD6,0xCC,0x01,0x51,0x8B,0x8D,0xA2,0x29,0x65,0x4B,0x5F,0x3D,0x8B,0x51,0x34,0xB3,0x99,0x2E,0x0B,0x4F,0xD9,0xF4,0x66,0x84,0xB6,0x3C,0x75,0x35,0x93,0x91,0x92,0xE9,0x54,0xCD,0x4C,0x65,0x72,0xAB,0x55,0x95,0xE0,0x15,0x1C,0xB5,0x5B,0x3D,0x49,0x86,0x9B,0x79,0x52,0xC0,0xC5,0x1C,0x1A,0xD0,0x80,0x06,0x04,0xF0,0x04,0xF9,0xFF,0x15,0x39,0x49,0x79,0x05};
static  const uint8_t spa_POINT[]     = {0x02,0xC8,0x5A,0x5C,0x00,0x45,0x4E,0x25,0xB7,0xF0,0x2C,0x4D,0x74,0xDC,0xDC,0xD8,0x26,0xDD,0x65,0xE6,0x70,0x93,0xDF,0xCA,0xA0,0x8E,0xD3,0x5D,0x5E,0x0E,0x9B,0x19,0xD4,0xF2,0x64,0xD3,0x94,0x69,0x51,0xAA,0x53,0xAC,0x34,0x4A,0x65,0xB5,0x4A,0x3B,0x32,0x69,0x85,0x5B,0x2B,0x7D,0x57,0x6A,0x59,0xE4,0xC6,0x0C,0x45,0xA8,0xB6,0x69,0x5A,0x32,0x09,0xE5,0xEE,0x22,0xB2,0x01,0x00,0x14,0x70,0x45,0x9A,0x06,0x10,0xD0,0x7C,0xC3,0xFF,0x51,0x35,0x49,0x15,0x49,0x65,0x79,0x05};
static  const uint8_t spa_POSITIVE[]  = {0x02,0xF0,0x3E,0xA5,0x45,0x45,0x57,0x5A,0xB0,0xEA,0x15,0xA4,0x56,0xAA,0xA6,0x35,0x57,0x90,0xCA,0x54,0x3A,0xA7,0x3C,0x41,0x8E,0x5B,0x61,0x92,0x69,0x87,0x23,0xAA,0xFC,0xC4,0xC4,0x56,0x05,0x20,0x81,0x8D,0x94,0x5D,0xAC,0x21,0xAA,0x6E,0x56,0x32,0x49,0x8A,0x99,0x6D,0x3A,0xE9,0xE0,0x2E,0x1E,0xB6,0xAA,0x15,0x4D,0x98,0xB8,0xC5,0x22,0x32,0x08,0xE5,0xEE,0x22,0xB2,0x41,0x01,0x57,0xB2,0x19,0x60,0x33,0xB5,0x92,0x54,0x66,0x52,0x13,0xB5,0x47,0x3D,0x9C,0xA1,0x67,0x34,0x6E,0x43,0xF7,0xCC,0x99,0x31,0x3B,0xCD,0xCD,0x91,0x56,0xE4,0x9C,0xB0,0x14,0xE3,0xA6,0xAE,0xBB,0xDD,0x5A,0xAD,0x9A,0x39,0xF7,0x41,0x40,0xB3,0x6A,0xFF,0x5A,0x39,0x55,0x79,0x05};
static  const uint8_t spa_POUN_[]     = {0x04,0xA0,0x4E,0x54,0x01,0x2E,0x98,0x36,0x2B,0xD9,0x09,0x0F,0xAA,0xB5,0x9C,0xBC,0xB2,0x5C,0xA3,0xF4,0xF1,0x4B,0xED,0x4C,0xB3,0x45,0x27,0xC8,0x75,0x32,0x4D,0x17,0x9E,0xA8,0xC4,0xCD,0x32,0x69,0x79,0xE2,0x92,0xB6,0xD2,0xB9,0xE3,0x48,0xF3,0x88,0x51,0xCE,0xCA,0x2D,0xCF,0x23,0xD5,0x35,0x67,0xB6,0x32,0xE5,0x52,0xB3,0x5C,0x59,0x9A,0x94,0xD2,0xC5,0x62,0x63,0xEA,0x62,0xB6,0x42,0xED,0x46,0xA9,0x2F,0x8A,0xBA,0x28,0xB2,0xA4,0xA1,0x48,0xAA,0xE5,0x48,0x1B,0x86,0xA4,0xA4,0x82,0x3D,0x4D,0x1C,0xFC,0xE0,0x87,0xFF,0x65,0x65,0x51,0x25,0x05};
static  const uint8_t spa_PRESS[]     = {0x04,0xA8,0x34,0x9D,0x01,0x2D,0x44,0x0A,0x20,0xF7,0xAC,0x60,0xA7,0x2E,0xA6,0xE6,0x76,0xAA,0xBB,0xBC,0x3C,0x28,0xBD,0xAC,0xC9,0xF1,0x6B,0x31,0x37,0xD7,0x35,0x27,0x6A,0x21,0x34,0xC2,0x56,0x9F,0x7C,0xF8,0x12,0x0B,0x59,0x7D,0x9A,0x19,0x4A,0x34,0x65,0xCD,0x6A,0x87,0x77,0x89,0xD4,0x25,0xA9,0x6F,0x8E,0x7C,0x3C,0xEA,0x08,0x20,0x73,0x53,0x01,0x7C,0x25,0xC6,0x80,0x4F,0xD5,0x08,0xF0,0x0D,0x1B,0x03,0xBE,0x21,0x63,0xC0,0x57,0x6C,0x04,0xF8,0x42,0x92,0x00,0x4F,0x90,0x22,0xE0,0x7B,0x56,0x04,0x7C,0x47,0x82,0x80,0xEF,0x84,0x11,0xF0,0x03,0xE9,0xFF,0x59,0x41,0x25,0x71,0x79,0x25,0x05};
static  const uint8_t spa_PROGRAMME[] = {0x0C,0x48,0x2E,0x95,0x03,0x2E,0x0A,0x8D,0x3D,0xDA,0x13,0xD5,0x68,0xF9,0xA9,0x73,0x68,0xC7,0x94,0x13,0x94,0x62,0xA9,0xC6,0xAB,0x4F,0x50,0x63,0x84,0x19,0xAD,0x3E,0x41,0x0B,0xEE,0x6E,0xB8,0xE9,0x04,0xD5,0x69,0x84,0xF0,0xAB,0x11,0x66,0xE7,0x66,0x22,0xAF,0x5C,0x14,0xA3,0x2B,0xAB,0x2E,0x34,0xA9,0x54,0x19,0x1D,0x96,0x4A,0xE5,0x3E,0xAB,0xB8,0x44,0x9C,0x50,0xA7,0x66,0x21,0xA4,0x71,0x52,0x95,0x33,0x17,0x66,0xA7,0x1D,0x75,0x69,0x1A,0x94,0xE9,0x75,0xB5,0xA5,0xA9,0x9B,0xE7,0x9A,0x33,0xB4,0xD8,0xE1,0xC1,0x5D,0xCE,0xD8,0xFC,0x44,0x24,0x75,0x3E,0x53,0x8B,0xE5,0x19,0xBC,0x78,0xCC,0x35,0x76,0x64,0xF2,0xED,0x36,0xD7,0x54,0x51,0xCE,0xB3,0xEB,0x1C,0xE6,0xEC,0x34,0x0C,0xAC,0x89,0x9F,0xED,0xF2,0x45};
static  const uint8_t spa_Q[]         = {0x0E,0x58,0x5E,0xD8,0x00,0x3B,0xAA,0x3A,0x60,0xB5,0xF1,0x16,0xF4,0x82,0x54,0xD1,0x65,0x5A,0x3C,0xB4,0x42,0x6E,0x2F,0xDA,0xF1,0x8A,0x9B,0x0C,0xF6,0xF0,0xD5,0x2B,0x29,0x7C,0x54,0x59,0x5F,0xED,0x64,0xA4,0x59,0x1C,0x93,0xFA,0xA6,0x52,0x24,0xB1,0xAA,0x6C,0xAF,0x42,0xE5,0xC5,0x89,0x44,0xAE,0x76,0x95,0x36,0xC7,0xEA,0xB9,0xCA,0x34,0x4A,0xBF,0x70,0xE4,0x12,0xD3,0x28,0xF5,0x2C,0x11,0x8B,0x55,0x2B,0xC2,0xB2,0x69,0x2E,0x96,0xED,0xFF,0x25};
static  const uint8_t spa_R[]         = {0x23,0x2C,0xEE,0x2A,0x8C,0x57,0xAE,0x28,0xC7,0x4F,0x33,0x5D,0xB8,0xB2,0xEC,0xAF,0xD2,0x78,0xD5,0xCE,0x46,0x53,0xCC,0x74,0x25,0x6E,0xEE,0x7D,0x19,0xAA,0xDA,0xF1,0xC4,0xCD,0x7D,0xE8,0x73,0x9F,0xFB,0x5C,0x86,0xA2,0x7F,0x2C,0x79,0x55,0x1D,0xD2,0x98,0xE6,0xA6,0xAB,0x8D,0xCE,0xE3,0xFF,0x11,0x51,0x25};
static  const uint8_t spa_RED[]       = {0xAA,0xE6,0xBE,0x2D,0x32,0x1C,0x9B,0x4A,0xB8,0x36,0x77,0x73,0x62,0x0A,0x9E,0xDD,0x3C,0xC2,0xB1,0xCB,0x64,0x08,0xF5,0x8C,0xC6,0x29,0x76,0x8D,0x2C,0x3D,0x5A,0x8F,0xA0,0x78,0x0E,0x6F,0x5F,0x74,0xFD,0xE3,0x8F,0x60,0x6A,0xE9,0xAD,0x4F,0x38,0x6D,0x8A,0xA5,0xB7,0x3A,0xF1,0x30,0xCE,0x59,0xB9,0xF8,0x64,0x23,0x38,0x47,0x46,0x93,0x53,0x77,0x67,0x12,0x15,0x4B,0x4E,0xD7,0x9C,0x89,0x77,0x2E,0x1A,0x7D,0x73,0x62,0x56,0x35,0xC9,0x8D,0xCD,0x90,0x86,0x57,0x2D,0x35,0x24,0x49,0x9A,0xD9,0x91,0xC8,0x20,0x94,0xBB,0x8B,0xC8,0x06,0x37,0x6D,0xE3,0x2E,0xA6,0x6E,0xD2,0xD0,0xBC,0xB8,0x9B,0xDB,0xFE,0x15,0x51,0x65,0x51,0x25};
static  const uint8_t spa_RESET[]     = {0xAA,0xF0,0x4D,0x54,0x22,0x5B,0xFB,0xAC,0xC5,0x49,0x53,0x66,0x5A,0xCB,0x15,0x76,0xCB,0xA8,0x1B,0xAD,0x56,0x70,0x8C,0x21,0xCF,0x34,0xDA,0xC1,0x76,0x9B,0xBB,0xAC,0x83,0xCC,0x34,0x72,0x7E,0x93,0x42,0x39,0x3D,0x4B,0x01,0x17,0xBB,0x69,0x40,0x00,0x8F,0x85,0x09,0xE0,0xCA,0x0C,0x01,0x5C,0x16,0x29,0x80,0x2B,0x23,0x0C,0xB0,0x69,0x7A,0x2B,0xAA,0x16,0x1B,0xA9,0xD8,0xAB,0x6F,0x56,0x75,0xDC,0x67,0xAF,0xA1,0x7B,0x93,0x4A,0x5B,0x3C,0xC6,0x91,0x42,0xD3,0x74,0x71,0x9A,0xAA,0x93,0x68,0xEB,0x29,0x6C,0x11,0xCA,0xDD,0x45,0x64,0x03,0x28,0x60,0x28,0x77,0x01,0x3C,0x23,0x29,0x80,0x6B,0xD4,0x09,0xB0,0x98,0x27,0x02,0x0A,0x2D,0xFB,0x39,0x25,0x55,0x15,0x51,0x25};
static  const uint8_t spa_RETURN[]    = {0xA1,0x8A,0x26,0xD5,0x38,0xB3,0xA4,0x3C,0x26,0xF2,0x08,0xEB,0x3D,0x92,0xEC,0x29,0x2D,0x63,0xD3,0x4A,0x9A,0x27,0xD7,0x8A,0x8E,0xA1,0x6B,0x91,0x8C,0xAD,0x12,0x93,0x4C,0x28,0x77,0x17,0x91,0x0D,0x00,0x06,0x58,0xCA,0xDC,0x01,0x1D,0xB5,0x35,0xBF,0xB0,0x90,0x88,0xA8,0x75,0xFC,0x64,0xDD,0xCB,0xAA,0xD6,0xF1,0x9B,0x0F,0x77,0xD5,0x56,0xC7,0x6F,0xA1,0x23,0x45,0x33,0x9D,0xA0,0xFA,0xF6,0x54,0x6B,0x79,0xA2,0xEA,0xCB,0x42,0x7D,0xD5,0x49,0x6A,0xEC,0x70,0xD5,0x56,0x27,0x6F,0xBE,0x3D,0xC5,0x5A,0xAE,0xAA,0xA6,0x48,0x97,0x58,0xB4,0xBA,0xE6,0xCB,0x53,0xB5,0x65,0x19,0x4A,0xF0,0x70,0xA9,0x49,0x69,0x2C,0x31,0xDC,0x34,0x27,0xA5,0xA9,0xC6,0x0A,0x33,0xAF,0x95,0xE6,0x16,0x23,0xC5,0x3D,0x51,0x98,0x9A,0x13,0x33,0x89,0x44,0x61,0x6A,0xCC,0x34,0x52,0xDD,0xFC,0x39,0x55,0x25};
static  const uint8_t spa_RUN[]       = {0x22,0x11,0xAE,0x5C,0xA3,0x94,0x98,0x4A,0xB8,0x0E,0xF7,0x92,0x67,0x0A,0x1E,0xDB,0x4D,0x5B,0xA9,0xC9,0x79,0x49,0xD3,0x0C,0x27,0x21,0x35,0x49,0xCD,0xBB,0xD8,0x8E,0x38,0x35,0x71,0x2D,0xF7,0x70,0xE2,0x12,0x2F,0xDD,0xB5,0xD1,0x49,0xAA,0xBD,0x72,0xB7,0x96,0x27,0x6B,0x76,0x2B,0xC2,0x5A,0x9D,0xA2,0x86,0xAE,0x50,0x6B,0x54,0xFA,0x62,0x2C,0x42,0x3C,0x76,0x1A,0xB2,0x36,0x0B,0xF5,0x46,0x61,0xC8,0x4A,0xB3,0xD8,0x12,0x87,0x21,0x49,0x8D,0x21,0x4F,0x13,0x86,0xA4,0x24,0x5A,0x3C,0x75,0x1A,0x8B,0x0D,0x53,0xF5,0xD8,0xFF,0x71,0x39,0x49,0x39,0x39,0x55,0x25};
static  const uint8_t spa_RUNNING[]   = {0x22,0x11,0xAE,0x5C,0xA3,0x94,0x98,0x4A,0xB8,0x0E,0xF7,0x92,0x67,0x2A,0x1E,0xDB,0x4D,0x5B,0xA9,0x29,0x78,0x49,0xD3,0x0C,0x27,0x21,0x37,0x49,0xCD,0xBB,0xD8,0x8E,0x38,0x35,0x71,0x2D,0xF7,0x70,0xA2,0x92,0xB3,0xCC,0x35,0xD5,0x89,0x6A,0xD8,0x0C,0x8D,0x94,0x27,0x6C,0x7E,0x32,0x38,0x5D,0xAE,0xB0,0x7B,0x0F,0xC5,0xF6,0xD8,0xA2,0xCA,0x4D,0x9A,0x5B,0x75,0x49,0x0B,0x75,0x59,0x2A,0xB5,0x2B,0x99,0xCE,0xD1,0x7D,0x22,0x8F,0x7A,0x78,0x25,0xCF,0xA9,0x3C,0xBA,0x15,0x1A,0xA5,0xAA,0x52,0x1A,0x66,0x12,0xE8,0xAE,0xD0,0x7A,0x52,0x53,0x96,0x1A,0x45,0xD6,0x54,0x4D,0x49,0x6A,0x1A,0x79,0x56,0x35,0x66,0xC5,0xE5,0xE4,0x59,0xD4,0x10,0x95,0x95,0x6A,0x64,0xD6,0x83,0x1D,0x5C,0x5F,0x9C,0x4B,0x88,0xD9,0xF1,0x03,0x02,0x9C,0x51,0xFD,0x65};
static  const uint8_t spa_S[]         = {0x2D,0x9E,0xC9,0x85,0x3B,0x16,0xAF,0x68,0x87,0x31,0x4A,0x6B,0x74,0xC2,0xA5,0x8B,0xA4,0xA3,0xD1,0x89,0x96,0x4E,0xF2,0xF1,0x46,0x27,0x99,0x26,0xC9,0xC7,0x17,0x9F,0x62,0x85,0x11,0x69,0x6D,0x7D,0xEA,0x11,0x82,0xBD,0x74,0xF5,0x6A,0xBB,0x57,0xA9,0xF0,0x25,0x0C,0x08,0x46,0x52,0x00,0xDF,0xA7,0x69,0x40,0x01,0xDF,0xA5,0x71,0x80,0x00,0x3F,0xA4,0x51,0x00,0x01,0x3F,0xA5,0x61,0x00,0x03,0xFF,0x51,0x59,0x41,0x65};
static  const uint8_t spa_SAME[]      = {0x02,0xB8,0x54,0xCC,0x02,0x06,0x38,0x8C,0xDD,0x02,0x27,0x5D,0x22,0xB0,0xB5,0x2A,0x9D,0x74,0xA9,0xE2,0xB4,0xAA,0x75,0x92,0x69,0x8A,0xD2,0xB2,0xD6,0x49,0xA7,0x4A,0xAE,0xA8,0xDA,0x27,0x9D,0x26,0x29,0xB3,0x6A,0x9F,0x72,0xB9,0x42,0xF3,0xAE,0x7D,0xEA,0x19,0x13,0x35,0xA6,0xCE,0xEA,0x86,0x17,0xF4,0x9E,0x3A,0x6B,0x9A,0xCE,0x40,0xBB,0x67,0xB7,0x69,0x38,0x45,0xAB,0x9A,0xE5,0xE6,0x2A,0x44,0x2A,0xBD,0x89,0x5B,0x93,0x96,0x0C,0xF4,0xB5,0x6E,0x4D,0x9A,0xAA,0xD8,0x93,0xD8,0x35,0xCC,0xD9,0x70,0x1B,0x79,0xDB,0xFF,0x51,0x25,0x79,0x61,0x65};
static  const uint8_t spa_SCORE[]     = {0x06,0xF8,0x46,0xCB,0x00,0x4F,0x79,0x28,0xE0,0x3B,0x75,0x03,0xFC,0xE0,0xE1,0x80,0xEB,0xAC,0x11,0x28,0x94,0xBB,0x8B,0xC8,0x06,0x05,0xA4,0x51,0xC4,0x80,0x78,0x87,0x8B,0x17,0xF3,0x90,0x9A,0x37,0x3A,0x6E,0xC1,0xD3,0x96,0x94,0xFB,0x78,0x05,0xF5,0x78,0xB1,0xDF,0x13,0x64,0xB2,0x6D,0x41,0x79,0x4E,0x94,0xE9,0xB6,0x39,0xE5,0x59,0x99,0xF7,0x97,0x66,0xB2,0x69,0x14,0x3E,0x4E,0xB8,0xC8,0xAA,0x52,0xFB,0x5C,0x95,0x68,0xAF,0x4B,0x6B,0x7A,0x47,0x50,0x5E,0x2E,0x9D,0xA9,0x55,0x41,0xB1,0xB8,0x74,0x3E,0x66,0x27,0xE9,0x9A,0xD6,0x7B,0xDF,0x55,0xC2,0x5D,0x5B,0x1F,0x5C,0x75,0x33,0x6F,0x6D,0x7D,0xF4,0x55,0xC9,0xB2,0xA5,0x75,0xC9,0x59,0x85,0xFA,0xE6,0x3A,0xFC,0x11,0x39,0x79,0x61,0x51,0x65};
static  const uint8_t spa_SECOND[]    = {0x02,0xD8,0xD4,0x53,0x01,0x97,0x6B,0x28,0xE0,0x4B,0x8B,0x62,0x1F,0x92,0xE6,0xA1,0x8E,0x8F,0x5B,0x9D,0x6B,0x6A,0xCD,0x3E,0x7E,0x0F,0xA5,0xA9,0x56,0x7B,0xC5,0x2D,0xB9,0x96,0xE4,0x1C,0xE4,0x0B,0xE5,0xEE,0x22,0xB2,0x01,0x04,0x90,0x7B,0x50,0x29,0xB3,0x73,0x36,0xF7,0x2A,0xA5,0x2D,0x21,0x54,0xB9,0x2E,0xA7,0xBE,0xD8,0x70,0xE3,0xD8,0xE4,0xC6,0x24,0xCD,0x9A,0xB2,0xB5,0x9B,0xB2,0x11,0x0F,0xF2,0xCC,0x66,0xCA,0xCA,0xCC,0xD9,0x72,0x9B,0xB1,0x08,0xD1,0xB2,0xD0,0x62,0xC6,0xC4,0xCD,0xDA,0x3C,0x35,0x02,0x85,0x72,0x77,0x11,0xD9,0x10,0xA6,0x11,0x22,0xA2,0x44,0x76,0x98,0xB6,0x71,0x17,0x53,0x37,0xFF,0x19,0x19,0x41,0x59,0x65};
static  const uint8_t spa_SMALL[]     = {0x04,0xF8,0x8A,0x85,0x03,0x12,0x10,0xC0,0xB7,0xA6,0x26,0x0E,0x3E,0x2C,0x50,0xBB,0xD8,0x38,0x46,0x35,0x6C,0x41,0x56,0xE2,0x43,0xD2,0x6C,0x04,0x99,0x67,0x96,0x51,0x9E,0x15,0x24,0x36,0x6D,0xAA,0x79,0x4F,0x98,0xF8,0xB6,0xAA,0xE5,0x59,0x51,0x12,0xDB,0xA6,0x9C,0x67,0xA5,0x89,0xED,0x98,0x5A,0x9E,0x91,0x67,0x3A,0xAB,0xAA,0x7E,0x47,0x9D,0xD8,0xAE,0xBB,0xF8,0x1B,0x43,0x25,0xB9,0x9E,0xE4,0x2F,0x8D,0x51,0xCC,0x7A,0x43,0xDF,0x30,0xFB,0x32,0x69,0x2A,0x3B,0xC3,0xEC,0x73,0xA7,0x1A,0xEF,0x4E,0xB3,0x8F,0xD1,0x2E,0xD2,0x37,0x4D,0x21,0xF8,0x04,0x5B,0xD6,0x30,0x46,0x6F,0xEB,0x22,0xD9,0xDC,0x18,0xA2,0x8F,0x61,0x65,0x31,0x63,0x72,0x36,0x09,0x91,0xF6,0xFF,0x15,0x25,0x41,0x15,0x65};
static  const uint8_t spa_START[]     = {0x08,0xD8,0x50,0x05,0x01,0x5F,0xB1,0x12,0xE0,0x33,0x55,0x06,0x7C,0xEE,0x66,0x80,0x6F,0x54,0x19,0xF0,0x65,0x18,0x07,0x10,0x28,0x94,0xBB,0x8B,0xC8,0x06,0x03,0x6C,0x96,0x36,0x9C,0xAA,0xD3,0x5D,0xBC,0xD3,0xF1,0x8A,0x52,0x6F,0xE9,0x28,0x27,0x28,0xF1,0x32,0x24,0x3C,0x9D,0x28,0xC7,0x4B,0x97,0xF0,0x74,0xD2,0x9C,0xAE,0x4D,0x23,0xE3,0x2D,0x56,0x95,0xF3,0xB6,0x85,0x76,0x5A,0x5D,0x2E,0xDB,0x1A,0xB6,0x6A,0x8C,0xB9,0x4C,0xAA,0xEB,0xC2,0x36,0x95,0x18,0x15,0x2A,0x0B,0xCB,0x54,0x83,0x8E,0x9B,0xB4,0x24,0x93,0x50,0xEE,0x2E,0x22,0x1B,0x00,0x18,0x70,0x94,0x3A,0x03,0x5E,0x66,0x53,0xC0,0x51,0x96,0x04,0xD8,0x42,0x02,0x01,0x8D,0xBA,0xFD,0x05,0x79,0x15,0x65};
static  const uint8_t spa_STOP[]      = {0x08,0xF8,0x92,0x8D,0x00,0x5F,0x89,0x32,0xE0,0x6B,0x35,0x01,0x7C,0xAD,0x2A,0x80,0xEF,0x55,0x04,0xF0,0xA3,0x08,0x01,0xBE,0x13,0x46,0xA0,0x50,0xEE,0x2E,0x22,0x1B,0x1C,0xB0,0x8D,0xD5,0x70,0x9B,0xCE,0x10,0xB3,0x4E,0x27,0xCC,0xB1,0x3D,0x59,0x33,0x9F,0x38,0xC7,0xA9,0x74,0xD3,0x7D,0xB3,0x51,0xA4,0x58,0x9D,0xC9,0xB9,0x51,0x23,0x94,0xBB,0x8B,0xC8,0x06,0x00,0x60,0x80,0x57,0x96,0x04,0xC8,0xCE,0x1D,0x01,0x79,0x84,0x22,0xC0,0x3B,0xF7,0xFF,0x09,0x61,0x15,0x49,0x75,0x65};
static  const uint8_t spa_SWITCH[]    = {0x08,0xB8,0x84,0x95,0x01,0x5F,0x73,0x30,0xE0,0x73,0x0B,0x01,0x7C,0xE9,0xA6,0x80,0x2F,0x22,0x05,0xF0,0xB5,0xB8,0x02,0xBE,0x51,0x53,0xC0,0x6F,0x66,0x02,0xE8,0x3A,0x2B,0x78,0x89,0x47,0xB8,0x89,0x97,0xE2,0x47,0xB5,0x2A,0xA1,0x9F,0x4E,0xD0,0x69,0xAA,0x25,0xAD,0x3E,0xD1,0x94,0xC1,0x3A,0xBA,0xF9,0x14,0x33,0x05,0x69,0xD9,0xE2,0x52,0x0F,0xAF,0xA4,0x59,0x8F,0x51,0x23,0x94,0xBB,0x8B,0xC8,0x06,0x00,0x02,0x74,0x69,0x2E,0x80,0xD3,0x42,0x0C,0x70,0xC6,0x84,0x03,0x76,0x9B,0x72,0xC0,0x1A,0x9B,0x06,0x58,0xF5,0xDC,0x01,0x73,0x6D,0x1A,0x60,0x95,0x4E,0x01,0x8C,0xA8,0x42,0x80,0xAA,0x4C,0x10,0x10,0xA5,0xE9,0xFF,0x15};
static  const uint8_t spa_T[]         = {0x0E,0x38,0xC2,0xD4,0x00,0x57,0xB5,0x36,0x77,0x29,0x26,0xCF,0xB6,0xBD,0xBC,0xE5,0x0C,0xA4,0xA7,0xF6,0xF2,0x97,0x53,0xB0,0xD9,0xC6,0x3B,0x5C,0xC9,0x76,0x0A,0x32,0x5B,0x7B,0x66,0xA3,0xDC,0x41,0x50,0x7A,0x6A,0xB7,0x66,0x27,0x45,0xDA,0x89,0x53,0xFA,0x95,0x18,0x79,0x27,0x4E,0x19,0x56,0x20,0x94,0xEB,0x3A,0x75,0x4C,0xE3,0x74,0x48,0xFE,0x15,0x27,0x8E,0x71,0x74,0xE3,0xF0,0x20,0x3D,0x15,0xC5,0x0D,0xCD,0xA0,0x6E,0x8F,0xED,0xFF,0x39,0x51,0x15};
static  const uint8_t spa_TEN[]       = {0x0E,0x38,0xD4,0x53,0x01,0x8B,0x85,0x68,0x60,0x05,0xDD,0x29,0x5B,0xBA,0xE9,0x1B,0x9D,0x68,0xE6,0x62,0x73,0x6F,0x7C,0xA2,0x19,0x46,0x34,0xBC,0xD1,0x49,0x56,0x68,0xD1,0xB4,0xC5,0x27,0x1F,0x39,0xC5,0xCD,0x67,0x9F,0xB2,0x3B,0xD3,0x8C,0x9C,0x33,0x9A,0xEE,0x4C,0x5D,0x62,0x4E,0xEA,0xAB,0x61,0x4B,0x49,0xB9,0xA9,0xCF,0x4A,0xBC,0x34,0xED,0x84,0x21,0x69,0x4D,0xD7,0x74,0x15,0x86,0x24,0xDC,0xCA,0x4A,0xB1,0x1B,0x92,0x94,0x28,0x4B,0x55,0x6E,0x48,0x52,0xC2,0x33,0x55,0xFF,0x69,0x39,0x41,0x09,0x15};
static  const uint8_t spa_THANK[]     = {0x08,0xC8,0xDC,0x15,0x01,0x4D,0xA8,0x10,0x60,0xF2,0x50,0x01,0x74,0x93,0x3A,0x9C,0xEA,0x5D,0x8B,0x27,0xF6,0x71,0x87,0x2A,0x2E,0xB7,0xC5,0xC7,0x1B,0x7E,0xB4,0xD4,0x26,0x9D,0xA8,0xA7,0xB2,0x94,0x0A,0xBD,0x92,0x5E,0x3C,0x42,0xCB,0xCC,0x68,0x9B,0x09,0xAD,0x54,0xDB,0x65,0xC8,0xC6,0x75,0xD1,0x92,0xF8,0xD1,0x8C,0xC9,0x98,0x17,0x59,0x1A,0x54,0x08,0xE5,0xEE,0x22,0xB2,0x01,0x08,0x50,0x7B,0x38,0x03,0x4A,0x08,0x16,0x40,0x89,0x46,0xFF,0x15,0x41,0x09,0x15};
static  const uint8_t spa_THAT[]      = {0x6C,0x18,0x34,0x25,0xC5,0x57,0xEA,0xC6,0xD5,0x9D,0x06,0x85,0x4A,0x97,0x50,0x77,0x96,0xEC,0xC2,0x6D,0x4A,0xD5,0x65,0x51,0x30,0x35,0x19,0x51,0xD7,0x49,0xCD,0x71,0x7B,0x45,0xC3,0x26,0xB5,0xFA,0xE2,0x93,0xCC,0xD0,0x5C,0xAA,0x8D,0x4F,0x3E,0x72,0x69,0x99,0x36,0x3E,0xD5,0xC8,0xED,0x19,0xD2,0x64,0xB5,0xA3,0x64,0x96,0xE9,0x92,0xD1,0xB7,0xE2,0x19,0x9A,0xB3,0x48,0x2F,0x94,0xBB,0x8B,0xC8,0x06,0x00,0x00,0x05,0x5C,0x91,0xA6,0x01,0x04,0x34,0xDF,0xF0,0x51,0x09,0x15};
static  const uint8_t spa_THE[]       = {0xA6,0x48,0xB2,0x28,0xA4,0x26,0xBB,0x3C,0xA9,0xA4,0xE0,0x6C,0x5C,0xD2,0x2A,0x8B,0x83,0x64,0xF1,0x8A,0x3A,0x1F,0x71,0x91,0xC7,0xCB,0xEF,0x74,0xD9,0xC3,0x1F,0x2D,0x7F,0x88,0x96,0x34,0x7D,0x75,0xFC,0xA1,0xD6,0x52,0x79,0xD5,0x89,0x86,0x1C,0x0B,0x93,0xCD,0xA7,0xE8,0x76,0x3C,0x9D,0x56,0xEF,0xA6,0xB5,0xD5,0x87,0xA7,0xFA,0x94,0xFF,0x39,0x51,0x09,0x15};
static  const uint8_t spa_THEN[]      = {0xA6,0x4B,0x24,0x24,0xCD,0x6A,0xD9,0xCE,0xF5,0x99,0x84,0xB8,0xBB,0xEB,0x3C,0x8C,0x6A,0xC8,0xC2,0x30,0x7F,0x7C,0xEA,0x61,0x83,0xD2,0xFC,0xD1,0x69,0xBA,0x4E,0xCA,0x8C,0x57,0xA7,0xED,0x26,0xD9,0xD3,0x3F,0x9D,0x66,0xD8,0x66,0x4B,0xDD,0x74,0x9A,0x69,0x47,0x2C,0x74,0xD5,0x6A,0xA6,0x1E,0x75,0xD7,0xD6,0xA3,0xED,0xC6,0xB1,0xD9,0xE3,0xB6,0xB6,0x1B,0xC5,0xE1,0x74,0x3A,0x9A,0xAE,0x0C,0x9B,0xCB,0xE9,0x68,0x86,0x0C,0x28,0x49,0x67,0xFF,0x11,0x25,0x49,0x09,0x15};
static  const uint8_t spa_THIRD[]     = {0x08,0x28,0xAA,0x8C,0x02,0x0C,0xC8,0xBA,0x8D,0x01,0x4D,0x86,0x1B,0xA0,0xE9,0xB6,0xE3,0x16,0x53,0x9A,0xE2,0xB3,0x8F,0x5D,0x55,0x6A,0x99,0xDD,0x3E,0x76,0x93,0xA5,0x19,0xF6,0xF8,0xB8,0x43,0x97,0xA6,0xF2,0xEA,0xE3,0x77,0xD3,0x96,0xAA,0x8B,0x4E,0xD4,0x74,0x69,0x98,0x3F,0x3E,0x79,0xF3,0xE9,0x29,0x3E,0xE7,0x54,0x2D,0x79,0x1A,0xD7,0xD4,0xD3,0xB6,0xE8,0xE1,0x12,0x73,0x4E,0x57,0xA3,0x87,0x4B,0xCE,0x59,0x7D,0x0B,0xEE,0x21,0x36,0x67,0x0C,0xCD,0xBA,0x85,0xDB,0xE2,0x36,0x54,0x6F,0xEE,0x56,0x97,0xDB,0x58,0x8D,0x7A,0x5A,0x4E,0x2E,0x63,0x51,0x1A,0x15,0x39,0x49,0x8C,0x49,0x8A,0xBA,0x76,0x45,0x36,0x46,0xEA,0x96,0x9E,0x31,0x15,0xD0,0x95,0x85,0x00,0x96,0x90,0x44,0x40,0x96,0xE1,0xFF,0x65,0x49,0x09,0x15};
static  const uint8_t spa_THIS[]      = {0xAA,0xF2,0xD2,0x6C,0xA4,0x2A,0xAA,0xCA,0x4B,0xB5,0xB6,0x6C,0x18,0xCA,0xAA,0x94,0x53,0xB4,0xF1,0x8A,0x3B,0x0B,0xEC,0xD2,0x45,0x27,0xEC,0xDC,0x71,0xCA,0x67,0x9D,0x68,0x48,0xC7,0xE9,0x58,0x74,0xD2,0x69,0x13,0x22,0x63,0xF1,0xA9,0x86,0x35,0xEC,0xCC,0xC5,0xAD,0xEE,0x5E,0x68,0xE4,0xE2,0x2A,0x20,0xE3,0x10,0x01,0x2C,0x62,0x66,0x80,0xC7,0xDC,0x15,0xF0,0x98,0x94,0x00,0x3E,0xB7,0x10,0xC0,0xA3,0x96,0x0C,0xF8,0x42,0x9D,0x01,0xDF,0x09,0x33,0xE0,0x1B,0x31,0x02,0x7C,0xA7,0x42,0x80,0x6F,0x94,0x10,0xF0,0x95,0x39,0x02,0x1A,0x0E,0xFD,0x51,0x59,0x49,0x15};
static  const uint8_t spa_TIME[]      = {0x0E,0x38,0xD0,0xC3,0x01,0x47,0xBB,0x3A,0x20,0xEB,0x8E,0xE6,0x95,0x14,0x61,0x1A,0xA2,0x96,0x97,0x73,0xBB,0x4A,0x59,0x3E,0x7E,0xC9,0x5B,0xAE,0x99,0xE8,0x04,0xD5,0x7C,0x95,0x78,0xAA,0x13,0x34,0x75,0x55,0x1A,0x89,0x4E,0xD4,0xCC,0x56,0xA9,0xB5,0x3A,0x71,0xF3,0x93,0x65,0xD6,0xE8,0xA4,0xC3,0x8F,0xA7,0x6B,0xAB,0x53,0x8D,0x98,0xE2,0xE6,0x8D,0x46,0x35,0x42,0x90,0x65,0xD6,0x69,0xDD,0xF0,0x46,0x5E,0x55,0xBA,0x0C,0x4D,0x89,0x4E,0x45,0xE4,0x30,0x44,0x25,0xD9,0xE2,0xA9,0xFD,0xA8,0xA6,0xA2,0x30,0xDA,0x2C,0xB5,0x9A,0x8B,0xE6,0x70,0xCC,0x36,0xFF,0x4D,0x25,0x15};
static  const uint8_t spa_TRY[]       = {0x06,0x98,0xA9,0x2D,0x01,0x33,0xB5,0x3B,0xA0,0x87,0x8C,0xE6,0xD7,0x10,0xEE,0xC2,0x72,0x86,0x9B,0xA6,0x16,0x95,0x27,0x9C,0xDE,0x09,0x4A,0xDE,0x72,0xF5,0x86,0x27,0xAE,0xEE,0xCA,0xD5,0x53,0x9E,0xAC,0x99,0xAD,0x54,0x4B,0x79,0xBA,0x66,0xB7,0x33,0xA4,0xF5,0x1A,0xAA,0xDB,0x8A,0xD4,0x55,0x6B,0x2C,0x61,0xC3,0xD2,0x66,0x8D,0xA9,0xE4,0x76,0x37,0x9F,0x54,0xA6,0x1A,0x2C,0xC2,0xB2,0x72,0x1A,0xB3,0xD5,0xA8,0xEA,0x32,0x69,0x2C,0x46,0x62,0xAA,0xCA,0x84,0xB1,0x5A,0xB6,0xC9,0x0E,0xEB,0xC6,0x51,0x58,0x34,0x3A,0xAE,0x1B,0x47,0x66,0x89,0x48,0xBB,0xFF,0x51,0x35,0x19,0x51,0x75,0x15};
static  const uint8_t spa_TWELVE[]    = {0x06,0x58,0xCA,0xCC,0x00,0x4D,0x57,0x09,0xA0,0xC4,0x88,0xE4,0x85,0x1A,0x66,0xEA,0xAB,0x9A,0x1F,0x6B,0xAB,0x8B,0x6E,0x3A,0x7E,0x71,0xA3,0x6E,0xBC,0xF9,0x84,0xD5,0x8D,0xBA,0xCB,0xCA,0x13,0x35,0xD5,0xEA,0xA9,0x9B,0x4E,0xD2,0xED,0x78,0x18,0xAD,0x3A,0x45,0x0D,0xE5,0xC9,0xB6,0x7A,0x0C,0x25,0xB6,0x25,0xC5,0xED,0x32,0xE4,0xD6,0x16,0x54,0xB7,0xCB,0x9C,0x83,0x57,0x50,0x2D,0x2A,0x6B,0x76,0x9E,0x89,0xBE,0xAA,0x2C,0x29,0x64,0x18,0x59,0xEA,0xB2,0x24,0x9F,0x69,0xE8,0xA9,0xD3,0x12,0x8D,0x75,0xB1,0x75,0x4D,0x4B,0x8C,0x5E,0x46,0xD6,0x3A,0xCD,0xC1,0xB5,0x86,0xF8,0x66,0x04,0xB0,0x16,0x4A,0x80,0xA2,0xCB,0x10,0x50,0x55,0xDB,0xFF,0x51,0x05,0x4D,0x15};
static  const uint8_t spa_TYPE[]      = {0x0A,0x38,0xB4,0x53,0x01,0xCB,0xA7,0x8F,0xB0,0x9B,0x4C,0x4F,0xB1,0x35,0xBC,0x66,0x32,0xD4,0x59,0xE3,0xF1,0x4A,0xCF,0x72,0xD3,0xCA,0x27,0xAC,0xB9,0x2A,0x5D,0x1B,0x9D,0xAC,0xE5,0x8A,0x72,0x6D,0xB5,0xDA,0x9E,0x52,0xC2,0x7D,0x55,0x1A,0x9B,0x17,0xC9,0xC8,0x56,0x66,0xEA,0x4D,0xC5,0x24,0x6A,0x93,0x49,0x28,0x77,0x17,0x91,0x0D,0x00,0x00,0x80,0x80,0x10,0xD9,0x10,0x90,0x8B,0x19,0x02,0x52,0x11,0xF9,0x55};
static  const uint8_t spa_U[]         = {0xAE,0x5A,0x40,0x2C,0xB7,0xC5,0x84,0x6C,0x42,0xA1,0xD8,0x0D,0x13,0xD2,0x89,0x05,0x6D,0x37,0x74,0x4A,0xA6,0x50,0xB0,0x9B,0x4A,0x2D,0x9E,0xCA,0x40,0xAF,0x2B,0x8F,0x60,0x38,0x03,0xDB,0x7A,0x78,0xFC,0x26,0x83,0x3D,0x7C,0xF5,0x0E,0x46,0x54,0xF8,0xA8,0xB2,0xBE,0x1A,0x69,0x64,0xA3,0xAA,0xB1,0x32,0x15,0x4E,0x9C,0x8B,0xF9,0x26,0xD7,0x0A,0x77,0x6A,0x96,0x8F,0xDC,0xA0,0xD5,0x99,0x98,0x37,0x31,0x23,0x0B,0x6B,0xA1,0x9E,0x44,0x8F,0x6A,0x94,0xE2,0x2B,0x42,0xED,0xA8,0x41,0xA8,0x4F,0x37,0xAD,0xA3,0x06,0xE1,0xD6,0x5D,0x3D,0xAD,0x1A,0x7C,0x6A,0x11,0xC9,0x36,0xFF,0x09,0x55};
static  const uint8_t spa_UH[]        = {0x2B,0x68,0x6E,0xD4,0xD4,0x56,0x9D,0xA0,0xB9,0x75,0x13,0x69,0x75,0x82,0xEA,0x2B,0x5C,0x6D,0xD5,0x89,0x5B,0xC8,0x72,0x95,0x45,0x2B,0xAF,0x3E,0x53,0xDD,0x6E,0x8F,0xBA,0xF8,0x4C,0x75,0xBB,0x5D,0xDA,0x5C,0xC3,0xD5,0x2B,0xD6,0xFF,0x05,0x55};
static  const uint8_t spa_UP[]        = {0x27,0xAA,0x66,0x33,0x5D,0x16,0x9E,0xB0,0xDA,0xCB,0x32,0x9D,0x79,0xA2,0x2A,0x2F,0x23,0xB4,0xE5,0x49,0xBA,0xB8,0xCE,0xE2,0xCE,0xA7,0x6A,0x72,0xBB,0x9A,0xBA,0x94,0x36,0x87,0xCE,0x66,0x59,0x45,0x26,0xA1,0xDC,0x5D,0x44,0x36,0x00,0x00,0x03,0xBC,0x4F,0x13,0x40,0x52,0xA1,0xFF,0x35};
static  const uint8_t spa_V[]         = {0xA6,0x4E,0xCC,0x25,0x42,0x1A,0xB9,0xBA,0x0A,0x23,0x57,0x6E,0xED,0xCA,0xC2,0x94,0x23,0xA4,0xB5,0x2F,0x52,0xD6,0x98,0x61,0xA6,0x35,0x59,0xE1,0xB2,0x01,0xD6,0xD7,0x78,0x45,0xCB,0x1B,0xC8,0x6C,0xEC,0x9D,0xAD,0x7C,0x45,0x03,0x9A,0x89,0x3D,0xAA,0xED,0x98,0x78,0x26,0x76,0x6B,0x76,0x14,0xC2,0x9D,0x3A,0x69,0x58,0x81,0x51,0xAE,0xEB,0xA4,0x71,0x3A,0x22,0xFF,0x8A,0xE3,0xC6,0xAE,0xC1,0x76,0xCA,0xB1,0x1B,0xBB,0x05,0x9F,0x4D,0x3B,0x6E,0x1C,0x11,0xA4,0xA7,0xA2,0xA8,0x61,0x3A,0xA4,0xCE,0x71,0xFA,0x4D,0x25,0x51,0x35};
static  const uint8_t spa_VERY[]      = {0xAE,0xAD,0x4A,0xC8,0x4A,0x53,0xE7,0xB6,0x56,0xAB,0xEC,0xBA,0x48,0xD2,0x37,0x9E,0xA2,0xAB,0x22,0x4F,0xFF,0x78,0x8A,0xEE,0x8A,0x33,0x6C,0xD5,0x29,0xAA,0x37,0x6D,0xCF,0xC5,0xA7,0x6C,0x51,0xAC,0x74,0x56,0xB7,0xAA,0x0F,0x49,0xD2,0xCA,0x5A,0xAA,0x3E,0xC4,0x44,0x6A,0xCD,0xA9,0x7A,0x74,0xD2,0xCC,0xD5,0xA7,0xEA,0x2E,0x50,0x27,0x57,0x9F,0x6A,0xB8,0x44,0x99,0x5A,0xBC,0xAA,0xE9,0x0B,0x25,0x73,0xF5,0x68,0x7B,0x14,0x8A,0xA8,0x59,0xA1,0xAB,0x9A,0xB9,0x22,0xA3,0xFC,0x75};
static  const uint8_t spa_W[]         = {0xA3,0xBF,0x2A,0xC2,0x43,0x64,0xAD,0xA4,0xA8,0x94,0xF4,0x5A,0x7C,0xE2,0xEA,0xC7,0x52,0x6C,0xD1,0x89,0xAA,0x9B,0x4C,0x97,0x4E,0x27,0x2A,0x71,0xB2,0x8C,0x57,0xB5,0x38,0xFB,0x8A,0x14,0x5A,0xA8,0x32,0x6F,0xCA,0x5C,0x28,0xB5,0x2D,0x46,0x51,0xA2,0x85,0x91,0x6E,0x1E,0x75,0x72,0x22,0x13,0xB5,0xB8,0x37,0x65,0xEA,0x96,0xD9,0x3A,0x1B,0x97,0x29,0x2B,0xB6,0x3E,0xAF,0x95,0xE6,0x64,0xC4,0x27,0x6B,0x66,0x98,0xA3,0x95,0x6C,0x8B,0x45,0x61,0x8D,0x26,0x2D,0x4D,0x5F,0xB9,0xD5,0x87,0x56,0x37,0x7B,0xF4,0x15,0x39,0x41,0x75};
static  const uint8_t spa_WANT[]      = {0xAA,0x24,0xBE,0x7D,0x34,0x6C,0x9B,0x9C,0xE6,0xD1,0xF0,0x68,0x58,0xB2,0x80,0x3F,0xDD,0xD4,0xED,0x88,0x23,0xBD,0x6A,0x53,0xBE,0x27,0xCA,0x7C,0xB3,0x4C,0xF5,0x9C,0x28,0xD9,0x2F,0x57,0xF3,0x7C,0xE2,0x94,0xAE,0x5C,0x2D,0xD5,0x29,0xB2,0xDF,0x18,0xD6,0x64,0xBB,0x2E,0x7D,0x56,0x66,0xCE,0x96,0x3B,0x8E,0x64,0x16,0xCA,0xDD,0x45,0x64,0x03,0x80,0x02,0xAE,0x48,0xD3,0x00,0x02,0x9A,0x6F,0xFC,0x65,0x41,0x75};
static  const uint8_t spa_WAS[]       = {0x26,0x33,0x36,0xF3,0x90,0x9C,0x98,0xDC,0xB8,0xCC,0x41,0xE6,0x92,0xF2,0x20,0x22,0x2A,0x4D,0x55,0x2B,0x02,0x9F,0xAE,0x54,0x3C,0xAB,0x48,0xBC,0xBB,0x4A,0xF4,0x8E,0xAA,0xA8,0xED,0x48,0xEC,0x33,0xEA,0xA2,0xA6,0x23,0x61,0xCF,0xA8,0x8B,0x9A,0x8A,0xC4,0xDD,0xA3,0xCE,0x66,0xD3,0x9C,0x36,0xCD,0xAA,0x15,0xD9,0x2C,0x87,0xF8,0xEB,0x52,0x34,0x38,0x62,0x62,0x9B,0x7C,0x27,0x80,0x0D,0xC8,0x18,0x70,0x29,0x0B,0x05,0x30,0xF0,0x51,0x25,0x51,0x75};
static  const uint8_t spa_WERE[]      = {0xAA,0xF0,0x6C,0xA3,0x02,0x7D,0xD9,0xAC,0x44,0x99,0xB7,0x67,0x50,0xAE,0x13,0x26,0xEB,0x5E,0x56,0xB5,0x4E,0xD8,0x7C,0xB8,0xAB,0xB6,0x3A,0x61,0xF5,0xED,0xA9,0xD6,0xF2,0x44,0xD5,0x97,0x85,0xFA,0xAA,0x93,0xD4,0xD8,0xE1,0xAA,0xAD,0x4E,0xDE,0x7C,0x7B,0x8A,0xB5,0x5C,0x55,0x4D,0x91,0x2E,0xB1,0x68,0x75,0xCD,0x97,0xA7,0x6A,0xCB,0x32,0x94,0xE0,0xE1,0x52,0x93,0xD2,0x58,0x62,0xB8,0x69,0x4E,0x4A,0x53,0x8D,0x15,0x66,0x5E,0xEB,0xFF,0x15,0x41,0x09,0x75};
static  const uint8_t spa_WHAT[]      = {0xAA,0xD4,0x2A,0xB3,0x9D,0x59,0x99,0x42,0xDA,0xCC,0x43,0x72,0x62,0x0A,0xE1,0x32,0x07,0x99,0x4B,0xC9,0x03,0xFB,0xCC,0x10,0xAE,0x2B,0x4B,0x6C,0x32,0x53,0xF4,0x9D,0x2C,0xCB,0x29,0x0F,0xF6,0x7B,0xF2,0xAC,0x32,0x27,0x28,0xCF,0x2A,0x8A,0xEE,0xCC,0xC4,0x3C,0xA3,0x2C,0x26,0xB2,0x9C,0x7A,0xB7,0x32,0x7B,0x69,0xB5,0x74,0x83,0x4A,0x11,0xDC,0x45,0x44,0x36,0x80,0x00,0xAE,0x48,0x93,0x00,0x02,0x8A,0x4F,0xFD,0x09,0x61,0x49,0x09,0x75};
static  const uint8_t spa_WHICH[]     = {0x6A,0x62,0x7E,0xD2,0x82,0xD5,0xD8,0x3E,0xB5,0xD6,0xAF,0xB9,0xCA,0xAA,0x51,0x27,0xBE,0xE6,0x2A,0xAB,0x4E,0xD9,0xAD,0xA3,0xB5,0xEC,0x3A,0x65,0x0F,0x49,0x92,0xB6,0x6B,0x15,0x3D,0xB3,0xA8,0x55,0x4B,0x54,0x88,0xE0,0x2E,0x22,0xB2,0x41,0x01,0x73,0x8C,0x29,0x60,0xB6,0x0D,0x05,0xEC,0xDA,0xA1,0x80,0xD9,0xB7,0x14,0x30,0xC6,0x04,0x03,0xC6,0x0C,0xC3,0xC0,0xFF,0x0D};
static  const uint8_t spa_X[]         = {0xAD,0x18,0x21,0x28,0xCA,0x6A,0x9F,0xA0,0x3B,0xA3,0xCA,0xA8,0x7D,0x82,0x61,0x83,0xA2,0x63,0xD1,0x89,0x86,0x0F,0xCA,0xF2,0xC9,0x27,0x1E,0xA5,0xC8,0xD3,0x96,0x8C,0xB4,0x55,0xD1,0xB4,0x6A,0x42,0x0A,0xA1,0xDC,0x5D,0x44,0x36,0x00,0x00,0x18,0x20,0x5D,0x0B,0x07,0x1C,0xD5,0x69,0x80,0xAB,0x2A,0x14,0x70,0x65,0xA6,0x02,0x8E,0x48,0x67,0xC0,0x57,0x1A,0x0C,0xF8,0x41,0x8D,0x01,0xDF,0x89,0x30,0xE0,0x1B,0x66,0x02,0xFC,0xC8,0x46,0x80,0x27,0x38,0x10,0x50,0x69,0xC6,0xFF,0x4D};
static  const uint8_t spa_Y[]         = {0xA2,0x64,0xA6,0x72,0x4C,0x1C,0xA9,0x42,0xB8,0xE2,0xB6,0x48,0xE4,0x32,0xE9,0x5B,0x3D,0x75,0x61,0x4B,0xAD,0xB9,0xB4,0x90,0x5C,0x23,0x4A,0xE6,0x52,0x43,0x73,0xAD,0xA8,0xE8,0xAD,0x48,0xCA,0x75,0xA2,0xAA,0xAF,0x2D,0xC4,0xD3,0x89,0x9B,0xBE,0x0E,0x57,0x4F,0x27,0xAB,0x66,0xDB,0x5D,0x32,0x9E,0xBA,0x9A,0xAD,0x0C,0xC9,0x78,0xDA,0x66,0xB6,0xA2,0xB8,0xD3,0xEA,0x9B,0xD9,0x8A,0xE2,0xCD,0x6B,0x6C,0x66,0xD3,0x4A,0x56,0x8D,0xA9,0xD9,0x71,0x4F,0x99,0x39,0xC6,0x6E,0x43,0x22,0x75,0x71,0x1B,0xBB,0x36,0xAE,0xF1,0x59,0x65,0x6C,0x5A,0xA5,0x37,0x2B,0xA7,0xB1,0x5B,0xE1,0x9C,0xAE,0xF5,0x25,0x41,0x51,0x4D};
static  const uint8_t spa_YEAR[]      = {0x26,0xEF,0x40,0xB5,0xB6,0x69,0x9B,0x6C,0x01,0x91,0xB8,0xA1,0xEC,0xD2,0x05,0x95,0xF4,0x96,0x76,0x48,0x36,0x61,0xD6,0x59,0xDB,0x25,0x3A,0x5C,0x89,0xE7,0x22,0x8F,0x60,0x49,0x07,0xB9,0xAD,0x3D,0xFD,0x15,0x2C,0x97,0x40,0x53,0xAB,0x4E,0xB0,0x5C,0xA2,0x74,0x2E,0x3A,0xD1,0xD4,0x41,0xB6,0xDE,0xE8,0x64,0xD3,0x06,0xC5,0xD8,0xAA,0x53,0x0C,0x9F,0x9A,0x21,0x8B,0x57,0xD7,0x7D,0x79,0xAA,0x3C,0x19,0x43,0x0B,0x1D,0x29,0x7A,0x79,0x4C,0x35,0x77,0x24,0xC7,0x95,0x36,0xD7,0x34,0x91,0x6C,0x97,0xCB,0x5C,0xD3,0x44,0xB1,0x5D,0x2E,0x73,0x8D,0xEB,0x29,0x36,0x29,0xCD,0xA5,0x76,0x06,0xE7,0xE8,0xFF,0x65,0x51,0x4D};
static  const uint8_t spa_YES[]       = {0x21,0x5B,0x2E,0x81,0xA6,0x56,0xF5,0x6C,0xA4,0xCB,0x25,0x4A,0xE7,0xA2,0x93,0x8E,0xE0,0x1A,0x61,0xAB,0x6F,0x72,0xB2,0xE1,0x4B,0x2C,0x64,0xF5,0xAD,0x56,0x37,0x43,0x89,0xA6,0xAC,0xC9,0x23,0x02,0xBE,0x12,0xE3,0x00,0x03,0x3E,0x55,0x23,0xC0,0x37,0x6C,0x0C,0xF8,0x86,0x8C,0x01,0x5F,0xB1,0x11,0xE0,0x0B,0xC9,0xFF,0x25,0x55,0x79,0x4D};
static  const uint8_t spa_YOUR[]      = {0xA1,0x69,0x86,0xD1,0xA7,0x2B,0xE5,0x3A,0x55,0x2D,0x08,0xDA,0xC4,0xCA,0x56,0x16,0xA9,0x5C,0xA3,0x3D,0x4F,0x99,0x44,0x59,0x85,0xF4,0x5A,0x65,0x74,0xE3,0xA9,0xDC,0xFB,0x96,0xA7,0x4A,0x7A,0xA2,0x8C,0x72,0x9F,0x2A,0xDA,0xC9,0x54,0xCE,0xBD,0xEA,0x10,0x26,0x42,0xB4,0xF7,0xAA,0xA3,0xDF,0x08,0xD1,0xDE,0xA3,0x8E,0x6E,0x23,0x44,0x73,0x8F,0x3A,0x9A,0x8D,0x54,0xC9,0x35,0xEA,0xE4,0xBA,0xD2,0xB0,0xF7,0x68,0x92,0xDF,0x74,0x91,0x9C,0xA5,0x89,0xBD,0xD3,0x48,0x3B,0xF8,0xF6,0xFF,0x2D};
static  const uint8_t spa_Z[]         = {0x08,0x38,0x20,0x4D,0x02,0x12,0x08,0xED,0x05,0x66,0xEE,0x19,0xA7,0x34,0x1B,0xA8,0x86,0x55,0xEA,0x91,0x6C,0x90,0x9C,0x9E,0xB1,0x4E,0xB4,0x71,0x51,0x66,0xCE,0x3A,0xD1,0xD0,0x41,0x65,0x5D,0xFB,0x24,0x43,0x27,0xB5,0x77,0xE3,0x53,0x8C,0x10,0x94,0x96,0x8D,0x4F,0x35,0x5C,0x50,0x46,0xAD,0x3E,0x4D,0xB7,0x41,0x51,0xB9,0xE4,0xF4,0xDD,0x19,0x67,0xD6,0x9C,0x35,0x74,0x6D,0x1C,0x59,0x8B,0xCB,0x38,0xAC,0xB2,0x69,0xB4,0x36,0x43,0xD1,0xCC,0xA6,0x53,0x5A,0x0C,0x91,0x8B,0x56,0xB4,0x25,0x33,0x74,0xC5,0xCE,0xAE,0x4E,0xFE};
