// Talkie library
//
// Armin Joachimsmeyer 01/2019 converted to .c and .h files
//
// These sounds were extracted by Richard Broadhurst https://www.youtube.com/watch?v=IHldh_rknuk&feature=youtu.be&t=12

#pragma once 
static const uint8_t zero[] = {0x06,0x18,0xd8,0x2d,0x00,0x89,0xa5,0x06,0xa0,0xa0,0xb4,0x00,0x64,0x5a,0x76,0xc2,0x2d,0x22,0xcc,0xdd,0xce,0x69,0x17,0x67,0x35,0xf7,0xc6,0xa7,0x2d,0x9c,0x3d,0xba,0x2a,0x9e,0x36,0x4a,0xc9,0x9e,0x88,0x74,0xda,0x60,0x64,0x3a,0xc3,0xf4,0x6a,0xbd,0x91,0xed,0x74,0x33,0xab,0xf5,0x46,0xb6,0xd2,0xcd,0xac,0xd6,0x06,0x2b,0xf5,0xac,0xd2,0x5a,0x55,0x55,0x63,0xbc,0xca,0x68,0x7d,0x25,0xab,0xb2,0x3a,0xa3,0x0d,0x15,0x2d,0xd3,0x1b,0xaf,0x36,0x2d,0xcc,0x30,0x9f,0xbd,0xda,0xb4,0x30,0xc3,0x6d,0xce,0x69,0x53,0x33,0xb5,0xb2,0x39,0xa7,0x4d,0x39,0x4c,0xcb,0x16,0x9f,0x36,0xe5,0x30,0x2d,0x5b,0x7c,0xda,0x94,0xc3,0xb4,0x6c,0xf1,0x69,0x53,0x0e,0xd3,0xb2,0xc5,0xa7,0x4d,0x39,0x4c,0xcb,0x16,0xaf,0x2e,0x96,0x50,0x2d,0x9b,0xd5,0x5a,0xdf,0xdd,0xcc,0x6c,0x35,0x3c};
static const uint8_t one[] = {0xa9,0xe5,0xce,0x27,0x4d,0x62,0x97,0x96,0x3b,0x9f,0x34,0x4e,0xdc,0x5a,0xee,0xbc,0xd3,0x25,0x76,0x6b,0x79,0x8c,0x8c,0xd0,0x28,0xad,0xe5,0x31,0x32,0x42,0xea,0xac,0xd6,0x9a,0x6e,0x75,0x4e,0x7b,0x5a,0x6f,0x7b,0xd8,0x24,0xcb,0x69,0xa7,0x4e,0x0b,0x0f,0xc7,0xa7,0x5d,0x26,0x3d,0x23,0x6c,0x9f,0x76,0x99,0xf2,0x8c,0xb0,0x7d,0xda,0x29,0xd3,0x2b,0xc2,0xc9,0x69,0x63,0x9d,0xc0,0xc9,0xc2,0xa7,0xcd,0x61,0x12,0xb6,0x43,0x9f,0x36,0xc7,0x49,0xd8,0x2e,0x7d,0xda,0x1c,0x27,0x61,0xbb,0xb4,0x03,0xb8,0xd7,0x00,0x00,0x00,0x00,0x00,0x80,0x07};
static const uint8_t two[] = {0x05,0x68,0x42,0x3d,0x01,0x83,0x6b,0x04,0x60,0x08,0xb5,0x04,0x24,0x28,0x91,0x00,0xe0,0xaa,0x4f,0x5b,0x8c,0xa8,0x47,0xe4,0x39,0x6d,0x31,0xa2,0x1e,0x91,0xfb,0xb4,0xc5,0x88,0x7a,0x44,0xee,0xd3,0x56,0x23,0xea,0x11,0x99,0x4f,0x97,0xb4,0x59,0x84,0x67,0x3e,0x6d,0x30,0x6e,0x9e,0xd6,0xf9,0xb4,0xc1,0x84,0xb9,0x5b,0xee,0xd3,0x06,0x93,0xe6,0x6e,0x99,0x4f,0x1b,0x4c,0x98,0xbb,0x65,0x5e,0x6d,0xb0,0x61,0xee,0x96,0x7b,0xb5,0xde,0x95,0xb9,0x79,0xe6,0xd1,0x7a,0xdf,0xe6,0x1a,0x5d,0x46,0xeb,0x43,0x99,0x6b,0x74,0x19,0xad,0x0f,0x65,0xa6,0xde,0x79,0xb4,0xde,0x97,0x99,0x7a,0xe7,0xd1,0x7a,0x5f,0xe6,0xea,0x5d,0x4a,0xeb,0x7d,0x99,0x6b,0x74,0x81,0x07};
static const uint8_t three[] = {0x10,0x80,0xae,0xcd,0x02,0x50,0x85,0xfb,0x29,0xaa,0x4a,0x17,0xd5,0x34,0xa7,0x2d,0x26,0x54,0xc5,0x53,0x9f,0x36,0x87,0x60,0xb5,0x70,0x7d,0xda,0x54,0x8c,0xb5,0xc4,0xf7,0x69,0x53,0x36,0xd6,0x12,0xdf,0xa7,0x4d,0x41,0x24,0x52,0x37,0x9e,0x36,0x05,0x91,0x48,0xdd,0x78,0xda,0xe2,0x95,0xad,0x3d,0xf3,0x69,0x6b,0x30,0xd2,0xcd,0x5e,0xa7,0xad,0xce,0x58,0xa7,0x3a,0x9d,0xb6,0x1a,0x63,0xe9,0xea,0x74,0xda,0x6a,0x8c,0xa5,0xab,0xd5,0x69,0xab,0x31,0x96,0xae,0x4e,0xa7,0xad,0xda,0x58,0xba,0x3a,0x9d,0xb6,0x07,0x61,0xda,0x9c,0x73,0xda,0x1e,0x84,0x68,0x73,0xee,0x69,0x7b,0x10,0xa2,0xcd,0xb9,0xab,0xed,0x41,0x88,0x36,0xe7,0xae,0xb6,0x07,0x61,0xda,0x9c,0x3a,0xda,0x1e,0x84,0x68,0xa3,0x1a,0x3c};
static const uint8_t four[] = {0x00,0x00,0x00,0xa7,0x8d,0xae,0x42,0x9d,0x52,0x9f,0xd6,0xd7,0x76,0x31,0xcd,0x7c,0x5a,0xdf,0x3b,0x30,0xa2,0xf3,0x69,0x7d,0xef,0xc0,0x88,0xce,0xa7,0xf3,0xbd,0x03,0x23,0x3a,0x9f,0xd6,0x96,0x4b,0x13,0xf3,0x7e,0x5a,0x5b,0x2e,0x4d,0xcc,0xdb,0x69,0x6d,0xdd,0x74,0x31,0xef,0xab,0x75,0xb5,0x43,0x43,0xfd,0xae,0xd6,0xd5,0x0e,0x09,0xc9,0xbb,0xda,0x50,0xca,0xb5,0x78,0xf7,0x68,0x7d,0xa9,0xd0,0xe2,0x3d,0xa3,0xf5,0xa5,0xc2,0x8a,0x77,0xaf,0x36,0x76,0xb5,0x0c,0xd9,0x3c,0xda,0x38,0xd4,0x32,0xe4,0xf3,0x6a,0xe3,0x10,0xcb,0x90,0xcd,0xa3,0x8d,0x43,0x2d,0x43,0x36,0x8f,0x36,0x76,0xb5,0x08,0xd9,0xd2,0xda,0x38,0xd4,0x32,0x65,0x4b,0x69,0x63,0x57,0xcb,0x90,0xcd,0x0f};
static const uint8_t five[] = {0x00,0x00,0x0a,0x08,0x92,0x63,0xad,0x51,0x4b,0x06,0x59,0x92,0xd3,0x26,0xef,0xc5,0xae,0x8b,0x4e,0x1b,0xb7,0xb9,0x4c,0xc6,0x3d,0x6d,0xdc,0xe6,0x32,0x19,0xf7,0xb4,0x71,0x9b,0xcb,0x64,0xdc,0xd3,0xa6,0xe9,0x66,0xd3,0x51,0x4f,0x9b,0x86,0xbb,0x4d,0x45,0x3d,0x6d,0x5a,0x6e,0x36,0x11,0xf5,0xb4,0x69,0x9a,0xf9,0x44,0xd4,0xd3,0xa6,0xa9,0x56,0x5d,0x66,0x4f,0x9b,0x86,0x59,0x76,0x9b,0x3d,0x6d,0x6a,0xee,0x5e,0x15,0xe7,0xb4,0xc5,0x4b,0xe4,0x4d,0xe5,0xd3,0x16,0x2f,0x91,0x37,0x95,0x4f,0x5b,0xbc,0x44,0xde,0x54,0x3e,0x6d,0xf1,0x12,0x79,0x53,0xf9,0xb4,0xc5,0x4b,0xe4,0x4d,0xe5,0xd5,0x16,0x2f,0x91,0x37,0x95,0x47,0x57,0xbc,0x64,0x5e,0x57,0x19,0x6d,0x09,0xe6,0x1c,0xd2,0x79,0xb4,0x25,0x98,0x73,0x48,0xe7,0xd1,0x96,0x60,0xce,0x21,0x9d,0x47,0x5b,0x82,0x39,0x87,0x74,0x1e,0x6d,0x09,0xe6,0x1c,0xd2,0x09,0x1e};
static const uint8_t six[] = {0x0e,0xe8,0x58,0xc3,0x01,0x09,0x57,0x1a,0xa0,0x11,0x77,0x07,0x34,0x12,0x1e,0x80,0x4c,0xc3,0x0d,0x50,0xb1,0xfb,0x29,0xab,0xe5,0x08,0xf3,0x45,0xa7,0x2d,0x56,0xc2,0xac,0x1e,0x9f,0xa6,0x78,0x49,0x89,0x5a,0x75,0xda,0xe2,0x35,0x25,0x6b,0xd1,0x69,0x8b,0xd7,0x94,0xac,0x55,0x2d,0x2b,0x5e,0x53,0xa2,0x56,0x99,0x30,0x7b,0x0d,0xf5,0x5e,0x05,0xc0,0x80,0x58,0xd4,0x1c,0x90,0xa2,0x69,0x02,0xaa,0x0b,0x4b,0x40,0x33,0x69,0x0e,0x68,0xd0,0xc3,0x01,0x85,0x94,0x3b,0xa0,0xa1,0x30,0x03,0x74,0xe4,0xd1,0x82,0x25,0xd3,0xdd,0xcd,0xce,0x03};
static const uint8_t seven[] = {0x06,0x18,0x54,0xfd,0x2c,0xdb,0xb9,0x7a,0xb8,0x95,0xb3,0x1c,0x9f,0xe1,0x69,0x76,0x02,0x50,0xb1,0x85,0x03,0x06,0x53,0x75,0xc0,0x92,0xe6,0x0e,0x28,0xcc,0xfd,0x94,0x89,0xbb,0x97,0x57,0xa9,0xd3,0x26,0x67,0xc5,0x35,0xb6,0x4f,0x9b,0x9c,0x15,0xf7,0xd8,0x3e,0x6d,0xb1,0x5a,0x9c,0x3d,0xf9,0xb4,0xc5,0x5a,0x71,0xf4,0xe4,0xd3,0x16,0x6b,0x25,0xd1,0x53,0x4e,0x57,0x83,0x15,0x85,0xa4,0x39,0x6d,0x8d,0x56,0xe4,0x9c,0xe5,0xb4,0x35,0x7a,0x91,0x71,0x96,0xd3,0x56,0x1f,0x66,0x2a,0xbb,0x4f,0x5b,0xbd,0x9b,0xa9,0xec,0x3e,0x6d,0xf5,0x61,0xa6,0xb2,0xfb,0x8c,0xd5,0x9b,0x99,0xe8,0xa6,0xd2,0x16,0x83,0xcd,0x12,0x73,0x52,0x57,0x34,0x34,0x5b,0xb4,0x4e,0x6d,0xd1,0xd0,0x6c,0xd1,0x3a,0xb5,0x45,0x43,0xb3,0x45,0xeb,0xd4,0x16,0x0d,0xcd,0x9a,0xad,0x4b,0x5b,0x34,0x36,0x6b,0x2e,0x4d,0x6d,0x31,0xd8,0xc2,0xd5,0xa6,0x74,0x59,0x63,0xa9,0x64,0x13,0x80,0x07};
static const uint8_t eight[] = {0x0d,0x50,0xb1,0xeb,0xb4,0x85,0xbb,0xce,0xa6,0xa5,0xd3,0x76,0xaf,0xe8,0x53,0x75,0x4e,0xdb,0xbd,0xa2,0x4f,0x35,0x39,0xdd,0xc8,0x46,0xd2,0x5e,0xfb,0xb4,0xa3,0x38,0x71,0x7b,0xed,0xd3,0xce,0xe2,0x44,0xed,0xb5,0x4f,0x3b,0x93,0x33,0xb5,0xc6,0x3b,0xed,0x4c,0x4e,0xd0,0x59,0x07,0x00,0x00,0x14,0x10,0xad,0xfa,0x09,0x7b,0x28,0xf7,0x34,0x3b,0x2b,0x5a,0xa1,0x52,0x3d,0x6c,0x8f,0x68,0xc5,0x4e,0x35,0x4f,0x22,0x80,0xa1,0x5d,0x1f};
static const uint8_t nine[] = {0xad,0xcb,0x0a,0x75,0x4a,0xc6,0xb4,0x36,0x2b,0xd4,0x2d,0x1e,0xd3,0xda,0xac,0x50,0xa7,0x78,0x4c,0x6b,0xb3,0x42,0xdd,0xe2,0x31,0xa7,0x2d,0x96,0x4d,0x5c,0xd7,0x9c,0x76,0x99,0x50,0x15,0x73,0x72,0xda,0x65,0xcb,0xd3,0xdd,0xc9,0x69,0x97,0x2d,0x4f,0x77,0x27,0xa7,0x5d,0xb6,0x3c,0xdd,0x9d,0x9c,0x76,0xea,0xae,0x0e,0x53,0x72,0xda,0x3c,0xcb,0x69,0xcd,0xce,0x69,0xf3,0x2c,0xa7,0x35,0x3b,0xa7,0xcd,0xb3,0x9c,0xd6,0xed,0x9c,0xb6,0xd4,0x4a,0x2e,0x4d,0x7a,0xda,0x5e,0x2b,0x31,0xbd,0xce,0xe9,0x7a,0xcd,0xc4,0xf4,0x3a,0xa7,0xed,0xd5,0x0d,0xd2,0x6b,0x9f,0xb6,0x57,0x37,0x48,0xaf,0x7d,0xda,0x5e,0xdd,0x21,0xbd,0xf6,0x69,0x7b,0x71,0x83,0xf4,0xda,0xa7,0xeb,0xc5,0x0d,0xd2,0x6b,0xaf,0xb6,0x39,0x74,0x77,0x4b,0xbd,0xda,0xe6,0xd0,0xc3,0x2c,0xf5,0x68,0x9b,0x45,0x0f,0xb3,0xd6,0xa3,0x6d,0x0e,0x3d,0x4c,0x13,0x8d,0xb6,0x39,0x74,0x37,0x6d,0x35,0xda,0xe6,0xd0,0xc3,0x2c,0x71,0xeb,0xaa,0x41,0x57,0x8b,0x26,0xad,0x2d,0x92,0x52,0x22,0xe3,0x94,0xb6,0x28,0x0a,0xb5,0x8c,0x53,0xda,0x2c,0x29,0x34,0x22,0x0e,0xc0,0x03};
static const uint8_t ten[] = {0x09,0xc8,0xcc,0x23,0x00,0x9d,0x99,0x25,0x20,0x20,0xab,0x02,0x30,0xed,0x73,0xda,0xaa,0xa4,0x74,0x22,0xf4,0x69,0x6b,0x94,0x90,0x9d,0xd0,0xa7,0xad,0xd1,0xd9,0xbb,0x47,0x9f,0xb6,0x06,0xe7,0x98,0xaa,0x7c,0xda,0xea,0x9d,0x63,0xaa,0xf2,0x69,0x53,0x74,0x8b,0x8d,0xc8,0xa7,0x4d,0xd1,0xcd,0x2f,0x02,0x9f,0x36,0x45,0x37,0xbf,0x0c,0xbc,0xda,0x94,0xcc,0xfc,0x22,0x70,0x69,0xab,0x65,0x37,0xa1,0xdb,0xa5,0xad,0x8e,0xdd,0x18,0xaf,0x94,0xb6,0x3a,0x76,0x63,0xbc,0x53,0xda,0xea,0xd8,0x8d,0xf1,0x4e,0x69,0xab,0x63,0x37,0xc6,0x3b,0xa5,0xad,0x8e,0xdd,0x04,0xef,0x94,0xb6,0x3a,0x76,0x63,0xbc,0x03,0xf0};
static const uint8_t alert[] = {0xa7,0xcd,0x6a,0x0b,0xbb,0xeb,0x9c,0x36,0xe9,0x4b,0xca,0x58,0x75,0xba,0xa4,0xaf,0x28,0x73,0xd5,0x69,0x2b,0xf5,0x35,0xc7,0xb5,0xa7,0xab,0xd4,0xd7,0x1c,0xd7,0x9e,0x36,0xea,0x1e,0x53,0x5a,0x72,0xda,0xa8,0x7b,0x54,0x69,0xf1,0xe9,0xa2,0xea,0x31,0xa5,0xc5,0xab,0x8d,0x3c,0x4f,0x95,0xd6,0x9d,0x36,0xd3,0xe8,0x72,0x97,0x7d,0xda,0xa5,0xc2,0xdc,0x23,0xc9,0x69,0x7d,0x6d,0x33,0x8b,0xc5,0xa7,0x4d,0x4d,0xac,0x5d,0x9e,0x9c,0x2e,0x76,0xb6,0x0e,0x7d,0x7a,0xda,0xd4,0x44,0x2b,0xec,0xce,0x69,0x53,0x32,0xa9,0xd2,0x5b,0xa7,0xcd,0x45,0x2c,0xd2,0x1e,0x9f,0x36,0x17,0xb1,0x28,0x7b,0xbd,0xda,0x5c,0xc4,0xa2,0xec,0x75,0x69,0x73,0x11,0xcb,0xb6,0x57,0xd0,0x82,0x9d,0x74,0xdc,0x35,0x8a,0x03,0xba,0xd4,0x14,0xc0,0xc4,0x92,0x0f};
static const uint8_t critical[] = {0x63,0xcc,0x4f,0x3d,0x22,0x94,0x94,0x31,0x7f,0x0b,0x77,0x8f,0xa3,0x80,0x74,0x30,0x0c,0x10,0x27,0xc4,0x69,0x53,0x32,0xd1,0xd4,0x3a,0xa7,0x8d,0x85,0x2d,0xda,0x9a,0x9c,0x36,0x15,0xd6,0x28,0x59,0x72,0xda,0xd2,0x45,0x2c,0xe5,0xcd,0x69,0x73,0x13,0xb1,0x92,0xb5,0xa7,0x4d,0x5e,0x83,0x33,0xe2,0x9c,0x36,0x7b,0x4d,0x8e,0xa8,0x7d,0xda,0x12,0xd5,0x39,0xaa,0xf5,0x69,0x4b,0x54,0xe7,0xa8,0x56,0xa7,0x2d,0x51,0x5d,0xa2,0x1a,0x8d,0xb6,0x44,0x75,0x89,0x6a,0x24,0xa2,0x1c,0xd5,0xb9,0x2a,0x36,0x18,0x20,0x54,0x8c,0x04,0xb0,0x26,0x7e,0xda,0x98,0x3d,0xc4,0x63,0xca,0x69,0x63,0x1e,0x13,0xb7,0x2b,0xa7,0x8d,0x65,0x54,0xdc,0x4e,0x9f,0x36,0x96,0x51,0x71,0x3b,0xbd,0xda,0x90,0xa6,0xd8,0xfd,0xf2,0x68,0x7d,0x9a,0x62,0xf3,0x3b,0xa3,0x0d,0x71,0x9a,0xcd,0xee,0x8c,0xce,0x95,0x49,0x8a,0x58,0x5c,0x5a,0x5f,0x26,0x31,0xe3,0x71,0x6a,0x7d,0x9d,0xc0,0x8c,0x57,0xa9,0x0d,0xa9,0x53,0x5d,0xda,0x3c};
static const uint8_t doublepoints[] = {0xa9,0xb5,0x22,0xd4,0x37,0x46,0xa6,0xd6,0x88,0xd0,0xd8,0x18,0x99,0x5a,0x2b,0x42,0x63,0x63,0x60,0x6b,0x03,0x33,0x8b,0xf2,0x45,0xa7,0xad,0xc6,0x2c,0xd4,0x1f,0x9d,0xb6,0x98,0x88,0x10,0x5b,0x74,0xda,0x62,0x33,0x42,0xed,0xd3,0x69,0xb3,0xcd,0x32,0x89,0x47,0xa7,0xcd,0x36,0x4b,0x25,0x6e,0x85,0x96,0xe4,0x08,0x71,0x8f,0x13,0x5a,0x1c,0x23,0xc3,0x34,0xe9,0x69,0xbd,0xab,0x56,0xe1,0xd6,0xa7,0x0d,0x7a,0x5a,0x94,0xbb,0x9c,0x36,0xa8,0x69,0x51,0xee,0x72,0xda,0xa0,0xa6,0x45,0xb9,0xcb,0xe9,0x82,0xda,0x16,0x91,0x2e,0xad,0x35,0x7a,0x4b,0xd8,0xba,0x88,0x5e,0x26,0x73,0x6e,0x8d,0x89,0x3a,0x1e,0x27,0x52,0xd9,0x29,0x6a,0xb9,0x9e,0xea,0x72,0x29,0x40,0x80,0xa8,0xb4,0x52,0x51,0xad,0x97,0xba,0xdb,0x49,0x45,0x57,0x5e,0xe6,0x9e,0xf8,0x4c,0xd1,0x67,0x9b,0x6a,0xe2,0xd3,0xc6,0x98,0x15,0x68,0x71,0x4e,0x1b,0x63,0x75,0x88,0xb4,0x39,0x6d,0x48,0x55,0x21,0xdc,0xf5,0xb4,0xb1,0x67,0xaa,0x59,0xe3,0xd3,0xe6,0x1e,0xa6,0x61,0x4d,0x4e,0x9b,0x5b,0x98,0x86,0x35,0x39,0x5d,0x6e,0x61,0x1a,0xda,0xe4,0xb4,0xdd,0xba,0xf2,0x68,0x9c,0xd3,0x76,0xeb,0x4a,0x63,0xb1,0x4f,0xdb,0x8d,0x2b,0x8d,0xc6,0x19,0x6d,0x37,0xae,0x34,0x96,0x24,0x55,0xdd,0xb8,0xd1,0x6a,0x1d,0x91,0x0d,0xa9,0x81,0x6b,0x71,0x08,0xd0,0xa1,0xaa,0x02,0x3a,0x0c,0x57,0xc0,0x40,0x9a,0x0a,0x58,0x48,0xb2,0x85,0x2f,0x68,0x84,0xab,0x9d,0x12,0x3e,0x6f,0x91,0x6a,0xb1,0x53,0xf6,0xac,0x45,0xba,0x45,0x36,0xf5,0x77,0x1a,0x61,0x11,0xe7,0x01};
static const uint8_t exerciseextremecaution[] = {0xa7,0x4d,0x49,0x33,0xa7,0x82,0x9e,0xb6,0x14,0x2a,0x3d,0xb7,0x75,0xda,0xd2,0xa8,0x75,0xdd,0xd1,0xaa,0x4b,0xa5,0x8a,0x4c,0x3b,0x00,0x0e,0x58,0x55,0x22,0x01,0xc3,0x62,0x16,0xa0,0x48,0xac,0xd3,0xe6,0x40,0x66,0x6d,0x9d,0x4f,0x9b,0x03,0x99,0xb7,0x75,0x3e,0x6d,0x0e,0x64,0xd6,0xd6,0x79,0xb5,0x39,0x90,0x79,0x5b,0xe6,0x00,0x14,0xa4,0x95,0x80,0xc1,0xc4,0x03,0xb0,0xa4,0x58,0x02,0xa6,0x90,0x08,0xc0,0x12,0xec,0x09,0x08,0x24,0xea,0xb4,0xc9,0x84,0x07,0xd5,0xe4,0xd3,0xe6,0xec,0x85,0x31,0x51,0x4f,0xdb,0x55,0x45,0xaa,0xb9,0x39,0xed,0x72,0x15,0xe9,0x6e,0xfb,0xb4,0xd9,0x8f,0xab,0x64,0xe3,0xd3,0xa6,0x96,0x6a,0xde,0xe1,0x4e,0x9b,0xa7,0x5a,0x4c,0x9b,0x3d,0x5d,0x9e,0x6a,0xd1,0x6d,0xf5,0xb4,0xb9,0x88,0x6c,0x67,0xd8,0xd3,0xe6,0x22,0xb2,0x9d,0x61,0x4f,0x57,0xac,0x84,0xeb,0x96,0x3d,0x6d,0xd5,0x94,0x6b,0x5d,0xee,0xb4,0x93,0xab,0x79,0x68,0xa6,0xd3,0x2e,0x66,0x29,0xea,0x89,0x4e,0x37,0xb9,0x85,0x9a,0xba,0x3e,0x6d,0xb7,0xa2,0x69,0x9c,0xf9,0xb4,0xd5,0x49,0x88,0xe5,0xc3,0xd3,0x56,0x27,0x21,0x5a,0x8f,0x5a,0x59,0xad,0xba,0x58,0xbe,0x32,0x61,0x34,0x16,0x11,0x19,0x3b,0x00,0x39,0x96,0x15,0xa0,0x53,0xf3,0x04,0x0c,0xa6,0x96,0x80,0x29,0xcc,0x12,0x30,0x85,0xba,0x03,0x3a,0x33,0x57,0xc0,0x94,0xee,0x2a,0xec,0x69,0x31,0x8f,0xc4,0xaa,0xb0,0xc7,0xc5,0x38,0x16,0x1b,0x80,0xea,0xdd,0x13,0x50,0x9d,0xd9,0x19,0xab,0x15,0xe3,0xf0,0x38,0xa7,0x4d,0x41,0xd4,0xc2,0x7a,0x9f,0xb6,0x04,0x66,0x1b,0x5d,0x73,0xda,0x12,0x98,0x6d,0x74,0xf5,0xe9,0x9a,0x65,0xf2,0xb2,0x55,0xa7,0xed,0x41,0xc8,0x5b,0x5b,0x9e,0xb6,0x07,0x21,0x6f,0x6d,0x79,0xda,0x1e,0x84,0xbc,0xb5,0xe5,0xe9,0xaa,0x21,0x9d,0xe6,0x5a,0xad,0xf5,0x86,0xd7,0xa8,0x94,0xb6,0xd6,0x1b,0x5e,0xa3,0x52,0xda,0x5a,0x6f,0x78,0x8d,0x4a,0x69,0x69,0xbd,0xe1,0x0d,0x4a,0xab,0xa9,0x0d,0x86,0xd7,0x25,0xac,0xba,0x26,0x1a,0x9a,0x64,0x8b,0xc3,0x80,0x90,0xd9,0x1c,0x90,0x3a,0x6a,0x00,0x4c,0x42,0x3f,0xf3,0x54,0xa1,0xa6,0xe6,0xe4,0x74,0xcb,0x96,0x67,0x84,0xad,0xd3,0xa6,0x19,0x21,0x51,0x61,0x4e,0xbb,0x4c,0x7a,0x45,0xa4,0x3d,0x6d,0xb6,0x1b,0x6e,0xd9,0xfa,0xb4,0xf1,0x38,0xcf,0xaa,0x95,0xd3,0xa6,0xe3,0xdc,0x6b,0x56,0x4e,0x57,0x83,0x8c,0x88,0x36,0x4a,0x40,0xe4,0x14,0x09,0x18,0x56,0x3d,0x00,0xc3,0xaa,0x05,0xa0,0x5b,0xf1,0x04,0x58,0xed,0x75,0xda,0x6c,0x25,0xc2,0xad,0xdf,0xe9,0xaa,0xa5,0x70,0x8b,0x6c,0xa7,0x6d,0x8e,0xdc,0xc4,0xd2,0xad,0x36,0x4b,0xf6,0x4a,0x9e,0x33,0xda,0x2c,0xd9,0xbb,0x68,0x4e,0x6b,0xb3,0x64,0xef,0xa2,0xc5,0xad,0x2d,0x92,0x7c,0x9a,0xe6,0x94,0x36,0x4b,0xf6,0x6e,0x9a,0x53,0xda,0x2c,0xd9,0xbb,0x68,0xb6,0x89,0x8a,0x22,0xef,0xd0,0xc6,0x0f};
static const uint8_t extrafuel[] = {0x03,0x88,0xce,0xf3,0xb4,0xcd,0xb9,0xc9,0xe6,0xea,0xd3,0xb6,0xe2,0x14,0x1e,0x73,0x46,0xdb,0x8a,0x53,0x44,0xcc,0x31,0x49,0xab,0xca,0x11,0x59,0x99,0x00,0xd5,0x9a,0x04,0xa0,0x5b,0xf7,0x02,0xcc,0x28,0x9a,0x80,0x61,0x31,0x14,0xd0,0x04,0x25,0x04,0xa0,0x38,0xf6,0xd3,0xd4,0x20,0xa6,0xa1,0x69,0x4e,0x5b,0xa2,0xba,0x24,0xaf,0x3e,0x6d,0xaa,0x22,0xb6,0xdc,0xfa,0xb4,0xa9,0x8a,0xe8,0x72,0x9b,0xd3,0xa5,0xa2,0x2a,0xe5,0x75,0x5a,0x9b,0x35,0x9b,0x7b,0xc4,0x32,0x40,0x10,0xac,0x06,0x68,0x4e,0xc4,0x00,0xcd,0xab,0x18,0xa0,0x39,0x16,0x03,0xf4,0xa8,0x6a,0x80,0x1e,0x4d,0xce,0xd8,0xac,0x09,0x46,0xb8,0x39,0x6d,0x77,0x2e,0x50,0xe9,0xed,0xb4,0xdd,0xb9,0x40,0xa5,0xd7,0xd3,0x56,0x6b,0xc2,0x1d,0x7e,0x4f,0x9b,0x9d,0x92,0x57,0xa6,0x3d,0x6d,0x76,0xca,0x5e,0x99,0xe6,0xb4,0x51,0x75,0xb8,0x4b,0x9f,0xd3,0x46,0x55,0xe1,0x21,0x7d,0x4e,0x1b,0x65,0x47,0x1b,0xf7,0x5b,0x6d,0x50,0x1d,0x6d,0xdc,0xef,0xb4,0x51,0x64,0xb5,0x89,0xf7,0xd5,0x46,0x91,0xdd,0xca,0xde,0x57,0x1b,0x45,0x76,0x2b,0x7b,0x5f,0x6d,0x12,0x39,0x29,0x9c,0xef,0xb4,0x49,0xe6,0xb8,0x70,0xde,0xd3,0x26,0x99,0xe3,0xc2,0x79,0x4f,0x9b,0x64,0x8e,0x0b,0xe7,0x3d,0x6d,0x92,0x39,0x2e,0x9c,0x67,0xb5,0x49,0xe4,0xb8,0x70,0x9e,0xd1,0x26,0x99,0x63,0xc2,0x79,0x1e};
static const uint8_t fighterpilotsneededinsectorwars[] = {0x0c,0x68,0x81,0x53,0x00,0x35,0x70,0x1a,0xc0,0x3b,0xeb,0x53,0x86,0xe2,0x66,0x49,0x5b,0x4f,0x19,0x47,0x99,0xac,0xcf,0x3e,0x65,0xec,0xe5,0x5a,0x36,0xe5,0x14,0xd9,0xab,0x45,0xc6,0xe9,0x53,0x66,0xaf,0xe6,0xe9,0xa7,0x13,0x60,0xa3,0x56,0x02,0xac,0xe3,0x3e,0x75,0x89,0x64,0x19,0xd9,0xe8,0xd4,0x39,0xb3,0x7a,0xe8,0xa6,0xd3,0xe4,0xcc,0x1a,0xa9,0xab,0x56,0x13,0x0b,0x5b,0xba,0x6d,0x2c,0x4d,0xcc,0x6c,0x91,0xba,0x99,0x15,0xc1,0x85,0x45,0x8a,0x23,0x02,0x44,0x1f,0xec,0x00,0xd6,0x54,0x4f,0x99,0xbb,0xbb,0xa6,0x15,0x3d,0x4d,0xde,0x9e,0xd2,0x55,0xf6,0x74,0x39,0xbb,0xfa,0xc6,0xec,0xd3,0xe5,0xec,0xea,0x1b,0x93,0x4f,0x9f,0xb3,0xab,0x6f,0x4c,0x3e,0x43,0x4c,0x11,0xe2,0x35,0xf6,0x0c,0x31,0x46,0x88,0xd5,0xe4,0xd3,0xe7,0x14,0x2e,0xd6,0x93,0xcf,0x90,0x53,0xb8,0x58,0x4f,0x3e,0x55,0xce,0xe1,0xa2,0x73,0xbb,0x4c,0xc5,0x96,0x08,0x5b,0x13,0x02,0x70,0x69,0xe9,0x80,0x22,0x34,0x03,0x50,0xb9,0x78,0x02,0x3a,0x57,0x3d,0xcd,0x90,0x2a,0x66,0x92,0xb6,0xb5,0x5e,0x70,0x8d,0xc4,0xd4,0x53,0x56,0x89,0xb6,0xad,0x55,0x4e,0x51,0x15,0xea,0x94,0xcf,0x3d,0x79,0x55,0x24,0x95,0x31,0xe7,0x64,0xdd,0x1a,0xa9,0xe7,0xd8,0x93,0x0f,0xa9,0x24,0x15,0x71,0x4f,0x3e,0xa4,0x92,0x56,0xc4,0x3d,0xc5,0x90,0x46,0x92,0x61,0xf7,0x14,0x43,0x2a,0x49,0x45,0xdc,0x53,0x0e,0xa9,0xc8,0xd5,0x4b,0x56,0x53,0x95,0xb2,0x84,0xae,0x3d,0x4d,0xb3,0xac,0x16,0x39,0xfb,0xb4,0xd5,0xb0,0x45,0xd6,0xec,0xd3,0x57,0xc3,0xea,0x59,0x4f,0x4e,0x5e,0x0d,0xab,0x67,0x2d,0x19,0x75,0xe5,0xa6,0xaa,0xde,0xe4,0xf4,0xc3,0x04,0xb3,0xe8,0xe3,0xd3,0x54,0xa9,0x5a,0x36,0xa7,0x4f,0x53,0xa5,0x69,0xd9,0x8c,0x3e,0x75,0x95,0xaa,0x65,0x33,0xfa,0xf4,0x59,0xb2,0xb7,0x76,0x99,0x51,0x67,0x81,0xb6,0x16,0xf5,0x46,0x95,0x05,0xda,0x9a,0xd7,0x6b,0x75,0x12,0xe8,0x67,0x3e,0xb7,0xf5,0x59,0xa2,0xaf,0x46,0x9d,0xd3,0x3f,0xeb,0x2a,0x26,0x76,0xce,0xf2,0xbc,0x87,0x85,0xdb,0x09,0xc0,0xa2,0xea,0x01,0xe8,0xc8,0x32,0x00,0x1d,0x79,0x04,0xa0,0x82,0xc8,0x13,0x64,0xed,0x16,0x12,0xb3,0x4f,0x9c,0xad,0xa5,0xc6,0x96,0x3e,0x49,0xb6,0x96,0x1a,0x5b,0xe6,0x24,0xd9,0x7a,0xaa,0x4f,0x95,0xe2,0x65,0x6b,0xa9,0xb1,0x55,0x50,0xa8,0xe3,0x94,0xb9,0x4a,0x46,0x89,0x35,0x5b,0xe1,0x22,0x07,0x0c,0x30,0xac,0x73,0x01,0x86,0x14,0x3d,0xf1,0x30,0x6a,0x34,0x91,0xe5,0xc4,0xc5,0x8a,0x59,0xda,0xe2,0x93,0xe4,0x2c,0x12,0xad,0x9d,0x4f,0x92,0x8b,0x48,0xb4,0x6e,0x3e,0x49,0xca,0x22,0xd1,0xba,0xf9,0xa4,0x31,0x89,0x76,0x6b,0xab,0x95,0x9b,0x58,0x9a,0x29,0xb5,0x5b,0x21,0x5b,0x4a,0x84,0xce,0x2e,0x85,0xd8,0xaa,0x91,0x19,0xa9,0x14,0x7c,0xb4,0x71,0xfb,0xc4,0x91,0x8b,0x5a,0x29,0x6e,0xb3,0x57,0xae,0x72,0xb5,0x3a,0x2f,0x39,0x99,0x8b,0x5d,0x62,0xbc,0xf5,0xe4,0x2e,0x76,0xb1,0xf1,0xda,0x93,0xfb,0x34,0xa5,0x22,0x5d,0x4e,0x61,0xcb,0xb9,0xab,0x76,0x3b,0xb5,0x0f,0x1b,0x6a,0xd6,0xf5,0x34,0xde,0x6f,0xa8,0x59,0x97,0xd3,0xfb,0xb0,0xae,0x66,0x5d,0xcf,0x14,0x6b,0x48,0x14,0x6d,0x3e,0x53,0xac,0x21,0x51,0xb4,0xe5,0xcc,0xb1,0x86,0x44,0xd1,0x9e,0xb5,0xc4,0xea,0x92,0x45,0x7b,0xce,0x9a,0xab,0xb3,0x97,0xf4,0x3e,0x5b,0xae,0xce,0xd6,0xd2,0xe7,0x6c,0xa9,0x1a,0x7b,0x49,0xef,0xb3,0xe7,0x14,0x2a,0xee,0x69,0xcf,0xde,0xad,0x68,0x98,0xf6,0x3b,0x47,0xb7,0xaa,0x61,0x9a,0xcf,0x01,0x05,0x79,0x38,0x60,0x61,0x09,0x07,0x6c,0x24,0x61,0x80,0x45,0x34,0x09,0xb0,0x09,0xe7,0x03};
static const uint8_t fuelstatus[] = {0x0a,0x28,0x46,0x5c,0x00,0xc5,0xb2,0x0b,0xa0,0x3a,0x35,0x01,0x14,0x23,0xa1,0x80,0x62,0xd8,0x1d,0x50,0x9d,0xb8,0x03,0x92,0x66,0x3f,0x6d,0x75,0x24,0x96,0x51,0xfb,0xb4,0xd5,0x91,0x58,0x45,0xad,0xd3,0x56,0x47,0x62,0x95,0xb5,0x4e,0x1b,0x8c,0x56,0x46,0x24,0x5e,0xad,0x89,0x9e,0xc1,0x53,0xf9,0xb4,0x41,0x46,0xa9,0x7b,0xe7,0xd3,0x26,0xe1,0x25,0x66,0x5d,0x4e,0x9b,0xa4,0x97,0x9a,0x76,0x3e,0x6d,0xd2,0xba,0x66,0xd8,0xf5,0xb4,0xc9,0xd8,0xba,0x52,0xd6,0xd5,0x7a,0x9b,0x53,0x2c,0xe9,0x57,0xeb,0x6d,0x4e,0xb1,0x64,0x1f,0xad,0xb7,0x35,0xc9,0x9a,0xbd,0xb5,0xde,0xd6,0x14,0x4b,0xfa,0xd6,0x7a,0x5b,0x53,0x2c,0xd9,0x03,0x90,0x61,0x8f,0x03,0x06,0xd2,0x74,0xc0,0x84,0x1a,0x0e,0x28,0xd8,0xd3,0x01,0x15,0x6a,0x28,0x20,0xc3,0x08,0x18,0xe3,0xb2,0x56,0x91,0x11,0xea,0x8c,0x45,0xa9,0x87,0x4f,0xa3,0xd3,0x56,0x11,0xee,0x1d,0xa3,0x4e,0x5b,0x45,0xb8,0x4f,0x8e,0x3e,0x6d,0x15,0xe9,0x3e,0x31,0xfa,0xb4,0x39,0x44,0x69,0x77,0xad,0xd3,0xe6,0x10,0xa5,0xdd,0xb1,0x4f,0x9b,0x43,0x94,0x76,0xc7,0x1e,0x6d,0xf3,0xaa,0x25,0x16,0xe7,0xb4,0xdd,0x92,0x95,0x44,0x95,0xd3,0xe6,0xe0,0xa6,0x31,0x53,0x4e,0x97,0x6d,0x6a,0xd8,0x9e,0x3e,0x6d,0xd6,0xe1,0xa5,0x3b,0xf6,0xb4,0xd9,0x58,0x84,0x5c,0x95,0xd3,0x66,0x63,0x11,0xb2,0x55,0x56,0x5b,0xb4,0x66,0xe8,0x2c,0x76,0x40,0x92,0xe6,0x0e,0x28,0xc2,0xcc,0x01,0x49,0x5a,0x38,0x20,0x29,0x0b,0x03,0x14,0xe9,0xae,0x80,0xa4,0xdd,0x19,0x90,0xb8,0xfb,0x03};
static const uint8_t invaderinsector[] = {0xa7,0x1d,0x4e,0x8d,0x23,0x3b,0x9d,0xb6,0x5b,0x53,0x8e,0xea,0xd5,0xda,0x2c,0x84,0xdd,0xf4,0x71,0x6b,0xb3,0x14,0x76,0xd5,0x3b,0xad,0x2d,0x52,0xd9,0x55,0x2f,0x97,0x36,0x0b,0x61,0x37,0xbd,0x33,0xda,0x62,0x58,0xcc,0x3d,0x6d,0x6b,0xab,0x63,0x95,0x32,0x4d,0xad,0xad,0x9e,0x55,0xd2,0x34,0x8d,0xb6,0x3a,0x56,0x49,0xd3,0x7c,0x9a,0xea,0x58,0x25,0xcd,0xf3,0x69,0x9b,0x17,0xf7,0xe4,0xb7,0xa7,0x6d,0x5e,0xdc,0x93,0xdf,0x9e,0xb6,0x79,0x71,0x4f,0x7e,0x7b,0xda,0x16,0x95,0x7d,0x62,0xf2,0x69,0xb3,0x16,0x9b,0x8d,0xb0,0xa7,0xcd,0x5a,0x6c,0x36,0xc2,0x9e,0xae,0x79,0xd4,0xde,0x2a,0x62,0x00,0x6e,0x6d,0x1d,0x20,0x9c,0xdd,0x69,0x53,0x64,0xf7,0x8a,0xc3,0xa7,0x4d,0x91,0xdd,0x2b,0x0e,0x9d,0x36,0x45,0x76,0xaf,0x38,0x74,0xda,0x14,0xd9,0xbd,0xe2,0xd0,0xe9,0x62,0x62,0xcf,0xf4,0x53,0xa7,0x8d,0x89,0xa3,0xc2,0x4f,0xad,0x36,0x26,0x8e,0x0a,0x3f,0x35,0xda,0x98,0x28,0x2a,0xe2,0xd4,0xea,0x92,0x10,0x5b,0xae,0xa9,0xab,0x4d,0x5c,0xec,0xc5,0xab,0xad,0x36,0x71,0xb1,0x17,0xaf,0xda,0xda,0xcc,0xc5,0x5e,0xbc,0xda,0x68,0x2b,0x51,0xed,0xd6,0xd4,0x0e,0xd8,0x44,0xc3,0x01,0x0b,0x6b,0x38,0xa0,0xa2,0x08,0x07,0x0c,0x64,0x6e,0x80,0x89,0x35,0x1c,0x10,0x40,0xf5,0xe9,0x8a,0x72,0x4b,0xce,0xcb,0xa7,0x4d,0xc1,0xdd,0x7d,0x8a,0x9c,0x36,0x45,0x0b,0xcf,0x2e,0x56,0x80,0x18,0xa4,0x02,0x10,0x9d,0x24,0xea,0x6c,0x9e,0x08,0x57,0xc9,0xa8,0xf5,0x66,0xa3,0x4c,0xc4,0x00,0x10,0x60,0x19,0xb5,0x04,0x2c,0x2d,0x96,0x80,0xa1,0xc4,0xce,0xd8,0x9d,0x29,0xa7,0xa5,0x3b,0x6d,0xf5,0x62,0x92,0xba,0xe5,0xb4,0x25,0x38,0xcb,0xd8,0x96,0xd3,0x96,0x68,0x2c,0x63,0x5b,0x4e,0x9b,0x0b,0x6b,0x94,0x2c,0x39,0x6d,0x2e,0xac,0x51,0xb2,0xf8,0xb4,0xb9,0xb0,0x46,0xc9,0x92,0xd3,0xe6,0xcc,0x1a,0x25,0x8b,0x47,0x97,0x33,0x6b,0x94,0x2e,0x0e,0x6d,0xb4,0x14,0xe6,0x1e,0x3b,0xb5,0x45,0xb8,0x86,0xbb,0xed,0x07};
static const uint8_t laser[] = {0xa7,0xcd,0x3c,0x2a,0x94,0x7b,0x9f,0x36,0xf3,0xc8,0x54,0xca,0x73,0xda,0xcc,0x23,0x53,0x29,0xcf,0x69,0x33,0x8f,0x4c,0xa5,0x3c,0xa7,0xcd,0x3c,0x32,0x95,0xf2,0x9c,0x36,0xf3,0xc8,0x50,0xce,0x7d,0xba,0xec,0xab,0x45,0x6c,0xf6,0x69,0xb3,0xd5,0xd4,0xbe,0x22,0xa7,0x2d,0x96,0xd3,0x63,0x23,0x9f,0xb6,0x68,0xb4,0xcd,0x29,0x7a,0xda,0xa2,0xd1,0x36,0xa7,0xe8,0x69,0x8b,0x46,0xdb,0x9c,0x22,0xab,0x2d,0x9a,0x6c,0x6b,0xca,0x9c,0xb6,0x71,0x73,0xca,0x68,0x7d,0xda,0x2d,0xd5,0xd8,0xc2,0xcb,0x69,0x6f,0x34,0x17,0x75,0xb6,0xa7,0xbd,0xd1,0x5c,0xd4,0xd9,0x9e,0xf6,0x06,0x73,0x51,0x67,0x7b,0xda,0x6e,0xd8,0x22,0xb9,0xd1,0x69,0x8b,0xd1,0xd0,0xb0,0x85,0xa7,0xcd,0xd6,0x42,0xc2,0x16,0x9e,0x36,0x05,0x35,0x6d,0x9f,0x75,0xda,0xe4,0xd5,0xb4,0x7d,0xd6,0x69,0x93,0x73,0xb5,0xb2,0xc5,0xa7,0xcd,0xda,0xc5,0x46,0x56,0x9f,0x36,0x6b,0x17,0x1b,0x59,0x75,0xda,0xac,0x43,0x74,0xa4,0xd5,0x6a,0xb3,0x72,0xb5,0x91,0xd5,0xa5,0xad,0x06,0x35,0x4b,0x62,0x85,0xb6,0x5a,0xf4,0x48,0xa9,0x0d,0x0f};
static const uint8_t marginal[] = {0x00,0x00,0xd0,0xda,0xe4,0xb9,0x05,0x75,0x4e,0x6b,0x93,0xe3,0x66,0xd2,0x39,0xad,0x4d,0x8e,0x5b,0x48,0x96,0x9c,0x36,0x3a,0x0f,0x17,0x6d,0x73,0xda,0x50,0x37,0x4c,0xb5,0xd3,0x69,0x43,0xdd,0x30,0xd3,0x4e,0xa7,0x8d,0x75,0xc3,0x4c,0x3b,0x9d,0x6e,0xe9,0xf4,0x0a,0xb7,0x73,0xba,0x65,0xcb,0x33,0x5c,0xce,0x69,0x73,0x0f,0x8e,0xf0,0xb4,0xa7,0x5b,0xa6,0x22,0xd4,0x9c,0x9c,0xb6,0x64,0xe1,0x4c,0xdd,0x4c,0x5a,0xa6,0xa3,0x52,0xd3,0xec,0x68,0x87,0x45,0xb6,0x8a,0x38,0xa7,0x5f,0xab,0x4b,0xc3,0x6d,0x17,0xa0,0x69,0xd2,0xd3,0x76,0xc7,0xa6,0xe1,0xad,0x4f,0xdb,0x2d,0x99,0x45,0x74,0x3e,0x5d,0xb7,0x64,0x16,0xd1,0x69,0x0c,0x45,0x61,0xa4,0x78,0x9b,0xd1,0x16,0x8d,0x19,0xec,0x6d,0x4e,0x5b,0x74,0x3b,0xab,0x36,0x3e,0x6d,0x0e,0xe3,0x98,0x19,0xfb,0xb4,0x39,0x4c,0xc0,0x44,0xec,0xd3,0xa6,0x38,0x81,0xe3,0x95,0x47,0x1b,0x5b,0x27,0x85,0xcf,0x1e,0x6d,0xac,0x9d,0x14,0xbe,0xb8,0xb5,0xb1,0x75,0x52,0xf8,0xe2,0xd6,0xc6,0xda,0x49,0xe1,0x8b,0xe0,0x01};
static const uint8_t operational[] = {0xa7,0x2d,0xce,0x4f,0xdd,0xd6,0x9c,0xb6,0x38,0x3b,0x71,0x5f,0x7b,0xba,0xe2,0xfc,0xd4,0x7c,0xed,0x69,0x53,0xd8,0x32,0x97,0xd7,0xa7,0x4d,0x61,0xcb,0x5c,0x5e,0x8f,0x24,0x85,0x29,0x73,0x79,0x02,0x20,0x00,0x57,0xd9,0x17,0x90,0x99,0xdb,0x69,0xb7,0x4d,0x55,0xf5,0x24,0xa7,0x5d,0x36,0x54,0xd5,0xd3,0x9c,0x76,0xd9,0x50,0xd5,0x48,0x73,0xda,0xce,0xc3,0xc3,0xcc,0xc9,0x69,0x8b,0x6c,0x37,0xf5,0x34,0xa7,0x0d,0x9d,0x65,0x5c,0xd7,0x9c,0x36,0x77,0xe5,0x4c,0x59,0x75,0xba,0x92,0x45,0xb2,0x64,0xe9,0xe9,0x4a,0x14,0xce,0xb1,0xd9,0xa7,0x2d,0x46,0x24,0xcf,0x6b,0x9d,0xb6,0x18,0x95,0xb8,0xa8,0x75,0xd2,0x69,0x54,0xa4,0xb2,0x4d,0x01,0x86,0x57,0x2e,0xc0,0x30,0x2a,0x09,0x18,0x41,0xf8,0xcc,0xd3,0xab,0x70,0x6a,0x92,0xd3,0x56,0x8b,0x25,0x91,0x89,0x57,0x5b,0x2d,0x36,0x57,0x26,0x1a,0x5d,0xd1,0x98,0xad,0x31,0x7b,0x35,0xc9,0x48,0x28,0xd9,0x94,0xd3,0xe6,0x1c,0xce,0xea,0x53,0x4e,0x9b,0x42,0xa7,0xb8,0xce,0x3e,0x6d,0x0a,0x9d,0xe2,0x3a,0xfb,0x74,0x29,0x74,0x8a,0xeb,0xec,0xd4,0xfa,0x67,0x41,0x39,0xb6,0x53,0xeb,0xae,0x3b,0x55,0xc5,0x2e,0xad,0xbf,0xee,0x9c,0x19,0x25,0xe4,0x21,0x4c,0xa6,0x9a,0x9b,0x07};
static const uint8_t outoffuel[] = {0x05,0x48,0x47,0xf1,0xb4,0x25,0x9c,0xc8,0x79,0xec,0xd3,0x96,0x70,0x22,0x67,0xb1,0x4f,0x9b,0xe3,0x89,0x6d,0x94,0x39,0x6d,0x4e,0x2b,0xb6,0x35,0xea,0xb4,0xa9,0xac,0xf8,0xd4,0xe8,0xd3,0xc6,0x36,0x6a,0x9d,0x65,0x4e,0x1b,0x5b,0xbb,0x56,0x8d,0x3d,0x6d,0x6c,0x15,0x92,0x3d,0xf6,0x74,0xd1,0x4f,0x62,0xfb,0xea,0xd5,0x46,0x37,0x09,0xed,0x5b,0x4f,0x17,0x43,0x1b,0x4e,0xac,0x3e,0x6d,0x0c,0x6d,0x34,0xde,0x7a,0xb5,0x31,0xb4,0xe1,0x78,0xeb,0xd4,0x86,0x58,0x4a,0xeb,0xab,0x01,0x02,0xd0,0x84,0x64,0x02,0x06,0x93,0x34,0xc0,0xa6,0x94,0x0c,0x18,0x58,0x33,0x01,0xa1,0xa7,0x9d,0x36,0xb5,0x6e,0x95,0x9e,0x7d,0xda,0xd4,0xbb,0x95,0x7b,0xf6,0x69,0x53,0x9a,0x14,0x8d,0x47,0xa7,0x4d,0x69,0x52,0x2c,0x6e,0x9d,0x36,0xa5,0x49,0xb1,0xb8,0x75,0xda,0x54,0xd7,0x69,0xa2,0xca,0x69,0x53,0x59,0xa7,0x8e,0x2a,0xa7,0x8b,0x71,0x92,0xd2,0x26,0x9f,0x36,0x86,0x29,0x0a,0xbd,0x7d,0xda,0x18,0xa6,0xc8,0x75,0xf6,0xea,0x92,0xed,0x40,0x97,0xd9,0xa3,0x4d,0xba,0x1d,0x43,0x66,0xaf,0x36,0xe9,0x32,0x51,0x5d,0xbc,0xda,0x64,0xd2,0x44,0xad,0xf1,0x6a,0x93,0x49,0x13,0xb5,0xc6,0xa3,0x4d,0x3a,0x4d,0xd4,0x9a,0xb4,0x2e,0xe9,0x74,0x31,0x6b,0x62,0x80,0xa6,0xcc,0x0c,0x50,0x95,0xf9,0x88,0x66,0xaa,0xd4,0x74,0x2b,0x2b,0x9c,0xb1,0xda,0xdd,0x6d,0x3b,0xa0,0x19,0x53,0x07,0x34,0x65,0x76,0xda,0xee,0x44,0xa4,0x32,0xf5,0x69,0x9b,0x63,0x91,0xae,0xd4,0xa7,0x6d,0x51,0x89,0xb3,0x32,0x9f,0xb6,0x05,0x25,0xae,0xea,0x7c,0xda,0x6a,0x84,0x6d,0x32,0xcb,0x69,0x83,0x8a,0x88,0xd2,0xcc,0xa7,0xf5,0xba,0xd3,0xca,0x33,0x9d,0xd6,0xeb,0x4e,0x2b,0xcf,0x7c,0x5a,0xaf,0x3b,0xad,0xbc,0xd3,0x69,0x83,0xee,0xb4,0xf2,0x4c,0xa7,0x0d,0x3a,0x3a,0x8d,0xfb,0xac,0x36,0xea,0x1a,0x15,0xde,0xbc,0xda,0xa8,0x6b,0x54,0x78,0xf3,0x6a,0xa3,0xae,0x51,0xe1,0xcd,0xab,0x8d,0xba,0x46,0x85,0x37,0xaf,0x36,0xea,0x1a,0x15,0xde,0x3c,0xda,0xa8,0x6b,0x54,0x78,0xf7,0x68,0xa3,0xce,0x31,0xe1,0xdd,0xad,0x8d,0xba,0x46,0x85,0x77,0xa7,0x36,0xea,0x1a,0x55,0xde,0xac,0xe2,0x68,0xab,0x25,0x2c,0xf6,0x03};
static const uint8_t overheated[] = {0xa7,0x8b,0xb6,0xc6,0x02,0xb3,0x9f,0x36,0xb8,0xee,0x74,0x4c,0x77,0xda,0xe0,0xbb,0xd3,0x31,0xed,0x69,0x7d,0xec,0x12,0x93,0xbc,0xa7,0x9b,0x2a,0xd4,0x3d,0x92,0x8c,0xd6,0xc6,0x6a,0x33,0x5a,0x0d,0x70,0xda,0x98,0xd2,0xd5,0xcd,0xce,0x69,0xb7,0x4b,0x33,0x73,0x27,0xa7,0x5b,0x36,0xd4,0xcd,0xed,0x9c,0x36,0x0e,0xf4,0x08,0x5f,0x7c,0xda,0x54,0x29,0xdd,0x72,0xca,0x6a,0x53,0xc5,0x08,0x8f,0x31,0xab,0x2d,0x96,0x24,0xd6,0x22,0xad,0xb6,0x58,0x96,0x38,0x0b,0xb5,0xda,0x2c,0x45,0xfd,0xdc,0xf2,0x69,0x9b,0x64,0xb5,0x89,0x38,0xa7,0x6d,0x8a,0xc5,0x26,0xea,0x9c,0xb6,0x29,0x16,0xdb,0xac,0x7d,0xda,0xa6,0x58,0x6c,0xb3,0xf6,0x6a,0x9b,0x62,0xb1,0xcd,0x59,0x70,0xda,0xae,0x9c,0xd5,0x2d,0xf5,0x69,0xa3,0xb2,0xcc,0xea,0x22,0xa7,0x2d,0x52,0xdd,0xab,0x26,0x9d,0xb6,0x29,0x35,0xcb,0xbc,0x78,0xda,0xa6,0xd4,0x2c,0xf3,0xe2,0x69,0x9b,0x56,0xb3,0xcc,0x8b,0x00,0x00,0xf0};
static const uint8_t playastroblaster[] = {0x01,0xa8,0x44,0xfa,0x24,0x41,0x57,0x2b,0xeb,0x92,0x93,0x04,0x5f,0xc9,0x9a,0x67,0x4e,0x12,0x7c,0x25,0x6b,0x4e,0x39,0x51,0x2c,0xe9,0x1c,0x55,0xf6,0x84,0xb1,0x64,0x70,0x74,0xd4,0x13,0xc5,0x92,0x2e,0x51,0x65,0x4f,0x94,0x92,0xe9,0xe4,0x8c,0x3e,0x71,0x4a,0xa6,0x9d,0x3d,0xe4,0x24,0x29,0xb8,0x75,0x74,0x99,0x93,0x54,0x2b,0xda,0x59,0x41,0x4e,0x52,0xad,0x68,0x57,0x05,0x39,0x49,0x91,0x62,0x33,0x19,0xe7,0xa4,0x45,0x8a,0xcd,0x66,0x9c,0x93,0x75,0xab,0xe4,0x5b,0x91,0x4f,0xd1,0xad,0x90,0x6f,0xd7,0x39,0x65,0xb7,0x42,0xb6,0xd5,0x64,0xd5,0x45,0x93,0xde,0x65,0xe8,0xd5,0x16,0x4d,0xf6,0x13,0x61,0x46,0x5f,0x34,0xf9,0x8f,0x59,0x33,0x6d,0xd6,0x14,0xdf,0x16,0x07,0x80,0x01,0xae,0xcb,0x24,0xc0,0x0f,0x99,0x93,0xc4,0x6a,0xbd,0x31,0x52,0x4e,0x12,0xab,0xd5,0xc6,0x48,0x39,0x49,0x68,0xd6,0x13,0x2d,0xe5,0x24,0x39,0x5b,0x94,0x5f,0x94,0x93,0xe4,0x6c,0x51,0xbe,0x51,0x4f,0x92,0xb3,0x7b,0xf9,0x46,0x39,0x65,0x15,0x11,0xa6,0x91,0xe8,0x94,0x43,0x9b,0x9a,0xab,0x9b,0x04,0x74,0x29,0x1a,0x80,0x61,0x55,0x0c,0x30,0x9c,0x2a,0x03,0x9a,0x11,0x55,0x40,0x73,0x12,0x09,0x28,0x9a,0xe3,0x64,0x55,0xba,0x4b,0x58,0x9a,0x93,0xf9,0x64,0xe6,0xed,0xa9,0x4f,0x1e,0x52,0x19,0xaf,0xb6,0x5a,0xb9,0xcf,0x65,0x3c,0x96,0x7a,0x14,0x3e,0xb5,0xf2,0x6a,0xab,0xd2,0x5a,0xdf,0x46,0x63,0x0d,0x5d,0x8b,0x8b,0x5b,0x58,0xc5,0x75,0xbd,0x8c,0xe6,0x6a,0x9e,0xc4,0x8d,0x34,0x79,0x79,0x46,0xd2,0x53,0xfa,0xd0,0xa5,0xe2,0x8b,0x4f,0xe9,0x42,0x97,0x4a,0xdc,0x3a,0x65,0x48,0x19,0xe2,0x5d,0xfa,0x94,0xa9,0x66,0x88,0x5f,0xe8,0x53,0xa5,0x9a,0x1a,0x39,0x61,0x4f,0x9d,0x5a,0x72,0x4f,0x85,0x39,0x4d,0x6c,0xc9,0xdd,0x15,0xe5,0xb4,0xa9,0x25,0xf7,0x74,0x99,0xd5,0xc5,0x96,0x52,0x3d,0x65,0x4e,0x5f,0xad,0x24,0xca,0xc4,0x36,0x40,0xc7,0xae,0x0e,0x28,0x24,0x4d,0x01,0x0d,0x87,0x32,0x20,0x8a,0x32,0x07,0x54,0x18,0x9a,0x80,0xc8,0xd2,0xcf,0x50,0xac,0xab,0x59,0xf4,0x39,0x63,0xb1,0xae,0x6e,0xd1,0xf7,0x4c,0xc5,0xba,0xba,0x47,0xdf,0x33,0xe7,0x22,0x12,0x61,0x9b,0xcf,0x92,0xab,0x48,0x84,0x6e,0x3e,0x5b,0xae,0x2c,0x19,0xb6,0x69,0xed,0xb9,0x8a,0x44,0xe8,0xa6,0xb5,0xe7,0x2a,0x12,0xa1,0x9b,0xd7,0x91,0xab,0x48,0x84,0x6e,0x56,0x80,0xcd,0xd4,0x04,0x70,0x99,0xea,0x01};
static const uint8_t player[] = {0x06,0xc8,0xdc,0xc3,0x00,0x85,0x79,0x38,0x40,0x9b,0xae,0xd5,0x7a,0x5b,0xcd,0x2a,0x4b,0x4e,0x1b,0x65,0x8d,0x2a,0x3d,0x39,0x6d,0x94,0x35,0xaa,0xf4,0xa4,0x01,0x3e,0xa5,0x36,0x20,0xc4,0x94,0xd3,0x16,0x19,0x9a,0x53,0x93,0x4e,0x57,0x94,0x6b,0x4e,0x4d,0x3a,0x6d,0x75,0x64,0xd1,0xf9,0xe4,0xb4,0xd5,0x91,0x45,0xe7,0x93,0xd3,0x66,0xcb,0x5e,0x1b,0xa3,0x4f,0x9b,0xad,0x78,0xad,0x95,0x3e,0x6d,0x72,0x6a,0x39,0x36,0xf9,0xb4,0xc9,0xa9,0x65,0xdb,0xe4,0xd3,0xa6,0xc4,0x96,0xe9,0x57,0x4e,0x9b,0x0a,0x59,0x46,0x5e,0x39,0x6d,0xca,0x64,0x1d,0x71,0xe5,0xb4,0x31,0xb1,0x4f,0xf8,0x94,0xd3,0xc6,0xc4,0x3e,0xe9,0x73,0x4e,0x9b,0x93,0x4a,0x86,0x4e,0x19,0x5d,0x8a,0xc6,0x51,0x32,0x39,0xb5,0x21,0x92,0x74,0x59,0x99,0xd0,0x84,0x48,0x52,0xe5,0x91,0x5d,0x93,0x32,0x6a,0x54,0xd8,0x82,0x07};
static const uint8_t playover[] = {0x0e,0xa0,0xa6,0xfa,0xb4,0x95,0x49,0xbb,0x4a,0x9d,0xd3,0x06,0x95,0xe3,0x86,0x4f,0x4e,0x1b,0x54,0x4e,0x38,0x3e,0x39,0x6d,0x95,0x91,0x9a,0xb9,0xea,0xb4,0x55,0x46,0x4a,0xe5,0xa2,0xd3,0x56,0x19,0x29,0x95,0x8b,0x4e,0x5b,0x65,0xa4,0x54,0x2e,0x3a,0x5d,0x4d,0xce,0x36,0xb5,0xe8,0xb4,0x35,0x39,0xd9,0xd6,0xc2,0xd3,0xd6,0xec,0x64,0x5b,0xab,0x4e,0x5b,0x9d,0x72,0x4c,0x2c,0x3e,0x6d,0x75,0xca,0x31,0xd1,0xf8,0x74,0xc5,0x61,0xec,0x46,0xe8,0xd3,0x15,0x87,0x71,0x9b,0x61,0x4e,0x9b,0x35,0xe9,0x4d,0x98,0x3e,0x6d,0xd6,0xa4,0x37,0x69,0xf8,0xb4,0x55,0x93,0xcc,0x74,0xe9,0xd3,0x16,0x4d,0xb2,0xdb,0xa5,0x57,0x57,0x34,0xc9,0x6e,0x97,0x6e,0x6d,0x12,0xe4,0xd5,0x21,0xa5,0xb4,0x49,0x92,0xd7,0x84,0x94,0xd0,0x26,0x45,0x51,0x61,0x72,0x5d,0x5a,0x2d,0x45,0xa4,0xd8,0x16,0x66,0xb6,0x92,0x5a,0x62,0x05,0x08,0xa0,0x77,0xea,0x6a,0x43,0x9c,0xa6,0xe0,0xad,0xa7,0x0d,0x69,0x9a,0x83,0xb6,0x9e,0xd6,0xe7,0x29,0x09,0xda,0x7a,0x5a,0x9f,0xa7,0x24,0x78,0xcb,0x69,0x43,0xca,0x2c,0xd1,0x64,0xa7,0x0b,0xa9,0xb2,0x58,0x9b,0xad,0xd6,0x97,0x4a,0x65,0xf9,0x3c,0x5a,0x5f,0x32,0x55,0xe4,0xf5,0xea,0x82,0xcd,0x32,0xe5,0xc5,0xab,0xad,0x5a,0xd5,0xcc,0x92,0xac,0xb6,0x6a,0x55,0x33,0x4b,0x72,0xda,0xa2,0xcd,0x4c,0x35,0xce,0xe9,0x52,0x36,0x73,0xb3,0x38,0xa7,0x8d,0x8d,0x2c,0x5d,0x67,0x9f,0x36,0x56,0xb6,0x08,0xbf,0x72,0xda,0x58,0xd9,0x32,0xfc,0xce,0x6a,0x63,0x65,0x8b,0xf0,0x2b,0xa7,0x4d,0x59,0xdc,0x3d,0x9a,0x9c,0x36,0x65,0x89,0xf0,0x6c,0x72,0xba,0x94,0x25,0xdc,0xb3,0xc9,0xea,0x52,0xa2,0x0c,0xf7,0xcb,0xad,0x8d,0x32,0x22,0x97,0x62,0x95,0x36,0x4a,0x8f,0x5c,0x8a,0x45,0x00,0x62,0xb7,0x1e};
static const uint8_t remaining[] = {0xa7,0x0d,0xa1,0x44,0x4a,0x9d,0xac,0xd6,0x17,0xe3,0x2c,0xea,0x73,0xda,0x98,0x54,0x33,0xb8,0xf1,0x69,0x53,0x14,0x89,0xd4,0x4d,0xa7,0xcb,0x5e,0xc5,0x4b,0x3b,0x9f,0xb6,0x7a,0x25,0xde,0xcc,0x7d,0xda,0xea,0x95,0x78,0x33,0xf3,0xea,0x82,0x56,0x8d,0x16,0x2f,0xa3,0x55,0x56,0xc3,0x52,0x73,0x8f,0x56,0x39,0x0d,0x0b,0xcd,0x7d,0xda,0xe2,0xc5,0x24,0x35,0xf7,0xe9,0xba,0x55,0xc3,0xb2,0x5a,0xa7,0x1d,0x4e,0x0d,0xcb,0x6a,0x9d,0x76,0x38,0x35,0x2c,0xab,0x75,0xda,0xe1,0xd4,0xb0,0xac,0xd6,0x69,0x87,0x53,0xc3,0xb4,0x5a,0xa7,0x1b,0x4e,0x0d,0xd3,0x6a,0x8d,0xb6,0x28,0xf4,0x16,0x9b,0x73,0xda,0x9e,0xc5,0xc8,0x72,0xf6,0x69,0x7b,0x51,0x23,0xcf,0xd9,0xa7,0x1d,0x51,0x8c,0xd3,0xa3,0x9c,0x76,0x44,0x35,0x8e,0xa8,0x7c,0xba,0x11,0x55,0x29,0x62,0xf6,0x68,0x1b,0x17,0x95,0x93,0x38,0xa3,0xed,0x5c,0x54,0x4e,0xe2,0xb4,0xb6,0x28,0x11,0x4b,0x5a,0xdd,0xda,0x62,0x48,0x43,0x79,0x49,0x6b,0x8b,0x21,0x0d,0x95,0x35,0xf0};
static const uint8_t ship[] = {0x01,0x58,0x35,0xb4,0x00,0xc3,0x89,0x14,0x60,0x7a,0x91,0x02,0x4c,0xaf,0x5a,0x80,0xe1,0x58,0x12,0x30,0x6b,0x48,0x02,0x66,0x36,0x39,0xed,0x4c,0xc2,0xd2,0x16,0xe7,0xb4,0x2d,0xb0,0x69,0xfa,0xe6,0xd3,0x36,0xcf,0x6a,0x15,0xbb,0x4f,0xdb,0x8c,0xa9,0xa5,0xe7,0x3d,0x6d,0xd3,0xae,0x1a,0x9e,0x17,0x1e};
static const uint8_t ships[] = {0x01,0x58,0xc5,0xa5,0x00,0xc3,0xab,0x14,0x60,0x7a,0x91,0x02,0x4c,0xaf,0x52,0x80,0x61,0x59,0x12,0xb0,0x6a,0x48,0x02,0x66,0x76,0x39,0xed,0x4a,0xca,0xd4,0x1e,0xe7,0xb4,0x3d,0xb2,0x49,0xc6,0xea,0xd3,0x36,0xcf,0x6a,0x15,0xbb,0x4f,0xdb,0xac,0xaa,0xa5,0xe7,0x3d,0x6d,0xd3,0xae,0x1a,0x9e,0x77,0xb4,0x4d,0xbb,0x6a,0x78,0x5e,0x80,0x00,0x44,0x65,0x59,0x80,0x21,0xd4,0x4e,0x78,0x53,0x84,0x94,0xc5,0x3e,0xe1,0xeb,0x91,0xea,0x61,0xc7,0x00,0x8b,0x73,0x3c};
static const uint8_t warpactivated[] = {0xa5,0x95,0xae,0xab,0x14,0x93,0x95,0x56,0xba,0xce,0x52,0x4c,0x5a,0x5a,0xe9,0xaa,0x5a,0xa0,0x59,0x6b,0x95,0xed,0x6a,0x85,0x64,0xab,0x75,0xba,0x26,0x8d,0xdc,0x9d,0xd6,0xab,0x9a,0x72,0x72,0x77,0x5a,0x63,0xb7,0xcd,0xd9,0xfb,0x69,0x8d,0xbb,0x76,0x67,0xef,0xab,0xd5,0xee,0xda,0x5c,0xbc,0x9f,0x76,0x2a,0x57,0xf7,0x48,0x72,0xda,0x65,0xd2,0xc2,0xc3,0xc9,0x69,0x97,0x49,0x0b,0x0f,0x27,0xa3,0x8d,0x8f,0xd2,0x2d,0xeb,0xa4,0x36,0x5e,0xd1,0x0c,0x6b,0x42,0x00,0xde,0xd0,0xa0,0xb9,0xad,0x58,0x56,0xaa,0x9d,0x55,0xb5,0x90,0x19,0x6e,0xb1,0x52,0x55,0xbd,0x95,0xb9,0xc9,0x81,0xd3,0x96,0x28,0x6d,0x3d,0x56,0x4e,0x9b,0xa3,0xb4,0xcd,0x58,0x39,0x6d,0x8e,0xd2,0x36,0x63,0xe5,0xb4,0x39,0x7b,0x64,0x8f,0xb1,0xd3,0xe6,0xec,0x91,0x3d,0xc6,0x4e,0xbb,0x74,0x46,0x7a,0xa4,0x3e,0x6d,0xce,0xdc,0xe1,0x8d,0x7c,0xb5,0xa5,0x70,0x87,0x17,0xb2,0x52,0xe4,0xcc,0xe3,0x91,0xd4,0x50,0x95,0x03,0x45,0x98,0x5b,0x46,0xed,0x94,0x6e,0xc2,0x5e,0xe5,0xf4,0xd7,0x77,0x5b,0x58,0x94,0x33,0x76,0xa1,0x62,0x65,0xa9,0x4f,0x9b,0xa5,0x79,0x94,0xb7,0x5c,0x6d,0x96,0xe6,0x51,0xde,0xaa,0xb4,0x85,0x59,0x58,0x59,0xa3,0xd4,0x56,0x6a,0x41,0xae,0xb5,0x4b,0x5b,0xa9,0x39,0xbb,0xd4,0x3e,0x6d,0xf6,0x66,0x1a,0x76,0xe9,0xb4,0xc5,0x99,0x69,0xd8,0xed,0xd3,0x36,0xad,0x6e,0xed,0x8f,0x4f,0xdb,0x8c,0xba,0x95,0x3f,0x3e,0x6d,0x33,0xea,0x56,0xfe,0xf8,0xb4,0xcd,0xa8,0x5b,0xfb,0xe3,0xd2,0x36,0xad,0x6e,0xed,0xb7,0x46,0x3b,0x5d,0x98,0x96,0x5b,0x3d,0x63,0x35,0xa2,0xee,0xbe,0x64,0xb5,0xc5,0x72,0x84,0xef,0xd8,0xd5,0x16,0xcb,0x11,0xbe,0x63,0x47,0x5b,0x2c,0x47,0xf8,0x8e,0x2d,0x6d,0xb1,0x9c,0x1e,0x57,0x36,0xb5,0xcd,0x92,0x2b,0xd9,0x9c,0xd4,0x36,0x4b,0x6e,0x64,0x93,0x5b,0x53,0x0d,0xb9,0x89,0x4f,0x0e,0x59,0x52,0xd2,0x11,0x33,0xe6,0x01};
static const uint8_t temperature[] = {0x05,0xe8,0x4c,0x23,0x00,0x5d,0x8a,0x16,0x20,0x4a,0x8b,0x06,0x78,0xab,0x75,0xda,0x96,0x38,0x34,0x73,0xf2,0x69,0x9b,0x73,0x93,0xb6,0x47,0xa7,0x6d,0xce,0x4d,0xdb,0x6e,0xb5,0xd6,0x7a,0x33,0xcd,0xa8,0xe3,0x5a,0x1b,0xc4,0xb4,0xa2,0x31,0x04,0x20,0x4b,0x8b,0x33,0xa6,0xe2,0xce,0x61,0x69,0x4e,0x9b,0x2a,0xab,0x9b,0x2e,0x39,0x6d,0xb4,0x2e,0xd5,0x7c,0xfb,0xb4,0xd1,0xba,0x56,0xf3,0xed,0xd3,0x46,0xeb,0x5a,0xcd,0xb7,0x57,0x9b,0x94,0x46,0xa5,0xcf,0x6b,0x6d,0xd3,0xac,0x9a,0xdc,0xc4,0x01,0x2b,0xb0,0x14,0xa0,0x0b,0xca,0x02,0x4c,0xc5,0x56,0x80,0xa9,0xc8,0x12,0x30,0x0d,0xe9,0x69,0x9b,0xe4,0x54,0xef,0x3a,0xa7,0xcd,0x5a,0xc2,0xd6,0x6b,0x9d,0x36,0x6b,0x09,0x3b,0xaf,0x75,0xda,0x94,0x44,0xa2,0x3c,0xeb,0x69,0x63,0x66,0xab,0xf4,0x55,0xa7,0x8d,0x99,0x3d,0xd2,0xef,0x9c,0x36,0x66,0xf6,0x48,0xbf,0xbd,0xda,0x98,0xd9,0xa3,0xfc,0xc9,0x69,0x73,0x50,0xe3,0xd2,0xc5,0xa7,0xcd,0x41,0x9d,0x4b,0x17,0x9f,0x2e,0x07,0x35,0x2e,0x5d,0xdc,0xda,0x6c,0xd8,0xad,0x25,0x76,0x6b,0xb3,0x61,0xb7,0x92,0xd8,0xf0};
static const uint8_t tobattlestation[] = {0x09,0x18,0xc1,0xac,0x00,0x41,0x4a,0x9c,0xd6,0x5b,0xcb,0x70,0x9b,0xb5,0x5a,0x6f,0x2c,0xd3,0x75,0x56,0xe9,0x7c,0x08,0x55,0xb1,0x26,0xa9,0xb5,0xc6,0xc2,0xc2,0x92,0xa4,0xd6,0x5a,0x4d,0x0b,0xad,0x1d,0x5a,0x67,0xa5,0x34,0x2c,0x09,0xc0,0x69,0x52,0x92,0x10,0xaf,0x32,0xa7,0xcd,0x5e,0x86,0x7b,0xca,0x9c,0x36,0x05,0x6b,0xab,0x2d,0x7a,0xda,0x58,0x3c,0xbb,0xda,0xdc,0x69,0x63,0x89,0x9c,0x2a,0xab,0xa7,0x8d,0x25,0x72,0xaa,0xac,0x9e,0x36,0xc7,0x72,0xd7,0x29,0x7b,0xba,0xec,0x2a,0x4d,0xb2,0xf6,0x69,0x8b,0x8e,0x12,0xd7,0xc4,0xa7,0x0d,0xb5,0x98,0xdb,0xe2,0xac,0x36,0xf4,0x08,0xb1,0x3a,0x7d,0x3a,0x1f,0xaa,0x54,0x6c,0xd5,0x6a,0x7d,0xa8,0x32,0xd6,0x55,0xab,0xf5,0xa1,0x4a,0x59,0x57,0x8d,0xd6,0xfb,0x2e,0x63,0x5d,0x95,0x80,0x8e,0xa4,0x03,0xd0,0x99,0x58,0x00,0x1a,0xd5,0x80,0x00,0x2c,0xe9,0x71,0xea,0x26,0xcc,0xd5,0xbd,0xf1,0x69,0x8b,0x91,0x0a,0xaf,0x45,0xa7,0xab,0x46,0x3d,0xbc,0x5e,0x9d,0xb6,0x3a,0x75,0xf3,0x5e,0x79,0xda,0x6a,0xd5,0xdd,0x7b,0xe1,0x69,0xab,0x53,0x37,0xef,0x85,0xa7,0xad,0x4e,0xdd,0xbc,0x56,0x25,0x60,0x58,0x91,0x04,0x8c,0x60,0x5c,0x80,0xe1,0x8c,0x4f,0x39,0x02,0xb3,0x95,0xa7,0x3d,0x6d,0xf7,0xe4,0x96,0xb6,0xea,0xb4,0xdd,0x93,0x5b,0xea,0xaa,0xd3,0x36,0xc7,0x6e,0x26,0x6b,0x47,0x57,0x0d,0x45,0x71,0x6c,0x19,0x6d,0xd1,0x14,0x45,0xd9,0x66,0xb4,0x45,0x53,0x14,0x45,0x9b,0xd6,0x16,0x4d,0xd1,0x14,0x6d,0x5a,0x5b,0x34,0x45,0x51,0xb4,0x29,0x6d,0xd1,0xe4,0xcd,0xd1,0x06,0x1e};
static const uint8_t standbyfordockingmanouver[] = {0x06,0x18,0xd8,0xd5,0x00,0x9b,0x98,0x1a,0x60,0x12,0x0b,0x01,0x74,0xe4,0x0e,0x0e,0x28,0xdc,0xe3,0x54,0xcd,0xb8,0x5a,0x58,0x9b,0xd3,0x56,0xab,0x16,0x9a,0x8b,0x4f,0x5b,0xad,0x5a,0x58,0x2e,0x3e,0x6d,0xb5,0xe1,0x19,0x39,0xeb,0xb4,0xd5,0x86,0x67,0xe4,0xac,0xd3,0x16,0x5b,0xee,0x91,0xb5,0x4e,0x57,0x6c,0xbb,0x55,0xd5,0x5e,0x5d,0x61,0xa2,0x97,0x5c,0x79,0xb4,0x85,0x89,0x7c,0x51,0x99,0xd2,0x66,0x2e,0x7a,0xc6,0x53,0x4b,0x6b,0x5d,0x9a,0xb8,0x36,0x3a,0x6d,0x8c,0x95,0x26,0x31,0xf9,0xb4,0xa1,0x64,0x8b,0x65,0x9d,0xd3,0xc6,0xd4,0xe1,0x9a,0x73,0x4e,0x9b,0xe2,0x84,0x6b,0x4d,0x39,0x6d,0x8a,0x13,0xae,0x35,0xe5,0xb4,0x29,0x4e,0xb8,0xd6,0x94,0xd3,0xa6,0x38,0xee,0x56,0x93,0x4f,0x9b,0xd3,0x98,0x56,0xcd,0x3e,0x6d,0x0e,0xed,0xda,0xb9,0xea,0xb4,0x39,0xb4,0x6b,0xd7,0xea,0xd3,0xe6,0xd0,0xa1,0x95,0xab,0x4f,0x9b,0x43,0x87,0x56,0xae,0x3e,0x5d,0x8d,0x2a,0xb1,0x5e,0xfb,0xb4,0x35,0x89,0xf8,0x65,0xcd,0xd3,0xd6,0x24,0xe2,0x97,0x35,0x4f,0x5b,0x93,0x88,0x5f,0xd6,0x3c,0x5d,0x0b,0x22,0xe1,0xb9,0x69,0xb5,0x2d,0xb0,0x94,0x67,0xaf,0xd1,0xb6,0xc0,0x92,0x9e,0xbd,0x04,0x50,0x8c,0xb9,0x00,0xaa,0x76,0x15,0x40,0xd5,0x6e,0x0a,0x60,0x29,0xe3,0x74,0x6e,0xba,0xbb,0x58,0x93,0xd3,0xfa,0x19,0xe6,0xa2,0x6d,0x56,0xeb,0x8f,0x53,0xb4,0x2e,0x5e,0xad,0xdf,0x4e,0x91,0xb2,0xe6,0xb4,0xb9,0xb3,0x85,0xeb,0xaa,0xd2,0x56,0x83,0x85,0xe1,0x59,0x52,0x5b,0x35,0xa4,0xb4,0xc7,0x29,0x6d,0x33,0xe8,0x1a,0x11,0xe7,0xb4,0x33,0x55,0x78,0xb8,0xed,0xd3,0x14,0x6d,0x9e,0xe2,0xab,0x4f,0x9b,0x5c,0xb8,0x79,0xdd,0x3a,0x6d,0x72,0xe1,0xe6,0x75,0xeb,0x34,0x29,0x65,0xaa,0xd7,0xec,0xd3,0xa6,0x94,0xa9,0x5e,0xb3,0x4f,0x9b,0x52,0xa6,0x7a,0xcd,0x3e,0x5d,0xce,0x69,0x16,0x3e,0xe5,0x74,0x39,0x86,0x59,0x78,0xe5,0xd4,0x46,0xa7,0xd2,0x11,0x76,0x18,0x50,0xa8,0x88,0x03,0xac,0xf0,0x3a,0x5d,0x53,0xa4,0xd1,0x51,0xf9,0x74,0x55,0xb2,0x46,0x67,0xe5,0xd1,0x46,0x45,0xdd,0x9a,0x4e,0x47,0x1b,0x15,0x55,0x6b,0x39,0x1d,0x6d,0x54,0x54,0xad,0xe5,0x74,0xb4,0x51,0x51,0xb5,0x96,0xd3,0xd1,0x46,0x45,0xd5,0x5a,0x4e,0x57,0x1b,0x35,0x65,0x68,0x26,0x39,0x6d,0x89,0x1e,0xec,0x3a,0xe7,0xb4,0x25,0x7a,0xb0,0xeb,0x9c,0xd1,0x66,0x85,0xd6,0xe2,0x4b,0x46,0x9b,0x15,0xda,0xa8,0x35,0x39,0x6d,0xb2,0x1a,0xea,0x51,0xeb,0xb4,0xc9,0x99,0x4b,0xc5,0xec,0xd5,0x46,0x6f,0xae,0x15,0xb3,0x57,0x1b,0x82,0xb9,0xa5,0xcf,0x1e,0x5d,0x08,0xe6,0x96,0x3e,0xab,0xb5,0x21,0x98,0x5b,0xc6,0xac,0xd4,0x85,0x60,0xc6,0xe1,0xad,0x4a,0x1b,0xbd,0x99,0xb8,0x27,0x3e,0x6d,0x29,0x61,0x61,0xb4,0xfa,0xb4,0xb9,0xaa,0x85,0xf1,0xe2,0xd1,0xa6,0x4e,0x5e,0xa9,0x8f,0x47,0x9b,0x3a,0x79,0xa5,0xbe,0x1e,0x6d,0xea,0xec,0x95,0xfa,0xa6,0xb4,0xa9,0x53,0x54,0xda,0xe3,0xd0,0xa6,0x2a,0x96,0x15,0x6d,0x1e};
