/**
 * @file MCP9808SensorLib_example.ino
 *
 * @author positronic57
 *
 * @brief Arduino sketch as MCP9808SensorLib demo.
 *
 * @details The sensor is configured to measure the temperature
 * continuously with resolution of +/-0.25°C.
 *
 * @date: 27.07.2025
 *
 * @copyright GNU General Public License v2
 *
 */


#include "MCP9808SensorLib.h"

MCP9808Sensor temperature_sensor;

bool sensor_present = false;

void setup() {
  Serial.begin(9600);
  
  delay(100);

  sensor_present = temperature_sensor.begin();

  if (!sensor_present) {
    Serial.println("Error: MCP9808 sensor not detected!");
    return;
  }

  Serial.println("Info: MCP9808 sensor present");

  sensor_present = true;
}

void loop() {
  float temperature = 0.0;

  for(;;) {
    if (sensor_present) {
      temperature = temperature_sensor.readTemperature();
      Serial.print("T = ");
      Serial.print(temperature);
      Serial.println("[°C]");
    }
    delay(5000);
  }
}
