This is a yet another library for communication with Microchip MCP9808 temperature sensor on Arduino boards. The I2C I/O operations are done using Arduino Wire library.

### Implemented functionalities
The library provide functions for:
- reading the temperature sample;
- changing the resolution of the temperature measurement;
- switching between the continuous conversion and shutdown mode of operation.

Alarms or interrupts are not supported.

### Supported architectures
- AVR (Arduino boards based on Atmega328p microcontroller);
- ESP32C6 (boards based on ESP32C6 and supported by the latest Arduino ESP32 APIs by Espressif System).

### Functions
* __begin()__ - the function initializes the connection with the sensor and prepares for I2C I/O operations. The default I2C address is 0x18. It configures the sensor to perform a continuous temperature sampling with resolution of ±0.25°C. as default settings. Use the arguments of the functions to begin with a different mode and resolution. This function should be called only once.

* __setModOfOperation()__ - switch between the different mods of operation: shutdown (the sensor is still accessible via I2C bus for configuration but does not perform temperature measurements) and continuous temperature measurements.

* __setResolution()__ - change the resolution of the temperature measurement by providing one of the four possible values as an argument.

* __readTemperature()__ - use this function to get the current temperature value in °C.

### Test hardware and software APIs
Arduino UNO R2, Arduino Nano with Arduino AVR Boards v1.8.6; Seeed Studio XIAO ESP32C6 with Arduino ESP32 by Espressif System v3.3.0. 


**WARNING:** 
The source is provided as it is without any warranty. Use it on your own risk!
The author does not take any responsibility for the damage caused while using this software.

**DISCLAIMER:**
The code is a result of a hobby work and the author is not affiliated with any of the hardware/components/boards manufacturers mentioned in the code, documentation or the description of this project. All trademarks are the property of the respective owners.

 