#ifndef MOTORON_PROTOCOL_H
#define MOTORON_PROTOCOL_H

#define MOTORON_CMD_GET_FIRMWARE_VERSION 0x87
#define MOTORON_CMD_SET_PROTOCOL_OPTIONS 0x8B
#define MOTORON_CMD_READ_EEPROM 0x93
#define MOTORON_CMD_WRITE_EEPROM 0x95
#define MOTORON_CMD_REINITIALIZE 0x96
#define MOTORON_CMD_RESET 0x99
#define MOTORON_CMD_GET_VARIABLES 0x9A
#define MOTORON_CMD_SET_VARIABLE 0x9C
#define MOTORON_CMD_COAST_NOW 0xA5
#define MOTORON_CMD_CLEAR_MOTOR_FAULT 0xA6
#define MOTORON_CMD_CLEAR_LATCHED_STATUS_FLAGS 0xA9
#define MOTORON_CMD_SET_LATCHED_STATUS_FLAGS 0xAC
#define MOTORON_CMD_SET_BRAKING 0xB1
#define MOTORON_CMD_SET_BRAKING_NOW 0xB2
#define MOTORON_CMD_SET_SPEED 0xD1
#define MOTORON_CMD_SET_SPEED_NOW 0xD2
#define MOTORON_CMD_SET_BUFFERED_SPEED 0xD4
#define MOTORON_CMD_SET_ALL_SPEEDS 0xE1
#define MOTORON_CMD_SET_ALL_SPEEDS_NOW 0xE2
#define MOTORON_CMD_SET_ALL_BUFFERED_SPEEDS 0xE4
#define MOTORON_CMD_SET_ALL_SPEEDS_USING_BUFFERS 0xF0
#define MOTORON_CMD_SET_ALL_SPEEDS_NOW_USING_BUFFERS 0xF3
#define MOTORON_CMD_RESET_COMMAND_TIMEOUT 0xF5
#define MOTORON_CMD_MULTI_DEVICE_ERROR_CHECK 0xF9
#define MOTORON_CMD_MULTI_DEVICE_WRITE 0xFA

#define MOTORON_SETTING_FACTORY_RESET_CODE 0
#define MOTORON_SETTING_DEVICE_NUMBER 1
#define MOTORON_SETTING_ALTERNATIVE_DEVICE_NUMBER 3
#define MOTORON_SETTING_COMMUNICATION_OPTIONS 5
#define MOTORON_SETTING_BAUD_DIVIDER 6
#define MOTORON_SETTING_RESPONSE_DELAY 8

#define MOTORON_VAR_PROTOCOL_OPTIONS 0
#define MOTORON_VAR_STATUS_FLAGS 1
#define MOTORON_VAR_VIN_VOLTAGE 3
#define MOTORON_VAR_COMMAND_TIMEOUT 5
#define MOTORON_VAR_ERROR_RESPONSE 7
#define MOTORON_VAR_ERROR_MASK 8
#define MOTORON_VAR_JUMPER_STATE 10
#define MOTORON_VAR_UART_FAULT_FLAGS 11
#define MOTORON_VAR_UART_FAULTS 11

#define MOTORON_MVAR_PWM_MODE 1
#define MOTORON_MVAR_TARGET_SPEED 2
#define MOTORON_MVAR_TARGET_BRAKE_AMOUNT 4
#define MOTORON_MVAR_CURRENT_SPEED 6
#define MOTORON_MVAR_BUFFERED_SPEED 8
#define MOTORON_MVAR_MAX_ACCEL_FORWARD 10
#define MOTORON_MVAR_MAX_ACCEL_REVERSE 12
#define MOTORON_MVAR_MAX_DECEL_FORWARD 14
#define MOTORON_MVAR_MAX_DECEL_REVERSE 16
#define MOTORON_MVAR_STARTING_SPEED_FORWARD 18
#define MOTORON_MVAR_STARTING_SPEED_REVERSE 20
#define MOTORON_MVAR_DIRECTION_CHANGE_DELAY_FORWARD 22
#define MOTORON_MVAR_DIRECTION_CHANGE_DELAY_REVERSE 23
#define MOTORON_MVAR_MAX_DECEL_TMP 24
#define MOTORON_MVAR_CURRENT_LIMIT 26
#define MOTORON_MVAR_CURRENT_SENSE_RAW 28
#define MOTORON_MVAR_CURRENT_SENSE_SPEED 30
#define MOTORON_MVAR_CURRENT_SENSE_PROCESSED 32
#define MOTORON_MVAR_CURRENT_SENSE_OFFSET 34
#define MOTORON_MVAR_CURRENT_SENSE_MINIMUM_DIVISOR 35

#define MOTORON_PROTOCOL_OPTION_CRC_FOR_COMMANDS 0
#define MOTORON_PROTOCOL_OPTION_CRC_FOR_RESPONSES 1
#define MOTORON_PROTOCOL_OPTION_I2C_GENERAL_CALL 2

#define MOTORON_COMMUNICATION_OPTION_7BIT_RESPONSES 0
#define MOTORON_COMMUNICATION_OPTION_14BIT_DEVICE_NUMBER 1
#define MOTORON_COMMUNICATION_OPTION_ERR_IS_DE 2

#define MOTORON_STATUS_FLAG_PROTOCOL_ERROR 0
#define MOTORON_STATUS_FLAG_CRC_ERROR 1
#define MOTORON_STATUS_FLAG_COMMAND_TIMEOUT_LATCHED 2
#define MOTORON_STATUS_FLAG_MOTOR_FAULT_LATCHED 3
#define MOTORON_STATUS_FLAG_NO_POWER_LATCHED 4
#define MOTORON_STATUS_FLAG_UART_ERROR 5
#define MOTORON_STATUS_FLAG_RESET 9
#define MOTORON_STATUS_FLAG_COMMAND_TIMEOUT 10
#define MOTORON_STATUS_FLAG_MOTOR_FAULTING 11
#define MOTORON_STATUS_FLAG_NO_POWER 12
#define MOTORON_STATUS_FLAG_ERROR_ACTIVE 13
#define MOTORON_STATUS_FLAG_MOTOR_OUTPUT_ENABLED 14
#define MOTORON_STATUS_FLAG_MOTOR_DRIVING 15

#define MOTORON_UART_FAULT_FRAMING 0
#define MOTORON_UART_FAULT_NOISE 1
#define MOTORON_UART_FAULT_HARDWARE_OVERRUN 2
#define MOTORON_UART_FAULT_SOFTWARE_OVERRUN 3

#define MOTORON_ERROR_RESPONSE_COAST 0
#define MOTORON_ERROR_RESPONSE_BRAKE 1
#define MOTORON_ERROR_RESPONSE_COAST_NOW 2
#define MOTORON_ERROR_RESPONSE_BRAKE_NOW 3

#define MOTORON_PWM_MODE_DEFAULT 0
#define MOTORON_PWM_MODE_1_KHZ 1
#define MOTORON_PWM_MODE_2_KHZ 2
#define MOTORON_PWM_MODE_4_KHZ 3
#define MOTORON_PWM_MODE_5_KHZ 4
#define MOTORON_PWM_MODE_10_KHZ 5
#define MOTORON_PWM_MODE_20_KHZ 6
#define MOTORON_PWM_MODE_40_KHZ 7
#define MOTORON_PWM_MODE_80_KHZ 8

#define MOTORON_JMP1_INSTALLED 0
#define MOTORON_JMP1_NOT_INSTALLED 1

#define MOTORON_CLEAR_MOTOR_FAULT_UNCONDITIONAL 0

#define MOTORON_ERROR_CHECK_CONTINUE 0x3C
#define MOTORON_ERROR_CHECK_DONE 0x00

#define MOTORON_MAX_SPEED 800
#define MOTORON_MAX_ACCEL 6400
#define MOTORON_MAX_DIRECTION_CHANGE_DELAY 250

#define MOTORON_LATCHED_STATUS_FLAGS 0x03FF
#define MOTORON_MAX_ERROR_MASK 0x07FF

#define MOTORON_MAX_COMMAND_TIMEOUT 16250

#define MOTORON_MIN_BAUD_RATE 245
#define MOTORON_MAX_BAUD_RATE 1000000

#endif
