#ifndef __POKEROPO_I2C_SLAVE_HANDLER_H__
#define __POKEROPO_I2C_SLAVE_HANDLER_H__

#include <Arduino.h>

class I2CSlaveInterface {
  public:
    virtual void* getRxBuffer();
    virtual int getRxBufferSize();
    virtual void* getTxBuffer();
    virtual int getTxBufferSize();
    virtual void processRxData();
    virtual void prepareTxData();
};

class I2CSlaveHandler {
  public:
    I2CSlaveHandler(I2CSlaveInterface* ioProcessor=NULL);
    void begin(byte slaveAddress, void (*receiveEvent)(int), void (*requestEvent)(void));
    void next();
    void receiveEvent(int numBytesReceived);
    void requestEvent();
    void reset();
  protected:
    virtual void logNullProcessorError_();
    virtual void debugReset_();
  private:
    I2CSlaveInterface* _ioProcessor = NULL;
    bool _txDataReady = false;
    bool _rxDataReady = false;
    bool _requestSent = false;
};

#endif
