#ifndef __POKEROPO_I2C_MASTER_HANDLER_H__
#define __POKEROPO_I2C_MASTER_HANDLER_H__

#include <Arduino.h>

class I2CMasterInterface {
  public:
    virtual void* getTxBuffer();
    virtual int getTxBufferSize();
    virtual void* getRxBuffer();
    virtual int getRxBufferSize();
    virtual void prepareTxData();
    virtual void processRxData();
};

class I2CMasterHandler {
  public:
    I2CMasterHandler();
    void begin(byte masterAddress);
    void call(byte slaveAddress, I2CMasterInterface* ioProcessor);
    void call(byte slaveAddress, void* txBuffer, int txBufferSize, void* rxBuffer, int rxBufferSize);
    int8_t send(byte slaveAddress, void* buffer, int bufferSize);
    int8_t request(byte slaveAddress, void* buffer, int bufferSize);
  protected:
    void call_(byte slaveAddress,
        void* txBuffer, int txBufferSize, void* rxBuffer, int rxBufferSize,
        I2CMasterInterface* ioProcessor);
  private:
    bool _txDataReady = false;
    bool _rxDataReady = false;
    bool _rqDataReady = false;
    unsigned long _updateInterval = 100;
    unsigned long _prevUpdateTime = 0;
};

#endif
