#include "Pokerobo_I2C.h"

struct EquationDefinition {
  uint32_t no;              //  4 byte(s)
  float a;                  //  4
  float b;                  //  4
  float c;                  //  4
  byte padding[16];         // 16
                            //------
                            // 32
};

struct EquationSolution {
  uint32_t no;              //  4 byte(s)
  byte numberOfSolutions;   //  1
  float x1;                 //  4
  float x2;                 //  4
  byte padding[19];         // 19
                            //------
                            // 32
};

class I2CSlaveProcessorDemo: public I2CSlaveInterface {
  public:
    void* getRxBuffer() {
      return (void*)&eqDefinition;
    }

    int getRxBufferSize() {
      return sizeof(EquationDefinition);
    }

    void* getTxBuffer() {
      return (void*)&eqSolutionOutput;
    }

    int getTxBufferSize() {
      return sizeof(EquationSolution);
    }

    void processRxData() {
      EquationDefinition* rxData = &eqDefinition;
      Serial.print("Solving quadratic equation ("),
          Serial.print(rxData->no), Serial.print("): ");
      Serial.print(rxData->a), Serial.print("x^2");
      Serial.print(" + ");
      Serial.print(rxData->b), Serial.print("x");
      Serial.print(" + ");
      Serial.print(rxData->c), Serial.print(" = 0");
      Serial.println();

      eqSolution.no = rxData->no;
      float delta = rxData->b*rxData->b - rxData->a*rxData->c*4;
      if (delta > 0) {
        float sqrtDelta = sqrt(delta);
        eqSolution.numberOfSolutions = 2;
        eqSolution.x1 = (-rxData->b + sqrtDelta)/rxData->a/2.0;
        eqSolution.x2 = (-rxData->b - sqrtDelta)/rxData->a/2.0;
      } else if (delta == 0.0) {
        eqSolution.numberOfSolutions = 1;
        eqSolution.x1 = -rxData->b/rxData->a/2.0;
        eqSolution.x2 = 0;
      } else {
        eqSolution.numberOfSolutions = 0;
        eqSolution.x1 = 0;
        eqSolution.x2 = 0;
      }
    };

    void prepareTxData() {
      memcpy((void*)&eqSolutionOutput, (void*)&eqSolution, sizeof(EquationSolution));
    };
  private:
    EquationDefinition eqDefinition;
    EquationSolution eqSolution;
    EquationSolution eqSolutionOutput;
};

//-------------------------------------------------------------------------------------------------

I2CSlaveProcessorDemo i2cSlaveProcessor;
I2CSlaveHandler i2cWorker(&i2cSlaveProcessor);

const byte slaveAddress = 9;

void setup() {
  Serial.begin(57600);

  i2cWorker.begin(slaveAddress,
    [] (int numBytesReceived) { i2cWorker.receiveEvent(numBytesReceived); },
    [] () { i2cWorker.requestEvent(); }
  );
}

void loop() {
  i2cWorker.next();
}
