#include "Pokerobo_I2C.h"

struct EquationDefinition {
  uint32_t no;              //  4 byte(s)
  float a;                  //  4
  float b;                  //  4
  float c;                  //  4
  byte padding[16];         // 16
                            //------
                            // 32
};

struct EquationSolution {
  uint32_t no;              //  4 byte(s)
  byte numberOfSolutions;   //  1
  float x1;                 //  4
  float x2;                 //  4
  byte padding[19];         // 19
                            //------
                            // 32
};

class I2CMasterProcessorDemo: public I2CMasterInterface {
  public:
    void* getTxBuffer();
    int getTxBufferSize();
    void* getRxBuffer();
    int getRxBufferSize();
    void prepareTxData();
    void processRxData();
  private:
    uint32_t _counter = 0;
    EquationDefinition eqDefinition;
    EquationSolution eqSolution;
};

int randomSignal() {
  return (random(6) > 2) ? 1 : -1;
}

void* I2CMasterProcessorDemo::getTxBuffer() {
  return (void*)&eqDefinition;
}

int I2CMasterProcessorDemo::getTxBufferSize() {
  return sizeof(EquationDefinition);
}

void* I2CMasterProcessorDemo::getRxBuffer() {
  return (void*)&eqSolution;
}

int I2CMasterProcessorDemo::getRxBufferSize() {
  return sizeof(EquationSolution);
}

void I2CMasterProcessorDemo::prepareTxData() {
  EquationDefinition* txData = &eqDefinition;
  txData->no = ++_counter;
  txData->a = randomSignal() * random(1, 101);
  txData->b = randomSignal() * random(1, 101);
  txData->c = randomSignal() * random(1, 101);

  Serial.print("Master: ("), Serial.print(txData->no), Serial.print("): ");
  Serial.print(txData->a), Serial.print("x^2");
  Serial.print(" + ");
  Serial.print(txData->b), Serial.print("x");
  Serial.print(" + ");
  Serial.print(txData->c), Serial.print(" = 0");
  Serial.println();
}

void I2CMasterProcessorDemo::processRxData() {
  EquationSolution* rxData = &eqSolution;
  Serial.print("Result ("), Serial.print(rxData->no), Serial.print("): ");
  if (rxData->numberOfSolutions <= 0) {
    Serial.println("the equation has no solution");
  } else if (rxData->numberOfSolutions == 1) {
    Serial.print("the equation has exactly one solution x="),
        Serial.print(rxData->x1);
    Serial.println();
  } else {
    Serial.print("the equation has two solutions x1="),
        Serial.print(rxData->x1),
        Serial.print(", x2="), Serial.print(rxData->x2);
    Serial.println();
  }
}

//-------------------------------------------------------------------------------------------------

I2CMasterProcessorDemo i2cMasterProcessor;

I2CMasterHandler i2cMaster;

const byte masterAddress = 8;
const byte slaveAddress = 9;

void setup() {
  Serial.begin(57600);
  i2cMaster.begin(masterAddress);
}

void loop() {
  i2cMaster.call(slaveAddress, &i2cMasterProcessor);
}
