// This file is based on code from the OpenCV project, converted using the
// code in https://github.com/pmarques-dev/aruco-database-converter.
// It is subject to the license terms in the LICENSE file found on this folder
// and at http://opencv.org/license.html.

#define ARUCO_DB_ORIGINAL	1
#define ARUCO_DB_4X4_1000	2
#define ARUCO_DB_5X5_1000	3
#define ARUCO_DB_6X6_1000	4
#define ARUCO_DB_7X7_1000	5
#define ARUCO_DB_ARUCO_MIP_36h12	6
#define ARUCO_DB_APRILTAG_16h5	7
#define ARUCO_DB_APRILTAG_25h9	8
#define ARUCO_DB_APRILTAG_36h10	9
#define ARUCO_DB_APRILTAG_36h11	10

#if !defined(ARUCO_DB)

#error you need to select one aruco database by defining ARUCO_DB to be one of: ARUCO_DB_ORIGINAL ARUCO_DB_4X4_1000 ARUCO_DB_5X5_1000 ARUCO_DB_6X6_1000 ARUCO_DB_7X7_1000 ARUCO_DB_ARUCO_MIP_36h12 ARUCO_DB_APRILTAG_16h5 ARUCO_DB_APRILTAG_25h9 ARUCO_DB_APRILTAG_36h10 ARUCO_DB_APRILTAG_36h11

#elif (ARUCO_DB == ARUCO_DB_ORIGINAL)

#ifndef ARUCO_DB_SIZE
#define ARUCO_DB_SIZE 1024
#endif

#define ARUCO_BITS	5

static unsigned char database[ARUCO_DB_SIZE][4][4] = {
	#if (ARUCO_DB_SIZE > 0)
		{ { 132,33,8,0 }, { 0,0,15,1 }, { 8,66,16,1 }, { 248,0,0,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1)
		{ { 132,33,11,1 }, { 8,66,15,1 }, { 232,66,16,1 }, { 248,33,8,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2)
		{ { 132,33,4,1 }, { 8,0,31,0 }, { 144,66,16,1 }, { 124,0,8,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 3)
		{ { 132,33,7,0 }, { 0,66,31,0 }, { 112,66,16,1 }, { 124,33,0,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 4)
		{ { 132,33,120,0 }, { 16,132,15,1 }, { 15,66,16,1 }, { 248,16,132,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 5)
		{ { 132,33,123,1 }, { 24,198,15,1 }, { 239,66,16,1 }, { 248,49,140,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 6)
		{ { 132,33,116,1 }, { 24,132,31,0 }, { 151,66,16,1 }, { 124,16,140,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 7)
		{ { 132,33,119,0 }, { 16,198,31,0 }, { 119,66,16,1 }, { 124,49,132,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 8)
		{ { 132,32,152,0 }, { 16,0,46,1 }, { 12,130,16,1 }, { 186,0,4,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 9)
		{ { 132,32,155,1 }, { 24,66,46,1 }, { 236,130,16,1 }, { 186,33,12,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 10)
		{ { 132,32,148,1 }, { 24,0,62,0 }, { 148,130,16,1 }, { 62,0,12,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 11)
		{ { 132,32,151,0 }, { 16,66,62,0 }, { 116,130,16,1 }, { 62,33,4,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 12)
		{ { 132,32,232,0 }, { 0,132,46,1 }, { 11,130,16,1 }, { 186,16,128,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 13)
		{ { 132,32,235,1 }, { 8,198,46,1 }, { 235,130,16,1 }, { 186,49,136,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 14)
		{ { 132,32,228,1 }, { 8,132,62,0 }, { 147,130,16,1 }, { 62,16,136,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 15)
		{ { 132,32,231,0 }, { 0,198,62,0 }, { 115,130,16,1 }, { 62,49,128,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 16)
		{ { 132,47,8,0 }, { 33,8,15,1 }, { 8,122,16,1 }, { 248,8,66,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 17)
		{ { 132,47,11,1 }, { 41,74,15,1 }, { 232,122,16,1 }, { 248,41,74,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 18)
		{ { 132,47,4,1 }, { 41,8,31,0 }, { 144,122,16,1 }, { 124,8,74,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 19)
		{ { 132,47,7,0 }, { 33,74,31,0 }, { 112,122,16,1 }, { 124,41,66,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 20)
		{ { 132,47,120,0 }, { 49,140,15,1 }, { 15,122,16,1 }, { 248,24,198,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 21)
		{ { 132,47,123,1 }, { 57,206,15,1 }, { 239,122,16,1 }, { 248,57,206,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 22)
		{ { 132,47,116,1 }, { 57,140,31,0 }, { 151,122,16,1 }, { 124,24,206,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 23)
		{ { 132,47,119,0 }, { 49,206,31,0 }, { 119,122,16,1 }, { 124,57,198,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 24)
		{ { 132,46,152,0 }, { 49,8,46,1 }, { 12,186,16,1 }, { 186,8,70,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 25)
		{ { 132,46,155,1 }, { 57,74,46,1 }, { 236,186,16,1 }, { 186,41,78,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 26)
		{ { 132,46,148,1 }, { 57,8,62,0 }, { 148,186,16,1 }, { 62,8,78,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 27)
		{ { 132,46,151,0 }, { 49,74,62,0 }, { 116,186,16,1 }, { 62,41,70,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 28)
		{ { 132,46,232,0 }, { 33,140,46,1 }, { 11,186,16,1 }, { 186,24,194,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 29)
		{ { 132,46,235,1 }, { 41,206,46,1 }, { 235,186,16,1 }, { 186,57,202,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 30)
		{ { 132,46,228,1 }, { 41,140,62,0 }, { 147,186,16,1 }, { 62,24,202,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 31)
		{ { 132,46,231,0 }, { 33,206,62,0 }, { 115,186,16,1 }, { 62,57,194,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 32)
		{ { 132,19,8,0 }, { 32,0,77,1 }, { 8,100,16,1 }, { 217,0,2,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 33)
		{ { 132,19,11,1 }, { 40,66,77,1 }, { 232,100,16,1 }, { 217,33,10,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 34)
		{ { 132,19,4,1 }, { 40,0,93,0 }, { 144,100,16,1 }, { 93,0,10,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 35)
		{ { 132,19,7,0 }, { 32,66,93,0 }, { 112,100,16,1 }, { 93,33,2,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 36)
		{ { 132,19,120,0 }, { 48,132,77,1 }, { 15,100,16,1 }, { 217,16,134,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 37)
		{ { 132,19,123,1 }, { 56,198,77,1 }, { 239,100,16,1 }, { 217,49,142,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 38)
		{ { 132,19,116,1 }, { 56,132,93,0 }, { 151,100,16,1 }, { 93,16,142,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 39)
		{ { 132,19,119,0 }, { 48,198,93,0 }, { 119,100,16,1 }, { 93,49,134,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 40)
		{ { 132,18,152,0 }, { 48,0,108,1 }, { 12,164,16,1 }, { 155,0,6,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 41)
		{ { 132,18,155,1 }, { 56,66,108,1 }, { 236,164,16,1 }, { 155,33,14,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 42)
		{ { 132,18,148,1 }, { 56,0,124,0 }, { 148,164,16,1 }, { 31,0,14,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 43)
		{ { 132,18,151,0 }, { 48,66,124,0 }, { 116,164,16,1 }, { 31,33,6,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 44)
		{ { 132,18,232,0 }, { 32,132,108,1 }, { 11,164,16,1 }, { 155,16,130,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 45)
		{ { 132,18,235,1 }, { 40,198,108,1 }, { 235,164,16,1 }, { 155,49,138,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 46)
		{ { 132,18,228,1 }, { 40,132,124,0 }, { 147,164,16,1 }, { 31,16,138,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 47)
		{ { 132,18,231,0 }, { 32,198,124,0 }, { 115,164,16,1 }, { 31,49,130,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 48)
		{ { 132,29,8,0 }, { 1,8,77,1 }, { 8,92,16,1 }, { 217,8,64,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 49)
		{ { 132,29,11,1 }, { 9,74,77,1 }, { 232,92,16,1 }, { 217,41,72,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 50)
		{ { 132,29,4,1 }, { 9,8,93,0 }, { 144,92,16,1 }, { 93,8,72,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 51)
		{ { 132,29,7,0 }, { 1,74,93,0 }, { 112,92,16,1 }, { 93,41,64,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 52)
		{ { 132,29,120,0 }, { 17,140,77,1 }, { 15,92,16,1 }, { 217,24,196,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 53)
		{ { 132,29,123,1 }, { 25,206,77,1 }, { 239,92,16,1 }, { 217,57,204,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 54)
		{ { 132,29,116,1 }, { 25,140,93,0 }, { 151,92,16,1 }, { 93,24,204,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 55)
		{ { 132,29,119,0 }, { 17,206,93,0 }, { 119,92,16,1 }, { 93,57,196,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 56)
		{ { 132,28,152,0 }, { 17,8,108,1 }, { 12,156,16,1 }, { 155,8,68,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 57)
		{ { 132,28,155,1 }, { 25,74,108,1 }, { 236,156,16,1 }, { 155,41,76,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 58)
		{ { 132,28,148,1 }, { 25,8,124,0 }, { 148,156,16,1 }, { 31,8,76,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 59)
		{ { 132,28,151,0 }, { 17,74,124,0 }, { 116,156,16,1 }, { 31,41,68,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 60)
		{ { 132,28,232,0 }, { 1,140,108,1 }, { 11,156,16,1 }, { 155,24,192,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 61)
		{ { 132,28,235,1 }, { 9,206,108,1 }, { 235,156,16,1 }, { 155,57,200,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 62)
		{ { 132,28,228,1 }, { 9,140,124,0 }, { 147,156,16,1 }, { 31,24,200,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 63)
		{ { 132,28,231,0 }, { 1,206,124,0 }, { 115,156,16,1 }, { 31,57,192,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 64)
		{ { 133,225,8,0 }, { 66,16,15,1 }, { 8,67,208,1 }, { 248,4,33,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 65)
		{ { 133,225,11,1 }, { 74,82,15,1 }, { 232,67,208,1 }, { 248,37,41,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 66)
		{ { 133,225,4,1 }, { 74,16,31,0 }, { 144,67,208,1 }, { 124,4,41,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 67)
		{ { 133,225,7,0 }, { 66,82,31,0 }, { 112,67,208,1 }, { 124,37,33,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 68)
		{ { 133,225,120,0 }, { 82,148,15,1 }, { 15,67,208,1 }, { 248,20,165,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 69)
		{ { 133,225,123,1 }, { 90,214,15,1 }, { 239,67,208,1 }, { 248,53,173,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 70)
		{ { 133,225,116,1 }, { 90,148,31,0 }, { 151,67,208,1 }, { 124,20,173,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 71)
		{ { 133,225,119,0 }, { 82,214,31,0 }, { 119,67,208,1 }, { 124,53,165,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 72)
		{ { 133,224,152,0 }, { 82,16,46,1 }, { 12,131,208,1 }, { 186,4,37,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 73)
		{ { 133,224,155,1 }, { 90,82,46,1 }, { 236,131,208,1 }, { 186,37,45,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 74)
		{ { 133,224,148,1 }, { 90,16,62,0 }, { 148,131,208,1 }, { 62,4,45,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 75)
		{ { 133,224,151,0 }, { 82,82,62,0 }, { 116,131,208,1 }, { 62,37,37,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 76)
		{ { 133,224,232,0 }, { 66,148,46,1 }, { 11,131,208,1 }, { 186,20,161,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 77)
		{ { 133,224,235,1 }, { 74,214,46,1 }, { 235,131,208,1 }, { 186,53,169,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 78)
		{ { 133,224,228,1 }, { 74,148,62,0 }, { 147,131,208,1 }, { 62,20,169,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 79)
		{ { 133,224,231,0 }, { 66,214,62,0 }, { 115,131,208,1 }, { 62,53,161,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 80)
		{ { 133,239,8,0 }, { 99,24,15,1 }, { 8,123,208,1 }, { 248,12,99,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 81)
		{ { 133,239,11,1 }, { 107,90,15,1 }, { 232,123,208,1 }, { 248,45,107,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 82)
		{ { 133,239,4,1 }, { 107,24,31,0 }, { 144,123,208,1 }, { 124,12,107,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 83)
		{ { 133,239,7,0 }, { 99,90,31,0 }, { 112,123,208,1 }, { 124,45,99,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 84)
		{ { 133,239,120,0 }, { 115,156,15,1 }, { 15,123,208,1 }, { 248,28,231,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 85)
		{ { 133,239,123,1 }, { 123,222,15,1 }, { 239,123,208,1 }, { 248,61,239,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 86)
		{ { 133,239,116,1 }, { 123,156,31,0 }, { 151,123,208,1 }, { 124,28,239,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 87)
		{ { 133,239,119,0 }, { 115,222,31,0 }, { 119,123,208,1 }, { 124,61,231,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 88)
		{ { 133,238,152,0 }, { 115,24,46,1 }, { 12,187,208,1 }, { 186,12,103,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 89)
		{ { 133,238,155,1 }, { 123,90,46,1 }, { 236,187,208,1 }, { 186,45,111,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 90)
		{ { 133,238,148,1 }, { 123,24,62,0 }, { 148,187,208,1 }, { 62,12,111,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 91)
		{ { 133,238,151,0 }, { 115,90,62,0 }, { 116,187,208,1 }, { 62,45,103,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 92)
		{ { 133,238,232,0 }, { 99,156,46,1 }, { 11,187,208,1 }, { 186,28,227,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 93)
		{ { 133,238,235,1 }, { 107,222,46,1 }, { 235,187,208,1 }, { 186,61,235,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 94)
		{ { 133,238,228,1 }, { 107,156,62,0 }, { 147,187,208,1 }, { 62,28,235,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 95)
		{ { 133,238,231,0 }, { 99,222,62,0 }, { 115,187,208,1 }, { 62,61,227,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 96)
		{ { 133,211,8,0 }, { 98,16,77,1 }, { 8,101,208,1 }, { 217,4,35,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 97)
		{ { 133,211,11,1 }, { 106,82,77,1 }, { 232,101,208,1 }, { 217,37,43,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 98)
		{ { 133,211,4,1 }, { 106,16,93,0 }, { 144,101,208,1 }, { 93,4,43,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 99)
		{ { 133,211,7,0 }, { 98,82,93,0 }, { 112,101,208,1 }, { 93,37,35,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 100)
		{ { 133,211,120,0 }, { 114,148,77,1 }, { 15,101,208,1 }, { 217,20,167,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 101)
		{ { 133,211,123,1 }, { 122,214,77,1 }, { 239,101,208,1 }, { 217,53,175,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 102)
		{ { 133,211,116,1 }, { 122,148,93,0 }, { 151,101,208,1 }, { 93,20,175,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 103)
		{ { 133,211,119,0 }, { 114,214,93,0 }, { 119,101,208,1 }, { 93,53,167,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 104)
		{ { 133,210,152,0 }, { 114,16,108,1 }, { 12,165,208,1 }, { 155,4,39,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 105)
		{ { 133,210,155,1 }, { 122,82,108,1 }, { 236,165,208,1 }, { 155,37,47,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 106)
		{ { 133,210,148,1 }, { 122,16,124,0 }, { 148,165,208,1 }, { 31,4,47,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 107)
		{ { 133,210,151,0 }, { 114,82,124,0 }, { 116,165,208,1 }, { 31,37,39,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 108)
		{ { 133,210,232,0 }, { 98,148,108,1 }, { 11,165,208,1 }, { 155,20,163,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 109)
		{ { 133,210,235,1 }, { 106,214,108,1 }, { 235,165,208,1 }, { 155,53,171,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 110)
		{ { 133,210,228,1 }, { 106,148,124,0 }, { 147,165,208,1 }, { 31,20,171,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 111)
		{ { 133,210,231,0 }, { 98,214,124,0 }, { 115,165,208,1 }, { 31,53,163,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 112)
		{ { 133,221,8,0 }, { 67,24,77,1 }, { 8,93,208,1 }, { 217,12,97,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 113)
		{ { 133,221,11,1 }, { 75,90,77,1 }, { 232,93,208,1 }, { 217,45,105,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 114)
		{ { 133,221,4,1 }, { 75,24,93,0 }, { 144,93,208,1 }, { 93,12,105,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 115)
		{ { 133,221,7,0 }, { 67,90,93,0 }, { 112,93,208,1 }, { 93,45,97,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 116)
		{ { 133,221,120,0 }, { 83,156,77,1 }, { 15,93,208,1 }, { 217,28,229,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 117)
		{ { 133,221,123,1 }, { 91,222,77,1 }, { 239,93,208,1 }, { 217,61,237,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 118)
		{ { 133,221,116,1 }, { 91,156,93,0 }, { 151,93,208,1 }, { 93,28,237,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 119)
		{ { 133,221,119,0 }, { 83,222,93,0 }, { 119,93,208,1 }, { 93,61,229,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 120)
		{ { 133,220,152,0 }, { 83,24,108,1 }, { 12,157,208,1 }, { 155,12,101,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 121)
		{ { 133,220,155,1 }, { 91,90,108,1 }, { 236,157,208,1 }, { 155,45,109,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 122)
		{ { 133,220,148,1 }, { 91,24,124,0 }, { 148,157,208,1 }, { 31,12,109,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 123)
		{ { 133,220,151,0 }, { 83,90,124,0 }, { 116,157,208,1 }, { 31,45,101,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 124)
		{ { 133,220,232,0 }, { 67,156,108,1 }, { 11,157,208,1 }, { 155,28,225,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 125)
		{ { 133,220,235,1 }, { 75,222,108,1 }, { 235,157,208,1 }, { 155,61,233,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 126)
		{ { 133,220,228,1 }, { 75,156,124,0 }, { 147,157,208,1 }, { 31,28,233,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 127)
		{ { 133,220,231,0 }, { 67,222,124,0 }, { 115,157,208,1 }, { 31,61,225,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 128)
		{ { 130,97,8,0 }, { 64,0,139,1 }, { 8,67,32,1 }, { 232,128,1,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 129)
		{ { 130,97,11,1 }, { 72,66,139,1 }, { 232,67,32,1 }, { 232,161,9,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 130)
		{ { 130,97,4,1 }, { 72,0,155,0 }, { 144,67,32,1 }, { 108,128,9,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 131)
		{ { 130,97,7,0 }, { 64,66,155,0 }, { 112,67,32,1 }, { 108,161,1,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 132)
		{ { 130,97,120,0 }, { 80,132,139,1 }, { 15,67,32,1 }, { 232,144,133,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 133)
		{ { 130,97,123,1 }, { 88,198,139,1 }, { 239,67,32,1 }, { 232,177,141,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 134)
		{ { 130,97,116,1 }, { 88,132,155,0 }, { 151,67,32,1 }, { 108,144,141,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 135)
		{ { 130,97,119,0 }, { 80,198,155,0 }, { 119,67,32,1 }, { 108,177,133,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 136)
		{ { 130,96,152,0 }, { 80,0,170,1 }, { 12,131,32,1 }, { 170,128,5,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 137)
		{ { 130,96,155,1 }, { 88,66,170,1 }, { 236,131,32,1 }, { 170,161,13,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 138)
		{ { 130,96,148,1 }, { 88,0,186,0 }, { 148,131,32,1 }, { 46,128,13,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 139)
		{ { 130,96,151,0 }, { 80,66,186,0 }, { 116,131,32,1 }, { 46,161,5,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 140)
		{ { 130,96,232,0 }, { 64,132,170,1 }, { 11,131,32,1 }, { 170,144,129,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 141)
		{ { 130,96,235,1 }, { 72,198,170,1 }, { 235,131,32,1 }, { 170,177,137,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 142)
		{ { 130,96,228,1 }, { 72,132,186,0 }, { 147,131,32,1 }, { 46,144,137,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 143)
		{ { 130,96,231,0 }, { 64,198,186,0 }, { 115,131,32,1 }, { 46,177,129,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 144)
		{ { 130,111,8,0 }, { 97,8,139,1 }, { 8,123,32,1 }, { 232,136,67,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 145)
		{ { 130,111,11,1 }, { 105,74,139,1 }, { 232,123,32,1 }, { 232,169,75,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 146)
		{ { 130,111,4,1 }, { 105,8,155,0 }, { 144,123,32,1 }, { 108,136,75,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 147)
		{ { 130,111,7,0 }, { 97,74,155,0 }, { 112,123,32,1 }, { 108,169,67,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 148)
		{ { 130,111,120,0 }, { 113,140,139,1 }, { 15,123,32,1 }, { 232,152,199,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 149)
		{ { 130,111,123,1 }, { 121,206,139,1 }, { 239,123,32,1 }, { 232,185,207,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 150)
		{ { 130,111,116,1 }, { 121,140,155,0 }, { 151,123,32,1 }, { 108,152,207,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 151)
		{ { 130,111,119,0 }, { 113,206,155,0 }, { 119,123,32,1 }, { 108,185,199,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 152)
		{ { 130,110,152,0 }, { 113,8,170,1 }, { 12,187,32,1 }, { 170,136,71,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 153)
		{ { 130,110,155,1 }, { 121,74,170,1 }, { 236,187,32,1 }, { 170,169,79,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 154)
		{ { 130,110,148,1 }, { 121,8,186,0 }, { 148,187,32,1 }, { 46,136,79,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 155)
		{ { 130,110,151,0 }, { 113,74,186,0 }, { 116,187,32,1 }, { 46,169,71,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 156)
		{ { 130,110,232,0 }, { 97,140,170,1 }, { 11,187,32,1 }, { 170,152,195,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 157)
		{ { 130,110,235,1 }, { 105,206,170,1 }, { 235,187,32,1 }, { 170,185,203,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 158)
		{ { 130,110,228,1 }, { 105,140,186,0 }, { 147,187,32,1 }, { 46,152,203,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 159)
		{ { 130,110,231,0 }, { 97,206,186,0 }, { 115,187,32,1 }, { 46,185,195,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 160)
		{ { 130,83,8,0 }, { 96,0,201,1 }, { 8,101,32,1 }, { 201,128,3,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 161)
		{ { 130,83,11,1 }, { 104,66,201,1 }, { 232,101,32,1 }, { 201,161,11,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 162)
		{ { 130,83,4,1 }, { 104,0,217,0 }, { 144,101,32,1 }, { 77,128,11,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 163)
		{ { 130,83,7,0 }, { 96,66,217,0 }, { 112,101,32,1 }, { 77,161,3,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 164)
		{ { 130,83,120,0 }, { 112,132,201,1 }, { 15,101,32,1 }, { 201,144,135,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 165)
		{ { 130,83,123,1 }, { 120,198,201,1 }, { 239,101,32,1 }, { 201,177,143,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 166)
		{ { 130,83,116,1 }, { 120,132,217,0 }, { 151,101,32,1 }, { 77,144,143,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 167)
		{ { 130,83,119,0 }, { 112,198,217,0 }, { 119,101,32,1 }, { 77,177,135,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 168)
		{ { 130,82,152,0 }, { 112,0,232,1 }, { 12,165,32,1 }, { 139,128,7,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 169)
		{ { 130,82,155,1 }, { 120,66,232,1 }, { 236,165,32,1 }, { 139,161,15,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 170)
		{ { 130,82,148,1 }, { 120,0,248,0 }, { 148,165,32,1 }, { 15,128,15,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 171)
		{ { 130,82,151,0 }, { 112,66,248,0 }, { 116,165,32,1 }, { 15,161,7,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 172)
		{ { 130,82,232,0 }, { 96,132,232,1 }, { 11,165,32,1 }, { 139,144,131,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 173)
		{ { 130,82,235,1 }, { 104,198,232,1 }, { 235,165,32,1 }, { 139,177,139,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 174)
		{ { 130,82,228,1 }, { 104,132,248,0 }, { 147,165,32,1 }, { 15,144,139,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 175)
		{ { 130,82,231,0 }, { 96,198,248,0 }, { 115,165,32,1 }, { 15,177,131,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 176)
		{ { 130,93,8,0 }, { 65,8,201,1 }, { 8,93,32,1 }, { 201,136,65,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 177)
		{ { 130,93,11,1 }, { 73,74,201,1 }, { 232,93,32,1 }, { 201,169,73,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 178)
		{ { 130,93,4,1 }, { 73,8,217,0 }, { 144,93,32,1 }, { 77,136,73,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 179)
		{ { 130,93,7,0 }, { 65,74,217,0 }, { 112,93,32,1 }, { 77,169,65,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 180)
		{ { 130,93,120,0 }, { 81,140,201,1 }, { 15,93,32,1 }, { 201,152,197,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 181)
		{ { 130,93,123,1 }, { 89,206,201,1 }, { 239,93,32,1 }, { 201,185,205,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 182)
		{ { 130,93,116,1 }, { 89,140,217,0 }, { 151,93,32,1 }, { 77,152,205,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 183)
		{ { 130,93,119,0 }, { 81,206,217,0 }, { 119,93,32,1 }, { 77,185,197,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 184)
		{ { 130,92,152,0 }, { 81,8,232,1 }, { 12,157,32,1 }, { 139,136,69,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 185)
		{ { 130,92,155,1 }, { 89,74,232,1 }, { 236,157,32,1 }, { 139,169,77,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 186)
		{ { 130,92,148,1 }, { 89,8,248,0 }, { 148,157,32,1 }, { 15,136,77,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 187)
		{ { 130,92,151,0 }, { 81,74,248,0 }, { 116,157,32,1 }, { 15,169,69,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 188)
		{ { 130,92,232,0 }, { 65,140,232,1 }, { 11,157,32,1 }, { 139,152,193,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 189)
		{ { 130,92,235,1 }, { 73,206,232,1 }, { 235,157,32,1 }, { 139,185,201,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 190)
		{ { 130,92,228,1 }, { 73,140,248,0 }, { 147,157,32,1 }, { 15,152,201,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 191)
		{ { 130,92,231,0 }, { 65,206,248,0 }, { 115,157,32,1 }, { 15,185,193,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 192)
		{ { 131,161,8,0 }, { 2,16,139,1 }, { 8,66,224,1 }, { 232,132,32,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 193)
		{ { 131,161,11,1 }, { 10,82,139,1 }, { 232,66,224,1 }, { 232,165,40,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 194)
		{ { 131,161,4,1 }, { 10,16,155,0 }, { 144,66,224,1 }, { 108,132,40,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 195)
		{ { 131,161,7,0 }, { 2,82,155,0 }, { 112,66,224,1 }, { 108,165,32,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 196)
		{ { 131,161,120,0 }, { 18,148,139,1 }, { 15,66,224,1 }, { 232,148,164,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 197)
		{ { 131,161,123,1 }, { 26,214,139,1 }, { 239,66,224,1 }, { 232,181,172,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 198)
		{ { 131,161,116,1 }, { 26,148,155,0 }, { 151,66,224,1 }, { 108,148,172,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 199)
		{ { 131,161,119,0 }, { 18,214,155,0 }, { 119,66,224,1 }, { 108,181,164,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 200)
		{ { 131,160,152,0 }, { 18,16,170,1 }, { 12,130,224,1 }, { 170,132,36,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 201)
		{ { 131,160,155,1 }, { 26,82,170,1 }, { 236,130,224,1 }, { 170,165,44,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 202)
		{ { 131,160,148,1 }, { 26,16,186,0 }, { 148,130,224,1 }, { 46,132,44,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 203)
		{ { 131,160,151,0 }, { 18,82,186,0 }, { 116,130,224,1 }, { 46,165,36,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 204)
		{ { 131,160,232,0 }, { 2,148,170,1 }, { 11,130,224,1 }, { 170,148,160,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 205)
		{ { 131,160,235,1 }, { 10,214,170,1 }, { 235,130,224,1 }, { 170,181,168,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 206)
		{ { 131,160,228,1 }, { 10,148,186,0 }, { 147,130,224,1 }, { 46,148,168,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 207)
		{ { 131,160,231,0 }, { 2,214,186,0 }, { 115,130,224,1 }, { 46,181,160,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 208)
		{ { 131,175,8,0 }, { 35,24,139,1 }, { 8,122,224,1 }, { 232,140,98,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 209)
		{ { 131,175,11,1 }, { 43,90,139,1 }, { 232,122,224,1 }, { 232,173,106,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 210)
		{ { 131,175,4,1 }, { 43,24,155,0 }, { 144,122,224,1 }, { 108,140,106,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 211)
		{ { 131,175,7,0 }, { 35,90,155,0 }, { 112,122,224,1 }, { 108,173,98,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 212)
		{ { 131,175,120,0 }, { 51,156,139,1 }, { 15,122,224,1 }, { 232,156,230,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 213)
		{ { 131,175,123,1 }, { 59,222,139,1 }, { 239,122,224,1 }, { 232,189,238,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 214)
		{ { 131,175,116,1 }, { 59,156,155,0 }, { 151,122,224,1 }, { 108,156,238,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 215)
		{ { 131,175,119,0 }, { 51,222,155,0 }, { 119,122,224,1 }, { 108,189,230,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 216)
		{ { 131,174,152,0 }, { 51,24,170,1 }, { 12,186,224,1 }, { 170,140,102,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 217)
		{ { 131,174,155,1 }, { 59,90,170,1 }, { 236,186,224,1 }, { 170,173,110,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 218)
		{ { 131,174,148,1 }, { 59,24,186,0 }, { 148,186,224,1 }, { 46,140,110,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 219)
		{ { 131,174,151,0 }, { 51,90,186,0 }, { 116,186,224,1 }, { 46,173,102,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 220)
		{ { 131,174,232,0 }, { 35,156,170,1 }, { 11,186,224,1 }, { 170,156,226,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 221)
		{ { 131,174,235,1 }, { 43,222,170,1 }, { 235,186,224,1 }, { 170,189,234,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 222)
		{ { 131,174,228,1 }, { 43,156,186,0 }, { 147,186,224,1 }, { 46,156,234,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 223)
		{ { 131,174,231,0 }, { 35,222,186,0 }, { 115,186,224,1 }, { 46,189,226,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 224)
		{ { 131,147,8,0 }, { 34,16,201,1 }, { 8,100,224,1 }, { 201,132,34,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 225)
		{ { 131,147,11,1 }, { 42,82,201,1 }, { 232,100,224,1 }, { 201,165,42,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 226)
		{ { 131,147,4,1 }, { 42,16,217,0 }, { 144,100,224,1 }, { 77,132,42,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 227)
		{ { 131,147,7,0 }, { 34,82,217,0 }, { 112,100,224,1 }, { 77,165,34,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 228)
		{ { 131,147,120,0 }, { 50,148,201,1 }, { 15,100,224,1 }, { 201,148,166,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 229)
		{ { 131,147,123,1 }, { 58,214,201,1 }, { 239,100,224,1 }, { 201,181,174,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 230)
		{ { 131,147,116,1 }, { 58,148,217,0 }, { 151,100,224,1 }, { 77,148,174,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 231)
		{ { 131,147,119,0 }, { 50,214,217,0 }, { 119,100,224,1 }, { 77,181,166,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 232)
		{ { 131,146,152,0 }, { 50,16,232,1 }, { 12,164,224,1 }, { 139,132,38,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 233)
		{ { 131,146,155,1 }, { 58,82,232,1 }, { 236,164,224,1 }, { 139,165,46,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 234)
		{ { 131,146,148,1 }, { 58,16,248,0 }, { 148,164,224,1 }, { 15,132,46,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 235)
		{ { 131,146,151,0 }, { 50,82,248,0 }, { 116,164,224,1 }, { 15,165,38,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 236)
		{ { 131,146,232,0 }, { 34,148,232,1 }, { 11,164,224,1 }, { 139,148,162,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 237)
		{ { 131,146,235,1 }, { 42,214,232,1 }, { 235,164,224,1 }, { 139,181,170,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 238)
		{ { 131,146,228,1 }, { 42,148,248,0 }, { 147,164,224,1 }, { 15,148,170,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 239)
		{ { 131,146,231,0 }, { 34,214,248,0 }, { 115,164,224,1 }, { 15,181,162,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 240)
		{ { 131,157,8,0 }, { 3,24,201,1 }, { 8,92,224,1 }, { 201,140,96,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 241)
		{ { 131,157,11,1 }, { 11,90,201,1 }, { 232,92,224,1 }, { 201,173,104,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 242)
		{ { 131,157,4,1 }, { 11,24,217,0 }, { 144,92,224,1 }, { 77,140,104,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 243)
		{ { 131,157,7,0 }, { 3,90,217,0 }, { 112,92,224,1 }, { 77,173,96,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 244)
		{ { 131,157,120,0 }, { 19,156,201,1 }, { 15,92,224,1 }, { 201,156,228,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 245)
		{ { 131,157,123,1 }, { 27,222,201,1 }, { 239,92,224,1 }, { 201,189,236,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 246)
		{ { 131,157,116,1 }, { 27,156,217,0 }, { 151,92,224,1 }, { 77,156,236,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 247)
		{ { 131,157,119,0 }, { 19,222,217,0 }, { 119,92,224,1 }, { 77,189,228,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 248)
		{ { 131,156,152,0 }, { 19,24,232,1 }, { 12,156,224,1 }, { 139,140,100,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 249)
		{ { 131,156,155,1 }, { 27,90,232,1 }, { 236,156,224,1 }, { 139,173,108,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 250)
		{ { 131,156,148,1 }, { 27,24,248,0 }, { 148,156,224,1 }, { 15,140,108,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 251)
		{ { 131,156,151,0 }, { 19,90,248,0 }, { 116,156,224,1 }, { 15,173,100,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 252)
		{ { 131,156,232,0 }, { 3,156,232,1 }, { 11,156,224,1 }, { 139,156,224,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 253)
		{ { 131,156,235,1 }, { 11,222,232,1 }, { 235,156,224,1 }, { 139,189,232,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 254)
		{ { 131,156,228,1 }, { 11,156,248,0 }, { 147,156,224,1 }, { 15,156,232,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 255)
		{ { 131,156,231,0 }, { 3,222,248,0 }, { 115,156,224,1 }, { 15,189,224,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 256)
		{ { 188,33,8,0 }, { 132,32,15,1 }, { 8,66,30,1 }, { 248,2,16,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 257)
		{ { 188,33,11,1 }, { 140,98,15,1 }, { 232,66,30,1 }, { 248,35,24,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 258)
		{ { 188,33,4,1 }, { 140,32,31,0 }, { 144,66,30,1 }, { 124,2,24,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 259)
		{ { 188,33,7,0 }, { 132,98,31,0 }, { 112,66,30,1 }, { 124,35,16,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 260)
		{ { 188,33,120,0 }, { 148,164,15,1 }, { 15,66,30,1 }, { 248,18,148,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 261)
		{ { 188,33,123,1 }, { 156,230,15,1 }, { 239,66,30,1 }, { 248,51,156,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 262)
		{ { 188,33,116,1 }, { 156,164,31,0 }, { 151,66,30,1 }, { 124,18,156,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 263)
		{ { 188,33,119,0 }, { 148,230,31,0 }, { 119,66,30,1 }, { 124,51,148,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 264)
		{ { 188,32,152,0 }, { 148,32,46,1 }, { 12,130,30,1 }, { 186,2,20,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 265)
		{ { 188,32,155,1 }, { 156,98,46,1 }, { 236,130,30,1 }, { 186,35,28,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 266)
		{ { 188,32,148,1 }, { 156,32,62,0 }, { 148,130,30,1 }, { 62,2,28,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 267)
		{ { 188,32,151,0 }, { 148,98,62,0 }, { 116,130,30,1 }, { 62,35,20,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 268)
		{ { 188,32,232,0 }, { 132,164,46,1 }, { 11,130,30,1 }, { 186,18,144,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 269)
		{ { 188,32,235,1 }, { 140,230,46,1 }, { 235,130,30,1 }, { 186,51,152,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 270)
		{ { 188,32,228,1 }, { 140,164,62,0 }, { 147,130,30,1 }, { 62,18,152,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 271)
		{ { 188,32,231,0 }, { 132,230,62,0 }, { 115,130,30,1 }, { 62,51,144,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 272)
		{ { 188,47,8,0 }, { 165,40,15,1 }, { 8,122,30,1 }, { 248,10,82,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 273)
		{ { 188,47,11,1 }, { 173,106,15,1 }, { 232,122,30,1 }, { 248,43,90,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 274)
		{ { 188,47,4,1 }, { 173,40,31,0 }, { 144,122,30,1 }, { 124,10,90,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 275)
		{ { 188,47,7,0 }, { 165,106,31,0 }, { 112,122,30,1 }, { 124,43,82,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 276)
		{ { 188,47,120,0 }, { 181,172,15,1 }, { 15,122,30,1 }, { 248,26,214,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 277)
		{ { 188,47,123,1 }, { 189,238,15,1 }, { 239,122,30,1 }, { 248,59,222,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 278)
		{ { 188,47,116,1 }, { 189,172,31,0 }, { 151,122,30,1 }, { 124,26,222,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 279)
		{ { 188,47,119,0 }, { 181,238,31,0 }, { 119,122,30,1 }, { 124,59,214,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 280)
		{ { 188,46,152,0 }, { 181,40,46,1 }, { 12,186,30,1 }, { 186,10,86,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 281)
		{ { 188,46,155,1 }, { 189,106,46,1 }, { 236,186,30,1 }, { 186,43,94,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 282)
		{ { 188,46,148,1 }, { 189,40,62,0 }, { 148,186,30,1 }, { 62,10,94,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 283)
		{ { 188,46,151,0 }, { 181,106,62,0 }, { 116,186,30,1 }, { 62,43,86,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 284)
		{ { 188,46,232,0 }, { 165,172,46,1 }, { 11,186,30,1 }, { 186,26,210,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 285)
		{ { 188,46,235,1 }, { 173,238,46,1 }, { 235,186,30,1 }, { 186,59,218,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 286)
		{ { 188,46,228,1 }, { 173,172,62,0 }, { 147,186,30,1 }, { 62,26,218,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 287)
		{ { 188,46,231,0 }, { 165,238,62,0 }, { 115,186,30,1 }, { 62,59,210,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 288)
		{ { 188,19,8,0 }, { 164,32,77,1 }, { 8,100,30,1 }, { 217,2,18,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 289)
		{ { 188,19,11,1 }, { 172,98,77,1 }, { 232,100,30,1 }, { 217,35,26,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 290)
		{ { 188,19,4,1 }, { 172,32,93,0 }, { 144,100,30,1 }, { 93,2,26,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 291)
		{ { 188,19,7,0 }, { 164,98,93,0 }, { 112,100,30,1 }, { 93,35,18,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 292)
		{ { 188,19,120,0 }, { 180,164,77,1 }, { 15,100,30,1 }, { 217,18,150,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 293)
		{ { 188,19,123,1 }, { 188,230,77,1 }, { 239,100,30,1 }, { 217,51,158,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 294)
		{ { 188,19,116,1 }, { 188,164,93,0 }, { 151,100,30,1 }, { 93,18,158,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 295)
		{ { 188,19,119,0 }, { 180,230,93,0 }, { 119,100,30,1 }, { 93,51,150,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 296)
		{ { 188,18,152,0 }, { 180,32,108,1 }, { 12,164,30,1 }, { 155,2,22,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 297)
		{ { 188,18,155,1 }, { 188,98,108,1 }, { 236,164,30,1 }, { 155,35,30,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 298)
		{ { 188,18,148,1 }, { 188,32,124,0 }, { 148,164,30,1 }, { 31,2,30,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 299)
		{ { 188,18,151,0 }, { 180,98,124,0 }, { 116,164,30,1 }, { 31,35,22,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 300)
		{ { 188,18,232,0 }, { 164,164,108,1 }, { 11,164,30,1 }, { 155,18,146,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 301)
		{ { 188,18,235,1 }, { 172,230,108,1 }, { 235,164,30,1 }, { 155,51,154,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 302)
		{ { 188,18,228,1 }, { 172,164,124,0 }, { 147,164,30,1 }, { 31,18,154,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 303)
		{ { 188,18,231,0 }, { 164,230,124,0 }, { 115,164,30,1 }, { 31,51,146,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 304)
		{ { 188,29,8,0 }, { 133,40,77,1 }, { 8,92,30,1 }, { 217,10,80,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 305)
		{ { 188,29,11,1 }, { 141,106,77,1 }, { 232,92,30,1 }, { 217,43,88,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 306)
		{ { 188,29,4,1 }, { 141,40,93,0 }, { 144,92,30,1 }, { 93,10,88,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 307)
		{ { 188,29,7,0 }, { 133,106,93,0 }, { 112,92,30,1 }, { 93,43,80,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 308)
		{ { 188,29,120,0 }, { 149,172,77,1 }, { 15,92,30,1 }, { 217,26,212,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 309)
		{ { 188,29,123,1 }, { 157,238,77,1 }, { 239,92,30,1 }, { 217,59,220,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 310)
		{ { 188,29,116,1 }, { 157,172,93,0 }, { 151,92,30,1 }, { 93,26,220,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 311)
		{ { 188,29,119,0 }, { 149,238,93,0 }, { 119,92,30,1 }, { 93,59,212,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 312)
		{ { 188,28,152,0 }, { 149,40,108,1 }, { 12,156,30,1 }, { 155,10,84,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 313)
		{ { 188,28,155,1 }, { 157,106,108,1 }, { 236,156,30,1 }, { 155,43,92,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 314)
		{ { 188,28,148,1 }, { 157,40,124,0 }, { 148,156,30,1 }, { 31,10,92,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 315)
		{ { 188,28,151,0 }, { 149,106,124,0 }, { 116,156,30,1 }, { 31,43,84,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 316)
		{ { 188,28,232,0 }, { 133,172,108,1 }, { 11,156,30,1 }, { 155,26,208,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 317)
		{ { 188,28,235,1 }, { 141,238,108,1 }, { 235,156,30,1 }, { 155,59,216,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 318)
		{ { 188,28,228,1 }, { 141,172,124,0 }, { 147,156,30,1 }, { 31,26,216,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 319)
		{ { 188,28,231,0 }, { 133,238,124,0 }, { 115,156,30,1 }, { 31,59,208,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 320)
		{ { 189,225,8,0 }, { 198,48,15,1 }, { 8,67,222,1 }, { 248,6,49,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 321)
		{ { 189,225,11,1 }, { 206,114,15,1 }, { 232,67,222,1 }, { 248,39,57,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 322)
		{ { 189,225,4,1 }, { 206,48,31,0 }, { 144,67,222,1 }, { 124,6,57,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 323)
		{ { 189,225,7,0 }, { 198,114,31,0 }, { 112,67,222,1 }, { 124,39,49,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 324)
		{ { 189,225,120,0 }, { 214,180,15,1 }, { 15,67,222,1 }, { 248,22,181,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 325)
		{ { 189,225,123,1 }, { 222,246,15,1 }, { 239,67,222,1 }, { 248,55,189,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 326)
		{ { 189,225,116,1 }, { 222,180,31,0 }, { 151,67,222,1 }, { 124,22,189,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 327)
		{ { 189,225,119,0 }, { 214,246,31,0 }, { 119,67,222,1 }, { 124,55,181,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 328)
		{ { 189,224,152,0 }, { 214,48,46,1 }, { 12,131,222,1 }, { 186,6,53,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 329)
		{ { 189,224,155,1 }, { 222,114,46,1 }, { 236,131,222,1 }, { 186,39,61,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 330)
		{ { 189,224,148,1 }, { 222,48,62,0 }, { 148,131,222,1 }, { 62,6,61,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 331)
		{ { 189,224,151,0 }, { 214,114,62,0 }, { 116,131,222,1 }, { 62,39,53,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 332)
		{ { 189,224,232,0 }, { 198,180,46,1 }, { 11,131,222,1 }, { 186,22,177,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 333)
		{ { 189,224,235,1 }, { 206,246,46,1 }, { 235,131,222,1 }, { 186,55,185,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 334)
		{ { 189,224,228,1 }, { 206,180,62,0 }, { 147,131,222,1 }, { 62,22,185,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 335)
		{ { 189,224,231,0 }, { 198,246,62,0 }, { 115,131,222,1 }, { 62,55,177,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 336)
		{ { 189,239,8,0 }, { 231,56,15,1 }, { 8,123,222,1 }, { 248,14,115,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 337)
		{ { 189,239,11,1 }, { 239,122,15,1 }, { 232,123,222,1 }, { 248,47,123,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 338)
		{ { 189,239,4,1 }, { 239,56,31,0 }, { 144,123,222,1 }, { 124,14,123,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 339)
		{ { 189,239,7,0 }, { 231,122,31,0 }, { 112,123,222,1 }, { 124,47,115,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 340)
		{ { 189,239,120,0 }, { 247,188,15,1 }, { 15,123,222,1 }, { 248,30,247,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 341)
		{ { 189,239,123,1 }, { 255,254,15,1 }, { 239,123,222,1 }, { 248,63,255,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 342)
		{ { 189,239,116,1 }, { 255,188,31,0 }, { 151,123,222,1 }, { 124,30,255,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 343)
		{ { 189,239,119,0 }, { 247,254,31,0 }, { 119,123,222,1 }, { 124,63,247,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 344)
		{ { 189,238,152,0 }, { 247,56,46,1 }, { 12,187,222,1 }, { 186,14,119,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 345)
		{ { 189,238,155,1 }, { 255,122,46,1 }, { 236,187,222,1 }, { 186,47,127,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 346)
		{ { 189,238,148,1 }, { 255,56,62,0 }, { 148,187,222,1 }, { 62,14,127,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 347)
		{ { 189,238,151,0 }, { 247,122,62,0 }, { 116,187,222,1 }, { 62,47,119,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 348)
		{ { 189,238,232,0 }, { 231,188,46,1 }, { 11,187,222,1 }, { 186,30,243,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 349)
		{ { 189,238,235,1 }, { 239,254,46,1 }, { 235,187,222,1 }, { 186,63,251,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 350)
		{ { 189,238,228,1 }, { 239,188,62,0 }, { 147,187,222,1 }, { 62,30,251,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 351)
		{ { 189,238,231,0 }, { 231,254,62,0 }, { 115,187,222,1 }, { 62,63,243,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 352)
		{ { 189,211,8,0 }, { 230,48,77,1 }, { 8,101,222,1 }, { 217,6,51,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 353)
		{ { 189,211,11,1 }, { 238,114,77,1 }, { 232,101,222,1 }, { 217,39,59,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 354)
		{ { 189,211,4,1 }, { 238,48,93,0 }, { 144,101,222,1 }, { 93,6,59,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 355)
		{ { 189,211,7,0 }, { 230,114,93,0 }, { 112,101,222,1 }, { 93,39,51,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 356)
		{ { 189,211,120,0 }, { 246,180,77,1 }, { 15,101,222,1 }, { 217,22,183,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 357)
		{ { 189,211,123,1 }, { 254,246,77,1 }, { 239,101,222,1 }, { 217,55,191,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 358)
		{ { 189,211,116,1 }, { 254,180,93,0 }, { 151,101,222,1 }, { 93,22,191,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 359)
		{ { 189,211,119,0 }, { 246,246,93,0 }, { 119,101,222,1 }, { 93,55,183,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 360)
		{ { 189,210,152,0 }, { 246,48,108,1 }, { 12,165,222,1 }, { 155,6,55,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 361)
		{ { 189,210,155,1 }, { 254,114,108,1 }, { 236,165,222,1 }, { 155,39,63,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 362)
		{ { 189,210,148,1 }, { 254,48,124,0 }, { 148,165,222,1 }, { 31,6,63,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 363)
		{ { 189,210,151,0 }, { 246,114,124,0 }, { 116,165,222,1 }, { 31,39,55,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 364)
		{ { 189,210,232,0 }, { 230,180,108,1 }, { 11,165,222,1 }, { 155,22,179,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 365)
		{ { 189,210,235,1 }, { 238,246,108,1 }, { 235,165,222,1 }, { 155,55,187,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 366)
		{ { 189,210,228,1 }, { 238,180,124,0 }, { 147,165,222,1 }, { 31,22,187,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 367)
		{ { 189,210,231,0 }, { 230,246,124,0 }, { 115,165,222,1 }, { 31,55,179,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 368)
		{ { 189,221,8,0 }, { 199,56,77,1 }, { 8,93,222,1 }, { 217,14,113,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 369)
		{ { 189,221,11,1 }, { 207,122,77,1 }, { 232,93,222,1 }, { 217,47,121,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 370)
		{ { 189,221,4,1 }, { 207,56,93,0 }, { 144,93,222,1 }, { 93,14,121,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 371)
		{ { 189,221,7,0 }, { 199,122,93,0 }, { 112,93,222,1 }, { 93,47,113,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 372)
		{ { 189,221,120,0 }, { 215,188,77,1 }, { 15,93,222,1 }, { 217,30,245,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 373)
		{ { 189,221,123,1 }, { 223,254,77,1 }, { 239,93,222,1 }, { 217,63,253,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 374)
		{ { 189,221,116,1 }, { 223,188,93,0 }, { 151,93,222,1 }, { 93,30,253,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 375)
		{ { 189,221,119,0 }, { 215,254,93,0 }, { 119,93,222,1 }, { 93,63,245,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 376)
		{ { 189,220,152,0 }, { 215,56,108,1 }, { 12,157,222,1 }, { 155,14,117,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 377)
		{ { 189,220,155,1 }, { 223,122,108,1 }, { 236,157,222,1 }, { 155,47,125,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 378)
		{ { 189,220,148,1 }, { 223,56,124,0 }, { 148,157,222,1 }, { 31,14,125,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 379)
		{ { 189,220,151,0 }, { 215,122,124,0 }, { 116,157,222,1 }, { 31,47,117,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 380)
		{ { 189,220,232,0 }, { 199,188,108,1 }, { 11,157,222,1 }, { 155,30,241,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 381)
		{ { 189,220,235,1 }, { 207,254,108,1 }, { 235,157,222,1 }, { 155,63,249,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 382)
		{ { 189,220,228,1 }, { 207,188,124,0 }, { 147,157,222,1 }, { 31,30,249,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 383)
		{ { 189,220,231,0 }, { 199,254,124,0 }, { 115,157,222,1 }, { 31,63,241,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 384)
		{ { 186,97,8,0 }, { 196,32,139,1 }, { 8,67,46,1 }, { 232,130,17,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 385)
		{ { 186,97,11,1 }, { 204,98,139,1 }, { 232,67,46,1 }, { 232,163,25,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 386)
		{ { 186,97,4,1 }, { 204,32,155,0 }, { 144,67,46,1 }, { 108,130,25,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 387)
		{ { 186,97,7,0 }, { 196,98,155,0 }, { 112,67,46,1 }, { 108,163,17,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 388)
		{ { 186,97,120,0 }, { 212,164,139,1 }, { 15,67,46,1 }, { 232,146,149,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 389)
		{ { 186,97,123,1 }, { 220,230,139,1 }, { 239,67,46,1 }, { 232,179,157,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 390)
		{ { 186,97,116,1 }, { 220,164,155,0 }, { 151,67,46,1 }, { 108,146,157,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 391)
		{ { 186,97,119,0 }, { 212,230,155,0 }, { 119,67,46,1 }, { 108,179,149,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 392)
		{ { 186,96,152,0 }, { 212,32,170,1 }, { 12,131,46,1 }, { 170,130,21,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 393)
		{ { 186,96,155,1 }, { 220,98,170,1 }, { 236,131,46,1 }, { 170,163,29,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 394)
		{ { 186,96,148,1 }, { 220,32,186,0 }, { 148,131,46,1 }, { 46,130,29,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 395)
		{ { 186,96,151,0 }, { 212,98,186,0 }, { 116,131,46,1 }, { 46,163,21,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 396)
		{ { 186,96,232,0 }, { 196,164,170,1 }, { 11,131,46,1 }, { 170,146,145,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 397)
		{ { 186,96,235,1 }, { 204,230,170,1 }, { 235,131,46,1 }, { 170,179,153,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 398)
		{ { 186,96,228,1 }, { 204,164,186,0 }, { 147,131,46,1 }, { 46,146,153,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 399)
		{ { 186,96,231,0 }, { 196,230,186,0 }, { 115,131,46,1 }, { 46,179,145,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 400)
		{ { 186,111,8,0 }, { 229,40,139,1 }, { 8,123,46,1 }, { 232,138,83,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 401)
		{ { 186,111,11,1 }, { 237,106,139,1 }, { 232,123,46,1 }, { 232,171,91,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 402)
		{ { 186,111,4,1 }, { 237,40,155,0 }, { 144,123,46,1 }, { 108,138,91,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 403)
		{ { 186,111,7,0 }, { 229,106,155,0 }, { 112,123,46,1 }, { 108,171,83,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 404)
		{ { 186,111,120,0 }, { 245,172,139,1 }, { 15,123,46,1 }, { 232,154,215,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 405)
		{ { 186,111,123,1 }, { 253,238,139,1 }, { 239,123,46,1 }, { 232,187,223,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 406)
		{ { 186,111,116,1 }, { 253,172,155,0 }, { 151,123,46,1 }, { 108,154,223,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 407)
		{ { 186,111,119,0 }, { 245,238,155,0 }, { 119,123,46,1 }, { 108,187,215,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 408)
		{ { 186,110,152,0 }, { 245,40,170,1 }, { 12,187,46,1 }, { 170,138,87,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 409)
		{ { 186,110,155,1 }, { 253,106,170,1 }, { 236,187,46,1 }, { 170,171,95,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 410)
		{ { 186,110,148,1 }, { 253,40,186,0 }, { 148,187,46,1 }, { 46,138,95,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 411)
		{ { 186,110,151,0 }, { 245,106,186,0 }, { 116,187,46,1 }, { 46,171,87,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 412)
		{ { 186,110,232,0 }, { 229,172,170,1 }, { 11,187,46,1 }, { 170,154,211,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 413)
		{ { 186,110,235,1 }, { 237,238,170,1 }, { 235,187,46,1 }, { 170,187,219,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 414)
		{ { 186,110,228,1 }, { 237,172,186,0 }, { 147,187,46,1 }, { 46,154,219,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 415)
		{ { 186,110,231,0 }, { 229,238,186,0 }, { 115,187,46,1 }, { 46,187,211,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 416)
		{ { 186,83,8,0 }, { 228,32,201,1 }, { 8,101,46,1 }, { 201,130,19,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 417)
		{ { 186,83,11,1 }, { 236,98,201,1 }, { 232,101,46,1 }, { 201,163,27,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 418)
		{ { 186,83,4,1 }, { 236,32,217,0 }, { 144,101,46,1 }, { 77,130,27,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 419)
		{ { 186,83,7,0 }, { 228,98,217,0 }, { 112,101,46,1 }, { 77,163,19,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 420)
		{ { 186,83,120,0 }, { 244,164,201,1 }, { 15,101,46,1 }, { 201,146,151,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 421)
		{ { 186,83,123,1 }, { 252,230,201,1 }, { 239,101,46,1 }, { 201,179,159,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 422)
		{ { 186,83,116,1 }, { 252,164,217,0 }, { 151,101,46,1 }, { 77,146,159,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 423)
		{ { 186,83,119,0 }, { 244,230,217,0 }, { 119,101,46,1 }, { 77,179,151,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 424)
		{ { 186,82,152,0 }, { 244,32,232,1 }, { 12,165,46,1 }, { 139,130,23,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 425)
		{ { 186,82,155,1 }, { 252,98,232,1 }, { 236,165,46,1 }, { 139,163,31,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 426)
		{ { 186,82,148,1 }, { 252,32,248,0 }, { 148,165,46,1 }, { 15,130,31,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 427)
		{ { 186,82,151,0 }, { 244,98,248,0 }, { 116,165,46,1 }, { 15,163,23,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 428)
		{ { 186,82,232,0 }, { 228,164,232,1 }, { 11,165,46,1 }, { 139,146,147,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 429)
		{ { 186,82,235,1 }, { 236,230,232,1 }, { 235,165,46,1 }, { 139,179,155,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 430)
		{ { 186,82,228,1 }, { 236,164,248,0 }, { 147,165,46,1 }, { 15,146,155,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 431)
		{ { 186,82,231,0 }, { 228,230,248,0 }, { 115,165,46,1 }, { 15,179,147,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 432)
		{ { 186,93,8,0 }, { 197,40,201,1 }, { 8,93,46,1 }, { 201,138,81,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 433)
		{ { 186,93,11,1 }, { 205,106,201,1 }, { 232,93,46,1 }, { 201,171,89,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 434)
		{ { 186,93,4,1 }, { 205,40,217,0 }, { 144,93,46,1 }, { 77,138,89,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 435)
		{ { 186,93,7,0 }, { 197,106,217,0 }, { 112,93,46,1 }, { 77,171,81,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 436)
		{ { 186,93,120,0 }, { 213,172,201,1 }, { 15,93,46,1 }, { 201,154,213,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 437)
		{ { 186,93,123,1 }, { 221,238,201,1 }, { 239,93,46,1 }, { 201,187,221,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 438)
		{ { 186,93,116,1 }, { 221,172,217,0 }, { 151,93,46,1 }, { 77,154,221,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 439)
		{ { 186,93,119,0 }, { 213,238,217,0 }, { 119,93,46,1 }, { 77,187,213,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 440)
		{ { 186,92,152,0 }, { 213,40,232,1 }, { 12,157,46,1 }, { 139,138,85,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 441)
		{ { 186,92,155,1 }, { 221,106,232,1 }, { 236,157,46,1 }, { 139,171,93,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 442)
		{ { 186,92,148,1 }, { 221,40,248,0 }, { 148,157,46,1 }, { 15,138,93,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 443)
		{ { 186,92,151,0 }, { 213,106,248,0 }, { 116,157,46,1 }, { 15,171,85,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 444)
		{ { 186,92,232,0 }, { 197,172,232,1 }, { 11,157,46,1 }, { 139,154,209,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 445)
		{ { 186,92,235,1 }, { 205,238,232,1 }, { 235,157,46,1 }, { 139,187,217,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 446)
		{ { 186,92,228,1 }, { 205,172,248,0 }, { 147,157,46,1 }, { 15,154,217,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 447)
		{ { 186,92,231,0 }, { 197,238,248,0 }, { 115,157,46,1 }, { 15,187,209,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 448)
		{ { 187,161,8,0 }, { 134,48,139,1 }, { 8,66,238,1 }, { 232,134,48,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 449)
		{ { 187,161,11,1 }, { 142,114,139,1 }, { 232,66,238,1 }, { 232,167,56,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 450)
		{ { 187,161,4,1 }, { 142,48,155,0 }, { 144,66,238,1 }, { 108,134,56,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 451)
		{ { 187,161,7,0 }, { 134,114,155,0 }, { 112,66,238,1 }, { 108,167,48,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 452)
		{ { 187,161,120,0 }, { 150,180,139,1 }, { 15,66,238,1 }, { 232,150,180,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 453)
		{ { 187,161,123,1 }, { 158,246,139,1 }, { 239,66,238,1 }, { 232,183,188,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 454)
		{ { 187,161,116,1 }, { 158,180,155,0 }, { 151,66,238,1 }, { 108,150,188,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 455)
		{ { 187,161,119,0 }, { 150,246,155,0 }, { 119,66,238,1 }, { 108,183,180,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 456)
		{ { 187,160,152,0 }, { 150,48,170,1 }, { 12,130,238,1 }, { 170,134,52,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 457)
		{ { 187,160,155,1 }, { 158,114,170,1 }, { 236,130,238,1 }, { 170,167,60,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 458)
		{ { 187,160,148,1 }, { 158,48,186,0 }, { 148,130,238,1 }, { 46,134,60,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 459)
		{ { 187,160,151,0 }, { 150,114,186,0 }, { 116,130,238,1 }, { 46,167,52,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 460)
		{ { 187,160,232,0 }, { 134,180,170,1 }, { 11,130,238,1 }, { 170,150,176,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 461)
		{ { 187,160,235,1 }, { 142,246,170,1 }, { 235,130,238,1 }, { 170,183,184,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 462)
		{ { 187,160,228,1 }, { 142,180,186,0 }, { 147,130,238,1 }, { 46,150,184,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 463)
		{ { 187,160,231,0 }, { 134,246,186,0 }, { 115,130,238,1 }, { 46,183,176,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 464)
		{ { 187,175,8,0 }, { 167,56,139,1 }, { 8,122,238,1 }, { 232,142,114,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 465)
		{ { 187,175,11,1 }, { 175,122,139,1 }, { 232,122,238,1 }, { 232,175,122,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 466)
		{ { 187,175,4,1 }, { 175,56,155,0 }, { 144,122,238,1 }, { 108,142,122,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 467)
		{ { 187,175,7,0 }, { 167,122,155,0 }, { 112,122,238,1 }, { 108,175,114,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 468)
		{ { 187,175,120,0 }, { 183,188,139,1 }, { 15,122,238,1 }, { 232,158,246,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 469)
		{ { 187,175,123,1 }, { 191,254,139,1 }, { 239,122,238,1 }, { 232,191,254,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 470)
		{ { 187,175,116,1 }, { 191,188,155,0 }, { 151,122,238,1 }, { 108,158,254,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 471)
		{ { 187,175,119,0 }, { 183,254,155,0 }, { 119,122,238,1 }, { 108,191,246,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 472)
		{ { 187,174,152,0 }, { 183,56,170,1 }, { 12,186,238,1 }, { 170,142,118,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 473)
		{ { 187,174,155,1 }, { 191,122,170,1 }, { 236,186,238,1 }, { 170,175,126,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 474)
		{ { 187,174,148,1 }, { 191,56,186,0 }, { 148,186,238,1 }, { 46,142,126,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 475)
		{ { 187,174,151,0 }, { 183,122,186,0 }, { 116,186,238,1 }, { 46,175,118,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 476)
		{ { 187,174,232,0 }, { 167,188,170,1 }, { 11,186,238,1 }, { 170,158,242,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 477)
		{ { 187,174,235,1 }, { 175,254,170,1 }, { 235,186,238,1 }, { 170,191,250,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 478)
		{ { 187,174,228,1 }, { 175,188,186,0 }, { 147,186,238,1 }, { 46,158,250,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 479)
		{ { 187,174,231,0 }, { 167,254,186,0 }, { 115,186,238,1 }, { 46,191,242,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 480)
		{ { 187,147,8,0 }, { 166,48,201,1 }, { 8,100,238,1 }, { 201,134,50,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 481)
		{ { 187,147,11,1 }, { 174,114,201,1 }, { 232,100,238,1 }, { 201,167,58,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 482)
		{ { 187,147,4,1 }, { 174,48,217,0 }, { 144,100,238,1 }, { 77,134,58,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 483)
		{ { 187,147,7,0 }, { 166,114,217,0 }, { 112,100,238,1 }, { 77,167,50,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 484)
		{ { 187,147,120,0 }, { 182,180,201,1 }, { 15,100,238,1 }, { 201,150,182,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 485)
		{ { 187,147,123,1 }, { 190,246,201,1 }, { 239,100,238,1 }, { 201,183,190,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 486)
		{ { 187,147,116,1 }, { 190,180,217,0 }, { 151,100,238,1 }, { 77,150,190,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 487)
		{ { 187,147,119,0 }, { 182,246,217,0 }, { 119,100,238,1 }, { 77,183,182,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 488)
		{ { 187,146,152,0 }, { 182,48,232,1 }, { 12,164,238,1 }, { 139,134,54,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 489)
		{ { 187,146,155,1 }, { 190,114,232,1 }, { 236,164,238,1 }, { 139,167,62,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 490)
		{ { 187,146,148,1 }, { 190,48,248,0 }, { 148,164,238,1 }, { 15,134,62,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 491)
		{ { 187,146,151,0 }, { 182,114,248,0 }, { 116,164,238,1 }, { 15,167,54,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 492)
		{ { 187,146,232,0 }, { 166,180,232,1 }, { 11,164,238,1 }, { 139,150,178,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 493)
		{ { 187,146,235,1 }, { 174,246,232,1 }, { 235,164,238,1 }, { 139,183,186,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 494)
		{ { 187,146,228,1 }, { 174,180,248,0 }, { 147,164,238,1 }, { 15,150,186,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 495)
		{ { 187,146,231,0 }, { 166,246,248,0 }, { 115,164,238,1 }, { 15,183,178,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 496)
		{ { 187,157,8,0 }, { 135,56,201,1 }, { 8,92,238,1 }, { 201,142,112,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 497)
		{ { 187,157,11,1 }, { 143,122,201,1 }, { 232,92,238,1 }, { 201,175,120,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 498)
		{ { 187,157,4,1 }, { 143,56,217,0 }, { 144,92,238,1 }, { 77,142,120,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 499)
		{ { 187,157,7,0 }, { 135,122,217,0 }, { 112,92,238,1 }, { 77,175,112,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 500)
		{ { 187,157,120,0 }, { 151,188,201,1 }, { 15,92,238,1 }, { 201,158,244,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 501)
		{ { 187,157,123,1 }, { 159,254,201,1 }, { 239,92,238,1 }, { 201,191,252,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 502)
		{ { 187,157,116,1 }, { 159,188,217,0 }, { 151,92,238,1 }, { 77,158,252,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 503)
		{ { 187,157,119,0 }, { 151,254,217,0 }, { 119,92,238,1 }, { 77,191,244,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 504)
		{ { 187,156,152,0 }, { 151,56,232,1 }, { 12,156,238,1 }, { 139,142,116,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 505)
		{ { 187,156,155,1 }, { 159,122,232,1 }, { 236,156,238,1 }, { 139,175,124,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 506)
		{ { 187,156,148,1 }, { 159,56,248,0 }, { 148,156,238,1 }, { 15,142,124,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 507)
		{ { 187,156,151,0 }, { 151,122,248,0 }, { 116,156,238,1 }, { 15,175,116,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 508)
		{ { 187,156,232,0 }, { 135,188,232,1 }, { 11,156,238,1 }, { 139,158,240,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 509)
		{ { 187,156,235,1 }, { 143,254,232,1 }, { 235,156,238,1 }, { 139,191,248,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 510)
		{ { 187,156,228,1 }, { 143,188,248,0 }, { 147,156,238,1 }, { 15,158,248,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 511)
		{ { 187,156,231,0 }, { 135,254,248,0 }, { 115,156,238,1 }, { 15,191,240,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 512)
		{ { 76,33,8,0 }, { 128,1,7,1 }, { 8,66,25,0 }, { 240,64,0,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 513)
		{ { 76,33,11,1 }, { 136,67,7,1 }, { 232,66,25,0 }, { 240,97,8,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 514)
		{ { 76,33,4,1 }, { 136,1,23,0 }, { 144,66,25,0 }, { 116,64,8,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 515)
		{ { 76,33,7,0 }, { 128,67,23,0 }, { 112,66,25,0 }, { 116,97,0,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 516)
		{ { 76,33,120,0 }, { 144,133,7,1 }, { 15,66,25,0 }, { 240,80,132,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 517)
		{ { 76,33,123,1 }, { 152,199,7,1 }, { 239,66,25,0 }, { 240,113,140,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 518)
		{ { 76,33,116,1 }, { 152,133,23,0 }, { 151,66,25,0 }, { 116,80,140,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 519)
		{ { 76,33,119,0 }, { 144,199,23,0 }, { 119,66,25,0 }, { 116,113,132,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 520)
		{ { 76,32,152,0 }, { 144,1,38,1 }, { 12,130,25,0 }, { 178,64,4,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 521)
		{ { 76,32,155,1 }, { 152,67,38,1 }, { 236,130,25,0 }, { 178,97,12,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 522)
		{ { 76,32,148,1 }, { 152,1,54,0 }, { 148,130,25,0 }, { 54,64,12,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 523)
		{ { 76,32,151,0 }, { 144,67,54,0 }, { 116,130,25,0 }, { 54,97,4,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 524)
		{ { 76,32,232,0 }, { 128,133,38,1 }, { 11,130,25,0 }, { 178,80,128,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 525)
		{ { 76,32,235,1 }, { 136,199,38,1 }, { 235,130,25,0 }, { 178,113,136,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 526)
		{ { 76,32,228,1 }, { 136,133,54,0 }, { 147,130,25,0 }, { 54,80,136,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 527)
		{ { 76,32,231,0 }, { 128,199,54,0 }, { 115,130,25,0 }, { 54,113,128,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 528)
		{ { 76,47,8,0 }, { 161,9,7,1 }, { 8,122,25,0 }, { 240,72,66,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 529)
		{ { 76,47,11,1 }, { 169,75,7,1 }, { 232,122,25,0 }, { 240,105,74,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 530)
		{ { 76,47,4,1 }, { 169,9,23,0 }, { 144,122,25,0 }, { 116,72,74,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 531)
		{ { 76,47,7,0 }, { 161,75,23,0 }, { 112,122,25,0 }, { 116,105,66,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 532)
		{ { 76,47,120,0 }, { 177,141,7,1 }, { 15,122,25,0 }, { 240,88,198,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 533)
		{ { 76,47,123,1 }, { 185,207,7,1 }, { 239,122,25,0 }, { 240,121,206,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 534)
		{ { 76,47,116,1 }, { 185,141,23,0 }, { 151,122,25,0 }, { 116,88,206,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 535)
		{ { 76,47,119,0 }, { 177,207,23,0 }, { 119,122,25,0 }, { 116,121,198,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 536)
		{ { 76,46,152,0 }, { 177,9,38,1 }, { 12,186,25,0 }, { 178,72,70,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 537)
		{ { 76,46,155,1 }, { 185,75,38,1 }, { 236,186,25,0 }, { 178,105,78,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 538)
		{ { 76,46,148,1 }, { 185,9,54,0 }, { 148,186,25,0 }, { 54,72,78,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 539)
		{ { 76,46,151,0 }, { 177,75,54,0 }, { 116,186,25,0 }, { 54,105,70,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 540)
		{ { 76,46,232,0 }, { 161,141,38,1 }, { 11,186,25,0 }, { 178,88,194,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 541)
		{ { 76,46,235,1 }, { 169,207,38,1 }, { 235,186,25,0 }, { 178,121,202,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 542)
		{ { 76,46,228,1 }, { 169,141,54,0 }, { 147,186,25,0 }, { 54,88,202,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 543)
		{ { 76,46,231,0 }, { 161,207,54,0 }, { 115,186,25,0 }, { 54,121,194,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 544)
		{ { 76,19,8,0 }, { 160,1,69,1 }, { 8,100,25,0 }, { 209,64,2,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 545)
		{ { 76,19,11,1 }, { 168,67,69,1 }, { 232,100,25,0 }, { 209,97,10,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 546)
		{ { 76,19,4,1 }, { 168,1,85,0 }, { 144,100,25,0 }, { 85,64,10,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 547)
		{ { 76,19,7,0 }, { 160,67,85,0 }, { 112,100,25,0 }, { 85,97,2,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 548)
		{ { 76,19,120,0 }, { 176,133,69,1 }, { 15,100,25,0 }, { 209,80,134,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 549)
		{ { 76,19,123,1 }, { 184,199,69,1 }, { 239,100,25,0 }, { 209,113,142,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 550)
		{ { 76,19,116,1 }, { 184,133,85,0 }, { 151,100,25,0 }, { 85,80,142,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 551)
		{ { 76,19,119,0 }, { 176,199,85,0 }, { 119,100,25,0 }, { 85,113,134,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 552)
		{ { 76,18,152,0 }, { 176,1,100,1 }, { 12,164,25,0 }, { 147,64,6,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 553)
		{ { 76,18,155,1 }, { 184,67,100,1 }, { 236,164,25,0 }, { 147,97,14,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 554)
		{ { 76,18,148,1 }, { 184,1,116,0 }, { 148,164,25,0 }, { 23,64,14,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 555)
		{ { 76,18,151,0 }, { 176,67,116,0 }, { 116,164,25,0 }, { 23,97,6,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 556)
		{ { 76,18,232,0 }, { 160,133,100,1 }, { 11,164,25,0 }, { 147,80,130,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 557)
		{ { 76,18,235,1 }, { 168,199,100,1 }, { 235,164,25,0 }, { 147,113,138,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 558)
		{ { 76,18,228,1 }, { 168,133,116,0 }, { 147,164,25,0 }, { 23,80,138,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 559)
		{ { 76,18,231,0 }, { 160,199,116,0 }, { 115,164,25,0 }, { 23,113,130,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 560)
		{ { 76,29,8,0 }, { 129,9,69,1 }, { 8,92,25,0 }, { 209,72,64,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 561)
		{ { 76,29,11,1 }, { 137,75,69,1 }, { 232,92,25,0 }, { 209,105,72,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 562)
		{ { 76,29,4,1 }, { 137,9,85,0 }, { 144,92,25,0 }, { 85,72,72,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 563)
		{ { 76,29,7,0 }, { 129,75,85,0 }, { 112,92,25,0 }, { 85,105,64,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 564)
		{ { 76,29,120,0 }, { 145,141,69,1 }, { 15,92,25,0 }, { 209,88,196,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 565)
		{ { 76,29,123,1 }, { 153,207,69,1 }, { 239,92,25,0 }, { 209,121,204,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 566)
		{ { 76,29,116,1 }, { 153,141,85,0 }, { 151,92,25,0 }, { 85,88,204,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 567)
		{ { 76,29,119,0 }, { 145,207,85,0 }, { 119,92,25,0 }, { 85,121,196,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 568)
		{ { 76,28,152,0 }, { 145,9,100,1 }, { 12,156,25,0 }, { 147,72,68,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 569)
		{ { 76,28,155,1 }, { 153,75,100,1 }, { 236,156,25,0 }, { 147,105,76,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 570)
		{ { 76,28,148,1 }, { 153,9,116,0 }, { 148,156,25,0 }, { 23,72,76,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 571)
		{ { 76,28,151,0 }, { 145,75,116,0 }, { 116,156,25,0 }, { 23,105,68,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 572)
		{ { 76,28,232,0 }, { 129,141,100,1 }, { 11,156,25,0 }, { 147,88,192,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 573)
		{ { 76,28,235,1 }, { 137,207,100,1 }, { 235,156,25,0 }, { 147,121,200,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 574)
		{ { 76,28,228,1 }, { 137,141,116,0 }, { 147,156,25,0 }, { 23,88,200,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 575)
		{ { 76,28,231,0 }, { 129,207,116,0 }, { 115,156,25,0 }, { 23,121,192,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 576)
		{ { 77,225,8,0 }, { 194,17,7,1 }, { 8,67,217,0 }, { 240,68,33,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 577)
		{ { 77,225,11,1 }, { 202,83,7,1 }, { 232,67,217,0 }, { 240,101,41,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 578)
		{ { 77,225,4,1 }, { 202,17,23,0 }, { 144,67,217,0 }, { 116,68,41,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 579)
		{ { 77,225,7,0 }, { 194,83,23,0 }, { 112,67,217,0 }, { 116,101,33,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 580)
		{ { 77,225,120,0 }, { 210,149,7,1 }, { 15,67,217,0 }, { 240,84,165,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 581)
		{ { 77,225,123,1 }, { 218,215,7,1 }, { 239,67,217,0 }, { 240,117,173,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 582)
		{ { 77,225,116,1 }, { 218,149,23,0 }, { 151,67,217,0 }, { 116,84,173,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 583)
		{ { 77,225,119,0 }, { 210,215,23,0 }, { 119,67,217,0 }, { 116,117,165,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 584)
		{ { 77,224,152,0 }, { 210,17,38,1 }, { 12,131,217,0 }, { 178,68,37,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 585)
		{ { 77,224,155,1 }, { 218,83,38,1 }, { 236,131,217,0 }, { 178,101,45,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 586)
		{ { 77,224,148,1 }, { 218,17,54,0 }, { 148,131,217,0 }, { 54,68,45,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 587)
		{ { 77,224,151,0 }, { 210,83,54,0 }, { 116,131,217,0 }, { 54,101,37,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 588)
		{ { 77,224,232,0 }, { 194,149,38,1 }, { 11,131,217,0 }, { 178,84,161,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 589)
		{ { 77,224,235,1 }, { 202,215,38,1 }, { 235,131,217,0 }, { 178,117,169,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 590)
		{ { 77,224,228,1 }, { 202,149,54,0 }, { 147,131,217,0 }, { 54,84,169,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 591)
		{ { 77,224,231,0 }, { 194,215,54,0 }, { 115,131,217,0 }, { 54,117,161,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 592)
		{ { 77,239,8,0 }, { 227,25,7,1 }, { 8,123,217,0 }, { 240,76,99,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 593)
		{ { 77,239,11,1 }, { 235,91,7,1 }, { 232,123,217,0 }, { 240,109,107,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 594)
		{ { 77,239,4,1 }, { 235,25,23,0 }, { 144,123,217,0 }, { 116,76,107,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 595)
		{ { 77,239,7,0 }, { 227,91,23,0 }, { 112,123,217,0 }, { 116,109,99,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 596)
		{ { 77,239,120,0 }, { 243,157,7,1 }, { 15,123,217,0 }, { 240,92,231,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 597)
		{ { 77,239,123,1 }, { 251,223,7,1 }, { 239,123,217,0 }, { 240,125,239,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 598)
		{ { 77,239,116,1 }, { 251,157,23,0 }, { 151,123,217,0 }, { 116,92,239,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 599)
		{ { 77,239,119,0 }, { 243,223,23,0 }, { 119,123,217,0 }, { 116,125,231,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 600)
		{ { 77,238,152,0 }, { 243,25,38,1 }, { 12,187,217,0 }, { 178,76,103,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 601)
		{ { 77,238,155,1 }, { 251,91,38,1 }, { 236,187,217,0 }, { 178,109,111,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 602)
		{ { 77,238,148,1 }, { 251,25,54,0 }, { 148,187,217,0 }, { 54,76,111,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 603)
		{ { 77,238,151,0 }, { 243,91,54,0 }, { 116,187,217,0 }, { 54,109,103,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 604)
		{ { 77,238,232,0 }, { 227,157,38,1 }, { 11,187,217,0 }, { 178,92,227,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 605)
		{ { 77,238,235,1 }, { 235,223,38,1 }, { 235,187,217,0 }, { 178,125,235,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 606)
		{ { 77,238,228,1 }, { 235,157,54,0 }, { 147,187,217,0 }, { 54,92,235,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 607)
		{ { 77,238,231,0 }, { 227,223,54,0 }, { 115,187,217,0 }, { 54,125,227,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 608)
		{ { 77,211,8,0 }, { 226,17,69,1 }, { 8,101,217,0 }, { 209,68,35,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 609)
		{ { 77,211,11,1 }, { 234,83,69,1 }, { 232,101,217,0 }, { 209,101,43,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 610)
		{ { 77,211,4,1 }, { 234,17,85,0 }, { 144,101,217,0 }, { 85,68,43,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 611)
		{ { 77,211,7,0 }, { 226,83,85,0 }, { 112,101,217,0 }, { 85,101,35,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 612)
		{ { 77,211,120,0 }, { 242,149,69,1 }, { 15,101,217,0 }, { 209,84,167,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 613)
		{ { 77,211,123,1 }, { 250,215,69,1 }, { 239,101,217,0 }, { 209,117,175,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 614)
		{ { 77,211,116,1 }, { 250,149,85,0 }, { 151,101,217,0 }, { 85,84,175,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 615)
		{ { 77,211,119,0 }, { 242,215,85,0 }, { 119,101,217,0 }, { 85,117,167,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 616)
		{ { 77,210,152,0 }, { 242,17,100,1 }, { 12,165,217,0 }, { 147,68,39,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 617)
		{ { 77,210,155,1 }, { 250,83,100,1 }, { 236,165,217,0 }, { 147,101,47,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 618)
		{ { 77,210,148,1 }, { 250,17,116,0 }, { 148,165,217,0 }, { 23,68,47,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 619)
		{ { 77,210,151,0 }, { 242,83,116,0 }, { 116,165,217,0 }, { 23,101,39,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 620)
		{ { 77,210,232,0 }, { 226,149,100,1 }, { 11,165,217,0 }, { 147,84,163,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 621)
		{ { 77,210,235,1 }, { 234,215,100,1 }, { 235,165,217,0 }, { 147,117,171,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 622)
		{ { 77,210,228,1 }, { 234,149,116,0 }, { 147,165,217,0 }, { 23,84,171,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 623)
		{ { 77,210,231,0 }, { 226,215,116,0 }, { 115,165,217,0 }, { 23,117,163,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 624)
		{ { 77,221,8,0 }, { 195,25,69,1 }, { 8,93,217,0 }, { 209,76,97,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 625)
		{ { 77,221,11,1 }, { 203,91,69,1 }, { 232,93,217,0 }, { 209,109,105,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 626)
		{ { 77,221,4,1 }, { 203,25,85,0 }, { 144,93,217,0 }, { 85,76,105,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 627)
		{ { 77,221,7,0 }, { 195,91,85,0 }, { 112,93,217,0 }, { 85,109,97,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 628)
		{ { 77,221,120,0 }, { 211,157,69,1 }, { 15,93,217,0 }, { 209,92,229,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 629)
		{ { 77,221,123,1 }, { 219,223,69,1 }, { 239,93,217,0 }, { 209,125,237,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 630)
		{ { 77,221,116,1 }, { 219,157,85,0 }, { 151,93,217,0 }, { 85,92,237,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 631)
		{ { 77,221,119,0 }, { 211,223,85,0 }, { 119,93,217,0 }, { 85,125,229,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 632)
		{ { 77,220,152,0 }, { 211,25,100,1 }, { 12,157,217,0 }, { 147,76,101,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 633)
		{ { 77,220,155,1 }, { 219,91,100,1 }, { 236,157,217,0 }, { 147,109,109,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 634)
		{ { 77,220,148,1 }, { 219,25,116,0 }, { 148,157,217,0 }, { 23,76,109,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 635)
		{ { 77,220,151,0 }, { 211,91,116,0 }, { 116,157,217,0 }, { 23,109,101,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 636)
		{ { 77,220,232,0 }, { 195,157,100,1 }, { 11,157,217,0 }, { 147,92,225,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 637)
		{ { 77,220,235,1 }, { 203,223,100,1 }, { 235,157,217,0 }, { 147,125,233,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 638)
		{ { 77,220,228,1 }, { 203,157,116,0 }, { 147,157,217,0 }, { 23,92,233,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 639)
		{ { 77,220,231,0 }, { 195,223,116,0 }, { 115,157,217,0 }, { 23,125,225,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 640)
		{ { 74,97,8,0 }, { 192,1,131,1 }, { 8,67,41,0 }, { 224,192,1,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 641)
		{ { 74,97,11,1 }, { 200,67,131,1 }, { 232,67,41,0 }, { 224,225,9,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 642)
		{ { 74,97,4,1 }, { 200,1,147,0 }, { 144,67,41,0 }, { 100,192,9,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 643)
		{ { 74,97,7,0 }, { 192,67,147,0 }, { 112,67,41,0 }, { 100,225,1,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 644)
		{ { 74,97,120,0 }, { 208,133,131,1 }, { 15,67,41,0 }, { 224,208,133,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 645)
		{ { 74,97,123,1 }, { 216,199,131,1 }, { 239,67,41,0 }, { 224,241,141,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 646)
		{ { 74,97,116,1 }, { 216,133,147,0 }, { 151,67,41,0 }, { 100,208,141,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 647)
		{ { 74,97,119,0 }, { 208,199,147,0 }, { 119,67,41,0 }, { 100,241,133,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 648)
		{ { 74,96,152,0 }, { 208,1,162,1 }, { 12,131,41,0 }, { 162,192,5,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 649)
		{ { 74,96,155,1 }, { 216,67,162,1 }, { 236,131,41,0 }, { 162,225,13,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 650)
		{ { 74,96,148,1 }, { 216,1,178,0 }, { 148,131,41,0 }, { 38,192,13,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 651)
		{ { 74,96,151,0 }, { 208,67,178,0 }, { 116,131,41,0 }, { 38,225,5,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 652)
		{ { 74,96,232,0 }, { 192,133,162,1 }, { 11,131,41,0 }, { 162,208,129,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 653)
		{ { 74,96,235,1 }, { 200,199,162,1 }, { 235,131,41,0 }, { 162,241,137,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 654)
		{ { 74,96,228,1 }, { 200,133,178,0 }, { 147,131,41,0 }, { 38,208,137,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 655)
		{ { 74,96,231,0 }, { 192,199,178,0 }, { 115,131,41,0 }, { 38,241,129,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 656)
		{ { 74,111,8,0 }, { 225,9,131,1 }, { 8,123,41,0 }, { 224,200,67,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 657)
		{ { 74,111,11,1 }, { 233,75,131,1 }, { 232,123,41,0 }, { 224,233,75,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 658)
		{ { 74,111,4,1 }, { 233,9,147,0 }, { 144,123,41,0 }, { 100,200,75,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 659)
		{ { 74,111,7,0 }, { 225,75,147,0 }, { 112,123,41,0 }, { 100,233,67,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 660)
		{ { 74,111,120,0 }, { 241,141,131,1 }, { 15,123,41,0 }, { 224,216,199,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 661)
		{ { 74,111,123,1 }, { 249,207,131,1 }, { 239,123,41,0 }, { 224,249,207,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 662)
		{ { 74,111,116,1 }, { 249,141,147,0 }, { 151,123,41,0 }, { 100,216,207,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 663)
		{ { 74,111,119,0 }, { 241,207,147,0 }, { 119,123,41,0 }, { 100,249,199,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 664)
		{ { 74,110,152,0 }, { 241,9,162,1 }, { 12,187,41,0 }, { 162,200,71,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 665)
		{ { 74,110,155,1 }, { 249,75,162,1 }, { 236,187,41,0 }, { 162,233,79,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 666)
		{ { 74,110,148,1 }, { 249,9,178,0 }, { 148,187,41,0 }, { 38,200,79,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 667)
		{ { 74,110,151,0 }, { 241,75,178,0 }, { 116,187,41,0 }, { 38,233,71,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 668)
		{ { 74,110,232,0 }, { 225,141,162,1 }, { 11,187,41,0 }, { 162,216,195,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 669)
		{ { 74,110,235,1 }, { 233,207,162,1 }, { 235,187,41,0 }, { 162,249,203,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 670)
		{ { 74,110,228,1 }, { 233,141,178,0 }, { 147,187,41,0 }, { 38,216,203,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 671)
		{ { 74,110,231,0 }, { 225,207,178,0 }, { 115,187,41,0 }, { 38,249,195,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 672)
		{ { 74,83,8,0 }, { 224,1,193,1 }, { 8,101,41,0 }, { 193,192,3,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 673)
		{ { 74,83,11,1 }, { 232,67,193,1 }, { 232,101,41,0 }, { 193,225,11,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 674)
		{ { 74,83,4,1 }, { 232,1,209,0 }, { 144,101,41,0 }, { 69,192,11,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 675)
		{ { 74,83,7,0 }, { 224,67,209,0 }, { 112,101,41,0 }, { 69,225,3,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 676)
		{ { 74,83,120,0 }, { 240,133,193,1 }, { 15,101,41,0 }, { 193,208,135,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 677)
		{ { 74,83,123,1 }, { 248,199,193,1 }, { 239,101,41,0 }, { 193,241,143,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 678)
		{ { 74,83,116,1 }, { 248,133,209,0 }, { 151,101,41,0 }, { 69,208,143,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 679)
		{ { 74,83,119,0 }, { 240,199,209,0 }, { 119,101,41,0 }, { 69,241,135,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 680)
		{ { 74,82,152,0 }, { 240,1,224,1 }, { 12,165,41,0 }, { 131,192,7,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 681)
		{ { 74,82,155,1 }, { 248,67,224,1 }, { 236,165,41,0 }, { 131,225,15,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 682)
		{ { 74,82,148,1 }, { 248,1,240,0 }, { 148,165,41,0 }, { 7,192,15,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 683)
		{ { 74,82,151,0 }, { 240,67,240,0 }, { 116,165,41,0 }, { 7,225,7,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 684)
		{ { 74,82,232,0 }, { 224,133,224,1 }, { 11,165,41,0 }, { 131,208,131,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 685)
		{ { 74,82,235,1 }, { 232,199,224,1 }, { 235,165,41,0 }, { 131,241,139,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 686)
		{ { 74,82,228,1 }, { 232,133,240,0 }, { 147,165,41,0 }, { 7,208,139,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 687)
		{ { 74,82,231,0 }, { 224,199,240,0 }, { 115,165,41,0 }, { 7,241,131,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 688)
		{ { 74,93,8,0 }, { 193,9,193,1 }, { 8,93,41,0 }, { 193,200,65,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 689)
		{ { 74,93,11,1 }, { 201,75,193,1 }, { 232,93,41,0 }, { 193,233,73,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 690)
		{ { 74,93,4,1 }, { 201,9,209,0 }, { 144,93,41,0 }, { 69,200,73,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 691)
		{ { 74,93,7,0 }, { 193,75,209,0 }, { 112,93,41,0 }, { 69,233,65,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 692)
		{ { 74,93,120,0 }, { 209,141,193,1 }, { 15,93,41,0 }, { 193,216,197,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 693)
		{ { 74,93,123,1 }, { 217,207,193,1 }, { 239,93,41,0 }, { 193,249,205,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 694)
		{ { 74,93,116,1 }, { 217,141,209,0 }, { 151,93,41,0 }, { 69,216,205,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 695)
		{ { 74,93,119,0 }, { 209,207,209,0 }, { 119,93,41,0 }, { 69,249,197,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 696)
		{ { 74,92,152,0 }, { 209,9,224,1 }, { 12,157,41,0 }, { 131,200,69,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 697)
		{ { 74,92,155,1 }, { 217,75,224,1 }, { 236,157,41,0 }, { 131,233,77,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 698)
		{ { 74,92,148,1 }, { 217,9,240,0 }, { 148,157,41,0 }, { 7,200,77,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 699)
		{ { 74,92,151,0 }, { 209,75,240,0 }, { 116,157,41,0 }, { 7,233,69,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 700)
		{ { 74,92,232,0 }, { 193,141,224,1 }, { 11,157,41,0 }, { 131,216,193,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 701)
		{ { 74,92,235,1 }, { 201,207,224,1 }, { 235,157,41,0 }, { 131,249,201,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 702)
		{ { 74,92,228,1 }, { 201,141,240,0 }, { 147,157,41,0 }, { 7,216,201,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 703)
		{ { 74,92,231,0 }, { 193,207,240,0 }, { 115,157,41,0 }, { 7,249,193,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 704)
		{ { 75,161,8,0 }, { 130,17,131,1 }, { 8,66,233,0 }, { 224,196,32,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 705)
		{ { 75,161,11,1 }, { 138,83,131,1 }, { 232,66,233,0 }, { 224,229,40,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 706)
		{ { 75,161,4,1 }, { 138,17,147,0 }, { 144,66,233,0 }, { 100,196,40,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 707)
		{ { 75,161,7,0 }, { 130,83,147,0 }, { 112,66,233,0 }, { 100,229,32,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 708)
		{ { 75,161,120,0 }, { 146,149,131,1 }, { 15,66,233,0 }, { 224,212,164,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 709)
		{ { 75,161,123,1 }, { 154,215,131,1 }, { 239,66,233,0 }, { 224,245,172,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 710)
		{ { 75,161,116,1 }, { 154,149,147,0 }, { 151,66,233,0 }, { 100,212,172,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 711)
		{ { 75,161,119,0 }, { 146,215,147,0 }, { 119,66,233,0 }, { 100,245,164,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 712)
		{ { 75,160,152,0 }, { 146,17,162,1 }, { 12,130,233,0 }, { 162,196,36,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 713)
		{ { 75,160,155,1 }, { 154,83,162,1 }, { 236,130,233,0 }, { 162,229,44,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 714)
		{ { 75,160,148,1 }, { 154,17,178,0 }, { 148,130,233,0 }, { 38,196,44,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 715)
		{ { 75,160,151,0 }, { 146,83,178,0 }, { 116,130,233,0 }, { 38,229,36,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 716)
		{ { 75,160,232,0 }, { 130,149,162,1 }, { 11,130,233,0 }, { 162,212,160,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 717)
		{ { 75,160,235,1 }, { 138,215,162,1 }, { 235,130,233,0 }, { 162,245,168,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 718)
		{ { 75,160,228,1 }, { 138,149,178,0 }, { 147,130,233,0 }, { 38,212,168,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 719)
		{ { 75,160,231,0 }, { 130,215,178,0 }, { 115,130,233,0 }, { 38,245,160,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 720)
		{ { 75,175,8,0 }, { 163,25,131,1 }, { 8,122,233,0 }, { 224,204,98,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 721)
		{ { 75,175,11,1 }, { 171,91,131,1 }, { 232,122,233,0 }, { 224,237,106,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 722)
		{ { 75,175,4,1 }, { 171,25,147,0 }, { 144,122,233,0 }, { 100,204,106,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 723)
		{ { 75,175,7,0 }, { 163,91,147,0 }, { 112,122,233,0 }, { 100,237,98,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 724)
		{ { 75,175,120,0 }, { 179,157,131,1 }, { 15,122,233,0 }, { 224,220,230,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 725)
		{ { 75,175,123,1 }, { 187,223,131,1 }, { 239,122,233,0 }, { 224,253,238,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 726)
		{ { 75,175,116,1 }, { 187,157,147,0 }, { 151,122,233,0 }, { 100,220,238,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 727)
		{ { 75,175,119,0 }, { 179,223,147,0 }, { 119,122,233,0 }, { 100,253,230,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 728)
		{ { 75,174,152,0 }, { 179,25,162,1 }, { 12,186,233,0 }, { 162,204,102,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 729)
		{ { 75,174,155,1 }, { 187,91,162,1 }, { 236,186,233,0 }, { 162,237,110,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 730)
		{ { 75,174,148,1 }, { 187,25,178,0 }, { 148,186,233,0 }, { 38,204,110,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 731)
		{ { 75,174,151,0 }, { 179,91,178,0 }, { 116,186,233,0 }, { 38,237,102,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 732)
		{ { 75,174,232,0 }, { 163,157,162,1 }, { 11,186,233,0 }, { 162,220,226,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 733)
		{ { 75,174,235,1 }, { 171,223,162,1 }, { 235,186,233,0 }, { 162,253,234,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 734)
		{ { 75,174,228,1 }, { 171,157,178,0 }, { 147,186,233,0 }, { 38,220,234,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 735)
		{ { 75,174,231,0 }, { 163,223,178,0 }, { 115,186,233,0 }, { 38,253,226,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 736)
		{ { 75,147,8,0 }, { 162,17,193,1 }, { 8,100,233,0 }, { 193,196,34,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 737)
		{ { 75,147,11,1 }, { 170,83,193,1 }, { 232,100,233,0 }, { 193,229,42,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 738)
		{ { 75,147,4,1 }, { 170,17,209,0 }, { 144,100,233,0 }, { 69,196,42,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 739)
		{ { 75,147,7,0 }, { 162,83,209,0 }, { 112,100,233,0 }, { 69,229,34,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 740)
		{ { 75,147,120,0 }, { 178,149,193,1 }, { 15,100,233,0 }, { 193,212,166,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 741)
		{ { 75,147,123,1 }, { 186,215,193,1 }, { 239,100,233,0 }, { 193,245,174,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 742)
		{ { 75,147,116,1 }, { 186,149,209,0 }, { 151,100,233,0 }, { 69,212,174,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 743)
		{ { 75,147,119,0 }, { 178,215,209,0 }, { 119,100,233,0 }, { 69,245,166,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 744)
		{ { 75,146,152,0 }, { 178,17,224,1 }, { 12,164,233,0 }, { 131,196,38,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 745)
		{ { 75,146,155,1 }, { 186,83,224,1 }, { 236,164,233,0 }, { 131,229,46,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 746)
		{ { 75,146,148,1 }, { 186,17,240,0 }, { 148,164,233,0 }, { 7,196,46,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 747)
		{ { 75,146,151,0 }, { 178,83,240,0 }, { 116,164,233,0 }, { 7,229,38,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 748)
		{ { 75,146,232,0 }, { 162,149,224,1 }, { 11,164,233,0 }, { 131,212,162,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 749)
		{ { 75,146,235,1 }, { 170,215,224,1 }, { 235,164,233,0 }, { 131,245,170,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 750)
		{ { 75,146,228,1 }, { 170,149,240,0 }, { 147,164,233,0 }, { 7,212,170,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 751)
		{ { 75,146,231,0 }, { 162,215,240,0 }, { 115,164,233,0 }, { 7,245,162,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 752)
		{ { 75,157,8,0 }, { 131,25,193,1 }, { 8,92,233,0 }, { 193,204,96,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 753)
		{ { 75,157,11,1 }, { 139,91,193,1 }, { 232,92,233,0 }, { 193,237,104,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 754)
		{ { 75,157,4,1 }, { 139,25,209,0 }, { 144,92,233,0 }, { 69,204,104,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 755)
		{ { 75,157,7,0 }, { 131,91,209,0 }, { 112,92,233,0 }, { 69,237,96,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 756)
		{ { 75,157,120,0 }, { 147,157,193,1 }, { 15,92,233,0 }, { 193,220,228,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 757)
		{ { 75,157,123,1 }, { 155,223,193,1 }, { 239,92,233,0 }, { 193,253,236,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 758)
		{ { 75,157,116,1 }, { 155,157,209,0 }, { 151,92,233,0 }, { 69,220,236,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 759)
		{ { 75,157,119,0 }, { 147,223,209,0 }, { 119,92,233,0 }, { 69,253,228,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 760)
		{ { 75,156,152,0 }, { 147,25,224,1 }, { 12,156,233,0 }, { 131,204,100,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 761)
		{ { 75,156,155,1 }, { 155,91,224,1 }, { 236,156,233,0 }, { 131,237,108,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 762)
		{ { 75,156,148,1 }, { 155,25,240,0 }, { 148,156,233,0 }, { 7,204,108,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 763)
		{ { 75,156,151,0 }, { 147,91,240,0 }, { 116,156,233,0 }, { 7,237,100,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 764)
		{ { 75,156,232,0 }, { 131,157,224,1 }, { 11,156,233,0 }, { 131,220,224,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 765)
		{ { 75,156,235,1 }, { 139,223,224,1 }, { 235,156,233,0 }, { 131,253,232,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 766)
		{ { 75,156,228,1 }, { 139,157,240,0 }, { 147,156,233,0 }, { 7,220,232,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 767)
		{ { 75,156,231,0 }, { 131,223,240,0 }, { 115,156,233,0 }, { 7,253,224,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 768)
		{ { 116,33,8,0 }, { 4,33,7,1 }, { 8,66,23,0 }, { 240,66,16,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 769)
		{ { 116,33,11,1 }, { 12,99,7,1 }, { 232,66,23,0 }, { 240,99,24,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 770)
		{ { 116,33,4,1 }, { 12,33,23,0 }, { 144,66,23,0 }, { 116,66,24,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 771)
		{ { 116,33,7,0 }, { 4,99,23,0 }, { 112,66,23,0 }, { 116,99,16,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 772)
		{ { 116,33,120,0 }, { 20,165,7,1 }, { 15,66,23,0 }, { 240,82,148,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 773)
		{ { 116,33,123,1 }, { 28,231,7,1 }, { 239,66,23,0 }, { 240,115,156,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 774)
		{ { 116,33,116,1 }, { 28,165,23,0 }, { 151,66,23,0 }, { 116,82,156,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 775)
		{ { 116,33,119,0 }, { 20,231,23,0 }, { 119,66,23,0 }, { 116,115,148,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 776)
		{ { 116,32,152,0 }, { 20,33,38,1 }, { 12,130,23,0 }, { 178,66,20,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 777)
		{ { 116,32,155,1 }, { 28,99,38,1 }, { 236,130,23,0 }, { 178,99,28,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 778)
		{ { 116,32,148,1 }, { 28,33,54,0 }, { 148,130,23,0 }, { 54,66,28,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 779)
		{ { 116,32,151,0 }, { 20,99,54,0 }, { 116,130,23,0 }, { 54,99,20,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 780)
		{ { 116,32,232,0 }, { 4,165,38,1 }, { 11,130,23,0 }, { 178,82,144,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 781)
		{ { 116,32,235,1 }, { 12,231,38,1 }, { 235,130,23,0 }, { 178,115,152,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 782)
		{ { 116,32,228,1 }, { 12,165,54,0 }, { 147,130,23,0 }, { 54,82,152,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 783)
		{ { 116,32,231,0 }, { 4,231,54,0 }, { 115,130,23,0 }, { 54,115,144,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 784)
		{ { 116,47,8,0 }, { 37,41,7,1 }, { 8,122,23,0 }, { 240,74,82,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 785)
		{ { 116,47,11,1 }, { 45,107,7,1 }, { 232,122,23,0 }, { 240,107,90,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 786)
		{ { 116,47,4,1 }, { 45,41,23,0 }, { 144,122,23,0 }, { 116,74,90,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 787)
		{ { 116,47,7,0 }, { 37,107,23,0 }, { 112,122,23,0 }, { 116,107,82,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 788)
		{ { 116,47,120,0 }, { 53,173,7,1 }, { 15,122,23,0 }, { 240,90,214,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 789)
		{ { 116,47,123,1 }, { 61,239,7,1 }, { 239,122,23,0 }, { 240,123,222,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 790)
		{ { 116,47,116,1 }, { 61,173,23,0 }, { 151,122,23,0 }, { 116,90,222,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 791)
		{ { 116,47,119,0 }, { 53,239,23,0 }, { 119,122,23,0 }, { 116,123,214,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 792)
		{ { 116,46,152,0 }, { 53,41,38,1 }, { 12,186,23,0 }, { 178,74,86,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 793)
		{ { 116,46,155,1 }, { 61,107,38,1 }, { 236,186,23,0 }, { 178,107,94,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 794)
		{ { 116,46,148,1 }, { 61,41,54,0 }, { 148,186,23,0 }, { 54,74,94,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 795)
		{ { 116,46,151,0 }, { 53,107,54,0 }, { 116,186,23,0 }, { 54,107,86,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 796)
		{ { 116,46,232,0 }, { 37,173,38,1 }, { 11,186,23,0 }, { 178,90,210,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 797)
		{ { 116,46,235,1 }, { 45,239,38,1 }, { 235,186,23,0 }, { 178,123,218,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 798)
		{ { 116,46,228,1 }, { 45,173,54,0 }, { 147,186,23,0 }, { 54,90,218,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 799)
		{ { 116,46,231,0 }, { 37,239,54,0 }, { 115,186,23,0 }, { 54,123,210,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 800)
		{ { 116,19,8,0 }, { 36,33,69,1 }, { 8,100,23,0 }, { 209,66,18,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 801)
		{ { 116,19,11,1 }, { 44,99,69,1 }, { 232,100,23,0 }, { 209,99,26,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 802)
		{ { 116,19,4,1 }, { 44,33,85,0 }, { 144,100,23,0 }, { 85,66,26,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 803)
		{ { 116,19,7,0 }, { 36,99,85,0 }, { 112,100,23,0 }, { 85,99,18,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 804)
		{ { 116,19,120,0 }, { 52,165,69,1 }, { 15,100,23,0 }, { 209,82,150,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 805)
		{ { 116,19,123,1 }, { 60,231,69,1 }, { 239,100,23,0 }, { 209,115,158,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 806)
		{ { 116,19,116,1 }, { 60,165,85,0 }, { 151,100,23,0 }, { 85,82,158,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 807)
		{ { 116,19,119,0 }, { 52,231,85,0 }, { 119,100,23,0 }, { 85,115,150,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 808)
		{ { 116,18,152,0 }, { 52,33,100,1 }, { 12,164,23,0 }, { 147,66,22,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 809)
		{ { 116,18,155,1 }, { 60,99,100,1 }, { 236,164,23,0 }, { 147,99,30,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 810)
		{ { 116,18,148,1 }, { 60,33,116,0 }, { 148,164,23,0 }, { 23,66,30,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 811)
		{ { 116,18,151,0 }, { 52,99,116,0 }, { 116,164,23,0 }, { 23,99,22,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 812)
		{ { 116,18,232,0 }, { 36,165,100,1 }, { 11,164,23,0 }, { 147,82,146,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 813)
		{ { 116,18,235,1 }, { 44,231,100,1 }, { 235,164,23,0 }, { 147,115,154,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 814)
		{ { 116,18,228,1 }, { 44,165,116,0 }, { 147,164,23,0 }, { 23,82,154,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 815)
		{ { 116,18,231,0 }, { 36,231,116,0 }, { 115,164,23,0 }, { 23,115,146,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 816)
		{ { 116,29,8,0 }, { 5,41,69,1 }, { 8,92,23,0 }, { 209,74,80,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 817)
		{ { 116,29,11,1 }, { 13,107,69,1 }, { 232,92,23,0 }, { 209,107,88,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 818)
		{ { 116,29,4,1 }, { 13,41,85,0 }, { 144,92,23,0 }, { 85,74,88,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 819)
		{ { 116,29,7,0 }, { 5,107,85,0 }, { 112,92,23,0 }, { 85,107,80,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 820)
		{ { 116,29,120,0 }, { 21,173,69,1 }, { 15,92,23,0 }, { 209,90,212,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 821)
		{ { 116,29,123,1 }, { 29,239,69,1 }, { 239,92,23,0 }, { 209,123,220,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 822)
		{ { 116,29,116,1 }, { 29,173,85,0 }, { 151,92,23,0 }, { 85,90,220,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 823)
		{ { 116,29,119,0 }, { 21,239,85,0 }, { 119,92,23,0 }, { 85,123,212,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 824)
		{ { 116,28,152,0 }, { 21,41,100,1 }, { 12,156,23,0 }, { 147,74,84,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 825)
		{ { 116,28,155,1 }, { 29,107,100,1 }, { 236,156,23,0 }, { 147,107,92,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 826)
		{ { 116,28,148,1 }, { 29,41,116,0 }, { 148,156,23,0 }, { 23,74,92,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 827)
		{ { 116,28,151,0 }, { 21,107,116,0 }, { 116,156,23,0 }, { 23,107,84,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 828)
		{ { 116,28,232,0 }, { 5,173,100,1 }, { 11,156,23,0 }, { 147,90,208,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 829)
		{ { 116,28,235,1 }, { 13,239,100,1 }, { 235,156,23,0 }, { 147,123,216,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 830)
		{ { 116,28,228,1 }, { 13,173,116,0 }, { 147,156,23,0 }, { 23,90,216,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 831)
		{ { 116,28,231,0 }, { 5,239,116,0 }, { 115,156,23,0 }, { 23,123,208,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 832)
		{ { 117,225,8,0 }, { 70,49,7,1 }, { 8,67,215,0 }, { 240,70,49,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 833)
		{ { 117,225,11,1 }, { 78,115,7,1 }, { 232,67,215,0 }, { 240,103,57,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 834)
		{ { 117,225,4,1 }, { 78,49,23,0 }, { 144,67,215,0 }, { 116,70,57,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 835)
		{ { 117,225,7,0 }, { 70,115,23,0 }, { 112,67,215,0 }, { 116,103,49,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 836)
		{ { 117,225,120,0 }, { 86,181,7,1 }, { 15,67,215,0 }, { 240,86,181,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 837)
		{ { 117,225,123,1 }, { 94,247,7,1 }, { 239,67,215,0 }, { 240,119,189,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 838)
		{ { 117,225,116,1 }, { 94,181,23,0 }, { 151,67,215,0 }, { 116,86,189,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 839)
		{ { 117,225,119,0 }, { 86,247,23,0 }, { 119,67,215,0 }, { 116,119,181,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 840)
		{ { 117,224,152,0 }, { 86,49,38,1 }, { 12,131,215,0 }, { 178,70,53,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 841)
		{ { 117,224,155,1 }, { 94,115,38,1 }, { 236,131,215,0 }, { 178,103,61,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 842)
		{ { 117,224,148,1 }, { 94,49,54,0 }, { 148,131,215,0 }, { 54,70,61,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 843)
		{ { 117,224,151,0 }, { 86,115,54,0 }, { 116,131,215,0 }, { 54,103,53,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 844)
		{ { 117,224,232,0 }, { 70,181,38,1 }, { 11,131,215,0 }, { 178,86,177,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 845)
		{ { 117,224,235,1 }, { 78,247,38,1 }, { 235,131,215,0 }, { 178,119,185,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 846)
		{ { 117,224,228,1 }, { 78,181,54,0 }, { 147,131,215,0 }, { 54,86,185,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 847)
		{ { 117,224,231,0 }, { 70,247,54,0 }, { 115,131,215,0 }, { 54,119,177,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 848)
		{ { 117,239,8,0 }, { 103,57,7,1 }, { 8,123,215,0 }, { 240,78,115,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 849)
		{ { 117,239,11,1 }, { 111,123,7,1 }, { 232,123,215,0 }, { 240,111,123,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 850)
		{ { 117,239,4,1 }, { 111,57,23,0 }, { 144,123,215,0 }, { 116,78,123,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 851)
		{ { 117,239,7,0 }, { 103,123,23,0 }, { 112,123,215,0 }, { 116,111,115,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 852)
		{ { 117,239,120,0 }, { 119,189,7,1 }, { 15,123,215,0 }, { 240,94,247,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 853)
		{ { 117,239,123,1 }, { 127,255,7,1 }, { 239,123,215,0 }, { 240,127,255,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 854)
		{ { 117,239,116,1 }, { 127,189,23,0 }, { 151,123,215,0 }, { 116,94,255,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 855)
		{ { 117,239,119,0 }, { 119,255,23,0 }, { 119,123,215,0 }, { 116,127,247,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 856)
		{ { 117,238,152,0 }, { 119,57,38,1 }, { 12,187,215,0 }, { 178,78,119,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 857)
		{ { 117,238,155,1 }, { 127,123,38,1 }, { 236,187,215,0 }, { 178,111,127,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 858)
		{ { 117,238,148,1 }, { 127,57,54,0 }, { 148,187,215,0 }, { 54,78,127,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 859)
		{ { 117,238,151,0 }, { 119,123,54,0 }, { 116,187,215,0 }, { 54,111,119,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 860)
		{ { 117,238,232,0 }, { 103,189,38,1 }, { 11,187,215,0 }, { 178,94,243,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 861)
		{ { 117,238,235,1 }, { 111,255,38,1 }, { 235,187,215,0 }, { 178,127,251,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 862)
		{ { 117,238,228,1 }, { 111,189,54,0 }, { 147,187,215,0 }, { 54,94,251,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 863)
		{ { 117,238,231,0 }, { 103,255,54,0 }, { 115,187,215,0 }, { 54,127,243,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 864)
		{ { 117,211,8,0 }, { 102,49,69,1 }, { 8,101,215,0 }, { 209,70,51,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 865)
		{ { 117,211,11,1 }, { 110,115,69,1 }, { 232,101,215,0 }, { 209,103,59,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 866)
		{ { 117,211,4,1 }, { 110,49,85,0 }, { 144,101,215,0 }, { 85,70,59,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 867)
		{ { 117,211,7,0 }, { 102,115,85,0 }, { 112,101,215,0 }, { 85,103,51,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 868)
		{ { 117,211,120,0 }, { 118,181,69,1 }, { 15,101,215,0 }, { 209,86,183,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 869)
		{ { 117,211,123,1 }, { 126,247,69,1 }, { 239,101,215,0 }, { 209,119,191,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 870)
		{ { 117,211,116,1 }, { 126,181,85,0 }, { 151,101,215,0 }, { 85,86,191,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 871)
		{ { 117,211,119,0 }, { 118,247,85,0 }, { 119,101,215,0 }, { 85,119,183,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 872)
		{ { 117,210,152,0 }, { 118,49,100,1 }, { 12,165,215,0 }, { 147,70,55,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 873)
		{ { 117,210,155,1 }, { 126,115,100,1 }, { 236,165,215,0 }, { 147,103,63,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 874)
		{ { 117,210,148,1 }, { 126,49,116,0 }, { 148,165,215,0 }, { 23,70,63,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 875)
		{ { 117,210,151,0 }, { 118,115,116,0 }, { 116,165,215,0 }, { 23,103,55,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 876)
		{ { 117,210,232,0 }, { 102,181,100,1 }, { 11,165,215,0 }, { 147,86,179,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 877)
		{ { 117,210,235,1 }, { 110,247,100,1 }, { 235,165,215,0 }, { 147,119,187,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 878)
		{ { 117,210,228,1 }, { 110,181,116,0 }, { 147,165,215,0 }, { 23,86,187,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 879)
		{ { 117,210,231,0 }, { 102,247,116,0 }, { 115,165,215,0 }, { 23,119,179,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 880)
		{ { 117,221,8,0 }, { 71,57,69,1 }, { 8,93,215,0 }, { 209,78,113,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 881)
		{ { 117,221,11,1 }, { 79,123,69,1 }, { 232,93,215,0 }, { 209,111,121,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 882)
		{ { 117,221,4,1 }, { 79,57,85,0 }, { 144,93,215,0 }, { 85,78,121,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 883)
		{ { 117,221,7,0 }, { 71,123,85,0 }, { 112,93,215,0 }, { 85,111,113,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 884)
		{ { 117,221,120,0 }, { 87,189,69,1 }, { 15,93,215,0 }, { 209,94,245,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 885)
		{ { 117,221,123,1 }, { 95,255,69,1 }, { 239,93,215,0 }, { 209,127,253,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 886)
		{ { 117,221,116,1 }, { 95,189,85,0 }, { 151,93,215,0 }, { 85,94,253,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 887)
		{ { 117,221,119,0 }, { 87,255,85,0 }, { 119,93,215,0 }, { 85,127,245,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 888)
		{ { 117,220,152,0 }, { 87,57,100,1 }, { 12,157,215,0 }, { 147,78,117,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 889)
		{ { 117,220,155,1 }, { 95,123,100,1 }, { 236,157,215,0 }, { 147,111,125,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 890)
		{ { 117,220,148,1 }, { 95,57,116,0 }, { 148,157,215,0 }, { 23,78,125,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 891)
		{ { 117,220,151,0 }, { 87,123,116,0 }, { 116,157,215,0 }, { 23,111,117,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 892)
		{ { 117,220,232,0 }, { 71,189,100,1 }, { 11,157,215,0 }, { 147,94,241,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 893)
		{ { 117,220,235,1 }, { 79,255,100,1 }, { 235,157,215,0 }, { 147,127,249,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 894)
		{ { 117,220,228,1 }, { 79,189,116,0 }, { 147,157,215,0 }, { 23,94,249,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 895)
		{ { 117,220,231,0 }, { 71,255,116,0 }, { 115,157,215,0 }, { 23,127,241,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 896)
		{ { 114,97,8,0 }, { 68,33,131,1 }, { 8,67,39,0 }, { 224,194,17,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 897)
		{ { 114,97,11,1 }, { 76,99,131,1 }, { 232,67,39,0 }, { 224,227,25,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 898)
		{ { 114,97,4,1 }, { 76,33,147,0 }, { 144,67,39,0 }, { 100,194,25,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 899)
		{ { 114,97,7,0 }, { 68,99,147,0 }, { 112,67,39,0 }, { 100,227,17,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 900)
		{ { 114,97,120,0 }, { 84,165,131,1 }, { 15,67,39,0 }, { 224,210,149,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 901)
		{ { 114,97,123,1 }, { 92,231,131,1 }, { 239,67,39,0 }, { 224,243,157,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 902)
		{ { 114,97,116,1 }, { 92,165,147,0 }, { 151,67,39,0 }, { 100,210,157,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 903)
		{ { 114,97,119,0 }, { 84,231,147,0 }, { 119,67,39,0 }, { 100,243,149,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 904)
		{ { 114,96,152,0 }, { 84,33,162,1 }, { 12,131,39,0 }, { 162,194,21,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 905)
		{ { 114,96,155,1 }, { 92,99,162,1 }, { 236,131,39,0 }, { 162,227,29,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 906)
		{ { 114,96,148,1 }, { 92,33,178,0 }, { 148,131,39,0 }, { 38,194,29,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 907)
		{ { 114,96,151,0 }, { 84,99,178,0 }, { 116,131,39,0 }, { 38,227,21,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 908)
		{ { 114,96,232,0 }, { 68,165,162,1 }, { 11,131,39,0 }, { 162,210,145,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 909)
		{ { 114,96,235,1 }, { 76,231,162,1 }, { 235,131,39,0 }, { 162,243,153,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 910)
		{ { 114,96,228,1 }, { 76,165,178,0 }, { 147,131,39,0 }, { 38,210,153,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 911)
		{ { 114,96,231,0 }, { 68,231,178,0 }, { 115,131,39,0 }, { 38,243,145,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 912)
		{ { 114,111,8,0 }, { 101,41,131,1 }, { 8,123,39,0 }, { 224,202,83,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 913)
		{ { 114,111,11,1 }, { 109,107,131,1 }, { 232,123,39,0 }, { 224,235,91,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 914)
		{ { 114,111,4,1 }, { 109,41,147,0 }, { 144,123,39,0 }, { 100,202,91,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 915)
		{ { 114,111,7,0 }, { 101,107,147,0 }, { 112,123,39,0 }, { 100,235,83,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 916)
		{ { 114,111,120,0 }, { 117,173,131,1 }, { 15,123,39,0 }, { 224,218,215,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 917)
		{ { 114,111,123,1 }, { 125,239,131,1 }, { 239,123,39,0 }, { 224,251,223,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 918)
		{ { 114,111,116,1 }, { 125,173,147,0 }, { 151,123,39,0 }, { 100,218,223,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 919)
		{ { 114,111,119,0 }, { 117,239,147,0 }, { 119,123,39,0 }, { 100,251,215,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 920)
		{ { 114,110,152,0 }, { 117,41,162,1 }, { 12,187,39,0 }, { 162,202,87,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 921)
		{ { 114,110,155,1 }, { 125,107,162,1 }, { 236,187,39,0 }, { 162,235,95,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 922)
		{ { 114,110,148,1 }, { 125,41,178,0 }, { 148,187,39,0 }, { 38,202,95,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 923)
		{ { 114,110,151,0 }, { 117,107,178,0 }, { 116,187,39,0 }, { 38,235,87,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 924)
		{ { 114,110,232,0 }, { 101,173,162,1 }, { 11,187,39,0 }, { 162,218,211,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 925)
		{ { 114,110,235,1 }, { 109,239,162,1 }, { 235,187,39,0 }, { 162,251,219,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 926)
		{ { 114,110,228,1 }, { 109,173,178,0 }, { 147,187,39,0 }, { 38,218,219,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 927)
		{ { 114,110,231,0 }, { 101,239,178,0 }, { 115,187,39,0 }, { 38,251,211,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 928)
		{ { 114,83,8,0 }, { 100,33,193,1 }, { 8,101,39,0 }, { 193,194,19,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 929)
		{ { 114,83,11,1 }, { 108,99,193,1 }, { 232,101,39,0 }, { 193,227,27,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 930)
		{ { 114,83,4,1 }, { 108,33,209,0 }, { 144,101,39,0 }, { 69,194,27,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 931)
		{ { 114,83,7,0 }, { 100,99,209,0 }, { 112,101,39,0 }, { 69,227,19,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 932)
		{ { 114,83,120,0 }, { 116,165,193,1 }, { 15,101,39,0 }, { 193,210,151,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 933)
		{ { 114,83,123,1 }, { 124,231,193,1 }, { 239,101,39,0 }, { 193,243,159,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 934)
		{ { 114,83,116,1 }, { 124,165,209,0 }, { 151,101,39,0 }, { 69,210,159,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 935)
		{ { 114,83,119,0 }, { 116,231,209,0 }, { 119,101,39,0 }, { 69,243,151,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 936)
		{ { 114,82,152,0 }, { 116,33,224,1 }, { 12,165,39,0 }, { 131,194,23,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 937)
		{ { 114,82,155,1 }, { 124,99,224,1 }, { 236,165,39,0 }, { 131,227,31,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 938)
		{ { 114,82,148,1 }, { 124,33,240,0 }, { 148,165,39,0 }, { 7,194,31,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 939)
		{ { 114,82,151,0 }, { 116,99,240,0 }, { 116,165,39,0 }, { 7,227,23,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 940)
		{ { 114,82,232,0 }, { 100,165,224,1 }, { 11,165,39,0 }, { 131,210,147,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 941)
		{ { 114,82,235,1 }, { 108,231,224,1 }, { 235,165,39,0 }, { 131,243,155,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 942)
		{ { 114,82,228,1 }, { 108,165,240,0 }, { 147,165,39,0 }, { 7,210,155,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 943)
		{ { 114,82,231,0 }, { 100,231,240,0 }, { 115,165,39,0 }, { 7,243,147,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 944)
		{ { 114,93,8,0 }, { 69,41,193,1 }, { 8,93,39,0 }, { 193,202,81,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 945)
		{ { 114,93,11,1 }, { 77,107,193,1 }, { 232,93,39,0 }, { 193,235,89,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 946)
		{ { 114,93,4,1 }, { 77,41,209,0 }, { 144,93,39,0 }, { 69,202,89,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 947)
		{ { 114,93,7,0 }, { 69,107,209,0 }, { 112,93,39,0 }, { 69,235,81,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 948)
		{ { 114,93,120,0 }, { 85,173,193,1 }, { 15,93,39,0 }, { 193,218,213,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 949)
		{ { 114,93,123,1 }, { 93,239,193,1 }, { 239,93,39,0 }, { 193,251,221,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 950)
		{ { 114,93,116,1 }, { 93,173,209,0 }, { 151,93,39,0 }, { 69,218,221,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 951)
		{ { 114,93,119,0 }, { 85,239,209,0 }, { 119,93,39,0 }, { 69,251,213,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 952)
		{ { 114,92,152,0 }, { 85,41,224,1 }, { 12,157,39,0 }, { 131,202,85,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 953)
		{ { 114,92,155,1 }, { 93,107,224,1 }, { 236,157,39,0 }, { 131,235,93,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 954)
		{ { 114,92,148,1 }, { 93,41,240,0 }, { 148,157,39,0 }, { 7,202,93,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 955)
		{ { 114,92,151,0 }, { 85,107,240,0 }, { 116,157,39,0 }, { 7,235,85,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 956)
		{ { 114,92,232,0 }, { 69,173,224,1 }, { 11,157,39,0 }, { 131,218,209,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 957)
		{ { 114,92,235,1 }, { 77,239,224,1 }, { 235,157,39,0 }, { 131,251,217,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 958)
		{ { 114,92,228,1 }, { 77,173,240,0 }, { 147,157,39,0 }, { 7,218,217,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 959)
		{ { 114,92,231,0 }, { 69,239,240,0 }, { 115,157,39,0 }, { 7,251,209,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 960)
		{ { 115,161,8,0 }, { 6,49,131,1 }, { 8,66,231,0 }, { 224,198,48,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 961)
		{ { 115,161,11,1 }, { 14,115,131,1 }, { 232,66,231,0 }, { 224,231,56,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 962)
		{ { 115,161,4,1 }, { 14,49,147,0 }, { 144,66,231,0 }, { 100,198,56,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 963)
		{ { 115,161,7,0 }, { 6,115,147,0 }, { 112,66,231,0 }, { 100,231,48,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 964)
		{ { 115,161,120,0 }, { 22,181,131,1 }, { 15,66,231,0 }, { 224,214,180,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 965)
		{ { 115,161,123,1 }, { 30,247,131,1 }, { 239,66,231,0 }, { 224,247,188,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 966)
		{ { 115,161,116,1 }, { 30,181,147,0 }, { 151,66,231,0 }, { 100,214,188,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 967)
		{ { 115,161,119,0 }, { 22,247,147,0 }, { 119,66,231,0 }, { 100,247,180,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 968)
		{ { 115,160,152,0 }, { 22,49,162,1 }, { 12,130,231,0 }, { 162,198,52,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 969)
		{ { 115,160,155,1 }, { 30,115,162,1 }, { 236,130,231,0 }, { 162,231,60,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 970)
		{ { 115,160,148,1 }, { 30,49,178,0 }, { 148,130,231,0 }, { 38,198,60,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 971)
		{ { 115,160,151,0 }, { 22,115,178,0 }, { 116,130,231,0 }, { 38,231,52,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 972)
		{ { 115,160,232,0 }, { 6,181,162,1 }, { 11,130,231,0 }, { 162,214,176,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 973)
		{ { 115,160,235,1 }, { 14,247,162,1 }, { 235,130,231,0 }, { 162,247,184,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 974)
		{ { 115,160,228,1 }, { 14,181,178,0 }, { 147,130,231,0 }, { 38,214,184,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 975)
		{ { 115,160,231,0 }, { 6,247,178,0 }, { 115,130,231,0 }, { 38,247,176,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 976)
		{ { 115,175,8,0 }, { 39,57,131,1 }, { 8,122,231,0 }, { 224,206,114,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 977)
		{ { 115,175,11,1 }, { 47,123,131,1 }, { 232,122,231,0 }, { 224,239,122,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 978)
		{ { 115,175,4,1 }, { 47,57,147,0 }, { 144,122,231,0 }, { 100,206,122,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 979)
		{ { 115,175,7,0 }, { 39,123,147,0 }, { 112,122,231,0 }, { 100,239,114,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 980)
		{ { 115,175,120,0 }, { 55,189,131,1 }, { 15,122,231,0 }, { 224,222,246,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 981)
		{ { 115,175,123,1 }, { 63,255,131,1 }, { 239,122,231,0 }, { 224,255,254,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 982)
		{ { 115,175,116,1 }, { 63,189,147,0 }, { 151,122,231,0 }, { 100,222,254,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 983)
		{ { 115,175,119,0 }, { 55,255,147,0 }, { 119,122,231,0 }, { 100,255,246,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 984)
		{ { 115,174,152,0 }, { 55,57,162,1 }, { 12,186,231,0 }, { 162,206,118,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 985)
		{ { 115,174,155,1 }, { 63,123,162,1 }, { 236,186,231,0 }, { 162,239,126,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 986)
		{ { 115,174,148,1 }, { 63,57,178,0 }, { 148,186,231,0 }, { 38,206,126,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 987)
		{ { 115,174,151,0 }, { 55,123,178,0 }, { 116,186,231,0 }, { 38,239,118,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 988)
		{ { 115,174,232,0 }, { 39,189,162,1 }, { 11,186,231,0 }, { 162,222,242,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 989)
		{ { 115,174,235,1 }, { 47,255,162,1 }, { 235,186,231,0 }, { 162,255,250,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 990)
		{ { 115,174,228,1 }, { 47,189,178,0 }, { 147,186,231,0 }, { 38,222,250,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 991)
		{ { 115,174,231,0 }, { 39,255,178,0 }, { 115,186,231,0 }, { 38,255,242,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 992)
		{ { 115,147,8,0 }, { 38,49,193,1 }, { 8,100,231,0 }, { 193,198,50,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 993)
		{ { 115,147,11,1 }, { 46,115,193,1 }, { 232,100,231,0 }, { 193,231,58,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 994)
		{ { 115,147,4,1 }, { 46,49,209,0 }, { 144,100,231,0 }, { 69,198,58,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 995)
		{ { 115,147,7,0 }, { 38,115,209,0 }, { 112,100,231,0 }, { 69,231,50,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 996)
		{ { 115,147,120,0 }, { 54,181,193,1 }, { 15,100,231,0 }, { 193,214,182,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 997)
		{ { 115,147,123,1 }, { 62,247,193,1 }, { 239,100,231,0 }, { 193,247,190,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 998)
		{ { 115,147,116,1 }, { 62,181,209,0 }, { 151,100,231,0 }, { 69,214,190,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 999)
		{ { 115,147,119,0 }, { 54,247,209,0 }, { 119,100,231,0 }, { 69,247,182,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1000)
		{ { 115,146,152,0 }, { 54,49,224,1 }, { 12,164,231,0 }, { 131,198,54,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1001)
		{ { 115,146,155,1 }, { 62,115,224,1 }, { 236,164,231,0 }, { 131,231,62,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1002)
		{ { 115,146,148,1 }, { 62,49,240,0 }, { 148,164,231,0 }, { 7,198,62,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1003)
		{ { 115,146,151,0 }, { 54,115,240,0 }, { 116,164,231,0 }, { 7,231,54,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1004)
		{ { 115,146,232,0 }, { 38,181,224,1 }, { 11,164,231,0 }, { 131,214,178,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1005)
		{ { 115,146,235,1 }, { 46,247,224,1 }, { 235,164,231,0 }, { 131,247,186,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1006)
		{ { 115,146,228,1 }, { 46,181,240,0 }, { 147,164,231,0 }, { 7,214,186,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1007)
		{ { 115,146,231,0 }, { 38,247,240,0 }, { 115,164,231,0 }, { 7,247,178,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1008)
		{ { 115,157,8,0 }, { 7,57,193,1 }, { 8,92,231,0 }, { 193,206,112,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1009)
		{ { 115,157,11,1 }, { 15,123,193,1 }, { 232,92,231,0 }, { 193,239,120,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1010)
		{ { 115,157,4,1 }, { 15,57,209,0 }, { 144,92,231,0 }, { 69,206,120,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1011)
		{ { 115,157,7,0 }, { 7,123,209,0 }, { 112,92,231,0 }, { 69,239,112,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1012)
		{ { 115,157,120,0 }, { 23,189,193,1 }, { 15,92,231,0 }, { 193,222,244,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1013)
		{ { 115,157,123,1 }, { 31,255,193,1 }, { 239,92,231,0 }, { 193,255,252,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1014)
		{ { 115,157,116,1 }, { 31,189,209,0 }, { 151,92,231,0 }, { 69,222,252,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1015)
		{ { 115,157,119,0 }, { 23,255,209,0 }, { 119,92,231,0 }, { 69,255,244,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1016)
		{ { 115,156,152,0 }, { 23,57,224,1 }, { 12,156,231,0 }, { 131,206,116,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1017)
		{ { 115,156,155,1 }, { 31,123,224,1 }, { 236,156,231,0 }, { 131,239,124,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1018)
		{ { 115,156,148,1 }, { 31,57,240,0 }, { 148,156,231,0 }, { 7,206,124,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1019)
		{ { 115,156,151,0 }, { 23,123,240,0 }, { 116,156,231,0 }, { 7,239,116,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1020)
		{ { 115,156,232,0 }, { 7,189,224,1 }, { 11,156,231,0 }, { 131,222,240,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1021)
		{ { 115,156,235,1 }, { 15,255,224,1 }, { 235,156,231,0 }, { 131,255,248,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1022)
		{ { 115,156,228,1 }, { 15,189,240,0 }, { 147,156,231,0 }, { 7,222,248,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1023)
		{ { 115,156,231,0 }, { 7,255,240,0 }, { 115,156,231,0 }, { 7,255,240,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1024)
	#error invalid ARUCO_DB_SIZE, max database size for this aruco type is 1024
	#endif

};

#elif (ARUCO_DB == ARUCO_DB_4X4_1000)

#ifndef ARUCO_DB_SIZE
#define ARUCO_DB_SIZE 1000
#endif

#define ARUCO_BITS	4

static unsigned char database[ARUCO_DB_SIZE][4][2] = {
	#if (ARUCO_DB_SIZE > 0)
		{ { 181,50 }, { 235,72 }, { 76,173 }, { 18,215 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1)
		{ { 15,154 }, { 101,71 }, { 89,240 }, { 226,166 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2)
		{ { 51,45 }, { 222,17 }, { 180,204 }, { 136,123 }, },
	#endif
	#if (ARUCO_DB_SIZE > 3)
		{ { 153,70 }, { 193,60 }, { 98,153 }, { 60,131 }, },
	#endif
	#if (ARUCO_DB_SIZE > 4)
		{ { 84,158 }, { 161,211 }, { 121,42 }, { 203,133 }, },
	#endif
	#if (ARUCO_DB_SIZE > 5)
		{ { 121,205 }, { 216,183 }, { 179,158 }, { 237,27 }, },
	#endif
	#if (ARUCO_DB_SIZE > 6)
		{ { 158,46 }, { 135,93 }, { 116,121 }, { 186,225 }, },
	#endif
	#if (ARUCO_DB_SIZE > 7)
		{ { 196,242 }, { 35,234 }, { 79,35 }, { 87,196 }, },
	#endif
	#if (ARUCO_DB_SIZE > 8)
		{ { 254,218 }, { 173,239 }, { 91,127 }, { 247,181 }, },
	#endif
	#if (ARUCO_DB_SIZE > 9)
		{ { 207,86 }, { 101,252 }, { 106,243 }, { 63,166 }, },
	#endif
	#if (ARUCO_DB_SIZE > 10)
		{ { 249,145 }, { 248,142 }, { 137,159 }, { 113,31 }, },
	#endif
	#if (ARUCO_DB_SIZE > 11)
		{ { 17,167 }, { 211,18 }, { 229,136 }, { 72,203 }, },
	#endif
	#if (ARUCO_DB_SIZE > 12)
		{ { 14,183 }, { 55,86 }, { 237,112 }, { 106,236 }, },
	#endif
	#if (ARUCO_DB_SIZE > 13)
		{ { 42,15 }, { 29,21 }, { 240,84 }, { 168,184 }, },
	#endif
	#if (ARUCO_DB_SIZE > 14)
		{ { 36,177 }, { 58,66 }, { 141,36 }, { 66,92 }, },
	#endif
	#if (ARUCO_DB_SIZE > 15)
		{ { 38,62 }, { 47,81 }, { 124,100 }, { 138,244 }, },
	#endif
	#if (ARUCO_DB_SIZE > 16)
		{ { 70,101 }, { 22,240 }, { 166,98 }, { 15,104 }, },
	#endif
	#if (ARUCO_DB_SIZE > 17)
		{ { 102,0 }, { 12,192 }, { 0,102 }, { 3,48 }, },
	#endif
	#if (ARUCO_DB_SIZE > 18)
		{ { 108,94 }, { 41,245 }, { 122,54 }, { 175,148 }, },
	#endif
	#if (ARUCO_DB_SIZE > 19)
		{ { 118,175 }, { 159,211 }, { 245,110 }, { 203,249 }, },
	#endif
	#if (ARUCO_DB_SIZE > 20)
		{ { 134,139 }, { 21,75 }, { 209,97 }, { 210,168 }, },
	#endif
	#if (ARUCO_DB_SIZE > 21)
		{ { 176,43 }, { 155,9 }, { 212,13 }, { 144,217 }, },
	#endif
	#if (ARUCO_DB_SIZE > 22)
		{ { 204,213 }, { 48,254 }, { 171,51 }, { 127,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 23)
		{ { 221,130 }, { 193,206 }, { 65,187 }, { 115,131 }, },
	#endif
	#if (ARUCO_DB_SIZE > 24)
		{ { 254,71 }, { 157,252 }, { 226,127 }, { 63,185 }, },
	#endif
	#if (ARUCO_DB_SIZE > 25)
		{ { 148,113 }, { 178,104 }, { 142,41 }, { 22,77 }, },
	#endif
	#if (ARUCO_DB_SIZE > 26)
		{ { 172,228 }, { 10,126 }, { 39,53 }, { 126,80 }, },
	#endif
	#if (ARUCO_DB_SIZE > 27)
		{ { 165,84 }, { 104,120 }, { 42,165 }, { 30,22 }, },
	#endif
	#if (ARUCO_DB_SIZE > 28)
		{ { 33,35 }, { 91,0 }, { 196,132 }, { 0,218 }, },
	#endif
	#if (ARUCO_DB_SIZE > 29)
		{ { 52,111 }, { 155,113 }, { 246,44 }, { 142,217 }, },
	#endif
	#if (ARUCO_DB_SIZE > 30)
		{ { 68,21 }, { 48,208 }, { 168,34 }, { 11,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 31)
		{ { 87,178 }, { 231,194 }, { 77,234 }, { 67,231 }, },
	#endif
	#if (ARUCO_DB_SIZE > 32)
		{ { 158,207 }, { 149,127 }, { 243,121 }, { 254,169 }, },
	#endif
	#if (ARUCO_DB_SIZE > 33)
		{ { 240,203 }, { 153,171 }, { 211,15 }, { 213,153 }, },
	#endif
	#if (ARUCO_DB_SIZE > 34)
		{ { 8,174 }, { 3,23 }, { 117,16 }, { 232,192 }, },
	#endif
	#if (ARUCO_DB_SIZE > 35)
		{ { 9,41 }, { 82,5 }, { 148,144 }, { 160,74 }, },
	#endif
	#if (ARUCO_DB_SIZE > 36)
		{ { 24,117 }, { 178,52 }, { 174,24 }, { 44,77 }, },
	#endif
	#if (ARUCO_DB_SIZE > 37)
		{ { 4,255 }, { 51,115 }, { 255,32 }, { 206,204 }, },
	#endif
	#if (ARUCO_DB_SIZE > 38)
		{ { 13,246 }, { 99,118 }, { 111,176 }, { 110,198 }, },
	#endif
	#if (ARUCO_DB_SIZE > 39)
		{ { 28,90 }, { 161,101 }, { 90,56 }, { 166,133 }, },
	#endif
	#if (ARUCO_DB_SIZE > 40)
		{ { 23,24 }, { 228,65 }, { 24,232 }, { 130,39 }, },
	#endif
	#if (ARUCO_DB_SIZE > 41)
		{ { 42,40 }, { 14,5 }, { 20,84 }, { 160,112 }, },
	#endif
	#if (ARUCO_DB_SIZE > 42)
		{ { 50,140 }, { 140,19 }, { 49,76 }, { 200,49 }, },
	#endif
	#if (ARUCO_DB_SIZE > 43)
		{ { 56,178 }, { 171,6 }, { 77,28 }, { 96,213 }, },
	#endif
	#if (ARUCO_DB_SIZE > 44)
		{ { 36,232 }, { 10,99 }, { 23,36 }, { 198,80 }, },
	#endif
	#if (ARUCO_DB_SIZE > 45)
		{ { 46,235 }, { 31,103 }, { 215,116 }, { 230,248 }, },
	#endif
	#if (ARUCO_DB_SIZE > 46)
		{ { 45,63 }, { 123,85 }, { 252,180 }, { 170,222 }, },
	#endif
	#if (ARUCO_DB_SIZE > 47)
		{ { 75,100 }, { 70,180 }, { 38,210 }, { 45,98 }, },
	#endif
	#if (ARUCO_DB_SIZE > 48)
		{ { 80,46 }, { 131,145 }, { 116,10 }, { 137,193 }, },
	#endif
	#if (ARUCO_DB_SIZE > 49)
		{ { 80,19 }, { 177,128 }, { 200,10 }, { 1,141 }, },
	#endif
	#if (ARUCO_DB_SIZE > 50)
		{ { 81,148 }, { 224,146 }, { 41,138 }, { 73,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 51)
		{ { 85,104 }, { 194,225 }, { 22,170 }, { 135,67 }, },
	#endif
	#if (ARUCO_DB_SIZE > 52)
		{ { 93,65 }, { 208,228 }, { 130,186 }, { 39,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 53)
		{ { 95,151 }, { 245,214 }, { 233,250 }, { 107,175 }, },
	#endif
	#if (ARUCO_DB_SIZE > 54)
		{ { 104,1 }, { 24,132 }, { 128,22 }, { 33,24 }, },
	#endif
	#if (ARUCO_DB_SIZE > 55)
		{ { 104,103 }, { 27,180 }, { 230,22 }, { 45,216 }, },
	#endif
	#if (ARUCO_DB_SIZE > 56)
		{ { 97,36 }, { 74,144 }, { 36,134 }, { 9,82 }, },
	#endif
	#if (ARUCO_DB_SIZE > 57)
		{ { 97,233 }, { 90,163 }, { 151,134 }, { 197,90 }, },
	#endif
	#if (ARUCO_DB_SIZE > 58)
		{ { 107,18 }, { 109,132 }, { 72,214 }, { 33,182 }, },
	#endif
	#if (ARUCO_DB_SIZE > 59)
		{ { 111,229 }, { 94,246 }, { 167,246 }, { 111,122 }, },
	#endif
	#if (ARUCO_DB_SIZE > 60)
		{ { 103,223 }, { 125,243 }, { 251,230 }, { 207,190 }, },
	#endif
	#if (ARUCO_DB_SIZE > 61)
		{ { 126,27 }, { 189,197 }, { 216,126 }, { 163,189 }, },
	#endif
	#if (ARUCO_DB_SIZE > 62)
		{ { 128,160 }, { 2,10 }, { 5,1 }, { 80,64 }, },
	#endif
	#if (ARUCO_DB_SIZE > 63)
		{ { 131,68 }, { 68,56 }, { 34,193 }, { 28,34 }, },
	#endif
	#if (ARUCO_DB_SIZE > 64)
		{ { 139,162 }, { 71,14 }, { 69,209 }, { 112,226 }, },
	#endif
	#if (ARUCO_DB_SIZE > 65)
		{ { 147,122 }, { 231,41 }, { 94,201 }, { 148,231 }, },
	#endif
	#if (ARUCO_DB_SIZE > 66)
		{ { 132,108 }, { 2,121 }, { 54,33 }, { 158,64 }, },
	#endif
	#if (ARUCO_DB_SIZE > 67)
		{ { 133,42 }, { 67,73 }, { 84,161 }, { 146,194 }, },
	#endif
	#if (ARUCO_DB_SIZE > 68)
		{ { 133,156 }, { 96,91 }, { 57,161 }, { 218,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 69)
		{ { 156,137 }, { 144,79 }, { 145,57 }, { 242,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 70)
		{ { 159,161 }, { 214,78 }, { 133,249 }, { 114,107 }, },
	#endif
	#if (ARUCO_DB_SIZE > 71)
		{ { 187,124 }, { 238,61 }, { 62,221 }, { 188,119 }, },
	#endif
	#if (ARUCO_DB_SIZE > 72)
		{ { 188,4 }, { 136,92 }, { 32,61 }, { 58,17 }, },
	#endif
	#if (ARUCO_DB_SIZE > 73)
		{ { 182,91 }, { 189,105 }, { 218,109 }, { 150,189 }, },
	#endif
	#if (ARUCO_DB_SIZE > 74)
		{ { 191,200 }, { 204,111 }, { 19,253 }, { 246,51 }, },
	#endif
	#if (ARUCO_DB_SIZE > 75)
		{ { 183,171 }, { 223,75 }, { 213,237 }, { 210,251 }, },
	#endif
	#if (ARUCO_DB_SIZE > 76)
		{ { 202,31 }, { 53,157 }, { 248,83 }, { 185,172 }, },
	#endif
	#if (ARUCO_DB_SIZE > 77)
		{ { 201,98 }, { 67,172 }, { 70,147 }, { 53,194 }, },
	#endif
	#if (ARUCO_DB_SIZE > 78)
		{ { 217,88 }, { 224,173 }, { 26,155 }, { 181,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 79)
		{ { 211,213 }, { 244,186 }, { 171,203 }, { 93,47 }, },
	#endif
	#if (ARUCO_DB_SIZE > 80)
		{ { 204,152 }, { 32,207 }, { 25,51 }, { 243,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 81)
		{ { 199,160 }, { 70,202 }, { 5,227 }, { 83,98 }, },
	#endif
	#if (ARUCO_DB_SIZE > 82)
		{ { 197,55 }, { 115,216 }, { 236,163 }, { 27,206 }, },
	#endif
	#if (ARUCO_DB_SIZE > 83)
		{ { 233,93 }, { 120,189 }, { 186,151 }, { 189,30 }, },
	#endif
	#if (ARUCO_DB_SIZE > 84)
		{ { 249,37 }, { 218,156 }, { 164,159 }, { 57,91 }, },
	#endif
	#if (ARUCO_DB_SIZE > 85)
		{ { 251,187 }, { 255,143 }, { 221,223 }, { 241,255 }, },
	#endif
	#if (ARUCO_DB_SIZE > 86)
		{ { 238,42 }, { 15,205 }, { 84,119 }, { 179,240 }, },
	#endif
	#if (ARUCO_DB_SIZE > 87)
		{ { 247,77 }, { 220,249 }, { 178,239 }, { 159,59 }, },
	#endif
	#if (ARUCO_DB_SIZE > 88)
		{ { 53,117 }, { 250,112 }, { 174,172 }, { 14,95 }, },
	#endif
	#if (ARUCO_DB_SIZE > 89)
		{ { 138,173 }, { 22,31 }, { 181,81 }, { 248,104 }, },
	#endif
	#if (ARUCO_DB_SIZE > 90)
		{ { 118,23 }, { 189,208 }, { 232,110 }, { 11,189 }, },
	#endif
	#if (ARUCO_DB_SIZE > 91)
		{ { 10,207 }, { 21,55 }, { 243,80 }, { 236,168 }, },
	#endif
	#if (ARUCO_DB_SIZE > 92)
		{ { 6,75 }, { 21,97 }, { 210,96 }, { 134,168 }, },
	#endif
	#if (ARUCO_DB_SIZE > 93)
		{ { 45,193 }, { 88,102 }, { 131,180 }, { 102,26 }, },
	#endif
	#if (ARUCO_DB_SIZE > 94)
		{ { 73,216 }, { 96,167 }, { 27,146 }, { 229,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 95)
		{ { 67,244 }, { 102,178 }, { 47,194 }, { 77,102 }, },
	#endif
	#if (ARUCO_DB_SIZE > 96)
		{ { 79,54 }, { 103,212 }, { 108,242 }, { 43,230 }, },
	#endif
	#if (ARUCO_DB_SIZE > 97)
		{ { 79,211 }, { 117,230 }, { 203,242 }, { 103,174 }, },
	#endif
	#if (ARUCO_DB_SIZE > 98)
		{ { 105,228 }, { 74,182 }, { 39,150 }, { 109,82 }, },
	#endif
	#if (ARUCO_DB_SIZE > 99)
		{ { 112,199 }, { 153,178 }, { 227,14 }, { 77,153 }, },
	#endif
	#if (ARUCO_DB_SIZE > 100)
		{ { 122,110 }, { 143,181 }, { 118,94 }, { 173,241 }, },
	#endif
	#if (ARUCO_DB_SIZE > 101)
		{ { 180,234 }, { 139,107 }, { 87,45 }, { 214,209 }, },
	#endif
	#if (ARUCO_DB_SIZE > 102)
		{ { 237,79 }, { 89,253 }, { 242,183 }, { 191,154 }, },
	#endif
	#if (ARUCO_DB_SIZE > 103)
		{ { 252,231 }, { 155,254 }, { 231,63 }, { 127,217 }, },
	#endif
	#if (ARUCO_DB_SIZE > 104)
		{ { 254,166 }, { 143,222 }, { 101,127 }, { 123,241 }, },
	#endif
	#if (ARUCO_DB_SIZE > 105)
		{ { 0,37 }, { 18,16 }, { 164,0 }, { 8,72 }, },
	#endif
	#if (ARUCO_DB_SIZE > 106)
		{ { 0,67 }, { 17,32 }, { 194,0 }, { 4,136 }, },
	#endif
	#if (ARUCO_DB_SIZE > 107)
		{ { 10,136 }, { 4,7 }, { 17,80 }, { 224,32 }, },
	#endif
	#if (ARUCO_DB_SIZE > 108)
		{ { 10,134 }, { 5,22 }, { 97,80 }, { 104,160 }, },
	#endif
	#if (ARUCO_DB_SIZE > 109)
		{ { 2,111 }, { 23,49 }, { 246,64 }, { 140,232 }, },
	#endif
	#if (ARUCO_DB_SIZE > 110)
		{ { 0,28 }, { 32,17 }, { 56,0 }, { 136,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 111)
		{ { 0,151 }, { 49,18 }, { 233,0 }, { 72,140 }, },
	#endif
	#if (ARUCO_DB_SIZE > 112)
		{ { 8,55 }, { 51,20 }, { 236,16 }, { 40,204 }, },
	#endif
	#if (ARUCO_DB_SIZE > 113)
		{ { 10,49 }, { 54,4 }, { 140,80 }, { 32,108 }, },
	#endif
	#if (ARUCO_DB_SIZE > 114)
		{ { 9,198 }, { 65,54 }, { 99,144 }, { 108,130 }, },
	#endif
	#if (ARUCO_DB_SIZE > 115)
		{ { 11,1 }, { 84,4 }, { 128,208 }, { 32,42 }, },
	#endif
	#if (ARUCO_DB_SIZE > 116)
		{ { 9,251 }, { 115,39 }, { 223,144 }, { 228,206 }, },
	#endif
	#if (ARUCO_DB_SIZE > 117)
		{ { 11,88 }, { 100,37 }, { 26,208 }, { 164,38 }, },
	#endif
	#if (ARUCO_DB_SIZE > 118)
		{ { 16,130 }, { 129,2 }, { 65,8 }, { 64,129 }, },
	#endif
	#if (ARUCO_DB_SIZE > 119)
		{ { 24,45 }, { 146,21 }, { 180,24 }, { 168,73 }, },
	#endif
	#if (ARUCO_DB_SIZE > 120)
		{ { 16,120 }, { 162,33 }, { 30,8 }, { 132,69 }, },
	#endif
	#if (ARUCO_DB_SIZE > 121)
		{ { 16,115 }, { 179,32 }, { 206,8 }, { 4,205 }, },
	#endif
	#if (ARUCO_DB_SIZE > 122)
		{ { 18,116 }, { 166,48 }, { 46,72 }, { 12,101 }, },
	#endif
	#if (ARUCO_DB_SIZE > 123)
		{ { 18,177 }, { 182,2 }, { 141,72 }, { 64,109 }, },
	#endif
	#if (ARUCO_DB_SIZE > 124)
		{ { 26,249 }, { 182,39 }, { 159,88 }, { 228,109 }, },
	#endif
	#if (ARUCO_DB_SIZE > 125)
		{ { 19,6 }, { 197,16 }, { 96,200 }, { 8,163 }, },
	#endif
	#if (ARUCO_DB_SIZE > 126)
		{ { 12,14 }, { 1,85 }, { 112,48 }, { 170,128 }, },
	#endif
	#if (ARUCO_DB_SIZE > 127)
		{ { 12,241 }, { 50,102 }, { 143,48 }, { 102,76 }, },
	#endif
	#if (ARUCO_DB_SIZE > 128)
		{ { 4,51 }, { 51,64 }, { 204,32 }, { 2,204 }, },
	#endif
	#if (ARUCO_DB_SIZE > 129)
		{ { 12,159 }, { 49,87 }, { 249,48 }, { 234,140 }, },
	#endif
	#if (ARUCO_DB_SIZE > 130)
		{ { 14,242 }, { 39,102 }, { 79,112 }, { 102,228 }, },
	#endif
	#if (ARUCO_DB_SIZE > 131)
		{ { 14,253 }, { 54,119 }, { 191,112 }, { 238,108 }, },
	#endif
	#if (ARUCO_DB_SIZE > 132)
		{ { 7,76 }, { 68,113 }, { 50,224 }, { 142,34 }, },
	#endif
	#if (ARUCO_DB_SIZE > 133)
		{ { 15,164 }, { 70,86 }, { 37,240 }, { 106,98 }, },
	#endif
	#if (ARUCO_DB_SIZE > 134)
		{ { 7,47 }, { 87,81 }, { 244,224 }, { 138,234 }, },
	#endif
	#if (ARUCO_DB_SIZE > 135)
		{ { 5,181 }, { 114,82 }, { 173,160 }, { 74,78 }, },
	#endif
	#if (ARUCO_DB_SIZE > 136)
		{ { 15,145 }, { 116,70 }, { 137,240 }, { 98,46 }, },
	#endif
	#if (ARUCO_DB_SIZE > 137)
		{ { 7,219 }, { 117,99 }, { 219,224 }, { 198,174 }, },
	#endif
	#if (ARUCO_DB_SIZE > 138)
		{ { 30,228 }, { 134,118 }, { 39,120 }, { 110,97 }, },
	#endif
	#if (ARUCO_DB_SIZE > 139)
		{ { 20,57 }, { 178,65 }, { 156,40 }, { 130,77 }, },
	#endif
	#if (ARUCO_DB_SIZE > 140)
		{ { 29,128 }, { 192,70 }, { 1,184 }, { 98,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 141)
		{ { 21,200 }, { 192,99 }, { 19,168 }, { 198,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 142)
		{ { 31,139 }, { 213,71 }, { 209,248 }, { 226,171 }, },
	#endif
	#if (ARUCO_DB_SIZE > 143)
		{ { 21,186 }, { 227,67 }, { 93,168 }, { 194,199 }, },
	#endif
	#if (ARUCO_DB_SIZE > 144)
		{ { 29,177 }, { 242,70 }, { 141,184 }, { 98,79 }, },
	#endif
	#if (ARUCO_DB_SIZE > 145)
		{ { 32,128 }, { 8,2 }, { 1,4 }, { 64,16 }, },
	#endif
	#if (ARUCO_DB_SIZE > 146)
		{ { 40,233 }, { 26,39 }, { 151,20 }, { 228,88 }, },
	#endif
	#if (ARUCO_DB_SIZE > 147)
		{ { 34,162 }, { 15,2 }, { 69,68 }, { 64,240 }, },
	#endif
	#if (ARUCO_DB_SIZE > 148)
		{ { 40,83 }, { 57,36 }, { 202,20 }, { 36,156 }, },
	#endif
	#if (ARUCO_DB_SIZE > 149)
		{ { 42,240 }, { 46,38 }, { 15,84 }, { 100,116 }, },
	#endif
	#if (ARUCO_DB_SIZE > 150)
		{ { 34,247 }, { 63,50 }, { 239,68 }, { 76,252 }, },
	#endif
	#if (ARUCO_DB_SIZE > 151)
		{ { 41,64 }, { 72,36 }, { 2,148 }, { 36,18 }, },
	#endif
	#if (ARUCO_DB_SIZE > 152)
		{ { 33,70 }, { 73,48 }, { 98,132 }, { 12,146 }, },
	#endif
	#if (ARUCO_DB_SIZE > 153)
		{ { 41,185 }, { 122,7 }, { 157,148 }, { 224,94 }, },
	#endif
	#if (ARUCO_DB_SIZE > 154)
		{ { 43,156 }, { 108,23 }, { 57,212 }, { 232,54 }, },
	#endif
	#if (ARUCO_DB_SIZE > 155)
		{ { 43,178 }, { 111,6 }, { 77,212 }, { 96,246 }, },
	#endif
	#if (ARUCO_DB_SIZE > 156)
		{ { 56,202 }, { 137,39 }, { 83,28 }, { 228,145 }, },
	#endif
	#if (ARUCO_DB_SIZE > 157)
		{ { 56,46 }, { 139,21 }, { 116,28 }, { 168,209 }, },
	#endif
	#if (ARUCO_DB_SIZE > 158)
		{ { 48,7 }, { 153,16 }, { 224,12 }, { 8,153 }, },
	#endif
	#if (ARUCO_DB_SIZE > 159)
		{ { 56,231 }, { 155,54 }, { 231,28 }, { 108,217 }, },
	#endif
	#if (ARUCO_DB_SIZE > 160)
		{ { 58,73 }, { 156,37 }, { 146,92 }, { 164,57 }, },
	#endif
	#if (ARUCO_DB_SIZE > 161)
		{ { 58,101 }, { 158,52 }, { 166,92 }, { 44,121 }, },
	#endif
	#if (ARUCO_DB_SIZE > 162)
		{ { 50,93 }, { 188,49 }, { 186,76 }, { 140,61 }, },
	#endif
	#if (ARUCO_DB_SIZE > 163)
		{ { 59,136 }, { 204,7 }, { 17,220 }, { 224,51 }, },
	#endif
	#if (ARUCO_DB_SIZE > 164)
		{ { 57,29 }, { 248,21 }, { 184,156 }, { 168,31 }, },
	#endif
	#if (ARUCO_DB_SIZE > 165)
		{ { 59,211 }, { 253,38 }, { 203,220 }, { 100,191 }, },
	#endif
	#if (ARUCO_DB_SIZE > 166)
		{ { 38,71 }, { 29,112 }, { 226,100 }, { 14,184 }, },
	#endif
	#if (ARUCO_DB_SIZE > 167)
		{ { 39,128 }, { 76,66 }, { 1,228 }, { 66,50 }, },
	#endif
	#if (ARUCO_DB_SIZE > 168)
		{ { 47,170 }, { 79,71 }, { 85,244 }, { 226,242 }, },
	#endif
	#if (ARUCO_DB_SIZE > 169)
		{ { 45,20 }, { 104,84 }, { 40,180 }, { 42,22 }, },
	#endif
	#if (ARUCO_DB_SIZE > 170)
		{ { 37,222 }, { 105,115 }, { 123,164 }, { 206,150 }, },
	#endif
	#if (ARUCO_DB_SIZE > 171)
		{ { 37,83 }, { 121,96 }, { 202,164 }, { 6,158 }, },
	#endif
	#if (ARUCO_DB_SIZE > 172)
		{ { 47,119 }, { 127,116 }, { 238,244 }, { 46,254 }, },
	#endif
	#if (ARUCO_DB_SIZE > 173)
		{ { 52,72 }, { 136,97 }, { 18,44 }, { 134,17 }, },
	#endif
	#if (ARUCO_DB_SIZE > 174)
		{ { 60,168 }, { 138,71 }, { 21,60 }, { 226,81 }, },
	#endif
	#if (ARUCO_DB_SIZE > 175)
		{ { 60,65 }, { 152,100 }, { 130,60 }, { 38,25 }, },
	#endif
	#if (ARUCO_DB_SIZE > 176)
		{ { 52,13 }, { 152,81 }, { 176,44 }, { 138,25 }, },
	#endif
	#if (ARUCO_DB_SIZE > 177)
		{ { 52,251 }, { 187,99 }, { 223,44 }, { 198,221 }, },
	#endif
	#if (ARUCO_DB_SIZE > 178)
		{ { 54,154 }, { 173,67 }, { 89,108 }, { 194,181 }, },
	#endif
	#if (ARUCO_DB_SIZE > 179)
		{ { 61,224 }, { 202,102 }, { 7,188 }, { 102,83 }, },
	#endif
	#if (ARUCO_DB_SIZE > 180)
		{ { 53,106 }, { 203,97 }, { 86,172 }, { 134,211 }, },
	#endif
	#if (ARUCO_DB_SIZE > 181)
		{ { 61,9 }, { 216,69 }, { 144,188 }, { 162,27 }, },
	#endif
	#if (ARUCO_DB_SIZE > 182)
		{ { 61,237 }, { 218,119 }, { 183,188 }, { 238,91 }, },
	#endif
	#if (ARUCO_DB_SIZE > 183)
		{ { 63,196 }, { 204,118 }, { 35,252 }, { 110,51 }, },
	#endif
	#if (ARUCO_DB_SIZE > 184)
		{ { 63,108 }, { 206,117 }, { 54,252 }, { 174,115 }, },
	#endif
	#if (ARUCO_DB_SIZE > 185)
		{ { 55,206 }, { 205,115 }, { 115,236 }, { 206,179 }, },
	#endif
	#if (ARUCO_DB_SIZE > 186)
		{ { 61,92 }, { 232,117 }, { 58,188 }, { 174,23 }, },
	#endif
	#if (ARUCO_DB_SIZE > 187)
		{ { 61,118 }, { 235,116 }, { 110,188 }, { 46,215 }, },
	#endif
	#if (ARUCO_DB_SIZE > 188)
		{ { 55,176 }, { 238,66 }, { 13,236 }, { 66,119 }, },
	#endif
	#if (ARUCO_DB_SIZE > 189)
		{ { 63,23 }, { 253,84 }, { 232,252 }, { 42,191 }, },
	#endif
	#if (ARUCO_DB_SIZE > 190)
		{ { 63,255 }, { 255,119 }, { 255,252 }, { 238,255 }, },
	#endif
	#if (ARUCO_DB_SIZE > 191)
		{ { 72,229 }, { 18,182 }, { 167,18 }, { 109,72 }, },
	#endif
	#if (ARUCO_DB_SIZE > 192)
		{ { 66,104 }, { 6,161 }, { 22,66 }, { 133,96 }, },
	#endif
	#if (ARUCO_DB_SIZE > 193)
		{ { 74,45 }, { 22,149 }, { 180,82 }, { 169,104 }, },
	#endif
	#if (ARUCO_DB_SIZE > 194)
		{ { 65,96 }, { 66,160 }, { 6,130 }, { 5,66 }, },
	#endif
	#if (ARUCO_DB_SIZE > 195)
		{ { 73,81 }, { 112,164 }, { 138,146 }, { 37,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 196)
		{ { 65,221 }, { 112,179 }, { 187,130 }, { 205,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 197)
		{ { 75,223 }, { 117,183 }, { 251,210 }, { 237,174 }, },
	#endif
	#if (ARUCO_DB_SIZE > 198)
		{ { 88,79 }, { 145,181 }, { 242,26 }, { 173,137 }, },
	#endif
	#if (ARUCO_DB_SIZE > 199)
		{ { 90,72 }, { 132,165 }, { 18,90 }, { 165,33 }, },
	#endif
	#if (ARUCO_DB_SIZE > 200)
		{ { 88,22 }, { 161,148 }, { 104,26 }, { 41,133 }, },
	#endif
	#if (ARUCO_DB_SIZE > 201)
		{ { 80,93 }, { 176,177 }, { 186,10 }, { 141,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 202)
		{ { 90,250 }, { 167,167 }, { 95,90 }, { 229,229 }, },
	#endif
	#if (ARUCO_DB_SIZE > 203)
		{ { 90,181 }, { 182,150 }, { 173,90 }, { 105,109 }, },
	#endif
	#if (ARUCO_DB_SIZE > 204)
		{ { 81,35 }, { 211,128 }, { 196,138 }, { 1,203 }, },
	#endif
	#if (ARUCO_DB_SIZE > 205)
		{ { 91,138 }, { 197,135 }, { 81,218 }, { 225,163 }, },
	#endif
	#if (ARUCO_DB_SIZE > 206)
		{ { 89,25 }, { 240,133 }, { 152,154 }, { 161,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 207)
		{ { 81,53 }, { 242,144 }, { 172,138 }, { 9,79 }, },
	#endif
	#if (ARUCO_DB_SIZE > 208)
		{ { 76,105 }, { 18,229 }, { 150,50 }, { 167,72 }, },
	#endif
	#if (ARUCO_DB_SIZE > 209)
		{ { 70,193 }, { 20,226 }, { 131,98 }, { 71,40 }, },
	#endif
	#if (ARUCO_DB_SIZE > 210)
		{ { 78,11 }, { 21,197 }, { 208,114 }, { 163,168 }, },
	#endif
	#if (ARUCO_DB_SIZE > 211)
		{ { 68,95 }, { 49,241 }, { 250,34 }, { 143,140 }, },
	#endif
	#if (ARUCO_DB_SIZE > 212)
		{ { 78,89 }, { 52,229 }, { 154,114 }, { 167,44 }, },
	#endif
	#if (ARUCO_DB_SIZE > 213)
		{ { 77,131 }, { 81,198 }, { 193,178 }, { 99,138 }, },
	#endif
	#if (ARUCO_DB_SIZE > 214)
		{ { 77,125 }, { 114,245 }, { 190,178 }, { 175,78 }, },
	#endif
	#if (ARUCO_DB_SIZE > 215)
		{ { 71,216 }, { 100,227 }, { 27,226 }, { 199,38 }, },
	#endif
	#if (ARUCO_DB_SIZE > 216)
		{ { 71,115 }, { 119,224 }, { 206,226 }, { 7,238 }, },
	#endif
	#if (ARUCO_DB_SIZE > 217)
		{ { 92,133 }, { 144,214 }, { 161,58 }, { 107,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 218)
		{ { 94,68 }, { 132,244 }, { 34,122 }, { 47,33 }, },
	#endif
	#if (ARUCO_DB_SIZE > 219)
		{ { 86,43 }, { 151,193 }, { 212,106 }, { 131,233 }, },
	#endif
	#if (ARUCO_DB_SIZE > 220)
		{ { 92,187 }, { 179,199 }, { 221,58 }, { 227,205 }, },
	#endif
	#if (ARUCO_DB_SIZE > 221)
		{ { 85,195 }, { 209,226 }, { 195,170 }, { 71,139 }, },
	#endif
	#if (ARUCO_DB_SIZE > 222)
		{ { 95,110 }, { 199,245 }, { 118,250 }, { 175,227 }, },
	#endif
	#if (ARUCO_DB_SIZE > 223)
		{ { 95,235 }, { 215,231 }, { 215,250 }, { 231,235 }, },
	#endif
	#if (ARUCO_DB_SIZE > 224)
		{ { 93,18 }, { 225,196 }, { 72,186 }, { 35,135 }, },
	#endif
	#if (ARUCO_DB_SIZE > 225)
		{ { 85,94 }, { 225,241 }, { 122,170 }, { 143,135 }, },
	#endif
	#if (ARUCO_DB_SIZE > 226)
		{ { 98,112 }, { 46,160 }, { 14,70 }, { 5,116 }, },
	#endif
	#if (ARUCO_DB_SIZE > 227)
		{ { 98,21 }, { 60,144 }, { 168,70 }, { 9,60 }, },
	#endif
	#if (ARUCO_DB_SIZE > 228)
		{ { 97,194 }, { 73,162 }, { 67,134 }, { 69,146 }, },
	#endif
	#if (ARUCO_DB_SIZE > 229)
		{ { 107,32 }, { 78,132 }, { 4,214 }, { 33,114 }, },
	#endif
	#if (ARUCO_DB_SIZE > 230)
		{ { 99,69 }, { 92,176 }, { 162,198 }, { 13,58 }, },
	#endif
	#if (ARUCO_DB_SIZE > 231)
		{ { 107,92 }, { 108,181 }, { 58,214 }, { 173,54 }, },
	#endif
	#if (ARUCO_DB_SIZE > 232)
		{ { 107,91 }, { 125,165 }, { 218,214 }, { 165,190 }, },
	#endif
	#if (ARUCO_DB_SIZE > 233)
		{ { 120,12 }, { 136,149 }, { 48,30 }, { 169,17 }, },
	#endif
	#if (ARUCO_DB_SIZE > 234)
		{ { 122,207 }, { 157,183 }, { 243,94 }, { 237,185 }, },
	#endif
	#if (ARUCO_DB_SIZE > 235)
		{ { 120,127 }, { 187,181 }, { 254,30 }, { 173,221 }, },
	#endif
	#if (ARUCO_DB_SIZE > 236)
		{ { 121,128 }, { 200,134 }, { 1,158 }, { 97,19 }, },
	#endif
	#if (ARUCO_DB_SIZE > 237)
		{ { 113,229 }, { 218,178 }, { 167,142 }, { 77,91 }, },
	#endif
	#if (ARUCO_DB_SIZE > 238)
		{ { 113,116 }, { 234,176 }, { 46,142 }, { 13,87 }, },
	#endif
	#if (ARUCO_DB_SIZE > 239)
		{ { 121,182 }, { 235,150 }, { 109,158 }, { 105,215 }, },
	#endif
	#if (ARUCO_DB_SIZE > 240)
		{ { 113,211 }, { 249,162 }, { 203,142 }, { 69,159 }, },
	#endif
	#if (ARUCO_DB_SIZE > 241)
		{ { 123,51 }, { 255,132 }, { 204,222 }, { 33,255 }, },
	#endif
	#if (ARUCO_DB_SIZE > 242)
		{ { 100,106 }, { 11,225 }, { 86,38 }, { 135,208 }, },
	#endif
	#if (ARUCO_DB_SIZE > 243)
		{ { 102,168 }, { 14,195 }, { 21,102 }, { 195,112 }, },
	#endif
	#if (ARUCO_DB_SIZE > 244)
		{ { 110,167 }, { 31,214 }, { 229,118 }, { 107,248 }, },
	#endif
	#if (ARUCO_DB_SIZE > 245)
		{ { 110,145 }, { 60,198 }, { 137,118 }, { 99,60 }, },
	#endif
	#if (ARUCO_DB_SIZE > 246)
		{ { 101,34 }, { 75,192 }, { 68,166 }, { 3,210 }, },
	#endif
	#if (ARUCO_DB_SIZE > 247)
		{ { 109,203 }, { 89,231 }, { 211,182 }, { 231,154 }, },
	#endif
	#if (ARUCO_DB_SIZE > 248)
		{ { 103,141 }, { 92,211 }, { 177,230 }, { 203,58 }, },
	#endif
	#if (ARUCO_DB_SIZE > 249)
		{ { 109,49 }, { 122,196 }, { 140,182 }, { 35,94 }, },
	#endif
	#if (ARUCO_DB_SIZE > 250)
		{ { 126,128 }, { 140,198 }, { 1,126 }, { 99,49 }, },
	#endif
	#if (ARUCO_DB_SIZE > 251)
		{ { 126,226 }, { 143,230 }, { 71,126 }, { 103,241 }, },
	#endif
	#if (ARUCO_DB_SIZE > 252)
		{ { 126,141 }, { 156,215 }, { 177,126 }, { 235,57 }, },
	#endif
	#if (ARUCO_DB_SIZE > 253)
		{ { 116,210 }, { 169,226 }, { 75,46 }, { 71,149 }, },
	#endif
	#if (ARUCO_DB_SIZE > 254)
		{ { 124,50 }, { 171,196 }, { 76,62 }, { 35,213 }, },
	#endif
	#if (ARUCO_DB_SIZE > 255)
		{ { 126,53 }, { 190,212 }, { 172,126 }, { 43,125 }, },
	#endif
	#if (ARUCO_DB_SIZE > 256)
		{ { 117,171 }, { 219,195 }, { 213,174 }, { 195,219 }, },
	#endif
	#if (ARUCO_DB_SIZE > 257)
		{ { 119,5 }, { 220,208 }, { 160,238 }, { 11,59 }, },
	#endif
	#if (ARUCO_DB_SIZE > 258)
		{ { 127,43 }, { 223,197 }, { 212,254 }, { 163,251 }, },
	#endif
	#if (ARUCO_DB_SIZE > 259)
		{ { 125,218 }, { 233,231 }, { 91,190 }, { 231,151 }, },
	#endif
	#if (ARUCO_DB_SIZE > 260)
		{ { 127,146 }, { 237,198 }, { 73,254 }, { 99,183 }, },
	#endif
	#if (ARUCO_DB_SIZE > 261)
		{ { 128,117 }, { 50,56 }, { 174,1 }, { 28,76 }, },
	#endif
	#if (ARUCO_DB_SIZE > 262)
		{ { 128,243 }, { 51,42 }, { 207,1 }, { 84,204 }, },
	#endif
	#if (ARUCO_DB_SIZE > 263)
		{ { 129,166 }, { 67,26 }, { 101,129 }, { 88,194 }, },
	#endif
	#if (ARUCO_DB_SIZE > 264)
		{ { 137,237 }, { 82,63 }, { 183,145 }, { 252,74 }, },
	#endif
	#if (ARUCO_DB_SIZE > 265)
		{ { 129,252 }, { 98,59 }, { 63,129 }, { 220,70 }, },
	#endif
	#if (ARUCO_DB_SIZE > 266)
		{ { 152,166 }, { 131,30 }, { 101,25 }, { 120,193 }, },
	#endif
	#if (ARUCO_DB_SIZE > 267)
		{ { 154,32 }, { 134,12 }, { 4,89 }, { 48,97 }, },
	#endif
	#if (ARUCO_DB_SIZE > 268)
		{ { 145,67 }, { 209,40 }, { 194,137 }, { 20,139 }, },
	#endif
	#if (ARUCO_DB_SIZE > 269)
		{ { 153,249 }, { 242,47 }, { 159,153 }, { 244,79 }, },
	#endif
	#if (ARUCO_DB_SIZE > 270)
		{ { 145,147 }, { 241,10 }, { 201,137 }, { 80,143 }, },
	#endif
	#if (ARUCO_DB_SIZE > 271)
		{ { 155,212 }, { 228,62 }, { 43,217 }, { 124,39 }, },
	#endif
	#if (ARUCO_DB_SIZE > 272)
		{ { 132,9 }, { 16,73 }, { 144,33 }, { 146,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 273)
		{ { 132,107 }, { 19,105 }, { 214,33 }, { 150,200 }, },
	#endif
	#if (ARUCO_DB_SIZE > 274)
		{ { 134,196 }, { 4,122 }, { 35,97 }, { 94,32 }, },
	#endif
	#if (ARUCO_DB_SIZE > 275)
		{ { 142,100 }, { 6,124 }, { 38,113 }, { 62,96 }, },
	#endif
	#if (ARUCO_DB_SIZE > 276)
		{ { 134,26 }, { 37,73 }, { 88,97 }, { 146,164 }, },
	#endif
	#if (ARUCO_DB_SIZE > 277)
		{ { 133,78 }, { 65,121 }, { 114,161 }, { 158,130 }, },
	#endif
	#if (ARUCO_DB_SIZE > 278)
		{ { 141,203 }, { 81,111 }, { 211,177 }, { 246,138 }, },
	#endif
	#if (ARUCO_DB_SIZE > 279)
		{ { 133,103 }, { 83,120 }, { 230,161 }, { 30,202 }, },
	#endif
	#if (ARUCO_DB_SIZE > 280)
		{ { 133,175 }, { 83,91 }, { 245,161 }, { 218,202 }, },
	#endif
	#if (ARUCO_DB_SIZE > 281)
		{ { 133,215 }, { 113,122 }, { 235,161 }, { 94,142 }, },
	#endif
	#if (ARUCO_DB_SIZE > 282)
		{ { 135,179 }, { 119,74 }, { 205,225 }, { 82,238 }, },
	#endif
	#if (ARUCO_DB_SIZE > 283)
		{ { 156,225 }, { 146,110 }, { 135,57 }, { 118,73 }, },
	#endif
	#if (ARUCO_DB_SIZE > 284)
		{ { 156,242 }, { 163,110 }, { 79,57 }, { 118,197 }, },
	#endif
	#if (ARUCO_DB_SIZE > 285)
		{ { 148,23 }, { 177,88 }, { 232,41 }, { 26,141 }, },
	#endif
	#if (ARUCO_DB_SIZE > 286)
		{ { 149,0 }, { 192,72 }, { 0,169 }, { 18,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 287)
		{ { 149,162 }, { 195,74 }, { 69,169 }, { 82,195 }, },
	#endif
	#if (ARUCO_DB_SIZE > 288)
		{ { 157,35 }, { 211,76 }, { 196,185 }, { 50,203 }, },
	#endif
	#if (ARUCO_DB_SIZE > 289)
		{ { 159,98 }, { 199,108 }, { 70,249 }, { 54,227 }, },
	#endif
	#if (ARUCO_DB_SIZE > 290)
		{ { 157,82 }, { 225,108 }, { 74,185 }, { 54,135 }, },
	#endif
	#if (ARUCO_DB_SIZE > 291)
		{ { 149,218 }, { 225,107 }, { 91,169 }, { 214,135 }, },
	#endif
	#if (ARUCO_DB_SIZE > 292)
		{ { 160,197 }, { 24,58 }, { 163,5 }, { 92,24 }, },
	#endif
	#if (ARUCO_DB_SIZE > 293)
		{ { 170,205 }, { 28,63 }, { 179,85 }, { 252,56 }, },
	#endif
	#if (ARUCO_DB_SIZE > 294)
		{ { 162,216 }, { 44,43 }, { 27,69 }, { 212,52 }, },
	#endif
	#if (ARUCO_DB_SIZE > 295)
		{ { 162,87 }, { 61,56 }, { 234,69 }, { 28,188 }, },
	#endif
	#if (ARUCO_DB_SIZE > 296)
		{ { 169,61 }, { 122,29 }, { 188,149 }, { 184,94 }, },
	#endif
	#if (ARUCO_DB_SIZE > 297)
		{ { 169,87 }, { 121,60 }, { 234,149 }, { 60,158 }, },
	#endif
	#if (ARUCO_DB_SIZE > 298)
		{ { 171,82 }, { 109,44 }, { 74,213 }, { 52,182 }, },
	#endif
	#if (ARUCO_DB_SIZE > 299)
		{ { 163,54 }, { 111,24 }, { 108,197 }, { 24,246 }, },
	#endif
	#if (ARUCO_DB_SIZE > 300)
		{ { 163,89 }, { 124,41 }, { 154,197 }, { 148,62 }, },
	#endif
	#if (ARUCO_DB_SIZE > 301)
		{ { 176,244 }, { 170,58 }, { 47,13 }, { 92,85 }, },
	#endif
	#if (ARUCO_DB_SIZE > 302)
		{ { 184,18 }, { 169,12 }, { 72,29 }, { 48,149 }, },
	#endif
	#if (ARUCO_DB_SIZE > 303)
		{ { 176,191 }, { 187,27 }, { 253,13 }, { 216,221 }, },
	#endif
	#if (ARUCO_DB_SIZE > 304)
		{ { 178,157 }, { 188,27 }, { 185,77 }, { 216,61 }, },
	#endif
	#if (ARUCO_DB_SIZE > 305)
		{ { 187,237 }, { 222,63 }, { 183,221 }, { 252,123 }, },
	#endif
	#if (ARUCO_DB_SIZE > 306)
		{ { 185,114 }, { 235,44 }, { 78,157 }, { 52,215 }, },
	#endif
	#if (ARUCO_DB_SIZE > 307)
		{ { 185,150 }, { 233,30 }, { 105,157 }, { 120,151 }, },
	#endif
	#if (ARUCO_DB_SIZE > 308)
		{ { 164,195 }, { 25,106 }, { 195,37 }, { 86,152 }, },
	#endif
	#if (ARUCO_DB_SIZE > 309)
		{ { 172,210 }, { 41,110 }, { 75,53 }, { 118,148 }, },
	#endif
	#if (ARUCO_DB_SIZE > 310)
		{ { 174,177 }, { 62,78 }, { 141,117 }, { 114,124 }, },
	#endif
	#if (ARUCO_DB_SIZE > 311)
		{ { 165,130 }, { 73,74 }, { 65,165 }, { 82,146 }, },
	#endif
	#if (ARUCO_DB_SIZE > 312)
		{ { 175,101 }, { 94,124 }, { 166,245 }, { 62,122 }, },
	#endif
	#if (ARUCO_DB_SIZE > 313)
		{ { 165,123 }, { 123,105 }, { 222,165 }, { 150,222 }, },
	#endif
	#if (ARUCO_DB_SIZE > 314)
		{ { 175,250 }, { 111,111 }, { 95,245 }, { 246,246 }, },
	#endif
	#if (ARUCO_DB_SIZE > 315)
		{ { 180,100 }, { 138,120 }, { 38,45 }, { 30,81 }, },
	#endif
	#if (ARUCO_DB_SIZE > 316)
		{ { 188,98 }, { 139,108 }, { 70,61 }, { 54,209 }, },
	#endif
	#if (ARUCO_DB_SIZE > 317)
		{ { 180,129 }, { 152,74 }, { 129,45 }, { 82,25 }, },
	#endif
	#if (ARUCO_DB_SIZE > 318)
		{ { 182,160 }, { 142,74 }, { 5,109 }, { 82,113 }, },
	#endif
	#if (ARUCO_DB_SIZE > 319)
		{ { 190,238 }, { 143,127 }, { 119,125 }, { 254,241 }, },
	#endif
	#if (ARUCO_DB_SIZE > 320)
		{ { 190,13 }, { 156,93 }, { 176,125 }, { 186,57 }, },
	#endif
	#if (ARUCO_DB_SIZE > 321)
		{ { 188,217 }, { 184,111 }, { 155,61 }, { 246,29 }, },
	#endif
	#if (ARUCO_DB_SIZE > 322)
		{ { 190,248 }, { 174,111 }, { 31,125 }, { 246,117 }, },
	#endif
	#if (ARUCO_DB_SIZE > 323)
		{ { 181,40 }, { 202,73 }, { 20,173 }, { 146,83 }, },
	#endif
	#if (ARUCO_DB_SIZE > 324)
		{ { 183,9 }, { 220,73 }, { 144,237 }, { 146,59 }, },
	#endif
	#if (ARUCO_DB_SIZE > 325)
		{ { 183,210 }, { 237,106 }, { 75,237 }, { 86,183 }, },
	#endif
	#if (ARUCO_DB_SIZE > 326)
		{ { 192,234 }, { 3,171 }, { 87,3 }, { 213,192 }, },
	#endif
	#if (ARUCO_DB_SIZE > 327)
		{ { 192,25 }, { 48,137 }, { 152,3 }, { 145,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 328)
		{ { 192,253 }, { 50,187 }, { 191,3 }, { 221,76 }, },
	#endif
	#if (ARUCO_DB_SIZE > 329)
		{ { 200,211 }, { 49,174 }, { 203,19 }, { 117,140 }, },
	#endif
	#if (ARUCO_DB_SIZE > 330)
		{ { 202,90 }, { 37,173 }, { 90,83 }, { 181,164 }, },
	#endif
	#if (ARUCO_DB_SIZE > 331)
		{ { 193,77 }, { 80,185 }, { 178,131 }, { 157,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 332)
		{ { 201,180 }, { 98,158 }, { 45,147 }, { 121,70 }, },
	#endif
	#if (ARUCO_DB_SIZE > 333)
		{ { 193,87 }, { 113,184 }, { 234,131 }, { 29,142 }, },
	#endif
	#if (ARUCO_DB_SIZE > 334)
		{ { 195,152 }, { 100,139 }, { 25,195 }, { 209,38 }, },
	#endif
	#if (ARUCO_DB_SIZE > 335)
		{ { 195,29 }, { 116,153 }, { 184,195 }, { 153,46 }, },
	#endif
	#if (ARUCO_DB_SIZE > 336)
		{ { 216,128 }, { 128,142 }, { 1,27 }, { 113,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 337)
		{ { 216,239 }, { 147,191 }, { 247,27 }, { 253,201 }, },
	#endif
	#if (ARUCO_DB_SIZE > 338)
		{ { 218,43 }, { 151,141 }, { 212,91 }, { 177,233 }, },
	#endif
	#if (ARUCO_DB_SIZE > 339)
		{ { 208,30 }, { 161,153 }, { 120,11 }, { 153,133 }, },
	#endif
	#if (ARUCO_DB_SIZE > 340)
		{ { 209,5 }, { 208,152 }, { 160,139 }, { 25,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 341)
		{ { 211,173 }, { 214,155 }, { 181,203 }, { 217,107 }, },
	#endif
	#if (ARUCO_DB_SIZE > 342)
		{ { 219,167 }, { 215,158 }, { 229,219 }, { 121,235 }, },
	#endif
	#if (ARUCO_DB_SIZE > 343)
		{ { 196,201 }, { 16,235 }, { 147,35 }, { 215,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 344)
		{ { 204,120 }, { 34,237 }, { 30,51 }, { 183,68 }, },
	#endif
	#if (ARUCO_DB_SIZE > 345)
		{ { 205,69 }, { 80,252 }, { 162,179 }, { 63,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 346)
		{ { 197,11 }, { 81,201 }, { 208,163 }, { 147,138 }, },
	#endif
	#if (ARUCO_DB_SIZE > 347)
		{ { 207,207 }, { 85,255 }, { 243,243 }, { 255,170 }, },
	#endif
	#if (ARUCO_DB_SIZE > 348)
		{ { 220,172 }, { 130,223 }, { 53,59 }, { 251,65 }, },
	#endif
	#if (ARUCO_DB_SIZE > 349)
		{ { 212,2 }, { 129,200 }, { 64,43 }, { 19,129 }, },
	#endif
	#if (ARUCO_DB_SIZE > 350)
		{ { 220,99 }, { 147,236 }, { 198,59 }, { 55,201 }, },
	#endif
	#if (ARUCO_DB_SIZE > 351)
		{ { 212,39 }, { 147,216 }, { 228,43 }, { 27,201 }, },
	#endif
	#if (ARUCO_DB_SIZE > 352)
		{ { 212,245 }, { 178,250 }, { 175,43 }, { 95,77 }, },
	#endif
	#if (ARUCO_DB_SIZE > 353)
		{ { 214,120 }, { 166,233 }, { 30,107 }, { 151,101 }, },
	#endif
	#if (ARUCO_DB_SIZE > 354)
		{ { 222,184 }, { 166,207 }, { 29,123 }, { 243,101 }, },
	#endif
	#if (ARUCO_DB_SIZE > 355)
		{ { 221,230 }, { 195,254 }, { 103,187 }, { 127,195 }, },
	#endif
	#if (ARUCO_DB_SIZE > 356)
		{ { 213,93 }, { 240,249 }, { 186,171 }, { 159,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 357)
		{ { 221,189 }, { 242,223 }, { 189,187 }, { 251,79 }, },
	#endif
	#if (ARUCO_DB_SIZE > 358)
		{ { 223,29 }, { 244,221 }, { 184,251 }, { 187,47 }, },
	#endif
	#if (ARUCO_DB_SIZE > 359)
		{ { 226,202 }, { 13,171 }, { 83,71 }, { 213,176 }, },
	#endif
	#if (ARUCO_DB_SIZE > 360)
		{ { 234,107 }, { 31,173 }, { 214,87 }, { 181,248 }, },
	#endif
	#if (ARUCO_DB_SIZE > 361)
		{ { 224,180 }, { 42,154 }, { 45,7 }, { 89,84 }, },
	#endif
	#if (ARUCO_DB_SIZE > 362)
		{ { 226,56 }, { 46,137 }, { 28,71 }, { 145,116 }, },
	#endif
	#if (ARUCO_DB_SIZE > 363)
		{ { 226,212 }, { 44,186 }, { 43,71 }, { 93,52 }, },
	#endif
	#if (ARUCO_DB_SIZE > 364)
		{ { 227,34 }, { 79,136 }, { 68,199 }, { 17,242 }, },
	#endif
	#if (ARUCO_DB_SIZE > 365)
		{ { 225,216 }, { 104,171 }, { 27,135 }, { 213,22 }, },
	#endif
	#if (ARUCO_DB_SIZE > 366)
		{ { 240,3 }, { 153,136 }, { 192,15 }, { 17,153 }, },
	#endif
	#if (ARUCO_DB_SIZE > 367)
		{ { 242,204 }, { 140,187 }, { 51,79 }, { 221,49 }, },
	#endif
	#if (ARUCO_DB_SIZE > 368)
		{ { 248,246 }, { 171,190 }, { 111,31 }, { 125,213 }, },
	#endif
	#if (ARUCO_DB_SIZE > 369)
		{ { 241,73 }, { 216,169 }, { 146,143 }, { 149,27 }, },
	#endif
	#if (ARUCO_DB_SIZE > 370)
		{ { 243,234 }, { 207,171 }, { 87,207 }, { 213,243 }, },
	#endif
	#if (ARUCO_DB_SIZE > 371)
		{ { 241,156 }, { 232,155 }, { 57,143 }, { 217,23 }, },
	#endif
	#if (ARUCO_DB_SIZE > 372)
		{ { 249,245 }, { 250,190 }, { 175,159 }, { 125,95 }, },
	#endif
	#if (ARUCO_DB_SIZE > 373)
		{ { 241,59 }, { 251,137 }, { 220,143 }, { 145,223 }, },
	#endif
	#if (ARUCO_DB_SIZE > 374)
		{ { 236,141 }, { 24,223 }, { 177,55 }, { 251,24 }, },
	#endif
	#if (ARUCO_DB_SIZE > 375)
		{ { 238,201 }, { 28,239 }, { 147,119 }, { 247,56 }, },
	#endif
	#if (ARUCO_DB_SIZE > 376)
		{ { 230,15 }, { 29,217 }, { 240,103 }, { 155,184 }, },
	#endif
	#if (ARUCO_DB_SIZE > 377)
		{ { 228,247 }, { 59,250 }, { 239,39 }, { 95,220 }, },
	#endif
	#if (ARUCO_DB_SIZE > 378)
		{ { 231,96 }, { 78,232 }, { 6,231 }, { 23,114 }, },
	#endif
	#if (ARUCO_DB_SIZE > 379)
		{ { 239,232 }, { 78,239 }, { 23,247 }, { 247,114 }, },
	#endif
	#if (ARUCO_DB_SIZE > 380)
		{ { 237,178 }, { 107,206 }, { 77,183 }, { 115,214 }, },
	#endif
	#if (ARUCO_DB_SIZE > 381)
		{ { 229,21 }, { 120,216 }, { 168,167 }, { 27,30 }, },
	#endif
	#if (ARUCO_DB_SIZE > 382)
		{ { 239,209 }, { 124,238 }, { 139,247 }, { 119,62 }, },
	#endif
	#if (ARUCO_DB_SIZE > 383)
		{ { 244,134 }, { 137,218 }, { 97,47 }, { 91,145 }, },
	#endif
	#if (ARUCO_DB_SIZE > 384)
		{ { 252,1 }, { 152,204 }, { 128,63 }, { 51,25 }, },
	#endif
	#if (ARUCO_DB_SIZE > 385)
		{ { 246,195 }, { 157,234 }, { 195,111 }, { 87,185 }, },
	#endif
	#if (ARUCO_DB_SIZE > 386)
		{ { 244,124 }, { 170,249 }, { 62,47 }, { 159,85 }, },
	#endif
	#if (ARUCO_DB_SIZE > 387)
		{ { 252,147 }, { 185,206 }, { 201,63 }, { 115,157 }, },
	#endif
	#if (ARUCO_DB_SIZE > 388)
		{ { 245,66 }, { 201,232 }, { 66,175 }, { 23,147 }, },
	#endif
	#if (ARUCO_DB_SIZE > 389)
		{ { 253,152 }, { 232,207 }, { 25,191 }, { 243,23 }, },
	#endif
	#if (ARUCO_DB_SIZE > 390)
		{ { 245,61 }, { 250,217 }, { 188,175 }, { 155,95 }, },
	#endif
	#if (ARUCO_DB_SIZE > 391)
		{ { 2,189 }, { 54,19 }, { 189,64 }, { 200,108 }, },
	#endif
	#if (ARUCO_DB_SIZE > 392)
		{ { 0,225 }, { 18,34 }, { 135,0 }, { 68,72 }, },
	#endif
	#if (ARUCO_DB_SIZE > 393)
		{ { 2,226 }, { 7,34 }, { 71,64 }, { 68,224 }, },
	#endif
	#if (ARUCO_DB_SIZE > 394)
		{ { 2,174 }, { 7,19 }, { 117,64 }, { 200,224 }, },
	#endif
	#if (ARUCO_DB_SIZE > 395)
		{ { 8,120 }, { 34,37 }, { 30,16 }, { 164,68 }, },
	#endif
	#if (ARUCO_DB_SIZE > 396)
		{ { 0,116 }, { 34,48 }, { 46,0 }, { 12,68 }, },
	#endif
	#if (ARUCO_DB_SIZE > 397)
		{ { 8,158 }, { 33,23 }, { 121,16 }, { 232,132 }, },
	#endif
	#if (ARUCO_DB_SIZE > 398)
		{ { 8,209 }, { 48,38 }, { 139,16 }, { 100,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 399)
		{ { 8,125 }, { 50,53 }, { 190,16 }, { 172,76 }, },
	#endif
	#if (ARUCO_DB_SIZE > 400)
		{ { 10,50 }, { 39,4 }, { 76,80 }, { 32,228 }, },
	#endif
	#if (ARUCO_DB_SIZE > 401)
		{ { 10,222 }, { 37,55 }, { 123,80 }, { 236,164 }, },
	#endif
	#if (ARUCO_DB_SIZE > 402)
		{ { 2,81 }, { 52,32 }, { 138,64 }, { 4,44 }, },
	#endif
	#if (ARUCO_DB_SIZE > 403)
		{ { 1,162 }, { 67,2 }, { 69,128 }, { 64,194 }, },
	#endif
	#if (ARUCO_DB_SIZE > 404)
		{ { 3,128 }, { 68,2 }, { 1,192 }, { 64,34 }, },
	#endif
	#if (ARUCO_DB_SIZE > 405)
		{ { 11,131 }, { 85,6 }, { 193,208 }, { 96,170 }, },
	#endif
	#if (ARUCO_DB_SIZE > 406)
		{ { 11,75 }, { 85,37 }, { 210,208 }, { 164,170 }, },
	#endif
	#if (ARUCO_DB_SIZE > 407)
		{ { 11,39 }, { 87,20 }, { 228,208 }, { 40,234 }, },
	#endif
	#if (ARUCO_DB_SIZE > 408)
		{ { 11,239 }, { 87,55 }, { 247,208 }, { 236,234 }, },
	#endif
	#if (ARUCO_DB_SIZE > 409)
		{ { 9,182 }, { 99,22 }, { 109,144 }, { 104,198 }, },
	#endif
	#if (ARUCO_DB_SIZE > 410)
		{ { 9,89 }, { 112,37 }, { 154,144 }, { 164,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 411)
		{ { 9,147 }, { 113,6 }, { 201,144 }, { 96,142 }, },
	#endif
	#if (ARUCO_DB_SIZE > 412)
		{ { 11,248 }, { 102,39 }, { 31,208 }, { 228,102 }, },
	#endif
	#if (ARUCO_DB_SIZE > 413)
		{ { 3,217 }, { 116,35 }, { 155,192 }, { 196,46 }, },
	#endif
	#if (ARUCO_DB_SIZE > 414)
		{ { 3,241 }, { 118,34 }, { 143,192 }, { 68,110 }, },
	#endif
	#if (ARUCO_DB_SIZE > 415)
		{ { 16,196 }, { 128,50 }, { 35,8 }, { 76,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 416)
		{ { 24,171 }, { 147,7 }, { 213,24 }, { 224,201 }, },
	#endif
	#if (ARUCO_DB_SIZE > 417)
		{ { 26,160 }, { 134,6 }, { 5,88 }, { 96,97 }, },
	#endif
	#if (ARUCO_DB_SIZE > 418)
		{ { 26,4 }, { 132,20 }, { 32,88 }, { 40,33 }, },
	#endif
	#if (ARUCO_DB_SIZE > 419)
		{ { 26,108 }, { 134,53 }, { 54,88 }, { 172,97 }, },
	#endif
	#if (ARUCO_DB_SIZE > 420)
		{ { 26,174 }, { 135,23 }, { 117,88 }, { 232,225 }, },
	#endif
	#if (ARUCO_DB_SIZE > 421)
		{ { 18,137 }, { 148,3 }, { 145,72 }, { 192,41 }, },
	#endif
	#if (ARUCO_DB_SIZE > 422)
		{ { 16,23 }, { 177,16 }, { 232,8 }, { 8,141 }, },
	#endif
	#if (ARUCO_DB_SIZE > 423)
		{ { 26,243 }, { 183,38 }, { 207,88 }, { 100,237 }, },
	#endif
	#if (ARUCO_DB_SIZE > 424)
		{ { 25,64 }, { 192,36 }, { 2,152 }, { 36,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 425)
		{ { 17,2 }, { 193,0 }, { 64,136 }, { 0,131 }, },
	#endif
	#if (ARUCO_DB_SIZE > 426)
		{ { 17,43 }, { 211,1 }, { 212,136 }, { 128,203 }, },
	#endif
	#if (ARUCO_DB_SIZE > 427)
		{ { 17,207 }, { 209,51 }, { 243,136 }, { 204,139 }, },
	#endif
	#if (ARUCO_DB_SIZE > 428)
		{ { 27,34 }, { 199,4 }, { 68,216 }, { 32,227 }, },
	#endif
	#if (ARUCO_DB_SIZE > 429)
		{ { 19,46 }, { 199,17 }, { 116,200 }, { 136,227 }, },
	#endif
	#if (ARUCO_DB_SIZE > 430)
		{ { 17,21 }, { 240,16 }, { 168,136 }, { 8,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 431)
		{ { 19,187 }, { 247,3 }, { 221,200 }, { 192,239 }, },
	#endif
	#if (ARUCO_DB_SIZE > 432)
		{ { 12,32 }, { 2,68 }, { 4,48 }, { 34,64 }, },
	#endif
	#if (ARUCO_DB_SIZE > 433)
		{ { 12,201 }, { 16,103 }, { 147,48 }, { 230,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 434)
		{ { 12,220 }, { 32,119 }, { 59,48 }, { 238,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 435)
		{ { 12,54 }, { 35,84 }, { 108,48 }, { 42,196 }, },
	#endif
	#if (ARUCO_DB_SIZE > 436)
		{ { 6,20 }, { 36,80 }, { 40,96 }, { 10,36 }, },
	#endif
	#if (ARUCO_DB_SIZE > 437)
		{ { 6,114 }, { 39,96 }, { 78,96 }, { 6,228 }, },
	#endif
	#if (ARUCO_DB_SIZE > 438)
		{ { 13,97 }, { 82,100 }, { 134,176 }, { 38,74 }, },
	#endif
	#if (ARUCO_DB_SIZE > 439)
		{ { 5,13 }, { 80,81 }, { 176,160 }, { 138,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 440)
		{ { 13,143 }, { 81,87 }, { 241,176 }, { 234,138 }, },
	#endif
	#if (ARUCO_DB_SIZE > 441)
		{ { 15,224 }, { 70,102 }, { 7,240 }, { 102,98 }, },
	#endif
	#if (ARUCO_DB_SIZE > 442)
		{ { 15,73 }, { 84,101 }, { 146,240 }, { 166,42 }, },
	#endif
	#if (ARUCO_DB_SIZE > 443)
		{ { 7,133 }, { 84,82 }, { 161,224 }, { 74,42 }, },
	#endif
	#if (ARUCO_DB_SIZE > 444)
		{ { 5,144 }, { 96,66 }, { 9,160 }, { 66,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 445)
		{ { 13,51 }, { 115,68 }, { 204,176 }, { 34,206 }, },
	#endif
	#if (ARUCO_DB_SIZE > 446)
		{ { 15,150 }, { 101,86 }, { 105,240 }, { 106,166 }, },
	#endif
	#if (ARUCO_DB_SIZE > 447)
		{ { 15,118 }, { 103,116 }, { 110,240 }, { 46,230 }, },
	#endif
	#if (ARUCO_DB_SIZE > 448)
		{ { 20,96 }, { 130,96 }, { 6,40 }, { 6,65 }, },
	#endif
	#if (ARUCO_DB_SIZE > 449)
		{ { 28,141 }, { 144,87 }, { 177,56 }, { 234,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 450)
		{ { 20,218 }, { 161,99 }, { 91,40 }, { 198,133 }, },
	#endif
	#if (ARUCO_DB_SIZE > 451)
		{ { 28,115 }, { 179,100 }, { 206,56 }, { 38,205 }, },
	#endif
	#if (ARUCO_DB_SIZE > 452)
		{ { 30,148 }, { 164,86 }, { 41,120 }, { 106,37 }, },
	#endif
	#if (ARUCO_DB_SIZE > 453)
		{ { 30,186 }, { 167,71 }, { 93,120 }, { 226,229 }, },
	#endif
	#if (ARUCO_DB_SIZE > 454)
		{ { 22,217 }, { 180,99 }, { 155,104 }, { 198,45 }, },
	#endif
	#if (ARUCO_DB_SIZE > 455)
		{ { 30,61 }, { 182,85 }, { 188,120 }, { 170,109 }, },
	#endif
	#if (ARUCO_DB_SIZE > 456)
		{ { 22,251 }, { 183,99 }, { 223,104 }, { 198,237 }, },
	#endif
	#if (ARUCO_DB_SIZE > 457)
		{ { 29,233 }, { 210,103 }, { 151,184 }, { 230,75 }, },
	#endif
	#if (ARUCO_DB_SIZE > 458)
		{ { 29,254 }, { 227,119 }, { 127,184 }, { 238,199 }, },
	#endif
	#if (ARUCO_DB_SIZE > 459)
		{ { 31,159 }, { 245,87 }, { 249,248 }, { 234,175 }, },
	#endif
	#if (ARUCO_DB_SIZE > 460)
		{ { 40,139 }, { 25,7 }, { 209,20 }, { 224,152 }, },
	#endif
	#if (ARUCO_DB_SIZE > 461)
		{ { 32,175 }, { 27,19 }, { 245,4 }, { 200,216 }, },
	#endif
	#if (ARUCO_DB_SIZE > 462)
		{ { 34,14 }, { 13,17 }, { 112,68 }, { 136,176 }, },
	#endif
	#if (ARUCO_DB_SIZE > 463)
		{ { 34,169 }, { 30,3 }, { 149,68 }, { 192,120 }, },
	#endif
	#if (ARUCO_DB_SIZE > 464)
		{ { 42,141 }, { 28,23 }, { 177,84 }, { 232,56 }, },
	#endif
	#if (ARUCO_DB_SIZE > 465)
		{ { 42,163 }, { 31,6 }, { 197,84 }, { 96,248 }, },
	#endif
	#if (ARUCO_DB_SIZE > 466)
		{ { 42,239 }, { 31,55 }, { 247,84 }, { 236,248 }, },
	#endif
	#if (ARUCO_DB_SIZE > 467)
		{ { 40,144 }, { 40,6 }, { 9,20 }, { 96,20 }, },
	#endif
	#if (ARUCO_DB_SIZE > 468)
		{ { 40,59 }, { 59,5 }, { 220,20 }, { 160,220 }, },
	#endif
	#if (ARUCO_DB_SIZE > 469)
		{ { 42,88 }, { 44,37 }, { 26,84 }, { 164,52 }, },
	#endif
	#if (ARUCO_DB_SIZE > 470)
		{ { 34,51 }, { 63,0 }, { 204,68 }, { 0,252 }, },
	#endif
	#if (ARUCO_DB_SIZE > 471)
		{ { 33,160 }, { 74,2 }, { 5,132 }, { 64,82 }, },
	#endif
	#if (ARUCO_DB_SIZE > 472)
		{ { 33,2 }, { 73,0 }, { 64,132 }, { 0,146 }, },
	#endif
	#if (ARUCO_DB_SIZE > 473)
		{ { 33,165 }, { 90,18 }, { 165,132 }, { 72,90 }, },
	#endif
	#if (ARUCO_DB_SIZE > 474)
		{ { 33,199 }, { 89,50 }, { 227,132 }, { 76,154 }, },
	#endif
	#if (ARUCO_DB_SIZE > 475)
		{ { 43,3 }, { 93,4 }, { 192,212 }, { 32,186 }, },
	#endif
	#if (ARUCO_DB_SIZE > 476)
		{ { 35,103 }, { 95,48 }, { 230,196 }, { 12,250 }, },
	#endif
	#if (ARUCO_DB_SIZE > 477)
		{ { 41,48 }, { 106,4 }, { 12,148 }, { 32,86 }, },
	#endif
	#if (ARUCO_DB_SIZE > 478)
		{ { 41,210 }, { 105,38 }, { 75,148 }, { 100,150 }, },
	#endif
	#if (ARUCO_DB_SIZE > 479)
		{ { 43,25 }, { 124,5 }, { 152,212 }, { 160,62 }, },
	#endif
	#if (ARUCO_DB_SIZE > 480)
		{ { 43,155 }, { 125,7 }, { 217,212 }, { 224,190 }, },
	#endif
	#if (ARUCO_DB_SIZE > 481)
		{ { 43,151 }, { 125,22 }, { 233,212 }, { 104,190 }, },
	#endif
	#if (ARUCO_DB_SIZE > 482)
		{ { 56,40 }, { 138,5 }, { 20,28 }, { 160,81 }, },
	#endif
	#if (ARUCO_DB_SIZE > 483)
		{ { 56,165 }, { 154,22 }, { 165,28 }, { 104,89 }, },
	#endif
	#if (ARUCO_DB_SIZE > 484)
		{ { 58,134 }, { 141,22 }, { 97,92 }, { 104,177 }, },
	#endif
	#if (ARUCO_DB_SIZE > 485)
		{ { 50,1 }, { 156,0 }, { 128,76 }, { 0,57 }, },
	#endif
	#if (ARUCO_DB_SIZE > 486)
		{ { 56,159 }, { 185,23 }, { 249,28 }, { 232,157 }, },
	#endif
	#if (ARUCO_DB_SIZE > 487)
		{ { 50,210 }, { 173,34 }, { 75,76 }, { 68,181 }, },
	#endif
	#if (ARUCO_DB_SIZE > 488)
		{ { 58,153 }, { 188,7 }, { 153,92 }, { 224,61 }, },
	#endif
	#if (ARUCO_DB_SIZE > 489)
		{ { 58,213 }, { 188,54 }, { 171,92 }, { 108,61 }, },
	#endif
	#if (ARUCO_DB_SIZE > 490)
		{ { 57,232 }, { 202,39 }, { 23,156 }, { 228,83 }, },
	#endif
	#if (ARUCO_DB_SIZE > 491)
		{ { 59,193 }, { 220,38 }, { 131,220 }, { 100,59 }, },
	#endif
	#if (ARUCO_DB_SIZE > 492)
		{ { 51,67 }, { 221,32 }, { 194,204 }, { 4,187 }, },
	#endif
	#if (ARUCO_DB_SIZE > 493)
		{ { 59,231 }, { 223,54 }, { 231,220 }, { 108,251 }, },
	#endif
	#if (ARUCO_DB_SIZE > 494)
		{ { 49,154 }, { 233,3 }, { 89,140 }, { 192,151 }, },
	#endif
	#if (ARUCO_DB_SIZE > 495)
		{ { 51,144 }, { 236,2 }, { 9,204 }, { 64,55 }, },
	#endif
	#if (ARUCO_DB_SIZE > 496)
		{ { 59,158 }, { 237,23 }, { 121,220 }, { 232,183 }, },
	#endif
	#if (ARUCO_DB_SIZE > 497)
		{ { 36,196 }, { 8,114 }, { 35,36 }, { 78,16 }, },
	#endif
	#if (ARUCO_DB_SIZE > 498)
		{ { 44,74 }, { 9,101 }, { 82,52 }, { 166,144 }, },
	#endif
	#if (ARUCO_DB_SIZE > 499)
		{ { 44,173 }, { 26,87 }, { 181,52 }, { 234,88 }, },
	#endif
	#if (ARUCO_DB_SIZE > 500)
		{ { 44,207 }, { 25,119 }, { 243,52 }, { 238,152 }, },
	#endif
	#if (ARUCO_DB_SIZE > 501)
		{ { 44,103 }, { 27,116 }, { 230,52 }, { 46,216 }, },
	#endif
	#if (ARUCO_DB_SIZE > 502)
		{ { 38,234 }, { 15,99 }, { 87,100 }, { 198,240 }, },
	#endif
	#if (ARUCO_DB_SIZE > 503)
		{ { 46,229 }, { 30,118 }, { 167,116 }, { 110,120 }, },
	#endif
	#if (ARUCO_DB_SIZE > 504)
		{ { 44,112 }, { 42,100 }, { 14,52 }, { 38,84 }, },
	#endif
	#if (ARUCO_DB_SIZE > 505)
		{ { 46,18 }, { 45,68 }, { 72,116 }, { 34,180 }, },
	#endif
	#if (ARUCO_DB_SIZE > 506)
		{ { 46,209 }, { 60,102 }, { 139,116 }, { 102,60 }, },
	#endif
	#if (ARUCO_DB_SIZE > 507)
		{ { 46,57 }, { 62,69 }, { 156,116 }, { 162,124 }, },
	#endif
	#if (ARUCO_DB_SIZE > 508)
		{ { 37,100 }, { 74,112 }, { 38,164 }, { 14,82 }, },
	#endif
	#if (ARUCO_DB_SIZE > 509)
		{ { 37,231 }, { 91,114 }, { 231,164 }, { 78,218 }, },
	#endif
	#if (ARUCO_DB_SIZE > 510)
		{ { 47,204 }, { 76,119 }, { 51,244 }, { 238,50 }, },
	#endif
	#if (ARUCO_DB_SIZE > 511)
		{ { 45,188 }, { 106,87 }, { 61,180 }, { 234,86 }, },
	#endif
	#if (ARUCO_DB_SIZE > 512)
		{ { 45,113 }, { 122,100 }, { 142,180 }, { 38,94 }, },
	#endif
	#if (ARUCO_DB_SIZE > 513)
		{ { 37,213 }, { 120,114 }, { 171,164 }, { 78,30 }, },
	#endif
	#if (ARUCO_DB_SIZE > 514)
		{ { 37,155 }, { 121,67 }, { 217,164 }, { 194,158 }, },
	#endif
	#if (ARUCO_DB_SIZE > 515)
		{ { 39,16 }, { 108,64 }, { 8,228 }, { 2,54 }, },
	#endif
	#if (ARUCO_DB_SIZE > 516)
		{ { 47,124 }, { 110,117 }, { 62,244 }, { 174,118 }, },
	#endif
	#if (ARUCO_DB_SIZE > 517)
		{ { 39,242 }, { 111,98 }, { 79,228 }, { 70,246 }, },
	#endif
	#if (ARUCO_DB_SIZE > 518)
		{ { 39,58 }, { 111,65 }, { 92,228 }, { 130,246 }, },
	#endif
	#if (ARUCO_DB_SIZE > 519)
		{ { 47,182 }, { 111,86 }, { 109,244 }, { 106,246 }, },
	#endif
	#if (ARUCO_DB_SIZE > 520)
		{ { 39,211 }, { 125,98 }, { 203,228 }, { 70,190 }, },
	#endif
	#if (ARUCO_DB_SIZE > 521)
		{ { 47,179 }, { 127,70 }, { 205,244 }, { 98,254 }, },
	#endif
	#if (ARUCO_DB_SIZE > 522)
		{ { 39,31 }, { 125,81 }, { 248,228 }, { 138,190 }, },
	#endif
	#if (ARUCO_DB_SIZE > 523)
		{ { 60,75 }, { 153,101 }, { 210,60 }, { 166,153 }, },
	#endif
	#if (ARUCO_DB_SIZE > 524)
		{ { 54,192 }, { 140,98 }, { 3,108 }, { 70,49 }, },
	#endif
	#if (ARUCO_DB_SIZE > 525)
		{ { 54,238 }, { 143,115 }, { 119,108 }, { 206,241 }, },
	#endif
	#if (ARUCO_DB_SIZE > 526)
		{ { 62,233 }, { 158,103 }, { 151,124 }, { 230,121 }, },
	#endif
	#if (ARUCO_DB_SIZE > 527)
		{ { 52,184 }, { 170,67 }, { 29,44 }, { 194,85 }, },
	#endif
	#if (ARUCO_DB_SIZE > 528)
		{ { 60,20 }, { 168,84 }, { 40,60 }, { 42,21 }, },
	#endif
	#if (ARUCO_DB_SIZE > 529)
		{ { 60,82 }, { 169,100 }, { 74,60 }, { 38,149 }, },
	#endif
	#if (ARUCO_DB_SIZE > 530)
		{ { 52,114 }, { 171,96 }, { 78,44 }, { 6,213 }, },
	#endif
	#if (ARUCO_DB_SIZE > 531)
		{ { 52,126 }, { 171,113 }, { 126,44 }, { 142,213 }, },
	#endif
	#if (ARUCO_DB_SIZE > 532)
		{ { 52,191 }, { 187,83 }, { 253,44 }, { 202,221 }, },
	#endif
	#if (ARUCO_DB_SIZE > 533)
		{ { 62,113 }, { 190,100 }, { 142,124 }, { 38,125 }, },
	#endif
	#if (ARUCO_DB_SIZE > 534)
		{ { 62,83 }, { 189,100 }, { 202,124 }, { 38,189 }, },
	#endif
	#if (ARUCO_DB_SIZE > 535)
		{ { 61,140 }, { 200,87 }, { 49,188 }, { 234,19 }, },
	#endif
	#if (ARUCO_DB_SIZE > 536)
		{ { 53,162 }, { 203,66 }, { 69,172 }, { 66,211 }, },
	#endif
	#if (ARUCO_DB_SIZE > 537)
		{ { 53,46 }, { 203,81 }, { 116,172 }, { 138,211 }, },
	#endif
	#if (ARUCO_DB_SIZE > 538)
		{ { 53,45 }, { 218,81 }, { 180,172 }, { 138,91 }, },
	#endif
	#if (ARUCO_DB_SIZE > 539)
		{ { 55,172 }, { 206,83 }, { 53,236 }, { 202,115 }, },
	#endif
	#if (ARUCO_DB_SIZE > 540)
		{ { 53,112 }, { 234,96 }, { 14,172 }, { 6,87 }, },
	#endif
	#if (ARUCO_DB_SIZE > 541)
		{ { 55,250 }, { 239,99 }, { 95,236 }, { 198,247 }, },
	#endif
	#if (ARUCO_DB_SIZE > 542)
		{ { 63,241 }, { 254,102 }, { 143,252 }, { 102,127 }, },
	#endif
	#if (ARUCO_DB_SIZE > 543)
		{ { 63,219 }, { 253,103 }, { 219,252 }, { 230,191 }, },
	#endif
	#if (ARUCO_DB_SIZE > 544)
		{ { 72,196 }, { 0,182 }, { 35,18 }, { 109,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 545)
		{ { 72,233 }, { 18,167 }, { 151,18 }, { 229,72 }, },
	#endif
	#if (ARUCO_DB_SIZE > 546)
		{ { 74,194 }, { 5,166 }, { 67,82 }, { 101,160 }, },
	#endif
	#if (ARUCO_DB_SIZE > 547)
		{ { 74,65 }, { 20,164 }, { 130,82 }, { 37,40 }, },
	#endif
	#if (ARUCO_DB_SIZE > 548)
		{ { 66,235 }, { 23,163 }, { 215,66 }, { 197,232 }, },
	#endif
	#if (ARUCO_DB_SIZE > 549)
		{ { 72,19 }, { 49,132 }, { 200,18 }, { 33,140 }, },
	#endif
	#if (ARUCO_DB_SIZE > 550)
		{ { 74,216 }, { 36,167 }, { 27,82 }, { 229,36 }, },
	#endif
	#if (ARUCO_DB_SIZE > 551)
		{ { 66,253 }, { 54,179 }, { 191,66 }, { 205,108 }, },
	#endif
	#if (ARUCO_DB_SIZE > 552)
		{ { 74,23 }, { 53,148 }, { 232,82 }, { 41,172 }, },
	#endif
	#if (ARUCO_DB_SIZE > 553)
		{ { 73,99 }, { 83,164 }, { 198,146 }, { 37,202 }, },
	#endif
	#if (ARUCO_DB_SIZE > 554)
		{ { 67,110 }, { 71,177 }, { 118,194 }, { 141,226 }, },
	#endif
	#if (ARUCO_DB_SIZE > 555)
		{ { 65,58 }, { 99,129 }, { 92,130 }, { 129,198 }, },
	#endif
	#if (ARUCO_DB_SIZE > 556)
		{ { 73,177 }, { 114,134 }, { 141,146 }, { 97,78 }, },
	#endif
	#if (ARUCO_DB_SIZE > 557)
		{ { 65,61 }, { 114,145 }, { 188,130 }, { 137,78 }, },
	#endif
	#if (ARUCO_DB_SIZE > 558)
		{ { 75,146 }, { 101,134 }, { 73,210 }, { 97,166 }, },
	#endif
	#if (ARUCO_DB_SIZE > 559)
		{ { 75,155 }, { 117,135 }, { 217,210 }, { 225,174 }, },
	#endif
	#if (ARUCO_DB_SIZE > 560)
		{ { 67,63 }, { 119,145 }, { 252,194 }, { 137,238 }, },
	#endif
	#if (ARUCO_DB_SIZE > 561)
		{ { 88,34 }, { 131,132 }, { 68,26 }, { 33,193 }, },
	#endif
	#if (ARUCO_DB_SIZE > 562)
		{ { 80,170 }, { 131,131 }, { 85,10 }, { 193,193 }, },
	#endif
	#if (ARUCO_DB_SIZE > 563)
		{ { 88,39 }, { 147,148 }, { 228,26 }, { 41,201 }, },
	#endif
	#if (ARUCO_DB_SIZE > 564)
		{ { 82,200 }, { 132,163 }, { 19,74 }, { 197,33 }, },
	#endif
	#if (ARUCO_DB_SIZE > 565)
		{ { 82,132 }, { 132,146 }, { 33,74 }, { 73,33 }, },
	#endif
	#if (ARUCO_DB_SIZE > 566)
		{ { 82,10 }, { 133,129 }, { 80,74 }, { 129,161 }, },
	#endif
	#if (ARUCO_DB_SIZE > 567)
		{ { 90,15 }, { 149,149 }, { 240,90 }, { 169,169 }, },
	#endif
	#if (ARUCO_DB_SIZE > 568)
		{ { 88,152 }, { 160,135 }, { 25,26 }, { 225,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 569)
		{ { 88,92 }, { 160,181 }, { 58,26 }, { 173,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 570)
		{ { 80,219 }, { 177,163 }, { 219,10 }, { 197,141 }, },
	#endif
	#if (ARUCO_DB_SIZE > 571)
		{ { 80,247 }, { 179,178 }, { 239,10 }, { 77,205 }, },
	#endif
	#if (ARUCO_DB_SIZE > 572)
		{ { 90,244 }, { 166,182 }, { 47,90 }, { 109,101 }, },
	#endif
	#if (ARUCO_DB_SIZE > 573)
		{ { 81,236 }, { 194,179 }, { 55,138 }, { 205,67 }, },
	#endif
	#if (ARUCO_DB_SIZE > 574)
		{ { 81,66 }, { 193,160 }, { 66,138 }, { 5,131 }, },
	#endif
	#if (ARUCO_DB_SIZE > 575)
		{ { 81,13 }, { 208,145 }, { 176,138 }, { 137,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 576)
		{ { 91,3 }, { 213,132 }, { 192,218 }, { 33,171 }, },
	#endif
	#if (ARUCO_DB_SIZE > 577)
		{ { 83,235 }, { 215,163 }, { 215,202 }, { 197,235 }, },
	#endif
	#if (ARUCO_DB_SIZE > 578)
		{ { 81,118 }, { 227,176 }, { 110,138 }, { 13,199 }, },
	#endif
	#if (ARUCO_DB_SIZE > 579)
		{ { 89,113 }, { 242,164 }, { 142,154 }, { 37,79 }, },
	#endif
	#if (ARUCO_DB_SIZE > 580)
		{ { 81,147 }, { 241,130 }, { 201,138 }, { 65,143 }, },
	#endif
	#if (ARUCO_DB_SIZE > 581)
		{ { 83,249 }, { 246,163 }, { 159,202 }, { 197,111 }, },
	#endif
	#if (ARUCO_DB_SIZE > 582)
		{ { 91,179 }, { 247,134 }, { 205,218 }, { 97,239 }, },
	#endif
	#if (ARUCO_DB_SIZE > 583)
		{ { 83,151 }, { 245,146 }, { 233,202 }, { 73,175 }, },
	#endif
	#if (ARUCO_DB_SIZE > 584)
		{ { 76,76 }, { 0,245 }, { 50,50 }, { 175,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 585)
		{ { 68,75 }, { 17,225 }, { 210,34 }, { 135,136 }, },
	#endif
	#if (ARUCO_DB_SIZE > 586)
		{ { 76,35 }, { 19,196 }, { 196,50 }, { 35,200 }, },
	#endif
	#if (ARUCO_DB_SIZE > 587)
		{ { 70,140 }, { 4,211 }, { 49,98 }, { 203,32 }, },
	#endif
	#if (ARUCO_DB_SIZE > 588)
		{ { 78,39 }, { 23,212 }, { 228,114 }, { 43,232 }, },
	#endif
	#if (ARUCO_DB_SIZE > 589)
		{ { 70,144 }, { 36,194 }, { 9,98 }, { 67,36 }, },
	#endif
	#if (ARUCO_DB_SIZE > 590)
		{ { 78,212 }, { 36,246 }, { 43,114 }, { 111,36 }, },
	#endif
	#if (ARUCO_DB_SIZE > 591)
		{ { 69,206 }, { 65,243 }, { 115,162 }, { 207,130 }, },
	#endif
	#if (ARUCO_DB_SIZE > 592)
		{ { 69,229 }, { 82,242 }, { 167,162 }, { 79,74 }, },
	#endif
	#if (ARUCO_DB_SIZE > 593)
		{ { 69,39 }, { 83,208 }, { 228,162 }, { 11,202 }, },
	#endif
	#if (ARUCO_DB_SIZE > 594)
		{ { 79,193 }, { 84,230 }, { 131,242 }, { 103,42 }, },
	#endif
	#if (ARUCO_DB_SIZE > 595)
		{ { 71,5 }, { 84,208 }, { 160,226 }, { 11,42 }, },
	#endif
	#if (ARUCO_DB_SIZE > 596)
		{ { 69,52 }, { 98,208 }, { 44,162 }, { 11,70 }, },
	#endif
	#if (ARUCO_DB_SIZE > 597)
		{ { 69,114 }, { 99,224 }, { 78,162 }, { 7,198 }, },
	#endif
	#if (ARUCO_DB_SIZE > 598)
		{ { 92,200 }, { 128,231 }, { 19,58 }, { 231,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 599)
		{ { 92,14 }, { 129,213 }, { 112,58 }, { 171,129 }, },
	#endif
	#if (ARUCO_DB_SIZE > 600)
		{ { 84,235 }, { 147,227 }, { 215,42 }, { 199,201 }, },
	#endif
	#if (ARUCO_DB_SIZE > 601)
		{ { 86,137 }, { 148,195 }, { 145,106 }, { 195,41 }, },
	#endif
	#if (ARUCO_DB_SIZE > 602)
		{ { 86,67 }, { 149,224 }, { 194,106 }, { 7,169 }, },
	#endif
	#if (ARUCO_DB_SIZE > 603)
		{ { 94,231 }, { 151,246 }, { 231,122 }, { 111,233 }, },
	#endif
	#if (ARUCO_DB_SIZE > 604)
		{ { 92,112 }, { 162,228 }, { 14,58 }, { 39,69 }, },
	#endif
	#if (ARUCO_DB_SIZE > 605)
		{ { 84,178 }, { 163,194 }, { 77,42 }, { 67,197 }, },
	#endif
	#if (ARUCO_DB_SIZE > 606)
		{ { 94,121 }, { 182,229 }, { 158,122 }, { 167,109 }, },
	#endif
	#if (ARUCO_DB_SIZE > 607)
		{ { 86,243 }, { 183,226 }, { 207,106 }, { 71,237 }, },
	#endif
	#if (ARUCO_DB_SIZE > 608)
		{ { 93,163 }, { 211,198 }, { 197,186 }, { 99,203 }, },
	#endif
	#if (ARUCO_DB_SIZE > 609)
		{ { 93,242 }, { 227,230 }, { 79,186 }, { 103,199 }, },
	#endif
	#if (ARUCO_DB_SIZE > 610)
		{ { 85,29 }, { 240,209 }, { 184,170 }, { 139,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 611)
		{ { 93,157 }, { 240,215 }, { 185,186 }, { 235,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 612)
		{ { 87,252 }, { 230,243 }, { 63,234 }, { 207,103 }, },
	#endif
	#if (ARUCO_DB_SIZE > 613)
		{ { 87,210 }, { 229,226 }, { 75,234 }, { 71,167 }, },
	#endif
	#if (ARUCO_DB_SIZE > 614)
		{ { 95,115 }, { 247,228 }, { 206,250 }, { 39,239 }, },
	#endif
	#if (ARUCO_DB_SIZE > 615)
		{ { 104,45 }, { 26,149 }, { 180,22 }, { 169,88 }, },
	#endif
	#if (ARUCO_DB_SIZE > 616)
		{ { 104,195 }, { 25,166 }, { 195,22 }, { 101,152 }, },
	#endif
	#if (ARUCO_DB_SIZE > 617)
		{ { 104,135 }, { 25,150 }, { 225,22 }, { 105,152 }, },
	#endif
	#if (ARUCO_DB_SIZE > 618)
		{ { 106,74 }, { 13,165 }, { 82,86 }, { 165,176 }, },
	#endif
	#if (ARUCO_DB_SIZE > 619)
		{ { 98,105 }, { 30,161 }, { 150,70 }, { 133,120 }, },
	#endif
	#if (ARUCO_DB_SIZE > 620)
		{ { 96,185 }, { 58,131 }, { 157,6 }, { 193,92 }, },
	#endif
	#if (ARUCO_DB_SIZE > 621)
		{ { 104,255 }, { 59,183 }, { 255,22 }, { 237,220 }, },
	#endif
	#if (ARUCO_DB_SIZE > 622)
		{ { 106,220 }, { 44,183 }, { 59,86 }, { 237,52 }, },
	#endif
	#if (ARUCO_DB_SIZE > 623)
		{ { 106,218 }, { 45,167 }, { 91,86 }, { 229,180 }, },
	#endif
	#if (ARUCO_DB_SIZE > 624)
		{ { 106,62 }, { 47,149 }, { 124,86 }, { 169,244 }, },
	#endif
	#if (ARUCO_DB_SIZE > 625)
		{ { 106,81 }, { 60,164 }, { 138,86 }, { 37,60 }, },
	#endif
	#if (ARUCO_DB_SIZE > 626)
		{ { 106,49 }, { 62,132 }, { 140,86 }, { 33,124 }, },
	#endif
	#if (ARUCO_DB_SIZE > 627)
		{ { 98,215 }, { 61,178 }, { 235,70 }, { 77,188 }, },
	#endif
	#if (ARUCO_DB_SIZE > 628)
		{ { 97,204 }, { 72,179 }, { 51,134 }, { 205,18 }, },
	#endif
	#if (ARUCO_DB_SIZE > 629)
		{ { 107,130 }, { 77,134 }, { 65,214 }, { 97,178 }, },
	#endif
	#if (ARUCO_DB_SIZE > 630)
		{ { 107,227 }, { 95,166 }, { 199,214 }, { 101,250 }, },
	#endif
	#if (ARUCO_DB_SIZE > 631)
		{ { 105,58 }, { 107,133 }, { 92,150 }, { 161,214 }, },
	#endif
	#if (ARUCO_DB_SIZE > 632)
		{ { 97,158 }, { 105,147 }, { 121,134 }, { 201,150 }, },
	#endif
	#if (ARUCO_DB_SIZE > 633)
		{ { 97,149 }, { 120,146 }, { 169,134 }, { 73,30 }, },
	#endif
	#if (ARUCO_DB_SIZE > 634)
		{ { 97,117 }, { 122,176 }, { 174,134 }, { 13,94 }, },
	#endif
	#if (ARUCO_DB_SIZE > 635)
		{ { 105,95 }, { 121,181 }, { 250,150 }, { 173,158 }, },
	#endif
	#if (ARUCO_DB_SIZE > 636)
		{ { 105,55 }, { 123,148 }, { 236,150 }, { 41,222 }, },
	#endif
	#if (ARUCO_DB_SIZE > 637)
		{ { 99,218 }, { 109,163 }, { 91,198 }, { 197,182 }, },
	#endif
	#if (ARUCO_DB_SIZE > 638)
		{ { 112,2 }, { 137,128 }, { 64,14 }, { 1,145 }, },
	#endif
	#if (ARUCO_DB_SIZE > 639)
		{ { 120,99 }, { 155,164 }, { 198,30 }, { 37,217 }, },
	#endif
	#if (ARUCO_DB_SIZE > 640)
		{ { 112,79 }, { 153,177 }, { 242,14 }, { 141,153 }, },
	#endif
	#if (ARUCO_DB_SIZE > 641)
		{ { 114,202 }, { 141,163 }, { 83,78 }, { 197,177 }, },
	#endif
	#if (ARUCO_DB_SIZE > 642)
		{ { 122,173 }, { 158,151 }, { 181,94 }, { 233,121 }, },
	#endif
	#if (ARUCO_DB_SIZE > 643)
		{ { 112,123 }, { 187,161 }, { 222,14 }, { 133,221 }, },
	#endif
	#if (ARUCO_DB_SIZE > 644)
		{ { 122,20 }, { 172,148 }, { 40,94 }, { 41,53 }, },
	#endif
	#if (ARUCO_DB_SIZE > 645)
		{ { 122,249 }, { 190,167 }, { 159,94 }, { 229,125 }, },
	#endif
	#if (ARUCO_DB_SIZE > 646)
		{ { 122,211 }, { 189,166 }, { 203,94 }, { 101,189 }, },
	#endif
	#if (ARUCO_DB_SIZE > 647)
		{ { 122,187 }, { 191,135 }, { 221,94 }, { 225,253 }, },
	#endif
	#if (ARUCO_DB_SIZE > 648)
		{ { 121,226 }, { 203,166 }, { 71,158 }, { 101,211 }, },
	#endif
	#if (ARUCO_DB_SIZE > 649)
		{ { 113,41 }, { 218,129 }, { 148,142 }, { 129,91 }, },
	#endif
	#if (ARUCO_DB_SIZE > 650)
		{ { 123,103 }, { 223,180 }, { 230,222 }, { 45,251 }, },
	#endif
	#if (ARUCO_DB_SIZE > 651)
		{ { 113,208 }, { 232,162 }, { 11,142 }, { 69,23 }, },
	#endif
	#if (ARUCO_DB_SIZE > 652)
		{ { 121,57 }, { 250,133 }, { 156,158 }, { 161,95 }, },
	#endif
	#if (ARUCO_DB_SIZE > 653)
		{ { 115,48 }, { 238,128 }, { 12,206 }, { 1,119 }, },
	#endif
	#if (ARUCO_DB_SIZE > 654)
		{ { 115,185 }, { 254,131 }, { 157,206 }, { 193,127 }, },
	#endif
	#if (ARUCO_DB_SIZE > 655)
		{ { 115,83 }, { 253,160 }, { 202,206 }, { 5,191 }, },
	#endif
	#if (ARUCO_DB_SIZE > 656)
		{ { 115,255 }, { 255,179 }, { 255,206 }, { 205,255 }, },
	#endif
	#if (ARUCO_DB_SIZE > 657)
		{ { 108,136 }, { 8,199 }, { 17,54 }, { 227,16 }, },
	#endif
	#if (ARUCO_DB_SIZE > 658)
		{ { 100,9 }, { 24,193 }, { 144,38 }, { 131,24 }, },
	#endif
	#if (ARUCO_DB_SIZE > 659)
		{ { 108,67 }, { 25,228 }, { 194,54 }, { 39,152 }, },
	#endif
	#if (ARUCO_DB_SIZE > 660)
		{ { 102,6 }, { 13,208 }, { 96,102 }, { 11,176 }, },
	#endif
	#if (ARUCO_DB_SIZE > 661)
		{ { 102,131 }, { 29,194 }, { 193,102 }, { 67,184 }, },
	#endif
	#if (ARUCO_DB_SIZE > 662)
		{ { 100,176 }, { 42,194 }, { 13,38 }, { 67,84 }, },
	#endif
	#if (ARUCO_DB_SIZE > 663)
		{ { 100,218 }, { 41,227 }, { 91,38 }, { 199,148 }, },
	#endif
	#if (ARUCO_DB_SIZE > 664)
		{ { 110,159 }, { 61,215 }, { 249,118 }, { 235,188 }, },
	#endif
	#if (ARUCO_DB_SIZE > 665)
		{ { 103,200 }, { 76,227 }, { 19,230 }, { 199,50 }, },
	#endif
	#if (ARUCO_DB_SIZE > 666)
		{ { 111,238 }, { 79,247 }, { 119,246 }, { 239,242 }, },
	#endif
	#if (ARUCO_DB_SIZE > 667)
		{ { 109,59 }, { 123,197 }, { 220,182 }, { 163,222 }, },
	#endif
	#if (ARUCO_DB_SIZE > 668)
		{ { 111,210 }, { 109,230 }, { 75,246 }, { 103,182 }, },
	#endif
	#if (ARUCO_DB_SIZE > 669)
		{ { 116,128 }, { 136,194 }, { 1,46 }, { 67,17 }, },
	#endif
	#if (ARUCO_DB_SIZE > 670)
		{ { 124,171 }, { 155,199 }, { 213,62 }, { 227,217 }, },
	#endif
	#if (ARUCO_DB_SIZE > 671)
		{ { 126,104 }, { 142,229 }, { 22,126 }, { 167,113 }, },
	#endif
	#if (ARUCO_DB_SIZE > 672)
		{ { 126,2 }, { 141,196 }, { 64,126 }, { 35,177 }, },
	#endif
	#if (ARUCO_DB_SIZE > 673)
		{ { 124,156 }, { 168,215 }, { 57,62 }, { 235,21 }, },
	#endif
	#if (ARUCO_DB_SIZE > 674)
		{ { 116,54 }, { 171,208 }, { 108,46 }, { 11,213 }, },
	#endif
	#if (ARUCO_DB_SIZE > 675)
		{ { 124,17 }, { 184,196 }, { 136,62 }, { 35,29 }, },
	#endif
	#if (ARUCO_DB_SIZE > 676)
		{ { 126,222 }, { 173,247 }, { 123,126 }, { 239,181 }, },
	#endif
	#if (ARUCO_DB_SIZE > 677)
		{ { 126,182 }, { 175,214 }, { 109,126 }, { 107,245 }, },
	#endif
	#if (ARUCO_DB_SIZE > 678)
		{ { 118,219 }, { 189,227 }, { 219,110 }, { 199,189 }, },
	#endif
	#if (ARUCO_DB_SIZE > 679)
		{ { 125,196 }, { 200,246 }, { 35,190 }, { 111,19 }, },
	#endif
	#if (ARUCO_DB_SIZE > 680)
		{ { 125,138 }, { 201,199 }, { 81,190 }, { 227,147 }, },
	#endif
	#if (ARUCO_DB_SIZE > 681)
		{ { 117,109 }, { 218,241 }, { 182,174 }, { 143,91 }, },
	#endif
	#if (ARUCO_DB_SIZE > 682)
		{ { 119,136 }, { 204,195 }, { 17,238 }, { 195,51 }, },
	#endif
	#if (ARUCO_DB_SIZE > 683)
		{ { 119,32 }, { 206,192 }, { 4,238 }, { 3,115 }, },
	#endif
	#if (ARUCO_DB_SIZE > 684)
		{ { 119,65 }, { 220,224 }, { 130,238 }, { 7,59 }, },
	#endif
	#if (ARUCO_DB_SIZE > 685)
		{ { 117,56 }, { 234,193 }, { 28,174 }, { 131,87 }, },
	#endif
	#if (ARUCO_DB_SIZE > 686)
		{ { 117,190 }, { 235,211 }, { 125,174 }, { 203,215 }, },
	#endif
	#if (ARUCO_DB_SIZE > 687)
		{ { 125,155 }, { 249,199 }, { 217,190 }, { 227,159 }, },
	#endif
	#if (ARUCO_DB_SIZE > 688)
		{ { 119,87 }, { 253,240 }, { 234,238 }, { 15,191 }, },
	#endif
	#if (ARUCO_DB_SIZE > 689)
		{ { 136,40 }, { 2,13 }, { 20,17 }, { 176,64 }, },
	#endif
	#if (ARUCO_DB_SIZE > 690)
		{ { 128,172 }, { 2,27 }, { 53,1 }, { 216,64 }, },
	#endif
	#if (ARUCO_DB_SIZE > 691)
		{ { 136,13 }, { 16,29 }, { 176,17 }, { 184,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 692)
		{ { 136,103 }, { 19,60 }, { 230,17 }, { 60,200 }, },
	#endif
	#if (ARUCO_DB_SIZE > 693)
		{ { 130,78 }, { 5,57 }, { 114,65 }, { 156,160 }, },
	#endif
	#if (ARUCO_DB_SIZE > 694)
		{ { 138,161 }, { 22,14 }, { 133,81 }, { 112,104 }, },
	#endif
	#if (ARUCO_DB_SIZE > 695)
		{ { 130,43 }, { 23,9 }, { 212,65 }, { 144,232 }, },
	#endif
	#if (ARUCO_DB_SIZE > 696)
		{ { 128,24 }, { 32,9 }, { 24,1 }, { 144,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 697)
		{ { 136,249 }, { 50,47 }, { 159,17 }, { 244,76 }, },
	#endif
	#if (ARUCO_DB_SIZE > 698)
		{ { 128,157 }, { 48,27 }, { 185,1 }, { 216,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 699)
		{ { 138,156 }, { 36,31 }, { 57,81 }, { 248,36 }, },
	#endif
	#if (ARUCO_DB_SIZE > 700)
		{ { 130,49 }, { 54,8 }, { 140,65 }, { 16,108 }, },
	#endif
	#if (ARUCO_DB_SIZE > 701)
		{ { 138,117 }, { 54,60 }, { 174,81 }, { 60,108 }, },
	#endif
	#if (ARUCO_DB_SIZE > 702)
		{ { 130,151 }, { 53,26 }, { 233,65 }, { 88,172 }, },
	#endif
	#if (ARUCO_DB_SIZE > 703)
		{ { 129,9 }, { 80,9 }, { 144,129 }, { 144,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 704)
		{ { 129,235 }, { 83,43 }, { 215,129 }, { 212,202 }, },
	#endif
	#if (ARUCO_DB_SIZE > 705)
		{ { 129,7 }, { 81,24 }, { 224,129 }, { 24,138 }, },
	#endif
	#if (ARUCO_DB_SIZE > 706)
		{ { 139,40 }, { 70,13 }, { 20,209 }, { 176,98 }, },
	#endif
	#if (ARUCO_DB_SIZE > 707)
		{ { 139,172 }, { 70,31 }, { 53,209 }, { 248,98 }, },
	#endif
	#if (ARUCO_DB_SIZE > 708)
		{ { 131,46 }, { 71,25 }, { 116,193 }, { 152,226 }, },
	#endif
	#if (ARUCO_DB_SIZE > 709)
		{ { 131,229 }, { 86,58 }, { 167,193 }, { 92,106 }, },
	#endif
	#if (ARUCO_DB_SIZE > 710)
		{ { 129,80 }, { 96,40 }, { 10,129 }, { 20,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 711)
		{ { 137,50 }, { 99,12 }, { 76,145 }, { 48,198 }, },
	#endif
	#if (ARUCO_DB_SIZE > 712)
		{ { 139,122 }, { 103,45 }, { 94,209 }, { 180,230 }, },
	#endif
	#if (ARUCO_DB_SIZE > 713)
		{ { 139,150 }, { 101,30 }, { 105,209 }, { 120,166 }, },
	#endif
	#if (ARUCO_DB_SIZE > 714)
		{ { 131,125 }, { 118,57 }, { 190,193 }, { 156,110 }, },
	#endif
	#if (ARUCO_DB_SIZE > 715)
		{ { 144,135 }, { 145,26 }, { 225,9 }, { 88,137 }, },
	#endif
	#if (ARUCO_DB_SIZE > 716)
		{ { 154,252 }, { 166,63 }, { 63,89 }, { 252,101 }, },
	#endif
	#if (ARUCO_DB_SIZE > 717)
		{ { 146,245 }, { 182,58 }, { 175,73 }, { 92,109 }, },
	#endif
	#if (ARUCO_DB_SIZE > 718)
		{ { 145,170 }, { 195,11 }, { 85,137 }, { 208,195 }, },
	#endif
	#if (ARUCO_DB_SIZE > 719)
		{ { 147,65 }, { 212,40 }, { 130,201 }, { 20,43 }, },
	#endif
	#if (ARUCO_DB_SIZE > 720)
		{ { 147,37 }, { 214,24 }, { 164,201 }, { 24,107 }, },
	#endif
	#if (ARUCO_DB_SIZE > 721)
		{ { 155,235 }, { 215,47 }, { 215,217 }, { 244,235 }, },
	#endif
	#if (ARUCO_DB_SIZE > 722)
		{ { 153,52 }, { 226,28 }, { 44,153 }, { 56,71 }, },
	#endif
	#if (ARUCO_DB_SIZE > 723)
		{ { 145,247 }, { 243,58 }, { 239,137 }, { 92,207 }, },
	#endif
	#if (ARUCO_DB_SIZE > 724)
		{ { 155,218 }, { 229,47 }, { 91,217 }, { 244,167 }, },
	#endif
	#if (ARUCO_DB_SIZE > 725)
		{ { 147,86 }, { 229,56 }, { 106,201 }, { 28,167 }, },
	#endif
	#if (ARUCO_DB_SIZE > 726)
		{ { 132,66 }, { 1,104 }, { 66,33 }, { 22,128 }, },
	#endif
	#if (ARUCO_DB_SIZE > 727)
		{ { 140,129 }, { 16,78 }, { 129,49 }, { 114,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 728)
		{ { 140,79 }, { 17,125 }, { 242,49 }, { 190,136 }, },
	#endif
	#if (ARUCO_DB_SIZE > 729)
		{ { 134,72 }, { 4,105 }, { 18,97 }, { 150,32 }, },
	#endif
	#if (ARUCO_DB_SIZE > 730)
		{ { 134,166 }, { 7,90 }, { 101,97 }, { 90,224 }, },
	#endif
	#if (ARUCO_DB_SIZE > 731)
		{ { 142,3 }, { 21,76 }, { 192,113 }, { 50,168 }, },
	#endif
	#if (ARUCO_DB_SIZE > 732)
		{ { 134,227 }, { 23,106 }, { 199,97 }, { 86,232 }, },
	#endif
	#if (ARUCO_DB_SIZE > 733)
		{ { 134,111 }, { 23,121 }, { 246,97 }, { 158,232 }, },
	#endif
	#if (ARUCO_DB_SIZE > 734)
		{ { 142,175 }, { 23,95 }, { 245,113 }, { 250,232 }, },
	#endif
	#if (ARUCO_DB_SIZE > 735)
		{ { 132,94 }, { 33,121 }, { 122,33 }, { 158,132 }, },
	#endif
	#if (ARUCO_DB_SIZE > 736)
		{ { 132,119 }, { 51,120 }, { 238,33 }, { 30,204 }, },
	#endif
	#if (ARUCO_DB_SIZE > 737)
		{ { 134,250 }, { 39,107 }, { 95,97 }, { 214,228 }, },
	#endif
	#if (ARUCO_DB_SIZE > 738)
		{ { 142,30 }, { 37,93 }, { 120,113 }, { 186,164 }, },
	#endif
	#if (ARUCO_DB_SIZE > 739)
		{ { 142,55 }, { 55,92 }, { 236,113 }, { 58,236 }, },
	#endif
	#if (ARUCO_DB_SIZE > 740)
		{ { 135,10 }, { 69,73 }, { 80,225 }, { 146,162 }, },
	#endif
	#if (ARUCO_DB_SIZE > 741)
		{ { 143,138 }, { 69,79 }, { 81,241 }, { 242,162 }, },
	#endif
	#if (ARUCO_DB_SIZE > 742)
		{ { 143,38 }, { 71,92 }, { 100,241 }, { 58,226 }, },
	#endif
	#if (ARUCO_DB_SIZE > 743)
		{ { 135,33 }, { 86,72 }, { 132,225 }, { 18,106 }, },
	#endif
	#if (ARUCO_DB_SIZE > 744)
		{ { 135,13 }, { 84,89 }, { 176,225 }, { 154,42 }, },
	#endif
	#if (ARUCO_DB_SIZE > 745)
		{ { 133,114 }, { 99,104 }, { 78,161 }, { 22,198 }, },
	#endif
	#if (ARUCO_DB_SIZE > 746)
		{ { 135,62 }, { 103,89 }, { 124,225 }, { 154,230 }, },
	#endif
	#if (ARUCO_DB_SIZE > 747)
		{ { 156,67 }, { 145,108 }, { 194,57 }, { 54,137 }, },
	#endif
	#if (ARUCO_DB_SIZE > 748)
		{ { 158,97 }, { 150,108 }, { 134,121 }, { 54,105 }, },
	#endif
	#if (ARUCO_DB_SIZE > 749)
		{ { 148,88 }, { 160,105 }, { 26,41 }, { 150,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 750)
		{ { 148,248 }, { 162,107 }, { 31,41 }, { 214,69 }, },
	#endif
	#if (ARUCO_DB_SIZE > 751)
		{ { 156,50 }, { 163,76 }, { 76,57 }, { 50,197 }, },
	#endif
	#if (ARUCO_DB_SIZE > 752)
		{ { 148,118 }, { 163,120 }, { 110,41 }, { 30,197 }, },
	#endif
	#if (ARUCO_DB_SIZE > 753)
		{ { 148,177 }, { 178,74 }, { 141,41 }, { 82,77 }, },
	#endif
	#if (ARUCO_DB_SIZE > 754)
		{ { 148,221 }, { 176,123 }, { 187,41 }, { 222,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 755)
		{ { 148,155 }, { 177,75 }, { 217,41 }, { 210,141 }, },
	#endif
	#if (ARUCO_DB_SIZE > 756)
		{ { 156,219 }, { 177,111 }, { 219,57 }, { 246,141 }, },
	#endif
	#if (ARUCO_DB_SIZE > 757)
		{ { 158,156 }, { 164,95 }, { 57,121 }, { 250,37 }, },
	#endif
	#if (ARUCO_DB_SIZE > 758)
		{ { 158,210 }, { 165,110 }, { 75,121 }, { 118,165 }, },
	#endif
	#if (ARUCO_DB_SIZE > 759)
		{ { 150,25 }, { 180,73 }, { 152,105 }, { 146,45 }, },
	#endif
	#if (ARUCO_DB_SIZE > 760)
		{ { 158,177 }, { 182,78 }, { 141,121 }, { 114,109 }, },
	#endif
	#if (ARUCO_DB_SIZE > 761)
		{ { 149,105 }, { 210,105 }, { 150,169 }, { 150,75 }, },
	#endif
	#if (ARUCO_DB_SIZE > 762)
		{ { 159,109 }, { 214,125 }, { 182,249 }, { 190,107 }, },
	#endif
	#if (ARUCO_DB_SIZE > 763)
		{ { 151,43 }, { 215,73 }, { 212,233 }, { 146,235 }, },
	#endif
	#if (ARUCO_DB_SIZE > 764)
		{ { 149,182 }, { 227,90 }, { 109,169 }, { 90,199 }, },
	#endif
	#if (ARUCO_DB_SIZE > 765)
		{ { 149,185 }, { 242,75 }, { 157,169 }, { 210,79 }, },
	#endif
	#if (ARUCO_DB_SIZE > 766)
		{ { 157,61 }, { 242,93 }, { 188,185 }, { 186,79 }, },
	#endif
	#if (ARUCO_DB_SIZE > 767)
		{ { 157,87 }, { 241,124 }, { 234,185 }, { 62,143 }, },
	#endif
	#if (ARUCO_DB_SIZE > 768)
		{ { 168,236 }, { 10,63 }, { 55,21 }, { 252,80 }, },
	#endif
	#if (ARUCO_DB_SIZE > 769)
		{ { 168,37 }, { 26,28 }, { 164,21 }, { 56,88 }, },
	#endif
	#if (ARUCO_DB_SIZE > 770)
		{ { 162,172 }, { 14,27 }, { 53,69 }, { 216,112 }, },
	#endif
	#if (ARUCO_DB_SIZE > 771)
		{ { 162,2 }, { 13,8 }, { 64,69 }, { 16,176 }, },
	#endif
	#if (ARUCO_DB_SIZE > 772)
		{ { 170,102 }, { 15,60 }, { 102,85 }, { 60,240 }, },
	#endif
	#if (ARUCO_DB_SIZE > 773)
		{ { 170,143 }, { 29,31 }, { 241,85 }, { 248,184 }, },
	#endif
	#if (ARUCO_DB_SIZE > 774)
		{ { 170,231 }, { 31,62 }, { 231,85 }, { 124,248 }, },
	#endif
	#if (ARUCO_DB_SIZE > 775)
		{ { 168,48 }, { 42,12 }, { 12,21 }, { 48,84 }, },
	#endif
	#if (ARUCO_DB_SIZE > 776)
		{ { 168,122 }, { 43,45 }, { 94,21 }, { 180,212 }, },
	#endif
	#if (ARUCO_DB_SIZE > 777)
		{ { 168,246 }, { 43,62 }, { 111,21 }, { 124,212 }, },
	#endif
	#if (ARUCO_DB_SIZE > 778)
		{ { 168,147 }, { 57,14 }, { 201,21 }, { 112,156 }, },
	#endif
	#if (ARUCO_DB_SIZE > 779)
		{ { 162,20 }, { 44,24 }, { 40,69 }, { 24,52 }, },
	#endif
	#if (ARUCO_DB_SIZE > 780)
		{ { 170,52 }, { 46,28 }, { 44,85 }, { 56,116 }, },
	#endif
	#if (ARUCO_DB_SIZE > 781)
		{ { 162,114 }, { 47,40 }, { 78,69 }, { 20,244 }, },
	#endif
	#if (ARUCO_DB_SIZE > 782)
		{ { 170,242 }, { 47,46 }, { 79,85 }, { 116,244 }, },
	#endif
	#if (ARUCO_DB_SIZE > 783)
		{ { 162,241 }, { 62,42 }, { 143,69 }, { 84,124 }, },
	#endif
	#if (ARUCO_DB_SIZE > 784)
		{ { 161,64 }, { 72,40 }, { 2,133 }, { 20,18 }, },
	#endif
	#if (ARUCO_DB_SIZE > 785)
		{ { 169,10 }, { 73,13 }, { 80,149 }, { 176,146 }, },
	#endif
	#if (ARUCO_DB_SIZE > 786)
		{ { 161,38 }, { 75,24 }, { 100,133 }, { 24,210 }, },
	#endif
	#if (ARUCO_DB_SIZE > 787)
		{ { 169,197 }, { 88,62 }, { 163,149 }, { 124,26 }, },
	#endif
	#if (ARUCO_DB_SIZE > 788)
		{ { 169,207 }, { 89,63 }, { 243,149 }, { 252,154 }, },
	#endif
	#if (ARUCO_DB_SIZE > 789)
		{ { 161,52 }, { 106,24 }, { 44,133 }, { 24,86 }, },
	#endif
	#if (ARUCO_DB_SIZE > 790)
		{ { 169,18 }, { 105,12 }, { 72,149 }, { 48,150 }, },
	#endif
	#if (ARUCO_DB_SIZE > 791)
		{ { 161,250 }, { 107,43 }, { 95,133 }, { 212,214 }, },
	#endif
	#if (ARUCO_DB_SIZE > 792)
		{ { 171,152 }, { 108,15 }, { 25,213 }, { 240,54 }, },
	#endif
	#if (ARUCO_DB_SIZE > 793)
		{ { 163,247 }, { 127,58 }, { 239,197 }, { 92,254 }, },
	#endif
	#if (ARUCO_DB_SIZE > 794)
		{ { 176,6 }, { 137,24 }, { 96,13 }, { 24,145 }, },
	#endif
	#if (ARUCO_DB_SIZE > 795)
		{ { 176,69 }, { 152,56 }, { 162,13 }, { 28,25 }, },
	#endif
	#if (ARUCO_DB_SIZE > 796)
		{ { 184,141 }, { 152,31 }, { 177,29 }, { 248,25 }, },
	#endif
	#if (ARUCO_DB_SIZE > 797)
		{ { 178,132 }, { 140,26 }, { 33,77 }, { 88,49 }, },
	#endif
	#if (ARUCO_DB_SIZE > 798)
		{ { 184,240 }, { 170,46 }, { 15,29 }, { 116,85 }, },
	#endif
	#if (ARUCO_DB_SIZE > 799)
		{ { 184,85 }, { 184,60 }, { 170,29 }, { 60,29 }, },
	#endif
	#if (ARUCO_DB_SIZE > 800)
		{ { 178,118 }, { 175,56 }, { 110,77 }, { 28,245 }, },
	#endif
	#if (ARUCO_DB_SIZE > 801)
		{ { 186,145 }, { 188,14 }, { 137,93 }, { 112,61 }, },
	#endif
	#if (ARUCO_DB_SIZE > 802)
		{ { 178,113 }, { 190,40 }, { 142,77 }, { 20,125 }, },
	#endif
	#if (ARUCO_DB_SIZE > 803)
		{ { 185,192 }, { 200,46 }, { 3,157 }, { 116,19 }, },
	#endif
	#if (ARUCO_DB_SIZE > 804)
		{ { 185,66 }, { 201,44 }, { 66,157 }, { 52,147 }, },
	#endif
	#if (ARUCO_DB_SIZE > 805)
		{ { 185,42 }, { 203,13 }, { 84,157 }, { 176,211 }, },
	#endif
	#if (ARUCO_DB_SIZE > 806)
		{ { 179,140 }, { 204,27 }, { 49,205 }, { 216,51 }, },
	#endif
	#if (ARUCO_DB_SIZE > 807)
		{ { 179,202 }, { 205,43 }, { 83,205 }, { 212,179 }, },
	#endif
	#if (ARUCO_DB_SIZE > 808)
		{ { 187,102 }, { 207,60 }, { 102,221 }, { 60,243 }, },
	#endif
	#if (ARUCO_DB_SIZE > 809)
		{ { 179,15 }, { 221,25 }, { 240,205 }, { 152,187 }, },
	#endif
	#if (ARUCO_DB_SIZE > 810)
		{ { 177,218 }, { 233,43 }, { 91,141 }, { 212,151 }, },
	#endif
	#if (ARUCO_DB_SIZE > 811)
		{ { 187,20 }, { 236,28 }, { 40,221 }, { 56,55 }, },
	#endif
	#if (ARUCO_DB_SIZE > 812)
		{ { 187,246 }, { 239,62 }, { 111,221 }, { 124,247 }, },
	#endif
	#if (ARUCO_DB_SIZE > 813)
		{ { 179,19 }, { 253,8 }, { 200,205 }, { 16,191 }, },
	#endif
	#if (ARUCO_DB_SIZE > 814)
		{ { 164,104 }, { 10,105 }, { 22,37 }, { 150,80 }, },
	#endif
	#if (ARUCO_DB_SIZE > 815)
		{ { 172,44 }, { 10,93 }, { 52,53 }, { 186,80 }, },
	#endif
	#if (ARUCO_DB_SIZE > 816)
		{ { 172,161 }, { 26,78 }, { 133,53 }, { 114,88 }, },
	#endif
	#if (ARUCO_DB_SIZE > 817)
		{ { 172,235 }, { 27,111 }, { 215,53 }, { 246,216 }, },
	#endif
	#if (ARUCO_DB_SIZE > 818)
		{ { 172,199 }, { 25,126 }, { 227,53 }, { 126,152 }, },
	#endif
	#if (ARUCO_DB_SIZE > 819)
		{ { 164,103 }, { 27,120 }, { 230,37 }, { 30,216 }, },
	#endif
	#if (ARUCO_DB_SIZE > 820)
		{ { 166,192 }, { 12,106 }, { 3,101 }, { 86,48 }, },
	#endif
	#if (ARUCO_DB_SIZE > 821)
		{ { 174,224 }, { 14,110 }, { 7,117 }, { 118,112 }, },
	#endif
	#if (ARUCO_DB_SIZE > 822)
		{ { 166,35 }, { 31,72 }, { 196,101 }, { 18,248 }, },
	#endif
	#if (ARUCO_DB_SIZE > 823)
		{ { 173,232 }, { 74,111 }, { 23,181 }, { 246,82 }, },
	#endif
	#if (ARUCO_DB_SIZE > 824)
		{ { 165,204 }, { 72,123 }, { 51,165 }, { 222,18 }, },
	#endif
	#if (ARUCO_DB_SIZE > 825)
		{ { 167,236 }, { 78,123 }, { 55,229 }, { 222,114 }, },
	#endif
	#if (ARUCO_DB_SIZE > 826)
		{ { 173,124 }, { 106,125 }, { 62,181 }, { 190,86 }, },
	#endif
	#if (ARUCO_DB_SIZE > 827)
		{ { 165,26 }, { 105,73 }, { 88,165 }, { 146,150 }, },
	#endif
	#if (ARUCO_DB_SIZE > 828)
		{ { 165,145 }, { 120,74 }, { 137,165 }, { 82,30 }, },
	#endif
	#if (ARUCO_DB_SIZE > 829)
		{ { 173,25 }, { 120,77 }, { 152,181 }, { 178,30 }, },
	#endif
	#if (ARUCO_DB_SIZE > 830)
		{ { 165,151 }, { 121,90 }, { 233,165 }, { 90,158 }, },
	#endif
	#if (ARUCO_DB_SIZE > 831)
		{ { 180,109 }, { 154,121 }, { 182,45 }, { 158,89 }, },
	#endif
	#if (ARUCO_DB_SIZE > 832)
		{ { 190,203 }, { 157,111 }, { 211,125 }, { 246,185 }, },
	#endif
	#if (ARUCO_DB_SIZE > 833)
		{ { 188,58 }, { 171,77 }, { 92,61 }, { 178,213 }, },
	#endif
	#if (ARUCO_DB_SIZE > 834)
		{ { 188,245 }, { 186,126 }, { 175,61 }, { 126,93 }, },
	#endif
	#if (ARUCO_DB_SIZE > 835)
		{ { 190,189 }, { 190,95 }, { 189,125 }, { 250,125 }, },
	#endif
	#if (ARUCO_DB_SIZE > 836)
		{ { 190,243 }, { 191,110 }, { 207,125 }, { 118,253 }, },
	#endif
	#if (ARUCO_DB_SIZE > 837)
		{ { 181,37 }, { 218,88 }, { 164,173 }, { 26,91 }, },
	#endif
	#if (ARUCO_DB_SIZE > 838)
		{ { 181,143 }, { 217,91 }, { 241,173 }, { 218,155 }, },
	#endif
	#if (ARUCO_DB_SIZE > 839)
		{ { 183,104 }, { 206,105 }, { 22,237 }, { 150,115 }, },
	#endif
	#if (ARUCO_DB_SIZE > 840)
		{ { 191,228 }, { 206,126 }, { 39,253 }, { 126,115 }, },
	#endif
	#if (ARUCO_DB_SIZE > 841)
		{ { 189,254 }, { 235,127 }, { 127,189 }, { 254,215 }, },
	#endif
	#if (ARUCO_DB_SIZE > 842)
		{ { 189,157 }, { 248,95 }, { 185,189 }, { 250,31 }, },
	#endif
	#if (ARUCO_DB_SIZE > 843)
		{ { 181,245 }, { 250,122 }, { 175,173 }, { 94,95 }, },
	#endif
	#if (ARUCO_DB_SIZE > 844)
		{ { 181,243 }, { 251,106 }, { 207,173 }, { 86,223 }, },
	#endif
	#if (ARUCO_DB_SIZE > 845)
		{ { 191,176 }, { 238,78 }, { 13,253 }, { 114,119 }, },
	#endif
	#if (ARUCO_DB_SIZE > 846)
		{ { 183,90 }, { 237,105 }, { 90,237 }, { 150,183 }, },
	#endif
	#if (ARUCO_DB_SIZE > 847)
		{ { 191,62 }, { 239,93 }, { 124,253 }, { 186,247 }, },
	#endif
	#if (ARUCO_DB_SIZE > 848)
		{ { 183,57 }, { 254,73 }, { 156,237 }, { 146,127 }, },
	#endif
	#if (ARUCO_DB_SIZE > 849)
		{ { 191,213 }, { 252,126 }, { 171,253 }, { 126,63 }, },
	#endif
	#if (ARUCO_DB_SIZE > 850)
		{ { 183,29 }, { 252,89 }, { 184,237 }, { 154,63 }, },
	#endif
	#if (ARUCO_DB_SIZE > 851)
		{ { 191,53 }, { 254,92 }, { 172,253 }, { 58,127 }, },
	#endif
	#if (ARUCO_DB_SIZE > 852)
		{ { 183,127 }, { 255,121 }, { 254,237 }, { 158,255 }, },
	#endif
	#if (ARUCO_DB_SIZE > 853)
		{ { 200,1 }, { 16,140 }, { 128,19 }, { 49,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 854)
		{ { 192,165 }, { 18,154 }, { 165,3 }, { 89,72 }, },
	#endif
	#if (ARUCO_DB_SIZE > 855)
		{ { 194,130 }, { 5,138 }, { 65,67 }, { 81,160 }, },
	#endif
	#if (ARUCO_DB_SIZE > 856)
		{ { 200,189 }, { 50,159 }, { 189,19 }, { 249,76 }, },
	#endif
	#if (ARUCO_DB_SIZE > 857)
		{ { 194,252 }, { 38,187 }, { 63,67 }, { 221,100 }, },
	#endif
	#if (ARUCO_DB_SIZE > 858)
		{ { 202,145 }, { 52,142 }, { 137,83 }, { 113,44 }, },
	#endif
	#if (ARUCO_DB_SIZE > 859)
		{ { 194,91 }, { 53,169 }, { 218,67 }, { 149,172 }, },
	#endif
	#if (ARUCO_DB_SIZE > 860)
		{ { 201,68 }, { 64,188 }, { 34,147 }, { 61,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 861)
		{ { 193,42 }, { 67,137 }, { 84,131 }, { 145,194 }, },
	#endif
	#if (ARUCO_DB_SIZE > 862)
		{ { 195,192 }, { 68,170 }, { 3,195 }, { 85,34 }, },
	#endif
	#if (ARUCO_DB_SIZE > 863)
		{ { 201,122 }, { 99,173 }, { 94,147 }, { 181,198 }, },
	#endif
	#if (ARUCO_DB_SIZE > 864)
		{ { 193,185 }, { 114,139 }, { 157,131 }, { 209,78 }, },
	#endif
	#if (ARUCO_DB_SIZE > 865)
		{ { 201,117 }, { 114,188 }, { 174,147 }, { 61,78 }, },
	#endif
	#if (ARUCO_DB_SIZE > 866)
		{ { 193,247 }, { 115,186 }, { 239,131 }, { 93,206 }, },
	#endif
	#if (ARUCO_DB_SIZE > 867)
		{ { 203,177 }, { 118,142 }, { 141,211 }, { 113,110 }, },
	#endif
	#if (ARUCO_DB_SIZE > 868)
		{ { 208,108 }, { 130,185 }, { 54,11 }, { 157,65 }, },
	#endif
	#if (ARUCO_DB_SIZE > 869)
		{ { 216,135 }, { 145,158 }, { 225,27 }, { 121,137 }, },
	#endif
	#if (ARUCO_DB_SIZE > 870)
		{ { 208,175 }, { 147,155 }, { 245,11 }, { 217,201 }, },
	#endif
	#if (ARUCO_DB_SIZE > 871)
		{ { 218,196 }, { 132,190 }, { 35,91 }, { 125,33 }, },
	#endif
	#if (ARUCO_DB_SIZE > 872)
		{ { 210,12 }, { 132,153 }, { 48,75 }, { 153,33 }, },
	#endif
	#if (ARUCO_DB_SIZE > 873)
		{ { 218,9 }, { 148,141 }, { 144,91 }, { 177,41 }, },
	#endif
	#if (ARUCO_DB_SIZE > 874)
		{ { 208,48 }, { 162,136 }, { 12,11 }, { 17,69 }, },
	#endif
	#if (ARUCO_DB_SIZE > 875)
		{ { 216,148 }, { 160,158 }, { 41,27 }, { 121,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 876)
		{ { 208,58 }, { 163,137 }, { 92,11 }, { 145,197 }, },
	#endif
	#if (ARUCO_DB_SIZE > 877)
		{ { 208,182 }, { 163,154 }, { 109,11 }, { 89,197 }, },
	#endif
	#if (ARUCO_DB_SIZE > 878)
		{ { 208,117 }, { 178,184 }, { 174,11 }, { 29,77 }, },
	#endif
	#if (ARUCO_DB_SIZE > 879)
		{ { 210,118 }, { 167,184 }, { 110,75 }, { 29,229 }, },
	#endif
	#if (ARUCO_DB_SIZE > 880)
		{ { 218,93 }, { 180,189 }, { 186,91 }, { 189,45 }, },
	#endif
	#if (ARUCO_DB_SIZE > 881)
		{ { 218,53 }, { 182,156 }, { 172,91 }, { 57,109 }, },
	#endif
	#if (ARUCO_DB_SIZE > 882)
		{ { 210,23 }, { 181,152 }, { 232,75 }, { 25,173 }, },
	#endif
	#if (ARUCO_DB_SIZE > 883)
		{ { 217,2 }, { 193,140 }, { 64,155 }, { 49,131 }, },
	#endif
	#if (ARUCO_DB_SIZE > 884)
		{ { 211,232 }, { 198,171 }, { 23,203 }, { 213,99 }, },
	#endif
	#if (ARUCO_DB_SIZE > 885)
		{ { 211,229 }, { 214,186 }, { 167,203 }, { 93,107 }, },
	#endif
	#if (ARUCO_DB_SIZE > 886)
		{ { 209,154 }, { 225,139 }, { 89,139 }, { 209,135 }, },
	#endif
	#if (ARUCO_DB_SIZE > 887)
		{ { 209,246 }, { 227,186 }, { 111,139 }, { 93,199 }, },
	#endif
	#if (ARUCO_DB_SIZE > 888)
		{ { 209,81 }, { 240,168 }, { 138,139 }, { 21,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 889)
		{ { 219,20 }, { 228,156 }, { 40,219 }, { 57,39 }, },
	#endif
	#if (ARUCO_DB_SIZE > 890)
		{ { 211,62 }, { 231,153 }, { 124,203 }, { 153,231 }, },
	#endif
	#if (ARUCO_DB_SIZE > 891)
		{ { 211,211 }, { 245,170 }, { 203,203 }, { 85,175 }, },
	#endif
	#if (ARUCO_DB_SIZE > 892)
		{ { 196,96 }, { 2,232 }, { 6,35 }, { 23,64 }, },
	#endif
	#if (ARUCO_DB_SIZE > 893)
		{ { 204,167 }, { 19,222 }, { 229,51 }, { 123,200 }, },
	#endif
	#if (ARUCO_DB_SIZE > 894)
		{ { 198,66 }, { 5,232 }, { 66,99 }, { 23,160 }, },
	#endif
	#if (ARUCO_DB_SIZE > 895)
		{ { 198,71 }, { 21,248 }, { 226,99 }, { 31,168 }, },
	#endif
	#if (ARUCO_DB_SIZE > 896)
		{ { 206,231 }, { 23,254 }, { 231,115 }, { 127,232 }, },
	#endif
	#if (ARUCO_DB_SIZE > 897)
		{ { 196,92 }, { 32,249 }, { 58,35 }, { 159,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 898)
		{ { 204,29 }, { 48,221 }, { 184,51 }, { 187,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 899)
		{ { 204,53 }, { 50,220 }, { 172,51 }, { 59,76 }, },
	#endif
	#if (ARUCO_DB_SIZE > 900)
		{ { 198,188 }, { 38,219 }, { 61,99 }, { 219,100 }, },
	#endif
	#if (ARUCO_DB_SIZE > 901)
		{ { 205,168 }, { 66,207 }, { 21,179 }, { 243,66 }, },
	#endif
	#if (ARUCO_DB_SIZE > 902)
		{ { 197,12 }, { 64,217 }, { 48,163 }, { 155,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 903)
		{ { 197,228 }, { 66,250 }, { 39,163 }, { 95,66 }, },
	#endif
	#if (ARUCO_DB_SIZE > 904)
		{ { 197,194 }, { 65,234 }, { 67,163 }, { 87,130 }, },
	#endif
	#if (ARUCO_DB_SIZE > 905)
		{ { 205,45 }, { 82,221 }, { 180,179 }, { 187,74 }, },
	#endif
	#if (ARUCO_DB_SIZE > 906)
		{ { 205,89 }, { 112,237 }, { 154,179 }, { 183,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 907)
		{ { 205,149 }, { 112,222 }, { 169,179 }, { 123,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 908)
		{ { 197,147 }, { 113,202 }, { 201,163 }, { 83,142 }, },
	#endif
	#if (ARUCO_DB_SIZE > 909)
		{ { 199,95 }, { 117,249 }, { 250,227 }, { 159,174 }, },
	#endif
	#if (ARUCO_DB_SIZE > 910)
		{ { 212,197 }, { 144,250 }, { 163,43 }, { 95,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 911)
		{ { 222,136 }, { 132,207 }, { 17,123 }, { 243,33 }, },
	#endif
	#if (ARUCO_DB_SIZE > 912)
		{ { 214,36 }, { 134,216 }, { 36,107 }, { 27,97 }, },
	#endif
	#if (ARUCO_DB_SIZE > 913)
		{ { 222,236 }, { 134,255 }, { 55,123 }, { 255,97 }, },
	#endif
	#if (ARUCO_DB_SIZE > 914)
		{ { 214,226 }, { 135,234 }, { 71,107 }, { 87,225 }, },
	#endif
	#if (ARUCO_DB_SIZE > 915)
		{ { 222,198 }, { 133,254 }, { 99,123 }, { 127,161 }, },
	#endif
	#if (ARUCO_DB_SIZE > 916)
		{ { 222,35 }, { 151,204 }, { 196,123 }, { 51,233 }, },
	#endif
	#if (ARUCO_DB_SIZE > 917)
		{ { 220,220 }, { 160,255 }, { 59,59 }, { 255,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 918)
		{ { 220,26 }, { 161,205 }, { 88,59 }, { 179,133 }, },
	#endif
	#if (ARUCO_DB_SIZE > 919)
		{ { 212,17 }, { 176,200 }, { 136,43 }, { 19,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 920)
		{ { 222,84 }, { 164,252 }, { 42,123 }, { 63,37 }, },
	#endif
	#if (ARUCO_DB_SIZE > 921)
		{ { 214,148 }, { 164,218 }, { 41,107 }, { 91,37 }, },
	#endif
	#if (ARUCO_DB_SIZE > 922)
		{ { 222,157 }, { 180,223 }, { 185,123 }, { 251,45 }, },
	#endif
	#if (ARUCO_DB_SIZE > 923)
		{ { 221,129 }, { 208,206 }, { 129,187 }, { 115,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 924)
		{ { 213,165 }, { 210,218 }, { 165,171 }, { 91,75 }, },
	#endif
	#if (ARUCO_DB_SIZE > 925)
		{ { 215,172 }, { 198,219 }, { 53,235 }, { 219,99 }, },
	#endif
	#if (ARUCO_DB_SIZE > 926)
		{ { 215,102 }, { 199,248 }, { 102,235 }, { 31,227 }, },
	#endif
	#if (ARUCO_DB_SIZE > 927)
		{ { 223,169 }, { 214,207 }, { 149,251 }, { 243,107 }, },
	#endif
	#if (ARUCO_DB_SIZE > 928)
		{ { 213,220 }, { 224,251 }, { 59,171 }, { 223,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 929)
		{ { 221,31 }, { 241,221 }, { 248,187 }, { 187,143 }, },
	#endif
	#if (ARUCO_DB_SIZE > 930)
		{ { 223,240 }, { 230,238 }, { 15,251 }, { 119,103 }, },
	#endif
	#if (ARUCO_DB_SIZE > 931)
		{ { 226,72 }, { 12,169 }, { 18,71 }, { 149,48 }, },
	#endif
	#if (ARUCO_DB_SIZE > 932)
		{ { 226,232 }, { 14,171 }, { 23,71 }, { 213,112 }, },
	#endif
	#if (ARUCO_DB_SIZE > 933)
		{ { 226,7 }, { 29,152 }, { 224,71 }, { 25,184 }, },
	#endif
	#if (ARUCO_DB_SIZE > 934)
		{ { 224,93 }, { 56,185 }, { 186,7 }, { 157,28 }, },
	#endif
	#if (ARUCO_DB_SIZE > 935)
		{ { 234,245 }, { 62,190 }, { 175,87 }, { 125,124 }, },
	#endif
	#if (ARUCO_DB_SIZE > 936)
		{ { 235,38 }, { 79,156 }, { 100,215 }, { 57,242 }, },
	#endif
	#if (ARUCO_DB_SIZE > 937)
		{ { 235,237 }, { 94,191 }, { 183,215 }, { 253,122 }, },
	#endif
	#if (ARUCO_DB_SIZE > 938)
		{ { 225,82 }, { 105,168 }, { 74,135 }, { 21,150 }, },
	#endif
	#if (ARUCO_DB_SIZE > 939)
		{ { 225,126 }, { 107,185 }, { 126,135 }, { 157,214 }, },
	#endif
	#if (ARUCO_DB_SIZE > 940)
		{ { 233,219 }, { 121,175 }, { 219,151 }, { 245,158 }, },
	#endif
	#if (ARUCO_DB_SIZE > 941)
		{ { 248,6 }, { 137,156 }, { 96,31 }, { 57,145 }, },
	#endif
	#if (ARUCO_DB_SIZE > 942)
		{ { 240,238 }, { 139,187 }, { 119,15 }, { 221,209 }, },
	#endif
	#if (ARUCO_DB_SIZE > 943)
		{ { 248,161 }, { 154,142 }, { 133,31 }, { 113,89 }, },
	#endif
	#if (ARUCO_DB_SIZE > 944)
		{ { 250,0 }, { 140,140 }, { 0,95 }, { 49,49 }, },
	#endif
	#if (ARUCO_DB_SIZE > 945)
		{ { 250,194 }, { 141,174 }, { 67,95 }, { 117,177 }, },
	#endif
	#if (ARUCO_DB_SIZE > 946)
		{ { 240,155 }, { 185,139 }, { 217,15 }, { 209,157 }, },
	#endif
	#if (ARUCO_DB_SIZE > 947)
		{ { 250,244 }, { 174,190 }, { 47,95 }, { 125,117 }, },
	#endif
	#if (ARUCO_DB_SIZE > 948)
		{ { 250,60 }, { 174,157 }, { 60,95 }, { 185,117 }, },
	#endif
	#if (ARUCO_DB_SIZE > 949)
		{ { 242,252 }, { 174,187 }, { 63,79 }, { 221,117 }, },
	#endif
	#if (ARUCO_DB_SIZE > 950)
		{ { 242,189 }, { 190,155 }, { 189,79 }, { 217,125 }, },
	#endif
	#if (ARUCO_DB_SIZE > 951)
		{ { 242,147 }, { 189,138 }, { 201,79 }, { 81,189 }, },
	#endif
	#if (ARUCO_DB_SIZE > 952)
		{ { 241,96 }, { 202,168 }, { 6,143 }, { 21,83 }, },
	#endif
	#if (ARUCO_DB_SIZE > 953)
		{ { 249,236 }, { 202,191 }, { 55,159 }, { 253,83 }, },
	#endif
	#if (ARUCO_DB_SIZE > 954)
		{ { 241,70 }, { 201,184 }, { 98,143 }, { 29,147 }, },
	#endif
	#if (ARUCO_DB_SIZE > 955)
		{ { 249,225 }, { 218,174 }, { 135,159 }, { 117,91 }, },
	#endif
	#if (ARUCO_DB_SIZE > 956)
		{ { 243,72 }, { 204,169 }, { 18,207 }, { 149,51 }, },
	#endif
	#if (ARUCO_DB_SIZE > 957)
		{ { 243,174 }, { 207,155 }, { 117,207 }, { 217,243 }, },
	#endif
	#if (ARUCO_DB_SIZE > 958)
		{ { 243,193 }, { 220,170 }, { 131,207 }, { 85,59 }, },
	#endif
	#if (ARUCO_DB_SIZE > 959)
		{ { 243,139 }, { 221,139 }, { 209,207 }, { 209,187 }, },
	#endif
	#if (ARUCO_DB_SIZE > 960)
		{ { 243,167 }, { 223,154 }, { 229,207 }, { 89,251 }, },
	#endif
	#if (ARUCO_DB_SIZE > 961)
		{ { 241,115 }, { 251,168 }, { 206,143 }, { 21,223 }, },
	#endif
	#if (ARUCO_DB_SIZE > 962)
		{ { 241,151 }, { 249,154 }, { 233,143 }, { 89,159 }, },
	#endif
	#if (ARUCO_DB_SIZE > 963)
		{ { 243,244 }, { 238,186 }, { 47,207 }, { 93,119 }, },
	#endif
	#if (ARUCO_DB_SIZE > 964)
		{ { 251,50 }, { 239,140 }, { 76,223 }, { 49,247 }, },
	#endif
	#if (ARUCO_DB_SIZE > 965)
		{ { 228,7 }, { 25,216 }, { 224,39 }, { 27,152 }, },
	#endif
	#if (ARUCO_DB_SIZE > 966)
		{ { 230,77 }, { 28,249 }, { 178,103 }, { 159,56 }, },
	#endif
	#if (ARUCO_DB_SIZE > 967)
		{ { 236,85 }, { 56,252 }, { 170,55 }, { 63,28 }, },
	#endif
	#if (ARUCO_DB_SIZE > 968)
		{ { 237,192 }, { 72,238 }, { 3,183 }, { 119,18 }, },
	#endif
	#if (ARUCO_DB_SIZE > 969)
		{ { 237,133 }, { 88,222 }, { 161,183 }, { 123,26 }, },
	#endif
	#if (ARUCO_DB_SIZE > 970)
		{ { 239,162 }, { 79,206 }, { 69,247 }, { 115,242 }, },
	#endif
	#if (ARUCO_DB_SIZE > 971)
		{ { 231,78 }, { 77,249 }, { 114,231 }, { 159,178 }, },
	#endif
	#if (ARUCO_DB_SIZE > 972)
		{ { 229,213 }, { 120,250 }, { 171,167 }, { 95,30 }, },
	#endif
	#if (ARUCO_DB_SIZE > 973)
		{ { 239,80 }, { 108,236 }, { 10,247 }, { 55,54 }, },
	#endif
	#if (ARUCO_DB_SIZE > 974)
		{ { 244,34 }, { 139,200 }, { 68,47 }, { 19,209 }, },
	#endif
	#if (ARUCO_DB_SIZE > 975)
		{ { 244,137 }, { 152,203 }, { 145,47 }, { 211,25 }, },
	#endif
	#if (ARUCO_DB_SIZE > 976)
		{ { 244,41 }, { 154,201 }, { 148,47 }, { 147,89 }, },
	#endif
	#if (ARUCO_DB_SIZE > 977)
		{ { 246,106 }, { 143,233 }, { 86,111 }, { 151,241 }, },
	#endif
	#if (ARUCO_DB_SIZE > 978)
		{ { 254,11 }, { 157,205 }, { 208,127 }, { 179,185 }, },
	#endif
	#if (ARUCO_DB_SIZE > 979)
		{ { 254,111 }, { 159,253 }, { 246,127 }, { 191,249 }, },
	#endif
	#if (ARUCO_DB_SIZE > 980)
		{ { 244,149 }, { 184,218 }, { 169,47 }, { 91,29 }, },
	#endif
	#if (ARUCO_DB_SIZE > 981)
		{ { 244,53 }, { 186,216 }, { 172,47 }, { 27,93 }, },
	#endif
	#if (ARUCO_DB_SIZE > 982)
		{ { 244,31 }, { 185,217 }, { 248,47 }, { 155,157 }, },
	#endif
	#if (ARUCO_DB_SIZE > 983)
		{ { 246,176 }, { 174,202 }, { 13,111 }, { 83,117 }, },
	#endif
	#if (ARUCO_DB_SIZE > 984)
		{ { 245,232 }, { 202,235 }, { 23,175 }, { 215,83 }, },
	#endif
	#if (ARUCO_DB_SIZE > 985)
		{ { 245,197 }, { 216,250 }, { 163,175 }, { 95,27 }, },
	#endif
	#if (ARUCO_DB_SIZE > 986)
		{ { 253,35 }, { 219,204 }, { 196,191 }, { 51,219 }, },
	#endif
	#if (ARUCO_DB_SIZE > 987)
		{ { 255,192 }, { 204,238 }, { 3,255 }, { 119,51 }, },
	#endif
	#if (ARUCO_DB_SIZE > 988)
		{ { 247,204 }, { 204,251 }, { 51,239 }, { 223,51 }, },
	#endif
	#if (ARUCO_DB_SIZE > 989)
		{ { 247,233 }, { 222,235 }, { 151,239 }, { 215,123 }, },
	#endif
	#if (ARUCO_DB_SIZE > 990)
		{ { 245,188 }, { 234,219 }, { 61,175 }, { 219,87 }, },
	#endif
	#if (ARUCO_DB_SIZE > 991)
		{ { 253,246 }, { 235,254 }, { 111,191 }, { 127,215 }, },
	#endif
	#if (ARUCO_DB_SIZE > 992)
		{ { 245,217 }, { 248,235 }, { 155,175 }, { 215,31 }, },
	#endif
	#if (ARUCO_DB_SIZE > 993)
		{ { 253,151 }, { 249,222 }, { 233,191 }, { 123,159 }, },
	#endif
	#if (ARUCO_DB_SIZE > 994)
		{ { 253,63 }, { 251,221 }, { 252,191 }, { 187,223 }, },
	#endif
	#if (ARUCO_DB_SIZE > 995)
		{ { 255,156 }, { 236,223 }, { 57,255 }, { 251,55 }, },
	#endif
	#if (ARUCO_DB_SIZE > 996)
		{ { 255,90 }, { 237,237 }, { 90,255 }, { 183,183 }, },
	#endif
	#if (ARUCO_DB_SIZE > 997)
		{ { 247,254 }, { 239,251 }, { 127,239 }, { 223,247 }, },
	#endif
	#if (ARUCO_DB_SIZE > 998)
		{ { 255,17 }, { 252,204 }, { 136,255 }, { 51,63 }, },
	#endif
	#if (ARUCO_DB_SIZE > 999)
		{ { 247,191 }, { 255,219 }, { 253,239 }, { 219,255 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1000)
	#error invalid ARUCO_DB_SIZE, max database size for this aruco type is 1000
	#endif

};

#elif (ARUCO_DB == ARUCO_DB_5X5_1000)

#ifndef ARUCO_DB_SIZE
#define ARUCO_DB_SIZE 1000
#endif

#define ARUCO_BITS	5

static unsigned char database[ARUCO_DB_SIZE][4][4] = {
	#if (ARUCO_DB_SIZE > 0)
		{ { 162,217,94,0 }, { 82,46,217,1 }, { 61,77,162,1 }, { 205,186,37,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1)
		{ { 14,3,115,0 }, { 176,198,133,0 }, { 103,96,56,0 }, { 80,177,134,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2)
		{ { 215,135,110,1 }, { 47,151,157,1 }, { 187,112,245,1 }, { 220,244,250,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 3)
		{ { 129,202,251,1 }, { 122,222,40,1 }, { 239,169,192,1 }, { 138,61,175,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 4)
		{ { 215,90,146,0 }, { 116,27,236,0 }, { 36,173,117,1 }, { 27,236,23,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 5)
		{ { 234,4,22,1 }, { 153,35,152,0 }, { 180,16,43,1 }, { 12,226,76,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 6)
		{ { 105,235,246,0 }, { 242,191,51,0 }, { 55,235,203,0 }, { 102,126,167,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 7)
		{ { 113,10,53,1 }, { 60,249,16,0 }, { 214,40,71,0 }, { 4,79,158,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 8)
		{ { 134,176,153,0 }, { 18,64,238,1 }, { 76,134,176,1 }, { 187,129,36,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 9)
		{ { 152,159,210,1 }, { 191,14,105,0 }, { 165,252,140,1 }, { 75,56,126,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 10)
		{ { 158,119,1,1 }, { 237,64,207,0 }, { 192,119,60,1 }, { 121,129,91,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 11)
		{ { 209,109,96,0 }, { 69,157,11,0 }, { 3,91,69,1 }, { 104,92,209,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 12)
		{ { 243,21,136,1 }, { 13,49,233,1 }, { 136,212,103,1 }, { 203,198,88,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 13)
		{ { 47,56,179,0 }, { 144,250,230,0 }, { 102,142,122,0 }, { 51,175,132,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 14)
		{ { 254,126,84,0 }, { 245,45,222,0 }, { 21,63,63,1 }, { 61,218,87,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 15)
		{ { 40,241,191,1 }, { 218,226,115,1 }, { 254,199,138,0 }, { 231,35,173,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 16)
		{ { 75,211,172,0 }, { 226,145,241,1 }, { 26,229,233,0 }, { 199,196,163,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 17)
		{ { 95,81,55,1 }, { 220,211,213,0 }, { 246,69,125,0 }, { 85,229,157,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 18)
		{ { 123,38,226,0 }, { 165,183,162,0 }, { 35,178,111,0 }, { 34,246,210,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 19)
		{ { 131,14,244,0 }, { 49,156,184,0 }, { 23,184,96,1 }, { 14,156,198,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 20)
		{ { 150,237,58,1 }, { 95,138,143,1 }, { 174,91,180,1 }, { 248,168,253,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 21)
		{ { 168,114,32,0 }, { 224,160,74,0 }, { 2,39,10,1 }, { 41,2,131,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 22)
		{ { 181,134,80,1 }, { 63,52,12,0 }, { 133,48,214,1 }, { 24,22,126,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 23)
		{ { 93,9,111,0 }, { 132,223,21,1 }, { 123,72,93,0 }, { 212,125,144,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 24)
		{ { 206,104,17,1 }, { 216,73,142,0 }, { 196,11,57,1 }, { 56,201,13,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 25)
		{ { 210,204,185,0 }, { 87,201,168,1 }, { 78,153,165,1 }, { 138,201,245,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 26)
		{ { 225,231,69,1 }, { 107,117,27,0 }, { 209,115,195,1 }, { 108,87,107,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 27)
		{ { 17,33,35,0 }, { 4,210,3,0 }, { 98,66,68,0 }, { 96,37,144,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 28)
		{ { 29,203,57,0 }, { 246,216,5,1 }, { 78,105,220,0 }, { 208,13,183,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 29)
		{ { 18,17,29,1 }, { 28,64,209,1 }, { 220,68,36,0 }, { 197,129,28,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 30)
		{ { 19,155,183,0 }, { 54,218,241,0 }, { 118,236,228,0 }, { 71,173,182,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 31)
		{ { 27,68,57,1 }, { 221,208,128,1 }, { 206,17,108,0 }, { 128,133,221,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 32)
		{ { 32,104,103,0 }, { 64,238,18,0 }, { 115,11,2,0 }, { 36,59,129,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 33)
		{ { 37,85,100,0 }, { 65,180,85,0 }, { 19,85,82,0 }, { 85,22,193,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 34)
		{ { 35,33,221,0 }, { 16,116,179,1 }, { 93,194,98,0 }, { 230,151,4,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 35)
		{ { 61,55,245,0 }, { 181,244,119,0 }, { 87,246,94,0 }, { 119,23,214,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 36)
		{ { 76,197,86,0 }, { 211,7,21,0 }, { 53,81,153,0 }, { 84,112,101,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 37)
		{ { 65,104,128,1 }, { 72,25,34,0 }, { 128,139,65,0 }, { 34,76,9,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 38)
		{ { 77,86,142,1 }, { 233,19,116,1 }, { 184,181,89,0 }, { 151,100,75,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 39)
		{ { 67,30,57,0 }, { 49,217,192,1 }, { 78,60,97,0 }, { 129,205,198,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 40)
		{ { 86,148,18,1 }, { 31,3,196,0 }, { 164,20,181,0 }, { 17,224,124,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 41)
		{ { 82,151,207,0 }, { 39,71,241,1 }, { 121,244,165,0 }, { 199,241,114,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 42)
		{ { 108,36,251,1 }, { 153,231,38,1 }, { 239,146,27,0 }, { 178,115,204,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 43)
		{ { 97,132,236,1 }, { 11,181,48,1 }, { 155,144,195,0 }, { 134,86,232,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 44)
		{ { 109,63,24,1 }, { 185,57,71,1 }, { 140,126,91,0 }, { 241,78,78,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 45)
		{ { 116,177,61,0 }, { 22,225,87,1 }, { 94,70,151,0 }, { 245,67,180,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 46)
		{ { 116,220,203,1 }, { 79,111,100,1 }, { 233,157,151,0 }, { 147,123,121,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 47)
		{ { 124,164,3,0 }, { 135,99,6,0 }, { 96,18,159,0 }, { 48,99,112,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 48)
		{ { 122,200,146,1 }, { 222,43,160,0 }, { 164,137,175,0 }, { 2,234,61,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 49)
		{ { 123,91,235,1 }, { 236,255,225,1 }, { 235,237,111,0 }, { 195,255,155,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 50)
		{ { 141,172,114,0 }, { 147,158,14,0 }, { 39,26,216,1 }, { 56,60,228,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 51)
		{ { 141,105,60,1 }, { 216,152,31,1 }, { 158,75,88,1 }, { 252,12,141,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 52)
		{ { 143,28,5,1 }, { 137,88,220,0 }, { 208,28,120,1 }, { 29,141,72,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 53)
		{ { 139,74,34,1 }, { 232,154,136,0 }, { 162,41,104,1 }, { 8,172,139,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 54)
		{ { 151,253,165,0 }, { 71,216,255,0 }, { 82,223,244,1 }, { 127,141,241,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 55)
		{ { 172,101,198,1 }, { 201,38,63,0 }, { 177,211,26,1 }, { 126,50,73,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 56)
		{ { 172,195,248,0 }, { 242,164,45,1 }, { 15,225,154,1 }, { 218,18,167,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 57)
		{ { 161,23,239,1 }, { 41,246,121,1 }, { 251,244,66,1 }, { 207,55,202,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 58)
		{ { 167,9,19,1 }, { 24,122,141,0 }, { 228,72,114,1 }, { 88,175,12,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 59)
		{ { 171,111,145,0 }, { 241,120,171,0 }, { 68,251,106,1 }, { 106,143,71,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 60)
		{ { 185,237,248,1 }, { 223,188,43,1 }, { 143,219,206,1 }, { 234,30,253,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 61)
		{ { 178,100,158,0 }, { 85,34,186,1 }, { 60,147,38,1 }, { 174,162,85,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 62)
		{ { 190,93,195,0 }, { 197,110,237,0 }, { 97,221,62,1 }, { 91,187,81,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 63)
		{ { 196,5,67,1 }, { 9,71,13,0 }, { 225,80,17,1 }, { 88,113,72,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 64)
		{ { 200,163,238,1 }, { 170,135,59,1 }, { 187,226,137,1 }, { 238,112,170,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 65)
		{ { 194,117,197,0 }, { 65,69,251,0 }, { 81,215,33,1 }, { 111,209,65,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 66)
		{ { 198,194,214,1 }, { 122,7,188,0 }, { 181,161,177,1 }, { 30,240,47,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 67)
		{ { 217,102,212,1 }, { 253,21,58,0 }, { 149,179,77,1 }, { 46,84,95,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 68)
		{ { 221,94,185,1 }, { 253,217,108,1 }, { 206,189,93,1 }, { 155,77,223,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 69)
		{ { 244,234,25,0 }, { 118,105,14,1 }, { 76,43,151,1 }, { 184,75,55,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 70)
		{ { 243,178,148,0 }, { 54,49,250,0 }, { 20,166,231,1 }, { 47,198,54,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 71)
		{ { 122,186,5,0 }, { 166,105,210,0 }, { 80,46,175,0 }, { 37,203,50,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 72)
		{ { 216,141,41,1 }, { 143,201,9,1 }, { 202,88,141,1 }, { 200,73,248,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 73)
		{ { 12,103,50,1 }, { 249,130,7,0 }, { 166,115,24,0 }, { 112,32,207,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 74)
		{ { 21,89,12,1 }, { 76,24,85,1 }, { 152,77,84,0 }, { 213,12,25,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 75)
		{ { 76,116,192,1 }, { 201,5,102,0 }, { 129,151,25,0 }, { 51,80,73,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 76)
		{ { 84,3,14,0 }, { 36,3,21,1 }, { 56,96,21,0 }, { 212,96,18,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 77)
		{ { 160,208,172,0 }, { 66,160,120,1 }, { 26,133,130,1 }, { 143,2,161,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 78)
		{ { 194,152,166,0 }, { 2,139,248,0 }, { 50,140,161,1 }, { 15,232,160,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 79)
		{ { 203,104,150,0 }, { 208,27,186,0 }, { 52,139,105,1 }, { 46,236,5,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 80)
		{ { 253,105,209,0 }, { 212,125,47,0 }, { 69,203,95,1 }, { 122,95,21,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 81)
		{ { 4,145,90,1 }, { 26,6,69,1 }, { 173,68,144,0 }, { 209,48,44,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 82)
		{ { 12,222,112,0 }, { 243,140,68,0 }, { 7,61,152,0 }, { 17,24,231,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 83)
		{ { 5,170,62,0 }, { 50,154,22,1 }, { 62,42,208,0 }, { 180,44,166,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 84)
		{ { 1,99,183,1 }, { 120,210,51,0 }, { 246,227,64,0 }, { 102,37,143,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 85)
		{ { 9,145,68,1 }, { 138,20,81,0 }, { 145,68,200,0 }, { 69,20,40,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 86)
		{ { 9,105,83,1 }, { 216,94,3,0 }, { 229,75,72,0 }, { 96,61,13,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 87)
		{ { 6,37,161,1 }, { 9,192,167,0 }, { 194,210,48,0 }, { 114,129,200,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 88)
		{ { 3,61,226,1 }, { 9,158,227,0 }, { 163,222,96,0 }, { 99,188,200,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 89)
		{ { 7,213,6,1 }, { 75,18,213,0 }, { 176,85,240,0 }, { 85,164,105,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 90)
		{ { 15,143,170,0 }, { 163,154,165,1 }, { 42,248,248,0 }, { 210,172,226,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 91)
		{ { 28,116,60,1 }, { 221,128,86,1 }, { 158,23,28,0 }, { 181,0,221,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 92)
		{ { 25,29,145,1 }, { 157,88,97,0 }, { 196,220,76,0 }, { 67,13,92,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 93)
		{ { 22,27,35,1 }, { 44,202,197,0 }, { 226,108,52,0 }, { 81,169,154,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 94)
		{ { 22,210,141,1 }, { 110,64,244,1 }, { 216,165,180,0 }, { 151,129,59,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 95)
		{ { 23,78,198,1 }, { 109,30,180,0 }, { 177,185,116,0 }, { 22,188,91,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 96)
		{ { 19,226,177,0 }, { 118,208,162,0 }, { 70,163,228,0 }, { 34,133,183,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 97)
		{ { 31,126,250,1 }, { 253,158,230,1 }, { 175,191,124,0 }, { 179,188,223,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 98)
		{ { 41,15,112,0 }, { 177,188,1,0 }, { 7,120,74,0 }, { 64,30,198,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 99)
		{ { 34,71,126,1 }, { 121,166,145,1 }, { 191,113,34,0 }, { 196,178,207,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 100)
		{ { 42,23,192,1 }, { 169,36,225,0 }, { 129,244,42,0 }, { 67,146,74,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 101)
		{ { 42,251,100,1 }, { 234,172,211,0 }, { 147,111,170,0 }, { 101,154,171,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 102)
		{ { 35,240,4,0 }, { 66,48,210,0 }, { 16,7,226,0 }, { 37,134,33,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 103)
		{ { 39,205,252,0 }, { 83,188,181,1 }, { 31,217,242,0 }, { 214,158,229,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 104)
		{ { 35,106,172,0 }, { 96,184,178,1 }, { 26,171,98,0 }, { 166,142,131,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 105)
		{ { 47,123,47,0 }, { 224,250,215,1 }, { 122,111,122,0 }, { 245,175,131,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 106)
		{ { 52,144,196,0 }, { 6,36,116,0 }, { 17,132,150,0 }, { 23,18,48,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 107)
		{ { 48,9,214,1 }, { 28,46,49,0 }, { 181,200,6,0 }, { 70,58,28,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 108)
		{ { 52,94,16,1 }, { 125,40,68,0 }, { 132,61,22,0 }, { 17,10,95,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 109)
		{ { 57,82,232,0 }, { 228,180,96,1 }, { 11,165,78,0 }, { 131,22,147,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 110)
		{ { 50,0,113,0 }, { 20,228,128,0 }, { 71,0,38,0 }, { 0,147,148,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 111)
		{ { 54,231,29,0 }, { 119,96,151,1 }, { 92,115,182,0 }, { 244,131,119,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 112)
		{ { 68,138,4,1 }, { 42,9,20,0 }, { 144,40,145,0 }, { 20,72,42,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 113)
		{ { 68,236,254,1 }, { 91,143,54,1 }, { 191,155,145,0 }, { 182,120,237,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 114)
		{ { 69,31,114,1 }, { 57,159,69,0 }, { 167,124,81,0 }, { 81,124,206,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 115)
		{ { 69,74,149,0 }, { 112,89,52,0 }, { 84,169,81,0 }, { 22,77,7,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 116)
		{ { 70,19,190,1 }, { 56,131,245,1 }, { 190,228,49,0 }, { 215,224,142,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 117)
		{ { 78,131,9,0 }, { 162,65,133,1 }, { 72,96,185,0 }, { 208,193,34,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 118)
		{ { 71,114,153,1 }, { 120,81,230,1 }, { 204,167,113,0 }, { 179,197,15,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 119)
		{ { 79,130,125,1 }, { 186,213,148,1 }, { 223,32,249,0 }, { 148,213,174,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 120)
		{ { 92,55,141,1 }, { 173,65,119,1 }, { 216,246,29,0 }, { 247,65,90,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 121)
		{ { 88,253,119,0 }, { 215,207,83,0 }, { 119,95,141,0 }, { 101,121,245,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 122)
		{ { 81,183,248,0 }, { 55,149,99,1 }, { 15,246,197,0 }, { 227,84,246,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 123)
		{ { 89,58,251,0 }, { 180,223,98,1 }, { 111,174,77,0 }, { 163,125,150,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 124)
		{ { 90,153,153,0 }, { 150,73,225,1 }, { 76,204,173,0 }, { 195,201,52,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 125)
		{ { 83,1,240,1 }, { 28,149,161,0 }, { 135,192,101,0 }, { 66,212,156,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 126)
		{ { 83,204,103,1 }, { 79,223,144,0 }, { 243,25,229,0 }, { 4,253,249,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 127)
		{ { 83,110,1,0 }, { 101,89,130,0 }, { 64,59,101,0 }, { 32,205,83,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 128)
		{ { 91,37,175,1 }, { 141,211,179,1 }, { 250,210,109,0 }, { 230,229,216,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 129)
		{ { 95,213,204,1 }, { 207,21,245,1 }, { 153,213,253,0 }, { 215,212,121,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 130)
		{ { 101,102,66,1 }, { 105,55,6,0 }, { 161,51,83,0 }, { 48,118,75,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 131)
		{ { 101,199,175,0 }, { 99,243,53,1 }, { 122,241,211,0 }, { 214,103,227,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 132)
		{ { 102,55,81,0 }, { 49,101,199,0 }, { 69,118,51,0 }, { 113,211,70,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 133)
		{ { 103,12,197,1 }, { 9,125,180,0 }, { 209,152,115,0 }, { 22,223,72,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 134)
		{ { 112,150,93,1 }, { 63,101,80,1 }, { 221,52,135,0 }, { 133,83,126,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 135)
		{ { 124,99,128,1 }, { 236,33,39,0 }, { 128,227,31,0 }, { 114,66,27,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 136)
		{ { 121,171,169,0 }, { 166,249,35,1 }, { 74,234,207,0 }, { 226,79,178,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 137)
		{ { 114,61,70,0 }, { 5,47,211,0 }, { 49,94,39,0 }, { 101,250,80,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 138)
		{ { 115,229,178,1 }, { 95,179,163,0 }, { 166,211,231,0 }, { 98,230,253,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 139)
		{ { 132,38,140,0 }, { 33,0,62,1 }, { 24,178,16,1 }, { 190,0,66,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 140)
		{ { 137,241,1,0 }, { 194,80,75,0 }, { 64,71,200,1 }, { 105,5,33,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 141)
		{ { 134,174,233,1 }, { 43,204,174,1 }, { 203,186,176,1 }, { 186,153,234,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 142)
		{ { 138,35,249,1 }, { 184,196,171,1 }, { 207,226,40,1 }, { 234,145,142,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 143)
		{ { 148,53,113,1 }, { 29,196,79,0 }, { 199,86,20,1 }, { 121,17,220,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 144)
		{ { 156,69,27,0 }, { 213,66,13,1 }, { 108,81,28,1 }, { 216,33,85,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 145)
		{ { 149,31,164,1 }, { 45,152,125,0 }, { 146,252,84,1 }, { 95,12,218,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 146)
		{ { 150,141,144,0 }, { 23,8,173,0 }, { 4,216,180,1 }, { 90,136,116,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 147)
		{ { 151,38,183,0 }, { 53,210,190,0 }, { 118,178,116,1 }, { 62,165,214,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 148)
		{ { 155,55,103,0 }, { 165,214,219,0 }, { 115,118,108,1 }, { 109,181,210,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 149)
		{ { 155,198,224,1 }, { 239,148,168,0 }, { 131,177,236,1 }, { 10,148,251,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 150)
		{ { 160,154,110,1 }, { 42,174,88,1 }, { 187,44,130,1 }, { 141,58,170,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 151)
		{ { 164,82,134,1 }, { 104,34,124,0 }, { 176,165,18,1 }, { 31,34,11,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 152)
		{ { 168,176,133,1 }, { 138,96,122,0 }, { 208,134,138,1 }, { 47,3,40,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 153)
		{ { 173,155,66,0 }, { 162,62,77,0 }, { 33,108,218,1 }, { 89,62,34,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 154)
		{ { 175,240,88,1 }, { 218,52,206,1 }, { 141,7,250,1 }, { 185,150,45,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 155)
		{ { 176,46,99,1 }, { 45,238,10,0 }, { 227,58,6,1 }, { 40,59,218,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 156)
		{ { 176,15,24,0 }, { 53,40,9,1 }, { 12,120,6,1 }, { 200,10,86,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 157)
		{ { 188,234,178,1 }, { 254,170,46,0 }, { 166,171,158,1 }, { 58,42,191,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 158)
		{ { 190,196,76,1 }, { 207,36,156,1 }, { 153,17,190,1 }, { 156,146,121,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 159)
		{ { 179,130,250,0 }, { 54,182,168,1 }, { 47,160,230,1 }, { 138,182,182,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 160)
		{ { 179,88,60,1 }, { 92,184,216,1 }, { 158,13,102,1 }, { 141,142,157,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 161)
		{ { 191,69,238,0 }, { 197,182,189,1 }, { 59,209,126,1 }, { 222,182,209,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 162)
		{ { 191,86,51,1 }, { 253,242,204,0 }, { 230,53,126,1 }, { 25,167,223,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 163)
		{ { 196,58,240,0 }, { 48,141,110,0 }, { 7,174,17,1 }, { 59,88,134,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 164)
		{ { 204,233,131,0 }, { 194,75,47,0 }, { 96,203,153,1 }, { 122,105,33,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 165)
		{ { 197,51,0,1 }, { 40,17,79,0 }, { 128,102,81,1 }, { 121,68,10,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 166)
		{ { 205,34,99,1 }, { 168,215,14,0 }, { 227,34,89,1 }, { 56,117,138,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 167)
		{ { 198,8,138,1 }, { 8,11,172,1 }, { 168,136,49,1 }, { 154,232,8,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 168)
		{ { 198,148,63,0 }, { 19,195,220,1 }, { 126,20,177,1 }, { 157,225,228,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 169)
		{ { 202,238,132,1 }, { 235,9,186,0 }, { 144,187,169,1 }, { 46,200,107,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 170)
		{ { 207,167,18,1 }, { 187,19,143,0 }, { 164,114,249,1 }, { 120,228,110,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 171)
		{ { 203,97,226,1 }, { 200,151,171,0 }, { 163,195,105,1 }, { 106,244,137,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 172)
		{ { 208,2,233,0 }, { 36,197,40,1 }, { 75,160,5,1 }, { 138,81,146,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 173)
		{ { 220,183,70,0 }, { 167,7,95,0 }, { 49,118,157,1 }, { 125,112,114,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 174)
		{ { 217,139,132,1 }, { 174,25,57,0 }, { 144,232,205,1 }, { 78,76,58,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 175)
		{ { 217,206,178,0 }, { 247,155,40,0 }, { 38,185,205,1 }, { 10,108,247,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 176)
		{ { 210,153,64,1 }, { 14,13,201,0 }, { 129,76,165,1 }, { 73,216,56,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 177)
		{ { 210,209,23,0 }, { 86,67,217,0 }, { 116,69,165,1 }, { 77,225,53,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 178)
		{ { 222,90,110,1 }, { 236,143,220,1 }, { 187,45,61,1 }, { 157,248,155,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 179)
		{ { 218,71,66,1 }, { 237,7,137,0 }, { 161,113,45,1 }, { 72,240,91,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 180)
		{ { 219,60,16,0 }, { 149,25,202,0 }, { 4,30,109,1 }, { 41,204,84,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 181)
		{ { 219,143,201,0 }, { 167,93,169,1 }, { 73,248,237,1 }, { 202,221,114,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 182)
		{ { 232,24,227,1 }, { 136,239,104,0 }, { 227,140,11,1 }, { 11,123,136,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 183)
		{ { 229,28,111,0 }, { 1,255,92,1 }, { 123,28,83,1 }, { 157,127,192,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 184)
		{ { 225,174,56,1 }, { 59,185,10,1 }, { 142,58,195,1 }, { 168,78,238,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 185)
		{ { 237,185,123,1 }, { 154,255,79,1 }, { 239,78,219,1 }, { 249,127,172,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 186)
		{ { 233,224,50,0 }, { 210,179,10,0 }, { 38,3,203,1 }, { 40,102,165,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 187)
		{ { 235,93,12,0 }, { 193,57,217,1 }, { 24,93,107,1 }, { 205,206,65,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 188)
		{ { 239,249,157,0 }, { 210,121,255,1 }, { 92,207,251,1 }, { 255,207,37,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 189)
		{ { 248,17,1,0 }, { 132,97,73,0 }, { 64,68,15,1 }, { 73,67,16,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 190)
		{ { 248,7,211,0 }, { 181,103,41,0 }, { 101,240,15,1 }, { 74,115,86,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 191)
		{ { 246,2,32,1 }, { 44,161,140,0 }, { 130,32,55,1 }, { 24,194,154,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 192)
		{ { 246,27,95,1 }, { 60,111,221,1 }, { 253,108,55,1 }, { 221,251,30,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 193)
		{ { 254,181,237,0 }, { 135,229,255,1 }, { 91,214,191,1 }, { 255,211,240,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 194)
		{ { 250,51,56,1 }, { 188,161,203,1 }, { 142,102,47,1 }, { 233,194,158,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 195)
		{ { 250,74,193,1 }, { 236,109,168,0 }, { 193,169,47,1 }, { 10,219,27,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 196)
		{ { 247,47,112,1 }, { 61,189,143,0 }, { 135,122,119,1 }, { 120,222,222,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 197)
		{ { 247,234,252,1 }, { 126,189,190,1 }, { 159,171,247,1 }, { 190,222,191,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 198)
		{ { 255,24,148,1 }, { 156,57,252,0 }, { 148,140,127,1 }, { 31,206,28,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 199)
		{ { 251,163,94,0 }, { 182,55,155,1 }, { 61,98,239,1 }, { 236,246,54,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 200)
		{ { 104,184,47,0 }, { 130,235,82,1 }, { 122,14,139,0 }, { 165,107,160,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 201)
		{ { 153,15,11,1 }, { 173,90,9,1 }, { 232,120,76,1 }, { 200,45,90,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 202)
		{ { 153,216,38,1 }, { 206,154,88,0 }, { 178,13,204,1 }, { 13,44,185,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 203)
		{ { 228,95,14,1 }, { 105,43,93,1 }, { 184,125,19,1 }, { 221,106,75,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 204)
		{ { 29,16,110,1 }, { 140,150,84,1 }, { 187,4,92,0 }, { 149,52,152,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 205)
		{ { 42,193,48,1 }, { 218,160,129,0 }, { 134,65,170,0 }, { 64,130,173,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 206)
		{ { 52,65,99,1 }, { 76,230,5,0 }, { 227,65,22,0 }, { 80,51,153,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 207)
		{ { 55,192,116,1 }, { 94,180,148,0 }, { 151,1,246,0 }, { 20,150,189,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 208)
		{ { 63,53,203,1 }, { 141,118,231,1 }, { 233,214,126,0 }, { 243,183,88,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 209)
		{ { 86,160,76,0 }, { 6,5,150,1 }, { 25,2,181,0 }, { 180,208,48,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 210)
		{ { 87,56,57,1 }, { 28,217,198,1 }, { 206,14,117,0 }, { 177,205,156,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 211)
		{ { 102,152,184,0 }, { 18,169,228,1 }, { 14,140,179,0 }, { 147,202,164,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 212)
		{ { 115,165,23,0 }, { 23,115,147,0 }, { 116,82,231,0 }, { 100,231,116,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 213)
		{ { 127,44,253,1 }, { 157,253,182,1 }, { 223,154,127,0 }, { 182,223,220,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 214)
		{ { 139,71,233,0 }, { 225,212,169,1 }, { 75,241,104,1 }, { 202,149,195,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 215)
		{ { 165,195,151,0 }, { 114,114,61,0 }, { 116,225,210,1 }, { 94,39,39,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 216)
		{ { 169,169,235,0 }, { 130,254,43,1 }, { 107,202,202,1 }, { 234,63,160,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 217)
		{ { 181,25,183,0 }, { 20,250,125,0 }, { 118,204,86,1 }, { 95,47,148,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 218)
		{ { 178,218,153,1 }, { 126,104,232,1 }, { 204,173,166,1 }, { 139,139,63,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 219)
		{ { 196,193,244,0 }, { 82,133,61,0 }, { 23,193,145,1 }, { 94,80,165,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 220)
		{ { 202,185,30,0 }, { 146,11,219,1 }, { 60,78,169,1 }, { 237,232,36,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 221)
		{ { 216,111,163,1 }, { 237,203,43,0 }, { 226,251,13,1 }, { 106,105,219,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 222)
		{ { 223,141,142,0 }, { 135,27,189,1 }, { 56,216,253,1 }, { 222,236,112,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 223)
		{ { 229,102,143,1 }, { 105,115,62,1 }, { 248,179,83,1 }, { 190,103,75,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 224)
		{ { 237,71,26,1 }, { 249,51,13,1 }, { 172,113,91,1 }, { 216,102,79,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 225)
		{ { 240,103,134,1 }, { 109,35,59,0 }, { 176,243,7,1 }, { 110,98,91,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 226)
		{ { 4,41,238,1 }, { 8,142,55,1 }, { 187,202,16,0 }, { 246,56,136,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 227)
		{ { 0,35,71,1 }, { 40,70,19,0 }, { 241,98,0,0 }, { 100,49,10,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 228)
		{ { 0,162,251,0 }, { 50,198,34,1 }, { 111,162,128,0 }, { 162,49,166,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 229)
		{ { 4,200,206,0 }, { 66,14,52,1 }, { 57,137,144,0 }, { 150,56,33,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 230)
		{ { 0,210,225,1 }, { 106,196,96,0 }, { 195,165,128,0 }, { 3,17,171,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 231)
		{ { 12,10,15,0 }, { 160,74,20,1 }, { 120,40,24,0 }, { 148,41,2,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 232)
		{ { 8,139,198,0 }, { 162,14,49,0 }, { 49,232,136,0 }, { 70,56,34,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 233)
		{ { 12,134,91,0 }, { 179,70,4,1 }, { 109,48,152,0 }, { 144,49,102,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 234)
		{ { 5,129,253,0 }, { 18,212,53,1 }, { 95,192,208,0 }, { 214,21,164,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 235)
		{ { 1,113,30,0 }, { 80,18,83,1 }, { 60,71,64,0 }, { 229,36,5,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 236)
		{ { 1,194,21,1 }, { 122,80,16,0 }, { 212,33,192,0 }, { 4,5,47,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 237)
		{ { 1,231,113,0 }, { 115,212,3,0 }, { 71,115,192,0 }, { 96,21,231,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 238)
		{ { 9,41,191,0 }, { 144,218,51,1 }, { 126,202,72,0 }, { 230,45,132,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 239)
		{ { 13,16,27,1 }, { 152,82,68,1 }, { 236,4,88,0 }, { 145,37,12,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 240)
		{ { 13,5,24,0 }, { 145,16,5,1 }, { 12,80,88,0 }, { 208,4,68,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 241)
		{ { 13,237,47,1 }, { 203,218,23,1 }, { 250,91,216,0 }, { 244,45,233,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 242)
		{ { 13,102,222,0 }, { 241,22,54,1 }, { 61,179,88,0 }, { 182,52,71,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 243)
		{ { 9,242,118,0 }, { 242,150,82,0 }, { 55,39,200,0 }, { 37,52,167,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 244)
		{ { 2,208,130,1 }, { 74,2,224,0 }, { 160,133,160,0 }, { 3,160,41,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 245)
		{ { 2,98,201,0 }, { 96,68,162,1 }, { 73,163,32,0 }, { 162,145,3,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 246)
		{ { 6,243,169,0 }, { 98,192,231,1 }, { 74,231,176,0 }, { 243,129,163,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 247)
		{ { 6,239,35,0 }, { 99,202,135,0 }, { 98,123,176,0 }, { 112,169,227,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 248)
		{ { 14,62,18,0 }, { 177,10,198,0 }, { 36,62,56,0 }, { 49,168,70,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 249)
		{ { 10,154,221,1 }, { 186,76,240,1 }, { 221,172,168,0 }, { 135,153,46,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 250)
		{ { 10,97,109,1 }, { 200,196,147,1 }, { 219,67,40,0 }, { 228,145,137,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 251)
		{ { 10,255,81,0 }, { 243,76,195,0 }, { 69,127,168,0 }, { 97,153,103,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 252)
		{ { 7,230,114,1 }, { 123,150,134,0 }, { 167,51,240,0 }, { 48,180,239,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 253)
		{ { 11,154,1,0 }, { 162,88,192,0 }, { 64,44,232,0 }, { 1,141,34,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 254)
		{ { 15,208,142,0 }, { 194,18,244,1 }, { 56,133,248,0 }, { 151,164,33,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 255)
		{ { 15,73,147,0 }, { 208,90,165,0 }, { 100,201,120,0 }, { 82,173,5,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 256)
		{ { 15,247,123,0 }, { 243,214,199,1 }, { 111,119,248,0 }, { 241,181,231,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 257)
		{ { 16,158,96,1 }, { 47,140,64,0 }, { 131,60,132,0 }, { 1,24,250,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 258)
		{ { 16,81,237,0 }, { 68,196,113,1 }, { 91,197,4,0 }, { 199,17,145,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 259)
		{ { 20,122,222,1 }, { 124,14,118,1 }, { 189,175,20,0 }, { 183,56,31,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 260)
		{ { 28,133,62,1 }, { 159,130,21,1 }, { 190,80,156,0 }, { 212,32,252,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 261)
		{ { 28,35,104,0 }, { 164,132,7,1 }, { 11,98,28,0 }, { 240,16,146,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 262)
		{ { 24,199,52,0 }, { 247,128,17,0 }, { 22,113,140,0 }, { 68,0,247,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 263)
		{ { 21,251,130,1 }, { 110,26,103,0 }, { 160,239,212,0 }, { 115,44,59,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 264)
		{ { 17,78,147,1 }, { 125,90,32,0 }, { 228,185,68,0 }, { 2,45,95,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 265)
		{ { 25,160,234,1 }, { 142,150,34,1 }, { 171,130,204,0 }, { 162,52,184,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 266)
		{ { 18,24,76,0 }, { 4,12,208,1 }, { 25,12,36,0 }, { 133,152,16,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 267)
		{ { 18,163,174,0 }, { 38,130,179,1 }, { 58,226,164,0 }, { 230,160,178,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 268)
		{ { 30,172,60,0 }, { 151,136,150,1 }, { 30,26,188,0 }, { 180,136,244,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 269)
		{ { 30,201,108,0 }, { 198,140,149,1 }, { 27,73,188,0 }, { 212,152,177,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 270)
		{ { 30,233,163,1 }, { 206,202,167,0 }, { 226,203,188,0 }, { 114,169,185,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 271)
		{ { 26,118,216,0 }, { 245,4,226,1 }, { 13,183,44,0 }, { 163,144,87,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 272)
		{ { 19,182,7,1 }, { 47,82,210,0 }, { 240,54,228,0 }, { 37,165,122,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 273)
		{ { 23,70,188,0 }, { 117,144,180,1 }, { 30,177,116,0 }, { 150,132,215,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 274)
		{ { 31,21,121,0 }, { 149,212,197,1 }, { 79,84,124,0 }, { 209,149,212,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 275)
		{ { 27,35,125,0 }, { 180,212,147,1 }, { 95,98,108,0 }, { 228,149,150,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 276)
		{ { 27,191,146,0 }, { 183,26,227,0 }, { 36,254,236,0 }, { 99,172,118,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 277)
		{ { 31,150,154,1 }, { 191,18,228,1 }, { 172,180,252,0 }, { 147,164,126,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 278)
		{ { 27,72,235,0 }, { 196,222,160,1 }, { 107,137,108,0 }, { 130,189,145,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 279)
		{ { 32,12,253,0 }, { 17,236,48,1 }, { 95,152,2,0 }, { 134,27,196,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 280)
		{ { 32,23,86,0 }, { 49,38,81,0 }, { 53,116,2,0 }, { 69,50,70,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 281)
		{ { 40,1,153,1 }, { 152,96,33,1 }, { 204,192,10,0 }, { 194,3,12,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 282)
		{ { 44,50,55,1 }, { 184,226,86,0 }, { 246,38,26,0 }, { 53,35,142,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 283)
		{ { 37,140,230,0 }, { 3,190,52,0 }, { 51,152,210,0 }, { 22,62,224,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 284)
		{ { 33,30,140,0 }, { 33,56,112,1 }, { 24,188,66,0 }, { 135,14,66,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 285)
		{ { 45,125,105,0 }, { 193,252,71,1 }, { 75,95,90,0 }, { 241,31,193,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 286)
		{ { 41,192,73,0 }, { 194,116,0,1 }, { 73,1,202,0 }, { 128,23,33,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 287)
		{ { 38,177,32,0 }, { 2,160,199,0 }, { 2,70,178,0 }, { 113,130,160,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 288)
		{ { 38,128,28,1 }, { 26,32,148,1 }, { 156,0,178,0 }, { 148,130,44,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 289)
		{ { 34,180,26,0 }, { 19,34,194,1 }, { 44,22,162,0 }, { 161,162,100,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 290)
		{ { 38,42,68,1 }, { 40,44,150,0 }, { 145,42,50,0 }, { 52,154,10,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 291)
		{ { 38,171,89,0 }, { 50,108,135,1 }, { 77,106,178,0 }, { 240,155,38,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 292)
		{ { 38,201,132,0 }, { 66,40,181,0 }, { 16,201,178,0 }, { 86,138,33,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 293)
		{ { 42,48,98,1 }, { 136,166,194,0 }, { 163,6,42,0 }, { 33,178,136,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 294)
		{ { 46,50,173,0 }, { 160,224,246,1 }, { 90,166,58,0 }, { 183,131,130,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 295)
		{ { 35,63,1,1 }, { 41,120,195,0 }, { 192,126,98,0 }, { 97,143,74,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 296)
		{ { 35,131,80,0 }, { 50,52,129,0 }, { 5,96,226,0 }, { 64,150,38,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 297)
		{ { 39,100,46,1 }, { 73,178,150,1 }, { 186,19,114,0 }, { 180,166,201,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 298)
		{ { 39,212,176,1 }, { 91,176,228,0 }, { 134,149,242,0 }, { 19,134,237,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 299)
		{ { 47,186,44,1 }, { 170,184,214,1 }, { 154,46,250,0 }, { 181,142,170,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 300)
		{ { 43,38,186,1 }, { 185,178,162,1 }, { 174,178,106,0 }, { 162,166,206,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 301)
		{ { 48,11,141,0 }, { 36,104,49,1 }, { 88,232,6,0 }, { 198,11,18,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 302)
		{ { 52,38,146,1 }, { 61,34,38,0 }, { 164,178,22,0 }, { 50,34,94,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 303)
		{ { 48,130,25,0 }, { 54,96,0,1 }, { 76,32,134,0 }, { 128,3,54,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 304)
		{ { 48,123,44,1 }, { 108,168,83,1 }, { 154,111,6,0 }, { 229,10,155,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 305)
		{ { 60,184,59,1 }, { 158,234,70,1 }, { 238,14,158,0 }, { 177,43,188,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 306)
		{ { 60,38,15,1 }, { 173,98,22,1 }, { 248,50,30,0 }, { 180,35,90,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 307)
		{ { 56,233,220,0 }, { 214,44,51,1 }, { 29,203,142,0 }, { 230,26,53,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 308)
		{ { 60,192,247,0 }, { 214,230,52,0 }, { 119,129,158,0 }, { 22,51,181,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 309)
		{ { 56,247,84,1 }, { 255,36,83,0 }, { 149,119,142,0 }, { 101,18,127,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 310)
		{ { 49,5,180,1 }, { 29,176,49,0 }, { 150,208,70,0 }, { 70,6,220,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 311)
		{ { 53,184,254,1 }, { 30,190,118,1 }, { 191,142,214,0 }, { 183,62,188,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 312)
		{ { 53,178,211,1 }, { 62,118,102,0 }, { 229,166,214,0 }, { 51,55,62,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 313)
		{ { 57,155,206,1 }, { 174,62,113,1 }, { 185,236,206,0 }, { 199,62,58,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 314)
		{ { 57,109,46,0 }, { 197,186,19,1 }, { 58,91,78,0 }, { 228,46,209,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 315)
		{ { 61,224,131,1 }, { 206,114,38,0 }, { 224,131,222,0 }, { 50,39,57,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 316)
		{ { 57,244,208,0 }, { 215,52,98,0 }, { 5,151,206,0 }, { 35,22,117,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 317)
		{ { 57,255,32,0 }, { 231,184,67,0 }, { 2,127,206,0 }, { 97,14,243,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 318)
		{ { 57,199,136,1 }, { 239,48,33,1 }, { 136,241,206,0 }, { 194,6,123,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 319)
		{ { 54,15,36,0 }, { 37,168,149,0 }, { 18,120,54,0 }, { 84,138,210,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 320)
		{ { 50,30,213,0 }, { 53,108,240,0 }, { 85,188,38,0 }, { 7,155,86,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 321)
		{ { 54,191,209,1 }, { 63,108,231,0 }, { 197,254,182,0 }, { 115,155,126,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 322)
		{ { 54,70,235,0 }, { 101,230,164,1 }, { 107,177,54,0 }, { 146,179,211,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 323)
		{ { 58,45,168,0 }, { 133,168,163,1 }, { 10,218,46,0 }, { 226,138,208,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 324)
		{ { 58,147,187,0 }, { 182,226,225,1 }, { 110,228,174,0 }, { 195,163,182,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 325)
		{ { 55,149,173,0 }, { 7,240,245,1 }, { 90,212,246,0 }, { 215,135,240,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 326)
		{ { 55,4,147,0 }, { 21,114,164,0 }, { 100,144,118,0 }, { 18,167,84,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 327)
		{ { 51,160,216,1 }, { 30,52,162,1 }, { 141,130,230,0 }, { 162,150,60,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 328)
		{ { 55,67,167,0 }, { 100,242,181,0 }, { 114,225,118,0 }, { 86,167,147,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 329)
		{ { 51,250,92,0 }, { 118,60,210,1 }, { 29,47,230,0 }, { 165,158,55,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 330)
		{ { 63,131,110,0 }, { 166,182,149,1 }, { 59,96,254,0 }, { 212,182,178,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 331)
		{ { 63,107,96,0 }, { 228,188,135,0 }, { 3,107,126,0 }, { 112,158,147,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 332)
		{ { 64,225,205,0 }, { 66,69,51,1 }, { 89,195,129,0 }, { 230,81,33,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 333)
		{ { 76,144,234,0 }, { 130,135,100,1 }, { 43,132,153,0 }, { 147,112,160,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 334)
		{ { 72,154,105,1 }, { 170,205,64,1 }, { 203,44,137,0 }, { 129,89,170,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 335)
		{ { 76,190,247,0 }, { 179,207,118,0 }, { 119,190,153,0 }, { 55,121,230,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 336)
		{ { 72,235,138,1 }, { 234,11,35,1 }, { 168,235,137,0 }, { 226,104,43,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 337)
		{ { 72,211,7,1 }, { 234,67,81,0 }, { 240,101,137,0 }, { 69,97,43,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 338)
		{ { 76,90,152,1 }, { 248,9,100,1 }, { 140,173,25,0 }, { 147,72,15,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 339)
		{ { 65,36,19,1 }, { 25,83,2,0 }, { 228,18,65,0 }, { 32,101,76,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 340)
		{ { 77,11,248,0 }, { 176,157,37,1 }, { 15,232,89,0 }, { 210,92,134,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 341)
		{ { 73,91,189,1 }, { 248,217,113,1 }, { 222,237,73,0 }, { 199,77,143,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 342)
		{ { 70,141,101,0 }, { 3,205,149,0 }, { 83,88,177,0 }, { 84,217,224,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 343)
		{ { 66,181,107,1 }, { 11,199,195,1 }, { 235,86,161,0 }, { 225,241,232,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 344)
		{ { 70,92,131,0 }, { 65,75,228,0 }, { 96,157,49,0 }, { 19,233,65,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 345)
		{ { 70,244,103,0 }, { 67,199,214,0 }, { 115,23,177,0 }, { 53,241,225,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 346)
		{ { 70,121,187,0 }, { 80,203,231,1 }, { 110,207,49,0 }, { 243,233,133,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 347)
		{ { 74,163,157,1 }, { 186,65,179,1 }, { 220,226,169,0 }, { 230,193,46,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 348)
		{ { 78,65,78,1 }, { 200,7,149,1 }, { 185,65,57,0 }, { 212,240,9,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 349)
		{ { 78,75,194,0 }, { 224,15,165,0 }, { 33,233,57,0 }, { 82,248,3,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 350)
		{ { 67,137,211,1 }, { 26,95,161,0 }, { 229,200,225,0 }, { 66,253,44,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 351)
		{ { 71,170,200,1 }, { 42,29,166,1 }, { 137,170,241,0 }, { 178,220,42,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 352)
		{ { 67,59,19,0 }, { 48,91,195,0 }, { 100,110,97,0 }, { 97,237,6,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 353)
		{ { 71,74,105,1 }, { 104,221,132,1 }, { 203,41,113,0 }, { 144,221,139,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 354)
		{ { 79,22,235,1 }, { 169,215,228,1 }, { 235,180,121,0 }, { 147,245,202,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 355)
		{ { 79,69,160,0 }, { 193,145,165,0 }, { 2,209,121,0 }, { 82,196,193,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 356)
		{ { 80,145,108,1 }, { 14,133,81,1 }, { 155,68,133,0 }, { 197,80,184,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 357)
		{ { 84,16,187,0 }, { 20,195,100,1 }, { 110,132,21,0 }, { 147,97,148,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 358)
		{ { 80,90,77,1 }, { 108,77,80,1 }, { 217,45,5,0 }, { 133,89,27,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 359)
		{ { 80,114,212,0 }, { 116,5,114,0 }, { 21,167,5,0 }, { 39,80,23,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 360)
		{ { 84,234,241,1 }, { 126,205,38,0 }, { 199,171,149,0 }, { 50,89,191,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 361)
		{ { 88,9,195,1 }, { 140,79,33,0 }, { 225,200,13,0 }, { 66,121,24,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 362)
		{ { 92,89,121,0 }, { 212,205,69,1 }, { 79,77,29,0 }, { 209,89,149,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 363)
		{ { 88,107,27,0 }, { 244,75,3,1 }, { 108,107,13,0 }, { 224,105,23,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 364)
		{ { 81,52,246,1 }, { 29,151,114,0 }, { 183,150,69,0 }, { 39,116,220,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 365)
		{ { 85,169,118,1 }, { 30,159,23,0 }, { 183,74,213,0 }, { 116,124,188,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 366)
		{ { 85,151,183,1 }, { 63,211,117,0 }, { 246,244,213,0 }, { 87,101,254,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 367)
		{ { 85,72,67,1 }, { 76,95,4,0 }, { 225,9,85,0 }, { 16,125,25,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 368)
		{ { 81,203,28,0 }, { 118,25,17,1 }, { 28,105,197,0 }, { 196,76,55,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 369)
		{ { 89,103,105,1 }, { 237,213,3,1 }, { 203,115,77,0 }, { 224,85,219,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 370)
		{ { 89,87,155,0 }, { 245,83,97,1 }, { 108,245,77,0 }, { 195,101,87,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 371)
		{ { 86,160,171,1 }, { 14,195,166,1 }, { 234,130,181,0 }, { 178,225,184,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 372)
		{ { 82,76,88,0 }, { 85,13,128,1 }, { 13,25,37,0 }, { 128,216,85,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 373)
		{ { 86,87,68,1 }, { 109,5,213,0 }, { 145,117,53,0 }, { 85,208,91,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 374)
		{ { 94,1,56,0 }, { 148,129,133,1 }, { 14,64,61,0 }, { 208,192,148,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 375)
		{ { 90,1,255,0 }, { 148,199,177,1 }, { 127,192,45,0 }, { 198,241,148,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 376)
		{ { 90,53,19,1 }, { 157,67,195,0 }, { 228,86,45,0 }, { 97,225,92,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 377)
		{ { 94,29,215,1 }, { 157,79,245,0 }, { 245,220,61,0 }, { 87,249,92,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 378)
		{ { 94,146,70,1 }, { 174,7,212,0 }, { 177,36,189,0 }, { 21,240,58,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 379)
		{ { 90,108,162,0 }, { 197,139,162,0 }, { 34,155,45,0 }, { 34,232,209,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 380)
		{ { 87,57,5,0 }, { 4,89,215,0 }, { 80,78,117,0 }, { 117,205,16,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 381)
		{ { 87,185,238,0 }, { 6,159,247,1 }, { 59,206,245,0 }, { 247,252,176,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 382)
		{ { 83,27,44,1 }, { 44,153,209,1 }, { 154,108,101,0 }, { 197,204,154,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 383)
		{ { 87,134,8,0 }, { 39,17,132,1 }, { 8,48,245,0 }, { 144,196,114,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 384)
		{ { 87,179,31,1 }, { 62,83,215,1 }, { 252,102,245,0 }, { 245,229,62,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 385)
		{ { 87,175,125,0 }, { 55,221,151,1 }, { 95,122,245,0 }, { 244,221,246,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 386)
		{ { 83,240,235,0 }, { 70,215,226,1 }, { 107,135,229,0 }, { 163,245,177,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 387)
		{ { 91,30,236,0 }, { 165,157,240,1 }, { 27,188,109,0 }, { 135,220,210,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 388)
		{ { 95,6,166,1 }, { 173,147,180,0 }, { 178,176,125,0 }, { 22,228,218,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 389)
		{ { 95,46,87,1 }, { 189,95,150,0 }, { 245,58,125,0 }, { 52,253,94,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 390)
		{ { 91,89,192,0 }, { 196,29,225,0 }, { 1,205,109,0 }, { 67,220,17,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 391)
		{ { 91,221,125,1 }, { 223,221,209,1 }, { 223,93,237,0 }, { 197,221,253,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 392)
		{ { 91,78,47,0 }, { 229,219,144,1 }, { 122,57,109,0 }, { 132,237,211,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 393)
		{ { 95,111,137,1 }, { 237,89,167,1 }, { 200,251,125,0 }, { 242,205,91,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 394)
		{ { 91,99,218,0 }, { 244,23,163,1 }, { 45,227,109,0 }, { 226,244,23,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 395)
		{ { 96,32,36,1 }, { 8,161,18,0 }, { 146,2,3,0 }, { 36,66,136,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 396)
		{ { 100,167,30,1 }, { 59,35,23,1 }, { 188,114,147,0 }, { 244,98,110,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 397)
		{ { 96,84,84,1 }, { 89,37,80,0 }, { 149,21,3,0 }, { 5,82,77,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 398)
		{ { 104,166,103,0 }, { 163,231,18,0 }, { 115,50,139,0 }, { 36,115,226,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 399)
		{ { 108,235,188,1 }, { 250,169,55,1 }, { 158,235,155,0 }, { 246,74,175,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 400)
		{ { 105,70,205,1 }, { 233,117,48,1 }, { 217,177,75,0 }, { 134,87,75,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 401)
		{ { 109,243,169,1 }, { 234,241,103,1 }, { 202,231,219,0 }, { 243,71,171,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 402)
		{ { 109,94,31,0 }, { 241,123,84,1 }, { 124,61,91,0 }, { 149,111,71,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 403)
		{ { 102,32,99,0 }, { 0,231,134,0 }, { 99,2,51,0 }, { 48,243,128,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 404)
		{ { 102,219,83,1 }, { 122,111,197,0 }, { 229,109,179,0 }, { 81,251,47,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 405)
		{ { 98,215,16,1 }, { 123,33,193,0 }, { 132,117,163,0 }, { 65,194,111,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 406)
		{ { 106,165,84,1 }, { 155,37,147,0 }, { 149,82,171,0 }, { 100,210,108,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 407)
		{ { 110,46,41,1 }, { 169,233,134,1 }, { 202,58,59,0 }, { 176,203,202,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 408)
		{ { 103,54,146,0 }, { 49,51,230,0 }, { 36,182,115,0 }, { 51,230,70,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 409)
		{ { 103,196,202,0 }, { 67,55,164,1 }, { 41,145,243,0 }, { 146,246,97,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 410)
		{ { 99,83,34,1 }, { 104,179,193,0 }, { 162,101,99,0 }, { 65,230,139,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 411)
		{ { 107,59,196,1 }, { 168,61,243,0 }, { 145,238,107,0 }, { 103,222,10,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 412)
		{ { 111,22,80,1 }, { 185,53,196,0 }, { 133,52,123,0 }, { 17,214,78,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 413)
		{ { 107,88,37,1 }, { 200,249,208,0 }, { 210,13,107,0 }, { 5,207,137,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 414)
		{ { 111,99,213,1 }, { 248,117,183,0 }, { 213,227,123,0 }, { 118,215,15,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 415)
		{ { 112,192,248,1 }, { 94,165,32,1 }, { 143,129,135,0 }, { 130,82,189,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 416)
		{ { 116,215,208,0 }, { 119,37,101,0 }, { 5,245,151,0 }, { 83,82,119,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 417)
		{ { 113,43,110,1 }, { 44,191,19,1 }, { 187,106,71,0 }, { 228,126,154,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 418)
		{ { 113,121,27,1 }, { 92,123,67,1 }, { 236,79,71,0 }, { 225,111,29,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 419)
		{ { 113,66,210,0 }, { 116,55,32,0 }, { 37,161,71,0 }, { 2,118,23,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 420)
		{ { 113,99,253,0 }, { 116,245,51,1 }, { 95,227,71,0 }, { 230,87,151,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 421)
		{ { 117,254,122,1 }, { 127,191,70,1 }, { 175,63,215,0 }, { 177,126,255,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 422)
		{ { 125,152,140,0 }, { 134,57,116,1 }, { 24,140,223,0 }, { 151,78,48,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 423)
		{ { 125,185,247,0 }, { 150,255,119,0 }, { 119,206,223,0 }, { 119,127,180,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 424)
		{ { 125,19,147,1 }, { 188,115,101,0 }, { 228,228,95,0 }, { 83,103,30,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 425)
		{ { 121,71,103,0 }, { 229,247,17,0 }, { 115,113,79,0 }, { 68,119,211,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 426)
		{ { 125,223,195,0 }, { 231,127,101,0 }, { 97,253,223,0 }, { 83,127,115,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 427)
		{ { 121,239,82,1 }, { 255,63,3,0 }, { 165,123,207,0 }, { 96,126,127,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 428)
		{ { 114,0,182,0 }, { 20,163,176,0 }, { 54,128,39,0 }, { 6,226,148,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 429)
		{ { 118,68,152,1 }, { 93,33,164,1 }, { 140,145,55,0 }, { 146,194,93,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 430)
		{ { 118,122,66,0 }, { 100,47,198,0 }, { 33,47,55,0 }, { 49,250,19,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 431)
		{ { 126,11,181,1 }, { 188,233,181,0 }, { 214,232,63,0 }, { 86,203,158,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 432)
		{ { 115,58,225,1 }, { 44,253,226,0 }, { 195,174,103,0 }, { 35,223,154,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 433)
		{ { 119,139,59,1 }, { 62,251,133,1 }, { 238,104,247,0 }, { 208,239,190,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 434)
		{ { 119,93,234,0 }, { 69,191,229,1 }, { 43,221,119,0 }, { 211,254,209,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 435)
		{ { 127,76,0,1 }, { 205,57,132,0 }, { 128,25,127,0 }, { 16,206,89,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 436)
		{ { 123,117,224,1 }, { 205,181,227,0 }, { 131,215,111,0 }, { 99,214,217,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 437)
		{ { 127,226,186,0 }, { 246,179,166,1 }, { 46,163,255,0 }, { 178,230,183,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 438)
		{ { 128,176,67,1 }, { 10,70,74,0 }, { 225,6,128,1 }, { 41,49,40,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 439)
		{ { 128,188,61,0 }, { 19,200,90,1 }, { 94,30,128,1 }, { 173,9,228,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 440)
		{ { 128,50,88,0 }, { 48,4,74,1 }, { 13,38,0,1 }, { 169,16,6,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 441)
		{ { 128,92,26,1 }, { 89,10,72,1 }, { 172,29,0,1 }, { 137,40,77,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 442)
		{ { 132,251,36,0 }, { 98,136,95,0 }, { 18,111,144,1 }, { 125,8,163,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 443)
		{ { 128,127,245,1 }, { 121,204,123,0 }, { 215,255,0,1 }, { 111,25,207,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 444)
		{ { 136,45,197,1 }, { 137,76,59,0 }, { 209,218,8,1 }, { 110,25,72,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 445)
		{ { 136,153,224,1 }, { 138,140,105,0 }, { 131,204,136,1 }, { 75,24,168,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 446)
		{ { 136,25,149,0 }, { 144,72,121,0 }, { 84,204,8,1 }, { 79,9,4,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 447)
		{ { 133,29,199,1 }, { 9,94,125,0 }, { 241,220,80,1 }, { 95,61,72,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 448)
		{ { 129,187,135,0 }, { 34,90,123,0 }, { 112,238,192,1 }, { 111,45,34,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 449)
		{ { 129,225,96,1 }, { 74,148,11,0 }, { 131,67,192,1 }, { 104,20,169,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 450)
		{ { 133,126,33,1 }, { 105,216,78,0 }, { 194,63,80,1 }, { 57,13,203,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 451)
		{ { 129,242,146,0 }, { 114,18,106,0 }, { 36,167,192,1 }, { 43,36,39,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 452)
		{ { 137,61,108,1 }, { 137,156,91,1 }, { 155,94,72,1 }, { 237,28,200,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 453)
		{ { 137,100,178,1 }, { 217,146,42,0 }, { 166,147,72,1 }, { 42,36,205,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 454)
		{ { 141,212,30,1 }, { 219,18,92,1 }, { 188,21,216,1 }, { 157,36,109,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 455)
		{ { 137,94,209,1 }, { 249,92,104,0 }, { 197,189,72,1 }, { 11,29,79,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 456)
		{ { 138,4,172,0 }, { 129,128,184,1 }, { 26,144,40,1 }, { 142,128,192,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 457)
		{ { 142,200,22,0 }, { 210,10,156,0 }, { 52,9,184,1 }, { 28,168,37,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 458)
		{ { 142,242,252,1 }, { 250,132,254,1 }, { 159,167,184,1 }, { 191,144,175,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 459)
		{ { 131,11,137,0 }, { 32,88,169,1 }, { 72,232,96,1 }, { 202,141,2,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 460)
		{ { 135,43,109,0 }, { 32,220,159,1 }, { 91,106,112,1 }, { 252,157,130,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 461)
		{ { 135,69,49,0 }, { 81,208,141,0 }, { 70,81,112,1 }, { 88,133,197,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 462)
		{ { 131,108,120,1 }, { 89,156,138,1 }, { 143,27,96,1 }, { 168,156,205,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 463)
		{ { 135,238,13,0 }, { 99,88,158,1 }, { 88,59,240,1 }, { 188,141,99,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 464)
		{ { 139,177,43,1 }, { 138,210,203,1 }, { 234,70,232,1 }, { 233,165,168,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 465)
		{ { 139,145,216,0 }, { 146,20,233,1 }, { 13,196,232,1 }, { 203,148,36,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 466)
		{ { 139,89,102,0 }, { 192,158,217,0 }, { 51,77,104,1 }, { 77,188,129,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 467)
		{ { 143,229,85,0 }, { 211,84,159,0 }, { 85,83,248,1 }, { 124,149,101,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 468)
		{ { 143,243,101,1 }, { 234,212,223,0 }, { 211,103,248,1 }, { 125,149,171,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 469)
		{ { 148,26,21,0 }, { 52,72,92,0 }, { 84,44,20,1 }, { 29,9,22,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 470)
		{ { 144,225,167,0 }, { 70,194,59,0 }, { 114,195,132,1 }, { 110,33,177,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 471)
		{ { 144,71,255,0 }, { 117,198,57,1 }, { 127,241,4,1 }, { 206,49,215,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 472)
		{ { 156,188,213,0 }, { 151,76,126,0 }, { 85,158,156,1 }, { 63,25,116,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 473)
		{ { 152,146,244,0 }, { 182,132,120,0 }, { 23,164,140,1 }, { 15,16,182,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 474)
		{ { 156,83,168,1 }, { 236,128,109,1 }, { 138,229,28,1 }, { 219,0,155,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 475)
		{ { 152,195,107,0 }, { 230,198,9,1 }, { 107,97,140,1 }, { 200,49,179,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 476)
		{ { 152,114,63,1 }, { 252,194,90,1 }, { 254,39,12,1 }, { 173,33,159,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 477)
		{ { 145,19,213,0 }, { 52,84,121,0 }, { 85,228,68,1 }, { 79,21,22,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 478)
		{ { 149,191,251,0 }, { 55,222,111,1 }, { 111,254,212,1 }, { 251,61,246,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 479)
		{ { 149,69,22,1 }, { 93,18,29,0 }, { 180,81,84,1 }, { 92,36,93,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 480)
		{ { 149,238,216,0 }, { 119,28,46,1 }, { 13,187,212,1 }, { 186,28,119,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 481)
		{ { 157,214,4,0 }, { 231,16,92,0 }, { 16,53,220,1 }, { 29,4,115,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 482)
		{ { 157,98,112,0 }, { 244,148,14,0 }, { 7,35,92,1 }, { 56,20,151,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 483)
		{ { 150,175,206,0 }, { 39,14,191,1 }, { 57,250,180,1 }, { 254,184,114,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 484)
		{ { 150,186,24,1 }, { 62,8,206,1 }, { 140,46,180,1 }, { 185,136,62,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 485)
		{ { 150,217,61,1 }, { 94,200,221,1 }, { 222,77,180,1 }, { 221,137,189,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 486)
		{ { 158,33,46,0 }, { 132,130,159,1 }, { 58,66,60,1 }, { 252,160,144,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 487)
		{ { 154,185,132,0 }, { 134,8,251,0 }, { 16,206,172,1 }, { 111,136,48,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 488)
		{ { 154,129,79,1 }, { 142,70,153,1 }, { 249,64,172,1 }, { 204,177,56,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 489)
		{ { 154,59,54,1 }, { 188,138,219,0 }, { 182,110,44,1 }, { 109,168,158,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 490)
		{ { 158,195,37,0 }, { 230,192,157,0 }, { 82,97,188,1 }, { 92,129,179,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 491)
		{ { 147,149,40,0 }, { 7,144,201,1 }, { 10,84,228,1 }, { 201,132,240,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 492)
		{ { 151,50,46,1 }, { 44,146,222,1 }, { 186,38,116,1 }, { 189,164,154,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 493)
		{ { 151,211,152,0 }, { 118,16,237,1 }, { 12,229,244,1 }, { 219,132,55,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 494)
		{ { 155,157,163,1 }, { 143,218,233,0 }, { 226,220,236,1 }, { 75,173,248,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 495)
		{ { 159,28,240,0 }, { 149,156,236,0 }, { 7,156,124,1 }, { 27,156,212,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 496)
		{ { 159,51,82,1 }, { 188,22,207,0 }, { 165,102,124,1 }, { 121,180,30,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 497)
		{ { 155,250,202,0 }, { 230,30,234,1 }, { 41,175,236,1 }, { 171,188,51,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 498)
		{ { 159,250,148,0 }, { 246,24,254,0 }, { 20,175,252,1 }, { 63,140,55,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 499)
		{ { 160,60,203,1 }, { 9,110,106,1 }, { 233,158,2,1 }, { 171,59,72,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 500)
		{ { 164,168,105,0 }, { 2,236,14,1 }, { 75,10,146,1 }, { 184,27,160,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 501)
		{ { 160,179,245,0 }, { 50,228,123,0 }, { 87,230,130,1 }, { 111,19,166,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 502)
		{ { 164,106,191,0 }, { 112,234,62,1 }, { 126,171,18,1 }, { 190,43,135,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 503)
		{ { 160,91,120,1 }, { 120,172,73,1 }, { 143,109,2,1 }, { 201,26,143,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 504)
		{ { 168,104,152,1 }, { 216,40,42,1 }, { 140,139,10,1 }, { 170,10,13,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 505)
		{ { 172,205,54,1 }, { 219,170,29,0 }, { 182,89,154,1 }, { 92,42,237,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 506)
		{ { 172,220,121,1 }, { 219,236,76,1 }, { 207,29,154,1 }, { 153,27,237,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 507)
		{ { 161,73,35,0 }, { 64,250,9,0 }, { 98,73,66,1 }, { 72,47,129,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 508)
		{ { 161,67,217,0 }, { 112,116,41,1 }, { 77,225,66,1 }, { 202,23,7,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 509)
		{ { 173,176,209,0 }, { 146,116,110,0 }, { 69,134,218,1 }, { 59,23,36,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 510)
		{ { 169,155,28,1 }, { 186,56,89,1 }, { 156,108,202,1 }, { 205,14,46,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 511)
		{ { 169,138,215,1 }, { 186,126,56,0 }, { 245,168,202,1 }, { 14,63,46,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 512)
		{ { 173,84,106,1 }, { 201,182,76,1 }, { 171,21,90,1 }, { 153,54,201,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 513)
		{ { 173,235,81,1 }, { 250,124,15,0 }, { 197,107,218,1 }, { 120,31,47,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 514)
		{ { 166,29,142,0 }, { 1,42,253,1 }, { 56,220,50,1 }, { 223,170,64,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 515)
		{ { 166,92,102,1 }, { 73,174,220,0 }, { 179,29,50,1 }, { 29,186,201,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 516)
		{ { 174,188,36,0 }, { 131,168,222,0 }, { 18,30,186,1 }, { 61,138,224,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 517)
		{ { 170,171,48,0 }, { 178,168,139,0 }, { 6,106,170,1 }, { 104,138,166,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 518)
		{ { 174,204,216,0 }, { 211,44,172,1 }, { 13,153,186,1 }, { 154,154,101,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 519)
		{ { 170,237,187,0 }, { 211,234,171,1 }, { 110,219,170,1 }, { 234,171,229,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 520)
		{ { 174,227,205,1 }, { 234,100,191,1 }, { 217,227,186,1 }, { 254,147,43,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 521)
		{ { 167,54,8,1 }, { 41,48,206,1 }, { 136,54,114,1 }, { 185,134,74,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 522)
		{ { 163,236,229,0 }, { 67,252,186,0 }, { 83,155,226,1 }, { 46,159,225,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 523)
		{ { 163,193,155,1 }, { 90,114,169,1 }, { 236,193,226,1 }, { 202,167,45,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 524)
		{ { 167,250,58,0 }, { 114,186,206,1 }, { 46,47,242,1 }, { 185,174,167,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 525)
		{ { 175,165,105,1 }, { 139,244,143,1 }, { 203,82,250,1 }, { 248,151,232,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 526)
		{ { 175,200,189,1 }, { 218,248,188,1 }, { 222,137,250,1 }, { 158,143,173,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 527)
		{ { 175,239,164,0 }, { 227,184,191,0 }, { 18,251,250,1 }, { 126,142,227,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 528)
		{ { 171,103,246,0 }, { 241,182,187,0 }, { 55,243,106,1 }, { 110,182,199,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 529)
		{ { 180,28,82,0 }, { 21,46,76,0 }, { 37,28,22,1 }, { 25,58,84,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 530)
		{ { 180,63,68,1 }, { 45,44,95,0 }, { 145,126,22,1 }, { 125,26,90,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 531)
		{ { 180,240,202,0 }, { 70,38,110,1 }, { 41,135,150,1 }, { 187,50,49,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 532)
		{ { 184,24,45,0 }, { 132,232,88,1 }, { 90,12,14,1 }, { 141,11,144,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 533)
		{ { 188,191,136,1 }, { 175,40,111,1 }, { 136,254,158,1 }, { 251,10,122,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 534)
		{ { 184,142,4,1 }, { 175,40,24,0 }, { 144,56,142,1 }, { 12,10,122,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 535)
		{ { 188,120,40,1 }, { 204,168,78,1 }, { 138,15,30,1 }, { 185,10,153,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 536)
		{ { 184,200,67,1 }, { 206,110,8,0 }, { 225,9,142,1 }, { 8,59,57,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 537)
		{ { 188,243,60,1 }, { 254,160,95,1 }, { 158,103,158,1 }, { 253,2,191,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 538)
		{ { 181,19,12,0 }, { 36,48,93,1 }, { 24,100,86,1 }, { 221,6,18,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 539)
		{ { 177,63,106,0 }, { 37,190,75,1 }, { 43,126,70,1 }, { 233,62,210,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 540)
		{ { 177,101,123,1 }, { 93,246,11,1 }, { 239,83,70,1 }, { 232,55,221,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 541)
		{ { 177,203,237,0 }, { 102,252,57,1 }, { 91,233,198,1 }, { 206,31,179,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 542)
		{ { 177,194,103,1 }, { 110,246,24,0 }, { 243,33,198,1 }, { 12,55,187,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 543)
		{ { 177,90,242,1 }, { 124,190,104,0 }, { 167,173,70,1 }, { 11,62,159,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 544)
		{ { 181,238,31,1 }, { 127,122,30,1 }, { 252,59,214,1 }, { 188,47,127,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 545)
		{ { 185,144,112,1 }, { 158,180,72,0 }, { 135,4,206,1 }, { 9,22,188,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 546)
		{ { 185,163,64,1 }, { 174,52,11,0 }, { 129,98,206,1 }, { 104,22,58,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 547)
		{ { 185,120,90,0 }, { 212,62,74,1 }, { 45,15,78,1 }, { 169,62,21,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 548)
		{ { 185,247,203,0 }, { 231,118,107,1 }, { 105,247,206,1 }, { 235,55,115,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 549)
		{ { 182,5,1,1 }, { 13,96,141,0 }, { 192,80,54,1 }, { 88,131,88,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 550)
		{ { 178,255,194,0 }, { 103,46,235,0 }, { 33,255,166,1 }, { 107,186,115,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 551)
		{ { 178,123,21,0 }, { 116,104,219,0 }, { 84,111,38,1 }, { 109,139,23,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 552)
		{ { 178,110,90,1 }, { 125,46,138,1 }, { 173,59,38,1 }, { 168,186,95,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 553)
		{ { 190,181,243,1 }, { 159,230,239,0 }, { 231,214,190,1 }, { 123,179,252,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 554)
		{ { 186,167,161,0 }, { 167,224,171,0 }, { 66,242,174,1 }, { 106,131,242,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 555)
		{ { 186,114,10,1 }, { 236,34,202,1 }, { 168,39,46,1 }, { 169,162,27,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 556)
		{ { 179,48,64,0 }, { 4,52,202,0 }, { 1,6,102,1 }, { 41,150,16,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 557)
		{ { 183,181,52,1 }, { 31,176,223,0 }, { 150,86,246,1 }, { 125,134,252,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 558)
		{ { 183,105,76,0 }, { 68,60,159,1 }, { 25,75,118,1 }, { 252,158,17,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 559)
		{ { 183,197,193,0 }, { 71,116,173,0 }, { 65,209,246,1 }, { 90,151,113,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 560)
		{ { 179,87,222,0 }, { 117,54,249,1 }, { 61,245,102,1 }, { 207,182,87,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 561)
		{ { 187,84,251,0 }, { 213,246,232,1 }, { 111,149,110,1 }, { 139,183,213,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 562)
		{ { 187,202,108,1 }, { 238,188,152,1 }, { 155,41,238,1 }, { 140,158,187,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 563)
		{ { 187,251,225,1 }, { 238,252,235,0 }, { 195,239,238,1 }, { 107,159,187,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 564)
		{ { 191,246,134,1 }, { 239,50,254,0 }, { 176,183,254,1 }, { 63,166,123,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 565)
		{ { 196,45,124,0 }, { 17,141,31,1 }, { 31,90,17,1 }, { 252,88,196,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 566)
		{ { 200,28,52,0 }, { 145,137,88,0 }, { 22,28,9,1 }, { 13,72,196,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 567)
		{ { 204,67,229,1 }, { 232,197,61,0 }, { 211,225,25,1 }, { 94,81,139,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 568)
		{ { 197,53,174,1 }, { 9,147,127,1 }, { 186,214,81,1 }, { 255,100,200,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 569)
		{ { 193,146,192,0 }, { 34,21,104,0 }, { 1,164,193,1 }, { 11,84,34,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 570)
		{ { 197,35,247,0 }, { 48,215,63,0 }, { 119,226,81,1 }, { 126,117,134,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 571)
		{ { 193,159,254,0 }, { 51,159,121,1 }, { 63,252,193,1 }, { 207,124,230,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 572)
		{ { 193,84,97,0 }, { 65,213,72,0 }, { 67,21,65,1 }, { 9,85,193,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 573)
		{ { 193,87,130,0 }, { 97,19,105,0 }, { 32,245,65,1 }, { 75,100,67,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 574)
		{ { 193,199,55,1 }, { 123,211,25,0 }, { 246,113,193,1 }, { 76,101,239,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 575)
		{ { 201,140,239,1 }, { 139,223,56,1 }, { 251,152,201,1 }, { 142,125,232,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 576)
		{ { 205,240,111,0 }, { 194,215,94,1 }, { 123,7,217,1 }, { 189,117,161,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 577)
		{ { 201,95,103,1 }, { 233,223,89,0 }, { 243,125,73,1 }, { 77,125,203,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 578)
		{ { 201,119,241,0 }, { 241,213,107,0 }, { 71,247,73,1 }, { 107,85,199,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 579)
		{ { 205,226,149,1 }, { 250,81,62,0 }, { 212,163,217,1 }, { 62,69,47,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 580)
		{ { 198,191,7,1 }, { 43,75,223,0 }, { 240,126,177,1 }, { 125,233,106,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 581)
		{ { 198,191,184,0 }, { 51,137,239,1 }, { 14,254,177,1 }, { 251,200,230,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 582)
		{ { 198,219,201,1 }, { 106,77,237,1 }, { 201,237,177,1 }, { 219,217,43,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 583)
		{ { 202,49,136,0 }, { 128,1,235,1 }, { 8,198,41,1 }, { 235,192,0,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 584)
		{ { 206,222,45,1 }, { 235,201,220,1 }, { 218,61,185,1 }, { 157,201,235,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 585)
		{ { 199,120,44,1 }, { 72,153,222,1 }, { 154,15,113,1 }, { 189,204,137,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 586)
		{ { 203,171,75,1 }, { 170,95,139,1 }, { 233,106,233,1 }, { 232,253,42,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 587)
		{ { 207,67,191,0 }, { 240,211,189,1 }, { 126,225,121,1 }, { 222,229,135,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 588)
		{ { 208,174,86,1 }, { 63,15,26,0 }, { 181,58,133,1 }, { 44,120,126,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 589)
		{ { 208,115,51,0 }, { 116,195,75,0 }, { 102,103,5,1 }, { 105,97,151,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 590)
		{ { 216,20,152,0 }, { 149,1,104,1 }, { 12,148,13,1 }, { 139,64,84,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 591)
		{ { 220,96,159,1 }, { 220,67,62,1 }, { 252,131,29,1 }, { 190,97,29,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 592)
		{ { 213,117,88,0 }, { 85,21,79,1 }, { 13,87,85,1 }, { 249,84,85,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 593)
		{ { 209,224,215,0 }, { 86,87,58,0 }, { 117,131,197,1 }, { 46,117,53,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 594)
		{ { 213,251,177,0 }, { 118,217,111,0 }, { 70,239,213,1 }, { 123,77,183,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 595)
		{ { 213,218,116,1 }, { 126,157,92,0 }, { 151,45,213,1 }, { 29,92,191,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 596)
		{ { 221,60,116,1 }, { 157,157,94,0 }, { 151,30,93,1 }, { 61,92,220,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 597)
		{ { 221,151,109,0 }, { 167,213,93,1 }, { 91,116,221,1 }, { 221,85,242,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 598)
		{ { 217,27,49,0 }, { 180,217,73,0 }, { 70,108,77,1 }, { 73,77,150,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 599)
		{ { 217,98,166,0 }, { 228,147,58,0 }, { 50,163,77,1 }, { 46,100,147,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 600)
		{ { 210,171,124,1 }, { 62,141,155,1 }, { 159,106,165,1 }, { 236,216,190,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 601)
		{ { 210,197,236,0 }, { 71,133,185,1 }, { 27,209,165,1 }, { 206,208,241,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 602)
		{ { 210,202,106,0 }, { 102,143,136,1 }, { 43,41,165,1 }, { 136,248,179,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 603)
		{ { 210,107,214,0 }, { 116,15,187,0 }, { 53,235,37,1 }, { 110,248,23,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 604)
		{ { 222,155,52,0 }, { 182,137,221,0 }, { 22,108,189,1 }, { 93,200,182,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 605)
		{ { 222,146,158,0 }, { 182,3,252,1 }, { 60,164,189,1 }, { 159,224,54,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 606)
		{ { 218,96,216,1 }, { 220,5,170,1 }, { 141,131,45,1 }, { 170,208,29,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 607)
		{ { 215,57,178,1 }, { 28,155,239,0 }, { 166,206,117,1 }, { 123,236,156,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 608)
		{ { 215,95,38,0 }, { 101,155,221,0 }, { 50,125,117,1 }, { 93,236,211,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 609)
		{ { 223,1,65,1 }, { 140,85,141,0 }, { 193,64,125,1 }, { 88,213,24,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 610)
		{ { 223,121,15,1 }, { 204,91,223,1 }, { 248,79,125,1 }, { 253,237,25,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 611)
		{ { 219,247,116,0 }, { 247,149,219,0 }, { 23,119,237,1 }, { 109,212,247,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 612)
		{ { 224,67,79,1 }, { 104,103,25,1 }, { 249,97,3,1 }, { 204,115,11,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 613)
		{ { 224,198,227,0 }, { 99,231,40,0 }, { 99,177,131,1 }, { 10,115,227,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 614)
		{ { 236,56,189,1 }, { 152,233,126,1 }, { 222,142,27,1 }, { 191,75,140,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 615)
		{ { 236,81,253,0 }, { 208,229,125,1 }, { 95,197,27,1 }, { 223,83,133,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 616)
		{ { 229,141,36,0 }, { 3,185,29,0 }, { 18,88,211,1 }, { 92,78,224,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 617)
		{ { 229,5,121,1 }, { 25,245,13,1 }, { 207,80,83,1 }, { 216,87,204,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 618)
		{ { 225,78,248,0 }, { 113,189,40,1 }, { 15,185,67,1 }, { 138,94,199,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 619)
		{ { 229,87,220,1 }, { 121,53,125,1 }, { 157,245,83,1 }, { 223,86,79,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 620)
		{ { 225,247,242,1 }, { 123,183,107,0 }, { 167,247,195,1 }, { 107,118,239,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 621)
		{ { 226,133,77,0 }, { 3,101,153,1 }, { 89,80,163,1 }, { 204,211,96,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 622)
		{ { 226,24,26,0 }, { 16,43,200,1 }, { 44,12,35,1 }, { 137,234,4,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 623)
		{ { 226,43,203,0 }, { 32,111,171,1 }, { 105,234,35,1 }, { 234,251,2,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 624)
		{ { 230,236,2,0 }, { 67,43,142,0 }, { 32,27,179,1 }, { 56,234,97,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 625)
		{ { 230,98,129,0 }, { 96,97,174,0 }, { 64,163,51,1 }, { 58,195,3,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 626)
		{ { 234,38,64,0 }, { 161,37,138,0 }, { 1,50,43,1 }, { 40,210,66,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 627)
		{ { 234,224,196,0 }, { 194,37,186,0 }, { 17,131,171,1 }, { 46,210,33,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 628)
		{ { 234,114,148,1 }, { 248,33,250,0 }, { 148,167,43,1 }, { 47,194,15,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 629)
		{ { 227,17,63,1 }, { 24,243,217,1 }, { 254,68,99,1 }, { 205,231,140,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 630)
		{ { 231,11,230,1 }, { 40,191,189,0 }, { 179,232,115,1 }, { 94,254,138,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 631)
		{ { 227,100,241,1 }, { 89,245,170,0 }, { 199,147,99,1 }, { 42,215,205,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 632)
		{ { 231,250,226,1 }, { 106,191,238,0 }, { 163,175,243,1 }, { 59,254,171,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 633)
		{ { 227,219,243,0 }, { 114,255,233,0 }, { 103,237,227,1 }, { 75,255,167,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 634)
		{ { 239,135,98,0 }, { 163,183,141,0 }, { 35,112,251,1 }, { 88,246,226,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 635)
		{ { 239,93,112,0 }, { 209,189,205,0 }, { 7,93,123,1 }, { 89,222,197,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 636)
		{ { 235,102,14,0 }, { 225,51,154,1 }, { 56,51,107,1 }, { 172,230,67,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 637)
		{ { 239,74,60,0 }, { 240,185,156,1 }, { 30,41,123,1 }, { 156,206,135,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 638)
		{ { 240,178,33,1 }, { 46,225,74,0 }, { 194,38,135,1 }, { 41,67,186,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 639)
		{ { 240,175,79,0 }, { 39,111,27,1 }, { 121,122,135,1 }, { 236,123,114,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 640)
		{ { 244,159,60,1 }, { 63,169,93,1 }, { 158,124,151,1 }, { 221,74,254,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 641)
		{ { 240,245,4,0 }, { 71,33,91,0 }, { 16,87,135,1 }, { 109,66,113,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 642)
		{ { 240,242,120,0 }, { 118,165,74,1 }, { 15,39,135,1 }, { 169,82,183,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 643)
		{ { 248,52,99,0 }, { 133,231,74,0 }, { 99,22,15,1 }, { 41,115,208,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 644)
		{ { 252,219,143,0 }, { 230,107,125,1 }, { 120,237,159,1 }, { 223,107,51,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 645)
		{ { 252,254,77,1 }, { 239,109,94,1 }, { 217,63,159,1 }, { 189,91,123,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 646)
		{ { 253,176,69,1 }, { 142,117,94,0 }, { 209,6,223,1 }, { 61,87,56,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 647)
		{ { 253,51,235,0 }, { 164,247,111,1 }, { 107,230,95,1 }, { 251,119,146,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 648)
		{ { 249,196,217,1 }, { 223,117,40,1 }, { 205,145,207,1 }, { 138,87,125,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 649)
		{ { 242,35,145,1 }, { 60,97,171,0 }, { 196,226,39,1 }, { 106,195,30,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 650)
		{ { 246,210,251,1 }, { 126,231,236,1 }, { 239,165,183,1 }, { 155,243,191,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 651)
		{ { 254,239,211,1 }, { 255,111,175,0 }, { 229,251,191,1 }, { 122,251,127,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 652)
		{ { 243,176,58,1 }, { 30,179,202,1 }, { 174,6,231,1 }, { 169,230,188,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 653)
		{ { 247,138,77,1 }, { 46,125,156,1 }, { 217,40,247,1 }, { 156,223,58,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 654)
		{ { 243,143,157,1 }, { 63,121,185,1 }, { 220,248,231,1 }, { 206,207,126,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 655)
		{ { 247,242,39,0 }, { 102,243,222,0 }, { 114,39,247,1 }, { 61,231,179,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 656)
		{ { 255,189,133,1 }, { 143,121,255,0 }, { 208,222,255,1 }, { 127,207,120,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 657)
		{ { 255,38,197,1 }, { 173,117,190,0 }, { 209,178,127,1 }, { 62,215,90,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 658)
		{ { 251,224,97,0 }, { 198,245,138,0 }, { 67,3,239,1 }, { 40,215,177,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 659)
		{ { 255,220,26,0 }, { 215,59,204,1 }, { 44,29,255,1 }, { 153,238,117,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 660)
		{ { 25,248,99,1 }, { 206,222,66,0 }, { 227,15,204,0 }, { 33,61,185,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 661)
		{ { 169,93,31,1 }, { 217,122,89,1 }, { 252,93,74,1 }, { 205,47,77,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 662)
		{ { 0,184,72,1 }, { 10,12,66,1 }, { 137,14,128,0 }, { 161,24,40,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 663)
		{ { 0,236,225,0 }, { 67,204,34,0 }, { 67,155,128,0 }, { 34,25,225,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 664)
		{ { 8,97,102,0 }, { 192,134,19,0 }, { 51,67,8,0 }, { 100,48,129,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 665)
		{ { 8,244,131,0 }, { 195,66,98,0 }, { 96,151,136,0 }, { 35,33,97,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 666)
		{ { 12,248,157,0 }, { 210,72,118,1 }, { 92,143,152,0 }, { 183,9,37,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 667)
		{ { 8,192,62,1 }, { 218,130,16,1 }, { 190,1,136,0 }, { 132,32,173,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 668)
		{ { 1,57,192,0 }, { 0,28,99,0 }, { 1,206,64,0 }, { 99,28,0,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 669)
		{ { 1,40,10,0 }, { 0,26,2,1 }, { 40,10,64,0 }, { 160,44,0,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 670)
		{ { 1,190,179,1 }, { 59,218,98,0 }, { 230,190,192,0 }, { 35,45,238,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 671)
		{ { 13,128,85,0 }, { 146,84,20,0 }, { 85,0,216,0 }, { 20,21,36,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 672)
		{ { 13,175,99,1 }, { 171,222,7,0 }, { 227,122,216,0 }, { 112,61,234,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 673)
		{ { 6,181,236,0 }, { 3,132,247,1 }, { 27,214,176,0 }, { 247,144,224,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 674)
		{ { 2,153,54,1 }, { 26,138,209,0 }, { 182,76,160,0 }, { 69,168,172,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 675)
		{ { 6,182,143,0 }, { 35,66,246,1 }, { 120,182,176,0 }, { 183,161,98,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 676)
		{ { 6,125,64,1 }, { 73,12,199,0 }, { 129,95,48,0 }, { 113,152,73,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 677)
		{ { 2,114,104,1 }, { 104,132,194,1 }, { 139,39,32,0 }, { 161,144,139,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 678)
		{ { 6,203,237,1 }, { 106,204,181,1 }, { 219,233,176,0 }, { 214,153,171,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 679)
		{ { 14,15,61,0 }, { 177,200,149,1 }, { 94,120,56,0 }, { 212,137,198,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 680)
		{ { 14,213,203,0 }, { 195,70,229,1 }, { 105,213,184,0 }, { 211,177,97,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 681)
		{ { 3,125,39,1 }, { 73,218,211,0 }, { 242,95,96,0 }, { 101,173,201,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 682)
		{ { 3,233,143,0 }, { 66,90,179,1 }, { 120,203,224,0 }, { 230,173,33,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 683)
		{ { 7,250,159,1 }, { 122,90,246,1 }, { 252,175,240,0 }, { 183,173,47,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 684)
		{ { 11,76,16,0 }, { 209,24,128,0 }, { 4,25,104,0 }, { 0,140,69,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 685)
		{ { 16,185,87,1 }, { 30,78,83,0 }, { 245,78,132,0 }, { 101,57,60,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 686)
		{ { 16,22,41,0 }, { 37,192,64,1 }, { 74,52,4,0 }, { 129,1,210,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 687)
		{ { 16,98,139,1 }, { 108,66,34,1 }, { 232,163,4,0 }, { 162,33,27,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 688)
		{ { 24,157,182,0 }, { 151,138,113,0 }, { 54,220,140,0 }, { 71,40,244,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 689)
		{ { 24,109,0,1 }, { 205,8,3,0 }, { 128,91,12,0 }, { 96,8,89,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 690)
		{ { 28,118,42,0 }, { 229,130,70,1 }, { 42,55,28,0 }, { 177,32,211,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 691)
		{ { 24,95,228,1 }, { 237,140,113,0 }, { 147,253,12,0 }, { 71,24,219,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 692)
		{ { 28,66,22,0 }, { 244,2,20,0 }, { 52,33,28,0 }, { 20,32,23,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 693)
		{ { 17,60,169,0 }, { 5,216,98,1 }, { 74,158,68,0 }, { 163,13,208,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 694)
		{ { 17,152,57,1 }, { 30,216,64,1 }, { 206,12,196,0 }, { 129,13,188,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 695)
		{ { 21,58,99,0 }, { 36,222,70,0 }, { 99,46,84,0 }, { 49,61,146,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 696)
		{ { 21,18,117,1 }, { 60,212,84,0 }, { 215,36,84,0 }, { 21,21,158,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 697)
		{ { 21,222,162,0 }, { 103,154,100,0 }, { 34,189,212,0 }, { 19,44,243,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 698)
		{ { 21,106,24,1 }, { 124,24,6,1 }, { 140,43,84,0 }, { 176,12,31,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 699)
		{ { 29,209,40,0 }, { 198,144,69,1 }, { 10,69,220,0 }, { 209,4,177,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 700)
		{ { 29,113,148,1 }, { 220,16,119,0 }, { 148,199,92,0 }, { 119,4,29,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 701)
		{ { 18,57,139,1 }, { 12,74,227,1 }, { 232,206,36,0 }, { 227,169,24,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 702)
		{ { 18,5,152,0 }, { 21,0,161,1 }, { 12,208,36,0 }, { 194,128,84,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 703)
		{ { 22,2,152,1 }, { 60,0,164,1 }, { 140,160,52,0 }, { 146,128,30,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 704)
		{ { 26,52,127,1 }, { 157,198,210,1 }, { 255,22,44,0 }, { 165,177,220,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 705)
		{ { 30,220,239,1 }, { 207,206,244,1 }, { 251,157,188,0 }, { 151,185,249,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 706)
		{ { 30,112,115,0 }, { 212,198,198,0 }, { 103,7,60,0 }, { 49,177,149,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 707)
		{ { 26,67,149,0 }, { 244,64,177,0 }, { 84,225,44,0 }, { 70,129,23,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 708)
		{ { 26,126,27,1 }, { 253,74,194,1 }, { 236,63,44,0 }, { 161,169,95,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 709)
		{ { 23,173,194,0 }, { 7,30,167,0 }, { 33,218,244,0 }, { 114,188,112,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 710)
		{ { 19,25,222,1 }, { 28,30,241,1 }, { 189,204,100,0 }, { 199,188,28,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 711)
		{ { 27,168,147,1 }, { 158,90,162,0 }, { 228,138,236,0 }, { 34,173,60,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 712)
		{ { 27,147,73,1 }, { 174,84,193,1 }, { 201,100,236,0 }, { 193,149,58,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 713)
		{ { 27,208,27,0 }, { 214,82,192,1 }, { 108,5,236,0 }, { 129,165,53,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 714)
		{ { 31,66,219,1 }, { 252,86,164,1 }, { 237,161,124,0 }, { 146,181,31,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 715)
		{ { 32,185,170,0 }, { 2,170,99,1 }, { 42,206,130,0 }, { 227,42,160,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 716)
		{ { 36,196,186,0 }, { 83,162,36,1 }, { 46,145,146,0 }, { 146,34,229,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 717)
		{ { 40,173,5,0 }, { 131,104,19,0 }, { 80,90,138,0 }, { 100,11,96,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 718)
		{ { 44,35,100,1 }, { 168,164,23,0 }, { 147,98,26,0 }, { 116,18,138,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 719)
		{ { 44,14,154,1 }, { 185,42,36,1 }, { 172,184,26,0 }, { 146,42,78,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 720)
		{ { 44,81,3,1 }, { 200,98,69,0 }, { 224,69,26,0 }, { 81,35,9,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 721)
		{ { 37,197,207,1 }, { 75,118,53,1 }, { 249,209,210,0 }, { 214,55,105,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 722)
		{ { 37,200,211,1 }, { 90,126,36,0 }, { 229,137,210,0 }, { 18,63,45,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 723)
		{ { 33,119,232,1 }, { 105,180,99,1 }, { 139,247,66,0 }, { 227,22,203,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 724)
		{ { 34,141,218,1 }, { 27,46,161,1 }, { 173,216,162,0 }, { 194,186,108,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 725)
		{ { 34,10,238,0 }, { 32,174,176,1 }, { 59,168,34,0 }, { 134,186,130,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 726)
		{ { 46,134,44,0 }, { 163,160,148,1 }, { 26,48,186,0 }, { 148,130,226,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 727)
		{ { 42,182,47,1 }, { 171,226,210,1 }, { 250,54,170,0 }, { 165,163,234,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 728)
		{ { 39,60,45,0 }, { 1,248,214,1 }, { 90,30,114,0 }, { 181,143,192,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 729)
		{ { 39,157,74,0 }, { 3,62,197,1 }, { 41,92,242,0 }, { 209,190,96,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 730)
		{ { 39,155,7,1 }, { 42,122,213,0 }, { 240,108,242,0 }, { 85,175,42,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 731)
		{ { 35,87,132,0 }, { 97,48,241,0 }, { 16,245,98,0 }, { 71,134,67,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 732)
		{ { 35,78,67,1 }, { 105,126,128,0 }, { 225,57,98,0 }, { 0,191,75,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 733)
		{ { 47,171,185,1 }, { 186,248,167,1 }, { 206,234,250,0 }, { 242,143,174,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 734)
		{ { 48,176,46,1 }, { 14,162,82,1 }, { 186,6,134,0 }, { 165,34,184,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 735)
		{ { 48,40,122,0 }, { 20,174,2,1 }, { 47,10,6,0 }, { 160,58,148,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 736)
		{ { 52,253,160,1 }, { 79,168,103,0 }, { 130,223,150,0 }, { 115,10,249,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 737)
		{ { 60,214,137,0 }, { 231,96,100,1 }, { 72,181,158,0 }, { 147,3,115,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 738)
		{ { 56,126,182,0 }, { 245,170,114,0 }, { 54,191,14,0 }, { 39,42,215,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 739)
		{ { 49,0,109,0 }, { 4,244,16,1 }, { 91,0,70,0 }, { 132,23,144,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 740)
		{ { 49,23,219,1 }, { 61,118,97,1 }, { 237,244,70,0 }, { 195,55,94,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 741)
		{ { 49,167,119,1 }, { 63,246,19,0 }, { 247,114,198,0 }, { 100,55,254,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 742)
		{ { 61,128,10,1 }, { 142,50,4,1 }, { 168,0,222,0 }, { 144,38,56,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 743)
		{ { 61,226,157,0 }, { 246,112,54,1 }, { 92,163,222,0 }, { 182,7,55,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 744)
		{ { 54,106,119,1 }, { 124,238,150,0 }, { 247,43,54,0 }, { 52,187,159,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 745)
		{ { 54,199,190,1 }, { 127,162,181,1 }, { 190,241,182,0 }, { 214,162,255,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 746)
		{ { 62,187,41,0 }, { 166,232,199,1 }, { 74,110,190,0 }, { 241,139,178,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 747)
		{ { 62,104,154,0 }, { 212,42,166,1 }, { 44,139,62,0 }, { 178,170,21,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 748)
		{ { 62,95,2,1 }, { 237,42,197,0 }, { 160,125,62,0 }, { 81,170,91,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 749)
		{ { 58,86,206,1 }, { 237,38,240,1 }, { 185,181,46,0 }, { 135,178,91,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 750)
		{ { 62,95,252,0 }, { 245,172,245,1 }, { 31,253,62,0 }, { 215,154,215,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 751)
		{ { 51,185,172,0 }, { 6,184,243,1 }, { 26,206,230,0 }, { 231,142,176,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 752)
		{ { 51,84,174,0 }, { 69,178,240,1 }, { 58,149,102,0 }, { 135,166,209,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 753)
		{ { 63,25,160,0 }, { 132,184,229,0 }, { 2,204,126,0 }, { 83,142,144,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 754)
		{ { 59,173,97,1 }, { 143,252,131,0 }, { 195,90,238,0 }, { 96,159,248,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 755)
		{ { 59,112,47,1 }, { 204,242,210,1 }, { 250,7,110,0 }, { 165,167,153,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 756)
		{ { 59,235,58,1 }, { 254,186,131,1 }, { 174,107,238,0 }, { 224,174,191,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 757)
		{ { 64,83,90,0 }, { 112,7,65,1 }, { 45,101,1,0 }, { 193,112,7,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 758)
		{ { 65,152,22,0 }, { 18,27,80,0 }, { 52,12,193,0 }, { 5,108,36,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 759)
		{ { 65,143,177,0 }, { 51,217,33,0 }, { 70,248,193,0 }, { 66,77,230,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 760)
		{ { 69,217,33,1 }, { 74,217,69,0 }, { 194,77,209,0 }, { 81,77,169,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 761)
		{ { 69,235,1,0 }, { 98,89,7,0 }, { 64,107,209,0 }, { 112,77,35,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 762)
		{ { 73,157,82,0 }, { 147,31,65,0 }, { 37,92,201,0 }, { 65,124,100,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 763)
		{ { 66,56,79,1 }, { 8,79,210,1 }, { 249,14,33,0 }, { 165,249,8,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 764)
		{ { 74,166,163,1 }, { 171,195,162,0 }, { 226,178,169,0 }, { 34,225,234,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 765)
		{ { 74,197,42,1 }, { 203,131,129,1 }, { 170,81,169,0 }, { 192,224,233,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 766)
		{ { 74,200,115,0 }, { 210,207,128,0 }, { 103,9,169,0 }, { 0,249,165,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 767)
		{ { 71,180,198,1 }, { 11,23,246,0 }, { 177,150,241,0 }, { 55,244,104,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 768)
		{ { 67,147,93,0 }, { 50,85,209,1 }, { 93,100,225,0 }, { 197,213,38,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 769)
		{ { 67,120,117,0 }, { 80,221,210,0 }, { 87,15,97,0 }, { 37,221,133,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 770)
		{ { 79,58,175,1 }, { 168,219,246,1 }, { 250,174,121,0 }, { 183,237,138,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 771)
		{ { 79,135,68,1 }, { 171,21,149,0 }, { 145,112,249,0 }, { 84,212,106,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 772)
		{ { 79,135,223,0 }, { 179,87,181,1 }, { 125,240,249,0 }, { 214,245,102,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 773)
		{ { 79,196,222,1 }, { 219,23,180,1 }, { 189,145,249,0 }, { 150,244,109,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 774)
		{ { 84,31,71,0 }, { 37,79,85,0 }, { 113,124,21,0 }, { 85,121,82,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 775)
		{ { 80,31,148,0 }, { 53,9,113,0 }, { 20,252,5,0 }, { 71,72,86,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 776)
		{ { 92,145,67,0 }, { 134,71,69,0 }, { 97,68,157,0 }, { 81,113,48,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 777)
		{ { 88,189,239,1 }, { 143,207,115,1 }, { 251,222,141,0 }, { 231,121,248,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 778)
		{ { 92,221,7,1 }, { 207,75,85,0 }, { 240,93,157,0 }, { 85,105,121,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 779)
		{ { 92,102,88,1 }, { 253,5,6,1 }, { 141,51,29,0 }, { 176,80,95,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 780)
		{ { 92,219,50,1 }, { 254,139,69,0 }, { 166,109,157,0 }, { 81,104,191,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 781)
		{ { 85,69,212,0 }, { 85,21,53,0 }, { 21,209,85,0 }, { 86,84,85,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 782)
		{ { 81,68,62,0 }, { 85,147,16,1 }, { 62,17,69,0 }, { 132,100,213,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 783)
		{ { 81,231,230,0 }, { 103,151,51,0 }, { 51,243,197,0 }, { 102,116,243,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 784)
		{ { 89,11,167,0 }, { 164,219,49,0 }, { 114,232,77,0 }, { 70,109,146,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 785)
		{ { 93,186,56,1 }, { 190,153,70,1 }, { 142,46,221,0 }, { 177,76,190,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 786)
		{ { 93,166,55,1 }, { 191,211,22,0 }, { 246,50,221,0 }, { 52,101,254,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 787)
		{ { 89,249,149,0 }, { 214,89,115,0 }, { 84,207,205,0 }, { 103,77,53,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 788)
		{ { 93,255,236,0 }, { 231,157,119,1 }, { 27,255,221,0 }, { 247,92,243,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 789)
		{ { 82,157,58,0 }, { 23,139,193,1 }, { 46,92,165,0 }, { 193,232,244,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 790)
		{ { 86,58,151,0 }, { 52,75,246,0 }, { 116,174,53,0 }, { 55,233,22,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 791)
		{ { 82,99,34,0 }, { 100,131,131,0 }, { 34,99,37,0 }, { 96,224,147,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 792)
		{ { 82,203,49,1 }, { 126,201,129,0 }, { 198,105,165,0 }, { 64,201,191,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 793)
		{ { 90,139,204,1 }, { 174,13,177,1 }, { 153,232,173,0 }, { 198,216,58,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 794)
		{ { 83,33,106,0 }, { 4,151,131,1 }, { 43,66,101,0 }, { 224,244,144,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 795)
		{ { 87,245,17,0 }, { 87,81,199,0 }, { 68,87,245,0 }, { 113,197,117,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 796)
		{ { 95,220,33,0 }, { 199,217,196,0 }, { 66,29,253,0 }, { 17,205,241,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 797)
		{ { 96,140,28,0 }, { 19,41,16,1 }, { 28,24,131,0 }, { 132,74,100,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 798)
		{ { 96,162,213,1 }, { 58,101,50,0 }, { 213,162,131,0 }, { 38,83,46,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 799)
		{ { 96,222,5,1 }, { 107,105,80,0 }, { 208,61,131,0 }, { 5,75,107,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 800)
		{ { 108,76,110,0 }, { 193,175,20,1 }, { 59,25,27,0 }, { 148,122,193,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 801)
		{ { 104,82,12,0 }, { 224,33,80,1 }, { 24,37,11,0 }, { 133,66,3,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 802)
		{ { 101,59,167,0 }, { 32,251,119,0 }, { 114,238,83,0 }, { 119,111,130,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 803)
		{ { 97,170,234,0 }, { 34,191,34,1 }, { 43,170,195,0 }, { 162,126,162,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 804)
		{ { 101,113,110,1 }, { 72,183,87,1 }, { 187,71,83,0 }, { 245,118,137,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 805)
		{ { 101,124,89,1 }, { 89,125,70,1 }, { 205,31,83,0 }, { 177,95,77,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 806)
		{ { 105,131,46,1 }, { 170,179,17,1 }, { 186,96,203,0 }, { 196,102,170,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 807)
		{ { 109,196,12,0 }, { 195,49,20,1 }, { 24,17,219,0 }, { 148,70,97,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 808)
		{ { 109,210,20,1 }, { 250,49,84,0 }, { 148,37,219,0 }, { 21,70,47,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 809)
		{ { 98,150,165,1 }, { 43,225,240,0 }, { 210,180,163,0 }, { 7,195,234,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 810)
		{ { 98,117,38,1 }, { 73,163,211,0 }, { 178,87,35,0 }, { 101,226,201,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 811)
		{ { 98,100,214,1 }, { 89,39,178,0 }, { 181,147,35,0 }, { 38,242,77,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 812)
		{ { 98,91,220,1 }, { 120,45,241,1 }, { 157,237,35,0 }, { 199,218,15,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 813)
		{ { 110,51,2,1 }, { 168,35,199,0 }, { 160,102,59,0 }, { 113,226,10,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 814)
		{ { 110,90,137,0 }, { 224,105,228,1 }, { 72,173,59,0 }, { 147,203,3,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 815)
		{ { 99,209,212,0 }, { 82,53,241,0 }, { 21,197,227,0 }, { 71,214,37,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 816)
		{ { 99,75,129,1 }, { 104,121,161,0 }, { 192,233,99,0 }, { 66,207,11,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 817)
		{ { 107,56,145,1 }, { 152,121,226,0 }, { 196,142,107,0 }, { 35,207,12,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 818)
		{ { 107,122,42,0 }, { 224,187,194,1 }, { 42,47,107,0 }, { 161,238,131,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 819)
		{ { 116,56,51,0 }, { 20,235,70,0 }, { 102,14,23,0 }, { 49,107,148,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 820)
		{ { 112,6,44,0 }, { 37,161,16,1 }, { 26,48,7,0 }, { 132,66,210,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 821)
		{ { 116,170,141,1 }, { 46,105,54,1 }, { 216,170,151,0 }, { 182,75,58,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 822)
		{ { 116,76,143,0 }, { 69,107,52,1 }, { 120,153,23,0 }, { 150,107,81,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 823)
		{ { 124,183,167,0 }, { 167,227,119,0 }, { 114,246,159,0 }, { 119,99,242,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 824)
		{ { 120,3,22,1 }, { 188,35,17,0 }, { 180,96,15,0 }, { 68,98,30,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 825)
		{ { 124,199,198,1 }, { 239,39,53,0 }, { 177,241,159,0 }, { 86,114,123,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 826)
		{ { 117,182,4,1 }, { 47,49,86,0 }, { 144,54,215,0 }, { 53,70,122,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 827)
		{ { 113,254,101,0 }, { 103,253,82,0 }, { 83,63,199,0 }, { 37,95,243,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 828)
		{ { 113,79,154,1 }, { 125,59,33,1 }, { 172,249,71,0 }, { 194,110,95,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 829)
		{ { 121,32,119,0 }, { 148,247,18,0 }, { 119,2,79,0 }, { 36,119,148,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 830)
		{ { 125,121,205,0 }, { 196,125,119,1 }, { 89,207,95,0 }, { 247,95,17,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 831)
		{ { 125,67,92,0 }, { 244,53,21,1 }, { 29,97,95,0 }, { 212,86,23,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 832)
		{ { 125,127,59,0 }, { 245,251,71,1 }, { 110,127,95,0 }, { 241,111,215,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 833)
		{ { 118,85,8,0 }, { 69,33,197,1 }, { 8,85,55,0 }, { 209,194,81,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 834)
		{ { 122,152,199,0 }, { 134,111,240,0 }, { 113,140,175,0 }, { 7,251,48,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 835)
		{ { 126,19,192,0 }, { 164,37,229,0 }, { 1,228,63,0 }, { 83,210,18,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 836)
		{ { 126,94,89,1 }, { 253,109,196,1 }, { 205,61,63,0 }, { 145,219,95,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 837)
		{ { 115,36,132,0 }, { 5,49,178,0 }, { 16,146,103,0 }, { 38,198,80,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 838)
		{ { 115,46,39,1 }, { 45,251,146,0 }, { 242,58,103,0 }, { 36,239,218,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 839)
		{ { 115,139,84,1 }, { 62,61,145,0 }, { 149,104,231,0 }, { 68,222,62,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 840)
		{ { 132,4,34,0 }, { 1,130,12,0 }, { 34,16,16,1 }, { 24,32,192,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 841)
		{ { 128,232,46,0 }, { 66,138,26,1 }, { 58,11,128,1 }, { 172,40,161,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 842)
		{ { 128,237,48,0 }, { 83,136,11,0 }, { 6,91,128,1 }, { 104,8,229,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 843)
		{ { 140,53,96,0 }, { 129,132,79,0 }, { 3,86,24,1 }, { 121,16,192,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 844)
		{ { 140,120,240,1 }, { 216,140,110,0 }, { 135,143,24,1 }, { 59,24,141,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 845)
		{ { 136,194,128,1 }, { 234,0,40,0 }, { 128,161,136,1 }, { 10,0,43,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 846)
		{ { 129,26,100,1 }, { 40,156,88,0 }, { 147,44,64,1 }, { 13,28,138,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 847)
		{ { 129,38,163,0 }, { 33,210,42,0 }, { 98,178,64,1 }, { 42,37,194,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 848)
		{ { 133,154,140,1 }, { 42,24,124,1 }, { 152,172,208,1 }, { 159,12,42,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 849)
		{ { 137,19,23,1 }, { 184,82,89,0 }, { 244,100,72,1 }, { 77,37,14,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 850)
		{ { 130,9,37,0 }, { 0,200,153,0 }, { 82,72,32,1 }, { 76,137,128,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 851)
		{ { 130,183,201,1 }, { 43,68,235,1 }, { 201,246,160,1 }, { 235,145,106,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 852)
		{ { 142,185,191,1 }, { 154,202,255,1 }, { 254,206,184,1 }, { 255,169,172,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 853)
		{ { 138,159,236,0 }, { 163,140,249,1 }, { 27,252,168,1 }, { 207,152,226,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 854)
		{ { 142,228,226,0 }, { 195,134,174,0 }, { 35,147,184,1 }, { 58,176,225,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 855)
		{ { 135,32,232,0 }, { 0,148,174,1 }, { 11,130,112,1 }, { 186,148,128,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 856)
		{ { 135,205,96,1 }, { 75,156,141,0 }, { 131,89,240,1 }, { 88,156,233,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 857)
		{ { 135,71,172,1 }, { 105,144,189,1 }, { 154,241,112,1 }, { 222,132,203,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 858)
		{ { 139,10,91,0 }, { 176,94,136,1 }, { 109,40,104,1 }, { 136,189,6,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 859)
		{ { 139,92,190,1 }, { 217,154,248,1 }, { 190,157,104,1 }, { 143,172,205,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 860)
		{ { 143,213,180,0 }, { 211,144,253,0 }, { 22,213,248,1 }, { 95,132,229,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 861)
		{ { 139,118,41,0 }, { 225,208,202,1 }, { 74,55,104,1 }, { 169,133,195,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 862)
		{ { 148,51,175,0 }, { 36,194,127,1 }, { 122,230,20,1 }, { 255,33,146,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 863)
		{ { 144,85,72,1 }, { 77,4,73,1 }, { 137,85,4,1 }, { 201,16,89,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 864)
		{ { 156,62,39,0 }, { 165,202,94,0 }, { 114,62,28,1 }, { 61,41,210,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 865)
		{ { 152,151,159,0 }, { 183,66,121,1 }, { 124,244,140,1 }, { 207,33,118,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 866)
		{ { 152,88,144,1 }, { 220,8,104,0 }, { 132,141,12,1 }, { 11,8,29,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 867)
		{ { 149,182,31,0 }, { 55,82,94,1 }, { 124,54,212,1 }, { 189,37,118,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 868)
		{ { 145,64,55,0 }, { 84,210,24,0 }, { 118,1,68,1 }, { 12,37,149,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 869)
		{ { 157,179,128,0 }, { 166,16,111,0 }, { 0,230,220,1 }, { 123,4,50,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 870)
		{ { 153,65,137,1 }, { 204,80,41,1 }, { 200,193,76,1 }, { 202,5,25,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 871)
		{ { 146,173,38,0 }, { 7,138,155,0 }, { 50,90,164,1 }, { 108,168,240,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 872)
		{ { 146,101,228,1 }, { 77,132,187,0 }, { 147,211,36,1 }, { 110,144,217,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 873)
		{ { 146,111,141,1 }, { 109,72,187,1 }, { 216,251,36,1 }, { 238,137,91,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 874)
		{ { 150,94,153,0 }, { 117,72,236,1 }, { 76,189,52,1 }, { 155,137,87,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 875)
		{ { 154,11,77,0 }, { 164,76,153,1 }, { 89,104,44,1 }, { 204,153,18,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 876)
		{ { 154,221,17,0 }, { 215,72,201,0 }, { 68,93,172,1 }, { 73,137,117,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 877)
		{ { 147,246,156,1 }, { 127,16,250,1 }, { 156,183,228,1 }, { 175,132,127,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 878)
		{ { 159,52,189,1 }, { 157,208,254,1 }, { 222,150,124,1 }, { 191,133,220,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 879)
		{ { 159,80,9,0 }, { 196,80,204,1 }, { 72,5,124,1 }, { 153,133,17,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 880)
		{ { 160,153,27,1 }, { 26,106,73,1 }, { 236,76,130,1 }, { 201,43,44,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 881)
		{ { 164,15,234,0 }, { 33,174,45,1 }, { 43,248,18,1 }, { 218,58,194,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 882)
		{ { 160,15,83,1 }, { 57,110,9,0 }, { 229,120,2,1 }, { 72,59,78,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 883)
		{ { 168,2,105,1 }, { 168,228,8,1 }, { 203,32,10,1 }, { 136,19,138,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 884)
		{ { 172,27,205,1 }, { 168,108,125,1 }, { 217,236,26,1 }, { 223,27,10,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 885)
		{ { 172,135,77,0 }, { 163,100,29,1 }, { 89,112,154,1 }, { 220,19,98,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 886)
		{ { 172,118,200,0 }, { 225,36,110,1 }, { 9,183,26,1 }, { 187,18,67,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 887)
		{ { 165,68,167,0 }, { 65,242,60,0 }, { 114,145,82,1 }, { 30,39,193,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 888)
		{ { 161,244,92,0 }, { 83,52,90,1 }, { 29,23,194,1 }, { 173,22,101,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 889)
		{ { 169,157,169,0 }, { 131,248,105,1 }, { 74,220,202,1 }, { 203,15,224,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 890)
		{ { 169,135,255,0 }, { 179,246,57,1 }, { 127,240,202,1 }, { 206,55,230,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 891)
		{ { 169,71,98,1 }, { 233,182,9,0 }, { 163,113,74,1 }, { 72,54,203,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 892)
		{ { 166,129,114,1 }, { 26,166,141,0 }, { 167,64,178,1 }, { 88,178,172,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 893)
		{ { 166,249,172,1 }, { 74,168,255,1 }, { 154,207,178,1 }, { 255,138,169,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 894)
		{ { 162,196,38,0 }, { 67,162,152,0 }, { 50,17,162,1 }, { 12,162,225,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 895)
		{ { 170,53,101,1 }, { 137,228,219,0 }, { 211,86,42,1 }, { 109,147,200,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 896)
		{ { 170,168,102,0 }, { 130,174,154,0 }, { 51,10,170,1 }, { 44,186,160,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 897)
		{ { 170,200,143,0 }, { 194,106,184,1 }, { 120,137,170,1 }, { 142,171,33,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 898)
		{ { 167,110,148,1 }, { 121,56,190,0 }, { 148,187,114,1 }, { 62,142,79,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 899)
		{ { 175,4,36,1 }, { 137,176,156,0 }, { 146,16,122,1 }, { 28,134,200,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 900)
		{ { 176,65,44,0 }, { 68,160,25,1 }, { 26,65,6,1 }, { 204,2,145,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 901)
		{ { 176,208,227,0 }, { 70,230,104,0 }, { 99,133,134,1 }, { 11,51,177,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 902)
		{ { 176,237,129,1 }, { 79,104,43,0 }, { 192,219,134,1 }, { 106,11,121,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 903)
		{ { 180,231,236,0 }, { 103,164,63,1 }, { 27,243,150,1 }, { 254,18,243,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 904)
		{ { 184,160,236,1 }, { 142,164,58,1 }, { 155,130,142,1 }, { 174,18,184,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 905)
		{ { 184,188,60,1 }, { 159,168,90,1 }, { 158,30,142,1 }, { 173,10,252,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 906)
		{ { 177,102,224,1 }, { 109,180,42,0 }, { 131,179,70,1 }, { 42,22,219,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 907)
		{ { 189,49,10,1 }, { 140,50,79,1 }, { 168,70,94,1 }, { 249,38,24,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 908)
		{ { 189,63,186,1 }, { 189,186,111,1 }, { 174,254,94,1 }, { 251,46,222,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 909)
		{ { 185,190,220,0 }, { 183,60,122,1 }, { 29,190,206,1 }, { 175,30,118,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 910)
		{ { 178,58,240,1 }, { 60,172,234,0 }, { 135,174,38,1 }, { 43,154,158,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 911)
		{ { 182,207,169,0 }, { 103,232,173,1 }, { 74,249,182,1 }, { 218,139,243,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 912)
		{ { 186,35,226,1 }, { 172,166,171,0 }, { 163,226,46,1 }, { 106,178,154,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 913)
		{ { 183,36,171,1 }, { 13,242,174,1 }, { 234,146,118,1 }, { 186,167,216,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 914)
		{ { 183,41,251,0 }, { 20,254,175,1 }, { 111,202,118,1 }, { 250,191,148,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 915)
		{ { 179,174,8,0 }, { 39,56,138,1 }, { 8,58,230,1 }, { 168,142,114,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 916)
		{ { 183,86,202,1 }, { 109,54,236,1 }, { 169,181,118,1 }, { 155,182,91,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 917)
		{ { 191,168,244,0 }, { 150,188,190,0 }, { 23,138,254,1 }, { 62,158,180,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 918)
		{ { 191,148,18,1 }, { 159,50,204,0 }, { 164,20,254,1 }, { 25,166,124,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 919)
		{ { 191,122,64,1 }, { 236,60,206,0 }, { 129,47,126,1 }, { 57,158,27,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 920)
		{ { 196,133,200,0 }, { 3,5,45,1 }, { 9,208,145,1 }, { 218,80,96,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 921)
		{ { 192,14,9,1 }, { 41,73,8,1 }, { 200,56,1,1 }, { 136,73,74,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 922)
		{ { 192,112,254,0 }, { 80,135,122,1 }, { 63,135,1,1 }, { 175,112,133,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 923)
		{ { 204,116,17,0 }, { 209,65,78,0 }, { 68,23,25,1 }, { 57,65,69,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 924)
		{ { 193,8,90,1 }, { 24,31,8,1 }, { 173,8,65,1 }, { 136,124,12,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 925)
		{ { 193,47,130,1 }, { 41,27,43,0 }, { 160,250,65,1 }, { 106,108,74,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 926)
		{ { 193,35,120,0 }, { 48,149,11,1 }, { 15,98,65,1 }, { 232,84,134,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 927)
		{ { 198,52,219,1 }, { 25,71,238,1 }, { 237,150,49,1 }, { 187,241,76,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 928)
		{ { 198,164,244,1 }, { 27,133,190,0 }, { 151,146,177,1 }, { 62,208,236,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 929)
		{ { 194,228,25,0 }, { 83,65,138,1 }, { 76,19,161,1 }, { 168,193,101,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 930)
		{ { 195,29,35,0 }, { 1,219,201,0 }, { 98,92,97,1 }, { 73,237,192,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 931)
		{ { 195,242,196,1 }, { 106,21,250,0 }, { 145,167,225,1 }, { 47,212,43,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 932)
		{ { 199,95,223,0 }, { 113,95,253,1 }, { 125,253,113,1 }, { 223,253,71,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 933)
		{ { 203,101,189,0 }, { 209,209,187,1 }, { 94,211,105,1 }, { 238,197,197,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 934)
		{ { 203,199,15,1 }, { 235,83,153,1 }, { 248,113,233,1 }, { 204,229,107,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 935)
		{ { 207,246,185,0 }, { 243,209,238,1 }, { 78,183,249,1 }, { 187,197,231,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 936)
		{ { 212,84,239,0 }, { 69,199,124,1 }, { 123,149,21,1 }, { 159,113,209,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 937)
		{ { 212,251,220,0 }, { 118,13,127,1 }, { 29,239,149,1 }, { 255,88,55,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 938)
		{ { 220,232,84,0 }, { 214,13,30,0 }, { 21,11,157,1 }, { 60,88,53,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 939)
		{ { 213,177,150,0 }, { 22,19,127,0 }, { 52,198,213,1 }, { 127,100,52,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 940)
		{ { 209,159,7,1 }, { 47,91,89,0 }, { 240,124,197,1 }, { 77,109,122,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 941)
		{ { 209,93,126,1 }, { 93,159,89,1 }, { 191,93,69,1 }, { 205,124,221,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 942)
		{ { 217,164,134,1 }, { 143,19,58,0 }, { 176,146,205,1 }, { 46,100,120,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 943)
		{ { 221,9,48,1 }, { 156,153,13,0 }, { 134,72,93,1 }, { 88,76,156,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 944)
		{ { 217,180,57,1 }, { 159,209,74,1 }, { 206,22,205,1 }, { 169,69,252,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 945)
		{ { 221,171,105,1 }, { 174,221,15,1 }, { 203,106,221,1 }, { 248,93,186,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 946)
		{ { 217,203,66,0 }, { 230,31,9,0 }, { 33,105,205,1 }, { 72,124,51,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 947)
		{ { 210,33,13,0 }, { 4,65,155,1 }, { 88,66,37,1 }, { 236,193,16,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 948)
		{ { 214,73,4,0 }, { 68,9,157,0 }, { 16,73,53,1 }, { 92,200,17,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 949)
		{ { 210,216,219,0 }, { 86,79,232,1 }, { 109,141,165,1 }, { 139,249,53,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 950)
		{ { 218,63,69,1 }, { 173,77,219,0 }, { 209,126,45,1 }, { 109,217,90,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 951)
		{ { 218,125,218,0 }, { 213,15,235,1 }, { 45,223,45,1 }, { 235,248,85,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 952)
		{ { 218,211,230,0 }, { 230,135,249,0 }, { 51,229,173,1 }, { 79,240,179,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 953)
		{ { 211,51,189,0 }, { 52,209,251,1 }, { 94,230,101,1 }, { 239,197,150,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 954)
		{ { 215,225,237,1 }, { 78,213,191,1 }, { 219,195,245,1 }, { 254,213,185,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 955)
		{ { 219,197,122,0 }, { 215,151,137,1 }, { 47,81,237,1 }, { 200,244,245,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 956)
		{ { 224,128,59,1 }, { 26,227,8,1 }, { 238,0,131,1 }, { 136,99,172,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 957)
		{ { 224,207,105,1 }, { 107,237,9,1 }, { 203,121,131,1 }, { 200,91,235,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 958)
		{ { 228,71,48,1 }, { 121,161,13,0 }, { 134,113,19,1 }, { 88,66,207,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 959)
		{ { 232,29,86,1 }, { 153,47,89,0 }, { 181,92,11,1 }, { 77,122,76,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 960)
		{ { 232,243,72,1 }, { 234,37,75,1 }, { 137,103,139,1 }, { 233,82,43,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 961)
		{ { 232,254,175,0 }, { 227,235,122,1 }, { 122,191,139,1 }, { 175,107,227,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 962)
		{ { 236,231,159,0 }, { 243,99,63,1 }, { 124,243,155,1 }, { 254,99,103,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 963)
		{ { 225,60,212,1 }, { 25,61,122,0 }, { 149,158,67,1 }, { 47,94,76,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 964)
		{ { 229,204,106,1 }, { 75,191,12,1 }, { 171,25,211,1 }, { 152,126,233,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 965)
		{ { 233,175,154,0 }, { 179,59,43,1 }, { 44,250,203,1 }, { 234,110,102,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 966)
		{ { 227,0,237,0 }, { 0,245,184,1 }, { 91,128,99,1 }, { 142,215,128,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 967)
		{ { 231,177,14,0 }, { 2,51,223,1 }, { 56,70,243,1 }, { 253,230,32,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 968)
		{ { 227,192,126,0 }, { 82,183,152,1 }, { 63,1,227,1 }, { 140,246,165,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 969)
		{ { 235,140,163,0 }, { 131,251,168,0 }, { 98,152,235,1 }, { 10,239,224,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 970)
		{ { 235,159,109,1 }, { 171,253,217,1 }, { 219,124,235,1 }, { 205,223,234,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 971)
		{ { 239,65,11,0 }, { 192,115,141,1 }, { 104,65,123,1 }, { 216,231,1,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 972)
		{ { 239,194,195,0 }, { 226,119,172,0 }, { 97,161,251,1 }, { 26,247,35,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 973)
		{ { 240,168,32,0 }, { 6,169,10,0 }, { 2,10,135,1 }, { 40,74,176,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 974)
		{ { 244,25,211,0 }, { 20,111,109,0 }, { 101,204,23,1 }, { 91,123,20,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 975)
		{ { 244,133,191,1 }, { 31,227,61,1 }, { 254,208,151,1 }, { 222,99,252,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 976)
		{ { 240,106,204,0 }, { 100,45,58,1 }, { 25,171,7,1 }, { 174,90,19,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 977)
		{ { 240,123,107,1 }, { 108,239,75,1 }, { 235,111,7,1 }, { 233,123,155,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 978)
		{ { 244,251,170,0 }, { 102,171,111,1 }, { 42,239,151,1 }, { 251,106,179,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 979)
		{ { 252,198,47,0 }, { 231,227,28,1 }, { 122,49,159,1 }, { 156,99,243,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 980)
		{ { 248,111,16,0 }, { 245,41,11,0 }, { 4,123,15,1 }, { 104,74,87,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 981)
		{ { 252,127,120,1 }, { 253,173,79,1 }, { 143,127,31,1 }, { 249,90,223,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 982)
		{ { 241,171,217,0 }, { 54,125,43,1 }, { 77,234,199,1 }, { 234,95,54,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 983)
		{ { 245,81,143,1 }, { 76,115,125,1 }, { 248,197,87,1 }, { 223,103,25,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 984)
		{ { 241,248,166,1 }, { 78,187,122,0 }, { 178,143,199,1 }, { 47,110,185,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 985)
		{ { 241,86,24,0 }, { 117,49,72,1 }, { 12,53,71,1 }, { 137,70,87,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 986)
		{ { 253,132,196,0 }, { 135,53,60,0 }, { 17,144,223,1 }, { 30,86,112,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 987)
		{ { 249,141,114,1 }, { 159,191,9,0 }, { 167,88,207,1 }, { 72,126,252,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 988)
		{ { 253,15,85,1 }, { 189,125,29,0 }, { 213,120,95,1 }, { 92,95,94,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 989)
		{ { 242,156,111,1 }, { 15,239,216,1 }, { 251,28,167,1 }, { 141,251,248,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 990)
		{ { 246,136,24,1 }, { 30,41,140,1 }, { 140,8,183,1 }, { 152,202,60,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 991)
		{ { 246,7,197,0 }, { 37,101,189,0 }, { 81,240,55,1 }, { 94,211,82,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 992)
		{ { 242,65,215,0 }, { 84,103,185,0 }, { 117,193,39,1 }, { 78,243,21,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 993)
		{ { 246,241,27,0 }, { 86,99,207,1 }, { 108,71,183,1 }, { 249,227,53,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 994)
		{ { 242,230,203,1 }, { 111,103,170,1 }, { 233,179,167,1 }, { 170,243,123,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 995)
		{ { 250,213,32,1 }, { 207,161,201,0 }, { 130,85,175,1 }, { 73,194,249,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 996)
		{ { 254,67,233,0 }, { 228,229,173,1 }, { 75,225,63,1 }, { 218,211,147,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 997)
		{ { 243,251,142,0 }, { 102,59,251,1 }, { 56,239,231,1 }, { 239,238,51,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 998)
		{ { 255,187,218,0 }, { 182,63,239,1 }, { 45,238,255,1 }, { 251,254,54,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 999)
		{ { 251,201,14,1 }, { 206,59,153,1 }, { 184,73,239,1 }, { 204,238,57,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1000)
	#error invalid ARUCO_DB_SIZE, max database size for this aruco type is 1000
	#endif

};

#elif (ARUCO_DB == ARUCO_DB_6X6_1000)

#ifndef ARUCO_DB_SIZE
#define ARUCO_DB_SIZE 1000
#endif

#define ARUCO_BITS	6

static unsigned char database[ARUCO_DB_SIZE][4][5] = {
	#if (ARUCO_DB_SIZE > 0)
		{ { 30,61,216,42,6 }, { 227,186,70,49,9 }, { 101,65,187,199,8 }, { 152,198,37,220,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1)
		{ { 14,251,163,137,1 }, { 215,230,24,5,14 }, { 137,28,93,247,0 }, { 122,1,134,126,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2)
		{ { 21,144,126,172,13 }, { 236,105,87,80,6 }, { 179,87,224,154,8 }, { 96,174,169,99,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 3)
		{ { 201,27,48,105,14 }, { 66,50,75,222,12 }, { 121,96,205,137,3 }, { 55,189,36,196,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 4)
		{ { 214,7,214,225,5 }, { 164,203,74,191,2 }, { 168,118,190,6,11 }, { 79,213,45,50,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 5)
		{ { 216,232,224,230,8 }, { 43,140,19,138,15 }, { 22,112,113,113,11 }, { 245,28,131,29,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 6)
		{ { 66,104,180,31,5 }, { 13,165,192,149,13 }, { 175,130,209,100,2 }, { 186,144,58,91,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 7)
		{ { 136,165,15,41,10 }, { 19,115,23,38,0 }, { 89,79,10,81,1 }, { 6,78,140,236,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 8)
		{ { 48,125,82,79,13 }, { 109,110,97,60,9 }, { 191,36,171,224,12 }, { 147,200,103,107,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 9)
		{ { 60,47,52,179,12 }, { 131,11,235,52,15 }, { 60,210,207,67,12 }, { 242,205,125,12,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 10)
		{ { 69,223,199,78,3 }, { 252,247,24,232,9 }, { 199,46,63,186,2 }, { 145,113,142,243,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 11)
		{ { 72,216,91,37,7 }, { 126,84,86,148,8 }, { 234,77,161,177,2 }, { 18,150,162,167,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 12)
		{ { 113,5,88,252,6 }, { 40,58,230,248,2 }, { 99,241,170,8,14 }, { 65,246,117,193,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 13)
		{ { 134,220,250,208,7 }, { 228,212,212,59,14 }, { 224,181,243,182,1 }, { 125,194,178,178,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 14)
		{ { 141,114,169,63,6 }, { 219,180,206,70,5 }, { 111,201,84,235,1 }, { 166,39,50,221,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 15)
		{ { 162,184,157,205,14 }, { 89,177,117,31,10 }, { 123,59,145,212,5 }, { 95,138,232,217,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 16)
		{ { 9,253,30,156,4 }, { 75,103,212,112,10 }, { 35,151,139,249,0 }, { 80,226,190,109,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 17)
		{ { 21,77,189,24,15 }, { 148,191,197,112,12 }, { 241,139,219,42,8 }, { 48,234,63,210,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 18)
		{ { 48,10,49,14,2 }, { 24,56,40,16,13 }, { 71,8,197,0,12 }, { 176,129,65,193,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 19)
		{ { 72,7,239,175,13 }, { 62,227,79,164,7 }, { 191,95,126,1,2 }, { 226,95,44,119,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 20)
		{ { 86,223,17,219,6 }, { 208,62,216,189,11 }, { 109,184,143,182,10 }, { 219,209,183,192,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 21)
		{ { 102,136,50,116,12 }, { 136,64,243,153,12 }, { 50,228,193,22,6 }, { 57,156,240,33,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 22)
		{ { 118,232,203,120,1 }, { 181,236,182,137,8 }, { 129,237,49,118,14 }, { 25,22,211,122,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 23)
		{ { 154,83,217,207,3 }, { 126,190,12,31,3 }, { 207,57,188,165,9 }, { 207,131,7,215,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 24)
		{ { 169,203,132,2,4 }, { 2,135,120,66,9 }, { 36,2,29,57,5 }, { 148,33,238,20,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 25)
		{ { 198,117,73,73,0 }, { 241,38,4,175,0 }, { 9,41,42,230,3 }, { 15,82,6,72,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 26)
		{ { 193,210,136,148,1 }, { 76,132,156,194,2 }, { 130,145,20,184,3 }, { 68,51,146,19,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 27)
		{ { 231,72,8,82,11 }, { 132,20,165,203,9 }, { 212,161,1,46,7 }, { 157,58,82,130,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 28)
		{ { 234,47,202,132,8 }, { 43,194,45,163,10 }, { 18,21,63,69,7 }, { 92,91,68,61,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 29)
		{ { 233,99,183,123,1 }, { 23,231,170,222,5 }, { 141,238,220,105,7 }, { 167,181,94,126,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 30)
		{ { 250,54,101,42,15 }, { 119,57,107,163,5 }, { 245,74,102,197,15 }, { 172,93,105,206,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 31)
		{ { 6,91,255,123,13 }, { 244,231,207,29,13 }, { 189,239,253,166,0 }, { 187,143,62,114,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 32)
		{ { 5,65,215,45,6 }, { 184,247,66,84,0 }, { 107,78,184,42,0 }, { 2,164,46,241,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 33)
		{ { 12,247,36,106,2 }, { 195,55,26,40,5 }, { 69,98,78,243,0 }, { 161,69,142,204,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 34)
		{ { 19,56,163,158,11 }, { 93,248,129,65,15 }, { 215,156,81,204,8 }, { 248,40,17,251,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 35)
		{ { 21,168,147,231,4 }, { 153,200,82,92,11 }, { 46,124,145,90,8 }, { 211,164,161,57,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 36)
		{ { 58,65,126,233,14 }, { 34,127,103,29,6 }, { 121,119,232,37,12 }, { 107,142,111,228,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 37)
		{ { 79,17,226,108,0 }, { 234,226,2,201,4 }, { 3,100,120,143,2 }, { 41,52,4,117,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 38)
		{ { 83,13,182,210,0 }, { 0,203,128,249,15 }, { 4,182,219,12,10 }, { 249,240,29,48,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 39)
		{ { 88,155,250,227,4 }, { 98,202,94,156,15 }, { 44,117,253,145,10 }, { 243,151,165,52,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 40)
		{ { 100,9,232,160,11 }, { 164,146,39,128,14 }, { 208,81,121,2,6 }, { 112,30,68,146,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 41)
		{ { 96,83,122,137,1 }, { 100,102,44,148,6 }, { 137,21,236,160,6 }, { 98,147,70,98,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 42)
		{ { 97,89,6,155,10 }, { 64,119,161,196,11 }, { 93,150,9,168,6 }, { 210,56,94,224,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 43)
		{ { 107,255,120,215,11 }, { 111,22,189,253,15 }, { 222,177,239,253,6 }, { 251,251,214,143,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 44)
		{ { 112,173,150,164,15 }, { 13,219,115,176,10 }, { 242,86,155,80,14 }, { 80,220,237,187,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 45)
		{ { 117,132,111,113,10 }, { 176,89,183,236,4 }, { 88,239,98,26,14 }, { 35,126,217,160,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 46)
		{ { 122,149,25,47,12 }, { 90,42,119,181,1 }, { 63,73,138,149,14 }, { 138,222,229,69,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 47)
		{ { 134,9,118,10,10 }, { 160,115,1,19,13 }, { 85,6,233,6,1 }, { 188,136,12,224,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 48)
		{ { 138,45,68,195,15 }, { 39,19,65,47,11 }, { 252,50,43,69,1 }, { 223,72,44,142,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 49)
		{ { 147,235,120,177,4 }, { 33,14,222,87,14 }, { 40,209,237,124,9 }, { 126,167,183,8,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 50)
		{ { 152,141,168,77,4 }, { 10,170,84,46,12 }, { 43,33,91,17,9 }, { 55,66,165,85,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 51)
		{ { 158,222,43,60,8 }, { 218,108,159,35,12 }, { 19,205,71,183,9 }, { 60,79,147,101,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 52)
		{ { 165,41,224,123,8 }, { 161,162,163,78,13 }, { 29,224,121,74,5 }, { 183,44,84,88,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 53)
		{ { 181,147,184,85,15 }, { 204,154,253,94,4 }, { 250,161,220,154,13 }, { 39,171,245,147,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 54)
		{ { 183,248,228,38,15 }, { 237,157,115,67,13 }, { 246,66,113,254,13 }, { 188,44,235,155,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 55)
		{ { 188,32,82,37,14 }, { 171,88,99,22,0 }, { 122,68,160,67,13 }, { 6,140,97,173,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 56)
		{ { 192,68,135,118,5 }, { 28,197,194,170,1 }, { 166,238,18,32,3 }, { 133,84,58,51,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 57)
		{ { 196,195,36,37,9 }, { 140,7,27,134,4 }, { 154,66,76,50,3 }, { 38,29,142,3,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 58)
		{ { 197,169,27,216,13 }, { 149,98,213,218,10 }, { 177,189,137,90,3 }, { 85,186,180,106,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 59)
		{ { 206,115,230,178,12 }, { 227,199,203,131,7 }, { 52,214,124,231,3 }, { 236,29,62,60,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 60)
		{ { 205,12,166,39,2 }, { 138,209,2,230,13 }, { 78,70,83,11,3 }, { 182,116,8,181,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 61)
		{ { 201,67,93,68,13 }, { 62,7,77,218,0 }, { 178,43,172,41,3 }, { 5,187,46,7,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 62)
		{ { 207,190,128,243,4 }, { 195,128,218,239,11 }, { 44,240,23,223,3 }, { 223,117,176,28,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 63)
		{ { 229,125,21,135,7 }, { 221,23,96,246,11 }, { 238,26,139,234,7 }, { 214,240,110,139,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 64)
		{ { 239,198,133,142,9 }, { 158,165,57,227,3 }, { 151,26,22,63,7 }, { 204,121,202,87,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 65)
		{ { 247,126,243,119,2 }, { 249,220,170,255,13 }, { 78,236,247,238,15 }, { 191,245,83,185,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 66)
		{ { 44,228,63,37,4 }, { 155,69,118,52,4 }, { 42,79,194,115,4 }, { 34,198,234,45,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 67)
		{ { 43,220,255,75,3 }, { 118,245,52,125,13 }, { 205,47,243,189,4 }, { 187,226,202,246,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 68)
		{ { 55,199,221,189,10 }, { 184,191,191,117,2 }, { 91,219,190,62,12 }, { 74,239,223,209,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 69)
		{ { 161,162,84,224,15 }, { 37,17,123,90,2 }, { 240,114,164,88,5 }, { 69,173,232,138,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 70)
		{ { 169,130,193,187,5 }, { 54,160,250,70,3 }, { 173,216,52,25,5 }, { 198,37,240,86,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 71)
		{ { 216,27,73,176,8 }, { 114,10,143,130,10 }, { 16,217,45,129,11 }, { 84,31,21,4,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 72)
		{ { 3,88,41,248,6 }, { 80,52,198,73,14 }, { 97,249,65,172,0 }, { 121,38,50,192,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 73)
		{ { 7,196,9,95,12 }, { 152,36,213,109,1 }, { 63,169,2,62,0 }, { 139,106,178,65,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 74)
		{ { 15,226,102,23,11 }, { 175,85,153,69,5 }, { 222,134,100,127,0 }, { 170,41,154,175,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 75)
		{ { 20,72,54,68,1 }, { 140,77,0,24,12 }, { 130,38,193,34,8 }, { 49,128,11,35,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 76)
		{ { 16,173,95,251,7 }, { 53,123,214,60,11 }, { 237,255,171,80,8 }, { 211,198,189,234,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 77)
		{ { 18,130,149,83,15 }, { 20,153,217,29,1 }, { 252,170,148,20,8 }, { 139,137,185,146,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 78)
		{ { 22,225,49,132,12 }, { 153,14,81,17,6 }, { 50,24,200,118,8 }, { 104,136,167,9,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 79)
		{ { 24,122,73,107,0 }, { 115,44,14,12,9 }, { 13,105,37,225,8 }, { 147,7,3,76,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 80)
		{ { 26,232,134,17,2 }, { 3,221,144,5,8 }, { 72,134,17,117,8 }, { 26,0,155,188,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 81)
		{ { 25,19,174,10,1 }, { 70,235,12,64,5 }, { 133,7,92,137,8 }, { 160,35,13,118,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 82)
		{ { 27,103,181,161,7 }, { 23,159,74,117,6 }, { 232,90,222,109,8 }, { 106,229,47,158,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 83)
		{ { 37,220,149,240,11 }, { 212,149,179,120,10 }, { 208,250,147,186,4 }, { 81,236,218,146,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 84)
		{ { 40,137,97,247,6 }, { 58,18,242,12,15 }, { 110,248,105,17,4 }, { 243,4,244,133,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 85)
		{ { 51,84,20,106,10 }, { 64,61,35,121,1 }, { 85,98,130,172,12 }, { 137,236,75,192,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 86)
		{ { 49,193,108,31,7 }, { 44,63,244,68,5 }, { 239,131,104,56,12 }, { 162,34,255,195,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 87)
		{ { 51,203,24,198,6 }, { 8,30,124,89,11 }, { 102,49,141,60,12 }, { 217,163,231,129,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 88)
		{ { 62,207,228,144,15 }, { 166,159,249,33,14 }, { 240,146,127,55,12 }, { 120,73,255,150,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 89)
		{ { 70,69,24,163,15 }, { 132,22,71,181,3 }, { 252,81,138,38,2 }, { 202,222,38,130,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 90)
		{ { 68,186,112,182,7 }, { 237,16,218,144,15 }, { 230,208,229,210,2 }, { 240,149,176,139,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 91)
		{ { 65,156,98,62,8 }, { 104,96,147,224,13 }, { 23,196,99,152,2 }, { 176,124,144,97,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 92)
		{ { 72,209,145,74,1 }, { 86,166,16,152,1 }, { 133,40,152,177,2 }, { 129,144,134,86,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 93)
		{ { 84,244,153,246,13 }, { 221,140,215,184,3 }, { 182,249,146,242,10 }, { 193,222,179,27,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 94)
		{ { 87,90,156,129,3 }, { 196,157,12,213,10 }, { 200,19,149,174,10 }, { 90,179,11,146,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 95)
		{ { 85,131,85,178,12 }, { 176,11,219,208,3 }, { 52,218,172,26,10 }, { 192,189,189,0,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 96)
		{ { 87,183,118,16,15 }, { 229,91,217,241,4 }, { 240,134,238,222,10 }, { 40,249,189,170,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 97)
		{ { 92,52,54,254,4 }, { 203,105,194,184,7 }, { 39,246,194,195,10 }, { 225,212,57,109,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 98)
		{ { 92,72,252,119,14 }, { 170,157,199,156,13 }, { 126,227,241,35,10 }, { 179,158,59,149,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 99)
		{ { 94,110,239,64,2 }, { 179,221,12,169,12 }, { 64,47,119,103,10 }, { 57,83,11,188,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 100)
		{ { 95,35,59,111,15 }, { 159,122,79,221,5 }, { 255,109,204,79,10 }, { 171,191,37,239,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 101)
		{ { 91,116,42,99,2 }, { 67,92,6,237,5 }, { 76,101,66,237,10 }, { 171,118,3,172,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 102)
		{ { 101,15,163,58,14 }, { 144,242,235,224,13 }, { 117,204,95,10,6 }, { 176,125,116,240,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 103)
		{ { 101,211,23,92,12 }, { 216,103,249,216,0 }, { 51,174,140,186,6 }, { 1,185,254,97,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 104)
		{ { 106,156,36,90,14 }, { 66,49,241,169,13 }, { 117,162,67,149,6 }, { 185,88,248,196,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 105)
		{ { 105,197,243,4,2 }, { 58,214,48,240,4 }, { 66,12,250,57,6 }, { 32,240,198,181,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 106)
		{ { 105,210,72,78,10 }, { 106,52,61,200,1 }, { 87,33,36,185,6 }, { 129,59,194,197,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 107)
		{ { 116,121,226,222,6 }, { 233,254,224,136,15 }, { 103,180,121,226,14 }, { 241,16,119,249,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 108)
		{ { 114,207,35,234,11 }, { 20,126,59,169,15 }, { 213,124,79,52,14 }, { 249,93,199,226,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 109)
		{ { 119,177,220,65,4 }, { 225,139,116,221,0 }, { 40,35,184,222,14 }, { 11,178,237,24,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 110)
		{ { 126,12,7,33,7 }, { 150,89,98,165,8 }, { 232,78,3,7,14 }, { 26,84,105,166,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 111)
		{ { 122,105,112,100,7 }, { 47,30,98,153,12 }, { 226,96,233,101,14 }, { 57,148,103,143,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 112)
		{ { 120,178,216,112,7 }, { 103,152,254,152,0 }, { 224,225,180,209,14 }, { 1,151,241,158,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 113)
		{ { 121,197,133,121,4 }, { 18,175,242,236,0 }, { 41,234,26,57,14 }, { 3,116,255,84,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 114)
		{ { 134,111,89,252,6 }, { 185,54,206,59,10 }, { 99,249,175,102,1 }, { 93,199,54,201,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 115)
		{ { 130,246,114,127,5 }, { 109,100,218,63,5 }, { 175,228,230,244,1 }, { 175,197,178,107,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 116)
		{ { 133,78,47,65,4 }, { 144,69,76,110,12 }, { 40,47,71,42,1 }, { 55,99,42,32,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 117)
		{ { 154,17,133,147,4 }, { 82,139,192,7,3 }, { 44,154,24,133,9 }, { 206,0,61,20,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 118)
		{ { 156,113,96,201,7 }, { 231,62,64,14,6 }, { 233,48,104,227,9 }, { 103,0,39,206,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 119)
		{ { 157,209,148,253,8 }, { 202,175,147,94,2 }, { 27,242,152,187,9 }, { 71,172,159,85,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 120)
		{ { 162,30,18,227,8 }, { 64,64,43,63,11 }, { 28,116,135,132,5 }, { 223,205,64,32,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 121)
		{ { 174,112,28,130,12 }, { 195,5,101,19,3 }, { 52,19,128,231,5 }, { 204,138,106,12,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 122)
		{ { 173,1,33,156,1 }, { 158,34,160,66,6 }, { 131,152,72,11,5 }, { 100,32,84,71,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 123)
		{ { 176,53,31,158,14 }, { 89,123,229,50,3 }, { 119,159,138,192,13 }, { 196,202,125,233,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 124)
		{ { 182,74,216,13,4 }, { 168,172,108,23,8 }, { 43,1,181,38,13 }, { 30,131,99,81,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 125)
		{ { 181,55,49,75,4 }, { 209,42,104,126,5 }, { 45,40,206,202,13 }, { 167,225,101,72,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 126)
		{ { 190,170,199,227,11 }, { 183,217,59,15,11 }, { 220,126,53,87,13 }, { 223,13,201,190,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 127)
		{ { 187,104,61,188,15 }, { 31,61,231,83,14 }, { 243,219,193,109,13 }, { 124,174,123,207,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 128)
		{ { 198,114,247,44,1 }, { 253,229,10,147,4 }, { 131,78,244,230,3 }, { 44,149,10,123,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 129)
		{ { 193,231,77,186,11 }, { 53,55,159,226,3 }, { 213,219,46,120,3 }, { 196,127,158,202,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 130)
		{ { 203,85,238,89,13 }, { 102,231,197,239,4 }, { 185,167,122,173,3 }, { 47,122,62,118,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 131)
		{ { 203,160,83,114,4 }, { 51,64,210,219,1 }, { 36,236,160,93,3 }, { 141,180,176,44,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 132)
		{ { 208,9,15,207,1 }, { 28,107,4,142,11 }, { 143,63,9,0,11 }, { 215,18,13,99,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 133)
		{ { 208,108,58,213,4 }, { 9,76,196,190,14 }, { 42,181,195,96,11 }, { 119,210,51,41,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 134)
		{ { 211,241,32,87,4 }, { 73,14,208,207,5 }, { 46,160,72,252,11 }, { 175,48,183,9,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 135)
		{ { 230,227,59,26,7 }, { 149,118,252,147,5 }, { 229,141,204,118,7 }, { 172,147,246,234,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 136)
		{ { 227,83,62,164,10 }, { 72,87,47,211,6 }, { 82,87,204,172,7 }, { 108,191,78,161,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 137)
		{ { 232,6,142,177,4 }, { 2,193,238,166,2 }, { 40,215,22,1,7 }, { 70,87,120,52,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 138)
		{ { 236,7,192,89,7 }, { 166,178,232,174,0 }, { 233,160,62,3,7 }, { 7,81,116,214,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 139)
		{ { 234,243,128,61,10 }, { 75,182,187,135,0 }, { 91,192,28,245,7 }, { 14,29,214,221,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 140)
		{ { 246,59,39,216,8 }, { 209,107,169,139,14 }, { 17,190,77,198,15 }, { 125,25,93,104,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 141)
		{ { 243,7,152,55,9 }, { 12,138,175,247,1 }, { 158,193,158,12,15 }, { 142,255,85,19,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 142)
		{ { 254,75,186,155,9 }, { 134,238,173,151,15 }, { 157,149,221,39,15 }, { 254,155,87,118,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 143)
		{ { 171,165,125,134,11 }, { 63,19,53,115,7 }, { 214,27,234,93,5 }, { 236,234,204,143,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 144)
		{ { 192,209,98,90,11 }, { 100,118,145,138,5 }, { 213,164,104,176,3 }, { 165,24,150,226,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 145)
		{ { 19,206,123,174,7 }, { 60,124,94,113,15 }, { 231,93,231,60,8 }, { 248,231,163,227,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 146)
		{ { 78,129,253,97,7 }, { 182,147,86,157,4 }, { 232,107,248,23,2 }, { 43,150,172,150,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 147)
		{ { 86,224,118,50,0 }, { 161,77,146,145,5 }, { 4,198,224,118,10 }, { 168,148,155,40,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 148)
		{ { 106,112,138,84,0 }, { 75,196,164,137,0 }, { 2,165,16,229,6 }, { 9,18,82,61,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 149)
		{ { 114,168,152,161,8 }, { 1,136,55,149,10 }, { 24,81,145,84,14 }, { 90,158,193,24,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 150)
		{ { 129,93,66,248,0 }, { 96,102,130,106,10 }, { 1,244,43,168,1 }, { 85,100,22,96,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 151)
		{ { 207,76,195,213,15 }, { 190,212,193,239,10 }, { 250,188,51,47,3 }, { 95,120,50,183,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 152)
		{ { 214,187,101,134,4 }, { 249,11,88,131,15 }, { 38,26,109,214,11 }, { 252,17,173,9,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 153)
		{ { 236,211,19,163,1 }, { 214,70,58,150,3 }, { 140,92,140,179,7 }, { 198,149,198,38,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 154)
		{ { 245,33,245,32,7 }, { 181,155,98,210,4 }, { 224,74,248,74,15 }, { 36,180,109,154,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 155)
		{ { 249,31,165,223,7 }, { 94,187,232,238,15 }, { 239,186,95,137,15 }, { 247,113,125,215,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 156)
		{ { 0,36,244,122,7 }, { 37,177,194,56,5 }, { 229,226,242,64,0 }, { 161,196,56,218,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 157)
		{ { 0,8,77,136,2 }, { 48,49,4,0,10 }, { 65,27,33,0,0 }, { 80,2,8,192,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 158)
		{ { 4,60,194,242,9 }, { 229,192,131,40,11 }, { 148,244,51,194,0 }, { 209,76,16,58,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 159)
		{ { 4,123,80,33,1 }, { 229,6,10,20,8 }, { 136,64,173,226,0 }, { 18,133,6,10,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 160)
		{ { 6,122,228,193,13 }, { 229,133,73,13,14 }, { 184,50,117,230,0 }, { 123,9,42,26,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 161)
		{ { 0,170,150,138,3 }, { 5,241,24,16,11 }, { 197,22,149,80,0 }, { 208,129,136,250,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 162)
		{ { 4,209,56,233,4 }, { 192,38,86,28,6 }, { 41,113,200,178,0 }, { 99,134,166,64,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 163)
		{ { 5,16,168,13,10 }, { 200,176,5,68,4 }, { 91,1,80,138,0 }, { 34,42,0,209,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 164)
		{ { 1,64,176,0,7 }, { 4,148,64,80,4 }, { 224,0,208,40,0 }, { 32,160,34,146,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 165)
		{ { 1,157,156,238,1 }, { 76,163,22,120,11 }, { 135,115,155,152,0 }, { 209,230,140,83,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 166)
		{ { 8,16,87,227,11 }, { 118,81,3,28,3 }, { 220,126,160,129,0 }, { 195,140,8,166,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 167)
		{ { 8,107,151,182,6 }, { 27,215,202,16,11 }, { 102,222,157,97,0 }, { 208,133,62,189,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 168)
		{ { 14,232,184,96,10 }, { 131,148,23,25,12 }, { 80,97,209,119,0 }, { 57,142,130,156,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 169)
		{ { 11,108,118,185,11 }, { 39,117,131,117,14 }, { 217,214,227,109,0 }, { 122,236,26,238,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 170)
		{ { 15,220,185,140,11 }, { 222,180,21,113,14 }, { 211,25,211,191,0 }, { 120,234,130,215,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 171)
		{ { 15,202,207,58,0 }, { 178,229,158,65,9 }, { 5,207,53,63,0 }, { 152,39,154,116,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 172)
		{ { 20,36,159,217,8 }, { 145,233,133,60,2 }, { 25,191,146,66,8 }, { 67,202,25,120,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 173)
		{ { 20,7,32,31,13 }, { 140,42,201,36,5 }, { 191,128,78,2,8 }, { 162,73,53,67,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 174)
		{ { 21,9,16,213,7 }, { 140,26,192,92,10 }, { 234,176,137,10,8 }, { 83,160,53,131,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 175)
		{ { 19,92,215,48,7 }, { 116,221,194,113,8 }, { 224,206,179,172,8 }, { 24,228,59,178,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 176)
		{ { 17,71,154,187,6 }, { 0,254,206,116,3 }, { 109,213,158,40,8 }, { 194,231,55,240,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 177)
		{ { 28,185,169,35,8 }, { 211,138,23,4,13 }, { 28,73,89,211,8 }, { 178,14,133,28,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 178)
		{ { 28,221,7,118,6 }, { 218,95,210,40,9 }, { 102,238,11,179,8 }, { 145,68,191,165,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 179)
		{ { 31,46,124,36,11 }, { 175,25,15,113,12 }, { 210,67,231,79,8 }, { 56,239,9,143,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 180)
		{ { 25,102,66,71,7 }, { 47,92,72,108,1 }, { 238,36,38,105,8 }, { 131,97,35,175,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 181)
		{ { 25,87,212,200,4 }, { 98,175,72,120,2 }, { 33,50,190,169,8 }, { 65,225,47,84,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 182)
		{ { 31,168,244,240,4 }, { 163,137,210,89,14 }, { 32,242,241,95,8 }, { 121,164,185,28,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 183)
		{ { 27,130,70,237,8 }, { 42,105,27,77,2 }, { 27,118,36,29,8 }, { 75,45,137,101,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 184)
		{ { 27,174,225,15,14 }, { 59,184,89,101,13 }, { 127,8,119,93,8 }, { 186,105,161,221,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 185)
		{ { 34,164,182,60,10 }, { 9,241,179,49,4 }, { 83,198,210,84,4 }, { 40,204,216,249,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 186)
		{ { 34,191,144,18,15 }, { 69,146,249,49,9 }, { 244,128,159,212,4 }, { 152,201,244,154,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 187)
		{ { 35,44,21,180,0 }, { 25,1,162,113,10 }, { 2,218,131,76,4 }, { 88,228,88,9,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 188)
		{ { 37,90,169,102,12 }, { 216,132,111,72,13 }, { 54,105,85,170,4 }, { 177,47,98,17,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 189)
		{ { 39,165,175,169,7 }, { 149,243,118,101,6 }, { 233,95,90,94,4 }, { 106,102,236,250,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 190)
		{ { 37,244,14,66,5 }, { 197,69,116,104,1 }, { 164,39,2,250,4 }, { 129,98,234,42,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 191)
		{ { 40,102,85,205,14 }, { 59,53,105,60,2 }, { 123,58,166,97,4 }, { 67,201,106,205,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 192)
		{ { 44,66,126,14,0 }, { 170,101,44,16,5 }, { 7,7,228,35,4 }, { 160,131,74,101,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 193)
		{ { 42,185,124,189,0 }, { 107,35,182,21,14 }, { 11,211,233,213,4 }, { 122,134,220,77,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 194)
		{ { 41,70,225,210,3 }, { 54,148,168,104,7 }, { 196,184,118,41,4 }, { 225,97,82,150,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 195)
		{ { 45,166,40,65,0 }, { 131,0,60,108,4 }, { 8,33,70,91,4 }, { 35,99,192,12,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 196)
		{ { 43,251,32,154,6 }, { 67,54,248,65,15 }, { 101,144,77,253,4 }, { 248,33,246,204,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 197)
		{ { 54,140,214,107,12 }, { 160,233,115,61,9 }, { 61,102,179,22,12 }, { 155,204,233,112,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 198)
		{ { 52,135,119,124,7 }, { 188,123,250,56,4 }, { 227,238,238,18,12 }, { 33,197,253,227,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 199)
		{ { 52,221,235,132,0 }, { 248,206,52,32,14 }, { 2,29,123,178,12 }, { 112,66,199,49,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 200)
		{ { 55,145,247,111,1 }, { 252,235,50,93,5 }, { 143,110,248,158,12 }, { 171,164,205,115,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 201)
		{ { 58,34,142,23,5 }, { 15,201,236,5,1 }, { 174,135,20,69,12 }, { 138,3,121,63,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 202)
		{ { 62,19,189,64,8 }, { 210,139,45,25,4 }, { 16,43,220,135,12 }, { 41,139,77,20,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 203)
		{ { 60,152,67,202,2 }, { 242,120,48,8,11 }, { 69,60,33,147,12 }, { 209,0,193,228,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 204)
		{ { 57,88,157,23,9 }, { 94,141,165,84,9 }, { 158,139,145,169,12 }, { 146,170,91,23,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 205)
		{ { 57,116,218,238,11 }, { 111,252,39,120,3 }, { 215,117,178,233,12 }, { 193,238,67,255,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 206)
		{ { 63,109,188,115,1 }, { 135,143,166,125,13 }, { 140,227,219,111,12 }, { 187,230,95,30,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 207)
		{ { 61,107,192,80,12 }, { 163,142,233,72,8 }, { 48,160,61,107,12 }, { 17,41,119,28,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 208)
		{ { 57,171,39,73,7 }, { 23,123,120,76,12 }, { 233,46,77,89,12 }, { 51,33,237,238,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 209)
		{ { 70,2,78,37,14 }, { 168,81,79,133,0 }, { 122,71,36,6,2 }, { 10,31,40,161,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 210)
		{ { 70,130,186,11,12 }, { 128,224,93,149,5 }, { 61,5,212,22,2 }, { 170,155,160,112,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 211)
		{ { 66,233,205,90,14 }, { 49,183,213,137,9 }, { 117,171,57,116,2 }, { 153,26,190,216,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 212)
		{ { 68,201,183,179,15 }, { 148,215,211,148,15 }, { 252,222,217,50,2 }, { 242,156,190,178,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 213)
		{ { 64,199,212,30,9 }, { 44,167,153,176,1 }, { 151,130,190,48,2 }, { 128,217,158,83,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 214)
		{ { 70,210,180,204,14 }, { 200,181,89,153,6 }, { 115,50,212,182,2 }, { 105,153,170,209,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 215)
		{ { 67,25,83,86,11 }, { 124,82,129,217,9 }, { 214,172,169,140,2 }, { 153,184,20,163,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 216)
		{ { 65,34,230,221,9 }, { 45,225,137,204,6 }, { 155,182,116,72,2 }, { 99,57,24,123,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 217)
		{ { 71,83,165,154,11 }, { 212,183,137,193,7 }, { 213,154,92,174,2 }, { 232,57,30,210,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 218)
		{ { 78,30,241,224,8 }, { 242,128,11,185,14 }, { 16,120,247,135,2 }, { 121,221,0,20,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 219)
		{ { 78,74,192,150,0 }, { 170,132,136,129,11 }, { 6,144,53,39,2 }, { 216,17,18,21,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 220)
		{ { 78,95,170,6,15 }, { 206,214,77,161,13 }, { 246,5,95,167,2 }, { 184,91,38,183,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 221)
		{ { 74,141,50,148,3 }, { 14,82,144,177,14 }, { 194,148,203,21,2 }, { 120,208,148,167,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 222)
		{ { 73,21,148,179,9 }, { 70,131,131,244,3 }, { 156,210,154,137,2 }, { 194,252,28,22,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 223)
		{ { 77,77,219,98,1 }, { 182,198,6,248,9 }, { 132,109,187,43,2 }, { 145,246,6,54,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 224)
		{ { 75,167,97,232,1 }, { 55,34,26,233,6 }, { 129,120,110,93,2 }, { 105,117,132,78,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 225)
		{ { 73,212,131,216,14 }, { 82,244,209,232,2 }, { 113,188,18,185,2 }, { 65,120,178,244,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 226)
		{ { 86,41,14,246,12 }, { 137,75,199,137,11 }, { 54,247,9,70,10 }, { 217,30,61,41,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 227)
		{ { 83,126,213,255,12 }, { 121,173,203,253,11 }, { 63,250,183,236,10 }, { 219,253,59,89,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 228)
		{ { 85,245,167,175,10 }, { 217,255,19,228,7 }, { 95,94,90,250,10 }, { 226,124,143,249,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 229)
		{ { 85,213,234,100,15 }, { 236,222,87,232,4 }, { 242,101,122,186,10 }, { 33,126,167,179,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 230)
		{ { 88,27,171,29,10 }, { 90,250,141,132,12 }, { 91,141,93,129,10 }, { 50,27,21,245,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 231)
		{ { 94,190,146,109,13 }, { 207,232,91,189,8 }, { 187,100,151,215,10 }, { 27,221,161,127,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 232)
		{ { 95,16,249,155,5 }, { 246,168,196,213,7 }, { 173,153,240,143,10 }, { 234,178,49,86,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 233)
		{ { 93,30,223,165,12 }, { 250,201,79,244,10 }, { 58,95,183,139,10 }, { 82,255,41,53,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 234)
		{ { 95,113,141,240,2 }, { 211,159,134,201,2 }, { 64,251,24,239,10 }, { 73,54,31,156,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 235)
		{ { 93,225,30,70,8 }, { 139,79,21,216,1 }, { 22,39,136,123,10 }, { 129,186,143,45,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 236)
		{ { 96,51,187,36,7 }, { 93,210,110,144,4 }, { 226,77,220,192,6 }, { 32,151,100,187,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 237)
		{ { 100,88,26,254,1 }, { 204,100,166,152,11 }, { 135,245,129,162,6 }, { 209,150,82,99,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 238)
		{ { 99,200,221,167,6 }, { 56,149,118,213,11 }, { 110,91,177,60,6 }, { 218,182,234,145,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 239)
		{ { 97,218,61,143,13 }, { 92,37,125,212,15 }, { 191,27,197,184,6 }, { 242,187,234,67,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 240)
		{ { 110,58,34,175,10 }, { 203,112,43,133,15 }, { 95,84,69,199,6 }, { 250,29,64,237,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 241)
		{ { 110,97,5,183,1 }, { 159,7,162,133,3 }, { 142,218,8,103,6 }, { 202,20,94,15,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 242)
		{ { 106,137,169,232,12 }, { 18,162,119,137,14 }, { 49,121,89,21,6 }, { 121,30,228,84,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 243)
		{ { 106,151,34,79,5 }, { 78,98,120,173,5 }, { 175,36,78,149,6 }, { 171,81,228,103,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 244)
		{ { 107,18,195,128,1 }, { 118,192,40,193,2 }, { 128,28,52,141,6 }, { 72,49,64,54,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 245)
		{ { 107,104,75,34,10 }, { 51,84,39,193,9 }, { 84,77,33,109,6 }, { 152,62,66,172,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 246)
		{ { 111,148,193,87,9 }, { 254,128,177,237,1 }, { 158,168,50,159,6 }, { 139,120,208,23,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 247)
		{ { 109,166,254,160,13 }, { 167,193,127,240,6 }, { 176,87,246,91,6 }, { 96,255,232,62,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 248)
		{ { 111,234,202,69,7 }, { 175,212,124,205,8 }, { 234,37,53,127,6 }, { 27,51,226,191,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 249)
		{ { 112,61,56,166,0 }, { 73,10,38,176,15 }, { 6,81,203,192,14 }, { 240,214,69,9,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 250)
		{ { 118,108,53,231,8 }, { 153,13,35,189,15 }, { 30,122,195,102,14 }, { 251,220,75,9,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 251)
		{ { 112,74,13,255,6 }, { 24,61,238,140,11 }, { 111,251,5,32,14 }, { 211,23,123,193,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 252)
		{ { 117,120,169,200,0 }, { 209,172,36,200,14 }, { 1,57,81,234,14 }, { 113,50,67,88,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 253)
		{ { 113,74,112,19,8 }, { 32,12,169,212,13 }, { 28,128,229,40,14 }, { 178,185,83,0,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 254)
		{ { 117,127,140,187,9 }, { 197,175,175,228,11 }, { 157,211,31,234,14 }, { 210,127,95,90,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 255)
		{ { 124,35,104,51,1 }, { 167,10,174,132,5 }, { 140,193,108,67,14 }, { 162,23,85,14,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 256)
		{ { 124,181,167,211,1 }, { 215,203,176,172,7 }, { 140,190,90,211,14 }, { 227,80,221,62,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 257)
		{ { 124,248,44,237,14 }, { 203,61,119,140,14 }, { 123,115,65,243,14 }, { 115,30,235,205,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 258)
		{ { 127,36,226,52,15 }, { 175,216,227,225,4 }, { 242,196,114,79,14 }, { 40,124,113,191,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 259)
		{ { 127,71,41,141,8 }, { 154,46,45,229,6 }, { 27,25,78,47,14 }, { 106,123,71,69,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 260)
		{ { 134,216,3,209,9 }, { 212,68,145,15,10 }, { 152,188,1,182,1 }, { 95,8,146,34,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 261)
		{ { 131,139,27,161,3 }, { 20,82,30,87,10 }, { 200,93,141,28,1 }, { 94,167,132,162,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 262)
		{ { 135,162,121,197,9 }, { 189,0,29,95,6 }, { 154,57,228,94,1 }, { 111,171,128,11,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 263)
		{ { 138,67,100,140,14 }, { 42,55,73,3,6 }, { 115,18,108,37,1 }, { 108,9,46,197,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 264)
		{ { 136,147,59,76,8 }, { 90,98,29,26,4 }, { 19,45,204,145,1 }, { 37,139,132,101,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 265)
		{ { 143,33,223,78,3 }, { 191,243,4,91,1 }, { 199,47,184,79,1 }, { 141,162,12,255,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 266)
		{ { 141,132,53,114,9 }, { 150,1,147,122,5 }, { 148,234,194,27,1 }, { 165,236,152,6,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 267)
		{ { 141,136,215,31,13 }, { 190,225,209,86,9 }, { 191,142,177,27,1 }, { 150,168,184,119,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 268)
		{ { 137,159,120,252,13 }, { 110,34,223,122,14 }, { 179,241,239,153,1 }, { 117,239,180,71,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 269)
		{ { 146,107,22,121,12 }, { 1,111,203,31,8 }, { 57,230,141,100,9 }, { 31,141,63,104,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 270)
		{ { 148,142,34,241,2 }, { 128,88,154,46,14 }, { 72,244,71,18,9 }, { 119,69,145,160,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 271)
		{ { 144,229,230,49,7 }, { 37,223,210,38,4 }, { 232,198,122,112,9 }, { 38,68,191,186,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 272)
		{ { 150,216,133,42,1 }, { 212,173,18,3,9 }, { 133,74,17,182,9 }, { 156,4,139,82,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 273)
		{ { 149,57,59,164,6 }, { 217,90,70,82,14 }, { 98,93,201,202,9 }, { 116,166,37,169,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 274)
		{ { 149,60,251,77,13 }, { 253,232,69,126,12 }, { 187,45,243,202,9 }, { 55,234,33,123,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 275)
		{ { 145,62,170,18,6 }, { 65,216,204,98,13 }, { 100,133,87,200,9 }, { 180,99,49,184,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 276)
		{ { 151,111,90,175,9 }, { 173,110,15,119,11 }, { 159,85,175,110,9 }, { 222,239,7,107,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 277)
		{ { 145,178,41,253,10 }, { 89,56,159,78,6 }, { 91,249,68,216,9 }, { 103,47,145,201,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 278)
		{ { 145,211,250,118,1 }, { 108,206,158,90,5 }, { 134,229,252,184,9 }, { 165,167,151,51,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 279)
		{ { 154,112,134,200,8 }, { 67,237,1,11,2 }, { 17,54,16,229,9 }, { 77,8,11,124,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 280)
		{ { 152,142,205,3,1 }, { 54,137,28,38,9 }, { 140,11,55,17,9 }, { 150,67,137,22,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 281)
		{ { 152,199,16,151,10 }, { 10,30,153,54,3 }, { 94,144,142,49,9 }, { 198,201,151,133,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 282)
		{ { 157,203,235,70,6 }, { 186,222,92,74,13 }, { 102,45,125,59,9 }, { 181,35,167,181,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 283)
		{ { 164,40,245,182,14 }, { 185,145,227,18,15 }, { 118,218,241,66,5 }, { 244,140,120,153,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 284)
		{ { 163,55,241,121,3 }, { 117,178,170,127,4 }, { 201,232,254,204,5 }, { 47,229,84,218,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 285)
		{ { 163,68,64,245,10 }, { 40,20,163,111,2 }, { 90,240,34,44,5 }, { 79,108,82,129,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 286)
		{ { 161,127,173,133,8 }, { 89,135,45,102,14 }, { 26,27,95,232,5 }, { 118,107,78,25,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 287)
		{ { 167,210,150,35,13 }, { 196,197,123,87,1 }, { 188,70,148,190,5 }, { 142,173,234,50,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 288)
		{ { 168,69,112,43,11 }, { 38,54,35,54,5 }, { 221,64,234,33,5 }, { 166,204,70,198,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 289)
		{ { 174,72,127,160,9 }, { 182,69,39,19,14 }, { 144,95,225,39,5 }, { 124,142,74,38,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 290)
		{ { 172,79,182,214,8 }, { 138,199,169,58,15 }, { 22,182,223,35,5 }, { 245,201,94,53,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 291)
		{ { 168,168,211,133,3 }, { 63,208,48,22,10 }, { 202,28,177,81,5 }, { 86,128,192,191,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 292)
		{ { 169,139,10,203,8 }, { 2,98,61,78,11 }, { 29,53,13,25,5 }, { 215,43,196,100,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 293)
		{ { 173,254,140,222,2 }, { 203,181,188,106,11 }, { 71,179,23,251,5 }, { 213,99,218,221,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 294)
		{ { 180,239,46,46,14 }, { 137,127,127,34,13 }, { 119,71,79,114,13 }, { 180,79,239,233,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 295)
		{ { 183,153,137,199,0 }, { 216,138,52,79,11 }, { 14,57,25,158,13 }, { 223,34,197,17,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 296)
		{ { 190,12,162,14,12 }, { 138,232,97,35,13 }, { 55,4,83,7,13 }, { 188,72,97,117,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 297)
		{ { 188,112,34,122,9 }, { 199,108,163,10,5 }, { 149,228,64,227,13 }, { 165,12,83,110,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 298)
		{ { 190,188,47,145,10 }, { 211,89,181,39,14 }, { 88,159,67,215,13 }, { 126,74,217,172,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 299)
		{ { 184,233,10,152,3 }, { 7,126,180,2,10 }, { 193,149,9,113,13 }, { 84,2,215,238,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 300)
		{ { 189,10,48,236,8 }, { 138,40,43,90,14 }, { 19,112,197,11,13 }, { 117,173,65,69,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 301)
		{ { 194,2,224,243,1 }, { 36,128,138,143,7 }, { 140,240,116,4,3 }, { 239,21,16,18,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 302)
		{ { 194,107,50,227,7 }, { 5,86,74,159,15 }, { 236,116,205,100,3 }, { 255,149,38,170,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 303)
		{ { 198,202,66,106,8 }, { 160,100,27,139,9 }, { 21,100,37,54,3 }, { 157,29,130,96,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 304)
		{ { 199,30,238,104,14 }, { 224,241,79,235,12 }, { 113,103,119,142,3 }, { 61,127,40,240,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 305)
		{ { 199,125,46,145,3 }, { 197,87,132,231,14 }, { 200,151,75,238,3 }, { 126,114,30,170,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 306)
		{ { 206,60,32,116,2 }, { 203,16,130,171,12 }, { 66,224,67,199,3 }, { 61,84,16,141,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 307)
		{ { 204,74,185,197,7 }, { 158,148,76,158,14 }, { 234,57,213,35,3 }, { 119,147,34,151,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 308)
		{ { 206,247,99,220,13 }, { 255,102,217,171,6 }, { 179,188,110,247,3 }, { 109,89,182,111,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 309)
		{ { 205,67,34,202,2 }, { 130,118,8,202,7 }, { 69,52,76,43,3 }, { 229,49,6,228,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 310)
		{ { 207,183,204,29,0 }, { 235,163,156,231,0 }, { 11,131,62,223,3 }, { 14,115,156,93,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 311)
		{ { 201,206,200,53,10 }, { 42,148,159,230,8 }, { 90,193,55,57,3 }, { 22,127,146,149,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 312)
		{ { 207,243,75,113,3 }, { 247,86,158,207,0 }, { 200,237,44,255,3 }, { 15,55,150,174,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 313)
		{ { 214,46,123,112,13 }, { 181,72,207,187,12 }, { 176,237,231,70,11 }, { 61,223,49,42,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 314)
		{ { 212,23,75,59,4 }, { 240,106,206,166,1 }, { 45,205,46,130,11 }, { 134,87,53,96,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 315)
		{ { 215,141,250,151,14 }, { 168,218,213,247,15 }, { 126,149,251,30,11 }, { 254,250,181,177,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 316)
		{ { 209,216,245,85,1 }, { 124,141,144,222,12 }, { 138,170,241,184,11 }, { 55,176,155,19,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 317)
		{ { 213,207,225,211,9 }, { 180,142,153,238,15 }, { 156,184,127,58,11 }, { 247,121,151,18,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 318)
		{ { 218,22,168,204,9 }, { 78,168,13,171,6 }, { 147,49,86,133,11 }, { 109,91,1,87,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 319)
		{ { 216,76,68,133,9 }, { 46,13,1,166,10 }, { 154,18,35,33,11 }, { 86,88,11,7,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 320)
		{ { 220,217,114,142,13 }, { 238,110,81,146,15 }, { 183,20,233,179,11 }, { 244,152,167,103,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 321)
		{ { 223,103,17,126,8 }, { 155,46,139,251,1 }, { 23,232,142,111,11 }, { 141,253,23,77,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 322)
		{ { 219,153,125,230,7 }, { 126,27,86,219,15 }, { 230,123,233,157,11 }, { 253,182,173,135,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 323)
		{ { 221,171,142,49,14 }, { 131,219,223,198,8 }, { 120,199,29,91,11 }, { 22,63,189,188,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 324)
		{ { 224,25,8,76,13 }, { 76,34,101,138,8 }, { 179,33,9,128,7 }, { 21,26,100,67,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 325)
		{ { 230,54,218,82,1 }, { 229,192,172,187,1 }, { 132,165,182,198,7 }, { 141,211,80,58,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 326)
		{ { 226,172,199,155,0 }, { 49,225,176,167,11 }, { 13,158,51,84,7 }, { 222,80,216,120,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 327)
		{ { 228,141,33,98,0 }, { 144,2,50,170,13 }, { 4,104,75,18,7 }, { 181,84,196,0,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 328)
		{ { 226,254,208,197,1 }, { 109,132,56,191,10 }, { 138,48,183,244,7 }, { 95,209,194,27,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 329)
		{ { 225,58,125,2,10 }, { 113,17,45,210,13 }, { 84,11,229,200,7 }, { 180,187,72,136,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 330)
		{ { 231,208,91,142,5 }, { 252,100,116,211,3 }, { 167,29,160,190,7 }, { 204,178,226,99,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 331)
		{ { 236,48,156,107,5 }, { 199,161,102,158,1 }, { 173,99,144,195,7 }, { 135,150,104,94,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 332)
		{ { 236,170,73,210,0 }, { 179,0,188,138,11 }, { 4,185,37,83,7 }, { 213,19,208,12,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 333)
		{ { 238,179,122,196,6 }, { 235,82,124,155,6 }, { 98,53,236,215,7 }, { 109,147,228,173,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 334)
		{ { 232,224,103,46,2 }, { 59,117,50,130,5 }, { 71,78,96,113,7 }, { 164,20,202,237,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 335)
		{ { 234,229,213,36,12 }, { 59,135,115,179,0 }, { 50,74,186,117,7 }, { 12,220,238,29,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 336)
		{ { 237,107,28,44,2 }, { 139,55,46,210,8 }, { 67,67,141,107,7 }, { 20,183,78,205,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 337)
		{ { 235,200,175,29,6 }, { 26,245,244,199,12 }, { 107,143,81,61,7 }, { 62,50,250,245,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 338)
		{ { 242,5,98,212,5 }, { 44,74,224,171,6 }, { 162,180,106,4,15 }, { 109,80,117,35,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 339)
		{ { 246,25,188,251,2 }, { 192,187,166,159,15 }, { 77,243,217,134,15 }, { 255,150,93,208,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 340)
		{ { 246,163,92,109,11 }, { 173,59,63,159,0 }, { 219,99,172,86,15 }, { 15,159,205,203,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 341)
		{ { 244,241,189,15,0 }, { 217,175,52,150,5 }, { 15,11,216,242,15 }, { 166,146,207,89,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 342)
		{ { 241,106,155,67,5 }, { 21,204,108,222,9 }, { 172,45,149,104,15 }, { 151,179,99,58,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 343)
		{ { 241,178,145,41,14 }, { 81,184,123,214,0 }, { 121,72,148,216,15 }, { 6,189,225,216,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 344)
		{ { 250,84,91,243,5 }, { 118,76,230,191,3 }, { 172,253,162,165,15 }, { 207,214,115,38,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 345)
		{ { 254,110,134,124,6 }, { 139,253,234,171,8 }, { 99,230,23,103,15 }, { 29,85,123,253,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 346)
		{ { 249,13,185,67,2 }, { 18,154,36,254,13 }, { 76,41,219,9,15 }, { 183,242,69,148,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 347)
		{ { 249,105,102,43,13 }, { 39,111,99,198,13 }, { 189,70,105,105,15 }, { 182,60,111,110,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 348)
		{ { 251,65,203,72,4 }, { 50,238,100,203,0 }, { 33,45,56,45,15 }, { 13,50,103,116,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 349)
		{ { 253,87,191,152,5 }, { 214,239,236,242,6 }, { 161,159,222,171,15 }, { 100,243,127,118,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 350)
		{ { 251,152,144,126,6 }, { 74,184,242,219,9 }, { 103,224,145,157,15 }, { 157,180,241,213,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 351)
		{ { 255,234,33,198,3 }, { 159,28,56,203,15 }, { 198,56,69,127,15 }, { 253,49,195,143,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 352)
		{ { 163,165,111,69,0 }, { 57,67,52,111,4 }, { 10,47,106,92,5 }, { 47,98,204,41,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 353)
		{ { 161,152,104,48,2 }, { 96,16,182,66,12 }, { 64,193,97,152,5 }, { 52,38,208,128,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 354)
		{ { 15,55,131,43,0 }, { 211,226,10,101,1 }, { 13,76,30,207,0 }, { 138,101,4,124,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 355)
		{ { 38,236,72,39,2 }, { 169,20,54,37,9 }, { 78,65,35,118,4 }, { 154,70,194,137,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 356)
		{ { 65,152,184,168,15 }, { 68,176,87,208,14 }, { 241,81,209,152,2 }, { 112,190,160,210,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 357)
		{ { 78,181,67,138,4 }, { 243,98,80,161,3 }, { 37,28,42,215,2 }, { 200,80,164,108,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 358)
		{ { 99,197,227,123,10 }, { 48,246,179,237,5 }, { 93,236,122,60,6 }, { 171,124,214,240,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 359)
		{ { 110,89,221,230,12 }, { 250,135,103,153,11 }, { 54,123,185,167,6 }, { 217,158,110,21,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 360)
		{ { 128,212,89,240,8 }, { 112,4,151,58,2 }, { 16,249,162,176,1 }, { 69,206,146,0,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 361)
		{ { 152,8,136,159,13 }, { 14,168,197,6,11 }, { 191,145,17,1,9 }, { 214,10,49,87,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 362)
		{ { 163,6,103,166,15 }, { 60,81,107,99,7 }, { 246,94,102,12,5 }, { 236,109,104,163,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 363)
		{ { 2,25,166,20,7 }, { 76,211,192,1,12 }, { 226,134,89,132,0 }, { 56,0,60,179,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 364)
		{ { 2,21,202,78,2 }, { 104,242,4,41,1 }, { 71,37,58,132,0 }, { 137,66,4,241,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 365)
		{ { 0,104,204,57,9 }, { 37,165,135,4,8 }, { 153,195,49,96,0 }, { 18,14,26,90,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 366)
		{ { 0,161,19,254,8 }, { 25,98,147,24,3 }, { 23,252,136,80,0 }, { 193,140,148,105,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 367)
		{ { 2,185,86,117,5 }, { 109,67,210,29,8 }, { 170,230,169,212,0 }, { 27,132,188,43,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 368)
		{ { 2,198,187,83,2 }, { 16,212,156,61,5 }, { 76,173,214,52,0 }, { 171,195,146,176,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 369)
		{ { 2,243,31,29,9 }, { 93,103,157,21,0 }, { 155,143,140,244,0 }, { 10,139,158,107,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 370)
		{ { 7,42,193,126,3 }, { 189,176,138,73,9 }, { 199,232,53,78,0 }, { 153,37,16,219,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 371)
		{ { 7,55,141,151,2 }, { 217,147,140,101,3 }, { 78,155,30,206,0 }, { 202,99,28,153,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 372)
		{ { 1,111,31,231,5 }, { 29,71,78,124,11 }, { 174,127,143,104,0 }, { 211,231,46,43,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 373)
		{ { 1,119,48,21,5 }, { 77,6,200,116,4 }, { 170,128,206,232,0 }, { 34,225,54,11,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 374)
		{ { 7,149,114,65,10 }, { 224,82,17,125,4 }, { 88,36,234,158,0 }, { 43,232,132,160,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 375)
		{ { 7,200,163,134,14 }, { 152,212,81,65,15 }, { 118,28,81,62,0 }, { 248,40,162,177,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 376)
		{ { 5,254,251,247,9 }, { 253,196,159,124,15 }, { 158,253,247,250,0 }, { 243,239,146,59,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 377)
		{ { 12,21,243,16,1 }, { 246,194,128,48,4 }, { 128,140,250,131,0 }, { 32,192,20,54,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 378)
		{ { 10,68,98,226,14 }, { 34,84,67,41,7 }, { 116,116,98,37,0 }, { 233,76,34,164,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 379)
		{ { 8,94,55,238,9 }, { 94,101,11,56,15 }, { 151,126,199,161,0 }, { 241,205,10,103,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 380)
		{ { 8,82,222,18,13 }, { 102,197,205,16,1 }, { 180,135,180,161,0 }, { 128,139,58,54,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 381)
		{ { 12,102,136,3,9 }, { 135,132,13,36,1 }, { 156,1,22,99,0 }, { 130,75,2,30,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 382)
		{ { 8,140,186,71,15 }, { 14,208,85,60,13 }, { 254,37,211,17,0 }, { 179,202,160,183,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 383)
		{ { 12,172,39,30,5 }, { 159,97,208,32,13 }, { 167,142,67,83,0 }, { 176,64,184,111,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 384)
		{ { 8,179,56,11,15 }, { 71,50,93,20,5 }, { 253,1,204,209,0 }, { 162,139,164,206,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 385)
		{ { 12,162,165,217,4 }, { 147,161,216,12,6 }, { 41,186,84,83,0 }, { 99,1,184,92,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 386)
		{ { 8,227,82,192,1 }, { 39,70,24,24,2 }, { 128,52,172,113,0 }, { 65,129,134,46,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 387)
		{ { 14,255,68,245,14 }, { 235,23,219,45,10 }, { 122,242,47,247,0 }, { 91,77,190,141,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 388)
		{ { 14,255,93,234,11 }, { 247,55,31,57,11 }, { 213,123,175,247,0 }, { 217,207,142,206,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 389)
		{ { 11,52,109,201,14 }, { 115,49,69,109,6 }, { 121,59,98,205,0 }, { 107,106,40,204,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 390)
		{ { 13,9,254,187,3 }, { 166,243,134,84,15 }, { 205,215,249,11,0 }, { 242,166,28,246,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 391)
		{ { 15,16,170,146,6 }, { 194,208,196,65,7 }, { 100,149,80,143,0 }, { 232,34,48,180,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 392)
		{ { 13,31,101,167,14 }, { 250,19,75,100,15 }, { 126,90,111,139,0 }, { 242,109,44,133,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 393)
		{ { 15,177,95,160,0 }, { 243,67,22,81,2 }, { 0,95,168,223,0 }, { 72,166,140,44,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 394)
		{ { 13,162,5,35,3 }, { 151,17,26,68,1 }, { 204,74,4,91,0 }, { 130,37,136,142,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 395)
		{ { 13,175,35,219,11 }, { 151,114,153,108,15 }, { 221,188,79,91,0 }, { 243,105,148,238,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 396)
		{ { 11,240,165,238,4 }, { 91,165,82,73,7 }, { 39,122,80,253,0 }, { 233,36,170,93,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 397)
		{ { 13,200,153,251,14 }, { 146,180,215,92,11 }, { 125,249,145,59,0 }, { 211,174,178,212,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 398)
		{ { 15,253,48,39,7 }, { 207,22,82,117,13 }, { 238,64,203,255,0 }, { 186,228,166,143,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 399)
		{ { 11,199,93,86,2 }, { 58,23,156,121,1 }, { 70,171,174,61,0 }, { 137,227,158,133,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 400)
		{ { 18,47,163,1,13 }, { 21,202,73,37,12 }, { 184,12,95,68,8 }, { 58,73,37,58,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 401)
		{ { 18,117,72,114,5 }, { 101,14,198,41,1 }, { 164,225,42,228,8 }, { 137,70,55,10,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 402)
		{ { 16,79,174,98,7 }, { 4,223,78,40,13 }, { 228,103,95,32,8 }, { 177,71,47,178,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 403)
		{ { 16,140,138,232,11 }, { 4,248,23,40,10 }, { 209,117,19,16,8 }, { 81,78,129,242,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 404)
		{ { 16,243,244,46,14 }, { 105,191,91,16,5 }, { 119,66,252,240,8 }, { 160,141,175,217,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 405)
		{ { 19,55,238,112,2 }, { 97,219,142,105,4 }, { 64,231,126,204,8 }, { 41,103,29,184,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 406)
		{ { 23,11,35,235,0 }, { 144,106,10,77,15 }, { 13,124,77,14,8 }, { 251,37,5,96,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 407)
		{ { 21,2,111,27,11 }, { 180,121,141,68,5 }, { 221,143,100,10,8 }, { 162,43,25,226,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 408)
		{ { 17,161,171,203,2 }, { 17,250,20,76,7 }, { 77,61,88,88,8 }, { 227,34,133,248,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 409)
		{ { 19,166,74,200,13 }, { 37,104,93,105,2 }, { 177,53,38,92,8 }, { 73,107,161,106,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 410)
		{ { 23,142,53,205,3 }, { 156,57,24,125,14 }, { 203,58,199,30,8 }, { 123,225,137,195,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 411)
		{ { 21,139,229,157,12 }, { 184,171,217,68,14 }, { 59,154,125,26,8 }, { 114,41,189,81,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 412)
		{ { 23,166,249,125,4 }, { 185,168,222,125,4 }, { 43,233,246,94,8 }, { 43,231,177,89,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 413)
		{ { 21,220,164,180,4 }, { 200,141,210,96,14 }, { 34,210,83,186,8 }, { 112,100,187,17,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 414)
		{ { 17,223,5,67,12 }, { 80,15,89,108,9 }, { 60,42,15,184,8 }, { 147,105,175,0,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 415)
		{ { 21,210,1,147,5 }, { 212,12,216,68,3 }, { 172,152,4,186,8 }, { 194,33,179,2,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 416)
		{ { 24,31,173,250,10 }, { 82,187,143,40,15 }, { 85,251,95,129,8 }, { 241,79,29,212,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 417)
		{ { 28,64,14,171,13 }, { 134,109,71,4,3 }, { 189,87,0,35,8 }, { 194,14,43,102,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 418)
		{ { 30,76,93,61,2 }, { 186,61,134,53,8 }, { 75,203,163,39,8 }, { 26,198,27,197,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 419)
		{ { 24,111,246,127,9 }, { 47,239,139,60,13 }, { 159,230,255,97,8 }, { 179,205,31,127,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 420)
		{ { 24,87,52,184,15 }, { 70,63,203,48,6 }, { 241,210,206,161,8 }, { 96,205,63,198,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 421)
		{ { 30,86,137,227,4 }, { 210,140,78,45,3 }, { 44,121,22,167,8 }, { 203,71,35,20,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 422)
		{ { 26,149,209,132,5 }, { 126,138,80,49,2 }, { 162,24,186,149,8 }, { 72,192,165,23,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 423)
		{ { 24,167,255,2,10 }, { 51,219,29,48,5 }, { 84,15,254,81,8 }, { 160,203,141,188,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 424)
		{ { 24,158,177,201,14 }, { 82,184,89,60,14 }, { 121,56,215,145,8 }, { 115,201,161,212,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 425)
		{ { 28,178,10,96,10 }, { 195,88,31,8,0 }, { 80,101,4,211,8 }, { 1,15,129,172,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 426)
		{ { 28,146,53,136,1 }, { 214,41,24,16,6 }, { 129,26,196,147,8 }, { 96,129,137,70,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 427)
		{ { 28,147,183,214,13 }, { 222,203,217,24,7 }, { 182,190,220,147,8 }, { 225,137,189,55,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 428)
		{ { 26,202,188,88,1 }, { 6,173,156,25,12 }, { 129,163,213,53,8 }, { 57,131,155,86,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 429)
		{ { 28,226,172,181,8 }, { 139,141,159,4,6 }, { 26,211,84,115,8 }, { 98,15,155,29,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 430)
		{ { 27,121,237,6,4 }, { 123,143,68,65,13 }, { 38,11,121,237,8 }, { 184,34,47,29,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 431)
		{ { 31,106,57,19,2 }, { 147,28,140,85,13 }, { 76,137,197,111,8 }, { 186,163,19,140,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 432)
		{ { 29,152,56,117,0 }, { 202,8,150,92,12 }, { 10,225,193,155,8 }, { 51,166,145,5,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 433)
		{ { 32,13,193,3,15 }, { 52,146,97,36,9 }, { 252,8,59,0,4 }, { 146,72,100,146,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 434)
		{ { 38,53,212,232,0 }, { 225,163,34,57,2 }, { 1,114,186,198,4 }, { 73,196,76,88,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 435)
		{ { 38,117,44,47,8 }, { 201,39,39,37,5 }, { 31,67,74,230,4 }, { 170,78,78,73,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 436)
		{ { 32,83,133,143,6 }, { 88,183,104,4,3 }, { 111,26,28,160,4 }, { 194,1,110,209,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 437)
		{ { 34,136,31,122,3 }, { 20,113,182,25,9 }, { 197,239,129,20,4 }, { 153,134,216,226,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 438)
		{ { 39,44,250,229,5 }, { 173,192,102,125,14 }, { 170,117,243,78,4 }, { 123,230,96,59,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 439)
		{ { 33,107,76,67,11 }, { 37,23,45,76,9 }, { 220,35,45,104,4 }, { 147,43,78,138,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 440)
		{ { 37,188,103,11,10 }, { 241,113,49,100,13 }, { 93,14,99,218,4 }, { 178,104,200,232,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 441)
		{ { 33,163,233,176,14 }, { 49,146,255,64,6 }, { 112,217,124,88,4 }, { 96,47,244,152,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 442)
		{ { 33,150,242,145,15 }, { 100,208,249,116,6 }, { 248,148,246,152,4 }, { 98,233,240,178,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 443)
		{ { 39,162,43,140,10 }, { 153,112,61,65,6 }, { 83,29,68,94,4 }, { 104,43,192,233,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 444)
		{ { 39,159,72,50,8 }, { 224,2,191,97,9 }, { 20,193,47,158,4 }, { 152,111,212,0,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 445)
		{ { 35,226,188,201,7 }, { 5,181,124,93,6 }, { 233,51,212,124,4 }, { 107,163,234,218,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 446)
		{ { 33,194,87,244,1 }, { 60,69,186,88,2 }, { 130,254,164,56,4 }, { 65,165,218,35,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 447)
		{ { 39,207,186,248,11 }, { 132,246,191,121,14 }, { 209,245,223,62,4 }, { 121,239,214,242,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 448)
		{ { 42,47,189,228,11 }, { 31,147,47,57,14 }, { 210,123,223,69,4 }, { 121,207,76,159,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 449)
		{ { 42,84,58,140,12 }, { 74,100,101,49,6 }, { 51,21,194,165,4 }, { 104,202,98,101,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 450)
		{ { 42,209,187,151,15 }, { 94,214,245,21,7 }, { 254,157,216,181,4 }, { 234,138,246,183,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 451)
		{ { 40,255,58,99,1 }, { 71,70,62,60,13 }, { 140,101,207,241,4 }, { 179,199,198,46,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 452)
		{ { 43,84,197,185,8 }, { 114,165,163,101,2 }, { 25,218,50,173,4 }, { 74,108,90,84,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 453)
		{ { 45,97,175,26,10 }, { 147,247,165,64,5 }, { 85,143,88,107,4 }, { 160,42,94,252,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 454)
		{ { 43,188,219,62,6 }, { 123,240,246,113,9 }, { 103,205,179,221,4 }, { 152,230,240,253,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 455)
		{ { 45,159,154,13,2 }, { 202,242,60,116,8 }, { 75,5,159,155,4 }, { 18,227,196,245,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 456)
		{ { 47,187,114,106,3 }, { 231,114,58,89,13 }, { 197,100,237,223,4 }, { 185,165,196,238,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 457)
		{ { 43,217,204,255,7 }, { 110,183,246,77,11 }, { 239,243,57,189,4 }, { 219,38,254,215,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 458)
		{ { 41,198,223,142,12 }, { 58,229,125,112,3 }, { 55,31,182,57,4 }, { 192,235,234,117,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 459)
		{ { 52,12,63,195,5 }, { 148,73,100,60,15 }, { 172,63,195,2,12 }, { 243,194,105,34,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 460)
		{ { 48,3,27,40,14 }, { 16,122,111,16,0 }, { 113,77,140,0,12 }, { 0,143,101,224,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 461)
		{ { 48,113,29,236,3 }, { 93,63,38,24,2 }, { 195,123,136,224,12 }, { 65,134,79,203,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 462)
		{ { 52,76,222,162,10 }, { 160,221,39,48,11 }, { 84,87,179,34,12 }, { 208,206,75,176,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 463)
		{ { 50,122,138,139,12 }, { 65,236,109,5,11 }, { 61,21,21,228,12 }, { 218,11,99,120,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 464)
		{ { 54,87,99,215,2 }, { 248,94,168,45,7 }, { 78,188,110,166,12 }, { 235,65,87,161,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 465)
		{ { 52,141,50,170,6 }, { 128,122,114,48,15 }, { 101,84,203,18,12 }, { 240,196,229,224,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 466)
		{ { 54,129,250,177,1 }, { 164,202,182,21,6 }, { 136,213,248,22,12 }, { 106,134,213,50,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 467)
		{ { 54,153,111,21,13 }, { 252,75,245,5,12 }, { 186,143,105,150,12 }, { 58,10,253,35,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 468)
		{ { 50,204,108,49,14 }, { 32,29,247,37,12 }, { 120,195,99,52,12 }, { 58,78,251,128,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 469)
		{ { 54,224,7,77,4 }, { 153,109,112,13,0 }, { 43,46,0,118,12 }, { 11,0,235,105,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 470)
		{ { 51,64,141,156,5 }, { 28,173,228,65,2 }, { 163,155,16,44,12 }, { 72,34,123,83,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 471)
		{ { 51,125,174,182,10 }, { 73,223,167,97,15 }, { 86,215,91,236,12 }, { 248,110,95,185,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 472)
		{ { 49,94,255,61,1 }, { 124,237,174,116,12 }, { 139,207,247,168,12 }, { 50,231,91,115,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 473)
		{ { 53,164,249,40,11 }, { 181,184,55,112,4 }, { 209,73,242,90,12 }, { 32,238,193,218,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 474)
		{ { 51,134,161,198,4 }, { 24,136,120,105,7 }, { 38,56,86,28,12 }, { 233,97,225,17,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 475)
		{ { 53,232,26,158,12 }, { 137,108,245,80,11 }, { 55,149,129,122,12 }, { 208,170,243,105,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 476)
		{ { 55,216,88,186,3 }, { 228,60,182,81,11 }, { 197,209,161,190,12 }, { 216,166,211,194,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 477)
		{ { 56,21,51,89,12 }, { 82,106,225,60,4 }, { 57,172,202,129,12 }, { 35,200,117,100,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 478)
		{ { 56,27,98,106,12 }, { 98,106,107,8,13 }, { 53,100,109,129,12 }, { 177,13,101,100,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 479)
		{ { 58,54,80,219,10 }, { 99,56,169,61,3 }, { 93,176,166,197,12 }, { 203,201,81,204,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 480)
		{ { 56,136,209,242,9 }, { 54,136,179,24,11 }, { 148,248,177,17,12 }, { 209,140,209,22,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 481)
		{ { 58,204,141,200,2 }, { 18,189,52,41,10 }, { 65,59,19,53,12 }, { 89,66,203,212,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 482)
		{ { 60,252,249,7,11 }, { 255,156,53,52,13 }, { 222,9,243,243,12 }, { 178,202,195,159,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 483)
		{ { 60,246,137,57,12 }, { 211,172,255,36,0 }, { 57,201,22,243,12 }, { 2,79,243,92,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 484)
		{ { 59,15,174,199,9 }, { 14,203,45,109,15 }, { 158,55,95,13,12 }, { 251,107,77,55,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 485)
		{ { 61,11,95,245,6 }, { 186,91,238,92,10 }, { 106,255,173,11,12 }, { 83,167,125,165,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 486)
		{ { 57,73,131,170,6 }, { 18,254,98,64,11 }, { 101,92,25,41,12 }, { 208,36,103,244,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 487)
		{ { 61,92,175,229,6 }, { 218,221,102,108,14 }, { 106,127,83,171,12 }, { 115,102,107,181,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 488)
		{ { 59,111,209,254,2 }, { 59,190,170,121,11 }, { 71,248,191,109,12 }, { 217,229,87,221,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 489)
		{ { 61,114,229,206,7 }, { 255,189,104,72,7 }, { 231,58,116,235,12 }, { 225,33,107,223,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 490)
		{ { 59,165,24,48,4 }, { 3,10,246,113,0 }, { 32,193,138,93,12 }, { 8,230,245,12,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 491)
		{ { 59,215,215,116,14 }, { 122,223,251,121,0 }, { 114,238,190,189,12 }, { 9,237,255,181,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 492)
		{ { 66,21,7,134,1 }, { 92,67,0,161,3 }, { 134,30,10,132,2 }, { 200,80,12,35,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 493)
		{ { 68,42,51,204,5 }, { 157,96,72,152,14 }, { 163,60,197,66,2 }, { 113,145,32,107,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 494)
		{ { 64,105,62,32,12 }, { 1,71,71,144,12 }, { 48,71,201,96,2 }, { 48,158,46,40,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 495)
		{ { 68,76,84,241,12 }, { 160,5,195,188,10 }, { 56,242,163,34,2 }, { 83,220,58,0,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 496)
		{ { 64,78,207,5,5 }, { 60,197,76,164,8 }, { 170,15,55,32,2 }, { 18,83,42,51,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 497)
		{ { 64,223,74,196,6 }, { 104,86,92,168,10 }, { 98,53,47,176,2 }, { 81,83,166,161,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 498)
		{ { 70,218,103,26,14 }, { 240,117,217,129,13 }, { 117,142,101,182,2 }, { 184,25,186,224,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 499)
		{ { 67,32,239,178,13 }, { 53,193,199,193,7 }, { 180,223,112,76,2 }, { 232,62,56,58,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 500)
		{ { 65,99,121,242,7 }, { 53,22,206,216,7 }, { 228,249,236,104,2 }, { 225,183,54,138,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 501)
		{ { 71,127,169,44,10 }, { 217,182,15,225,12 }, { 83,73,95,238,2 }, { 56,127,6,217,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 502)
		{ { 67,168,36,115,10 }, { 1,17,147,205,13 }, { 92,226,65,92,2 }, { 187,60,152,136,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 503)
		{ { 69,174,2,166,1 }, { 141,64,26,224,11 }, { 134,84,7,90,2 }, { 208,117,128,43,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 504)
		{ { 72,29,125,107,6 }, { 114,51,70,188,13 }, { 109,107,235,129,2 }, { 179,214,44,196,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 505)
		{ { 72,68,41,14,4 }, { 26,36,68,160,5 }, { 39,9,66,33,2 }, { 160,82,34,69,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 506)
		{ { 76,93,176,242,6 }, { 194,150,194,184,15 }, { 100,240,219,163,2 }, { 241,212,54,148,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 507)
		{ { 72,79,166,76,0 }, { 10,231,8,168,12 }, { 3,38,95,33,2 }, { 49,81,14,117,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 508)
		{ { 72,129,242,45,11 }, { 46,242,19,148,4 }, { 219,68,248,17,2 }, { 34,156,132,247,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 509)
		{ { 72,140,105,154,11 }, { 54,48,149,160,15 }, { 213,153,99,17,2 }, { 240,90,144,198,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 510)
		{ { 76,230,39,197,2 }, { 155,85,24,172,6 }, { 74,62,70,115,2 }, { 99,81,138,173,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 511)
		{ { 79,61,163,205,7 }, { 223,242,64,237,14 }, { 235,60,91,207,2 }, { 123,112,36,255,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 512)
		{ { 73,73,253,184,8 }, { 50,167,135,208,14 }, { 17,219,249,41,2 }, { 112,190,30,84,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 513)
		{ { 77,89,111,25,7 }, { 246,119,196,196,12 }, { 233,143,105,171,2 }, { 50,50,62,230,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 514)
		{ { 79,79,213,39,11 }, { 190,151,11,245,9 }, { 222,74,191,47,2 }, { 154,253,14,151,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 515)
		{ { 75,148,100,228,11 }, { 110,17,19,233,6 }, { 210,114,98,157,2 }, { 105,124,136,135,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 516)
		{ { 77,160,106,169,14 }, { 163,112,87,196,6 }, { 121,85,96,91,2 }, { 98,62,160,236,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 517)
		{ { 75,146,209,251,2 }, { 114,176,154,221,3 }, { 77,248,180,157,2 }, { 203,181,144,212,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 518)
		{ { 79,237,128,190,11 }, { 143,182,147,225,11 }, { 215,208,27,127,2 }, { 216,124,150,223,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 519)
		{ { 73,250,110,175,3 }, { 111,117,30,196,15 }, { 207,87,101,249,2 }, { 242,55,138,239,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 520)
		{ { 84,32,172,167,7 }, { 141,153,70,132,7 }, { 238,83,80,66,10 }, { 226,22,41,155,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 521)
		{ { 84,25,164,142,8 }, { 200,171,1,128,15 }, { 23,18,89,130,10 }, { 240,24,13,81,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 522)
		{ { 86,116,218,31,8 }, { 233,236,133,181,1 }, { 31,133,178,230,10 }, { 138,218,19,121,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 523)
		{ { 82,70,69,212,11 }, { 60,29,137,169,2 }, { 210,186,38,36,10 }, { 73,89,27,131,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 524)
		{ { 80,153,112,192,3 }, { 100,26,16,152,14 }, { 192,48,233,144,10 }, { 113,144,133,130,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 525)
		{ { 82,162,196,106,5 }, { 37,169,90,137,1 }, { 165,98,52,84,10 }, { 137,21,169,90,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 526)
		{ { 80,232,170,66,4 }, { 1,204,84,136,13 }, { 36,37,81,112,10 }, { 177,18,163,56,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 527)
		{ { 82,242,173,89,8 }, { 81,173,157,141,4 }, { 25,171,84,244,10 }, { 43,27,155,88,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 528)
		{ { 82,218,235,246,10 }, { 120,220,159,137,15 }, { 86,253,117,180,10 }, { 249,31,147,177,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 529)
		{ { 85,46,248,226,2 }, { 161,152,14,248,15 }, { 68,113,247,74,10 }, { 241,247,1,152,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 530)
		{ { 81,65,96,182,2 }, { 40,30,130,192,7 }, { 70,208,104,40,10 }, { 224,52,23,129,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 531)
		{ { 85,104,6,21,8 }, { 137,77,129,196,8 }, { 26,134,1,106,10 }, { 18,56,27,41,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 532)
		{ { 83,74,126,75,13 }, { 36,109,77,221,13 }, { 189,39,229,44,10 }, { 187,187,43,98,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 533)
		{ { 83,107,211,224,11 }, { 53,222,11,217,10 }, { 208,124,189,108,10 }, { 89,189,7,186,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 534)
		{ { 87,114,130,210,7 }, { 197,220,200,201,3 }, { 228,180,20,238,10 }, { 201,49,51,186,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 535)
		{ { 87,129,213,88,2 }, { 176,187,144,217,0 }, { 65,170,184,30,10 }, { 9,176,157,208,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 536)
		{ { 87,164,195,74,8 }, { 177,232,17,233,1 }, { 21,44,50,94,10 }, { 137,120,129,120,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 537)
		{ { 81,151,175,148,8 }, { 88,203,157,224,6 }, { 18,159,94,152,10 }, { 96,123,157,49,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 538)
		{ { 87,143,23,115,11 }, { 148,91,155,253,9 }, { 220,238,143,30,10 }, { 155,253,157,162,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 539)
		{ { 85,194,224,207,0 }, { 168,172,24,204,7 }, { 15,48,116,58,10 }, { 227,49,131,81,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 540)
		{ { 87,246,164,229,1 }, { 205,141,26,237,6 }, { 138,114,86,254,10 }, { 107,117,139,27,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 541)
		{ { 92,5,94,2,5 }, { 166,75,68,176,1 }, { 164,7,170,3,10 }, { 128,210,45,38,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 542)
		{ { 94,56,204,77,0 }, { 235,169,4,141,8 }, { 11,35,49,199,10 }, { 27,18,9,93,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 543)
		{ { 94,101,102,31,5 }, { 175,111,192,165,5 }, { 175,134,106,103,10 }, { 170,80,63,111,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 544)
		{ { 90,165,235,123,5 }, { 55,234,214,173,5 }, { 173,237,122,85,10 }, { 171,86,181,126,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 545)
		{ { 94,173,81,224,13 }, { 183,10,83,185,10 }, { 176,120,171,87,10 }, { 89,220,165,14,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 546)
		{ { 88,179,133,252,1 }, { 95,171,154,136,2 }, { 131,250,28,209,10 }, { 65,21,157,95,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 547)
		{ { 90,197,248,110,0 }, { 42,174,22,185,5 }, { 7,97,250,53,10 }, { 169,214,135,85,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 548)
		{ { 88,241,107,96,0 }, { 115,78,22,136,4 }, { 0,109,104,241,10 }, { 33,22,135,44,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 549)
		{ { 91,48,177,32,8 }, { 83,136,3,209,4 }, { 16,72,208,205,10 }, { 40,188,1,28,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 550)
		{ { 95,52,239,231,11 }, { 255,217,7,237,7 }, { 222,127,114,207,10 }, { 235,126,9,191,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 551)
		{ { 89,64,115,102,9 }, { 62,76,3,216,5 }, { 150,108,224,41,10 }, { 161,188,3,39,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 552)
		{ { 93,105,19,173,1 }, { 159,110,2,212,10 }, { 139,92,137,107,10 }, { 82,180,7,111,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 553)
		{ { 89,82,185,227,11 }, { 86,156,15,220,7 }, { 220,121,212,169,10 }, { 227,191,3,150,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 554)
		{ { 93,70,244,172,2 }, { 170,189,10,240,6 }, { 67,82,246,43,10 }, { 96,245,11,213,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 555)
		{ { 95,128,157,46,8 }, { 154,169,23,209,1 }, { 23,75,144,31,10 }, { 136,190,137,85,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 556)
		{ { 95,224,251,80,14 }, { 179,220,213,217,4 }, { 112,173,240,127,10 }, { 41,186,179,188,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 557)
		{ { 95,235,211,215,0 }, { 187,206,152,221,11 }, { 14,188,189,127,10 }, { 219,177,151,61,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 558)
		{ { 100,105,134,115,5 }, { 133,199,226,140,9 }, { 172,230,25,98,6 }, { 147,20,126,58,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 559)
		{ { 96,188,232,205,8 }, { 105,160,53,172,14 }, { 27,49,115,208,6 }, { 115,90,192,89,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 560)
		{ { 100,158,227,5,6 }, { 248,208,120,164,12 }, { 106,12,119,146,6 }, { 50,81,224,177,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 561)
		{ { 98,212,165,37,13 }, { 92,133,115,165,4 }, { 186,74,82,180,6 }, { 42,92,234,19,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 562)
		{ { 98,246,143,142,3 }, { 93,245,60,161,3 }, { 199,31,22,244,6 }, { 200,83,202,251,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 563)
		{ { 101,96,72,36,7 }, { 173,20,102,192,0 }, { 226,65,32,106,6 }, { 0,54,98,139,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 564)
		{ { 99,180,12,145,8 }, { 65,1,181,229,2 }, { 24,147,2,220,6 }, { 74,122,216,8,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 565)
		{ { 99,159,233,153,13 }, { 116,162,253,229,14 }, { 185,153,127,156,6 }, { 122,123,244,82,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 566)
		{ { 101,237,229,156,7 }, { 189,183,240,224,14 }, { 227,154,123,122,6 }, { 112,112,254,219,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 567)
		{ { 103,235,231,112,4 }, { 177,199,250,201,12 }, { 32,238,125,126,6 }, { 57,53,254,56,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 568)
		{ { 106,1,200,157,4 }, { 42,162,228,133,2 }, { 43,145,56,5,6 }, { 74,18,116,85,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 569)
		{ { 104,61,242,11,0 }, { 99,226,32,180,13 }, { 13,4,251,193,6 }, { 178,208,68,124,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 570)
		{ { 104,24,102,125,13 }, { 110,97,227,140,12 }, { 187,230,97,129,6 }, { 51,28,120,103,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 571)
		{ { 108,84,97,80,15 }, { 246,20,225,168,4 }, { 240,168,98,163,6 }, { 33,88,114,134,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 572)
		{ { 104,75,24,245,13 }, { 14,6,239,156,10 }, { 186,241,141,33,6 }, { 83,159,118,7,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 573)
		{ { 104,79,21,129,0 }, { 18,7,40,180,10 }, { 8,26,143,33,6 }, { 82,209,78,4,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 574)
		{ { 110,110,244,89,0 }, { 163,165,168,189,12 }, { 9,162,247,103,6 }, { 59,209,90,92,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 575)
		{ { 110,152,128,38,5 }, { 206,128,114,129,9 }, { 166,64,17,151,6 }, { 152,20,224,23,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 576)
		{ { 110,144,99,51,3 }, { 246,80,178,133,5 }, { 204,204,96,151,6 }, { 170,20,208,166,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 577)
		{ { 110,241,228,10,7 }, { 231,183,112,129,5 }, { 229,2,120,247,6 }, { 168,16,238,222,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 578)
		{ { 108,195,36,252,0 }, { 138,39,186,136,6 }, { 3,242,76,51,6 }, { 97,21,222,69,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 579)
		{ { 105,0,81,91,15 }, { 54,48,225,220,1 }, { 253,168,160,9,6 }, { 131,184,112,198,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 580)
		{ { 107,64,14,250,12 }, { 2,101,231,201,3 }, { 53,247,0,45,6 }, { 201,62,122,100,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 581)
		{ { 107,124,181,68,7 }, { 95,149,96,249,12 }, { 226,42,211,237,6 }, { 57,240,106,159,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 582)
		{ { 105,172,245,202,2 }, { 51,177,48,248,15 }, { 69,58,243,89,6 }, { 241,240,200,220,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 583)
		{ { 105,167,102,247,12 }, { 43,67,251,236,7 }, { 62,246,110,89,6 }, { 227,125,252,45,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 584)
		{ { 109,235,50,140,11 }, { 143,118,57,208,14 }, { 211,20,205,123,6 }, { 112,185,198,239,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 585)
		{ { 116,23,252,110,12 }, { 232,171,111,184,5 }, { 55,99,254,130,14 }, { 161,223,109,81,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 586)
		{ { 112,97,170,185,4 }, { 1,238,230,132,6 }, { 41,213,88,96,14 }, { 98,22,119,120,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 587)
		{ { 116,67,17,82,1 }, { 148,14,168,152,1 }, { 132,168,140,34,14 }, { 129,145,87,2,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 588)
		{ { 112,185,187,138,9 }, { 85,234,53,144,15 }, { 149,29,217,208,14 }, { 240,154,197,122,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 589)
		{ { 118,148,62,229,4 }, { 200,73,118,189,6 }, { 42,119,194,150,14 }, { 107,214,233,33,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 590)
		{ { 118,188,96,18,9 }, { 229,8,177,161,13 }, { 148,128,99,214,14 }, { 184,88,209,10,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 591)
		{ { 112,155,7,165,4 }, { 88,75,122,132,10 }, { 42,94,13,144,14 }, { 82,21,237,33,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 592)
		{ { 116,139,191,1,3 }, { 148,219,60,148,12 }, { 200,15,221,18,14 }, { 50,147,205,178,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 593)
		{ { 114,248,93,79,11 }, { 125,61,53,157,9 }, { 223,43,161,244,14 }, { 155,154,203,203,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 594)
		{ { 118,211,218,167,15 }, { 236,222,127,149,3 }, { 254,85,188,182,14 }, { 202,159,231,179,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 595)
		{ { 117,36,208,249,9 }, { 165,168,163,252,2 }, { 153,240,178,74,14 }, { 67,252,81,90,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 596)
		{ { 117,60,188,48,6 }, { 193,153,230,240,12 }, { 96,195,211,202,14 }, { 48,246,121,152,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 597)
		{ { 119,3,201,213,15 }, { 188,154,237,205,2 }, { 250,185,60,14,14 }, { 75,59,117,147,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 598)
		{ { 113,69,59,42,5 }, { 20,110,102,240,5 }, { 165,77,202,40,14 }, { 160,246,103,98,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 599)
		{ { 115,108,25,223,1 }, { 29,44,164,253,11 }, { 143,185,131,108,14 }, { 219,242,83,75,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 600)
		{ { 113,72,238,44,10 }, { 40,253,39,192,12 }, { 83,71,113,40,14 }, { 48,62,75,241,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 601)
		{ { 115,111,34,124,0 }, { 9,110,170,233,12 }, { 3,228,79,108,14 }, { 57,117,87,105,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 602)
		{ { 115,145,99,174,14 }, { 120,122,115,193,7 }, { 119,92,104,156,14 }, { 232,60,229,225,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 603)
		{ { 117,131,158,142,9 }, { 140,235,61,208,3 }, { 151,23,156,26,14 }, { 192,187,205,115,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 604)
		{ { 119,191,100,123,6 }, { 225,59,250,237,13 }, { 109,226,111,222,14 }, { 187,117,253,200,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 605)
		{ { 115,229,189,18,10 }, { 17,159,181,241,5 }, { 84,139,218,124,14 }, { 168,250,223,152,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 606)
		{ { 115,207,104,128,3 }, { 36,30,60,225,14 }, { 192,17,111,60,14 }, { 120,115,199,130,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 607)
		{ { 113,247,74,10,0 }, { 97,110,60,224,1 }, { 5,5,46,248,14 }, { 128,115,199,104,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 608)
		{ { 120,45,207,39,6 }, { 59,219,102,164,9 }, { 110,79,59,65,14 }, { 146,86,109,189,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 609)
		{ { 124,2,58,157,7 }, { 142,120,236,148,6 }, { 235,149,196,3,14 }, { 98,147,113,231,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 610)
		{ { 122,92,206,58,4 }, { 98,237,230,161,9 }, { 37,199,51,165,14 }, { 152,86,123,116,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 611)
		{ { 122,114,16,7,7 }, { 79,28,104,149,1 }, { 238,0,132,229,14 }, { 138,145,99,143,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 612)
		{ { 126,178,36,208,11 }, { 199,25,185,137,6 }, { 208,178,68,215,14 }, { 105,25,217,142,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 613)
		{ { 120,253,197,213,2 }, { 123,159,176,172,10 }, { 74,186,59,241,14 }, { 83,80,223,157,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 614)
		{ { 126,232,117,158,9 }, { 191,45,177,145,15 }, { 151,154,225,119,14 }, { 248,152,219,79,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 615)
		{ { 123,28,43,68,14 }, { 90,88,101,233,12 }, { 114,45,67,141,14 }, { 57,122,97,165,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 616)
		{ { 127,4,160,250,2 }, { 130,184,162,233,7 }, { 69,240,82,15,14 }, { 233,116,81,212,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 617)
		{ { 123,39,78,235,3 }, { 39,123,46,237,3 }, { 205,119,46,77,14 }, { 203,119,77,238,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 618)
		{ { 125,38,127,122,1 }, { 183,105,174,248,5 }, { 133,239,230,75,14 }, { 161,247,89,110,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 619)
		{ { 127,50,169,94,10 }, { 219,184,173,201,5 }, { 87,169,84,207,14 }, { 169,59,81,221,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 620)
		{ { 121,180,170,170,7 }, { 71,248,118,224,7 }, { 229,85,82,217,14 }, { 224,118,225,254,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 621)
		{ { 125,176,215,37,3 }, { 255,217,50,212,0 }, { 202,78,176,219,14 }, { 2,180,201,191,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 622)
		{ { 127,147,79,12,2 }, { 250,123,60,193,0 }, { 67,15,44,159,14 }, { 8,51,205,229,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 623)
		{ { 125,252,16,66,2 }, { 195,28,48,248,9 }, { 68,32,131,251,14 }, { 145,240,195,140,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 624)
		{ { 125,213,216,211,15 }, { 230,158,245,252,3 }, { 252,177,186,187,14 }, { 195,250,247,150,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 625)
		{ { 128,56,32,103,11 }, { 77,16,3,14,13 }, { 222,96,65,192,1 }, { 183,12,0,139,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 626)
		{ { 132,17,185,214,3 }, { 220,146,132,26,7 }, { 198,185,216,130,1 }, { 229,130,20,147,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 627)
		{ { 128,3,252,100,10 }, { 40,147,15,26,4 }, { 82,99,252,0,1 }, { 37,143,12,145,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 628)
		{ { 130,59,15,187,10 }, { 81,115,143,7,11 }, { 93,223,13,196,1 }, { 222,15,28,232,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 629)
		{ { 134,42,167,117,10 }, { 153,209,139,15,12 }, { 90,238,85,70,1 }, { 63,13,24,185,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 630)
		{ { 132,27,89,75,7 }, { 244,50,76,30,9 }, { 237,41,173,130,1 }, { 151,131,36,194,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 631)
		{ { 130,68,49,200,10 }, { 16,52,1,59,6 }, { 81,56,194,36,1 }, { 109,200,2,192,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 632)
		{ { 130,89,216,117,3 }, { 108,150,134,31,8 }, { 202,225,185,164,1 }, { 31,134,22,147,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 633)
		{ { 132,72,31,220,14 }, { 152,117,197,26,10 }, { 115,191,129,34,1 }, { 85,138,58,225,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 634)
		{ { 130,181,229,107,4 }, { 113,163,82,47,5 }, { 45,106,122,212,1 }, { 175,68,172,88,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 635)
		{ { 128,183,10,183,0 }, { 73,66,158,38,3 }, { 14,213,14,208,1 }, { 198,71,148,41,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 636)
		{ { 134,178,80,25,10 }, { 225,48,153,23,0 }, { 89,128,164,214,1 }, { 14,137,144,200,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 637)
		{ { 128,204,47,123,8 }, { 16,101,151,46,13 }, { 29,239,67,48,1 }, { 183,78,154,96,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 638)
		{ { 134,253,182,100,8 }, { 201,199,19,59,12 }, { 18,102,219,246,1 }, { 61,204,142,57,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 639)
		{ { 129,121,60,62,9 }, { 77,39,135,82,13 }, { 151,195,201,232,1 }, { 180,174,30,75,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 640)
		{ { 133,96,132,133,11 }, { 141,149,1,70,2 }, { 218,18,16,106,1 }, { 70,40,10,155,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 641)
		{ { 131,98,22,146,5 }, { 5,69,200,83,3 }, { 164,150,132,108,1 }, { 204,161,58,42,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 642)
		{ { 131,128,229,221,15 }, { 60,177,209,79,6 }, { 251,186,112,28,1 }, { 111,40,184,211,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 643)
		{ { 135,160,76,203,2 }, { 161,49,20,79,3 }, { 77,51,32,94,1 }, { 207,34,136,200,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 644)
		{ { 135,184,138,180,13 }, { 205,192,215,67,10 }, { 178,213,17,222,1 }, { 92,46,176,59,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 645)
		{ { 142,2,6,56,4 }, { 130,97,202,3,0 }, { 33,198,4,7,1 }, { 12,5,56,100,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 646)
		{ { 140,54,125,172,7 }, { 255,49,78,50,6 }, { 227,91,230,195,1 }, { 100,199,40,207,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 647)
		{ { 140,65,233,44,2 }, { 186,182,6,2,4 }, { 67,73,120,35,1 }, { 36,6,6,213,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 648)
		{ { 140,152,59,175,12 }, { 218,96,87,22,15 }, { 63,93,193,147,1 }, { 246,142,160,101,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 649)
		{ { 136,244,107,79,11 }, { 127,116,21,46,5 }, { 223,45,98,241,1 }, { 167,74,130,239,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 650)
		{ { 143,44,197,204,4 }, { 187,161,64,107,10 }, { 35,58,51,79,1 }, { 93,96,40,93,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 651)
		{ { 141,55,126,115,3 }, { 231,83,142,126,5 }, { 204,231,238,203,1 }, { 167,231,28,174,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 652)
		{ { 139,69,79,63,7 }, { 62,119,198,103,1 }, { 239,207,42,45,1 }, { 142,102,62,231,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 653)
		{ { 141,86,37,150,0 }, { 218,5,136,98,7 }, { 6,154,70,171,1 }, { 228,97,26,5,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 654)
		{ { 139,191,24,57,2 }, { 67,50,158,119,8 }, { 73,193,143,221,1 }, { 30,231,148,204,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 655)
		{ { 141,166,67,9,4 }, { 179,96,88,102,0 }, { 41,12,38,91,1 }, { 6,97,160,108,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 656)
		{ { 141,208,202,166,8 }, { 234,196,23,66,3 }, { 22,85,48,187,1 }, { 196,46,130,53,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 657)
		{ { 139,246,152,79,4 }, { 75,164,92,127,1 }, { 47,33,150,253,1 }, { 143,227,162,93,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 658)
		{ { 144,18,153,165,4 }, { 88,136,78,22,2 }, { 42,89,148,128,9 }, { 70,135,33,17,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 659)
		{ { 150,46,4,135,5 }, { 141,9,72,39,11 }, { 174,18,7,70,9 }, { 222,65,41,11,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 660)
		{ { 146,92,163,212,0 }, { 88,204,128,43,14 }, { 2,188,83,164,9 }, { 125,64,19,49,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 661)
		{ { 146,133,143,119,10 }, { 24,219,151,47,1 }, { 94,239,26,20,9 }, { 143,78,157,177,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 662)
		{ { 148,169,61,69,10 }, { 153,27,21,30,12 }, { 90,43,201,82,9 }, { 55,138,141,137,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 663)
		{ { 145,32,243,51,2 }, { 49,216,130,86,5 }, { 76,204,240,72,9 }, { 166,164,17,184,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 664)
		{ { 145,39,109,79,3 }, { 61,59,12,110,5 }, { 207,43,110,72,9 }, { 167,99,13,203,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 665)
		{ { 151,51,253,233,10 }, { 241,187,15,95,6 }, { 89,123,252,206,9 }, { 111,175,13,216,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 666)
		{ { 151,72,243,129,3 }, { 180,220,0,87,14 }, { 200,28,241,46,9 }, { 126,160,3,178,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 667)
		{ { 151,159,160,6,9 }, { 204,138,25,99,13 }, { 150,0,95,158,9 }, { 188,105,133,19,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 668)
		{ { 147,208,63,215,12 }, { 88,77,213,95,7 }, { 62,191,192,188,9 }, { 239,170,187,33,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 669)
		{ { 149,252,208,110,0 }, { 233,172,18,122,9 }, { 7,96,179,250,9 }, { 149,228,131,89,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 670)
		{ { 147,195,178,11,1 }, { 4,238,24,87,5 }, { 141,4,220,60,9 }, { 174,161,135,114,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 671)
		{ { 145,195,66,1,14 }, { 32,94,89,70,0 }, { 120,4,44,56,9 }, { 6,41,167,160,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 672)
		{ { 158,10,212,208,9 }, { 166,137,137,27,10 }, { 144,178,181,7,9 }, { 93,137,25,22,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 673)
		{ { 158,62,24,70,8 }, { 203,8,13,59,9 }, { 22,33,135,199,9 }, { 157,203,1,13,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 674)
		{ { 154,97,122,220,9 }, { 47,110,133,27,6 }, { 147,181,232,101,9 }, { 109,138,23,111,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 675)
		{ { 152,200,135,101,13 }, { 30,205,83,14,8 }, { 186,110,17,49,9 }, { 23,12,171,55,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 676)
		{ { 152,193,223,48,9 }, { 54,207,151,18,0 }, { 144,207,184,49,9 }, { 4,142,159,54,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 677)
		{ { 158,249,40,250,12 }, { 195,46,215,11,15 }, { 53,241,73,247,9 }, { 253,14,183,76,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 678)
		{ { 158,240,171,22,1 }, { 223,204,148,3,5 }, { 134,141,80,247,9 }, { 172,2,147,63,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 679)
		{ { 152,251,117,9,13 }, { 119,47,89,22,12 }, { 185,10,237,241,9 }, { 54,137,175,78,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 680)
		{ { 159,32,1,53,4 }, { 155,8,194,71,0 }, { 42,200,0,79,9 }, { 14,36,49,13,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 681)
		{ { 153,18,120,7,12 }, { 106,8,77,86,5 }, { 62,1,228,137,9 }, { 166,171,33,5,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 682)
		{ { 155,131,245,126,11 }, { 62,187,155,91,5 }, { 215,234,252,29,9 }, { 173,173,157,215,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 683)
		{ { 153,249,200,173,5 }, { 111,174,86,70,10 }, { 171,81,57,249,9 }, { 86,38,167,95,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 684)
		{ { 157,228,46,236,2 }, { 139,125,22,106,6 }, { 67,119,66,123,9 }, { 101,102,139,237,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 685)
		{ { 155,219,144,210,3 }, { 70,158,152,91,11 }, { 196,176,157,189,9 }, { 221,161,151,150,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 686)
		{ { 159,254,132,153,15 }, { 199,189,217,103,10 }, { 249,146,23,255,9 }, { 94,105,187,222,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 687)
		{ { 162,66,140,215,9 }, { 12,133,173,15,3 }, { 158,179,20,36,5 }, { 207,11,90,19,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 688)
		{ { 164,205,25,53,7 }, { 156,22,246,54,8 }, { 234,201,139,50,5 }, { 22,198,246,131,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 689)
		{ { 166,213,162,25,0 }, { 192,230,176,39,4 }, { 9,132,90,182,5 }, { 46,64,214,112,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 690)
		{ { 160,223,192,176,6 }, { 96,150,250,34,10 }, { 96,208,63,176,5 }, { 84,69,246,144,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 691)
		{ { 163,49,180,144,4 }, { 65,131,224,83,6 }, { 32,146,216,204,5 }, { 108,160,124,24,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 692)
		{ { 167,32,134,58,15 }, { 133,241,227,67,1 }, { 245,198,16,78,5 }, { 140,44,120,250,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 693)
		{ { 167,56,45,40,13 }, { 213,33,103,67,12 }, { 177,75,65,206,5 }, { 60,46,104,74,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 694)
		{ { 163,63,204,220,14 }, { 105,179,237,107,10 }, { 115,179,63,204,5 }, { 93,107,124,217,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 695)
		{ { 165,62,179,132,11 }, { 221,208,41,114,14 }, { 210,28,215,202,5 }, { 116,233,64,187,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 696)
		{ { 161,112,26,189,7 }, { 77,116,230,86,2 }, { 235,213,128,232,5 }, { 70,166,114,235,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 697)
		{ { 167,103,101,55,9 }, { 189,7,171,103,5 }, { 158,202,110,110,5 }, { 174,109,94,11,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 698)
		{ { 165,123,102,174,4 }, { 233,103,106,66,15 }, { 39,86,109,234,5 }, { 244,37,110,105,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 699)
		{ { 161,213,29,147,2 }, { 80,23,180,118,3 }, { 76,155,138,184,5 }, { 198,226,222,128,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 700)
		{ { 163,248,233,155,14 }, { 113,180,245,71,15 }, { 125,153,113,252,5 }, { 254,42,242,216,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 701)
		{ { 165,211,131,218,3 }, { 212,246,184,74,3 }, { 197,188,28,186,5 }, { 197,33,214,242,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 702)
		{ { 165,214,235,188,6 }, { 248,244,254,98,6 }, { 99,221,118,186,5 }, { 100,103,242,241,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 703)
		{ { 170,38,227,151,9 }, { 63,192,169,39,7 }, { 158,156,118,69,5 }, { 238,73,80,63,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 704)
		{ { 174,30,201,63,12 }, { 250,160,239,39,9 }, { 63,201,55,135,5 }, { 158,79,112,85,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 705)
		{ { 172,119,184,237,2 }, { 203,182,46,62,6 }, { 75,113,222,227,5 }, { 103,199,70,221,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 706)
		{ { 170,169,238,77,15 }, { 47,243,117,15,12 }, { 251,39,121,85,5 }, { 63,10,236,255,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 707)
		{ { 170,128,121,170,6 }, { 50,48,118,19,7 }, { 101,89,224,21,5 }, { 236,134,224,196,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 708)
		{ { 174,194,96,202,1 }, { 166,36,56,11,7 }, { 133,48,100,55,5 }, { 237,1,194,70,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 709)
		{ { 169,58,152,98,11 }, { 71,144,47,90,9 }, { 212,97,149,201,5 }, { 149,175,64,158,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 710)
		{ { 171,18,81,200,12 }, { 114,32,105,91,2 }, { 49,56,164,141,5 }, { 77,169,96,68,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 711)
		{ { 173,102,219,216,13 }, { 183,228,237,122,2 }, { 177,189,182,107,5 }, { 69,235,114,126,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 712)
		{ { 173,82,221,74,1 }, { 246,165,44,90,1 }, { 133,43,180,171,5 }, { 133,163,74,86,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 713)
		{ { 169,182,113,16,8 }, { 115,0,185,114,4 }, { 16,136,230,217,5 }, { 36,233,208,12,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 714)
		{ { 173,186,226,53,0 }, { 235,192,186,70,12 }, { 10,196,117,219,5 }, { 54,37,208,61,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 715)
		{ { 173,151,65,223,12 }, { 250,34,249,110,3 }, { 63,184,46,155,5 }, { 199,105,244,69,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 716)
		{ { 171,243,182,44,7 }, { 79,247,122,83,4 }, { 227,70,220,253,5 }, { 44,165,238,255,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 717)
		{ { 182,34,108,113,12 }, { 161,9,239,15,4 }, { 56,227,100,70,13 }, { 47,15,121,8,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 718)
		{ { 180,30,37,122,7 }, { 212,57,234,42,13 }, { 229,234,71,130,13 }, { 181,69,121,194,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 719)
		{ { 182,55,195,138,3 }, { 245,250,40,35,3 }, { 197,28,62,198,13 }, { 204,65,69,250,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 720)
		{ { 176,76,212,55,0 }, { 40,141,162,54,9 }, { 14,194,179,32,13 }, { 150,196,91,17,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 721)
		{ { 178,127,139,5,3 }, { 93,222,44,39,8 }, { 202,13,31,228,13 }, { 30,67,71,187,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 722)
		{ { 176,173,216,34,5 }, { 37,138,118,50,9 }, { 164,65,187,80,13 }, { 148,198,229,26,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 723)
		{ { 180,155,130,43,11 }, { 196,250,59,6,9 }, { 221,68,29,146,13 }, { 150,13,197,242,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 724)
		{ { 176,211,78,194,3 }, { 100,95,60,10,3 }, { 196,55,44,176,13 }, { 197,3,207,162,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 725)
		{ { 177,61,126,195,14 }, { 97,91,101,126,15 }, { 124,55,235,200,13 }, { 247,234,109,168,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 726)
		{ { 177,6,164,99,14 }, { 0,153,107,110,5 }, { 124,98,86,8,13 }, { 167,109,105,144,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 727)
		{ { 179,43,116,63,14 }, { 41,59,235,87,13 }, { 127,194,237,76,13 }, { 190,173,125,201,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 728)
		{ { 183,31,214,70,15 }, { 236,219,105,123,9 }, { 246,38,191,142,13 }, { 157,233,109,179,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 729)
		{ { 177,110,241,244,5 }, { 61,140,234,122,14 }, { 162,248,247,104,13 }, { 117,229,115,27,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 730)
		{ { 177,126,83,138,14 }, { 113,124,105,114,11 }, { 117,28,167,232,13 }, { 212,233,99,232,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 731)
		{ { 183,98,223,55,7 }, { 189,221,238,87,1 }, { 238,207,180,110,13 }, { 142,167,123,187,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 732)
		{ { 177,169,248,148,9 }, { 45,138,181,82,14 }, { 146,145,249,88,13 }, { 116,170,213,27,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 733)
		{ { 179,183,217,210,4 }, { 113,138,252,123,3 }, { 36,185,190,220,13 }, { 205,227,245,24,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 734)
		{ { 179,238,187,76,6 }, { 25,252,124,123,12 }, { 99,45,215,124,13 }, { 61,227,227,249,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 735)
		{ { 184,44,165,82,4 }, { 19,137,224,42,13 }, { 36,170,83,65,13 }, { 181,64,121,28,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 736)
		{ { 184,20,13,235,15 }, { 86,57,103,46,3 }, { 253,123,2,129,13 }, { 199,78,105,198,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 737)
		{ { 188,25,220,199,7 }, { 238,155,100,30,11 }, { 238,51,185,131,13 }, { 215,130,109,151,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 738)
		{ { 188,84,38,185,6 }, { 194,125,226,38,6 }, { 105,214,66,163,13 }, { 102,68,123,228,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 739)
		{ { 190,103,55,196,5 }, { 159,79,104,59,6 }, { 162,62,206,103,13 }, { 109,193,111,47,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 740)
		{ { 184,250,232,211,5 }, { 103,140,252,14,15 }, { 172,177,117,241,13 }, { 247,3,243,30,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 741)
		{ { 190,194,26,55,8 }, { 138,76,191,23,1 }, { 30,197,132,55,13 }, { 142,143,211,37,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 742)
		{ { 187,24,207,164,11 }, { 126,217,39,67,10 }, { 210,95,49,141,13 }, { 92,46,73,183,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 743)
		{ { 189,1,126,246,13 }, { 174,75,231,90,7 }, { 182,247,232,11,13 }, { 229,174,125,39,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 744)
		{ { 189,34,47,210,7 }, { 151,89,236,74,7 }, { 228,191,68,75,13 }, { 229,35,121,174,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 745)
		{ { 189,2,85,133,5 }, { 190,9,104,86,2 }, { 170,26,164,11,13 }, { 70,161,105,7,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 746)
		{ { 185,114,78,96,5 }, { 103,77,110,74,0 }, { 160,103,36,233,13 }, { 5,39,107,46,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 747)
		{ { 189,119,92,22,15 }, { 239,31,237,114,1 }, { 246,131,174,235,13 }, { 132,235,127,143,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 748)
		{ { 185,136,172,46,1 }, { 14,169,54,66,13 }, { 135,67,81,25,13 }, { 180,38,201,87,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 749)
		{ { 191,160,38,103,5 }, { 143,73,114,79,5 }, { 174,102,64,95,13 }, { 175,36,233,47,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 750)
		{ { 185,130,150,168,6 }, { 2,249,122,82,2 }, { 97,86,148,25,13 }, { 68,165,233,244,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 751)
		{ { 189,135,23,24,10 }, { 146,123,185,114,0 }, { 81,142,142,27,13 }, { 4,233,221,228,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 752)
		{ { 191,190,239,45,7 }, { 255,249,126,103,12 }, { 235,79,119,223,13 }, { 62,103,233,255,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 753)
		{ { 189,250,159,0,7 }, { 215,221,124,82,8 }, { 224,15,149,251,13 }, { 20,163,235,190,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 754)
		{ { 194,112,53,187,8 }, { 81,37,131,151,7 }, { 29,218,192,228,3 }, { 238,156,26,72,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 755)
		{ { 196,108,5,172,13 }, { 157,37,67,162,10 }, { 179,90,3,98,3 }, { 84,92,42,75,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 756)
		{ { 196,121,84,220,3 }, { 237,55,128,154,10 }, { 195,178,169,226,3 }, { 85,144,30,203,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 757)
		{ { 194,106,81,13,8 }, { 57,36,9,151,8 }, { 27,8,165,100,3 }, { 30,153,2,73,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 758)
		{ { 198,164,159,104,4 }, { 145,225,86,187,0 }, { 33,111,146,86,3 }, { 13,214,168,120,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 759)
		{ { 192,158,44,235,4 }, { 64,33,94,174,15 }, { 45,115,71,144,3 }, { 247,87,168,64,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 760)
		{ { 198,146,33,73,13 }, { 212,32,89,143,4 }, { 185,40,68,150,3 }, { 47,25,160,66,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 761)
		{ { 196,186,131,207,8 }, { 217,224,25,142,11 }, { 31,60,21,210,3 }, { 215,25,128,121,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 762)
		{ { 198,231,133,67,11 }, { 149,151,25,175,1 }, { 220,42,30,118,3 }, { 143,89,142,154,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 763)
		{ { 198,215,175,70,4 }, { 216,199,92,171,5 }, { 38,47,94,182,3 }, { 173,83,174,49,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 764)
		{ { 197,54,85,77,11 }, { 253,49,9,254,0 }, { 219,42,166,202,3 }, { 7,249,8,203,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 765)
		{ { 195,147,255,13,7 }, { 124,243,92,215,4 }, { 235,15,252,156,3 }, { 46,179,172,243,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 766)
		{ { 193,245,112,165,10 }, { 105,22,19,246,6 }, { 90,80,234,248,3 }, { 102,252,134,137,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 767)
		{ { 204,57,113,197,0 }, { 251,2,0,158,14 }, { 10,56,233,195,3 }, { 119,144,4,13,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 768)
		{ { 200,2,137,73,2 }, { 18,176,12,142,0 }, { 73,41,20,1,3 }, { 7,19,0,212,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 769)
		{ { 200,124,100,74,5 }, { 103,37,64,170,13 }, { 165,34,99,225,3 }, { 181,80,42,78,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 770)
		{ { 202,103,225,13,7 }, { 63,182,72,167,4 }, { 235,8,126,101,3 }, { 46,81,38,223,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 771)
		{ { 200,153,231,66,2 }, { 114,211,16,138,13 }, { 68,46,121,145,3 }, { 181,16,140,180,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 772)
		{ { 200,170,178,16,5 }, { 7,192,216,146,12 }, { 160,132,213,81,3 }, { 52,145,176,62,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 773)
		{ { 204,166,213,159,3 }, { 191,177,152,182,3 }, { 207,154,182,83,3 }, { 198,209,152,223,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 774)
		{ { 202,229,134,251,14 }, { 3,247,211,175,3 }, { 125,246,26,117,3 }, { 207,92,190,252,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 775)
		{ { 202,217,124,49,15 }, { 102,23,215,151,12 }, { 248,195,233,181,3 }, { 62,158,190,134,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 776)
		{ { 206,228,202,14,6 }, { 171,244,84,163,1 }, { 103,5,50,119,3 }, { 140,82,162,253,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 777)
		{ { 203,45,164,50,12 }, { 3,131,195,227,13 }, { 52,194,91,77,3 }, { 188,124,60,28,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 778)
		{ { 203,87,214,130,2 }, { 98,215,8,243,3 }, { 68,22,190,173,3 }, { 204,241,14,180,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 779)
		{ { 201,144,33,177,0 }, { 82,0,146,198,6 }, { 8,216,64,153,3 }, { 102,52,144,4,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 780)
		{ { 201,130,95,176,10 }, { 50,81,159,210,2 }, { 80,223,164,25,3 }, { 68,191,152,164,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 781)
		{ { 203,158,212,36,7 }, { 110,145,90,243,8 }, { 226,66,183,157,3 }, { 28,245,168,151,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 782)
		{ { 205,134,171,157,13 }, { 158,224,221,230,6 }, { 187,157,86,27,3 }, { 102,123,176,119,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 783)
		{ { 201,201,176,119,5 }, { 14,134,210,222,13 }, { 174,224,217,57,3 }, { 183,180,182,23,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 784)
		{ { 201,250,31,99,2 }, { 83,85,30,222,9 }, { 76,111,133,249,3 }, { 151,183,138,172,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 785)
		{ { 203,247,64,6,9 }, { 111,6,25,227,1 }, { 150,0,46,253,3 }, { 140,121,134,15,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 786)
		{ { 205,218,13,28,15 }, { 222,53,221,194,8 }, { 243,139,5,187,3 }, { 20,59,186,199,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 787)
		{ { 208,11,130,83,15 }, { 4,218,201,142,9 }, { 252,164,29,0,11 }, { 151,25,53,178,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 788)
		{ { 212,59,207,214,15 }, { 253,219,205,138,11 }, { 246,191,61,194,11 }, { 213,27,61,187,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 789)
		{ { 214,98,171,209,11 }, { 149,220,141,143,6 }, { 216,189,84,102,11 }, { 111,27,19,186,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 790)
		{ { 212,102,200,58,15 }, { 165,188,207,162,1 }, { 245,193,54,98,11 }, { 132,95,51,218,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 791)
		{ { 209,32,28,120,10 }, { 1,57,135,218,0 }, { 81,227,128,72,11 }, { 5,190,25,200,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 792)
		{ { 211,57,65,195,9 }, { 117,10,1,207,11 }, { 156,56,41,204,11 }, { 223,56,5,10,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 793)
		{ { 209,7,160,253,4 }, { 8,170,202,238,6 }, { 43,240,94,8,11 }, { 103,117,53,81,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 794)
		{ { 209,149,58,14,2 }, { 72,122,20,242,5 }, { 71,5,202,152,11 }, { 164,242,133,225,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 795)
		{ { 215,189,66,29,13 }, { 237,106,209,231,8 }, { 187,132,43,222,11 }, { 30,120,181,107,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 796)
		{ { 215,192,166,80,13 }, { 132,205,209,203,4 }, { 176,166,80,62,11 }, { 45,56,187,50,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 797)
		{ { 215,229,141,245,12 }, { 153,143,215,239,2 }, { 58,251,26,126,11 }, { 79,126,191,25,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 798)
		{ { 215,197,83,246,7 }, { 188,94,210,251,3 }, { 230,252,170,62,11 }, { 205,244,183,163,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 799)
		{ { 213,254,112,184,8 }, { 225,44,155,242,14 }, { 17,208,231,250,11 }, { 116,253,147,72,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 800)
		{ { 216,12,185,190,6 }, { 26,184,198,178,15 }, { 103,217,211,1,11 }, { 244,214,49,213,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 801)
		{ { 222,52,186,37,6 }, { 203,216,70,183,4 }, { 106,69,210,199,11 }, { 46,214,33,189,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 802)
		{ { 220,14,198,139,14 }, { 162,249,73,166,11 }, { 125,22,55,3,11 }, { 214,89,41,244,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 803)
		{ { 222,3,247,164,11 }, { 190,219,11,147,6 }, { 210,94,252,7,11 }, { 108,157,13,183,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 804)
		{ { 218,93,11,138,2 }, { 82,126,4,163,11 }, { 69,29,11,165,11 }, { 220,82,7,228,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 805)
		{ { 216,113,249,127,15 }, { 127,190,199,158,5 }, { 255,233,248,225,11 }, { 167,158,55,223,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 806)
		{ { 220,189,130,231,2 }, { 203,218,18,174,11 }, { 78,116,27,211,11 }, { 215,84,133,189,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 807)
		{ { 220,176,90,229,5 }, { 239,72,86,158,2 }, { 170,117,160,211,11 }, { 71,150,161,47,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 808)
		{ { 218,147,222,80,0 }, { 98,203,156,155,0 }, { 0,167,188,149,11 }, { 13,147,157,52,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 809)
		{ { 218,183,241,191,8 }, { 123,170,155,183,7 }, { 31,216,254,213,11 }, { 238,221,149,93,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 810)
		{ { 222,159,2,50,14 }, { 194,90,219,163,9 }, { 116,196,15,151,11 }, { 156,93,181,164,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 811)
		{ { 218,196,13,85,0 }, { 26,13,148,175,0 }, { 10,171,2,53,11 }, { 15,82,155,5,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 812)
		{ { 220,197,171,128,14 }, { 146,222,85,162,6 }, { 112,29,90,51,11 }, { 100,90,167,180,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 813)
		{ { 218,194,178,58,10 }, { 2,252,155,147,5 }, { 85,196,212,53,11 }, { 172,157,147,244,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 814)
		{ { 218,218,88,253,0 }, { 106,44,158,159,10 }, { 11,241,165,181,11 }, { 95,151,147,69,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 815)
		{ { 217,37,142,168,1 }, { 7,235,6,226,2 }, { 129,87,26,73,11 }, { 68,118,13,126,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 816)
		{ { 221,5,118,59,14 }, { 162,123,195,246,5 }, { 125,198,234,11,11 }, { 166,252,61,228,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 817)
		{ { 221,46,153,8,12 }, { 147,168,77,242,8 }, { 49,9,151,75,11 }, { 20,251,33,92,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 818)
		{ { 217,85,104,199,5 }, { 110,14,68,238,7 }, { 174,49,106,169,11 }, { 231,114,39,7,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 819)
		{ { 219,80,109,76,3 }, { 126,61,4,203,4 }, { 195,43,96,173,11 }, { 45,50,11,199,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 820)
		{ { 223,104,170,56,8 }, { 131,236,135,195,12 }, { 17,197,81,111,11 }, { 60,62,19,124,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 821)
		{ { 219,66,135,167,5 }, { 30,205,74,199,3 }, { 174,94,20,45,11 }, { 206,53,43,55,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 822)
		{ { 219,129,40,179,13 }, { 6,10,215,199,7 }, { 188,209,72,29,11 }, { 238,62,181,6,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 823)
		{ { 217,163,194,250,13 }, { 39,234,219,202,3 }, { 181,244,60,89,11 }, { 197,61,181,126,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 824)
		{ { 221,179,56,211,8 }, { 195,10,157,222,7 }, { 28,177,204,219,11 }, { 231,187,149,12,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 825)
		{ { 217,202,123,155,1 }, { 54,108,156,214,15 }, { 141,157,229,57,11 }, { 246,179,147,102,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 826)
		{ { 219,246,158,176,7 }, { 71,221,222,243,2 }, { 224,215,150,253,11 }, { 76,247,187,190,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 827)
		{ { 226,8,108,175,8 }, { 40,33,39,135,15 }, { 31,83,97,4,7 }, { 254,30,72,65,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 828)
		{ { 224,27,171,150,4 }, { 88,194,236,130,15 }, { 38,157,93,128,7 }, { 244,19,116,49,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 829)
		{ { 224,72,115,243,0 }, { 48,68,162,158,15 }, { 12,252,225,32,7 }, { 247,148,82,32,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 830)
		{ { 228,117,169,91,14 }, { 209,182,229,174,5 }, { 125,169,90,226,7 }, { 167,90,118,216,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 831)
		{ { 230,128,236,116,9 }, { 172,129,183,139,4 }, { 146,227,112,22,7 }, { 45,30,216,19,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 832)
		{ { 226,175,118,72,7 }, { 37,115,120,187,12 }, { 225,38,239,84,7 }, { 61,209,236,234,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 833)
		{ { 224,162,200,17,13 }, { 37,128,253,134,0 }, { 184,129,52,80,7 }, { 6,27,240,26,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 834)
		{ { 226,203,113,80,12 }, { 48,6,249,155,12 }, { 48,168,237,52,7 }, { 61,153,246,0,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 835)
		{ { 224,210,73,197,15 }, { 124,20,125,142,2 }, { 250,57,36,176,7 }, { 71,27,226,131,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 836)
		{ { 225,12,194,130,9 }, { 36,192,33,226,11 }, { 148,20,51,8,7 }, { 212,120,64,50,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 837)
		{ { 225,127,68,52,3 }, { 109,23,170,226,8 }, { 194,194,47,232,7 }, { 20,117,94,139,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 838)
		{ { 231,173,69,177,14 }, { 177,19,243,231,10 }, { 120,218,43,94,7 }, { 94,124,252,136,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 839)
		{ { 225,182,90,159,9 }, { 109,96,189,246,3 }, { 159,149,166,216,7 }, { 198,251,208,107,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 840)
		{ { 231,252,32,65,12 }, { 193,4,113,239,12 }, { 56,32,67,254,7 }, { 63,120,226,8,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 841)
		{ { 238,51,65,56,1 }, { 247,34,170,131,0 }, { 129,200,44,199,7 }, { 12,21,84,78,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 842)
		{ { 238,124,54,51,4 }, { 195,69,226,183,13 }, { 44,198,195,231,7 }, { 190,212,122,44,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 843)
		{ { 236,112,123,248,10 }, { 243,116,167,154,6 }, { 81,253,224,227,7 }, { 101,158,82,236,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 844)
		{ { 232,123,59,230,14 }, { 91,86,111,154,15 }, { 118,125,205,225,7 }, { 245,159,102,173,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 845)
		{ { 232,149,232,57,1 }, { 102,162,182,166,4 }, { 137,193,122,145,7 }, { 38,86,212,86,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 846)
		{ { 238,172,9,125,5 }, { 159,32,246,175,8 }, { 171,233,3,87,7 }, { 31,86,240,79,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 847)
		{ { 236,161,201,55,4 }, { 187,130,246,134,1 }, { 46,201,56,83,7 }, { 134,22,244,29,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 848)
		{ { 232,151,189,197,5 }, { 94,131,124,190,6 }, { 170,59,222,145,7 }, { 103,211,236,23,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 849)
		{ { 232,204,18,29,0 }, { 10,100,176,182,8 }, { 11,132,131,49,7 }, { 22,208,210,101,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 850)
		{ { 238,193,29,105,8 }, { 146,39,55,159,0 }, { 25,107,136,55,7 }, { 15,158,206,68,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 851)
		{ { 237,7,255,219,10 }, { 178,243,173,254,7 }, { 93,191,254,11,7 }, { 231,251,92,244,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 852)
		{ { 237,105,243,54,11 }, { 191,214,163,210,13 }, { 214,204,249,107,7 }, { 180,188,86,191,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 853)
		{ { 237,118,20,181,12 }, { 203,5,235,246,2 }, { 58,210,134,235,7 }, { 70,253,122,13,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 854)
		{ { 239,132,33,209,7 }, { 150,16,240,239,6 }, { 232,184,66,31,7 }, { 111,112,240,134,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 855)
		{ { 235,245,218,120,2 }, { 99,246,182,251,0 }, { 65,229,186,253,7 }, { 13,246,214,252,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 856)
		{ { 233,249,229,214,13 }, { 127,135,241,202,15 }, { 182,186,121,249,7 }, { 245,56,254,31,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 857)
		{ { 235,211,15,145,9 }, { 86,71,189,199,2 }, { 152,159,12,189,7 }, { 78,59,222,38,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 858)
		{ { 233,219,241,32,9 }, { 118,134,59,210,12 }, { 144,72,253,185,7 }, { 52,189,198,22,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 859)
		{ { 244,41,139,109,8 }, { 153,234,39,142,8 }, { 27,109,25,66,15 }, { 23,30,69,121,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 860)
		{ { 246,10,52,34,5 }, { 132,9,106,147,13 }, { 164,66,197,6,15 }, { 188,149,105,2,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 861)
		{ { 244,88,85,155,1 }, { 244,45,160,150,11 }, { 141,154,161,162,15 }, { 214,144,91,66,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 862)
		{ { 242,118,55,97,3 }, { 85,93,42,191,4 }, { 200,110,198,228,15 }, { 47,213,75,170,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 863)
		{ { 244,75,10,224,6 }, { 128,94,110,138,10 }, { 96,117,13,34,15 }, { 85,23,103,160,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 864)
		{ { 246,110,129,75,12 }, { 145,172,105,175,9 }, { 61,40,23,102,15 }, { 159,89,99,88,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 865)
		{ { 246,67,29,76,6 }, { 152,63,108,155,0 }, { 99,43,140,38,15 }, { 13,147,111,193,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 866)
		{ { 244,87,34,238,1 }, { 204,110,42,170,7 }, { 135,116,78,162,15 }, { 229,85,71,99,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 867)
		{ { 244,153,83,229,11 }, { 252,90,51,158,10 }, { 218,124,169,146,15 }, { 87,156,197,163,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 868)
		{ { 240,252,47,27,5 }, { 85,109,244,166,13 }, { 173,143,67,240,15 }, { 182,82,251,106,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 869)
		{ { 247,9,30,9,12 }, { 128,107,101,215,8 }, { 57,7,137,14,15 }, { 30,186,109,96,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 870)
		{ { 247,38,87,194,0 }, { 177,73,40,251,3 }, { 4,62,166,78,15 }, { 205,241,73,40,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 871)
		{ { 241,133,27,198,13 }, { 28,74,117,250,3 }, { 182,61,138,24,15 }, { 197,250,229,35,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 872)
		{ { 243,136,98,232,1 }, { 36,104,50,203,14 }, { 129,116,97,28,15 }, { 125,52,193,98,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 873)
		{ { 247,169,183,234,6 }, { 145,251,114,219,15 }, { 101,126,217,94,15 }, { 253,180,237,248,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 874)
		{ { 247,138,138,92,2 }, { 136,248,188,203,8 }, { 67,165,21,30,15 }, { 29,51,209,241,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 875)
		{ { 243,237,194,21,2 }, { 41,222,176,231,8 }, { 74,132,59,124,15 }, { 30,112,215,185,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 876)
		{ { 245,245,148,242,4 }, { 193,143,242,250,3 }, { 36,242,154,250,15 }, { 197,244,255,24,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 877)
		{ { 248,15,62,15,4 }, { 10,107,108,182,13 }, { 47,7,207,1,15 }, { 182,211,109,101,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 878)
		{ { 252,190,99,125,14 }, { 251,120,251,174,12 }, { 123,236,103,211,15 }, { 55,93,241,237,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 879)
		{ { 248,237,33,73,11 }, { 23,62,49,174,12 }, { 217,40,75,113,15 }, { 55,88,199,206,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 880)
		{ { 250,216,194,128,14 }, { 98,220,113,131,10 }, { 112,20,49,181,15 }, { 92,24,227,180,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 881)
		{ { 254,229,5,156,6 }, { 155,63,240,163,2 }, { 99,154,10,119,15 }, { 76,80,255,205,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 882)
		{ { 254,196,253,27,8 }, { 178,173,181,183,5 }, { 29,139,242,55,15 }, { 174,218,219,84,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 883)
		{ { 250,210,225,31,4 }, { 122,172,248,135,5 }, { 47,136,116,181,15 }, { 174,17,243,85,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 884)
		{ { 252,195,230,115,2 }, { 162,223,186,142,5 }, { 76,230,124,51,15 }, { 167,21,223,180,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 885)
		{ { 249,63,162,110,11 }, { 79,250,43,234,13 }, { 215,100,95,201,15 }, { 181,125,69,255,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 886)
		{ { 251,86,194,94,3 }, { 110,252,168,235,1 }, { 199,164,54,173,15 }, { 141,113,83,247,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 887)
		{ { 255,78,140,162,15 }, { 134,157,111,227,11 }, { 244,83,23,47,15 }, { 220,127,107,150,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 888)
		{ { 255,79,112,226,4 }, { 162,14,106,251,15 }, { 36,112,239,47,15 }, { 253,245,103,4,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 889)
		{ { 249,177,42,52,9 }, { 79,74,183,194,4 }, { 146,197,72,217,15 }, { 36,62,213,47,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 890)
		{ { 255,135,146,120,1 }, { 134,234,186,251,0 }, { 129,228,158,31,15 }, { 13,245,213,118,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 891)
		{ { 249,195,188,9,10 }, { 2,191,61,214,4 }, { 89,3,220,57,15 }, { 38,187,207,212,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 892)
		{ { 255,202,25,209,12 }, { 146,12,253,223,10 }, { 56,185,133,63,15 }, { 95,187,243,4,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 893)
		{ { 255,239,23,165,10 }, { 155,95,59,247,10 }, { 90,94,143,127,15 }, { 94,253,207,173,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 894)
		{ { 253,254,218,140,1 }, { 239,236,60,242,10 }, { 131,21,183,251,15 }, { 84,243,195,127,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 895)
		{ { 6,66,233,9,7 }, { 180,180,76,5,4 }, { 233,9,116,38,0 }, { 42,3,34,210,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 896)
		{ { 3,36,36,70,13 }, { 13,1,65,105,5 }, { 182,34,66,76,0 }, { 169,104,40,11,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 897)
		{ { 7,94,92,135,12 }, { 232,5,77,117,11 }, { 62,19,167,174,0 }, { 218,235,42,1,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 898)
		{ { 7,136,66,250,6 }, { 160,112,210,73,11 }, { 101,244,33,30,0 }, { 217,36,176,224,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 899)
		{ { 10,7,178,27,11 }, { 6,242,137,53,5 }, { 221,132,222,5,0 }, { 170,201,20,246,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 900)
		{ { 16,148,220,241,14 }, { 96,153,215,60,2 }, { 120,243,178,144,8 }, { 67,206,185,144,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 901)
		{ { 22,162,90,176,15 }, { 165,88,223,17,2 }, { 240,213,164,86,8 }, { 72,143,177,170,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 902)
		{ { 16,253,203,109,14 }, { 121,254,87,44,8 }, { 123,109,59,240,8 }, { 19,78,167,249,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 903)
		{ { 17,52,172,162,12 }, { 65,137,71,96,7 }, { 52,83,82,200,8 }, { 224,110,41,24,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 904)
		{ { 17,166,62,16,1 }, { 5,73,156,112,4 }, { 128,135,198,88,8 }, { 32,227,153,42,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 905)
		{ { 30,88,44,226,2 }, { 194,29,6,9,15 }, { 68,115,65,167,8 }, { 249,6,11,132,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 906)
		{ { 24,99,58,139,0 }, { 3,110,12,20,7 }, { 13,21,204,97,8 }, { 226,131,7,108,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 907)
		{ { 26,99,1,47,13 }, { 31,46,75,5,1 }, { 191,72,12,101,8 }, { 138,13,39,79,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 908)
		{ { 26,241,71,206,15 }, { 127,127,81,9,3 }, { 247,62,40,245,8 }, { 201,8,175,239,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 909)
		{ { 25,108,177,139,1 }, { 23,172,0,116,15 }, { 141,24,211,105,8 }, { 242,224,3,94,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 910)
		{ { 29,149,207,92,12 }, { 250,235,213,104,0 }, { 51,175,58,155,8 }, { 1,106,189,117,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 911)
		{ { 25,158,56,146,2 }, { 66,24,156,112,15 }, { 68,145,199,153,8 }, { 240,227,145,132,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 912)
		{ { 31,252,86,35,10 }, { 227,93,19,117,9 }, { 92,70,163,255,8 }, { 154,236,139,172,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 913)
		{ { 36,27,41,179,3 }, { 212,18,174,4,15 }, { 204,217,77,130,4 }, { 242,7,84,130,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 914)
		{ { 38,231,136,133,0 }, { 137,134,60,37,2 }, { 10,17,30,118,4 }, { 74,67,198,25,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 915)
		{ { 33,7,54,188,1 }, { 12,99,170,112,6 }, { 131,214,206,8,4 }, { 96,229,92,99,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 916)
		{ { 40,77,70,86,10 }, { 42,87,161,40,9 }, { 86,166,43,33,4 }, { 145,72,94,165,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 917)
		{ { 46,236,227,69,8 }, { 187,196,49,45,12 }, { 26,44,115,119,4 }, { 59,72,194,61,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 918)
		{ { 45,79,225,77,4 }, { 186,166,104,108,12 }, { 43,40,127,43,4 }, { 51,97,102,85,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 919)
		{ { 45,138,40,60,7 }, { 142,48,254,64,12 }, { 227,193,69,27,4 }, { 48,39,240,199,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 920)
		{ { 52,248,62,55,1 }, { 205,77,182,20,13 }, { 142,199,193,242,12 }, { 178,134,219,43,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 921)
		{ { 56,99,93,125,8 }, { 59,47,175,28,0 }, { 27,235,172,97,12 }, { 3,143,95,77,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 922)
		{ { 63,162,28,196,12 }, { 139,9,125,89,2 }, { 50,51,132,95,12 }, { 73,171,233,13,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 923)
		{ { 66,221,151,174,14 }, { 88,247,83,177,11 }, { 119,94,155,180,2 }, { 216,220,174,241,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 924)
		{ { 68,223,18,214,11 }, { 204,86,153,184,11 }, { 214,180,143,178,2 }, { 209,217,150,163,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 925)
		{ { 65,58,205,236,8 }, { 121,161,15,200,10 }, { 19,123,53,200,2 }, { 81,63,8,89,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 926)
		{ { 65,192,219,73,4 }, { 48,228,84,220,0 }, { 41,45,176,56,2 }, { 3,178,162,112,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 927)
		{ { 76,180,0,200,13 }, { 199,32,81,168,2 }, { 177,48,2,211,2 }, { 65,88,160,78,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 928)
		{ { 73,35,72,149,2 }, { 43,18,140,196,2 }, { 74,145,44,73,2 }, { 66,51,20,141,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 929)
		{ { 82,55,185,92,6 }, { 89,186,204,185,4 }, { 99,169,222,196,10 }, { 41,211,53,217,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 930)
		{ { 82,81,56,221,10 }, { 72,62,133,157,6 }, { 91,177,200,164,10 }, { 107,154,23,193,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 931)
		{ { 94,113,146,65,3 }, { 199,222,0,157,0 }, { 200,36,152,231,10 }, { 11,144,7,190,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 932)
		{ { 92,178,113,235,13 }, { 247,40,91,156,7 }, { 189,120,228,211,10 }, { 227,157,161,78,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 933)
		{ { 91,238,55,54,6 }, { 27,93,218,241,13 }, { 102,206,199,125,10 }, { 184,245,187,173,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 934)
		{ { 96,5,132,21,2 }, { 8,147,160,164,0 }, { 74,130,26,0,6 }, { 2,80,92,145,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 935)
		{ { 100,8,128,51,8 }, { 128,128,163,132,9 }, { 28,192,17,2,6 }, { 146,28,80,16,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 936)
		{ { 110,40,135,140,3 }, { 159,241,32,129,10 }, { 195,30,17,71,6 }, { 88,16,72,255,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 937)
		{ { 108,85,84,181,7 }, { 238,23,226,180,2 }, { 234,210,170,163,6 }, { 66,212,126,135,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 938)
		{ { 104,186,254,70,1 }, { 111,193,60,152,13 }, { 134,39,245,209,6 }, { 177,147,200,63,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 939)
		{ { 104,179,85,202,7 }, { 119,51,120,152,3 }, { 229,58,172,209,6 }, { 193,145,236,206,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 940)
		{ { 117,156,155,102,9 }, { 220,200,55,248,9 }, { 150,109,147,154,14 }, { 145,254,193,51,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 941)
		{ { 124,11,200,10,0 }, { 162,170,44,128,9 }, { 5,1,61,3,14 }, { 144,19,69,84,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 942)
		{ { 126,89,104,196,9 }, { 238,14,37,137,14 }, { 146,49,105,167,14 }, { 121,26,71,7,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 943)
		{ { 120,111,61,52,5 }, { 31,15,238,176,12 }, { 162,203,207,97,14 }, { 48,215,127,15,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 944)
		{ { 120,193,191,255,10 }, { 26,255,183,156,7 }, { 95,255,216,49,14 }, { 227,158,223,245,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 945)
		{ { 122,218,185,69,10 }, { 90,156,61,157,12 }, { 90,41,213,181,14 }, { 59,155,195,149,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 946)
		{ { 128,60,123,156,0 }, { 121,96,132,50,14 }, { 3,157,227,192,1 }, { 116,194,16,105,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 947)
		{ { 135,20,88,249,7 }, { 228,48,198,127,2 }, { 233,241,162,142,1 }, { 79,230,48,194,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 948)
		{ { 131,27,5,165,13 }, { 92,3,75,71,10 }, { 186,90,13,140,1 }, { 94,45,44,3,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 949)
		{ { 136,59,180,103,4 }, { 75,131,74,30,13 }, { 46,98,221,193,1 }, { 183,133,44,29,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 950)
		{ { 140,169,136,156,0 }, { 139,162,148,2,10 }, { 3,145,25,83,1 }, { 84,2,148,93,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 951)
		{ { 142,177,3,26,11 }, { 215,114,145,3,1 }, { 213,140,8,215,1 }, { 140,8,148,238,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 952)
		{ { 143,39,191,54,4 }, { 155,195,206,115,5 }, { 38,207,222,79,1 }, { 172,231,60,61,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 953)
		{ { 143,22,179,202,0 }, { 210,224,8,123,7 }, { 5,60,214,143,1 }, { 237,225,0,116,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 954)
		{ { 148,24,222,74,0 }, { 224,233,4,26,9 }, { 5,39,177,130,9 }, { 149,130,9,112,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 955)
		{ { 147,69,36,197,0 }, { 8,15,0,111,6 }, { 10,50,74,44,9 }, { 111,96,15,1,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 956)
		{ { 156,253,156,216,5 }, { 199,175,212,58,10 }, { 161,179,155,243,9 }, { 85,194,191,94,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 957)
		{ { 155,34,55,120,13 }, { 23,105,203,91,4 }, { 177,238,196,77,9 }, { 45,173,57,110,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 958)
		{ { 153,250,163,209,6 }, { 83,220,216,78,14 }, { 104,188,85,249,9 }, { 119,33,179,188,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 959)
		{ { 162,159,28,84,3 }, { 76,19,188,59,8 }, { 194,163,143,148,5 }, { 29,195,220,131,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 960)
		{ { 172,79,91,26,11 }, { 182,118,173,50,9 }, { 213,141,175,35,5 }, { 148,203,86,230,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 961)
		{ { 172,191,109,54,6 }, { 251,19,254,34,13 }, { 102,203,111,211,5 }, { 180,71,252,141,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 962)
		{ { 169,185,76,64,8 }, { 99,3,53,74,8 }, { 16,35,41,217,5 }, { 21,42,204,12,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 963)
		{ { 182,40,233,2,12 }, { 177,136,101,3,13 }, { 52,9,113,70,13 }, { 188,10,97,24,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 964)
		{ { 180,109,218,222,0 }, { 169,238,164,58,11 }, { 7,181,187,98,13 }, { 213,194,87,121,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 965)
		{ { 178,110,246,10,1 }, { 37,237,40,51,13 }, { 133,6,247,100,13 }, { 188,193,75,122,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 966)
		{ { 179,37,153,105,14 }, { 17,186,103,127,0 }, { 121,105,154,76,13 }, { 15,238,101,216,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 967)
		{ { 179,80,40,17,5 }, { 68,12,228,71,4 }, { 168,129,64,172,13 }, { 46,34,115,2,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 968)
		{ { 190,28,27,59,6 }, { 210,120,230,55,9 }, { 109,205,131,135,13 }, { 158,198,113,228,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 969)
		{ { 188,127,85,99,14 }, { 243,31,107,62,9 }, { 124,106,175,227,13 }, { 151,205,111,140,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 970)
		{ { 188,175,230,141,5 }, { 175,235,120,38,14 }, { 171,22,127,83,13 }, { 118,65,237,127,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 971)
		{ { 189,37,146,140,4 }, { 139,234,96,114,2 }, { 35,20,154,75,13 }, { 68,224,101,125,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 972)
		{ { 196,27,214,183,1 }, { 236,195,138,150,11 }, { 142,214,189,130,3 }, { 214,149,28,51,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 973)
		{ { 198,99,190,252,14 }, { 137,247,207,155,6 }, { 115,247,220,102,3 }, { 109,159,62,249,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 974)
		{ { 198,86,130,19,13 }, { 196,196,201,167,1 }, { 188,132,22,166,3 }, { 142,89,50,50,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 975)
		{ { 198,139,73,36,10 }, { 184,18,31,131,8 }, { 82,73,45,22,3 }, { 28,31,132,129,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 976)
		{ { 193,61,206,190,2 }, { 105,243,134,226,11 }, { 71,215,59,200,3 }, { 212,118,28,249,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 977)
		{ { 197,25,109,109,1 }, { 252,35,6,206,12 }, { 139,107,105,138,3 }, { 55,54,12,67,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 978)
		{ { 199,77,61,239,11 }, { 156,55,7,255,15 }, { 223,123,203,46,3 }, { 255,254,14,195,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 979)
		{ { 193,90,43,220,9 }, { 92,100,141,202,14 }, { 147,189,69,168,3 }, { 117,59,18,99,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 980)
		{ { 202,35,114,33,12 }, { 35,66,75,151,4 }, { 56,68,236,69,3 }, { 46,157,36,44,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 981)
		{ { 207,199,244,213,9 }, { 174,135,153,255,6 }, { 154,178,254,63,3 }, { 111,249,158,23,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 982)
		{ { 208,49,39,226,6 }, { 81,91,66,138,7 }, { 100,126,72,192,11 }, { 229,20,45,168,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 983)
		{ { 212,119,84,14,0 }, { 233,47,8,178,1 }, { 7,2,174,226,11 }, { 132,209,15,73,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 984)
		{ { 209,134,49,90,2 }, { 16,56,152,250,5 }, { 69,168,198,24,11 }, { 165,241,145,192,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 985)
		{ { 219,76,100,122,11 }, { 38,61,131,235,13 }, { 213,226,99,45,11 }, { 189,124,27,198,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 986)
		{ { 219,132,135,144,8 }, { 18,201,145,227,2 }, { 16,158,18,29,11 }, { 76,120,153,52,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 987)
		{ { 223,222,6,112,0 }, { 194,77,154,235,8 }, { 0,230,7,191,11 }, { 29,117,155,36,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 988)
		{ { 226,41,186,96,0 }, { 1,194,38,155,12 }, { 0,101,217,68,7 }, { 61,150,68,56,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 989)
		{ { 225,64,224,141,6 }, { 40,180,96,198,6 }, { 107,16,112,40,7 }, { 102,48,98,209,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 990)
		{ { 225,154,144,165,2 }, { 72,144,58,214,10 }, { 74,80,149,152,7 }, { 86,181,192,145,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 991)
		{ { 231,242,192,250,9 }, { 229,164,187,203,3 }, { 149,240,52,254,7 }, { 205,61,210,90,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 992)
		{ { 238,173,190,131,8 }, { 131,195,53,183,15 }, { 28,23,219,87,7 }, { 254,218,204,60,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 993)
		{ { 240,28,242,124,1 }, { 108,232,162,186,12 }, { 131,228,243,128,15 }, { 53,212,81,115,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 994)
		{ { 247,101,168,38,4 }, { 137,142,102,227,5 }, { 38,65,90,110,15 }, { 172,118,103,25,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 995)
		{ { 247,236,195,164,13 }, { 189,204,115,227,10 }, { 178,92,51,126,15 }, { 92,124,227,59,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 996)
		{ { 248,45,84,113,4 }, { 35,11,226,190,8 }, { 40,226,171,65,15 }, { 23,212,125,12,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 997)
		{ { 254,133,143,205,11 }, { 158,251,53,175,2 }, { 219,63,26,23,15 }, { 79,90,205,247,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 998)
		{ { 248,227,91,11,6 }, { 51,126,124,150,1 }, { 109,13,172,113,15 }, { 134,147,231,236,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 999)
		{ { 254,214,62,31,15 }, { 206,125,253,183,5 }, { 255,135,198,183,15 }, { 174,219,251,231,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1000)
	#error invalid ARUCO_DB_SIZE, max database size for this aruco type is 1000
	#endif

};

#elif (ARUCO_DB == ARUCO_DB_7X7_1000)

#ifndef ARUCO_DB_SIZE
#define ARUCO_DB_SIZE 1000
#endif

#define ARUCO_BITS	7

static unsigned char database[ARUCO_DB_SIZE][4][7] = {
	#if (ARUCO_DB_SIZE > 0)
		{ { 221,92,108,165,202,10,1 }, { 99,179,173,228,49,180,0 }, { 168,41,210,155,29,93,1 }, { 22,198,19,218,230,227,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1)
		{ { 228,27,241,62,64,171,0 }, { 17,253,137,11,181,42,1 }, { 106,129,62,71,236,19,1 }, { 170,86,232,72,223,196,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2)
		{ { 158,170,43,172,93,39,1 }, { 163,182,158,145,75,171,1 }, { 242,93,26,234,42,188,1 }, { 234,233,68,188,182,226,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 3)
		{ { 166,103,5,183,233,76,0 }, { 221,48,50,221,165,172,0 }, { 25,75,246,208,115,50,1 }, { 26,210,221,166,6,93,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 4)
		{ { 198,188,123,19,50,86,0 }, { 253,193,139,113,154,97,0 }, { 53,38,100,111,30,177,1 }, { 67,44,199,104,193,223,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 5)
		{ { 88,128,20,35,89,238,0 }, { 4,122,28,80,184,133,1 }, { 59,205,98,20,0,141,0 }, { 208,142,133,28,47,16,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 6)
		{ { 211,107,190,111,84,72,0 }, { 164,240,198,70,247,63,0 }, { 9,21,123,62,235,101,1 }, { 126,119,177,49,135,146,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 7)
		{ { 60,161,109,136,139,219,0 }, { 37,14,191,169,44,198,0 }, { 109,232,136,219,66,158,0 }, { 49,154,74,254,184,82,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 8)
		{ { 137,7,31,86,150,158,0 }, { 112,74,104,49,231,125,0 }, { 60,180,181,124,112,72,1 }, { 95,115,198,11,41,7,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 9)
		{ { 187,101,177,141,110,63,0 }, { 200,86,142,255,101,242,1 }, { 126,59,88,198,211,110,1 }, { 167,211,127,184,181,9,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 10)
		{ { 245,0,209,130,244,144,1 }, { 11,88,37,139,208,113,0 }, { 132,151,160,197,128,87,1 }, { 71,5,232,210,13,104,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 11)
		{ { 2,38,112,184,84,26,0 }, { 208,112,139,128,96,75,0 }, { 44,21,14,135,50,32,0 }, { 105,3,0,232,135,5,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 12)
		{ { 84,243,107,151,72,240,1 }, { 55,25,135,197,159,200,1 }, { 135,137,116,235,103,149,0 }, { 137,252,209,240,204,118,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 13)
		{ { 158,36,136,70,35,153,1 }, { 235,14,86,34,161,96,0 }, { 204,226,49,8,146,60,1 }, { 3,66,162,53,56,107,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 14)
		{ { 189,255,50,107,201,203,1 }, { 71,255,254,76,174,186,0 }, { 233,201,235,38,127,222,1 }, { 46,186,153,63,255,241,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 15)
		{ { 206,17,5,176,90,151,1 }, { 147,63,8,177,20,229,0 }, { 244,173,6,208,68,57,1 }, { 83,148,70,136,126,100,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 16)
		{ { 211,240,97,114,31,139,0 }, { 144,45,223,37,248,177,0 }, { 104,252,39,67,7,229,1 }, { 70,143,210,125,218,4,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 17)
		{ { 1,225,158,206,200,237,1 }, { 38,92,98,150,175,150,1 }, { 219,137,185,188,195,192,0 }, { 180,250,180,163,29,50,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 18)
		{ { 38,203,204,42,112,120,1 }, { 175,176,1,14,172,79,1 }, { 143,7,42,25,233,178,0 }, { 249,26,184,64,6,250,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 19)
		{ { 56,125,77,118,65,19,0 }, { 112,183,95,13,133,68,0 }, { 100,65,55,89,95,14,0 }, { 17,80,216,125,118,135,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 20)
		{ { 58,144,74,233,225,233,1 }, { 174,63,117,200,42,2,1 }, { 203,195,203,169,4,174,0 }, { 160,42,9,215,126,58,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 21)
		{ { 70,212,132,123,60,221,0 }, { 221,45,64,86,248,199,0 }, { 93,158,111,16,149,177,0 }, { 113,143,181,1,90,93,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 22)
		{ { 72,146,167,222,158,43,1 }, { 18,7,232,163,251,143,1 }, { 234,60,189,242,164,137,0 }, { 248,239,226,139,240,36,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 23)
		{ { 94,118,195,228,152,168,0 }, { 193,43,103,135,51,137,1 }, { 10,140,147,225,183,61,0 }, { 200,230,112,243,106,65,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 24)
		{ { 116,162,222,250,47,136,1 }, { 59,104,87,170,250,142,0 }, { 136,250,47,189,162,151,0 }, { 56,175,170,245,11,110,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 25)
		{ { 148,93,226,40,19,89,0 }, { 69,165,149,38,38,99,0 }, { 77,100,10,35,221,20,1 }, { 99,50,50,84,210,209,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 26)
		{ { 155,18,149,100,237,163,1 }, { 138,127,124,3,65,188,1 }, { 226,219,147,84,164,108,1 }, { 158,193,96,31,127,40,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 27)
		{ { 161,212,148,45,130,248,0 }, { 68,105,32,110,41,118,1 }, { 15,160,218,20,149,194,1 }, { 183,74,59,2,75,17,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 28)
		{ { 187,120,230,49,108,208,1 }, { 158,187,135,78,66,244,0 }, { 133,155,70,51,143,110,1 }, { 23,161,57,112,238,188,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 29)
		{ { 203,181,221,203,219,24,0 }, { 224,83,115,227,188,247,0 }, { 12,109,233,221,214,233,1 }, { 119,158,227,231,101,3,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 30)
		{ { 211,229,238,183,131,51,0 }, { 240,36,191,230,159,116,1 }, { 102,96,246,187,211,229,1 }, { 151,124,179,254,146,7,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 31)
		{ { 242,148,35,63,209,156,1 }, { 210,57,180,89,187,99,0 }, { 156,197,254,98,20,167,1 }, { 99,110,205,22,206,37,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 32)
		{ { 253,214,209,159,59,230,1 }, { 95,75,29,255,153,187,1 }, { 179,238,124,197,181,223,1 }, { 238,204,255,220,105,125,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 33)
		{ { 58,70,36,238,132,238,1 }, { 198,42,236,156,225,14,1 }, { 187,144,187,146,49,46,0 }, { 184,67,156,155,170,49,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 34)
		{ { 98,24,126,36,59,15,0 }, { 168,229,153,56,51,133,0 }, { 120,110,18,63,12,35,0 }, { 80,230,14,76,211,138,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 35)
		{ { 10,205,67,111,157,195,0 }, { 196,174,121,69,207,131,0 }, { 97,220,251,97,89,168,0 }, { 96,249,209,79,58,145,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 36)
		{ { 14,64,212,195,142,2,0 }, { 129,66,105,230,192,132,0 }, { 32,56,225,149,129,56,0 }, { 16,129,179,203,33,64,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 37)
		{ { 20,159,217,160,98,36,0 }, { 105,241,5,179,12,8,1 }, { 18,35,2,205,252,148,0 }, { 136,24,102,208,71,203,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 38)
		{ { 25,162,225,26,101,237,0 }, { 28,30,151,19,232,26,1 }, { 91,211,44,67,162,204,0 }, { 172,11,228,116,188,28,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 39)
		{ { 43,80,130,126,27,52,0 }, { 144,35,80,62,131,211,1 }, { 22,108,63,32,133,106,0 }, { 229,224,190,5,98,4,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 40)
		{ { 41,105,56,146,159,163,0 }, { 48,206,186,172,196,145,1 }, { 98,252,164,142,75,74,0 }, { 196,145,154,174,185,134,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 41)
		{ { 44,247,84,219,244,86,1 }, { 95,83,107,220,204,79,0 }, { 181,23,237,149,119,154,0 }, { 121,25,157,235,101,125,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 42)
		{ { 53,233,63,158,54,124,0 }, { 61,192,134,189,239,87,1 }, { 31,54,60,254,75,214,0 }, { 245,123,222,176,129,222,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 43)
		{ { 63,116,171,216,61,243,1 }, { 255,15,222,143,66,211,1 }, { 231,222,13,234,151,126,0 }, { 229,161,120,189,248,127,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 44)
		{ { 68,208,41,244,255,64,0 }, { 61,49,240,165,89,129,0 }, { 1,127,151,202,5,145,0 }, { 64,205,82,135,198,94,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 45)
		{ { 72,64,228,132,42,245,0 }, { 12,14,129,182,17,196,1 }, { 87,170,16,147,129,9,0 }, { 145,196,54,192,184,24,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 46)
		{ { 95,25,19,104,52,2,0 }, { 137,227,76,1,86,19,0 }, { 32,22,11,100,76,125,0 }, { 100,53,64,25,99,200,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 47)
		{ { 94,178,114,64,61,93,1 }, { 143,71,215,16,122,201,0 }, { 221,94,1,39,38,189,0 }, { 73,175,4,117,241,120,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 48)
		{ { 111,155,36,31,21,194,0 }, { 149,139,152,72,221,31,0 }, { 33,212,124,18,108,251,0 }, { 124,93,137,12,232,212,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 49)
		{ { 114,170,249,32,168,227,1 }, { 174,236,175,11,24,136,1 }, { 227,138,130,79,170,167,0 }, { 136,140,104,122,155,186,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 50)
		{ { 121,136,117,59,134,54,1 }, { 18,226,173,121,216,86,1 }, { 182,48,238,87,8,207,0 }, { 181,13,207,90,163,164,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 51)
		{ { 123,231,19,174,121,81,1 }, { 206,118,22,141,159,219,0 }, { 197,79,58,228,115,239,0 }, { 109,252,216,180,55,57,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 52)
		{ { 133,106,70,201,89,224,0 }, { 5,152,83,196,2,191,1 }, { 3,205,73,177,43,80,1 }, { 254,160,17,229,12,208,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 53)
		{ { 142,63,238,242,217,81,1 }, { 247,183,243,130,134,237,0 }, { 197,77,167,187,254,56,1 }, { 91,176,160,231,246,247,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 54)
		{ { 173,56,205,33,115,103,1 }, { 47,183,27,123,0,53,1 }, { 243,103,66,89,142,90,1 }, { 214,0,111,108,118,250,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 55)
		{ { 177,55,37,48,185,63,1 }, { 90,37,190,25,36,253,1 }, { 254,78,134,82,118,70,1 }, { 223,146,76,62,210,45,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 56)
		{ { 186,195,128,210,81,219,0 }, { 148,30,92,142,172,105,0 }, { 109,197,37,128,225,174,1 }, { 75,26,184,157,60,20,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 57)
		{ { 193,117,109,93,24,166,1 }, { 114,9,203,85,21,183,1 }, { 178,140,93,91,87,65,1 }, { 246,212,85,105,200,39,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 58)
		{ { 206,97,211,126,229,17,0 }, { 153,118,115,7,215,98,0 }, { 68,83,191,101,195,57,1 }, { 35,117,240,103,55,76,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 59)
		{ { 210,92,152,54,221,91,1 }, { 246,245,60,6,241,225,0 }, { 237,93,182,12,157,37,1 }, { 67,199,176,30,87,183,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 60)
		{ { 208,106,145,233,239,206,1 }, { 14,248,126,247,112,170,0 }, { 185,251,203,196,171,5,1 }, { 42,135,119,191,15,184,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 61)
		{ { 73,228,227,141,169,90,1 }, { 78,2,187,199,59,210,0 }, { 173,74,216,227,147,201,0 }, { 37,238,113,238,160,57,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 62)
		{ { 82,209,159,40,31,179,0 }, { 160,109,28,39,94,199,1 }, { 102,252,10,124,197,165,0 }, { 241,189,114,28,91,2,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 63)
		{ { 2,24,175,24,115,160,1 }, { 186,153,144,35,2,7,1 }, { 130,231,12,122,140,32,0 }, { 240,32,98,4,204,174,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 64)
		{ { 5,192,75,56,81,119,0 }, { 53,52,25,21,10,83,1 }, { 119,69,14,105,1,208,0 }, { 229,40,84,76,22,86,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 65)
		{ { 15,88,169,33,137,159,0 }, { 161,175,184,87,32,208,0 }, { 124,200,194,74,141,120,0 }, { 5,130,117,14,250,194,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 66)
		{ { 15,206,165,68,68,26,0 }, { 193,146,200,7,105,92,0 }, { 44,17,17,82,185,248,0 }, { 29,75,112,9,164,193,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 67)
		{ { 21,238,211,115,20,216,1 }, { 87,232,71,71,234,89,0 }, { 141,148,103,101,187,212,0 }, { 77,43,241,113,11,245,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 68)
		{ { 22,241,226,252,69,158,1 }, { 147,57,223,150,111,66,0 }, { 188,209,31,163,199,180,0 }, { 33,123,52,253,206,100,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 69)
		{ { 30,94,76,65,59,115,0 }, { 237,135,93,100,0,205,1 }, { 103,110,65,25,61,60,0 }, { 217,128,19,93,112,219,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 70)
		{ { 31,194,82,102,200,118,1 }, { 135,114,109,20,139,216,1 }, { 183,9,179,37,33,252,0 }, { 141,232,148,91,39,112,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 71)
		{ { 39,33,22,246,49,159,1 }, { 155,108,90,152,167,85,0 }, { 252,198,55,180,66,114,0 }, { 85,114,140,173,27,108,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 72)
		{ { 39,155,122,137,27,220,0 }, { 165,201,145,248,46,219,0 }, { 29,236,72,175,108,242,0 }, { 109,186,15,196,201,210,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 73)
		{ { 46,12,48,75,106,108,0 }, { 205,210,192,120,160,130,1 }, { 27,43,105,6,24,58,0 }, { 160,130,143,1,165,217,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 74)
		{ { 47,169,226,121,230,43,0 }, { 153,182,235,106,110,18,1 }, { 106,51,207,35,202,250,0 }, { 164,59,43,107,182,204,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 75)
		{ { 44,207,211,2,147,19,1 }, { 67,198,57,47,142,73,0 }, { 228,100,160,101,249,154,0 }, { 73,56,250,78,49,225,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 76)
		{ { 49,83,3,2,18,230,1 }, { 6,9,12,61,134,25,1 }, { 179,164,32,96,101,70,0 }, { 204,48,222,24,72,48,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 77)
		{ { 48,120,115,90,253,41,1 }, { 26,213,247,13,226,131,1 }, { 202,95,173,103,15,6,0 }, { 224,163,216,119,213,172,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 78)
		{ { 55,226,67,44,167,160,1 }, { 139,40,55,45,75,26,1 }, { 130,242,154,97,35,246,0 }, { 172,105,90,118,10,104,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 79)
		{ { 76,11,79,138,255,84,0 }, { 45,146,49,177,214,207,0 }, { 21,127,168,249,104,25,0 }, { 121,181,198,198,36,218,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 80)
		{ { 78,218,184,202,73,33,1 }, { 163,215,208,134,152,138,1 }, { 194,73,41,142,173,185,0 }, { 168,140,176,133,245,226,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 81)
		{ { 76,218,221,21,152,110,0 }, { 53,195,41,87,57,141,1 }, { 59,12,212,93,173,153,0 }, { 216,206,117,74,97,214,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 82)
		{ { 86,123,85,187,37,96,1 }, { 159,225,23,197,212,14,1 }, { 131,82,110,213,111,53,0 }, { 184,21,209,244,67,252,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 83)
		{ { 84,151,117,241,41,203,0 }, { 93,109,221,193,60,140,0 }, { 105,202,71,215,116,149,0 }, { 24,158,65,221,219,93,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 84)
		{ { 84,152,140,205,4,162,0 }, { 33,137,76,194,89,6,1 }, { 34,144,89,152,140,149,0 }, { 176,77,33,153,72,194,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 85)
		{ { 94,110,164,168,119,169,0 }, { 201,190,150,166,112,15,1 }, { 74,247,10,146,187,61,0 }, { 248,7,50,180,190,201,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 86)
		{ { 99,4,81,119,99,178,0 }, { 216,120,89,105,145,80,1 }, { 38,227,119,69,16,99,0 }, { 133,68,203,77,15,13,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 87)
		{ { 105,226,58,120,116,228,1 }, { 62,122,194,28,90,27,1 }, { 147,151,15,46,35,203,0 }, { 236,45,28,33,175,62,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 88)
		{ { 109,23,226,74,80,28,1 }, { 67,19,193,26,182,91,0 }, { 156,5,41,35,244,91,0 }, { 109,54,172,65,228,97,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 89)
		{ { 112,62,128,226,203,177,0 }, { 64,189,118,170,144,200,1 }, { 70,233,163,128,190,7,0 }, { 137,132,170,183,94,129,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 90)
		{ { 119,80,90,139,20,43,1 }, { 163,69,13,204,242,19,1 }, { 234,20,104,173,5,119,0 }, { 228,39,153,216,81,98,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 91)
		{ { 130,100,225,43,36,151,1 }, { 202,44,139,87,192,98,0 }, { 244,146,106,67,147,32,1 }, { 35,1,245,104,154,41,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 92)
		{ { 131,253,167,209,241,197,0 }, { 220,157,242,215,14,53,0 }, { 81,199,197,242,223,224,1 }, { 86,56,117,167,220,157,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 93)
		{ { 147,189,107,77,96,125,1 }, { 238,149,199,81,47,114,1 }, { 223,3,89,107,94,228,1 }, { 167,122,69,113,212,187,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 94)
		{ { 148,216,165,194,122,237,1 }, { 15,157,196,183,168,165,1 }, { 219,175,33,210,141,148,1 }, { 210,138,246,145,220,248,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 95)
		{ { 148,247,189,26,15,79,1 }, { 119,69,158,55,236,174,0 }, { 249,120,44,94,247,148,1 }, { 58,155,246,60,209,119,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 96)
		{ { 152,241,170,62,148,248,0 }, { 52,43,166,6,239,99,1 }, { 15,148,190,42,199,140,1 }, { 227,123,176,50,234,22,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 97)
		{ { 169,138,223,140,87,40,0 }, { 32,210,17,171,107,63,1 }, { 10,117,24,253,168,202,1 }, { 254,107,106,196,37,130,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 98)
		{ { 177,14,54,223,65,63,0 }, { 80,212,220,216,163,126,1 }, { 126,65,125,182,56,70,1 }, { 191,98,141,157,149,133,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 99)
		{ { 185,234,28,100,226,107,0 }, { 44,246,110,44,41,60,1 }, { 107,35,147,28,43,206,1 }, { 158,74,26,59,55,154,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 100)
		{ { 188,38,74,240,242,183,1 }, { 123,62,111,184,2,105,1 }, { 246,167,135,169,50,30,1 }, { 203,32,14,251,62,111,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 101)
		{ { 189,63,146,218,126,170,0 }, { 89,219,78,170,230,187,1 }, { 42,191,45,164,254,94,1 }, { 238,179,170,185,109,205,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 102)
		{ { 192,53,46,74,202,87,0 }, { 100,21,234,48,150,230,0 }, { 117,41,169,58,86,1,1 }, { 51,180,134,43,212,19,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 103)
		{ { 194,54,220,36,22,128,1 }, { 226,105,3,34,81,45,0 }, { 128,180,18,29,182,33,1 }, { 90,69,34,96,75,35,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 104)
		{ { 211,79,245,172,136,118,1 }, { 198,224,173,151,21,254,1 }, { 183,8,154,215,249,101,1 }, { 191,212,116,218,131,177,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 105)
		{ { 215,6,210,240,31,150,0 }, { 209,104,93,178,82,249,0 }, { 52,252,7,165,176,117,1 }, { 79,165,38,221,11,69,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 106)
		{ { 216,50,245,201,86,5,0 }, { 0,87,199,243,80,47,0 }, { 80,53,73,215,166,13,1 }, { 122,5,103,241,245,0,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 107)
		{ { 216,217,65,4,131,170,0 }, { 0,139,61,37,61,32,1 }, { 42,224,144,65,77,141,1 }, { 130,94,82,94,104,128,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 108)
		{ { 224,211,100,108,77,209,1 }, { 6,61,209,12,93,238,0 }, { 197,217,27,19,101,131,1 }, { 59,221,24,69,222,48,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 109)
		{ { 225,232,37,60,152,205,0 }, { 20,172,162,29,57,183,0 }, { 89,140,158,82,11,195,1 }, { 118,206,92,34,154,148,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 110)
		{ { 229,118,79,139,232,157,1 }, { 107,29,35,221,178,254,0 }, { 220,139,232,249,55,83,1 }, { 63,166,221,226,92,107,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 111)
		{ { 232,80,250,159,250,74,0 }, { 60,83,169,238,179,163,0 }, { 41,47,252,175,133,11,1 }, { 98,230,187,202,229,30,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 112)
		{ { 235,128,234,240,130,92,1 }, { 182,34,225,186,58,112,0 }, { 157,32,135,171,128,235,1 }, { 7,46,46,195,162,54,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 113)
		{ { 239,108,113,174,69,200,1 }, { 199,250,147,141,241,50,0 }, { 137,209,58,199,27,123,1 }, { 38,71,216,228,175,241,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 114)
		{ { 247,217,64,237,177,12,0 }, { 137,161,117,220,61,51,0 }, { 24,70,219,129,77,247,1 }, { 102,94,29,215,66,200,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 115)
		{ { 254,214,40,241,92,60,1 }, { 243,51,196,220,120,233,1 }, { 158,29,71,138,53,191,1 }, { 203,143,29,145,230,103,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 116)
		{ { 20,199,225,220,124,3,1 }, { 91,20,205,135,77,139,0 }, { 224,31,29,195,241,148,0 }, { 104,217,112,217,148,109,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 117)
		{ { 34,236,79,160,255,225,0 }, { 236,188,51,173,74,133,1 }, { 67,255,130,249,27,162,0 }, { 208,169,90,230,30,155,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 118)
		{ { 164,134,72,34,231,234,0 }, { 109,56,57,40,232,40,1 }, { 43,243,162,9,48,146,1 }, { 138,11,138,78,14,91,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 119)
		{ { 179,172,156,128,134,12,1 }, { 226,192,38,186,104,52,0 }, { 152,48,128,156,154,230,1 }, { 22,11,46,178,1,163,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 120)
		{ { 235,197,247,106,12,68,0 }, { 196,98,193,31,222,182,0 }, { 17,24,43,119,209,235,1 }, { 54,189,252,65,163,17,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 121)
		{ { 0,36,28,209,199,244,0 }, { 116,88,114,240,64,68,1 }, { 23,241,197,156,18,0,0 }, { 145,1,7,167,13,23,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 122)
		{ { 0,65,85,60,228,236,0 }, { 28,120,33,21,101,6,1 }, { 27,147,158,85,65,0,0 }, { 176,83,84,66,15,28,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 123)
		{ { 2,119,133,135,91,48,1 }, { 194,17,18,231,133,205,1 }, { 134,109,112,208,247,32,0 }, { 217,208,243,164,68,33,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 124)
		{ { 1,218,232,155,2,227,0 }, { 52,141,137,230,136,26,1 }, { 99,160,108,139,173,192,0 }, { 172,8,179,200,216,150,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 125)
		{ { 4,40,5,26,111,159,0 }, { 25,156,26,49,224,198,0 }, { 124,251,44,80,10,16,0 }, { 49,131,198,44,28,204,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 126)
		{ { 7,145,0,75,83,171,0 }, { 129,29,88,96,172,19,1 }, { 106,229,105,0,68,240,0 }, { 228,26,131,13,92,64,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 127)
		{ { 10,89,153,210,227,215,1 }, { 190,223,120,183,132,64,0 }, { 245,227,165,204,205,40,0 }, { 1,16,246,143,125,190,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 128)
		{ { 9,178,243,249,248,177,1 }, { 26,127,227,195,10,219,1 }, { 198,143,207,231,166,200,0 }, { 237,168,97,227,255,44,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 129)
		{ { 13,49,205,127,92,218,1 }, { 55,59,75,67,229,215,0 }, { 173,157,127,89,198,88,0 }, { 117,211,225,105,110,118,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 130)
		{ { 14,110,159,79,116,37,1 }, { 235,214,66,87,195,15,1 }, { 210,23,121,124,187,56,0 }, { 248,97,245,33,53,235,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 131)
		{ { 23,114,128,242,245,110,0 }, { 157,49,126,150,224,25,1 }, { 59,87,167,128,167,116,0 }, { 204,3,180,191,70,92,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 132)
		{ { 22,255,97,63,186,238,0 }, { 221,169,175,117,173,139,1 }, { 59,174,254,67,127,180,0 }, { 232,218,215,122,202,221,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 133)
		{ { 25,50,221,83,147,173,1 }, { 50,79,119,115,160,29,1 }, { 218,228,229,93,166,76,0 }, { 220,2,231,119,121,38,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 134)
		{ { 30,55,90,161,138,28,1 }, { 227,99,39,240,38,200,0 }, { 156,40,194,173,118,60,0 }, { 9,178,7,242,99,99,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 135)
		{ { 30,243,155,67,46,40,0 }, { 169,67,70,103,238,136,1 }, { 10,58,97,108,231,188,0 }, { 136,187,243,49,97,74,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 136)
		{ { 35,152,218,66,102,77,0 }, { 172,213,65,58,234,16,0 }, { 89,51,33,45,140,226,0 }, { 4,43,174,65,85,154,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 137)
		{ { 35,183,98,39,73,166,1 }, { 194,57,155,88,143,152,1 }, { 178,201,114,35,118,226,0 }, { 140,248,141,108,206,33,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 138)
		{ { 39,232,89,247,30,7,0 }, { 177,228,75,253,201,145,0 }, { 112,60,119,205,11,242,0 }, { 68,201,223,233,19,198,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 139)
		{ { 41,207,36,233,56,245,0 }, { 76,174,192,220,12,223,1 }, { 87,142,75,146,121,202,0 }, { 253,152,29,129,186,153,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 140)
		{ { 43,202,225,232,241,71,1 }, { 142,182,249,159,8,27,0 }, { 241,71,139,195,169,234,0 }, { 108,8,124,207,182,184,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 141)
		{ { 46,52,167,60,136,145,0 }, { 209,47,162,11,3,198,0 }, { 68,136,158,114,150,58,0 }, { 49,224,104,34,250,69,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 142)
		{ { 44,130,54,130,20,241,1 }, { 7,78,128,136,202,77,1 }, { 199,148,32,182,32,154,0 }, { 217,41,136,128,185,112,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 143)
		{ { 52,119,39,34,124,128,0 }, { 73,57,134,13,198,141,0 }, { 0,159,34,114,119,22,0 }, { 88,177,216,48,206,73,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 144)
		{ { 62,106,78,239,207,36,0 }, { 161,178,119,252,195,142,1 }, { 18,121,251,185,43,62,0 }, { 184,225,159,247,38,194,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 145)
		{ { 61,189,0,186,135,236,0 }, { 85,171,54,184,236,18,1 }, { 27,240,174,128,94,222,0 }, { 164,27,142,182,106,213,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 146)
		{ { 65,89,70,17,248,154,0 }, { 24,153,41,68,54,213,0 }, { 44,143,196,49,77,65,0 }, { 85,182,17,74,76,140,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 147)
		{ { 66,160,192,80,251,19,1 }, { 154,20,123,34,24,193,0 }, { 228,111,133,1,130,161,0 }, { 65,140,34,111,20,44,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 148)
		{ { 66,215,59,80,17,218,1 }, { 246,73,216,5,62,73,0 }, { 173,196,5,110,117,161,0 }, { 73,62,80,13,201,55,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 149)
		{ { 71,21,159,236,40,89,1 }, { 239,101,64,131,55,214,0 }, { 205,10,27,252,212,113,0 }, { 53,246,96,129,83,123,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 150)
		{ { 72,72,74,156,121,141,1 }, { 58,158,17,148,51,131,0 }, { 216,207,28,169,9,9,0 }, { 96,230,20,196,60,174,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 151)
		{ { 75,141,239,56,120,19,0 }, { 248,182,137,3,30,215,0 }, { 100,15,14,123,216,233,0 }, { 117,188,96,72,182,143,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 152)
		{ { 72,197,79,119,42,255,1 }, { 126,46,73,117,191,196,1 }, { 255,170,119,121,81,137,0 }, { 145,254,215,73,58,63,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 153)
		{ { 73,205,149,222,250,38,0 }, { 88,210,104,183,157,151,1 }, { 50,47,189,212,217,201,0 }, { 244,220,246,139,37,141,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 154)
		{ { 74,248,19,154,40,250,0 }, { 156,203,10,133,186,194,1 }, { 47,138,44,228,15,169,0 }, { 161,174,208,168,105,156,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 155)
		{ { 76,39,45,47,65,165,0 }, { 97,62,146,81,149,14,1 }, { 82,193,122,90,114,25,0 }, { 184,84,197,36,190,67,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 156)
		{ { 76,63,202,163,60,106,1 }, { 111,163,11,194,246,137,1 }, { 171,30,98,169,254,25,0 }, { 200,183,161,232,98,251,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 157)
		{ { 76,105,150,233,240,91,0 }, { 13,246,106,198,54,71,0 }, { 109,7,203,180,203,25,0 }, { 113,54,49,171,55,216,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 158)
		{ { 83,59,100,210,198,162,0 }, { 144,153,239,160,212,28,1 }, { 34,177,165,147,110,101,0 }, { 156,21,130,251,204,132,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 159)
		{ { 81,70,77,104,180,53,1 }, { 106,36,101,21,80,95,1 }, { 214,22,139,89,49,69,0 }, { 253,5,84,83,18,43,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 160)
		{ { 81,86,86,98,113,201,1 }, { 78,125,85,4,178,29,0 }, { 201,199,35,53,53,69,0 }, { 92,38,144,85,95,57,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 161)
		{ { 80,115,53,140,113,223,1 }, { 14,93,158,149,53,79,0 }, { 253,199,24,214,103,5,0 }, { 121,86,84,188,221,56,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 162)
		{ { 84,74,231,46,2,158,1 }, { 3,168,141,55,179,78,0 }, { 188,160,58,115,169,21,0 }, { 57,102,246,88,138,224,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 163)
		{ { 84,219,22,238,94,71,0 }, { 5,245,76,180,223,143,0 }, { 113,61,59,180,109,149,0 }, { 120,253,150,153,87,208,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 164)
		{ { 86,240,240,30,140,100,1 }, { 151,65,167,22,217,130,1 }, { 147,24,188,7,135,181,0 }, { 160,205,180,114,193,116,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 165)
		{ { 91,106,3,196,23,123,1 }, { 134,134,94,165,115,89,1 }, { 239,116,17,224,43,109,0 }, { 205,103,82,189,48,176,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 166)
		{ { 91,249,239,82,25,108,1 }, { 182,131,215,23,190,149,1 }, { 155,76,37,123,207,237,0 }, { 212,190,244,117,224,182,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 167)
		{ { 92,116,249,2,251,190,0 }, { 105,91,191,55,176,193,1 }, { 62,239,160,79,151,29,0 }, { 193,134,246,126,237,75,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 168)
		{ { 94,157,11,47,79,122,1 }, { 231,179,28,97,255,194,1 }, { 175,121,122,104,92,189,0 }, { 161,255,195,28,102,243,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 169)
		{ { 99,67,213,185,201,130,0 }, { 144,120,57,207,20,158,0 }, { 32,201,206,213,225,99,0 }, { 60,148,121,206,15,4,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 170)
		{ { 96,93,164,245,22,155,1 }, { 82,173,200,238,117,69,0 }, { 236,180,87,146,221,3,0 }, { 81,87,59,137,218,165,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 171)
		{ { 100,136,47,135,72,47,0 }, { 33,148,136,217,187,132,1 }, { 122,9,112,250,8,147,0 }, { 144,238,205,136,148,194,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 172)
		{ { 104,106,145,148,102,64,0 }, { 28,210,2,175,81,8,0 }, { 1,51,20,196,171,11,0 }, { 8,69,122,160,37,156,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 173)
		{ { 108,55,209,238,204,101,1 }, { 71,119,99,155,213,138,1 }, { 211,25,187,197,246,27,0 }, { 168,213,236,227,119,113,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 174)
		{ { 109,89,245,135,43,42,0 }, { 9,195,153,239,181,148,1 }, { 42,106,112,215,205,91,0 }, { 148,214,251,204,225,200,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 175)
		{ { 115,31,7,158,40,12,0 }, { 216,129,4,153,183,158,0 }, { 24,10,60,240,124,103,0 }, { 60,246,204,144,64,141,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 176)
		{ { 114,38,22,146,200,199,1 }, { 214,92,46,152,146,140,0 }, { 241,137,164,180,50,39,0 }, { 24,164,140,186,29,53,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 177)
		{ { 115,131,239,207,199,93,1 }, { 166,20,245,251,255,94,0 }, { 221,113,249,251,224,231,0 }, { 61,127,239,215,148,50,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 178)
		{ { 113,246,244,181,170,13,0 }, { 88,101,167,254,57,156,0 }, { 88,42,214,151,183,199,0 }, { 28,206,63,242,211,13,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 179)
		{ { 118,16,2,241,170,59,0 }, { 153,37,108,232,50,192,1 }, { 110,42,199,160,4,55,0 }, { 129,166,11,155,82,76,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 180)
		{ { 118,84,255,84,38,33,0 }, { 249,69,197,47,83,4,1 }, { 66,50,21,127,149,55,0 }, { 144,101,122,81,209,79,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 181)
		{ { 122,227,200,30,38,54,0 }, { 184,2,15,62,221,74,1 }, { 54,50,60,9,227,175,0 }, { 169,93,190,120,32,14,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 182)
		{ { 126,32,91,27,109,102,0 }, { 189,82,31,89,210,130,1 }, { 51,91,108,109,2,63,0 }, { 160,165,205,124,37,94,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 183)
		{ { 124,113,102,127,179,75,1 }, { 31,39,255,108,183,7,0 }, { 233,102,255,51,71,31,0 }, { 112,118,155,127,242,124,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 184)
		{ { 126,136,249,129,71,26,0 }, { 161,210,157,235,120,64,0 }, { 44,113,64,207,136,191,0 }, { 1,15,107,220,165,194,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 185)
		{ { 127,189,182,243,152,70,0 }, { 213,227,238,218,158,149,0 }, { 49,12,231,182,222,255,0 }, { 84,188,173,187,227,213,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 186)
		{ { 131,186,63,66,156,103,0 }, { 164,197,234,17,202,189,1 }, { 115,28,161,126,46,224,1 }, { 222,169,196,43,209,146,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 187)
		{ { 131,179,163,188,159,85,1 }, { 150,37,178,179,79,251,0 }, { 213,124,158,226,230,224,1 }, { 111,249,102,166,210,52,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 188)
		{ { 134,184,56,238,195,91,1 }, { 167,245,250,160,169,98,0 }, { 237,97,187,142,14,176,1 }, { 35,74,130,175,215,242,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 189)
		{ { 138,251,116,46,23,43,0 }, { 128,231,155,36,237,47,1 }, { 106,116,58,23,111,168,1 }, { 250,91,146,108,243,128,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 190)
		{ { 142,5,134,252,131,42,0 }, { 209,34,120,162,39,38,1 }, { 42,96,159,176,208,56,1 }, { 178,114,34,143,34,69,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 191)
		{ { 143,72,60,30,32,231,0 }, { 189,206,136,20,129,54,1 }, { 115,130,60,30,9,120,1 }, { 182,64,148,8,185,222,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 192)
		{ { 142,83,181,252,28,224,0 }, { 149,107,192,135,69,175,1 }, { 3,156,31,214,229,56,1 }, { 250,209,112,129,235,84,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 193)
		{ { 141,157,35,130,73,96,0 }, { 69,147,144,129,142,176,1 }, { 3,73,32,226,92,216,1 }, { 134,184,192,132,228,209,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 194)
		{ { 141,185,144,117,146,156,1 }, { 19,235,98,114,45,113,0 }, { 156,164,215,4,206,216,1 }, { 71,90,39,35,107,228,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 195)
		{ { 144,19,230,225,162,176,0 }, { 8,41,229,226,6,108,1 }, { 6,162,195,179,228,4,1 }, { 155,48,35,211,202,8,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 196)
		{ { 147,155,55,123,26,144,1 }, { 146,233,196,97,142,255,0 }, { 132,172,111,118,108,228,1 }, { 127,184,195,17,203,164,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 197)
		{ { 151,14,49,237,242,168,1 }, { 203,248,228,225,33,59,1 }, { 138,167,219,198,56,116,1 }, { 238,66,67,147,143,233,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 198)
		{ { 151,52,94,59,153,170,0 }, { 241,105,63,64,162,183,1 }, { 42,204,238,61,22,116,1 }, { 246,162,129,126,75,71,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 199)
		{ { 149,122,253,44,125,85,0 }, { 45,245,151,23,65,255,0 }, { 85,95,26,95,175,84,1 }, { 127,193,116,116,215,218,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 200)
		{ { 151,221,14,6,20,80,1 }, { 231,129,4,4,207,117,0 }, { 133,20,48,56,93,244,1 }, { 87,121,144,16,64,243,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 201)
		{ { 154,154,4,227,189,68,1 }, { 142,163,116,208,200,173,0 }, { 145,94,227,144,44,172,1 }, { 90,137,133,151,98,184,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 202)
		{ { 155,190,173,173,13,248,1 }, { 230,171,150,195,105,254,1 }, { 143,216,90,218,190,236,1 }, { 191,203,97,180,234,179,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 203)
		{ { 157,103,144,38,24,93,0 }, { 69,102,6,22,165,249,0 }, { 93,12,50,4,243,92,1 }, { 79,210,180,48,51,81,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 204)
		{ { 159,129,201,246,175,127,0 }, { 189,38,125,179,237,240,1 }, { 127,122,183,201,192,252,1 }, { 135,219,230,223,50,94,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 205)
		{ { 159,247,196,109,149,97,1 }, { 199,39,119,70,77,63,1 }, { 195,84,219,17,247,252,1 }, { 254,89,49,119,114,113,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 206)
		{ { 167,3,62,38,186,122,0 }, { 173,96,168,40,167,253,1 }, { 47,46,178,62,96,114,1 }, { 223,242,138,10,131,90,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 207)
		{ { 166,79,109,144,30,111,0 }, { 245,132,137,189,100,173,1 }, { 123,60,4,219,121,50,1 }, { 218,147,94,200,144,215,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 208)
		{ { 166,84,136,155,103,3,0 }, { 249,21,24,238,192,34,0 }, { 96,115,108,136,149,50,1 }, { 34,1,187,140,84,79,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 209)
		{ { 164,250,171,52,23,138,0 }, { 49,169,154,47,107,41,0 }, { 40,244,22,106,175,146,1 }, { 74,107,122,44,202,198,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 210)
		{ { 169,35,165,79,219,255,1 }, { 6,30,250,123,165,255,1 }, { 255,237,249,82,226,74,1 }, { 255,210,239,47,188,48,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 211)
		{ { 175,22,89,55,116,14,1 }, { 251,115,9,89,225,57,0 }, { 184,23,118,77,52,122,1 }, { 78,67,205,72,103,111,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 212)
		{ { 174,60,2,96,17,226,1 }, { 199,171,90,8,2,33,1 }, { 163,196,3,32,30,58,1 }, { 194,32,8,45,106,241,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 213)
		{ { 174,166,70,29,70,134,0 }, { 209,26,11,120,75,46,0 }, { 48,177,92,49,50,186,1 }, { 58,105,15,104,44,69,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 214)
		{ { 174,169,188,206,254,64,0 }, { 173,210,226,170,205,167,0 }, { 1,63,185,158,202,186,1 }, { 114,217,170,163,165,218,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 215)
		{ { 177,170,233,41,210,190,0 }, { 32,184,175,123,40,123,1 }, { 62,165,202,75,170,198,1 }, { 239,10,111,122,142,130,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 216)
		{ { 179,236,199,247,61,40,0 }, { 216,160,87,207,235,181,1 }, { 10,94,119,241,155,230,1 }, { 214,235,249,245,2,141,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 217)
		{ { 179,242,249,209,5,96,1 }, { 182,65,215,207,72,56,1 }, { 131,80,69,207,167,230,1 }, { 142,9,121,245,193,54,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 218)
		{ { 183,83,178,95,132,147,0 }, { 145,77,236,78,199,122,0 }, { 100,144,253,38,229,118,1 }, { 47,113,185,27,217,68,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 219)
		{ { 180,99,115,84,106,222,0 }, { 29,88,207,61,39,232,0 }, { 61,171,21,103,99,22,1 }, { 11,242,94,121,141,92,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 220)
		{ { 182,97,89,33,192,136,0 }, { 161,120,39,77,36,32,0 }, { 8,129,194,77,67,54,1 }, { 2,18,89,114,15,66,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 221)
		{ { 186,184,208,95,68,186,1 }, { 146,219,79,74,233,98,1 }, { 174,145,125,5,142,174,1 }, { 163,75,169,121,109,164,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 222)
		{ { 186,192,40,124,16,3,1 }, { 178,38,204,12,9,35,0 }, { 224,4,31,10,1,174,1 }, { 98,72,24,25,178,38,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 223)
		{ { 188,9,19,77,135,103,0 }, { 5,198,124,121,71,34,1 }, { 115,112,217,100,72,30,1 }, { 162,113,79,31,49,208,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 224)
		{ { 190,60,15,68,249,12,0 }, { 233,147,118,25,35,165,0 }, { 24,79,145,120,30,62,1 }, { 82,226,76,55,100,203,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 225)
		{ { 193,39,249,24,172,4,0 }, { 120,64,163,19,84,186,0 }, { 16,26,140,79,242,65,1 }, { 46,149,100,98,129,15,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 226)
		{ { 194,54,103,175,248,99,1 }, { 206,53,171,193,147,175,1 }, { 227,15,250,243,54,33,1 }, { 250,228,193,234,214,57,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 227)
		{ { 194,202,232,228,90,50,0 }, { 160,176,201,166,25,233,1 }, { 38,45,19,139,169,161,1 }, { 203,204,50,201,134,130,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 228)
		{ { 198,18,22,32,228,28,0 }, { 137,113,32,16,114,108,0 }, { 28,19,130,52,36,49,1 }, { 27,39,4,2,71,72,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 229)
		{ { 199,229,93,208,65,150,0 }, { 241,88,91,149,28,116,0 }, { 52,193,5,221,83,241,1 }, { 23,28,84,237,13,71,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 230)
		{ { 202,89,204,102,248,236,0 }, { 172,187,97,22,181,165,1 }, { 27,143,179,25,205,41,1 }, { 210,214,180,67,110,154,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 231)
		{ { 200,251,13,58,124,119,1 }, { 62,183,10,21,220,239,1 }, { 247,31,46,88,111,137,1 }, { 251,157,212,40,118,190,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 232)
		{ { 204,35,191,4,244,230,0 }, { 45,90,170,19,87,45,1 }, { 51,151,144,126,226,25,1 }, { 218,117,100,42,173,90,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 233)
		{ { 204,185,29,222,17,77,0 }, { 53,199,82,145,189,39,0 }, { 89,68,61,220,78,153,1 }, { 114,94,196,165,113,214,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 234)
		{ { 214,71,53,203,221,81,1 }, { 199,84,244,197,212,239,0 }, { 197,93,233,214,113,53,1 }, { 123,149,209,151,149,113,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 235)
		{ { 212,80,13,82,140,243,1 }, { 55,13,108,5,208,228,1 }, { 231,152,165,88,5,21,1 }, { 147,133,208,27,88,118,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 236)
		{ { 214,126,50,1,136,117,0 }, { 197,197,166,84,18,232,1 }, { 87,8,192,38,63,53,1 }, { 139,164,21,50,209,209,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 237)
		{ { 214,239,103,48,199,69,1 }, { 215,180,183,53,94,44,0 }, { 209,113,134,115,123,181,1 }, { 26,61,86,118,150,245,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 238)
		{ { 217,10,193,255,8,72,0 }, { 20,162,69,195,177,186,0 }, { 9,8,127,193,168,77,1 }, { 46,198,225,209,34,148,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 239)
		{ { 218,68,144,181,192,149,0 }, { 208,126,36,214,17,96,0 }, { 84,129,214,132,145,45,1 }, { 3,68,53,146,63,5,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 240)
		{ { 218,142,240,138,31,78,1 }, { 198,194,157,178,248,171,0 }, { 185,124,40,135,184,173,1 }, { 106,143,166,220,161,177,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 241)
		{ { 226,186,72,154,71,244,1 }, { 182,153,19,184,216,106,1 }, { 151,241,44,137,46,163,1 }, { 171,13,142,228,76,182,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 242)
		{ { 226,251,142,197,152,25,0 }, { 160,133,98,206,63,237,0 }, { 76,12,209,184,239,163,1 }, { 91,254,57,163,80,130,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 243)
		{ { 229,62,6,191,131,16,1 }, { 83,161,50,232,147,126,0 }, { 132,96,254,176,62,83,1 }, { 63,100,139,166,66,229,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 244)
		{ { 230,135,176,105,180,112,0 }, { 205,96,224,74,92,107,1 }, { 7,22,203,6,240,179,1 }, { 235,29,41,3,131,89,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 245)
		{ { 229,161,35,223,231,210,0 }, { 29,24,250,233,223,114,0 }, { 37,243,253,226,66,211,1 }, { 39,125,203,175,140,92,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 246)
		{ { 228,231,74,54,176,3,0 }, { 121,36,43,12,159,41,0 }, { 96,6,182,41,115,147,1 }, { 74,124,152,106,18,79,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 247)
		{ { 235,25,74,181,219,227,0 }, { 180,191,57,232,23,177,1 }, { 99,237,214,169,76,107,1 }, { 198,244,11,206,126,150,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 248)
		{ { 235,104,214,214,135,188,0 }, { 144,202,115,190,243,116,1 }, { 30,240,181,181,139,107,1 }, { 151,103,190,231,41,132,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 249)
		{ { 239,76,157,25,92,242,0 }, { 245,218,8,79,80,247,1 }, { 39,157,76,92,153,123,1 }, { 247,133,121,8,45,215,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 250)
		{ { 240,140,65,178,161,79,1 }, { 94,164,61,153,184,32,0 }, { 249,66,166,193,24,135,1 }, { 2,14,204,222,18,189,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 251)
		{ { 245,42,227,102,145,91,0 }, { 5,164,255,11,179,121,0 }, { 109,68,179,99,170,87,1 }, { 79,102,232,127,146,208,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 252)
		{ { 247,127,207,238,89,167,0 }, { 225,189,95,159,151,191,1 }, { 114,205,59,249,255,119,1 }, { 254,244,252,253,94,195,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 253)
		{ { 248,218,47,9,127,235,0 }, { 44,159,156,109,122,175,1 }, { 107,255,72,122,45,143,1 }, { 250,175,91,28,252,154,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 254)
		{ { 252,25,236,171,9,228,1 }, { 39,171,149,218,148,166,1 }, { 147,200,106,155,204,31,1 }, { 178,148,173,212,234,242,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 255)
		{ { 147,75,97,136,48,21,0 }, { 136,132,133,149,4,123,0 }, { 84,6,8,195,105,100,1 }, { 111,16,84,208,144,136,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 256)
		{ { 200,173,102,37,128,21,1 }, { 66,166,163,80,31,100,0 }, { 212,0,210,51,90,137,1 }, { 19,124,5,98,178,161,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 257)
		{ { 28,218,21,111,160,160,1 }, { 11,235,100,69,137,14,1 }, { 130,130,251,84,45,156,0 }, { 184,72,209,19,107,232,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 258)
		{ { 35,147,244,147,165,30,0 }, { 152,65,185,218,236,92,0 }, { 60,82,228,151,228,226,0 }, { 29,27,173,206,193,12,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 259)
		{ { 47,88,146,189,228,140,1 }, { 155,251,32,222,99,18,0 }, { 152,147,222,164,141,122,0 }, { 36,99,61,130,111,236,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 260)
		{ { 67,161,247,150,104,223,0 }, { 156,92,139,147,191,212,0 }, { 125,139,52,247,194,225,0 }, { 21,254,228,232,157,28,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 261)
		{ { 73,80,111,179,116,206,1 }, { 62,59,137,213,242,21,0 }, { 185,151,102,251,5,73,0 }, { 84,39,213,200,238,62,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 262)
		{ { 82,96,94,14,152,127,0 }, { 164,68,47,20,179,199,1 }, { 127,12,184,61,3,37,0 }, { 241,230,148,122,17,18,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 263)
		{ { 82,145,24,227,252,161,0 }, { 168,125,100,192,220,129,1 }, { 66,159,227,140,68,165,0 }, { 192,157,129,147,95,10,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 264)
		{ { 101,223,133,82,42,63,1 }, { 91,133,72,63,188,220,1 }, { 254,42,37,80,253,211,0 }, { 157,158,254,9,80,237,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 265)
		{ { 113,72,12,215,43,160,0 }, { 56,136,84,236,145,148,1 }, { 2,234,117,152,9,71,0 }, { 148,196,155,149,8,142,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 266)
		{ { 142,6,96,125,160,37,0 }, { 217,38,225,80,1,42,1 }, { 82,2,223,3,48,56,1 }, { 170,64,5,67,178,77,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 267)
		{ { 150,170,33,3,84,112,1 }, { 135,144,134,65,200,105,1 }, { 135,21,96,66,42,180,1 }, { 203,9,193,48,132,240,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 268)
		{ { 161,37,174,137,93,100,1 }, { 102,16,146,218,70,183,1 }, { 147,93,72,186,210,66,1 }, { 246,177,45,164,132,51,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 269)
		{ { 188,234,86,10,46,231,1 }, { 15,206,15,60,202,174,1 }, { 243,186,40,53,43,158,1 }, { 186,169,158,120,57,248,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 270)
		{ { 194,210,70,164,139,68,0 }, { 132,33,49,180,27,172,0 }, { 17,104,146,177,37,161,1 }, { 26,236,22,198,66,16,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 271)
		{ { 218,226,149,139,69,176,0 }, { 128,90,22,199,216,110,1 }, { 6,209,104,212,163,173,1 }, { 187,13,241,180,45,0,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 272)
		{ { 236,63,99,213,29,216,0 }, { 85,139,211,201,119,233,0 }, { 13,220,85,227,126,27,1 }, { 75,247,73,229,232,213,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 273)
		{ { 255,105,45,60,107,15,0 }, { 185,182,158,61,53,182,0 }, { 120,107,30,90,75,127,1 }, { 54,214,94,60,182,206,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 274)
		{ { 0,28,79,167,70,146,1 }, { 98,185,9,225,195,68,0 }, { 164,177,114,249,28,0,0 }, { 17,97,195,200,78,163,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 275)
		{ { 2,24,244,93,202,150,0 }, { 144,217,233,114,1,198,0 }, { 52,169,221,23,140,32,0 }, { 49,192,39,75,205,132,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 276)
		{ { 3,209,163,72,235,88,0 }, { 140,17,240,39,46,210,0 }, { 13,107,137,98,197,224,0 }, { 37,186,114,7,196,24,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 277)
		{ { 4,27,131,253,41,154,1 }, { 27,169,88,195,39,202,0 }, { 172,202,95,224,236,16,0 }, { 41,242,97,141,74,236,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 278)
		{ { 9,141,142,139,148,215,1 }, { 102,142,40,210,206,87,0 }, { 245,148,232,184,216,200,0 }, { 117,57,165,138,56,179,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 279)
		{ { 8,163,222,26,89,139,0 }, { 48,94,27,2,174,143,0 }, { 104,205,44,61,226,136,0 }, { 120,186,160,108,61,6,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 280)
		{ { 11,188,12,8,32,24,0 }, { 232,131,2,0,40,86,0 }, { 12,2,8,24,30,232,0 }, { 53,10,0,32,96,139,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 281)
		{ { 8,180,118,44,124,199,0 }, { 76,127,139,16,75,135,0 }, { 113,159,26,55,22,136,0 }, { 112,233,4,104,255,25,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 282)
		{ { 8,252,181,200,85,47,1 }, { 66,215,218,151,104,7,1 }, { 250,85,9,214,159,136,0 }, { 240,11,116,173,245,161,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 283)
		{ { 14,22,54,84,254,34,0 }, { 217,83,232,32,67,141,1 }, { 34,63,149,54,52,56,0 }, { 216,225,2,11,229,77,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 284)
		{ { 18,44,177,159,7,34,1 }, { 210,192,158,227,193,2,1 }, { 162,112,124,198,154,36,0 }, { 160,65,227,188,129,165,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 285)
		{ { 18,69,156,171,22,232,0 }, { 228,104,4,230,228,7,1 }, { 11,180,106,156,209,36,0 }, { 240,19,179,144,11,19,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 286)
		{ { 19,147,126,245,174,67,1 }, { 190,101,237,224,79,156,0 }, { 225,58,215,191,100,228,0 }, { 28,249,3,219,211,62,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 287)
		{ { 22,41,244,18,48,140,0 }, { 153,200,135,18,164,5,0 }, { 24,134,36,23,202,52,0 }, { 80,18,164,112,137,204,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 288)
		{ { 21,124,103,88,122,66,0 }, { 93,145,207,37,2,151,0 }, { 33,47,13,115,31,84,0 }, { 116,160,82,121,196,221,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 289)
		{ { 21,204,177,89,131,214,1 }, { 87,200,252,119,8,82,0 }, { 181,224,205,70,153,212,0 }, { 37,8,119,31,137,245,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 290)
		{ { 23,227,47,161,221,185,0 }, { 161,60,182,197,110,221,1 }, { 78,221,194,250,99,244,0 }, { 221,187,81,182,158,66,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 291)
		{ { 27,70,90,142,239,10,1 }, { 234,82,61,164,227,154,0 }, { 168,123,184,173,49,108,0 }, { 44,227,146,222,37,43,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 292)
		{ { 27,105,78,73,179,188,1 }, { 170,138,119,116,38,87,1 }, { 158,230,201,57,75,108,0 }, { 245,50,23,119,40,170,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 293)
		{ { 27,196,203,219,144,138,1 }, { 242,10,109,199,170,19,0 }, { 168,132,237,233,145,236,0 }, { 100,42,241,219,40,39,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 294)
		{ { 31,44,109,141,119,17,1 }, { 235,150,151,225,65,87,0 }, { 196,119,88,219,26,124,0 }, { 117,65,67,244,180,235,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 295)
		{ { 31,87,63,15,8,234,1 }, { 231,75,140,69,167,158,1 }, { 171,136,120,126,117,124,0 }, { 188,242,209,24,233,115,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 296)
		{ { 28,109,100,176,216,126,1 }, { 87,178,175,148,36,197,1 }, { 191,13,134,147,91,28,0 }, { 209,146,20,250,166,245,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 297)
		{ { 31,214,51,233,39,78,1 }, { 207,99,220,245,106,26,0 }, { 185,114,75,230,53,252,0 }, { 44,43,87,157,227,121,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 298)
		{ { 31,237,94,0,105,171,1 }, { 235,222,31,4,46,148,1 }, { 234,203,0,61,91,252,0 }, { 148,186,16,124,61,235,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 299)
		{ { 32,25,133,43,191,166,0 }, { 8,169,56,123,196,135,1 }, { 50,254,234,80,204,2,0 }, { 240,145,239,14,74,136,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 300)
		{ { 34,61,51,120,7,207,0 }, { 212,237,218,57,102,2,0 }, { 121,240,15,102,94,34,0 }, { 32,51,78,45,219,149,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 301)
		{ { 32,99,33,28,107,49,0 }, { 24,20,146,45,5,202,1 }, { 70,107,28,66,99,2,0 }, { 169,208,90,36,148,12,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 302)
		{ { 34,110,87,72,118,216,1 }, { 206,216,67,45,98,79,0 }, { 141,183,9,117,59,34,0 }, { 121,35,90,97,13,185,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 303)
		{ { 32,116,241,178,248,194,1 }, { 94,121,171,143,128,129,0 }, { 161,143,166,199,151,2,0 }, { 64,128,248,234,207,61,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 304)
		{ { 33,172,61,93,237,110,0 }, { 124,208,250,89,105,150,1 }, { 59,91,221,94,26,194,0 }, { 180,203,77,47,133,159,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 305)
		{ { 33,195,23,29,144,62,1 }, { 18,64,40,93,47,95,1 }, { 190,4,220,116,97,194,0 }, { 253,122,93,10,1,36,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 306)
		{ { 39,47,226,196,67,84,0 }, { 197,144,211,186,7,88,0 }, { 21,97,17,163,250,114,0 }, { 13,112,46,229,132,209,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 307)
		{ { 39,159,50,224,232,133,0 }, { 201,253,224,152,14,152,0 }, { 80,139,131,166,124,242,0 }, { 12,184,12,131,223,201,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 308)
		{ { 38,190,33,114,154,9,1 }, { 211,165,226,41,168,137,0 }, { 200,44,167,66,62,178,0 }, { 72,138,202,35,210,229,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 309)
		{ { 42,3,57,247,158,125,1 }, { 182,102,224,249,229,201,1 }, { 223,60,247,206,96,42,0 }, { 201,211,207,131,179,54,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 310)
		{ { 43,24,147,239,72,235,0 }, { 132,255,72,203,163,146,1 }, { 107,137,123,228,140,106,0 }, { 164,226,233,137,127,144,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 311)
		{ { 41,20,232,100,42,8,0 }, { 104,35,193,42,33,144,0 }, { 8,42,19,11,148,74,0 }, { 4,194,42,65,226,11,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 312)
		{ { 41,104,166,84,120,185,0 }, { 24,158,194,14,35,213,1 }, { 78,143,21,50,139,74,0 }, { 213,226,56,33,188,140,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 313)
		{ { 42,193,129,37,248,55,0 }, { 136,54,40,95,13,193,1 }, { 118,15,210,64,193,170,0 }, { 193,216,125,10,54,8,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 314)
		{ { 40,212,32,190,102,221,1 }, { 94,63,128,188,233,66,0 }, { 221,179,62,130,21,138,0 }, { 33,75,158,128,254,61,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 315)
		{ { 41,251,7,40,147,64,0 }, { 4,163,50,45,14,31,0 }, { 1,100,138,112,111,202,0 }, { 124,56,90,38,98,144,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 316)
		{ { 45,79,27,209,68,171,0 }, { 113,222,72,205,102,24,1 }, { 106,145,69,236,121,90,0 }, { 140,51,89,137,61,199,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 317)
		{ { 44,77,58,93,125,209,0 }, { 125,222,208,76,71,195,0 }, { 69,223,93,46,89,26,0 }, { 97,241,25,5,189,223,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 318)
		{ { 46,201,163,115,80,78,1 }, { 151,178,200,95,174,1,0 }, { 185,5,103,98,201,186,0 }, { 64,58,253,9,166,244,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 319)
		{ { 47,242,157,56,166,39,0 }, { 185,103,42,63,72,30,1 }, { 114,50,142,92,167,250,0 }, { 188,9,126,42,115,78,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 320)
		{ { 51,14,242,29,118,78,0 }, { 220,208,141,122,99,27,0 }, { 57,55,92,39,184,102,0 }, { 108,99,47,88,133,157,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 321)
		{ { 51,46,161,171,153,4,0 }, { 192,160,182,219,128,155,0 }, { 16,76,234,194,186,102,0 }, { 108,128,237,182,130,129,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 322)
		{ { 49,41,200,243,224,220,1 }, { 62,184,103,218,164,80,0 }, { 157,131,231,137,202,70,0 }, { 5,18,173,243,14,190,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 323)
		{ { 53,0,254,245,196,8,0 }, { 49,112,229,202,99,20,0 }, { 8,17,215,191,128,86,0 }, { 20,99,41,211,135,70,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 324)
		{ { 55,36,110,62,36,63,0 }, { 249,36,143,24,227,86,1 }, { 126,18,62,59,18,118,0 }, { 181,99,140,120,146,79,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 325)
		{ { 53,81,121,197,146,92,1 }, { 39,65,229,253,37,81,0 }, { 157,36,209,207,69,86,0 }, { 69,82,95,211,193,114,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 326)
		{ { 54,184,189,91,81,60,0 }, { 177,209,214,91,168,71,1 }, { 30,69,109,94,142,182,0 }, { 241,10,237,53,197,198,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 327)
		{ { 54,221,188,202,44,119,0 }, { 237,197,204,158,204,198,1 }, { 119,26,41,158,221,182,0 }, { 177,153,188,153,209,219,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 328)
		{ { 55,221,249,250,116,140,0 }, { 249,249,197,159,236,19,0 }, { 24,151,47,207,221,246,0 }, { 100,27,252,209,207,207,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 329)
		{ { 57,8,64,158,68,97,1 }, { 22,150,5,136,193,18,1 }, { 195,17,60,129,8,78,0 }, { 164,65,136,208,52,180,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 330)
		{ { 59,1,93,14,177,201,1 }, { 174,78,53,9,165,23,0 }, { 201,198,184,93,64,110,0 }, { 116,82,200,86,57,58,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 331)
		{ { 58,14,216,225,88,0,1 }, { 226,242,69,202,0,137,0 }, { 128,13,67,141,184,46,0 }, { 72,128,41,209,39,163,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 332)
		{ { 56,110,40,10,241,243,1 }, { 110,158,190,12,128,75,1 }, { 231,199,168,10,59,14,0 }, { 233,0,152,62,188,187,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 333)
		{ { 57,97,243,168,199,88,1 }, { 6,114,183,175,102,82,0 }, { 141,113,138,231,195,78,0 }, { 37,51,122,246,167,48,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 334)
		{ { 57,175,5,221,138,171,1 }, { 82,142,110,233,45,158,1 }, { 234,168,221,208,122,206,0 }, { 188,218,75,187,56,165,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 335)
		{ { 57,172,253,140,32,166,1 }, { 106,202,143,155,9,22,1 }, { 178,130,24,223,154,206,0 }, { 180,72,108,248,169,171,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 336)
		{ { 56,215,227,25,189,206,1 }, { 94,11,189,95,110,139,0 }, { 185,222,204,99,245,142,0 }, { 104,187,125,94,232,61,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 337)
		{ { 62,29,177,174,155,223,1 }, { 199,239,188,187,165,195,0 }, { 253,236,186,198,220,62,0 }, { 97,210,238,158,251,241,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 338)
		{ { 63,57,54,16,131,58,1 }, { 147,195,190,40,38,84,1 }, { 174,96,132,54,78,126,0 }, { 149,50,10,62,225,228,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 339)
		{ { 61,68,172,103,73,121,1 }, { 103,54,212,78,161,212,1 }, { 207,73,115,26,145,94,0 }, { 149,194,185,21,182,115,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 340)
		{ { 62,216,120,160,212,247,1 }, { 167,255,173,156,72,65,1 }, { 247,149,130,143,13,190,0 }, { 193,9,28,218,255,242,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 341)
		{ { 67,45,92,111,10,140,0 }, { 224,232,67,112,181,150,0 }, { 24,168,123,29,90,97,0 }, { 52,214,135,97,11,131,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 342)
		{ { 66,52,3,145,156,82,1 }, { 214,1,42,193,82,193,0 }, { 165,28,196,224,22,33,0 }, { 65,165,65,170,64,53,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 343)
		{ { 64,59,107,130,137,239,0 }, { 36,141,187,145,182,136,1 }, { 123,200,160,235,110,1,0 }, { 136,182,196,238,216,146,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 344)
		{ { 67,109,145,73,70,116,0 }, { 196,208,66,119,84,82,1 }, { 23,49,73,68,219,97,0 }, { 165,21,119,33,5,145,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 345)
		{ { 67,151,133,107,233,44,1 }, { 202,49,112,83,188,158,1 }, { 154,75,235,80,244,225,0 }, { 188,158,229,7,70,41,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 346)
		{ { 71,29,159,177,209,0,1 }, { 243,241,48,195,22,21,0 }, { 128,69,198,252,220,113,0 }, { 84,52,97,134,71,231,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 347)
		{ { 70,43,251,166,87,121,0 }, { 165,244,147,163,247,73,1 }, { 79,117,50,239,234,49,0 }, { 201,119,226,228,151,210,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 348)
		{ { 70,92,73,248,0,58,1 }, { 243,161,73,133,48,66,1 }, { 174,0,15,201,29,49,0 }, { 161,6,80,201,66,231,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 349)
		{ { 69,118,247,32,48,38,1 }, { 75,97,139,23,18,29,1 }, { 178,6,2,119,183,81,0 }, { 220,36,116,104,195,105,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 350)
		{ { 70,168,40,69,154,252,0 }, { 165,136,226,112,57,193,1 }, { 31,172,209,10,10,177,0 }, { 193,206,7,35,136,210,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 351)
		{ { 68,160,107,94,1,10,0 }, { 49,0,219,1,187,2,0 }, { 40,64,61,107,2,145,0 }, { 32,110,192,109,128,70,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 352)
		{ { 69,185,78,113,53,37,0 }, { 57,165,83,80,94,21,1 }, { 82,86,71,57,78,209,0 }, { 212,61,5,101,82,206,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 353)
		{ { 75,113,215,160,253,197,1 }, { 142,127,51,151,86,149,0 }, { 209,223,130,245,199,105,0 }, { 84,181,116,230,127,56,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 354)
		{ { 79,60,121,82,108,209,1 }, { 255,223,195,1,208,208,0 }, { 197,155,37,79,30,121,0 }, { 5,133,192,97,253,255,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 355)
		{ { 79,178,80,33,70,98,0 }, { 133,115,11,96,88,24,1 }, { 35,49,66,5,38,249,0 }, { 140,13,3,104,103,80,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 356)
		{ { 79,239,177,247,108,238,1 }, { 223,250,202,215,253,152,1 }, { 187,155,119,198,251,249,0 }, { 140,223,245,169,175,253,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 357)
		{ { 82,75,82,250,189,204,0 }, { 156,232,117,148,246,139,0 }, { 25,222,175,165,105,37,0 }, { 104,183,148,215,11,156,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 358)
		{ { 83,200,244,221,123,200,1 }, { 158,216,213,230,57,151,0 }, { 137,239,93,151,137,229,0 }, { 116,206,51,213,141,188,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 359)
		{ { 87,5,99,141,134,48,0 }, { 193,0,165,225,87,82,1 }, { 6,48,216,227,80,117,0 }, { 165,117,67,210,128,65,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 360)
		{ { 85,75,225,85,227,0,0 }, { 25,144,245,103,21,24,0 }, { 0,99,213,67,233,85,0 }, { 12,84,115,87,132,204,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 361)
		{ { 85,138,47,175,183,98,0 }, { 45,160,188,225,219,31,1 }, { 35,118,250,250,40,213,0 }, { 252,109,195,158,130,218,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 362)
		{ { 84,153,49,31,160,83,0 }, { 29,197,172,65,157,66,0 }, { 101,2,252,70,76,149,0 }, { 33,92,193,26,209,220,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 363)
		{ { 88,13,255,122,69,176,1 }, { 114,250,213,3,214,70,1 }, { 134,209,47,127,216,13,0 }, { 177,53,224,85,175,167,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 364)
		{ { 90,18,17,208,247,52,1 }, { 154,83,116,177,80,73,1 }, { 150,119,133,196,36,45,0 }, { 201,5,70,151,101,44,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 365)
		{ { 95,17,24,22,24,164,0 }, { 177,75,4,16,149,145,1 }, { 18,140,52,12,68,125,0 }, { 196,212,132,16,105,70,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 366)
		{ { 93,61,87,179,227,47,0 }, { 89,247,63,241,182,20,1 }, { 122,99,230,245,94,93,0 }, { 148,54,199,254,119,205,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 367)
		{ { 93,74,155,244,162,166,0 }, { 57,234,108,183,19,24,1 }, { 50,162,151,236,169,93,0 }, { 140,100,118,155,43,206,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 368)
		{ { 94,137,78,179,16,89,0 }, { 181,166,5,192,190,69,0 }, { 77,4,102,185,72,189,0 }, { 81,62,129,208,50,214,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 369)
		{ { 95,182,4,116,142,30,1 }, { 211,35,110,48,121,220,0 }, { 188,56,151,16,54,253,0 }, { 29,207,6,59,98,101,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 370)
		{ { 95,252,162,7,10,47,1 }, { 195,135,142,118,187,144,1 }, { 250,40,112,34,159,253,0 }, { 132,238,183,56,240,225,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 371)
		{ { 98,20,52,163,198,43,1 }, { 194,117,168,232,240,4,1 }, { 234,49,226,150,20,35,0 }, { 144,7,139,138,215,33,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 372)
		{ { 96,69,249,159,75,213,0 }, { 116,92,145,255,149,194,0 }, { 85,233,124,207,209,3,0 }, { 33,212,255,196,157,23,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 373)
		{ { 96,94,235,202,23,75,1 }, { 102,133,217,175,242,11,0 }, { 233,116,41,235,189,3,0 }, { 104,39,250,205,208,179,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 374)
		{ { 97,111,101,43,244,79,0 }, { 76,180,171,93,244,31,0 }, { 121,23,234,83,123,67,0 }, { 124,23,221,106,150,153,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 375)
		{ { 96,111,231,237,175,53,0 }, { 72,164,243,255,87,206,1 }, { 86,122,219,243,251,3,0 }, { 185,245,127,231,146,137,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 376)
		{ { 98,227,54,39,167,213,0 }, { 140,108,178,124,223,76,0 }, { 85,242,242,54,99,163,0 }, { 25,125,159,38,155,24,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 377)
		{ { 101,50,13,146,242,6,0 }, { 57,17,42,185,144,29,0 }, { 48,39,164,216,38,83,0 }, { 92,4,206,170,68,78,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 378)
		{ { 101,174,116,178,81,246,0 }, { 85,248,155,152,152,93,1 }, { 55,197,38,151,58,211,0 }, { 221,12,140,236,143,213,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 379)
		{ { 106,37,233,73,31,2,1 }, { 226,2,219,107,84,131,0 }, { 160,124,73,75,210,43,0 }, { 96,149,107,109,160,35,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 380)
		{ { 105,154,22,139,171,78,0 }, { 12,195,56,248,186,158,0 }, { 57,106,232,180,44,203,0 }, { 60,174,143,142,97,152,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 381)
		{ { 104,159,185,186,26,80,0 }, { 116,227,128,171,156,203,0 }, { 5,44,46,206,252,139,0 }, { 105,156,234,128,227,151,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 382)
		{ { 104,172,27,248,226,27,1 }, { 122,246,106,169,58,66,0 }, { 236,35,143,236,26,139,0 }, { 33,46,74,171,55,175,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 383)
		{ { 107,204,220,27,224,85,0 }, { 252,214,33,94,152,86,0 }, { 85,3,236,29,153,235,0 }, { 53,12,189,66,53,159,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 384)
		{ { 110,70,68,174,42,27,1 }, { 203,38,9,172,177,206,0 }, { 236,42,58,145,49,59,0 }, { 57,198,154,200,50,105,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 385)
		{ { 110,91,221,156,85,145,1 }, { 179,223,17,143,85,79,0 }, { 196,213,28,221,237,59,0 }, { 121,85,120,196,125,230,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 386)
		{ { 110,114,103,14,62,109,0 }, { 141,7,131,61,243,143,1 }, { 91,62,56,115,39,59,0 }, { 248,231,222,96,240,88,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 387)
		{ { 111,134,147,35,45,171,0 }, { 201,110,24,75,250,152,1 }, { 106,218,98,100,176,251,0 }, { 140,175,233,12,59,73,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 388)
		{ { 108,137,244,64,218,114,1 }, { 7,210,233,42,28,197,1 }, { 167,45,129,23,200,155,0 }, { 209,156,42,75,165,240,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 389)
		{ { 111,156,82,187,178,211,1 }, { 223,239,41,232,154,83,0 }, { 229,166,238,165,28,251,0 }, { 101,44,139,202,123,253,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 390)
		{ { 111,148,127,90,90,175,1 }, { 243,95,201,57,186,151,1 }, { 250,173,45,127,20,251,0 }, { 244,174,206,73,253,103,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 391)
		{ { 110,168,22,55,188,108,1 }, { 159,226,34,88,251,133,1 }, { 155,30,246,52,10,187,0 }, { 208,239,141,34,35,252,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 392)
		{ { 110,177,138,108,23,81,0 }, { 165,39,82,42,95,67,0 }, { 69,116,27,40,198,187,0 }, { 97,125,42,37,114,82,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 393)
		{ { 111,200,142,200,247,162,0 }, { 169,154,120,174,90,23,1 }, { 34,247,137,184,137,251,0 }, { 244,45,58,143,44,202,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 394)
		{ { 115,81,80,190,35,239,0 }, { 156,109,29,188,181,18,1 }, { 123,226,62,133,69,103,0 }, { 164,86,158,220,91,28,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 395)
		{ { 112,139,71,240,27,189,0 }, { 16,172,85,185,62,205,1 }, { 94,236,7,241,104,135,0 }, { 217,190,78,213,26,132,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 396)
		{ { 112,149,37,251,26,110,1 }, { 86,33,204,249,188,135,1 }, { 187,44,111,210,84,135,0 }, { 240,158,207,153,194,53,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 397)
		{ { 114,158,255,114,99,90,0 }, { 252,241,221,43,186,76,0 }, { 45,99,39,127,188,167,0 }, { 25,46,234,93,199,159,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 398)
		{ { 112,171,227,124,150,208,1 }, { 22,168,231,43,95,75,0 }, { 133,180,159,99,234,135,0 }, { 105,125,106,115,138,180,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 399)
		{ { 114,245,151,82,179,142,0 }, { 216,73,126,63,190,5,0 }, { 56,230,165,116,215,167,0 }, { 80,62,254,63,73,13,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 400)
		{ { 118,5,164,230,226,221,0 }, { 205,60,228,186,181,68,0 }, { 93,163,179,146,208,55,0 }, { 17,86,174,147,158,89,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 401)
		{ { 116,17,6,76,105,165,0 }, { 9,29,84,24,23,134,1 }, { 82,203,25,48,68,23,0 }, { 176,244,12,21,92,72,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 402)
		{ { 118,36,17,60,244,246,1 }, { 223,120,46,25,81,67,1 }, { 183,151,158,68,18,55,0 }, { 225,69,76,58,15,125,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 403)
		{ { 116,101,193,88,187,101,1 }, { 95,4,119,63,20,131,1 }, { 211,110,141,65,211,23,0 }, { 224,148,126,119,16,125,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 404)
		{ { 119,125,91,58,188,225,0 }, { 253,237,39,13,214,147,1 }, { 67,158,174,109,95,119,0 }, { 228,181,216,114,91,223,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 405)
		{ { 119,182,15,188,123,59,0 }, { 249,53,30,169,59,223,1 }, { 110,111,30,248,54,247,0 }, { 253,238,74,188,86,79,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 406)
		{ { 118,180,133,0,61,168,1 }, { 203,9,22,11,120,133,1 }, { 138,222,0,80,150,183,0 }, { 208,143,104,52,72,105,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 407)
		{ { 117,238,187,75,14,98,1 }, { 103,192,206,111,218,154,1 }, { 163,56,105,110,187,215,0 }, { 172,173,251,57,129,243,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 408)
		{ { 118,250,208,216,178,184,0 }, { 153,201,103,174,56,75,1 }, { 14,166,141,133,175,183,0 }, { 233,14,58,243,73,204,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 409)
		{ { 120,75,97,130,218,8,1 }, { 2,146,165,173,180,137,0 }, { 136,45,160,195,105,15,0 }, { 72,150,218,210,164,160,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 410)
		{ { 122,187,251,47,52,31,1 }, { 170,231,143,91,255,75,0 }, { 252,22,122,111,238,175,0 }, { 105,127,237,120,243,170,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 411)
		{ { 127,39,5,215,84,100,0 }, { 213,18,70,217,213,29,1 }, { 19,21,117,208,114,127,0 }, { 220,85,205,177,36,85,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 412)
		{ { 125,227,180,31,248,152,0 }, { 25,90,166,78,189,223,0 }, { 12,143,252,22,227,223,0 }, { 125,222,185,50,173,76,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 413)
		{ { 127,237,141,135,251,207,1 }, { 239,158,62,255,189,149,0 }, { 249,239,240,216,219,255,0 }, { 84,222,255,190,60,251,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 414)
		{ { 126,246,82,55,17,197,0 }, { 213,111,23,92,155,9,0 }, { 81,196,118,37,55,191,0 }, { 72,108,157,116,123,85,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 415)
		{ { 129,31,240,203,185,104,1 }, { 78,193,241,194,164,187,1 }, { 139,78,233,135,252,64,1 }, { 238,146,161,199,193,185,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 416)
		{ { 128,46,234,6,149,52,0 }, { 96,128,179,18,195,105,1 }, { 22,84,176,43,186,0,1 }, { 203,97,164,102,128,131,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 417)
		{ { 130,73,255,59,138,203,1 }, { 182,236,169,103,166,166,0 }, { 233,168,238,127,201,32,1 }, { 50,178,243,74,155,182,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 418)
		{ { 129,200,212,49,219,37,0 }, { 16,244,49,118,8,181,1 }, { 82,109,198,21,137,192,1 }, { 214,136,55,70,23,132,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 419)
		{ { 132,43,15,88,160,122,0 }, { 61,128,106,1,38,110,1 }, { 47,2,141,120,106,16,1 }, { 187,50,64,43,0,222,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 420)
		{ { 133,43,127,179,216,14,0 }, { 49,240,171,209,166,189,0 }, { 56,13,230,255,106,80,1 }, { 94,178,197,234,135,198,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 421)
		{ { 134,32,167,236,235,192,1 }, { 143,56,242,163,3,166,0 }, { 129,235,155,242,130,48,1 }, { 50,224,98,167,142,120,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 422)
		{ { 134,89,195,75,94,119,1 }, { 135,149,73,119,198,227,1 }, { 247,61,105,97,205,48,1 }, { 227,177,247,73,84,240,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 423)
		{ { 135,96,6,117,87,9,0 }, { 145,52,82,100,99,53,0 }, { 72,117,87,48,3,112,1 }, { 86,99,19,37,22,68,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 424)
		{ { 132,219,148,26,247,200,0 }, { 29,217,48,38,236,47,0 }, { 9,247,172,20,237,144,1 }, { 122,27,178,6,77,220,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 425)
		{ { 138,22,181,10,57,125,0 }, { 204,71,144,19,160,239,1 }, { 95,78,40,86,180,40,1 }, { 251,130,228,4,241,25,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 426)
		{ { 138,63,78,17,183,8,0 }, { 248,131,51,96,102,45,0 }, { 8,118,196,57,126,40,1 }, { 90,51,3,102,96,143,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 427)
		{ { 137,70,134,138,98,190,0 }, { 72,26,8,182,162,126,1 }, { 62,163,40,176,177,72,1 }, { 191,34,182,136,44,9,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 428)
		{ { 139,122,129,163,127,219,0 }, { 140,191,26,231,224,249,0 }, { 109,255,98,192,175,104,1 }, { 79,131,243,172,126,152,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 429)
		{ { 137,134,220,73,174,214,0 }, { 108,74,105,114,72,254,0 }, { 53,186,201,29,176,200,1 }, { 63,137,39,75,41,27,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 430)
		{ { 137,153,52,70,112,178,1 }, { 10,219,200,0,141,117,1 }, { 166,135,49,22,76,200,1 }, { 215,88,128,9,237,168,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 431)
		{ { 139,205,202,224,85,9,1 }, { 226,182,81,134,110,49,0 }, { 200,85,3,169,217,232,1 }, { 70,59,48,197,54,163,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 432)
		{ { 139,222,241,118,82,104,1 }, { 214,243,193,39,169,57,1 }, { 139,37,55,71,189,232,1 }, { 206,74,242,65,231,181,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 433)
		{ { 142,18,98,26,198,81,1 }, { 151,23,161,32,194,106,0 }, { 197,49,172,35,36,56,1 }, { 43,33,130,66,244,116,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 434)
		{ { 141,46,148,181,204,168,0 }, { 81,250,34,194,97,188,1 }, { 10,153,214,148,186,88,1 }, { 158,195,33,162,47,197,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 435)
		{ { 140,75,185,11,82,34,0 }, { 33,210,136,103,132,43,1 }, { 34,37,104,78,233,24,1 }, { 234,16,243,8,165,194,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 436)
		{ { 141,153,201,208,216,171,1 }, { 51,159,105,131,44,177,1 }, { 234,141,133,201,204,216,1 }, { 198,154,96,203,124,230,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 437)
		{ { 144,17,129,73,60,185,1 }, { 10,13,68,67,100,227,1 }, { 206,158,73,64,196,4,1 }, { 227,147,97,17,88,40,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 438)
		{ { 146,45,168,84,94,84,1 }, { 246,144,198,50,69,225,0 }, { 149,61,21,10,218,36,1 }, { 67,209,38,49,132,183,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 439)
		{ { 144,78,120,161,56,250,1 }, { 110,232,141,196,32,233,1 }, { 175,142,66,143,57,4,1 }, { 203,130,17,216,139,187,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 440)
		{ { 144,151,90,16,127,241,0 }, { 124,93,21,32,78,233,1 }, { 71,255,4,45,116,132,1 }, { 203,185,2,84,93,31,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 441)
		{ { 144,179,61,187,100,42,0 }, { 56,113,142,193,236,46,1 }, { 42,19,110,222,102,132,1 }, { 186,27,193,184,199,14,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 442)
		{ { 147,192,227,79,19,241,0 }, { 132,12,213,103,139,115,1 }, { 71,228,121,99,129,228,1 }, { 231,104,243,85,152,16,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 443)
		{ { 151,73,34,81,12,38,0 }, { 145,128,204,84,70,176,1 }, { 50,24,69,34,73,116,1 }, { 134,177,21,25,128,196,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 444)
		{ { 151,74,87,164,6,195,0 }, { 133,236,13,165,67,60,0 }, { 97,176,18,245,41,116,1 }, { 30,97,82,216,27,208,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 445)
		{ { 150,115,104,38,246,150,1 }, { 171,57,175,52,197,105,0 }, { 180,183,178,11,103,52,1 }, { 75,81,150,122,206,106,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 446)
		{ { 149,138,223,218,96,3,1 }, { 59,212,77,131,138,62,0 }, { 224,3,45,253,168,212,1 }, { 62,40,224,217,21,238,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 447)
		{ { 150,175,46,35,58,45,0 }, { 233,164,134,112,174,173,1 }, { 90,46,98,58,122,180,1 }, { 218,186,135,48,146,203,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 448)
		{ { 155,7,68,229,222,47,0 }, { 192,54,109,240,101,189,1 }, { 122,61,211,145,112,108,1 }, { 222,211,7,219,54,1,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 449)
		{ { 152,75,88,148,206,180,0 }, { 48,218,37,180,69,232,1 }, { 22,185,148,141,105,12,1 }, { 139,209,22,210,45,134,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 450)
		{ { 153,122,202,55,11,119,1 }, { 54,167,31,118,131,248,1 }, { 247,104,118,41,175,76,1 }, { 143,224,183,124,114,182,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 451)
		{ { 156,0,144,208,133,65,1 }, { 23,70,116,130,64,32,0 }, { 193,80,133,132,128,28,1 }, { 2,1,32,151,49,116,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 452)
		{ { 157,117,4,69,227,242,1 }, { 79,27,126,100,5,116,1 }, { 167,227,209,16,87,92,1 }, { 151,80,19,63,108,121,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 453)
		{ { 160,66,244,31,20,137,1 }, { 18,76,129,78,225,47,0 }, { 200,148,124,23,161,2,1 }, { 122,67,185,64,153,36,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 454)
		{ { 160,154,32,41,137,97,0 }, { 4,165,176,72,8,170,1 }, { 67,72,202,2,44,130,1 }, { 170,136,9,6,210,144,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 455)
		{ { 161,151,65,181,6,20,0 }, { 80,33,1,249,77,120,0 }, { 20,48,86,193,116,194,1 }, { 15,89,79,192,66,5,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 456)
		{ { 162,199,179,237,218,219,0 }, { 196,124,232,239,47,235,0 }, { 109,173,219,230,241,162,1 }, { 107,250,123,139,159,17,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 457)
		{ { 163,237,115,3,171,156,0 }, { 200,200,179,125,174,240,0 }, { 28,234,224,103,91,226,1 }, { 7,186,223,102,137,137,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 458)
		{ { 164,14,153,123,197,24,0 }, { 113,240,112,75,224,106,0 }, { 12,81,239,76,184,18,1 }, { 43,3,233,7,7,199,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 459)
		{ { 166,46,211,181,170,239,0 }, { 221,236,43,251,35,168,1 }, { 123,170,214,229,186,50,1 }, { 138,226,111,234,27,221,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 460)
		{ { 166,72,83,81,97,91,1 }, { 159,212,89,77,34,96,0 }, { 237,67,69,101,9,50,1 }, { 3,34,89,77,21,252,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 461)
		{ { 166,88,46,241,183,120,1 }, { 191,161,240,236,98,101,1 }, { 143,118,199,186,13,50,1 }, { 211,35,27,135,194,254,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 462)
		{ { 167,125,62,203,3,105,0 }, { 229,197,210,236,166,54,1 }, { 75,96,105,190,95,114,1 }, { 182,50,155,165,209,211,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 463)
		{ { 165,183,40,12,100,157,0 }, { 105,29,130,24,109,122,0 }, { 92,147,24,10,118,210,1 }, { 47,91,12,32,220,75,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 464)
		{ { 164,207,91,78,212,244,0 }, { 101,216,97,29,207,107,1 }, { 23,149,185,109,121,146,1 }, { 235,121,220,67,13,211,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 465)
		{ { 171,21,211,205,48,133,0 }, { 200,79,65,219,7,51,0 }, { 80,134,89,229,212,106,1 }, { 102,112,109,193,121,9,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 466)
		{ { 171,47,103,30,208,8,1 }, { 210,146,163,9,167,63,0 }, { 136,5,188,115,122,106,1 }, { 126,114,200,98,164,165,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 467)
		{ { 168,43,177,100,80,17,1 }, { 2,246,194,11,5,105,0 }, { 196,5,19,70,234,10,1 }, { 75,80,104,33,183,160,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 468)
		{ { 168,67,58,121,199,250,1 }, { 54,122,248,108,102,106,1 }, { 175,241,207,46,97,10,1 }, { 171,51,27,15,175,54,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 469)
		{ { 168,95,145,245,169,81,0 }, { 92,231,112,207,5,232,0 }, { 69,74,215,196,253,10,1 }, { 11,208,121,135,115,157,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 470)
		{ { 168,126,123,132,128,94,1 }, { 102,195,171,157,35,104,0 }, { 189,0,144,239,63,10,1 }, { 11,98,92,234,225,179,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 471)
		{ { 168,132,121,195,96,56,1 }, { 106,82,193,201,168,96,1 }, { 142,3,97,207,16,138,1 }, { 131,10,201,193,165,43,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 472)
		{ { 171,163,68,207,130,112,0 }, { 132,2,99,232,141,126,1 }, { 7,32,249,145,98,234,1 }, { 191,88,139,227,32,16,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 473)
		{ { 171,230,49,247,179,118,0 }, { 220,98,250,253,137,121,1 }, { 55,102,247,198,51,234,1 }, { 207,72,223,175,163,29,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 474)
		{ { 172,22,16,22,73,151,0 }, { 81,95,24,24,129,232,0 }, { 116,201,52,4,52,26,1 }, { 11,192,140,12,125,69,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 475)
		{ { 174,39,216,18,235,36,1 }, { 251,82,51,58,132,168,1 }, { 146,107,164,13,242,58,1 }, { 138,144,174,102,37,111,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 476)
		{ { 175,59,230,2,186,159,1 }, { 139,143,171,58,166,253,0 }, { 252,174,160,51,238,122,1 }, { 95,178,174,106,248,232,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 477)
		{ { 174,70,26,234,137,71,1 }, { 231,102,120,156,130,170,0 }, { 241,72,171,172,49,58,1 }, { 42,160,156,143,51,115,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 478)
		{ { 173,66,113,218,119,159,1 }, { 27,94,217,189,224,123,0 }, { 252,247,45,199,33,90,1 }, { 111,3,222,205,189,108,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 479)
		{ { 173,88,23,206,43,193,1 }, { 15,207,80,173,131,182,0 }, { 193,234,57,244,13,90,1 }, { 54,224,218,133,121,248,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 480)
		{ { 172,151,210,208,179,77,0 }, { 93,71,113,186,46,41,0 }, { 89,102,133,165,244,154,1 }, { 74,58,46,199,113,93,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 481)
		{ { 173,190,197,66,11,202,0 }, { 69,139,91,43,168,188,0 }, { 41,232,33,81,190,218,1 }, { 30,138,234,109,104,209,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 482)
		{ { 175,250,80,85,120,101,0 }, { 157,215,67,92,9,185,1 }, { 83,15,85,5,47,250,1 }, { 206,200,29,97,117,220,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 483)
		{ { 176,31,206,26,12,146,1 }, { 114,137,13,10,198,238,0 }, { 164,152,44,57,252,6,1 }, { 59,177,168,88,72,167,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 484)
		{ { 177,112,134,190,143,137,0 }, { 16,45,54,174,227,182,0 }, { 72,248,190,176,135,70,1 }, { 54,227,186,182,90,4,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 485)
		{ { 183,222,54,61,41,2,0 }, { 217,225,156,76,11,190,0 }, { 32,74,94,54,61,246,1 }, { 62,232,25,28,195,205,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 486)
		{ { 180,229,14,234,89,126,0 }, { 101,48,94,156,174,231,1 }, { 63,77,43,184,83,150,1 }, { 243,186,156,189,6,83,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 487)
		{ { 186,59,44,235,91,138,0 }, { 160,187,222,232,164,175,0 }, { 40,237,107,154,110,46,1 }, { 122,146,139,189,238,130,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 488)
		{ { 187,123,82,243,209,20,0 }, { 144,243,119,220,134,121,0 }, { 20,69,231,165,111,110,1 }, { 79,48,157,247,103,132,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 489)
		{ { 186,116,182,71,89,86,1 }, { 198,83,222,94,131,229,0 }, { 181,77,113,54,151,46,1 }, { 83,224,189,61,229,49,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 490)
		{ { 186,139,73,97,25,111,1 }, { 166,166,93,89,44,169,1 }, { 251,76,67,73,104,174,1 }, { 202,154,77,93,50,178,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 491)
		{ { 187,152,233,200,28,89,0 }, { 164,135,197,139,104,243,0 }, { 77,28,9,203,140,238,1 }, { 103,139,104,209,240,146,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 492)
		{ { 188,30,177,81,156,163,1 }, { 83,207,236,75,64,169,1 }, { 226,156,197,70,188,30,1 }, { 202,129,105,27,249,229,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 493)
		{ { 188,42,52,17,27,68,1 }, { 23,194,150,120,0,173,0 }, { 145,108,68,22,42,30,1 }, { 90,128,15,52,161,244,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 494)
		{ { 189,81,101,27,30,213,0 }, { 21,15,133,125,196,247,0 }, { 85,188,108,83,69,94,1 }, { 119,145,223,80,248,84,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 495)
		{ { 190,112,117,173,51,180,1 }, { 139,107,151,253,1,103,1 }, { 150,230,90,215,7,62,1 }, { 243,64,95,244,235,104,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 496)
		{ { 189,255,164,161,70,198,1 }, { 71,187,142,254,76,60,0 }, { 177,177,66,146,255,222,1 }, { 30,25,63,184,238,241,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 497)
		{ { 193,4,151,159,155,192,0 }, { 84,72,48,227,147,183,0 }, { 1,236,252,244,144,65,1 }, { 118,228,227,134,9,21,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 498)
		{ { 193,30,33,36,254,38,1 }, { 74,177,168,49,81,185,1 }, { 178,63,146,66,60,65,1 }, { 206,197,70,10,198,169,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 499)
		{ { 192,237,72,64,106,165,0 }, { 104,156,67,52,28,160,1 }, { 82,171,1,9,91,129,1 }, { 130,156,22,97,28,139,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 500)
		{ { 192,234,184,166,4,229,0 }, { 36,236,130,150,217,40,1 }, { 83,144,50,142,171,129,1 }, { 138,77,180,160,155,146,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 501)
		{ { 198,87,250,41,77,82,1 }, { 231,113,153,70,86,234,0 }, { 165,89,74,47,245,49,1 }, { 43,181,49,76,199,115,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 502)
		{ { 200,111,63,193,206,104,0 }, { 100,210,226,229,118,172,1 }, { 11,57,193,254,123,9,1 }, { 154,183,83,163,165,147,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 503)
		{ { 200,99,86,204,12,4,1 }, { 2,66,67,148,87,174,0 }, { 144,24,25,181,99,9,1 }, { 58,245,20,225,33,32,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 504)
		{ { 201,215,21,97,151,171,1 }, { 66,111,120,101,124,61,1 }, { 234,244,195,84,117,201,1 }, { 222,31,83,15,123,33,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 505)
		{ { 203,227,118,18,26,242,1 }, { 150,74,139,36,158,253,1 }, { 167,172,36,55,99,233,1 }, { 223,188,146,104,169,52,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 506)
		{ { 204,23,188,202,55,164,1 }, { 107,75,208,178,212,47,1 }, { 146,246,41,158,244,25,1 }, { 250,21,166,133,233,107,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 507)
		{ { 204,223,166,39,145,190,0 }, { 65,171,184,86,191,109,1 }, { 62,196,242,50,253,153,1 }, { 219,126,181,14,234,193,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 508)
		{ { 204,235,235,67,36,93,0 }, { 45,134,195,87,254,104,0 }, { 93,18,97,107,235,153,1 }, { 11,63,245,97,176,218,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 509)
		{ { 209,53,155,82,5,119,0 }, { 116,69,94,19,214,112,1 }, { 119,80,37,108,214,69,1 }, { 135,53,228,61,81,23,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 510)
		{ { 209,91,212,112,60,106,0 }, { 28,225,77,6,116,189,1 }, { 43,30,7,21,237,69,1 }, { 222,151,48,89,67,156,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 511)
		{ { 215,26,117,66,163,79,1 }, { 143,197,253,49,176,60,0 }, { 249,98,161,87,44,117,1 }, { 30,6,198,95,209,248,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 512)
		{ { 215,230,123,63,234,215,1 }, { 255,124,175,117,155,250,0 }, { 245,171,254,111,51,245,1 }, { 47,236,215,122,159,127,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 513)
		{ { 219,2,186,238,81,189,1 }, { 162,126,212,146,179,123,1 }, { 222,197,59,174,160,109,1 }, { 239,102,164,149,191,34,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 514)
		{ { 216,126,223,70,165,187,1 }, { 106,207,127,7,243,108,1 }, { 238,210,177,125,191,13,1 }, { 155,103,240,127,121,171,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 515)
		{ { 216,131,133,71,132,38,1 }, { 2,2,108,83,221,44,1 }, { 178,16,241,80,224,141,1 }, { 154,93,229,27,32,32,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 516)
		{ { 218,189,22,192,207,231,0 }, { 196,223,126,176,94,164,1 }, { 115,249,129,180,94,173,1 }, { 146,189,6,191,125,145,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 517)
		{ { 219,226,77,128,236,124,1 }, { 174,18,39,149,120,252,1 }, { 159,27,128,217,35,237,1 }, { 159,143,84,242,36,58,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 518)
		{ { 217,244,154,237,44,69,0 }, { 108,103,70,214,91,178,0 }, { 81,26,91,172,151,205,1 }, { 38,237,53,177,115,27,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 519)
		{ { 222,24,187,178,78,206,1 }, { 183,251,140,179,242,160,0 }, { 185,185,38,238,140,61,1 }, { 2,167,230,152,239,246,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 520)
		{ { 221,25,226,31,178,162,1 }, { 27,139,173,98,151,51,1 }, { 162,166,252,35,204,93,1 }, { 230,116,163,90,232,236,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 521)
		{ { 222,44,65,181,149,43,0 }, { 209,166,63,193,113,33,1 }, { 106,84,214,193,26,61,1 }, { 194,71,65,254,50,197,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 522)
		{ { 220,75,143,150,13,97,0 }, { 53,134,20,135,215,172,1 }, { 67,88,52,248,233,29,1 }, { 154,245,240,148,48,214,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 523)
		{ { 221,148,173,142,18,115,1 }, { 103,7,140,163,153,119,1 }, { 231,36,56,218,148,221,1 }, { 247,76,226,152,240,115,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 524)
		{ { 221,209,152,178,105,248,1 }, { 63,123,20,134,188,240,1 }, { 143,203,38,140,197,221,1 }, { 135,158,176,148,111,126,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 525)
		{ { 225,16,129,210,125,199,0 }, { 28,29,88,155,208,177,0 }, { 113,223,37,192,132,67,1 }, { 70,133,236,141,92,28,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 526)
		{ { 226,29,244,60,230,69,1 }, { 222,245,161,58,85,38,0 }, { 209,51,158,23,220,35,1 }, { 50,85,46,66,215,189,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 527)
		{ { 227,42,142,26,117,17,0 }, { 184,148,18,10,210,127,0 }, { 68,87,44,56,170,99,1 }, { 127,37,168,36,20,142,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 528)
		{ { 230,127,34,189,228,63,1 }, { 219,181,170,220,119,106,1 }, { 254,19,222,162,127,51,1 }, { 171,119,29,170,214,237,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 529)
		{ { 230,201,244,50,47,175,1 }, { 155,236,153,62,252,164,1 }, { 250,250,38,23,201,179,1 }, { 146,159,190,76,155,236,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 530)
		{ { 233,65,95,6,96,115,0 }, { 44,86,9,13,151,116,1 }, { 103,3,48,125,65,75,1 }, { 151,116,216,72,53,26,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 531)
		{ { 232,162,221,84,147,113,0 }, { 52,70,115,43,25,109,1 }, { 71,100,149,93,162,139,1 }, { 219,76,106,103,49,22,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 532)
		{ { 232,216,146,243,185,171,1 }, { 26,239,120,206,186,161,1 }, { 234,206,231,164,141,139,1 }, { 194,174,185,143,123,172,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 533)
		{ { 234,224,242,13,25,46,0 }, { 128,66,155,94,59,163,1 }, { 58,76,88,39,131,171,1 }, { 226,238,61,108,161,0,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 534)
		{ { 237,183,135,120,221,244,0 }, { 85,59,114,27,94,255,1 }, { 23,221,143,112,246,219,1 }, { 255,189,108,39,110,85,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 535)
		{ { 237,243,41,3,202,39,1 }, { 35,23,170,125,156,184,1 }, { 242,41,224,74,103,219,1 }, { 142,156,223,42,244,98,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 536)
		{ { 242,9,23,170,178,81,0 }, { 140,228,36,169,150,103,0 }, { 69,38,170,244,72,39,1 }, { 115,52,202,146,19,152,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 537)
		{ { 242,87,191,49,98,230,1 }, { 254,121,140,127,22,44,1 }, { 179,163,70,126,245,39,1 }, { 154,52,127,24,207,63,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 538)
		{ { 240,161,59,114,216,194,0 }, { 52,120,238,9,158,161,0 }, { 33,141,167,110,66,135,1 }, { 66,188,200,59,143,22,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 539)
		{ { 242,204,10,145,3,251,0 }, { 244,140,28,236,58,96,1 }, { 111,224,68,168,25,167,1 }, { 131,46,27,156,24,151,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 540)
		{ { 240,197,80,127,169,160,1 }, { 90,104,117,76,157,162,1 }, { 130,202,255,5,81,135,1 }, { 162,220,153,87,11,45,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 541)
		{ { 241,197,159,71,93,153,1 }, { 98,92,84,79,255,245,0 }, { 204,221,113,124,209,199,1 }, { 87,255,249,21,29,35,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 542)
		{ { 240,244,101,147,182,176,1 }, { 90,9,167,237,216,101,1 }, { 134,182,228,211,23,135,1 }, { 211,13,219,242,200,45,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 543)
		{ { 244,0,37,19,37,72,0 }, { 29,0,148,73,240,36,0 }, { 9,82,100,82,0,23,1 }, { 18,7,201,20,128,92,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 544)
		{ { 244,111,108,190,223,216,1 }, { 119,184,183,172,245,239,0 }, { 141,253,190,155,123,23,1 }, { 123,215,154,246,142,247,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 545)
		{ { 247,104,114,223,78,225,0 }, { 149,220,199,236,211,178,1 }, { 67,185,125,167,11,119,1 }, { 166,229,155,241,157,212,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 546)
		{ { 251,140,211,46,207,23,0 }, { 192,246,61,59,219,242,0 }, { 116,121,186,101,152,239,1 }, { 39,237,238,94,55,129,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 547)
		{ { 249,145,73,232,47,176,0 }, { 40,43,85,169,92,242,1 }, { 6,250,11,201,68,207,1 }, { 167,157,74,213,106,10,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 548)
		{ { 251,204,144,194,16,228,0 }, { 196,202,68,158,152,49,1 }, { 19,132,33,132,153,239,1 }, { 198,12,188,145,41,145,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 549)
		{ { 248,252,106,92,170,113,1 }, { 126,135,231,44,27,226,1 }, { 199,42,157,43,31,143,1 }, { 163,236,26,115,240,191,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 550)
		{ { 254,15,171,22,40,191,1 }, { 251,142,140,27,183,232,1 }, { 254,138,52,106,248,63,1 }, { 139,246,236,24,184,239,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 551)
		{ { 252,66,14,134,208,220,0 }, { 37,26,36,156,179,109,0 }, { 29,133,176,184,33,31,1 }, { 91,102,156,146,44,82,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 552)
		{ { 252,124,113,120,44,31,0 }, { 89,231,207,29,112,226,0 }, { 124,26,15,71,31,31,1 }, { 35,135,92,121,243,205,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 553)
		{ { 255,159,183,150,227,134,1 }, { 219,219,188,187,159,60,0 }, { 176,227,180,246,252,255,1 }, { 30,124,238,158,237,237,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 554)
		{ { 112,127,0,71,111,110,0 }, { 76,145,94,124,245,136,1 }, { 59,123,113,0,127,7,0 }, { 136,215,159,61,68,153,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 555)
		{ { 131,238,196,68,55,228,0 }, { 204,136,83,54,73,61,1 }, { 19,246,17,17,187,224,1 }, { 222,73,54,101,8,153,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 556)
		{ { 1,32,180,5,180,95,1 }, { 14,68,170,82,97,85,0 }, { 253,22,208,22,130,64,0 }, { 85,67,37,42,145,56,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 557)
		{ { 0,59,124,20,69,167,0 }, { 48,221,155,16,69,12,1 }, { 114,209,20,31,110,0,0 }, { 152,81,4,108,221,134,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 558)
		{ { 3,79,186,190,163,12,0 }, { 248,224,176,182,167,26,0 }, { 24,98,190,174,249,96,0 }, { 44,114,182,134,131,143,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 559)
		{ { 1,86,37,1,21,142,0 }, { 64,9,152,85,96,29,0 }, { 56,212,64,82,53,64,0 }, { 92,3,85,12,200,1,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 560)
		{ { 1,143,230,168,33,42,0 }, { 72,160,153,130,46,30,1 }, { 42,66,10,179,248,192,0 }, { 188,58,32,204,130,137,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 561)
		{ { 0,175,103,1,210,134,0 }, { 64,152,171,113,14,13,0 }, { 48,165,192,115,122,128,0 }, { 88,56,71,106,140,129,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 562)
		{ { 0,217,16,247,55,249,0 }, { 28,237,80,228,237,65,1 }, { 79,246,119,132,77,128,0 }, { 193,91,147,133,91,156,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 563)
		{ { 3,240,9,255,186,56,0 }, { 184,33,98,229,169,211,1 }, { 14,46,255,200,7,224,0 }, { 229,202,211,163,66,14,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 564)
		{ { 5,92,205,107,57,177,1 }, { 107,173,81,71,128,215,1 }, { 198,206,107,89,157,80,0 }, { 245,128,241,69,90,235,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 565)
		{ { 6,109,146,36,128,158,1 }, { 195,232,42,22,39,64,0 }, { 188,128,146,36,219,48,0 }, { 1,114,52,42,11,225,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 566)
		{ { 4,166,38,247,185,66,1 }, { 95,32,250,192,139,141,0 }, { 161,78,247,178,50,144,0 }, { 88,232,129,175,130,125,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 567)
		{ { 4,196,160,187,5,176,0 }, { 81,40,144,198,200,66,1 }, { 6,208,110,130,145,144,0 }, { 161,9,177,132,138,69,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 568)
		{ { 9,4,240,102,157,166,0 }, { 64,106,249,18,193,145,1 }, { 50,220,179,7,144,72,0 }, { 196,193,164,79,171,1,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 569)
		{ { 8,63,162,23,251,204,1 }, { 94,155,178,114,167,137,0 }, { 153,239,244,34,254,8,0 }, { 72,242,167,38,236,189,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 570)
		{ { 10,107,164,59,63,71,1 }, { 158,166,154,118,196,143,0 }, { 241,126,110,18,235,40,0 }, { 120,145,183,44,178,188,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 571)
		{ { 9,147,68,160,208,252,0 }, { 4,59,33,144,44,93,1 }, { 31,133,130,145,100,200,0 }, { 221,26,4,194,110,16,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 572)
		{ { 8,210,94,4,114,98,1 }, { 46,83,9,36,11,13,1 }, { 163,39,16,61,37,136,0 }, { 216,104,18,72,101,58,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 573)
		{ { 14,39,43,135,201,75,1 }, { 231,22,186,193,167,136,0 }, { 233,73,240,234,114,56,0 }, { 8,242,193,174,180,115,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 574)
		{ { 15,42,254,150,218,227,0 }, { 181,222,171,162,131,157,1 }, { 99,173,180,191,170,120,0 }, { 220,224,162,234,189,214,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 575)
		{ { 13,94,114,56,152,3,0 }, { 81,231,169,4,2,155,0 }, { 96,12,142,39,61,88,0 }, { 108,160,16,74,243,197,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 576)
		{ { 14,87,112,167,99,99,1 }, { 207,119,153,228,133,8,1 }, { 227,99,114,135,117,56,0 }, { 136,80,147,204,247,121,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 577)
		{ { 13,106,169,220,27,63,0 }, { 49,134,218,183,33,219,1 }, { 126,108,29,202,171,88,0 }, { 237,194,118,173,176,198,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 578)
		{ { 13,118,154,128,113,208,1 }, { 111,91,18,134,2,89,0 }, { 133,199,0,172,183,88,0 }, { 77,32,48,164,109,123,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 579)
		{ { 14,124,197,35,226,204,1 }, { 207,187,35,119,160,4,0 }, { 153,163,226,81,159,56,0 }, { 16,2,247,98,110,249,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 580)
		{ { 15,139,106,20,246,21,0 }, { 185,150,161,48,79,89,0 }, { 84,55,148,43,104,248,0 }, { 77,121,6,66,180,206,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 581)
		{ { 13,171,134,215,206,17,1 }, { 19,150,98,226,207,220,0 }, { 196,57,245,176,234,216,0 }, { 29,249,163,163,52,228,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 582)
		{ { 15,203,199,97,60,150,1 }, { 139,170,73,87,78,221,0 }, { 180,158,67,113,233,248,0 }, { 93,185,117,73,42,232,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 583)
		{ { 14,236,63,51,174,17,1 }, { 251,230,162,101,202,196,0 }, { 196,58,230,126,27,184,0 }, { 17,169,211,34,179,239,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 584)
		{ { 17,15,152,165,71,82,0 }, { 100,240,28,226,69,88,0 }, { 37,113,82,140,248,68,0 }, { 13,81,35,156,7,147,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 585)
		{ { 17,119,210,131,226,153,0 }, { 72,93,39,230,166,88,0 }, { 76,163,224,165,247,68,0 }, { 13,50,179,242,93,9,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 586)
		{ { 17,151,181,190,81,161,0 }, { 80,125,148,131,141,31,1 }, { 66,197,62,214,244,196,0 }, { 252,88,224,148,223,5,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 587)
		{ { 18,155,152,58,105,111,1 }, { 190,245,28,18,172,138,1 }, { 251,75,46,12,236,164,0 }, { 168,154,164,28,87,190,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 588)
		{ { 19,233,65,189,245,218,0 }, { 156,184,63,197,109,83,0 }, { 45,215,222,193,75,228,0 }, { 101,91,81,254,14,156,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 589)
		{ { 22,13,83,212,169,87,0 }, { 221,196,125,145,7,192,0 }, { 117,74,149,229,88,52,0 }, { 1,240,68,223,17,221,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 590)
		{ { 22,61,21,111,231,73,0 }, { 205,245,118,97,229,6,0 }, { 73,115,251,84,94,52,0 }, { 48,83,195,55,87,217,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 591)
		{ { 20,130,100,0,95,151,1 }, { 3,28,157,48,72,205,0 }, { 244,253,0,19,32,148,0 }, { 89,137,6,92,156,96,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 592)
		{ { 21,130,161,143,42,56,1 }, { 11,0,132,227,169,218,1 }, { 142,42,120,194,160,212,0 }, { 173,202,227,144,128,104,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 593)
		{ { 21,153,34,53,74,250,0 }, { 21,185,140,96,47,208,1 }, { 47,169,86,34,76,212,0 }, { 133,250,3,24,206,212,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 594)
		{ { 23,156,89,25,214,46,0 }, { 241,209,45,113,104,19,1 }, { 58,53,204,77,28,244,0 }, { 228,11,71,90,69,199,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 595)
		{ { 21,165,87,175,25,244,1 }, { 71,104,23,209,143,215,1 }, { 151,204,122,245,82,212,0 }, { 245,248,197,244,11,113,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 596)
		{ { 22,185,129,147,151,243,0 }, { 149,141,62,227,204,65,1 }, { 103,244,228,192,206,180,0 }, { 193,25,227,190,88,212,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 597)
		{ { 20,212,174,31,83,198,0 }, { 117,25,156,118,139,7,0 }, { 49,229,124,58,149,148,0 }, { 112,104,183,28,204,87,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 598)
		{ { 22,222,188,166,177,46,1 }, { 235,225,188,150,169,13,1 }, { 186,70,178,158,189,180,0 }, { 216,74,180,158,195,235,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 599)
		{ { 21,215,231,50,136,117,0 }, { 85,37,165,23,142,220,1 }, { 87,8,166,115,245,212,0 }, { 157,184,244,82,210,85,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 600)
		{ { 27,5,137,184,14,199,1 }, { 246,46,12,179,68,146,0 }, { 241,184,14,200,208,108,0 }, { 36,145,102,152,58,55,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 601)
		{ { 24,76,13,17,16,216,1 }, { 118,138,4,69,32,69,0 }, { 141,132,68,88,25,12,0 }, { 81,2,81,16,40,183,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 602)
		{ { 27,80,19,3,222,147,1 }, { 130,95,44,101,194,209,0 }, { 228,189,224,100,5,108,0 }, { 69,161,211,26,125,32,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 603)
		{ { 26,117,67,117,230,58,0 }, { 216,51,111,101,103,64,1 }, { 46,51,215,97,87,44,0 }, { 129,115,83,123,102,13,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 604)
		{ { 25,139,44,109,101,206,0 }, { 44,186,220,80,109,30,0 }, { 57,211,91,26,104,204,0 }, { 60,91,5,29,174,154,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 605)
		{ { 24,157,237,154,191,3,0 }, { 120,135,189,163,204,135,0 }, { 96,126,172,219,220,140,0 }, { 112,153,226,222,240,143,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 606)
		{ { 26,163,189,21,22,74,1 }, { 182,66,142,99,109,13,0 }, { 169,52,84,94,226,172,0 }, { 88,91,99,56,161,54,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 607)
		{ { 24,191,221,217,136,80,1 }, { 118,195,103,195,12,206,0 }, { 133,8,205,221,254,140,0 }, { 57,152,97,243,97,183,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 608)
		{ { 26,187,197,128,248,166,1 }, { 138,155,47,147,12,141,1 }, { 178,143,128,209,238,172,0 }, { 216,152,100,250,108,168,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 609)
		{ { 24,202,200,115,174,12,1 }, { 58,162,101,118,232,136,0 }, { 152,58,231,9,169,140,0 }, { 8,139,183,83,34,174,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 610)
		{ { 26,251,85,224,195,153,1 }, { 130,255,119,165,44,76,0 }, { 204,225,131,213,111,172,0 }, { 25,26,82,247,127,160,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 611)
		{ { 25,252,172,250,123,235,0 }, { 124,191,222,166,168,151,1 }, { 107,239,47,154,159,204,0 }, { 244,138,178,189,254,159,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 612)
		{ { 31,33,77,51,43,129,0 }, { 185,46,23,97,132,148,0 }, { 64,234,102,89,66,124,0 }, { 20,144,195,116,58,78,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 613)
		{ { 29,104,97,97,80,45,1 }, { 3,182,199,85,32,17,1 }, { 218,5,67,67,11,92,0 }, { 196,2,85,113,182,224,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 614)
		{ { 29,113,17,105,159,205,1 }, { 7,111,118,117,100,147,0 }, { 217,252,203,68,71,92,0 }, { 100,147,87,55,123,112,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 615)
		{ { 28,115,52,93,58,61,1 }, { 27,71,198,116,37,207,1 }, { 222,46,93,22,103,28,0 }, { 249,210,23,49,241,108,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 616)
		{ { 30,167,7,22,61,22,1 }, { 219,2,30,17,207,205,0 }, { 180,94,52,112,114,188,0 }, { 89,249,196,60,32,109,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 617)
		{ { 32,22,241,69,239,16,1 }, { 74,81,241,107,65,200,0 }, { 132,123,209,71,180,2,0 }, { 9,193,107,71,197,41,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 618)
		{ { 33,37,79,144,49,77,0 }, { 124,4,19,153,38,21,0 }, { 89,70,4,249,82,66,0 }, { 84,50,76,228,16,31,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 619)
		{ { 35,45,115,235,220,62,1 }, { 194,240,235,217,230,211,1 }, { 190,29,235,231,90,98,0 }, { 229,179,205,235,135,161,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 620)
		{ { 35,72,62,43,100,184,1 }, { 170,248,128,76,226,86,1 }, { 142,147,106,62,9,98,0 }, { 181,35,153,0,143,170,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 621)
		{ { 35,86,58,73,248,94,1 }, { 238,81,232,92,34,219,0 }, { 189,15,201,46,53,98,0 }, { 109,162,29,11,197,59,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 622)
		{ { 34,138,184,17,107,194,0 }, { 188,216,152,106,8,136,0 }, { 33,235,68,14,168,162,0 }, { 8,136,43,12,141,158,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 623)
		{ { 32,167,72,150,66,82,1 }, { 118,16,11,168,141,72,0 }, { 165,33,52,137,114,130,0 }, { 9,88,138,232,4,55,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 624)
		{ { 34,164,248,245,231,39,1 }, { 250,116,251,250,73,0,1 }, { 242,115,215,143,146,162,0 }, { 128,73,47,239,151,47,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 625)
		{ { 33,239,227,53,220,27,1 }, { 82,180,171,79,111,217,0 }, { 236,29,214,99,251,194,0 }, { 77,251,121,106,150,165,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 626)
		{ { 33,255,170,148,240,254,0 }, { 124,153,170,158,47,89,1 }, { 63,135,148,170,255,194,0 }, { 205,122,60,170,204,159,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 627)
		{ { 37,48,68,183,73,106,0 }, { 21,49,27,200,161,148,1 }, { 43,73,118,145,6,82,0 }, { 148,194,137,236,70,84,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 628)
		{ { 38,55,142,202,57,200,0 }, { 237,9,82,138,166,143,0 }, { 9,206,41,184,246,50,0 }, { 120,178,168,165,72,91,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 629)
		{ { 39,67,65,27,226,165,0 }, { 153,28,33,125,132,26,1 }, { 82,163,236,65,97,114,0 }, { 172,16,223,66,28,76,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 630)
		{ { 39,119,180,37,12,229,0 }, { 197,109,130,94,69,156,1 }, { 83,152,82,22,247,114,0 }, { 156,209,61,32,219,81,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 631)
		{ { 36,140,97,44,211,5,0 }, { 65,180,177,57,9,3,0 }, { 80,101,154,67,24,146,0 }, { 96,72,78,70,150,193,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 632)
		{ { 39,181,134,58,242,110,1 }, { 223,49,42,58,174,23,1 }, { 187,39,174,48,214,242,0 }, { 244,58,174,42,70,125,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 633)
		{ { 37,192,47,169,170,233,1 }, { 47,44,160,237,42,150,1 }, { 203,170,202,250,1,210,0 }, { 180,170,91,130,154,122,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 634)
		{ { 37,193,244,243,24,172,1 }, { 19,104,193,222,172,149,1 }, { 154,140,103,151,193,210,0 }, { 212,154,189,193,139,100,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 635)
		{ { 38,223,180,89,168,216,1 }, { 223,201,224,78,44,206,0 }, { 141,138,205,22,253,178,0 }, { 57,154,57,3,201,253,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 636)
		{ { 36,229,181,254,134,140,0 }, { 81,104,226,191,237,6,0 }, { 24,176,191,214,211,146,0 }, { 48,91,254,163,139,69,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 637)
		{ { 36,250,147,106,49,84,1 }, { 15,225,82,31,138,75,0 }, { 149,70,43,100,175,146,0 }, { 105,40,252,37,67,248,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 638)
		{ { 41,33,120,64,98,223,1 }, { 46,94,203,56,36,80,0 }, { 253,163,1,15,66,74,0 }, { 5,18,14,105,189,58,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 639)
		{ { 42,47,218,50,70,201,1 }, { 246,254,3,42,230,8,0 }, { 201,177,38,45,250,42,0 }, { 8,51,170,96,63,183,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 640)
		{ { 40,62,63,42,103,4,0 }, { 104,243,146,57,194,14,0 }, { 16,115,42,126,62,10,0 }, { 56,33,206,36,231,139,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 641)
		{ { 43,205,185,118,1,186,0 }, { 240,234,216,15,173,80,1 }, { 46,192,55,78,217,234,0 }, { 133,90,248,13,171,135,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 642)
		{ { 40,234,218,205,222,126,1 }, { 38,210,107,254,107,203,1 }, { 191,61,217,173,171,138,0 }, { 233,235,63,235,37,178,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 643)
		{ { 44,77,140,242,231,58,1 }, { 123,178,120,174,228,68,1 }, { 174,115,167,152,217,26,0 }, { 145,19,186,143,38,239,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 644)
		{ { 46,88,0,228,62,206,0 }, { 141,171,72,188,97,129,0 }, { 57,190,19,128,13,58,0 }, { 64,195,30,137,106,216,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 645)
		{ { 45,129,187,116,79,227,1 }, { 55,126,216,43,79,144,1 }, { 227,249,23,110,192,218,0 }, { 132,249,106,13,191,118,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 646)
		{ { 44,145,67,129,237,29,0 }, { 9,23,49,217,110,192,0 }, { 92,91,192,225,68,154,0 }, { 1,187,77,198,116,72,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 647)
		{ { 45,180,8,215,116,177,1 }, { 123,31,66,200,201,81,1 }, { 198,151,117,136,22,218,0 }, { 197,73,137,161,124,111,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 648)
		{ { 44,224,23,61,89,3,1 }, { 19,118,26,77,11,135,0 }, { 224,77,94,116,3,154,0 }, { 112,232,89,44,55,100,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 649)
		{ { 48,9,23,86,236,208,1 }, { 30,216,100,9,199,196,0 }, { 133,155,181,116,72,6,0 }, { 17,241,200,19,13,188,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 650)
		{ { 51,70,13,15,126,150,0 }, { 232,24,12,125,193,223,0 }, { 52,191,120,88,49,102,0 }, { 125,193,223,24,12,11,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 651)
		{ { 50,113,60,116,164,89,0 }, { 188,101,230,12,101,68,0 }, { 77,18,151,30,71,38,0 }, { 17,83,24,51,211,30,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 652)
		{ { 48,167,239,179,52,231,1 }, { 126,44,143,219,206,13,1 }, { 243,150,102,251,242,134,0 }, { 216,57,237,248,154,63,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 653)
		{ { 48,183,244,73,95,202,0 }, { 68,89,223,106,108,143,0 }, { 41,253,73,23,246,134,0 }, { 120,155,43,125,205,17,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 654)
		{ { 51,236,16,56,154,82,0 }, { 212,224,46,44,8,211,0 }, { 37,44,142,4,27,230,0 }, { 101,136,26,58,3,149,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 655)
		{ { 53,106,133,153,65,91,0 }, { 21,148,30,207,32,94,0 }, { 109,65,76,208,171,86,0 }, { 61,2,121,188,20,212,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 656)
		{ { 54,125,199,249,16,137,1 }, { 211,173,71,207,38,7,0 }, { 200,132,79,241,223,54,0 }, { 112,50,121,241,90,229,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 657)
		{ { 53,145,236,15,52,5,1 }, { 43,5,133,90,205,23,0 }, { 208,22,120,27,196,214,0 }, { 116,89,173,80,208,106,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 658)
		{ { 58,31,122,71,185,141,0 }, { 232,207,245,88,167,137,0 }, { 88,206,241,47,124,46,0 }, { 72,242,141,87,249,139,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 659)
		{ { 58,86,77,209,166,203,1 }, { 254,15,109,237,96,12,0 }, { 233,178,197,217,53,46,0 }, { 24,3,91,219,120,63,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 660)
		{ { 57,105,99,159,57,176,1 }, { 26,138,151,205,135,211,1 }, { 134,206,124,227,75,78,0 }, { 229,240,217,244,168,172,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 661)
		{ { 59,96,103,17,227,243,0 }, { 156,30,191,109,2,84,1 }, { 103,227,196,115,3,110,0 }, { 149,32,91,126,188,28,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 662)
		{ { 57,204,214,65,214,205,1 }, { 70,222,101,126,106,21,0 }, { 217,181,193,53,153,206,0 }, { 84,43,63,83,61,177,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 663)
		{ { 60,51,21,240,128,231,0 }, { 21,111,110,153,4,12,1 }, { 115,128,135,212,102,30,0 }, { 152,16,76,187,123,84,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 664)
		{ { 60,51,197,75,3,115,1 }, { 7,7,95,107,132,78,1 }, { 231,96,105,81,230,30,0 }, { 185,16,235,125,112,112,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 665)
		{ { 61,98,186,75,99,200,0 }, { 45,90,214,110,162,26,0 }, { 9,227,105,46,163,94,0 }, { 44,34,187,53,173,90,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 666)
		{ { 61,117,9,162,109,95,1 }, { 111,55,30,157,228,208,0 }, { 253,91,34,200,87,94,0 }, { 5,147,220,188,118,123,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 667)
		{ { 63,152,179,12,62,51,1 }, { 139,199,140,43,75,211,1 }, { 230,62,24,102,140,254,0 }, { 229,233,106,24,241,232,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 668)
		{ { 62,205,175,189,212,43,0 }, { 241,182,172,207,111,7,1 }, { 106,21,222,250,217,190,0 }, { 240,123,121,154,182,199,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 669)
		{ { 63,213,180,83,119,231,1 }, { 223,95,220,126,204,21,1 }, { 243,247,101,22,213,254,0 }, { 212,25,191,29,253,125,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 670)
		{ { 60,233,181,48,105,180,0 }, { 25,250,150,31,12,196,1 }, { 22,203,6,86,203,158,0 }, { 145,152,124,52,175,204,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 671)
		{ { 64,3,93,254,66,40,1 }, { 50,112,65,161,181,14,1 }, { 138,33,63,221,96,1,0 }, { 184,86,194,193,7,38,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 672)
		{ { 67,106,171,8,205,110,1 }, { 166,144,186,23,114,154,1 }, { 187,89,136,106,171,97,0 }, { 172,167,116,46,132,178,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 673)
		{ { 67,113,229,169,206,30,1 }, { 130,49,171,247,116,214,0 }, { 188,57,202,211,199,97,0 }, { 53,151,119,234,198,32,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 674)
		{ { 65,168,233,191,52,145,0 }, { 56,172,131,195,217,83,0 }, { 68,150,126,203,138,193,0 }, { 101,77,225,224,154,142,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 675)
		{ { 65,202,197,166,227,19,0 }, { 8,180,57,167,153,92,0 }, { 100,99,178,209,169,193,0 }, { 29,76,242,206,22,136,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 676)
		{ { 66,247,60,189,2,52,0 }, { 240,97,130,244,29,78,1 }, { 22,32,94,158,119,161,0 }, { 185,92,23,160,195,7,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 677)
		{ { 68,39,29,179,182,219,1 }, { 127,108,42,225,244,77,0 }, { 237,182,230,220,114,17,0 }, { 89,23,195,170,27,127,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 678)
		{ { 68,76,27,64,24,97,1 }, { 103,196,64,5,18,129,1 }, { 195,12,1,108,25,17,0 }, { 192,164,80,1,17,243,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 679)
		{ { 70,74,152,175,201,220,0 }, { 165,248,48,214,177,202,0 }, { 29,201,250,140,169,49,0 }, { 41,198,181,134,15,210,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 680)
		{ { 70,131,6,249,199,224,1 }, { 151,56,112,224,94,14,1 }, { 131,241,207,176,96,177,0 }, { 184,61,3,135,14,116,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 681)
		{ { 68,140,202,221,114,250,1 }, { 127,152,73,226,59,67,1 }, { 175,167,93,169,152,145,0 }, { 225,110,35,201,12,255,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 682)
		{ { 70,158,58,59,116,65,1 }, { 255,245,128,64,218,11,0 }, { 193,23,110,46,60,177,0 }, { 104,45,129,0,215,255,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 683)
		{ { 73,31,143,197,190,227,0 }, { 108,143,104,227,87,157,1 }, { 99,190,209,248,252,73,0 }, { 220,245,99,139,120,155,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 684)
		{ { 73,75,34,203,253,35,1 }, { 10,150,248,196,214,155,1 }, { 226,95,233,162,105,73,0 }, { 236,181,145,143,180,168,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 685)
		{ { 73,91,8,111,19,202,1 }, { 38,171,88,100,181,27,0 }, { 169,228,123,8,109,73,0 }, { 108,86,147,13,106,178,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 686)
		{ { 74,177,68,70,10,33,1 }, { 130,7,67,32,157,132,1 }, { 194,40,49,17,70,169,0 }, { 144,220,130,97,112,32,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 687)
		{ { 75,195,24,213,28,201,0 }, { 180,78,64,196,125,153,0 }, { 73,156,85,140,97,233,0 }, { 76,223,17,129,57,22,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 688)
		{ { 76,116,244,77,39,23,1 }, { 75,71,219,118,81,70,0 }, { 244,114,89,23,151,25,0 }, { 49,69,55,109,241,105,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 689)
		{ { 78,157,120,2,250,136,1 }, { 235,219,161,32,188,129,0 }, { 136,175,160,15,92,185,0 }, { 64,158,130,66,237,235,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 690)
		{ { 79,168,131,36,88,72,0 }, { 133,178,2,3,59,145,0 }, { 9,13,18,96,138,249,0 }, { 68,238,96,32,38,208,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 691)
		{ { 77,204,62,66,47,44,0 }, { 105,194,208,52,250,148,1 }, { 26,122,33,62,25,217,0 }, { 148,175,150,5,161,203,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 692)
		{ { 77,205,182,47,105,192,1 }, { 79,250,144,70,159,150,0 }, { 129,203,122,54,217,217,0 }, { 52,252,177,4,175,249,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 693)
		{ { 76,252,81,246,35,2,0 }, { 89,227,91,165,153,0,0 }, { 32,98,55,197,31,153,0 }, { 0,76,210,237,99,205,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 694)
		{ { 77,248,189,181,78,179,0 }, { 49,255,138,231,89,212,1 }, { 102,185,86,222,143,217,0 }, { 149,205,115,168,255,198,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 695)
		{ { 78,254,206,197,81,2,1 }, { 227,147,91,198,27,13,0 }, { 160,69,81,185,191,185,0 }, { 88,108,49,237,100,227,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 696)
		{ { 83,45,244,148,190,11,1 }, { 218,196,175,162,117,149,0 }, { 232,62,148,151,218,101,0 }, { 84,215,34,250,145,173,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 697)
		{ { 83,55,48,177,237,76,1 }, { 222,113,182,208,116,152,0 }, { 153,91,198,134,118,101,0 }, { 12,151,5,182,199,61,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 698)
		{ { 81,138,115,76,78,26,0 }, { 0,208,205,33,123,218,0 }, { 44,57,25,103,40,197,0 }, { 45,239,66,89,133,128,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 699)
		{ { 81,173,41,83,250,51,0 }, { 120,148,238,97,156,209,1 }, { 102,47,229,74,90,197,0 }, { 197,156,195,59,148,143,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 700)
		{ { 80,244,139,181,87,23,1 }, { 114,53,30,247,91,65,0 }, { 244,117,86,232,151,133,0 }, { 65,109,119,188,86,39,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 701)
		{ { 83,242,216,169,125,63,0 }, { 168,117,31,214,120,219,1 }, { 126,95,74,141,167,229,0 }, { 237,143,53,252,87,10,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 702)
		{ { 87,46,51,92,65,229,1 }, { 215,220,214,17,19,26,1 }, { 211,193,29,102,58,117,0 }, { 172,100,68,53,157,245,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 703)
		{ { 85,97,138,153,243,43,1 }, { 59,20,62,230,54,19,1 }, { 234,103,204,168,195,85,0 }, { 228,54,51,190,20,110,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 704)
		{ { 84,114,176,221,66,144,1 }, { 19,89,198,230,17,74,0 }, { 132,161,93,134,167,21,0 }, { 41,68,51,177,205,100,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 705)
		{ { 87,120,188,172,178,210,1 }, { 175,233,174,166,17,87,0 }, { 165,166,154,158,143,117,0 }, { 117,68,50,186,203,250,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 706)
		{ { 85,178,111,85,255,238,1 }, { 63,25,255,113,123,157,1 }, { 187,255,213,123,38,213,0 }, { 220,239,71,127,204,126,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 707)
		{ { 87,215,193,128,15,12,1 }, { 195,1,21,183,124,152,0 }, { 152,120,0,193,245,245,0 }, { 12,159,118,212,64,97,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 708)
		{ { 85,243,37,159,247,53,0 }, { 25,21,182,245,221,95,1 }, { 86,119,252,210,103,213,0 }, { 253,93,215,182,212,76,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 709)
		{ { 90,0,169,237,210,158,0 }, { 160,58,236,243,49,67,0 }, { 60,165,219,202,128,45,0 }, { 97,70,103,155,174,2,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 710)
		{ { 89,39,61,104,89,78,1 }, { 102,114,222,17,52,159,0 }, { 185,77,11,94,114,77,0 }, { 124,150,68,61,167,51,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 711)
		{ { 89,73,179,211,30,79,0 }, { 20,198,204,247,246,145,0 }, { 121,60,101,230,201,77,0 }, { 68,183,247,153,177,148,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 712)
		{ { 91,92,30,37,185,241,1 }, { 238,239,52,68,19,213,1 }, { 199,206,210,60,29,109,0 }, { 213,228,17,22,123,187,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 713)
		{ { 89,81,133,145,139,249,0 }, { 20,15,52,231,52,212,1 }, { 79,232,196,208,197,77,0 }, { 149,150,115,150,120,20,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 714)
		{ { 91,156,92,115,202,248,1 }, { 246,251,101,96,184,212,1 }, { 143,169,231,29,28,237,0 }, { 149,142,131,83,111,183,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 715)
		{ { 90,148,209,233,34,152,1 }, { 202,107,69,227,56,66,0 }, { 140,162,75,197,148,173,0 }, { 33,14,99,209,107,41,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 716)
		{ { 88,170,155,107,27,52,0 }, { 32,226,86,115,154,203,1 }, { 22,108,107,108,170,141,0 }, { 233,172,231,53,35,130,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 717)
		{ { 90,202,163,22,250,87,1 }, { 158,150,172,55,155,201,0 }, { 245,47,180,98,169,173,0 }, { 73,236,246,26,180,188,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 718)
		{ { 88,216,190,3,241,57,0 }, { 40,215,180,70,186,69,1 }, { 78,71,224,62,141,141,0 }, { 209,46,177,22,245,138,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 719)
		{ { 90,253,27,96,216,252,0 }, { 228,251,102,21,62,193,1 }, { 31,141,131,108,95,173,0 }, { 193,190,84,51,111,147,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 720)
		{ { 93,40,12,244,83,170,1 }, { 51,186,94,160,49,21,1 }, { 170,229,23,152,10,93,0 }, { 212,70,2,189,46,230,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 721)
		{ { 94,52,215,24,145,91,0 }, { 213,71,63,3,50,71,0 }, { 109,68,140,117,150,61,0 }, { 113,38,96,126,113,85,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 722)
		{ { 94,140,231,129,51,103,0 }, { 205,134,157,243,26,5,1 }, { 115,102,64,243,152,189,0 }, { 208,44,103,220,176,217,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 723)
		{ { 92,240,52,170,32,5,0 }, { 9,103,134,148,152,6,0 }, { 80,2,42,150,7,157,0 }, { 48,12,148,176,243,72,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 724)
		{ { 99,47,8,198,1,227,0 }, { 228,140,90,136,149,24,1 }, { 99,192,49,136,122,99,0 }, { 140,84,136,173,24,147,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 725)
		{ { 97,34,240,131,154,222,0 }, { 4,72,171,250,176,217,0 }, { 61,172,224,135,162,67,0 }, { 77,134,175,234,137,16,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 726)
		{ { 97,64,6,28,66,91,1 }, { 22,20,8,44,51,86,0 }, { 237,33,28,48,1,67,0 }, { 53,102,26,8,20,52,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 727)
		{ { 99,104,252,248,31,16,0 }, { 176,224,211,174,80,215,0 }, { 4,124,15,159,139,99,0 }, { 117,133,58,229,131,134,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 728)
		{ { 98,163,80,160,5,206,1 }, { 134,104,27,152,124,8,0 }, { 185,208,2,133,98,163,0 }, { 8,31,12,236,11,48,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 729)
		{ { 96,207,8,137,207,134,1 }, { 98,152,56,252,92,138,0 }, { 176,249,200,136,121,131,0 }, { 40,157,31,142,12,163,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 730)
		{ { 100,31,102,147,38,250,0 }, { 93,137,137,232,246,76,1 }, { 47,178,100,179,124,19,0 }, { 153,55,139,200,200,221,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 731)
		{ { 103,84,36,66,155,194,1 }, { 199,9,248,44,144,149,0 }, { 161,236,161,18,21,115,0 }, { 84,132,154,15,200,113,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 732)
		{ { 103,94,109,245,161,167,0 }, { 249,173,249,221,17,28,1 }, { 114,194,215,219,61,115,0 }, { 156,68,93,207,218,207,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 733)
		{ { 100,112,128,63,112,33,0 }, { 25,53,2,78,145,3,1 }, { 66,7,126,0,135,19,0 }, { 224,68,185,32,86,76,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 734)
		{ { 101,113,143,62,145,182,1 }, { 51,41,58,31,151,87,1 }, { 182,196,190,120,199,83,0 }, { 245,116,252,46,74,102,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 735)
		{ { 103,153,192,236,194,232,1 }, { 135,185,97,170,61,18,1 }, { 139,161,155,129,204,243,0 }, { 164,94,42,195,78,240,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 736)
		{ { 102,181,191,1,79,214,0 }, { 229,89,154,123,94,196,0 }, { 53,249,64,126,214,179,0 }, { 17,189,111,44,205,83,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 737)
		{ { 103,209,57,91,135,184,0 }, { 177,73,240,109,252,82,1 }, { 14,240,237,78,69,243,0 }, { 165,31,219,7,201,70,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 738)
		{ { 101,214,185,83,116,18,0 }, { 121,81,200,79,216,89,0 }, { 36,23,101,78,181,211,0 }, { 77,13,249,9,197,79,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 739)
		{ { 107,53,69,174,190,183,0 }, { 200,47,43,185,213,215,1 }, { 118,190,186,209,86,107,0 }, { 245,213,206,234,122,9,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 740)
		{ { 106,85,31,116,156,15,1 }, { 242,103,104,29,119,133,0 }, { 248,28,151,124,85,43,0 }, { 80,247,92,11,115,39,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 741)
		{ { 105,214,240,35,1,52,0 }, { 64,99,145,94,152,88,1 }, { 22,64,98,7,181,203,0 }, { 141,12,189,68,227,1,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 742)
		{ { 107,214,206,166,84,232,1 }, { 230,59,1,142,251,29,1 }, { 139,149,50,185,181,235,0 }, { 220,111,184,192,110,51,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 743)
		{ { 108,83,126,168,65,235,0 }, { 37,127,153,140,54,14,1 }, { 107,193,10,191,101,27,0 }, { 184,54,24,204,255,82,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 744)
		{ { 110,99,164,20,64,36,1 }, { 147,18,130,30,21,12,1 }, { 146,1,20,18,227,59,0 }, { 152,84,60,32,164,100,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 745)
		{ { 108,120,204,22,132,88,1 }, { 55,131,35,14,241,68,0 }, { 141,16,180,25,143,27,0 }, { 17,71,184,98,96,246,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 746)
		{ { 108,206,226,122,51,47,0 }, { 89,166,217,62,186,11,1 }, { 122,102,47,35,185,155,0 }, { 232,46,190,77,178,205,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 747)
		{ { 111,226,98,8,71,155,0 }, { 129,30,155,44,122,90,0 }, { 108,241,8,35,35,251,0 }, { 45,47,26,108,188,64,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 748)
		{ { 113,2,15,225,198,243,0 }, { 36,60,108,233,82,92,1 }, { 103,177,195,248,32,71,0 }, { 157,37,75,155,30,18,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 749)
		{ { 113,1,66,223,219,44,0 }, { 16,16,117,248,183,147,1 }, { 26,109,253,161,64,71,0 }, { 228,246,143,215,4,4,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 750)
		{ { 114,10,186,206,130,96,0 }, { 164,192,228,170,147,10,1 }, { 3,32,185,174,168,39,0 }, { 168,100,170,147,129,146,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 751)
		{ { 114,76,255,13,215,153,0 }, { 224,220,181,111,115,71,0 }, { 76,245,216,127,153,39,0 }, { 113,103,123,86,157,131,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 752)
		{ { 112,148,200,167,175,228,0 }, { 108,41,53,250,217,128,1 }, { 19,250,242,137,148,135,0 }, { 128,205,175,214,74,27,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 753)
		{ { 115,219,92,88,31,37,1 }, { 178,197,85,60,92,159,1 }, { 210,124,13,29,109,231,0 }, { 252,157,30,85,81,166,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 754)
		{ { 113,220,240,226,63,213,1 }, { 78,237,213,190,216,209,0 }, { 213,254,35,135,157,199,0 }, { 69,141,190,213,219,185,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 755)
		{ { 115,240,217,222,113,35,1 }, { 186,85,95,143,153,19,1 }, { 226,71,61,205,135,231,0 }, { 228,76,248,253,85,46,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 756)
		{ { 117,16,178,106,60,109,0 }, { 13,101,196,26,242,147,1 }, { 91,30,43,38,132,87,0 }, { 228,167,172,17,211,88,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 757)
		{ { 117,125,232,146,6,63,0 }, { 113,133,143,190,244,80,1 }, { 126,48,36,139,223,87,0 }, { 133,23,190,248,208,199,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 758)
		{ { 116,159,153,133,17,253,0 }, { 101,205,20,219,61,73,1 }, { 95,196,80,204,252,151,0 }, { 201,94,109,148,89,211,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 759)
		{ { 122,14,219,24,154,237,0 }, { 244,206,37,59,50,139,1 }, { 91,172,140,109,184,47,0 }, { 232,166,110,82,57,151,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 760)
		{ { 121,22,143,58,72,165,1 }, { 114,63,4,27,146,158,1 }, { 210,137,46,120,180,79,0 }, { 188,164,236,16,126,39,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 761)
		{ { 121,188,129,6,112,53,0 }, { 72,151,6,27,153,81,1 }, { 86,7,48,64,158,207,0 }, { 197,76,236,48,116,137,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 762)
		{ { 125,77,194,163,143,129,1 }, { 67,174,53,238,214,144,0 }, { 192,248,226,161,217,95,0 }, { 4,181,187,214,58,225,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 763)
		{ { 124,135,26,99,181,78,0 }, { 109,98,124,88,254,9,0 }, { 57,86,227,44,112,159,0 }, { 72,63,141,31,35,91,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 764)
		{ { 127,162,123,214,2,146,1 }, { 179,74,207,169,155,88,0 }, { 164,160,53,239,34,255,0 }, { 13,108,202,249,169,102,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 765)
		{ { 125,171,223,59,221,197,1 }, { 55,254,55,91,222,159,0 }, { 209,221,238,125,234,223,0 }, { 124,189,237,118,63,246,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 766)
		{ { 125,187,65,173,85,124,1 }, { 7,179,23,217,125,91,1 }, { 159,85,90,193,110,223,0 }, { 237,95,77,244,102,240,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 767)
		{ { 131,4,66,138,233,199,0 }, { 204,28,57,144,130,178,0 }, { 113,203,168,161,16,96,1 }, { 38,160,132,206,28,25,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 768)
		{ { 131,43,42,216,218,107,1 }, { 182,148,234,160,38,187,1 }, { 235,45,141,170,106,96,1 }, { 238,178,2,171,148,182,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 769)
		{ { 129,42,82,146,228,127,0 }, { 28,212,43,144,226,120,1 }, { 127,19,164,165,42,64,1 }, { 143,35,132,234,21,156,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 770)
		{ { 129,56,22,164,149,242,0 }, { 4,233,58,128,67,117,1 }, { 39,212,146,180,14,64,1 }, { 215,97,0,174,75,144,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 771)
		{ { 129,100,221,191,156,110,1 }, { 118,96,43,215,225,183,1 }, { 187,28,254,221,147,64,1 }, { 246,195,245,234,3,55,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 772)
		{ { 129,123,93,252,187,253,1 }, { 62,237,115,181,37,255,1 }, { 223,238,159,221,111,64,1 }, { 255,210,86,231,91,190,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 773)
		{ { 130,178,225,68,80,78,0 }, { 132,17,203,19,41,41,0 }, { 57,5,17,67,166,160,1 }, { 74,74,100,105,196,16,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 774)
		{ { 128,247,188,97,25,21,0 }, { 96,101,210,86,12,237,0 }, { 84,76,67,30,247,128,1 }, { 91,152,53,37,211,3,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 775)
		{ { 135,52,106,165,125,200,0 }, { 237,57,147,192,99,177,0 }, { 9,223,82,171,22,112,1 }, { 70,227,1,228,206,91,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 776)
		{ { 132,140,23,210,149,239,1 }, { 87,204,120,145,234,37,1 }, { 251,212,165,244,24,144,1 }, { 210,43,196,143,25,245,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 777)
		{ { 132,150,182,186,170,44,0 }, { 89,97,160,178,170,174,1 }, { 26,42,174,182,180,144,1 }, { 186,170,166,130,195,77,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 778)
		{ { 135,156,185,242,219,180,0 }, { 241,249,240,179,136,241,1 }, { 22,237,167,206,156,240,1 }, { 199,136,230,135,207,199,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 779)
		{ { 132,196,118,79,240,21,1 }, { 75,84,225,84,139,103,0 }, { 212,7,249,55,17,144,1 }, { 115,104,149,67,149,105,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 780)
		{ { 135,196,142,129,238,18,1 }, { 235,16,40,230,74,244,0 }, { 164,59,192,184,145,240,1 }, { 23,169,51,138,4,107,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 781)
		{ { 133,225,245,45,64,89,1 }, { 7,116,131,71,45,118,0 }, { 205,1,90,87,195,208,1 }, { 55,90,113,96,151,112,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 782)
		{ { 137,14,35,66,210,193,1 }, { 70,158,224,33,130,57,0 }, { 193,165,161,98,56,72,1 }, { 78,32,194,3,188,177,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 783)
		{ { 138,56,218,197,237,134,1 }, { 170,219,123,210,67,160,0 }, { 176,219,209,173,142,40,1 }, { 2,225,37,239,109,170,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 784)
		{ { 138,149,152,168,110,21,0 }, { 232,119,0,178,76,226,0 }, { 84,59,10,140,212,168,1 }, { 35,153,38,128,119,11,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 785)
		{ { 141,29,47,20,46,123,1 }, { 127,135,136,33,103,244,1 }, { 239,58,20,122,92,88,1 }, { 151,243,66,8,240,255,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 786)
		{ { 141,111,99,41,14,170,1 }, { 67,170,139,101,102,186,1 }, { 170,184,74,99,123,88,1 }, { 174,179,83,104,170,225,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 787)
		{ { 142,178,140,83,176,124,1 }, { 191,3,98,82,168,109,1 }, { 159,6,229,24,166,184,1 }, { 219,10,165,35,96,126,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 788)
		{ { 142,222,235,43,219,30,1 }, { 227,179,185,119,170,235,0 }, { 188,109,234,107,189,184,1 }, { 107,170,247,78,230,227,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 789)
		{ { 141,245,6,243,158,250,0 }, { 85,43,106,228,238,245,1 }, { 47,188,231,176,87,216,1 }, { 215,187,147,171,106,85,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 790)
		{ { 144,23,149,47,152,143,0 }, { 64,109,44,83,165,175,0 }, { 120,140,250,84,244,4,1 }, { 122,210,229,26,91,1,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 791)
		{ { 145,35,7,27,254,232,0 }, { 28,24,38,97,230,191,1 }, { 11,191,236,112,98,68,1 }, { 254,179,195,50,12,28,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 792)
		{ { 144,37,85,177,206,2,1 }, { 82,112,47,225,68,164,0 }, { 160,57,198,213,82,4,1 }, { 18,145,67,250,7,37,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 793)
		{ { 144,40,188,66,77,232,0 }, { 36,216,214,2,224,164,1 }, { 11,217,33,30,138,4,1 }, { 146,131,160,53,141,146,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 794)
		{ { 144,57,208,138,32,54,1 }, { 10,193,15,146,132,98,1 }, { 182,2,40,133,206,4,1 }, { 163,16,164,248,65,168,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 795)
		{ { 147,79,149,211,130,90,0 }, { 212,192,108,231,164,124,0 }, { 45,32,229,212,249,100,1 }, { 31,18,243,155,1,149,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 796)
		{ { 146,164,210,234,226,74,0 }, { 204,112,111,162,170,34,0 }, { 41,35,171,165,146,164,1 }, { 34,42,162,251,7,25,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 797)
		{ { 145,180,112,9,138,92,1 }, { 70,65,167,112,40,242,0 }, { 157,40,200,7,22,196,1 }, { 39,138,7,114,193,49,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 798)
		{ { 147,222,25,219,41,219,1 }, { 254,205,92,197,168,250,0 }, { 237,202,109,204,61,228,1 }, { 47,138,209,157,89,191,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 799)
		{ { 145,229,150,87,118,92,0 }, { 92,80,70,118,239,117,0 }, { 29,55,117,52,211,196,1 }, { 87,123,183,49,5,29,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 800)
		{ { 146,236,144,218,63,135,0 }, { 216,204,94,182,200,163,0 }, { 112,254,45,132,155,164,1 }, { 98,137,182,189,25,141,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 801)
		{ { 146,252,112,168,201,176,0 }, { 192,249,183,132,8,226,1 }, { 6,201,138,135,31,164,1 }, { 163,136,16,246,207,129,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 802)
		{ { 149,25,170,136,106,158,1 }, { 43,153,140,178,38,242,0 }, { 188,171,8,170,204,84,1 }, { 39,178,38,152,204,234,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 803)
		{ { 148,82,41,183,65,127,0 }, { 53,53,156,213,161,104,1 }, { 127,65,118,202,37,20,1 }, { 139,66,213,156,214,86,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 804)
		{ { 148,87,59,92,68,38,1 }, { 115,81,204,21,71,42,1 }, { 178,17,29,110,117,20,1 }, { 170,113,84,25,197,103,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 805)
		{ { 151,82,5,249,168,20,0 }, { 153,33,100,213,0,254,0 }, { 20,10,207,208,37,116,1 }, { 63,128,85,147,66,76,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 806)
		{ { 150,156,251,61,143,160,1 }, { 243,233,181,99,75,162,1 }, { 130,248,222,111,156,180,1 }, { 162,233,99,86,203,231,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 807)
		{ { 151,163,111,26,69,144,1 }, { 179,24,151,1,206,126,0 }, { 132,209,44,123,98,244,1 }, { 63,57,192,116,140,102,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 808)
		{ { 151,170,229,229,236,98,0 }, { 141,176,239,195,73,188,1 }, { 35,27,211,211,170,244,1 }, { 158,201,97,251,134,216,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 809)
		{ { 151,229,170,59,113,88,1 }, { 255,48,150,70,174,115,0 }, { 141,71,110,42,211,244,1 }, { 103,58,177,52,134,127,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 810)
		{ { 154,32,49,130,105,146,1 }, { 138,90,158,129,128,224,0 }, { 164,203,32,198,2,44,1 }, { 3,128,192,188,173,40,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 811)
		{ { 153,69,56,75,61,53,1 }, { 106,70,212,84,196,243,1 }, { 214,94,105,14,81,76,1 }, { 231,145,149,21,177,43,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 812)
		{ { 154,177,236,143,208,111,1 }, { 166,23,175,210,173,39,1 }, { 251,5,248,155,198,172,1 }, { 242,90,165,250,244,50,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 813)
		{ { 154,213,151,178,63,108,1 }, { 222,99,20,183,238,165,1 }, { 155,126,38,244,213,172,1 }, { 210,187,246,148,99,61,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 814)
		{ { 153,249,19,79,121,230,0 }, { 12,219,94,85,143,179,1 }, { 51,207,121,100,79,204,1 }, { 230,248,213,61,109,152,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 815)
		{ { 158,24,232,0,191,106,1 }, { 175,131,189,34,96,161,1 }, { 171,126,128,11,140,60,1 }, { 194,131,34,94,224,250,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 816)
		{ { 159,72,93,163,29,40,1 }, { 163,226,21,197,224,181,1 }, { 138,92,98,221,9,124,1 }, { 214,131,209,212,35,226,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 817)
		{ { 159,84,21,142,137,140,0 }, { 193,75,52,149,161,182,0 }, { 24,200,184,212,21,124,1 }, { 54,194,212,150,105,65,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 818)
		{ { 157,106,155,82,57,78,1 }, { 63,194,94,23,162,185,0 }, { 185,78,37,108,171,92,1 }, { 78,162,244,61,33,254,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 819)
		{ { 158,111,156,10,159,118,0 }, { 229,194,62,54,196,239,1 }, { 55,124,168,28,251,60,1 }, { 251,145,182,62,33,211,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 820)
		{ { 160,9,100,5,91,91,0 }, { 4,148,153,104,37,229,0 }, { 109,109,80,19,72,2,1 }, { 83,210,11,76,148,144,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 821)
		{ { 162,60,219,252,54,178,0 }, { 248,233,75,171,67,99,1 }, { 38,182,31,237,158,34,1 }, { 227,97,106,233,75,143,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 822)
		{ { 163,91,247,118,247,143,0 }, { 152,253,249,63,231,61,0 }, { 120,247,183,119,237,98,1 }, { 94,115,254,79,223,140,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 823)
		{ { 162,157,115,18,132,59,0 }, { 208,197,169,9,238,96,1 }, { 110,16,164,103,92,162,1 }, { 131,59,200,74,209,133,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 824)
		{ { 160,206,10,169,116,87,0 }, { 108,180,8,220,74,107,0 }, { 117,23,74,168,57,130,1 }, { 107,41,29,136,22,155,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 825)
		{ { 160,220,172,38,43,179,1 }, { 106,173,152,46,137,228,1 }, { 230,234,50,26,157,130,1 }, { 147,200,186,12,218,171,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 826)
		{ { 162,245,118,116,106,43,1 }, { 218,117,203,44,47,164,1 }, { 234,43,23,55,87,162,1 }, { 146,250,26,105,215,45,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 827)
		{ { 166,47,214,238,159,142,1 }, { 195,232,123,186,231,175,0 }, { 184,252,187,181,250,50,1 }, { 122,243,174,239,11,225,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 828)
		{ { 165,56,116,248,96,115,1 }, { 31,245,203,136,0,118,1 }, { 231,3,15,151,14,82,1 }, { 183,0,8,233,215,252,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 829)
		{ { 164,94,71,141,231,74,0 }, { 77,145,57,237,99,46,0 }, { 41,115,216,241,61,18,1 }, { 58,99,91,206,68,217,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 830)
		{ { 167,93,87,124,48,116,1 }, { 223,225,65,29,7,119,1 }, { 151,6,31,117,93,114,1 }, { 247,112,92,65,67,253,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 831)
		{ { 166,114,149,34,69,134,0 }, { 129,121,26,31,192,44,0 }, { 48,209,34,84,167,50,1 }, { 26,1,252,44,79,64,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 832)
		{ { 165,131,104,82,20,90,0 }, { 53,0,201,8,236,121,0 }, { 45,20,37,11,96,210,1 }, { 79,27,136,73,128,86,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 833)
		{ { 164,155,84,147,194,3,0 }, { 17,213,41,232,140,44,0 }, { 96,33,228,149,108,146,1 }, { 26,24,139,202,85,196,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 834)
		{ { 166,189,42,131,213,14,0 }, { 225,145,186,216,238,33,0 }, { 56,85,224,170,94,178,1 }, { 66,59,141,174,196,195,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 835)
		{ { 169,7,89,5,251,125,0 }, { 108,86,49,121,37,249,1 }, { 95,111,208,77,112,74,1 }, { 207,210,79,70,53,27,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 836)
		{ { 169,21,217,154,37,235,1 }, { 126,79,25,139,228,50,1 }, { 235,210,44,205,212,74,1 }, { 166,19,232,204,121,63,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 837)
		{ { 171,34,146,112,50,2,0 }, { 152,98,74,42,2,57,0 }, { 32,38,7,36,162,106,1 }, { 78,32,42,41,35,12,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 838)
		{ { 169,55,228,166,33,245,1 }, { 78,47,147,154,133,124,1 }, { 215,194,50,147,246,74,1 }, { 159,80,172,228,250,57,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 839)
		{ { 170,114,189,81,74,123,0 }, { 180,87,202,111,32,236,1 }, { 111,41,69,94,167,42,1 }, { 155,130,123,41,245,22,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 840)
		{ { 168,137,199,107,240,9,0 }, { 8,182,97,75,174,39,0 }, { 72,7,235,113,200,138,1 }, { 114,58,233,67,54,136,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 841)
		{ { 170,213,171,110,131,212,1 }, { 230,43,240,63,143,98,0 }, { 149,224,187,106,213,170,1 }, { 35,120,254,7,234,51,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 842)
		{ { 168,211,200,181,190,175,0 }, { 56,47,41,254,109,169,1 }, { 122,190,214,137,229,138,1 }, { 202,219,63,202,122,14,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 843)
		{ { 174,20,19,54,167,164,0 }, { 217,107,48,57,195,32,1 }, { 18,242,182,100,20,58,1 }, { 130,97,206,6,107,77,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 844)
		{ { 173,100,135,249,112,220,1 }, { 95,58,66,223,34,119,0 }, { 157,135,79,240,147,90,1 }, { 119,34,125,161,46,125,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 845)
		{ { 175,121,76,217,234,209,1 }, { 191,159,99,236,4,246,0 }, { 197,171,205,153,79,122,1 }, { 55,144,27,227,124,254,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 846)
		{ { 173,154,157,184,0,254,1 }, { 55,235,8,155,40,126,1 }, { 191,128,14,220,172,218,1 }, { 191,10,108,136,107,246,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 847)
		{ { 175,156,136,245,213,82,0 }, { 245,179,120,202,73,113,0 }, { 37,85,215,136,156,250,1 }, { 71,73,41,143,102,215,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 848)
		{ { 173,207,238,79,108,35,0 }, { 105,150,201,78,207,190,1 }, { 98,27,121,59,249,218,1 }, { 190,249,185,73,180,203,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 849)
		{ { 173,247,163,231,58,61,1 }, { 75,39,194,255,175,249,1 }, { 222,46,115,226,247,218,1 }, { 207,250,255,161,242,105,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 850)
		{ { 178,65,252,215,31,187,0 }, { 176,76,221,238,229,229,1 }, { 110,252,117,159,193,38,1 }, { 211,211,187,221,153,6,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 851)
		{ { 179,66,216,120,217,241,1 }, { 182,124,117,14,0,251,1 }, { 199,205,143,13,161,102,1 }, { 239,128,56,87,31,54,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 852)
		{ { 178,97,81,226,141,99,0 }, { 132,100,127,141,196,160,1 }, { 99,88,163,197,67,38,1 }, { 130,145,216,255,19,16,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 853)
		{ { 179,99,173,194,60,10,1 }, { 170,0,206,143,228,189,0 }, { 168,30,33,218,227,102,1 }, { 94,147,248,185,128,42,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 854)
		{ { 179,122,143,78,111,189,1 }, { 170,157,86,63,227,254,1 }, { 222,251,57,120,175,102,1 }, { 191,227,254,53,92,170,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 855)
		{ { 176,177,13,218,203,9,1 }, { 50,21,118,169,172,166,0 }, { 200,105,173,216,70,134,1 }, { 50,154,202,183,84,38,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 856)
		{ { 176,187,235,133,79,183,0 }, { 32,157,159,251,79,232,1 }, { 118,249,80,235,238,134,1 }, { 139,249,111,252,220,130,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 857)
		{ { 177,195,46,176,79,2,0 }, { 48,48,156,172,78,188,0 }, { 32,121,6,186,97,198,1 }, { 30,185,26,156,134,6,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 858)
		{ { 177,202,162,122,198,206,0 }, { 20,184,236,62,234,58,0 }, { 57,177,175,34,169,198,1 }, { 46,43,190,27,142,148,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 859)
		{ { 180,119,47,73,43,245,0 }, { 109,13,214,125,6,238,1 }, { 87,234,73,122,119,22,1 }, { 187,176,95,53,216,91,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 860)
		{ { 181,174,77,39,89,131,1 }, { 99,188,31,73,137,189,0 }, { 224,205,114,89,58,214,1 }, { 94,200,201,124,30,227,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 861)
		{ { 183,210,205,142,206,219,0 }, { 165,29,45,175,233,254,0 }, { 109,185,184,217,165,246,1 }, { 63,203,250,218,92,82,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 862)
		{ { 182,235,156,93,104,151,0 }, { 185,220,78,94,13,238,0 }, { 116,139,93,28,235,182,1 }, { 59,216,61,57,29,206,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 863)
		{ { 180,244,103,243,78,87,0 }, { 85,53,207,253,202,228,0 }, { 117,57,103,243,23,150,1 }, { 19,169,223,249,214,85,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 864)
		{ { 184,15,212,222,49,7,1 }, { 90,198,93,154,133,47,0 }, { 240,70,61,149,248,14,1 }, { 122,80,172,221,49,173,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 865)
		{ { 184,57,126,65,128,2,0 }, { 32,195,239,72,6,36,0 }, { 32,0,193,63,78,14,1 }, { 18,48,9,123,225,130,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 866)
		{ { 184,56,131,182,233,190,0 }, { 24,187,62,155,163,224,1 }, { 62,203,182,224,142,14,1 }, { 131,226,236,190,110,140,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 867)
		{ { 184,108,6,172,40,232,0 }, { 76,170,6,140,35,166,1 }, { 11,138,26,176,27,14,1 }, { 178,226,24,176,42,153,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 868)
		{ { 185,136,183,154,126,192,1 }, { 30,218,132,171,202,183,0 }, { 129,191,44,246,136,206,1 }, { 118,169,234,144,173,188,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 869)
		{ { 184,156,165,183,60,206,0 }, { 92,171,140,219,233,165,0 }, { 57,158,118,210,156,142,1 }, { 82,203,237,152,234,157,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 870)
		{ { 186,207,131,167,229,28,1 }, { 202,178,52,223,239,104,0 }, { 156,83,242,224,249,174,1 }, { 11,123,253,150,38,169,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 871)
		{ { 184,231,17,147,88,172,1 }, { 82,90,6,221,172,169,1 }, { 154,141,100,196,115,142,1 }, { 202,154,221,176,45,37,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 872)
		{ { 189,114,116,100,13,206,1 }, { 7,107,223,28,97,188,0 }, { 185,216,19,23,39,94,1 }, { 30,195,28,125,235,112,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 873)
		{ { 188,125,134,57,75,186,1 }, { 83,187,30,110,38,230,1 }, { 174,233,78,48,223,30,1 }, { 179,178,59,60,110,229,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 874)
		{ { 195,30,73,175,1,169,1 }, { 226,173,17,193,177,58,1 }, { 202,192,122,201,60,97,1 }, { 174,70,193,196,90,163,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 875)
		{ { 192,46,91,239,41,95,0 }, { 108,228,91,209,179,234,0 }, { 125,74,123,237,58,1,1 }, { 43,230,197,237,19,155,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 876)
		{ { 193,78,242,15,34,121,1 }, { 78,196,129,102,179,122,1 }, { 207,34,120,39,185,65,1 }, { 175,102,179,64,145,185,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 877)
		{ { 193,129,72,108,154,70,1 }, { 38,32,105,48,29,179,0 }, { 177,44,155,9,64,193,1 }, { 102,220,6,75,2,50,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 878)
		{ { 193,153,177,237,205,191,1 }, { 2,253,248,211,125,242,1 }, { 254,217,219,198,204,193,1 }, { 167,223,101,143,223,160,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 879)
		{ { 193,146,177,38,19,223,1 }, { 6,109,152,51,185,121,0 }, { 253,228,50,70,164,193,1 }, { 79,78,230,12,219,48,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 880)
		{ { 195,183,213,56,210,51,1 }, { 210,117,43,35,28,127,1 }, { 230,37,142,85,246,225,1 }, { 255,28,98,106,87,37,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 881)
		{ { 193,215,25,188,235,129,1 }, { 122,125,48,165,29,186,0 }, { 192,235,158,204,117,193,1 }, { 46,220,82,134,95,47,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 882)
		{ { 193,246,67,78,186,232,1 }, { 78,9,99,37,187,187,1 }, { 139,174,185,97,55,193,1 }, { 238,238,210,99,72,57,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 883)
		{ { 196,56,145,7,35,108,1 }, { 15,193,18,115,177,32,1 }, { 155,98,112,68,142,17,1 }, { 130,70,231,36,65,248,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 884)
		{ { 198,77,74,227,205,183,0 }, { 225,188,121,212,214,224,1 }, { 118,217,227,169,89,49,1 }, { 131,181,149,207,30,195,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 885)
		{ { 199,83,172,246,95,75,1 }, { 183,53,216,166,245,189,0 }, { 233,125,55,154,229,113,1 }, { 94,215,178,141,214,118,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 886)
		{ { 197,126,74,113,2,75,0 }, { 117,165,75,100,50,56,0 }, { 105,32,71,41,63,81,1 }, { 14,38,19,105,82,215,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 887)
		{ { 198,116,217,128,138,199,1 }, { 231,77,43,183,16,160,0 }, { 241,168,128,205,151,49,1 }, { 2,132,118,234,89,115,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 888)
		{ { 197,136,152,47,230,202,1 }, { 47,248,40,98,249,50,0 }, { 169,179,250,12,136,209,1 }, { 38,79,163,10,15,250,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 889)
		{ { 197,174,39,8,53,94,1 }, { 79,128,154,17,122,127,0 }, { 189,86,8,114,58,209,1 }, { 127,47,68,44,128,249,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 890)
		{ { 199,188,103,248,187,33,1 }, { 219,165,243,161,26,183,1 }, { 194,110,143,243,30,241,1 }, { 246,172,66,231,210,237,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 891)
		{ { 196,190,140,164,243,99,0 }, { 109,181,58,162,25,45,1 }, { 99,103,146,152,190,145,1 }, { 218,76,34,174,86,219,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 892)
		{ { 203,15,36,114,82,53,0 }, { 208,182,192,48,148,125,1 }, { 86,37,39,18,120,105,1 }, { 223,20,134,1,182,133,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 893)
		{ { 201,72,89,111,111,39,1 }, { 42,246,89,117,209,178,1 }, { 242,123,123,77,9,73,1 }, { 166,197,215,77,55,170,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 894)
		{ { 200,85,15,64,161,129,0 }, { 104,15,112,5,22,36,0 }, { 64,194,129,120,85,9,1 }, { 18,52,80,7,120,11,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 895)
		{ { 203,90,139,223,86,169,0 }, { 176,159,64,231,243,59,1 }, { 74,181,125,232,173,105,1 }, { 238,103,243,129,124,134,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 896)
		{ { 200,115,24,175,214,16,0 }, { 32,115,34,228,213,107,0 }, { 4,53,250,140,103,9,1 }, { 107,85,147,162,103,2,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 897)
		{ { 201,159,158,95,56,56,0 }, { 120,195,64,66,191,255,1 }, { 14,14,125,60,252,201,1 }, { 255,254,161,1,97,143,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 898)
		{ { 202,191,51,44,49,240,0 }, { 204,235,146,1,31,107,1 }, { 7,198,26,102,126,169,1 }, { 235,124,64,36,235,153,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 899)
		{ { 201,233,181,7,221,84,0 }, { 4,210,178,87,221,245,0 }, { 21,93,240,86,203,201,1 }, { 87,221,245,38,165,144,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 900)
		{ { 203,240,30,59,146,129,0 }, { 176,111,34,100,154,55,0 }, { 64,164,238,60,7,233,1 }, { 118,44,147,34,123,6,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 901)
		{ { 204,2,72,129,217,10,0 }, { 33,18,57,192,48,169,0 }, { 40,77,192,137,32,25,1 }, { 74,134,1,206,36,66,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 902)
		{ { 206,44,78,124,45,3,1 }, { 251,166,91,0,83,166,0 }, { 224,90,31,57,26,57,1 }, { 50,229,0,109,50,239,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 903)
		{ { 205,131,179,65,153,204,1 }, { 7,74,240,83,62,185,0 }, { 153,204,193,102,224,217,1 }, { 78,190,101,7,169,112,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 904)
		{ { 206,128,171,157,219,17,1 }, { 179,22,176,227,27,227,0 }, { 196,109,220,234,128,185,1 }, { 99,236,99,134,180,102,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 905)
		{ { 204,183,70,234,75,14,1 }, { 67,51,91,176,190,174,0 }, { 184,105,43,177,118,153,1 }, { 58,190,134,237,102,97,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 906)
		{ { 207,228,35,113,192,123,1 }, { 215,54,234,69,58,112,1 }, { 239,1,199,98,19,249,1 }, { 135,46,81,43,182,117,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 907)
		{ { 205,246,59,148,188,171,1 }, { 123,79,170,133,123,185,1 }, { 234,158,148,238,55,217,1 }, { 206,239,80,170,249,111,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 908)
		{ { 211,23,149,186,69,222,1 }, { 214,121,28,147,244,126,0 }, { 189,209,46,212,244,101,1 }, { 63,23,228,156,79,53,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 909)
		{ { 208,58,34,105,80,179,0 }, { 0,189,206,64,18,107,1 }, { 102,133,75,34,46,5,1 }, { 235,36,1,57,222,128,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 910)
		{ { 211,54,150,219,2,36,1 }, { 210,65,70,242,146,62,1 }, { 146,32,109,180,182,101,1 }, { 190,36,167,177,65,37,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 911)
		{ { 210,86,224,221,145,27,0 }, { 208,5,253,198,49,107,0 }, { 108,68,221,131,181,37,1 }, { 107,70,49,223,208,5,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 912)
		{ { 210,188,170,228,3,129,0 }, { 224,173,214,162,27,32,0 }, { 64,224,19,170,158,165,1 }, { 2,108,34,181,218,131,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 913)
		{ { 211,196,238,80,249,166,0 }, { 248,24,253,22,26,181,1 }, { 50,207,133,59,145,229,1 }, { 214,172,52,95,140,15,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 914)
		{ { 211,228,7,252,5,226,1 }, { 214,40,94,133,91,54,1 }, { 163,208,31,240,19,229,1 }, { 182,109,80,189,10,53,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 915)
		{ { 211,252,28,167,191,2,0 }, { 232,225,62,228,217,181,0 }, { 32,126,242,156,31,229,1 }, { 86,205,147,190,67,139,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 916)
		{ { 215,68,167,168,172,223,0 }, { 205,44,172,151,114,246,0 }, { 125,154,138,242,145,117,1 }, { 55,167,116,154,154,89,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 917)
		{ { 214,159,244,68,89,83,0 }, { 197,213,221,2,29,237,0 }, { 101,77,17,23,252,181,1 }, { 91,220,32,93,213,209,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 918)
		{ { 212,175,147,230,193,68,0 }, { 69,240,118,147,159,40,0 }, { 17,65,179,228,250,149,1 }, { 10,124,228,183,7,209,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 919)
		{ { 217,18,102,139,15,210,1 }, { 6,11,157,224,210,254,0 }, { 165,248,104,179,36,77,1 }, { 63,165,131,220,232,48,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 920)
		{ { 216,81,88,45,224,190,1 }, { 42,123,45,84,53,98,1 }, { 190,131,218,13,69,13,1 }, { 163,86,21,90,111,42,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 921)
		{ { 216,99,102,115,129,229,0 }, { 20,46,247,84,150,44,1 }, { 83,192,231,51,99,13,1 }, { 154,52,149,119,186,20,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 922)
		{ { 219,108,88,112,132,206,1 }, { 246,234,111,20,112,48,0 }, { 185,144,135,13,27,109,1 }, { 6,7,20,123,43,183,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 923)
		{ { 217,99,155,60,255,211,0 }, { 60,126,62,39,87,251,0 }, { 101,255,158,108,227,77,1 }, { 111,245,114,62,63,30,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 924)
		{ { 216,138,98,229,71,244,0 }, { 4,186,213,240,91,104,1 }, { 23,241,83,163,40,141,1 }, { 139,109,7,213,174,144,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 925)
		{ { 217,153,210,99,213,126,1 }, { 6,243,125,82,254,113,1 }, { 191,85,227,37,204,205,1 }, { 199,63,165,95,103,176,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 926)
		{ { 217,162,40,145,224,209,0 }, { 60,30,166,192,24,120,0 }, { 69,131,196,138,34,205,1 }, { 15,12,1,178,188,30,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 927)
		{ { 219,244,50,154,65,205,0 }, { 212,95,150,148,186,50,0 }, { 89,193,44,166,23,237,1 }, { 38,46,148,180,253,21,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 928)
		{ { 220,29,107,96,189,237,0 }, { 109,175,245,17,118,161,1 }, { 91,222,131,107,92,29,1 }, { 194,183,68,87,250,219,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 929)
		{ { 222,26,217,103,197,109,0 }, { 165,247,117,83,241,40,1 }, { 91,81,243,77,172,61,1 }, { 138,71,229,87,119,210,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 930)
		{ { 221,114,161,214,214,204,1 }, { 23,27,230,183,241,57,0 }, { 153,181,181,194,167,93,1 }, { 78,71,246,179,236,116,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 931)
		{ { 221,116,213,91,237,200,1 }, { 95,91,119,71,240,182,0 }, { 137,219,237,85,151,93,1 }, { 54,135,241,119,109,125,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 932)
		{ { 221,134,26,161,4,19,1 }, { 99,102,12,192,90,120,0 }, { 228,16,66,172,48,221,1 }, { 15,45,1,152,51,99,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 933)
		{ { 223,175,27,5,181,189,1 }, { 235,206,54,81,127,121,1 }, { 222,214,208,108,122,253,1 }, { 207,127,69,54,57,235,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 934)
		{ { 222,176,237,214,204,22,1 }, { 179,19,239,147,217,228,0 }, { 180,25,181,219,134,189,1 }, { 19,205,228,251,228,102,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 935)
		{ { 223,230,10,66,93,241,0 }, { 229,30,86,4,218,249,1 }, { 71,221,33,40,51,253,1 }, { 207,173,144,53,60,83,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 936)
		{ { 221,251,88,81,243,143,0 }, { 57,223,127,116,60,57,0 }, { 120,231,197,13,111,221,1 }, { 78,30,23,127,125,206,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 937)
		{ { 227,22,68,69,140,160,0 }, { 192,9,97,72,81,188,1 }, { 2,152,209,17,52,99,1 }, { 158,197,9,67,72,1,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 938)
		{ { 226,26,171,99,248,21,1 }, { 170,181,224,91,146,233,0 }, { 212,15,227,106,172,35,1 }, { 75,164,237,3,214,170,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 939)
		{ { 226,90,168,144,16,221,1 }, { 182,141,128,158,48,105,0 }, { 221,132,4,138,173,35,1 }, { 75,6,60,128,216,182,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 940)
		{ { 224,126,198,224,106,118,1 }, { 78,177,75,190,18,236,1 }, { 183,43,3,177,191,3,1 }, { 155,164,62,233,70,185,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 941)
		{ { 225,117,204,107,230,146,0 }, { 104,57,107,110,212,118,0 }, { 36,179,235,25,215,67,1 }, { 55,21,187,107,78,11,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 942)
		{ { 224,221,231,62,185,106,0 }, { 92,161,185,15,191,167,1 }, { 43,78,190,115,221,131,1 }, { 242,254,248,78,194,157,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 943)
		{ { 231,26,89,61,43,68,0 }, { 189,225,17,121,17,186,0 }, { 17,106,94,77,44,115,1 }, { 46,196,79,68,67,222,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 944)
		{ { 230,61,186,78,33,23,0 }, { 233,197,218,26,151,98,0 }, { 116,66,57,46,222,51,1 }, { 35,116,172,45,209,203,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 945)
		{ { 231,80,110,107,241,111,0 }, { 173,53,249,92,178,55,1 }, { 123,71,235,59,5,115,1 }, { 246,38,157,79,214,90,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 946)
		{ { 229,83,212,72,59,179,0 }, { 9,77,89,46,20,255,1 }, { 102,238,9,21,229,83,1 }, { 255,148,58,77,89,72,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 947)
		{ { 228,120,9,177,15,166,1 }, { 51,169,26,253,80,160,1 }, { 178,248,70,200,15,19,1 }, { 130,133,95,172,74,230,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 948)
		{ { 229,122,161,185,186,74,1 }, { 31,161,170,239,48,187,0 }, { 169,46,206,194,175,83,1 }, { 110,134,123,170,194,252,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 949)
		{ { 231,124,180,146,88,174,1 }, { 211,217,138,158,176,181,1 }, { 186,141,36,150,159,115,1 }, { 214,134,188,168,205,229,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 950)
		{ { 230,164,245,240,132,66,1 }, { 215,96,235,139,88,36,0 }, { 161,16,135,215,146,179,1 }, { 18,13,104,235,131,117,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 951)
		{ { 229,213,42,118,142,25,1 }, { 115,37,224,44,255,240,0 }, { 204,56,183,42,85,211,1 }, { 7,255,154,3,210,103,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 952)
		{ { 231,215,202,210,228,123,1 }, { 255,21,105,142,254,120,1 }, { 239,19,165,169,245,243,1 }, { 143,63,184,203,84,127,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 953)
		{ { 228,239,89,211,239,61,1 }, { 123,212,115,253,252,232,1 }, { 222,123,229,205,123,147,1 }, { 139,159,223,231,21,239,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 954)
		{ { 235,27,228,239,142,205,0 }, { 132,175,225,250,245,190,0 }, { 89,184,251,147,236,107,1 }, { 62,215,175,195,250,144,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 955)
		{ { 233,50,9,4,85,129,1 }, { 34,31,18,9,81,57,0 }, { 192,213,16,72,38,75,1 }, { 78,69,72,36,124,34,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 956)
		{ { 235,52,254,217,172,58,1 }, { 250,67,235,202,114,246,1 }, { 174,26,205,191,150,107,1 }, { 183,167,41,235,225,47,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 957)
		{ { 234,78,19,245,78,30,0 }, { 208,242,72,253,115,232,0 }, { 60,57,87,228,57,43,1 }, { 11,231,95,137,39,133,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 958)
		{ { 233,176,103,32,6,254,0 }, { 4,43,139,57,122,116,1 }, { 63,176,2,115,6,203,1 }, { 151,47,78,104,234,16,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 959)
		{ { 234,213,177,80,109,191,0 }, { 216,95,216,31,124,224,1 }, { 126,219,5,70,213,171,1 }, { 131,159,124,13,253,13,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 960)
		{ { 239,10,161,134,54,174,0 }, { 137,138,136,187,241,57,1 }, { 58,182,48,194,168,123,1 }, { 206,71,238,136,168,200,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 961)
		{ { 237,54,239,15,39,238,1 }, { 111,11,155,123,243,62,1 }, { 187,242,120,123,182,91,1 }, { 190,103,239,108,232,123,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 962)
		{ { 237,74,130,29,33,213,0 }, { 29,142,16,94,19,122,0 }, { 85,194,92,32,169,91,1 }, { 47,100,61,4,56,220,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 963)
		{ { 236,96,189,109,140,6,0 }, { 33,98,234,95,81,166,0 }, { 48,24,219,94,131,27,1 }, { 50,197,125,43,163,66,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 964)
		{ { 239,130,202,100,252,71,0 }, { 173,54,105,26,91,185,0 }, { 113,31,147,41,160,251,1 }, { 78,237,44,75,54,90,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 965)
		{ { 238,161,127,189,151,92,0 }, { 181,98,179,249,127,103,0 }, { 29,116,222,255,66,187,1 }, { 115,127,79,230,163,86,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 966)
		{ { 238,209,152,137,82,229,1 }, { 167,95,0,254,28,35,1 }, { 211,165,72,140,197,187,1 }, { 226,28,63,128,125,114,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 967)
		{ { 241,9,85,233,4,138,1 }, { 2,232,77,201,116,54,0 }, { 168,144,75,213,72,71,1 }, { 54,23,73,217,11,160,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 968)
		{ { 243,42,138,178,12,104,1 }, { 182,160,6,138,242,184,1 }, { 139,24,38,168,170,103,1 }, { 142,167,168,176,2,182,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 969)
		{ { 243,71,148,129,100,1,1 }, { 202,84,4,206,84,60,0 }, { 192,19,64,148,241,103,1 }, { 30,21,57,144,21,41,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 970)
		{ { 243,136,79,37,132,41,1 }, { 162,164,37,73,123,52,1 }, { 202,16,210,121,8,231,1 }, { 150,111,73,82,18,162,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 971)
		{ { 240,162,31,6,126,77,1 }, { 46,84,6,57,251,173,0 }, { 217,63,48,124,34,135,1 }, { 90,239,206,48,21,58,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 972)
		{ { 243,170,11,255,165,205,0 }, { 188,172,118,217,251,58,0 }, { 89,210,255,232,42,231,1 }, { 46,111,205,183,26,158,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 973)
		{ { 240,175,124,121,142,228,0 }, { 116,232,231,120,92,174,1 }, { 19,184,207,31,122,135,1 }, { 186,157,15,115,139,151,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 974)
		{ { 240,217,16,212,202,31,1 }, { 18,213,108,188,61,224,0 }, { 252,41,149,132,77,135,1 }, { 3,222,30,155,85,164,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 975)
		{ { 245,75,179,178,85,245,1 }, { 23,252,148,159,214,121,1 }, { 215,213,38,230,233,87,1 }, { 207,53,252,148,159,244,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 976)
		{ { 246,81,96,41,26,234,1 }, { 135,41,141,108,52,163,1 }, { 171,172,74,3,69,55,1 }, { 226,150,27,88,202,112,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 977)
		{ { 246,117,82,145,217,185,1 }, { 211,93,55,204,54,225,1 }, { 206,205,196,165,87,55,1 }, { 195,182,25,246,93,101,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 978)
		{ { 245,114,198,173,192,65,0 }, { 5,53,39,206,19,62,0 }, { 65,1,218,177,167,87,1 }, { 62,100,57,242,86,80,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 979)
		{ { 247,124,210,85,227,70,0 }, { 221,209,127,126,19,48,0 }, { 49,99,213,37,159,119,1 }, { 6,100,63,127,69,221,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 980)
		{ { 246,132,78,31,171,28,0 }, { 249,0,53,120,187,230,0 }, { 28,106,252,57,16,183,1 }, { 51,238,143,86,0,79,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 981)
		{ { 248,61,136,57,165,1,1 }, { 122,167,54,74,84,34,0 }, { 192,82,206,8,222,15,1 }, { 34,21,41,54,114,175,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 982)
		{ { 251,54,195,223,220,215,1 }, { 214,31,111,219,211,251,0 }, { 245,157,253,225,182,111,1 }, { 111,229,237,251,124,53,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 983)
		{ { 248,76,172,3,76,20,1 }, { 98,146,132,94,208,228,0 }, { 148,25,96,26,153,15,1 }, { 19,133,189,16,164,163,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 984)
		{ { 251,160,208,185,211,75,1 }, { 150,118,63,234,56,51,0 }, { 233,101,206,133,130,239,1 }, { 102,14,43,254,55,52,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 985)
		{ { 250,195,132,204,125,54,1 }, { 138,18,92,158,93,239,1 }, { 182,95,25,144,225,175,1 }, { 251,221,60,157,36,40,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 986)
		{ { 249,231,61,60,30,97,1 }, { 118,102,134,45,93,191,1 }, { 195,60,30,94,115,207,1 }, { 254,221,90,48,179,55,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 987)
		{ { 248,255,88,101,6,119,1 }, { 102,231,79,124,93,104,1 }, { 247,48,83,13,127,143,1 }, { 139,93,31,121,115,179,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 988)
		{ { 253,11,219,85,100,56,1 }, { 59,210,69,75,119,120,1 }, { 142,19,85,109,232,95,1 }, { 143,119,105,81,37,238,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 989)
		{ { 253,22,174,228,229,62,1 }, { 107,51,252,154,115,124,1 }, { 190,83,147,186,180,95,1 }, { 159,103,44,159,230,107,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 990)
		{ { 254,73,163,120,194,52,0 }, { 145,178,228,63,22,98,1 }, { 22,33,143,98,201,63,1 }, { 163,52,126,19,166,196,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 991)
		{ { 253,132,226,198,107,168,1 }, { 75,26,213,170,187,176,1 }, { 138,235,49,163,144,223,1 }, { 134,238,170,213,172,105,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 992)
		{ { 252,149,79,148,230,207,0 }, { 125,31,45,185,127,36,0 }, { 121,179,148,249,84,159,1 }, { 18,127,78,218,124,95,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 993)
		{ { 254,165,35,88,48,164,1 }, { 219,10,198,25,30,35,1 }, { 146,134,13,98,82,191,1 }, { 226,60,76,49,168,109,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 994)
		{ { 254,168,217,255,176,118,0 }, { 189,226,111,219,153,99,1 }, { 55,6,255,205,138,191,1 }, { 227,76,237,251,35,222,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 995)
		{ { 255,195,135,255,162,252,1 }, { 159,42,100,255,191,126,1 }, { 159,162,255,240,225,255,1 }, { 191,126,255,147,42,124,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 996)
		{ { 95,114,124,241,17,248,0 }, { 181,107,215,196,48,93,1 }, { 15,196,71,159,39,125,0 }, { 221,6,17,245,235,86,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 997)
		{ { 135,81,63,164,61,190,1 }, { 171,105,152,149,103,245,1 }, { 190,222,18,254,69,112,1 }, { 215,243,84,140,203,106,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 998)
		{ { 198,147,77,53,31,189,0 }, { 177,45,17,113,125,237,1 }, { 94,252,86,89,100,177,1 }, { 219,223,71,68,90,70,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 999)
		{ { 231,230,150,226,6,159,1 }, { 195,108,74,190,250,124,0 }, { 252,176,35,180,179,243,1 }, { 31,47,190,169,27,97,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1000)
	#error invalid ARUCO_DB_SIZE, max database size for this aruco type is 1000
	#endif

};

#elif (ARUCO_DB == ARUCO_DB_ARUCO_MIP_36h12)

#ifndef ARUCO_DB_SIZE
#define ARUCO_DB_SIZE 250
#endif

#define ARUCO_BITS	6

static unsigned char database[ARUCO_DB_SIZE][4][5] = {
	#if (ARUCO_DB_SIZE > 0)
		{ { 210,182,58,9,13 }, { 69,104,93,183,4 }, { 185,5,198,212,11 }, { 46,219,161,106,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1)
		{ { 96,1,19,78,5 }, { 28,98,96,152,1 }, { 167,44,136,0,6 }, { 129,144,100,99,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2)
		{ { 18,6,251,231,2 }, { 56,216,14,61,7 }, { 78,125,246,4,8 }, { 235,199,1,177,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 3)
		{ { 255,138,214,203,4 }, { 162,233,120,223,11 }, { 45,54,181,31,15 }, { 223,177,233,116,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 4)
		{ { 133,218,155,196,9 }, { 220,196,29,90,10 }, { 146,61,149,186,1 }, { 85,171,130,51,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 5)
		{ { 180,97,175,233,12 }, { 145,239,103,14,6 }, { 57,127,88,98,13 }, { 103,14,111,120,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 6)
		{ { 109,181,31,225,3 }, { 215,83,54,252,2 }, { 200,127,138,219,6 }, { 67,246,204,174,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 7)
		{ { 82,72,197,65,15 }, { 52,157,65,141,8 }, { 248,42,49,36,10 }, { 27,24,43,146,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 8)
		{ { 0,143,52,80,3 }, { 4,19,152,56,12 }, { 192,162,207,16,0 }, { 49,193,156,130,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 9)
		{ { 142,164,98,236,14 }, { 171,112,83,43,6 }, { 115,116,98,87,1 }, { 109,76,160,237,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 10)
		{ { 234,194,190,118,13 }, { 14,197,255,155,5 }, { 182,231,212,53,7 }, { 173,159,250,55,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 11)
		{ { 26,246,21,196,4 }, { 91,13,88,57,2 }, { 34,58,134,245,8 }, { 73,193,171,13,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 12)
		{ { 180,138,73,242,7 }, { 180,24,254,10,11 }, { 228,249,37,18,13 }, { 213,7,241,130,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 13)
		{ { 46,78,18,131,11 }, { 134,84,41,53,11 }, { 220,20,135,39,4 }, { 218,201,66,166,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 14)
		{ { 120,177,242,250,8 }, { 99,234,179,152,7 }, { 21,244,248,209,14 }, { 225,156,213,124,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 15)
		{ { 39,211,79,87,14 }, { 248,87,253,77,1 }, { 126,175,44,190,4 }, { 139,43,254,161,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 16)
		{ { 137,34,47,255,1 }, { 31,97,142,78,7 }, { 143,255,68,73,1 }, { 231,39,24,111,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 17)
		{ { 76,22,105,64,6 }, { 242,16,76,168,4 }, { 96,41,102,131,2 }, { 33,83,32,132,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 18)
		{ { 191,73,179,81,1 }, { 150,206,160,95,12 }, { 136,172,217,47,13 }, { 63,160,87,54,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 19)
		{ { 220,25,28,213,13 }, { 206,11,197,158,10 }, { 186,179,137,131,11 }, { 87,154,61,7,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 20)
		{ { 17,215,195,248,5 }, { 116,238,218,104,2 }, { 161,252,62,184,8 }, { 65,101,183,114,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 21)
		{ { 22,161,48,227,5 }, { 133,10,82,29,7 }, { 172,112,200,86,8 }, { 235,132,165,10,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 22)
		{ { 226,159,39,239,15 }, { 92,115,123,175,15 }, { 255,126,79,148,7 }, { 255,93,236,227,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 23)
		{ { 66,141,138,224,12 }, { 0,194,87,169,10 }, { 48,117,27,20,2 }, { 89,94,164,48,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 24)
		{ { 144,213,72,71,7 }, { 108,30,84,46,1 }, { 238,33,42,176,9 }, { 135,66,167,131,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 25)
		{ { 35,25,203,201,3 }, { 116,242,36,77,10 }, { 201,61,57,140,4 }, { 91,34,68,242,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 26)
		{ { 195,176,195,223,12 }, { 121,224,209,207,3 }, { 63,188,48,220,3 }, { 207,56,176,121,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 27)
		{ { 4,36,188,204,9 }, { 141,161,5,56,6 }, { 147,51,210,66,0 }, { 97,202,8,91,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 28)
		{ { 42,8,29,99,0 }, { 18,1,38,29,9 }, { 12,107,129,5,4 }, { 155,134,72,4,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 29)
		{ { 118,39,67,217,6 }, { 177,122,232,173,2 }, { 105,188,46,70,14 }, { 75,81,117,232,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 30)
		{ { 208,100,91,241,9 }, { 53,76,135,190,2 }, { 152,253,162,96,11 }, { 71,222,19,42,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 31)
		{ { 243,141,127,214,0 }, { 56,75,180,251,15 }, { 6,191,235,28,15 }, { 253,242,221,33,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 32)
		{ { 198,203,249,161,0 }, { 176,134,30,151,14 }, { 8,89,253,54,3 }, { 126,151,134,16,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 33)
		{ { 60,27,231,198,5 }, { 254,203,104,8,15 }, { 166,62,125,131,12 }, { 241,1,109,55,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 34)
		{ { 39,111,117,230,3 }, { 189,23,42,121,15 }, { 198,122,239,110,4 }, { 249,229,78,139,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 35)
		{ { 68,144,163,246,3 }, { 220,208,146,136,7 }, { 198,252,80,146,2 }, { 225,20,144,179,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 36)
		{ { 218,96,172,213,2 }, { 11,157,132,143,6 }, { 74,179,80,101,11 }, { 111,18,27,157,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 37)
		{ { 60,198,141,245,9 }, { 158,141,191,44,2 }, { 154,251,22,51,12 }, { 67,79,219,23,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 38)
		{ { 171,70,249,218,14 }, { 50,180,237,123,7 }, { 117,185,246,45,5 }, { 237,235,114,212,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 39)
		{ { 136,213,51,215,8 }, { 90,70,145,62,7 }, { 30,188,202,177,1 }, { 231,200,150,37,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 40)
		{ { 182,214,46,194,1 }, { 196,77,60,43,7 }, { 132,55,70,182,13 }, { 237,67,203,34,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 41)
		{ { 179,192,43,100,6 }, { 24,92,118,75,4 }, { 98,109,64,60,13 }, { 45,38,227,161,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 42)
		{ { 34,229,109,64,8 }, { 49,7,53,41,4 }, { 16,43,106,116,4 }, { 41,74,206,8,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 43)
		{ { 172,95,87,112,10 }, { 242,87,171,58,8 }, { 80,238,175,163,5 }, { 21,205,94,164,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 44)
		{ { 170,169,147,246,6 }, { 27,210,242,27,11 }, { 102,252,153,85,5 }, { 221,132,244,189,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 45)
		{ { 76,170,7,200,13 }, { 151,97,89,136,10 }, { 177,62,5,83,2 }, { 81,25,168,110,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 46)
		{ { 92,155,79,123,0 }, { 242,107,158,140,9 }, { 13,239,45,147,10 }, { 147,23,157,100,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 47)
		{ { 170,158,240,224,5 }, { 102,128,122,59,14 }, { 160,112,247,149,5 }, { 125,197,224,22,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 48)
		{ { 7,5,197,117,0 }, { 184,131,130,109,0 }, { 10,234,58,14,0 }, { 11,100,28,17,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 49)
		{ { 172,129,245,69,14 }, { 186,147,113,30,4 }, { 122,42,248,19,5 }, { 39,136,236,149,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 50)
		{ { 115,91,145,231,4 }, { 88,142,106,221,11 }, { 46,120,157,172,14 }, { 219,181,103,17,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 51)
		{ { 140,195,92,238,4 }, { 170,39,94,26,3 }, { 39,115,172,51,1 }, { 197,135,174,69,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 52)
		{ { 228,70,148,208,4 }, { 128,133,232,186,2 }, { 32,178,150,34,7 }, { 69,209,122,16,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 53)
		{ { 181,225,33,222,0 }, { 153,46,176,74,7 }, { 7,184,72,122,13 }, { 229,32,215,73,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 54)
		{ { 38,16,23,208,15 }, { 212,81,225,25,2 }, { 240,190,128,134,4 }, { 73,136,120,162,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 55)
		{ { 241,212,57,235,5 }, { 84,44,118,254,7 }, { 173,121,194,184,15 }, { 231,246,227,66,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 56)
		{ { 161,163,58,201,6 }, { 1,114,124,94,6 }, { 105,53,204,88,5 }, { 103,163,228,232,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 57)
		{ { 23,76,98,192,2 }, { 160,92,0,105,14 }, { 64,52,99,46,8 }, { 121,96,3,160,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 58)
		{ { 30,226,127,113,6 }, { 179,93,222,29,4 }, { 104,239,228,119,8 }, { 43,135,187,172,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 59)
		{ { 139,28,94,206,9 }, { 110,97,5,123,11 }, { 151,55,163,141,1 }, { 221,234,8,103,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 60)
		{ { 106,5,176,198,10 }, { 10,146,33,185,7 }, { 86,48,218,5,6 }, { 233,216,68,149,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 61)
		{ { 13,5,104,223,12 }, { 170,34,197,108,7 }, { 63,177,106,11,0 }, { 227,106,52,69,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 62)
		{ { 25,45,37,229,15 }, { 31,27,67,108,14 }, { 250,122,75,73,8 }, { 115,108,45,143,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 63)
		{ { 26,219,236,204,8 }, { 106,175,29,9,14 }, { 19,51,125,181,8 }, { 121,11,143,85,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 64)
		{ { 207,236,135,240,0 }, { 147,197,146,235,10 }, { 0,254,19,127,3 }, { 93,116,154,60,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 65)
		{ { 208,185,221,231,10 }, { 121,155,23,158,11 }, { 94,123,185,208,11 }, { 215,158,141,153,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 66)
		{ { 136,220,239,129,14 }, { 114,213,85,38,14 }, { 120,31,115,177,1 }, { 118,74,170,180,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 67)
		{ { 68,86,129,203,9 }, { 212,164,9,172,3 }, { 157,56,22,162,2 }, { 195,89,2,82,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 68)
		{ { 219,178,255,200,3 }, { 119,249,28,219,6 }, { 193,63,244,221,11 }, { 109,179,137,254,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 69)
		{ { 164,141,150,223,1 }, { 140,227,176,62,11 }, { 143,182,155,18,5 }, { 215,192,220,115,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 70)
		{ { 183,44,194,231,13 }, { 173,200,99,111,11 }, { 190,116,51,78,13 }, { 223,108,97,59,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 71)
		{ { 12,41,91,83,15 }, { 183,82,197,28,9 }, { 252,173,169,67,0 }, { 147,138,52,174,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 72)
		{ { 244,152,50,112,4 }, { 192,72,242,154,12 }, { 32,228,193,146,15 }, { 53,148,241,32,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 73)
		{ { 153,104,237,194,9 }, { 55,141,5,74,15 }, { 148,59,113,105,9 }, { 245,42,11,30,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 74)
		{ { 158,78,26,248,5 }, { 134,108,206,59,10 }, { 161,245,135,39,9 }, { 93,199,51,102,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 75)
		{ { 134,131,226,209,11 }, { 164,210,153,15,6 }, { 216,180,124,22,1 }, { 111,9,148,178,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 76)
		{ { 129,11,69,192,4 }, { 48,3,72,74,10 }, { 32,58,45,8,1 }, { 85,33,44,0,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 77)
		{ { 106,196,75,254,2 }, { 58,116,182,169,3 }, { 71,253,34,53,6 }, { 201,86,210,229,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 78)
		{ { 100,83,70,97,5 }, { 228,71,106,140,0 }, { 168,102,44,162,6 }, { 3,21,110,34,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 79)
		{ { 57,144,189,89,8 }, { 82,169,181,92,4 }, { 25,171,208,153,12 }, { 35,170,217,84,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 80)
		{ { 28,158,208,246,10 }, { 234,152,155,56,11 }, { 86,240,183,147,8 }, { 209,205,145,149,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 81)
		{ { 194,103,41,214,5 }, { 29,6,204,171,7 }, { 166,185,78,100,3 }, { 237,83,54,11,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 82)
		{ { 131,153,63,121,5 }, { 84,99,214,95,12 }, { 169,239,201,156,1 }, { 63,166,188,98,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 83)
		{ { 58,192,90,197,13 }, { 46,76,117,29,2 }, { 186,53,160,53,12 }, { 75,138,227,39,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 84)
		{ { 53,122,223,243,11 }, { 245,221,175,92,11 }, { 220,255,181,234,12 }, { 211,175,91,186,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 85)
		{ { 13,92,5,86,5 }, { 222,5,192,104,9 }, { 166,170,3,171,0 }, { 145,96,58,7,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 86)
		{ { 47,84,126,244,4 }, { 234,69,230,121,6 }, { 34,247,226,175,4 }, { 105,230,122,37,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 87)
		{ { 134,193,21,4,1 }, { 156,7,16,19,0 }, { 130,10,136,54,1 }, { 12,128,142,3,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 88)
		{ { 100,15,217,229,15 }, { 188,146,111,188,10 }, { 250,121,191,2,6 }, { 83,223,100,147,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 89)
		{ { 206,8,187,207,7 }, { 158,240,68,159,15 }, { 239,61,209,7,3 }, { 255,146,32,247,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 90)
		{ { 16,155,179,67,14 }, { 80,218,89,28,13 }, { 124,44,221,144,8 }, { 179,137,165,176,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 91)
		{ { 194,20,53,201,2 }, { 80,49,0,191,6 }, { 73,58,194,132,3 }, { 111,208,8,192,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 92)
		{ { 53,180,223,206,4 }, { 249,233,116,120,3 }, { 39,63,178,218,12 }, { 193,226,233,121,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 93)
		{ { 69,151,82,207,2 }, { 232,114,24,252,3 }, { 79,52,174,154,2 }, { 195,241,132,225,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 94)
		{ { 236,145,91,130,12 }, { 242,66,117,146,3 }, { 52,29,168,147,7 }, { 196,154,228,36,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 95)
		{ { 81,136,30,237,0 }, { 8,105,22,220,10 }, { 11,119,129,24,10 }, { 83,182,137,97,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 96)
		{ { 45,218,125,201,7 }, { 246,53,124,92,14 }, { 233,59,229,187,4 }, { 115,163,234,198,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 97)
		{ { 46,1,66,20,4 }, { 170,66,224,1,0 }, { 34,132,40,7,4 }, { 8,0,116,37,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 98)
		{ { 66,232,144,249,9 }, { 5,164,147,157,10 }, { 153,240,145,116,2 }, { 91,156,146,90,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 99)
		{ { 154,136,86,82,7 }, { 38,89,208,27,9 }, { 228,166,161,21,9 }, { 157,128,185,166,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 100)
		{ { 142,128,217,216,0 }, { 178,160,148,27,2 }, { 1,185,176,23,1 }, { 77,130,144,84,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 101)
		{ { 137,28,188,243,4 }, { 66,129,198,126,15 }, { 44,243,211,137,1 }, { 247,230,56,20,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 102)
		{ { 37,221,130,65,0 }, { 192,198,48,108,8 }, { 8,36,27,186,4 }, { 19,96,198,48,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 103)
		{ { 35,149,81,211,4 }, { 112,2,240,125,3 }, { 44,184,170,156,4 }, { 203,224,244,0,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 104)
		{ { 143,232,240,199,0 }, { 171,132,16,95,15 }, { 14,48,241,127,1 }, { 255,160,130,29,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 105)
		{ { 148,16,106,151,0 }, { 232,72,132,6,7 }, { 14,149,96,130,9 }, { 230,2,17,33,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 106)
		{ { 130,96,155,64,12 }, { 17,196,69,27,0 }, { 48,45,144,100,1 }, { 13,138,34,56,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 107)
		{ { 15,201,202,243,6 }, { 162,214,214,77,11 }, { 108,245,57,63,0 }, { 219,38,182,180,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 108)
		{ { 104,129,129,209,1 }, { 22,130,176,140,2 }, { 136,184,24,17,6 }, { 67,16,212,22,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 109)
		{ { 113,134,19,192,8 }, { 16,72,57,248,2 }, { 16,60,134,24,14 }, { 65,249,193,32,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 110)
		{ { 15,26,183,98,9 }, { 214,193,11,89,13 }, { 148,110,213,143,0 }, { 185,173,8,54,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 111)
		{ { 163,87,191,193,8 }, { 80,199,45,127,6 }, { 24,63,222,172,5 }, { 111,235,78,48,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 112)
		{ { 76,3,183,164,6 }, { 154,211,74,144,6 }, { 98,94,220,3,2 }, { 96,149,44,181,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 113)
		{ { 32,77,237,206,6 }, { 56,183,100,40,15 }, { 103,59,123,32,4 }, { 241,66,110,209,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 114)
		{ { 173,99,0,211,7 }, { 135,22,232,78,3 }, { 236,176,12,107,5 }, { 199,33,118,142,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 115)
		{ { 132,204,76,208,9 }, { 164,5,149,42,10 }, { 144,179,35,50,1 }, { 85,74,154,2,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 116)
		{ { 66,22,14,92,4 }, { 72,97,204,169,0 }, { 35,167,6,132,2 }, { 9,83,56,97,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 117)
		{ { 135,210,173,250,8 }, { 208,165,159,75,7 }, { 21,251,84,190,1 }, { 237,47,154,80,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 118)
		{ { 120,80,231,116,9 }, { 126,205,163,136,4 }, { 146,238,112,161,14 }, { 33,28,91,55,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 119)
		{ { 78,117,15,199,12 }, { 219,71,69,173,3 }, { 62,63,10,231,2 }, { 203,90,46,45,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 120)
		{ { 191,46,93,253,10 }, { 187,57,175,127,10 }, { 91,251,167,79,13 }, { 95,239,89,205,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 121)
		{ { 216,131,36,218,5 }, { 6,43,216,138,7 }, { 165,178,76,17,11 }, { 229,17,189,70,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 122)
		{ { 35,75,82,248,0 }, { 32,102,170,89,10 }, { 1,244,173,44,4 }, { 89,165,86,96,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 123)
		{ { 55,130,4,81,4 }, { 128,9,248,77,0 }, { 40,162,4,30,12 }, { 11,33,249,0,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 124)
		{ { 171,223,42,213,3 }, { 78,86,188,111,14 }, { 202,181,79,189,5 }, { 127,99,214,167,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 125)
		{ { 54,94,120,239,9 }, { 236,44,47,61,15 }, { 159,113,231,166,12 }, { 251,207,67,67,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 126)
		{ { 73,202,166,202,2 }, { 2,245,24,200,15 }, { 69,54,85,57,2 }, { 241,49,138,244,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 127)
		{ { 3,195,157,223,3 }, { 28,183,156,93,3 }, { 207,187,156,60,0 }, { 203,163,158,211,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 128)
		{ { 198,140,83,133,13 }, { 188,64,81,183,10 }, { 186,28,163,22,3 }, { 94,216,160,35,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 129)
		{ { 91,252,187,246,7 }, { 95,220,214,249,15 }, { 230,253,211,253,10 }, { 249,246,179,191,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 130)
		{ { 98,50,65,226,1 }, { 117,0,42,137,3 }, { 132,120,36,196,6 }, { 201,21,64,10,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 131)
		{ { 171,201,13,92,12 }, { 26,39,245,75,8 }, { 51,171,9,61,5 }, { 29,42,254,69,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 132)
		{ { 56,140,111,232,5 }, { 54,105,118,40,14 }, { 161,127,99,17,12 }, { 113,70,233,102,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 133)
		{ { 218,14,45,98,13 }, { 22,9,79,171,13 }, { 180,107,71,5,11 }, { 189,95,41,6,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 134)
		{ { 16,133,93,254,9 }, { 60,43,151,56,3 }, { 151,251,170,16,8 }, { 193,206,157,67,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 135)
		{ { 77,70,239,214,11 }, { 190,213,141,232,7 }, { 214,191,118,43,2 }, { 225,123,26,183,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 136)
		{ { 118,234,18,214,1 }, { 141,76,184,153,11 }, { 134,180,133,118,14 }, { 217,145,211,43,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 137)
		{ { 157,179,119,211,13 }, { 247,75,217,94,7 }, { 188,190,236,219,9 }, { 231,169,189,46,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 138)
		{ { 238,208,239,167,1 }, { 254,197,54,135,7 }, { 142,95,112,183,7 }, { 238,22,202,55,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 139)
		{ { 230,236,58,226,15 }, { 133,84,119,187,15 }, { 244,117,195,118,7 }, { 253,222,226,170,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 140)
		{ { 68,31,174,232,3 }, { 196,243,14,168,14 }, { 193,119,95,130,2 }, { 113,87,12,242,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 141)
		{ { 186,25,200,255,5 }, { 110,170,230,15,11 }, { 175,241,57,133,13 }, { 223,6,117,87,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 142)
		{ { 49,48,53,234,11 }, { 85,57,35,88,7 }, { 213,122,192,200,12 }, { 225,172,73,202,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 143)
		{ { 108,232,247,98,5 }, { 183,197,114,152,13 }, { 164,110,241,115,6 }, { 177,148,234,62,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 144)
		{ { 136,13,171,88,13 }, { 22,226,197,42,12 }, { 177,173,91,1,1 }, { 53,74,52,118,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 145)
		{ { 141,52,9,224,13 }, { 215,0,71,106,2 }, { 176,121,2,203,1 }, { 69,110,32,14,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 146)
		{ { 43,233,46,226,1 }, { 7,71,54,73,15 }, { 132,119,73,125,4 }, { 249,38,206,46,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 147)
		{ { 214,3,2,198,12 }, { 136,74,73,139,3 }, { 54,52,12,6,11 }, { 205,25,37,33,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 148)
		{ { 70,159,252,114,4 }, { 224,131,222,185,13 }, { 36,227,255,150,2 }, { 185,215,188,16,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 149)
		{ { 135,238,190,237,3 }, { 141,245,30,127,14 }, { 203,119,215,126,1 }, { 127,231,138,251,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 150)
		{ { 66,88,126,247,10 }, { 104,85,135,157,15 }, { 94,247,225,164,2 }, { 251,158,26,161,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 151)
		{ { 122,140,196,229,2 }, { 42,153,50,173,10 }, { 74,114,51,21,14 }, { 91,84,201,149,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 152)
		{ { 118,164,55,101,0 }, { 153,73,50,189,4 }, { 10,110,194,86,14 }, { 43,212,201,41,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 153)
		{ { 153,158,65,239,4 }, { 122,40,90,110,11 }, { 47,120,39,153,9 }, { 215,101,161,69,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 154)
		{ { 125,9,105,228,2 }, { 186,26,38,200,14 }, { 66,121,105,11,14 }, { 113,54,69,133,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 155)
		{ { 192,43,175,70,11 }, { 29,211,13,138,13 }, { 214,47,93,64,3 }, { 181,27,12,187,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 156)
		{ { 146,89,243,228,7 }, { 124,222,66,27,14 }, { 226,124,249,164,9 }, { 125,132,39,179,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 157)
		{ { 33,22,161,220,0 }, { 88,160,168,104,6 }, { 3,184,86,136,4 }, { 97,97,80,81,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 158)
		{ { 159,45,228,216,4 }, { 163,171,192,107,14 }, { 33,178,123,79,9 }, { 125,96,61,92,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 159)
		{ { 0,239,250,194,9 }, { 37,198,29,56,15 }, { 148,53,255,112,0 }, { 241,203,134,58,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 160)
		{ { 123,55,31,248,12 }, { 83,107,239,249,2 }, { 49,255,142,205,14 }, { 73,255,125,108,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 161)
		{ { 102,131,57,218,9 }, { 148,34,189,153,7 }, { 149,185,204,22,6 }, { 233,155,212,66,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 162)
		{ { 208,16,174,227,15 }, { 68,217,71,142,7 }, { 252,119,80,128,11 }, { 231,30,41,178,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 163)
		{ { 28,208,11,76,0 }, { 218,108,20,8,0 }, { 3,45,0,179,8 }, { 1,2,131,101,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 164)
		{ { 149,7,15,195,11 }, { 148,91,13,110,3 }, { 220,63,14,10,9 }, { 199,107,13,162,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 165)
		{ { 248,76,154,119,0 }, { 10,204,166,190,9 }, { 14,229,147,33,15 }, { 151,214,83,53,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 166)
		{ { 56,248,99,215,6 }, { 123,92,240,12,15 }, { 110,188,97,241,12 }, { 243,0,243,173,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 167)
		{ { 54,70,255,4,5 }, { 188,205,108,49,4 }, { 162,15,246,38,12 }, { 40,195,107,51,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 168)
		{ { 206,27,150,65,2 }, { 194,211,8,159,8 }, { 72,38,157,135,3 }, { 31,145,12,180,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 169)
		{ { 122,93,69,218,8 }, { 114,47,161,169,11 }, { 21,186,43,165,14 }, { 217,88,95,68,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 170)
		{ { 20,224,14,246,12 }, { 137,77,215,8,3 }, { 54,247,0,114,8 }, { 193,14,187,41,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 171)
		{ { 94,149,171,253,8 }, { 218,234,151,173,6 }, { 27,253,90,151,10 }, { 107,94,149,117,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 172)
		{ { 178,233,203,114,9 }, { 53,206,183,11,9 }, { 148,237,57,116,13 }, { 157,14,215,58,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 173)
		{ { 3,108,71,221,7 }, { 61,117,192,109,10 }, { 235,190,35,108,0 }, { 91,96,58,235,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 174)
		{ { 184,238,151,198,11 }, { 31,221,57,58,11 }, { 214,62,151,113,13 }, { 213,201,203,191,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 175)
		{ { 14,158,143,101,7 }, { 222,209,94,45,8 }, { 234,111,23,151,0 }, { 27,71,168,183,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 176)
		{ { 212,173,46,241,10 }, { 129,91,151,174,14 }, { 88,247,75,82,11 }, { 119,94,157,168,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 177)
		{ { 136,17,199,243,2 }, { 114,211,130,14,3 }, { 76,254,56,129,1 }, { 199,4,28,180,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 178)
		{ { 71,189,231,195,1 }, { 245,195,16,237,15 }, { 140,62,123,222,2 }, { 251,112,140,58,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 179)
		{ { 58,218,223,182,4 }, { 122,205,254,17,11 }, { 38,223,181,181,12 }, { 216,135,251,53,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 180)
		{ { 110,91,40,87,4 }, { 202,6,236,141,13 }, { 46,161,77,167,6 }, { 187,19,118,5,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 181)
		{ { 51,230,124,217,1 }, { 37,45,188,125,6 }, { 137,179,230,124,12 }, { 107,227,219,74,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 182)
		{ { 42,185,253,210,13 }, { 119,131,245,25,15 }, { 180,187,249,213,4 }, { 249,138,252,30,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 183)
		{ { 138,250,103,242,11 }, { 119,85,155,11,15 }, { 212,254,101,245,1 }, { 253,13,154,174,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 184)
		{ { 230,162,143,197,14 }, { 153,209,125,143,2 }, { 122,63,20,86,7 }, { 79,27,232,185,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 185)
		{ { 114,4,156,219,13 }, { 4,169,229,189,3 }, { 189,179,146,4,14 }, { 203,218,121,82,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 186)
		{ { 174,101,218,193,2 }, { 163,214,36,63,2 }, { 72,53,186,103,5 }, { 79,194,70,188,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 187)
		{ { 18,81,164,82,6 }, { 64,159,192,9,5 }, { 100,162,88,164,8 }, { 169,0,63,144,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 188)
		{ { 16,137,171,132,1 }, { 28,202,20,0,14 }, { 130,29,89,16,8 }, { 112,2,133,51,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 189)
		{ { 226,240,150,238,0 }, { 73,229,50,155,3 }, { 7,118,144,244,7 }, { 205,148,202,121,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 190)
		{ { 176,202,238,87,3 }, { 44,221,188,14,13 }, { 206,167,117,48,13 }, { 183,3,219,179,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 191)
		{ { 253,102,119,232,6 }, { 179,125,106,250,6 }, { 97,126,230,107,15 }, { 101,245,107,236,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 192)
		{ { 68,75,63,81,8 }, { 144,71,141,156,12 }, { 24,175,205,34,2 }, { 51,155,30,32,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 193)
		{ { 190,139,58,86,10 }, { 138,90,189,27,13 }, { 86,165,205,23,13 }, { 189,139,213,165,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 194)
		{ { 104,10,117,207,12 }, { 58,33,105,156,15 }, { 63,58,229,1,6 }, { 243,153,104,69,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 195)
		{ { 172,2,186,234,8 }, { 130,224,47,26,7 }, { 21,117,212,3,5 }, { 229,143,64,116,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 196)
		{ { 151,216,21,225,12 }, { 208,13,83,95,10 }, { 56,122,129,190,9 }, { 95,172,171,0,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 197)
		{ { 29,67,134,224,8 }, { 130,207,11,72,2 }, { 16,118,28,43,8 }, { 65,45,15,52,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 198)
		{ { 26,20,245,176,14 }, { 114,153,195,49,6 }, { 112,218,242,133,8 }, { 104,204,57,148,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 199)
		{ { 230,88,168,216,1 }, { 196,164,164,139,14 }, { 129,177,81,166,7 }, { 125,18,82,82,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 200)
		{ { 163,134,142,250,7 }, { 4,241,254,107,3 }, { 229,247,22,28,5 }, { 205,103,248,242,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 201)
		{ { 54,104,169,103,3 }, { 157,156,38,13,13 }, { 206,105,81,102,12 }, { 187,6,67,155,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 202)
		{ { 232,252,83,216,5 }, { 119,100,240,186,10 }, { 161,188,163,241,7 }, { 85,208,242,110,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 203)
		{ { 46,43,126,221,5 }, { 175,99,236,29,14 }, { 171,183,237,71,4 }, { 123,131,124,111,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 204)
		{ { 139,36,112,241,3 }, { 39,16,130,127,6 }, { 200,240,226,77,1 }, { 111,228,16,142,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 205)
		{ { 246,151,149,243,2 }, { 208,155,186,191,3 }, { 76,250,158,150,15 }, { 207,213,221,144,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 206)
		{ { 69,137,255,200,14 }, { 176,243,85,216,14 }, { 113,63,249,26,2 }, { 113,186,172,240,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 207)
		{ { 46,32,128,201,12 }, { 131,160,97,13,2 }, { 57,48,16,71,4 }, { 75,8,96,92,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 208)
		{ { 6,66,101,247,13 }, { 188,5,203,13,7 }, { 190,250,100,38,0 }, { 235,13,58,3,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 209)
		{ { 61,113,77,209,0 }, { 243,15,164,76,2 }, { 8,187,40,235,12 }, { 67,34,95,12,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 210)
		{ { 22,146,198,239,1 }, { 236,233,26,13,3 }, { 143,118,52,150,8 }, { 203,5,137,115,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 211)
		{ { 62,103,242,244,9 }, { 175,206,171,57,6 }, { 146,244,254,103,12 }, { 105,205,87,63,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 212)
		{ { 80,65,218,214,3 }, { 44,222,132,152,3 }, { 198,181,184,32,10 }, { 193,146,23,179,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 213)
		{ { 26,21,3,65,5 }, { 86,74,64,45,0 }, { 168,44,10,133,8 }, { 11,64,37,38,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 214)
		{ { 100,193,140,116,2 }, { 136,151,182,136,0 }, { 66,227,24,50,6 }, { 1,22,222,145,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 215)
		{ { 10,114,238,195,5 }, { 103,197,76,13,7 }, { 172,55,116,229,0 }, { 235,3,42,62,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 216)
		{ { 31,15,157,198,0 }, { 154,139,12,121,11 }, { 6,59,159,15,8 }, { 217,227,13,21,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 217)
		{ { 169,85,155,198,7 }, { 94,214,100,122,3 }, { 230,61,154,169,5 }, { 197,226,102,183,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 218)
		{ { 243,41,17,208,13 }, { 21,10,225,219,10 }, { 176,184,137,76,15 }, { 93,184,117,10,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 219)
		{ { 33,192,212,255,12 }, { 40,165,243,92,3 }, { 63,242,176,56,4 }, { 195,172,250,81,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 220)
		{ { 224,28,239,91,0 }, { 112,225,164,174,13 }, { 13,175,115,128,7 }, { 183,82,88,112,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 221)
		{ { 78,35,163,82,0 }, { 147,194,136,137,5 }, { 4,172,92,71,2 }, { 169,17,20,60,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 222)
		{ { 170,79,4,228,9 }, { 14,7,43,43,10 }, { 146,114,15,37,5 }, { 93,77,78,7,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 223)
		{ { 225,196,252,196,3 }, { 44,149,52,250,6 }, { 194,51,242,56,7 }, { 101,242,202,147,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 224)
		{ { 32,142,143,110,8 }, { 24,225,63,40,9 }, { 23,111,23,16,4 }, { 145,79,200,113,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 225)
		{ { 132,134,119,74,5 }, { 180,97,88,58,5 }, { 165,46,230,18,1 }, { 165,193,168,98,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 226)
		{ { 158,152,199,85,8 }, { 250,201,145,15,8 }, { 26,174,49,151,9 }, { 31,8,153,53,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 227)
		{ { 44,89,251,125,12 }, { 250,230,231,28,12 }, { 59,237,249,163,4 }, { 51,142,118,117,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 228)
		{ { 148,70,164,97,3 }, { 132,157,10,46,4 }, { 200,98,86,34,9 }, { 39,69,11,146,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 229)
		{ { 130,146,220,194,14 }, { 96,145,93,27,3 }, { 116,51,180,148,1 }, { 205,139,168,144,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 230)
		{ { 0,77,97,99,1 }, { 52,6,2,44,13 }, { 140,104,107,32,0 }, { 179,68,6,2,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 231)
		{ { 208,85,39,128,9 }, { 84,79,1,162,6 }, { 144,30,74,160,11 }, { 100,88,15,34,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 232)
		{ { 160,22,56,82,13 }, { 68,0,237,58,5 }, { 180,161,198,128,5 }, { 165,203,112,2,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 233)
		{ { 143,101,127,99,9 }, { 183,71,7,127,5 }, { 156,111,234,111,1 }, { 175,238,14,46,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 234)
		{ { 204,166,195,227,7 }, { 183,208,90,174,3 }, { 236,124,54,83,3 }, { 199,85,160,190,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 235)
		{ { 203,19,107,199,10 }, { 122,82,13,207,7 }, { 94,61,108,141,3 }, { 239,59,4,165,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 236)
		{ { 252,90,131,229,3 }, { 222,220,42,142,10 }, { 202,124,21,163,15 }, { 87,21,67,183,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 237)
		{ { 154,164,79,195,0 }, { 51,73,20,47,3 }, { 12,63,34,85,9 }, { 207,66,137,44,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 238)
		{ { 189,236,27,211,12 }, { 147,76,245,126,11 }, { 60,189,131,123,13 }, { 215,234,243,44,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 239)
		{ { 224,32,185,247,12 }, { 25,128,231,158,7 }, { 62,249,208,64,7 }, { 231,158,112,25,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 240)
		{ { 75,143,53,251,0 }, { 18,35,154,253,15 }, { 13,250,207,29,2 }, { 251,245,156,68,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 241)
		{ { 184,22,95,99,7 }, { 118,89,110,62,1 }, { 236,111,166,129,13 }, { 135,199,105,166,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 242)
		{ { 51,220,136,214,9 }, { 76,140,181,105,11 }, { 150,177,19,188,12 }, { 217,106,211,19,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 243)
		{ { 16,162,247,228,13 }, { 61,201,91,24,6 }, { 178,126,244,80,8 }, { 97,141,169,59,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 244)
		{ { 200,203,95,245,3 }, { 62,87,158,158,10 }, { 202,255,173,49,3 }, { 87,151,158,167,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 245)
		{ { 222,37,159,246,11 }, { 159,219,135,187,3 }, { 214,255,154,71,11 }, { 205,222,29,191,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 246)
		{ { 70,208,112,221,4 }, { 232,36,208,157,6 }, { 43,176,224,182,2 }, { 107,144,178,65,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 247)
		{ { 50,211,185,116,1 }, { 92,142,190,25,4 }, { 130,233,220,180,12 }, { 41,135,215,19,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 248)
		{ { 112,117,241,192,4 }, { 113,142,96,184,6 }, { 32,56,250,224,14 }, { 97,208,103,24,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 249)
		{ { 77,88,219,234,0 }, { 242,228,6,216,11 }, { 5,125,177,171,2 }, { 209,182,2,116,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 250)
	#error invalid ARUCO_DB_SIZE, max database size for this aruco type is 250
	#endif

};

#elif (ARUCO_DB == ARUCO_DB_APRILTAG_16h5)

#ifndef ARUCO_DB_SIZE
#define ARUCO_DB_SIZE 30
#endif

#define ARUCO_BITS	4

static unsigned char database[ARUCO_DB_SIZE][4][2] = {
	#if (ARUCO_DB_SIZE > 0)
		{ { 216,196 }, { 128,190 }, { 35,27 }, { 125,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1)
		{ { 165,116 }, { 106,120 }, { 46,165 }, { 30,86 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2)
		{ { 86,44 }, { 134,209 }, { 52,106 }, { 139,97 }, },
	#endif
	#if (ARUCO_DB_SIZE > 3)
		{ { 157,162 }, { 195,78 }, { 69,185 }, { 114,195 }, },
	#endif
	#if (ARUCO_DB_SIZE > 4)
		{ { 101,158 }, { 105,211 }, { 121,166 }, { 203,150 }, },
	#endif
	#if (ARUCO_DB_SIZE > 5)
		{ { 214,254 }, { 167,251 }, { 127,107 }, { 223,229 }, },
	#endif
	#if (ARUCO_DB_SIZE > 6)
		{ { 26,205 }, { 148,55 }, { 179,88 }, { 236,41 }, },
	#endif
	#if (ARUCO_DB_SIZE > 7)
		{ { 162,231 }, { 31,58 }, { 231,69 }, { 92,248 }, },
	#endif
	#if (ARUCO_DB_SIZE > 8)
		{ { 154,127 }, { 183,61 }, { 254,89 }, { 188,237 }, },
	#endif
	#if (ARUCO_DB_SIZE > 9)
		{ { 182,168 }, { 142,75 }, { 21,109 }, { 210,113 }, },
	#endif
	#if (ARUCO_DB_SIZE > 10)
		{ { 208,28 }, { 160,153 }, { 56,11 }, { 153,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 11)
		{ { 213,15 }, { 209,217 }, { 240,171 }, { 155,139 }, },
	#endif
	#if (ARUCO_DB_SIZE > 12)
		{ { 33,176 }, { 106,2 }, { 13,132 }, { 64,86 }, },
	#endif
	#if (ARUCO_DB_SIZE > 13)
		{ { 108,226 }, { 11,230 }, { 71,54 }, { 103,208 }, },
	#endif
	#if (ARUCO_DB_SIZE > 14)
		{ { 78,49 }, { 54,196 }, { 140,114 }, { 35,108 }, },
	#endif
	#if (ARUCO_DB_SIZE > 15)
		{ { 8,245 }, { 50,54 }, { 175,16 }, { 108,76 }, },
	#endif
	#if (ARUCO_DB_SIZE > 16)
		{ { 60,144 }, { 168,70 }, { 9,60 }, { 98,21 }, },
	#endif
	#if (ARUCO_DB_SIZE > 17)
		{ { 45,201 }, { 88,103 }, { 147,180 }, { 230,26 }, },
	#endif
	#if (ARUCO_DB_SIZE > 18)
		{ { 192,165 }, { 18,154 }, { 165,3 }, { 89,72 }, },
	#endif
	#if (ARUCO_DB_SIZE > 19)
		{ { 241,98 }, { 203,168 }, { 70,143 }, { 21,211 }, },
	#endif
	#if (ARUCO_DB_SIZE > 20)
		{ { 236,135 }, { 25,222 }, { 225,55 }, { 123,152 }, },
	#endif
	#if (ARUCO_DB_SIZE > 21)
		{ { 169,234 }, { 75,47 }, { 87,149 }, { 244,210 }, },
	#endif
	#if (ARUCO_DB_SIZE > 22)
		{ { 66,251 }, { 55,163 }, { 223,66 }, { 197,236 }, },
	#endif
	#if (ARUCO_DB_SIZE > 23)
		{ { 184,56 }, { 170,13 }, { 28,29 }, { 176,85 }, },
	#endif
	#if (ARUCO_DB_SIZE > 24)
		{ { 59,151 }, { 253,22 }, { 233,220 }, { 104,191 }, },
	#endif
	#if (ARUCO_DB_SIZE > 25)
		{ { 181,206 }, { 201,123 }, { 115,173 }, { 222,147 }, },
	#endif
	#if (ARUCO_DB_SIZE > 26)
		{ { 250,181 }, { 190,158 }, { 173,95 }, { 121,125 }, },
	#endif
	#if (ARUCO_DB_SIZE > 27)
		{ { 12,171 }, { 19,71 }, { 213,48 }, { 226,200 }, },
	#endif
	#if (ARUCO_DB_SIZE > 28)
		{ { 83,224 }, { 198,162 }, { 7,202 }, { 69,99 }, },
	#endif
	#if (ARUCO_DB_SIZE > 29)
		{ { 116,245 }, { 186,242 }, { 175,46 }, { 79,93 }, },
	#endif
	#if (ARUCO_DB_SIZE > 30)
	#error invalid ARUCO_DB_SIZE, max database size for this aruco type is 30
	#endif

};

#elif (ARUCO_DB == ARUCO_DB_APRILTAG_25h9)

#ifndef ARUCO_DB_SIZE
#define ARUCO_DB_SIZE 35
#endif

#define ARUCO_BITS	5

static unsigned char database[ARUCO_DB_SIZE][4][4] = {
	#if (ARUCO_DB_SIZE > 0)
		{ { 143,211,170,1 }, { 234,146,237,1 }, { 170,229,248,1 }, { 219,164,171,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1)
		{ { 109,139,39,1 }, { 170,251,21,0 }, { 242,104,219,0 }, { 84,111,170,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2)
		{ { 22,208,222,1 }, { 94,6,244,1 }, { 189,133,180,0 }, { 151,176,61,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 3)
		{ { 179,147,87,1 }, { 62,118,217,0 }, { 245,100,230,1 }, { 77,183,62,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 4)
		{ { 115,40,116,1 }, { 28,189,146,0 }, { 151,10,103,0 }, { 36,222,156,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 5)
		{ { 221,18,172,0 }, { 164,145,124,1 }, { 26,164,93,1 }, { 159,68,146,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 6)
		{ { 103,234,238,0 }, { 98,191,182,1 }, { 59,171,243,0 }, { 182,254,163,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 7)
		{ { 213,186,96,1 }, { 46,157,78,0 }, { 131,46,213,1 }, { 57,92,186,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 8)
		{ { 231,69,93,1 }, { 89,117,157,1 }, { 221,81,115,1 }, { 220,215,77,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 9)
		{ { 17,101,123,0 }, { 85,214,3,1 }, { 111,83,68,0 }, { 224,53,213,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 10)
		{ { 228,155,129,0 }, { 34,105,109,0 }, { 64,236,147,1 }, { 91,75,34,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 11)
		{ { 130,77,138,0 }, { 65,10,169,1 }, { 40,217,32,1 }, { 202,168,65,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 12)
		{ { 117,19,219,0 }, { 52,119,101,1 }, { 109,228,87,0 }, { 211,119,22,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 13)
		{ { 152,112,167,1 }, { 204,194,122,0 }, { 242,135,12,1 }, { 47,33,153,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 14)
		{ { 75,152,26,1 }, { 154,27,192,1 }, { 172,12,233,0 }, { 129,236,44,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 15)
		{ { 65,65,182,1 }, { 88,147,49,0 }, { 182,193,65,0 }, { 70,100,141,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 16)
		{ { 172,7,198,1 }, { 169,38,61,0 }, { 177,240,26,1 }, { 94,50,74,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 17)
		{ { 129,217,185,0 }, { 82,216,105,1 }, { 78,205,192,1 }, { 203,13,165,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 18)
		{ { 35,119,206,1 }, { 105,54,243,1 }, { 185,247,98,0 }, { 231,182,75,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 19)
		{ { 144,92,117,0 }, { 85,204,88,0 }, { 87,29,4,1 }, { 13,25,213,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 20)
		{ { 138,62,250,0 }, { 177,142,234,1 }, { 47,190,40,1 }, { 171,184,198,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 21)
		{ { 63,236,133,1 }, { 207,120,182,0 }, { 208,155,254,0 }, { 54,143,121,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 22)
		{ { 70,169,59,0 }, { 18,203,135,1 }, { 110,74,177,0 }, { 240,233,164,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 23)
		{ { 162,116,1,1 }, { 73,96,202,0 }, { 192,23,34,1 }, { 41,131,73,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 24)
		{ { 52,42,195,1 }, { 44,110,38,0 }, { 225,170,22,0 }, { 50,59,26,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 25)
		{ { 37,240,225,0 }, { 66,244,102,0 }, { 67,135,210,0 }, { 51,23,161,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 26)
		{ { 144,226,137,0 }, { 102,64,42,1 }, { 72,163,132,1 }, { 170,1,51,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 27)
		{ { 15,33,102,1 }, { 136,150,151,0 }, { 179,66,120,0 }, { 116,180,136,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 28)
		{ { 165,79,19,0 }, { 113,122,13,0 }, { 100,121,82,1 }, { 88,47,71,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 29)
		{ { 221,124,193,0 }, { 197,93,110,0 }, { 65,159,93,1 }, { 59,93,81,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 30)
		{ { 254,142,154,0 }, { 183,43,172,1 }, { 44,184,191,1 }, { 154,234,118,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 31)
		{ { 10,11,60,1 }, { 184,136,145,1 }, { 158,104,40,0 }, { 196,136,142,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 32)
		{ { 139,80,95,0 }, { 208,86,216,1 }, { 125,5,104,1 }, { 141,181,5,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 33)
		{ { 13,198,237,1 }, { 235,212,52,1 }, { 219,177,216,0 }, { 150,21,235,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 34)
		{ { 115,137,157,0 }, { 22,121,177,1 }, { 92,200,231,0 }, { 198,207,52,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 35)
	#error invalid ARUCO_DB_SIZE, max database size for this aruco type is 35
	#endif

};

#elif (ARUCO_DB == ARUCO_DB_APRILTAG_36h10)

#ifndef ARUCO_DB_SIZE
#define ARUCO_DB_SIZE 2320
#endif

#define ARUCO_BITS	6

static unsigned char database[ARUCO_DB_SIZE][4][5] = {
	#if (ARUCO_DB_SIZE > 0)
		{ { 225,101,73,83,8 }, { 49,6,165,238,1 }, { 28,169,42,104,7 }, { 135,122,86,8,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1)
		{ { 50,53,132,160,4 }, { 65,139,98,33,2 }, { 32,82,26,196,12 }, { 72,68,109,24,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2)
		{ { 107,237,252,94,4 }, { 43,167,244,249,13 }, { 39,163,251,125,6 }, { 185,242,254,93,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 3)
		{ { 217,189,115,45,4 }, { 123,106,82,246,12 }, { 43,76,235,217,11 }, { 54,244,165,109,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 4)
		{ { 87,115,222,38,12 }, { 233,207,79,209,1 }, { 54,71,188,238,10 }, { 136,191,47,57,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 5)
		{ { 245,43,80,249,12 }, { 161,42,235,222,10 }, { 57,240,173,74,15 }, { 87,189,117,72,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 6)
		{ { 46,91,153,155,12 }, { 210,166,237,21,11 }, { 61,153,157,167,4 }, { 218,139,118,84,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 7)
		{ { 127,167,237,114,2 }, { 179,155,190,233,5 }, { 68,235,126,95,14 }, { 169,119,221,156,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 8)
		{ { 72,191,207,28,10 }, { 123,243,157,160,8 }, { 83,143,63,209,2 }, { 16,91,156,253,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 9)
		{ { 235,64,193,206,10 }, { 58,180,33,203,3 }, { 87,56,48,45,7 }, { 205,56,66,213,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 10)
		{ { 215,152,253,186,6 }, { 240,185,214,211,15 }, { 101,219,241,158,11 }, { 252,182,185,208,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 11)
		{ { 92,212,54,176,14 }, { 194,93,211,176,6 }, { 112,214,194,179,10 }, { 96,220,187,164,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 12)
		{ { 114,66,21,239,14 }, { 24,61,107,157,3 }, { 127,122,132,36,14 }, { 203,157,107,193,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 13)
		{ { 200,18,236,76,1 }, { 110,161,12,138,4 }, { 131,35,116,129,3 }, { 37,19,8,87,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 14)
		{ { 27,178,99,54,1 }, { 127,72,154,65,5 }, { 134,204,100,221,8 }, { 168,37,145,47,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 15)
		{ { 185,202,170,229,1 }, { 14,204,62,78,14 }, { 138,117,85,57,13 }, { 119,39,195,55,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 16)
		{ { 55,38,64,234,9 }, { 165,40,43,105,3 }, { 149,112,38,78,12 }, { 201,109,65,74,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 17)
		{ { 141,86,137,137,9 }, { 214,164,13,102,2 }, { 153,25,22,171,1 }, { 70,107,2,86,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 18)
		{ { 220,110,245,96,5 }, { 183,141,74,186,12 }, { 160,106,247,99,11 }, { 53,213,43,30,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 19)
		{ { 81,225,58,109,5 }, { 13,110,86,220,4 }, { 171,101,200,120,10 }, { 35,182,167,107,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 20)
		{ { 40,201,94,212,13 }, { 46,71,245,24,10 }, { 178,183,169,49,4 }, { 81,138,254,39,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 21)
		{ { 155,25,144,102,13 }, { 78,138,67,91,9 }, { 182,96,153,141,9 }, { 157,172,37,23,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 22)
		{ { 198,37,228,219,13 }, { 165,163,193,175,7 }, { 189,178,122,70,3 }, { 239,88,60,90,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 23)
		{ { 238,221,198,163,3 }, { 230,215,50,167,11 }, { 204,86,59,183,7 }, { 222,84,206,182,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 24)
		{ { 168,123,189,36,7 }, { 95,151,110,18,12 }, { 226,75,221,225,5 }, { 52,135,110,159,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 25)
		{ { 38,247,86,43,7 }, { 229,119,122,53,1 }, { 237,70,174,246,4 }, { 138,197,238,234,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 26)
		{ { 119,95,17,146,15 }, { 212,30,233,241,11 }, { 244,152,143,174,14 }, { 216,249,119,130,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 27)
		{ { 227,232,42,118,0 }, { 9,68,182,203,13 }, { 6,229,65,124,7 }, { 189,54,210,41,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 28)
		{ { 219,116,9,26,8 }, { 83,44,133,227,1 }, { 21,137,2,237,11 }, { 140,122,19,76,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 29)
		{ { 166,92,117,179,8 }, { 240,5,163,55,15 }, { 28,218,227,166,5 }, { 254,204,90,0,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 30)
		{ { 247,162,51,66,4 }, { 145,72,120,219,5 }, { 36,44,196,94,15 }, { 173,177,225,40,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 31)
		{ { 45,210,218,190,4 }, { 234,228,254,80,3 }, { 39,213,180,187,4 }, { 192,167,242,117,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 32)
		{ { 158,138,87,237,4 }, { 186,105,90,31,10 }, { 43,126,165,23,9 }, { 95,133,169,101,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 33)
		{ { 192,186,16,180,12 }, { 73,0,219,146,10 }, { 50,208,133,208,3 }, { 84,157,176,9,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 34)
		{ { 19,70,233,230,12 }, { 56,140,79,105,7 }, { 54,121,118,44,8 }, { 233,111,35,17,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 35)
		{ { 177,22,100,69,12 }, { 104,9,105,110,4 }, { 58,34,102,136,13 }, { 39,105,105,1,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 36)
		{ { 74,118,173,59,12 }, { 83,165,207,165,5 }, { 61,203,86,229,2 }, { 170,95,58,92,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 37)
		{ { 133,254,70,49,2 }, { 225,85,154,102,8 }, { 72,198,39,250,1 }, { 22,101,154,168,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 38)
		{ { 173,105,121,110,10 }, { 187,54,39,90,13 }, { 87,105,233,107,5 }, { 181,174,70,205,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 39)
		{ { 32,21,210,100,6 }, { 104,210,98,56,0 }, { 98,100,186,128,4 }, { 1,196,100,177,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 40)
		{ { 147,181,91,6,6 }, { 121,90,84,115,1 }, { 102,13,170,220,9 }, { 140,226,165,169,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 41)
		{ { 202,157,31,171,6 }, { 82,115,86,183,11 }, { 109,95,139,149,3 }, { 222,214,172,228,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 42)
		{ { 187,35,104,210,14 }, { 35,26,237,75,7 }, { 116,177,108,77,13 }, { 237,43,117,140,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 43)
		{ { 52,107,195,95,14 }, { 185,254,233,12,9 }, { 127,172,61,98,12 }, { 147,9,119,249,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 44)
		{ { 160,207,113,248,9 }, { 52,38,187,58,14 }, { 145,248,239,48,5 }, { 117,205,214,66,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 45)
		{ { 83,31,184,90,9 }, { 68,170,141,249,13 }, { 149,161,223,140,10 }, { 185,251,21,82,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 46)
		{ { 241,127,53,41,9 }, { 85,47,43,246,12 }, { 153,74,207,232,15 }, { 54,253,79,74,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 47)
		{ { 152,80,211,144,5 }, { 118,204,192,18,2 }, { 160,156,176,161,9 }, { 68,128,51,54,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 48)
		{ { 123,240,90,34,5 }, { 103,76,118,209,1 }, { 164,69,160,253,14 }, { 136,182,227,46,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 49)
		{ { 197,168,151,126,5 }, { 157,225,210,218,9 }, { 167,238,145,90,3 }, { 149,180,184,123,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 50)
		{ { 22,216,30,157,5 }, { 204,109,212,21,10 }, { 171,151,129,182,8 }, { 90,130,187,99,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 51)
		{ { 180,132,224,47,5 }, { 172,168,114,38,5 }, { 175,64,114,18,13 }, { 166,68,225,83,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 52)
		{ { 237,52,164,150,13 }, { 207,129,225,226,7 }, { 182,146,82,203,7 }, { 228,120,120,31,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 53)
		{ { 9,146,15,177,3 }, { 86,81,158,68,2 }, { 200,223,4,153,0 }, { 66,39,152,166,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 54)
		{ { 251,90,185,188,11 }, { 94,188,175,211,14 }, { 211,217,213,173,15 }, { 124,191,83,215,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 55)
		{ { 37,6,52,30,11 }, { 140,49,169,112,5 }, { 215,130,198,10,4 }, { 160,233,88,195,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 56)
		{ { 224,145,168,72,15 }, { 68,178,117,138,4 }, { 241,33,88,144,7 }, { 37,26,228,210,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 57)
		{ { 194,115,147,11,8 }, { 81,230,9,151,1 }, { 29,12,156,228,3 }, { 142,153,6,120,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 58)
		{ { 16,43,26,208,4 }, { 1,74,204,24,10 }, { 32,181,141,64,8 }, { 81,131,53,40,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 59)
		{ { 56,215,41,175,4 }, { 90,46,126,36,7 }, { 47,89,78,177,12 }, { 226,71,231,69,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 60)
		{ { 214,63,130,165,12 }, { 201,202,75,167,10 }, { 58,84,31,198,11 }, { 94,93,37,57,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 61)
		{ { 93,176,247,42,2 }, { 243,249,18,208,5 }, { 69,78,240,219,10 }, { 160,180,137,252,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 62)
		{ { 115,36,212,252,10 }, { 41,185,163,249,2 }, { 83,242,178,76,14 }, { 73,252,89,217,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 63)
		{ { 71,220,230,148,6 }, { 232,213,208,225,14 }, { 98,150,115,190,2 }, { 120,112,186,177,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 64)
		{ { 221,26,76,114,14 }, { 226,25,207,202,9 }, { 116,227,37,139,11 }, { 149,63,57,132,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 65)
		{ { 154,222,49,181,1 }, { 94,12,154,55,14 }, { 138,216,199,181,9 }, { 126,197,147,7,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 66)
		{ { 76,25,234,75,9 }, { 230,226,5,140,13 }, { 157,37,121,131,2 }, { 179,26,4,118,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 67)
		{ { 129,149,32,65,5 }, { 68,2,80,110,4 }, { 168,32,74,152,1 }, { 39,96,164,2,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 68)
		{ { 208,173,68,239,5 }, { 45,43,82,174,11 }, { 175,114,43,80,11 }, { 215,84,173,75,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 69)
		{ { 169,3,2,54,13 }, { 14,66,235,66,1 }, { 182,196,12,9,5 }, { 132,45,116,39,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 70)
		{ { 90,99,243,101,13 }, { 63,206,75,157,4 }, { 186,108,252,101,10 }, { 43,157,39,63,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 71)
		{ { 167,56,140,168,15 }, { 197,177,103,67,10 }, { 241,83,17,206,5 }, { 92,46,104,218,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 72)
		{ { 193,252,209,46,0 }, { 121,164,18,242,9 }, { 7,72,179,248,3 }, { 148,244,130,89,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 73)
		{ { 18,162,88,245,0 }, { 41,8,158,29,2 }, { 10,241,164,84,8 }, { 75,135,145,9,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 74)
		{ { 176,210,149,151,0 }, { 88,141,184,22,3 }, { 14,154,148,176,13 }, { 198,129,219,17,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 75)
		{ { 172,158,132,125,4 }, { 202,161,250,46,8 }, { 43,226,23,147,5 }, { 23,69,248,85,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 76)
		{ { 112,105,55,71,12 }, { 25,79,97,156,13 }, { 62,46,201,96,14 }, { 179,152,111,41,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 77)
		{ { 68,181,20,179,2 }, { 193,19,146,180,3 }, { 76,210,138,210,2 }, { 194,212,156,136,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 78)
		{ { 231,77,237,224,10 }, { 176,151,39,235,14 }, { 80,123,123,46,7 }, { 125,126,78,144,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 79)
		{ { 53,29,98,66,10 }, { 224,90,33,104,13 }, { 84,36,107,138,12 }, { 177,104,69,160,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 80)
		{ { 142,125,171,62,10 }, { 219,246,135,35,13 }, { 87,205,91,231,1 }, { 188,78,22,253,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 81)
		{ { 82,219,5,133,6 }, { 88,31,88,133,10 }, { 106,26,13,180,10 }, { 90,17,175,129,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 82)
		{ { 240,135,244,59,6 }, { 32,187,250,182,5 }, { 109,194,254,16,15 }, { 166,213,253,208,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 83)
		{ { 78,144,152,110,1 }, { 206,160,22,153,1 }, { 135,97,144,151,2 }, { 137,150,128,87,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 84)
		{ { 210,100,39,89,9 }, { 21,109,129,175,4 }, { 153,174,66,100,11 }, { 47,88,27,106,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 85)
		{ { 36,194,245,253,5 }, { 188,165,250,28,6 }, { 171,250,244,50,4 }, { 99,133,250,83,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 86)
		{ { 50,142,228,41,3 }, { 36,185,58,37,12 }, { 201,66,119,20,12 }, { 58,69,201,210,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 87)
		{ { 107,62,162,144,11 }, { 71,208,169,225,14 }, { 208,148,87,205,6 }, { 120,121,80,190,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 88)
		{ { 217,65,43,194,11 }, { 22,94,5,202,7 }, { 212,61,72,41,11 }, { 229,58,7,166,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 89)
		{ { 156,165,116,197,7 }, { 175,27,80,62,6 }, { 234,50,234,83,9 }, { 103,192,173,143,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 90)
		{ { 17,109,219,74,15 }, { 53,254,69,120,9 }, { 245,45,187,104,8 }, { 145,234,39,250,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 91)
		{ { 174,87,71,134,8 }, { 250,71,41,35,3 }, { 22,30,46,167,5 }, { 204,73,78,37,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 92)
		{ { 114,224,117,97,4 }, { 49,13,114,157,4 }, { 40,106,224,116,14 }, { 43,148,235,8,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 93)
		{ { 198,150,180,86,6 }, { 200,145,216,187,5 }, { 102,162,214,150,3 }, { 173,209,184,145,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 94)
		{ { 168,197,195,205,1 }, { 62,230,48,46,2 }, { 139,60,58,49,5 }, { 71,64,198,119,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 95)
		{ { 91,21,74,119,1 }, { 110,74,134,237,1 }, { 142,229,42,141,10 }, { 139,118,21,39,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 96)
		{ { 205,163,184,200,5 }, { 135,162,92,218,6 }, { 161,49,220,91,3 }, { 101,179,164,94,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 97)
		{ { 74,204,221,214,7 }, { 62,149,212,185,11 }, { 230,187,179,53,2 }, { 217,210,186,151,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 98)
		{ { 102,82,239,170,15 }, { 244,245,111,129,7 }, { 245,95,116,166,6 }, { 232,31,106,242,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 99)
		{ { 173,218,37,160,0 }, { 210,5,58,66,14 }, { 0,90,69,187,5 }, { 116,37,202,4,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 100)
		{ { 252,230,67,94,0 }, { 187,108,184,170,1 }, { 7,172,38,115,15 }, { 133,81,211,109,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 101)
		{ { 187,145,56,91,8 }, { 66,42,181,95,5 }, { 29,161,200,157,13 }, { 175,170,213,68,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 102)
		{ { 52,217,147,145,4 }, { 208,206,240,20,10 }, { 40,156,153,178,12 }, { 82,128,247,48,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 103)
		{ { 160,29,41,117,12 }, { 88,2,231,46,12 }, { 58,233,75,128,5 }, { 55,78,116,1,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 104)
		{ { 197,91,119,176,10 }, { 240,87,139,210,14 }, { 80,222,237,170,3 }, { 116,189,30,160,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 105)
		{ { 180,103,48,193,10 }, { 129,30,41,62,6 }, { 88,48,206,98,13 }, { 103,201,71,136,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 106)
		{ { 79,215,217,189,10 }, { 250,182,159,245,2 }, { 91,217,190,191,2 }, { 74,255,150,213,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 107)
		{ { 62,239,157,76,6 }, { 155,191,124,57,8 }, { 99,43,159,119,12 }, { 25,195,239,221,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 108)
		{ { 211,16,230,71,6 }, { 104,217,64,207,5 }, { 110,38,112,140,11 }, { 175,48,41,177,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 109)
		{ { 150,212,131,130,1 }, { 212,204,16,35,3 }, { 132,28,18,182,9 }, { 204,64,131,50,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 110)
		{ { 190,66,191,212,9 }, { 158,205,173,27,6 }, { 146,191,212,39,13 }, { 109,139,91,55,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 111)
		{ { 66,18,49,102,9 }, { 92,0,11,153,5 }, { 150,104,196,132,2 }, { 169,157,0,3,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 112)
		{ { 51,202,85,219,9 }, { 52,45,185,93,11 }, { 157,186,165,60,12 }, { 219,169,219,66,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 113)
		{ { 165,14,174,0,13 }, { 132,193,109,98,12 }, { 176,7,87,10,5 }, { 52,107,104,50,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 114)
		{ { 86,110,32,220,13 }, { 141,44,201,169,14 }, { 179,176,71,102,10 }, { 121,89,51,75,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 115)
		{ { 126,177,2,164,3 }, { 207,90,50,129,2 }, { 194,84,8,215,14 }, { 72,20,197,175,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 116)
		{ { 175,51,166,149,7 }, { 207,211,232,71,6 }, { 234,150,92,207,5 }, { 110,33,124,191,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 117)
		{ { 144,39,133,201,15 }, { 21,187,73,46,2 }, { 249,58,30,64,9 }, { 71,73,45,218,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 118)
		{ { 26,175,114,194,0 }, { 35,74,24,57,15 }, { 4,52,239,85,8 }, { 249,193,133,44,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 119)
		{ { 140,72,88,22,8 }, { 170,4,133,18,9 }, { 22,129,161,35,1 }, { 148,138,18,5,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 120)
		{ { 221,184,28,187,8 }, { 195,41,151,214,11 }, { 29,211,129,219,11 }, { 214,190,153,76,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 121)
		{ { 41,92,192,64,12 }, { 98,132,97,104,8 }, { 48,32,51,169,4 }, { 17,104,98,20,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 122)
		{ { 204,21,5,90,14 }, { 210,51,193,170,1 }, { 117,170,10,131,3 }, { 133,88,60,196,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 123)
		{ { 218,107,24,244,9 }, { 15,14,143,155,10 }, { 146,241,141,101,11 }, { 93,159,23,15,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 124)
		{ { 167,135,108,37,9 }, { 172,3,63,103,4 }, { 154,67,110,30,5 }, { 46,111,204,3,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 125)
		{ { 246,183,42,152,5 }, { 197,106,252,163,6 }, { 161,149,78,214,15 }, { 108,83,245,106,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 126)
		{ { 176,8,245,30,13 }, { 60,169,225,18,13 }, { 183,138,241,0,13 }, { 180,136,121,83,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 127)
		{ { 75,168,124,205,13 }, { 47,33,85,221,14 }, { 187,51,225,93,2 }, { 123,186,168,79,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 128)
		{ { 132,228,215,70,3 }, { 189,213,16,58,1 }, { 198,46,178,114,1 }, { 133,192,138,187,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 129)
		{ { 108,145,86,98,0 }, { 226,67,50,152,1 }, { 4,102,168,147,6 }, { 129,148,204,36,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 130)
		{ { 161,89,232,111,0 }, { 104,166,38,78,13 }, { 15,97,121,168,5 }, { 183,38,70,81,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 131)
		{ { 240,101,172,214,8 }, { 9,143,165,170,7 }, { 22,179,90,96,15 }, { 229,90,95,25,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 132)
		{ { 151,176,34,145,10 }, { 193,88,145,71,6 }, { 88,148,64,222,9 }, { 110,40,145,168,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 133)
		{ { 191,36,1,206,6 }, { 155,56,96,107,3 }, { 103,56,2,79,13 }, { 205,96,97,205,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 134)
		{ { 164,202,31,226,1 }, { 148,69,62,26,11 }, { 132,127,133,50,5 }, { 213,135,202,34,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 135)
		{ { 17,222,135,135,9 }, { 92,205,25,100,11 }, { 158,30,23,184,8 }, { 210,105,139,51,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 136)
		{ { 57,73,184,51,5 }, { 6,142,230,84,13 }, { 172,193,217,41,12 }, { 178,166,119,22,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 137)
		{ { 134,25,53,96,13 }, { 212,3,67,27,12 }, { 176,106,201,134,1 }, { 61,140,44,2,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 138)
		{ { 200,75,66,10,11 }, { 38,118,9,130,9 }, { 213,4,45,33,3 }, { 148,25,6,230,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 139)
		{ { 81,136,22,43,15 }, { 4,121,83,212,9 }, { 253,70,129,24,10 }, { 146,188,169,226,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 140)
		{ { 198,116,204,159,0 }, { 233,165,132,167,3 }, { 15,147,50,230,3 }, { 206,82,26,89,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 141)
		{ { 168,22,147,66,12 }, { 82,192,105,58,1 }, { 52,44,150,129,5 }, { 133,201,96,52,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 142)
		{ { 91,182,26,190,12 }, { 75,104,223,241,3 }, { 55,213,134,221,10 }, { 200,255,177,109,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 143)
		{ { 64,57,11,138,10 }, { 81,114,5,128,11 }, { 85,29,9,192,2 }, { 208,26,4,232,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 144)
		{ { 49,229,119,99,10 }, { 49,95,51,124,5 }, { 92,110,234,120,12 }, { 163,236,207,168,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 145)
		{ { 138,181,190,128,6 }, { 67,211,84,51,6 }, { 96,23,218,213,1 }, { 108,194,172,188,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 146)
		{ { 232,127,242,172,9 }, { 111,230,43,178,14 }, { 147,84,255,225,7 }, { 116,221,70,127,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 147)
		{ { 133,144,118,85,9 }, { 236,65,145,94,4 }, { 154,166,224,154,1 }, { 39,168,152,35,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 148)
		{ { 173,4,85,41,5 }, { 182,33,98,118,0 }, { 169,74,162,11,5 }, { 6,228,104,70,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 149)
		{ { 94,100,156,243,5 }, { 135,141,198,189,3 }, { 172,243,146,103,10 }, { 203,214,59,30,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 150)
		{ { 113,188,174,157,13 }, { 77,233,245,228,14 }, { 187,151,83,216,14 }, { 114,122,249,123,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 151)
		{ { 202,194,32,47,13 }, { 14,36,91,135,5 }, { 191,64,68,53,3 }, { 174,29,162,71,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 152)
		{ { 237,109,12,225,0 }, { 131,7,38,238,10 }, { 8,115,11,107,7 }, { 87,118,78,12,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 153)
		{ { 211,179,54,142,8 }, { 73,107,25,211,7 }, { 23,22,204,220,11 }, { 236,185,141,105,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 154)
		{ { 88,251,152,132,4 }, { 75,142,92,144,10 }, { 34,17,157,241,10 }, { 80,147,167,29,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 155)
		{ { 66,176,73,175,12 }, { 121,32,87,133,3 }, { 63,89,32,212,2 }, { 202,30,160,73,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 156)
		{ { 165,172,222,241,10 }, { 161,209,183,126,10 }, { 88,247,179,90,5 }, { 87,238,216,184,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 157)
		{ { 126,74,98,45,6 }, { 170,124,106,133,12 }, { 107,68,101,39,14 }, { 58,21,99,229,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 158)
		{ { 93,233,95,78,9 }, { 191,111,21,216,9 }, { 151,47,169,123,10 }, { 145,186,143,111,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 159)
		{ { 34,197,24,23,9 }, { 12,6,181,53,1 }, { 158,129,138,52,4 }, { 138,202,214,3,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 160)
		{ { 115,117,108,186,5 }, { 101,47,230,225,7 }, { 165,211,106,236,14 }, { 232,118,127,74,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 161)
		{ { 80,47,87,216,11 }, { 53,123,137,184,10 }, { 209,190,175,64,10 }, { 81,217,29,234,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 162)
		{ { 154,160,25,211,11 }, { 23,24,149,31,3 }, { 220,185,128,85,9 }, { 207,138,145,142,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 163)
		{ { 61,180,129,166,15 }, { 223,152,115,96,3 }, { 246,88,18,219,12 }, { 192,108,225,159,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 164)
		{ { 39,218,159,156,8 }, { 216,229,189,81,10 }, { 19,159,149,190,4 }, { 88,171,218,113,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 165)
		{ { 58,103,134,237,6 }, { 11,255,106,45,2 }, { 107,118,30,101,12 }, { 75,69,111,253,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 166)
		{ { 132,55,15,143,6 }, { 217,115,76,38,3 }, { 111,31,14,194,1 }, { 198,67,44,233,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 167)
		{ { 53,66,74,6,5 }, { 172,76,108,64,1 }, { 166,5,36,42,12 }, { 128,35,99,35,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 168)
		{ { 131,37,139,194,7 }, { 21,210,68,107,3 }, { 228,61,26,76,1 }, { 205,98,36,186,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 169)
		{ { 6,72,246,57,4 }, { 160,229,194,21,12 }, { 41,198,241,38,0 }, { 58,132,58,112,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 170)
		{ { 46,148,213,97,12 }, { 242,129,115,61,0 }, { 56,106,178,151,4 }, { 11,204,232,20,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 171)
		{ { 72,50,160,103,2 }, { 75,144,10,140,5 }, { 78,96,84,193,2 }, { 163,21,0,157,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 172)
		{ { 228,117,33,147,1 }, { 213,6,160,166,7 }, { 140,152,74,226,7 }, { 230,80,86,10,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 173)
		{ { 110,253,140,158,9 }, { 207,167,181,161,11 }, { 151,147,27,247,6 }, { 216,90,222,95,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 174)
		{ { 0,211,242,119,9 }, { 108,198,155,28,5 }, { 158,228,252,176,0 }, { 163,141,150,51,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 175)
		{ { 99,216,68,68,11 }, { 108,21,49,201,8 }, { 210,34,33,188,6 }, { 25,56,202,131,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 176)
		{ { 249,28,183,98,7 }, { 86,217,98,250,13 }, { 228,110,211,137,15 }, { 181,244,105,182,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 177)
		{ { 148,34,208,61,7 }, { 173,184,202,22,0 }, { 235,192,180,66,9 }, { 6,133,49,219,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 178)
		{ { 187,200,20,31,6 }, { 10,61,240,87,9 }, { 111,130,129,61,13 }, { 158,160,251,197,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 179)
		{ { 69,152,237,76,14 }, { 248,177,85,200,12 }, { 115,43,113,154,2 }, { 49,58,168,209,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 180)
		{ { 83,226,244,224,9 }, { 37,141,27,217,6 }, { 144,114,244,124,10 }, { 105,189,139,26,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 181)
		{ { 241,178,125,130,9 }, { 117,9,61,210,7 }, { 148,27,228,216,15 }, { 228,187,201,10,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 182)
		{ { 42,202,178,62,9 }, { 14,228,187,17,13 }, { 151,196,213,53,4 }, { 184,141,210,119,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 183)
		{ { 123,122,214,143,9 }, { 111,237,41,213,11 }, { 159,22,181,237,14 }, { 218,185,75,127,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 184)
		{ { 130,225,42,209,13 }, { 5,70,213,15,6 }, { 184,181,72,116,1 }, { 111,10,182,42,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 185)
		{ { 37,245,188,164,11 }, { 205,151,55,112,6 }, { 210,83,218,250,4 }, { 96,238,206,155,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 186)
		{ { 150,173,51,250,11 }, { 149,122,147,59,15 }, { 213,252,203,86,9 }, { 253,204,149,234,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 187)
		{ { 116,221,218,89,11 }, { 228,254,181,188,8 }, { 217,165,187,178,14 }, { 19,218,215,242,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 188)
		{ { 190,51,16,82,7 }, { 199,26,232,27,1 }, { 228,160,140,199,13 }, { 141,129,117,142,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 189)
		{ { 175,106,142,227,12 }, { 131,197,111,79,11 }, { 60,119,21,111,5 }, { 223,47,106,60,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 190)
		{ { 80,157,15,85,14 }, { 88,91,213,172,8 }, { 122,175,11,144,10 }, { 19,90,189,161,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 191)
		{ { 90,168,135,202,13 }, { 23,233,81,137,11 }, { 181,62,17,85,10 }, { 217,24,169,126,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 192)
		{ { 248,216,14,113,13 }, { 70,77,247,142,8 }, { 184,231,1,177,15 }, { 23,30,251,38,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 193)
		{ { 18,41,212,58,0 }, { 33,171,130,17,9 }, { 5,194,185,68,8 }, { 152,132,29,88,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 194)
		{ { 58,213,230,98,8 }, { 98,207,51,41,5 }, { 20,102,122,181,12 }, { 169,76,207,52,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 195)
		{ { 68,63,156,94,2 }, { 201,179,140,184,9 }, { 71,163,159,194,2 }, { 145,211,28,217,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 196)
		{ { 53,224,26,247,2 }, { 137,92,182,92,3 }, { 78,245,128,122,12 }, { 195,166,211,169,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 197)
		{ { 82,84,77,114,6 }, { 112,29,198,169,1 }, { 100,235,34,164,10 }, { 137,86,59,128,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 198)
		{ { 8,222,33,65,9 }, { 86,4,25,44,12 }, { 152,40,71,177,0 }, { 51,73,130,6,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 199)
		{ { 151,233,242,229,5 }, { 173,206,82,95,14 }, { 170,116,249,126,9 }, { 127,164,167,59,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 200)
		{ { 117,185,123,135,5 }, { 253,74,116,212,15 }, { 174,29,233,218,14 }, { 242,178,229,43,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 201)
		{ { 28,149,63,106,13 }, { 214,107,87,56,5 }, { 181,111,202,147,8 }, { 161,206,173,102,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 202)
		{ { 72,136,208,174,15 }, { 46,176,83,144,11 }, { 247,80,177,17,2 }, { 208,156,160,215,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 203)
		{ { 35,82,133,125,8 }, { 88,165,171,77,0 }, { 27,234,20,172,4 }, { 11,45,90,81,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 204)
		{ { 145,10,12,159,8 }, { 8,41,141,70,11 }, { 31,147,5,8,9 }, { 214,43,25,65,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 205)
		{ { 114,106,253,204,4 }, { 57,173,108,153,14 }, { 35,59,245,100,14 }, { 121,147,107,89,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 206)
		{ { 70,182,223,184,12 }, { 241,225,223,177,2 }, { 49,223,182,214,2 }, { 72,223,184,120,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 207)
		{ { 55,30,152,201,12 }, { 192,168,109,125,10 }, { 57,49,151,142,12 }, { 91,235,97,80,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 208)
		{ { 242,133,64,180,10 }, { 40,26,179,163,2 }, { 82,208,42,20,15 }, { 76,92,213,129,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 209)
		{ { 155,53,4,69,10 }, { 75,27,1,111,0 }, { 90,34,10,205,9 }, { 15,104,13,141,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 210)
		{ { 138,236,145,248,13 }, { 23,164,211,59,10 }, { 177,248,147,117,1 }, { 93,204,178,94,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 211)
		{ { 173,85,173,77,15 }, { 222,183,101,110,4 }, { 251,43,90,171,5 }, { 39,106,110,215,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 212)
		{ { 42,24,202,208,2 }, { 98,208,164,9,10 }, { 64,181,49,133,4 }, { 89,2,80,180,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 213)
		{ { 237,2,60,165,10 }, { 138,17,47,214,6 }, { 90,83,196,11,7 }, { 102,191,72,133,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 214)
		{ { 190,137,112,155,1 }, { 166,42,176,23,15 }, { 141,144,233,23,13 }, { 254,128,213,70,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 215)
		{ { 66,233,185,200,9 }, { 21,166,21,153,14 }, { 145,57,217,116,2 }, { 121,154,134,90,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 216)
		{ { 224,185,52,114,9 }, { 69,3,179,154,13 }, { 148,226,201,208,7 }, { 181,156,220,10,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 217)
		{ { 135,32,220,54,11 }, { 173,145,135,83,1 }, { 214,195,176,78,1 }, { 140,174,24,155,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 218)
		{ { 93,132,96,137,7 }, { 166,56,80,228,6 }, { 233,16,98,27,10 }, { 98,112,161,198,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 219)
		{ { 144,204,205,2,15 }, { 52,157,85,34,9 }, { 244,11,51,48,9 }, { 148,74,171,146,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 220)
		{ { 140,134,212,168,8 }, { 162,161,27,50,2 }, { 17,82,182,19,1 }, { 68,205,136,84,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 221)
		{ { 120,169,76,36,12 }, { 43,11,119,128,8 }, { 50,67,41,81,14 }, { 16,30,237,13,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 222)
		{ { 182,101,251,203,12 }, { 177,238,101,63,7 }, { 61,61,250,102,13 }, { 239,202,103,120,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 223)
		{ { 39,167,32,26,6 }, { 129,50,248,97,5 }, { 101,128,78,94,4 }, { 168,97,244,200,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 224)
		{ { 193,202,69,13,5 }, { 60,37,88,198,8 }, { 171,10,37,56,3 }, { 22,49,170,67,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 225)
		{ { 75,38,242,6,13 }, { 47,192,73,241,5 }, { 182,4,246,77,2 }, { 168,249,32,63,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 226)
		{ { 146,37,46,39,11 }, { 13,91,7,39,5 }, { 222,71,74,68,9 }, { 174,78,13,171,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 227)
		{ { 240,175,98,24,8 }, { 33,106,185,162,12 }, { 17,132,111,80,15 }, { 52,89,213,104,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 228)
		{ { 50,161,124,11,6 }, { 33,59,116,21,5 }, { 109,3,232,84,12 }, { 170,130,237,200,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 229)
		{ { 107,9,58,162,14 }, { 2,82,103,209,15 }, { 116,85,201,13,6 }, { 248,190,100,164,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 230)
		{ { 134,231,189,205,5 }, { 157,167,92,63,6 }, { 171,59,222,118,1 }, { 111,195,174,91,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 231)
		{ { 70,76,128,181,11 }, { 140,148,131,165,10 }, { 218,208,19,38,2 }, { 90,92,18,147,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 232)
		{ { 110,146,188,233,7 }, { 198,177,126,157,6 }, { 233,115,212,151,6 }, { 107,151,232,214,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 233)
		{ { 10,141,210,173,4 }, { 42,226,82,53,10 }, { 43,84,187,21,0 }, { 90,196,164,117,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 234)
		{ { 133,26,254,234,9 }, { 228,225,15,90,15 }, { 149,119,245,138,1 }, { 245,175,8,114,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 235)
		{ { 102,122,112,73,9 }, { 229,36,41,157,12 }, { 153,32,229,230,6 }, { 59,153,66,74,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 236)
		{ { 113,49,97,102,13 }, { 125,10,99,200,5 }, { 182,104,104,200,14 }, { 161,60,101,11,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 237)
		{ { 197,119,160,82,15 }, { 197,150,201,234,5 }, { 244,160,94,234,3 }, { 165,121,54,154,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 238)
		{ { 224,70,76,187,12 }, { 32,37,239,166,3 }, { 61,211,38,32,7 }, { 198,95,122,64,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 239)
		{ { 244,9,85,141,10 }, { 184,59,33,150,10 }, { 91,26,169,2,15 }, { 86,152,77,193,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 240)
		{ { 34,79,148,169,9 }, { 4,167,43,53,10 }, { 153,82,159,36,4 }, { 90,205,78,82,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 241)
		{ { 229,88,200,244,13 }, { 236,132,231,202,10 }, { 178,241,49,170,7 }, { 85,62,114,19,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 242)
		{ { 243,18,209,192,11 }, { 116,152,41,219,2 }, { 208,56,180,140,15 }, { 77,185,65,146,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 243)
		{ { 41,114,88,124,11 }, { 111,52,175,88,0 }, { 211,225,164,233,4 }, { 1,175,82,207,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 244)
		{ { 65,179,38,98,4 }, { 65,67,90,200,5 }, { 36,102,76,216,2 }, { 161,53,172,40,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 245)
		{ { 218,87,244,214,12 }, { 106,143,201,187,7 }, { 54,178,254,165,11 }, { 237,217,63,21,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 246)
		{ { 186,1,109,186,9 }, { 54,43,167,3,7 }, { 149,219,104,5,13 }, { 236,14,93,70,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 247)
		{ { 53,137,198,176,5 }, { 164,203,242,64,10 }, { 160,214,57,26,12 }, { 80,36,253,50,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 248)
		{ { 223,69,8,189,5 }, { 142,46,198,231,2 }, { 171,209,10,47,11 }, { 78,118,55,71,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 249)
		{ { 50,82,34,250,8 }, { 64,108,171,9,7 }, { 21,244,68,164,12 }, { 233,13,83,96,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 250)
		{ { 87,54,121,125,4 }, { 249,40,206,253,4 }, { 43,233,230,206,10 }, { 43,247,49,73,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 251)
		{ { 100,77,74,190,10 }, { 168,118,167,160,11 }, { 87,213,43,34,6 }, { 208,94,86,225,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 252)
		{ { 13,189,14,79,10 }, { 203,115,21,108,9 }, { 95,39,11,219,0 }, { 147,106,140,237,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 253)
		{ { 20,18,155,246,13 }, { 220,200,207,24,3 }, { 182,253,148,130,8 }, { 193,143,49,51,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 254)
		{ { 160,137,141,158,1 }, { 28,163,180,2,11 }, { 135,155,25,16,5 }, { 212,2,220,83,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 255)
		{ { 116,80,182,226,11 }, { 196,221,35,152,7 }, { 212,118,208,162,14 }, { 225,156,75,178,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 256)
		{ { 224,228,28,54,7 }, { 13,21,246,178,1 }, { 230,195,130,112,7 }, { 132,214,250,139,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 257)
		{ { 105,149,101,253,11 }, { 126,51,179,236,6 }, { 219,250,106,153,6 }, { 99,124,220,199,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 258)
		{ { 103,160,233,22,8 }, { 185,128,181,193,5 }, { 22,137,112,94,6 }, { 168,58,208,25,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 259)
		{ { 25,252,180,77,12 }, { 75,173,81,124,12 }, { 59,34,211,249,8 }, { 51,232,171,93,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 260)
		{ { 240,254,74,108,6 }, { 105,124,126,170,8 }, { 99,101,39,240,15 }, { 21,87,227,233,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 261)
		{ { 78,229,220,11,14 }, { 163,183,85,181,1 }, { 125,3,186,119,2 }, { 138,218,174,220,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 262)
		{ { 178,90,177,231,7 }, { 92,156,106,31,15 }, { 238,120,213,164,13 }, { 255,133,99,147,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 263)
		{ { 84,197,166,143,13 }, { 140,239,81,164,7 }, { 191,22,90,50,10 }, { 226,88,175,115,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 264)
		{ { 247,21,47,212,3 }, { 220,91,164,235,6 }, { 194,191,74,142,15 }, { 109,114,93,163,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 265)
		{ { 79,145,125,232,10 }, { 242,51,23,217,6 }, { 81,123,232,159,2 }, { 105,190,140,196,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 266)
		{ { 9,53,24,238,6 }, { 75,50,70,120,3 }, { 103,113,138,201,0 }, { 193,230,36,205,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 267)
		{ { 170,77,229,141,6 }, { 58,183,96,39,14 }, { 107,26,123,37,5 }, { 126,64,110,213,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 268)
		{ { 251,189,163,100,14 }, { 91,218,115,235,12 }, { 114,108,91,221,15 }, { 61,124,229,189,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 269)
		{ { 194,140,79,157,13 }, { 60,97,213,167,10 }, { 187,159,35,20,3 }, { 94,90,184,99,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 270)
		{ { 221,221,90,236,8 }, { 234,110,23,250,10 }, { 19,117,171,187,11 }, { 85,254,135,101,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 271)
		{ { 154,123,45,105,4 }, { 83,47,78,15,12 }, { 41,107,77,229,9 }, { 63,7,47,76,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 272)
		{ { 218,46,220,145,1 }, { 39,137,140,183,10 }, { 136,147,183,69,11 }, { 94,211,25,30,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 273)
		{ { 18,21,66,25,5 }, { 100,106,192,37,0 }, { 169,132,42,132,8 }, { 10,64,53,98,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 274)
		{ { 58,253,126,65,13 }, { 103,79,117,61,12 }, { 184,39,235,245,12 }, { 59,202,239,46,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 275)
		{ { 210,145,48,33,12 }, { 64,10,83,151,4 }, { 56,64,200,148,11 }, { 46,156,165,0,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 276)
		{ { 136,91,123,237,6 }, { 122,118,78,30,14 }, { 107,125,237,161,1 }, { 119,135,38,229,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 277)
		{ { 255,26,148,3,13 }, { 198,137,105,215,9 }, { 188,2,149,143,15 }, { 158,185,105,22,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 278)
		{ { 138,210,5,218,10 }, { 82,53,153,11,3 }, { 85,186,4,181,1 }, { 205,9,154,196,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 279)
		{ { 124,254,229,86,14 }, { 251,157,249,168,13 }, { 118,170,119,243,14 }, { 177,89,251,157,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 280)
		{ { 15,29,188,45,9 }, { 206,163,7,117,12 }, { 155,67,219,143,0 }, { 58,238,12,87,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 281)
		{ { 173,125,51,119,9 }, { 223,70,163,126,13 }, { 158,236,203,235,5 }, { 183,236,86,47,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 282)
		{ { 94,35,218,148,5 }, { 175,202,204,145,2 }, { 162,149,188,71,10 }, { 72,147,53,63,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 283)
		{ { 202,135,100,114,13 }, { 38,3,219,171,5 }, { 180,226,110,21,3 }, { 173,93,188,6,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 284)
		{ { 42,52,86,226,7 }, { 103,81,98,57,3 }, { 228,118,162,197,4 }, { 201,196,104,174,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 285)
		{ { 179,128,104,125,6 }, { 40,56,246,79,4 }, { 107,225,96,28,13 }, { 47,38,241,193,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 286)
		{ { 73,224,165,31,6 }, { 27,181,208,196,5 }, { 111,138,80,121,2 }, { 162,48,186,221,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 287)
		{ { 144,226,83,62,9 }, { 61,108,155,18,1 }, { 151,204,164,112,9 }, { 132,141,147,107,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 288)
		{ { 221,1,6,99,13 }, { 134,75,67,206,1 }, { 188,102,8,11,11 }, { 135,60,45,38,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 289)
		{ { 118,160,92,144,8 }, { 161,9,181,145,2 }, { 16,147,160,86,14 }, { 72,154,217,8,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 290)
		{ { 14,217,3,223,6 }, { 218,118,208,13,11 }, { 111,188,9,183,0 }, { 219,0,182,229,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 291)
		{ { 43,112,183,113,13 }, { 87,197,227,93,4 }, { 184,238,208,237,4 }, { 43,172,122,62,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 292)
		{ { 78,140,226,119,3 }, { 174,208,146,173,13 }, { 206,228,115,23,2 }, { 187,84,144,183,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 293)
		{ { 164,109,4,140,4 }, { 137,39,96,34,10 }, { 35,18,11,98,5 }, { 84,64,110,73,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 294)
		{ { 174,72,136,91,10 }, { 130,180,165,15,9 }, { 93,161,17,39,5 }, { 159,10,82,212,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 295)
		{ { 10,163,70,143,3 }, { 47,115,24,5,3 }, { 207,22,44,85,0 }, { 202,1,140,239,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 296)
		{ { 106,225,111,19,7 }, { 55,87,244,133,5 }, { 236,143,104,117,6 }, { 170,18,254,174,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 297)
		{ { 149,35,13,186,13 }, { 149,43,207,66,3 }, { 181,219,12,74,9 }, { 196,47,61,74,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 298)
		{ { 228,136,181,77,4 }, { 152,161,112,158,12 }, { 43,42,209,18,7 }, { 55,144,232,81,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 299)
		{ { 121,10,75,108,10 }, { 58,120,47,200,8 }, { 83,109,37,9,14 }, { 17,63,65,229,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 300)
		{ { 64,35,127,147,9 }, { 53,67,141,148,7 }, { 156,159,236,64,2 }, { 226,155,28,42,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 301)
		{ { 45,191,41,200,3 }, { 215,50,60,104,14 }, { 193,57,79,219,4 }, { 113,99,196,206,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 302)
		{ { 202,214,76,54,0 }, { 106,5,158,163,1 }, { 6,195,38,181,3 }, { 140,87,154,5,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 303)
		{ { 211,175,89,151,10 }, { 57,26,157,247,11 }, { 94,153,175,92,11 }, { 222,251,149,137,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 304)
		{ { 157,46,167,143,5 }, { 159,233,72,102,15 }, { 175,30,87,75,9 }, { 246,97,41,127,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 305)
		{ { 34,211,98,6,7 }, { 108,86,120,1,5 }, { 230,4,108,180,4 }, { 168,1,230,163,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 306)
		{ { 204,169,43,134,6 }, { 155,82,84,130,15 }, { 102,29,73,83,3 }, { 244,18,164,173,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 307)
		{ { 85,43,159,167,1 }, { 157,203,14,212,11 }, { 142,95,157,74,10 }, { 210,183,13,59,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 308)
		{ { 203,178,173,205,11 }, { 95,177,29,207,6 }, { 219,59,84,221,3 }, { 111,59,136,223,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 309)
		{ { 68,250,70,198,7 }, { 237,85,88,136,11 }, { 230,54,37,242,2 }, { 209,17,170,171,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 310)
		{ { 231,38,143,185,7 }, { 149,241,238,231,2 }, { 233,223,22,78,7 }, { 78,119,120,250,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 311)
		{ { 36,175,23,170,2 }, { 145,115,58,48,11 }, { 69,94,143,82,4 }, { 208,197,204,232,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 312)
		{ { 67,232,194,173,10 }, { 41,244,19,197,10 }, { 91,84,49,124,2 }, { 90,60,130,249,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 313)
		{ { 145,205,26,71,13 }, { 12,78,85,126,9 }, { 190,37,139,56,9 }, { 151,234,167,35,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 314)
		{ { 104,5,2,194,10 }, { 2,82,33,168,3 }, { 84,52,10,1,6 }, { 193,88,68,164,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 315)
		{ { 5,213,122,29,10 }, { 232,118,149,116,4 }, { 91,133,234,186,0 }, { 34,234,150,225,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 316)
		{ { 88,51,178,20,8 }, { 75,202,137,144,4 }, { 18,132,220,193,10 }, { 32,153,21,61,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 317)
		{ { 207,23,24,178,4 }, { 194,2,206,243,3 }, { 36,209,142,143,3 }, { 204,247,52,4,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 318)
		{ { 86,20,124,139,2 }, { 224,57,4,181,7 }, { 77,19,226,134,10 }, { 234,210,9,192,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 319)
		{ { 254,81,189,45,1 }, { 222,175,38,151,4 }, { 139,75,216,167,15 }, { 46,150,79,87,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 320)
		{ { 48,238,165,168,4 }, { 17,173,122,32,14 }, { 33,90,87,112,12 }, { 112,69,235,88,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 321)
		{ { 94,27,78,166,2 }, { 234,91,14,129,11 }, { 70,87,45,135,10 }, { 216,23,13,165,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 322)
		{ { 37,57,142,52,3 }, { 205,211,166,64,8 }, { 194,199,25,202,4 }, { 16,38,92,187,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 323)
		{ { 71,238,53,187,2 }, { 145,53,154,245,15 }, { 77,218,199,126,2 }, { 250,245,154,200,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 324)
		{ { 105,226,147,152,11 }, { 23,244,185,208,2 }, { 209,156,148,121,6 }, { 64,185,210,254,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 325)
		{ { 203,235,3,139,4 }, { 19,102,88,199,11 }, { 45,28,13,125,3 }, { 222,49,166,108,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 326)
		{ { 151,33,193,117,9 }, { 189,138,131,79,0 }, { 154,232,56,78,9 }, { 15,44,21,27,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 327)
		{ { 117,81,72,151,9 }, { 236,14,165,196,3 }, { 158,145,40,170,14 }, { 194,58,87,3,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 328)
		{ { 87,243,99,229,3 }, { 253,94,26,205,6 }, { 202,124,108,254,10 }, { 107,53,135,171,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 329)
		{ { 174,100,20,104,0 }, { 131,37,34,59,0 }, { 1,98,130,103,5 }, { 13,196,74,76,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 330)
		{ { 126,147,161,155,5 }, { 214,170,248,133,7 }, { 173,152,92,151,14 }, { 234,17,245,86,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 331)
		{ { 169,131,209,245,2 }, { 58,146,186,94,2 }, { 74,248,188,25,5 }, { 71,165,212,149,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 332)
		{ { 100,91,1,175,9 }, { 220,38,43,132,11 }, { 159,88,13,162,6 }, { 210,29,70,67,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 333)
		{ { 13,167,121,86,5 }, { 191,2,220,120,5 }, { 166,169,238,91,0 }, { 161,227,180,15,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 334)
		{ { 114,16,159,147,13 }, { 84,201,229,149,3 }, { 188,159,144,132,14 }, { 202,154,121,50,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 335)
		{ { 141,12,71,198,11 }, { 190,81,1,106,11 }, { 214,62,35,11,1 }, { 213,104,8,167,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 336)
		{ { 109,229,76,66,3 }, { 167,23,52,232,1 }, { 196,35,42,123,6 }, { 129,114,206,142,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 337)
		{ { 241,35,191,102,11 }, { 29,219,47,218,5 }, { 214,111,220,72,15 }, { 165,191,77,187,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 338)
		{ { 180,231,234,99,7 }, { 165,222,126,46,5 }, { 236,101,126,114,13 }, { 167,71,231,186,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 339)
		{ { 229,224,226,108,5 }, { 173,228,114,202,4 }, { 163,100,112,122,7 }, { 37,52,226,123,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 340)
		{ { 90,49,4,158,15 }, { 79,59,193,129,3 }, { 247,146,8,197,10 }, { 200,24,61,207,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 341)
		{ { 137,248,81,23,11 }, { 127,20,145,86,9 }, { 222,136,161,249,1 }, { 150,168,146,143,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 342)
		{ { 111,187,159,46,10 }, { 219,243,63,209,9 }, { 87,79,157,223,6 }, { 152,191,204,253,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 343)
		{ { 80,175,172,250,6 }, { 1,187,222,168,15 }, { 101,243,95,80,10 }, { 241,87,189,216,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 344)
		{ { 181,113,7,57,6 }, { 209,127,226,70,0 }, { 105,206,8,234,13 }, { 6,36,127,232,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 345)
		{ { 121,119,47,9,2 }, { 83,127,44,228,4 }, { 73,15,78,233,14 }, { 34,115,79,236,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 346)
		{ { 177,29,65,73,3 }, { 116,58,32,110,8 }, { 201,40,43,136,13 }, { 23,96,69,194,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 347)
		{ { 29,227,35,74,14 }, { 147,126,89,72,5 }, { 117,44,76,123,8 }, { 161,41,167,236,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 348)
		{ { 179,148,34,108,13 }, { 76,104,115,107,4 }, { 179,100,66,156,13 }, { 45,108,225,99,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 349)
		{ { 44,126,92,173,1 }, { 239,37,46,52,10 }, { 139,83,167,227,4 }, { 82,199,74,79,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 350)
		{ { 95,115,48,151,13 }, { 207,14,201,213,7 }, { 190,144,204,239,10 }, { 234,185,55,15,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 351)
		{ { 69,251,224,160,13 }, { 229,134,91,192,14 }, { 176,80,125,250,2 }, { 112,61,166,26,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 352)
		{ { 9,122,74,176,0 }, { 99,68,142,64,10 }, { 0,213,37,233,0 }, { 80,39,18,44,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 353)
		{ { 179,119,146,163,10 }, { 65,222,43,119,3 }, { 92,84,158,236,13 }, { 206,237,71,184,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 354)
		{ { 98,35,175,220,7 }, { 29,243,236,137,6 }, { 227,191,92,68,6 }, { 105,19,124,251,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 355)
		{ { 108,155,99,108,9 }, { 254,98,59,136,12 }, { 147,108,109,147,6 }, { 49,29,196,103,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 356)
		{ { 155,78,142,46,9 }, { 14,237,15,99,9 }, { 151,71,23,45,9 }, { 156,111,11,119,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 357)
		{ { 249,195,194,21,3 }, { 46,222,184,198,0 }, { 202,132,60,57,15 }, { 6,49,215,183,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 358)
		{ { 119,43,15,234,11 }, { 149,123,47,201,11 }, { 213,127,13,78,14 }, { 217,63,77,234,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 359)
		{ { 102,250,154,171,4 }, { 193,228,126,149,11 }, { 45,85,149,246,6 }, { 218,151,226,120,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 360)
		{ { 116,98,77,223,13 }, { 189,45,237,140,3 }, { 191,187,36,98,14 }, { 195,27,123,75,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 361)
		{ { 25,222,78,102,4 }, { 106,77,94,104,9 }, { 38,103,39,185,8 }, { 145,103,171,37,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 362)
		{ { 148,41,230,53,14 }, { 169,219,195,6,12 }, { 122,198,121,66,9 }, { 54,12,61,185,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 363)
		{ { 76,236,163,246,4 }, { 155,196,210,168,15 }, { 38,252,83,115,2 }, { 241,84,178,61,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 364)
		{ { 164,180,6,106,6 }, { 193,113,114,42,1 }, { 101,102,2,210,5 }, { 133,68,232,232,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 365)
		{ { 30,86,88,215,4 }, { 234,12,204,61,3 }, { 46,177,166,167,8 }, { 203,195,51,5,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 366)
		{ { 219,73,192,161,2 }, { 34,158,2,199,10 }, { 72,80,57,45,11 }, { 94,52,7,148,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 367)
		{ { 79,81,144,218,7 }, { 198,182,192,217,3 }, { 229,176,152,175,2 }, { 201,176,54,214,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 368)
		{ { 1,67,44,173,5 }, { 12,39,78,68,6 }, { 171,83,76,40,0 }, { 98,39,46,67,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 369)
		{ { 82,252,40,115,9 }, { 69,12,151,173,13 }, { 156,225,67,244,10 }, { 187,94,147,10,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 370)
		{ { 67,147,62,210,15 }, { 68,83,221,217,7 }, { 244,183,204,156,2 }, { 233,187,188,162,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 371)
		{ { 107,7,29,172,0 }, { 26,35,46,241,2 }, { 3,91,142,13,6 }, { 72,247,76,69,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 372)
		{ { 81,13,171,142,1 }, { 28,234,4,224,15 }, { 135,29,91,8,10 }, { 240,114,5,115,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 373)
		{ { 80,201,26,157,10 }, { 8,126,149,148,10 }, { 91,149,137,48,10 }, { 82,154,151,225,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 374)
		{ { 95,229,148,45,0 }, { 139,175,18,245,0 }, { 11,66,154,127,10 }, { 10,244,143,93,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 375)
		{ { 88,194,177,178,10 }, { 18,156,155,144,7 }, { 84,216,212,49,10 }, { 224,157,147,148,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 376)
		{ { 137,65,77,139,14 }, { 50,55,69,70,3 }, { 125,27,40,41,1 }, { 198,42,46,196,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 377)
		{ { 132,10,38,120,5 }, { 132,97,202,10,12 }, { 161,230,69,2,1 }, { 53,5,56,98,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 378)
		{ { 185,96,91,1,13 }, { 55,76,101,86,0 }, { 184,13,160,105,13 }, { 6,170,99,46,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 379)
		{ { 20,186,220,247,7 }, { 237,153,222,28,11 }, { 238,243,181,210,8 }, { 211,135,185,155,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 380)
		{ { 246,219,203,198,4 }, { 248,206,124,139,11 }, { 38,61,61,182,15 }, { 221,19,231,49,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 381)
		{ { 192,171,73,169,0 }, { 49,34,30,134,10 }, { 9,89,45,80,3 }, { 86,23,132,72,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 382)
		{ { 153,38,27,157,2 }, { 27,120,140,118,2 }, { 75,157,134,73,9 }, { 70,227,17,237,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 383)
		{ { 97,25,251,19,6 }, { 112,210,228,212,13 }, { 108,141,249,136,6 }, { 178,178,116,176,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 384)
		{ { 136,247,2,236,5 }, { 79,102,90,42,2 }, { 163,116,14,241,1 }, { 69,69,166,111,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 385)
		{ { 59,109,198,146,3 }, { 39,223,160,97,11 }, { 196,150,59,109,12 }, { 216,96,95,190,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 386)
		{ { 78,98,149,182,0 }, { 155,133,138,145,3 }, { 6,218,148,103,2 }, { 200,149,26,29,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 387)
		{ { 217,253,38,220,10 }, { 75,127,145,234,14 }, { 83,182,75,249,11 }, { 117,120,159,237,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 388)
		{ { 185,170,215,180,13 }, { 63,201,251,82,10 }, { 178,222,181,89,13 }, { 84,173,249,63,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 389)
		{ { 77,237,86,136,15 }, { 167,119,81,240,10 }, { 241,22,171,123,2 }, { 80,248,174,238,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 390)
		{ { 32,85,135,53,1 }, { 92,199,162,36,0 }, { 138,206,26,160,4 }, { 2,68,94,51,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 391)
		{ { 229,194,49,87,1 }, { 156,4,184,222,5 }, { 142,168,196,58,7 }, { 167,177,210,3,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 392)
		{ { 203,185,136,37,6 }, { 75,146,86,199,8 }, { 106,65,25,221,3 }, { 30,54,164,157,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 393)
		{ { 43,23,42,185,9 }, { 70,98,175,101,6 }, { 153,213,78,141,4 }, { 106,111,84,102,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 394)
		{ { 171,204,25,105,3 }, { 22,52,54,127,8 }, { 201,105,131,61,5 }, { 31,230,194,198,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 395)
		{ { 136,158,50,170,15 }, { 70,112,91,50,15 }, { 245,84,199,145,1 }, { 244,205,160,230,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 396)
		{ { 13,103,151,181,12 }, { 155,199,203,116,2 }, { 58,222,158,107,0 }, { 66,237,62,61,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 397)
		{ { 110,236,61,135,6 }, { 155,21,116,181,15 }, { 110,27,195,119,6 }, { 250,210,234,141,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 398)
		{ { 163,18,150,137,14 }, { 64,241,105,87,2 }, { 121,22,148,140,5 }, { 78,169,104,240,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 399)
		{ { 49,39,126,125,11 }, { 45,123,175,124,4 }, { 219,231,238,72,12 }, { 35,239,93,235,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 400)
		{ { 197,59,33,41,14 }, { 209,50,75,198,12 }, { 121,72,77,202,3 }, { 54,61,36,200,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 401)
		{ { 14,92,116,153,15 }, { 230,53,193,53,14 }, { 249,146,227,167,0 }, { 122,200,58,198,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 402)
		{ { 206,216,31,33,1 }, { 214,69,22,151,8 }, { 136,79,129,183,3 }, { 30,150,138,38,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 403)
		{ { 17,190,238,22,3 }, { 109,217,156,96,13 }, { 198,135,119,216,8 }, { 176,99,153,187,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 404)
		{ { 91,246,119,192,6 }, { 115,93,88,249,6 }, { 96,62,230,253,10 }, { 105,241,171,172,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 405)
		{ { 205,49,157,20,14 }, { 219,147,197,210,0 }, { 114,139,152,203,3 }, { 4,186,60,157,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 406)
		{ { 33,104,14,72,13 }, { 5,101,101,72,8 }, { 177,39,1,104,4 }, { 17,42,106,106,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 407)
		{ { 40,39,132,250,11 }, { 7,179,171,40,3 }, { 213,242,30,65,4 }, { 193,77,92,222,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 408)
		{ { 168,244,166,26,0 }, { 67,229,176,34,5 }, { 5,134,82,241,5 }, { 164,64,218,124,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 409)
		{ { 49,118,81,59,4 }, { 113,44,234,116,1 }, { 45,200,166,232,12 }, { 130,229,115,72,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 410)
		{ { 247,105,206,110,2 }, { 169,255,38,203,9 }, { 71,103,57,110,15 }, { 157,54,79,249,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 411)
		{ { 83,146,163,177,13 }, { 84,200,219,197,6 }, { 184,220,84,156,10 }, { 106,61,177,50,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 412)
		{ { 88,101,173,108,15 }, { 31,191,71,168,4 }, { 243,107,90,97,10 }, { 33,94,47,223,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 413)
		{ { 190,115,121,11,0 }, { 243,46,44,23,5 }, { 13,9,236,231,13 }, { 174,131,71,76,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 414)
		{ { 90,232,238,91,11 }, { 39,253,149,141,13 }, { 221,167,113,117,10 }, { 187,26,155,254,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 415)
		{ { 139,106,57,122,0 }, { 19,36,142,91,13 }, { 5,233,197,109,1 }, { 189,167,18,76,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 416)
		{ { 163,233,94,124,14 }, { 41,119,247,91,8 }, { 115,231,169,124,5 }, { 29,174,254,233,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 417)
		{ { 91,159,159,132,13 }, { 94,203,93,241,10 }, { 178,31,159,157,10 }, { 88,251,173,55,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 418)
		{ { 47,75,147,199,11 }, { 158,214,41,93,11 }, { 222,60,157,47,4 }, { 219,169,70,183,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 419)
		{ { 76,117,32,169,6 }, { 195,54,66,164,6 }, { 105,80,74,227,2 }, { 98,84,38,204,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 420)
		{ { 98,163,2,254,14 }, { 9,114,251,137,3 }, { 119,244,12,84,6 }, { 201,29,244,233,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 421)
		{ { 103,190,132,139,7 }, { 197,177,120,229,11 }, { 237,18,23,222,6 }, { 218,113,232,218,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 422)
		{ { 183,81,31,133,12 }, { 216,79,101,87,2 }, { 58,31,136,174,13 }, { 78,170,111,33,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 423)
		{ { 24,89,92,70,7 }, { 110,31,68,24,9 }, { 230,35,169,161,8 }, { 145,130,47,135,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 424)
		{ { 21,230,55,117,0 }, { 153,77,154,124,4 }, { 10,238,198,122,8 }, { 35,229,155,41,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 425)
		{ { 152,85,193,87,13 }, { 126,142,193,46,1 }, { 190,168,58,161,9 }, { 135,72,55,23,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 426)
		{ { 221,31,87,116,9 }, { 254,75,139,250,8 }, { 146,238,175,139,11 }, { 21,253,29,39,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 427)
		{ { 116,139,16,186,5 }, { 132,42,250,144,11 }, { 165,208,141,18,14 }, { 208,149,245,66,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 428)
		{ { 28,253,149,152,1 }, { 215,175,144,48,10 }, { 129,154,155,243,8 }, { 80,192,159,94,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 429)
		{ { 99,111,43,206,2 }, { 25,118,44,233,15 }, { 71,61,79,108,6 }, { 249,115,70,233,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 430)
		{ { 175,140,36,152,13 }, { 134,33,241,99,14 }, { 177,146,67,31,5 }, { 124,104,248,70,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 431)
		{ { 33,45,73,54,5 }, { 61,2,230,96,9 }, { 166,201,43,72,4 }, { 144,102,116,11,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 432)
		{ { 173,161,22,32,14 }, { 131,83,115,82,0 }, { 112,70,136,91,5 }, { 4,172,236,172,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 433)
		{ { 239,49,13,89,13 }, { 215,35,229,207,0 }, { 185,171,8,207,7 }, { 15,58,124,78,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 434)
		{ { 155,50,155,65,14 }, { 83,216,77,95,0 }, { 120,45,148,205,9 }, { 15,171,33,188,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 435)
		{ { 95,76,1,168,15 }, { 150,60,67,225,10 }, { 241,88,3,47,10 }, { 88,124,35,198,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 436)
		{ { 110,151,175,238,0 }, { 218,227,62,169,7 }, { 7,127,94,151,6 }, { 233,87,204,117,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 437)
		{ { 129,68,91,180,8 }, { 56,68,135,114,2 }, { 18,221,162,40,1 }, { 68,238,18,33,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 438)
		{ { 196,142,130,78,7 }, { 140,240,88,170,9 }, { 231,36,23,18,3 }, { 149,81,160,243,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 439)
		{ { 225,39,182,160,12 }, { 1,195,107,242,6 }, { 48,86,222,72,7 }, { 100,253,108,56,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 440)
		{ { 88,201,151,188,7 }, { 30,255,210,144,10 }, { 227,222,153,49,10 }, { 80,148,191,247,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 441)
		{ { 37,121,224,205,7 }, { 237,182,96,76,14 }, { 235,48,121,234,4 }, { 115,32,102,219,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 442)
		{ { 107,93,4,34,7 }, { 70,23,98,225,9 }, { 228,66,11,173,6 }, { 152,116,110,134,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 443)
		{ { 109,39,67,156,2 }, { 187,114,168,224,2 }, { 67,156,46,75,6 }, { 64,113,84,237,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 444)
		{ { 168,101,37,190,2 }, { 27,55,162,34,7 }, { 71,218,74,97,5 }, { 228,68,94,205,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 445)
		{ { 197,187,243,235,0 }, { 241,226,26,222,15 }, { 13,124,253,218,3 }, { 247,181,132,120,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 446)
		{ { 224,138,63,86,10 }, { 24,81,189,154,13 }, { 86,175,197,16,7 }, { 181,155,216,161,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 447)
		{ { 209,250,49,233,7 }, { 85,60,90,222,14 }, { 233,120,197,248,11 }, { 119,181,163,202,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 448)
		{ { 102,72,123,117,10 }, { 184,84,167,157,12 }, { 90,237,225,38,6 }, { 59,158,82,161,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 449)
		{ { 152,233,237,143,5 }, { 63,175,84,6,15 }, { 175,27,121,113,9 }, { 246,2,175,95,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 450)
		{ { 156,76,216,209,15 }, { 166,156,197,62,10 }, { 248,177,179,35,9 }, { 87,202,51,150,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 451)
		{ { 219,162,17,122,14 }, { 19,56,219,219,1 }, { 117,232,132,93,11 }, { 141,189,177,204,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 452)
		{ { 252,157,45,143,13 }, { 222,43,117,166,15 }, { 191,27,75,147,15 }, { 246,90,237,71,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 453)
		{ { 42,216,44,171,15 }, { 70,53,119,5,15 }, { 253,83,65,181,4 }, { 250,14,234,198,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 454)
		{ { 203,77,206,196,5 }, { 46,199,68,235,10 }, { 162,55,59,45,3 }, { 93,114,46,55,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 455)
		{ { 212,230,126,105,10 }, { 161,125,31,190,4 }, { 89,103,230,114,11 }, { 39,223,139,232,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 456)
		{ { 182,118,99,52,5 }, { 253,76,234,35,4 }, { 162,204,102,230,13 }, { 44,69,115,43,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 457)
		{ { 129,161,64,232,13 }, { 37,34,83,74,2 }, { 177,112,40,88,1 }, { 69,44,164,74,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 458)
		{ { 36,248,181,42,13 }, { 213,165,115,16,13 }, { 181,74,209,242,4 }, { 176,140,234,90,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 459)
		{ { 33,212,75,137,7 }, { 116,116,116,100,2 }, { 233,29,34,184,4 }, { 66,98,226,226,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 460)
		{ { 143,130,58,23,11 }, { 142,80,157,87,5 }, { 222,133,196,31,1 }, { 174,171,144,167,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 461)
		{ { 246,113,26,188,10 }, { 201,126,167,147,2 }, { 83,213,136,230,15 }, { 76,158,87,233,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 462)
		{ { 63,94,2,121,7 }, { 198,124,234,109,8 }, { 233,228,7,175,12 }, { 27,101,115,230,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 463)
		{ { 205,212,228,99,15 }, { 230,149,83,238,5 }, { 252,98,114,187,3 }, { 167,124,170,150,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 464)
		{ { 89,70,5,49,5 }, { 22,13,202,228,0 }, { 168,202,6,41,10 }, { 2,117,59,6,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 465)
		{ { 32,186,102,97,13 }, { 101,65,123,12,12 }, { 184,102,101,208,4 }, { 51,13,232,42,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 466)
		{ { 151,191,26,90,0 }, { 193,106,156,123,9 }, { 5,165,143,222,9 }, { 157,227,149,104,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 467)
		{ { 126,66,218,161,8 }, { 162,204,47,149,2 }, { 24,85,180,39,14 }, { 74,159,67,52,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 468)
		{ { 98,148,45,213,5 }, { 92,1,244,173,6 }, { 170,187,66,148,6 }, { 107,82,248,3,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 469)
		{ { 177,229,50,4,7 }, { 13,94,112,114,4 }, { 226,4,202,120,13 }, { 36,224,231,171,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 470)
		{ { 222,100,233,20,12 }, { 187,140,197,163,4 }, { 50,137,114,103,11 }, { 44,90,51,29,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 471)
		{ { 71,94,177,229,0 }, { 216,132,10,253,14 }, { 10,120,215,174,2 }, { 123,245,2,17,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 472)
		{ { 25,165,108,166,9 }, { 47,11,23,96,7 }, { 150,83,106,89,8 }, { 224,110,141,15,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 473)
		{ { 149,5,117,79,13 }, { 188,43,65,126,5 }, { 191,42,234,10,9 }, { 167,232,45,67,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 474)
		{ { 54,171,61,147,0 }, { 145,11,188,21,15 }, { 12,155,205,86,12 }, { 250,131,221,8,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 475)
		{ { 87,132,157,120,1 }, { 148,169,150,249,0 }, { 129,235,146,30,10 }, { 9,246,153,82,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 476)
		{ { 164,135,244,206,4 }, { 168,163,120,58,7 }, { 39,50,254,18,5 }, { 229,193,236,81,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 477)
		{ { 177,1,150,215,4 }, { 8,203,224,94,3 }, { 46,182,152,8,13 }, { 199,160,125,49,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 478)
		{ { 202,139,220,248,6 }, { 34,179,222,155,10 }, { 97,243,189,21,3 }, { 93,151,188,212,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 479)
		{ { 241,104,15,187,1 }, { 21,109,166,198,11 }, { 141,223,1,104,15 }, { 214,54,91,106,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 480)
		{ { 119,235,139,132,9 }, { 157,206,61,193,10 }, { 146,29,29,126,14 }, { 88,59,199,59,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 481)
		{ { 2,83,18,189,4 }, { 72,102,202,21,2 }, { 43,212,140,164,0 }, { 74,133,54,97,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 482)
		{ { 29,42,141,92,1 }, { 159,169,140,72,8 }, { 131,171,21,75,8 }, { 17,35,25,95,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 483)
		{ { 39,117,108,47,10 }, { 233,55,39,101,5 }, { 95,67,106,238,4 }, { 170,110,78,201,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 484)
		{ { 61,80,83,188,9 }, { 254,108,163,80,2 }, { 147,220,160,171,12 }, { 64,172,83,103,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 485)
		{ { 120,181,174,182,4 }, { 75,203,246,160,7 }, { 38,215,90,209,14 }, { 224,86,253,61,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 486)
		{ { 42,93,133,78,1 }, { 94,167,32,41,9 }, { 135,42,27,165,4 }, { 153,64,78,87,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 487)
		{ { 0,239,149,206,12 }, { 25,167,89,56,11 }, { 55,58,159,112,0 }, { 209,201,174,89,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 488)
		{ { 198,248,201,176,10 }, { 241,148,151,131,10 }, { 80,217,49,246,3 }, { 92,30,146,152,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 489)
		{ { 52,138,244,180,8 }, { 168,137,187,16,14 }, { 18,210,245,18,12 }, { 112,141,217,17,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 490)
		{ { 154,221,191,118,3 }, { 94,223,150,59,13 }, { 198,239,219,181,9 }, { 189,198,159,183,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 491)
		{ { 68,183,153,113,1 }, { 213,130,158,188,0 }, { 136,233,158,210,2 }, { 3,215,148,26,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 492)
		{ { 53,31,237,192,9 }, { 244,139,45,104,14 }, { 144,59,127,138,12 }, { 113,107,77,18,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 493)
		{ { 240,132,133,185,5 }, { 20,169,242,166,2 }, { 169,218,18,16,15 }, { 70,84,249,82,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 494)
		{ { 130,188,93,116,5 }, { 125,1,214,59,8 }, { 162,235,163,212,1 }, { 29,198,184,11,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 495)
		{ { 58,134,179,151,15 }, { 30,216,249,53,7 }, { 254,156,214,21,12 }, { 234,201,241,183,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 496)
		{ { 140,232,137,29,15 }, { 159,180,213,6,8 }, { 251,137,17,115,1 }, { 22,10,178,223,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 497)
		{ { 63,123,205,83,8 }, { 243,143,173,77,9 }, { 28,171,61,239,12 }, { 155,43,95,28,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 498)
		{ { 180,13,145,70,7 }, { 156,154,96,58,9 }, { 230,40,155,2,13 }, { 149,192,101,147,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 499)
		{ { 109,172,86,182,6 }, { 171,81,242,240,11 }, { 102,214,163,91,6 }, { 208,244,248,173,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 500)
		{ { 88,149,105,0,13 }, { 118,10,85,160,4 }, { 176,9,106,145,10 }, { 32,90,165,6,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 501)
		{ { 76,163,63,89,3 }, { 151,115,156,156,4 }, { 201,175,204,83,2 }, { 35,147,156,238,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 502)
		{ { 53,167,215,80,1 }, { 181,203,184,120,0 }, { 128,174,190,90,12 }, { 1,225,221,58,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 503)
		{ { 22,233,116,244,11 }, { 173,31,147,25,14 }, { 210,242,233,118,8 }, { 121,140,159,139,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 504)
		{ { 106,219,126,99,3 }, { 102,87,62,157,13 }, { 204,103,237,181,6 }, { 187,151,206,166,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 505)
		{ { 172,254,199,138,5 }, { 247,229,120,34,11 }, { 165,30,55,243,5 }, { 212,65,234,126,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 506)
		{ { 195,109,112,53,6 }, { 41,22,194,247,12 }, { 106,192,235,108,3 }, { 62,244,54,137,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 507)
		{ { 133,82,84,245,6 }, { 232,21,202,94,2 }, { 106,242,164,170,1 }, { 71,165,58,129,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 508)
		{ { 211,112,148,110,7 }, { 77,189,66,219,1 }, { 231,98,144,236,11 }, { 141,180,43,219,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 509)
		{ { 157,177,206,126,12 }, { 235,235,215,74,1 }, { 55,231,56,219,9 }, { 133,46,189,125,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 510)
		{ { 163,136,217,180,14 }, { 56,144,247,83,10 }, { 114,217,177,28,5 }, { 92,174,240,145,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 511)
		{ { 98,252,134,118,14 }, { 73,213,243,169,9 }, { 118,230,19,244,6 }, { 153,92,250,185,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 512)
		{ { 209,228,206,15,2 }, { 41,253,20,230,1 }, { 79,7,50,120,11 }, { 134,114,139,249,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 513)
		{ { 224,197,119,135,0 }, { 56,71,48,182,7 }, { 14,30,234,48,7 }, { 230,208,206,33,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 514)
		{ { 136,137,241,121,7 }, { 54,178,210,30,12 }, { 233,232,249,17,1 }, { 55,132,180,214,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 515)
		{ { 175,103,124,158,0 }, { 171,39,172,115,7 }, { 7,147,238,111,5 }, { 236,227,94,77,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 516)
		{ { 250,135,32,206,8 }, { 10,42,57,171,7 }, { 23,48,78,21,15 }, { 237,89,197,69,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 517)
		{ { 32,136,108,197,14 }, { 40,17,117,12,14 }, { 122,51,97,16,4 }, { 115,10,232,129,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 518)
		{ { 26,153,204,140,14 }, { 106,187,85,1,10 }, { 115,19,57,149,8 }, { 88,10,173,213,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 519)
		{ { 136,165,101,91,1 }, { 55,35,144,46,5 }, { 141,170,106,81,1 }, { 167,64,156,78,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 520)
		{ { 214,247,236,2,5 }, { 229,143,92,163,5 }, { 164,3,126,246,11 }, { 172,83,175,26,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 521)
		{ { 244,246,145,8,4 }, { 209,172,120,178,0 }, { 33,8,150,242,15 }, { 4,209,227,88,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 522)
		{ { 76,10,202,63,5 }, { 174,224,206,132,9 }, { 175,197,53,3,2 }, { 146,23,48,119,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 523)
		{ { 31,5,164,12,7 }, { 142,187,64,97,4 }, { 227,2,90,15,8 }, { 40,96,45,215,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 524)
		{ { 250,93,132,124,6 }, { 74,191,226,171,8 }, { 99,226,27,165,15 }, { 29,84,127,213,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 525)
		{ { 19,29,173,215,12 }, { 88,139,197,109,15 }, { 62,187,91,140,8 }, { 251,106,61,17,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 526)
		{ { 195,96,214,57,15 }, { 37,245,195,215,0 }, { 249,198,176,108,3 }, { 14,188,58,250,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 527)
		{ { 126,199,122,149,3 }, { 174,94,188,181,6 }, { 202,149,238,55,14 }, { 106,211,215,167,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 528)
		{ { 45,212,161,248,1 }, { 214,164,178,104,6 }, { 129,248,82,187,4 }, { 97,100,210,86,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 529)
		{ { 196,27,169,22,11 }, { 220,146,141,130,13 }, { 214,137,93,130,3 }, { 180,27,20,147,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 530)
		{ { 174,83,48,32,14 }, { 194,22,107,19,4 }, { 112,64,204,167,5 }, { 44,141,102,132,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 531)
		{ { 137,195,118,107,2 }, { 34,119,26,94,5 }, { 77,102,236,57,1 }, { 167,165,142,228,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 532)
		{ { 17,167,104,69,2 }, { 41,26,28,108,4 }, { 74,33,110,88,8 }, { 35,99,133,137,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 533)
		{ { 115,24,54,184,10 }, { 64,121,163,209,14 }, { 81,214,193,140,14 }, { 120,188,89,224,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 534)
		{ { 152,195,136,238,2 }, { 10,190,30,10,3 }, { 71,113,28,49,9 }, { 197,7,135,213,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 535)
		{ { 50,158,254,117,6 }, { 104,217,254,61,12 }, { 106,231,247,148,12 }, { 59,199,249,177,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 536)
		{ { 235,41,103,213,2 }, { 59,83,160,207,14 }, { 74,190,105,77,7 }, { 127,48,92,173,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 537)
		{ { 118,246,246,147,13 }, { 229,205,249,181,7 }, { 188,150,246,246,14 }, { 234,217,251,58,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 538)
		{ { 75,54,229,94,10 }, { 123,177,137,233,5 }, { 87,170,118,205,2 }, { 169,121,24,221,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 539)
		{ { 18,100,241,41,15 }, { 53,188,67,53,4 }, { 249,72,242,100,8 }, { 42,204,35,218,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 540)
		{ { 195,216,179,216,12 }, { 80,228,209,219,14 }, { 49,188,209,188,3 }, { 125,184,178,112,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 541)
		{ { 184,252,222,50,9 }, { 103,205,183,50,9 }, { 148,199,179,241,13 }, { 148,206,219,62,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 542)
		{ { 53,97,247,116,12 }, { 185,207,227,88,4 }, { 50,238,248,106,12 }, { 33,172,127,57,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 543)
		{ { 116,255,31,22,6 }, { 217,95,252,176,9 }, { 102,143,143,242,14 }, { 144,211,255,169,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 544)
		{ { 29,80,232,123,6 }, { 226,188,198,76,5 }, { 109,225,112,171,8 }, { 163,38,51,212,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 545)
		{ { 71,201,216,44,9 }, { 172,166,23,209,8 }, { 147,65,185,62,2 }, { 24,190,134,83,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 546)
		{ { 198,131,135,46,9 }, { 156,227,27,131,1 }, { 151,78,28,22,3 }, { 140,29,140,115,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 547)
		{ { 182,245,65,140,14 }, { 249,62,113,35,2 }, { 115,24,42,246,13 }, { 76,72,231,201,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 548)
		{ { 209,45,250,27,10 }, { 33,250,133,246,13 }, { 93,133,251,72,11 }, { 182,250,21,248,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 549)
		{ { 123,222,164,209,14 }, { 66,157,249,237,14 }, { 120,178,87,189,14 }, { 123,121,251,148,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 550)
		{ { 148,215,11,206,8 }, { 216,110,29,42,3 }, { 23,61,14,178,9 }, { 197,75,135,97,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 551)
		{ { 139,161,235,181,10 }, { 59,210,151,71,6 }, { 90,221,120,93,1 }, { 110,46,148,189,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 552)
		{ { 2,76,23,111,5 }, { 28,101,66,61,9 }, { 175,110,131,36,0 }, { 155,196,42,99,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 553)
		{ { 54,104,158,115,11 }, { 133,221,167,29,9 }, { 220,231,145,102,12 }, { 155,142,91,186,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 554)
		{ { 208,33,104,228,4 }, { 41,10,70,138,6 }, { 34,113,104,64,11 }, { 101,22,37,9,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 555)
		{ { 155,143,16,45,14 }, { 10,58,91,119,8 }, { 123,64,143,29,9 }, { 30,237,165,197,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 556)
		{ { 126,132,92,39,11 }, { 174,25,55,181,1 }, { 222,67,162,23,14 }, { 138,222,201,135,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 557)
		{ { 118,223,8,118,12 }, { 200,14,255,169,9 }, { 54,225,15,182,14 }, { 153,95,247,1,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 558)
		{ { 251,188,21,149,7 }, { 95,25,240,247,10 }, { 234,154,131,221,15 }, { 94,240,249,143,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 559)
		{ { 70,128,175,59,2 }, { 144,241,150,133,5 }, { 77,207,80,22,2 }, { 170,22,152,240,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 560)
		{ { 209,94,13,85,9 }, { 92,13,141,238,8 }, { 154,171,7,168,11 }, { 23,123,27,3,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 561)
		{ { 140,34,108,129,4 }, { 163,1,76,6,6 }, { 40,19,100,67,1 }, { 102,3,40,12,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 562)
		{ { 118,43,180,156,1 }, { 141,171,168,145,14 }, { 131,146,221,70,14 }, { 120,145,93,91,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 563)
		{ { 115,86,122,41,0 }, { 96,108,46,245,4 }, { 9,69,230,172,14 }, { 42,247,67,96,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 564)
		{ { 65,92,222,11,1 }, { 100,229,4,244,9 }, { 141,7,179,168,2 }, { 146,242,10,114,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 565)
		{ { 9,152,244,128,11 }, { 102,145,17,80,14 }, { 208,18,241,153,0 }, { 112,168,136,150,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 566)
		{ { 227,53,25,14,13 }, { 93,34,101,243,1 }, { 183,9,138,204,7 }, { 140,250,100,75,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 567)
		{ { 54,133,243,244,3 }, { 188,218,178,57,6 }, { 194,252,250,22,12 }, { 105,196,213,179,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 568)
		{ { 149,140,227,231,8 }, { 184,200,19,110,15 }, { 30,124,115,26,9 }, { 247,108,129,49,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 569)
		{ { 119,22,87,104,15 }, { 244,121,107,249,0 }, { 241,110,166,142,14 }, { 9,253,105,226,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 570)
		{ { 192,211,150,95,4 }, { 72,231,216,158,1 }, { 47,166,156,176,3 }, { 135,145,190,113,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 571)
		{ { 212,159,135,115,2 }, { 208,219,154,174,9 }, { 76,238,31,146,11 }, { 151,85,157,176,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 572)
		{ { 69,191,48,71,8 }, { 201,2,25,252,13 }, { 30,32,207,218,2 }, { 179,249,132,9,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 573)
		{ { 178,247,139,151,9 }, { 93,206,189,39,3 }, { 158,157,30,244,13 }, { 206,75,215,59,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 574)
		{ { 182,81,172,193,7 }, { 196,159,100,15,6 }, { 232,51,88,166,13 }, { 111,2,111,146,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 575)
		{ { 18,188,225,89,10 }, { 113,184,145,45,12 }, { 89,168,115,212,8 }, { 59,72,145,216,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 576)
		{ { 142,109,66,22,5 }, { 175,70,192,35,9 }, { 166,132,43,103,1 }, { 156,64,54,47,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 577)
		{ { 247,219,218,17,6 }, { 224,222,252,215,8 }, { 104,133,189,190,15 }, { 30,179,247,176,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 578)
		{ { 95,40,2,124,14 }, { 139,120,195,201,8 }, { 115,228,1,79,10 }, { 25,60,49,237,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 579)
		{ { 2,18,169,157,14 }, { 88,176,205,5,6 }, { 123,153,84,132,0 }, { 106,11,48,209,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 580)
		{ { 191,254,168,18,10 }, { 195,156,189,99,13 }, { 84,129,87,255,13 }, { 188,107,211,156,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 581)
		{ { 186,49,92,161,1 }, { 103,11,38,23,2 }, { 136,83,168,197,13 }, { 78,134,77,14,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 582)
		{ { 7,242,225,29,7 }, { 253,180,216,69,4 }, { 235,136,116,254,0 }, { 42,33,178,219,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 583)
		{ { 234,79,43,164,13 }, { 30,70,111,163,14 }, { 178,93,79,37,7 }, { 124,95,102,39,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 584)
		{ { 165,190,34,214,12 }, { 201,64,249,106,15 }, { 54,180,71,218,5 }, { 245,105,240,41,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 585)
		{ { 241,169,225,184,14 }, { 49,186,243,194,14 }, { 113,216,121,88,15 }, { 116,60,245,216,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 586)
		{ { 202,168,155,183,7 }, { 31,208,214,151,11 }, { 238,221,145,85,3 }, { 222,150,176,191,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 587)
		{ { 84,134,196,245,2 }, { 168,153,154,172,2 }, { 74,242,54,18,10 }, { 67,85,153,145,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 588)
		{ { 53,121,76,30,4 }, { 233,47,228,64,9 }, { 39,131,41,234,12 }, { 144,34,127,73,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 589)
		{ { 110,216,72,137,8 }, { 226,36,53,133,10 }, { 25,17,33,183,6 }, { 90,26,194,68,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 590)
		{ { 186,232,137,103,6 }, { 27,156,118,15,9 }, { 110,105,17,117,13 }, { 159,6,227,157,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 591)
		{ { 148,192,40,189,0 }, { 136,44,150,6,6 }, { 11,209,64,50,9 }, { 102,6,147,65,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 592)
		{ { 115,76,162,183,6 }, { 8,220,226,229,15 }, { 110,212,83,44,14 }, { 250,116,115,177,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 593)
		{ { 47,241,60,122,11 }, { 199,55,183,89,5 }, { 213,227,200,255,4 }, { 169,174,222,206,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 594)
		{ { 204,2,99,100,7 }, { 190,80,74,138,4 }, { 226,108,100,3,3 }, { 37,21,32,167,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 595)
		{ { 222,144,69,41,2 }, { 242,57,18,135,0 }, { 73,74,32,151,11 }, { 14,20,137,196,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 596)
		{ { 2,43,108,122,15 }, { 37,51,207,9,13 }, { 245,227,109,68,0 }, { 185,15,60,202,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 597)
		{ { 64,75,24,30,13 }, { 12,38,205,144,9 }, { 183,129,141,32,2 }, { 144,155,54,67,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 598)
		{ { 44,49,42,198,5 }, { 207,66,100,8,7 }, { 166,53,72,195,4 }, { 225,2,100,47,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 599)
		{ { 191,189,15,65,6 }, { 211,91,116,111,8 }, { 104,47,11,223,13 }, { 31,98,237,172,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 600)
		{ { 232,58,99,203,12 }, { 115,96,105,142,15 }, { 61,60,101,193,7 }, { 247,25,96,108,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 601)
		{ { 231,89,156,35,2 }, { 192,151,38,215,9 }, { 76,67,153,174,7 }, { 158,182,78,144,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 602)
		{ { 255,230,113,141,6 }, { 187,60,120,247,6 }, { 107,24,230,127,15 }, { 110,241,227,205,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 603)
		{ { 197,136,65,238,2 }, { 184,48,18,202,11 }, { 71,120,33,26,3 }, { 213,52,128,193,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 604)
		{ { 171,180,217,16,2 }, { 115,144,180,115,0 }, { 64,137,178,221,5 }, { 12,226,208,156,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 605)
		{ { 10,23,123,120,4 }, { 114,98,206,57,4 }, { 33,237,238,133,0 }, { 41,199,52,100,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 606)
		{ { 78,123,115,156,14 }, { 251,118,201,145,14 }, { 115,156,237,231,2 }, { 120,153,54,237,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 607)
		{ { 34,227,251,26,1 }, { 53,230,188,17,5 }, { 133,141,252,116,4 }, { 168,131,214,122,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 608)
		{ { 54,93,186,61,2 }, { 200,254,166,53,12 }, { 75,197,219,166,12 }, { 58,198,87,241,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 609)
		{ { 59,220,189,56,4 }, { 82,173,246,113,12 }, { 33,203,211,189,12 }, { 56,230,251,84,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 610)
		{ { 200,199,188,19,5 }, { 6,135,220,182,5 }, { 172,131,222,49,3 }, { 166,211,190,22,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 611)
		{ { 91,16,250,200,6 }, { 98,248,68,217,6 }, { 97,53,240,141,10 }, { 105,178,33,244,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 612)
		{ { 208,249,92,92,11 }, { 109,63,149,154,8 }, { 211,163,169,240,11 }, { 21,154,159,203,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 613)
		{ { 153,6,142,77,7 }, { 14,249,76,110,0 }, { 235,39,22,9,9 }, { 7,99,41,247,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 614)
		{ { 200,39,17,208,2 }, { 19,18,136,186,2 }, { 64,184,142,65,3 }, { 69,209,20,140,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 615)
		{ { 164,84,34,73,9 }, { 196,100,33,46,4 }, { 153,36,66,162,5 }, { 39,72,66,98,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 616)
		{ { 169,103,185,198,3 }, { 31,150,44,122,7 }, { 198,57,222,105,5 }, { 229,227,70,159,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 617)
		{ { 227,227,61,193,6 }, { 17,23,124,223,6 }, { 104,59,204,124,7 }, { 111,179,238,136,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 618)
		{ { 242,227,250,36,6 }, { 41,222,126,147,4 }, { 98,69,252,116,15 }, { 44,151,231,185,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 619)
		{ { 171,214,110,194,10 }, { 98,85,61,107,7 }, { 84,55,102,189,5 }, { 237,107,202,164,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 620)
		{ { 150,166,172,174,12 }, { 137,169,95,35,7 }, { 55,83,86,86,9 }, { 236,79,169,89,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 621)
		{ { 17,94,218,37,15 }, { 108,220,79,116,8 }, { 250,69,183,168,8 }, { 18,239,35,179,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 622)
		{ { 224,72,217,79,9 }, { 60,164,37,158,9 }, { 159,41,177,32,7 }, { 151,154,66,83,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 623)
		{ { 62,162,162,69,13 }, { 143,200,121,13,4 }, { 186,36,84,87,12 }, { 43,9,225,63,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 624)
		{ { 147,122,113,157,10 }, { 121,60,137,87,14 }, { 91,152,229,236,9 }, { 126,169,19,201,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 625)
		{ { 109,101,53,32,4 }, { 147,7,98,240,4 }, { 32,74,202,107,6 }, { 32,244,110,12,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 626)
		{ { 218,6,151,74,11 }, { 22,249,9,187,1 }, { 213,46,150,5,11 }, { 141,217,9,246,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 627)
		{ { 20,176,37,32,10 }, { 209,25,19,0,4 }, { 80,74,64,210,8 }, { 32,12,137,136,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 628)
		{ { 122,150,135,109,5 }, { 94,233,122,173,0 }, { 171,110,22,149,14 }, { 11,85,233,119,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 629)
		{ { 221,120,18,100,5 }, { 207,76,66,218,8 }, { 162,100,129,235,11 }, { 21,180,35,47,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 630)
		{ { 130,195,122,162,9 }, { 36,70,31,19,7 }, { 148,85,236,52,1 }, { 236,143,134,34,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 631)
		{ { 151,25,250,15,4 }, { 232,234,68,87,13 }, { 47,5,249,142,9 }, { 190,162,37,113,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 632)
		{ { 58,108,193,181,7 }, { 63,156,226,37,10 }, { 234,216,51,101,12 }, { 90,68,115,159,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 633)
		{ { 97,33,177,73,13 }, { 21,162,97,220,4 }, { 185,40,216,72,6 }, { 35,184,100,90,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 634)
		{ { 208,123,6,29,14 }, { 73,127,201,134,8 }, { 123,134,13,224,11 }, { 22,25,63,233,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 635)
		{ { 69,190,247,38,9 }, { 253,193,27,240,13 }, { 150,78,247,218,2 }, { 176,253,136,59,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 636)
		{ { 157,70,148,66,4 }, { 130,141,72,122,1 }, { 36,34,150,43,9 }, { 133,225,43,20,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 637)
		{ { 77,251,186,241,4 }, { 195,198,222,220,14 }, { 40,245,221,251,2 }, { 115,183,182,60,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 638)
		{ { 200,236,99,163,1 }, { 55,68,18,166,15 }, { 140,92,99,113,3 }, { 246,84,130,46,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 639)
		{ { 41,38,49,96,9 }, { 23,0,43,120,4 }, { 144,104,198,73,4 }, { 33,237,64,14,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 640)
		{ { 34,234,181,80,10 }, { 17,149,185,25,12 }, { 80,170,213,116,4 }, { 57,137,218,152,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 641)
		{ { 12,83,62,124,9 }, { 206,103,143,24,4 }, { 147,231,204,163,0 }, { 33,143,30,103,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 642)
		{ { 241,209,122,65,9 }, { 100,78,53,222,4 }, { 152,37,232,184,15 }, { 39,186,199,34,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 643)
		{ { 190,41,45,21,12 }, { 155,11,229,7,12 }, { 58,139,73,71,13 }, { 62,10,125,13,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 644)
		{ { 173,236,230,5,15 }, { 175,213,113,102,12 }, { 250,6,115,123,5 }, { 54,104,234,191,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 645)
		{ { 23,198,147,157,3 }, { 156,252,152,117,2 }, { 203,156,150,62,8 }, { 74,225,147,243,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 646)
		{ { 76,195,212,88,9 }, { 166,167,153,152,0 }, { 145,162,188,51,2 }, { 1,153,158,86,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 647)
		{ { 154,214,102,33,4 }, { 98,77,90,39,4 }, { 40,70,102,181,9 }, { 46,69,171,36,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 648)
		{ { 19,133,65,215,3 }, { 60,26,144,109,3 }, { 206,184,42,28,8 }, { 203,96,149,131,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 649)
		{ { 86,15,151,244,5 }, { 156,203,202,185,10 }, { 162,254,159,6,10 }, { 89,213,61,51,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 650)
		{ { 166,192,165,246,0 }, { 152,133,178,11,7 }, { 6,250,80,54,5 }, { 237,4,218,17,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 651)
		{ { 95,226,229,89,8 }, { 179,173,153,205,4 }, { 25,170,116,127,10 }, { 43,57,155,92,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 652)
		{ { 67,190,136,118,5 }, { 77,128,222,233,9 }, { 166,225,23,220,2 }, { 153,119,176,27,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 653)
		{ { 8,144,129,205,4 }, { 90,160,80,12,2 }, { 43,56,16,145,0 }, { 67,0,160,85,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 654)
		{ { 77,234,23,239,15 }, { 159,117,91,220,11 }, { 255,126,133,123,2 }, { 211,189,170,239,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 655)
		{ { 124,58,173,18,0 }, { 211,137,172,128,13 }, { 4,139,85,195,14 }, { 176,19,89,28,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 656)
		{ { 67,86,162,174,9 }, { 76,228,11,225,7 }, { 151,84,86,172,2 }, { 232,125,2,115,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 657)
		{ { 236,183,0,75,5 }, { 199,34,120,174,1 }, { 173,32,14,211,7 }, { 135,81,228,78,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 658)
		{ { 247,97,178,178,7 }, { 133,222,226,211,7 }, { 228,212,216,110,15 }, { 236,180,119,186,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 659)
		{ { 137,36,99,124,13 }, { 63,96,195,106,4 }, { 179,236,98,73,1 }, { 37,108,48,111,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 660)
		{ { 114,58,98,179,1 }, { 101,72,170,133,15 }, { 140,212,101,196,14 }, { 250,21,81,42,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 661)
		{ { 41,180,125,69,1 }, { 127,1,52,124,4 }, { 138,43,226,217,4 }, { 35,226,200,15,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 662)
		{ { 18,107,239,149,10 }, { 57,223,141,5,14 }, { 90,159,125,100,8 }, { 122,11,31,185,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 663)
		{ { 161,94,96,121,10 }, { 96,52,171,110,12 }, { 89,224,103,168,5 }, { 55,109,82,192,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 664)
		{ { 126,76,172,58,13 }, { 134,173,231,161,13 }, { 181,195,83,39,14 }, { 184,94,123,86,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 665)
		{ { 114,142,21,50,3 }, { 20,25,186,177,9 }, { 196,202,135,20,14 }, { 152,213,217,130,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 666)
		{ { 50,5,228,151,0 }, { 40,139,160,37,7 }, { 14,146,122,4,12 }, { 234,64,93,17,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 667)
		{ { 20,99,87,142,15 }, { 189,127,73,16,3 }, { 247,30,172,98,8 }, { 192,137,47,235,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 668)
		{ { 70,114,172,144,8 }, { 193,133,141,129,6 }, { 16,147,84,230,2 }, { 104,27,26,24,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 669)
		{ { 218,88,222,192,8 }, { 98,205,5,155,10 }, { 16,55,177,165,11 }, { 93,154,11,52,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 670)
		{ { 201,31,228,54,4 }, { 106,131,202,226,13 }, { 38,194,127,137,3 }, { 180,117,60,21,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 671)
		{ { 161,197,254,154,12 }, { 32,231,245,114,7 }, { 53,151,250,56,5 }, { 228,234,254,112,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 672)
		{ { 247,70,210,71,7 }, { 172,220,104,255,1 }, { 238,36,182,46,15 }, { 143,241,99,179,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 673)
		{ { 56,73,248,205,2 }, { 42,190,36,28,14 }, { 75,49,249,33,12 }, { 115,130,71,213,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 674)
		{ { 186,114,36,10,6 }, { 67,61,104,3,5 }, { 101,2,68,229,13 }, { 172,1,107,204,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 675)
		{ { 100,162,99,127,3 }, { 189,112,186,140,5 }, { 207,236,100,82,6 }, { 163,21,208,235,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 676)
		{ { 132,80,221,43,3 }, { 244,181,6,22,1 }, { 205,75,176,162,1 }, { 134,134,10,210,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 677)
		{ { 233,134,163,18,6 }, { 18,208,248,226,5 }, { 100,140,86,25,7 }, { 164,113,240,180,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 678)
		{ { 31,106,10,155,13 }, { 135,108,205,69,11 }, { 189,149,5,111,8 }, { 218,43,51,110,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 679)
		{ { 193,131,19,193,9 }, { 20,66,25,222,2 }, { 152,60,140,24,3 }, { 71,185,132,34,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 680)
		{ { 68,244,102,59,11 }, { 229,117,147,164,5 }, { 221,198,98,242,2 }, { 162,92,154,234,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 681)
		{ { 1,157,216,198,10 }, { 104,146,21,120,11 }, { 86,49,187,152,0 }, { 209,234,132,145,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 682)
		{ { 207,106,252,4,8 }, { 171,133,13,211,12 }, { 18,3,245,111,3 }, { 60,187,10,29,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 683)
		{ { 146,174,195,5,6 }, { 57,216,88,39,8 }, { 106,12,55,84,9 }, { 30,65,161,185,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 684)
		{ { 37,21,93,154,5 }, { 244,35,228,112,3 }, { 165,155,170,138,4 }, { 192,226,124,66,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 685)
		{ { 22,10,92,69,6 }, { 168,25,76,29,8 }, { 106,35,165,6,8 }, { 27,131,41,129,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 686)
		{ { 42,195,144,107,5 }, { 6,166,122,29,1 }, { 173,96,156,53,4 }, { 139,133,230,86,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 687)
		{ { 46,122,182,246,15 }, { 207,213,235,25,15 }, { 246,246,213,231,4 }, { 249,141,122,191,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 688)
		{ { 158,250,147,214,12 }, { 219,204,217,27,11 }, { 54,188,149,247,9 }, { 221,137,179,61,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 689)
		{ { 70,52,147,36,2 }, { 217,208,2,177,0 }, { 66,76,146,198,2 }, { 8,212,0,185,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 690)
		{ { 10,253,84,150,12 }, { 107,7,209,49,11 }, { 54,146,171,245,0 }, { 216,200,190,13,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 691)
		{ { 176,98,61,37,0 }, { 25,13,46,22,4 }, { 10,75,196,96,13 }, { 38,135,75,9,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 692)
		{ { 145,210,194,45,8 }, { 104,236,27,70,0 }, { 27,68,52,184,9 }, { 6,45,131,113,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 693)
		{ { 180,12,140,215,2 }, { 136,153,164,46,11 }, { 78,179,19,2,13 }, { 215,66,89,145,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 694)
		{ { 159,137,21,197,9 }, { 158,11,17,95,10 }, { 154,58,137,31,9 }, { 95,168,141,7,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 695)
		{ { 231,171,31,92,9 }, { 157,99,189,219,8 }, { 147,175,141,94,7 }, { 29,187,220,107,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 696)
		{ { 64,95,208,111,7 }, { 108,182,74,188,9 }, { 239,96,191,160,2 }, { 147,213,38,211,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 697)
		{ { 107,30,197,224,6 }, { 114,145,106,233,10 }, { 96,122,55,141,6 }, { 89,117,104,148,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 698)
		{ { 172,27,229,165,10 }, { 250,147,43,6,14 }, { 90,90,125,131,5 }, { 118,13,76,149,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 699)
		{ { 230,47,3,108,10 }, { 153,114,43,171,8 }, { 83,108,15,70,7 }, { 29,93,68,233,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 700)
		{ { 127,229,102,248,8 }, { 163,111,179,233,6 }, { 17,246,106,127,14 }, { 105,124,223,108,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 701)
		{ { 163,194,62,50,14 }, { 0,85,255,83,5 }, { 116,199,196,60,5 }, { 172,175,250,160,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 702)
		{ { 148,62,117,118,6 }, { 249,25,202,58,13 }, { 102,234,231,194,9 }, { 181,197,57,137,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 703)
		{ { 52,186,30,90,15 }, { 197,121,253,24,9 }, { 245,167,133,210,12 }, { 145,139,249,234,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 704)
		{ { 3,165,18,156,11 }, { 13,114,145,113,2 }, { 211,148,138,92,0 }, { 72,232,148,235,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 705)
		{ { 37,82,144,131,7 }, { 196,148,104,84,3 }, { 236,16,148,170,4 }, { 194,161,98,146,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 706)
		{ { 152,56,107,83,15 }, { 119,88,197,14,13 }, { 252,173,97,193,9 }, { 183,10,49,174,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 707)
		{ { 81,8,229,57,2 }, { 48,185,130,196,12 }, { 73,202,113,8,10 }, { 50,52,25,208,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 708)
		{ { 109,47,236,46,14 }, { 171,179,111,224,13 }, { 119,67,127,75,6 }, { 176,127,108,221,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 709)
		{ { 82,188,16,202,10 }, { 65,56,17,185,11 }, { 85,48,131,212,10 }, { 217,216,129,200,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 710)
		{ { 179,40,54,67,10 }, { 1,89,33,95,13 }, { 92,38,193,76,13 }, { 191,168,73,168,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 711)
		{ { 119,53,50,215,6 }, { 201,90,224,253,7 }, { 110,180,202,206,14 }, { 235,240,117,169,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 712)
		{ { 60,107,123,81,7 }, { 183,94,236,28,12 }, { 232,173,237,99,12 }, { 51,131,119,174,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 713)
		{ { 58,210,85,76,8 }, { 122,45,57,25,0 }, { 19,42,164,181,12 }, { 9,137,203,69,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 714)
		{ { 121,133,192,110,10 }, { 42,186,51,232,1 }, { 87,96,58,25,14 }, { 129,124,197,213,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 715)
		{ { 197,187,154,199,7 }, { 205,210,92,222,11 }, { 238,53,157,218,3 }, { 215,179,164,187,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 716)
		{ { 12,197,122,240,11 }, { 166,86,151,56,6 }, { 208,245,234,51,0 }, { 97,206,150,166,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 717)
		{ { 248,208,240,214,2 }, { 106,156,176,154,7 }, { 70,176,240,177,15 }, { 229,144,211,149,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 718)
		{ { 129,63,211,226,11 }, { 117,210,11,122,11 }, { 212,124,191,200,1 }, { 213,237,4,186,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 719)
		{ { 13,236,216,183,12 }, { 171,132,215,116,11 }, { 62,209,179,123,0 }, { 210,238,178,29,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 720)
		{ { 27,74,227,19,2 }, { 50,220,136,69,13 }, { 76,140,117,45,8 }, { 186,33,19,180,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 721)
		{ { 210,32,64,67,5 }, { 37,8,64,143,1 }, { 172,32,32,68,11 }, { 143,16,33,10,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 722)
		{ { 20,134,143,224,4 }, { 144,201,94,40,2 }, { 32,127,22,18,8 }, { 65,71,169,48,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 723)
		{ { 129,156,58,252,10 }, { 72,112,151,122,14 }, { 83,245,195,152,1 }, { 117,238,144,225,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 724)
		{ { 69,204,88,112,14 }, { 160,20,215,248,8 }, { 112,225,163,58,2 }, { 17,254,178,128,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 725)
		{ { 85,209,44,27,7 }, { 196,63,212,196,5 }, { 237,131,72,186,10 }, { 162,50,191,194,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 726)
		{ { 124,82,159,25,14 }, { 210,253,237,148,0 }, { 121,143,148,163,14 }, { 2,155,123,244,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 727)
		{ { 112,145,54,145,1 }, { 68,75,176,148,6 }, { 136,150,200,144,14 }, { 98,144,221,34,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 728)
		{ { 252,90,66,132,10 }, { 234,92,41,130,10 }, { 82,20,37,163,15 }, { 84,25,67,165,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 729)
		{ { 87,151,148,193,3 }, { 196,155,24,253,2 }, { 200,50,158,158,10 }, { 75,241,141,146,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 730)
		{ { 165,209,196,248,2 }, { 224,183,178,74,2 }, { 65,242,56,186,5 }, { 69,36,222,208,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 731)
		{ { 129,60,188,144,8 }, { 65,129,133,114,14 }, { 16,147,211,200,1 }, { 116,234,24,24,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 732)
		{ { 9,113,70,213,3 }, { 111,87,128,76,2 }, { 202,182,40,233,0 }, { 67,32,30,175,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 733)
		{ { 106,207,210,216,5 }, { 38,230,248,185,10 }, { 161,180,191,53,6 }, { 89,209,246,118,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 734)
		{ { 115,244,119,116,9 }, { 125,77,179,249,4 }, { 146,238,226,252,14 }, { 41,252,219,43,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 735)
		{ { 245,157,172,185,10 }, { 192,187,183,230,14 }, { 89,211,91,154,15 }, { 118,126,221,208,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 736)
		{ { 202,249,118,232,4 }, { 99,103,82,155,14 }, { 33,118,233,245,3 }, { 125,148,174,108,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 737)
		{ { 145,223,213,147,14 }, { 112,159,217,118,11 }, { 124,154,191,184,9 }, { 214,233,191,144,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 738)
		{ { 151,224,139,96,13 }, { 149,204,87,75,0 }, { 176,109,16,126,9 }, { 13,46,163,58,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 739)
		{ { 171,24,195,41,7 }, { 118,240,98,71,8 }, { 233,76,49,141,5 }, { 30,36,96,246,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 740)
		{ { 12,117,233,207,4 }, { 251,166,68,44,7 }, { 47,57,122,227,0 }, { 227,66,38,93,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 741)
		{ { 18,88,90,126,11 }, { 108,124,135,25,9 }, { 215,229,161,164,8 }, { 153,142,19,227,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 742)
		{ { 226,61,82,49,9 }, { 101,66,163,183,8 }, { 152,196,171,196,7 }, { 30,220,84,42,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 743)
		{ { 148,62,206,46,10 }, { 233,249,15,34,9 }, { 87,71,55,194,9 }, { 148,79,9,249,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 744)
		{ { 77,128,42,254,11 }, { 142,112,151,200,7 }, { 215,245,64,27,2 }, { 225,62,144,231,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 745)
		{ { 99,222,29,74,1 }, { 84,37,60,249,9 }, { 133,43,135,188,6 }, { 153,243,202,66,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 746)
		{ { 234,149,240,24,8 }, { 98,162,177,179,4 }, { 17,128,250,149,7 }, { 44,216,212,84,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 747)
		{ { 20,204,99,128,10 }, { 176,92,17,32,14 }, { 80,28,99,50,8 }, { 112,72,131,160,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 748)
		{ { 200,176,49,75,15 }, { 87,48,81,158,5 }, { 253,40,192,209,3 }, { 167,152,160,206,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 749)
		{ { 158,5,82,110,15 }, { 174,122,67,59,1 }, { 247,100,170,7,9 }, { 141,204,37,231,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 750)
		{ { 90,49,246,81,3 }, { 103,219,128,157,4 }, { 200,166,248,197,10 }, { 43,144,29,190,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 751)
		{ { 2,64,141,174,9 }, { 28,165,7,1,3 }, { 151,91,16,36,0 }, { 200,14,10,83,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 752)
		{ { 3,39,204,189,6 }, { 41,179,206,101,2 }, { 107,211,62,76,0 }, { 74,103,60,217,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 753)
		{ { 57,199,200,136,5 }, { 38,174,124,96,2 }, { 161,17,62,57,12 }, { 64,99,231,86,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 754)
		{ { 29,241,95,61,5 }, { 255,111,214,84,0 }, { 171,207,168,251,8 }, { 2,166,191,111,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 755)
		{ { 53,248,87,146,8 }, { 241,77,177,80,11 }, { 20,158,161,250,12 }, { 208,168,219,40,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 756)
		{ { 246,170,194,38,15 }, { 173,216,123,131,9 }, { 246,68,53,86,15 }, { 156,29,225,187,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 757)
		{ { 231,224,91,154,9 }, { 181,100,181,211,3 }, { 149,157,160,126,7 }, { 204,186,210,106,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 758)
		{ { 35,84,88,78,2 }, { 104,52,36,121,1 }, { 71,33,162,172,4 }, { 137,226,66,193,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 759)
		{ { 168,240,123,208,12 }, { 115,68,245,26,6 }, { 48,189,224,241,5 }, { 101,138,242,44,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 760)
		{ { 31,123,242,62,3 }, { 239,254,138,81,13 }, { 199,196,253,239,8 }, { 184,165,23,255,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 761)
		{ { 166,34,215,254,13 }, { 189,225,235,27,3 }, { 183,254,180,70,5 }, { 205,141,120,123,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 762)
		{ { 60,224,174,102,10 }, { 139,221,55,8,5 }, { 86,103,80,115,12 }, { 161,14,203,189,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 763)
		{ { 157,234,252,246,9 }, { 175,141,159,90,15 }, { 150,243,245,123,9 }, { 245,175,155,31,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 764)
		{ { 118,28,15,110,1 }, { 220,105,38,169,9 }, { 135,111,3,134,14 }, { 153,86,73,99,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 765)
		{ { 23,229,15,201,12 }, { 145,111,85,109,2 }, { 57,63,10,126,8 }, { 75,106,175,104,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 766)
		{ { 107,215,2,212,12 }, { 74,70,249,233,2 }, { 50,180,14,189,6 }, { 73,121,246,37,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 767)
		{ { 86,44,136,80,8 }, { 129,136,133,169,8 }, { 16,161,19,70,10 }, { 25,90,17,24,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 768)
		{ { 117,18,248,29,15 }, { 236,184,237,212,4 }, { 251,129,244,138,14 }, { 34,187,113,211,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 769)
		{ { 126,225,73,21,0 }, { 187,14,180,133,0 }, { 10,137,40,119,14 }, { 10,18,215,13,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 770)
		{ { 16,118,198,246,1 }, { 109,205,138,40,3 }, { 134,246,54,224,8 }, { 193,69,27,59,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 771)
		{ { 212,235,35,223,2 }, { 153,126,152,142,15 }, { 79,188,77,114,11 }, { 247,17,151,233,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 772)
		{ { 40,207,171,134,10 }, { 26,214,61,32,15 }, { 86,29,95,49,4 }, { 240,75,198,181,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 773)
		{ { 172,20,113,133,3 }, { 254,16,32,54,6 }, { 202,24,226,131,5 }, { 102,192,64,135,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 774)
		{ { 175,152,175,103,14 }, { 218,209,119,79,13 }, { 126,111,81,159,5 }, { 191,46,232,181,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 775)
		{ { 193,158,114,157,1 }, { 108,96,152,246,14 }, { 139,148,231,152,3 }, { 118,241,144,99,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 776)
		{ { 207,95,181,152,6 }, { 210,183,200,243,14 }, { 97,154,223,175,3 }, { 124,241,62,212,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 777)
		{ { 213,221,187,147,2 }, { 208,222,148,246,15 }, { 76,157,219,186,11 }, { 246,242,151,176,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 778)
		{ { 79,134,37,109,3 }, { 158,49,26,237,4 }, { 203,106,70,31,2 }, { 43,117,136,199,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 779)
		{ { 106,36,71,111,0 }, { 59,97,34,173,1 }, { 15,110,34,69,6 }, { 139,84,72,109,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 780)
		{ { 128,45,147,26,1 }, { 21,226,128,50,9 }, { 133,140,155,64,1 }, { 148,192,20,122,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 781)
		{ { 29,205,131,180,9 }, { 158,206,147,96,10 }, { 146,220,27,59,8 }, { 80,108,151,55,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 782)
		{ { 218,134,193,229,12 }, { 58,136,91,175,2 }, { 58,120,54,21,11 }, { 79,93,161,21,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 783)
		{ { 230,246,109,46,3 }, { 253,53,62,163,5 }, { 199,75,102,246,7 }, { 172,87,202,203,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 784)
		{ { 61,137,16,149,7 }, { 142,26,240,84,10 }, { 234,144,137,27,12 }, { 82,160,245,135,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 785)
		{ { 210,121,65,88,12 }, { 113,46,193,139,8 }, { 49,168,41,228,11 }, { 29,24,55,72,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 786)
		{ { 160,175,28,189,14 }, { 9,51,255,54,10 }, { 123,211,143,80,5 }, { 86,207,252,201,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 787)
		{ { 1,87,110,34,13 }, { 100,71,79,96,5 }, { 180,71,110,168,0 }, { 160,111,46,34,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 788)
		{ { 87,248,236,245,8 }, { 233,141,151,205,14 }, { 26,243,113,254,10 }, { 123,62,155,25,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 789)
		{ { 106,255,41,18,1 }, { 87,6,188,161,13 }, { 132,137,79,245,6 }, { 184,83,214,14,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 790)
		{ { 251,33,174,202,0 }, { 3,235,36,203,7 }, { 5,55,88,77,15 }, { 237,50,77,124,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 791)
		{ { 11,139,189,114,11 }, { 22,147,159,89,13 }, { 212,235,221,29,0 }, { 185,175,156,150,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 792)
		{ { 212,152,51,194,13 }, { 212,72,81,154,15 }, { 180,60,193,146,11 }, { 245,152,161,34,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 793)
		{ { 225,75,0,230,14 }, { 8,22,107,202,11 }, { 118,112,13,40,7 }, { 213,61,102,129,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 794)
		{ { 26,95,155,85,5 }, { 94,206,204,61,8 }, { 170,173,159,165,8 }, { 27,195,55,55,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 795)
		{ { 240,142,136,165,15 }, { 12,152,127,166,10 }, { 250,81,23,16,15 }, { 86,95,225,147,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 796)
		{ { 167,153,98,167,6 }, { 232,82,114,71,15 }, { 110,84,105,158,5 }, { 254,36,228,161,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 797)
		{ { 117,137,204,235,6 }, { 160,187,118,204,11 }, { 109,115,57,26,14 }, { 211,54,237,208,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 798)
		{ { 146,223,143,67,12 }, { 80,207,93,47,9 }, { 60,47,31,180,9 }, { 159,75,175,48,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 799)
		{ { 174,86,155,223,2 }, { 218,244,172,63,3 }, { 79,189,150,167,5 }, { 207,195,82,245,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 800)
		{ { 210,12,103,74,4 }, { 48,105,64,171,13 }, { 37,46,99,4,11 }, { 189,80,41,96,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 801)
		{ { 40,70,65,78,7 }, { 62,52,104,40,1 }, { 231,40,38,33,4 }, { 129,65,98,199,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 802)
		{ { 108,201,54,127,1 }, { 142,103,178,156,13 }, { 143,230,201,51,6 }, { 179,148,222,103,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 803)
		{ { 194,238,156,100,12 }, { 9,133,95,187,8 }, { 50,99,151,116,3 }, { 29,223,170,25,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 804)
		{ { 36,163,220,7,0 }, { 169,131,60,20,1 }, { 14,3,188,82,4 }, { 130,131,204,25,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 805)
		{ { 41,169,53,183,11 }, { 31,19,179,84,15 }, { 222,218,201,89,4 }, { 242,172,220,143,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 806)
		{ { 105,9,143,242,0 }, { 18,195,166,200,11 }, { 4,255,25,9,6 }, { 209,54,92,52,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 807)
		{ { 221,179,45,144,2 }, { 211,27,156,194,6 }, { 64,155,76,219,11 }, { 100,51,157,140,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 808)
		{ { 17,24,73,168,13 }, { 116,40,71,64,10 }, { 177,89,33,136,8 }, { 80,46,33,66,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 809)
		{ { 182,179,217,164,5 }, { 253,138,126,19,2 }, { 162,89,188,214,13 }, { 76,135,229,27,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 810)
		{ { 160,207,230,60,2 }, { 40,247,186,34,12 }, { 67,198,127,48,5 }, { 52,69,222,241,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 811)
		{ { 55,59,166,59,8 }, { 193,235,171,69,13 }, { 29,198,93,206,12 }, { 186,45,93,120,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 812)
		{ { 161,242,208,206,8 }, { 105,164,57,90,3 }, { 23,48,180,248,5 }, { 197,169,194,89,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 813)
		{ { 86,143,18,81,15 }, { 132,90,217,189,8 }, { 248,164,143,22,10 }, { 27,217,181,162,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 814)
		{ { 194,231,12,94,10 }, { 9,55,157,171,1 }, { 87,163,14,116,3 }, { 141,91,158,201,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 815)
		{ { 156,25,191,90,0 }, { 210,235,132,26,13 }, { 5,175,217,131,9 }, { 181,130,29,116,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 816)
		{ { 117,207,171,65,6 }, { 144,222,124,236,12 }, { 104,45,95,58,14 }, { 51,115,231,176,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 817)
		{ { 126,204,41,109,0 }, { 154,44,54,173,12 }, { 11,105,67,55,14 }, { 59,86,195,69,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 818)
		{ { 243,91,227,26,14 }, { 112,254,233,195,13 }, { 117,140,125,172,15 }, { 188,57,119,240,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 819)
		{ { 190,117,133,241,8 }, { 211,143,163,47,2 }, { 24,250,26,231,13 }, { 79,76,95,28,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 820)
		{ { 33,154,217,93,10 }, { 120,176,189,92,8 }, { 91,169,181,152,4 }, { 19,171,208,209,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 821)
		{ { 187,162,184,116,12 }, { 11,136,255,91,4 }, { 50,225,212,93,13 }, { 45,175,241,29,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 822)
		{ { 24,170,15,78,6 }, { 27,121,92,8,9 }, { 103,47,5,81,8 }, { 145,3,169,237,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 823)
		{ { 141,163,255,65,12 }, { 179,195,93,94,4 }, { 56,47,252,91,1 }, { 39,171,172,60,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 824)
		{ { 204,241,13,15,1 }, { 223,39,20,134,1 }, { 143,11,8,243,3 }, { 134,18,142,79,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 825)
		{ { 15,249,178,82,13 }, { 199,198,209,89,13 }, { 180,164,217,255,0 }, { 185,168,182,62,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 826)
		{ { 1,159,5,220,10 }, { 88,51,153,104,10 }, { 83,186,15,152,0 }, { 81,105,156,193,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 827)
		{ { 223,138,224,53,4 }, { 170,136,218,199,12 }, { 42,192,117,31,11 }, { 62,53,177,21,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 828)
		{ { 206,123,160,13,5 }, { 207,166,72,135,12 }, { 171,0,93,231,3 }, { 62,17,38,95,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 829)
		{ { 217,125,237,88,6 }, { 115,191,196,234,12 }, { 97,171,123,233,11 }, { 53,114,63,220,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 830)
		{ { 181,147,30,12,6 }, { 200,123,124,82,0 }, { 99,7,140,154,13 }, { 4,163,237,225,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 831)
		{ { 18,139,154,110,4 }, { 8,234,94,25,9 }, { 39,101,157,20,8 }, { 153,135,165,113,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 832)
		{ { 242,22,60,166,3 }, { 76,25,46,179,7 }, { 198,83,198,132,15 }, { 236,215,73,131,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 833)
		{ { 232,10,7,115,7 }, { 22,81,234,142,9 }, { 236,238,5,1,7 }, { 151,21,120,166,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 834)
		{ { 122,115,30,194,4 }, { 67,79,108,153,3 }, { 36,55,140,229,14 }, { 201,147,111,44,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 835)
		{ { 53,218,126,240,11 }, { 228,93,191,88,14 }, { 208,247,229,186,12 }, { 113,175,219,162,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 836)
		{ { 153,130,253,45,1 }, { 62,169,30,86,4 }, { 139,75,244,25,9 }, { 38,167,137,87,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 837)
		{ { 223,169,37,94,13 }, { 159,43,209,203,13 }, { 183,170,73,95,11 }, { 189,56,189,79,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 838)
		{ { 165,30,214,188,15 }, { 236,241,235,114,10 }, { 243,214,183,138,5 }, { 84,237,120,243,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 839)
		{ { 36,8,213,209,9 }, { 180,129,161,28,10 }, { 152,186,177,2,4 }, { 83,136,88,18,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 840)
		{ { 181,248,233,45,6 }, { 249,188,118,70,12 }, { 107,73,113,250,13 }, { 54,38,227,217,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 841)
		{ { 145,54,188,78,0 }, { 73,169,12,122,5 }, { 7,35,214,200,9 }, { 165,227,9,89,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 842)
		{ { 174,88,224,232,5 }, { 230,164,98,11,14 }, { 161,112,113,167,5 }, { 125,4,98,86,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 843)
		{ { 47,128,197,170,11 }, { 182,177,51,65,3 }, { 213,90,48,31,4 }, { 200,44,200,214,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 844)
		{ { 218,73,123,17,9 }, { 54,78,133,151,12 }, { 152,141,233,37,11 }, { 62,154,23,38,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 845)
		{ { 162,246,228,83,14 }, { 97,149,249,47,5 }, { 124,162,118,244,5 }, { 175,73,250,152,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 846)
		{ { 33,39,109,132,12 }, { 57,3,109,96,6 }, { 50,27,110,72,4 }, { 96,107,108,9,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 847)
		{ { 107,121,40,104,12 }, { 67,38,103,201,12 }, { 49,97,73,237,6 }, { 57,62,102,76,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 848)
		{ { 157,218,93,177,13 }, { 246,13,223,86,10 }, { 184,219,165,187,9 }, { 86,175,187,6,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 849)
		{ { 47,207,178,181,5 }, { 142,198,250,117,14 }, { 170,212,223,63,4 }, { 122,229,246,55,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 850)
		{ { 175,32,71,30,8 }, { 187,97,161,67,1 }, { 23,142,32,79,5 }, { 140,40,88,109,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 851)
		{ { 234,199,75,58,9 }, { 54,102,191,163,1 }, { 149,205,46,53,7 }, { 140,95,214,102,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 852)
		{ { 204,229,29,252,14 }, { 155,55,215,186,2 }, { 115,251,138,115,3 }, { 69,222,190,205,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 853)
		{ { 97,48,133,50,1 }, { 85,129,162,192,1 }, { 132,202,16,200,6 }, { 128,52,88,26,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 854)
		{ { 180,146,25,41,1 }, { 212,40,62,22,0 }, { 137,73,132,146,13 }, { 6,135,193,66,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 855)
		{ { 193,207,189,157,10 }, { 24,183,157,246,14 }, { 91,155,223,56,3 }, { 118,251,158,209,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 856)
		{ { 8,221,26,54,6 }, { 74,86,214,48,9 }, { 102,197,139,177,0 }, { 144,198,182,165,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 857)
		{ { 120,67,92,168,15 }, { 38,63,111,144,2 }, { 241,83,172,33,14 }, { 64,159,111,198,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 858)
		{ { 32,220,186,83,14 }, { 64,212,245,60,13 }, { 124,165,211,176,4 }, { 179,202,242,176,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 859)
		{ { 227,132,165,236,6 }, { 24,177,114,235,6 }, { 99,122,82,28,7 }, { 109,116,232,209,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 860)
		{ { 131,145,171,122,13 }, { 84,226,215,75,5 }, { 181,237,88,156,1 }, { 173,46,180,114,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 861)
		{ { 114,38,60,80,11 }, { 5,25,173,185,4 }, { 208,163,198,68,14 }, { 41,219,89,138,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 862)
		{ { 242,174,11,171,12 }, { 17,104,127,167,11 }, { 61,93,7,84,15 }, { 222,95,225,104,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 863)
		{ { 46,136,9,214,3 }, { 158,16,180,9,11 }, { 198,185,1,23,4 }, { 217,2,208,135,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 864)
		{ { 183,203,246,151,12 }, { 168,207,249,87,15 }, { 62,150,253,62,13 }, { 254,169,255,49,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 865)
		{ { 49,251,244,57,14 }, { 97,191,251,84,12 }, { 121,194,253,248,12 }, { 50,173,255,216,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 866)
		{ { 142,199,82,154,6 }, { 162,118,216,51,3 }, { 101,148,174,55,1 }, { 204,193,182,228,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 867)
		{ { 94,235,242,10,12 }, { 163,238,89,145,13 }, { 53,4,253,119,10 }, { 184,153,167,124,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 868)
		{ { 227,59,129,212,12 }, { 89,130,233,203,10 }, { 50,184,29,204,7 }, { 93,57,116,25,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 869)
		{ { 172,124,242,222,10 }, { 235,244,161,58,15 }, { 87,180,243,227,5 }, { 245,200,82,253,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 870)
		{ { 78,1,1,147,2 }, { 146,18,128,133,3 }, { 76,152,8,7,2 }, { 202,16,20,132,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 871)
		{ { 201,144,131,96,5 }, { 86,192,82,202,0 }, { 160,108,16,153,3 }, { 5,52,160,54,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 872)
		{ { 245,102,105,160,13 }, { 181,12,111,226,6 }, { 176,89,102,106,15 }, { 100,127,99,10,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 873)
		{ { 44,3,150,212,14 }, { 138,211,233,24,2 }, { 114,182,156,3,4 }, { 65,137,124,181,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 874)
		{ { 118,193,117,204,7 }, { 188,63,112,153,6 }, { 227,58,232,54,14 }, { 105,144,239,195,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 875)
		{ { 176,251,83,107,5 }, { 117,110,122,30,9 }, { 173,108,173,240,13 }, { 151,133,231,106,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 876)
		{ { 135,53,206,169,8 }, { 225,227,7,103,2 }, { 25,87,58,206,1 }, { 78,110,12,120,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 877)
		{ { 231,139,244,106,11 }, { 164,179,59,219,13 }, { 213,98,253,30,7 }, { 189,189,204,210,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 878)
		{ { 185,178,1,226,1 }, { 87,8,58,74,3 }, { 132,120,4,217,13 }, { 197,37,193,14,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 879)
		{ { 44,230,244,199,9 }, { 175,133,57,60,7 }, { 158,50,246,115,4 }, { 227,201,202,31,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 880)
		{ { 240,26,58,172,4 }, { 72,104,110,146,14 }, { 35,85,197,128,15 }, { 116,151,97,97,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 881)
		{ { 107,29,238,143,4 }, { 106,227,100,229,15 }, { 47,23,123,141,6 }, { 250,114,108,117,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 882)
		{ { 10,99,89,22,11 }, { 63,22,141,17,1 }, { 214,137,172,101,0 }, { 136,139,22,143,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 883)
		{ { 61,80,237,142,0 }, { 250,173,36,64,7 }, { 7,27,112,171,12 }, { 224,34,75,85,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 884)
		{ { 12,234,137,42,4 }, { 147,164,94,0,9 }, { 37,73,21,115,0 }, { 144,7,162,92,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 885)
		{ { 146,159,44,154,3 }, { 68,59,156,35,15 }, { 197,147,79,148,9 }, { 252,67,157,194,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 886)
		{ { 144,185,171,44,8 }, { 89,234,23,2,12 }, { 19,77,89,208,9 }, { 52,14,133,121,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 887)
		{ { 96,223,140,227,4 }, { 64,135,126,172,11 }, { 44,115,31,176,6 }, { 211,87,238,16,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 888)
		{ { 211,163,99,9,11 }, { 53,122,25,199,4 }, { 217,12,108,92,11 }, { 46,57,133,234,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 889)
		{ { 37,61,159,195,3 }, { 213,211,36,124,11 }, { 204,63,155,202,4 }, { 211,226,76,186,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 890)
		{ { 48,25,30,15,13 }, { 76,107,101,20,9 }, { 191,7,137,128,12 }, { 146,138,109,99,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 891)
		{ { 90,151,28,16,1 }, { 70,11,156,177,0 }, { 128,131,142,149,10 }, { 8,211,157,6,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 892)
		{ { 42,15,107,51,10 }, { 50,82,175,37,13 }, { 92,205,111,5,4 }, { 186,79,84,164,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 893)
		{ { 106,117,209,236,0 }, { 123,166,34,185,2 }, { 3,120,186,229,6 }, { 73,212,70,93,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 894)
		{ { 30,157,187,139,1 }, { 214,234,20,53,15 }, { 141,29,219,151,8 }, { 250,194,133,118,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 895)
		{ { 47,58,225,220,9 }, { 255,160,169,73,14 }, { 147,184,117,207,4 }, { 121,41,80,95,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 896)
		{ { 99,208,151,52,7 }, { 92,213,242,209,0 }, { 226,206,144,188,6 }, { 8,180,250,179,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 897)
		{ { 216,157,137,67,7 }, { 86,154,84,174,9 }, { 236,41,27,145,11 }, { 151,82,165,150,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 898)
		{ { 131,189,136,80,11 }, { 69,146,149,107,8 }, { 208,161,27,220,1 }, { 29,106,148,154,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 899)
		{ { 34,78,125,138,14 }, { 48,53,109,49,15 }, { 117,27,231,36,4 }, { 248,203,106,192,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 900)
		{ { 121,75,63,158,10 }, { 26,127,173,208,15 }, { 87,159,205,41,14 }, { 240,187,95,229,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 901)
		{ { 141,51,167,110,15 }, { 223,243,75,74,5 }, { 247,110,92,203,1 }, { 165,45,44,255,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 902)
		{ { 33,133,188,205,7 }, { 12,179,116,124,6 }, { 235,51,218,24,4 }, { 99,226,236,211,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 903)
		{ { 240,218,227,80,3 }, { 116,220,184,138,12 }, { 192,172,117,176,15 }, { 53,17,211,178,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 904)
		{ { 204,223,42,42,8 }, { 194,102,31,162,13 }, { 21,69,79,179,3 }, { 180,95,134,100,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 905)
		{ { 56,130,84,157,1 }, { 46,41,184,20,2 }, { 139,146,164,17,12 }, { 66,129,217,71,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 906)
		{ { 110,45,44,91,14 }, { 131,51,229,173,13 }, { 125,163,75,71,6 }, { 187,90,124,204,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 907)
		{ { 122,43,200,47,2 }, { 43,186,46,133,9 }, { 79,65,61,69,14 }, { 154,23,69,221,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 908)
		{ { 87,219,131,112,8 }, { 208,206,155,201,8 }, { 16,236,29,190,10 }, { 25,61,151,48,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 909)
		{ { 201,217,206,10,6 }, { 98,247,84,194,9 }, { 101,7,57,185,3 }, { 148,50,174,244,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 910)
		{ { 140,81,7,168,12 }, { 210,103,67,2,2 }, { 49,94,8,163,1 }, { 68,12,46,100,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 911)
		{ { 189,143,171,242,11 }, { 150,218,191,106,15 }, { 212,253,95,27,13 }, { 245,111,213,182,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 912)
		{ { 100,133,26,10,13 }, { 132,98,117,176,1 }, { 181,5,138,18,6 }, { 128,218,228,98,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 913)
		{ { 220,109,58,176,4 }, { 131,78,198,178,14 }, { 32,213,203,99,11 }, { 116,214,55,44,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 914)
		{ { 231,251,25,168,3 }, { 213,54,62,211,10 }, { 193,89,141,254,7 }, { 92,183,198,202,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 915)
		{ { 177,204,84,80,5 }, { 36,13,240,122,8 }, { 160,162,163,56,13 }, { 21,224,251,2,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 916)
		{ { 97,110,245,148,7 }, { 61,149,232,240,14 }, { 226,154,247,104,6 }, { 112,241,122,155,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 917)
		{ { 147,83,11,252,1 }, { 92,110,142,75,2 }, { 131,253,12,172,9 }, { 77,39,23,99,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 918)
		{ { 27,41,1,82,8 }, { 19,10,129,73,9 }, { 20,168,9,77,8 }, { 153,40,21,12,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 919)
		{ { 197,245,7,104,1 }, { 213,103,18,234,0 }, { 129,110,10,250,3 }, { 5,116,142,106,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 920)
		{ { 52,186,247,153,2 }, { 241,249,184,20,14 }, { 73,158,245,210,12 }, { 114,129,217,248,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 921)
		{ { 169,176,189,187,13 }, { 87,161,247,86,7 }, { 189,219,208,217,5 }, { 230,174,248,94,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 922)
		{ { 149,57,193,12,5 }, { 253,170,64,66,8 }, { 163,8,57,202,9 }, { 20,32,37,91,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 923)
		{ { 50,223,204,191,2 }, { 104,191,190,37,11 }, { 79,211,63,180,12 }, { 218,71,223,209,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 924)
		{ { 237,234,172,111,7 }, { 143,181,126,206,13 }, { 239,99,85,123,7 }, { 183,55,234,223,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 925)
		{ { 77,86,15,172,10 }, { 218,117,15,224,2 }, { 83,95,6,171,2 }, { 64,127,10,229,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 926)
		{ { 116,172,190,43,0 }, { 129,233,54,180,13 }, { 13,71,211,82,14 }, { 178,214,201,120,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 927)
		{ { 35,182,120,236,5 }, { 109,32,126,121,6 }, { 163,113,230,220,4 }, { 105,231,224,75,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 928)
		{ { 232,210,137,53,1 }, { 94,132,190,134,0 }, { 138,201,20,177,7 }, { 6,23,210,23,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 929)
		{ { 235,150,185,93,6 }, { 90,176,252,255,4 }, { 107,169,214,157,7 }, { 47,243,240,213,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 930)
		{ { 85,145,91,105,0 }, { 240,106,22,220,0 }, { 9,109,168,154,10 }, { 3,182,133,96,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 931)
		{ { 40,186,189,218,6 }, { 83,177,252,24,15 }, { 101,187,213,209,4 }, { 241,131,248,220,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 932)
		{ { 35,163,75,130,11 }, { 53,82,61,65,3 }, { 212,29,44,92,4 }, { 200,43,196,170,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 933)
		{ { 193,172,20,84,10 }, { 9,17,145,250,8 }, { 82,162,131,88,3 }, { 21,248,152,137,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 934)
		{ { 100,182,175,131,2 }, { 209,209,60,164,7 }, { 76,31,86,210,6 }, { 226,83,200,184,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 935)
		{ { 82,25,155,54,1 }, { 92,202,134,145,9 }, { 134,205,153,132,10 }, { 152,150,21,51,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 936)
		{ { 99,183,61,54,4 }, { 89,3,254,241,5 }, { 38,203,206,220,6 }, { 168,247,252,9,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 937)
		{ { 192,85,112,85,8 }, { 104,6,129,190,4 }, { 26,160,234,160,3 }, { 39,216,22,1,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 938)
		{ { 52,181,171,169,13 }, { 213,234,119,36,6 }, { 185,93,90,210,12 }, { 98,78,229,122,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 939)
		{ { 4,214,173,116,7 }, { 220,149,222,40,4 }, { 226,235,86,178,0 }, { 33,71,186,147,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 940)
		{ { 58,185,185,47,15 }, { 95,186,119,21,13 }, { 255,73,217,213,12 }, { 186,142,229,223,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 941)
		{ { 30,193,204,115,3 }, { 166,159,150,13,1 }, { 204,227,56,55,8 }, { 139,6,159,150,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 942)
		{ { 227,95,151,12,12 }, { 88,231,105,243,8 }, { 51,14,159,172,7 }, { 28,249,110,113,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 943)
		{ { 82,233,202,244,7 }, { 45,222,214,137,10 }, { 226,245,57,116,10 }, { 89,22,183,187,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 944)
		{ { 171,99,139,22,6 }, { 27,214,236,67,1 }, { 102,141,28,109,5 }, { 140,35,118,189,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 945)
		{ { 138,229,208,83,7 }, { 39,150,208,63,1 }, { 236,160,186,117,1 }, { 143,192,182,158,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 946)
		{ { 103,173,81,43,1 }, { 181,34,50,245,9 }, { 141,72,171,94,6 }, { 154,244,196,74,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 947)
		{ { 179,24,122,4,11 }, { 108,88,37,83,12 }, { 210,5,225,140,13 }, { 60,170,65,163,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 948)
		{ { 60,198,137,195,8 }, { 146,140,61,44,3 }, { 28,57,22,51,12 }, { 195,75,195,20,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 949)
		{ { 250,116,11,175,7 }, { 95,124,102,167,3 }, { 239,93,2,229,15 }, { 206,86,99,239,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 950)
		{ { 4,250,221,72,11 }, { 245,181,29,24,8 }, { 209,43,181,242,0 }, { 17,139,138,218,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 951)
		{ { 153,138,132,196,12 }, { 10,137,89,74,10 }, { 50,50,21,25,9 }, { 85,41,169,21,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 952)
		{ { 63,252,218,241,1 }, { 231,204,182,125,10 }, { 136,245,179,255,12 }, { 91,230,211,62,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 953)
		{ { 148,250,34,140,9 }, { 205,108,25,2,14 }, { 147,20,69,242,9 }, { 116,9,131,107,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 954)
		{ { 228,237,60,145,13 }, { 133,7,245,182,14 }, { 184,147,203,114,7 }, { 118,218,254,10,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 955)
		{ { 3,55,138,20,12 }, { 73,194,205,97,0 }, { 50,133,30,204,0 }, { 8,107,52,57,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 956)
		{ { 216,27,34,208,1 }, { 70,74,136,138,14 }, { 128,180,77,129,11 }, { 117,17,21,38,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 957)
		{ { 25,91,18,85,10 }, { 74,94,137,92,8 }, { 90,164,141,169,8 }, { 19,169,23,165,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 958)
		{ { 33,72,120,182,2 }, { 40,20,166,80,15 }, { 70,209,225,40,4 }, { 240,166,82,129,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 959)
		{ { 40,93,236,19,2 }, { 98,151,164,36,13 }, { 76,131,123,161,4 }, { 178,66,94,148,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 960)
		{ { 123,100,52,77,7 }, { 15,61,96,253,4 }, { 235,34,194,109,14 }, { 43,240,107,207,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 961)
		{ { 98,75,151,138,7 }, { 20,247,104,145,11 }, { 229,30,157,36,6 }, { 216,145,110,242,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 962)
		{ { 103,119,188,11,1 }, { 197,167,44,245,5 }, { 141,3,222,238,6 }, { 170,243,78,90,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 963)
		{ { 144,144,113,245,10 }, { 120,24,147,30,6 }, { 90,248,224,144,9 }, { 103,140,145,129,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 964)
		{ { 37,206,233,123,13 }, { 180,164,255,108,13 }, { 189,233,119,58,4 }, { 179,111,242,82,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 965)
		{ { 253,83,136,111,13 }, { 206,174,111,206,1 }, { 191,97,28,171,15 }, { 135,63,103,87,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 966)
		{ { 231,105,53,36,11 }, { 157,23,35,211,12 }, { 210,74,201,110,7 }, { 60,188,78,139,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 967)
		{ { 24,201,137,127,9 }, { 30,174,151,12,9 }, { 159,233,25,49,8 }, { 147,14,151,87,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 968)
		{ { 101,96,64,176,10 }, { 161,20,163,192,2 }, { 80,208,32,106,6 }, { 64,60,82,136,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 969)
		{ { 56,46,157,194,13 }, { 23,137,109,56,11 }, { 180,59,151,65,12 }, { 209,203,105,30,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 970)
		{ { 205,242,177,37,13 }, { 223,132,91,214,4 }, { 186,72,212,251,3 }, { 38,189,162,31,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 971)
		{ { 9,78,179,61,6 }, { 26,244,202,116,12 }, { 107,204,215,41,0 }, { 50,229,50,245,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 972)
		{ { 57,223,214,61,1 }, { 110,239,186,116,8 }, { 139,198,191,185,12 }, { 18,229,223,119,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 973)
		{ { 249,54,192,90,7 }, { 103,184,232,234,1 }, { 229,160,54,201,15 }, { 133,113,113,222,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 974)
		{ { 119,243,69,1,5 }, { 245,15,120,197,0 }, { 168,10,44,254,14 }, { 10,49,239,10,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 975)
		{ { 229,170,108,152,3 }, { 165,49,188,194,14 }, { 193,147,101,90,7 }, { 116,51,216,202,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 976)
		{ { 176,232,167,19,14 }, { 17,221,241,6,13 }, { 124,142,81,112,13 }, { 182,8,251,184,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 977)
		{ { 221,219,120,40,6 }, { 226,62,94,210,12 }, { 97,65,237,187,11 }, { 52,183,167,196,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 978)
		{ { 59,9,157,107,2 }, { 18,187,38,93,9 }, { 77,107,153,13,12 }, { 155,166,77,212,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 979)
		{ { 64,234,217,35,3 }, { 53,148,30,148,9 }, { 204,73,181,112,2 }, { 146,151,130,154,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 980)
		{ { 26,247,252,44,4 }, { 107,175,94,49,4 }, { 35,67,254,245,8 }, { 40,199,175,93,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 981)
		{ { 60,154,211,10,11 }, { 246,248,57,16,9 }, { 213,12,181,147,12 }, { 144,137,193,246,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 982)
		{ { 179,6,81,36,2 }, { 56,24,42,115,0 }, { 66,72,166,12,13 }, { 12,229,65,129,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 983)
		{ { 50,189,243,128,9 }, { 117,202,49,49,14 }, { 144,28,251,212,12 }, { 120,200,197,58,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 984)
		{ { 108,225,50,82,6 }, { 131,86,240,152,5 }, { 100,164,200,115,6 }, { 161,144,246,172,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 985)
		{ { 87,93,59,77,8 }, { 216,110,5,253,12 }, { 27,45,203,174,10 }, { 59,250,7,97,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 986)
		{ { 50,250,120,150,11 }, { 109,28,189,17,15 }, { 214,145,229,244,12 }, { 248,139,211,139,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 987)
		{ { 201,37,74,207,11 }, { 47,114,5,238,3 }, { 223,53,42,73,3 }, { 199,122,4,239,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 988)
		{ { 91,227,88,153,8 }, { 35,46,157,213,2 }, { 25,145,172,125,10 }, { 74,187,151,76,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 989)
		{ { 162,249,225,35,2 }, { 113,150,50,7,13 }, { 76,72,121,244,5 }, { 190,4,198,152,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 990)
		{ { 119,181,82,205,9 }, { 237,106,49,253,2 }, { 155,52,170,222,14 }, { 75,248,197,107,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 991)
		{ { 176,219,205,212,10 }, { 120,159,189,10,10 }, { 82,187,61,176,13 }, { 85,11,223,145,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 992)
		{ { 203,147,21,157,14 }, { 90,51,217,215,2 }, { 123,154,140,157,3 }, { 78,185,188,197,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 993)
		{ { 126,39,103,62,11 }, { 191,123,171,161,5 }, { 215,206,110,71,14 }, { 168,93,93,239,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 994)
		{ { 27,68,157,3,7 }, { 22,157,68,117,1 }, { 236,11,146,45,8 }, { 138,226,43,150,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 995)
		{ { 214,213,57,224,1 }, { 212,14,22,187,6 }, { 128,121,202,182,11 }, { 109,214,135,2,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 996)
		{ { 153,17,59,93,5 }, { 94,106,196,94,4 }, { 171,173,200,137,9 }, { 39,162,53,103,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 997)
		{ { 237,201,222,175,0 }, { 170,231,54,214,11 }, { 15,87,185,59,7 }, { 214,182,206,117,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 998)
		{ { 152,79,114,58,0 }, { 34,110,138,50,13 }, { 5,196,239,33,9 }, { 180,197,23,100,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 999)
		{ { 146,177,194,94,11 }, { 109,250,145,11,1 }, { 215,164,56,212,9 }, { 141,8,149,251,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1000)
		{ { 233,83,55,170,15 }, { 86,119,107,210,7 }, { 245,94,204,169,7 }, { 228,189,110,230,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1001)
		{ { 184,249,145,224,11 }, { 87,158,51,26,10 }, { 208,120,153,241,13 }, { 85,140,199,158,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1002)
		{ { 54,190,41,6,4 }, { 217,8,124,33,13 }, { 38,9,71,214,12 }, { 184,67,225,9,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1003)
		{ { 109,88,75,223,15 }, { 254,116,229,204,11 }, { 255,189,33,171,6 }, { 211,58,114,231,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1004)
		{ { 124,73,255,32,11 }, { 182,223,39,144,12 }, { 208,79,249,35,14 }, { 48,158,79,182,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1005)
		{ { 204,4,237,38,9 }, { 190,129,7,162,5 }, { 150,75,114,3,3 }, { 164,94,8,23,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1006)
		{ { 126,191,195,88,12 }, { 243,234,249,169,8 }, { 49,172,63,215,14 }, { 25,89,245,124,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1007)
		{ { 35,71,74,52,11 }, { 44,86,175,97,0 }, { 210,197,46,44,4 }, { 8,111,86,163,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1008)
		{ { 247,2,101,153,14 }, { 176,57,233,199,6 }, { 121,154,100,14,15 }, { 110,57,121,192,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1009)
		{ { 183,134,11,177,9 }, { 148,72,191,103,2 }, { 152,221,6,30,13 }, { 78,111,209,34,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1010)
		{ { 29,237,84,211,10 }, { 163,31,145,124,11 }, { 92,178,171,123,8 }, { 211,232,159,140,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1011)
		{ { 19,129,28,244,14 }, { 8,27,215,89,2 }, { 114,243,136,28,8 }, { 73,174,189,129,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1012)
		{ { 38,136,183,166,7 }, { 156,209,114,17,15 }, { 230,94,209,22,4 }, { 248,132,232,179,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1013)
		{ { 218,189,5,242,12 }, { 83,11,211,171,11 }, { 52,250,11,213,11 }, { 221,92,189,12,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1014)
		{ { 179,196,25,242,6 }, { 16,28,246,123,3 }, { 100,249,130,60,13 }, { 205,230,243,128,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1015)
		{ { 3,88,126,158,12 }, { 104,101,197,81,15 }, { 55,151,225,172,0 }, { 248,170,58,97,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1016)
		{ { 138,226,81,223,4 }, { 59,36,216,31,3 }, { 47,184,164,117,1 }, { 207,129,178,77,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1017)
		{ { 116,44,226,207,6 }, { 169,248,96,172,15 }, { 111,52,115,66,14 }, { 243,80,97,249,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1018)
		{ { 80,87,235,180,4 }, { 120,206,206,160,6 }, { 34,221,126,160,10 }, { 96,87,55,49,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1019)
		{ { 234,122,109,152,13 }, { 119,37,237,131,14 }, { 177,155,101,229,7 }, { 124,27,122,78,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1020)
		{ { 81,124,23,242,2 }, { 81,93,130,248,11 }, { 68,254,131,232,10 }, { 209,244,27,168,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1021)
		{ { 116,206,76,238,0 }, { 168,45,62,168,11 }, { 7,115,39,50,14 }, { 209,87,203,65,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1022)
		{ { 235,112,71,178,6 }, { 115,85,226,195,3 }, { 100,222,32,237,7 }, { 204,52,122,172,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1023)
		{ { 44,21,121,54,0 }, { 250,2,166,48,5 }, { 6,201,234,131,4 }, { 160,198,84,5,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1024)
		{ { 10,102,96,115,1 }, { 39,4,138,45,5 }, { 140,224,102,101,0 }, { 171,69,18,14,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1025)
		{ { 15,250,22,84,3 }, { 207,85,152,89,8 }, { 194,166,133,255,0 }, { 25,161,154,175,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1026)
		{ { 248,13,152,242,6 }, { 2,154,230,186,11 }, { 100,241,155,1,15 }, { 213,214,117,148,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1027)
		{ { 17,81,213,137,2 }, { 112,191,0,84,2 }, { 73,26,184,168,8 }, { 66,160,15,208,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1028)
		{ { 90,127,72,72,2 }, { 99,62,12,169,8 }, { 65,33,47,229,10 }, { 25,83,7,204,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1029)
		{ { 220,246,137,159,6 }, { 219,188,220,166,3 }, { 111,153,22,243,11 }, { 198,83,179,221,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1030)
		{ { 142,116,239,41,6 }, { 243,245,70,39,4 }, { 105,79,114,231,1 }, { 46,70,42,252,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1031)
		{ { 122,205,165,235,5 }, { 22,175,114,173,15 }, { 173,122,91,53,14 }, { 251,84,239,86,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1032)
		{ { 73,74,158,70,15 }, { 14,213,77,216,9 }, { 246,39,149,41,2 }, { 145,187,42,183,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1033)
		{ { 92,188,59,49,3 }, { 215,88,150,180,12 }, { 200,205,195,211,10 }, { 50,214,145,174,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1034)
		{ { 24,172,214,61,15 }, { 47,249,211,52,8 }, { 251,198,179,81,8 }, { 18,204,185,255,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1035)
		{ { 128,152,198,222,6 }, { 104,241,208,10,11 }, { 103,182,49,144,1 }, { 213,0,184,241,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1036)
		{ { 171,158,93,173,10 }, { 122,49,63,119,10 }, { 91,91,167,157,5 }, { 94,239,200,197,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1037)
		{ { 187,215,181,242,15 }, { 86,159,251,123,7 }, { 244,250,222,189,13 }, { 237,237,255,150,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1038)
		{ { 231,64,19,227,5 }, { 148,68,98,223,3 }, { 172,124,128,46,7 }, { 207,180,98,34,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1039)
		{ { 185,180,142,161,12 }, { 67,201,119,102,2 }, { 56,87,18,217,13 }, { 70,110,233,60,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1040)
		{ { 45,174,203,210,6 }, { 179,208,252,104,11 }, { 100,189,55,91,4 }, { 209,99,240,188,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1041)
		{ { 14,251,136,89,3 }, { 199,182,156,13,8 }, { 201,161,29,247,0 }, { 27,3,150,222,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1042)
		{ { 140,253,170,193,1 }, { 199,198,20,46,14 }, { 136,53,91,243,1 }, { 119,66,134,62,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1043)
		{ { 80,221,255,96,6 }, { 112,223,86,184,12 }, { 96,111,251,176,10 }, { 49,214,175,176,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1044)
		{ { 171,67,201,91,13 }, { 54,166,237,79,1 }, { 189,169,60,45,5 }, { 143,43,118,86,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1045)
		{ { 80,242,159,163,14 }, { 81,221,95,148,3 }, { 124,95,148,240,10 }, { 194,159,171,184,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1046)
		{ { 128,166,71,246,14 }, { 57,81,219,42,3 }, { 118,254,38,80,1 }, { 197,77,184,169,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1047)
		{ { 60,168,157,27,10 }, { 147,185,181,20,9 }, { 93,139,145,83,12 }, { 146,138,217,220,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1048)
		{ { 24,77,221,97,1 }, { 54,143,6,60,8 }, { 136,107,187,33,8 }, { 19,198,15,22,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1049)
		{ { 83,127,71,115,5 }, { 117,79,202,237,9 }, { 172,238,47,236,10 }, { 155,117,63,42,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1050)
		{ { 164,149,152,181,4 }, { 200,130,246,54,2 }, { 42,209,154,146,5 }, { 70,198,244,17,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1051)
		{ { 58,161,233,220,1 }, { 63,170,180,9,6 }, { 131,185,120,85,12 }, { 105,2,213,95,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1052)
		{ { 72,193,6,108,11 }, { 14,119,19,136,0 }, { 211,102,8,49,2 }, { 1,28,142,231,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1053)
		{ { 227,219,6,53,1 }, { 76,71,186,199,8 }, { 138,198,13,188,7 }, { 30,53,222,35,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1054)
		{ { 26,241,58,17,0 }, { 67,78,148,21,4 }, { 8,133,200,245,8 }, { 42,130,151,44,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1055)
		{ { 137,31,189,213,1 }, { 94,131,140,126,14 }, { 138,187,223,137,1 }, { 119,227,28,23,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1056)
		{ { 142,68,6,133,7 }, { 142,85,64,39,2 }, { 234,22,2,39,1 }, { 78,64,42,167,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1057)
		{ { 135,127,42,107,5 }, { 197,102,78,111,13 }, { 173,101,79,238,1 }, { 191,103,38,106,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1058)
		{ { 122,152,134,35,6 }, { 66,217,114,133,9 }, { 108,70,17,149,14 }, { 154,20,233,180,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1059)
		{ { 228,197,141,119,10 }, { 152,151,183,174,1 }, { 94,235,26,50,7 }, { 135,94,222,145,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1060)
		{ { 70,156,46,177,8 }, { 192,65,151,165,14 }, { 24,215,67,150,2 }, { 122,94,152,32,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1061)
		{ { 165,170,62,63,8 }, { 137,97,191,86,13 }, { 31,199,197,90,5 }, { 182,175,216,105,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1062)
		{ { 14,105,46,93,5 }, { 143,103,196,13,12 }, { 171,167,73,103,0 }, { 59,2,62,111,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1063)
		{ { 6,57,165,147,9 }, { 213,131,129,5,15 }, { 156,154,89,198,0 }, { 250,8,28,26,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1064)
		{ { 96,63,93,167,6 }, { 121,19,110,180,11 }, { 110,91,175,192,6 }, { 210,215,108,137,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1065)
		{ { 72,219,238,150,9 }, { 110,199,157,128,15 }, { 150,151,125,177,2 }, { 240,27,158,55,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1066)
		{ { 95,215,109,233,5 }, { 246,47,94,237,6 }, { 169,123,110,191,10 }, { 107,119,175,70,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1067)
		{ { 101,185,180,188,6 }, { 201,179,242,208,14 }, { 99,210,217,218,6 }, { 112,180,252,217,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1068)
		{ { 6,179,0,213,15 }, { 205,18,217,13,2 }, { 250,176,12,214,0 }, { 75,9,180,139,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1069)
		{ { 76,98,251,222,11 }, { 191,244,141,152,7 }, { 215,189,244,99,2 }, { 225,155,18,255,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1070)
		{ { 154,177,225,193,15 }, { 119,154,81,15,6 }, { 248,56,120,213,9 }, { 111,8,165,158,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1071)
		{ { 116,98,52,56,13 }, { 133,45,235,144,4 }, { 177,194,196,98,14 }, { 32,157,123,74,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1072)
		{ { 229,34,138,114,8 }, { 129,192,175,202,1 }, { 20,229,20,74,7 }, { 133,63,80,56,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1073)
		{ { 20,217,9,82,15 }, { 212,30,213,8,9 }, { 244,169,9,178,8 }, { 145,10,183,130,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1074)
		{ { 218,24,89,233,7 }, { 118,56,70,159,10 }, { 233,121,161,133,11 }, { 95,150,33,198,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1075)
		{ { 38,80,144,16,9 }, { 196,132,161,17,0 }, { 144,128,144,166,4 }, { 8,136,82,18,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1076)
		{ { 25,235,51,121,9 }, { 23,110,155,92,12 }, { 153,236,205,121,8 }, { 51,173,151,110,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1077)
		{ { 105,80,30,18,12 }, { 66,69,229,208,1 }, { 52,135,128,169,6 }, { 128,186,122,36,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1078)
		{ { 150,139,94,59,15 }, { 164,123,223,23,9 }, { 253,199,173,22,9 }, { 158,143,189,226,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1079)
		{ { 218,116,48,6,5 }, { 79,12,64,179,5 }, { 166,0,194,229,11 }, { 172,208,35,15,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1080)
		{ { 25,179,22,144,13 }, { 71,75,217,80,2 }, { 176,150,140,217,8 }, { 64,169,189,46,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1081)
		{ { 25,3,122,37,8 }, { 42,74,15,84,4 }, { 26,69,236,9,8 }, { 34,175,5,37,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1082)
		{ { 45,131,24,137,9 }, { 134,34,61,84,2 }, { 153,17,140,27,4 }, { 66,171,196,70,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1083)
		{ { 90,179,165,245,1 }, { 95,139,154,141,6 }, { 138,250,92,213,10 }, { 107,21,157,31,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1084)
		{ { 122,166,126,219,8 }, { 35,105,189,189,7 }, { 29,183,230,85,14 }, { 235,219,217,108,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1085)
		{ { 74,39,236,111,9 }, { 47,163,15,173,5 }, { 159,99,126,69,2 }, { 171,95,12,95,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1086)
		{ { 199,32,161,106,9 }, { 149,160,3,203,5 }, { 149,104,80,78,3 }, { 173,60,0,90,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1087)
		{ { 70,101,77,162,0 }, { 177,7,6,161,3 }, { 4,91,42,102,2 }, { 200,86,14,8,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1088)
		{ { 69,170,40,84,15 }, { 141,16,221,200,12 }, { 242,161,69,90,2 }, { 49,59,176,139,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1089)
		{ { 174,121,83,131,6 }, { 243,86,96,23,11 }, { 108,28,169,231,5 }, { 222,128,102,172,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1090)
		{ { 156,98,82,80,12 }, { 163,76,201,26,0 }, { 48,164,164,99,9 }, { 5,137,51,44,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1091)
		{ { 12,88,52,54,3 }, { 206,21,130,16,13 }, { 198,194,193,163,0 }, { 176,132,26,135,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1092)
		{ { 74,45,0,174,1 }, { 15,34,2,161,11 }, { 135,80,11,69,2 }, { 216,84,4,79,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1093)
		{ { 116,221,28,199,10 }, { 200,31,53,188,11 }, { 94,51,139,178,14 }, { 211,218,207,129,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1094)
		{ { 255,184,139,185,11 }, { 215,248,183,199,10 }, { 217,221,17,223,15 }, { 94,62,209,254,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1095)
		{ { 72,11,173,35,1 }, { 22,131,14,132,13 }, { 140,75,93,1,2 }, { 178,23,12,22,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1096)
		{ { 7,41,136,152,1 }, { 133,162,132,65,10 }, { 129,145,25,78,0 }, { 88,34,20,90,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1097)
		{ { 230,29,184,139,11 }, { 196,178,37,183,15 }, { 221,17,219,134,7 }, { 254,218,68,210,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1098)
		{ { 115,138,131,230,3 }, { 28,216,58,201,11 }, { 198,124,21,28,14 }, { 217,53,193,179,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1099)
		{ { 39,0,88,211,10 }, { 160,16,165,93,3 }, { 92,177,160,14,4 }, { 203,170,80,128,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1100)
		{ { 99,133,237,25,0 }, { 48,163,180,229,4 }, { 9,139,122,28,6 }, { 42,114,220,80,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1101)
		{ { 43,58,207,150,12 }, { 123,193,237,65,11 }, { 54,159,53,205,4 }, { 216,43,120,61,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1102)
		{ { 219,208,152,69,3 }, { 78,156,20,223,0 }, { 202,33,144,189,11 }, { 15,178,131,151,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1103)
		{ { 157,205,210,135,6 }, { 170,222,80,118,11 }, { 110,20,187,59,9 }, { 214,224,167,181,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1104)
		{ { 49,244,150,171,1 }, { 69,237,50,116,3 }, { 141,86,146,248,12 }, { 194,228,203,122,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1105)
		{ { 31,47,77,37,3 }, { 191,27,14,101,8 }, { 202,75,47,79,8 }, { 26,103,13,143,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1106)
		{ { 238,22,15,225,14 }, { 210,81,111,175,2 }, { 120,127,6,135,7 }, { 79,95,104,164,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1107)
		{ { 10,161,221,53,1 }, { 63,131,150,21,0 }, { 138,203,184,85,0 }, { 10,134,156,31,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1108)
		{ { 86,173,47,172,10 }, { 153,123,23,161,14 }, { 83,95,75,86,10 }, { 120,94,141,233,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1109)
		{ { 211,126,245,50,15 }, { 117,157,203,243,13 }, { 244,202,247,236,11 }, { 188,253,59,154,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1110)
		{ { 26,77,168,98,11 }, { 6,158,7,41,13 }, { 212,97,91,37,8 }, { 185,78,7,150,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1111)
		{ { 14,14,83,226,12 }, { 178,64,75,57,11 }, { 52,124,167,7,0 }, { 217,205,32,36,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1112)
		{ { 186,19,25,227,12 }, { 82,10,111,31,3 }, { 60,121,140,133,13 }, { 207,143,101,4,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1113)
		{ { 166,38,10,6,2 }, { 137,80,44,35,1 }, { 70,5,6,70,5 }, { 140,67,64,169,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1114)
		{ { 59,165,11,14,1 }, { 31,106,52,97,1 }, { 135,13,10,93,12 }, { 136,98,197,111,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1115)
		{ { 38,36,208,138,6 }, { 161,176,96,49,3 }, { 101,16,178,70,4 }, { 200,192,96,216,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1116)
		{ { 34,170,93,184,11 }, { 53,49,191,17,10 }, { 209,219,165,84,4 }, { 88,143,216,202,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1117)
		{ { 204,89,30,234,11 }, { 198,119,7,154,11 }, { 213,119,137,163,3 }, { 213,158,14,230,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1118)
		{ { 93,163,232,36,7 }, { 175,154,94,192,4 }, { 226,65,124,91,10 }, { 32,55,165,159,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1119)
		{ { 49,70,31,250,13 }, { 20,109,239,120,3 }, { 181,255,134,40,12 }, { 193,239,123,98,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1120)
		{ { 225,228,77,220,5 }, { 61,37,244,234,2 }, { 163,187,34,120,7 }, { 69,114,250,75,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1121)
		{ { 44,242,109,104,5 }, { 247,37,126,8,4 }, { 161,107,100,243,4 }, { 33,7,234,78,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1122)
		{ { 188,184,23,132,2 }, { 219,89,48,18,10 }, { 66,30,129,211,13 }, { 84,128,201,173,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1123)
		{ { 229,105,162,218,12 }, { 129,230,225,202,15 }, { 53,180,89,106,7 }, { 245,56,118,120,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1124)
		{ { 126,187,69,235,1 }, { 247,43,58,141,11 }, { 141,122,45,215,14 }, { 219,21,205,78,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1125)
		{ { 95,193,180,208,10 }, { 130,159,145,217,6 }, { 80,178,216,63,10 }, { 105,184,159,148,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1126)
		{ { 67,231,225,87,9 }, { 61,134,153,237,5 }, { 158,168,126,124,2 }, { 171,121,150,27,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1127)
		{ { 74,231,170,10,11 }, { 7,246,29,161,5 }, { 213,5,94,117,2 }, { 168,91,134,254,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1128)
		{ { 165,185,85,105,15 }, { 245,51,115,94,8 }, { 249,106,169,218,5 }, { 23,172,236,202,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1129)
		{ { 224,84,118,144,13 }, { 100,69,225,178,6 }, { 176,150,226,160,7 }, { 100,216,122,34,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1130)
		{ { 210,45,14,153,2 }, { 1,123,132,167,10 }, { 73,151,11,68,11 }, { 94,82,29,232,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1131)
		{ { 24,168,223,230,1 }, { 63,201,22,24,11 }, { 134,127,177,81,8 }, { 209,134,137,63,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1132)
		{ { 69,219,175,11,10 }, { 208,247,29,196,13 }, { 93,15,93,186,2 }, { 178,59,142,240,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1133)
		{ { 120,139,137,141,8 }, { 26,170,61,132,10 }, { 27,25,29,17,14 }, { 82,27,197,85,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1134)
		{ { 241,221,156,23,1 }, { 76,143,180,246,9 }, { 142,131,155,184,15 }, { 150,242,223,19,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1135)
		{ { 168,83,82,179,8 }, { 98,70,171,22,3 }, { 28,212,172,161,5 }, { 198,141,86,36,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1136)
		{ { 168,106,55,142,9 }, { 31,101,41,18,15 }, { 151,30,197,97,5 }, { 244,137,74,111,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1137)
		{ { 189,126,84,235,14 }, { 227,61,107,126,11 }, { 125,114,167,235,13 }, { 215,237,107,204,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1138)
		{ { 223,220,164,141,1 }, { 206,173,16,231,14 }, { 139,18,83,191,11 }, { 126,112,139,87,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1139)
		{ { 164,184,123,136,7 }, { 245,112,116,18,14 }, { 225,29,225,210,5 }, { 116,130,224,234,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1140)
		{ { 156,22,106,229,0 }, { 234,72,14,46,6 }, { 10,117,102,131,9 }, { 103,71,1,37,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1141)
		{ { 7,66,172,242,15 }, { 132,149,207,73,7 }, { 244,243,84,46,0 }, { 233,47,58,146,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1142)
		{ { 76,120,158,87,8 }, { 203,197,133,156,9 }, { 30,167,145,227,2 }, { 147,154,26,61,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1143)
		{ { 154,239,33,84,12 }, { 27,14,217,43,12 }, { 50,168,79,117,9 }, { 61,73,183,13,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1144)
		{ { 114,33,143,98,6 }, { 17,219,102,137,1 }, { 100,111,24,68,14 }, { 137,22,109,184,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1145)
		{ { 144,22,79,84,2 }, { 120,89,140,42,0 }, { 66,175,38,128,9 }, { 5,67,25,161,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1146)
		{ { 255,38,45,47,8 }, { 155,41,47,231,5 }, { 31,75,70,79,15 }, { 174,127,73,77,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1147)
		{ { 155,75,33,101,11 }, { 30,30,11,79,12 }, { 218,104,77,45,9 }, { 63,45,7,135,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1148)
		{ { 157,250,242,161,11 }, { 231,220,27,86,14 }, { 216,84,245,251,9 }, { 118,173,131,190,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1149)
		{ { 88,151,203,43,2 }, { 114,250,30,164,1 }, { 77,77,62,145,10 }, { 130,87,133,244,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1150)
		{ { 71,47,124,245,10 }, { 169,19,143,253,14 }, { 90,243,239,78,2 }, { 123,255,28,137,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1151)
		{ { 231,58,247,133,1 }, { 253,193,40,215,14 }, { 138,30,245,206,7 }, { 126,177,72,59,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1152)
		{ { 207,215,242,172,4 }, { 234,230,90,243,6 }, { 35,84,254,191,3 }, { 108,245,166,117,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1153)
		{ { 34,145,90,60,13 }, { 108,98,247,17,0 }, { 179,197,168,148,4 }, { 8,142,244,99,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1154)
		{ { 34,133,70,209,9 }, { 36,67,177,45,2 }, { 152,182,42,20,4 }, { 75,72,220,34,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1155)
		{ { 114,208,93,189,9 }, { 124,45,183,149,2 }, { 155,219,160,180,14 }, { 74,158,219,67,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1156)
		{ { 66,217,149,82,0 }, { 80,135,144,153,9 }, { 4,170,153,180,2 }, { 153,144,158,16,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1157)
		{ { 138,133,121,144,1 }, { 54,2,148,51,6 }, { 128,153,234,21,1 }, { 108,194,148,6,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1158)
		{ { 197,198,42,24,4 }, { 128,100,220,226,4 }, { 33,133,70,58,3 }, { 36,115,178,96,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1159)
		{ { 233,151,88,80,13 }, { 102,2,253,250,0 }, { 176,161,174,153,7 }, { 5,251,244,6,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1160)
		{ { 14,234,177,70,7 }, { 159,148,88,25,13 }, { 230,40,213,119,0 }, { 185,129,162,159,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1161)
		{ { 145,53,173,2,13 }, { 85,139,69,98,5 }, { 180,11,90,200,9 }, { 164,106,45,26,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1162)
		{ { 190,141,200,78,4 }, { 170,170,116,43,9 }, { 39,33,59,23,13 }, { 157,66,229,85,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1163)
		{ { 173,173,184,75,2 }, { 131,178,52,126,13 }, { 77,33,219,91,5 }, { 183,226,196,220,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1164)
		{ { 239,18,224,176,8 }, { 226,128,171,195,6 }, { 16,208,116,143,7 }, { 108,61,80,20,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1165)
		{ { 110,30,54,228,4 }, { 202,65,106,185,14 }, { 34,118,199,135,6 }, { 121,213,104,37,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1166)
		{ { 182,167,125,25,13 }, { 181,43,253,55,4 }, { 185,139,238,86,13 }, { 46,203,253,74,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1167)
		{ { 23,86,83,139,13 }, { 244,108,73,117,3 }, { 189,28,166,174,8 }, { 202,233,35,98,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1168)
		{ { 95,18,213,36,1 }, { 254,137,10,209,0 }, { 130,74,180,143,10 }, { 8,181,9,23,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1169)
		{ { 70,117,172,246,3 }, { 205,151,134,169,7 }, { 198,243,90,230,2 }, { 233,86,30,155,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1170)
		{ { 60,106,94,42,12 }, { 163,109,111,16,9 }, { 53,71,165,99,12 }, { 144,143,107,108,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1171)
		{ { 36,27,3,248,15 }, { 212,114,235,8,10 }, { 241,252,13,130,4 }, { 81,13,116,226,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1172)
		{ { 174,183,170,241,10 }, { 195,210,191,47,6 }, { 88,245,94,215,5 }, { 111,79,212,188,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1173)
		{ { 128,123,11,149,5 }, { 93,70,204,6,10 }, { 170,157,13,224,1 }, { 86,3,54,43,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1174)
		{ { 6,123,185,142,2 }, { 217,182,12,17,15 }, { 71,25,221,230,0 }, { 248,131,6,217,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1175)
		{ { 187,205,97,202,11 }, { 54,62,49,107,15 }, { 213,56,107,61,13 }, { 253,104,199,198,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1176)
		{ { 102,111,155,27,2 }, { 145,246,172,181,9 }, { 77,141,159,102,6 }, { 154,211,86,248,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1177)
		{ { 220,128,108,119,5 }, { 174,9,214,142,5 }, { 174,227,96,19,11 }, { 167,22,185,7,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1178)
		{ { 244,76,119,37,13 }, { 188,77,99,182,12 }, { 186,78,227,34,15 }, { 54,220,107,35,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1179)
		{ { 114,219,75,25,1 }, { 116,110,188,133,8 }, { 137,141,45,180,14 }, { 26,19,215,98,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1180)
		{ { 16,18,108,127,9 }, { 108,41,143,12,5 }, { 159,227,100,128,8 }, { 163,15,25,67,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1181)
		{ { 162,1,124,141,13 }, { 44,35,101,23,6 }, { 187,19,232,4,5 }, { 110,138,108,67,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1182)
		{ { 92,43,98,199,13 }, { 175,74,73,140,15 }, { 190,52,109,67,10 }, { 243,25,37,47,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1183)
		{ { 246,17,249,50,13 }, { 244,138,231,147,5 }, { 180,201,248,134,15 }, { 172,158,117,18,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1184)
		{ { 29,202,246,89,3 }, { 166,253,152,92,12 }, { 201,166,245,59,8 }, { 51,161,155,246,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1185)
		{ { 246,222,90,183,0 }, { 232,76,190,183,11 }, { 14,213,167,182,15 }, { 222,215,211,33,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1186)
		{ { 2,227,95,133,4 }, { 57,71,92,21,2 }, { 42,31,172,116,0 }, { 74,131,174,41,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1187)
		{ { 154,82,200,49,13 }, { 102,140,207,7,0 }, { 184,193,52,165,9 }, { 14,15,51,22,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1188)
		{ { 201,156,238,248,13 }, { 102,225,215,234,14 }, { 177,247,115,153,3 }, { 117,126,184,118,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1189)
		{ { 164,0,185,178,3 }, { 148,144,166,18,7 }, { 196,217,208,2,5 }, { 228,134,80,146,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1190)
		{ { 83,189,160,149,3 }, { 77,154,144,229,14 }, { 202,144,91,220,10 }, { 122,112,149,155,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1191)
		{ { 229,156,80,168,12 }, { 224,32,115,242,10 }, { 49,80,163,154,7 }, { 84,252,224,64,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1192)
		{ { 171,95,148,193,7 }, { 70,151,104,127,10 }, { 232,50,159,173,5 }, { 95,225,110,150,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1193)
		{ { 154,1,159,43,13 }, { 22,235,71,23,1 }, { 189,79,152,5,9 }, { 142,142,45,118,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1194)
		{ { 179,111,58,61,12 }, { 9,110,239,119,12 }, { 59,197,207,108,13 }, { 62,239,119,105,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1195)
		{ { 192,187,244,25,3 }, { 101,179,152,150,12 }, { 201,130,253,208,3 }, { 54,145,156,218,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1196)
		{ { 20,123,78,197,0 }, { 233,79,12,12,10 }, { 10,55,45,226,8 }, { 83,3,15,41,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1197)
		{ { 90,199,71,252,14 }, { 58,127,219,169,2 }, { 115,254,46,53,10 }, { 73,93,191,229,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1198)
		{ { 55,33,111,157,0 }, { 185,107,164,69,6 }, { 11,159,104,78,12 }, { 106,34,93,105,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1199)
		{ { 1,111,252,42,3 }, { 37,183,14,112,13 }, { 197,67,255,104,0 }, { 176,231,14,218,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1200)
		{ { 89,15,175,61,8 }, { 26,235,143,228,12 }, { 27,207,95,9,10 }, { 50,127,29,117,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1201)
		{ { 153,1,84,216,10 }, { 34,59,129,90,2 }, { 81,178,168,9,9 }, { 69,168,29,196,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1202)
		{ { 67,238,76,167,7 }, { 45,21,94,229,11 }, { 238,83,39,124,2 }, { 218,119,170,139,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1203)
		{ { 54,90,193,205,0 }, { 248,172,40,13,10 }, { 11,56,53,166,12 }, { 91,1,67,81,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1204)
		{ { 131,166,230,183,5 }, { 45,193,218,103,7 }, { 174,214,118,92,1 }, { 238,101,184,59,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1205)
		{ { 19,38,191,52,9 }, { 29,201,143,113,4 }, { 146,207,214,76,8 }, { 40,239,25,59,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1206)
		{ { 75,112,99,4,11 }, { 127,84,1,193,4 }, { 210,12,96,237,2 }, { 40,56,2,175,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1207)
		{ { 138,249,189,185,10 }, { 83,183,151,23,14 }, { 89,219,217,245,1 }, { 126,142,158,220,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1208)
		{ { 210,150,211,86,13 }, { 124,200,217,187,1 }, { 182,172,182,148,11 }, { 141,217,177,51,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1209)
		{ { 191,171,59,228,2 }, { 155,90,62,91,14 }, { 66,125,205,95,13 }, { 125,167,197,173,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1210)
		{ { 174,86,204,98,6 }, { 226,149,110,43,1 }, { 100,99,54,167,5 }, { 141,71,106,148,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1211)
		{ { 178,87,177,0,1 }, { 84,142,40,51,4 }, { 128,8,222,164,13 }, { 44,193,71,18,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1212)
		{ { 62,59,212,245,0 }, { 235,139,170,29,10 }, { 10,242,189,199,12 }, { 91,133,93,29,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1213)
		{ { 81,226,98,81,13 }, { 37,76,217,204,4 }, { 184,164,100,120,10 }, { 35,57,179,42,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1214)
		{ { 109,172,163,64,13 }, { 151,192,113,232,12 }, { 176,44,83,91,6 }, { 49,120,224,62,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1215)
		{ { 140,97,186,38,3 }, { 143,214,6,18,5 }, { 198,69,216,99,1 }, { 164,134,6,191,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1216)
		{ { 188,245,45,34,0 }, { 211,15,54,34,5 }, { 4,75,74,243,13 }, { 164,70,207,12,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1217)
		{ { 211,103,251,121,3 }, { 53,254,142,255,4 }, { 201,237,254,108,11 }, { 47,247,23,250,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1218)
		{ { 84,87,19,84,12 }, { 216,78,201,184,0 }, { 50,172,142,162,10 }, { 1,217,55,33,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1219)
		{ { 252,69,102,73,14 }, { 162,127,97,174,4 }, { 121,38,106,35,15 }, { 39,88,111,228,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1220)
		{ { 201,116,9,180,3 }, { 95,20,134,226,2 }, { 194,217,2,233,3 }, { 68,118,18,143,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1221)
		{ { 219,223,58,117,6 }, { 74,94,222,255,12 }, { 106,229,207,189,11 }, { 63,247,183,165,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1222)
		{ { 124,198,54,99,4 }, { 130,77,122,188,5 }, { 44,102,198,51,14 }, { 163,213,235,36,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1223)
		{ { 199,37,21,237,7 }, { 157,51,66,255,2 }, { 235,122,138,78,3 }, { 79,244,44,203,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1224)
		{ { 243,129,78,141,3 }, { 44,123,52,199,2 }, { 203,23,40,28,15 }, { 78,50,205,227,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1225)
		{ { 1,97,236,83,14 }, { 33,151,197,76,5 }, { 124,163,120,104,0 }, { 163,42,62,152,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1226)
		{ { 185,10,129,53,14 }, { 26,152,235,70,8 }, { 122,200,21,9,13 }, { 22,45,113,149,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1227)
		{ { 206,10,5,154,5 }, { 150,33,200,131,11 }, { 165,154,5,7,3 }, { 220,17,56,70,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1228)
		{ { 177,143,157,57,3 }, { 20,187,190,118,8 }, { 201,203,159,24,13 }, { 22,231,221,210,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1229)
		{ { 148,176,8,30,13 }, { 205,40,213,2,1 }, { 183,129,0,210,9 }, { 132,10,177,75,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1230)
		{ { 80,66,146,213,15 }, { 12,220,201,156,2 }, { 250,180,148,32,10 }, { 67,153,51,179,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1231)
		{ { 35,150,114,80,11 }, { 100,80,185,121,4 }, { 208,164,230,156,4 }, { 41,233,208,162,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1232)
		{ { 68,239,204,54,11 }, { 173,151,159,160,9 }, { 214,195,63,114,2 }, { 144,95,158,155,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1233)
		{ { 31,253,132,177,6 }, { 195,159,210,101,10 }, { 104,210,27,255,8 }, { 90,100,191,156,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1234)
		{ { 197,49,181,191,8 }, { 217,163,131,214,7 }, { 31,218,216,202,3 }, { 230,188,28,89,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1235)
		{ { 22,150,178,17,4 }, { 192,200,216,53,4 }, { 40,132,214,150,8 }, { 42,193,177,48,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1236)
		{ { 38,79,248,144,13 }, { 164,134,237,49,14 }, { 176,145,255,38,4 }, { 120,203,118,18,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1237)
		{ { 246,196,223,173,7 }, { 188,253,118,183,2 }, { 235,95,178,54,15 }, { 78,214,235,243,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1238)
		{ { 156,24,84,188,5 }, { 238,41,194,18,10 }, { 163,210,161,131,9 }, { 84,132,57,71,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1239)
		{ { 19,208,219,228,10 }, { 120,220,23,89,2 }, { 82,125,176,188,8 }, { 73,174,131,177,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1240)
		{ { 249,179,22,59,4 }, { 67,107,250,214,1 }, { 45,198,140,217,15 }, { 134,181,253,108,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1241)
		{ { 81,149,114,252,7 }, { 108,122,210,248,6 }, { 227,244,234,152,10 }, { 97,244,181,227,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1242)
		{ { 242,39,249,70,5 }, { 61,138,108,187,5 }, { 166,41,254,68,15 }, { 173,211,101,27,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1243)
		{ { 102,190,189,206,13 }, { 221,161,125,185,15 }, { 183,59,215,214,6 }, { 249,219,232,91,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1244)
		{ { 214,222,191,213,4 }, { 216,205,220,191,14 }, { 42,191,215,182,11 }, { 127,211,187,49,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1245)
		{ { 42,6,160,45,8 }, { 10,160,43,37,4 }, { 27,64,86,5,4 }, { 42,77,64,85,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1246)
		{ { 20,53,95,118,11 }, { 253,91,135,56,1 }, { 214,239,170,194,8 }, { 129,206,29,171,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1247)
		{ { 10,147,60,139,0 }, { 66,35,28,21,7 }, { 13,19,204,149,0 }, { 234,131,140,68,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1248)
		{ { 41,181,114,31,7 }, { 111,114,240,116,5 }, { 239,132,234,217,4 }, { 162,224,244,239,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1249)
		{ { 10,176,119,109,10 }, { 123,113,19,29,4 }, { 91,110,224,213,0 }, { 43,140,136,237,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1250)
		{ { 73,99,125,47,0 }, { 59,39,14,212,5 }, { 15,75,236,105,2 }, { 162,183,14,77,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1251)
		{ { 129,17,157,135,11 }, { 92,147,5,86,3 }, { 222,27,152,136,1 }, { 198,170,12,147,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1252)
		{ { 140,179,51,58,10 }, { 211,114,155,18,5 }, { 85,204,204,211,1 }, { 164,141,148,236,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1253)
		{ { 178,29,155,97,0 }, { 80,202,38,63,8 }, { 8,109,155,132,13 }, { 31,198,69,48,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1254)
		{ { 188,118,206,213,10 }, { 235,221,173,46,2 }, { 90,183,54,227,13 }, { 71,75,91,189,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1255)
		{ { 160,15,75,230,8 }, { 56,66,47,42,11 }, { 22,125,47,0,5 }, { 213,79,68,33,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1256)
		{ { 68,168,183,24,8 }, { 145,225,145,144,12 }, { 17,142,209,82,2 }, { 48,152,152,120,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1257)
		{ { 192,147,189,209,12 }, { 80,131,221,158,6 }, { 56,187,220,144,3 }, { 103,155,188,16,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1258)
		{ { 67,88,203,57,12 }, { 112,228,199,197,8 }, { 57,205,49,172,2 }, { 26,62,50,112,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1259)
		{ { 138,61,137,8,12 }, { 83,162,69,35,8 }, { 49,9,27,197,1 }, { 28,74,36,92,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1260)
		{ { 252,190,21,102,11 }, { 223,25,59,186,9 }, { 214,106,135,211,15 }, { 149,221,201,143,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1261)
		{ { 203,103,181,191,5 }, { 31,167,202,247,7 }, { 175,218,222,109,3 }, { 238,245,62,95,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1262)
		{ { 233,7,248,189,4 }, { 42,162,238,246,6 }, { 43,209,254,9,7 }, { 102,247,116,85,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1263)
		{ { 75,186,42,243,10 }, { 67,80,159,205,15 }, { 92,245,69,221,2 }, { 251,63,144,172,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1264)
		{ { 113,234,245,7,10 }, { 57,157,57,212,13 }, { 94,10,245,120,14 }, { 178,185,203,153,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1265)
		{ { 147,43,182,127,6 }, { 9,251,202,95,13 }, { 111,230,221,76,9 }, { 191,165,61,249,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1266)
		{ { 83,241,61,70,1 }, { 93,15,20,217,5 }, { 134,43,200,252,10 }, { 169,178,143,11,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1267)
		{ { 99,45,7,61,3 }, { 29,115,162,229,8 }, { 203,206,11,76,6 }, { 26,116,92,235,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1268)
		{ { 187,21,254,209,0 }, { 98,203,164,127,6 }, { 8,183,250,141,13 }, { 111,226,93,52,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1269)
		{ { 249,117,16,139,12 }, { 67,46,97,246,3 }, { 61,16,138,233,15 }, { 198,248,103,76,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1270)
		{ { 82,137,180,183,15 }, { 12,155,211,149,15 }, { 254,210,217,20,10 }, { 250,156,189,147,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1271)
		{ { 27,210,12,213,13 }, { 78,13,221,77,2 }, { 186,179,4,189,8 }, { 75,43,187,7,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1272)
		{ { 177,242,231,215,11 }, { 125,221,185,78,7 }, { 222,190,116,248,13 }, { 231,41,219,187,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1273)
		{ { 59,199,234,23,8 }, { 42,206,189,101,5 }, { 30,133,126,61,12 }, { 170,107,215,53,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1274)
		{ { 129,160,44,14,10 }, { 9,49,21,66,5 }, { 87,3,64,88,1 }, { 164,42,136,201,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1275)
		{ { 175,47,221,40,8 }, { 179,163,47,115,8 }, { 17,75,191,79,5 }, { 28,239,76,92,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1276)
		{ { 102,160,63,60,5 }, { 157,97,246,145,4 }, { 163,207,192,86,6 }, { 40,150,248,107,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1277)
		{ { 97,107,54,64,2 }, { 1,87,40,216,12 }, { 64,38,205,104,6 }, { 49,177,78,168,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1278)
		{ { 179,110,223,102,4 }, { 57,205,110,123,9 }, { 38,111,183,108,13 }, { 157,231,107,57,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1279)
		{ { 221,206,234,142,13 }, { 174,236,93,226,15 }, { 183,21,119,59,11 }, { 244,123,163,119,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1280)
		{ { 191,161,228,191,4 }, { 171,171,242,71,7 }, { 47,210,120,95,13 }, { 238,36,253,93,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1281)
		{ { 181,50,205,129,2 }, { 241,153,44,70,2 }, { 72,27,52,202,13 }, { 70,35,73,152,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1282)
		{ { 93,75,26,56,8 }, { 130,110,143,208,8 }, { 17,197,141,43,10 }, { 16,191,23,100,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1283)
		{ { 178,246,24,165,12 }, { 73,12,127,55,2 }, { 58,81,134,244,13 }, { 78,207,227,9,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1284)
		{ { 56,237,90,165,11 }, { 47,94,55,52,10 }, { 218,85,171,113,12 }, { 82,206,199,175,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1285)
		{ { 73,219,225,19,5 }, { 118,134,216,196,13 }, { 172,136,125,185,2 }, { 178,49,182,22,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1286)
		{ { 73,170,182,189,9 }, { 15,225,155,212,14 }, { 155,214,213,89,2 }, { 114,189,152,127,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1287)
		{ { 84,139,234,26,2 }, { 160,250,156,128,13 }, { 69,133,125,18,10 }, { 176,19,149,240,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1288)
		{ { 157,15,70,19,1 }, { 166,75,136,102,9 }, { 140,134,47,11,9 }, { 150,97,29,38,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1289)
		{ { 102,97,19,14,1 }, { 157,102,32,145,1 }, { 135,12,136,102,6 }, { 136,144,70,107,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1290)
		{ { 248,9,47,37,2 }, { 26,91,38,134,12 }, { 74,79,73,1,15 }, { 54,22,77,165,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1291)
		{ { 11,201,149,46,14 }, { 26,183,83,81,9 }, { 119,74,153,61,0 }, { 152,172,174,213,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1292)
		{ { 184,19,104,249,3 }, { 102,58,174,14,6 }, { 201,241,108,129,13 }, { 103,7,85,198,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1293)
		{ { 247,151,168,45,7 }, { 204,186,126,231,4 }, { 235,65,94,158,15 }, { 46,119,229,211,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1294)
		{ { 64,198,85,224,12 }, { 48,5,91,184,2 }, { 48,122,166,48,2 }, { 65,221,170,0,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1295)
		{ { 119,132,246,36,5 }, { 172,201,114,241,4 }, { 162,70,242,30,14 }, { 40,244,233,51,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1296)
		{ { 67,149,31,37,8 }, { 88,67,23,245,0 }, { 26,79,138,156,2 }, { 10,254,140,33,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1297)
		{ { 45,159,144,243,0 }, { 194,130,186,124,11 }, { 12,240,159,155,4 }, { 211,229,212,20,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1298)
		{ { 146,221,176,205,11 }, { 76,190,17,63,14 }, { 219,48,219,180,9 }, { 127,200,135,211,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1299)
		{ { 246,199,216,26,12 }, { 160,174,253,179,1 }, { 53,129,190,54,15 }, { 140,219,247,80,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1300)
		{ { 24,194,89,137,6 }, { 50,60,92,20,2 }, { 105,25,164,49,8 }, { 66,131,163,196,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1301)
		{ { 191,94,230,119,1 }, { 238,205,170,111,13 }, { 142,230,119,175,13 }, { 191,101,91,55,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1302)
		{ { 154,185,210,41,10 }, { 99,250,19,23,8 }, { 89,68,185,213,9 }, { 30,140,133,252,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1303)
		{ { 85,134,127,171,1 }, { 180,105,30,244,7 }, { 141,95,230,26,10 }, { 226,247,137,98,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1304)
		{ { 184,210,232,62,14 }, { 106,188,255,2,5 }, { 119,193,116,177,13 }, { 164,15,243,213,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1305)
		{ { 8,95,31,243,10 }, { 82,87,143,60,11 }, { 92,255,143,161,0 }, { 211,207,30,164,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1306)
		{ { 18,244,23,56,3 }, { 85,125,146,49,0 }, { 193,206,130,244,8 }, { 8,196,155,234,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1307)
		{ { 166,113,141,223,14 }, { 217,183,229,15,3 }, { 127,187,24,230,5 }, { 207,10,126,217,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1308)
		{ { 192,142,206,109,0 }, { 40,225,30,174,8 }, { 11,103,55,16,3 }, { 23,87,136,113,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1309)
		{ { 109,149,12,180,7 }, { 206,19,246,224,2 }, { 226,211,10,155,6 }, { 64,118,252,135,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1310)
		{ { 150,47,248,18,6 }, { 161,154,204,51,13 }, { 100,129,255,70,9 }, { 188,195,53,152,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1311)
		{ { 100,178,210,193,10 }, { 225,208,57,156,2 }, { 88,52,180,210,6 }, { 67,153,192,184,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1312)
		{ { 171,232,165,221,12 }, { 27,165,241,79,14 }, { 59,186,81,125,5 }, { 127,40,250,93,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1313)
		{ { 1,1,118,119,7 }, { 44,83,194,92,5 }, { 238,230,232,8,0 }, { 163,164,60,163,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1314)
		{ { 122,87,242,127,10 }, { 106,254,171,189,5 }, { 95,228,254,165,14 }, { 171,221,87,245,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1315)
		{ { 49,50,151,33,7 }, { 85,217,106,84,0 }, { 232,78,148,200,12 }, { 2,165,105,186,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1316)
		{ { 84,80,181,69,13 }, { 220,141,65,156,4 }, { 186,42,208,162,10 }, { 35,152,43,19,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1317)
		{ { 11,87,84,254,5 }, { 110,39,202,121,3 }, { 167,242,174,173,0 }, { 201,229,62,71,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1318)
		{ { 182,45,55,60,6 }, { 153,123,226,51,12 }, { 99,206,203,70,13 }, { 60,196,125,233,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1319)
		{ { 148,78,188,41,1 }, { 132,173,14,54,12 }, { 137,67,215,34,9 }, { 54,199,11,82,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1320)
		{ { 212,209,225,203,8 }, { 240,174,17,142,7 }, { 29,56,120,178,11 }, { 231,24,135,80,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1321)
		{ { 41,127,114,212,15 }, { 111,86,233,120,14 }, { 242,180,239,233,4 }, { 113,233,118,175,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1322)
		{ { 185,41,143,89,11 }, { 23,251,165,78,8 }, { 217,175,25,73,13 }, { 23,42,93,254,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1323)
		{ { 156,178,65,173,13 }, { 255,40,91,6,2 }, { 187,88,36,211,9 }, { 70,13,161,79,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1324)
		{ { 9,10,241,177,13 }, { 54,128,203,84,14 }, { 184,216,245,9,0 }, { 114,173,48,22,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1325)
		{ { 16,185,135,171,7 }, { 85,251,82,4,11 }, { 237,94,25,208,8 }, { 210,4,173,250,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1326)
		{ { 126,194,225,64,6 }, { 178,156,120,137,4 }, { 96,40,116,55,14 }, { 41,17,227,148,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1327)
		{ { 67,167,86,127,1 }, { 45,99,154,253,1 }, { 143,230,174,92,2 }, { 139,245,156,107,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1328)
		{ { 26,3,90,19,6 }, { 34,90,204,21,1 }, { 108,133,172,5,8 }, { 138,131,53,164,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1329)
		{ { 29,135,214,9,13 }, { 166,235,89,116,0 }, { 185,6,190,27,8 }, { 2,233,173,118,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1330)
		{ { 166,252,66,185,15 }, { 229,116,243,39,10 }, { 249,212,35,246,5 }, { 94,76,242,234,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1331)
		{ { 107,129,183,247,6 }, { 26,211,242,221,7 }, { 110,254,216,29,6 }, { 235,180,252,181,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1332)
		{ { 69,254,109,129,14 }, { 241,21,93,228,14 }, { 120,27,103,250,2 }, { 114,123,170,136,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1333)
		{ { 53,236,43,184,7 }, { 149,124,246,96,14 }, { 225,221,67,122,12 }, { 112,102,243,234,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1334)
		{ { 49,88,4,149,14 }, { 72,29,225,68,10 }, { 122,146,1,168,12 }, { 82,40,123,129,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1335)
		{ { 152,19,34,45,15 }, { 78,122,75,6,4 }, { 251,68,76,129,9 }, { 38,13,37,231,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1336)
		{ { 154,159,90,231,3 }, { 110,90,30,63,11 }, { 206,117,175,149,9 }, { 223,199,133,167,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1337)
		{ { 212,231,111,182,1 }, { 189,79,158,162,7 }, { 134,223,110,114,11 }, { 228,87,159,43,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1338)
		{ { 229,90,150,106,14 }, { 192,245,107,218,9 }, { 117,102,149,170,7 }, { 149,189,106,240,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1339)
		{ { 79,187,212,222,13 }, { 239,163,217,217,11 }, { 183,178,189,223,2 }, { 217,185,188,95,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1340)
		{ { 121,157,133,152,15 }, { 86,187,241,224,10 }, { 241,154,27,153,14 }, { 80,120,253,214,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1341)
		{ { 9,112,158,165,9 }, { 79,197,7,84,2 }, { 154,87,144,233,0 }, { 66,174,10,63,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1342)
		{ { 3,87,205,203,8 }, { 112,167,13,109,3 }, { 29,59,62,172,0 }, { 203,107,14,80,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1343)
		{ { 212,185,186,58,5 }, { 197,234,214,146,13 }, { 165,197,217,210,11 }, { 180,150,181,122,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1344)
		{ { 24,64,161,74,8 }, { 18,172,1,8,5 }, { 21,40,80,33,8 }, { 161,8,3,84,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1345)
		{ { 118,93,35,164,0 }, { 216,78,34,161,14 }, { 2,92,75,166,14 }, { 120,84,71,33,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1346)
		{ { 215,210,250,82,11 }, { 228,220,157,219,5 }, { 212,165,244,190,11 }, { 173,187,147,178,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1347)
		{ { 112,131,115,144,14 }, { 48,90,249,144,6 }, { 112,156,236,16,14 }, { 96,153,245,160,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1348)
		{ { 54,219,219,178,9 }, { 244,206,191,17,11 }, { 148,221,189,182,12 }, { 216,143,215,50,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1349)
		{ { 238,65,132,139,9 }, { 134,167,33,135,3 }, { 157,18,24,39,7 }, { 206,24,78,86,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1350)
		{ { 82,197,48,152,6 }, { 0,62,208,177,6 }, { 97,144,202,52,10 }, { 104,208,183,192,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1351)
		{ { 252,86,183,22,2 }, { 218,221,168,178,5 }, { 70,142,214,163,15 }, { 164,209,91,181,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1352)
		{ { 116,165,189,128,1 }, { 149,139,52,176,6 }, { 128,27,218,82,14 }, { 96,210,205,26,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1353)
		{ { 149,143,205,134,4 }, { 184,139,92,98,11 }, { 38,27,63,26,9 }, { 212,99,173,17,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1354)
		{ { 217,178,146,205,0 }, { 75,232,24,222,2 }, { 11,52,148,217,11 }, { 71,177,129,125,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1355)
		{ { 167,235,71,193,10 }, { 177,87,57,79,10 }, { 88,62,45,126,5 }, { 95,41,206,168,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1356)
		{ { 79,1,94,2,9 }, { 166,67,5,209,1 }, { 148,7,168,15,2 }, { 136,186,12,38,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1357)
		{ { 106,36,9,113,10 }, { 19,16,167,173,0 }, { 88,233,2,69,6 }, { 11,94,80,140,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1358)
		{ { 206,68,49,8,9 }, { 150,36,1,179,4 }, { 145,8,194,39,3 }, { 44,216,2,70,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1359)
		{ { 49,255,30,233,10 }, { 65,127,63,124,10 }, { 89,119,143,248,12 }, { 83,239,207,232,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1360)
		{ { 20,10,7,54,11 }, { 156,89,139,0,9 }, { 214,206,5,2,8 }, { 144,13,25,163,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1361)
		{ { 70,59,86,20,0 }, { 233,67,136,145,8 }, { 2,134,173,198,2 }, { 24,145,28,41,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1362)
		{ { 59,6,12,183,14 }, { 10,25,239,101,3 }, { 126,211,6,13,12 }, { 202,111,121,133,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1363)
		{ { 183,192,126,222,10 }, { 168,125,181,91,7 }, { 87,183,224,62,13 }, { 237,170,219,225,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1364)
		{ { 131,167,59,199,12 }, { 25,66,93,127,7 }, { 62,61,206,92,1 }, { 239,235,164,41,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1365)
		{ { 169,68,61,125,8 }, { 26,37,167,126,4 }, { 27,235,194,41,5 }, { 39,238,90,69,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1366)
		{ { 89,62,133,40,0 }, { 83,169,10,224,8 }, { 1,74,23,201,10 }, { 16,117,9,92,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1367)
		{ { 91,223,9,190,3 }, { 94,62,158,225,11 }, { 199,217,15,189,10 }, { 216,119,151,199,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1368)
		{ { 90,199,81,168,1 }, { 54,46,26,177,2 }, { 129,88,174,53,10 }, { 72,213,135,70,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1369)
		{ { 172,197,14,185,6 }, { 130,119,246,38,2 }, { 105,215,10,51,5 }, { 70,70,254,228,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1370)
		{ { 140,158,159,124,11 }, { 222,241,159,58,8 }, { 211,239,151,147,1 }, { 21,207,152,247,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1371)
		{ { 94,223,124,158,10 }, { 234,63,157,177,15 }, { 87,147,239,183,10 }, { 248,219,159,197,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1372)
		{ { 194,247,145,150,7 }, { 93,150,216,179,3 }, { 230,152,158,244,3 }, { 204,209,182,155,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1373)
		{ { 104,128,250,139,3 }, { 38,240,52,148,7 }, { 205,21,240,17,6 }, { 226,146,192,246,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1374)
		{ { 164,118,61,185,15 }, { 213,53,239,54,6 }, { 249,219,198,226,5 }, { 102,207,122,202,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1375)
		{ { 232,136,149,37,11 }, { 30,145,51,150,8 }, { 218,74,145,17,7 }, { 22,156,200,151,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1376)
		{ { 94,137,11,42,0 }, { 146,106,22,129,9 }, { 5,77,9,23,10 }, { 152,22,133,100,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1377)
		{ { 168,252,52,240,6 }, { 67,21,242,58,14 }, { 96,242,195,241,5 }, { 117,196,250,140,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1378)
		{ { 102,80,220,156,14 }, { 232,181,229,145,2 }, { 115,147,176,166,6 }, { 72,154,122,209,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1379)
		{ { 217,235,112,198,6 }, { 43,30,88,218,15 }, { 102,48,237,121,11 }, { 245,177,167,141,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1380)
		{ { 6,57,26,27,7 }, { 197,114,196,21,9 }, { 237,133,137,198,0 }, { 154,130,52,234,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1381)
		{ { 100,213,236,219,14 }, { 224,183,245,172,7 }, { 125,179,122,178,6 }, { 227,90,254,208,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1382)
		{ { 80,23,140,98,3 }, { 68,155,14,168,1 }, { 196,99,30,128,10 }, { 129,87,13,146,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1383)
		{ { 128,175,91,93,8 }, { 57,98,157,62,8 }, { 27,173,175,80,1 }, { 23,203,148,105,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1384)
		{ { 178,110,247,189,9 }, { 61,237,171,55,14 }, { 155,222,247,100,13 }, { 126,205,91,123,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1385)
		{ { 210,217,41,11,11 }, { 84,62,21,135,13 }, { 221,9,73,180,11 }, { 190,26,135,194,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1386)
		{ { 142,230,136,246,1 }, { 143,132,158,43,3 }, { 134,241,22,119,1 }, { 205,71,146,31,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1387)
		{ { 144,133,126,179,5 }, { 36,75,214,54,7 }, { 172,215,234,16,9 }, { 230,198,189,34,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1388)
		{ { 214,244,185,51,14 }, { 209,156,215,183,5 }, { 124,201,210,246,11 }, { 174,222,179,152,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1389)
		{ { 68,17,154,175,12 }, { 200,226,71,148,3 }, { 63,85,152,130,2 }, { 194,158,36,113,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1390)
		{ { 48,177,90,93,2 }, { 105,122,180,28,0 }, { 75,165,168,208,12 }, { 3,130,213,233,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1391)
		{ { 66,57,254,118,6 }, { 105,211,198,153,13 }, { 102,231,249,196,2 }, { 185,150,60,185,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1392)
		{ { 108,223,228,140,12 }, { 234,167,121,160,14 }, { 51,18,127,179,6 }, { 112,89,238,85,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1393)
		{ { 110,159,250,19,0 }, { 226,194,188,181,13 }, { 12,133,255,151,6 }, { 186,211,212,52,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1394)
		{ { 251,180,205,219,9 }, { 119,169,181,239,3 }, { 157,187,50,221,15 }, { 207,122,217,94,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1395)
		{ { 106,94,54,11,12 }, { 66,101,105,181,13 }, { 61,6,199,165,6 }, { 186,217,106,100,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1396)
		{ { 187,128,110,3,5 }, { 38,73,116,71,5 }, { 172,7,96,29,13 }, { 174,34,233,38,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1397)
		{ { 151,235,197,191,10 }, { 185,191,155,71,11 }, { 95,218,61,126,9 }, { 222,45,159,217,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1398)
		{ { 15,117,226,80,2 }, { 227,214,128,105,4 }, { 64,164,122,239,0 }, { 41,96,22,188,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1399)
		{ { 11,49,73,156,8 }, { 123,34,133,65,2 }, { 19,153,40,205,0 }, { 72,42,20,77,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1400)
		{ { 215,174,213,193,8 }, { 177,137,25,255,10 }, { 24,58,183,94,11 }, { 95,249,137,24,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1401)
		{ { 210,248,182,187,9 }, { 69,237,147,151,15 }, { 157,214,209,244,11 }, { 254,156,155,122,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1402)
		{ { 34,55,245,42,9 }, { 117,163,43,49,5 }, { 149,74,254,196,4 }, { 168,205,76,90,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1403)
		{ { 68,127,202,153,4 }, { 225,230,204,164,10 }, { 41,149,63,226,2 }, { 82,83,54,120,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1404)
		{ { 141,146,126,41,15 }, { 230,113,95,86,4 }, { 249,71,228,155,1 }, { 38,175,168,230,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1405)
		{ { 13,54,100,46,5 }, { 239,33,74,96,5 }, { 167,66,102,203,0 }, { 160,101,40,79,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1406)
		{ { 213,191,237,221,12 }, { 249,171,221,238,14 }, { 59,187,127,218,11 }, { 119,123,189,89,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1407)
		{ { 139,198,212,229,1 }, { 46,133,26,127,2 }, { 138,114,182,61,1 }, { 79,229,138,23,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1408)
		{ { 221,244,124,110,1 }, { 239,45,22,250,5 }, { 135,99,226,251,11 }, { 165,246,139,79,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1409)
		{ { 69,159,45,147,1 }, { 212,3,156,228,15 }, { 140,155,79,154,2 }, { 242,115,156,2,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1410)
		{ { 134,21,175,172,5 }, { 220,227,70,35,6 }, { 163,95,90,134,1 }, { 108,70,44,115,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1411)
		{ { 52,174,42,121,9 }, { 133,104,191,44,12 }, { 153,229,71,82,12 }, { 51,79,209,106,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1412)
		{ { 246,135,29,191,4 }, { 152,43,254,183,3 }, { 47,219,142,22,15 }, { 206,215,253,65,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1413)
		{ { 22,183,193,11,4 }, { 241,170,88,37,1 }, { 45,8,62,214,8 }, { 138,65,165,88,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1414)
		{ { 122,54,203,160,5 }, { 119,200,110,161,2 }, { 160,93,54,197,14 }, { 72,87,97,62,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1415)
		{ { 127,66,16,98,10 }, { 130,28,43,217,1 }, { 84,96,132,47,14 }, { 137,189,67,132,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1416)
		{ { 103,112,117,206,8 }, { 249,37,33,217,7 }, { 23,58,224,238,6 }, { 233,184,74,73,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1417)
		{ { 167,70,60,209,12 }, { 128,5,237,127,6 }, { 56,179,198,46,5 }, { 111,235,122,0,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1418)
		{ { 153,117,131,110,2 }, { 91,254,2,106,1 }, { 71,108,26,233,9 }, { 133,100,7,253,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1419)
		{ { 81,145,211,21,9 }, { 124,202,145,212,0 }, { 154,140,184,152,10 }, { 2,184,149,51,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1420)
		{ { 53,76,2,185,8 }, { 128,108,163,100,10 }, { 25,212,3,42,12 }, { 82,108,83,96,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1421)
		{ { 208,27,128,57,5 }, { 68,170,202,134,8 }, { 169,192,29,128,11 }, { 22,21,53,82,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1422)
		{ { 123,39,171,229,3 }, { 31,218,46,237,6 }, { 202,125,94,77,14 }, { 107,119,69,191,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1423)
		{ { 168,140,171,169,4 }, { 18,224,118,38,14 }, { 41,93,83,17,5 }, { 118,70,224,116,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1424)
		{ { 138,112,46,100,13 }, { 79,69,71,11,4 }, { 178,103,64,229,1 }, { 45,14,42,47,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1425)
		{ { 17,144,216,79,13 }, { 108,168,85,92,1 }, { 191,33,176,152,8 }, { 131,170,161,83,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1426)
		{ { 168,56,156,230,8 }, { 75,129,39,26,11 }, { 22,115,145,193,5 }, { 213,142,72,29,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1427)
		{ { 99,172,245,8,11 }, { 53,177,49,241,12 }, { 209,10,243,92,6 }, { 56,248,200,218,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1428)
		{ { 153,224,174,41,11 }, { 7,253,23,70,4 }, { 217,71,80,121,9 }, { 38,46,139,254,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1429)
		{ { 232,139,97,157,3 }, { 62,50,184,134,14 }, { 203,152,109,17,7 }, { 118,17,212,199,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1430)
		{ { 17,175,187,184,0 }, { 17,234,158,112,14 }, { 1,221,223,88,8 }, { 112,231,149,120,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1431)
		{ { 98,250,27,120,14 }, { 81,116,255,153,8 }, { 113,237,133,244,6 }, { 25,159,242,232,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1432)
		{ { 241,171,236,42,5 }, { 37,171,126,194,13 }, { 165,67,125,88,15 }, { 180,55,237,90,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1433)
		{ { 164,120,185,64,2 }, { 209,148,36,26,12 }, { 64,41,209,226,5 }, { 53,130,66,152,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1434)
		{ { 78,147,112,26,3 }, { 230,50,152,145,5 }, { 197,128,236,151,2 }, { 168,145,148,198,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1435)
		{ { 93,31,190,33,6 }, { 194,219,78,244,12 }, { 104,71,223,139,10 }, { 50,247,45,180,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1436)
		{ { 222,153,178,148,7 }, { 206,218,208,147,14 }, { 226,148,217,151,11 }, { 124,144,181,183,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1437)
		{ { 119,8,209,116,7 }, { 188,152,226,217,8 }, { 226,232,177,14,14 }, { 25,180,113,147,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1438)
		{ { 187,192,140,154,8 }, { 2,173,181,67,3 }, { 21,147,16,61,13 }, { 204,42,219,84,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1439)
		{ { 234,28,8,68,4 }, { 74,0,100,171,8 }, { 34,33,3,133,7 }, { 29,82,96,5,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1440)
		{ { 184,154,172,7,8 }, { 74,137,61,6,13 }, { 30,3,85,145,13 }, { 182,11,201,21,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1441)
		{ { 151,79,121,58,13 }, { 180,46,207,115,13 }, { 181,201,239,46,9 }, { 188,239,55,66,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1442)
		{ { 124,55,168,31,9 }, { 207,170,173,164,5 }, { 159,129,94,195,14 }, { 162,91,85,95,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1443)
		{ { 132,5,69,184,11 }, { 180,51,131,34,2 }, { 209,218,42,2,1 }, { 68,76,28,194,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1444)
		{ { 137,136,232,242,10 }, { 34,144,151,74,15 }, { 84,241,113,25,1 }, { 245,46,144,148,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1445)
		{ { 122,5,47,138,7 }, { 22,123,100,161,7 }, { 229,31,74,5,14 }, { 232,82,109,230,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1446)
		{ { 192,107,231,168,3 }, { 53,247,10,130,14 }, { 193,94,125,96,3 }, { 116,21,14,250,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1447)
		{ { 225,214,143,229,13 }, { 92,197,127,238,2 }, { 186,127,22,184,7 }, { 71,127,234,51,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1448)
		{ { 135,193,94,208,1 }, { 164,71,148,91,2 }, { 128,183,168,62,1 }, { 77,162,158,34,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1449)
		{ { 177,141,71,4,14 }, { 56,91,113,98,8 }, { 114,14,43,24,13 }, { 20,104,237,161,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1450)
		{ { 185,96,48,55,10 }, { 11,28,163,86,5 }, { 94,192,192,105,13 }, { 166,172,83,141,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1451)
		{ { 57,22,249,242,5 }, { 118,136,238,120,7 }, { 164,249,246,137,12 }, { 225,231,113,22,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1452)
		{ { 91,245,56,225,10 }, { 67,30,23,253,6 }, { 88,113,202,253,10 }, { 107,254,135,140,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1453)
		{ { 69,2,140,137,3 }, { 132,177,12,196,2 }, { 201,19,20,10,2 }, { 66,51,8,210,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1454)
		{ { 139,247,79,21,14 }, { 123,87,221,103,0 }, { 122,143,46,253,1 }, { 14,107,190,173,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1455)
		{ { 52,169,38,14,14 }, { 137,123,113,0,13 }, { 119,6,73,82,12 }, { 176,8,237,233,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1456)
		{ { 254,161,180,87,2 }, { 139,155,176,159,5 }, { 78,162,216,87,15 }, { 175,144,221,157,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1457)
		{ { 170,172,74,33,2 }, { 35,80,54,39,8 }, { 72,69,35,85,5 }, { 30,70,192,172,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1458)
		{ { 199,149,142,146,10 }, { 192,211,149,227,3 }, { 84,151,26,158,3 }, { 204,122,156,176,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1459)
		{ { 77,114,150,13,7 }, { 207,245,72,212,0 }, { 235,6,148,235,2 }, { 2,177,42,255,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1460)
		{ { 198,113,60,138,13 }, { 197,39,69,147,7 }, { 181,19,200,230,3 }, { 236,154,46,74,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1461)
		{ { 26,219,8,147,10 }, { 66,30,157,5,11 }, { 92,145,13,181,8 }, { 218,11,151,132,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1462)
		{ { 235,178,94,21,3 }, { 111,81,188,215,0 }, { 202,135,164,221,7 }, { 14,179,216,175,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1463)
		{ { 26,140,101,49,13 }, { 54,9,211,37,12 }, { 184,202,99,21,8 }, { 58,76,185,6,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1464)
		{ { 184,194,144,210,13 }, { 6,140,249,26,3 }, { 180,176,148,49,13 }, { 197,137,243,22,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1465)
		{ { 237,10,185,59,12 }, { 146,160,239,214,13 }, { 61,201,213,11,7 }, { 182,191,112,84,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1466)
		{ { 53,64,254,171,14 }, { 160,253,103,84,7 }, { 125,87,240,42,12 }, { 226,174,107,240,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1467)
		{ { 77,141,169,163,10 }, { 146,146,23,228,15 }, { 92,89,91,27,2 }, { 242,126,132,148,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1468)
		{ { 25,111,83,7,9 }, { 63,78,9,116,9 }, { 158,12,175,105,8 }, { 146,233,7,47,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1469)
		{ { 170,161,45,108,8 }, { 27,35,55,11,4 }, { 19,107,72,85,5 }, { 45,14,204,77,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1470)
		{ { 212,51,219,225,6 }, { 241,218,78,158,2 }, { 104,125,188,194,11 }, { 71,151,37,184,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1471)
		{ { 41,68,117,210,10 }, { 50,21,161,120,7 }, { 84,186,226,41,4 }, { 225,232,90,132,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1472)
		{ { 222,189,217,145,6 }, { 243,154,212,183,10 }, { 104,153,187,215,11 }, { 94,210,181,156,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1473)
		{ { 123,98,241,8,1 }, { 55,172,40,209,4 }, { 129,8,244,109,14 }, { 40,177,67,94,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1474)
		{ { 16,243,23,219,8 }, { 81,111,153,28,3 }, { 29,190,140,240,8 }, { 195,137,159,104,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1475)
		{ { 184,117,135,64,5 }, { 87,207,96,42,0 }, { 160,46,26,225,13 }, { 5,64,111,62,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1476)
		{ { 154,182,79,175,0 }, { 123,105,30,39,3 }, { 15,95,38,213,9 }, { 206,71,137,109,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1477)
		{ { 212,4,243,160,1 }, { 180,200,2,178,6 }, { 128,92,242,2,11 }, { 100,212,1,50,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1478)
		{ { 225,106,123,127,5 }, { 61,100,238,222,13 }, { 175,237,229,104,7 }, { 183,183,114,107,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1479)
		{ { 12,218,188,26,8 }, { 194,165,157,16,13 }, { 21,131,213,179,0 }, { 176,139,154,84,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1480)
		{ { 4,96,183,149,11 }, { 157,213,129,20,6 }, { 218,158,208,98,0 }, { 98,136,26,187,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1481)
		{ { 28,206,196,143,3 }, { 174,189,24,36,11 }, { 207,18,55,51,8 }, { 210,65,139,215,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1482)
		{ { 35,222,229,165,12 }, { 120,133,123,101,14 }, { 58,90,119,188,4 }, { 122,109,234,17,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1483)
		{ { 99,5,255,232,5 }, { 52,227,102,249,6 }, { 161,127,250,12,6 }, { 105,246,108,114,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1484)
		{ { 225,195,39,185,4 }, { 16,103,250,198,6 }, { 41,222,76,56,7 }, { 102,53,254,96,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1485)
		{ { 140,43,164,30,0 }, { 139,163,136,2,13 }, { 7,130,93,67,1 }, { 180,1,28,93,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1486)
		{ { 28,217,222,180,0 }, { 234,207,150,16,10 }, { 2,215,185,179,8 }, { 80,134,159,53,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1487)
		{ { 85,100,240,183,1 }, { 173,140,130,244,7 }, { 142,208,242,106,10 }, { 226,244,19,27,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1488)
		{ { 176,199,42,118,10 }, { 8,94,191,42,5 }, { 86,229,78,48,13 }, { 165,79,215,161,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1489)
		{ { 231,13,80,70,9 }, { 172,2,33,251,9 }, { 150,32,171,14,7 }, { 157,248,68,3,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1490)
		{ { 50,149,124,126,3 }, { 108,59,182,57,5 }, { 199,227,234,148,12 }, { 169,198,221,195,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1491)
		{ { 71,130,81,20,11 }, { 188,16,153,209,0 }, { 210,136,164,30,2 }, { 8,185,144,131,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1492)
		{ { 120,242,17,22,15 }, { 95,28,249,144,1 }, { 246,136,132,241,14 }, { 128,153,243,143,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1493)
		{ { 144,251,64,119,10 }, { 105,30,155,14,9 }, { 94,224,45,240,9 }, { 151,13,151,137,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1494)
		{ { 162,111,219,64,3 }, { 53,214,44,59,8 }, { 192,45,191,100,5 }, { 29,195,70,186,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1495)
		{ { 36,36,50,53,7 }, { 141,80,226,52,4 }, { 234,196,194,66,4 }, { 34,196,112,171,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1496)
		{ { 135,138,180,213,3 }, { 140,145,152,95,14 }, { 202,178,213,30,1 }, { 127,161,152,147,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1497)
		{ { 238,169,194,236,0 }, { 171,226,50,139,10 }, { 3,116,57,87,7 }, { 93,20,196,125,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1498)
		{ { 194,91,81,134,10 }, { 120,22,9,147,11 }, { 86,24,173,164,3 }, { 220,153,6,129,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1499)
		{ { 154,26,220,22,4 }, { 106,137,204,19,9 }, { 38,131,181,133,9 }, { 156,131,57,21,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1500)
		{ { 115,131,224,101,1 }, { 44,138,58,205,4 }, { 138,96,124,28,14 }, { 43,53,197,19,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1501)
		{ { 25,137,191,169,14 }, { 18,251,87,84,14 }, { 121,95,217,25,8 }, { 114,174,173,244,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1502)
		{ { 29,136,219,124,13 }, { 190,232,215,88,8 }, { 179,237,177,27,8 }, { 17,174,177,119,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1503)
		{ { 58,57,201,98,1 }, { 119,138,38,9,9 }, { 132,105,57,197,12 }, { 153,6,69,30,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1504)
		{ { 196,95,111,141,1 }, { 252,103,12,166,14 }, { 139,31,111,162,3 }, { 118,83,14,99,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1505)
		{ { 127,212,244,88,13 }, { 230,173,241,249,4 }, { 177,162,242,191,14 }, { 41,248,251,86,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1506)
		{ { 235,94,5,198,13 }, { 94,5,105,235,11 }, { 182,58,7,173,7 }, { 221,121,106,7,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1507)
		{ { 0,222,87,31,10 }, { 120,117,153,52,9 }, { 95,142,167,176,0 }, { 146,201,154,225,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1508)
		{ { 48,182,57,119,2 }, { 89,24,190,60,5 }, { 78,233,198,208,12 }, { 163,199,209,137,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1509)
		{ { 217,17,79,9,9 }, { 118,107,5,198,0 }, { 153,15,40,137,11 }, { 6,58,13,102,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1510)
		{ { 11,138,78,254,13 }, { 46,97,223,73,11 }, { 183,247,37,29,0 }, { 217,47,184,103,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1511)
		{ { 150,200,148,195,5 }, { 132,141,80,31,11 }, { 172,50,145,54,9 }, { 223,128,171,18,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1512)
		{ { 222,86,207,27,9 }, { 246,237,141,167,1 }, { 157,143,54,167,11 }, { 142,91,27,118,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1513)
		{ { 233,20,44,234,11 }, { 70,49,39,234,7 }, { 213,115,66,137,7 }, { 229,126,72,198,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1514)
		{ { 166,193,149,63,7 }, { 156,183,242,23,1 }, { 239,202,152,54,5 }, { 142,132,254,211,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1515)
		{ { 112,249,99,53,11 }, { 125,94,179,132,12 }, { 218,204,105,240,14 }, { 50,28,215,171,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1516)
		{ { 60,210,112,229,12 }, { 234,12,123,28,6 }, { 58,112,228,179,12 }, { 99,141,227,5,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1517)
		{ { 67,44,58,151,8 }, { 9,64,133,245,15 }, { 30,149,195,76,2 }, { 250,250,16,41,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1518)
		{ { 96,54,213,83,2 }, { 113,145,168,188,1 }, { 76,170,182,192,6 }, { 131,209,88,152,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1519)
		{ { 135,118,248,196,14 }, { 233,148,77,123,6 }, { 114,49,246,238,1 }, { 109,235,34,153,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1520)
		{ { 32,85,144,158,12 }, { 72,166,225,48,3 }, { 55,144,154,160,4 }, { 192,200,118,81,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1521)
		{ { 51,149,147,18,0 }, { 80,202,176,113,1 }, { 4,140,154,156,12 }, { 136,224,213,48,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1522)
		{ { 61,129,11,57,10 }, { 146,122,183,68,0 }, { 89,205,8,27,12 }, { 2,46,213,228,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1523)
		{ { 39,67,30,187,2 }, { 128,119,174,85,3 }, { 77,215,140,46,4 }, { 202,167,94,224,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1524)
		{ { 240,133,185,233,2 }, { 16,186,54,190,6 }, { 73,121,218,16,15 }, { 103,214,197,208,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1525)
		{ { 163,11,146,226,0 }, { 0,194,42,91,11 }, { 4,116,157,12,5 }, { 221,165,68,48,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1526)
		{ { 220,20,37,232,5 }, { 214,41,66,170,6 }, { 161,122,66,131,11 }, { 101,84,41,70,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1527)
		{ { 180,171,135,231,11 }, { 157,219,59,14,11 }, { 222,126,29,82,13 }, { 215,13,205,187,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1528)
		{ { 143,183,62,39,0 }, { 203,67,30,119,5 }, { 14,71,206,223,1 }, { 174,231,140,45,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1529)
		{ { 255,211,18,95,2 }, { 202,126,184,223,1 }, { 79,164,140,191,15 }, { 143,177,215,229,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1530)
		{ { 5,76,149,162,10 }, { 144,149,3,112,11 }, { 84,90,147,42,0 }, { 208,236,10,144,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1531)
		{ { 29,121,189,67,6 }, { 211,159,68,92,13 }, { 108,43,217,235,8 }, { 179,162,47,156,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1532)
		{ { 49,220,189,155,11 }, { 84,189,181,116,15 }, { 221,155,211,184,12 }, { 242,234,219,210,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1533)
		{ { 93,131,76,204,2 }, { 170,59,28,200,2 }, { 67,51,44,27,10 }, { 65,51,141,197,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1534)
		{ { 184,110,95,128,10 }, { 51,93,45,50,10 }, { 80,31,167,97,13 }, { 84,203,75,172,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1535)
		{ { 221,181,2,55,14 }, { 203,90,211,230,1 }, { 126,196,10,219,11 }, { 134,124,181,173,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1536)
		{ { 204,212,249,32,2 }, { 242,148,22,178,4 }, { 64,73,242,179,3 }, { 36,214,130,148,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1537)
		{ { 222,175,20,123,3 }, { 135,59,154,191,9 }, { 205,226,143,87,11 }, { 159,213,157,206,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1538)
		{ { 157,32,19,22,15 }, { 159,88,193,82,1 }, { 246,140,128,75,9 }, { 132,168,49,175,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1539)
		{ { 124,189,240,175,1 }, { 239,170,50,180,15 }, { 143,80,251,211,14 }, { 242,212,197,95,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1540)
		{ { 34,195,216,114,10 }, { 32,150,191,25,1 }, { 84,225,188,52,4 }, { 137,143,214,144,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1541)
		{ { 69,199,100,214,12 }, { 168,7,217,232,7 }, { 54,178,110,58,2 }, { 225,121,190,1,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1542)
		{ { 141,147,90,116,0 }, { 234,66,158,90,0 }, { 2,229,172,155,1 }, { 5,167,148,37,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1543)
		{ { 177,161,236,16,8 }, { 33,139,181,66,4 }, { 16,131,120,88,13 }, { 36,42,221,24,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1544)
		{ { 208,121,53,51,6 }, { 81,31,194,150,13 }, { 108,202,201,224,11 }, { 182,148,63,136,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1545)
		{ { 74,81,93,164,6 }, { 122,23,70,145,2 }, { 98,91,168,165,2 }, { 72,150,46,133,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1546)
		{ { 58,45,19,35,5 }, { 23,74,98,53,9 }, { 172,76,139,69,12 }, { 154,196,101,46,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1547)
		{ { 236,65,230,22,1 }, { 174,199,160,130,5 }, { 134,134,120,35,7 }, { 164,16,94,55,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1548)
		{ { 127,172,78,24,2 }, { 163,121,180,225,8 }, { 65,135,35,95,14 }, { 24,114,217,236,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1549)
		{ { 115,198,100,107,13 }, { 36,45,123,237,5 }, { 189,98,102,60,14 }, { 171,125,235,66,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1550)
		{ { 77,251,76,21,7 }, { 239,23,220,196,8 }, { 234,131,45,251,2 }, { 18,51,190,143,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1551)
		{ { 229,15,78,90,11 }, { 164,115,173,234,9 }, { 213,167,47,10,7 }, { 149,123,92,226,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1552)
		{ { 122,161,57,166,0 }, { 27,10,54,145,7 }, { 6,89,200,85,14 }, { 232,150,197,13,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1553)
		{ { 18,122,254,87,13 }, { 109,205,205,29,13 }, { 190,167,245,228,8 }, { 187,139,59,59,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1554)
		{ { 168,230,106,159,15 }, { 47,116,253,38,7 }, { 255,149,102,113,5 }, { 230,75,242,239,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1555)
		{ { 89,155,96,189,8 }, { 106,42,155,196,14 }, { 27,208,109,153,10 }, { 114,61,149,69,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1556)
		{ { 49,234,54,102,9 }, { 13,77,59,88,13 }, { 150,102,197,120,12 }, { 177,173,203,43,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1557)
		{ { 55,203,228,166,3 }, { 172,159,58,65,15 }, { 198,82,125,62,12 }, { 248,37,207,147,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1558)
		{ { 134,60,248,42,13 }, { 229,160,71,51,13 }, { 181,65,243,198,1 }, { 188,206,32,90,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1559)
		{ { 14,181,149,30,6 }, { 219,179,208,49,1 }, { 103,138,154,215,0 }, { 136,192,188,221,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1560)
		{ { 197,251,85,118,12 }, { 249,7,219,218,9 }, { 54,234,173,250,3 }, { 149,189,190,9,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1561)
		{ { 123,128,210,239,5 }, { 46,232,114,221,3 }, { 175,116,176,29,14 }, { 203,180,225,119,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1562)
		{ { 195,179,195,50,10 }, { 113,210,155,195,1 }, { 84,204,60,220,3 }, { 140,61,148,184,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1563)
		{ { 103,62,26,116,11 }, { 205,80,175,249,8 }, { 210,229,135,206,6 }, { 25,255,80,171,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1564)
		{ { 146,201,210,150,1 }, { 44,206,144,19,11 }, { 134,148,185,52,9 }, { 220,128,151,51,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1565)
		{ { 127,25,25,12,11 }, { 222,58,37,209,8 }, { 211,9,137,143,14 }, { 24,186,69,199,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1566)
		{ { 144,112,164,195,10 }, { 65,157,1,14,7 }, { 92,50,80,224,9 }, { 231,8,11,152,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1567)
		{ { 113,67,83,178,1 }, { 52,78,170,208,3 }, { 132,220,172,40,14 }, { 192,181,87,34,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1568)
		{ { 251,75,181,78,15 }, { 30,191,105,219,13 }, { 247,42,221,45,15 }, { 189,185,111,215,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1569)
		{ { 197,129,104,9,8 }, { 160,34,21,198,4 }, { 25,1,104,26,3 }, { 38,58,132,64,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1570)
		{ { 43,241,86,121,0 }, { 99,103,178,93,0 }, { 9,230,168,253,4 }, { 11,164,222,108,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1571)
		{ { 139,50,134,244,8 }, { 75,193,139,75,2 }, { 18,246,20,205,1 }, { 77,45,24,61,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1572)
		{ { 35,88,1,235,6 }, { 80,52,98,77,11 }, { 109,120,1,172,4 }, { 219,36,98,192,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1573)
		{ { 42,83,143,50,8 }, { 82,199,175,1,1 }, { 20,207,28,165,4 }, { 136,15,94,52,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1574)
		{ { 16,109,126,84,8 }, { 41,79,133,56,12 }, { 18,167,235,96,8 }, { 49,202,31,41,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1575)
		{ { 70,253,197,231,10 }, { 249,151,19,173,11 }, { 94,122,59,246,2 }, { 219,92,142,153,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1576)
		{ { 69,106,10,93,0 }, { 137,100,140,204,8 }, { 11,165,5,106,2 }, { 19,51,18,105,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1577)
		{ { 217,50,39,125,10 }, { 91,121,139,206,4 }, { 91,238,68,201,11 }, { 39,61,25,237,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1578)
		{ { 97,59,235,152,1 }, { 117,226,172,192,14 }, { 129,157,125,200,6 }, { 112,51,84,122,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1579)
		{ { 191,19,181,70,0 }, { 218,139,40,91,5 }, { 6,42,220,143,13 }, { 173,161,77,21,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1580)
		{ { 130,186,168,203,13 }, { 69,160,93,15,15 }, { 189,49,85,212,1 }, { 255,11,160,90,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1581)
		{ { 81,205,99,27,3 }, { 52,126,144,228,13 }, { 205,140,107,56,10 }, { 178,112,151,226,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1582)
		{ { 112,171,240,76,7 }, { 45,186,120,152,12 }, { 227,32,253,80,14 }, { 49,145,229,219,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1583)
		{ { 170,102,185,24,7 }, { 23,180,236,51,4 }, { 225,137,214,101,5 }, { 44,195,114,222,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1584)
		{ { 140,20,60,97,6 }, { 194,17,70,62,4 }, { 104,99,194,131,1 }, { 39,198,40,132,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1585)
		{ { 241,160,157,75,0 }, { 17,169,52,222,1 }, { 13,43,144,88,15 }, { 135,178,201,88,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1586)
		{ { 95,27,95,220,4 }, { 250,107,204,217,10 }, { 35,191,173,143,10 }, { 89,179,61,101,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1587)
		{ { 104,72,189,153,8 }, { 18,165,165,148,14 }, { 25,155,209,33,6 }, { 114,154,90,84,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1588)
		{ { 235,245,28,134,10 }, { 75,23,53,243,3 }, { 86,19,138,253,7 }, { 204,250,206,141,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1589)
		{ { 201,92,23,53,15 }, { 94,85,195,246,8 }, { 250,206,131,169,3 }, { 22,252,58,167,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1590)
		{ { 164,229,178,170,9 }, { 133,230,51,50,7 }, { 149,84,218,114,5 }, { 228,204,198,122,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1591)
		{ { 137,187,40,109,9 }, { 79,34,31,78,12 }, { 155,97,77,217,1 }, { 55,47,132,79,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1592)
		{ { 252,83,211,81,9 }, { 246,206,169,158,0 }, { 152,172,188,163,15 }, { 7,153,87,54,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1593)
		{ { 132,250,176,250,11 }, { 197,180,155,26,15 }, { 213,240,213,242,1 }, { 245,141,146,218,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1594)
		{ { 135,156,9,173,7 }, { 220,48,86,103,10 }, { 235,89,3,158,1 }, { 94,102,160,195,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1595)
		{ { 84,19,120,184,10 }, { 224,58,143,144,6 }, { 81,209,236,130,10 }, { 96,159,21,192,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1596)
		{ { 93,207,118,108,5 }, { 174,111,90,248,12 }, { 163,102,239,59,10 }, { 49,245,175,103,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1597)
		{ { 15,128,112,181,8 }, { 170,0,147,85,6 }, { 26,208,224,31,0 }, { 106,172,144,5,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1598)
		{ { 208,181,28,15,14 }, { 73,59,85,182,1 }, { 127,3,138,208,11 }, { 134,218,173,201,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1599)
		{ { 132,202,160,119,12 }, { 136,132,219,14,13 }, { 62,224,85,50,1 }, { 183,13,178,17,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1600)
		{ { 237,211,180,253,12 }, { 202,167,251,222,6 }, { 59,242,220,187,7 }, { 103,189,254,85,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1601)
		{ { 54,161,151,8,4 }, { 145,235,112,17,0 }, { 33,14,152,86,12 }, { 8,128,237,120,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1602)
		{ { 140,65,87,242,7 }, { 182,87,194,26,3 }, { 228,254,168,35,1 }, { 197,132,62,166,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1603)
		{ { 236,146,34,145,13 }, { 198,64,249,134,6 }, { 184,148,68,147,7 }, { 102,25,240,38,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1604)
		{ { 44,51,74,17,10 }, { 227,82,173,4,0 }, { 88,133,44,195,4 }, { 2,11,84,172,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1605)
		{ { 149,119,148,119,8 }, { 201,143,139,126,1 }, { 30,226,158,234,9 }, { 135,237,31,25,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1606)
		{ { 79,158,57,137,13 }, { 214,32,93,245,14 }, { 185,25,199,159,2 }, { 122,251,160,70,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1607)
		{ { 181,203,34,59,11 }, { 132,126,187,70,13 }, { 221,196,77,58,13 }, { 182,45,215,226,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1608)
		{ { 238,226,189,59,11 }, { 151,181,191,151,5 }, { 221,203,212,119,7 }, { 174,159,218,222,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1609)
		{ { 133,212,25,195,12 }, { 208,4,85,126,3 }, { 60,57,130,186,1 }, { 199,234,162,0,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1610)
		{ { 186,35,215,19,11 }, { 55,219,169,23,1 }, { 220,142,188,69,13 }, { 142,137,93,190,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1611)
		{ { 141,72,238,157,1 }, { 174,229,132,70,14 }, { 139,151,113,43,1 }, { 118,34,26,119,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1612)
		{ { 120,69,116,14,9 }, { 46,47,33,176,5 }, { 151,2,234,33,14 }, { 160,216,79,71,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1613)
		{ { 100,231,234,47,8 }, { 169,230,63,164,5 }, { 31,69,126,114,6 }, { 162,95,198,121,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1614)
		{ { 100,118,246,62,4 }, { 233,229,234,176,5 }, { 39,198,246,226,6 }, { 160,213,122,121,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1615)
		{ { 14,238,158,149,0 }, { 139,197,156,53,10 }, { 10,151,151,119,0 }, { 90,195,154,61,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1616)
		{ { 220,175,168,110,11 }, { 143,186,31,170,13 }, { 215,97,95,83,11 }, { 181,95,133,223,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1617)
		{ { 135,109,56,242,14 }, { 129,22,199,123,15 }, { 116,241,203,110,1 }, { 253,238,54,136,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1618)
		{ { 59,235,39,76,5 }, { 31,111,120,73,12 }, { 163,46,77,125,12 }, { 57,33,239,111,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1619)
		{ { 184,191,89,23,4 }, { 123,10,252,54,9 }, { 46,137,175,209,13 }, { 150,195,245,13,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1620)
		{ { 171,32,236,13,0 }, { 43,161,36,71,4 }, { 11,3,112,77,5 }, { 46,34,72,93,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1621)
		{ { 13,85,26,83,3 }, { 198,86,132,124,1 }, { 204,165,138,171,0 }, { 131,226,22,166,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1622)
		{ { 164,73,46,167,8 }, { 136,71,39,6,15 }, { 30,87,73,34,5 }, { 246,14,78,33,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1623)
		{ { 93,108,92,103,6 }, { 171,29,70,252,9 }, { 110,99,163,107,10 }, { 147,246,43,141,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1624)
		{ { 153,4,153,70,10 }, { 26,152,5,122,1 }, { 86,41,146,9,9 }, { 133,234,1,149,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1625)
		{ { 10,157,128,226,6 }, { 66,146,82,41,11 }, { 100,112,27,149,0 }, { 217,68,164,148,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1626)
		{ { 105,134,183,41,15 }, { 22,241,123,244,4 }, { 249,78,214,25,6 }, { 34,253,232,246,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1627)
		{ { 143,173,130,44,13 }, { 143,226,83,99,8 }, { 179,68,27,95,1 }, { 28,108,164,127,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1628)
		{ { 226,67,95,38,3 }, { 60,87,46,147,1 }, { 198,79,172,36,7 }, { 140,151,78,163,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1629)
		{ { 209,155,215,78,11 }, { 124,251,25,218,9 }, { 215,46,189,152,11 }, { 149,185,141,243,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1630)
		{ { 196,218,25,133,15 }, { 220,20,93,150,10 }, { 250,25,133,178,3 }, { 86,155,162,131,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1631)
		{ { 26,193,30,251,4 }, { 2,111,214,29,3 }, { 45,247,136,53,8 }, { 203,134,191,100,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1632)
		{ { 17,45,28,17,1 }, { 5,11,132,116,8 }, { 136,131,139,72,8 }, { 18,226,29,10,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1633)
		{ { 45,76,8,144,6 }, { 130,20,228,96,10 }, { 96,145,3,43,4 }, { 80,98,114,132,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1634)
		{ { 108,235,79,250,4 }, { 179,103,254,136,11 }, { 37,255,45,115,6 }, { 209,23,254,108,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1635)
		{ { 171,203,198,115,11 }, { 38,215,187,79,9 }, { 220,230,61,61,5 }, { 159,45,222,182,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1636)
		{ { 40,32,233,173,13 }, { 63,160,103,4,6 }, { 187,89,112,65,4 }, { 98,14,96,95,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1637)
		{ { 127,250,209,178,2 }, { 243,156,186,209,11 }, { 68,216,181,255,14 }, { 216,181,211,156,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1638)
		{ { 27,102,106,88,7 }, { 39,124,204,105,4 }, { 225,165,102,109,8 }, { 41,99,51,238,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1639)
		{ { 164,137,72,44,7 }, { 172,50,118,2,8 }, { 227,65,41,18,5 }, { 20,6,228,195,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1640)
		{ { 141,42,28,71,0 }, { 139,1,12,94,9 }, { 14,35,133,75,1 }, { 151,163,8,13,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1641)
		{ { 125,182,84,216,0 }, { 227,41,184,248,2 }, { 1,178,166,219,14 }, { 65,241,217,76,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1642)
		{ { 179,222,10,136,11 }, { 68,124,61,99,10 }, { 209,21,7,188,13 }, { 92,107,195,226,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1643)
		{ { 214,120,202,34,1 }, { 229,204,6,131,9 }, { 132,69,49,230,11 }, { 156,22,3,58,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1644)
		{ { 136,97,82,97,11 }, { 39,86,3,30,0 }, { 216,100,168,97,1 }, { 7,140,6,174,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1645)
		{ { 0,238,90,84,7 }, { 45,84,220,56,8 }, { 226,165,167,112,0 }, { 17,195,178,171,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1646)
		{ { 84,105,30,139,4 }, { 129,111,68,148,11 }, { 45,23,137,98,10 }, { 210,146,47,104,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1647)
		{ { 128,254,13,106,8 }, { 81,37,31,42,9 }, { 21,107,7,240,1 }, { 149,79,138,72,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1648)
		{ { 195,127,154,209,2 }, { 65,214,140,255,10 }, { 72,181,159,236,3 }, { 95,243,22,184,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1649)
		{ { 57,235,155,203,12 }, { 19,238,125,92,11 }, { 61,61,157,121,12 }, { 211,171,231,124,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1650)
		{ { 156,205,246,33,8 }, { 162,207,19,54,12 }, { 24,70,251,51,9 }, { 54,204,143,52,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1651)
		{ { 83,192,184,251,11 }, { 4,188,151,221,7 }, { 221,241,208,60,10 }, { 235,190,147,210,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1652)
		{ { 159,93,81,153,0 }, { 242,46,128,119,10 }, { 9,152,171,175,9 }, { 94,224,23,68,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1653)
		{ { 208,152,110,185,3 }, { 100,121,150,134,14 }, { 201,215,97,144,11 }, { 118,22,153,226,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1654)
		{ { 21,133,42,206,6 }, { 136,122,84,104,7 }, { 103,53,74,26,8 }, { 225,98,165,225,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1655)
		{ { 144,212,121,19,3 }, { 116,28,148,54,5 }, { 204,137,226,176,9 }, { 166,194,147,130,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1656)
		{ { 44,22,172,202,12 }, { 194,161,109,40,7 }, { 53,51,86,131,4 }, { 225,75,104,84,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1657)
		{ { 112,226,233,181,14 }, { 57,156,255,132,6 }, { 122,217,116,112,14 }, { 98,31,243,153,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1658)
		{ { 36,160,106,178,15 }, { 165,80,247,0,7 }, { 244,213,96,82,4 }, { 224,14,240,170,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1659)
		{ { 114,1,237,44,10 }, { 56,187,39,129,4 }, { 83,75,120,4,14 }, { 40,30,77,209,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1660)
		{ { 76,99,9,66,8 }, { 147,6,13,136,1 }, { 20,41,12,99,2 }, { 129,27,6,12,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1661)
		{ { 6,185,203,230,13 }, { 253,194,87,9,11 }, { 182,125,57,214,0 }, { 217,14,164,59,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1662)
		{ { 215,246,104,218,12 }, { 225,44,221,235,7 }, { 53,177,102,254,11 }, { 237,123,179,72,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1663)
		{ { 129,109,246,113,1 }, { 37,199,130,126,12 }, { 136,230,251,104,1 }, { 55,228,30,58,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1664)
		{ { 88,117,65,240,5 }, { 119,14,194,168,2 }, { 160,248,42,225,10 }, { 65,84,55,14,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1665)
		{ { 74,115,6,33,0 }, { 67,71,10,133,0 }, { 8,70,12,229,2 }, { 10,21,14,44,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1666)
		{ { 72,9,86,13,1 }, { 46,99,0,148,8 }, { 139,6,169,1,2 }, { 18,144,12,103,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1667)
		{ { 59,153,72,245,11 }, { 110,26,183,77,10 }, { 218,241,41,157,12 }, { 91,46,213,135,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1668)
		{ { 54,150,213,148,6 }, { 248,153,248,49,2 }, { 98,154,182,150,12 }, { 72,193,249,145,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1669)
		{ { 81,34,220,136,12 }, { 33,169,77,208,2 }, { 49,19,180,72,10 }, { 64,187,41,88,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1670)
		{ { 168,69,58,219,0 }, { 2,102,164,62,7 }, { 13,181,202,33,5 }, { 231,194,86,100,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1671)
		{ { 180,120,208,7,12 }, { 233,140,97,22,9 }, { 62,0,177,226,13 }, { 150,136,99,25,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1672)
		{ { 213,175,225,90,1 }, { 181,170,152,234,13 }, { 133,168,127,90,11 }, { 181,113,149,90,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1673)
		{ { 4,255,169,156,13 }, { 221,166,221,32,14 }, { 179,153,95,242,0 }, { 112,75,182,91,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1674)
		{ { 178,170,134,106,1 }, { 5,233,58,11,9 }, { 133,102,21,84,13 }, { 157,5,201,122,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1675)
		{ { 33,202,57,14,7 }, { 28,52,124,80,13 }, { 231,9,197,56,4 }, { 176,163,226,195,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1676)
		{ { 217,149,56,136,0 }, { 66,42,20,242,6 }, { 1,17,202,153,11 }, { 100,242,133,68,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1677)
		{ { 158,66,134,121,2 }, { 130,253,138,15,0 }, { 73,230,20,39,9 }, { 15,5,27,244,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1678)
		{ { 35,126,230,40,15 }, { 101,245,107,97,12 }, { 241,70,119,236,4 }, { 56,109,106,250,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1679)
		{ { 223,217,194,111,1 }, { 238,238,18,207,9 }, { 143,100,57,191,11 }, { 159,52,135,119,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1680)
		{ { 134,37,95,146,14 }, { 177,83,197,51,3 }, { 116,159,170,70,1 }, { 204,202,60,168,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1681)
		{ { 89,24,159,35,8 }, { 82,201,7,212,9 }, { 28,79,145,137,10 }, { 146,190,9,52,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1682)
		{ { 83,168,9,113,7 }, { 21,24,214,205,8 }, { 232,233,1,92,10 }, { 27,54,177,138,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1683)
		{ { 8,171,22,118,15 }, { 15,83,219,24,9 }, { 246,230,141,81,0 }, { 145,141,188,175,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1684)
		{ { 249,140,152,28,13 }, { 14,168,245,242,8 }, { 179,129,147,25,15 }, { 20,250,241,87,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1685)
		{ { 249,136,239,149,11 }, { 62,217,181,198,14 }, { 218,159,113,25,15 }, { 118,58,217,183,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1686)
		{ { 31,2,254,30,14 }, { 170,249,205,81,5 }, { 119,135,244,15,8 }, { 168,171,57,245,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1687)
		{ { 104,234,254,163,13 }, { 39,197,127,148,15 }, { 188,87,245,113,6 }, { 242,159,234,62,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1688)
		{ { 126,145,79,240,6 }, { 242,91,246,137,2 }, { 96,255,40,151,14 }, { 73,22,253,164,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1689)
		{ { 44,149,20,92,13 }, { 206,35,241,56,0 }, { 179,162,138,147,4 }, { 1,200,252,71,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1690)
		{ { 62,147,44,208,8 }, { 194,11,189,9,6 }, { 16,179,76,151,12 }, { 105,11,221,4,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1691)
		{ { 183,92,175,40,3 }, { 212,253,38,99,12 }, { 193,79,83,174,13 }, { 60,102,75,242,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1692)
		{ { 186,245,114,60,11 }, { 111,126,179,51,4 }, { 211,196,234,245,13 }, { 44,204,215,239,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1693)
		{ { 121,203,18,140,13 }, { 14,110,121,208,10 }, { 179,20,141,57,14 }, { 80,185,231,103,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1694)
		{ { 64,87,46,30,0 }, { 72,103,140,160,5 }, { 7,135,78,160,2 }, { 160,83,30,97,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1695)
		{ { 82,212,150,97,15 }, { 68,221,83,189,0 }, { 248,102,146,180,10 }, { 11,220,171,178,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1696)
		{ { 177,112,92,13,10 }, { 105,61,37,86,0 }, { 91,3,160,232,13 }, { 6,170,75,201,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1697)
		{ { 99,49,219,103,3 }, { 125,210,38,221,1 }, { 206,109,184,204,6 }, { 139,182,68,187,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1698)
		{ { 16,154,188,196,1 }, { 76,137,28,24,14 }, { 130,51,213,144,8 }, { 113,131,137,19,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1699)
		{ { 96,60,124,104,15 }, { 101,49,103,184,12 }, { 241,99,227,192,6 }, { 49,222,104,202,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1700)
		{ { 115,50,161,255,11 }, { 93,184,171,205,7 }, { 223,248,84,204,14 }, { 235,61,81,219,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1701)
		{ { 61,143,96,230,4 }, { 170,10,122,104,15 }, { 38,112,111,27,12 }, { 241,101,229,5,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1702)
		{ { 202,97,172,50,9 }, { 7,135,135,131,5 }, { 148,195,88,101,3 }, { 172,30,30,30,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1703)
		{ { 132,25,50,28,14 }, { 200,114,193,18,12 }, { 115,132,201,130,1 }, { 52,136,52,225,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1704)
		{ { 171,167,29,138,7 }, { 23,51,124,115,3 }, { 229,27,142,93,5 }, { 204,227,236,206,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1705)
		{ { 220,105,76,91,7 }, { 167,63,196,142,9 }, { 237,163,41,99,11 }, { 151,18,63,206,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1706)
		{ { 244,156,252,224,5 }, { 228,137,118,186,14 }, { 160,115,243,146,15 }, { 117,214,233,18,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1707)
		{ { 200,69,243,60,3 }, { 62,246,130,178,4 }, { 195,204,250,33,3 }, { 36,212,22,247,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1708)
		{ { 104,74,251,82,12 }, { 50,196,237,152,13 }, { 52,173,245,33,6 }, { 177,155,114,52,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1709)
		{ { 214,20,91,29,3 }, { 252,120,132,183,0 }, { 203,141,162,134,11 }, { 14,210,17,227,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1710)
		{ { 16,253,223,173,12 }, { 121,239,87,52,10 }, { 59,95,187,240,8 }, { 82,206,175,121,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1711)
		{ { 31,139,72,20,8 }, { 170,10,157,65,8 }, { 18,129,45,31,8 }, { 24,43,149,5,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1712)
		{ { 156,50,163,233,3 }, { 215,248,10,14,6 }, { 201,124,84,195,9 }, { 103,5,1,254,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1713)
		{ { 157,108,124,56,7 }, { 167,61,198,114,12 }, { 225,195,227,107,9 }, { 52,230,59,206,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1714)
		{ { 183,3,177,221,5 }, { 156,170,232,95,6 }, { 171,184,220,14,13 }, { 111,161,117,83,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1715)
		{ { 111,221,59,152,0 }, { 210,102,180,241,14 }, { 1,157,203,191,6 }, { 120,242,214,100,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1716)
		{ { 178,62,176,218,4 }, { 65,168,232,59,15 }, { 37,176,215,196,13 }, { 253,193,113,88,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1717)
		{ { 115,173,103,162,0 }, { 49,75,50,225,15 }, { 4,94,107,92,14 }, { 248,116,205,40,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1718)
		{ { 83,97,3,190,8 }, { 25,110,131,193,3 }, { 23,220,8,108,10 }, { 200,60,23,105,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1719)
		{ { 214,122,66,252,3 }, { 237,124,138,139,10 }, { 195,244,37,230,11 }, { 93,21,19,235,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1720)
		{ { 31,40,119,191,6 }, { 187,121,194,85,15 }, { 111,222,225,79,8 }, { 250,164,57,237,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1721)
		{ { 45,103,170,137,12 }, { 131,230,109,100,6 }, { 57,21,94,107,4 }, { 98,107,102,124,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1722)
		{ { 168,55,137,133,0 }, { 91,130,44,38,2 }, { 10,25,30,193,5 }, { 70,67,68,29,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1723)
		{ { 47,235,63,25,12 }, { 147,103,253,85,12 }, { 57,143,205,127,4 }, { 58,171,254,108,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1724)
		{ { 41,160,212,118,5 }, { 47,129,242,88,1 }, { 166,226,176,89,4 }, { 129,164,248,31,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1725)
		{ { 65,177,230,167,15 }, { 109,211,83,196,7 }, { 254,86,120,216,2 }, { 226,60,172,187,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1726)
		{ { 248,93,126,140,7 }, { 110,127,100,178,14 }, { 227,23,235,161,15 }, { 116,210,111,231,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1727)
		{ { 133,48,143,35,4 }, { 209,193,70,70,1 }, { 44,79,16,202,1 }, { 134,38,40,56,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1728)
		{ { 121,131,156,71,5 }, { 14,139,124,220,1 }, { 174,35,156,25,14 }, { 131,179,237,23,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1729)
		{ { 75,124,102,113,8 }, { 99,69,131,237,12 }, { 24,230,99,237,2 }, { 59,124,26,44,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1730)
		{ { 231,237,2,5,2 }, { 137,86,48,231,8 }, { 74,4,11,126,7 }, { 30,112,198,169,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1731)
		{ { 57,33,5,61,13 }, { 31,43,227,68,0 }, { 187,202,8,73,12 }, { 2,44,125,79,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1732)
		{ { 46,92,218,7,3 }, { 238,212,36,53,9 }, { 206,5,179,167,4 }, { 154,194,66,183,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1733)
		{ { 191,65,151,115,14 }, { 146,223,227,95,1 }, { 124,238,152,47,13 }, { 143,172,127,180,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1734)
		{ { 229,242,167,113,14 }, { 209,213,251,206,4 }, { 120,238,84,250,7 }, { 39,61,250,184,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1735)
		{ { 189,13,222,45,14 }, { 170,251,103,118,8 }, { 123,71,187,11,13 }, { 22,238,109,245,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1736)
		{ { 104,73,143,23,14 }, { 26,215,229,132,9 }, { 126,143,25,33,6 }, { 146,26,126,181,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1737)
		{ { 183,56,155,230,11 }, { 221,216,39,91,11 }, { 214,125,145,206,13 }, { 221,174,65,187,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1738)
		{ { 41,127,247,175,7 }, { 127,247,106,116,15 }, { 239,94,255,233,4 }, { 242,229,110,255,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1739)
		{ { 177,201,139,131,7 }, { 20,222,116,70,11 }, { 236,29,25,56,13 }, { 214,34,231,178,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1740)
		{ { 112,239,122,3,2 }, { 33,94,60,180,13 }, { 76,5,239,112,14 }, { 178,211,199,168,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1741)
		{ { 155,66,34,76,0 }, { 10,108,8,75,4 }, { 3,36,68,45,9 }, { 45,33,3,101,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1742)
		{ { 45,220,24,13,15 }, { 206,52,117,116,8 }, { 251,1,131,187,4 }, { 18,234,226,199,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1743)
		{ { 10,189,5,237,15 }, { 95,51,83,45,10 }, { 251,122,11,213,0 }, { 91,76,172,207,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1744)
		{ { 225,190,133,89,1 }, { 85,161,184,238,8 }, { 137,170,23,216,7 }, { 23,113,216,90,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1745)
		{ { 145,183,86,114,7 }, { 101,91,218,122,1 }, { 228,230,174,216,9 }, { 133,229,189,170,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1746)
		{ { 45,22,243,125,11 }, { 254,240,171,124,4 }, { 219,236,246,139,4 }, { 35,237,80,247,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1747)
		{ { 39,176,238,193,6 }, { 225,209,116,77,6 }, { 104,55,112,222,4 }, { 107,34,232,184,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1748)
		{ { 108,133,130,249,13 }, { 134,226,243,172,2 }, { 185,244,26,19,6 }, { 67,92,244,118,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1749)
		{ { 115,83,40,110,3 }, { 76,62,46,201,5 }, { 199,97,76,172,14 }, { 169,55,71,195,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1750)
		{ { 97,193,148,57,1 }, { 4,167,178,212,0 }, { 137,194,152,56,6 }, { 2,180,222,82,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1751)
		{ { 123,144,243,154,9 }, { 118,232,177,209,7 }, { 149,156,240,157,14 }, { 232,184,209,118,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1752)
		{ { 199,152,208,205,5 }, { 236,160,80,223,10 }, { 171,48,177,158,3 }, { 95,176,160,83,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1753)
		{ { 40,109,39,77,11 }, { 31,119,33,44,12 }, { 219,46,75,97,4 }, { 51,72,78,239,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1754)
		{ { 217,203,12,182,4 }, { 10,15,222,194,11 }, { 38,211,13,57,11 }, { 212,55,191,5,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1755)
		{ { 74,39,247,51,6 }, { 51,211,202,181,5 }, { 108,206,254,69,2 }, { 170,213,60,188,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1756)
		{ { 58,192,163,225,10 }, { 18,220,51,13,6 }, { 88,124,80,53,12 }, { 107,12,195,180,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1757)
		{ { 7,221,220,229,7 }, { 236,151,86,125,10 }, { 234,115,187,190,0 }, { 91,230,174,147,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1758)
		{ { 136,88,155,155,11 }, { 86,244,133,22,11 }, { 221,157,145,161,1 }, { 214,138,18,246,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1759)
		{ { 138,23,163,27,11 }, { 86,242,137,39,5 }, { 221,140,94,133,1 }, { 174,73,20,246,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1760)
		{ { 238,5,82,209,7 }, { 166,82,224,191,2 }, { 232,180,170,7,7 }, { 79,208,116,166,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1761)
		{ { 187,95,31,51,1 }, { 86,79,174,119,9 }, { 140,207,143,173,13 }, { 158,231,95,38,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1762)
		{ { 208,60,187,190,2 }, { 89,248,134,178,15 }, { 71,221,211,192,11 }, { 244,214,17,249,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1763)
		{ { 152,244,149,172,6 }, { 91,189,82,50,2 }, { 99,90,146,241,9 }, { 68,196,171,221,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1764)
		{ { 197,139,251,112,15 }, { 180,210,223,218,12 }, { 240,237,253,26,3 }, { 53,191,180,178,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1765)
		{ { 122,253,6,239,8 }, { 75,111,51,173,11 }, { 31,118,11,245,14 }, { 219,92,207,109,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1766)
		{ { 81,109,127,193,5 }, { 53,79,68,252,14 }, { 168,63,235,104,10 }, { 115,242,47,42,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1767)
		{ { 187,149,178,239,2 }, { 74,250,50,127,7 }, { 79,116,218,157,13 }, { 239,228,197,245,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1768)
		{ { 74,73,174,244,10 }, { 10,215,135,137,14 }, { 82,247,89,37,2 }, { 121,30,30,181,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1769)
		{ { 121,22,119,209,9 }, { 118,73,169,252,6 }, { 152,190,230,137,14 }, { 99,249,89,38,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1770)
		{ { 171,195,19,250,3 }, { 22,118,186,91,3 }, { 197,252,140,61,5 }, { 205,165,214,230,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1771)
		{ { 97,72,188,236,1 }, { 12,165,38,216,14 }, { 131,115,209,40,6 }, { 113,182,74,83,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1772)
		{ { 189,91,56,250,15 }, { 198,62,239,90,15 }, { 245,241,205,171,13 }, { 245,175,119,198,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1773)
		{ { 167,203,22,91,5 }, { 132,103,248,95,9 }, { 173,166,141,62,5 }, { 159,161,254,98,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1774)
		{ { 122,215,157,221,12 }, { 90,175,253,189,2 }, { 59,187,158,181,14 }, { 75,219,255,85,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1775)
		{ { 30,33,123,48,10 }, { 179,90,135,17,4 }, { 80,205,232,71,8 }, { 40,142,21,172,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1776)
		{ { 7,106,159,128,15 }, { 149,213,77,81,10 }, { 240,31,149,110,0 }, { 88,171,42,186,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1777)
		{ { 66,20,244,73,5 }, { 100,161,64,189,4 }, { 169,34,242,132,2 }, { 43,208,40,82,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1778)
		{ { 90,77,21,204,4 }, { 26,47,64,185,10 }, { 35,58,139,37,10 }, { 89,208,47,69,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1779)
		{ { 42,237,24,136,14 }, { 3,54,117,49,10 }, { 113,17,139,117,4 }, { 88,202,230,204,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1780)
		{ { 74,162,225,254,13 }, { 63,160,219,137,7 }, { 183,248,116,85,2 }, { 233,29,176,95,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1781)
		{ { 132,142,174,178,2 }, { 128,209,158,34,15 }, { 68,215,87,18,1 }, { 244,71,152,176,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1782)
		{ { 51,40,220,225,13 }, { 37,137,103,93,10 }, { 184,115,177,76,12 }, { 91,174,105,26,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1783)
		{ { 58,219,131,61,10 }, { 90,254,187,5,8 }, { 91,204,29,181,12 }, { 26,13,215,245,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1784)
		{ { 115,169,29,159,13 }, { 29,43,245,213,11 }, { 191,155,137,92,14 }, { 218,186,253,75,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1785)
		{ { 4,109,218,103,10 }, { 169,214,7,60,9 }, { 94,101,187,98,0 }, { 147,206,6,185,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1786)
		{ { 58,203,120,189,13 }, { 46,46,255,21,14 }, { 187,209,237,53,12 }, { 122,143,247,71,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1787)
		{ { 206,153,231,26,12 }, { 242,227,209,131,13 }, { 53,142,121,151,3 }, { 188,24,188,116,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1788)
		{ { 165,37,165,84,6 }, { 153,147,224,106,4 }, { 98,170,90,74,5 }, { 37,96,124,153,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1789)
		{ { 240,63,168,232,1 }, { 69,170,46,170,14 }, { 129,113,95,192,15 }, { 117,87,69,90,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1790)
		{ { 118,229,192,251,1 }, { 165,174,178,173,3 }, { 141,240,58,118,14 }, { 203,84,215,90,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1791)
		{ { 227,99,237,110,12 }, { 57,167,111,203,5 }, { 55,107,124,108,7 }, { 173,63,110,89,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1792)
		{ { 116,249,37,224,5 }, { 213,15,114,136,14 }, { 160,122,73,242,14 }, { 113,20,239,10,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1793)
		{ { 198,217,168,122,2 }, { 192,182,150,139,13 }, { 69,225,89,182,3 }, { 189,22,150,208,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1794)
		{ { 13,96,234,117,11 }, { 175,212,135,76,4 }, { 218,229,112,107,0 }, { 35,46,18,191,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1795)
		{ { 51,227,74,122,13 }, { 37,110,255,73,1 }, { 181,229,44,124,12 }, { 137,47,247,106,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1796)
		{ { 113,122,201,96,4 }, { 113,140,110,200,8 }, { 32,105,53,232,14 }, { 17,55,99,24,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1797)
		{ { 152,138,48,249,12 }, { 2,40,219,30,14 }, { 57,240,197,17,9 }, { 119,141,177,68,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1798)
		{ { 46,163,26,179,12 }, { 131,66,255,21,3 }, { 60,213,140,87,4 }, { 202,143,244,44,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1799)
		{ { 172,182,25,142,10 }, { 219,48,61,50,3 }, { 87,25,134,211,5 }, { 196,203,192,205,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1800)
		{ { 240,101,182,107,5 }, { 5,239,98,190,5 }, { 173,102,218,96,15 }, { 167,212,111,122,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1801)
		{ { 168,198,88,212,0 }, { 42,4,188,58,2 }, { 2,177,166,49,5 }, { 69,195,210,5,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1802)
		{ { 204,173,140,128,11 }, { 135,147,21,162,10 }, { 208,19,27,83,3 }, { 84,90,140,158,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1803)
		{ { 163,169,133,130,14 }, { 17,147,113,67,11 }, { 116,26,25,92,5 }, { 220,40,236,152,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1804)
		{ { 236,44,102,29,0 }, { 171,97,160,166,12 }, { 11,134,99,67,7 }, { 54,80,88,109,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1805)
		{ { 25,228,167,179,8 }, { 19,205,147,100,7 }, { 28,222,82,121,8 }, { 226,108,155,60,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1806)
		{ { 141,26,103,29,6 }, { 250,113,200,70,12 }, { 107,142,101,139,1 }, { 54,33,56,229,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1807)
		{ { 178,43,3,194,13 }, { 21,74,105,11,11 }, { 180,60,13,68,13 }, { 221,9,101,42,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1808)
		{ { 233,107,129,42,2 }, { 19,182,42,194,9 }, { 69,72,29,105,7 }, { 148,53,70,220,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1809)
		{ { 175,188,151,185,4 }, { 211,225,242,119,10 }, { 41,222,147,223,5 }, { 94,228,248,124,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1810)
		{ { 46,29,146,160,8 }, { 194,194,35,49,10 }, { 16,84,155,135,4 }, { 88,204,68,52,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1811)
		{ { 20,26,214,160,3 }, { 228,217,10,16,10 }, { 192,86,181,130,8 }, { 80,133,9,178,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1812)
		{ { 181,12,21,252,0 }, { 152,41,162,122,10 }, { 3,250,131,10,13 }, { 85,228,89,65,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1813)
		{ { 95,40,182,146,9 }, { 135,201,129,209,15 }, { 148,150,209,79,10 }, { 248,184,25,62,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1814)
		{ { 5,73,160,42,15 }, { 132,182,67,64,13 }, { 245,64,89,42,0 }, { 176,44,38,210,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1815)
		{ { 170,29,19,140,15 }, { 94,114,97,51,10 }, { 243,28,139,133,5 }, { 92,200,100,231,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1816)
		{ { 214,197,212,242,6 }, { 160,159,210,187,3 }, { 100,242,186,54,11 }, { 205,212,191,144,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1817)
		{ { 175,39,99,231,15 }, { 191,82,107,111,7 }, { 254,124,110,79,5 }, { 239,109,100,175,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1818)
		{ { 13,30,84,39,10 }, { 234,17,11,116,9 }, { 94,66,167,139,0 }, { 146,237,8,133,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1819)
		{ { 105,13,29,67,9 }, { 22,3,37,252,9 }, { 156,43,139,9,6 }, { 147,250,76,6,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1820)
		{ { 142,118,82,211,11 }, { 231,84,137,63,3 }, { 220,180,166,231,1 }, { 207,201,18,174,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1821)
		{ { 183,231,13,198,11 }, { 157,31,61,107,3 }, { 214,59,14,126,13 }, { 205,107,207,139,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1822)
		{ { 91,61,61,135,11 }, { 95,27,5,245,15 }, { 222,27,203,205,10 }, { 250,250,13,143,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1823)
		{ { 79,134,142,113,6 }, { 130,209,222,237,0 }, { 104,231,22,31,2 }, { 11,119,184,180,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1824)
		{ { 177,31,187,167,12 }, { 88,202,111,118,15 }, { 62,93,223,136,13 }, { 246,239,101,49,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1825)
		{ { 128,174,197,152,2 }, { 49,177,152,34,10 }, { 65,154,55,80,1 }, { 84,65,152,216,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1826)
		{ { 213,231,198,181,15 }, { 173,223,219,230,2 }, { 250,214,62,122,11 }, { 70,125,191,187,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1827)
		{ { 93,45,129,118,3 }, { 159,154,130,232,9 }, { 198,232,27,75,10 }, { 145,116,21,159,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1828)
		{ { 203,168,201,76,1 }, { 63,160,20,203,8 }, { 131,41,49,93,3 }, { 29,50,128,95,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1829)
		{ { 103,230,75,17,3 }, { 181,84,188,229,0 }, { 200,141,38,126,6 }, { 10,115,210,170,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1830)
		{ { 250,67,80,92,14 }, { 42,62,233,155,0 }, { 115,160,172,37,15 }, { 13,153,119,197,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1831)
		{ { 240,150,174,222,7 }, { 76,249,252,170,7 }, { 231,183,86,144,15 }, { 229,83,249,243,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1832)
		{ { 71,218,157,211,11 }, { 212,149,157,221,11 }, { 220,187,149,190,2 }, { 219,187,154,146,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1833)
		{ { 154,5,75,133,14 }, { 58,90,69,39,2 }, { 122,29,42,5,9 }, { 78,74,37,165,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1834)
		{ { 120,108,53,241,11 }, { 23,29,163,188,14 }, { 216,250,195,97,14 }, { 115,220,91,142,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1835)
		{ { 147,175,244,140,6 }, { 41,187,88,115,14 }, { 99,18,255,92,9 }, { 124,225,173,217,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1836)
		{ { 42,176,175,52,11 }, { 95,209,183,1,4 }, { 210,207,80,213,4 }, { 40,14,216,191,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1837)
		{ { 240,11,250,99,1 }, { 36,202,46,158,13 }, { 140,101,253,0,15 }, { 183,151,69,50,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1838)
		{ { 76,166,198,133,5 }, { 175,193,88,164,2 }, { 170,22,54,83,2 }, { 66,81,168,63,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1839)
		{ { 186,20,227,14,1 }, { 126,232,32,35,5 }, { 135,12,114,133,13 }, { 172,64,65,119,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1840)
		{ { 33,208,242,145,8 }, { 96,196,177,84,6 }, { 24,148,240,184,4 }, { 98,168,210,48,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1841)
		{ { 195,163,48,100,2 }, { 9,18,26,219,4 }, { 66,96,204,92,3 }, { 45,181,132,137,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1842)
		{ { 55,157,233,153,7 }, { 244,186,244,101,14 }, { 233,153,123,158,12 }, { 122,98,245,210,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1843)
		{ { 34,132,160,94,1 }, { 12,160,176,41,5 }, { 135,160,82,20,4 }, { 169,64,208,83,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1844)
		{ { 111,213,214,14,1 }, { 238,231,48,241,1 }, { 135,6,186,191,6 }, { 136,240,206,119,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1845)
		{ { 203,84,111,171,13 }, { 118,101,71,231,7 }, { 189,95,98,173,3 }, { 238,126,42,102,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1846)
		{ { 156,42,145,229,8 }, { 155,136,11,30,10 }, { 26,120,149,67,9 }, { 87,141,1,29,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1847)
		{ { 61,210,148,126,15 }, { 206,189,251,88,1 }, { 247,226,148,187,12 }, { 129,173,251,215,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1848)
		{ { 100,83,228,51,13 }, { 228,135,235,132,5 }, { 188,194,124,162,6 }, { 162,29,126,18,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1849)
		{ { 43,198,86,24,12 }, { 34,101,249,113,0 }, { 49,134,166,61,4 }, { 8,233,250,100,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1850)
		{ { 37,39,183,207,14 }, { 153,243,105,124,7 }, { 127,62,222,74,4 }, { 227,233,108,249,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1851)
		{ { 22,36,199,38,13 }, { 189,201,67,33,1 }, { 182,78,50,70,8 }, { 136,76,41,59,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1852)
		{ { 202,176,164,248,14 }, { 67,177,211,139,6 }, { 113,242,80,213,3 }, { 109,28,184,220,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1853)
		{ { 193,236,138,99,14 }, { 1,212,87,238,9 }, { 124,101,19,120,3 }, { 151,126,162,184,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1854)
		{ { 82,142,30,232,13 }, { 4,105,95,185,10 }, { 177,119,135,20,10 }, { 89,223,169,98,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1855)
		{ { 254,163,79,210,9 }, { 183,75,189,139,3 }, { 148,191,44,87,15 }, { 205,27,221,46,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1856)
		{ { 92,145,249,82,6 }, { 242,154,212,152,5 }, { 100,169,248,147,10 }, { 161,146,181,148,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1857)
		{ { 42,103,218,12,8 }, { 43,230,45,49,0 }, { 19,5,190,101,4 }, { 8,203,70,125,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1858)
		{ { 111,147,7,201,2 }, { 210,115,56,205,2 }, { 73,62,12,159,6 }, { 75,49,204,228,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1859)
		{ { 27,127,101,218,0 }, { 115,47,136,105,15 }, { 5,186,111,237,8 }, { 249,97,31,76,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1860)
		{ { 96,94,48,82,3 }, { 68,20,168,184,13 }, { 196,160,199,160,6 }, { 177,209,82,130,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1861)
		{ { 187,3,116,51,0 }, { 34,11,170,87,5 }, { 12,194,236,13,13 }, { 174,165,93,4,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1862)
		{ { 245,150,230,89,11 }, { 228,249,185,238,4 }, { 217,166,118,154,15 }, { 39,121,217,242,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1863)
		{ { 146,81,227,36,14 }, { 120,222,67,3,4 }, { 114,76,120,164,9 }, { 44,12,39,177,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1864)
		{ { 37,129,147,161,3 }, { 148,210,50,84,2 }, { 200,92,152,26,4 }, { 66,164,196,178,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1865)
		{ { 179,35,202,164,8 }, { 41,202,47,67,2 }, { 18,85,60,76,13 }, { 76,47,69,57,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1866)
		{ { 141,73,29,60,1 }, { 158,39,134,82,8 }, { 131,203,137,43,1 }, { 20,166,30,71,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1867)
		{ { 227,51,36,195,13 }, { 69,3,105,207,7 }, { 188,50,76,204,7 }, { 239,57,108,10,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1868)
		{ { 184,54,252,47,7 }, { 111,185,110,54,5 }, { 239,67,246,193,13 }, { 166,199,105,223,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1869)
		{ { 237,209,46,107,4 }, { 194,103,118,206,5 }, { 45,103,72,187,7 }, { 167,54,238,100,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1870)
		{ { 235,71,59,247,10 }, { 26,86,175,255,7 }, { 94,253,206,45,7 }, { 239,255,86,165,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1871)
		{ { 20,242,111,82,9 }, { 245,77,157,8,5 }, { 148,175,100,242,8 }, { 161,11,155,42,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1872)
		{ { 205,127,26,185,15 }, { 199,118,207,246,10 }, { 249,213,143,235,3 }, { 86,255,54,238,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1873)
		{ { 198,53,226,175,3 }, { 237,242,2,167,7 }, { 207,84,122,198,3 }, { 238,84,4,251,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1874)
		{ { 215,249,12,215,3 }, { 205,31,148,207,11 }, { 206,179,9,254,11 }, { 223,50,159,139,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1875)
		{ { 83,21,215,208,12 }, { 112,203,193,249,2 }, { 48,190,186,140,10 }, { 73,248,61,48,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1876)
		{ { 86,18,116,213,1 }, { 236,9,136,157,6 }, { 138,178,228,134,10 }, { 107,145,25,3,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1877)
		{ { 181,26,186,149,2 }, { 200,216,172,86,14 }, { 74,149,213,138,13 }, { 118,163,81,177,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1878)
		{ { 98,62,7,58,4 }, { 81,97,234,161,9 }, { 37,206,7,196,6 }, { 152,85,120,104,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1879)
		{ { 235,252,157,72,14 }, { 83,181,117,251,8 }, { 113,43,147,253,7 }, { 29,250,234,220,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1880)
		{ { 129,51,86,47,14 }, { 105,115,75,86,1 }, { 127,70,172,200,1 }, { 134,173,44,233,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1881)
		{ { 125,43,146,2,6 }, { 131,218,104,208,9 }, { 100,4,157,75,14 }, { 144,177,101,188,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1882)
		{ { 144,85,192,202,6 }, { 96,190,64,42,3 }, { 101,48,58,160,9 }, { 197,64,39,208,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1883)
		{ { 205,132,181,92,15 }, { 158,177,209,250,4 }, { 243,170,210,27,3 }, { 37,248,184,215,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1884)
		{ { 11,54,92,9,4 }, { 99,33,76,117,0 }, { 41,3,166,205,0 }, { 10,227,40,76,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1885)
		{ { 190,98,7,5,10 }, { 155,93,41,7,0 }, { 90,14,4,103,13 }, { 14,9,75,173,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1886)
		{ { 39,38,95,35,12 }, { 177,65,111,117,1 }, { 60,79,166,78,4 }, { 138,239,104,40,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1887)
		{ { 100,138,166,99,10 }, { 128,209,59,140,13 }, { 92,102,85,18,6 }, { 179,29,200,176,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1888)
		{ { 254,101,69,2,13 }, { 183,15,97,163,1 }, { 180,10,42,103,15 }, { 140,88,111,14,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1889)
		{ { 167,99,68,48,13 }, { 165,7,235,67,0 }, { 176,194,44,110,5 }, { 12,45,126,10,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1890)
		{ { 217,192,126,10,8 }, { 34,109,21,210,5 }, { 21,7,224,57,11 }, { 164,186,139,100,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1891)
		{ { 29,104,212,20,13 }, { 175,141,193,80,8 }, { 178,130,177,107,8 }, { 16,168,59,31,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1892)
		{ { 203,197,40,112,3 }, { 6,22,150,235,4 }, { 192,225,74,61,3 }, { 45,118,150,134,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1893)
		{ { 228,40,28,188,9 }, { 141,33,167,146,10 }, { 147,211,129,66,7 }, { 84,158,88,75,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1894)
		{ { 225,221,170,221,6 }, { 72,246,244,238,14 }, { 107,181,91,184,7 }, { 119,114,246,241,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1895)
		{ { 244,239,90,230,13 }, { 173,78,127,186,11 }, { 182,117,175,114,15 }, { 213,223,231,43,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1896)
		{ { 122,159,45,115,15 }, { 86,27,255,173,13 }, { 252,235,79,149,14 }, { 187,95,253,134,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1897)
		{ { 189,215,111,86,6 }, { 250,95,252,106,5 }, { 102,175,110,187,13 }, { 165,99,255,165,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1898)
		{ { 79,139,34,80,4 }, { 130,66,216,201,12 }, { 32,164,77,31,2 }, { 57,49,180,36,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1899)
		{ { 104,156,225,61,6 }, { 122,176,242,164,12 }, { 107,200,115,145,6 }, { 50,84,240,213,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1900)
		{ { 23,125,226,145,13 }, { 229,206,193,101,14 }, { 184,148,123,238,8 }, { 122,104,55,58,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1901)
		{ { 101,27,125,109,2 }, { 248,51,46,220,12 }, { 75,107,237,138,6 }, { 51,183,76,193,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1902)
		{ { 230,30,244,128,14 }, { 224,145,105,179,14 }, { 112,18,247,134,7 }, { 124,217,104,144,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1903)
		{ { 10,131,197,183,14 }, { 58,147,219,5,3 }, { 126,218,60,21,0 }, { 202,13,188,149,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1904)
		{ { 113,216,247,205,5 }, { 124,237,112,220,14 }, { 171,62,241,184,14 }, { 115,176,235,115,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1905)
		{ { 119,102,40,235,6 }, { 129,60,110,237,7 }, { 109,113,70,110,14 }, { 235,119,99,200,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1906)
		{ { 164,71,35,16,2 }, { 144,86,168,34,4 }, { 64,140,78,34,5 }, { 36,65,86,160,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1907)
		{ { 141,28,30,136,7 }, { 198,113,68,114,10 }, { 225,23,131,139,1 }, { 84,226,40,230,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1908)
		{ { 174,5,207,117,0 }, { 186,195,166,47,0 }, { 10,239,58,7,5 }, { 15,70,92,53,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1909)
		{ { 242,185,238,5,10 }, { 105,219,53,135,12 }, { 90,7,121,212,15 }, { 62,26,205,185,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1910)
		{ { 150,184,220,80,14 }, { 225,153,213,27,8 }, { 112,163,177,214,9 }, { 29,138,185,152,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1911)
		{ { 191,140,179,54,4 }, { 154,200,242,115,13 }, { 38,204,211,31,13 }, { 188,228,241,53,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1912)
		{ { 77,139,178,107,7 }, { 134,242,90,220,13 }, { 237,100,221,27,2 }, { 179,181,164,246,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1913)
		{ { 48,111,43,129,9 }, { 21,78,45,36,14 }, { 152,29,79,96,12 }, { 114,75,71,42,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1914)
		{ { 134,223,39,101,6 }, { 216,87,90,47,12 }, { 106,110,79,182,1 }, { 63,69,174,161,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1915)
		{ { 201,63,168,244,10 }, { 75,146,143,234,14 }, { 82,241,95,201,3 }, { 117,127,20,157,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1916)
		{ { 178,101,205,76,0 }, { 57,175,36,43,0 }, { 3,43,58,100,13 }, { 13,66,79,89,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1917)
		{ { 230,107,232,211,7 }, { 165,150,236,143,15 }, { 236,177,125,102,7 }, { 255,19,118,154,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1918)
		{ { 172,157,252,25,5 }, { 230,163,244,54,12 }, { 169,131,251,147,5 }, { 54,194,252,86,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1919)
		{ { 177,19,196,190,12 }, { 104,171,235,66,3 }, { 55,210,60,136,13 }, { 196,45,125,81,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1920)
		{ { 211,223,9,161,13 }, { 84,14,95,231,10 }, { 184,89,15,188,11 }, { 94,127,167,2,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1921)
		{ { 238,69,143,67,7 }, { 150,215,100,175,1 }, { 236,47,26,39,7 }, { 143,82,110,182,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1922)
		{ { 103,202,12,176,9 }, { 132,5,191,193,10 }, { 144,211,5,62,6 }, { 88,63,218,2,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1923)
		{ { 179,49,95,108,5 }, { 125,107,102,91,0 }, { 163,111,168,204,13 }, { 13,166,109,107,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1924)
		{ { 51,113,11,210,2 }, { 81,94,164,73,3 }, { 68,189,8,236,12 }, { 201,34,87,168,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1925)
		{ { 155,233,139,184,6 }, { 19,254,214,67,10 }, { 97,221,25,125,9 }, { 92,38,183,252,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1926)
		{ { 65,191,62,12,5 }, { 77,99,92,240,12 }, { 163,7,207,216,2 }, { 48,243,172,107,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1927)
		{ { 39,180,57,11,8 }, { 209,32,53,117,5 }, { 29,9,194,222,4 }, { 170,234,192,72,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1928)
		{ { 22,194,235,111,10 }, { 184,252,31,13,5 }, { 95,109,116,54,8 }, { 171,15,131,241,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1929)
		{ { 180,216,190,76,8 }, { 200,237,53,26,12 }, { 19,39,209,178,13 }, { 53,138,203,113,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1930)
		{ { 157,108,51,41,10 }, { 147,124,3,118,12 }, { 89,76,195,107,9 }, { 54,236,3,236,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1931)
		{ { 62,93,56,87,15 }, { 206,30,229,61,13 }, { 254,161,203,167,12 }, { 187,202,119,135,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1932)
		{ { 180,100,140,48,10 }, { 129,157,167,34,0 }, { 80,195,18,98,13 }, { 4,78,91,152,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1933)
		{ { 93,101,141,153,11 }, { 151,191,133,228,2 }, { 217,155,26,107,10 }, { 66,122,31,222,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1934)
		{ { 75,57,30,253,8 }, { 75,99,135,221,10 }, { 27,247,137,205,2 }, { 91,190,28,109,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1935)
		{ { 159,102,246,244,7 }, { 175,221,202,123,6 }, { 226,246,246,111,9 }, { 109,229,59,191,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1936)
		{ { 99,251,122,188,8 }, { 105,102,191,209,14 }, { 19,213,237,252,6 }, { 120,191,214,105,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1937)
		{ { 48,213,149,195,13 }, { 84,143,113,60,3 }, { 188,58,154,176,12 }, { 195,200,239,18,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1938)
		{ { 44,228,218,91,8 }, { 163,228,181,60,1 }, { 29,165,178,115,4 }, { 131,202,210,124,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1939)
		{ { 123,79,47,122,4 }, { 18,111,238,233,13 }, { 37,239,79,45,14 }, { 185,119,127,100,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1940)
		{ { 80,165,170,211,11 }, { 5,218,149,172,7 }, { 220,181,90,80,10 }, { 227,90,149,186,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1941)
		{ { 53,99,219,99,9 }, { 181,206,47,92,1 }, { 156,109,188,106,12 }, { 131,175,71,58,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1942)
		{ { 202,17,193,89,1 }, { 118,162,128,143,0 }, { 137,168,56,133,3 }, { 15,16,20,86,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1943)
		{ { 119,153,15,22,8 }, { 216,75,181,193,9 }, { 22,143,9,158,14 }, { 152,58,221,33,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1944)
		{ { 6,232,6,138,11 }, { 133,117,17,1,11 }, { 213,22,1,118,0 }, { 216,8,138,234,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1945)
		{ { 88,242,76,249,1 }, { 103,45,158,140,2 }, { 137,243,36,241,10 }, { 67,23,155,78,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1946)
		{ { 87,131,120,211,4 }, { 160,10,220,221,7 }, { 44,177,236,30,10 }, { 235,179,181,0,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1947)
		{ { 102,199,182,12,6 }, { 136,247,120,177,4 }, { 99,6,222,54,6 }, { 40,209,238,241,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1948)
		{ { 120,143,69,72,0 }, { 50,43,56,168,8 }, { 1,42,47,17,14 }, { 17,81,205,68,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1949)
		{ { 233,239,208,58,13 }, { 39,166,251,242,9 }, { 181,192,191,121,7 }, { 148,253,246,94,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1950)
		{ { 39,212,15,163,10 }, { 208,85,55,101,3 }, { 92,95,2,190,4 }, { 202,110,202,160,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1951)
		{ { 125,42,249,128,10 }, { 179,152,45,208,14 }, { 80,25,245,75,14 }, { 112,187,65,156,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1952)
		{ { 86,144,82,117,6 }, { 232,88,210,157,0 }, { 106,228,160,150,10 }, { 11,148,177,161,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1953)
		{ { 30,225,231,61,2 }, { 187,255,146,5,4 }, { 75,206,120,119,8 }, { 42,4,159,253,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1954)
		{ { 254,157,166,210,9 }, { 198,203,177,171,15 }, { 148,182,91,151,15 }, { 253,88,221,54,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1955)
		{ { 75,222,118,252,11 }, { 110,117,155,249,14 }, { 211,246,231,189,2 }, { 121,253,154,231,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1956)
		{ { 50,21,75,223,8 }, { 120,106,165,45,3 }, { 31,189,42,132,12 }, { 203,74,85,97,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1957)
		{ { 141,94,72,11,6 }, { 226,52,76,102,9 }, { 109,1,39,171,1 }, { 150,99,34,196,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1958)
		{ { 85,153,228,23,12 }, { 232,139,209,196,13 }, { 62,130,121,154,10 }, { 178,56,189,17,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1959)
		{ { 127,178,100,131,2 }, { 227,25,56,197,7 }, { 76,18,100,223,14 }, { 234,49,201,140,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1960)
		{ { 6,201,57,111,3 }, { 156,54,22,29,13 }, { 207,105,201,54,0 }, { 187,134,134,195,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1961)
		{ { 66,202,124,45,2 }, { 40,53,30,149,12 }, { 75,67,229,52,2 }, { 58,151,138,193,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1962)
		{ { 78,192,248,186,12 }, { 162,164,215,145,7 }, { 53,209,240,55,2 }, { 232,158,178,84,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1963)
		{ { 45,113,131,30,11 }, { 223,246,161,64,1 }, { 215,140,24,235,4 }, { 128,40,86,255,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1964)
		{ { 128,130,234,70,4 }, { 40,192,92,10,5 }, { 38,37,116,16,1 }, { 165,3,160,49,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1965)
		{ { 172,206,58,52,3 }, { 142,84,190,50,12 }, { 194,197,199,51,5 }, { 52,199,210,167,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1966)
		{ { 88,160,32,181,13 }, { 15,8,211,132,6 }, { 186,208,64,81,10 }, { 98,28,177,15,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1967)
		{ { 114,159,129,35,8 }, { 80,138,59,165,9 }, { 28,72,31,148,14 }, { 154,93,197,16,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1968)
		{ { 123,5,90,20,12 }, { 42,74,229,241,0 }, { 50,133,170,13,14 }, { 8,250,117,37,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1969)
		{ { 150,248,124,233,1 }, { 229,45,22,31,14 }, { 137,115,225,246,9 }, { 127,134,139,74,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1970)
		{ { 41,99,28,75,10 }, { 3,55,45,92,1 }, { 93,35,140,105,4 }, { 131,171,78,204,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1971)
		{ { 157,226,24,237,14 }, { 139,60,95,94,2 }, { 123,113,132,123,9 }, { 71,175,163,205,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1972)
		{ { 58,230,175,66,4 }, { 19,205,124,41,5 }, { 36,47,86,117,12 }, { 169,67,235,60,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1973)
		{ { 180,56,174,163,3 }, { 197,217,38,6,15 }, { 204,87,81,194,13 }, { 246,6,73,186,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1974)
		{ { 208,70,61,144,7 }, { 20,29,204,178,6 }, { 224,155,198,32,11 }, { 100,211,59,130,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1975)
		{ { 187,32,151,39,0 }, { 27,201,34,87,1 }, { 14,78,144,77,13 }, { 142,164,73,61,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1976)
		{ { 229,143,37,62,0 }, { 152,35,186,226,13 }, { 7,202,79,26,7 }, { 180,117,220,65,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1977)
		{ { 194,117,158,53,4 }, { 73,199,198,183,0 }, { 42,199,154,228,3 }, { 14,214,62,57,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1978)
		{ { 10,66,188,132,7 }, { 14,149,76,17,6 }, { 226,19,212,37,0 }, { 104,131,42,151,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1979)
		{ { 173,67,236,130,11 }, { 166,151,45,66,7 }, { 212,19,124,43,5 }, { 228,43,78,150,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1980)
		{ { 61,136,115,251,11 }, { 182,120,179,92,15 }, { 221,252,225,27,12 }, { 243,172,209,230,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1981)
		{ { 102,161,166,184,11 }, { 133,243,179,129,6 }, { 209,214,88,86,6 }, { 104,28,220,250,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1982)
		{ { 221,141,175,200,4 }, { 146,235,84,234,14 }, { 33,63,91,27,11 }, { 117,114,173,116,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1983)
		{ { 21,7,218,203,3 }, { 164,250,12,124,3 }, { 205,53,190,10,8 }, { 195,227,5,242,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1984)
		{ { 137,254,190,99,3 }, { 71,213,30,126,13 }, { 204,103,215,249,1 }, { 183,231,138,190,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1985)
		{ { 25,7,189,144,10 }, { 18,155,141,112,6 }, { 80,155,222,9,8 }, { 96,235,29,148,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1986)
		{ { 98,241,188,178,14 }, { 65,151,247,145,7 }, { 116,211,216,244,6 }, { 232,158,254,152,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1987)
		{ { 14,147,144,200,10 }, { 194,178,25,25,2 }, { 81,48,156,151,0 }, { 73,137,132,212,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1988)
		{ { 102,251,212,124,10 }, { 233,183,187,153,8 }, { 83,226,189,246,6 }, { 25,157,222,217,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1989)
		{ { 203,127,203,186,5 }, { 119,230,206,227,11 }, { 165,221,63,237,3 }, { 220,119,54,126,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1990)
		{ { 72,77,150,114,5 }, { 6,199,194,184,9 }, { 164,230,155,33,2 }, { 145,212,62,54,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1991)
		{ { 182,201,156,184,13 }, { 132,175,247,19,10 }, { 177,211,153,54,13 }, { 92,142,255,82,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1992)
		{ { 214,73,19,109,6 }, { 152,126,66,159,8 }, { 107,108,137,38,11 }, { 31,148,39,225,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1993)
		{ { 13,229,2,166,2 }, { 139,86,18,96,3 }, { 70,84,10,123,0 }, { 192,100,134,173,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1994)
		{ { 249,154,61,119,4 }, { 90,9,254,222,13 }, { 46,235,197,153,15 }, { 183,183,249,5,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1995)
		{ { 124,20,82,167,4 }, { 234,72,98,180,3 }, { 46,84,162,131,14 }, { 194,212,97,37,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1996)
		{ { 57,81,76,89,15 }, { 102,63,229,76,0 }, { 249,163,40,169,12 }, { 3,42,127,198,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1997)
		{ { 202,63,57,87,14 }, { 91,18,205,191,13 }, { 126,169,207,197,3 }, { 191,219,52,141,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1998)
		{ { 219,212,95,243,10 }, { 114,93,151,255,3 }, { 92,255,162,189,11 }, { 207,254,155,164,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1999)
		{ { 113,246,139,38,2 }, { 89,220,62,224,1 }, { 70,77,22,248,14 }, { 128,119,195,185,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2000)
		{ { 61,34,41,13,7 }, { 159,56,108,68,4 }, { 235,9,68,75,12 }, { 34,35,97,207,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2001)
		{ { 154,77,130,207,12 }, { 10,238,65,47,11 }, { 63,52,27,37,9 }, { 223,72,39,117,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2002)
		{ { 16,141,72,139,2 }, { 32,58,20,36,11 }, { 77,17,43,16,8 }, { 210,66,133,192,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2003)
		{ { 66,66,157,48,14 }, { 16,149,207,145,0 }, { 112,203,148,36,2 }, { 8,159,58,144,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2004)
		{ { 191,242,183,46,9 }, { 223,237,59,83,5 }, { 151,78,212,255,13 }, { 172,173,203,127,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2005)
		{ { 137,69,178,16,8 }, { 2,198,129,114,4 }, { 16,132,218,41,1 }, { 36,232,22,52,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2006)
		{ { 156,83,206,106,1 }, { 230,239,14,10,1 }, { 133,103,60,163,9 }, { 133,7,15,118,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2007)
		{ { 246,110,46,178,11 }, { 133,93,175,163,15 }, { 212,215,71,102,15 }, { 252,95,91,170,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2008)
		{ { 123,135,22,82,6 }, { 2,91,248,249,1 }, { 100,166,142,29,14 }, { 137,241,253,164,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2009)
		{ { 117,48,198,172,7 }, { 237,249,98,192,2 }, { 227,86,48,202,14 }, { 64,52,105,251,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2010)
		{ { 219,148,76,224,4 }, { 98,9,86,235,2 }, { 32,115,34,157,11 }, { 77,118,169,4,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2011)
		{ { 64,156,92,188,6 }, { 104,49,214,176,10 }, { 99,211,163,144,2 }, { 80,214,184,193,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2012)
		{ { 96,119,25,168,12 }, { 81,38,111,176,2 }, { 49,89,142,224,6 }, { 64,223,102,72,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2013)
		{ { 100,136,107,16,1 }, { 180,64,180,128,12 }, { 128,141,97,18,6 }, { 48,18,208,34,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2014)
		{ { 33,158,169,148,0 }, { 88,128,188,96,14 }, { 2,153,87,152,4 }, { 112,99,208,17,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2015)
		{ { 146,100,250,242,11 }, { 37,220,135,59,7 }, { 212,245,242,100,9 }, { 237,206,19,186,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2016)
		{ { 214,14,81,55,9 }, { 188,8,139,183,9 }, { 158,200,167,6,11 }, { 158,221,17,3,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2017)
		{ { 6,232,25,146,12 }, { 145,4,213,17,11 }, { 52,153,129,118,0 }, { 216,138,178,8,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2018)
		{ { 101,196,213,201,3 }, { 180,181,48,252,2 }, { 201,58,178,58,6 }, { 67,240,202,210,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2019)
		{ { 91,1,85,227,4 }, { 50,11,66,221,3 }, { 44,122,168,13,10 }, { 203,180,45,4,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2020)
		{ { 93,64,143,102,1 }, { 158,205,6,200,1 }, { 134,111,16,43,10 }, { 129,54,11,55,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2021)
		{ { 61,239,243,168,13 }, { 183,238,123,112,14 }, { 177,92,255,123,12 }, { 112,237,231,126,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2022)
		{ { 83,37,200,86,6 }, { 41,154,196,233,1 }, { 102,161,58,76,10 }, { 137,114,53,153,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2023)
		{ { 18,10,174,82,10 }, { 0,217,141,9,13 }, { 84,167,85,4,8 }, { 185,11,25,176,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2024)
		{ { 155,29,191,200,11 }, { 86,251,5,123,14 }, { 209,63,219,141,9 }, { 125,234,13,246,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2025)
		{ { 207,183,171,86,8 }, { 219,194,157,235,5 }, { 22,173,94,223,3 }, { 173,123,148,61,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2026)
		{ { 42,141,220,32,7 }, { 38,147,118,49,8 }, { 224,67,187,21,4 }, { 24,198,236,150,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2027)
		{ { 142,106,174,19,3 }, { 135,213,140,7,13 }, { 204,135,85,103,1 }, { 190,3,26,190,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2028)
		{ { 171,253,77,159,3 }, { 127,55,180,103,11 }, { 207,155,43,253,5 }, { 222,98,222,207,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2029)
		{ { 45,9,17,6,12 }, { 154,2,97,80,9 }, { 54,8,137,11,4 }, { 144,168,100,5,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2030)
		{ { 168,207,127,12,12 }, { 58,103,125,50,12 }, { 51,15,239,49,5 }, { 52,203,238,101,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2031)
		{ { 166,83,153,76,7 }, { 220,182,108,27,0 }, { 227,41,156,166,5 }, { 13,131,102,211,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2032)
		{ { 135,166,224,109,0 }, { 169,160,26,111,4 }, { 11,96,118,94,1 }, { 47,101,128,89,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2033)
		{ { 59,232,221,151,0 }, { 59,141,180,85,11 }, { 14,155,177,125,12 }, { 218,162,219,29,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2034)
		{ { 209,178,226,250,9 }, { 101,232,155,202,7 }, { 149,244,116,216,11 }, { 229,61,145,122,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2035)
		{ { 0,188,184,78,7 }, { 77,176,84,56,13 }, { 231,33,211,208,0 }, { 177,194,160,219,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2036)
		{ { 166,167,158,98,11 }, { 133,211,63,59,1 }, { 212,103,158,86,5 }, { 141,207,204,186,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2037)
		{ { 200,134,91,1,3 }, { 54,80,28,182,0 }, { 200,13,166,17,3 }, { 6,211,128,166,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2038)
		{ { 12,255,119,177,9 }, { 247,71,155,52,14 }, { 152,222,239,243,0 }, { 114,205,158,46,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2039)
		{ { 142,29,220,148,3 }, { 238,147,132,51,10 }, { 194,147,187,135,1 }, { 92,194,28,151,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2040)
		{ { 18,244,200,158,7 }, { 109,188,212,33,3 }, { 231,145,50,244,8 }, { 200,66,179,219,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2041)
		{ { 221,245,180,168,13 }, { 199,175,83,242,6 }, { 177,82,218,251,11 }, { 100,252,175,94,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2042)
		{ { 97,194,86,250,10 }, { 32,117,187,216,3 }, { 85,246,164,56,6 }, { 193,189,218,224,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2043)
		{ { 34,2,81,216,5 }, { 52,32,232,25,2 }, { 161,184,164,4,4 }, { 73,129,112,66,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2044)
		{ { 160,222,24,47,2 }, { 72,52,62,54,9 }, { 79,65,135,176,5 }, { 150,199,194,193,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2045)
		{ { 203,116,62,141,0 }, { 75,101,4,247,6 }, { 11,23,194,237,3 }, { 110,242,10,109,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2046)
		{ { 32,93,174,186,9 }, { 68,231,167,32,15 }, { 149,215,91,160,4 }, { 240,78,94,114,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2047)
		{ { 182,151,72,253,13 }, { 236,42,255,47,2 }, { 187,241,46,150,13 }, { 79,79,245,67,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2048)
		{ { 244,165,139,213,6 }, { 153,218,244,174,2 }, { 106,189,26,82,15 }, { 71,82,245,185,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2049)
		{ { 137,147,208,12,15 }, { 110,178,89,82,0 }, { 243,0,188,153,1 }, { 4,169,164,215,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2050)
		{ { 43,161,206,80,15 }, { 39,211,245,73,0 }, { 240,167,56,93,4 }, { 9,42,252,190,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2051)
		{ { 84,31,38,148,10 }, { 200,91,137,160,14 }, { 82,150,79,130,10 }, { 112,89,29,161,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2052)
		{ { 250,73,70,153,5 }, { 38,111,224,135,10 }, { 169,150,41,37,15 }, { 94,16,127,102,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2053)
		{ { 143,119,77,200,6 }, { 243,55,76,107,2 }, { 97,59,46,239,1 }, { 77,99,46,204,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2054)
		{ { 21,73,52,191,10 }, { 136,63,131,84,15 }, { 95,210,201,42,8 }, { 242,172,31,193,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2055)
		{ { 160,179,125,121,0 }, { 113,35,190,30,4 }, { 9,235,236,208,5 }, { 39,135,220,72,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2056)
		{ { 94,29,64,6,12 }, { 234,10,65,161,9 }, { 54,0,43,135,10 }, { 152,88,37,5,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2057)
		{ { 247,121,227,64,9 }, { 245,206,33,203,12 }, { 144,44,121,238,15 }, { 61,56,71,58,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2058)
		{ { 126,60,103,41,12 }, { 243,105,99,165,12 }, { 57,78,99,199,14 }, { 58,92,105,108,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2059)
		{ { 38,10,20,204,8 }, { 136,33,41,25,10 }, { 19,50,133,6,4 }, { 89,137,72,65,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2060)
		{ { 210,180,127,62,15 }, { 125,121,215,179,5 }, { 247,207,226,212,11 }, { 172,222,185,235,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2061)
		{ { 52,74,22,15,2 }, { 136,125,40,20,9 }, { 79,6,133,34,12 }, { 146,129,75,225,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2062)
		{ { 240,88,87,246,9 }, { 124,77,163,154,11 }, { 150,254,161,160,15 }, { 213,156,91,35,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2063)
		{ { 200,222,73,90,3 }, { 118,52,156,170,9 }, { 197,169,39,177,3 }, { 149,83,146,198,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2064)
		{ { 41,152,52,89,7 }, { 70,49,240,92,12 }, { 233,162,193,153,4 }, { 51,160,248,198,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2065)
		{ { 192,28,220,163,10 }, { 96,145,7,182,11 }, { 92,83,179,128,3 }, { 214,222,8,144,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2066)
		{ { 17,134,214,198,15 }, { 44,217,89,120,3 }, { 246,54,182,24,8 }, { 193,233,169,179,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2067)
		{ { 199,106,99,224,0 }, { 177,68,10,203,14 }, { 0,124,101,110,3 }, { 125,53,2,40,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2068)
		{ { 250,63,143,86,4 }, { 91,203,236,171,9 }, { 38,175,31,197,15 }, { 157,83,125,61,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2069)
		{ { 30,208,47,67,7 }, { 214,93,84,13,5 }, { 236,47,64,183,8 }, { 171,2,171,166,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2070)
		{ { 167,132,152,85,15 }, { 140,144,245,127,0 }, { 250,161,146,30,5 }, { 15,234,240,147,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2071)
		{ { 12,209,94,200,6 }, { 226,119,84,24,2 }, { 97,55,168,179,0 }, { 65,130,174,228,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2072)
		{ { 222,242,230,20,0 }, { 235,205,152,131,4 }, { 2,134,116,247,11 }, { 44,17,155,61,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2073)
		{ { 172,114,24,123,12 }, { 195,36,239,30,1 }, { 61,225,132,227,5 }, { 135,143,114,76,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2074)
		{ { 103,201,15,119,7 }, { 156,87,246,205,9 }, { 238,239,9,62,6 }, { 155,54,254,163,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2075)
		{ { 7,91,205,34,11 }, { 244,151,15,65,9 }, { 212,75,61,174,0 }, { 152,47,14,146,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2076)
		{ { 201,190,213,237,13 }, { 127,161,91,254,10 }, { 187,122,183,217,3 }, { 87,253,168,95,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2077)
		{ { 106,147,24,117,4 }, { 74,2,254,157,0 }, { 42,225,140,149,6 }, { 11,151,244,5,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2078)
		{ { 107,212,146,123,3 }, { 70,244,178,253,1 }, { 205,228,146,189,6 }, { 139,244,210,246,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2079)
		{ { 118,132,7,115,8 }, { 144,73,179,173,1 }, { 28,238,2,22,14 }, { 139,92,217,32,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2080)
		{ { 181,12,26,120,15 }, { 132,120,231,122,8 }, { 241,229,131,10,13 }, { 21,238,113,226,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2081)
		{ { 153,76,54,246,14 }, { 10,93,195,122,15 }, { 118,246,195,41,9 }, { 245,236,59,165,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2082)
		{ { 33,245,36,87,11 }, { 77,23,177,108,5 }, { 222,162,74,248,4 }, { 163,104,222,139,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2083)
		{ { 97,170,231,238,4 }, { 57,225,122,200,15 }, { 39,126,117,88,6 }, { 241,53,232,121,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2084)
		{ { 36,1,140,232,5 }, { 132,163,102,8,2 }, { 161,115,24,2,4 }, { 65,6,108,82,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2085)
		{ { 97,41,206,35,10 }, { 33,211,39,196,9 }, { 92,71,57,72,6 }, { 146,62,76,184,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2086)
		{ { 164,226,123,199,10 }, { 185,84,61,30,7 }, { 94,61,228,114,5 }, { 231,139,194,169,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2087)
		{ { 182,249,62,111,6 }, { 201,127,118,31,13 }, { 111,103,201,246,13 }, { 191,134,239,233,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2088)
		{ { 184,158,66,250,4 }, { 98,104,250,42,11 }, { 37,244,39,145,13 }, { 213,69,241,100,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2089)
		{ { 205,168,178,163,12 }, { 131,192,83,214,15 }, { 60,84,209,91,3 }, { 246,188,160,60,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2090)
		{ { 76,57,177,159,7 }, { 223,178,192,148,15 }, { 239,152,217,195,2 }, { 242,144,52,223,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2091)
		{ { 185,129,38,244,2 }, { 10,91,178,74,6 }, { 66,246,72,25,13 }, { 101,36,221,165,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2092)
		{ { 14,11,250,182,8 }, { 170,194,143,17,15 }, { 22,213,253,7,0 }, { 248,143,20,53,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2093)
		{ { 242,177,157,60,6 }, { 89,187,246,147,0 }, { 99,203,152,212,15 }, { 12,150,253,217,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2094)
		{ { 62,75,92,90,2 }, { 162,63,172,25,9 }, { 69,163,173,39,12 }, { 153,131,95,196,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2095)
		{ { 53,13,105,45,8 }, { 184,42,39,100,12 }, { 27,73,107,10,12 }, { 50,110,69,65,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2096)
		{ { 180,35,142,37,5 }, { 141,203,110,6,0 }, { 170,71,28,66,13 }, { 6,7,109,59,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2097)
		{ { 69,98,201,154,0 }, { 177,164,140,192,3 }, { 5,153,52,106,2 }, { 192,51,18,88,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2098)
		{ { 180,56,177,59,0 }, { 209,168,162,22,13 }, { 13,200,209,194,13 }, { 182,132,81,88,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2099)
		{ { 131,20,145,146,14 }, { 80,144,193,115,3 }, { 116,152,146,140,1 }, { 204,232,48,144,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2100)
		{ { 255,9,118,5,7 }, { 174,91,96,215,12 }, { 234,6,233,15,15 }, { 62,176,109,167,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2101)
		{ { 76,85,220,22,13 }, { 238,135,197,176,1 }, { 182,131,186,163,2 }, { 128,218,62,23,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2102)
		{ { 104,114,128,201,15 }, { 71,180,105,140,2 }, { 249,48,20,225,6 }, { 67,25,98,222,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2103)
		{ { 118,171,174,160,4 }, { 129,203,126,129,14 }, { 32,87,93,86,14 }, { 120,23,237,56,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2104)
		{ { 145,170,76,41,14 }, { 33,57,95,70,8 }, { 121,67,37,88,9 }, { 22,47,169,200,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2105)
		{ { 172,153,124,202,8 }, { 226,35,53,26,15 }, { 21,51,233,147,5 }, { 245,138,204,68,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2106)
		{ { 14,211,209,214,1 }, { 254,134,152,25,3 }, { 134,184,188,183,0 }, { 201,129,150,23,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2107)
		{ { 186,245,248,135,3 }, { 111,158,52,55,7 }, { 206,17,250,245,13 }, { 238,194,199,159,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2108)
		{ { 24,203,208,54,12 }, { 42,142,219,16,9 }, { 54,192,189,49,8 }, { 144,141,183,21,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2109)
		{ { 230,136,49,122,7 }, { 148,48,242,155,13 }, { 229,232,193,22,7 }, { 189,148,240,194,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2110)
		{ { 38,93,140,24,7 }, { 196,183,228,33,8 }, { 225,131,27,166,4 }, { 24,66,126,210,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2111)
		{ { 37,253,177,16,7 }, { 213,150,240,112,12 }, { 224,136,219,250,4 }, { 48,224,246,154,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2112)
		{ { 46,105,226,33,9 }, { 167,198,35,5,12 }, { 152,68,121,103,4 }, { 58,12,70,62,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2113)
		{ { 148,212,15,127,5 }, { 220,109,214,46,1 }, { 175,239,2,178,9 }, { 135,70,187,99,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2114)
		{ { 104,227,24,161,2 }, { 3,22,62,148,2 }, { 72,81,140,113,6 }, { 66,151,198,140,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2115)
		{ { 115,38,168,12,2 }, { 9,184,44,225,4 }, { 67,1,86,76,14 }, { 40,115,65,217,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2116)
		{ { 8,225,19,56,4 }, { 19,102,210,16,0 }, { 33,204,136,113,0 }, { 0,132,182,108,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2117)
		{ { 30,74,153,58,11 }, { 150,188,143,17,9 }, { 213,201,149,39,8 }, { 152,143,19,214,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2118)
		{ { 56,123,230,193,11 }, { 103,223,41,12,14 }, { 216,54,125,225,12 }, { 115,9,79,190,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2119)
		{ { 23,164,136,165,2 }, { 137,152,22,101,2 }, { 74,81,18,94,8 }, { 74,102,129,153,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2120)
		{ { 100,67,135,200,8 }, { 144,231,41,136,2 }, { 17,62,28,34,6 }, { 65,25,78,112,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2121)
		{ { 110,7,130,143,7 }, { 142,242,104,165,3 }, { 239,20,30,7,6 }, { 202,81,100,247,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2122)
		{ { 184,128,233,2,2 }, { 50,152,52,2,5 }, { 68,9,112,17,13 }, { 164,2,193,148,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2123)
		{ { 62,14,185,83,2 }, { 146,152,172,61,13 }, { 76,169,215,7,12 }, { 187,195,81,148,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2124)
		{ { 143,140,17,176,2 }, { 146,16,146,115,10 }, { 64,216,131,31,1 }, { 92,228,144,132,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2125)
		{ { 27,141,195,155,13 }, { 54,234,209,101,11 }, { 189,156,59,29,8 }, { 218,104,181,118,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2126)
		{ { 238,130,108,30,9 }, { 174,33,189,131,5 }, { 151,131,100,23,7 }, { 172,27,216,71,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2127)
		{ { 149,96,110,240,8 }, { 161,77,135,74,6 }, { 16,247,96,106,9 }, { 101,46,27,40,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2128)
		{ { 80,228,38,86,2 }, { 9,93,144,168,5 }, { 70,166,66,112,10 }, { 161,80,155,169,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2129)
		{ { 212,77,143,180,2 }, { 152,223,134,162,10 }, { 66,223,27,34,11 }, { 84,86,31,177,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2130)
		{ { 5,79,54,9,7 }, { 132,119,72,116,12 }, { 233,6,207,42,0 }, { 50,225,46,226,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2131)
		{ { 165,246,91,233,9 }, { 245,100,63,126,2 }, { 153,125,166,250,5 }, { 71,239,194,106,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2132)
		{ { 246,67,68,234,5 }, { 164,47,106,139,3 }, { 165,114,44,38,15 }, { 205,21,111,66,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2133)
		{ { 85,81,175,40,13 }, { 212,239,71,192,4 }, { 177,79,88,170,10 }, { 32,62,47,114,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2134)
		{ { 27,94,104,63,5 }, { 110,44,206,101,13 }, { 175,193,103,173,8 }, { 186,103,51,71,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2135)
		{ { 6,118,167,222,12 }, { 217,229,201,41,7 }, { 55,190,86,230,0 }, { 233,73,58,121,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2136)
		{ { 70,176,31,231,11 }, { 221,81,23,157,3 }, { 222,127,128,214,2 }, { 203,158,136,171,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2137)
		{ { 38,80,223,195,0 }, { 240,197,36,29,3 }, { 12,63,176,166,4 }, { 203,130,74,48,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2138)
		{ { 52,1,83,23,3 }, { 188,90,160,20,1 }, { 206,140,168,2,12 }, { 130,128,85,163,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2139)
		{ { 185,183,76,10,12 }, { 99,43,125,98,1 }, { 53,3,46,217,13 }, { 132,107,237,76,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2140)
		{ { 103,124,93,21,5 }, { 253,5,228,245,8 }, { 170,139,163,238,6 }, { 26,242,122,11,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2141)
		{ { 62,14,116,210,9 }, { 166,9,169,57,15 }, { 148,178,231,7,12 }, { 249,201,89,6,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2142)
		{ { 135,91,221,123,4 }, { 240,167,206,95,9 }, { 45,235,189,174,1 }, { 159,167,62,80,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2143)
		{ { 243,250,71,202,15 }, { 117,125,121,203,11 }, { 245,62,37,252,15 }, { 221,57,235,234,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2144)
		{ { 215,194,170,201,7 }, { 132,252,92,207,6 }, { 233,53,84,62,11 }, { 111,51,163,242,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2145)
		{ { 9,112,244,98,8 }, { 99,133,3,88,5 }, { 20,98,240,233,0 }, { 161,172,10,28,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2146)
		{ { 49,139,231,50,10 }, { 48,219,187,64,13 }, { 84,206,125,24,12 }, { 176,45,221,176,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2147)
		{ { 250,59,245,187,4 }, { 115,171,234,151,15 }, { 45,218,253,197,15 }, { 254,149,125,92,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2148)
		{ { 119,186,106,0,14 }, { 225,88,125,193,12 }, { 112,5,101,222,14 }, { 56,59,225,168,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2149)
		{ { 245,7,16,43,15 }, { 132,58,107,246,1 }, { 253,64,142,10,15 }, { 134,253,101,194,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2150)
		{ { 55,185,16,190,8 }, { 201,42,179,81,11 }, { 23,208,137,222,12 }, { 216,172,213,73,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2151)
		{ { 154,36,87,204,1 }, { 63,105,0,59,2 }, { 131,62,162,69,9 }, { 77,192,9,111,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2152)
		{ { 86,238,203,19,12 }, { 177,204,221,165,9 }, { 60,141,55,118,10 }, { 154,91,179,56,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2153)
		{ { 19,93,119,167,4 }, { 120,79,66,117,15 }, { 46,94,235,172,8 }, { 250,228,47,33,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2154)
		{ { 13,146,253,48,4 }, { 242,129,222,80,4 }, { 32,203,244,155,0 }, { 32,167,184,20,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2155)
		{ { 237,122,230,34,3 }, { 231,213,42,194,13 }, { 196,70,117,235,7 }, { 180,53,74,190,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2156)
		{ { 141,125,109,37,12 }, { 251,7,71,102,12 }, { 58,75,107,235,1 }, { 54,110,46,13,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2157)
		{ { 120,62,207,103,3 }, { 127,217,46,172,9 }, { 206,111,55,193,14 }, { 147,87,73,191,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2158)
		{ { 62,116,93,252,6 }, { 251,61,230,57,2 }, { 99,251,162,231,12 }, { 73,198,123,205,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2159)
		{ { 188,170,218,5,10 }, { 171,216,61,22,8 }, { 90,5,181,83,13 }, { 22,139,193,189,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2160)
		{ { 13,162,38,20,8 }, { 139,65,153,64,4 }, { 18,134,68,91,0 }, { 32,41,152,45,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2161)
		{ { 134,217,94,7,10 }, { 232,87,21,23,9 }, { 94,7,169,182,1 }, { 158,138,142,161,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2162)
		{ { 37,126,156,27,14 }, { 193,181,237,116,9 }, { 125,131,151,234,4 }, { 146,235,122,216,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2163)
		{ { 221,222,210,16,1 }, { 230,204,152,242,8 }, { 128,132,183,187,11 }, { 20,241,147,54,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2164)
		{ { 233,1,205,160,13 }, { 54,131,103,194,2 }, { 176,91,56,9,7 }, { 68,62,108,22,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2165)
		{ { 119,152,12,57,4 }, { 192,41,246,197,8 }, { 41,195,1,158,14 }, { 26,54,249,64,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2166)
		{ { 209,14,75,139,7 }, { 52,120,76,230,11 }, { 237,29,39,8,11 }, { 214,115,33,226,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2167)
		{ { 226,178,81,251,9 }, { 117,32,187,159,3 }, { 157,248,164,212,7 }, { 207,157,208,74,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2168)
		{ { 108,39,137,18,7 }, { 151,146,236,160,1 }, { 228,137,30,67,6 }, { 128,83,116,158,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2169)
		{ { 78,213,70,229,4 }, { 234,71,82,173,2 }, { 42,118,42,183,2 }, { 75,84,174,37,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2170)
		{ { 240,6,14,244,9 }, { 12,73,175,170,2 }, { 146,247,6,0,15 }, { 69,95,89,35,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2171)
		{ { 179,69,148,196,9 }, { 12,143,33,123,2 }, { 146,50,154,44,13 }, { 77,232,79,19,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2172)
		{ { 183,99,0,71,12 }, { 137,14,105,79,1 }, { 62,32,12,110,13 }, { 143,41,103,9,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2173)
		{ { 124,196,229,3,1 }, { 182,141,48,164,5 }, { 140,10,114,51,14 }, { 162,80,203,22,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2174)
		{ { 86,1,102,16,6 }, { 160,91,192,129,4 }, { 96,134,104,6,10 }, { 40,16,61,160,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2175)
		{ { 82,75,187,242,15 }, { 20,222,207,153,15 }, { 244,253,221,36,10 }, { 249,159,55,178,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2176)
		{ { 142,50,98,30,15 }, { 239,112,201,3,5 }, { 247,132,100,199,1 }, { 172,9,48,239,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2177)
		{ { 66,68,75,195,9 }, { 52,68,5,173,3 }, { 156,61,34,36,2 }, { 203,90,2,34,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2178)
		{ { 139,101,126,225,12 }, { 35,71,71,127,6 }, { 56,119,234,109,1 }, { 111,238,46,44,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2179)
		{ { 53,42,182,84,7 }, { 141,217,232,88,12 }, { 226,166,213,74,12 }, { 49,161,121,187,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2180)
		{ { 231,165,75,233,2 }, { 177,114,54,239,2 }, { 73,125,42,94,7 }, { 79,118,196,232,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2181)
		{ { 120,30,244,21,3 }, { 110,153,168,180,12 }, { 202,130,247,129,14 }, { 50,209,89,151,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2182)
		{ { 50,242,74,129,2 }, { 97,92,60,5,2 }, { 72,21,36,244,12 }, { 74,3,195,168,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2183)
		{ { 40,17,16,119,11 }, { 78,18,163,28,1 }, { 222,224,136,129,4 }, { 131,140,84,135,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2184)
		{ { 37,203,65,84,13 }, { 188,6,249,72,8 }, { 178,168,45,58,4 }, { 17,41,246,3,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2185)
		{ { 167,103,245,103,1 }, { 189,135,42,127,5 }, { 142,106,254,110,5 }, { 175,229,78,27,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2186)
		{ { 91,165,158,70,11 }, { 15,219,21,249,1 }, { 214,39,154,93,10 }, { 137,250,141,191,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2187)
		{ { 88,61,62,106,2 }, { 67,123,6,184,13 }, { 69,103,203,193,10 }, { 177,214,13,236,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2188)
		{ { 191,77,67,125,10 }, { 186,126,163,111,8 }, { 91,236,43,47,13 }, { 31,108,87,229,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2189)
		{ { 160,164,162,247,2 }, { 9,208,178,46,7 }, { 78,244,82,80,5 }, { 231,68,208,185,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2190)
		{ { 93,52,153,184,6 }, { 211,184,198,240,2 }, { 97,217,146,203,10 }, { 64,246,49,220,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2191)
		{ { 211,7,214,157,5 }, { 44,235,200,247,2 }, { 171,150,190,12,11 }, { 78,241,61,115,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2192)
		{ { 155,172,247,16,14 }, { 51,217,209,115,12 }, { 112,142,243,93,9 }, { 60,232,185,188,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2193)
		{ { 196,108,246,252,13 }, { 173,229,195,186,14 }, { 179,246,243,98,3 }, { 117,220,58,123,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2194)
		{ { 184,1,141,118,12 }, { 26,139,231,10,1 }, { 54,235,24,1,13 }, { 133,14,125,21,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2195)
		{ { 232,151,127,181,13 }, { 126,67,255,182,6 }, { 186,223,238,145,7 }, { 102,223,252,39,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2196)
		{ { 11,60,141,188,5 }, { 95,161,198,97,10 }, { 163,219,19,205,0 }, { 88,102,56,95,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2197)
		{ { 20,20,133,139,8 }, { 208,169,1,36,3 }, { 29,26,18,130,8 }, { 194,72,9,80,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2198)
		{ { 115,104,16,10,4 }, { 1,44,96,209,9 }, { 37,0,129,108,14 }, { 152,176,99,72,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2199)
		{ { 18,132,134,239,3 }, { 12,249,18,45,3 }, { 207,118,18,20,8 }, { 203,68,137,243,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2200)
		{ { 210,252,86,125,0 }, { 105,109,146,191,8 }, { 11,230,163,244,11 }, { 31,212,155,105,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2201)
		{ { 91,207,66,130,14 }, { 34,94,89,225,11 }, { 116,20,47,61,10 }, { 216,121,167,164,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2202)
		{ { 73,183,123,167,3 }, { 127,82,30,244,7 }, { 206,93,238,217,2 }, { 226,247,132,175,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2203)
		{ { 97,229,12,169,15 }, { 5,55,119,228,2 }, { 249,83,10,120,6 }, { 66,126,238,202,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2204)
		{ { 28,221,19,226,0 }, { 210,78,18,56,11 }, { 4,124,139,179,8 }, { 209,196,135,36,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2205)
		{ { 241,23,253,83,15 }, { 116,155,237,254,5 }, { 252,171,254,136,15 }, { 167,251,125,146,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2206)
		{ { 141,51,92,19,13 }, { 231,3,205,86,1 }, { 188,131,172,203,1 }, { 134,171,60,14,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2207)
		{ { 248,223,155,48,4 }, { 82,206,254,178,8 }, { 32,205,159,177,15 }, { 20,215,247,52,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2208)
		{ { 205,115,59,196,0 }, { 219,70,12,218,6 }, { 2,61,204,235,3 }, { 101,179,6,45,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2209)
		{ { 35,29,150,151,9 }, { 76,195,161,117,11 }, { 158,150,155,140,4 }, { 218,232,92,51,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2210)
		{ { 44,151,177,71,6 }, { 218,146,120,60,5 }, { 110,40,222,147,4 }, { 163,193,228,149,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2211)
		{ { 230,105,156,80,1 }, { 133,135,164,155,8 }, { 128,163,153,102,7 }, { 29,146,94,26,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2212)
		{ { 181,161,208,86,14 }, { 169,154,241,90,1 }, { 118,160,184,90,13 }, { 133,168,245,153,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2213)
		{ { 60,125,33,88,4 }, { 211,46,224,40,12 }, { 33,168,75,227,12 }, { 49,64,119,76,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2214)
		{ { 173,20,11,20,5 }, { 222,64,228,98,0 }, { 162,141,2,139,5 }, { 4,98,112,39,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2215)
		{ { 251,9,110,114,3 }, { 38,91,166,203,13 }, { 196,231,105,13,15 }, { 189,54,93,166,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2216)
		{ { 23,132,105,191,13 }, { 188,40,215,101,7 }, { 191,217,98,30,8 }, { 234,110,177,67,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2217)
		{ { 36,48,61,47,6 }, { 217,49,102,20,5 }, { 111,75,192,194,4 }, { 162,134,104,201,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2218)
		{ { 235,214,231,21,5 }, { 126,197,248,231,4 }, { 170,142,118,189,7 }, { 46,113,250,55,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2219)
		{ { 147,91,170,215,11 }, { 76,222,141,79,15 }, { 222,181,93,172,9 }, { 255,43,23,179,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2220)
		{ { 209,95,34,205,13 }, { 76,110,73,238,14 }, { 187,52,79,168,11 }, { 119,121,39,99,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2221)
		{ { 55,178,213,83,15 }, { 245,153,249,93,1 }, { 252,170,180,222,12 }, { 139,169,249,154,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2222)
		{ { 211,101,213,98,8 }, { 49,143,3,251,1 }, { 20,106,186,108,11 }, { 141,252,15,24,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2223)
		{ { 29,118,183,146,15 }, { 215,221,201,112,7 }, { 244,158,214,235,8 }, { 224,233,59,190,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2224)
		{ { 87,185,126,171,11 }, { 229,123,23,213,15 }, { 221,87,233,222,10 }, { 250,190,141,234,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2225)
		{ { 9,11,171,164,4 }, { 26,194,78,64,14 }, { 34,93,93,9,0 }, { 112,39,36,53,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2226)
		{ { 163,131,97,118,11 }, { 60,18,187,75,5 }, { 214,232,108,28,5 }, { 173,45,212,131,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2227)
		{ { 156,250,125,156,6 }, { 251,61,220,18,14 }, { 99,155,229,243,9 }, { 116,131,187,205,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2228)
		{ { 76,134,94,122,15 }, { 166,113,223,184,1 }, { 245,231,166,19,2 }, { 129,223,184,230,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2229)
		{ { 249,13,22,148,11 }, { 14,91,161,242,10 }, { 210,150,139,9,15 }, { 84,248,93,167,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2230)
		{ { 120,93,12,212,1 }, { 78,15,164,168,10 }, { 130,179,11,161,14 }, { 81,82,95,7,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2231)
		{ { 51,98,95,192,1 }, { 53,77,44,89,2 }, { 128,63,164,108,12 }, { 73,163,75,42,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2232)
		{ { 0,213,240,148,3 }, { 108,150,144,48,6 }, { 194,144,250,176,0 }, { 96,192,150,147,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2233)
		{ { 167,185,175,176,8 }, { 209,195,183,67,14 }, { 16,223,89,222,5 }, { 124,46,220,56,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2234)
		{ { 223,59,151,88,10 }, { 211,251,137,219,8 }, { 81,174,157,207,11 }, { 29,185,29,252,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2235)
		{ { 182,138,31,89,2 }, { 144,121,188,31,8 }, { 73,175,133,22,13 }, { 31,131,217,224,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2236)
		{ { 103,50,106,212,0 }, { 233,64,172,201,6 }, { 2,181,100,206,6 }, { 105,51,80,41,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2237)
		{ { 7,184,90,134,3 }, { 237,80,20,81,11 }, { 198,21,161,222,0 }, { 216,162,128,171,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2238)
		{ { 37,38,25,247,15 }, { 157,16,239,124,3 }, { 254,249,134,74,4 }, { 195,239,112,139,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2239)
		{ { 130,206,71,104,3 }, { 52,117,26,43,8 }, { 193,110,39,52,1 }, { 29,69,138,226,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2240)
		{ { 108,230,33,121,12 }, { 147,36,251,172,4 }, { 57,232,70,115,6 }, { 35,93,242,76,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2241)
		{ { 98,230,221,55,8 }, { 57,133,191,181,1 }, { 30,203,182,116,6 }, { 138,223,218,25,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2242)
		{ { 62,92,11,17,10 }, { 210,92,165,37,8 }, { 88,141,3,167,12 }, { 26,74,83,164,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2243)
		{ { 57,245,112,80,8 }, { 99,14,177,120,4 }, { 16,160,234,249,12 }, { 33,232,215,12,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2244)
		{ { 214,87,51,142,6 }, { 216,126,72,179,7 }, { 103,28,206,166,11 }, { 236,209,39,225,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2245)
		{ { 192,98,168,92,12 }, { 9,164,205,138,4 }, { 51,161,84,96,3 }, { 37,27,50,89,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2246)
		{ { 131,220,0,222,5 }, { 76,36,208,107,11 }, { 167,176,3,188,1 }, { 221,96,178,67,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2247)
		{ { 177,33,195,250,3 }, { 53,250,162,74,3 }, { 197,252,56,72,13 }, { 197,36,85,250,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2248)
		{ { 227,149,10,113,14 }, { 64,82,247,239,0 }, { 120,229,10,156,7 }, { 15,126,244,160,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2249)
		{ { 113,29,253,190,8 }, { 120,171,167,240,15 }, { 23,219,251,136,14 }, { 240,254,93,81,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2250)
		{ { 130,171,112,191,2 }, { 41,50,154,23,15 }, { 79,208,237,84,1 }, { 254,133,148,201,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2251)
		{ { 93,123,132,66,1 }, { 199,143,8,200,9 }, { 132,34,29,235,10 }, { 145,49,15,30,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2252)
		{ { 103,239,52,200,12 }, { 129,39,121,249,14 }, { 49,50,207,126,6 }, { 121,249,238,72,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2253)
		{ { 202,53,231,230,13 }, { 127,195,67,171,7 }, { 182,126,122,197,3 }, { 237,92,44,63,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2254)
		{ { 36,1,77,111,11 }, { 188,51,39,12,1 }, { 223,107,40,2,4 }, { 131,14,76,195,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2255)
		{ { 183,239,157,161,14 }, { 145,159,127,119,10 }, { 120,91,159,126,13 }, { 94,239,239,152,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2256)
		{ { 176,76,172,188,7 }, { 12,189,230,34,14 }, { 227,211,83,32,13 }, { 116,70,123,211,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2257)
		{ { 193,166,3,154,8 }, { 17,96,153,226,3 }, { 21,156,6,88,3 }, { 196,121,144,104,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2258)
		{ { 197,1,82,163,10 }, { 160,82,3,214,3 }, { 92,84,168,10,3 }, { 198,188,4,160,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2259)
		{ { 220,202,43,43,7 }, { 150,124,94,134,13 }, { 237,77,69,51,11 }, { 182,23,163,230,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2260)
		{ { 88,6,54,143,3 }, { 14,121,8,180,7 }, { 207,22,198,1,10 }, { 226,209,9,231,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2261)
		{ { 139,223,114,151,10 }, { 106,86,153,119,15 }, { 94,148,239,189,1 }, { 254,233,150,165,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2262)
		{ { 118,72,225,171,10 }, { 176,188,35,133,15 }, { 93,88,113,38,14 }, { 250,28,67,208,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2263)
		{ { 224,20,244,247,7 }, { 108,145,226,190,7 }, { 238,242,242,128,7 }, { 231,212,120,147,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2264)
		{ { 113,170,60,249,0 }, { 1,41,190,220,14 }, { 9,243,197,88,14 }, { 115,183,217,72,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2265)
		{ { 156,171,243,108,14 }, { 187,250,91,26,12 }, { 115,108,253,83,9 }, { 53,141,165,253,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2266)
		{ { 135,84,73,90,15 }, { 244,52,197,107,1 }, { 245,169,34,174,1 }, { 141,106,50,194,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2267)
		{ { 154,153,213,71,2 }, { 122,155,16,31,9 }, { 78,42,185,149,9 }, { 159,128,141,149,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2268)
		{ { 231,44,187,69,6 }, { 153,208,100,255,12 }, { 106,45,211,78,7 }, { 63,242,96,185,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2269)
		{ { 196,176,203,147,1 }, { 245,192,148,134,3 }, { 140,157,48,210,3 }, { 198,18,144,58,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2270)
		{ { 137,237,4,93,7 }, { 15,55,208,110,8 }, { 235,162,11,121,1 }, { 23,96,190,207,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2271)
		{ { 199,169,10,58,11 }, { 133,114,151,195,9 }, { 213,197,9,94,3 }, { 156,62,148,234,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2272)
		{ { 65,90,235,196,2 }, { 120,212,12,200,14 }, { 66,61,117,168,2 }, { 113,51,2,177,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2273)
		{ { 127,85,215,48,2 }, { 242,223,162,241,0 }, { 64,206,186,175,14 }, { 8,244,95,180,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2274)
		{ { 17,75,16,122,6 }, { 0,62,202,88,9 }, { 101,224,141,40,8 }, { 145,165,55,192,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2275)
		{ { 230,235,111,39,4 }, { 185,71,126,135,13 }, { 46,79,109,118,7 }, { 190,23,238,41,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2276)
		{ { 132,244,176,135,15 }, { 205,148,81,54,7 }, { 254,16,210,242,1 }, { 230,200,162,155,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2277)
		{ { 91,222,44,8,8 }, { 66,45,29,225,12 }, { 17,3,71,189,10 }, { 56,123,139,68,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2278)
		{ { 205,253,149,194,7 }, { 215,151,80,250,11 }, { 228,58,155,251,3 }, { 213,240,174,158,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2279)
		{ { 51,193,37,123,3 }, { 20,63,178,77,5 }, { 205,234,72,60,12 }, { 171,36,223,194,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2280)
		{ { 99,27,71,141,15 }, { 124,115,105,197,10 }, { 251,30,45,140,6 }, { 90,57,108,227,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2281)
		{ { 229,239,80,81,11 }, { 165,22,185,254,8 }, { 216,160,175,122,7 }, { 23,249,214,138,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2282)
		{ { 65,141,160,190,12 }, { 8,162,211,224,15 }, { 55,208,91,24,2 }, { 240,124,180,81,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2283)
		{ { 193,184,36,139,1 }, { 69,33,16,198,15 }, { 141,18,65,216,3 }, { 246,48,136,74,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2284)
		{ { 118,222,87,133,11 }, { 252,93,57,181,10 }, { 218,30,167,182,14 }, { 90,217,203,163,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2285)
		{ { 219,201,87,218,6 }, { 50,127,208,219,11 }, { 101,190,169,61,11 }, { 221,176,191,228,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2286)
		{ { 202,225,244,5,4 }, { 43,135,80,151,4 }, { 42,2,248,117,3 }, { 46,144,174,29,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2287)
		{ { 145,76,36,42,2 }, { 0,61,2,98,13 }, { 69,66,67,40,9 }, { 180,100,11,192,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2288)
		{ { 69,163,208,168,2 }, { 161,178,26,208,2 }, { 65,80,188,90,2 }, { 64,181,132,216,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2289)
		{ { 136,154,125,93,13 }, { 126,33,221,30,12 }, { 187,171,229,145,1 }, { 55,139,184,71,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2290)
		{ { 154,61,179,211,2 }, { 83,218,128,63,15 }, { 76,188,219,197,9 }, { 255,192,21,188,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2291)
		{ { 208,44,134,112,15 }, { 5,217,195,170,8 }, { 240,230,19,64,11 }, { 21,92,57,186,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2292)
		{ { 21,123,52,80,12 }, { 193,15,201,88,12 }, { 48,162,205,234,8 }, { 49,169,63,8,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2293)
		{ { 137,13,55,91,10 }, { 18,115,129,126,13 }, { 93,174,203,9,1 }, { 183,232,28,228,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2294)
		{ { 137,27,201,59,10 }, { 114,178,143,70,9 }, { 93,201,61,137,1 }, { 150,47,20,212,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2295)
		{ { 138,2,216,10,3 }, { 38,176,12,19,1 }, { 197,1,180,5,1 }, { 140,131,0,214,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2296)
		{ { 30,93,243,65,14 }, { 242,222,65,61,12 }, { 120,44,251,167,8 }, { 59,200,39,180,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2297)
		{ { 120,109,137,131,2 }, { 19,158,36,164,11 }, { 76,25,27,97,14 }, { 210,82,71,156,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2298)
		{ { 172,247,228,126,13 }, { 239,167,251,42,5 }, { 183,226,126,243,5 }, { 165,77,254,95,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2299)
		{ { 28,22,226,90,0 }, { 226,232,136,40,5 }, { 5,164,118,131,8 }, { 161,65,17,116,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2300)
		{ { 46,169,4,13,9 }, { 143,35,49,5,8 }, { 155,2,9,87,4 }, { 26,8,204,79,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2301)
		{ { 243,38,138,238,5 }, { 13,232,110,235,3 }, { 167,117,22,76,15 }, { 205,119,97,123,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2302)
		{ { 128,232,75,204,11 }, { 61,116,21,10,10 }, { 211,61,33,112,1 }, { 85,10,130,235,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2303)
		{ { 162,190,211,245,12 }, { 121,192,251,63,10 }, { 58,252,183,212,5 }, { 95,205,240,57,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2304)
		{ { 179,172,4,251,2 }, { 1,57,178,111,11 }, { 77,242,3,92,13 }, { 223,100,217,200,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2305)
		{ { 132,89,129,25,2 }, { 208,182,128,6,8 }, { 73,136,25,162,1 }, { 22,0,22,208,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2306)
		{ { 96,167,159,201,4 }, { 17,227,124,188,2 }, { 41,63,158,80,6 }, { 67,211,236,120,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2307)
		{ { 19,143,250,197,9 }, { 44,202,29,125,14 }, { 154,53,255,28,8 }, { 123,235,133,51,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2308)
		{ { 214,125,112,144,3 }, { 229,30,128,179,14 }, { 192,144,235,230,11 }, { 124,208,23,138,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2309)
		{ { 43,138,160,242,5 }, { 6,128,250,73,15 }, { 164,240,85,29,4 }, { 249,37,240,22,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2310)
		{ { 41,131,176,59,10 }, { 2,178,187,84,5 }, { 93,192,220,25,4 }, { 162,173,212,212,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2311)
		{ { 140,215,81,28,8 }, { 250,38,153,50,0 }, { 19,136,174,179,1 }, { 4,201,150,69,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2312)
		{ { 47,222,77,2,12 }, { 242,5,125,97,9 }, { 52,11,39,191,4 }, { 152,107,234,4,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2313)
		{ { 213,4,207,5,12 }, { 184,201,69,230,0 }, { 58,15,50,10,11 }, { 6,122,41,49,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2314)
		{ { 186,231,214,153,0 }, { 35,239,184,55,2 }, { 9,150,190,117,13 }, { 78,193,223,124,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2315)
		{ { 156,243,126,164,13 }, { 239,79,95,18,6 }, { 178,87,236,243,9 }, { 100,143,175,47,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2316)
		{ { 143,79,97,177,14 }, { 178,22,203,103,14 }, { 120,216,111,47,1 }, { 126,109,54,132,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2317)
		{ { 137,255,175,206,6 }, { 91,247,92,106,15 }, { 103,63,95,249,1 }, { 245,99,174,253,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2318)
		{ { 124,126,177,202,2 }, { 211,188,40,184,15 }, { 69,56,215,227,14 }, { 241,209,67,220,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2319)
		{ { 150,194,61,167,11 }, { 156,29,31,23,7 }, { 222,91,196,54,9 }, { 238,143,139,131,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2320)
	#error invalid ARUCO_DB_SIZE, max database size for this aruco type is 2320
	#endif

};

#elif (ARUCO_DB == ARUCO_DB_APRILTAG_36h11)

#ifndef ARUCO_DB_SIZE
#define ARUCO_DB_SIZE 587
#endif

#define ARUCO_BITS	6

static unsigned char database[ARUCO_DB_SIZE][4][5] = {
	#if (ARUCO_DB_SIZE > 0)
		{ { 33,161,70,186,11 }, { 37,115,179,64,3 }, { 213,214,40,88,4 }, { 192,44,220,234,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 1)
		{ { 146,209,143,233,11 }, { 84,255,23,15,2 }, { 217,127,24,180,9 }, { 79,14,143,242,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 2)
		{ { 112,137,1,75,11 }, { 20,58,49,140,9 }, { 221,40,9,16,14 }, { 147,24,197,194,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 3)
		{ { 25,57,121,226,7 }, { 119,26,70,88,15 }, { 228,121,233,201,8 }, { 241,166,37,142,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 4)
		{ { 68,21,61,61,7 }, { 220,51,198,180,4 }, { 235,203,202,130,2 }, { 34,214,60,195,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 5)
		{ { 53,205,91,140,15 }, { 188,126,117,112,10 }, { 243,29,171,58,12 }, { 80,234,231,227,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 6)
		{ { 161,11,165,106,0 }, { 16,163,42,74,13 }, { 5,106,93,8,5 }, { 181,37,76,80,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 7)
		{ { 43,135,74,96,8 }, { 34,66,63,105,0 }, { 16,101,46,29,4 }, { 9,111,196,36,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 8)
		{ { 181,127,184,212,4 }, { 201,142,236,122,14 }, { 34,177,223,234,13 }, { 117,227,119,25,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 9)
		{ { 78,32,181,166,4 }, { 155,129,66,145,7 }, { 38,90,208,71,2 }, { 232,148,40,29,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 10)
		{ { 97,216,151,242,12 }, { 80,197,243,216,11 }, { 52,254,145,184,6 }, { 209,188,250,48,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 11)
		{ { 171,52,105,255,12 }, { 123,32,231,111,7 }, { 63,249,98,205,5 }, { 239,110,112,77,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 12)
		{ { 89,76,164,92,2 }, { 10,189,128,232,12 }, { 67,162,83,41,10 }, { 49,112,27,213,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 13)
		{ { 250,28,45,46,2 }, { 90,57,38,163,13 }, { 71,75,67,133,15 }, { 188,86,73,197,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 14)
		{ { 151,194,75,151,2 }, { 184,92,156,71,3 }, { 78,157,36,62,9 }, { 206,35,147,161,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 15)
		{ { 117,146,134,36,10 }, { 200,217,59,192,0 }, { 82,70,20,154,14 }, { 0,61,201,177,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 16)
		{ { 28,170,254,153,10 }, { 163,249,157,20,14 }, { 89,151,245,83,8 }, { 114,139,153,252,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 17)
		{ { 50,54,221,193,6 }, { 113,153,108,61,2 }, { 104,59,182,196,12 }, { 75,195,105,152,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 18)
		{ { 136,78,82,125,6 }, { 42,116,202,62,8 }, { 107,228,167,33,1 }, { 23,197,50,229,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 19)
		{ { 87,113,168,199,14 }, { 201,158,69,205,7 }, { 126,49,88,238,10 }, { 235,58,39,153,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 20)
		{ { 245,41,37,184,1 }, { 149,43,162,194,14 }, { 129,218,73,74,15 }, { 116,52,93,74,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 21)
		{ { 46,89,204,26,1 }, { 230,167,164,1,9 }, { 133,131,57,167,4 }, { 152,2,94,86,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 22)
		{ { 127,165,138,179,1 }, { 135,202,182,229,3 }, { 140,213,26,95,14 }, { 202,118,213,62,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 23)
		{ { 235,67,56,79,9 }, { 14,38,45,223,5 }, { 159,33,204,45,7 }, { 175,187,70,71,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 24)
		{ { 57,19,213,52,5 }, { 126,139,234,80,0 }, { 162,202,188,137,12 }, { 0,165,125,23,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 25)
		{ { 215,155,26,59,5 }, { 196,106,222,215,9 }, { 173,197,141,158,11 }, { 158,183,181,98,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 26)
		{ { 13,251,231,104,13 }, { 247,231,91,72,12 }, { 177,110,125,251,0 }, { 49,45,174,126,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 27)
		{ { 92,215,160,49,13 }, { 198,142,219,164,4 }, { 184,192,94,179,10 }, { 34,93,183,22,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 28)
		{ { 185,200,247,164,11 }, { 62,221,51,82,14 }, { 210,94,241,57,13 }, { 116,172,203,183,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 29)
		{ { 70,152,126,6,11 }, { 236,81,21,145,13 }, { 214,7,225,150,2 }, { 184,154,136,163,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 30)
		{ { 110,12,93,82,7 }, { 182,17,228,185,9 }, { 228,171,163,7,6 }, { 153,210,120,134,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 31)
		{ { 91,197,103,187,4 }, { 50,111,210,229,7 }, { 45,222,106,61,10 }, { 234,116,191,100,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 32)
		{ { 30,99,2,188,2 }, { 139,126,138,1,2 }, { 67,212,12,103,8 }, { 72,5,23,237,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 33)
		{ { 138,199,208,70,10 }, { 42,150,25,59,1 }, { 86,32,190,53,1 }, { 141,201,134,149,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 34)
		{ { 166,95,226,50,6 }, { 224,214,234,35,13 }, { 100,196,127,166,5 }, { 188,69,118,176,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 35)
		{ { 84,0,235,97,6 }, { 176,216,70,140,4 }, { 104,109,112,2,10 }, { 35,22,33,176,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 36)
		{ { 247,160,102,131,6 }, { 161,89,112,199,7 }, { 108,22,96,94,15 }, { 238,48,233,168,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 37)
		{ { 45,208,175,223,6 }, { 218,245,244,76,7 }, { 111,191,80,187,4 }, { 227,34,250,245,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 38)
		{ { 59,156,182,11,1 }, { 70,233,48,117,13 }, { 141,6,211,157,12 }, { 186,224,201,118,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 39)
		{ { 173,106,28,175,9 }, { 143,37,47,86,11 }, { 159,83,133,107,5 }, { 214,175,74,79,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 40)
		{ { 147,182,46,251,5 }, { 69,105,222,111,7 }, { 173,247,70,220,9 }, { 239,103,185,106,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 41)
		{ { 187,33,13,147,13 }, { 23,11,229,71,3 }, { 188,155,8,77,13 }, { 206,42,125,14,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 42)
		{ { 222,229,80,148,11 }, { 175,30,145,179,2 }, { 210,144,170,119,11 }, { 76,216,151,143,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 43)
		{ { 160,205,20,121,11 }, { 4,55,179,62,8 }, { 217,226,139,48,5 }, { 23,204,222,194,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 44)
		{ { 42,35,171,178,7 }, { 23,210,238,1,7 }, { 228,221,92,69,4 }, { 232,7,116,190,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 45)
		{ { 79,103,244,181,15 }, { 175,151,203,245,6 }, { 250,210,254,111,2 }, { 106,253,62,159,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 46)
		{ { 88,168,21,129,8 }, { 19,9,17,148,10 }, { 24,26,129,81,10 }, { 82,152,137,12,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 47)
		{ { 116,52,39,214,4 }, { 217,73,224,168,7 }, { 38,190,66,194,14 }, { 225,80,121,41,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 48)
		{ { 29,236,64,135,4 }, { 171,12,80,100,11 }, { 46,16,35,123,8 }, { 210,96,163,13,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 49)
		{ { 137,42,179,160,2 }, { 19,208,10,82,14 }, { 64,92,213,73,1 }, { 116,165,0,188,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 50)
		{ { 56,213,116,46,14 }, { 106,63,115,48,5 }, { 119,66,234,177,12 }, { 160,204,239,197,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 51)
		{ { 12,67,86,122,1 }, { 166,103,138,24,1 }, { 133,230,172,35,0 }, { 129,133,30,102,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 52)
		{ { 93,179,17,203,1 }, { 215,42,24,220,3 }, { 141,56,140,219,10 }, { 195,177,133,78,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 53)
		{ { 201,87,202,31,9 }, { 110,230,141,230,1 }, { 159,133,62,169,3 }, { 134,123,22,119,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 54)
		{ { 162,36,87,130,3 }, { 53,81,32,51,3 }, { 196,30,162,68,5 }, { 204,192,72,170,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 55)
		{ { 41,172,233,143,3 }, { 63,176,52,100,15 }, { 207,25,115,89,4 }, { 242,98,192,223,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 56)
		{ { 204,197,44,82,8 }, { 130,7,149,170,5 }, { 20,163,74,51,3 }, { 165,90,158,4,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 57)
		{ { 218,139,53,120,12 }, { 18,43,219,155,12 }, { 49,234,205,21,11 }, { 61,157,189,68,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 58)
		{ { 213,180,185,227,6 }, { 209,152,86,254,7 }, { 108,121,210,218,11 }, { 231,246,161,152,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 59)
		{ { 172,156,221,60,14 }, { 250,177,247,50,8 }, { 115,203,179,147,5 }, { 20,206,248,213,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 60)
		{ { 203,218,168,57,1 }, { 70,164,158,199,12 }, { 137,193,85,189,3 }, { 62,55,146,86,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 61)
		{ { 25,134,37,107,1 }, { 22,41,26,108,5 }, { 141,106,70,25,8 }, { 163,101,137,70,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 62)
		{ { 186,230,204,136,9 }, { 39,173,61,35,2 }, { 145,19,54,117,13 }, { 76,75,203,94,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 63)
		{ { 223,145,177,14,5 }, { 222,170,80,211,5 }, { 167,8,216,159,11 }, { 172,176,165,87,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 64)
		{ { 161,169,213,167,5 }, { 61,131,114,86,11 }, { 174,90,185,88,5 }, { 214,164,236,27,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 65)
		{ { 43,101,26,169,13 }, { 7,102,103,117,2 }, { 185,85,138,109,4 }, { 74,238,102,110,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 66)
		{ { 77,92,46,25,13 }, { 198,101,197,228,12 }, { 185,135,67,171,2 }, { 50,122,58,102,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 67)
		{ { 91,22,55,54,11 }, { 94,89,139,241,5 }, { 214,206,198,141,10 }, { 168,253,25,167,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 68)
		{ { 247,83,214,10,8 }, { 224,239,41,211,1 }, { 21,6,188,174,15 }, { 140,185,79,112,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 69)
		{ { 94,132,179,125,2 }, { 154,248,146,189,4 }, { 75,236,210,23,10 }, { 43,212,145,245,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 70)
		{ { 252,228,58,159,2 }, { 139,124,180,182,7 }, { 79,149,194,115,15 }, { 230,210,211,237,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 71)
		{ { 187,146,109,26,6 }, { 114,57,252,67,5 }, { 101,139,100,157,13 }, { 172,35,249,196,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 72)
		{ { 237,141,35,110,5 }, { 158,98,114,234,13 }, { 167,108,75,27,7 }, { 181,116,228,103,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 73)
		{ { 106,248,70,243,7 }, { 103,85,242,141,11 }, { 236,246,33,245,6 }, { 219,20,250,174,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 74)
		{ { 234,86,165,19,8 }, { 82,133,169,167,5 }, { 28,138,86,165,7 }, { 174,89,90,20,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 75)
		{ { 93,73,113,70,12 }, { 186,14,65,216,13 }, { 54,40,233,43,10 }, { 177,184,39,5,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 76)
		{ { 71,3,96,236,10 }, { 168,50,11,201,6 }, { 83,112,108,14,2 }, { 105,61,4,193,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 77)
		{ { 140,75,205,103,10 }, { 186,151,15,14,9 }, { 94,107,61,35,1 }, { 151,15,14,149,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 78)
		{ { 41,95,57,1,14 }, { 82,22,109,116,12 }, { 120,9,207,169,4 }, { 50,235,102,132,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 79)
		{ { 246,181,119,233,7 }, { 245,123,114,191,6 }, { 233,126,234,214,15 }, { 111,212,237,234,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 80)
		{ { 82,6,2,245,10 }, { 8,88,139,173,2 }, { 90,244,6,4,10 }, { 75,93,17,161,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 81)
		{ { 181,17,148,146,14 }, { 192,155,225,82,3 }, { 116,146,152,138,13 }, { 196,168,125,144,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 82)
		{ { 72,226,153,171,7 }, { 23,180,94,148,3 }, { 237,89,148,113,2 }, { 194,151,162,222,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 83)
		{ { 183,159,87,55,10 }, { 248,91,187,119,9 }, { 94,206,175,158,13 }, { 158,237,221,161,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 84)
		{ { 168,20,198,131,14 }, { 98,209,97,38,3 }, { 124,22,50,129,5 }, { 198,72,104,180,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 85)
		{ { 45,169,0,88,3 }, { 135,50,176,72,8 }, { 193,160,9,91,4 }, { 17,32,212,206,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 86)
		{ { 212,171,164,121,7 }, { 133,187,218,142,12 }, { 233,226,93,82,11 }, { 55,21,189,218,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 87)
		{ { 152,42,14,101,12 }, { 11,73,79,14,8 }, { 58,103,5,65,9 }, { 23,15,41,45,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 88)
		{ { 244,128,204,193,5 }, { 164,137,116,142,2 }, { 168,51,48,18,15 }, { 71,18,233,18,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 89)
		{ { 11,32,234,115,2 }, { 35,208,134,77,5 }, { 76,229,112,77,0 }, { 171,38,16,188,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 90)
		{ { 169,80,103,16,10 }, { 114,85,161,66,4 }, { 80,142,96,169,5 }, { 36,40,90,164,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 91)
		{ { 4,134,226,238,1 }, { 172,224,26,40,7 }, { 135,116,118,18,0 }, { 225,69,128,115,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 92)
		{ { 176,169,114,97,5 }, { 37,74,114,30,12 }, { 168,100,233,80,13 }, { 55,132,229,42,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 93)
		{ { 231,63,58,37,7 }, { 205,82,110,247,12 }, { 234,69,207,206,7 }, { 62,247,100,171,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 94)
		{ { 23,226,5,185,8 }, { 145,45,155,69,2 }, { 25,218,4,126,8 }, { 74,45,155,72,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 95)
		{ { 236,154,178,178,4 }, { 194,192,250,146,15 }, { 36,212,213,147,7 }, { 244,149,240,52,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 96)
		{ { 217,51,158,7,6 }, { 75,219,76,214,1 }, { 110,7,156,201,11 }, { 134,179,45,189,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 97)
		{ { 235,136,116,249,9 }, { 38,33,179,223,14 }, { 153,242,225,29,7 }, { 127,188,216,70,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 98)
		{ { 148,32,165,92,12 }, { 153,169,193,10,4 }, { 51,170,80,66,9 }, { 37,8,57,89,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 99)
		{ { 227,100,255,153,2 }, { 49,245,164,247,6 }, { 73,159,242,108,7 }, { 110,242,90,248,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 100)
		{ { 138,76,184,240,10 }, { 2,148,135,59,14 }, { 80,241,211,37,1 }, { 125,206,18,148,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 101)
		{ { 247,42,238,118,6 }, { 169,217,238,203,13 }, { 102,231,117,78,15 }, { 189,55,121,185,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 102)
		{ { 115,204,107,86,9 }, { 60,76,181,233,13 }, { 150,173,99,60,14 }, { 185,122,211,35,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 103)
		{ { 201,156,166,165,9 }, { 78,193,19,230,14 }, { 154,86,83,153,3 }, { 118,124,136,55,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 104)
		{ { 54,106,12,83,5 }, { 133,13,236,13,9 }, { 172,163,5,102,12 }, { 155,3,123,10,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 105)
		{ { 80,158,81,148,3 }, { 124,24,152,176,10 }, { 194,152,167,144,10 }, { 80,209,145,131,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 106)
		{ { 186,109,34,125,1 }, { 15,110,162,47,12 }, { 139,228,75,101,13 }, { 63,68,87,111,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 107)
		{ { 210,172,241,99,11 }, { 53,152,19,191,13 }, { 220,104,243,84,11 }, { 191,220,129,154,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 108)
		{ { 217,137,254,246,8 }, { 42,203,151,218,15 }, { 22,247,249,25,11 }, { 245,190,157,53,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 109)
		{ { 100,23,7,187,2 }, { 208,115,170,164,3 }, { 77,222,14,130,6 }, { 194,85,92,224,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 110)
		{ { 249,189,49,42,11 }, { 87,58,51,242,13 }, { 213,72,203,217,15 }, { 180,252,197,206,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 111)
		{ { 119,115,156,32,7 }, { 197,159,110,209,0 }, { 224,67,156,238,14 }, { 8,183,111,154,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 112)
		{ { 104,191,141,27,15 }, { 87,179,253,164,9 }, { 253,139,31,209,6 }, { 146,91,252,222,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 113)
		{ { 222,221,132,166,14 }, { 202,159,83,163,11 }, { 118,82,27,183,11 }, { 220,92,175,149,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 114)
		{ { 66,234,236,73,11 }, { 37,181,29,141,12 }, { 217,35,117,116,2 }, { 59,27,138,218,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 115)
		{ { 48,43,104,213,3 }, { 45,26,172,12,14 }, { 202,177,109,64,12 }, { 115,3,85,139,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 116)
		{ { 78,187,147,12,14 }, { 219,242,89,145,8 }, { 115,12,157,215,2 }, { 24,153,164,253,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 117)
		{ { 67,156,93,155,5 }, { 116,33,212,245,11 }, { 173,155,163,156,2 }, { 218,242,184,66,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 118)
		{ { 225,252,146,40,13 }, { 69,228,115,242,8 }, { 177,68,147,248,7 }, { 20,252,226,122,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 119)
		{ { 248,166,168,212,10 }, { 11,152,189,170,6 }, { 82,177,86,81,15 }, { 101,91,209,157,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 120)
		{ { 181,57,2,161,8 }, { 193,74,35,70,10 }, { 24,84,9,202,13 }, { 86,44,69,40,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 121)
		{ { 177,99,71,94,14 }, { 57,127,233,74,1 }, { 119,174,44,104,13 }, { 133,41,127,233,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 122)
		{ { 173,47,90,242,9 }, { 167,66,175,122,11 }, { 148,245,175,75,5 }, { 213,239,84,46,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 123)
		{ { 170,181,220,133,0 }, { 107,131,52,55,2 }, { 10,19,186,213,5 }, { 78,194,204,29,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 124)
		{ { 179,236,37,120,6 }, { 17,61,242,107,12 }, { 97,234,67,124,13 }, { 61,100,251,200,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 125)
		{ { 71,153,196,64,5 }, { 228,131,80,201,8 }, { 160,34,57,158,2 }, { 25,48,172,18,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 126)
		{ { 139,198,141,192,4 }, { 18,133,92,107,2 }, { 32,59,22,61,1 }, { 77,99,170,20,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 127)
		{ { 112,47,21,221,14 }, { 25,59,233,188,10 }, { 123,186,143,64,14 }, { 83,217,125,201,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 128)
		{ { 180,34,147,218,9 }, { 149,232,169,26,3 }, { 149,188,148,66,13 }, { 197,137,81,122,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 129)
		{ { 26,202,208,56,2 }, { 34,188,154,17,8 }, { 65,192,181,53,8 }, { 24,133,147,212,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 130)
		{ { 129,51,99,151,1 }, { 125,66,136,70,7 }, { 142,156,108,200,1 }, { 230,33,20,43,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 131)
		{ { 14,105,42,215,0 }, { 139,70,132,13,15 }, { 14,181,73,103,0 }, { 251,2,22,45,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 132)
		{ { 138,208,92,91,9 }, { 102,37,149,31,1 }, { 157,163,160,181,1 }, { 143,138,154,70,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 133)
		{ { 133,230,84,193,11 }, { 165,21,25,126,2 }, { 216,50,166,122,1 }, { 71,233,138,138,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 134)
		{ { 61,10,194,179,11 }, { 166,216,171,68,11 }, { 220,212,53,11,12 }, { 210,45,81,182,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 135)
		{ { 75,191,160,85,2 }, { 75,146,152,237,12 }, { 74,160,95,221,2 }, { 59,113,148,157,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 136)
		{ { 114,45,222,48,6 }, { 33,219,230,177,8 }, { 96,199,187,68,14 }, { 24,214,125,184,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 137)
		{ { 54,157,26,205,2 }, { 200,122,52,61,10 }, { 75,53,139,150,12 }, { 91,194,197,225,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 138)
		{ { 162,217,148,230,0 }, { 72,135,50,27,11 }, { 6,114,153,180,5 }, { 221,132,206,17,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 139)
		{ { 95,173,145,57,13 }, { 151,170,211,245,8 }, { 185,200,155,95,10 }, { 26,252,181,94,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 140)
		{ { 87,83,90,233,6 }, { 224,126,78,221,2 }, { 105,117,172,174,10 }, { 75,183,39,224,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 141)
		{ { 95,94,241,212,6 }, { 250,156,200,249,14 }, { 98,184,247,175,10 }, { 121,241,51,149,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 142)
		{ { 235,195,230,172,12 }, { 42,231,123,195,6 }, { 51,86,124,61,7 }, { 108,61,238,117,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 143)
		{ { 10,153,200,53,13 }, { 110,130,215,5,8 }, { 186,193,57,149,0 }, { 26,14,180,23,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 144)
		{ { 84,99,228,154,5 }, { 165,175,200,128,7 }, { 165,146,124,98,10 }, { 224,17,63,90,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 145)
		{ { 37,103,104,147,10 }, { 161,22,173,100,7 }, { 92,145,110,106,4 }, { 226,107,86,136,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 146)
		{ { 171,237,55,6,4 }, { 27,71,112,115,13 }, { 38,14,203,125,5 }, { 188,224,238,45,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 147)
		{ { 89,189,222,217,4 }, { 99,235,212,252,10 }, { 41,183,187,217,10 }, { 83,242,189,124,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 148)
		{ { 100,250,4,192,9 }, { 197,5,57,136,10 }, { 144,50,5,242,6 }, { 81,25,202,10,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 149)
		{ { 37,14,68,231,5 }, { 172,1,106,108,11 }, { 174,114,39,10,4 }, { 211,101,104,3,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 150)
		{ { 229,138,55,75,12 }, { 144,97,121,222,13 }, { 61,46,197,26,7 }, { 183,185,232,96,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 151)
		{ { 36,202,165,116,1 }, { 156,133,186,8,12 }, { 130,234,85,50,4 }, { 49,5,218,19,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 152)
		{ { 228,44,246,88,8 }, { 161,225,161,186,12 }, { 17,166,243,66,7 }, { 53,216,88,120,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 153)
		{ { 110,162,56,83,8 }, { 131,0,189,157,5 }, { 28,161,196,87,6 }, { 171,155,208,12,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 154)
		{ { 247,88,19,2,5 }, { 212,76,96,211,9 }, { 164,12,129,174,15 }, { 156,176,99,34,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 155)
		{ { 12,235,51,187,13 }, { 151,102,219,20,15 }, { 189,220,205,115,0 }, { 242,141,182,110,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 156)
		{ { 120,106,232,103,0 }, { 43,140,46,140,13 }, { 14,97,117,97,14 }, { 179,23,67,29,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 157)
		{ { 240,222,140,150,9 }, { 76,141,189,162,11 }, { 150,147,23,176,15 }, { 212,91,219,19,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 158)
		{ { 38,200,30,254,6 }, { 136,117,246,25,11 }, { 103,247,129,54,4 }, { 217,134,250,225,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 159)
		{ { 105,244,137,8,6 }, { 83,180,116,224,0 }, { 97,9,18,249,6 }, { 0,114,226,220,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 160)
		{ { 63,191,146,164,13 }, { 207,202,123,113,10 }, { 178,84,159,223,12 }, { 88,237,229,63,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 161)
		{ { 214,85,90,118,0 }, { 232,78,134,187,1 }, { 6,229,170,166,11 }, { 141,214,23,33,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 162)
		{ { 156,202,226,54,13 }, { 174,204,219,2,13 }, { 182,196,117,51,9 }, { 180,13,179,55,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 163)
		{ { 178,86,193,106,3 }, { 116,188,42,43,1 }, { 197,104,54,164,13 }, { 141,69,67,210,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 164)
		{ { 215,138,199,34,1 }, { 180,201,26,195,9 }, { 132,78,53,30,11 }, { 156,53,137,50,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 165)
		{ { 45,193,254,38,2 }, { 170,215,54,80,5 }, { 70,71,248,59,4 }, { 160,166,206,181,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 166)
		{ { 175,32,81,9,0 }, { 179,32,32,87,0 }, { 9,8,160,79,5 }, { 14,160,64,76,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 167)
		{ { 147,44,8,175,14 }, { 9,56,71,103,11 }, { 127,81,3,76,9 }, { 222,110,33,201,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 168)
		{ { 83,254,202,119,5 }, { 109,204,222,237,9 }, { 174,229,55,252,10 }, { 155,119,179,59,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 169)
		{ { 93,41,36,151,10 }, { 139,27,129,196,15 }, { 94,146,73,75,10 }, { 242,56,29,141,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 170)
		{ { 47,16,26,34,11 }, { 198,80,39,81,1 }, { 212,69,128,143,4 }, { 136,174,64,166,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 171)
		{ { 198,173,22,177,4 }, { 129,67,210,183,10 }, { 40,214,139,86,3 }, { 94,212,188,40,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 172)
		{ { 210,236,164,178,0 }, { 1,141,146,163,15 }, { 4,210,83,116,11 }, { 252,84,155,24,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 173)
		{ { 166,250,96,61,4 }, { 233,36,250,7,12 }, { 43,192,101,246,5 }, { 62,5,242,73,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 174)
		{ { 48,87,195,182,9 }, { 124,206,171,32,3 }, { 150,220,62,160,12 }, { 192,77,87,51,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 175)
		{ { 232,23,181,77,2 }, { 90,179,40,190,4 }, { 75,42,222,129,7 }, { 39,209,76,213,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 176)
		{ { 64,171,252,62,0 }, { 41,163,158,144,13 }, { 7,195,253,80,2 }, { 176,151,156,89,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 177)
		{ { 245,58,209,110,7 }, { 253,184,106,218,9 }, { 231,104,181,202,15 }, { 149,181,97,219,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 178)
		{ { 54,243,160,110,8 }, { 201,174,59,9,5 }, { 23,96,92,246,12 }, { 169,13,199,89,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 179)
		{ { 39,120,46,65,8 }, { 193,69,37,77,12 }, { 24,39,65,238,4 }, { 59,42,74,40,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 180)
		{ { 62,144,98,20,6 }, { 234,88,240,1,4 }, { 98,132,96,151,12 }, { 40,0,241,165,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 181)
		{ { 1,253,122,212,14 }, { 105,86,213,120,14 }, { 114,181,235,248,0 }, { 113,234,182,169,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 182)
		{ { 200,118,91,198,4 }, { 123,68,76,186,3 }, { 38,61,166,225,3 }, { 197,211,34,45,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 183)
		{ { 173,61,130,21,15 }, { 207,210,225,102,8 }, { 250,132,27,203,5 }, { 22,104,116,191,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 184)
		{ { 150,49,122,39,14 }, { 233,90,71,23,5 }, { 126,69,232,198,9 }, { 174,142,37,169,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 185)
		{ { 5,248,19,202,6 }, { 209,116,80,88,11 }, { 101,60,129,250,0 }, { 209,160,162,232,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 186)
		{ { 14,122,220,34,14 }, { 227,149,79,17,9 }, { 116,67,181,231,0 }, { 152,143,42,156,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 187)
		{ { 191,82,196,165,0 }, { 234,141,42,71,2 }, { 10,82,52,175,13 }, { 78,37,75,21,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 188)
		{ { 114,79,106,226,14 }, { 32,94,111,169,15 }, { 116,117,111,36,14 }, { 249,95,103,160,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 189)
		{ { 84,15,215,234,8 }, { 176,235,11,184,11 }, { 21,126,191,2,10 }, { 209,221,13,112,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 190)
		{ { 156,150,47,116,1 }, { 222,73,158,42,4 }, { 130,239,70,147,9 }, { 37,71,153,39,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 191)
		{ { 38,64,66,176,1 }, { 164,68,162,1,2 }, { 128,212,32,38,4 }, { 72,4,82,34,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 192)
		{ { 25,124,183,117,4 }, { 91,205,194,124,12 }, { 42,238,211,233,8 }, { 51,228,59,61,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 193)
		{ { 31,43,184,80,13 }, { 135,138,205,89,12 }, { 176,161,221,79,8 }, { 57,171,53,30,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 194)
		{ { 200,125,108,42,13 }, { 103,39,71,162,13 }, { 181,67,107,225,3 }, { 180,94,46,78,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 195)
		{ { 220,141,45,237,14 }, { 154,59,87,174,14 }, { 123,123,75,19,11 }, { 119,94,173,197,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 196)
		{ { 203,107,1,115,8 }, { 19,6,139,207,9 }, { 28,232,13,109,3 }, { 159,61,22,12,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 197)
		{ { 190,66,16,54,8 }, { 138,12,171,19,1 }, { 22,192,132,39,13 }, { 140,141,83,5,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 198)
		{ { 187,70,34,167,7 }, { 14,92,106,103,7 }, { 238,84,70,45,13 }, { 238,101,99,167,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 199)
		{ { 115,50,38,239,8 }, { 73,105,43,205,7 }, { 31,118,68,204,14 }, { 235,61,73,105,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 200)
		{ { 73,51,173,227,9 }, { 87,131,15,204,7 }, { 156,123,92,201,2 }, { 227,63,12,30,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 201)
		{ { 31,28,137,108,7 }, { 222,184,70,105,8 }, { 227,105,19,143,8 }, { 25,102,33,215,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 202)
		{ { 137,118,101,171,10 }, { 115,53,11,102,7 }, { 93,90,102,233,1 }, { 230,109,10,204,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 203)
		{ { 146,244,107,161,2 }, { 113,92,22,39,6 }, { 72,93,98,244,9 }, { 110,70,131,168,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 204)
		{ { 41,121,129,118,7 }, { 95,150,226,72,9 }, { 230,232,25,233,4 }, { 145,36,118,159,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 205)
		{ { 173,112,44,248,13 }, { 199,37,231,74,6 }, { 177,243,64,235,5 }, { 101,46,122,78,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 206)
		{ { 71,49,152,185,0 }, { 193,162,134,213,2 }, { 9,209,152,206,2 }, { 74,182,20,88,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 207)
		{ { 236,46,142,6,11 }, { 143,209,45,162,9 }, { 214,7,23,67,7 }, { 148,91,72,191,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 208)
		{ { 54,161,214,152,0 }, { 161,235,176,17,2 }, { 1,150,184,86,12 }, { 72,128,221,120,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 209)
		{ { 165,206,134,80,15 }, { 132,213,249,106,8 }, { 240,166,23,58,5 }, { 21,105,250,178,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 210)
		{ { 99,120,112,52,8 }, { 105,4,163,209,12 }, { 18,192,225,236,6 }, { 56,188,82,9,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 211)
		{ { 243,171,65,212,6 }, { 57,26,248,203,10 }, { 98,184,45,92,15 }, { 93,49,245,137,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 212)
		{ { 230,3,42,139,5 }, { 132,98,108,135,7 }, { 173,21,76,6,7 }, { 238,19,100,98,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 213)
		{ { 76,17,238,199,3 }, { 238,211,4,140,7 }, { 206,55,120,131,2 }, { 227,18,12,183,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 214)
		{ { 38,29,229,13,6 }, { 248,179,96,37,12 }, { 107,10,123,134,4 }, { 58,64,108,209,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 215)
		{ { 41,102,22,227,2 }, { 3,85,42,124,3 }, { 76,118,134,105,4 }, { 195,229,74,172,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 216)
		{ { 55,207,241,160,10 }, { 176,158,59,113,14 }, { 80,88,255,62,12 }, { 120,237,199,144,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 217)
		{ { 196,87,132,122,11 }, { 196,183,139,170,1 }, { 213,226,30,162,3 }, { 133,93,30,210,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 218)
		{ { 119,110,82,255,9 }, { 173,108,171,253,11 }, { 159,244,167,110,14 }, { 219,253,83,107,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 219)
		{ { 152,8,25,187,9 }, { 22,40,135,22,11 }, { 157,217,129,1,9 }, { 214,142,17,70,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 220)
		{ { 80,203,43,93,8 }, { 24,110,157,140,12 }, { 27,173,77,48,10 }, { 51,27,151,97,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 221)
		{ { 139,105,24,6,3 }, { 15,22,4,83,9 }, { 198,1,137,109,1 }, { 156,162,6,143,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 222)
		{ { 18,217,194,206,9 }, { 108,238,17,9,11 }, { 151,52,57,180,8 }, { 217,8,135,115,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 223)
		{ { 21,140,46,115,8 }, { 128,73,151,108,13 }, { 28,231,67,26,8 }, { 179,110,153,32,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 224)
		{ { 107,132,1,94,10 }, { 26,48,177,233,1 }, { 87,168,2,29,6 }, { 137,120,208,197,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 225)
		{ { 103,105,93,185,15 }, { 181,55,231,213,10 }, { 249,219,169,110,6 }, { 90,190,126,202,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 226)
		{ { 62,114,116,92,1 }, { 239,45,168,25,4 }, { 131,162,228,231,12 }, { 41,129,91,79,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 227)
		{ { 1,202,26,87,1 }, { 12,68,156,92,9 }, { 142,165,133,56,0 }, { 147,163,146,35,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 228)
		{ { 34,231,3,111,5 }, { 29,102,122,45,1 }, { 175,108,14,116,4 }, { 139,69,230,107,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 229)
		{ { 213,220,237,174,1 }, { 252,173,22,226,15 }, { 135,91,115,186,11 }, { 244,118,139,83,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 230)
		{ { 128,149,50,197,11 }, { 76,82,17,62,6 }, { 218,52,202,144,1 }, { 103,200,132,163,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 231)
		{ { 247,228,233,213,4 }, { 185,140,244,239,6 }, { 42,185,114,126,15 }, { 111,114,243,25,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 232)
		{ { 89,216,79,156,11 }, { 126,125,149,192,10 }, { 211,159,33,185,10 }, { 80,58,155,231,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 233)
		{ { 244,46,208,133,1 }, { 173,136,40,182,10 }, { 138,16,183,66,15 }, { 86,209,65,27,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 234)
		{ { 93,180,169,31,10 }, { 219,184,149,228,5 }, { 95,137,82,219,10 }, { 162,122,145,221,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 235)
		{ { 13,88,229,177,15 }, { 246,149,195,68,14 }, { 248,218,113,171,0 }, { 114,44,58,150,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 236)
		{ { 105,251,159,164,3 }, { 95,215,62,208,10 }, { 194,95,157,249,6 }, { 80,183,206,191,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 237)
		{ { 41,186,81,246,0 }, { 123,0,186,88,11 }, { 6,248,165,217,4 }, { 209,165,208,13,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 238)
		{ { 88,124,103,66,7 }, { 119,93,64,168,13 }, { 228,46,99,225,10 }, { 177,80,43,174,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 239)
		{ { 216,185,2,30,13 }, { 79,106,209,130,9 }, { 183,132,9,209,11 }, { 148,24,181,111,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 240)
		{ { 187,89,68,73,14 }, { 98,63,97,79,8 }, { 121,34,41,173,13 }, { 31,40,111,196,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 241)
		{ { 170,35,31,53,10 }, { 27,83,175,23,0 }, { 90,207,140,69,5 }, { 14,143,92,173,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 242)
		{ { 13,149,148,63,4 }, { 202,163,210,116,1 }, { 47,194,154,155,0 }, { 130,228,188,85,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 243)
		{ { 222,196,97,37,7 }, { 190,28,82,167,4 }, { 234,72,98,55,11 }, { 46,84,163,135,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 244)
		{ { 5,161,105,48,13 }, { 181,2,215,64,4 }, { 176,201,104,90,0 }, { 32,46,180,10,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 245)
		{ { 226,81,46,181,8 }, { 72,71,167,135,6 }, { 26,215,72,164,7 }, { 110,30,94,33,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 246)
		{ { 171,72,226,220,0 }, { 42,228,160,75,14 }, { 3,180,113,45,5 }, { 125,32,82,117,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 247)
		{ { 12,182,132,148,15 }, { 207,145,217,32,2 }, { 242,146,22,211,0 }, { 64,73,184,159,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 248)
		{ { 146,122,107,91,1 }, { 117,108,140,15,13 }, { 141,173,101,228,9 }, { 191,3,19,106,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 249)
		{ { 187,144,243,69,0 }, { 122,200,48,95,4 }, { 10,44,240,157,13 }, { 47,160,193,53,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 250)
		{ { 99,46,143,173,0 }, { 25,225,46,229,10 }, { 11,95,23,76,6 }, { 90,119,72,121,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 251)
		{ { 194,238,175,42,7 }, { 21,245,94,163,13 }, { 229,79,87,116,3 }, { 188,87,170,250,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 252)
		{ { 30,178,175,57,13 }, { 215,233,223,5,4 }, { 185,207,84,215,8 }, { 42,15,185,126,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 253)
		{ { 81,21,72,197,2 }, { 104,26,4,236,2 }, { 74,49,42,136,10 }, { 67,114,5,129,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 254)
		{ { 70,147,213,222,4 }, { 248,163,216,153,3 }, { 39,186,188,150,2 }, { 201,145,188,81,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 255)
		{ { 136,142,145,97,13 }, { 22,128,91,62,8 }, { 184,104,151,17,1 }, { 23,205,160,22,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 256)
		{ { 104,131,111,244,15 }, { 62,83,255,136,6 }, { 242,255,108,17,6 }, { 97,31,252,167,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 257)
		{ { 81,189,46,68,1 }, { 77,75,20,232,12 }, { 130,39,75,216,10 }, { 49,114,141,43,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 258)
		{ { 122,10,196,14,9 }, { 46,169,41,129,9 }, { 151,2,53,5,14 }, { 152,25,73,87,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 259)
		{ { 139,183,98,180,10 }, { 107,82,155,99,6 }, { 82,212,110,221,1 }, { 108,109,148,173,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 260)
		{ { 28,175,131,161,10 }, { 147,218,27,36,10 }, { 88,92,31,83,8 }, { 82,77,133,188,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 261)
		{ { 194,112,11,187,13 }, { 85,100,199,135,3 }, { 189,221,0,228,3 }, { 206,30,50,106,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 262)
		{ { 251,46,208,154,10 }, { 35,184,169,243,11 }, { 85,144,183,77,15 }, { 220,249,81,220,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 263)
		{ { 248,82,2,148,14 }, { 74,92,233,130,2 }, { 114,148,4,161,15 }, { 68,25,115,165,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 264)
		{ { 122,161,4,202,6 }, { 3,59,112,137,3 }, { 101,50,8,85,14 }, { 201,16,237,204,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 265)
		{ { 106,150,210,188,11 }, { 110,240,187,177,2 }, { 211,212,182,149,6 }, { 72,221,208,247,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 266)
		{ { 40,242,236,117,14 }, { 107,149,255,12,4 }, { 122,227,116,241,4 }, { 35,15,250,157,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 267)
		{ { 96,112,101,235,4 }, { 113,37,98,140,7 }, { 45,122,96,224,6 }, { 227,20,106,72,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 268)
		{ { 122,217,179,168,12 }, { 82,238,115,145,14 }, { 49,92,217,181,14 }, { 120,156,231,116,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 269)
		{ { 53,114,214,203,15 }, { 229,253,105,92,3 }, { 253,54,180,234,12 }, { 195,169,107,250,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 270)
		{ { 212,38,239,184,15 }, { 181,249,207,162,6 }, { 241,223,118,66,11 }, { 100,95,57,250,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 271)
		{ { 100,238,77,186,10 }, { 177,53,191,160,11 }, { 85,219,39,114,6 }, { 208,95,218,200,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 272)
		{ { 152,61,122,143,1 }, { 111,106,4,54,15 }, { 143,21,235,193,9 }, { 246,194,5,111,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 273)
		{ { 140,163,31,73,9 }, { 151,99,29,30,0 }, { 153,47,140,83,1 }, { 7,139,140,110,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 274)
		{ { 2,84,87,180,6 }, { 120,85,194,49,2 }, { 98,222,162,164,0 }, { 72,196,58,161,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 275)
		{ { 213,58,228,20,9 }, { 237,137,137,194,12 }, { 146,130,117,202,11 }, { 52,57,25,27,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 276)
		{ { 157,60,100,57,6 }, { 227,57,194,102,12 }, { 105,194,99,203,9 }, { 54,100,57,204,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 277)
		{ { 121,83,50,238,5 }, { 78,110,106,216,7 }, { 167,116,204,169,14 }, { 225,181,103,103,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 278)
		{ { 112,136,77,102,4 }, { 56,9,118,136,9 }, { 38,107,33,16,14 }, { 145,22,233,1,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 279)
		{ { 29,211,82,141,8 }, { 234,110,25,84,2 }, { 27,20,172,187,8 }, { 66,169,135,101,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 280)
		{ { 216,229,29,36,6 }, { 27,31,86,178,0 }, { 98,75,138,113,11 }, { 4,214,175,141,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 281)
		{ { 214,2,156,163,8 }, { 128,137,15,151,3 }, { 28,83,148,6,11 }, { 206,159,9,16,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 282)
		{ { 217,74,182,16,12 }, { 2,205,201,210,12 }, { 48,134,213,41,11 }, { 52,185,59,52,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 283)
		{ { 118,107,184,136,0 }, { 129,174,44,145,14 }, { 1,17,221,102,14 }, { 120,147,71,88,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 284)
		{ { 253,12,107,49,9 }, { 182,72,167,230,12 }, { 152,205,99,11,15 }, { 54,126,81,38,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 285)
		{ { 59,255,139,157,1 }, { 95,238,188,101,10 }, { 139,157,31,253,12 }, { 90,99,215,127,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 286)
		{ { 231,134,244,212,14 }, { 168,145,249,251,6 }, { 114,178,246,30,7 }, { 109,249,248,145,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 287)
		{ { 212,230,185,183,9 }, { 157,140,159,182,7 }, { 158,217,214,114,11 }, { 230,223,147,27,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 288)
		{ { 207,168,187,54,9 }, { 159,192,151,211,13 }, { 150,205,209,95,3 }, { 188,190,144,63,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 289)
		{ { 32,164,54,108,6 }, { 9,113,114,56,4 }, { 99,102,194,80,4 }, { 33,196,232,233,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 290)
		{ { 92,239,185,83,6 }, { 147,158,220,188,13 }, { 108,169,223,115,10 }, { 179,211,183,156,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 291)
		{ { 15,6,182,96,5 }, { 134,193,74,121,4 }, { 160,102,214,15,0 }, { 41,229,40,54,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 292)
		{ { 187,81,210,94,7 }, { 110,254,224,91,1 }, { 231,164,184,173,13 }, { 141,160,119,247,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 293)
		{ { 247,226,98,100,1 }, { 173,76,58,203,4 }, { 130,100,100,126,15 }, { 45,53,195,43,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 294)
		{ { 129,253,169,133,5 }, { 93,134,84,102,14 }, { 170,25,91,248,1 }, { 118,98,166,27,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 295)
		{ { 34,65,219,197,9 }, { 60,198,37,29,2 }, { 154,61,184,36,4 }, { 75,138,70,51,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 296)
		{ { 86,251,75,40,0 }, { 241,110,30,129,8 }, { 1,77,45,246,10 }, { 24,23,135,104,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 297)
		{ { 237,166,76,109,0 }, { 171,33,62,238,0 }, { 11,99,38,91,7 }, { 7,119,200,77,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 298)
		{ { 206,123,8,15,4 }, { 203,38,76,135,9 }, { 47,1,13,231,3 }, { 158,19,38,77,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 299)
		{ { 97,146,238,126,9 }, { 108,225,191,200,5 }, { 151,231,116,152,6 }, { 161,63,216,115,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 300)
		{ { 148,63,245,18,4 }, { 241,139,200,50,13 }, { 36,138,255,194,9 }, { 180,193,61,24,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 301)
		{ { 136,179,190,173,15 }, { 79,243,95,22,6 }, { 251,87,220,209,1 }, { 102,143,172,255,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 302)
		{ { 155,39,229,141,0 }, { 59,171,8,103,6 }, { 11,26,126,77,9 }, { 110,97,13,93,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 303)
		{ { 190,11,69,253,2 }, { 186,59,170,15,10 }, { 75,250,45,7,13 }, { 95,5,93,197,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 304)
		{ { 105,251,58,114,10 }, { 67,86,191,216,13 }, { 84,229,205,249,6 }, { 177,191,214,172,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 305)
		{ { 97,56,58,131,2 }, { 65,80,36,212,15 }, { 76,21,193,200,6 }, { 242,178,64,168,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 306)
		{ { 102,136,99,155,3 }, { 180,112,176,133,15 }, { 205,156,97,22,6 }, { 250,16,208,226,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 307)
		{ { 84,208,28,153,2 }, { 192,61,148,148,2 }, { 73,147,128,178,10 }, { 66,146,155,192,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 308)
		{ { 144,177,12,2,10 }, { 65,27,21,2,1 }, { 84,3,8,208,9 }, { 132,10,141,136,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 309)
		{ { 246,103,252,109,1 }, { 173,175,46,191,4 }, { 139,99,254,102,15 }, { 47,215,79,91,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 310)
		{ { 122,205,117,129,3 }, { 54,31,48,181,14 }, { 200,26,235,53,14 }, { 122,208,207,134,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 311)
		{ { 58,189,7,246,1 }, { 95,75,178,41,11 }, { 134,254,11,213,12 }, { 217,68,221,47,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 312)
		{ { 84,48,18,71,3 }, { 205,88,0,156,1 }, { 206,36,128,194,10 }, { 131,144,1,171,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 313)
		{ { 6,119,148,213,8 }, { 201,135,137,61,2 }, { 26,178,158,230,0 }, { 75,201,30,25,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 314)
		{ { 168,85,177,32,1 }, { 86,134,34,50,4 }, { 128,72,218,161,5 }, { 36,196,70,22,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 315)
		{ { 156,180,215,253,11 }, { 255,249,147,62,2 }, { 219,254,178,211,9 }, { 71,204,153,255,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 316)
		{ { 49,161,147,230,10 }, { 25,218,51,88,3 }, { 86,124,152,88,12 }, { 193,172,197,185,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 317)
		{ { 61,163,183,109,4 }, { 155,235,122,92,4 }, { 43,110,220,91,12 }, { 35,165,237,125,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 318)
		{ { 65,83,241,224,4 }, { 112,134,74,216,6 }, { 32,120,252,168,2 }, { 97,181,38,16,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 319)
		{ { 85,68,51,91,5 }, { 148,108,192,252,5 }, { 173,172,194,42,10 }, { 163,240,51,98,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 320)
		{ { 146,246,18,73,13 }, { 69,108,89,63,0 }, { 185,36,134,244,9 }, { 15,201,163,106,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 321)
		{ { 38,154,53,248,10 }, { 208,49,187,25,14 }, { 81,250,197,150,4 }, { 121,141,216,192,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 322)
		{ { 4,38,119,137,6 }, { 177,113,72,52,6 }, { 105,30,230,66,0 }, { 98,193,40,232,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 323)
		{ { 148,135,205,198,15 }, { 188,155,93,42,3 }, { 246,59,62,18,9 }, { 197,75,173,147,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 324)
		{ { 78,167,231,217,12 }, { 179,227,217,173,6 }, { 57,190,126,87,2 }, { 107,89,188,124,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 325)
		{ { 46,54,115,69,11 }, { 255,80,41,61,4 }, { 218,44,230,199,4 }, { 43,201,64,175,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 326)
		{ { 58,94,143,48,4 }, { 82,205,238,33,8 }, { 32,207,23,165,12 }, { 24,71,123,52,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 327)
		{ { 118,217,250,167,7 }, { 236,222,118,149,15 }, { 238,85,249,182,14 }, { 250,150,231,179,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 328)
		{ { 100,228,234,29,15 }, { 173,244,245,164,4 }, { 251,133,114,114,6 }, { 34,90,242,251,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 329)
		{ { 18,167,180,52,13 }, { 13,139,219,49,4 }, { 178,194,222,84,8 }, { 40,205,189,27,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 330)
		{ { 73,115,217,85,3 }, { 127,150,140,220,0 }, { 202,169,188,233,2 }, { 3,179,22,159,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 331)
		{ { 205,180,24,151,5 }, { 207,0,212,246,3 }, { 174,145,130,219,3 }, { 198,242,176,15,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 332)
		{ { 139,218,118,210,14 }, { 98,85,217,91,15 }, { 116,182,229,189,1 }, { 253,169,186,164,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 333)
		{ { 245,74,77,236,8 }, { 184,45,47,202,10 }, { 19,123,37,42,15 }, { 85,63,75,65,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 334)
		{ { 129,22,22,248,10 }, { 64,113,139,122,2 }, { 81,246,134,136,1 }, { 69,237,24,224,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 335)
		{ { 64,54,244,230,11 }, { 109,145,11,184,7 }, { 214,114,246,192,2 }, { 225,221,8,155,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 336)
		{ { 39,54,40,42,6 }, { 193,48,110,97,5 }, { 101,65,70,206,4 }, { 168,103,96,200,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 337)
		{ { 164,19,210,41,15 }, { 228,242,107,22,0 }, { 249,68,188,130,5 }, { 6,141,100,242,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 338)
		{ { 144,31,228,193,7 }, { 100,155,72,46,14 }, { 232,50,127,128,9 }, { 119,65,45,146,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 339)
		{ { 154,191,206,86,14 }, { 107,219,221,43,9 }, { 118,167,63,213,9 }, { 157,75,189,189,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 340)
		{ { 45,50,91,158,15 }, { 255,112,237,80,3 }, { 247,157,164,203,4 }, { 192,171,112,239,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 341)
		{ { 217,144,31,106,9 }, { 86,105,23,218,1 }, { 149,111,128,153,11 }, { 133,190,137,102,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 342)
		{ { 58,166,79,173,14 }, { 59,121,127,37,2 }, { 123,95,38,85,12 }, { 74,79,233,237,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 343)
		{ { 101,40,141,96,11 }, { 149,145,39,200,8 }, { 208,107,17,74,6 }, { 17,62,72,154,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 344)
		{ { 10,83,233,96,11 }, { 118,150,15,9,4 }, { 208,105,124,165,0 }, { 41,15,6,150,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 345)
		{ { 233,224,156,62,4 }, { 11,165,246,210,1 }, { 39,195,144,121,7 }, { 132,182,250,93,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 346)
		{ { 77,155,120,99,13 }, { 230,2,95,220,13 }, { 188,97,237,155,2 }, { 179,191,164,6,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 347)
		{ { 217,139,180,131,3 }, { 6,155,24,214,15 }, { 204,18,221,25,11 }, { 246,177,141,150,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 348)
		{ { 52,177,129,237,7 }, { 221,186,114,12,2 }, { 235,120,24,210,12 }, { 67,4,229,219,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 349)
		{ { 91,55,63,73,0 }, { 83,107,12,253,4 }, { 9,47,206,205,10 }, { 43,243,13,108,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 350)
		{ { 133,114,183,185,1 }, { 213,229,138,86,6 }, { 137,222,212,234,1 }, { 102,165,26,122,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 351)
		{ { 44,93,5,106,4 }, { 210,39,98,40,9 }, { 37,106,11,163,4 }, { 145,68,110,68,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 352)
		{ { 228,103,18,150,13 }, { 141,70,233,178,3 }, { 182,148,142,98,7 }, { 196,217,118,43,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 353)
		{ { 42,8,214,247,8 }, { 42,193,163,29,11 }, { 30,246,177,5,4 }, { 219,140,88,53,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 354)
		{ { 69,41,73,198,1 }, { 189,2,4,200,11 }, { 134,57,41,74,2 }, { 209,50,4,11,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 355)
		{ { 37,1,236,91,7 }, { 164,179,228,76,5 }, { 237,163,120,10,4 }, { 163,34,124,210,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 356)
		{ { 184,245,71,121,12 }, { 115,111,243,46,0 }, { 57,238,42,241,13 }, { 7,76,255,108,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 357)
		{ { 163,183,234,75,3 }, { 101,242,60,111,5 }, { 205,37,126,220,5 }, { 175,99,196,250,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 358)
		{ { 68,61,107,155,4 }, { 241,98,196,164,15 }, { 45,157,107,194,2 }, { 242,82,52,104,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 359)
		{ { 190,45,203,132,8 }, { 187,202,37,35,10 }, { 18,29,59,71,13 }, { 92,74,69,61,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 360)
		{ { 181,31,196,126,12 }, { 232,171,235,106,9 }, { 55,226,63,138,13 }, { 149,109,125,81,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 361)
		{ { 111,56,207,152,8 }, { 243,225,165,193,10 }, { 17,159,49,207,6 }, { 88,58,88,124,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 362)
		{ { 144,242,254,147,4 }, { 97,205,220,22,7 }, { 44,151,244,240,9 }, { 230,131,187,56,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 363)
		{ { 7,253,84,10,11 }, { 229,55,17,113,9 }, { 213,2,171,254,0 }, { 152,232,142,202,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 364)
		{ { 238,83,195,208,8 }, { 242,198,169,139,2 }, { 16,188,60,167,7 }, { 77,25,86,52,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 365)
		{ { 247,9,142,188,10 }, { 136,251,167,195,10 }, { 83,215,25,14,15 }, { 92,62,93,241,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 366)
		{ { 101,70,124,48,9 }, { 164,5,175,240,4 }, { 144,195,230,42,6 }, { 32,255,90,2,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 367)
		{ { 174,111,215,151,14 }, { 187,215,233,55,11 }, { 126,158,191,103,5 }, { 222,201,126,189,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 368)
		{ { 139,196,115,158,9 }, { 62,100,145,115,7 }, { 151,156,226,61,1 }, { 236,232,146,103,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 369)
		{ { 151,25,48,254,4 }, { 200,42,194,91,15 }, { 39,240,201,142,9 }, { 253,164,53,65,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 370)
		{ { 154,117,45,245,7 }, { 95,31,198,47,6 }, { 234,251,74,229,9 }, { 111,70,63,143,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 371)
		{ { 189,71,254,83,14 }, { 162,223,237,126,5 }, { 124,167,254,43,13 }, { 167,235,127,180,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 372)
		{ { 111,21,48,146,8 }, { 194,2,161,241,7 }, { 20,144,202,143,6 }, { 232,248,84,4,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 373)
		{ { 93,225,204,72,9 }, { 167,175,21,200,0 }, { 145,35,56,123,10 }, { 1,58,143,94,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 374)
		{ { 17,28,227,220,13 }, { 124,232,193,104,14 }, { 179,188,115,136,8 }, { 113,104,49,115,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 375)
		{ { 164,199,225,87,12 }, { 184,134,249,46,5 }, { 62,168,126,50,5 }, { 167,73,246,17,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 376)
		{ { 85,38,145,17,2 }, { 145,152,136,244,0 }, { 72,136,150,74,10 }, { 2,241,17,152,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 377)
		{ { 157,101,17,128,5 }, { 151,14,64,114,2 }, { 160,24,138,107,9 }, { 68,224,39,14,9 }, },
	#endif
	#if (ARUCO_DB_SIZE > 378)
		{ { 102,99,193,203,3 }, { 181,182,40,141,3 }, { 205,56,60,102,6 }, { 203,17,70,218,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 379)
		{ { 191,197,148,0,2 }, { 130,159,48,115,0 }, { 64,2,154,63,13 }, { 12,224,207,148,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 380)
		{ { 58,53,0,56,7 }, { 71,58,226,33,0 }, { 225,192,10,197,12 }, { 8,68,117,206,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 381)
		{ { 118,212,246,121,12 }, { 224,237,243,189,4 }, { 57,230,242,182,14 }, { 43,220,251,112,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 382)
		{ { 68,111,38,103,11 }, { 141,87,11,172,13 }, { 222,102,79,98,2 }, { 179,93,14,171,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 383)
		{ { 23,174,89,233,7 }, { 181,56,94,125,10 }, { 233,121,167,94,8 }, { 91,231,161,202,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 384)
		{ { 54,19,45,99,14 }, { 208,27,111,13,5 }, { 124,107,76,134,12 }, { 171,15,109,128,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 385)
		{ { 142,7,73,43,15 }, { 182,50,79,39,1 }, { 253,73,46,7,1 }, { 142,79,36,198,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 386)
		{ { 24,138,205,223,1 }, { 62,169,156,12,11 }, { 143,187,53,17,8 }, { 211,3,153,87,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 387)
		{ { 237,144,82,208,2 }, { 226,80,176,218,2 }, { 64,180,160,155,7 }, { 69,176,208,164,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 388)
		{ { 91,107,208,31,5 }, { 47,174,200,213,9 }, { 175,128,189,109,10 }, { 154,177,55,95,4 }, },
	#endif
	#if (ARUCO_DB_SIZE > 389)
		{ { 132,164,208,112,14 }, { 161,144,211,58,0 }, { 112,224,178,82,1 }, { 5,204,176,152,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 390)
		{ { 201,178,163,175,4 }, { 91,224,90,198,7 }, { 47,92,84,217,3 }, { 230,53,160,125,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 391)
		{ { 171,24,133,47,12 }, { 90,161,99,71,9 }, { 63,74,17,141,5 }, { 158,44,104,85,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 392)
		{ { 157,233,24,57,0 }, { 131,46,150,86,8 }, { 9,193,137,123,9 }, { 22,166,151,76,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 393)
		{ { 53,118,238,158,0 }, { 233,237,172,96,7 }, { 7,151,118,234,12 }, { 224,99,91,121,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 394)
		{ { 232,208,13,33,0 }, { 82,5,54,134,0 }, { 8,75,0,177,7 }, { 6,22,202,4,10 }, },
	#endif
	#if (ARUCO_DB_SIZE > 395)
		{ { 112,155,90,149,12 }, { 104,74,253,148,10 }, { 58,149,173,144,14 }, { 82,155,245,33,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 396)
		{ { 169,2,42,49,4 }, { 2,64,238,70,4 }, { 40,197,68,9,5 }, { 38,39,112,36,0 }, },
	#endif
	#if (ARUCO_DB_SIZE > 397)
		{ { 160,62,162,185,12 }, { 65,224,235,38,14 }, { 57,212,87,192,5 }, { 118,77,112,120,2 }, },
	#endif
	#if (ARUCO_DB_SIZE > 398)
		{ { 30,88,158,197,14 }, { 202,221,69,29,10 }, { 122,55,145,167,8 }, { 91,138,43,181,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 399)
		{ { 116,71,14,237,13 }, { 140,111,111,172,2 }, { 187,119,14,34,14 }, { 67,95,111,99,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 400)
		{ { 54,189,68,21,9 }, { 237,11,177,37,8 }, { 154,130,43,214,12 }, { 26,72,221,11,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 401)
		{ { 183,248,210,81,6 }, { 225,220,240,95,8 }, { 104,164,177,254,13 }, { 31,160,243,184,7 }, },
	#endif
	#if (ARUCO_DB_SIZE > 402)
		{ { 220,222,75,250,5 }, { 246,108,222,170,11 }, { 165,253,39,179,11 }, { 213,87,179,102,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 403)
		{ { 158,218,153,195,0 }, { 210,140,28,31,11 }, { 12,57,149,183,9 }, { 223,131,131,20,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 404)
		{ { 143,251,152,168,11 }, { 199,182,31,83,10 }, { 209,81,157,255,1 }, { 92,175,134,222,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 405)
		{ { 154,199,119,231,1 }, { 62,79,26,63,7 }, { 142,126,238,53,9 }, { 239,197,143,39,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 406)
		{ { 141,10,83,203,3 }, { 182,112,8,94,11 }, { 205,60,165,11,1 }, { 215,161,0,230,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 407)
		{ { 201,237,29,206,13 }, { 31,39,85,250,11 }, { 183,59,139,121,3 }, { 213,250,174,79,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 408)
		{ { 194,56,83,94,10 }, { 121,112,129,155,9 }, { 87,172,161,196,3 }, { 157,152,16,233,14 }, },
	#endif
	#if (ARUCO_DB_SIZE > 409)
		{ { 238,74,166,67,7 }, { 134,213,104,143,13 }, { 236,38,85,39,7 }, { 191,17,106,182,1 }, },
	#endif
	#if (ARUCO_DB_SIZE > 410)
		{ { 205,131,69,161,14 }, { 178,19,91,198,2 }, { 120,90,44,27,3 }, { 70,61,172,132,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 411)
		{ { 90,25,224,90,14 }, { 98,186,193,137,13 }, { 117,160,121,133,10 }, { 185,24,53,212,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 412)
		{ { 150,215,128,210,5 }, { 196,142,216,43,3 }, { 164,176,30,182,9 }, { 205,65,183,18,3 }, },
	#endif
	#if (ARUCO_DB_SIZE > 413)
		{ { 226,200,133,24,5 }, { 20,165,240,131,8 }, { 161,138,17,52,7 }, { 28,16,250,82,8 }, },
	#endif
	#if (ARUCO_DB_SIZE > 414)
		{ { 197,49,79,141,11 }, { 253,115,5,198,2 }, { 219,31,40,202,3 }, { 70,58,12,235,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 415)
		{ { 164,124,55,238,1 }, { 221,101,34,58,15 }, { 135,126,195,226,5 }, { 245,196,74,107,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 416)
		{ { 29,130,198,248,12 }, { 162,233,219,72,2 }, { 49,246,52,27,8 }, { 65,45,185,116,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 417)
		{ { 50,92,92,108,8 }, { 104,45,39,57,8 }, { 19,99,163,164,12 }, { 25,206,75,65,6 }, },
	#endif
	#if (ARUCO_DB_SIZE > 418)
		{ { 93,157,27,174,0 }, { 218,106,22,240,11 }, { 7,93,139,155,10 }, { 208,246,133,101,11 }, },
	#endif
	#if (ARUCO_DB_SIZE > 419)
		{ { 149,73,224,117,14 }, { 168,158,195,78,12 }, { 122,224,121,42,9 }, { 55,44,55,145,5 }, },
	#endif
	#if (ARUCO_DB_SIZE > 420)
		{ { 138,104,69,193,5 }, { 55,5,64,15,10 }, { 168,58,33,101,1 }, { 95,0,42,14,12 }, },
	#endif
	#if (ARUCO_DB_SIZE > 421)
		{ { 173,249,241,15,14 }, { 251,182,113,86,13 }, { 127,8,249,251,5 }, { 182,168,230,221,15 }, },
	#endif
	#if (ARUCO_DB_SIZE > 422)
		{ { 149,206,243,11,0 }, { 176,236,24,118,13 }, { 13,12,247,58,9 }, { 182,225,131,112,13 }, },
	#endif
	#if (ARUCO_DB_SIZE > 423)
		{ { 113,147,59,32,13 }, { 84,74,127,208,4 }, { 176,77,204,152,