#include <Wire.h>
#include <HS300x.h>

static constexpr uint8_t numSensors = 4;

// Sensor objects (constructed at compile time)
HS300x sensors[numSensors] = {
  HS300x(0x44),
  HS300x(0x45),
  HS300x(0x46),
  HS300x(0x47)
};

bool allReady(bool *arr, uint8_t arrSize) {
  for (uint8_t i = 0; i < arrSize; i++) {
    if (!arr[i]) {
      return false;
    }
  }
  return true;
}

void setup() {
  Serial.begin(9600);
  Wire.begin();

  // Initialize all sensors
  for (auto &sensor : sensors) {
    if (sensor.begin()) {
      Serial.print("Sensor initialized with address 0x");
      Serial.println(sensor.getAddress(), HEX);
    } else {
      Serial.print("Sensor not found at 0x");
      Serial.println(sensor.getAddress(), HEX);
    }
  }

  Serial.println("Starting async multi-sensor measurement example");
}

void loop() {
  // Step 1: Start all measurements
  Serial.println("Starting measurements");
  for (auto &sensor : sensors) {
    sensor.startMeasurement();
  }

  // Step 2: Wait asynchronously until all are ready
  bool sensorReady[numSensors] = {false};
  while (!allReady(sensorReady, numSensors)) {
    for (uint8_t i = 0; i < numSensors; i++) {
      if (!sensorReady[i]) {
        if (sensors[i].isMeasurementReady()) {
          sensorReady[i] = true;
        }
      }
    }
    // We could do other tasks here while waiting
  }

  // Step 3: Print all results
  for (auto &sensor : sensors) {
    auto data = sensor.getMeasurement();
    Serial.print("Sensor: 0x");
    Serial.print(sensor.getAddress(), HEX);
    Serial.print(", Temperature: ");
    Serial.print(data.temperature);
    Serial.print(" °C, ");
    Serial.print(data.humidity);
    Serial.println(" %RH");
  }
  // Wait before next async cycle
  delay(1000);
}
