/**
 * src/BCC_ESP32S3.h
 * Library for ESP32-S3-DevKitC-1 breakout board
 * Created by Nonpawit Ekburanawat, 2025
 * Released under MIT License
 */

#ifndef BCC_ESP32S3_H
#define BCC_ESP32S3_H

/* Includes *****************************************************************/

#include <Arduino.h>

/* Public Definitions *******************************************************/

/* On-board buttons. */

#define BT1        47
#define BT2        21

/* On-board LEDs. */

#define RED_LED    38
#define YELLOW_LED 39
#define GREEN_LED  40

#define UART_TX    17
#define UART_RX    18

#define I2C_SDA    8
#define I2C_SCL    9

#define SPI_CS     10
#define SPI_MOSI   11
#define SPI_SCK    12
#define SPI_MISO   13

/* On-board analog pins. */

#define A1         4
#define A2         5
#define A3         6
#define A4         7

/* On-board digital pins. */

#define D1         15
#define D2         16
#define D3         3
#define D4         46

#define BUZZER     14

/* TB6612FNG driver pins. */

#define DRV_PWMA   48
#define DRV_A1     0
#define DRV_A2     45
#define DRV_PWMB   36
#define DRV_B1     35
#define DRV_B2     37

/* BCC_ESP32S3 class for the ESP32-S3-DevKitC-1 breakout board. */

class BCC_ESP32S3 {
public:
    /**
     * @brief  Constructor for BCC_ESP32S3 class.
     */
    BCC_ESP32S3();
    
    /**
     * @brief  Initialize the TB6612FNG motor driver pins.
     * @return None.
     */
    void motor_init(void);
    
    /**
     * @brief  Control both motors with speed values.
     * @param  motor_a Speed for motor A (-100 to 100, negative for reverse).
     * @param  motor_b Speed for motor B (-100 to 100, negative for reverse).
     * @return None.
     */
    void motor(int8_t motor_a, int8_t motor_b);
    
private:
    /* PWM channel assignments. */

    uint8_t _pwmChannelA;
    uint8_t _pwmChannelB;
};

#endif /* BCC_ESP32S3_H */
