/**
 * examples/MotorControl/MotorControl.ino
 * Example for controlling motors with BCC_ESP32S3 library
 * Created by Nonpawit Ekburanawat, 2025
 * Released under MIT License
 */

#include <BCC_ESP32S3.h>

BCC_ESP32S3 board;

void setup() {
  /* Initialize the motor driver. */

  board.motor_init();
}

void loop() {
  /* Motor control sequence. */
  
  /* Forward motion. */

  board.motor(50, 50);
  delay(2000);

  /* Stop. */
  
  board.motor(0, 0);
  delay(1000);

  /* Turn right. */

  board.motor(50, -50);
  delay(1000);
  
  /* Stop. */

  board.motor(0, 0);
  delay(1000);

  /* Backward motion. */

  board.motor(-50, -50);
  delay(2000);

  /* Stop. */

  board.motor(0, 0);
  delay(1000);

  /* Turn left. */

  board.motor(-50, 50);
  delay(1000);

  /* Stop and wait before repeating. */

  board.motor(0, 0);
  delay(2000);
}
