# BCC_ESP32S3 Library

An Arduino library for the ESP32-S3-DevKitC-1 breakout board.

## Features

- Easy pin configuration for ESP32-S3-DevKitC-1
- Helper functions for common peripherals
- Support for onboard components
- Simple API for GPIO, I2C, SPI, and other interfaces

## Installation

### Using the Arduino Library Manager

1. Open the Arduino IDE
2. Go to Sketch > Include Library > Manage Libraries...
3. Search for "BCC_ESP32S3"
4. Click "Install"

### Manual Installation

1. Download this repository as a ZIP file
2. In Arduino IDE, go to Sketch > Include Library > Add .ZIP Library...
3. Select the downloaded ZIP file

## Hardware Requirements
- ESP32-S3-DevKitC-1 board
- USB cable for programming

## Pin Mapping

### LEDs
| Function | ESP32-S3 Pin |
|----------|------------|
| RED_LED | 38 |
| YELLOW_LED | 39 |
| GREEN_LED | 40 |

### Buttons
| Function | ESP32-S3 Pin |
|----------|------------|
| BT1 | 47 |
| BT2 | 21 |

### Communication
| Function | ESP32-S3 Pin |
|----------|------------|
| UART_TX | 17 |
| UART_RX | 18 |
| I2C_SDA | 8 |
| I2C_SCL | 9 |
| SPI_CS | 10 |
| SPI_MOSI | 11 |
| SPI_SCK | 12 |
| SPI_MISO | 13 |

### Analog Pins
| Function | ESP32-S3 Pin |
|----------|------------|
| A1 | 4 |
| A2 | 5 |
| A3 | 6 |
| A4 | 7 |

### Digital Pins
| Function | ESP32-S3 Pin |
|----------|------------|
| D1 | 15 |
| D2 | 16 |
| D3 | 3 |
| D4 | 46 |
| BUZZER | 14 |

### Motor Driver (TB6612FNG)
| Function | ESP32-S3 Pin |
|----------|------------|
| DRV_PWMA | 48 |
| DRV_A1 | 0 |
| DRV_A2 | 45 |
| DRV_PWMB | 36 |
| DRV_B1 | 35 |
| DRV_B2 | 37 |

## Usage

```cpp
#include <BCC_ESP32S3.h>

BCC_ESP32S3 board;

void setup() {
  Serial.begin(115200);
  
  /* Initialize the motor driver. */

  board.motor_init();
  
  /* Direct pin control for LEDs. */

  pinMode(RED_LED, OUTPUT);
  pinMode(YELLOW_LED, OUTPUT);
  pinMode(GREEN_LED, OUTPUT);
  
  digitalWrite(RED_LED, HIGH);
  delay(500);
  digitalWrite(RED_LED, LOW);
  
  /* Using I2C pins directly. */

  Wire.begin(I2C_SDA, I2C_SCL);
  
  /* Using SPI pins directly. */

  SPI.begin(SPI_SCK, SPI_MISO, SPI_MOSI, SPI_CS);
}

void loop() {
  /* Motor control example. */

  /* Parameters: motor_a, motor_b (-100 to 100). */
  
  /* Move forward at 50% speed. */

  board.motor(50, 50);
  delay(2000);
  
  /* Turn right at 50% speed. */

  board.motor(50, -50);
  delay(1000);
  
  /* Move backward at 50% speed. */

  board.motor(-50, -50);
  delay(2000);
  
  /* Turn left at 50% speed. */

  board.motor(-50, 50);
  delay(1000);
  
  /* Stop. */

  board.motor(0, 0);
  delay(1000);
}
```

This library provides pin definitions for the ESP32-S3-DevKitC-1 breakout board and includes motor control functionality for the TB6612FNG motor driver.

## Examples

The library includes examples demonstrating various features:

- MotorControl: Control the TB6612FNG motor driver
- LEDControl: Control the on-board RGB LEDs in a traffic light sequence
- ButtonControl: Use two buttons to cycle through the three LEDs (RED, YELLOW, GREEN)

## License

This library is released under the MIT License. See the included LICENSE file for details.

## Contributing

Contributions are welcome! Please feel free to submit a Pull Request.

## Credits

Developed by Nonpawit Ekburanawat.
