# Davranış Kuralları (TR)

Bu topluluğun amacı, herkesin kendini güvende hissettiği, öğrenmeye ve üretmeye odaklanabildiği bir ortam kurmaktır. Hepimiz farklı geçmişlerden geliyoruz; bu çeşitliliği bir güç olarak görür, birbirimize saygı ve nezaketle yaklaşırız.

## Değerlerimiz
- Saygı ve empati: Önce anlamaya çalışır, iyi niyet varsayarız.
- Açıklık ve netlik: Geri bildirimi somut, eyleme dönük ve nazik veririz.
- Paylaşım ve kredi: Bilgiyi paylaşır, emeği görünür kılar, teşekkür ederiz.
- Öğrenme kültürü: Hatalardan ders çıkarır, “neden”i konuşur, gelişime alan açarız.

## Kabul Edilebilir Davranışlar
- Yeni gelenlere destek olmak; basit anlatmak, kaynak göstermek
- Anlaşmazlıklarda kişiyi değil problemi konuşmak
- Görüş ayrılıklarında veriye ve somut örneklere dayalı ilerlemek
- Genel yarara odaklanmak, kişisel saldırılardan kaçınmak

## Kabul Edilemez Davranışlar
- Taciz, ayrımcılık, nefret söylemi
- Cinselleştirilmiş dil/görsel ve istenmeyen cinsel ilgi
- Tehdit, kişisel saldırı, trolleme, sürekli provokasyon
- İfşa (doxxing) ve kişisel verileri izinsiz paylaşma
- Spam, konu dışı ısrarlı paylaşımlar, platform kurallarına aykırılık

## Kapsam
Bu kurallar, depo içindeki tüm alanlarda (Issues, PR’lar, Discussions), çevrimiçi/çevrimdışı etkinliklerde ve projeyi temsilen bulunduğunuz tüm ortamlarda geçerlidir.

## İhlal Bildirimi
Uygunsuz davranışları şu adrese bildirebilirsiniz: tunagul54@gmail.com veya WhatsApp: +90 538 040 81 48
- Bildirimler gizli tutulur; en kısa sürede dönüş yapılır.
- Kritik güvenlik/güvenlik‑dışı acil durumlarda platform kuralları da devreye alınabilir.

## Yaptırım İlkeleri
Topluluk sorumluları adil, ölçülü ve tutarlı şekilde hareket eder:
1. Hatırlatma ve yönlendirme
2. Yazılı uyarı
3. Geçici kısıtlama (katılım/söz hakkı)
4. Kalıcı kısıtlama/çıkarma

İtiraz süreci e‑posta ile yürütülür. Çıkar çatışması olan durumlarda ilgili sorumlular karar sürecinden çekilir.

## Uygulama
- Gizlilik: Bildirimler yalnızca gerekli kişilerle sınırlı paylaşılır.
- Minimum Gereklilik: Sorunu çözmek için en hafif yeterli adım tercih edilir.
- Kayıt: Önemli kararlar kısa bir not olarak saklanır (iç süreç).

## Atıf
Bu metin, Contributor Covenant v2.1 dokümanından esinlenilerek uyarlanmıştır: https://www.contributor-covenant.org

---

# Contributor Covenant Code of Conduct (EN)

Our goal is to maintain a safe, helpful, and welcoming community where people can learn and build with confidence.

## Our Values
- Respect and empathy: Seek to understand; assume good intent.
- Clarity and kindness: Give actionable, polite feedback.
- Sharing and credit: Share knowledge and recognize contributions.
- Learning culture: Discuss the “why,” learn from mistakes, and improve together.

## Acceptable Behavior
- Support newcomers; explain simply; point to resources
- Discuss problems, not people
- Rely on data and concrete examples in disagreements
- Focus on what benefits the community

## Unacceptable Behavior
- Harassment, discrimination, hate speech
- Sexualized language/imagery; unwelcome sexual attention
- Threats, personal attacks, trolling, sustained disruption
- Doxxing or sharing private information without consent
- Spam, persistent off‑topic posts, violation of platform rules

## Scope
Applies to all project spaces (Issues, PRs, Discussions), events (online/offline), and any public representation of the project.

## Reporting
Report unacceptable behavior to: tunagul54@gmail.com or WhatsApp: +90 538 040 81 48
- Reports are confidential; you will receive a timely acknowledgement.
- In urgent cases, platform policies may also be invoked as appropriate.

## Enforcement
Community maintainers will act fairly, proportionally, and consistently:
1. Reminder and guidance
2. Written warning
3. Temporary restrictions (participation/speaking)
4. Permanent restrictions/removal

Appeals can be submitted via email. Any maintainer with a conflict of interest will recuse themselves.

## Attribution
Adapted from the Contributor Covenant v2.1: https://www.contributor-covenant.org 