#include <probot.h>
PROBOT_SET_DRIVER_STATION_PASSWORD("ProBot1234");

// TestSlider: demonstrate Slider controlling position of a single axis

static probot::test::TestMotor   mot;
static probot::test::TestEncoder enc;
static probot::control::PidConfig cfgP{ 0.0012f, 0.0f, 0.00002f, 0.0f, -1.0f, 1.0f };
static probot::control::PID pid(cfgP);
static probot::control::ClosedLoopMotor* axis=nullptr;
static probot::mechanism::Slider* slider=nullptr;

void robotInit(){
  control::setGlobalPeriodMs(20);
  static probot::control::ClosedLoopMotor x(&enc, &pid, &mot, 1.0f, 1.0f);
  axis = &x;
  axis->setPidSlotConfig(1, cfgP);
  axis->selectDefaultSlot(probot::control::ControlType::kPosition, 1);
  static probot::test::TestPlant plant(&mot, &enc);
  control::attach(axis);
  control::attach(&plant);

  static probot::mechanism::Slider s(axis);
  slider = &s;
  slider->setLengthToTicks(100.0f); // 1 unit -> 100 ticks
  control::attach(slider);
}

void robotEnd() {}
void teleopInit(){ Serial.println("[SLID] teleopInit"); }

void teleopLoop(){
  static uint32_t last=0; uint32_t now=joystick::get_ms();
  if (now - last >= 2000){
    last = now;
    static bool toggle=false; toggle=!toggle;
    slider->setTargetLength(toggle ? 5.0f : 0.0f); // units
    Serial.printf("[SLID] target=%.1f units\n", slider->getTargetLength());
  }
  delay(20);
}

void autonomousInit(){}
void autonomousLoop(){ delay(1000); } 
