#pragma once
#include <Arduino.h>
#include <Wire.h>
#include <Preferences.h>

class ZenRTC {
public:
  struct DateTime { uint16_t year; uint8_t month, day, hour, minute, second, weekday; };

  ZenRTC(uint8_t sda=21, uint8_t scl=22, uint32_t freq=100000);
  bool begin(bool setBuildIfInvalid=true);
  bool now(DateTime &out);
  bool set(const DateTime &dt);
  static time_t toEpoch(const DateTime &dt);
  static DateTime fromEpoch(time_t e);
  void setMaxAcceptableJumpSeconds(uint32_t s);
  time_t lastGoodEpoch();
  bool setToBuildTime();

private:
  bool readStatus(uint8_t &status);
  bool writeStatus(uint8_t status);
  bool readControl(uint8_t &ctrl);
  bool writeControl(uint8_t ctrl);
  bool readBurst(uint8_t startReg, uint8_t *buf, size_t n);
  bool writeBurst(uint8_t startReg, const uint8_t *buf, size_t n);
  bool writeReg(uint8_t reg, uint8_t val);
  bool readRTC(DateTime &t);
  bool writeRTC(const DateTime &t);
  bool isReasonable(const DateTime &t) const;
  void print(const char* tag, const DateTime &t) const;

  uint8_t _sda, _scl; uint32_t _freq;
  Preferences _prefs; bool _prefsBegun=false;
  uint32_t _maxJump = 600;

  static constexpr uint8_t I2C_ADDR = 0x68;
  static constexpr const char* NAMESPACE = "zenrtc";
  static constexpr const char* KEY_LASTGOOD = "lastgood";
};
