#include <ZenRTC.h>

ZenRTC rtc;

void setup(){
  Serial.begin(115200); delay(200);
  Serial.println("\nZenRTC example");

  if (!rtc.begin(true)) {
    Serial.println("RTC init failed");
  }
  rtc.setMaxAcceptableJumpSeconds(120);
}

void loop(){
  ZenRTC::DateTime dt;
  if (rtc.now(dt)) {
    Serial.printf("Now: %04u-%02u-%02u %02u:%02u:%02u\n", dt.year, dt.month, dt.day, dt.hour, dt.minute, dt.second);
  } else {
    Serial.println("RTC read error or invalid time");
  }
  delay(1000);
}
